<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sr_lt', version '4.4'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Možete pregledati ovaj test, ali ako je ovo stvarni pokušaj rešavanja, bićete blokirani jer:';
$string['action'] = 'Akcija';
$string['activityoverview'] = 'Približava se rok za rešavanje testova';
$string['adaptive'] = 'Adaptivni režim';
$string['adaptive_help'] = 'Ako je omogućen adaptivni režim, onda je polazniku dozvoljeno da unutar istog pokušaja rešavanja testa više puta odgovori na pitanje. Na primer, ako je odgovor označen kao netačan, polazniku će biti dozvoljeno da odmah ponovo odgovori. Međutim, zavisno od podešavanja "Primeni kaznene poene", za svaki pogrešan odgovor obično će biti oduzet odgovarajući broj kaznenih poena.';
$string['add'] = 'Dodaj';
$string['addaquestion'] = 'novo pitanje';
$string['addarandomquestion'] = 'novo nasumično odabrano pitanje';
$string['addarandomquestion_help'] = 'Kada se dodaju nasumična pitanja, to rezultira time da se u test dodaju nasumično odabrana pitanja iz kategorije. Ovo znači da će svaki polaznik verovatno dobiti različit skup pitanja, a kada test dozvoljava ponovne pokušaje onda je verovatno da će svaki pokušaj sadržati novi skup pitanja.';
$string['addarandomquestion_success'] = 'Nasumično izabrana pitanja su dodata';
$string['addarandomselectedquestion'] = 'Dodaj nasumično izabrano pitanje...';
$string['addasection'] = 'novi naslov sekcije';
$string['adddescriptionlabel'] = 'Dodaj opis';
$string['addingquestion'] = 'Dodavanje pitanja';
$string['addingquestions'] = '<p>Ovaj deo stranice je mesto na kojem uređujete svoju bazu pitanja. Pitanja se čuvaju u kategorijama koje vam pomažu da pitanja ih organizujete. Pitanja se mogu koristiti u bilo kom testu vašeg kursa ili. čak, u drugim kursevima, ako odlučite da ih \'objavite\'. </p>
<p>Nakon što izaberete ili kreirate kategoriju pitanja, možete da pravite nova ili uređujete postojeća pitanja. Možete da izaberete bilo koje od ovih pitanja i dodate ih u vaš test koji se nalazi na suprotnoj strani ove stranice. </p>';
$string['addmoreoverallfeedbacks'] = 'Dodaj još {no} polja za povratne informacije';
$string['addnewgroupoverride'] = 'Dodaj izmenu za grupu';
$string['addnewpagesafterselected'] = 'Dodaj nove stranice posle izabranih pitanja';
$string['addnewquestionsqbank'] = 'Dodaj pitanja u kategoriju {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Dodaj izmenu podešavanja za korisnika';
$string['addpagebreak'] = 'Dodaj prelom stranice';
$string['addpagehere'] = 'Dodaj stranicu ovde';
$string['addquestion'] = 'Dodaj pitanje';
$string['addquestionfrombankatend'] = 'Dodaj iz banke pitanja na kraj';
$string['addquestionfrombanktopage'] = 'Dodaj iz banke pitanja na stranicu {$a}';
$string['addquestions'] = 'Dodaj pitanja';
$string['addquestionstoquiz'] = 'Dodaj pitanja u tekući test';
$string['addrandom'] = 'Dodaj {$a} nasumičnih pitanja';
$string['addrandom1'] = '<< Dodaj';
$string['addrandom2'] = 'slučajna pitanja';
$string['addrandomfromcategory'] = 'Dodaj nasumično odabrana pitanja iz kategorije';
$string['addrandomquestion'] = 'Dodaj nasumično odabrana pitanja';
$string['addrandomquestionatend'] = 'Dodaj nasumično odabrano pitanja na kraj';
$string['addrandomquestiontopage'] = 'Dodaj nasumično izabrano pitanje na stranicu {$a}';
$string['addrandomquestiontoquiz'] = 'Dodaj nasumično odabrana pitanja u test {$a}';
$string['addselectedquestionstoquiz'] = 'Dodaj izabrana pitanja u test';
$string['addselectedtoquiz'] = 'Dodaj izabrano u test';
$string['addtoquiz'] = 'Dodaj u test';
$string['affectedstudents'] = 'Uticalo je na {$a}';
$string['aftereachquestion'] = 'Nakon dodavanja svakog pitanja';
$string['afternquestions'] = 'Nakon dodavanja {$a} pitanja';
$string['age'] = 'starost';
$string['allattempts'] = 'Svi pokušaji';
$string['allinone'] = 'Neograničeno';
$string['allowreview'] = 'Dozvoli pregled';
$string['alreadysubmitted'] = 'Verovatno ste već predali test.';
$string['alternativeunits'] = 'Alternativne merne jedinice';
$string['alwaysavailable'] = 'Uvek dostupno';
$string['alwayslatest'] = 'Uvek najnovije';
$string['analysisoptions'] = 'Opcije analize';
$string['analysistitle'] = 'Tabela analize pitanja';
$string['answer'] = 'Odgovor';
$string['answered'] = 'Odgovoreno';
$string['answerhowmany'] = 'Jedan ili više tačnih odgovora?';
$string['answers'] = 'Odgovori';
$string['answersingleno'] = 'Dozvoljeno je više tačnih odgovora';
$string['answersingleyes'] = 'Samo jedan odgovor je tačan';
$string['answertoolong'] = 'Odgovor je predugačak nakon linije {$a} (maks. 255 znakova)';
$string['anytags'] = 'Bilo koje oznake';
$string['aon'] = 'AON format';
$string['areyousureremoveselected'] = 'Da li ste sigurni da želite da obrišete sva izabrana pitanja?';
$string['asshownoneditscreen'] = 'Kao što je prikazano na stranici za uređivanje';
$string['attempt'] = 'Pokušaj broj {$a}';
$string['attemptalreadyclosed'] = 'Ovaj pokušaj je već završen.';
$string['attemptclosed'] = 'Pokušaj još uvek nije zatvoren';
$string['attemptduration'] = 'Trajanje';
$string['attemptedon'] = 'Datum predaje testa';
$string['attempterror'] = 'Trenutno vam nije dozvoljeno da pokušate ovaj test zbog  {$a}';
$string['attempterrorcontentchange'] = 'Ovaj pregled testa više ne postoji (kada se test uređuje, svi pregledi koji su u toku automatski se brišu).';
$string['attempterrorcontentchangeforuser'] = 'Ovaj pokušaj rešavanja testa više ne postoji.';
$string['attempterrorinvalid'] = 'Neispravna ID oznaka pokušaja rešavanja testa';
$string['attemptfirst'] = 'Prvi pokušaj';
$string['attemptgradeddelay'] = 'Odlaganje obaveštenja o ocenjenom pokušaju';
$string['attemptgradeddelay_desc'] = 'Odlaganje se primenjuje pre slanja obaveštenja o ocenjenom pokušaju rešavanja testa kako bi se ostavilo dovoljno vremena predavaču da izmeni ocenu.';
$string['attemptincomplete'] = 'Ovaj pokušaj (korisnika: {$a}) još nije završen.';
$string['attemptlast'] = 'Poslednji pokušaj';
$string['attemptnumber'] = 'Pokušaj';
$string['attemptquiz'] = 'Pokušaj rešavanja testa';
$string['attemptquiznow'] = 'Započni test';
$string['attemptreviewtitle'] = '{$a}: Pregled pokušaja';
$string['attemptreviewtitlepaged'] = '{$a->name}: Pregled pokušaja (stranica {$a->currentpage} od {$a->totalpages})';
$string['attempts'] = 'Pokušaji';
$string['attempts_help'] = 'Ukupan broj dozvoljenih pokušaja (ne i broj dodatnih pokušaja).';
$string['attemptsallowed'] = 'Dozvoljen broj pokušaja';
$string['attemptsdeleted'] = 'Broj izbrisanih pokušaja';
$string['attemptselection'] = 'Izaberite koje pokušaje treba analizirati po korisniku:';
$string['attemptsexist'] = 'Test je već u upotrebi, ne možete više dodavati ili brisati pitanja.';
$string['attemptsnum'] = 'Ukupan broj pokušaja: {$a}';
$string['attemptsnumthisgroup'] = 'Ukupan broj pokušaja: {$a->total} ({$a->group} iz ove grupe)';
$string['attemptsnumyourgroups'] = 'Ukupan broj pokušaja: {$a->total} ({$a->group} iz vaše grupe)';
$string['attemptsonly'] = 'Prikaži samo polaznike sa pokušajima';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Pokušaj je još u toku';
$string['attemptsummarytitle'] = '{$a}: Rezime pokušaja';
$string['attemptsunlimited'] = 'Neograničen broj pokušaja';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (stranica {$a->currentpage} od {$a->totalpages})';
$string['autosaveperiod'] = 'Vremensko kašnjenje prilikom automatskog čuvanja odgovora';
$string['autosaveperiod_desc'] = 'U toku rešavanja testa odgovori polaznika mogu automatski da se snimaju. To se čini kad god polaznici unesu neku promenu nakon koje prođe dati broj minuta. Ovo podrazumeva kompromis: kraća zadrška povećava opterećenje servera, ali s druge smanjuje mogućnost da polaznici izgube svoje odgovore. Ako želite značajno da skratite ovo vreme zadrške trebalo bi to postepeno da činite i da pratite kako se menja opterećenje servera. Ako server postane preopterećen produžite datu minutažu. Ako unesete vrednost 0 isključićete automatsko čuvanje odgovora.';
$string['back'] = 'Povratak na pregled pitanja';
$string['backtocourse'] = 'Povratak na kurs';
$string['backtoquestionlist'] = 'Povratak na spisak pitanja';
$string['backtoquiz'] = 'Povratak na uređivanje testa';
$string['bestgrade'] = 'Najviša ocena';
$string['bothattempts'] = 'Prikaži polaznike sa i bez pokušaja';
$string['browsersecurity'] = 'Bezbednost prozora Web čitača';
$string['browsersecurity_help'] = 'Ako je izabrano "Iskačući prozor preko celog ekrana sa delimično uključenim JavaScript opcijama za bezbednost",

* test će se pokrenuti samo ako polaznik ima veb čitač sa uključenom podrškom za JavaScript
* test će se pojaviti u iskačućem prozoru preko celog ekrana, koji pokriva sve ostale prozore i koji nema dugmad za navigaviju
* polaznicima će, koliko je god to moguće, biti onemogućeno da koriste komande poput "kopiraj" i "nalepi"';
$string['cachedef_overrides'] = 'Informacije o izmenama podešavanja za korisnike i grupe';
$string['calculated'] = 'Računsko';
$string['calculatedquestion'] = 'Računsko pitanje nije podržano u liniji {$a}. Pitanje će biti ignorisano.';
$string['cannotcreatepath'] = 'Ne može se kreirati putanja ({$a})';
$string['cannoteditafterattempts'] = 'Ne možete da dodate ili uklonite pitanja zbog toga što već ima pokušaja rešavanja testa. ({$a})';
$string['cannotfindprevattempt'] = 'Nije moguće pronaći prethodni pokušaj';
$string['cannotfindquestionregard'] = 'Nije bilo moguće dobiti pitanja za ponovno ocenjivanje';
$string['cannotinsert'] = 'Ne može se umetnuti pitanje';
$string['cannotinsertrandomquestion'] = 'Nije bilo moguće ubaciti novo nasumično odabrano pitanje';
$string['cannotloadquestion'] = 'Nije bilo moguće učitati opcije pitanja';
$string['cannotloadtypeinfo'] = 'Nije moguće učitati informacije vezane za tip pitanja';
$string['cannotopen'] = 'Ne može se otvoriti izvozna datoteka ({$a})';
$string['cannotremoveallsectionslots'] = 'Izabrali ste sva pitanja ispod naslova sekcije \'{$a}\', Nije dozvoljeno da uklonite sva pitanja ispod naslova sekcije.';
$string['cannotremoveslots'] = 'Nije moguće ukloniti pitanja.';
$string['cannotrestore'] = 'Nije bilo moguće vratiti podatke za sesije pitanja';
$string['cannotreviewopen'] = 'Ne možete da pregledate ovaj pokušaj, još uvek je otvoren';
$string['cannotsavelayout'] = 'Nije bilo moguće sačuvati';
$string['cannotsavenumberofquestion'] = 'Nije bilo moguće sačuvati broj pitanja po jedno stranici';
$string['cannotsavequestion'] = 'Ne može se sačuvati spisak pitanja';
$string['cannotsetgrade'] = 'Nije bilo moguće postaviti novu maksimalnu ocenu za test';
$string['cannotsetsumgrades'] = 'Pokušaj da se podesi suma ocena nije uspeo';
$string['cannotstartgradesmismatch'] = 'Nije moguće započeti pokušaj rešavanja ovog testa. Ocena testa je podešena na {$a->grade}, ali nijedno od pitanja u testu nema podešenu ocenu. Ovo može biti popravljeno na stranici \'Uredi test\'.';
$string['cannotstartmissingquestion'] = 'Ne možete da započnete rešavanje ovog testa. U test je uključueno pitanje koje ne postoji.';
$string['cannotstartnoquestions'] = 'Nije moguće započeti pokušaj rešavanja ovog testa. Test još uvek nije podešen. Nijedno pitanje nije dodato.';
$string['cannotwrite'] = 'Ne može se upisivati u izvoznu datoteku ({$a})';
$string['canredoquestions'] = 'Dozvoli ponovno odgovoranje unutar pokušaja';
$string['canredoquestions_desc'] = 'Ako je ova opcija omogućena, polaznici će, nakon što daju odgovor na pitanje, videti dugme \'Pokušajte sa drugim pitanjem poput ovog\'. To im omogućava da pokušaju da odgovore na slično (nasumično izabrano) pitanja, ili na isto pitanje ponovo, bez potrebe da predaju čitav test i započnu novi pokušaj njegovog rešavanja. Ova opcija je korisna kada se radi o testovima za vežbanje.

Ovo podešavanje utiče samo na pitanja i ponašanja pitanja (na primer \'neposredne povratne informacije\', ili \'interaktivno sa višestrukim pokušajima\') kod kojih je moguće da se završi pitanje pre nego što se preda pokušaj rešavanja testa.';
$string['canredoquestions_help'] = 'Ako je ova opcija omogućena, polaznici će, nakon što daju odgovor na pitanje, videti dugme \'Pokušajte sa drugim pitanjem poput ovog\'. To im omogućava da pokušaju da odgovore na slično (nasumično izabrano) pitanja, ili na isto pitanje ponovo, bez potrebe da predaju čitav test i započnu novi pokušaj njegovog rešavanja. Ova opcija je korisna kada se radi o testovima za vežbanje.

Ovo podešavanje utiče samo na pitanja i ponašanja pitanja (na primer \'neposredne povratne informacije\', ili \'interaktivno sa višestrukim pokušajima\') kod kojih je moguće da se završi pitanje pre nego što se preda pokušaj rešavanja testa.';
$string['canredoquestionsyes'] = 'Da, pružite mogućnost da pokušaju da odgovore na drugo pitanje';
$string['caseno'] = 'Ne, veličina slova nije bitna';
$string['casesensitive'] = 'Razlikovanje malih i VELIKIH slova';
$string['caseyes'] = 'Da, veličina slova mora da se poklapa';
$string['categoryadded'] = 'Kategorija \'{$a}\' je dodata';
$string['categorydeleted'] = 'Kategorija \'{$a}\' je obrisana';
$string['categorynoedit'] = 'Nemate ovlašćenja za menjanje kategorije \'{$a}\'.';
$string['categoryupdated'] = 'Kategorija je uspešno izmenjena';
$string['close'] = 'Zatvori prozor';
$string['closebeforeopen'] = 'Datum zatvaranja testa mora biti posle datuma otvaranja testa.';
$string['closed'] = 'Zatvoreno';
$string['closepreview'] = 'Zatvori pregled';
$string['closereview'] = 'Zatvori pregled';
$string['comment'] = 'Komentar';
$string['commentorgrade'] = 'Komentarišite ili izmenite ocenu';
$string['comments'] = 'Komentari';
$string['completedon'] = 'Završeno';
$string['completionattemptsexhausted'] = 'Prelazna ocena ili svi dostupni pokušaji završeni';
$string['completionattemptsexhausted_help'] = 'Označi da je test završen kada polaznik potroši maksimalan broj pokušaja.';
$string['completiondetail:minattempts'] = 'Rešite test: {$a}';
$string['completiondetail:passorexhaust'] = 'Dobijte prelaznu ocenu ili dovršite sve dostupne pokušaje';
$string['completionminattempts'] = 'Minimalan broj pokušaja';
$string['completionminattemptsdesc'] = 'Minimalan broj potrebnih pokušaja: {$a}';
$string['completionminattemptserror'] = 'Minimalni broj pokušaja mora biti manji ili jednak dozvoljenom broju pokušaja.';
$string['completionminattemptsgroup'] = 'Zahtevaj pokušaje';
$string['completionpassorattemptsexhausteddesc'] = 'Polaznik mora da postigne prelaznu ocenu, ili da iscrpi sve raspoložive pokušaje da bi završio ovu aktivnost';
$string['configadaptive'] = 'Ukoliko izaberete \'Da\' za ovu opciju onda će polazniku biti dozvoljeno da više puta odgovori na pitanje, čak u okviru istog pokušaja rešavanja testa.';
$string['configattemptsallowed'] = 'Ograničenje u broju pokušaja koji su polaznicima dozvoljeni na testu';
$string['configdecimaldigits'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocene.';
$string['configdecimalplaces'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocene za test.';
$string['configdecimalplacesquestion'] = 'Broj cifara nakon decimalne tačke koje treba prikazati kada se pokazuju ocene za pojedinačna pitanja.';
$string['configdelay1'] = 'Ukoliko podesite vremenski razmak, onda će polaznik nakon prvog pokušaja morati toliko vremena da sačeka pre nego što bude mogao ponovo da pokuša da uradi test.';
$string['configdelay1st2nd'] = 'Ukoliko ovde podesite vremenski razmak, polaznici ne mogu da drugi put urade test pre nego što ne protekne toliko vremene od njihovog prvog pokušaja.';
$string['configdelay2'] = 'Ukoliko ovde podesite vremenski razmak, onda polaznik mora da sačeka toliko vremene da prođe pre nego što započne svoj treći (i svaki naredni) pokušaj rešavanja testa.';
$string['configdelaylater'] = 'Ukoliko ovde podesite vremenski razmak, onda polaznik ne može da započne treći, četvrti,... pokušaj pre nego toliko vremena ne prođe od kraja prethodnog pokušaja rešavanja testa.';
$string['configeachattemptbuildsonthelast'] = 'Ukoliko su dozvoljeni višestruki pokušaji onda svaki novi pokušaj sadrži rezultate prethodnog pokušaja.';
$string['configgrademethod'] = 'Kada su višestruki pokušaji dozvoljeni koji metod treba koristiti za izračunavanje polaznikove završne ocene za test.';
$string['configintro'] = 'Vrednosti koje ste ovde podesili definiše podrazumevane vrednosti koje se koriste u obrascu za podešavanje kada kreirate novi test. Možete, takođe, da konfigurišete koja podešavanja testa se smatraju naprednim.';
$string['configmaximumgrade'] = 'Podrazumevana ocena na osnovu koje će se gradirati ocene na testu';
$string['confignavmethod'] = 'Kod slobodne navigacije na pitanja se može odgovarati bilo kojim redosledom, Kod sekvencijalne navigacije na pitanja se mora odgovarati strogo utvrđenim redosledom';
$string['confignewpageevery'] = 'Kod dodavanja pitanja u test, prelom stranice će automatski biti ubačen prema podešavanju koje odve odaberete,';
$string['configoutcomesadvanced'] = 'Ako je ova opcija uključena onda će \'Ishodi\' u obrascu za uređivanje testa biti smešteni u delu za napredna podešavanja.';
$string['configpenaltyscheme'] = 'Kazneni bodovi koji se oduzimaju za svaki pogrešan odgovor u adaptivnom režimu.';
$string['configpopup'] = 'Prinudno otvaranje testa u iskačućem prozoru, uz korišćenje JavaScript opcija, koje će pokušati da ograniče korišćenje komandi "kopiraj", "nalepi" itd., u toku rešavanja testa.';
$string['configrequirepassword'] = 'Polaznici moraju da unesu ovu lozinku pre nego što pokušaju da reše test.';
$string['configrequiresubnet'] = 'Polaznici mogu da pokušaju da reše test samo sa ovih računara.';
$string['configreviewoptions'] = 'Ove opcije kontrolišu koje informacije će korisnici moći da vide kada budu pregledali pokušaj ili kada budu gledali izveštaje o testu.';
$string['configshowblocks'] = 'Prikaži blokove tokom rešavanja testa.';
$string['configshowuserpicture'] = 'Prikaži sliku korisnika na ekranu tokom pokušaja rešavanja testa.';
$string['configshufflewithin'] = 'Ako omogućite ovu opciju, onda će delovi koji sačinjavaju pojedinačno pitanje biti nasumično izmešani svaki put kada polaznik započne da rešava ovaj test. Ponuđena opcija je takođe uključena u podešavanjima pitanja.';
$string['configtimelimit'] = 'Podrazumevano vremensko ograničenje za testove u minutima. 0 znači da nema vremenskog ograničenja.';
$string['configtimelimitsec'] = 'Podraumevano vremensko ogrničenje za testove u sekundama. 0 znači da nema vremenskog ograničenja.';
$string['configurerandomquestion'] = 'Konfiguriši pitanje';
$string['confirmclose'] = 'Kada predate svoje odgovore nećete više biti u mogućnosti da ih menjate.';
$string['confirmremovequestion'] = 'Da li ste sigurni da želite da uklonite ovo {$a} pitanje?';
$string['confirmremovesectionheading'] = 'Da li ste sigurni da želite da uklonite naslov sekcije \'{$a}\'?';
$string['confirmserverdelete'] = 'Da li ste sigurni da želite da uklonite server <b>{$a}</b> sa spiska?';
$string['connectionerror'] = 'Mrežna veza je izgubljena. (Automatsko čuvanje nije uspelo).

Zapišite sve odgovora unetih na ovoj stranici u poslednjih nekoliko minuta, a zatim pokušajte ponovo da se povežete.

Kada se veza ponovo uspostavi vaši odgovori bi trebalo da budu sačuvani a ova poruka će nestati.';
$string['connectionok'] = 'Mrežna veza je ponovo uspostavljena. Možete bezbedno da nastavite.';
$string['containercategorycreated'] = 'Ova kategorija je kreirana sa ciljem da se u nju smeste sve originalne kategorije koje se pomere na nivo sajta iz dole navedenih razloga.';
$string['continueattemptquiz'] = 'Nastavite sa svojim pokušajem';
$string['continuepreview'] = 'Nastavi poslednji pregled';
$string['copyingfrom'] = 'Kreiranje kopije pitanja \'{$a}\'';
$string['copyingquestion'] = 'Kopiranje pitanja';
$string['correct'] = 'Tačno';
$string['correctanswer'] = 'Tačan odgovor';
$string['correctanswerformula'] = 'Formula tačnog odgovora';
$string['correctansweris'] = 'Tačan odgovor: {$a}';
$string['correctanswerlength'] = 'Značajne cifre';
$string['correctanswers'] = 'Tačni odgovori';
$string['correctanswershows'] = 'Tačan odgovor sadrži';
$string['corrresp'] = 'Tačan odgovor';
$string['countdown'] = 'Brojač';
$string['countdownfinished'] = 'Test se uskoro zatvara, vreme je da predate svoje odgovore.';
$string['countdowntenminutes'] = 'Test se zatvara za deset minuta.';
$string['coursetestmanager'] = 'Test Menadžer format';
$string['createcategoryandaddrandomquestion'] = 'Kreiraj kategoriju i dodaj nasumičnо odabranо pitanjе';
$string['createfirst'] = 'Morate prvo kreirati neka pitanja sa kratkim odgovorima.';
$string['createmultiple'] = 'Dodajte testu nekoliko nasumično odabranih pitanja';
$string['createnewquestion'] = 'Kreiraj novo pitanje';
$string['createquestionandadd'] = 'Kreiraj novo pitanje i dodaj ga testu.';
$string['custom'] = 'Proizvoljan format';
$string['dataitemneed'] = 'Morate dodati bar jedan skup stavki podataka da biste dobili validno pitanje';
$string['datasetdefinitions'] = 'Ponovo upotrebljene definicije seta podataka za kategoriju {$a}';
$string['datasetnumber'] = 'Broj';
$string['daysavailable'] = 'Dostupni dani';
$string['decimaldigits'] = 'Broj decimala u ocenama';
$string['decimalplaces'] = 'Decimalna mesta u ocenama';
$string['decimalplaces_help'] = 'Ovo podešavanje određuje broj cifara koji treba prikazati iza decimalne tačke kada se prikazuju ocena. Ovo utiče samo na prikaz ocena, ali ne i na ocene sačuvane u bazi podataka, niti na interna izračunavanja koja se izvode sa punom preciznošću.';
$string['decimalplacesquestion'] = 'Decimalna mesta u ocenama za pitanja';
$string['decimalplacesquestion_help'] = 'Broj cifara koji se prikazaju iza decimalne tačke kada se prikazuju ocene za pojedinačna pitanja.';
$string['decimalpoints'] = 'Decimalna mesta';
$string['default'] = 'Podrazumevano';
$string['defaultgrade'] = 'Podrazumevana ocena pitanja';
$string['defaultinfo'] = 'Podrazumevana kategorija za pitanja';
$string['delay1'] = 'Vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd'] = 'Prinudni vremenski razmak između prvog i drugog pokušaja';
$string['delay1st2nd_help'] = '<p>Ukoliko podesite vremenski razmak, polaznik mora nakon svog prvog pokušaja da sačeka da toliko vremena prođe pre nego što mu bude dozvoljeno da ponovo pokuša da reši test.</p>';
$string['delay2'] = 'Vremenski razmak između svih ostalih pokušaja';
$string['delaylater'] = 'Prinudni vremenski razmak između naknadnih pokušaja';
$string['delaylater_help'] = '<p>Ukoliko ovde podesite vremenski razmak, polaznik mora da sačeka da toliko vremena prođe pre nego što započne svoj treći i svaki naredni pokušaj rešavanja testa.</p>';
$string['deleteattemptcheck'] = 'Da li ste apsolutno sigurni da želite da obrišete ove pokušaje?';
$string['deleteselected'] = 'Obriši označeno';
$string['deletingquestionattempts'] = 'Obriši pokušaje pitanja';
$string['description'] = 'Opis';
$string['disabled'] = 'Onemogućeno';
$string['displayoptions'] = 'Opcije prikaza';
$string['donotuseautosave'] = 'Ne koristi opciju za automatsko čuvanje';
$string['download'] = 'Kliknite za preuzimanje izvezene datoteke sa kategorijama';
$string['downloadextra'] = '(datoteka se čuva i među datotekama kursa u /backupdata/quiz direktorijumu)';
$string['dragtoafter'] = 'Nakon {$a}';
$string['dragtostart'] = 'Na početak';
$string['duplicateresponse'] = 'Ovaj odgovor je ignorisan zato što je jednak odgovoru koji ste dali ranije.';
$string['eachattemptbuildsonthelast'] = 'Svaki pokušaj se nastavlja na prethodni';
$string['eachattemptbuildsonthelast_help'] = '<p>Ako je dozvoljeno više pokušaja rešavanja testa i ovo podešavanje je postavljeno na <b>Da</b>, onda će svaki novi pokušaj sadržati rezultate prethodnog. To dozvoljava da se rešavanje testa završi u više pokušaja.</p>

<p>Da bi se prikazao novi primerak testa pri svakom pokušaju, izaberite vrednost <b>Ne</b> za ovo podešavanje.</p>';
$string['edit_slotdisplaynumber_hint'] = 'Uredite broj pitanja (maksimalno 16 znakova)';
$string['edit_slotdisplaynumber_label'] = 'Nova vrednost za {$a}';
$string['editcategories'] = 'Uredi kategorije';
$string['editcategory'] = 'Uredi kategoriju';
$string['editcatquestions'] = 'Uređivanje pitanja u kategoriji';
$string['editingquestion'] = 'Uređivanje pitanja';
$string['editingquiz'] = 'Uređivanje testa';
$string['editingquiz_help'] = 'Prilikom kreiranja testa, osnovni pojmovi su:

* Test, koji sadrži pitanja na jednoj ili više stranica
* Banka pitanja, koja sadrži kopije svih pitanja organizovanih u kategorije
* Nasumično odabrano pitanje - polaznik dobija različita pitanja svaki put kada pokuša da rešava test, odnosno različiti polaznici mogu da dobiju različita pitanja tj. test.';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Uređivanje testa: {$a}';
$string['editmaxmark'] = 'Uredi maksimalnu ocenu';
$string['editoverride'] = 'Uredi izmenu';
$string['editqcats'] = 'Uređivanje kategorija pitanja';
$string['editquestion'] = 'Uredi pitanje';
$string['editquestions'] = 'Uredi pitanja';
$string['editquiz'] = 'Uredi test';
$string['editquizquestions'] = 'Uredi pitanja testa';
$string['emailconfirmautosubmitsmall'] = 'Hvala vam što ste poslali svoje odgovore na test \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Poštovani/a {$a->username},

Hvala što ste poslali svoje odgovore na test \'{$a->quizname}\' na kursu \'{$a->coursename}\' u {$a->submissiontime}.

Ova poruka je potvrda da su vaši odgovori sačuvani.

Ovom testu možete da pristupite na {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Poštovani/a {$a->username},

Vreme za test \'{$a->quizname}\' na kursu \'{$a->coursename}\' je isteklo. Vaši odgovori predati su automatski u {$a->submissiontime}.

Ova poruka potvrđuje da su vaši odgovori sačuvani.

Ovom testu možete pristupiti na {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Hvala što se predali svoje odogovore za test \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Potvrda o slanju testa: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Poštovani/a {$a->username},

Vaši odgovori na pitanja u testu \'{$a->quizname}\' na kursu \'{$a->coursename}\' predati u {$a->attempttimefinish} sada su ocenjeni.

Moći ćete da vidite svoj rezultat i povratne informacije ako posetite \'{$a->quizurl}\' i pregledate svoj pokušaj.';
$string['emailmanualgradedsubject'] = 'Vaš pokušaj rešavanja testa {$a->quizname} je ocenjen';
$string['emailnotifybody'] = 'Poštovani/a {$a->username},

{$a->studentname} je završio/la test \'{$a->quizname}\' ({$a->quizurl}) na kursu \'{$a->coursename}\'.

Ovaj pokušaj možete pregledati na  {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} je završio/la test {$a->quizname}. Pogledajte na {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} je završio/la test {$a->quizname}';
$string['emailoverduebody'] = 'Poštovani/a {$a->username},

Započeli ste rešavanje testa \'{$a->quizname}\'
na kursu \'{$a->coursename}\', ali niste predali svoje odgovore. Potrebno je da ih predate do {$a->attemptduedate}.

Ako, još uvek. želite da pošaljete svoje odgovore, molimo vas da odete na {$a->attemptsummaryurl} i kliknete na dugme \'Predaj\'. Ovo morate da uradite pre {$a->attemptgraceend}, u suprotnom vaš pokušaj rešavanja testa se neće računati.';
$string['emailoverduesmall'] = 'Niste predali svoj pokušaj rešavanja testa {$a->quizname}. Molimo vas da odete na {$a->attemptsummaryurl} pre {$a->attemptgraceend}, ako još uvek želite da predate svoje odgovore.';
$string['emailoverduesubject'] = 'Pokušaj rešavanja testa {$a->quizname} kasni';
$string['empty'] = 'Prazno';
$string['enabled'] = 'Omogućeno';
$string['endtest'] = 'Završi pokušaj...';
$string['erroraccessingreport'] = 'Ne možete da pristupite ovom izveštaju';
$string['errorinquestion'] = 'Greška u pitanju';
$string['errormissingquestion'] = 'Greška: Sistem ne može da pronađe pitanje čiji je identifikator {$a}';
$string['errornotnumbers'] = 'Greška - odgovori moraju biti numerički';
$string['errorunexpectedevent'] = 'Neočekivani kôd događaja {$a->event} pronađen za pitanje {$a->questionid} u pokušaju {$a->attemptid}.';
$string['essay'] = 'Esej';
$string['essayquestions'] = 'Pitanja';
$string['eventattemptautosaved'] = 'Pokušaj rešavanja testa je automatski sačuvan';
$string['eventattemptdeleted'] = 'Pokušaj rešavanja testa obrisan';
$string['eventattemptmanualgradingcomplete'] = 'Ručno ocenjivanje pokušaja rešavanja testa je završeno';
$string['eventattemptpreviewstarted'] = 'Pregled pokušaja rešavanja testa pokrenut';
$string['eventattemptquestionrestarted'] = 'Pokušaj rešavanja testa ponovo pokrenut';
$string['eventattemptreviewed'] = 'Pokušaj rešavanja testa prikazan';
$string['eventattemptsummaryviewed'] = 'Rezime pokušaja prikazan';
$string['eventattemptupdated'] = 'Pokušaj rešavanja testa ažuriran';
$string['eventattemptviewed'] = 'Pokušaj rešavanja testa prikazan';
$string['eventeditpageviewed'] = 'Stranica za uređivanje testa prikazana';
$string['eventoverridecreated'] = 'Izmena podešavanja testa kreirana';
$string['eventoverridedeleted'] = 'Izmena podešavanja testa obrisana';
$string['eventoverrideupdated'] = 'Izmena podešavanja testa ažurirana';
$string['eventpagebreakcreated'] = 'Prelom stranice kreiran';
$string['eventpagebreakdeleted'] = 'Prelom stranice obrisan';
$string['eventquestionmanuallygraded'] = 'Pitanje ručno ocenjeno';
$string['eventquizattemptabandoned'] = 'Pokušaj rešavanja testa napušten';
$string['eventquizattemptregraded'] = 'Pokušaj rešavanja testa ponovo ocenjen';
$string['eventquizattemptreopened'] = 'Pokušaj rešavanja testa je ponovo otvoren';
$string['eventquizattemptstarted'] = 'Quiz attempt started';
$string['eventquizattemptsubmitted'] = 'Pokušaj rešavanja testa predat';
$string['eventquizattempttimelimitexceeded'] = 'Vreme za rešavanje testa prekoračeno';
$string['eventquizgradeitemcreated'] = 'Stavka za ocenjivanje u testu je kreirana';
$string['eventquizgradeitemdeleted'] = 'Stavka za ocenjivanje u testu je obrisana';
$string['eventquizgradeitemorderchanged'] = 'Redosled stavki za ocenjivanje u testu je promenjen';
$string['eventquizgradeitemupdated'] = 'Stavka za ocenjivanje u testu je ažurirana';
$string['eventquizgradeupdated'] = 'Ocena testa ažurirana';
$string['eventquizrepaginated'] = 'Stranice testa reorganizovane';
$string['eventreportviewed'] = 'Izveštaj o testu prikazan';
$string['eventsectionbreakcreated'] = 'Prelom sekcije kreiran';
$string['eventsectionbreakdeleted'] = 'Prelom sekcije obrisan';
$string['eventsectionshuffleupdated'] = 'Nasumični redosled pitanja u sekciji ažuriran';
$string['eventsectiontitleupdated'] = 'Naslov sekcije ažuriran';
$string['eventslotcreated'] = 'Slot kreiran';
$string['eventslotdeleted'] = 'Slot obrisan';
$string['eventslotdisplayedquestionnumberupdated'] = 'Slot koji prikazuje broj pitanja ažuriran';
$string['eventslotgradeitemupdated'] = 'Slot stavki za ocenjivanje ažuriran';
$string['eventslotmarkupdated'] = 'Oznaka slota ažurirana';
$string['eventslotmoved'] = 'Slot premešten';
$string['eventslotrequirepreviousupdated'] = 'Slot zahteva prethodno ažuriranje';
$string['everynquestions'] = 'Svaka/ih {$a} pitanja';
$string['everyquestion'] = 'Svako pitanje';
$string['everythingon'] = 'Sve na';
$string['existingcategory'] = 'Postojeća kategorija';
$string['exportcategory'] = 'izvezi kategoriju';
$string['exporterror'] = 'Došlo je do greške u toku obrade izvoza';
$string['exportingquestions'] = 'Pitanja se izvoze u datoteku';
$string['exportname'] = 'Naziv datoteke';
$string['exportquestions'] = 'Izvezi pitanja u datoteku';
$string['extraattemptrestrictions'] = 'Dodatna ograničenja prilikom pokušaja';
$string['false'] = 'Pogrešno';
$string['feedback'] = 'Povratne informacije';
$string['feedbackerrorboundaryformat'] = 'Granične vrednosti ocene za povratne informacije moraju biti procenti ili brojevi. Vrednost koju ste uneli za granicu {$a} nije prepoznata.';
$string['feedbackerrorboundaryoutofrange'] = 'Granične vrednosti ocene za povratne informacije moraju biti između 0% i 100%. Vrednost koju ste uneli za granicu {$a} je van dozvoljenog opsega.';
$string['feedbackerrorjunkinboundary'] = 'Morate popuniti polja za granične vrednosti ocena za povratne informacije. Nemojte preskakati polja, već ih redom popunjavajte.';
$string['feedbackerrorjunkinfeedback'] = 'Morate popuniti polja povratnih informacija. Nemojte preskakati polja, već ih redom popunjavajte.';
$string['feedbackerrororder'] = 'Granične vrednosti ocena za povratne informacije moraju biti poređane počevši od najviše. Vrednost koju ste uneli za granicu {$a} je izvan niza.';
$string['file'] = 'Datoteka';
$string['fileformat'] = 'Format datoteke';
$string['fillcorrect'] = 'Unesite tačan odgovor';
$string['filloutnumericalanswer'] = 'Obezbedite bar jedan mogući odgovor i odstupanje. Prvi odgovor koji se poklapa biće korišćen za utvrđivanje ocene i povratnih informacija. Ako postavite povratne informacije bez odgovora na kraju, one će biti prikazane polaznicima čiji se odgovori ne poklapaju ni sa jednim od ostalih odgovora.';
$string['filloutoneanswer'] = 'Morate ponuditi najmanje jedan mogući odgovor. Odgovori koji se ne popune neće se koristiti. \'*\' se može koristiti kao džoker znak koji zamenjuje bilo koji niz znakova. Prvi odgovor koji se poklopi sa datim koristiće se za određivanje rezultata i povratnih informacija.';
$string['filloutthreequestions'] = 'Morate ispuniti bar tri pitanja sa odgovarajućim rešenjima. Možete dodati još netačnih odgovora davanjem rešenja uz prazna pitanja. Stavke u kojima su i pitanje i odgovor prazni neće se uzimati u obzir.';
$string['fillouttwochoices'] = 'Morate ispuniti bar dva odgovora. Prazni odgovori se neće koristiti.';
$string['finishattemptdots'] = 'Završi pokušaj...';
$string['finishreview'] = 'Završi pregled';
$string['forceregeneration'] = 'Obavezno obnavljanje';
$string['formatnotfound'] = 'Nije pronađen format {$a} za uvoz/izvoz';
$string['formulaerror'] = 'Greška u formuli!';
$string['fractionsaddwrong'] = 'Pozitivne ocene koje ste odabrali u zbiru ne daju 100%<br />Naime njihov zbir je {$a}%<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fractionsnomax'] = 'Jedan od odgovora bi trebao nositi 100% ocene, tako da je <br />moguće dobiti maksimalnu ocenu za ovo pitanje.<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['fromfile'] = 'iz datoteke:';
$string['functiondisabledbysecuremode'] = 'Ova funkcionalnost je trenutno onemogućena';
$string['generalfeedback'] = 'Opšte povratne informacije';
$string['generalfeedback_help'] = 'Opšte povratne informacije predstavljaju tekst koji se prikazuje nakon davanja odgovora na pitanje. Za razliku od povratnih informacija za pojedinačno pitanje koje zavise od datog odgovora, opšte povratne informacije su uvek iste.';
$string['gobacktoquiz'] = 'Vrati se';
$string['graceperiod'] = 'Dodatno vreme za predaju testa';
$string['graceperiod_desc'] = 'Ako je opcija \'Šta raditi kada vreme istekne\' podešeno na \'Postoji dodatni vremenski period...\', onda je ovo podrazumevano dodatno vreme koje se dozvoljava.';
$string['graceperiod_help'] = 'Ako je opcija \'Šta raditi kada vreme istekne\' podešeno na \'Postoji dodatni vremenski period...\', onda je ovo dodatno vreme koje se dozvoljava.';
$string['graceperiodmin'] = 'Dodatno vreme za konačnu predaju';
$string['graceperiodmin_desc'] = 'Postoji potencijalni problem na samom kraju testa. Sa jedne strane, želimo da polaznici imaju mogućnost da rade test sve do poslednje sekunde - uz pomoć tajmera koji automatski predaje test kada vreme istekne. Sa druge strane, server tada može biti preopterećen pa će mu biti potrebno neko vreme da obradi odgovore. Stoga ćemo prihvatati odgovore i nakon što rok za predaju istekne, unutar ovog dodatnog vremena (u sekundama), tako da polaznici neće biti oštećeni zbog toga što je server spor. Međutim, polaznici ovo mogu da zloupotrebe tako što će u toku ovog dodatnog vremena odgovarati na pitanja. Morate da napravite kompromis na osnovu toga koliko imate poverenja u performanse svog servera u toku rešavanja testa.';
$string['graceperiodtoosmall'] = 'Dodatno vreme mora biti veće od {$a}.';
$string['grade'] = 'Ocena';
$string['gradeall'] = 'Oceni sve';
$string['gradeaverage'] = 'Prosečna ocena';
$string['gradeboundary'] = 'Granična vrednost ocene';
$string['gradeessays'] = 'Oceni eseje';
$string['gradehighest'] = 'Najviša ocena';
$string['gradeitemdefaultname'] = 'Nova stavka za ocenjivanje {$a}';
$string['gradeitemdelete'] = 'Obrišite stavku za ocenjivanje {$a}';
$string['gradeitemedit'] = 'Уредите назив ставке за оцењивање  {$a}';
$string['gradeitemmarkscheme'] = 'Dodelite stavke za ocenjivanje';
$string['gradeitemnewname'] = 'Novi naziv stavke za ocenjivanje {$a}';
$string['gradeitemnoneselected'] = '[nijedna]';
$string['gradeitemnoslots'] = 'Ovaj test još uvek nema pitanja. Prvo dodajte pitanja, a zatim se vratite ovde da biste podesili stavke za ocenjivanje.';
$string['gradeitems'] = 'Stavke za ocenjivanje';
$string['gradeitemsautosetup'] = 'Podesite ocenu za svaku sekciju';
$string['gradeitemsetup'] = 'Podešavanje stavki za ocenjivanje';
$string['gradeitemsnoneyet'] = 'Креирајте ставке за оцењивање у оквиру свог квиза. Доделите питања или делове теста овим ставкама за оцењивање како бисте оцене поделили на различите области.';
$string['gradeitemsremoveall'] = 'Resetujte podešavanje';
$string['gradeitemsremoveallconfirm'] = 'Želite li da resetujete podešavanja stavki za ocenjivanje?';
$string['gradeitemsremoveallmessage'] = 'Ovo će obrisati sve stavke za ocenjivanje i opozvati dodelu pitanja i delova testa iz njih.<br><br>Ova akcija neće uticati na sama pitanja i delove testa, niti na postojeće pokušaje u okviru kviza.';
$string['gradeitemsremovealltitle'] = 'Resetujte podešavanje stavki za ocenjivanje';
$string['grademethod'] = 'Način ocenjivanja';
$string['grademethod_help'] = 'Kada je dozvoljen veći broj pokušaja rešavanja testa, postoje različiti načini za izračunavanje polaznikove konačne ocene.

* Najviša ocena od svih pokušaja
* Prosečna (srednja) ocena svih pokušaja
* Prvi pokušaj (svi ostali pokušaji se ignorišu)
* Poslednji pokušaj (svi ostali pokušaji se ignorišu)';
$string['gradesdeleted'] = 'Izbrisano ocena testa:';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Prelazna ocena ne može biti nula jer ovaj test ima postavljen metod završetka koji zahteva prelaznu ocenu. Molimo, unesite vrednost različitu od nule.';
$string['gradetopassoutof'] = 'Prolazna ocena: {$a->grade} od {$a->maxgrade}';
$string['gradingdetails'] = 'Ocena za ovaj odgovor je: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Sa prethodnim kaznenim bodovima ocena je <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Ovim odgovorom ste zaradili {$a} kaznenih bodova.';
$string['gradingdetailszeropenalty'] = 'Niste zaradili kaznene bodove za ovaj odgovor';
$string['gradingmethod'] = 'Način ocenjivanja: {$a}';
$string['groupoverrides'] = 'Izmene podešavanja za grupe';
$string['groupoverridesdeleted'] = 'Izmene podešavanja za grupe obrisane';
$string['groupsnone'] = 'Ne postoje grupe kojima možete pristupiti.';
$string['guestsno'] = 'Nažalost, gosti ne mogu ni da vide ni da rešavaju testove';
$string['hidebreaks'] = 'Sakrij prelome stranica';
$string['hidereordertool'] = 'Sakrij alat za reorganizovanje';
$string['history'] = 'Istorijat odziva sistema:';
$string['howquestionsbehave_desc'] = 'Podrazumevano podešavanje za to kako se pitanja ponašaju u testu';
$string['imagedisplay'] = 'Slika za prikaz';
$string['import_help'] = 'Ova funkcija vam omogućava da pitanja uvezete iz eksternih tekstualnih datoteka.

Ako vaša datoteka sadrži tzv. non-ascii znakove onda ona mora da koristi UTF-8 kodni raspored. Posebno budite oprezni sa datotekama koje su generisale Microsoft Office aplikacije, pošto one obično koriste specijalan kodni raspored koji neće biti ispravno obrađen.

Formati za uvoz i izvoz su prilagodljivi resursi. Drugi, opcioni, formati mogu se pronaći u bazi "Modules and Plugins" na sajtu moodle.org.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'kategorija uvoza';
$string['importerror'] = 'Došlo je do greške u toku obrade uvoza';
$string['importfilearea'] = 'Uvoz iz datoteke koja je već među datotekama kursa';
$string['importfileupload'] = 'Uvoz iz novoučitane datoteke...';
$string['importfromthisfile'] = 'Uvoz iz ove datoteke';
$string['importingquestions'] = 'Uvoz {$a} pitanja iz datoteke';
$string['importmax10error'] = 'Postoji greška u pitanju. Ne može biti više od deset odgovora';
$string['importmaxerror'] = 'Postoji greška u pitanju. Ima previše odgovora.';
$string['importquestions'] = 'Uvezi pitanja iz datoteke';
$string['inactiveoverridehelp'] = '* Ova izmena je neaktivna, jer je pristup korisnika aktivnosti ograničen. To može biti zbog grupe ili uloge koji su korisnima dodeljeni, zbog  drugih ograničenja pristupa ili zbog toga što je aktivnost skrivena.';
$string['incorrect'] = 'Netačno';
$string['indicator:cognitivedepth'] = 'Test - kognitivni aspekt';
$string['indicator:cognitivedepth_help'] = 'Ovaj indikator se zasniva na kognitivnoj dubini koju je polaznik postigao u okviru aktivnosti \'Test\'.';
$string['indicator:cognitivedepthdef'] = 'Test - kognitivni aspekt';
$string['indicator:cognitivedepthdef_help'] = '
Učesnik je postigao ovaj procenat kognitivnog angažmana koji nude aktivnosti Test tokom ovog intervala analize (Nivoi = Bez pregleda, Pregled, Predaja odgovora, Pregled povratnih informacija, Komentar na povratne informacije, Ponovna predaja odgovora nakon pregleda povratnih informacija)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Test - socijalni aspekt';
$string['indicator:socialbreadth_help'] = 'Ovaj indikator se zasniva na obimu socijalnih interakcija koji je polaznik postigao u okviru aktivnosti \'Test\'.';
$string['indicator:socialbreadthdef'] = 'Test - socijalni aspekt';
$string['indicator:socialbreadthdef_help'] = 'Učesnik je postigao ovaj procenat socijalnog angažmana koji nude aktivnosit Test tokom ovog intervala analize (Nivoi = Bez učešća, Učesnik sâm, Učesnik sa drugima)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Odgovori pojedinaca na svako pitanje';
$string['info'] = 'Informacije';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Početni broj polja za sveobuhvatne povratne informacije';
$string['initialnumfeedbacks_desc'] = 'Kada se kreira novi test, obezbedite ovaj broj praznih polja za sveobuhvatne povratne informacije. Jednom, kada je test kreiran, obrazac prikazuje broj polja neophodnih za odgovarajući broj povratnih informacija u testu. Ovo podešavanje mora da bude najmanje 1.';
$string['inprogress'] = 'U toku';
$string['introduction'] = 'Opis';
$string['invalidattemptid'] = 'Takav id pokušaja ne postoji';
$string['invalidcategory'] = 'Identifikator kategorije nije valjan';
$string['invalidoverrideid'] = 'Neispravna ID oznaka izmene';
$string['invalidquestionid'] = 'Neispravan id pitanja';
$string['invalidquizid'] = 'Neispravan identifikator testa';
$string['invalidrandomslot'] = 'Nevalidan identifikator slota nasumično odabranog pitanja';
$string['invalidsource'] = 'Izvor nije prihvaćen kao validan.';
$string['invalidsourcetype'] = 'Nije validan tip izvora';
$string['invalidstateid'] = 'Neispravan id statusa';
$string['lastanswer'] = 'Vaš odgovor je bio';
$string['lastautosave'] = 'Poslednje put sačuvano: {$a}';
$string['layout'] = 'Izgled (raspored pitanja)';
$string['layoutasshown'] = 'Izgled stranice kao što je prikazano.';
$string['layoutasshownwithpages'] = 'Izgled stranice kao što je prikazano. <small>(Nova stranica automatski na svakih  {$a} pitanja.)</small>';
$string['layoutshuffledandpaged'] = 'Pitanja su nasumično izmešana sa {$a} pitanja po stranici.';
$string['layoutshuffledsinglepage'] = 'Pitanja nasumično izmešana, sva prikazana na jednoj stranici.';
$string['link'] = 'Link';
$string['listitems'] = 'Spisak stavki u testu';
$string['literal'] = 'Znak';
$string['loadingquestionsfailed'] = 'Broj neuspelih učitavanja pitanja: {$a}';
$string['makecopy'] = 'Sačuvaj kao novo pitanje';
$string['managetypes'] = 'Upravljanje tipovima pitanja i serverima';
$string['manualgradequestion'] = 'Ručno oceni pitanje {$a->question} u {$a->quiz} od strane korisnika {$a->user}';
$string['manualgrading'] = 'Ocenjivanje';
$string['mark'] = 'Predajte';
$string['markall'] = 'Predajte stranicu';
$string['marks'] = 'Ocene';
$string['marks_help'] = 'Ocena dobijena za svako pitanje, kao i sveukupni rezultat pokušaja. Možete da izaberete Ocene samo ako je izabrana opcija Maksimalne ocene.';
$string['match'] = 'Sparivanje';
$string['matchanswer'] = 'Sparivanje odgovora';
$string['matchanswerno'] = 'Sparivanje odgovora {$a}';
$string['max'] = 'Maksimalno';
$string['maxmark'] = 'Maksimalna ocena';
$string['maxmarks'] = 'Maksimalne ocene';
$string['maxmarks_help'] = 'Maksimalna ocena dostupna za svako pitanje.';
$string['messageprovider:attempt_grading_complete'] = 'Obaveštenje da je vaš pokušaj ocenjen';
$string['messageprovider:attempt_overdue'] = 'Upozorenje kada vaš pokušaj rešavanja testa kasni';
$string['messageprovider:confirmation'] = 'Potvrda o predaji vaših pokušaja rešavanja testa';
$string['messageprovider:submission'] = 'Obaveštenje o predatim testovima vaših polaznika';
$string['min'] = 'Minimalno';
$string['minutes'] = 'Minut(a)';
$string['missingcategory'] = 'Nedostaje kategorija pitanja';
$string['missingcorrectanswer'] = 'Morate zadati tačan odgovor';
$string['missingitemtypename'] = 'Nedostaje naziv';
$string['missingquestion'] = 'Nedostaje naziv pitanja nakon linije {$a}';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Modul \'Test\' omogućava predavačima da dizajniraju testove koji se sastoje od različitih tipova pitanja, uključujući višestruki izbor, sparivanje, kratak odgovor, numerička pitanja itd.

Predavač može da dozvoli da se test rešava više puta, sa izmešanim redosledom pitanja ili nasumično izabranim pitanjima iz banke, prilikom svakog pokušaja. Takođe, moguće je podesiti vremensko ograničenje za rešavanje testa.

Svaki pokušaj se automatski ocenjuje, sa izuzetkom esejskog tipa pitanja, a ocena se beleži u knjigu ocena.

Predavač može da izabere da li će i kada polaznicima biti prikazni saveti, povratne informacije i tačni odgovori

Testovi mogu da se koriste:

* kao završni ispiti
* kao mini testovi nakon što polaznici imaju zadatak da pročitaju određeni tekst, ili na kraju neke teme (oblasti)
* kao priprema za završni ispit, koristeći pitanja sa prethodnih  ispita
* za pružanje neposrednih povratnih informacija o postignućima
* za samostalnu procenu znanja';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Testovi';
$string['moveselectedonpage'] = 'Premesti izabrana pitanja na stranicu: {$a}';
$string['multichoice'] = 'Višestruki izbor';
$string['multipleanswers'] = 'Odaberite bar jedan odgovor.';
$string['mustbesubmittedby'] = 'Ovaj pokušaj mora biti predat do {$a}.';
$string['name'] = 'Naziv';
$string['navigatenext'] = 'Sledeća stranica';
$string['navigateprevious'] = 'Prethodna stranica';
$string['navmethod'] = 'Metod navigacije';
$string['navmethod_free'] = 'Slobodna navigacija';
$string['navmethod_help'] = 'Kada je uključena sekvencijalna navigacija polaznici moraju da odgovaraju na pitanja onim redosledom kako su ona poređana u testu, i ne mogu da se vraćaju na prethodne ili preskaču stranice.';
$string['navmethod_seq'] = 'Sekvencijalna navigacija';
$string['navnojswarning'] = 'Upozorenje: ovi linkovi neće sačuvati vaše odgovore. Koristite dugme "Sledeće" na dnu stranice.';
$string['neverallononepage'] = 'Nikad, sva pitanja na jednu stranicu';
$string['newattemptfail'] = 'Greška: Nije bilo moguće započeti novi pokušaj rešavanja testa';
$string['newcategory'] = 'Nova kategorija';
$string['newpage'] = 'Nova stranica';
$string['newpage_help'] = '<p>Kod testove sa puno pitanja ima smisla podeliti test na nekoliko stranica tako što će se ograničiti broj pitanja po jednoj stranici. Kada se testu dodaju pitanja, prelomi stranica biće automatski umetniti shodno podešavanju koje ste ovde izabrali. Ipak, takođe je moguće da kasnije, tokom uređivanja stranice, ručno premeštate prelome stranica.
</p>';
$string['newpageevery'] = 'Automatski staruj novu stranicu';
$string['newsectionheading'] = 'Novi naslov';
$string['noanswers'] = 'Nijedan odgovor nije izabran!';
$string['noattempts'] = 'Nije bilo pokušaja da se reši ovaj test';
$string['noattemptsfound'] = 'Nije pronađen nijedan pokušaj.';
$string['noattemptstoshow'] = 'Nema pokušaja za prikaz';
$string['nocategory'] = 'Pogrešna ili nespecificirana kategorija';
$string['noclose'] = 'Nema datuma zatvaranja testa';
$string['nocommentsyet'] = 'Još nema komentara';
$string['noconnection'] = 'Trenutno nije uspostavljena veza sa Web servisom koji može da obradi ovo pitanje. Molimo kontaktirajte svog administratora';
$string['nodataset'] = 'ništa - nije džoker znak';
$string['nodatasubmitted'] = 'Nijedan podatak nije poslat.';
$string['noessayquestionsfound'] = 'Nisu pronađena pitanja koja se ručno ocenjuju';
$string['nogradewarning'] = 'Ovaj test se ne ocenjuje, tako da ne možete da podesite sveobuhvatnu povratnu informaciju.';
$string['nomoreattempts'] = 'Nemate više pravo da pokušavate da rešite test';
$string['none'] = 'Nijedna';
$string['noopen'] = 'Nema datuma otvaranja testa';
$string['nooverridedata'] = 'Morate da izmenite barem jedno od podešavanja testa';
$string['nopossibledatasets'] = 'Nema mogućih skupova podataka';
$string['noquestionintext'] = 'Tekst pitanja ne sadrži umetnuta pitanja';
$string['noquestions'] = 'Nijedno pitanje još nije dodato';
$string['noquestionsfound'] = 'Nema pitanja';
$string['noquestionsinquiz'] = 'Ne postoje pitanja u ovom testu';
$string['noquestionsnotinuse'] = 'Ovo nasumično odrabrano pitanje nije u upotrebi jer je njegova kategorija prazna';
$string['noquestionsonpage'] = 'Prazna stranica';
$string['noresponse'] = 'Bez odgovora';
$string['noreview'] = 'Nije Vam dozvoljen pregled ovog testa';
$string['noreviewattempt'] = 'Nije Vam dozvoljeno da pregledate ovaj pokušaj';
$string['noreviewshort'] = 'Pregled nije dozvoljen';
$string['noreviewuntil'] = 'Nije Vam dozvoljen pregled ovog testa do {$a}';
$string['noreviewuntilshort'] = 'Dostupno {$a}';
$string['noscript'] = 'JavaScript mora biti omogućen da biste nastavili dalje!';
$string['notavailabletostudents'] = 'Napomena: Ovaj test nije još dostupan Vašim polaznicima.';
$string['notenoughrandomquestions'] = 'Nema dovoljno pitanja u kategoriji {$a->category} za kreiranje pitanja {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Nije definisano dovoljno potpitanja!<br />Da li želite da se vratite nazad i ispravite pitanje?';
$string['notifyattemptsgradedtask'] = 'Slanje obaveštenja o ocenjenim pokušajima rešavanja testa';
$string['notimedependentitems'] = 'Modul za testove trenutno ne podržava vremenski ograničena pitanja. Podesite vremenko ograničenje za čitav test. Da li želite da izaberete drugo pitanje (ili da ipak upotrebite trenutno pitanje)?';
$string['notyetgraded'] = 'Još nije ocenjeno';
$string['notyetviewed'] = 'Još nije pregledano';
$string['notyourattempt'] = 'Ovo nije Vaš pokušaj!';
$string['noview'] = 'Prijavljenom korisniku nije dozvoljeno da pregleda ovaj test';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} su načinili {$a->attemptnum} pokušaja';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numeričko';
$string['numquestionsx'] = 'Pitanja: {$a}';
$string['oneminute'] = '1 minut';
$string['onlyteachersexport'] = 'Samo predavači mogu da izvoze pitanja';
$string['onlyteachersimport'] = 'Samo predavači sa pravima uređivanja mogu da uvoze pitanja';
$string['onthispage'] = 'Ova stranica';
$string['open'] = 'Nije odgovoreno';
$string['openafterclose'] = 'Nije moguće ažurirati test. Naveli ste datum otvaranja nakon datuma zatvaranja.';
$string['openclosedatesupdated'] = 'Ažurirani su datumi otvaranja i zatvaranja testa';
$string['optional'] = 'opciono';
$string['orderandpaging'] = 'Redosled pitanja i organizacija stranica';
$string['orderandpaging_help'] = 'Brojevi 10, 20, 30... pored svakog pitanja ukazuju na redosled pitanja u testu. Brojevi se povećavaju u koracima po 10 kako bi se ostavio prostor za ubacivanje dodatnih pitanja. Da biste promenili redosled pitanja, promenite broj a onda kliknite na dugme "Promeni redosled pitanja".

Da biste dodali prelom stranice nakon određenog pitanja, označite polje za potvrdu odmah pored samog pitanja a zatim kliknite na dugme "Dodaj nove stranice posle izabranih pitanja"

Da biste organizovali pitanja na više stranica kliknite na dugme "Reorganizuj stranice" i izaberite željeni broj pitanja po stranici.';
$string['orderingquiz'] = 'Redosled pitanja i organizacija stranica';
$string['orderingquizx'] = 'Redosled i organizacija stranica: {$a}';
$string['outcomesadvanced'] = 'Ishodi su napredna podešavanja';
$string['outof'] = '{$a->grade} od {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} od {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['overallfeedback_help'] = 'Sveobuhvatne povratne informacije predstavljaju tekst koji se prikazuje nakon rešavnja testa. Ako se dodatno odrede granične vrednosti ocena (kao procenti ili brojevi), tekst koji će biti prikazan zavisi od dobijene ocene.';
$string['overdue'] = 'Zakasneli';
$string['overduehandling'] = 'Kada vreme istekne';
$string['overduehandling_desc'] = 'Šta se obično događa ako polaznik ne preda test pre nego što vreme istekne.';
$string['overduehandling_help'] = 'Ovo podešavanje kontroliše šta se događa ako polaznik ne uspe da preda svoj pokušaj rešavanja testa pre nego što vreme istekne. Ako polaznici aktivno rade na testu u tom trenutku, onda će tajmer automatski predati pokušaj umesto njih, ali ako su odjavljen sa sistema, onda ovo podešavanje kontroliše šta će se desiti.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Pokušaji moraju biti predati pre nego što vreme istekne, ili se neće računati';
$string['overduehandlingautosubmit'] = 'Započeti pokušaji se automatski predaju';
$string['overduehandlinggraceperiod'] = '
Postoji dodatni vremenski period u kom se započeti pokušaji rešavanja mogu predati, ali se na pitanja više ne može odgovarati';
$string['overduemustbesubmittedby'] = 'Vreme za ovaj pokušaj rešavanje testa je isteklo. Pokušaj je već trebalo predati. Ako želite da ovaj test bude ocenjen morate ga predati do {$a}. Ako to ne uradite do navedenog roka, ocene za ovaj pokušaj se neće računati.';
$string['override'] = 'Izmena';
$string['overridecannotchange'] = 'Korisnik ili grupa se ne mogu promeniti nakon što je kreirana izmena podešavanja.';
$string['overridecannotsetbothgroupanduser'] = 'I grupa i korisnik se ne mogu podesiti u isto vreme.';
$string['overridedeletegroupsure'] = 'Da li ste sigurni da želite da obrišete izmenu podešavanja za grupu {$a}?';
$string['overridedeleteusersure'] = 'Da li ste sigurni da želite da obrišete izmenu podešavanja za korisnika {$a}?';
$string['overridegroup'] = 'Izmeni podešavanja za grupu';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'Vrednosti za pokušaje moraju biti veća od nule';
$string['overrideinvalidexistingid'] = 'Postojeća izmena podešavanja ne postoji.';
$string['overrideinvalidgroup'] = 'Data grupa ne postoji.';
$string['overrideinvalidquiz'] = 'Podešena ID oznaka testa ne postoji.';
$string['overrideinvalidtimelimit'] = 'Vremensko ograničenje mora biti veće od nule.';
$string['overrideinvaliduser'] = 'Dati korisnik ne postoji.';
$string['overridemissingdelete'] = 'ID oznaka(e) izmene(a) podešavanja {$ a} ne mogu biti obrisane jer ne postoje ili nisu deo datog testa.';
$string['overridemultiplerecordsexist'] = 'Za istog korisnika/grupu nije moguće izvršiti višestruke izmene podešavanja.';
$string['overridemustsetuserorgroup'] = 'Korisnik ili grupa moraju biti podešeni.';
$string['overrides'] = 'Izmene';
$string['overridesforquiz'] = 'Izmene podešavanja: {$a}';
$string['overridesnoneforgroups'] = 'Za ovaj test nisu kreirane izmene podešavanja testa za grupe.';
$string['overridesnoneforusers'] = 'Za ovaj test nisu kreirane izmene podešavanja testa za korisnike.';
$string['overridessummary'] = 'Postoje izmene podešavanja ({$a})';
$string['overridessummarygroup'] = 'Grupe: {$a}';
$string['overridessummarythisgroup'] = 'Postoje izmene podešavanja ({$a}) za ovu grupu';
$string['overridessummaryuser'] = 'Korisnici: {$a}';
$string['overridessummaryyourgroups'] = 'Postoje izmene podešavanja ({$a}) za vašu grupu';
$string['overrideuser'] = 'Izmeni podešavanja za korisnika';
$string['overrideusereventname'] = '{$a->quiz} - Izmena';
$string['page-mod-quiz-attempt'] = 'Stranica pokušaja rešavanja testa';
$string['page-mod-quiz-edit'] = 'Stranica za uređivanje testa';
$string['page-mod-quiz-report'] = 'Bilo koja stranica izveštaja o testu';
$string['page-mod-quiz-review'] = 'Stranica za pregled pokušaja rešavanja testa';
$string['page-mod-quiz-summary'] = 'Stranica sa rezimeom pokušaja';
$string['page-mod-quiz-view'] = 'Stranica sa informacijama o testu';
$string['page-mod-quiz-x'] = 'Bilo koja stranica test modula';
$string['pageshort'] = 'Str.';
$string['pagesize'] = 'Veličina stranice';
$string['parent'] = 'Nadređeni';
$string['parentcategory'] = 'Nadređena kategorija';
$string['parsingquestions'] = 'Parsiranje pitanja iz uvozne datoteke.';
$string['partiallycorrect'] = 'Delimično tačno';
$string['penalty'] = 'Kazneni bodovi';
$string['penaltyscheme'] = 'Primeni kaznene bodove';
$string['penaltyscheme_help'] = '<p>Ako je test pokrenut u adaptivnom modu onda je polaznicima dozvoljeno da, nakon pogrešnog odgovora, pokušaju ponovo. U tom slučaju možda ćete poželeti da uvedete kaznene poene za svaki pogrešan odgovor kako biste umanjili finalnu ocenu. Vrednost kaznenih poena se određuje pojedinačno za svako pitanje prilikom podešavanja i uređivanja pitanja.</p>

<p>Ovo podešavanje je bez uticaja ukoliko test nije pokrenut u adaptivnom modu.</p>';
$string['percentcorrect'] = 'Procenat tačnosti';
$string['pleaseclose'] = 'Vaš zahtev je prosleđen. Možete da zatvorite prozor';
$string['pluginadministration'] = 'Administracija testa';
$string['pluginname'] = 'Test';
$string['popup'] = 'Prikaži test u \'bezbednom\' prozoru';
$string['popupblockerwarning'] = 'Ovaj deo testa se radi u bezbednom modu, što znači da morate rešavati test u bezbednom prozoru. Molimo isključite sve alate za sprečavanje pojave iskačućih prozora. Hvala.';
$string['popupnotice'] = 'Polaznici će videti test u \'sigurnom\' prozoru';
$string['preprocesserror'] = 'Došlo je do greške u toku prethodne obrade!';
$string['preview'] = 'Pregled';
$string['previewquestion'] = 'Pregled pitanja';
$string['previewquiz'] = 'Pregledaj {$a}';
$string['previewquiznow'] = 'Pregledaj test sada';
$string['previewquizstart'] = 'Započni test';
$string['previous'] = 'Prethodno stanje';
$string['privacy:metadata:core_question'] = 'Aktivnost \'Test\' čuva informacije o korišćenju pitanja u podsistemu core_question.';
$string['privacy:metadata:quiz'] = 'Aktivnost \'Test\' koristi izveštaje o testu.';
$string['privacy:metadata:quiz_attempts'] = 'Detaljne informacije o svakom pokušaju rešavanja testa.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Broj pokušaja.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Trenutna stranica na kojoj je korisnik.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Vreme kada je korisnik obavešten da je ručno ocenjivanje njegovog pokušaja završeno';
$string['privacy:metadata:quiz_attempts:preview'] = 'Da li je ovo pregled testa.';
$string['privacy:metadata:quiz_attempts:state'] = 'Trenutni status pokušaja.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Zbir ocena u pokušaju.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Vreme kada je status pokušaja proveren.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Vreme kada je pokušaj završen.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Vreme kada je pokušaj ažuriran.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Vreme kada je pokušaj ažuriran putem oflajn ažuriranja.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Vreme kada je pokušaj započet.';
$string['privacy:metadata:quiz_grades'] = 'Detaljne informacije o ukupnoj oceni za ovaj test.';
$string['privacy:metadata:quiz_grades:grade'] = 'Ukupna ocena za ovaj test.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Test koji je ocenjen.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Vreme kada je ocena izmenjena.';
$string['privacy:metadata:quiz_grades:userid'] = 'Korisnik koji je ocenjen.';
$string['privacy:metadata:quiz_overrides'] = 'Detaljne informacije o izmenama za ovaj test.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Test sa informacijama o izmenama';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Nove vreme zatvaranja testa.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Novo vremensko ograničenje za test.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Nove vreme otvaranja testa.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Korisnik je izmenjen';
$string['privacy:metadata:quizaccess'] = 'Aktivnost \'Test\' koristi pravila za pristup testu.';
$string['publish'] = 'Objavi';
$string['publishedit'] = 'Da bi ste dodali ili uredili pitanja u ovoj kategoriji morate imati odgovarajuće pravo pristupa';
$string['qbrief'] = 'P. {$a}';
$string['qname'] = 'naziv';
$string['qti'] = 'IMS QTI format';
$string['qtypename'] = 'tip, naziv';
$string['question'] = 'Pitanje';
$string['questionbank'] = 'iz banke pitanja';
$string['questionbankmanagement'] = 'Upravljanje bankom pitanja';
$string['questionbehaviour'] = 'Karakteristike pitanja';
$string['questioncats'] = 'Kategorije pitanja';
$string['questiondeleted'] = 'Ovo pitanje je obrisano. Obratite se svom predavača.';
$string['questiondependencyadd'] = 'Nema ograničenja kada na pitanje {$a->thisq} može da se odgovori • Klikni za promenu';
$string['questiondependencyfree'] = 'Nema ograničenja za ovo pitanje';
$string['questiondependencyremove'] = 'Na pitanje {$a->thisq} ne može da se odgovori dok prethodno pitanje {$a->previousq} nije završeno • Klikni za promenu';
$string['questiondependsonprevious'] = 'Na ovo pitanje ne može da se odgovori dok prethodno pitanje nije završeno';
$string['questiondraftonly'] = 'Pitanje \'{$a}\' je u statusu \'Radna verzija\'. Da biste ga koristili u testu, idite u banku pitanja i promenite status pitanja na \'Spremno\'.';
$string['questiondraftwillnotwork'] = 'Ovo pitanje je u statusu \'Radna verzija\'. Da biste ga koristili u testu, idite u banku pitanja i promenite status pitanja na \'Spremno\'.';
$string['questioninuse'] = 'Pitanje \'{$a->questionname}\' se trenutno koristi u <br />{$a->quiznames}<br />Pitanje neće biti obrisano iz ovih testova, već samo sa spiska kategorije.';
$string['questionmissing'] = 'Nedostaje pitanje za ovu sesiju';
$string['questionname'] = 'Naziv pitanja';
$string['questionnonav'] = '<span class="accesshide">Pitanje </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Informacija </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Pitanje {$a} nije učitano iz baze podataka';
$string['questionorder'] = 'Redosled pitanja';
$string['questionposition'] = 'Nova pozicija u redosledu za pitanje {$a}';
$string['questions'] = 'Pitanja';
$string['questionsetpreview'] = 'Pregled skupa pitanja';
$string['questionsinclhidden'] = 'Pitanja (uključujući i skrivena)';
$string['questionsinthisquiz'] = 'Pitanja u ovom testu';
$string['questionsmatchingfilter'] = 'Pitanja koja odgovaraju ovom filteru: {$a}';
$string['questionsperpage'] = 'Broj pitanja po stranici';
$string['questionsperpageselected'] = 'Broj pitanja po stranici je podešen, tako da je trenutno broj stranica fiksiran. Usled toga kontrole za reorganiѕaciju stranica su isključene. Ovo možete da promenite na {$a}.';
$string['questionsperpagex'] = 'Broj pitanja po stranici: {$a}';
$string['questiontext'] = 'Tekst pitanja';
$string['questiontextisempty'] = '[Nema teksta pitanja]';
$string['questiontype'] = 'Tip pitanja {$a}';
$string['questiontypesetupoptions'] = 'Opcije podešavanja za tipove pitanja:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (najnovija)';
$string['quiz:addinstance'] = 'Dodavanje novog testa';
$string['quiz:attempt'] = 'Pokušaj rešavanja testova';
$string['quiz:deleteattempts'] = 'Obriši pokušaje rešavanja testa';
$string['quiz:emailconfirmsubmission'] = 'Dobijanje potvrde o predaji vaših sopstvenih testova';
$string['quiz:emailnotifyattemptgraded'] = 'Dobijanje poruke sa obaveštenjem kada je vaš pokušaj ocenjen';
$string['quiz:emailnotifysubmission'] = 'Dobijanje poruke sa obaveštenjem o predatim testovima vaših polaznika';
$string['quiz:emailwarnoverdue'] = 'Dobijanje upozorenje kada vaš pokušaj rešavanja testa kasni';
$string['quiz:grade'] = 'Oceni testove ručno';
$string['quiz:ignoretimelimits'] = 'Zanemari vremensko ograničenje testa';
$string['quiz:manage'] = 'Upravljanje testovima';
$string['quiz:manageoverrides'] = 'Upravljanje izmenama podešavanja testa';
$string['quiz:preview'] = 'Pregledaj testova';
$string['quiz:regrade'] = 'Ponovo oceni pokušaje';
$string['quiz:reopenattempts'] = 'Ponovo otvorite pokušaje rešavanja testa koji nikad nisu predati';
$string['quiz:reviewmyattempts'] = 'Pregledaj sopstvene pokušaje';
$string['quiz:view'] = 'Pregled informacija o testu';
$string['quiz:viewoverrides'] = 'Pregled izmena podešavanja testa';
$string['quiz:viewreports'] = 'Pregled izveštaja o testu';
$string['quizavailable'] = 'Test je dostupan do: {$a}';
$string['quizclose'] = 'Test dostupan do:';
$string['quizclosed'] = 'Test je zatvoren dana {$a}';
$string['quizcloses'] = 'Test se zatvara';
$string['quizcloseson'] = 'Ovaj test se zatvara {$a}.';
$string['quizeventcloses'] = '{$a} se zatvara';
$string['quizeventopens'] = '{$a} se otvara';
$string['quizisclosed'] = 'Ovaj test je zatvoren';
$string['quizisclosedwillopen'] = 'Test je zatvoren (otvara se {$a})';
$string['quizisopen'] = 'Ovaj test je otvoren';
$string['quizisopenwillclose'] = 'Test je otvoren (zatvara se {$a})';
$string['quiznavigation'] = 'Navigacija testa';
$string['quizopen'] = 'Test dostupan od:';
$string['quizopenclose'] = 'Datumi otvaranja i zatvaranja';
$string['quizopenclose_help'] = 'Polaznici mogu samo da započnu svoje pokušaje rešavanja testa nakon datuma otvaranja i moraju da ih završe pre datuma zatvaranja.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Ovaj test je otvoren';
$string['quizopenedon'] = 'Ovaj test je otvoren {$a}';
$string['quizopens'] = 'Test se otvara dana';
$string['quizopenwillclose'] = 'Ovaj test je otvoren, biće zatovoren {$a}';
$string['quizordernotrandom'] = 'Redosled testa nije izmešan';
$string['quizorderrandom'] = '* Redosled testa je izmešan';
$string['quizreport'] = 'Izveštaj o testu';
$string['quizsettings'] = 'Podešavanja testa';
$string['quizsetupnavigation'] = 'Navigacija za podešavanje testa';
$string['quiztimer'] = 'Tajmer testa';
$string['quizwillopen'] = 'Ovaj test se otvara {$a}';
$string['random'] = 'Nasumično odabrano pitanje';
$string['randomcatwithsubcat'] = '{$a} i potkategorije';
$string['randomcoursecatwithsubcat'] = 'Bilo koja kategorija unutar kategorije kurseva {$a}';
$string['randomcoursewithsubcat'] = 'Bilo koja kategorija na ovom kursu';
$string['randomcreate'] = 'Kreiraj nasumično odabrana pitanja';
$string['randomediting'] = 'Uređivanje nasumično odabranog pitanja';
$string['randomfaultynosubcat'] = 'Pogrešno pitanje';
$string['randomfromcategory'] = 'Nasumično odabrano pitanje iz kategorije';
$string['randomfromexistingcategory'] = 'Nasumično odabrano pitanje iz postojeće kategorije';
$string['randomfromunavailabletag'] = '{$a} (nije raspoloživo)';
$string['randommodulewithsubcat'] = 'Bilo koja kategorija ovog testa';
$string['randomnosubcat'] = 'Pitanja samo iѕ ove kategorije, ne i njenih potkategorija';
$string['randomnumber'] = 'Broj nasumično izabranih pitanja';
$string['randomqname'] = 'Nasumično izabrano pitanje na osnovu uslova za filtriranje';
$string['randomqnamecat'] = 'Nasumična kategorija ({$a->category}) na osnovu uslova zadatih pomoću filtera';
$string['randomqnamecattags'] = 'Nasumična kategorija ({$a->category}) na osnovu uslova zadatih pomoću filtera sa oznakama: {$a->tags}';
$string['randomqnametags'] = 'Nasumično izabrano pitanje na osnovu uslova za filtriranje sa oznakama: {$a}';
$string['randomquestion'] = 'Nasumično odabrano pitanje';
$string['randomquestion_help'] = 'Nasumično pitanje je način da se u test ubaci pitanje slučajno izabrano iz određene kategorije ili pomoću određene oznake.';
$string['randomquestiontags'] = 'Oznake';
$string['randomquestiontags_help'] = 'Možete dodatno ograničiti kriterijume za izbor tako što ćete ovde navesti oznake pitanja.

"Nasumična" pitanja biće izabrana od pitanja koja imaju sve ove oznake.';
$string['randomquestionusinganewcategory'] = 'Nasumično odabrano pitanje koristeći novu kategoriju';
$string['randomsystemwithsubcat'] = 'Bilo koja kategorija na nivou sistema';
$string['randomwithsubcat'] = 'Pitanja iz ove kategorije i njenih potkategorija';
$string['readytosend'] = 'Upravo ćete poslati svoje rešenje testa na ocenjivanje. Da li ste sigurni da želite da nastavite?';
$string['reattemptquiz'] = 'Ponovni pokušaj rešavanja testa';
$string['recentlyaddedquestion'] = 'Nedavno dodato pitanje!';
$string['recurse'] = 'Uključi i pitanja iz potkategorija';
$string['redoesofthisquestion'] = 'Druga pitanja na koja su ovde davani odgovori: {$a}';
$string['redoquestion'] = 'Pokušajte sa drugim pitanjem poput ovog';
$string['regrade'] = 'Ponovo oceni sve pokušaje';
$string['regradecomplete'] = 'Svi pokušaji su ponovo ocenjeni';
$string['regradecount'] = '{$a->changed} od ukupno {$a->attempt} ocena je promenjeno';
$string['regradedisplayexplanation'] = 'Pokušaji koji se menjaju tokom ponovnog ocenjivanja se prikazuju kao linkovi na prozor za pregled pitanja';
$string['regradenotallowed'] = 'Nemate dozvolu za ponovno ocenjivanje ovog testa';
$string['regradingquestion'] = 'Ponovno ocenjivanje "{$a}".';
$string['regradingquiz'] = 'Ponovno ocenjivanje testa "{$a}"';
$string['remove'] = 'Ukloni';
$string['removeallgroupoverrides'] = 'Obriši sve izmene podešavanja za grupe';
$string['removeallquizattempts'] = 'Оbriši sve pokušaje rešavanja testa';
$string['removealluseroverrides'] = 'Obriši sve izmene podešavanja za korisnike';
$string['removeemptypage'] = 'Ukloni praznu stranicu';
$string['removepagebreak'] = 'Ukloni prelom stranice';
$string['removeselected'] = 'Ukloni izabrane';
$string['rename'] = 'Preimenuj';
$string['renderingserverconnectfailed'] = 'Server {$a} nije uspeo da obradi RQP zahtev. Proverite da li je URL adresa tačna.';
$string['reopenattempt'] = 'Ponovo otvori';
$string['reopenattemptareyousuremessage'] = 'Ovo će ponovo otvoriti pokušaj rešavanja testa {$a->attemptnumber} korisnika {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Ponovo otvorite pokušaj rešavanja testa?';
$string['reopenattemptwrongstate'] = 'Pokušaj {$a->attemptid} je u pogrešnom statusu ({$a->state}) da bi mogao biti ponovo otvoren.';
$string['reopenedattemptwillbeinprogress'] = 'Pokušaj rešavanja testa ostaće otvoren i može se nastaviti.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Pokušaj rešavanja testa ostaće otvoren i može se nastaviti sve dok se test ne zatvori dana {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Pokušaj rešavanja testa biće odmah poslat na ocenjivanje.';
$string['reorderquestions'] = 'Promeni redosled pitanja';
$string['reordertool'] = 'Prikaži alat za reorganizovanje';
$string['repaginate'] = 'Reorganizuj stranice sa {$a} pitanja po jednoj stranici';
$string['repaginatecommand'] = 'Reorganizuj stranice';
$string['repaginatenow'] = 'Reorganizuj stranice sad';
$string['replace'] = 'Zameni';
$string['replacementoptions'] = 'Opcije za zamenu';
$string['report'] = 'Izveštaji';
$string['reportanalysis'] = 'Analiza pitanja';
$string['reportattemptsfrom'] = 'Pokušaji sledećih korisnika:';
$string['reportattemptsthatare'] = 'Pokušaji čiji je status:';
$string['reportdisplayoptions'] = 'Opcije prikaza';
$string['reportfullstat'] = 'Detaljna statistika';
$string['reportmulti_percent'] = 'Procenti';
$string['reportmulti_q_x_student'] = 'Odgovori polaznika';
$string['reportmulti_resp'] = 'Individualni odgovori';
$string['reportmustselectstate'] = 'Morate da izaberete bar jedno status';
$string['reportnotfound'] = 'Izveštaj nije poznat ({$a})';
$string['reportoverview'] = 'Pregled';
$string['reportregrade'] = 'Ponovna ocena pokušaja rešavanja testa';
$string['reportresponses'] = 'Detaljni odgovori';
$string['reports'] = 'Izveštaji';
$string['reportshowonly'] = 'Prikaži samo pokušaje';
$string['reportshowonlyfinished'] = 'Prikaz najviše jednog završenog pokušaja po korisniku ({$a})';
$string['reportsimplestat'] = 'Jednostavna statistika';
$string['reportusersall'] = 'svi korisnici koji su rešavali test';
$string['reportuserswith'] = 'upisani korisnici koji su rešavali test';
$string['reportuserswithorwithout'] = 'upisani korisnici koji jesu ili nisu rešavali test';
$string['reportuserswithout'] = 'upisani korisnici koji nisu rešavali test';
$string['reportwhattoinclude'] = 'Šta uključiti u izveštaj';
$string['requirepassword'] = 'Neophodna je lozinka';
$string['requirepassword_help'] = '<p>Ovo polje nije obavezno</p>

<p>Ako ovde odredite lozinku od učesnika će se zahtevati da istu unesu pre nego što im se dozvoli da pokušaju da reše test.</p>';
$string['requiresubnet'] = 'Zahtevana mrežna adresa';
$string['requiresubnet_help'] = '<p>Ovo polje nije obavezno.</p>

<p>Možete ograničiti pristup testu samo na neke podmreže u okviru LAN mreže ili Interneta navođenjem spiska parcijalnih ili potpunih IP adresnih brojeva odvojenih zarezima.</p>

<p>To je posebno korisno za nadgledane testove, kada želite da budete sigurni da samo prisutni u određenoj prostoriji mogu da pristupe testu.</p>

<p>Na primer:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Postoje tri tipa IP brojeva koje možete koristiti (ne možete upotrebiti tekstualna imena domena, kao što je recimo primer.com):
<ol>
<li>Potpune IP adrese, kao što je <b>192.168.10.1</b>, koje će označavati pojedinačne računare (ili proxy servere).</li>
<li>Parcijalne adrese, kao što je <b>192.168</b>, koje će obuhvatati sve adrese koje počinju tim brojevima.</li>
<li>CIDR notacija, kao što je <b>231.54.211.0/20</b>, koja dozvoljava detaljniju specifikaciju podmreža.</li>
</ol>
</p>

<p>Praznine se ignorišu.</p>';
$string['response'] = 'Odgovor';
$string['responses'] = 'Odgovori polaznika';
$string['results'] = 'Rezultati';
$string['returnattempt'] = 'Povratak na pokušaj';
$string['reuseifpossible'] = 'ponovo iskoristi prethodno uklonjeno';
$string['reverttodefaults'] = 'Vrati test na standardna podešavanja';
$string['review'] = 'Pregled';
$string['reviewafter'] = 'Dozvoliti pregled nakon što se test zatvori';
$string['reviewalways'] = 'Dozvoliti pregled u bilo koje vreme';
$string['reviewattempt'] = 'Pregledaj pokušaj';
$string['reviewbefore'] = 'Dozvoliti pregled dok je test otvoren';
$string['reviewclosed'] = 'Nakon što se test zatvori';
$string['reviewduring'] = 'Tokom pokušaja rešavanja';
$string['reviewimmediately'] = 'Odmah nakon pokušaja';
$string['reviewnever'] = 'Nikad nemoj dozvoliti pregled';
$string['reviewofquestion'] = 'Pregled pitanja {$a->question} u {$a->quiz} od strane korisnika {$a->user}';
$string['reviewopen'] = 'Kasnije, dok je test još uvek otvoren';
$string['reviewoptions'] = 'Polaznici mogu da pregledaju';
$string['reviewoptionsheading'] = 'Opcije za pregled';
$string['reviewoptionsheading_help'] = 'Ova opcije kontrolišu koje informacije polaznici mogu da vide kada pregledaju pokušaj rešavanja testa odnosno kada gledaju izveštaj sa testa.

**U toku pokušaja** - ovo podešavanje je relevantno samo za neka ponašanja, kao što je \'interaktivno sa višestrukim pokušajima\',  koje može da prikazuje povratne informacije u toku pokušaja.

**Odmah nakon pokušaja** - ovo podešavanje se primenjuje u prva dva minuta nakon što je polaznik kliknuo na dugme \'Predaj sve i završi\'.

**Kasnije, dok je test još uvek otvoren** - ovo podešavanje se primenjuje, nakon ta prva dva minuta pa sve dok je test otvoren.

**Nakon što je test zatvoren** - ovo podešavanje se primenjuje nakon što prođe datum zatvaranja testa. Ako test nema datum zatvaranja, ovaj uslov nikada neće biti postignut.';
$string['reviewoverallfeedback'] = 'Sveobuhvatne povratne informacije';
$string['reviewoverallfeedback_help'] = 'Povratne informacije koje se daju na kraju pokušaja rešavanja testa, u zavisnosti od ukupne ocene polaznika.';
$string['reviewresponse'] = 'Pregled odgovora';
$string['reviewresponsetoq'] = 'Pregledaj odgovore (pitanje {$a})';
$string['reviewthisattempt'] = 'Pregledaj svoj odgovor na ovaj pokušaj';
$string['rqp'] = 'Udaljeno pitanje';
$string['rqps'] = 'Udaljena pitanja';
$string['sameasoverall'] = 'Isto kao i za sveukupne ocene';
$string['save'] = 'Sačuvaj';
$string['saveandedit'] = 'Sačuvaj promene i uredi pitanja';
$string['saveattemptfailed'] = 'Neuspelo čuvanje aktuelnog pokušaja rešenja testa.';
$string['savedfromdeletedcourse'] = 'Sačuvano sa kursa "{$a}" koji je obrisan';
$string['savegrades'] = 'Sačuvaj ocene';
$string['savemanualgradingfailed'] = 'Izmena nije sačuvana. Proverite poruku u nastavku i pokušajte ponovo.';
$string['savemyanswers'] = 'Sačuvaj moje odgovore';
$string['savenosubmit'] = 'Sačuvaj bez predavanja';
$string['saveoverrideandstay'] = 'Sačuvaj i unesi drugu izmenu';
$string['savequiz'] = 'Sačuvaj ceo test';
$string['saving'] = 'Čuvanje';
$string['savingnewgradeforquestion'] = 'Čuvanje nove ocene za pitanjе sa identifikatorom {$a}.';
$string['savingnewmaximumgrade'] = 'Čuvanje nove maksimalne ocene';
$string['score'] = 'Neobrađeni rezultat';
$string['scores'] = 'Rezultati';
$string['search:activity'] = 'Test - informacije o aktivnosti';
$string['sectionheadingedit'] = 'Uredi naslov \'{$a}\'';
$string['sectionheadingremove'] = 'Ukloni naslov \'{$a}\'';
$string['sectionnoname'] = 'Sekcija bez naslova';
$string['seequestions'] = '(Pogledaj pitanja)';
$string['select'] = 'Selektuj';
$string['selectall'] = 'Izaberi sve';
$string['selectattempt'] = 'Odaberi pokušaj';
$string['selectcategory'] = 'Izaberi kategoriju';
$string['selectedattempts'] = 'Izabrani pokušaji...';
$string['selectmultipleitems'] = 'Izaberi više stavki';
$string['selectmultipletoolbar'] = 'Izaberi više traka sa alatkama';
$string['selectnone'] = 'Poništi izbor svega';
$string['selectquestionslot'] = 'Izaberi pitanje {$a}';
$string['selectquestiontype'] = '-- Izbaeri tip pitanja --';
$string['serveradded'] = 'Server je dodat';
$string['serveridentifier'] = 'Identifikator';
$string['serverinfo'] = 'Informacije o serveru';
$string['servers'] = 'Serveri';
$string['serverurl'] = 'URL servera';
$string['shortanswer'] = 'Pitanje sa kratkim odgovorom';
$string['show'] = 'Prikaži';
$string['showall'] = 'Prikaži sva pitanja na jednoj stranici';
$string['showblocks'] = 'Prikaži blokove tokom rešavanja testa';
$string['showblocks_help'] = 'Ako je podešeno na \'da\', onda će u toku rešavanja testa biti prikazani  uobičajeni blokovi.';
$string['showbreaks'] = 'Prikaži prelome stranica';
$string['showcategorycontents'] = 'Prikaži sadržaj kategorija {$a->arrow}';
$string['showcorrectanswer'] = 'Da li da se uz povratne informacije prikažu i tačni odgovori?';
$string['showdetailedmarks'] = 'Prikaži detalje ocene';
$string['showeachpage'] = 'Prikaži jednu po jednu stranicu';
$string['showfeedback'] = 'Da li da se prikažu i povratne informacije nakon davanja odgovora na pitanja?';
$string['showinsecurepopup'] = 'Upotrebiti \'bezbedni\' iskačući prozor za pokušaje';
$string['showlargeimage'] = 'Velika slika';
$string['shownoattempts'] = 'Prikaži polaznike bez pokušaja';
$string['shownoattemptsonly'] = 'Prikaži samo polaznike bez pokušaja';
$string['shownoimage'] = 'Bez slike';
$string['showreport'] = 'Prikaži izveštaj';
$string['showsmallimage'] = 'Mala slika';
$string['showteacherattempts'] = 'Prikaži pokušaje predavača da reši test';
$string['showuserpicture'] = 'Prikaži sliku korisnika';
$string['showuserpicture_help'] = 'Ako je ova opcija omogućena, ime i slika polaznika biće prikazana na ekranu tokom rešavanja testa, kao i prilikom pregleda. Ovo olakšava proveru da li su se polaznici prijavili na sistme sa svojim nalogom, na testu koji se rade u učionici pod kontrolom proktora (nastavnika).';
$string['shuffle'] = 'Izmešaj';
$string['shuffleanswers'] = 'Izmešaj odgovore';
$string['shuffledrandomly'] = 'Nasumično izmešano';
$string['shufflequestions'] = 'Izmešaj';
$string['shufflequestions_help'] = 'Ako je ova opcija omogućena, onda će svaki put kada se pokuša rešavanje testa, redosled pitanja u ovoj sekciji biti izmešana i poređana drugačijim nasumično redosledom.

Ovo može otežati polaznicima da razmenjuju odgovore između sebe ali, takođe, otežava i mogućnost polaznicima da diskutuju određeno pitanje sa predavačem.';
$string['shufflewithin'] = 'Izmešaj redosled odgovora u okviru pitanja';
$string['shufflewithin_help'] = 'Ako omogućite ovu opciju, delovi od kojih se sastoje pojedinačna pitanja biće nasumično izmešani svaki put kad polaznik pokuša da reši ovaj test, pod uslovom da je ista opcija omogućena i u podešavanjima samih pitanja. Ovo podešavanje se primenjuje samo na pitanja koja se sastoje iz više delova, kao što su pitanja tipa višestrukog izbora ili pitanja sa sparivanjem odgovora.';
$string['singleanswer'] = 'Odaberite jedan odgovor';
$string['sortage'] = 'Sortiraj po vremenu kreiranja';
$string['sortalpha'] = 'Sortiraj po imenu';
$string['sortquestionsbyx'] = 'Poređaj pitanja po {$a}';
$string['sortsubmit'] = 'Sortiraj pitanja';
$string['sorttypealpha'] = 'Sortiraj po tipu, imenu';
$string['specificapathnotonquestion'] = 'Zadata putanja datoteke nije na datom pitanju';
$string['specificquestionnotonquiz'] = 'Zadato pitanje nije u datom testu';
$string['startagain'] = 'Počni ponovo';
$string['startattempt'] = 'Započni pokušaj rešavanja';
$string['startedon'] = 'Započeto';
$string['startnewpreview'] = 'Započnite novi pregled';
$string['stateabandoned'] = 'Nikad predati';
$string['statefinished'] = 'Završeni';
$string['statefinisheddetails'] = 'Predato {$a}';
$string['stateinprogress'] = 'U toku';
$string['statenotloaded'] = 'Status za pitanje  {$a} nije učitano iz baze podataka';
$string['stateoverdue'] = 'Zakasneli';
$string['stateoverduedetails'] = 'Mora se predati do {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Stani pri pojavi greške';
$string['submission_confirmation'] = 'Pošaljite sve svoje odgovore i završite?';
$string['submission_confirmation_unanswered'] = 'Pitanja bez odgovora: {$a}';
$string['submitallandfinish'] = 'Predaj sve odgovore i završi test';
$string['subneterror'] = 'Nažalost, ovaj test je zaključan, odnosno dostupan je samo sa pojedinih lokacija. Trenutno Vaš računar nije jedan od onih kojima je dozvoljeno da koriste ovaj test.';
$string['subnetnotice'] = 'Ovom testu se može pristupiti samo sa određenih mesta. Vaš računar se ne nalazi u mreži sa koje je pristup dozvoljen. Ipak, kao predavač svakako možete da pregledate test.';
$string['subplugintype_quiz'] = 'Izveštaj';
$string['subplugintype_quiz_plural'] = 'Izveštaji';
$string['subplugintype_quizaccess'] = 'Pravilo za pristup testu';
$string['subplugintype_quizaccess_plural'] = 'Pravila za pristup testu';
$string['substitutedby'] = 'biće zamenjeno sa';
$string['summaryofattempt'] = 'Rezime pokušaja';
$string['summaryofattempts'] = 'Vaši pokušaji';
$string['temporaryblocked'] = 'Privremeno Vam nije dozvoljeno da ponovo pokušate da rešite test.<br /> Moći ćete ponovo da mu pristupite dana:';
$string['theattempt'] = 'Pokušaj rešavanja';
$string['theattempt_help'] = 'Da li polaznik uopšte može da pregleda pokušaj.';
$string['time'] = 'Vreme';
$string['timecompleted'] = 'Završeno';
$string['timedelay'] = 'Nije vam dozvoljeno da radite test jer još nije proteklo dovoljno vremena između provg i drugog pokušaja rešavanja testa';
$string['timeleft'] = 'Preostalo vreme';
$string['timelimit'] = 'Vremensko ograničenje';
$string['timelimit_help'] = 'Ako je ova opcija omogućena, na početnoj stranici testa biće navedeno vremensko ograničenje, a u bloku za navigaciju testa biće prikazan tajmer.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Nažalost, vreme za rešavanje testa je isteklo!';
$string['timestr'] = '%H:%M:%S dana %d.%m.%y.';
$string['timesup'] = 'Vreme je isteklo!';
$string['timetaken'] = 'Utrošeno vreme';
$string['timing'] = 'Podešavanje vremena';
$string['tofile'] = 'u datoteku';
$string['tolerance'] = 'Odstupanje';
$string['toomanyrandom'] = 'Broj potrebnih nasumičnih pitanja je veći nego broj pitanja koja postoje u kategoriji!';
$string['top'] = 'Najviši nivo';
$string['totalmarks'] = 'Maksimalno bodova za sva pitanja';
$string['totalmarksx'] = 'Maksimalno bodova za sva pitanja: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Ukupno {$a} pitanja u kategoriji.';
$string['true'] = 'Tačno';
$string['truefalse'] = 'Tačno/netačno';
$string['type'] = 'Tip';
$string['unfinished'] = 'otvoreno';
$string['ungraded'] = 'Neocenjeno';
$string['unit'] = 'Jedinica';
$string['unknowntype'] = 'Tip pitanja nije podržan u redu {$a}. Pitanje će biti ignorisano.';
$string['updatefilterconditon'] = 'Ažurirajte uslove za filtriranje';
$string['updatefilterconditon_success'] = 'Uslovi za filtriranje uspešno su ažurirani';
$string['updateoverdueattemptstask'] = 'Ažuriranje pokušaja rešavanja testa koji su predati za kašnjenjem';
$string['updatequizslotswithrandomxofy'] = 'Ažuriranje testa sa podacima o "nasumičnom" pitanju ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Ažuriraj podešavanja testa';
$string['updatingatttemptgrades'] = 'Ažuriranje ocena pokušaja';
$string['updatingfinalgrades'] = 'Ažuriranje konačnih ocena';
$string['updatingthegradebook'] = 'Ažuriranje knjige ocena';
$string['upgradesure'] = '<div>Modul \'Test\' će izvesti obimne promene tabela sa testovima u bazi podataka. Ova nadogradnja još uvek nije dovoljno testirana. Pre nego što nastavite strogo vam preporučujemo da napravite rezervnu kopiju vaše baze podataka.</div>';
$string['upgradingquizattempts'] = 'Nadogradnja pokušaja rešavanja testa: test {$a->done}/{$a->outof} (Identifikator testa {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Nadogradnja vrlo starih pokušaja rešavanja testa: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Nakon brisanja kursa, ova kategorija je sačuvana i premeštena na nivo sajta, zbog toga što se pitanja iz ove kategorije koriste u testovima drugih kurseva.';
$string['useroverrides'] = 'Izmene podešavanja za korisnike';
$string['useroverridesdeleted'] = 'Izmene podešavanja za korisnike obrisane';
$string['usersnone'] = 'Nijedan polaznik nema pristup ovom testu';
$string['validate'] = 'Proveri';
$string['viewallanswers'] = 'Prikaz {$a} pokušaja rešavanja testa';
$string['viewallreports'] = 'Pogledaj izveštaje za {$a} pokušaja';
$string['viewed'] = 'Pregledano';
$string['warningmissingtype'] = '<b>Ovo pitanje pripada tipu koji još uvek nije instaliran na vašem Moodleu.<br />Molimo obavestite svog Moodle administratora.</b>';
$string['wheregrade'] = 'Gde je moja ocena?';
$string['wildcard'] = 'Džoker znak';
$string['windowclosing'] = 'Ovaj prozor će se ubrzo zatvoriti.';
$string['withsummary'] = 'sa sumarnom statistikom';
$string['wronguse'] = 'Ne možete tako da koristite ovu stranicu';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Potrebno je da se upišete na ovaj kurs pre nego što pokušate rešavanje ovog testa';
$string['yourfinalgradeis'] = 'Vaša konačna ocena na ovom testu je {$a}.';
