<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'tr', version '4.4'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'D';
$string['Afull'] = 'Devamsız';
$string['Eacronym'] = 'M';
$string['Efull'] = 'Mazeretli';
$string['Lacronym'] = 'G';
$string['Lfull'] = 'Geç';
$string['Pacronym'] = 'M';
$string['Pfull'] = 'Mevcut';
$string['absenteereport'] = 'Devamsızlık raporu';
$string['acronym'] = 'Kısaltma';
$string['add'] = 'Ekle';
$string['addedrecip'] = '{$a} yeni alıcı eklendi';
$string['addedrecips'] = '{$a} yeni alıcı eklendi';
$string['addmultiplesessions'] = 'Çoklu oturum';
$string['addsession'] = 'Oturum ekle';
$string['adduser'] = 'Kullanıcı ekle';
$string['addwarning'] = 'Uyarı ekle';
$string['all'] = 'Tümü';
$string['allcourses'] = 'Tüm Kurslar';
$string['allowupdatestatus'] = 'Öğrencilerin kendi devamsızlık bilgilerini güncellemelerin izin verin';
$string['allowupdatestatus_desc'] = 'Seçili olması durumunda, öğrenciler oturum sona erdikten sonra devam durumlarını kendiler raporlayabilirler.';
$string['allowupdatestatus_help'] = 'Seçili olması durumunda, öğrenciler oturum sona erdikten sonra devam durumlarını kendiler raporlayabilirler.';
$string['allpast'] = 'Tüm geçmiş';
$string['allsessions'] = 'Tüm oturumlar';
$string['allsessionstotals'] = 'Seçilen oturumlar için toplamlar';
$string['attendance:addinstance'] = 'Yeni bir yoklama etkinliği ekle';
$string['attendance:canbelisted'] = 'Listede görünüyor';
$string['attendance:changeattendances'] = 'Yoklamaları Değiştir';
$string['attendance:changepreferences'] = 'Tercihleri Değiştirme';
$string['attendance:export'] = 'Raporları dışa aktar';
$string['attendance:import'] = 'Oturum bilgilerinin  (cvs) dosyasından içe aktar';
$string['attendance:manageattendances'] = 'Yoklamaları Yönet';
$string['attendance:managetemporaryusers'] = 'Geçici kullanıcıları yönet';
$string['attendance:manualautomark'] = 'Manuel otomatik işaretleme işlemine izin ver';
$string['attendance:takeattendances'] = 'Yoklama al';
$string['attendance:view'] = 'Yoklamaları Görüntüle';
$string['attendance:viewreports'] = 'Raporları Görüntüleme';
$string['attendance:viewsummaryreports'] = 'Kurs roporu özetiin görüntüle';
$string['attendance:warningemails'] = 'Devamsız öğrencilerde e-posta listelerine abona olabilsin';
$string['attendance_already_submitted'] = 'Yoklamanız zaten ayarlanmış';
$string['attendance_no_status'] = 'Geçerli bir durum mevcut değildi - yoklamayı kaydetmek için çok geç kalmış olabilirsiniz.';
$string['attendancedata'] = 'Yoklama verileri';
$string['attendancefile'] = 'Yoklama dosyası (csv biçimi)';
$string['attendancefile_help'] = 'Dosya, bir başlık satırı ve kullanıcıyı ve katılımın kaydedildiği zamanı tanımlamak için alanlar içeren bir CSV dosyası olmalıdır, örneğin (e-posta,taramazamanı) veya (kullanıcıadı,zaman)';
$string['attendancegrade'] = 'Devam notu';
$string['attendancenotset'] = 'Yoklama durumunuzu ayarlamanız gerekiyor';
$string['attendancenotstarted'] = 'Bu ders için henüz yoklama yapılmadı';
$string['attendancepercent'] = 'Devam Yüzdesi';
$string['attendancereport'] = 'Yoklama';
$string['attendanceslogged'] = 'Yoklama kayıtları';
$string['attendancestaken'] = 'Alınan yoklamalar';
$string['attendancesuccess'] = 'Yoklama başarıyla alındı';
$string['attendanceupdated'] = 'Yoklama başarıyla güncellendi';
$string['attendanceuserreport'] = 'Yoklama Raporu';
$string['attforblockdirstillexists'] = 'Eski mod/attforblock dizini mevcut - bu yükseltmeyi çalıştırmadan önce bu dizini sunucunuzdan silmelisiniz.';
$string['attrecords'] = 'Yoklama Kayıtlar';
$string['autoassignstatus'] = 'Mevcut en yüksek durumu otomatik olarak seç';
$string['autoassignstatus_help'] = 'Bu seçilirse, öğrencilere otomatik olarak mevcut en yüksek not atanacaktır.';
$string['automark'] = 'Otamatik İşaretleme';
$string['automark_help'] = 'İşaretlemenin otomatik olarak tamamlanmasına izin verir.
"Evet" seçilirse öğrenciler kursa ilk erişimlerine bağlı olarak otomatik olarak "var" olarak işaretlenecektir.
"Oturum sonunda işaretlenmemiş olarak ayarla" seçilirse yoklamalarını işaretlememiş olan tüm öğrenciler seçilen "yok" olarak işaretlenecektir.';
$string['automarkall'] = 'Evet';
$string['automarkclose'] = 'Oturum sonunda işaretlenmemiş olarak ayarla';
$string['automarkingcomplete'] = 'Otomatik işaretleme tamamlandı';
$string['automarkingnotavailableyet'] = 'Bu oturum, oturum kapatıldığında otomatik işaretlemeyi kullanıyor ve oturum henüz sona ermedi.';
$string['automarkingnotenabled'] = 'Bu oturumda otomatik işaretleme etkin değil';
$string['automarktask'] = 'Otomatik işaretleme gerektiren yoklama oturumlarını kontrol edin';
$string['automarkuseempty'] = 'Otomatik işaretleme durumu kullanılabilirliği yönetimi';
$string['automarkuseempty_desc'] = 'İşaretlenirse, otomatik işaretleme sırasında boş/ayarlanmamış "kullanılabilir" ayarına sahip durum öğelerine izin verilir';
$string['autorecorded'] = 'sistem otomatik olarak kaydedildi';
$string['availability'] = 'Kendinden işaretlemenin kullanılabilirliği';
$string['availability_help'] = 'Bu durumun kullanılabilirliğini kısıtlayın. <br> "Sınırlı" seçeneği işaretlenmişse, oturum başladıktan sonra bu durumun kaç dakika süreyle mevcut olduğunu belirtin. Bu, öğrenciler kendi yoklamalarını işaretlediğinde geçerlidir.';
$string['availabilityalways'] = 'Her zaman';
$string['availabilitylimitedtime'] = 'Sınırlı süre';
$string['availabilityno'] = 'Hayır';
$string['availablebeforesession'] = 'Oturum başlamadan önce kullanılabilir';
$string['availablebeforesession_help'] = 'Öğrenciler kendi yoklamalarını kaydederken, oturum başlamadan önce bu durumun seçilmesine izin verin.';
$string['averageattendance'] = 'Ortalama devam';
$string['averageattendancegraded'] = 'Ortalama devam';
$string['backtoparticipants'] = 'Katılımcı listesine geri dön';
$string['below'] = '%{$a} altında';
$string['calclose'] = 'Kapalı';
$string['calendarevent'] = 'Oturum için takvim etkinliği oluştur';
$string['calendarevent_help'] = 'Etkinleştirilirse, bu oturum için bir takvim etkinliği oluşturulur.
Devre dışı bırakılırsa, bu oturum için mevcut tüm takvim etkinlikleri silinecektir.';
$string['caleventcreated'] = 'Oturum için takvim etkinliği başarıyla oluşturuldu';
$string['caleventdeleted'] = 'Oturum için takvim etkinliği başarıyla silindi';
$string['calmonths'] = 'Oturum için takvim etkinliği başarıyla oluşturuldu';
$string['calshow'] = 'tarih seç';
$string['calweekdays'] = 'Pz,Pzt,Sa,Çar,Per,Cu,Cmt';
$string['cannottakeforgroup'] = '"{$a}" grubuna yoklama alamazsınız';
$string['cannottakethisgroup'] = 'Bu yoklamaoturumunun ilgili olduğu kurs grubunun bir üyesi değilsiniz, devamdurumunuz kaydedilmedi.';
$string['cantaddstatus'] = 'Yeni bir durum eklerken bir kısaltma ve açıklama belirlemelisiniz.';
$string['canthidestatus'] = 'Bu yoklama etkinliğinde zaten kullanımda olduğu için bu durumu gizleyemezsiniz.';
$string['categoryreport'] = 'Kurs kategorisi raporu';
$string['changeattendance'] = 'Yoklamayı değiştir';
$string['changeduration'] = 'Süreyi değiştir';
$string['changesession'] = 'Oturumu değiştir';
$string['checkweekdays'] = 'Seçtiğiniz oturum tarih aralığına denk gelen hafta içi günleri seçin.';
$string['closed'] = 'Bu oturum şu anda otomatik işaretleme için uygun değil';
$string['column'] = 'sütun';
$string['columnmap'] = 'Sütün eşleme';
$string['columnmap_help'] = 'Sunulan alanların her biri için csv dosyasında karşılık gelen sütunu seçin.';
$string['columns'] = 'sütunlar';
$string['commonsession'] = 'Tüm öğrenciler';
$string['commonsessions'] = 'Tüm öğrenciler';
$string['confirm'] = 'Onaylama';
$string['confirmcolumnmappings'] = 'Sütun eşlemelerini onaylayın';
$string['confirmdeletehiddensessions'] = 'Kurs başlangıç tarihinden ({$a->date}) önce planlanmış {$a->count} oturumu silmek istediğinizden emin misiniz?';
$string['confirmdeleteuser'] = '\'{$a->fullname}\' ({$a->email}) adlı kullanıcıyı silmek istediğinizden emin misiniz?<br/>Tüm katılım kayıtları kalıcı olarak silinecek.';
$string['copyfrom'] = 'Yoklama verilerini şuradan kopyala:';
$string['countofselected'] = 'Seçilen sayısı';
$string['course'] = 'Kurs';
$string['coursemessage'] = 'Kurs kullanıcılarına Mesaj';
$string['courseshortname'] = 'Kursun kısa adı';
$string['coursesummary'] = 'Kurs Özet raporu';
$string['createmultiplesessions'] = 'Birden çok oturum oluştur';
$string['createmultiplesessions_help'] = 'Bu işlev, tek bir basit adımda birden çok oturum oluşturmanıza olanak tanır.
Oturumlar temel oturumun tarihinde başlar ve "sonraki" tarihe kadar devam eder.

   * <strong>Tekrarla</strong>: Haftanın sınıfınızın toplanacağı günleri seçin (örneğin, Pazartesi/Çarşamba/Cuma).
   * <strong>Tekrar sıklığı</strong>: Bu, bir sıklık ayarına izin verir.  Sınıfınız her hafta toplanacaksa 1\'i seçin;  iki haftada bir toplanacaksa 2\'yi seçin;  her 3 haftada bir, 3\'ü seçin, vb.
   * <strong>Geçene kadar tekrarla</strong>: Dersin son gününü seçin (yoklama almak istediğiniz son gün).';
$string['createonesession'] = 'Kurs için bir oturum oluşturun';
$string['csvdelimiter'] = 'CSV sınırlayıcı';
$string['currentlyselectedusers'] = 'Şu anda seçili kullanıcılar';
$string['customexportfields'] = 'Özel kullanıcı profili alanlarını dışa aktar';
$string['customexportfields_help'] = 'Dışa aktarma raporunda gösterilecek ekstra özel kullanıcı profili alanları.';
$string['customfields'] = 'Özel oturum ayarları';
$string['date'] = 'Tarih';
$string['days'] = 'Günler';
$string['defaultdisplaymode'] = 'Varsayılan ekran modu';
$string['defaults'] = 'Varsayılanlar';
$string['defaultsessionsettings'] = 'Varsayılan oturum ayarları';
$string['defaultsessionsettings_help'] = 'Bu ayarlar, tüm yeni oturumlar için varsayılanları tanımlar.';
$string['defaultsettings'] = 'Varsayılan katılım ayarları';
$string['defaultsettings_help'] = 'Bu ayarlar, tüm yeni yoklamalar için varsayılanları tanımlar.';
$string['defaultstatus'] = 'Varsayılan durum seti';
$string['defaultsubnet'] = 'varsayılan ağ adresi';
$string['defaultsubnet_help'] = 'Yoklama kaydı, kısmi veya tam IP adreslerinin virgülle ayrılmış bir listesi belirtilerek belirli alt ağlarla sınırlandırılabilir. Bu, yeni oturumlar oluşturulurken kullanılan varsayılan değerdir.';
$string['defaultview'] = 'Girişt yapıldığında varsayılan görünüm';
$string['defaultview_desc'] = 'Bu, öğretmenlere ilk girişte gösterilen varsayılan görünümdür.';
$string['defaultwarnings'] = 'Varsayılan uyarı seti';
$string['defaultwarningsettings'] = 'Varsayılan uyarı ayarları';
$string['defaultwarningsettings_help'] = 'Bu ayarlar, tüm yeni uyarılar için varsayılanları tanımlar.';
$string['delete'] = 'Sil';
$string['deletecheckfull'] = 'Tüm kullanıcı verileri dahil olmak üzere {$a}\'yı tamamen silmek istediğinizden kesinlikle emin misiniz?';
$string['deletedgroup'] = 'Bu oturumla ilişkili grup silindi';
$string['deletehiddensessions'] = 'Tüm gizli oturmları sil';
$string['deletelogs'] = 'Yoklama verilerini sil';
$string['deleteselected'] = 'Seçileni Sil';
$string['deletesession'] = 'Oturumu sil';
$string['deletesessions'] = 'Tüm oturumları sil';
$string['deleteuser'] = 'Kullanıcı silindi';
$string['deletewarningconfirm'] = 'Bu uyarıyı silmek istediğinizden emin misiniz?';
$string['deletingsession'] = 'Kurs için oturum siliniyor';
$string['deletingstatus'] = 'Kursun durumu siliniyor';
$string['description'] = 'Açıklama';
$string['display'] = 'Görüntüleme';
$string['displaymode'] = 'Görüntüleme modu';
$string['donotusepaging'] = 'Sayfalamayı kullanmayın';
$string['downloadexcel'] = 'Excel biçiminde indir';
$string['downloadooo'] = 'LibreOffice biçiminde İndir';
$string['downloadtext'] = 'Metin biçiminde indir';
$string['duration'] = 'Süre';
$string['editsession'] = 'Oturumu Düzenle';
$string['edituser'] = 'Kullanıcıyı düzenle';
$string['emailcontent'] = 'E-Posta içeriğ';
$string['emailcontent_default'] = 'Merhaba %kullaniciadi%,
%coursename% %attendancename%\'deki katılımınız %warningpercent%\'in altına düştü ve şu anda %percent% - umarız iyisinizdir!

Bu kurstan en iyi şekilde yararlanmak için katılım oranınızı artırmalısınız, daha fazla desteğe ihtiyacınız olursa lütfen iletişime geçin.';
$string['emailcontent_help'] = 'Bir öğrenciye uyarı gönderildiğinde, e-posta içeriği bu alandan alınır. Aşağıdaki joker kartlar kullanılabilir:
ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Eposta Konu';
$string['emailsubject_default'] = 'Devamsızlık uyarısı';
$string['emailsubject_help'] = 'Öğrenciye uyarı gönderildiğinde e-posta konusunu bu alandan alır.';
$string['emailuser'] = 'Eposta kullanıcı';
$string['emailuser_help'] = 'Seçilmesi durumunda öğrenciye uyarı gönderilir.';
$string['emptyacronym'] = 'Boş kısaltmalara izin verilmiyor. Durum kaydı güncellenmedi.';
$string['emptydescription'] = 'Boş açıklamalara izin verilmiyor. Durum kaydı güncellenmedi.';
$string['enablecalendar'] = 'Takvim etkinlikleri oluştur';
$string['enablecalendar_desc'] = 'Etkinleştirilirse, her katılım oturumu için bir takvim etkinliği oluşturulur. Bu ayarı değiştirdikten sonra takvim sıfırlama raporunu çalıştırmalısınız.';
$string['enablewarnings'] = 'Uyarıları etkinleştir';
$string['enablewarnings_desc'] = 'Bu, yoklama için bir uyarı setinin tanımlanmasına ve katılım yapılandırılan eşiğin altına düştüğünde kullanıcılara e-posta bildirimlerine izin verir. <br/><strong>UYARI: Bu yeni bir özelliktir ve kapsamlı bir şekilde test edilmemiştir. Lütfen riski size ait olacak şekilde kullanın ve işe yaradığını düşünüyorsanız moodle forumlarında geri bildirimde bulunun.</strong>';
$string['encoding'] = 'Kodlama';
$string['encoding_help'] = 'Bu, öğrencilerin kimlik kartında kullanılan barkod kodlama türünü ifade eder. Genel barkod kodlama şemaları Code-39, Code-128 ve UPC-A\'yı içerir.';
$string['endofperiod'] = 'Dönem sonu';
$string['endtime'] = 'Oturum bitiş zamanı';
$string['enrolmentend'] = 'Kullanıcı kaydı {$a} sona erer';
$string['enrolmentstart'] = 'Kullanıcı kaydı başlar {$a}';
$string['enrolmentsuspended'] = 'Kurs kaydı askıya alındı';
$string['enterpassword'] = 'Şifreyi gir';
$string['error:coursehasnoattendance'] = '{$a} kısa adlı kursun yoklama etkinliği yok.';
$string['error:coursenotfound'] = '{$a} kısa adına sahip bir kurs bulunamadı.';
$string['error:qrcode'] = 'Öğrencilerin kendi katılımını kaydetmelerine izin ver QR kodunu kullanmak için etkinleştirilmelidir! Atlanıyor.';
$string['error:sessioncourseinvalid'] = 'Kurs oturumu geçersiz Atlanıyor';
$string['error:sessiondateinvalid'] = 'Oturum tarihi geçersiz. Atlanıyor';
$string['error:sessionendinvalid'] = 'Oturum bitisi ve süresi  geçersiz. Atlanıyor';
$string['error:sessionstartinvalid'] = 'Oturum başlangıcı  geçersiz. Atlanıyor';
$string['error:statusnotfound'] = 'Kullanıcı: {$a->extuser}, bulunamayan bir durum değerine sahip: {$a->status}';
$string['error:timenotreadable'] = 'Kullanıcı: {$a->extuser}, strtotime tarafından dönüştürülemeyen bir tarama süresine sahip: {$a->scantime}';
$string['error:userduplicate'] = '{$a} kullanıcısı, içe aktarmada iki kez bulundu. lütfen kullanıcı başına yalnızca bir kayıt ekleyin.';
$string['error:usernotfound'] = '{$a->userfield}, {$a->extuser} olarak ayarlanmış bir kullanıcı bu kursta bulunamadı';
$string['errorgroupsnotselected'] = 'Bir veya daha fazla grup seç';
$string['errorinaddingsession'] = 'Oturum eklenirken hata oluştu';
$string['erroringeneratingsessions'] = 'Oturum oluşturulurken hata oluştudr';
$string['eventdurationupdated'] = 'Oturum süresi güncellendi';
$string['eventreportviewed'] = 'Devam raporu görüntülendi';
$string['eventscreated'] = 'Takvim etkinlikleri oluşturuldu';
$string['eventsdeleted'] = 'Takvim etkinlikleri silindi';
$string['eventsessionadded'] = 'Oturum eklendi';
$string['eventsessiondeleted'] = 'Oturum silindi';
$string['eventsessionipshared'] = 'Yoklama kendi kendini işaretleme de  IP çakışması tespit edildi';
$string['eventsessionsimported'] = 'Oturum içe aktadrıldı';
$string['eventsessionupdated'] = 'Oturum günellendi';
$string['eventstatusadded'] = 'Oturum eklendi';
$string['eventstatusupdated'] = 'Durum güncllendi';
$string['eventstudentattendancesessionsupdated'] = 'Oturum raporu silindi';
$string['eventstudentattendancesessionsviewed'] = 'oturum roparu görüntülendi';
$string['eventtaken'] = 'Yoklama alındı';
$string['eventtakenbystudent'] = 'Öğrenci tarafından alınan yoklama';
$string['export'] = 'Dışa aktar';
$string['extrarestrictions'] = 'Ekstra kısıtlamalar';
$string['formattexttype'] = 'Biçimlendirme';
$string['from'] = 'şundan:';
$string['gradebookexplanation'] = 'Not defterinde not verme';
$string['gradebookexplanation_help'] = 'Devam modülü, bugüne kadar kazandığınız puan sayısına ve bugüne kadar kazanılmış olabilecek puan sayısına göre mevcut devam notunuzu görüntüler;  ilerideki ders dönemlerini kapsamaz.  Not defterinde yoklama notunuz, mevcut devam yüzdenize ve gelecekteki ders dönemleri de dahil olmak üzere kursun tüm süresi boyunca kazanılabilecek puan sayısına bağlıdır.  Bu nedenle, Yoklama modülünde ve not defterinde görüntülenen yoklama notlarınız aynı puan olmayabilir, ancak aynı yüzdedir.

Örneğin, bugüne kadar 10 puandan 8\'ini aldıysanız (%80 katılım) ve tüm kursa katılım 50 puan değerindeyse, Yoklama modülü 8/10 ve not defteri 40/50 olarak görüntülenecektir. Henüz 40 puan kazanmadınız ancak 40, mevcut katılım yüzdenizin %80\'ine eşdeğer puan değeridir. Devam modülünde kazandığınız puan değeri, sadece bugüne kadar devama dayalı olduğu için asla azalmaz; ancak not defterinde gösterilen yoklama puanı değeri, tüm kursa katılımı temel aldığından gelecekteki katılımınıza bağlı olarak artabilir veya azalabilir.';
$string['graded'] = 'Not verilen oturumlar';
$string['gridcolumns'] = 'Klavuz sutunları';
$string['group'] = 'Grup';
$string['groups'] = 'Gruplar';
$string['groupsession'] = 'Öğrenci grupları';
$string['groupsessionsby'] = 'Oturumlara göre gruplar';
$string['hiddensessions'] = 'Gizli oturumlar';
$string['hiddensessions_help'] = 'Kurs başlangıç tarihinden önce planlanırsa oturumlar gizlenir.

 Eski oturumları silmek yerine gizlemek için bu özelliği kullanabilirsiniz.  Not Defteri\'nde yalnızca görünür oturumlar görünecektir.';
$string['hiddensessionsdeleted'] = 'Tüm gizli oturumlar silindi';
$string['hideextrauserdetails'] = 'Ekstra kullanıcı ayrıntılarını gizle';
$string['hidensessiondetails'] = 'Oturum ayrıntılarını gizle';
$string['identifyby'] = 'Öğrenciyi şuna göre tanımla:';
$string['import'] = 'İçe aktar';
$string['importfile'] = 'Dosyayı içe aktar';
$string['importfile_help'] = 'Dosyayı içe aktar';
$string['importsessions'] = 'Oturumları içe aktar';
$string['importstatus'] = 'Durum alanı';
$string['importstatus_help'] = 'Bu, bir durum değerinin içe aktarmaya dahil edilmesini sağlar - örneğin P, L veya A gibi değerler';
$string['includeabsentee'] = 'Devamsızlık raporu hesaplanırken oturumu dahil et';
$string['includeabsentee_help'] = 'Seçilmesi durumunda, bu oturum devamsızlık raporu hesaplamalarına dahil edilecektir.';
$string['includeall'] = 'Tüm oturumları seç';
$string['includedescription'] = 'Oturum açıklamasını ekle';
$string['includenottaken'] = 'Katılım sağlanmayan oturumları da dahil et';
$string['includeqrcode'] = 'QR kodunu dahil et';
$string['includeremarks'] = 'Açıklamaları dahil et';
$string['incorrectpassword'] = 'Yanlış bir şifre girdiniz ve katılımınız kaydedilmedi, lütfen doğru şifreyi girin.';
$string['incorrectpasswordshort'] = 'Yanlış şifre, yoklama kaydedilmedi.';
$string['indetail'] = 'Detayında....';
$string['indicator:cognitivedepth'] = 'Katılım bilişsel';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, öğrencinin bir Katılım faaliyetinde ulaştığı bilişsel derinliğe dayanmaktadır.';
$string['indicator:cognitivedepthdef'] = 'Katılım bilişsel';
$string['indicator:cognitivedepthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında Yoklama tarafından sunulan bilişsel katılımın bu yüzdesine ulaştı (Düzeyler = Görüntüleme yok, Görüntüleme)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Katılım sosyal';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, öğrencinin bir Yoklama etkinliğinde ulaştığı sosyal genişliğe dayalıdır.';
$string['indicator:socialbreadthdef'] = 'Katılım sosyal';
$string['indicator:socialbreadthdef_help'] = 'Katılımcı, bu analiz aralığı sırasında Yoklama tarafından sunulan sosyal katılımın bu yüzdesine ulaştı (Seviyeler = Katılım yok, Yalnızca Katılımcı)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Bir eylem seçmelisiniz';
$string['invalidemails'] = 'Mevcut kullanıcı hesaplarının adreslerini belirtmelisiniz, {$a}: bulunamadı';
$string['invalidimportfile'] = 'Dosya biçimi geçersiz.';
$string['invalidsessionenddate'] = 'Bu tarih oturum başlangıç tarihinden önce olamaz';
$string['invalidsessionendtime'] = 'Bitiş zamanı, başlangıç zamanından büyük olmalıdır';
$string['invalidstatus'] = 'Geçersiz bir durum seçtiniz, lütfen tekrar deneyin';
$string['iptimemissing'] = 'Serbest bırakmak için geçersiz dakika';
$string['jumpto'] = 'Şuraya atla';
$string['keepsearching'] = 'Aramayı devam et';
$string['lasttaken'] = 'En son alınan yoklama sayısı';
$string['manualtriggerauto'] = 'Otomatik işaretlemeyi manuel olarak tetikleyin';
$string['marksessionimportcsvhelp'] = 'Bu form, bir kullanıcı tanımlayıcısı ve bir durum içeren bir csv dosyası yüklemenize olanak tanır - durum alanı, durum kısaltması veya o kullanıcı için yoklamanın kaydedildiği zaman olabilir. Bir zaman değeri geçilirse, o zaman mevcut olan en yüksek nota sahip durum değerini atamaya çalışacaktır.';
$string['maxpossible'] = 'Mümkün olan en yüksek';
$string['maxpossible_help'] = 'Henüz alınmamış her oturumda (geçmiş ve gelecek) maksimum puanı alan her kullanıcının ulaşabileceği puanı gösterir:
<ul>
<li><strong>Puan</strong>: her kullanıcının tüm oturumlarda ulaşabileceği maksimum puan.</li>
<li><strong>Yüzde</strong>: her kullanıcının tüm oturumlarda ulaşabileceği maksimum yüzde.</li>
</ul>';
$string['maxpossiblepercentage'] = 'Mümkün olan en yüksek yüzde';
$string['maxpossiblepoints'] = 'Mümkün olan en yüksek puan';
$string['maxwarn'] = 'Maksimum sayıda e-posta uyarısı';
$string['maxwarn_help'] = 'Bir uyarının gönderilmesi gereken maksimum sayı (oturum başına yalnızca bir uyarı gönderilir)';
$string['mergeuser'] = 'Kullanıcıyı birleştir';
$string['messagedselecteduserfailed'] = 'Bir veya daha fazla kullanıcıya mesaj gönderilemedi. Daha fazla bilgi almak için lütfen hata ayıklamayı açın.';
$string['mobilesessionfrom'] = 'Bir öncekinden daha eski oturumları göster';
$string['mobilesessionfrom_help'] = 'Uygulamada işaretleme yaparken oturum listesinin kısıtlanmasına izin verir - yalnızca bu tarihten sonra başlayan oturumları gösterir';
$string['mobilesessionto'] = 'Gelecek oturumları göster';
$string['mobilesessionto_help'] = 'Oturum listesinin yalnızca az sayıda gelecek oturumu gösterecek şekilde kısıtlanmasını sağlar.';
$string['mobilesettings'] = 'Mobil uygulama ayarları';
$string['mobilesettings_help'] = 'Bu ayarlar, Moodle mobil uygulama davranışını kontrol eder';
$string['modulename'] = 'Yoklama';
$string['modulename_help'] = 'Yoklama etkinliği modülü, öğretmenin ders sırasında yoklama almasını ve öğrencilerin kendi yoklama kayıtlarını görüntülemelerini sağlar.

Öğretmen birden fazla oturum oluşturabilir ve yoklama durumunu "Var", "Yok", "Geç" veya "Mazeretli" olarak işaretleyebilir veya durumları kendi ihtiyaçlarına göre değiştirebilir.

Tüm sınıf veya tek tek öğrenciler için raporlar mevcuttur.';
$string['modulenameplural'] = 'Yoklamalar';
$string['months'] = 'Ay';
$string['moreattendance'] = 'Bu sayfa için katılım başarıyla alındı';
$string['moveleft'] = 'Sola hareket et';
$string['moveright'] = 'Sağa hareket et';
$string['multisessionexpanded'] = 'Çoklu oturumlar genişletildi';
$string['multisessionexpanded_desc'] = 'Yeni oturumlar oluştururken "Birden çok oturum" ayarlarını varsayılan olarak genişletilmiş olarak gösterin.';
$string['mustselectusers'] = 'Dışa aktarılacak kullanıcıları seçmelisiniz';
$string['name'] = 'İsim';
$string['newdate'] = 'Yeni tarih';
$string['newduration'] = 'Yeni sure';
$string['newstatusset'] = 'Yeni durum ayarı';
$string['noabsentstatusset'] = 'Kullanımda ayarlanan durum, işaretlenmediğinde kullanılacak bir duruma sahip değildir.';
$string['noattendanceusers'] = 'Kursa kayıtlı öğrenci olmadığı için herhangi bir veriyi dışa aktarmak mümkün değildir.';
$string['noattforuser'] = 'Kullanıcı için yoklama kaydı yok';
$string['noautomark'] = 'Devre dışı';
$string['nocapabilitytotakethisattendance'] = 'Değiştirme izninizin olmadığı cmid: {$a} ile bir oturumun katılımını değiştirmeye çalıştınız.';
$string['nodescription'] = 'Normal sınıf oturumu';
$string['noeventstoreset'] = 'Güncelleme gerektiren takvim etkinliği yok.';
$string['nogroups'] = 'Bu etkinlik, grupları kullanacak şekilde ayarlandı, ancak kursta hiç grup yok.';
$string['noguest'] = 'Misafir katılımı göremiyor';
$string['noofdaysabsent'] = 'Devamsızlık gün sayısı';
$string['noofdaysexcused'] = 'İzin verilen gün sayısı';
$string['noofdayslate'] = 'Geç kalan gün sayısı';
$string['noofdayspresent'] = 'mevcut gün sayısı';
$string['nosessiondayselected'] = 'Oturum günü seçilmedi';
$string['nosessionexists'] = 'Bu kurs için Oturum yok';
$string['nosessionsselected'] = 'Oturum seçilmedi';
$string['notfound'] = 'Bu kursta yoklama etkinliği bulunamadı!';
$string['notifytask'] = 'Kullanıcılara uyarı gönder';
$string['notmember'] = '';
$string['notset'] = 'ayarlanmadı';
$string['nounmarkedstatusset'] = 'Bu oturum için (id:{$a->sessionid}) işaretlenmemiş bir durum yapılandırılmamış, bu durumu düzeltmek için <a href="{$a->url}">Durum ayarını</a> güncelleyin';
$string['noupgradefromthisversion'] = 'Yoklama modülü, yüklediğiniz attforblock sürümünden yükseltilemez. - yeni̇ yoklama modülünü yüklemeden önce lütfen attforblock\'u si̇li̇n veya en son sürüme yükselti̇n';
$string['numsessions'] = 'Oturum sayısı';
$string['numsessionstaken'] = 'Alınan oturum sayısı';
$string['olddate'] = 'Eski tarih';
$string['onactivitycompletion'] = 'Etkinlik tamamlandığında';
$string['onlyselectedusers'] = 'Belirli kullanıcıları dışa aktarın';
$string['overallsessions'] = 'Tüm oturumlarda';
$string['overallsessions_help'] = 'Henüz alınmamış olanlar (geçmiş ve gelecek) dahil olmak üzere tüm oturumların istatistiklerini gösterir:
     <ul>
     <li><strong>Oturum</strong>: toplam oturum sayısı.</li>
     <li><strong>Puan</strong>: Alınan oturumlara göre verilen puanlar.</li>
     <li><strong>Yüzde</strong>: Tüm oturumlar için mümkün olan maksimum puan üzerinden verilen puanların yüzdesi.</li>
     </ul>';
$string['oversessionstaken'] = 'Alınan oturumlar';
$string['oversessionstaken_help'] = 'Katılımın alındığı oturumların istatistiklerini gösterir:
<ul>
<li> <strong> Sessions </strong>: Daha önce alınan oturum sayısı.</li>
<li> <strong> Points </strong>: Alınan oturumlara göre verilen puanlar.</li>
<li> <strong> Percent </strong>: Alınan oturumların maksimum puan üzerinden verilen puanların yüzdesi.</li>
</ul>';
$string['pageof'] = '{$a->numpages} sayfadan {$a->sayfa} sayfa';
$string['participant'] = 'Katılımcı';
$string['password'] = 'Şifre';
$string['passwordgrp'] = 'Öğrenci şifrresi';
$string['passwordgrp_help'] = 'Ayarlanırsa, oturum için kendi katılım durumlarını ayarlayabilmeleri için öğrencilerin bu parolayı girmeleri istenecektir. Boş olması durumunda, parola gerekmez.';
$string['passwordheader'] = 'Yoklama almak için aşağıda listelenen şifreyi kullanın';
$string['passwordrequired'] = 'Yoklama göndermeden önce oturum şifresini girmelisiniz.';
$string['percentage'] = 'Yüzde';
$string['percentageallsessions'] = 'Alınan oturumların yüzdesi';
$string['percentagesessionscompleted'] = 'Alınan oturumların yüzdesi';
$string['pluginadministration'] = 'Yoklama yönetimi';
$string['pluginname'] = 'Yoklama';
$string['points'] = 'Puan';
$string['pointsallsessions'] = 'Tüm oturumlardaki puanlar';
$string['pointssessionscompleted'] = 'Alınan oturumlar boyunca alınan puanlar';
$string['preferences_desc'] = 'Durum ayarlarında yapılan değişiklikler mevcut katılım oturumlarını ve değerlendirmeyi de etkileyebilecektir.';
$string['preventsharederror'] = 'Bu cihaz başka bir öğrencinin yoklamasını kaydetmek için kullanılmış gibi göründüğünden bir oturum için kendi kendine işaretleme devre dışı bırakılmıştır.';
$string['preventsharedip'] = 'Öğrencilerin IP adresini paylaşmasını engelle';
$string['preventsharedip_help'] = 'Öğrencilerin aynı cihazı (IP adresi kullanılarak tanımlanmış) başka öğrencilerin yoklamasını almak için kullanmasını engelleyin.';
$string['preventsharediptime'] = 'IP adresinin yeniden kullanımına izin verme süresi (dakika)';
$string['preventsharediptime_help'] = 'Bu süre geçtikten sonra bu oturuma katılım almak için bir IP adresinin yeniden kullanılmasına izin verin.';
$string['preview'] = 'Dosya önizleme';
$string['previewhtml'] = 'HTML biçimi önizlemesi';
$string['priorto'] = 'Oturum tarihi, kurs başlangıç tarihinden ({$a}) öncedir, dolayısıyla bu tarihten önce planlanan yeni oturumlar gizlenir (erişilemez). Önceki oturumlara erişmek için kurs başlangıç tarihini istediğiniz zaman değiştirebilirsiniz (kurs ayarlarına bakın).<br><br>Lütfen oturum tarihini değiştirin veya onaylamak için tekrar "Oturum ekle" düğmesini tıklayın.';
$string['privacy:metadata:attendancelog'] = 'Kaydedilen kullanıcı katılımlarının günlüğü.';
$string['privacy:metadata:attendancesessions'] = 'Katılımın kaydedileceği oturumlar.';
$string['privacy:metadata:attendancewarningdone'] = 'Kullanıcılara katılım kayıtları üzerinden gönderilen uyarıların günlük dosyası kayıtları';
$string['privacy:metadata:duration'] = 'Saniye cinsinden oturum süresi';
$string['privacy:metadata:groupid'] = 'Oturumla ilişkili grup kimliği.';
$string['privacy:metadata:ipaddress'] = 'IP adresi katılımı ile işaretlendi.';
$string['privacy:metadata:lasttaken'] = 'Oturum devam durumunu en son alındığı zaman damgası.';
$string['privacy:metadata:lasttakenby'] = 'Bu oturuma katılım sağlayan son kullanıcının kullanıcı kimliği';
$string['privacy:metadata:notifyid'] = 'Yoklama oturumu uyarısının ilişkili olduğu kimlik.';
$string['privacy:metadata:remarks'] = 'Kullanıcının katılımıyla ilgili yorumlar.';
$string['privacy:metadata:sessdate'] = 'Oturumun başladığı zaman damgası.';
$string['privacy:metadata:sessionid'] = 'Yoklam oturum kimliği.';
$string['privacy:metadata:statusid'] = 'Öğrencinin yoklama durumu kimliği.';
$string['privacy:metadata:statusset'] = 'Durum kimliğinin ait olduğu durum dizini.';
$string['privacy:metadata:studentid'] = 'Devamsızlık kaydı bulunan öğrencinin kimliği.';
$string['privacy:metadata:takenby'] = 'Öğrenci için yoklama alan kullanıcının kullanıcı kimliği.';
$string['privacy:metadata:timemodified'] = 'Oturumun en son ne zaman değiştirildiğinin zaman damgası';
$string['privacy:metadata:timesent'] = 'Uyarı gönderildiğinde zaman damgası.';
$string['privacy:metadata:timetaken'] = 'Öğrenci için yoklamanın ne zaman alındığının zaman damgası.';
$string['privacy:metadata:userid'] = 'Uyarı gönderilecek kullanıcının kimliği.';
$string['processingfile'] = 'Dosya işleniyor';
$string['qr_cookie_error'] = 'QR oturumunun süresi doldu.';
$string['qr_pass_wrong'] = 'QR şifresi yanlış veya süresi dolmuş.';
$string['qrcode'] = 'QR kod';
$string['qrcodeandpasswordheader'] = 'Yoklamaya katılmak için aşağıdaki QR kodunu tarayın veya aşağıda listelenen şifreyi kullanın';
$string['qrcodeheader'] = 'Yoklamaya katılmak için aşağıdaki QR kodunu tarayın';
$string['qrcodevalidafter'] = 'saniye';
$string['qrcodevalidbefore'] = 'Şunlar için geçerli QR kodu:';
$string['randompassword'] = 'Rastgele şifire';
$string['remark'] = '$A için açıklama';
$string['remarks'] = 'Açıklamalar';
$string['repeatasfollows'] = 'Yukarıdaki oturumu aşağıdaki gibi tekrarlayın';
$string['repeatevery'] = 'Şu aralıkla tekrarla';
$string['repeaton'] = 'Şurada tekrar edin';
$string['repeatuntil'] = 'Şu zaman kadar tekar edin';
$string['report'] = 'Rapor';
$string['reportsessiondate'] = 'Oturum tarihi';
$string['reportsessionduration'] = 'Outurum süreci';
$string['reportsessionlasttaken'] = 'Oturumun son alındığı saat (öğretmen)';
$string['required'] = 'Zorunlu*';
$string['requiredentries'] = 'Geçici kayıtlar, katılımcı devam kayıtlarının üzerine yazılır';
$string['requiredentry'] = 'Geçici kullanıcı birleştirme yardım kılavuzu';
$string['requiredentry_help'] = '<p align="center"><b>Devam</b></p>
 <p align="left"><strong>Hesapları Birleştir</strong></p>
 <p hizalama="sol">
 <table border="2" cellpadding="4">
 <tr>
 <th>Moodle Kullanıcısı</th>
 <th>Geçici Kullanıcı</th>
 <th>Eylem</th>
 </tr>
 <tr>
 <td>Katılım verileri</td>
 <td>Katılım verileri</td>
 <td>Geçici kullanıcı, Moodle kullanıcısını geçersiz kılar</td>
 </tr>
 <tr>
 <td>Katılım verisi yok</td>
 <td>Katılım verileri</td>
 <td>Geçici kullanıcı katılımı Moodle kullanıcısına aktarılacaktır</td>
 </tr>
 <tr>
 <td>Katılım verileri</td>
 <td>Katılım verisi yok</td>
 <td>Geçici kullanıcı silinecek</td>
 </tr>
 <tr>
 <td>Katılım verisi yok</td>
 <td>Katılım verisi yok</td>
 <td>Geçici kullanıcı silinecek</td>
 </tr>
 </tablo>

 </p>
 <p align="left"><strong>Geçici kullanıcı, birleştirme işleminden sonra her durumda silinecek</strong></p>
 Türkçe [tr] |  tarihçe';
$string['requiresubnet'] = 'Ağ adresi gerekli olsun';
$string['requiresubnet_help'] = 'Yoklama kaydı, kısmi veya tam IP adreslerinin virgülle ayrılmış bir listesi belirtilerek belirli alt ağlarla sınırlandırılabilir.';
$string['resetcaledarcreate'] = 'Takvim etkinlikleri etkinleştirildi, ancak bazı oturumlarda etkinlik yok. Mevcut tüm oturumlar için takvim etkinlikleri oluşturmak istiyor musunuz?';
$string['resetcaledardelete'] = 'Takvim etkinlikleri devre dışı bırakıldı, ancak bazı oturumlarda silinmesi gereken etkinlikler var. Mevcut tüm etkinlikleri silmek istiyor musunuz?';
$string['resetcalendar'] = 'Takvimi sıfırla';
$string['resetdescription'] = 'Katılım verilerinin silinmesinin veritabanındaki bilgileri sileceğini unutmayın. Elbette başlangıç tarihini değiştiren eski oturumları gizleyebilirsiniz!';
$string['resetstatuses'] = 'Durumları varsayılana sıfırla';
$string['restoredefaults'] = 'Varsayılanları geri yükle';
$string['resultsperpage'] = 'Sayfa başına sonuç';
$string['resultsperpage_desc'] = 'Sayfada görüntülenecek öğrenci sayısı';
$string['rotateqrcode'] = 'QR kodunu döndür';
$string['rotateqrcode_cleartemppass_task'] = 'Döndürme QR kodu işlevi tarafından oluşturulan geçici şifreleri temizleme görevi.';
$string['rotateqrcodeexpirymargin'] = 'QR kodunu/şifrenin bitiş marjını döndür (saniye)';
$string['rotateqrcodeexpirymargin_desc'] = 'Süresi dolmuş QR koduna/şifreye izin vermek için zaman aralığı (saniye).';
$string['rotateqrcodeinterval'] = 'QR kodunu/şifre aralığını döndür (saniye)';
$string['rotateqrcodeinterval_desc'] = 'QR kodunu/şifreyi döndürmek için zaman aralığı (saniye).';
$string['save'] = 'Katılımı kaydet';
$string['saveandshownext'] = 'Kaydet ve sonraki sayfayı göster';
$string['scantime'] = 'Tarama süresi';
$string['scantime_help'] = 'Bu, içe aktarma dosyasına bir zaman damgasının eklenmesine izin verir - PHP strtotime işlevi kullanılarak geçirilen zaman damgasını dönüştürmeye çalışır ve ardından kullanıcı için hangi durumun ayarlanacağına karar vermek için devam durumu ayarlarını kullanır.';
$string['search:activity'] = 'Katılım - etkinlik bilgileri';
$string['selectactivity'] = 'Aktivite seçin';
$string['session'] = 'Oturum';
$string['session_help'] = 'Oturum';
$string['sessionadded'] = 'Oturum başarıyla eklendi';
$string['sessionalreadyexists'] = 'Bu tarih için oturum zaten var';
$string['sessiondate'] = 'Tarih';
$string['sessiondays'] = 'Seans Günleri';
$string['sessiondeleted'] = 'Oturum başarıyla silindi';
$string['sessiondescription'] = 'Oturum açıklaması';
$string['sessionduplicate'] = 'Kurs için yinelenen bir oturum var: {$a->course} katılım: {$a->activity}, {$a->date}';
$string['sessionexist'] = 'Oturum eklenmedi (zaten var)!';
$string['sessiongenerated'] = 'Bir oturum başarıyla oluşturuldu';
$string['sessions'] = 'Oturumlar';
$string['sessionsallcourses'] = 'Tüm dersler';
$string['sessionsbyactivity'] = 'Katılım örneği';
$string['sessionsbycourse'] = 'Kurs';
$string['sessionsbydate'] = 'Hafta';
$string['sessionscompleted'] = 'alınan seanslar';
$string['sessionscurrentcourses'] = 'Mevcut dersler';
$string['sessionsgenerated'] = '{$a} oturum başarıyla oluşturuldu';
$string['sessionsids'] = 'Oturum kimlikleri:';
$string['sessionsnotfound'] = 'Seçilen zaman aralığında oturum yok';
$string['sessionstartdate'] = 'Oturum başlangıç tarihi';
$string['sessionstotal'] = 'Toplam seans sayısı';
$string['sessionsupdated'] = 'Oturumlar güncellendi';
$string['sessiontype'] = 'Tip';
$string['sessiontype_help'] = 'Tüm öğrenciler veya bir grup öğrenci için oturum ekleyebilirsiniz. Farklı türler ekleyebilme yeteneği, etkinlik grubu moduna bağlıdır.

* "Grup yok" grup modunda tüm öğrenciler için yalnızca oturumlar ekleyebilirsiniz.
* "Ayrı gruplar" grup modunda yalnızca bir grup öğrenci için oturum ekleyebilirsiniz.
* "Görünür gruplar" grup modunda her iki oturum türünü de ekleyebilirsiniz.';
$string['sessiontypeshort'] = 'Tür';
$string['sessionunknowngroup'] = 'Bir oturum bilinmeyen grupları belirtiyor: {$a}';
$string['sessionupdated'] = 'Oturum başarıyla güncellendi';
$string['set_by_student'] = 'Kendinden kaydedilmiş';
$string['setallstatuses'] = 'için durumu ayarla';
$string['setallstatusesto'] = 'Durumu «{$a}» olarak ayarla';
$string['setperiod'] = 'IP\'yi serbest bırakmak için dakika cinsinden belirtilen süre';
$string['settings'] = 'Ayarlar';
$string['setunmarked'] = 'Değelendiilmediğinde otomatik olarak ayarlanır';
$string['setunmarked_help'] = 'Oturumda etkinleştirildiyse, bir öğrenci kendi katılımını işaretlemediyse bu durumu ayarlayın.';
$string['showdefaults'] = 'İşaretlenmediğinde otomatik olarak ayarlanır';
$string['showduration'] = 'Süreyi göster';
$string['showextrauserdetails'] = 'Ekstra kullanıcı ayrıntılarını göster';
$string['showqrcode'] = 'QR Kodunu Görüntüle';
$string['showsessiondescriptiononreport'] = 'Raporda oturum açıklamasını göster';
$string['showsessiondescriptiononreport_desc'] = 'Katılım raporu listesinde oturum açıklamasını gösterin.';
$string['showsessiondetails'] = 'Oturum ayrıntılarını göster';
$string['somedisabledstatus'] = '(Oturum başladığından bazı seçenekler kaldırılmıştır.)';
$string['sortedgrid'] = 'sıralanmış ızgara';
$string['sortedlist'] = 'Sıralanmış liste';
$string['startofperiod'] = 'Dönemin başlangıcı';
$string['starttime'] = 'Başlangıç saati';
$string['status'] = 'Durum';
$string['statusall'] = 'herşey';
$string['statusdeleted'] = 'Durum silindi';
$string['statuses'] = 'Durumlar';
$string['statusset'] = 'Durum seti {$a}';
$string['statussetsettings'] = 'Durum seti';
$string['statustotalcount'] = 'Durum {$a} - Toplam sayım';
$string['statustotalcountcurrentweek'] = 'Durum {$a} - Geçerli hafta için toplam sayım';
$string['statustotalcountpreviousweek'] = 'Durum {$a} - Önceki hafta için toplam sayım';
$string['statusunselected'] = 'seçilmemiş';
$string['strftimedm'] = '%b %d';
$string['strftimedmw'] = '<nobr>%a %b %d</nobr>';
$string['strftimedmy'] = '%d %b %Y';
$string['strftimedmyhm'] = '%d %b %Y %I.%M%p';
$string['strftimedmyw'] = '<nobr>%a %d %b %Y</nobr>';
$string['strftimeh'] = '%I%p';
$string['strftimehm'] = '%I:%M%p';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'Öğrenci Kimliği';
$string['studentmarked'] = 'Bu oturuma katılımınız kaydedildi.';
$string['studentmarking'] = 'Öğrenci kaydı';
$string['studentpassword'] = 'Öğrenci şifresi';
$string['studentrecordingexpanded'] = 'Öğrenci kaydı genişletildi';
$string['studentrecordingexpanded_desc'] = 'Yeni oturumlar oluştururken varsayılan olarak genişletilmiş "Öğrenci kaydı" ayarlarını gösterin.';
$string['studentscanmark'] = 'Öğrencilerin kendi yoklamalarını kaydetmelerine izin ver';
$string['studentscanmark_desc'] = 'İşaretlenirse, öğretmenler öğrencilerin kendi katılımlarını işaretlemelerine izin verebilir.';
$string['studentscanmark_help'] = 'İşaretlenirse, öğrenciler oturum için kendi katılım durumlarını değiştirebilirler.';
$string['studentscanmarksessiontime'] = 'Öğrenciler oturum süresi boyunca katılımı kaydeder';
$string['studentscanmarksessiontime_desc'] = 'İşaretliyse öğrenciler sadece oturum sırasında katılımlarını kaydedebilirler.';
$string['studentscanmarksessiontimeend'] = 'Oturum sonu (dakika)';
$string['studentscanmarksessiontimeend_desc'] = 'Oturumun bir bitiş saati yoksa, öğrencilerin devamlarını kaydetmeleri için oturum kaç dakika olmalıdır.';
$string['studentsearlyopentime'] = 'İşaretleme için oturumu erken açın';
$string['studentsearlyopentime_help'] = 'Bu, öğretmenlerin oturumu erken açmasına olanak tanıyarak yoklamanın gerçek başlama saatinden önce alınmasını sağlar.';
$string['submit'] = 'Göndermek';
$string['submitattendance'] = 'Katılımı gönder';
$string['submitattendancefuture'] = 'Gelecekteki devamsızlık durumunu bildir';
$string['submitpassword'] = 'Şifre gönder';
$string['subnet'] = 'Alt ağ';
$string['subnetactivitylevel'] = 'Etkinlik düzeyinde alt ağ yapılandırmasına izin ver';
$string['subnetactivitylevel_desc'] = 'Etkinleştirilirse öğretmenler, katılım oluştururken etkinlik düzeyinde varsayılan alt ağı geçersiz kılabilir. Aksi takdirde, bir oturum oluşturulurken site varsayılanı kullanılacaktır.';
$string['subnetwrong'] = 'Katılım yalnızca belirli konumlardan kaydedilebilir ve bu bilgisayar izin verilenler listesinde değildir.';
$string['summary'] = 'Katılım yalnızca belirli konumlardan kaydedilebilir ve bu bilgisayar izin verilenler listesinde değildir.';
$string['tablerenamefailed'] = 'Eski attforblock tablosunun yeniden adlandırılması başarısız oldu';
$string['tactions'] = 'Eylem';
$string['takeattendance'] = 'Yoklama almak';
$string['takensessions'] = 'alınan seanslar';
$string['tcreated'] = 'oluşturuldu';
$string['tempaddform'] = 'Geçici kullanıcı ekle';
$string['tempexists'] = 'Bu e-posta adresine sahip geçici bir kullanıcı zaten var';
$string['temptable'] = 'Geçici kullanıcıların listesi';
$string['tempuser'] = 'geçici kullanıcı';
$string['tempusermerge'] = 'Geçici kullanıcıyı birleştir';
$string['tempusers'] = 'Geçici kullanıcılar';
$string['tempusersedit'] = 'Geçici kullanıcıyı düzenle';
$string['tempuserslist'] = 'Geçici kullanıcılar';
$string['thirdpartyemails'] = 'Diğer kullanıcıları bilgilendir';
$string['thirdpartyemails_help'] = 'Bilgilendirilecek diğer kullanıcıların listesi. (mod/attendance:viewreports yeteneği gerekir)';
$string['thirdpartyemailsubject'] = 'Katılım uyarısı';
$string['thirdpartyemailtext'] = '{$a->firstname} {$a->lastname} {$a->coursename} {$a->aname} kapsamında katılım, {$a->warningpercent} ({$a->percent}) değerinden daha düşük';
$string['thirdpartyemailtextfooter'] = 'Bunu, bu kursun öğretmeni e-postanızı alıcı listesine eklediği için alıyorsunuz.';
$string['thiscourse'] = 'Bu ders';
$string['time'] = 'Zaman';
$string['timeahead'] = 'Bir yılı aşan birden fazla oturum oluşturulamaz, lütfen başlangıç ve bitiş tarihlerini ayarlayın.';
$string['timemodified'] = 'Zaman değiştirildi';
$string['timetaken'] = 'Yoklama daha önce alınmış';
$string['to'] = 'ile:';
$string['todate'] = 'bugüne kadar';
$string['totalnumsessions'] = 'Toplam oturum sayısı';
$string['triggered'] = 'İlk bildirim';
$string['tuseremail'] = 'E-posta';
$string['tusername'] = 'Ad Soyad';
$string['ungraded'] = 'Not verilmeyen oturumlar';
$string['unknowngroup'] = 'Bilinmeyen grup';
$string['unknownstatus'] = 'Bilinmeyen durum kimliği: {$a}';
$string['update'] = 'Bilinmeyen durum kimliği: {$a}';
$string['updateattendance'] = 'Yoklamayı güncelle';
$string['uploadattendance'] = 'Katılımı CSV\'ye göre yükleyin';
$string['usedefaultsubnet'] = 'Varsayılanı Kullan';
$string['usemessageform'] = 'veya seçilen öğrencilere mesaj göndermek için aşağıdaki formu kullanın';
$string['userexistingstatus'] = 'Yoklamanız şu şekilde işaretlenmiş: <strong>{$a}</strong>, gerekirse bunu değiştirmek için aşağıdaki formu kullanın.';
$string['userexists'] = 'Bu e-posta adresine sahip gerçek bir kullanıcı zaten var';
$string['userid'] = 'Kullanıcı kimliği';
$string['userimportfield'] = 'Harici kullanıcı alanı';
$string['userimportfield_help'] = 'Kullanıcı tanımlayıcısını içeren yüklenen CSV\'den alan';
$string['userimportto'] = 'Moodle kullanıcı alanı';
$string['userimportto_help'] = 'CSV dışa aktarımındaki verilerle eşleşen Moodle alanı';
$string['users'] = 'Dışa aktarılacak kullanıcılar';
$string['usersessiongrade'] = 'Kullanıcı oturumu notu';
$string['usersessionremarks'] = 'Kullanıcı oturumu açıklamaları';
$string['usersessiontaken'] = 'Kullanıcı oturumu alındı';
$string['userstatus'] = 'Kullanıcı oturum durumu';
$string['usestatusset'] = 'Durum seti';
$string['variable'] = 'değişken';
$string['variablesupdated'] = 'Değişkenler başarıyla güncellendi';
$string['versionforprinting'] = 'baskı için sürüm';
$string['viewmode'] = 'Görünüm modu';
$string['warnafter'] = 'Uyarı öncesi alınan seans sayısı';
$string['warnafter_help'] = 'Uyarılar, yalnızca kullanıcının katılımı en az bu sayıda oturum için alındığında tetiklenir.';
$string['warningdeleted'] = 'Uyarı silindi';
$string['warningdesc'] = 'Bu uyarılar, yeni katılım etkinliklerine otomatik olarak eklenecektir. Tam olarak aynı anda birden fazla uyarı tetiklenirse, yalnızca uyarı eşiği daha düşük olan uyarı gönderilir.';
$string['warningdesc_course'] = 'Burada belirlenen uyarı eşikleri, devamsızlık raporunu etkiler ve öğrencilerin ve üçüncü şahısların bilgilendirilmesine olanak tanır. Tam olarak aynı anda birden fazla uyarı tetiklenirse, yalnızca uyarı eşiği daha düşük olan uyarı gönderilir.';
$string['warningfailed'] = 'Aynı yüzdeyi ve oturum sayısını kullanan bir uyarı oluşturamazsınız.';
$string['warningpercent'] = 'Yüzde altına düşerse uyar';
$string['warningpercent_help'] = 'Toplam yüzde bu sayının altına düştüğünde bir uyarı tetiklenecektir.';
$string['warnings'] = 'Uyarı seti';
$string['warningthreshold'] = 'Uyarı eşiği';
$string['warningupdated'] = 'Güncellenen uyarılar';
$string['week'] = 'hafta(lar)';
$string['weekcommencing'] = 'Hafta başlıyor';
$string['weeks'] = 'Haftalar';
$string['youcantdo'] = 'hiçbir şey yapamazsın';
