<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'tr', version '4.4'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['action'] = 'Eylem';
$string['activityoverview'] = 'Doldurman gereken anket var';
$string['additionalinfo'] = 'Ek bilgi';
$string['additionalinfo_help'] = 'Bu anketin ilk sayfasının en üstünde gösterilecek olan metin (örn. yönergeler, arkaplan bilgisi vb)';
$string['addnewquestion'] = '{$a} sorusu ekleniyor';
$string['addnewsection'] = 'Yeni bölüm ekle';
$string['addquestion'] = 'Soru ekle...';
$string['addquestions'] = 'Soru ekle';
$string['addquestiontosection'] = 'Bölüme soru ekle';
$string['addselqtype'] = 'Seçilmiş soru tipini ekle';
$string['alignment'] = 'Tek seçimlik düğmeleri hizalama';
$string['alignment_help'] = 'Düğme hizalamayı seç: Dikey (varsayılan) veya yatay';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Hepsi';
$string['allnameddegrees'] = 'Adlandırılmış puanlar';
$string['allnameddegrees_help'] = 'Oran değerleri için sayı yerine görüntülenecek metni belirtin. Kullanılmayacaksa değeri boş bırakın.';
$string['alreadyfilled'] = 'Bu anketi zaten bizim için {$a} tamamladınız. Teşekkür ederiz.';
$string['andaveragevalues'] = 've ortalama değerler';
$string['anonymous'] = 'Anonim';
$string['answer'] = 'Cevap';
$string['answergiven'] = 'Bu soruya verilen cevap';
$string['answernotgiven'] = 'Bu soruya cevaplanmadı';
$string['answerquestions'] = 'Soruları yanıtla..';
$string['answers'] = 'Cevaplar';
$string['attempted'] = 'Bu anket formu gönderildi.';
$string['attemptstillinprogress'] = 'Devam ediyor. Kaydedilen yer:';
$string['autonumbering'] = 'Otomatik numaralandırma';
$string['autonumbering_help'] = 'Sorular ve sayfaları otomatik numaralandır. Koşullu dallanma soru formları için otomatik numaralandırmayı devre dışı bırakabilirsiniz.';
$string['autonumberno'] = 'Sayfa ve soruları numaralandırma';
$string['autonumberpages'] = 'Otomatik sayfa numarası';
$string['autonumberpagesandquestions'] = 'Sayfa ve soruları otomatik numaralandır';
$string['autonumberquestions'] = 'Soruları otomatik numaralandır';
$string['average'] = 'Ortalama';
$string['averageposition'] = 'Ortalama\'nın konumu';
$string['averagerank'] = 'Ortalama derece';
$string['averagesrow'] = 'Ortalamalar (geçerli olduğu yerlerde):';
$string['bodytext'] = 'Gövde metni';
$string['boxesnbexact'] = 'tam olarak {$a} kutu.';
$string['boxesnbmax'] = 'en fazla {$a} kutu.';
$string['boxesnbmin'] = 'en az {$a}  kutu.';
$string['boxesnbreq'] = 'Bu soruları işaretlemeniz gerekir.';
$string['by'] = 'tarafından';
$string['cannotviewpublicresponses'] = 'Bu genel ankete verilen cevapları görüntüleyemezsiniz.';
$string['centerlabel'] = 'Merkez etiket';
$string['chart:bipolar'] = 'Bipolar çubuklar';
$string['chart:hbar'] = 'Yatay çubuklar';
$string['chart:radar'] = 'Radar';
$string['chart:rose'] = 'Gül (kırmızı)';
$string['chart:type'] = 'Grafik Türü';
$string['chart:type_help'] = 'Bu geribildirim için kullanmak istediğiniz Grafik türünü seçin';
$string['chart:vprogress'] = 'Dikey ilerleme çubuğu';
$string['checkallradiobuttons'] = '<strong>{$a}</strong> radyo düğmelerini kontrol edin!';
$string['checkboxes'] = 'Onay Kutusu';
$string['checkboxes_help'] = 'Kullanıcının bir veya daha fazla cevaplaması için her satırda bir seçenek girin.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Konum(lar)a yeni Sayfa son(lar)ı eklendi';
$string['checkbreaksok'] = 'Tüm gerekli Sayfa sonları mevcuttur!';
$string['checkbreaksremoved'] = 'Fazla  {$a}  Safya sonları kaldırıldı';
$string['checknotstarted'] = 'Seçin başlatılmadı';
$string['checkstarted'] = 'Seçim başladı';
$string['clicktoswitch'] = '(geçiş yapmak için tıklayın)';
$string['closebeforeopen'] = 'Açılış tarihinden önce olacak şekilde kapanış tarihi belirttiniz.';
$string['closed'] = 'Anket {$a} katılıma kapatıldı. Teşekkürler.';
$string['closedate'] = 'Yanıtlara izin ver';
$string['closeson'] = 'Anket {$a}\'da kullanıma kapanacaktır.';
$string['completionsubmit'] = 'Öğrenci bu anket formunu  gönderebilmek için tamamlamak zorundadır.';
$string['condition'] = 'Koşul';
$string['confalts'] = '- VEYA - <br /> Onay sayfası';
$string['configemailreporting'] = 'Raporların e-posta ile gönderilmesine izin verin';
$string['configemailreportinglong'] = 'Bazı raporların doğrudan belirtilen e-posta adreslerine e-posta ile gönderilmesi için seçenekleri etkinleştirir.';
$string['configmaxsections'] = 'Maksimum geribildirim bölümleri';
$string['configusergraph'] = '"Kişilik Testi" geribildirim için grafik görüntüleme';
$string['configusergraphlong'] = '<a href="http://www.rgraph.net/"> Rgraph</a> kütüphanesini "Kişilik Testi" geri bildirim listeleri görüntülemek için kullanırsınız.';
$string['confirmdelallresp'] = 'Bu anket TÜM cevaplar silmek istediğinizden emin misiniz?';
$string['confirmdelchildren'] = 'Eğer bu soruyu silerseniz,  alt soru(lar) da silinir:';
$string['confirmdeletesection'] = '"{$a}" geri bildirim bölümünü silmek istediğinizden emin misiniz?';
$string['confirmdelgroupresp'] = '{$a}\'daki tüm cevapları silmek istediğinizden emin misiniz?';
$string['confirmdelquestion'] = '{$a} konumundaki soruyu silmek istediğinizden emin misiniz?';
$string['confirmdelquestionresps'] = 'Bu da  {$a} bu soruya verilecek cevapları silecektir.';
$string['confirmdelresp'] = '{$a} &nbsp;{$a}&nbsp; tarafından verilen cevapları silmek istediğinizden emin misiniz?';
$string['confirmremovequestion'] = '"{$a->qname}" sorusunu "{$a->sname}" bölümünden kaldırmak istediğinizden emin misiniz?';
$string['confpage'] = 'Başlık metni';
$string['confpage_help'] = '(Kalın), başlık ve gövde metni için bir kullanıcı bu Anketi tamamladıktan sonra görüntülenen "Onay" sayfası. (URL, varsa, onay metni üzerinde önceliğe sahiptir.) Bu alanı boş bırakırsanız, soru formu tamamlanması (Bu anketi tamamladığınız için teşekkürler) varsayılan bir ileti görüntülenir.';
$string['confpagedesc'] = '(Kalın), başlık ve gövde metni için bir kullanıcı bu Anketi tamamladıktan sonra görüntülenen "Onay" sayfası. (URL, varsa, onay metni üzerinde önceliğe sahiptir.)';
$string['contentoptions'] = 'İçerik seçenekleri';
$string['couldnotcreatenewsurvey'] = 'Yeni bir anket oluşturalamadı';
$string['couldnotdelresp'] = 'Cevap silinemedi';
$string['createcontent'] = 'Yeni içerik tanımla';
$string['createcontent_help'] = 'Radyo düğmesi seçeneklerinden birini seçin. Varayılan için \'Yeni oluştur\' u seçin.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Yeni oluştur';
$string['crontask'] = 'Anket temizliği işi';
$string['date'] = 'Tarih';
$string['date_help'] = 'Eğer bu soruya düzgün cevap verilmesini istiyorsanız düzgün bir tarih formatında soru tipi kullanın.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Yıl-ay-gün formatını kullanın, örneğin 4 Mart 1945 için:&nbsp; <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Tüm cevapları silin';
$string['deletecurrentquestion'] = 'Soru {$a}\'yı Sil';
$string['deletedallgroupresp'] = 'Gruptaki  TÜM {$a}Cevapları sil';
$string['deletedallresp'] = 'Anket cevapları silindi';
$string['deletedisabled'] = 'Bu öge silinemedi';
$string['deletedresp'] = 'Cevabı sil';
$string['deleteresp'] = 'Bu cevabı sil';
$string['deletesection'] = 'Bu bölümü sil';
$string['deletingresp'] = 'Cevap Siliniyor';
$string['dependencies'] = 'Bağımlılıklar';
$string['dependquestion'] = 'Ana soru';
$string['dependquestion_help'] = 'Ana soru ve bu sorunun seçim seçeneği seçebilirsiniz. Eğer öğrenci önceden anasoru ve seçenekleri işaretlemişse alt sorular görüntülenir.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Soruyu cevaplamadı';
$string['directwarnings'] = 'Bu soruya olan doğrudan bağımlılıklar kaldırılacaktır. Bunlar aşağıdakileri etkileyecektir:';
$string['displaymethod'] = 'Görüntüleme yöntemi soru için tanımlı değil.';
$string['download'] = 'İndir';
$string['downloadpdf'] = 'PDF dosyası olarak indir';
$string['downloadtextformat'] = 'İndir';
$string['downloadtextformat_help'] = 'Bu özellik, bir anketin tüm yanıtlarını seçilebilir, desteklenen bir dosya biçimine kaydetmenizi sağlar.
Dışa aktarıma fazladan veri öğeleri eklemeyi ve dosyayı seçilen kullanıcılara otomatik olarak göndermeyi seçebilirsiniz.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Rapor türü';
$string['dropdown'] = 'Açılan kutu';
$string['dropdown_help'] = 'Ekran';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Düzenle';
$string['editingfeedback'] = 'Geri bildirim ayarlarını düzenleme';
$string['editingquestionnaire'] = 'Anket ayarlarını düzenle';
$string['editquestion'] = '{$a} Sorusu düzenleniyor';
$string['email'] = 'E-Posta';
$string['emailextra'] = 'İndirmeyi e-postalara gönder';
$string['emailextra_help'] = 'İndirme dosyasını virgülle ayırarak listelenen e-posta adreslerine gönderir. HİÇBİR güvenlik veya gizlilik kontrolü yapılmadığını unutmayın.
 Buna erişmek için modül ayarlarında \'allowemailreporting\' etkinleştirilmelidir.';
$string['emailroles'] = 'İndirme işlemini rollere yönlendir.';
$string['emailroles_help'] = 'İndirme dosyasını "mod/questionnaire:submissionnotification" özelliğine sahip tüm rollere e-posta yoluyla gönderir.  Erişim için modül ayarlarında \'allowemailreporting\' etkinleştirilmelidir.';
$string['emailsend'] = 'Rapor gönder';
$string['emailsnotspecified'] = 'E-posta ( s ) belirtilmedi.';
$string['emailssent'] = 'İndirilen dosyalar belirtilen e-postaya ( s ) gönderildi.';
$string['errnewname'] = 'Üzgünüm, bu isim halihazırda kullanılıyor. Lütfen yeni bir isim seçin.';
$string['erroropening'] = 'Anket açılırken kata oluştu';
$string['errortable'] = 'Hata, sistem tablosu bozuk.';
$string['essaybox'] = 'Yazı kutusu';
$string['essaybox_help'] = 'Bu soruyu x Metin alanı sütunları (veya alanı genişliği) içeren bir düz metin kutusu görüntüler ve y Textarea satırları (metin satırı sayısı).

Hem x ve y için kendi varsayılan 0 değer (veya 0 olarak ayarlarsanız) ayarlarsanız, Moodle\'ın HTML editörü (ders / kullanıcı bağlamı ve kullanıcı profili mevcut ise), standart yükseklik ve genişlikte gösterilecektir.';
$string['event_all_responses_deleted'] = 'Tüm cevaplar silindi';
$string['event_all_responses_saved_as_text'] = 'Tüm cevaplar metin olarak kaydedildi';
$string['event_all_responses_viewed'] = 'Tüm cevaplar rapor olarak izlendi';
$string['event_individual_responses_viewed'] = 'Bireysel cevaplar rapor olarak izlendi';
$string['event_non_respondents_viewed'] = 'Cevap vermeyenler incelendi';
$string['event_previewed'] = 'Anket ön izlemesi yapıldı';
$string['event_question_created'] = 'Soru eklendi';
$string['event_question_deleted'] = 'Soru Silindi';
$string['event_response_deleted'] = 'Bireysel cevaplar silind';
$string['event_resumed'] = 'Deneme yeniden başladı';
$string['event_saved'] = 'Cevaplar kaydedildi';
$string['event_submitted'] = 'Cevaplar gönderildi';
$string['feedback'] = 'Geri bildirim';
$string['feedback_help'] = 'Yeribildirim yardımı';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Daha{no} fazla geribildirim alanı ekle';
$string['feedbackbysection'] = 'Bölüom geribildirimleri';
$string['feedbackdefaultlabel'] = '[Yeni bölüm]';
$string['feedbackeditingglobal'] = 'Genel geribildirim için anketi düzenle';
$string['feedbackeditingmessages'] = 'Anket Formu Geribildirim Mesajları Düzenleniyor';
$string['feedbackeditingsections'] = 'Anket Formu Bölüm Geribildirim Mesajları Düzenleniyor';
$string['feedbackeditmessages'] = 'Bölüm ayarları ve geri bildirim mesajlarını kaydet';
$string['feedbackeditsections'] = 'Ayarlı ve Bölüm geribildirimlerini kaydet';
$string['feedbackerrorboundaryformat'] = 'Geribildirim Puan sınırlarını yüzde veya sayı olması gerekir. Sınır {$a} girilen değer kabul edilemez';
$string['feedbackerrorboundaryoutofrange'] = 'Geribildirim Puan sınırları % 0 ile % 100 arasında olmalıdır. Sınır {$a} girilen değer aralık dışındadır.';
$string['feedbackerrorjunkinboundary'] = 'Herhangi bir boşluk bırakmadan geribildirim puan sınırını kutuların doldurmanız gerekir.';
$string['feedbackerrorjunkinfeedback'] = 'Herhangi bir boşluk bırakmadan geri bildirim kutuları doldurmanız gerekir.';
$string['feedbackerrororder'] = 'Geribildirim Puan sınırları, en yüksek ilk olması gerekir. Sınır {$a} girdiğiniz değer sırası yanlış.';
$string['feedbackglobal'] = 'Genel Geribildiri';
$string['feedbackglobalheading'] = 'Genel geribildirim başlıkları';
$string['feedbackglobalmessages'] = 'Genel geribildirim mesajları';
$string['feedbackhdr'] = 'Geribildirimler';
$string['feedbackheading'] = 'Geribildirim başlıkları';
$string['feedbackheading_help'] = 'Geri bildirim başlığı alanında 2 değişken kullanabilirsiniz: $scorepercent ve $oppositescorepercent.';
$string['feedbackmessages'] = 'Bölüm {$a} için bölüm mesajları';
$string['feedbacknextsection'] = 'Sonraki bölüm {$a}';
$string['feedbacknone'] = 'Geri bildirim iletisi yok';
$string['feedbacknotes'] = 'Geribildirim notları';
$string['feedbacknotes_help'] = 'Burada girilen metin  geribilidirm raporun sonunda katılımcıların gösterilir';
$string['feedbackoptions'] = 'Geri bildirim seçenekleri';
$string['feedbackoptions_help'] = 'Geribildirim seçenekleri, soru formu içeriyorsa aşağıdaki soru tipleri ve soru ayarları kullanılabilir:
Radyo düğmeleri; Açılır liste kutusu veya derceli soru. Bu soruların, gerektiği şekilde ayarlanmış olması gerekir,  soru adı alanı boş olmamalı ve olası cevaplar ve seçenekler bir değer içermelidir.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Bu soru [{$a}] geribildirim bölümünün parçasıdır';
$string['feedbackremovesection'] = 'Bu sorunun [{$a}] çıkarılması tamamen geri bölümünü kaldıracaktır';
$string['feedbackreport'] = 'Geribildirim raporu';
$string['feedbackscore'] = 'Geribildirim puanı';
$string['feedbackscoreboundary'] = 'Geribildirim pun sınırı';
$string['feedbackscores'] = 'Sonuçları göster';
$string['feedbackscores_help'] = 'Geribildirim puanları tablosunu görüntüle';
$string['feedbacksection'] = 'Bölüm';
$string['feedbacksectionheading'] = '{$a} bölüm başlığı';
$string['feedbacksectionheadingmissing'] = 'Bu bölümü geribildirimi  için bir başlık girmelisiniz!';
$string['feedbacksectionheadingtext'] = 'Başlık';
$string['feedbacksectionlabel'] = 'Etiket';
$string['feedbacksectionlabel_help'] = 'Bu etiket grafikler/diyagramlarında kullanılacaktır. Lütfen mümkün olduğunca kısa tutun!';
$string['feedbacksectionquestions'] = '{$a} bölüm soruları';
$string['feedbacksections'] = 'Geri bildirim bölümleri';
$string['feedbacksectionsselect'] = 'Bölümler';
$string['feedbacksectionsselect_help'] = 'Sorularınızı bu bölüme yerleştirin.';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Geribildirim ayarları kaydedildi';
$string['feedbacktype'] = 'Geribildirim türü';
$string['field'] = 'Soru {$a}';
$string['fieldlength'] = 'Giriş metni uzunluğu';
$string['fieldlength_help'] = '** Metin Kutusu ** soru tipi için, ** Girdi Kutusu uzunluğu ** ve cevap verecek kişi tarafından girilecek metin ** Maksimum metin uzunluğu ** girin. Varsayılan değerler Girdi Kutusu genişliği 20 karakter ve girilen metnin maksimum uzunluğu 25 karakterdir.';
$string['finished'] = 'Bu anketteki tüm soruları cevapladın!';
$string['firstrespondent'] = 'İlk Cevap veren';
$string['formateditor'] = 'HTML editörü';
$string['formatplain'] = 'Düz metin';
$string['grade'] = 'Ödev notu';
$string['gradesdeleted'] = 'Anket Formu notları silindi';
$string['headingtext'] = 'Başlık metni';
$string['horizontal'] = 'Yatay';
$string['id'] = 'Kimlik';
$string['includechoicecodes'] = 'Seçenek kodlarıni dahil et';
$string['includechoicetext'] = 'Seçenek metnini dahil et';
$string['includeincomplete'] = 'Eksik yanıtları dahil et';
$string['includerankaverages'] = 'Sıralama sorusu ortalamalarını dahil et';
$string['incorrectcourseid'] = 'Kursin İD numarası yanlıştır';
$string['incorrectmodule'] = 'Kurs Modülü Kimliği yanlıştır';
$string['incorrectquestionnaire'] = 'Anket yanlışdir';
$string['indirectwarnings'] = 'Bu liste dolaylı bağlı soruları ve doğrudan bağlı sorular için kalan bağımlılıkları göstermektedir:';
$string['invalidincrement'] = 'Değer artışlarının maksimum değerden daha düşük olması gerektiğini unutmayın. Örneğin, 1-10 arasında bir ölçek kullanılıyorsa, artış değeri muhtemelen 1 olacaktır.';
$string['invalidminmaxrange'] = 'Bu soru tipi -100 ila +100 mutlak maksimum aralığını desteklemektedir. Anket tasarımlarının büyük çoğunluğunun 1-10 veya -10 ila +10 aralığını kullanmasını bekliyoruz.';
$string['invalidrange'] = 'Maksimum slider değeri minimum slider değerinden büyük olmalıdır.';
$string['invalidresponse'] = 'Geçersiz cevap seçildi';
$string['invalidresponserecord'] = 'Geçersiz yanıt kaydı belirtildi.';
$string['invalidsectionid'] = 'Geçersiz geri bildirim bölümü belirtildi.';
$string['invalidstartingvalue'] = 'Başlangıç değeri minimum ve maksimum değerlere eşit veya bu değerler arasında olmalıdır. Örneğin, 1-10 arası bir ölçek kullanılıyorsa, başlangıç değeri 5 olabilir.';
$string['invalidsurveyid'] = 'Geçersiz anket kimliği.';
$string['kindofratescale'] = 'Oran ölçek türü';
$string['kindofratescale_help'] = 'Daha fazla yardım için aşagıdaki linte sağ tıklayın';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Son cevap veren';
$string['leftlabel'] = 'Sol etiket';
$string['length'] = 'Uzunluk';
$string['managequestions'] = 'Soruları yönet';
$string['managequestions_help'] = 'Soru sayfasını düzenle kısmında sorular yönetebilirsiniz.  Anket soruları üzerinde bir dizi işlem gerçekleştirebilirsiniz';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Zorunlu - Tüm bu bağımlılıklar yerine getirilmelidir.';
$string['maxdigitsallowed'] = 'Max. izin verilen basamak';
$string['maxdigitsallowed_help'] = 'Sayısal bir soru için girilen karakter sayısına bir sınır belirlemek için **İzin verilen maks. rakam** seçeneğini kullanın. Unutmayın ki ondalık nokta da bir karakter olarak sayılır!';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Max. Zorunlu cevap sayısı';
$string['maxforcedresponses_help'] = 'Katılımcıyı en az ** Min. ** kutu ve en çok ** ** onay kutusunu işaretlemeye zorlamak için bu parametreleri kullanın. Için
Işaretlenecek belirli sayıda onay kutusu zorlar, ** Min. ** ve ** Max. ** değerlerini aynı değere ayarlayın. Sadece bir dakika veya maksimum bir değer isteniyorsa, diğerini bırakın
Değerini varsayılan ** 0 ** değerine ayarlar. ** Min. ** veya ** Max. ** değerlerini varsayılan ** 0 ** değerinden farklı değerlere ayarlarsanız, eğer bir uyarı mesajı görüntülenir.
Yanıtlayıcı, gereksinimlerinize uymuyor. Açıkçası, davalıya, ya genel talimatlardaki gereklilikleri açıkça belirtmelisiniz.
Anketinizi veya ilgili sorular metninde bulabilirsiniz.';
$string['maxrange'] = 'Maksimum slider aralığı (sağ)';
$string['maxrange_help'] = 'Sağ taraftaki aralığın maksimum değerini ayarlayın. Varsayılan değer 100\'dür, ancak 1-100 arasında herhangi bir sayı olabilir. Sol taraf için minimum değer negatif bir değer ise, maksimum aralık pozitif (+) işareti ile ifade edilecektir.';
$string['maxtextlength'] = 'Maks. Metin uzunluğu';
$string['maxtextlength_help'] = 'Metin Kutusu soru türü için, katılımcı tarafından girilecek Metin kutusunun uzunluğunu ve Metnin maksimum metin uzunluğunu girin.
Varsayılan değerler Giriş Kutusu genişliği için 20 karakter ve girilen maksimum metin uzunluğu için 25 karakterdir.';
$string['messageprovider:message'] = 'Anket Formu hatırlatıcısı';
$string['messageprovider:notification'] = 'Anket Formu gönderimi';
$string['minforcedresponses'] = 'Verilmesi gereken en az cevap sayısı';
$string['minforcedresponses_help'] = 'Yanıtlayanı minimum **Min.** ve maksimum **Maks.** onay kutularını işaretlemeye zorlamak için bu parametreleri kullanın. Tam sayıda onay kutusunun işaretlenmesini zorlamak için **Min.** ve **Max.** değerlerini aynı değere ayarlayın. Yalnızca bir minimum veya maksimum değer isteniyorsa, diğer değeri varsayılan **0** değerinde bırakın. Min.** veya **Maks.** değerlerini varsayılan **0** değerlerinden farklı değerlere ayarlarsanız, yanıtlayıcı gereksinimlerinize uymuyorsa bir uyarı mesajı görüntülenecektir. Açıkçası, Anketinizin genel talimatlarında veya ilgili soruların metninde herhangi bir gereksinimi yanıtlayıcıya açıkça belirtmelisiniz.';
$string['minrange'] = 'Minimum slider aralığı (sol)';
$string['minrange_help'] = 'Sol taraftaki aralığın minimum değerini ayarlayın. Varsayılan değer 1\'dir, ancak -100 kadar düşük bir değere ayarlanabilir. Negatif bir sayı kullanırsanız (-100 ila -1), sağ taraftaki maksimum değer pozitif (+) işaretiyle ifade edilecektir.';
$string['misconfigured'] = 'Kurs yanlış ayarlanmış';
$string['missingname'] = '{$a}adı olmadığı ve zorunlu olmadığı için soru olamaz ve  geri bildirim bölümünde kullanılamaz.';
$string['missingnameandrequired'] = '{$A}adı olmadı için soru olamaz ve  geri bildirim bölümünde kullanılamaz.';
$string['missingquestion'] = 'Lütfen zorunl soruyu cevaplayın';
$string['missingquestions'] = 'Lütfen zorunlu soruları cevaplayınız:';
$string['missingrequired'] = 'Soru {$a} bu geri bildirim bölümünde gerekli olmadığından kullanılamaz.';
$string['modulename'] = 'Anket (Soru tabanlı form)';
$string['modulename_help'] = 'Anket modülü kullanıcılardan veri toplama amacıyla, farklı soru tipleri kullanarak çeşitli anketler oluşturmanıza olanak sağlar.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Anketler';
$string['movedisabled'] = 'Bu öge taşınamaz';
$string['myresponses'] = 'Tüm cevaplarınız';
$string['myresponsetitle'] = 'Senin {$a} cevab(lar)ın';
$string['myresults'] = 'Senin sonuçların';
$string['name'] = 'İsim';
$string['navigate'] = 'Soruların dallanmasın izin ver';
$string['navigate_help'] = 'Anketinde Evet/hayır ve Radyo Butonu soruların ve alt soru tipleri ve alt soru seçenekleri varsa etkinleştirin';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Geri bildirim bölümüne gidin';
$string['next'] = 'Sonraki';
$string['nextpage'] = 'Sonfraki sayfa';
$string['nlines'] = '{$a} çizgileri';
$string['noanswer'] = 'Cevap yok';
$string['noattempts'] = 'Bu anket formu  hiç doldurulmamıştır.';
$string['nodata'] = 'Hiç bir veri gönderilmedi';
$string['noduplicates'] = 'Yinelenmeyen seçenekler';
$string['noduplicateschoiceserror'] = '"Yenilenmeyen Seçenek"soru türü için en az muhtemel cevap girmelisiniz!.';
$string['non_respondents'] = 'Bu ankete henüz cevap vermemiş olan kullanıcılar';
$string['noneinuse'] = 'Bu anket herhangi soru içermeyior';
$string['nopublicsurveys'] = 'Genel anket yok.';
$string['noresponsedata'] = 'Bu soruya hiç cevap verilmemiş';
$string['noresponses'] = 'Cevap yok';
$string['normal'] = 'Normal';
$string['not_started'] = 'başlamadı';
$string['notanumber'] = '<strong>{$a}</strong> kabul edilmeyen sayı biçimi';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A sütünü';
$string['notavail'] = 'Bu anket artık kullanılabilir değil. Öğremenden silmesini isteyin';
$string['noteligible'] = 'Bu anketi doldurmak için uygun değisiniz';
$string['notemplatesurveys'] = 'Soru şablonu yok.';
$string['notenoughscaleitems'] = 'Ölçek ögeleri için en az 2 seçenek girmelisiniz!';
$string['notificationfull'] = 'Tüm gönderimler';
$string['notifications'] = 'Gönderim bildirimlerini ilet';
$string['notifications_help'] = 'Bir gönderim yapıldığında mod/questionnaire:submissionnotification" özelliğine sahip rolleri uyarın.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Sadece bildirim';
$string['notopen'] = 'Bu anket {$a}.\'e kadar açılmayacak';
$string['notrequired'] = 'Cevap zorunlu değil';
$string['notset'] = 'ayarlanmadı';
$string['nousersselected'] = 'Hiçbir kullanıcı seçilmedi';
$string['num'] = '#';
$string['numattemptsmade'] = 'Bu anketi dolduran kişi sayısı: {$a}';
$string['numberfloat'] = '<Strong>sayı{$a->sayı}</strong>/<strong>yeniden biçimlendirildi/yuvarlandı <strong>{$a->precision}</strong> ondalık basamağa';
$string['numberofdecimaldigits'] = 'Nb basamak Sayısı';
$string['numberofdecimaldigits_help'] = 'Anket Formu sayfasında sayılan ve gösterilen Ortalama değer biçimini belirtmek için ** Nb ondalık basamak ** kullanın.';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Nb Ölçek öğesi sayısı';
$string['numberscaleitems_help'] = 'Nb Ölçek öğesi *öğe sayısı* oran ölçeği olarak kullanılacak. Normal olarak 3 den 5\'e kadar kullanılır. Varsayılan değer: ** 5 **. dir';
$string['numeric'] = 'Sayısal';
$string['numeric_help'] = 'Eğer cevabın doğru biçimlendirilmiş bir sayı olmasını istiyorsanız bu soru türünü kullanın';
$string['of'] = 'den';
$string['openafterclose'] = 'Kapanış tarihinden sonra bir açık tarih belirlediniz';
$string['opendate'] = 'Şu kişilerden yanıt alınmasına izin verin';
$string['option'] = '{$a} seçeneği';
$string['optional'] = 'İsteğe bağlı - Bu bağımlılıklardan en az birinin yerine getirilmesi gerekir.';
$string['optionalname'] = 'Soru Adı';
$string['optionalname_help'] = 'Soru Adı yanıtları/Excel CSV formatında dışa aktarırken kullanılır.
Eğer CVS olarak dışa aktarmayacak sanız, soru adları hakkında hiç endişelenmenize gerek yok.
Eğer düzenli olarak anket verilerini CSV dosyasına aktarmayı planlıyorsanız, soru adlandırmak için iki seçeneğiniz var.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '-VEYA-';
$string['order_ascending'] = 'Artan sırada';
$string['order_default'] = 'Varsayılan sırada görüntüle';
$string['order_descending'] = 'Azalan sırada';
$string['orderresponses'] = 'Cevapları sırala';
$string['orderresponses_help'] = 'Tüm yanıtları görüntülerken, cevapların sayısına göre aşağıdaki (ortalama sutun) 4 soru tipinde sıralama seçeneğine sahipsiniz.
 *tek seçenekli radyo düğemis
 *tek seçenekli açılır kutu
 * birden fazla seçenek (onay kutuları)
* ölçek sorular (Likert ölçekleri dahil).
Tüm yanıtları sayfaya ulaştığında, varsayılan olarak tüm yanıtları Anketi oluşturan  kişinin soru seçimlerini girdiği sırayla sıralanır.
Siz daha sonra artan veya azalan düzende sıralayabilirsiniz';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Osgood';
$string['other'] = 'Diğer:';
$string['otherempty'] = 'Bu seçimi işaretlediyseniz, metin kutusuna bir metin girmeniz gerekir.';
$string['overviewnumresplog'] = 'cevaplar';
$string['overviewnumresplog1'] = 'cevaplar';
$string['overviewnumrespvw'] = 'cevaplar';
$string['overviewnumrespvw1'] = 'cevap';
$string['owner'] = 'sahibi';
$string['page'] = 'Sayfa';
$string['pageof'] = 'Sayfa {$a->page} den {$a->totpages}';
$string['parent'] = 'Ebeveyn';
$string['participant'] = 'Kursiyer';
$string['pleasecomplete'] = 'Lütfen bu seçeneği doldurun';
$string['pluginadministration'] = 'Anket Yönetimi';
$string['pluginname'] = 'Anket (Soru tabanlı form)';
$string['position'] = 'konum';
$string['possibleanswers'] = 'muhtemel cevaplar';
$string['posteddata'] = 'Yayınlanan veriler ile ulaşılan sayfa:';
$string['preview_label'] = 'Önizleme';
$string['preview_questionnaire'] = 'Anket Önizleme';
$string['previewing'] = 'Anket önizleme yapılıyor';
$string['previous'] = 'Önceki';
$string['previouspage'] = 'Önceki sayfa';
$string['print'] = 'Bu cevabı yazdır';
$string['printblank'] = 'Boş yazdır';
$string['printblanktooltip'] = 'Boş Anket Yazıcı-dostu bir pencere açar';
$string['printtooltip'] = 'Mevcut cevap Yazıcı-dostu bir pencere açar';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Çoktan seçmeli soru yanıtı.';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'Bu yanıt için bir seçim kaydının kimliğidir.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'Bu yanıt için soru kaydının kimliği.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Tek seçenekli bir soru yanıtı.';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'Bu yanıt için seçim kaydının kimliği.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'The ID of the question record for this response.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['privacy:metadata:questionnaire_response'] = 'Devam eden veya gönderilen bir yanıt';
$string['privacy:metadata:questionnaire_response:complete'] = 'Yanıt tamamlama durumu.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Bu yanıt için not.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'Bu yanıt için anket kaydının kimliği.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Bu yanıt için en son kaydetme zaman damgası.';
$string['privacy:metadata:questionnaire_response:userid'] = 'Bu yanıt için kullanıcının kimliği.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Bir boolean (evet/hayır) soru yanıtı.';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Belirli boolean yanıtı.';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'Bu yanıt için soru kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_date'] = 'Bir tarih sorusu yanıtı.';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'Bu yanıt için soru kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Belirli tarih cevabı.';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_other'] = '\'Diğer\' bir seçim metin yanıtı.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'Bu yanıt için seçim kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'Bu yanıt için soru kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Belirli metin cevabı.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Sıralı bir soru yanıtı.';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'Bu yanıt için seçim kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'Bu yanıt için soru kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Özel sıralama cevabı.';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_text'] = 'Metin sorusu yanıtı.';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'Bu yanıt için soru kaydının kimliği.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Özel metin cevabı.';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'Bu yanıt için yanıt kaydının kimliği.';
$string['private'] = 'Özel';
$string['progressbar'] = 'İlerleme çubuğunu göster';
$string['progressbar_info'] = 'Anket {$a} tamamlandı.';
$string['progresshelp'] = 'İlerleme Çubuğu';
$string['progresshelp_help'] = 'İlerleme çubuğunu tamamlamak için bir sonraki sayfaya geçin';
$string['public'] = 'Genel';
$string['publiccopy'] = 'Kopya:';
$string['publicoriginal'] = 'Orijinal:';
$string['qtype'] = 'Tür';
$string['qtype_help'] = 'Kullanıcıların bir kez, günlük, haftalık, aylık ya da sınırsız sayıda (çok) defa, cevap verebilecekleri türler için izin verin.';
$string['qtypedaily'] = 'günlük cevap';
$string['qtypemonthly'] = 'aylık cevap';
$string['qtypeonce'] = 'bir kez cevap';
$string['qtypeunlimited'] = 'birden fazla cevap';
$string['qtypeweekly'] = 'haftalık cevap';
$string['questionnaire:addinstance'] = 'Yeni anket formu ekle';
$string['questionnaire:copysurveys'] = 'Şablon ve özel anketi kopyala';
$string['questionnaire:createpublic'] = 'Genel anket ekle';
$string['questionnaire:createtemplates'] = 'Anket şablonu oluştur';
$string['questionnaire:deleteresponses'] = 'Herhangi bir cevabı sil';
$string['questionnaire:downloadresponses'] = 'Cevapları bir CVS dosyası olarak indir';
$string['questionnaire:editquestions'] = 'Anket sorularını ekle ve düzenle';
$string['questionnaire:manage'] = 'Anketi ekle ve düzenle';
$string['questionnaire:message'] = 'Cevap vermeyenlere mesaj gönder';
$string['questionnaire:preview'] = 'Anketi Önizle';
$string['questionnaire:printblank'] = 'Boş anket yazdır';
$string['questionnaire:readallresponseanytime'] = 'Cevapları her zaman okuyun';
$string['questionnaire:readallresponses'] = 'Konuları açtığında anket özetlerini okul';
$string['questionnaire:readownresponses'] = 'Kendi cevaplarını oku';
$string['questionnaire:submissionnotification'] = 'Her gönderim için bildirim al';
$string['questionnaire:submit'] = 'Anket tamamlandı ve gönderildi';
$string['questionnaire:view'] = 'Anketi görüntüle';
$string['questionnaire:viewsingleresponse'] = 'Kendi cevaplarını görüntüle';
$string['questionnaireadministration'] = 'Anket yönetimi';
$string['questionnairecloses'] = 'Anket sona erdi';
$string['questionnaireopens'] = 'Anket başladı';
$string['questionnairereport'] = 'Anket raporu';
$string['questionnum'] = 'Soru #';
$string['questions'] = 'Sorular';
$string['questionsinsection'] = 'Bu bölümdeki sorular:';
$string['questiontypes'] = 'Soru Tipi';
$string['questiontypes_help'] = 'Aşağıdaki Moodle Belgelerin bakın';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Radyo düğmesi';
$string['radiobuttons_help'] = 'Bu soru tipince cevap verenler bir seçenek seçmek zorundadırlar.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Sıra';
$string['ratescale'] = 'Oran (ölçek 1..5)';
$string['ratescale_help'] = 'Aşağıdaki Moodle Belgelerine bakın';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Anket Formu Türü';
$string['realm_help'] = '* ** Burada üç tür anket vardır: **
* Özel - sadece içinde tanımlanan kurs aittir.
*  Şablon - kopyalanabilir ve düzenlenebilir.
* Genel - kurslar arasında paylaşılabilir.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'Bu Anketi tamamladıktan sonra kullanıcının yönlendirildiği URL.';
$string['remove'] = 'Sil';
$string['removeallquestionnaireattempts'] = 'Ankete  verilen cevapların tümünü sil';
$string['removenotinuse'] = 'Bu anket formu , silinen genel anket formu dayanıyordu.
Artık kullanılamaz ve silinmelidir.';
$string['required'] = 'Cevaplanması zorunludur';
$string['required_help'] = 'Eğer ***EVET***\'ti seçerseniz. bu soru zorunlu hale gelecektir. örn.
              cevap verenler bu soruya cevap vermeden bu anketi gönderemeyeceklerdir.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Gerekli olan bir parametre eksik';
$string['reset'] = 'Sıfırla';
$string['respeligiblerepl'] = '(daha üst bir tarafandan değiştirildi)';
$string['respondent'] = 'Cevap veren';
$string['respondenteligibleall'] = 'tümü';
$string['respondenteligiblestudents'] = 'sadece öğrenciler';
$string['respondenteligibleteachers'] = 'sadece öğretmenler';
$string['respondents'] = 'Cevap verenler';
$string['respondenttype'] = 'Cevap veren türü';
$string['respondenttype_help'] = 'Siz "fullname" ayarlayarak her cevap veren kullanıcının adını görüntüyelebilirsiniz
Siz "anonymous" ayarlayarak cevap veren kullanıcıların isimlerini gizleyebilirsiniz.';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'anonim';
$string['respondenttypefullname'] = 'tam adı';
$string['response'] = 'Cevap';
$string['responsefieldlines'] = 'Giriş kutusu boyutu';
$string['responseformat'] = 'Cevap biçimi';
$string['responseoptions'] = 'Cevap seçenekleri';
$string['responses'] = 'Cevaplar';
$string['responseview'] = 'Öğrenciler TÜM cevapları görüntüleyebilir';
$string['responseview_help'] = 'Gönderilen anketlerin (genel istatistik tablo) tüm katılımcıların cevaplarını  kimlerin görebileceğini belirleyebilirsiniz.';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Her zaman';
$string['responseviewstudentsnever'] = 'Asla';
$string['responseviewstudentswhenanswered'] = 'Ankete cevap verdikten sonra';
$string['responseviewstudentswhenclosed'] = 'Ankete katılım bittikten sonra';
$string['restrictedtoteacher'] = 'Bu işlevler sadece düzenleme yapabilen öğretmenler ile sınırlıdır!';
$string['resume'] = 'Cevapları Onayla/Kaydet';
$string['resume_help'] = 'Bu seçeneği ayarlayarak kullanıcıların bir ankete verdikleri cevapları  göndermeden önce onları kaydetmelerine olanak verir. Kullanıcılar bitiremedikleri anketleri daha sonraki bir tarihte kaldıkları yerden devam edebilirler.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Ankete devam et';
$string['return'] = 'Geri dön';
$string['rightlabel'] = 'Sağ etiket';
$string['save'] = 'Kaydet';
$string['save_and_exit'] = 'Kaydet ve çık';
$string['saveasnew'] = 'Yeni soru olarak kaydet';
$string['savedbutnotsubmitted'] = 'Bu anket kaydedildi fakat henüz gönderilmedi';
$string['savedprogress'] = 'Çalışmalarınız kaydedildi. Bu anket formunu tamamlamak için herhangi bir zamanda dönebilirsiniz.';
$string['saveeditedquestion'] = 'Soru {$a}\'yı kaydet';
$string['savesettings'] = 'Ayarları kaydet';
$string['search:activity'] = 'Anket Formu - etkinlik bilgisi';
$string['search:question'] = 'Anket Formu -Sorular';
$string['section'] = 'Açıklama';
$string['sectionbreak'] = '-----  Sayfa Sonu-----';
$string['sectionbreak_help'] = '-----  Sayfa Sonu-----';
$string['sectionsnotset'] = 'Bölüm başına en az bir soru seçmelisiniz! <br /> Seçilmeyen bölümler: {$a}';
$string['sectiontext'] = 'Etiket';
$string['sectiontext_help'] = 'Bu bir soru değildir. fakat bir dizi soruyu açıklamak için görüntülenecek kısa bir metindir.';
$string['selecttheme'] = 'Bu anket ile kullanmak için bir tema (css) seçin.';
$string['send'] = 'Gönder';
$string['send_message'] = 'Seçilen kullanıcılara mesaj gönder';
$string['send_message_to'] = 'Mesaj Gönder:';
$string['sendemail'] = 'Eposta gönder';
$string['sendemail_help'] = 'Her gönderimin bir kopyasını belirtilen adrese veya adreslere gönderir.
Virgülle ayırarak birden fazla adres sağlayabilirsiniz.
E-posta yedeklemesi olmaması için boş bırakın. Buna erişmek için modül ayarlarında \'allowemailreporting\' etkinleştirilmelidir.';
$string['set'] = 'ayarla';
$string['settings'] = 'Ayarlar';
$string['settingssaved'] = 'Ayarlar kaydedildi';
$string['show_nonrespondents'] = 'Olmayan katılımcılar';
$string['slider'] = 'Slider';
$string['slider_help'] = 'Slider sorusu, katılımcıların bir slider\'ı iki uç nokta arasında sürükleyerek sürekli bir aralıktan bir değer seçmelerine olanak tanır. Bir merkez değer de belirlenebilir.';
$string['started'] = 'Başladı';
$string['startingvalue'] = 'Slider başlangıç değeri';
$string['startingvalue_help'] = 'Slider başlangıç değeri, slider\'ın katılımcılar için ilk olarak nerede görünmesi gerektiğini belirtir. Aralık bilinmediği için varsayılan değer 1\'dir. Merkezi bir değer vererek aralığın ortasından başlatmak isteyebilirsiniz (1-100 aralığının merkezi değeri 50\'dir).';
$string['stepvalue'] = 'Slider artış değeri';
$string['stepvalue_help'] = 'Slider artış değeri, katılımcıların aralıktaki yanıtlarını ne kadar hassas bir şekilde belirtmelerini istediğinizi gösterir. Soru varsayılan olarak bir artışla 1-100 aralığındadır ve katılımcıların 70, 71, 72, 73, 74 vb. değerler vermesine olanak tanır. Ancak bunun yerine, katılımcıların 60, 65, 70, 75, 80 vb. değerler vermesine olanak tanıyan beşlik artışlar ayarlayabilir veya yalnızca 1\'lik artışlarla 1-10 aralığını kullanabilirsiniz.';
$string['strfdate'] = '%g/%a/%Y';
$string['strfdateformatcsv'] = 'g/a/Y H:i:s';
$string['strictdateformatting'] = 'Aşağıdaki tarih seçiciyi kullanarak tarihi girin.';
$string['subject'] = 'Konu';
$string['submissionnotificationhtmlanon'] = '"{$a->name}" anketine yeni bir <a href="{$a->submissionurl}".> gönderim</a> var.';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a>\'nın "{$a->coursename}" kursundaki "{$a->name}" anketine yeni bir <a href="{$a->submissionurl}" iletisi</a> var.';
$string['submissionnotificationsubject'] = 'Yeni anket formu gönderimi';
$string['submissionnotificationtextanon'] = '"{$a->name}" anketine yeni bir gönderim ({$a->submissionurl}) var.';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}), "{$a->" kursundaki "{$a->name}" anketine yeni bir gönderim yaptı ({$a->submissionurl}) kursadı}".';
$string['submitoptions'] = 'Gönderme seçenekleri';
$string['submitpreview'] = 'Gönderi önizleme';
$string['submitpreviewcorrect'] = 'Bu gönderi doğru bir şekilde doldurulmuş olarak kabul edilecektir.';
$string['submitsurvey'] = 'Anketi gönder';
$string['submitted'] = ':de gönderildi';
$string['subtitle'] = 'Alt başlık';
$string['subtitle_help'] = 'Anket altbaşlığı: Ilk sayfada yalnızca başlık altında görünür.';
$string['summary'] = 'Özet';
$string['summaryreportattached'] = 'Anket özet raporu ektedir';
$string['surveynotexists'] = 'anket yok';
$string['surveyowner'] = 'Bu işlemi gerçekleştirmek için  anketin sahibi olmanız gerekir.';
$string['surveyresponse'] = 'Anket cevabı';
$string['template'] = 'Şablon';
$string['templatenotviewable'] = 'Anket şablonları görüntülenemez.';
$string['text'] = 'Soru Metni';
$string['textareacolumns'] = 'Metinalanı sutunlar';
$string['textareacolumns_help'] = 'Bu soru bir düz metin kutusu görüntüler.** x ** * Textarea sütunlar * (veya alan * genişlik *) ve ** y ** * Textarea satır * (metin sayısı
* çizgiler *).
Eğer x ve y varsayılan değerlerine gidersen ** 0 ** değer (ya da eğer sen koymak ** 0 **), sonra standart yükseklik ve Genişlik (Eğer HTML Düzenleyicisi görüntülenir
Kurs/kullanıcı bağlamı & kullanıcı profili kullanılabilir).';
$string['textarearows'] = 'Metinalanı Satırlar';
$string['textbox'] = 'Metin Kutusu';
$string['textbox_help'] = 'Metin kutusu soru türü için giriş kutusu uzunluğu ve cevaplayan tarafından girilecek metin maksimum metin uzunluğunu girin.
varsayılan değerler, giriş kutusu genişliği 20 karakter ve girilen metnin uzunluğu en fazla 25 karakterdir.';
$string['textdownloadoptions'] = 'CSV indirme seçenekleri';
$string['thank_head'] = 'Bu Anketi doldurduğunuz için teşekkür ederiz.';
$string['theme'] = 'Tema';
$string['thismonth'] = 'bu ay';
$string['thisresponse'] = 'Bu cevap';
$string['thisweek'] = 'bu hafta';
$string['thousands'] = 'Binlik ayırıcıları kullanmayın.';
$string['title'] = 'Başlık';
$string['title_help'] = 'Anket başlığı, her sayfanın başında görüntülenir. Varsayılan olarak anket adını kullanır.  Ancak istediğiniz gibi düzenleme yapabilirsiniz.';
$string['today'] = 'bugün';
$string['total'] = 'Toplam';
$string['totalofnumbers'] = 'Girilen rakamların toplamı';
$string['totalresponses'] = 'Soruya verilen toplam cevap';
$string['type'] = 'Soru tipi';
$string['undefinedquestiontype'] = 'Tanınmayan soru tip!';
$string['unknown'] = 'Bilinmeyen';
$string['unknownaction'] = 'Belirlenemeyen anket eylemi.';
$string['url'] = 'Onay Adresi';
$string['url_help'] = 'Herhangi bir kullanıcı bu anketi tamamladıktan sonra bu adrese  yönlendirilir.';
$string['useprivate'] = 'Varolandan koypala';
$string['usepublic'] = 'Genel yap';
$string['usetemplate'] = 'Şablon kullan';
$string['vertical'] = 'Dikey';
$string['view'] = 'Görünüm';
$string['viewallresponses'] = 'Tüm cevapları görüntüle';
$string['viewallresponses_help'] = 'Anket ** Grup Modu ** ayarlı ise: * Görünür gruplar *, ya da * Ayrı gruplar * ve geçerli kullanıcıya ayarlanır *moodle/site:accessallgroups*: yeteneği ölçüsünde(güncel bağlamda) *  gruplar Mevcut ders tanımlanmışlardır, daha sonra kullanıcı grupları bir açılan liste erişimi vardır. Bu açılır liste gruplar tarafından anket cevaplarını kullanıcıya göre "filtre" yapmaya yarar.


Ayarı ise ** grup modu **: * ayrı gruplar *, sonra sahip olmayan kullanıcılar * moodle / site: accessallgroups * yeteneği
(genellikle öğrenciler, veya düzenleme öğretmenler, vb) Sadece ait oldukları grupların cevaplarını görüntülemek mümkün olacak.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Cevaplayan listesi';
$string['viewindividualresponse'] = 'Bireysel cevaplar';
$string['viewindividualresponse_help'] = 'Bireysel cevapları görmek için aşağıdaki listedeki katılımcıların isimlerinin üzerine tıklayın.';
$string['viewresponses'] = 'Tüm cevaplayanlar ({$a})';
$string['viewyourresponses'] = 'Cevaplarınızı görüntüleyin';
$string['warning'] = 'Uyarı, hata ile karşılaşıldı.';
$string['wronganswers'] = 'Cevaplarınız bazı yanlışlar var  (aşağıya bakınız)';
$string['wrongdateformat'] = 'Girdiğiniz tarih: <strong>{$a}</strong> örnekte gösterilen formata uygun değil.';
$string['wrongdaterange'] = 'HATA! yıl 1902 2037 aralığında olmasıgerekir.';
$string['wrongformat'] = 'Sorulara verdiğiniz cevaplarda bazı yanlışlkılar var:&nbsp;';
$string['wrongformats'] = 'Sorulara verdiğiniz cevaplarda bazı yanlışlkılar var:&nbsp;';
$string['yesno'] = 'Evet / Hayır';
$string['yesno_help'] = 'Basit Evet / Hayır sorusu.';
$string['yourresponse'] = 'Cevaplarınızı görantüleyin';
$string['yourresponses'] = 'Cevaplarınızı görüntüleyin';
