<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'zoom', language 'tr', version '4.4'.
 *
 * @package     zoom
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountid'] = 'Zoom hesap kimliği';
$string['actions'] = 'Eylemler';
$string['activitydate:ended'] = 'Bitti:';
$string['activitydate:started'] = 'Başladı:';
$string['activitydate:starts'] = 'Başlangıç:';
$string['addparticipant'] = 'Katılımcı ekle';
$string['addparticipantgroup'] = 'Bir grup katılımcı ekleyin';
$string['addroom'] = 'Oda ekleyin';
$string['addroomalert'] = 'Tıklayarak bir oda ekleyin';
$string['addtocalendar'] = 'Takvime ekle';
$string['allmeetings'] = 'Tüm görüşmeler';
$string['allmeetings_desc'] = 'Bu ayarla, Zoom etkinlik dizin sayfasına giden bir bağlantının her etkinlik örneği genel bakış sayfasının altında gösterilip gösterilmeyeceğini kontrol edebilirsiniz. Bu ayar yalnızca Zoom etkinlik genel bakış sayfalarındaki bağlantının sunumunu etkiler. Bağlantıyı orada göstermemeye karar verseniz bile, kullanıcı kurs içindeki diğer bağlantılar aracılığıyla Zoom etkinlik dizini sayfasına erişebilir.';
$string['allmeetings_disable'] = 'Tüm toplantı bağlantısını devre dışı bırak';
$string['allmeetings_enable'] = 'Tüm toplantılar bağlantısını etkinleştir';
$string['alternative_hosts'] = 'Alternatif Barındırıcılar';
$string['alternative_hosts_desc'] = 'Bu ayar ile, etkinlik örneği ayarlarında alternatif ana bilgisayar seçme seçeneğinin kullanıcılara gösterilip gösterilmeyeceğini kontrol edebilirsiniz. İki tür widget mevcuttur: Virgülle ayrılmış e-posta adreslerini kabul eden düz bir giriş alanı. Ve kursa kayıtlı, Zoom hesabı olan ve {$a->roller} dışında bir rolü olan kullanıcıların kolayca seçilmesini sağlayan otomatik tamamlama özelliğine sahip bir kullanıcı seçici. Öğretmen tarafından doğrudan Zoom\'da ayarlanmış olabilecek ancak Moodle kullanıcı seçicisinden seçilemeyen alternatif ana bilgisayarlar, aktiviteye genel bakış sayfasında gösterilmeye devam eder ve Moodle içinden bir toplantı güncellendiğinde de korunur.';
$string['alternative_hosts_disable'] = 'Alternatif ana bilgisayar seçeneğini devre dışı bırak';
$string['alternative_hosts_help'] = 'Alternatif toplantı sahibi seçeneği, toplantıları planlamanıza ve yapamıyorsanız, toplantıyı veya web seminerini başlatmak için aynı hesapta başka bir Pro kullanıcı atamanıza olanak tanır. Bu kullanıcı, toplantıyı başlatmak için bir bağlantıyla birlikte alternatif bir toplantı sahibi olarak eklendiklerini bildiren bir e-posta alacak. Birden çok e-postayı virgülle ayırın (boşluksuz).';
$string['alternative_hosts_inputfield'] = 'Alternatif ana bilgisayar seçeneğini düz giriş alanı olarak göster';
$string['alternative_hosts_picker'] = 'Alternatif ana bilgisayar seçeneğini otomatik tamamlama ile kullanıcı seçici olarak göster';
$string['alternative_hosts_picker_help'] = 'Alternatif toplantı sahibi seçeneği, toplantı planlamanıza ve bu kursa kayıtlı diğer Zoom kullanıcısını/kullanıcılarını da toplantıyı başlatmak üzere atamanıza olanak tanır. Bu kullanıcılar, Zoom\'dan alternatif bir toplantı sahibi olarak eklendiklerini bildiren ve toplantıyı başlatmak için bir bağlantı içeren bir e-posta alacaklar.\\n\\n Toplantı ihtiyaçlarınıza göre bir veya daha fazla alternatif toplantı sahibi seçebilirsiniz.\\n\\n Eğer Bu kullanıcı seçicide belirli bir kullanıcıyı bulamıyorsunuz, bu kullanıcı ya bu kursa uygun bir rolle kayıtlı değil ya da Zoom\'da uygun bir hesaba sahip değil.';
$string['alternative_hosts_picker_noneselected'] = 'Alternatif ana bilgisayar seçilmedi';
$string['alternative_hosts_picker_placeholder'] = 'Kullanıcıları seçin';
$string['apiendpoint'] = 'Zoom API Uç Noktası';
$string['apiendpoint_desc'] = 'Zoom etkinliğinin bağlanmak için hangi Zoom API uç noktasını kullanacağını seçin. Genel API uç noktası tüm kullanıcılar için çalışmalıdır. Avrupa Birliği (AB) API uç noktası, yalnızca AB temel hazırlık seçeneğine sahip bir Zoom lisansına sahip kullanıcılara yöneliktir. Emin değilseniz, global API uç noktasını kullanın.';
$string['apiendpoint_eu'] = 'AB API Uç Noktası';
$string['apiendpoint_global'] = 'Genel API Uç Noktası';
$string['apiidentifier'] = 'Zoom API Tanımlayıcısı';
$string['apiidentifier_desc'] = 'Zoom API\'ye çağrı yaparken kullanılacak tanımlayıcı alanı';
$string['apiurl'] = 'Zoom API bağlantısı';
$string['apiurl_desc'] = '';
$string['audio_both'] = 'VoIP ve Telefon';
$string['audio_telephony'] = 'Sadece telefon';
$string['audio_voip'] = 'Yalnızca bilgisayar sesi';
$string['audiodefault'] = 'Ses varsayılanı';
$string['authentication'] = 'Kimlik doğrulama';
$string['autorecording_cloud'] = 'Bulut';
$string['autorecording_local'] = 'Yerel';
$string['autorecording_none'] = 'Yok';
$string['autorecording_userdefault'] = 'Varsayılan Zoom kullanıcı ayarlarını kullan';
$string['autorecordingoptionsupdate'] = 'Otomatik kayıt seçeneklerini güncelleyin';
$string['breakoutrooms'] = 'Zoom OAuth belirteci önbelleği';
$string['cachedef_oauth'] = 'Zoom OAuth belirteci önbelleği';
$string['cachedef_zoomid'] = 'Kullanıcının zoom kullanıcı kimliği';
$string['cachedef_zoommeetingsecurity'] = 'Hesabın parola gereksinimlerini karşılamak da dahil olmak üzere Zoom toplantısı güvenlik ayarları';
$string['calendardescriptionintro'] = '\\nAçıklama:\\n{\\$a}';
$string['calendariconalt'] = 'Takvim simgesi';
$string['changehost'] = 'Barındırıcıyı değiştir';
$string['clickjoin'] = 'Toplantıya katılma butonuna tıklandı';
$string['clientid'] = 'Zoom istemci kimliği';
$string['connectionfailed'] = 'Bağlantı başarısız oldu:';
$string['connectionok'] = 'Bağlantı çalışıyor.';
$string['connectionsettings'] = 'Bağlantı ayarları';
$string['connectionsettings_desc'] = 'Bu ayarlar Moodle\'ın Zoom\'a nasıl bağlanacağını tanımlar.';
$string['connectionstatus'] = 'Bağlantı durumu';
$string['day'] = 'Gün(ler)';
$string['defaultsettings'] = 'Varsayılan Zoom ayarları';
$string['defaultsettings_help'] = 'Bu ayarlar, tüm yeni Zoom toplantıları ve web seminerleri için varsayılanları tanımlar.';
$string['deletemeetingrecordings'] = 'Toplantı kayıtlarını Moodle\'dan silme';
$string['deleteroom'] = 'Odayı sil';
$string['displayleadtime'] = 'Teslim süresini göster';
$string['displayleadtime_desc'] = 'Etkinleştirilirse, teslim süresi kullanıcılara gösterilecektir. Bu şekilde, kullanıcılara planlanan başlangıç saatinden önce toplantıya katılabilecekleri / ne zaman katılabilecekleri bildirilir. Bu, kullanıcıların katılabilecekleri zamana kadar sayfayı sürekli olarak yeniden yüklemelerini engelleyebilir.';
$string['displayleadtime_nohideif'] = 'Lütfen unutmayın: Bu ayar yalnızca \'{$a}\' ayarı sıfırdan büyük bir değere ayarlanmışsa işlenir.';
$string['displaypassword'] = 'Şifreyi göster';
$string['displaypassword_help'] = 'Etkinleştirilirse, toplantı şifresi toplantı sahibi olmayanlara her zaman görüntülenir.';
$string['downloadical'] = 'iCal indir';
$string['downloadical_desc'] = 'Bu ayarla, etkinlik eşgörünümüne genel bakış sayfasında toplantı için bir iCal dosyası indirmek için bir bağlantının gösterilip gösterilmeyeceğini kontrol edebilirsiniz. Bu ayar yalnızca üçüncü taraf takvim araçları için bir iCal dosyası indirme olasılığını etkiler. Bu ayardan bağımsız olarak, Zoom toplantı etkinliği, toplantı başlangıç tarihi belirlenir belirlenmez Moodle takvimine bir takvim girişi ekleyecektir.';
$string['downloadical_disable'] = 'iCal bağlantısını indirmeyi devre dışı bırak';
$string['downloadical_enable'] = 'iCal bağlantısını indirmeyi etkinleştir';
$string['duration'] = 'Süre (dakika)';
$string['encryptiontype'] = 'Şifreleme tipi';
$string['encryptiontype_alwaysshow'] = 'Kullanıcının uçtan uca şifreleme kullanıp kullanamayacağına bakılmaksızın her zaman şifreleme türü seçiciyi göster';
$string['encryptiontype_desc'] = 'Bu ayarla, etkinlik örneği ayarlarında kullanıcılara gelişmiş şifreleme yerine uçtan uca şifrelemeyi seçme seçeneğinin gösterilip gösterilmeyeceğini kontrol edebilirsiniz. Bu ayar yalnızca Moodle etkinlik örneği ayarlarını etkiler. Seçeneği her zaman göstermeye karar verseniz bile, kullanıcının uçtan uca şifrelemeyi nihayet etkinleştirmek için Zoom\'da uçtan uca şifrelemeye ihtiyacı olacaktır.';
$string['encryptiontype_disable'] = 'Şifreleme türü seçiciyi devre dışı bırak';
$string['encryptiontype_showonlyife2epossible'] = 'Şifreleme türü seçiciyi yalnızca kullanıcı uçtan uca şifreleme kullanabiliyorsa göster';
$string['end_date_option_after'] = 'Sonra';
$string['end_date_option_occurrences'] = 'olaylar';
$string['enddate'] = 'Bitiş tarihi';
$string['endtime'] = 'Bitiş zamanı';
$string['err_downloadicaldisabled'] = 'Zoom toplantısı iCal dosyalarının indirilmesi devre dışı bırakıldı.';
$string['err_downloadicalrecurringempty'] = 'Zoom toplantısı iCal dosyasını indirmek, en az tek bir olay içermediği için bu toplantı için mümkün değildir.';
$string['err_downloadicalrecurringnofixed'] = 'Belirli bir zamanı olmayan yinelenen bir toplantı olduğu için bu toplantı için Zoom toplantısı iCal dosyasının indirilmesi mümkün değildir.';
$string['err_duration_nonpositive'] = 'Süre olumlu olmalı.';
$string['err_duration_too_long'] = 'Süre 150 saati aşamaz.';
$string['err_end_date'] = 'Yineleme bitiş tarihi eski tarihili olamaz';
$string['err_end_date_before_start'] = 'Yineleme bitiş tarihi, başlangıç tarihinden önce olamaz';
$string['err_invalid_password'] = 'Parola geçersiz karakterler içeriyor.';
$string['err_long_timeframe'] = 'İstenen zaman aralığı çok uzun, son ayın sonuçlarını gösteriyor.';
$string['err_password'] = 'Parola yalnızca şu karakterleri içerebilir: [az AZ 0-9 @ - _ *]. Maksimum 10 karakter.';
$string['err_password_required'] = 'Parola gerekli.';
$string['err_repeat_monthly_interval'] = 'Aylık toplantı için maksimum aralık 3 aydır';
$string['err_repeat_weekly_interval'] = 'Haftalık toplantı için maksimum aralık 12 haftadır';
$string['err_start_time_past'] = 'Başlangıç tarihi geçmiş bir tarih olamaz.';
$string['err_start_time_past_recurring'] = 'Yinelenen toplantılar için, bu alanın tarih kısmı bir sonraki toplantı için mümkün olan en erken tarihtir. Bu tarih bugün veya gelecekte olmalıdır.';
$string['err_weekly_days'] = 'Yinelenen haftalık toplantı için gün(ler) seçin';
$string['erroraddinstance'] = 'Yeni zoom toplantısı oluşturulamadı. Yinelenen bir toplantı için geçersiz seçenekler seçildi.';
$string['errorwebservice'] = 'Zoom web servisi hatası: {$a}.';
$string['errorwebservice_badrequest'] = 'Zoom hatalı bir istek aldı: {$a}';
$string['errorwebservice_notfound'] = 'Kaynak mevcut değil: {$a}';
$string['export'] = 'Dışa aktar';
$string['externaluser'] = 'Harici kullanıcı';
$string['firstjoin'] = 'İlk katılabilir';
$string['firstjoin_desc'] = 'Bir kullanıcı planlanmış bir toplantıya erkenden katılabilir (başlamadan dakikalar önce).';
$string['getmeetingrecordings'] = 'Zoom\'dan toplantı kayıtlarını alın';
$string['getmeetingreports'] = 'Zoom\'dan toplantı raporu alın';
$string['globalsettings'] = 'Genel ayarlar';
$string['globalsettings_desc'] = 'Bu ayarlar, bir bütün olarak Zoom eklentisi için geçerlidir.';
$string['host'] = 'Barındırıcı';
$string['hostintro'] = '<a target="_blank" href="https://support.zoom.us/hc/en-us/articles/208220166" >Alternatif Toplantı Sahipleri</a> Zoom toplantılarını başlatabilir ve Bekleme Odasını yönetebilir.';
$string['indicator:cognitivedepth'] = 'Zoom bilişsel derinliği';
$string['indicator:cognitivedepth_help'] = 'Bu gösterge, Zoom etkinliğinde öğrencinin ulaştığı bilişsel derinliğe dayanmaktadır.';
$string['indicator:socialbreadth'] = 'Zoom sosyal';
$string['indicator:socialbreadth_help'] = 'Bu gösterge, öğrencinin bir Zoom etkinliğinde ulaştığı sosyal genişliğe dayanmaktadır.';
$string['instanceusers'] = 'Örnek kullanıcıları kontrol edin';
$string['instanceusers_desc'] = 'Lisansları yeniden tanımla etkinleştirilmişse, yalnızca bu Moodle örneğindeki lisanslı kullanıcıları kontrol edin.  Ayrı örneklerin tek bir Zoom lisansı havuzunu böldüğü kurulumlar için kullanışlıdır.';
$string['invalid_status'] = 'Durum geçersiz, veritabanını kontrol edin.';
$string['invalidscheduleuser'] = 'Belirtilen kullanıcı için program yapamazsınız.';
$string['invitation_dialin'] = 'Desende arama';
$string['invitation_dialin_help'] = 'Rakamlarda Zoom toplantı kadranını bulmak için normal ifade kalıbı.';
$string['invitation_h323'] = 'H.323 mesaj kalıbı';
$string['invitation_h323_help'] = 'Zoom toplantısı H.323 bilgilerini bulmak için kullanılan regex deseni. Davetiyeleriniz SIP veya H.323 öğeleri içermiyorsa, eşleşen düzenli ifade desenini boş bir dizeye ayarlayın. (Bu özellikle hata ayıklamanın etkin olduğu sunucular için geçerlidir, çünkü iCal dışa aktarma gibi özel dosya türlerinin biçimini bozabilir).';
$string['invitation_icallink'] = 'iCal bağlantı mesajı kalıbı';
$string['invitation_icallink_help'] = 'Zoom toplantısı iCal bağlantısını bulmak için normal ifade kalıbı.';
$string['invitation_invite'] = 'Davet mesajı kalıbı';
$string['invitation_invite_help'] = 'Zoom toplantısı tanıtım mesajını bulmak için normal ifade kalıbı.';
$string['invitation_joinurl'] = 'URL kalıbına katıl';
$string['invitation_joinurl_help'] = 'Zoom toplantısına katılma url\'sini bulmak için normal ifade kalıbı.';
$string['invitation_onetapmobile'] = 'Tek dokunuşla mobil desen';
$string['invitation_onetapmobile_help'] = 'Zoom toplantısını bulmak için tek dokunuşla mobil ayrıntılar içeren regex deseni.';
$string['invitation_sip'] = 'SIP deseni';
$string['invitation_sip_help'] = 'Zoom toplantısı SIP bilgilerini bulmak için kullanılan regex kalıbı. Davetiyeleriniz SIP veya H.323 öğeleri içermiyorsa, eşleşen düzenli ifade desenini boş bir dizeye ayarlayın. (Bu özellikle hata ayıklamanın etkin olduğu sunucular için geçerlidir, çünkü iCal dışa aktarma gibi özel dosya türlerinin biçimini bozabilir).';
$string['invitationmatchnotfound'] = '"{$a->element}" öğesi için Zoom davetinde, "{$a->pattern}" kalıbıyla eşleşme bulunamadı.';
$string['invitationmodificationfailed'] = 'Zoom daveti öğesi için normal ifadede hata: "{$a->element}" ve desen: "{$a->pattern}".';
$string['invitationregex'] = 'Zoom daveti normal ifadesi ve yetenekleri';
$string['invitationregex_help'] = 'Bilginin yetenekler tarafından kontrol edilebilmesi için bir zoom davetinin her bir bölümünü izole etmek için düzenli ifade(regex) kalıplarını tanımlayın.';
$string['invitationregex_nohideif'] = 'Lütfen unutmayın: Normal ifade kalıpları yalnızca \'{$a}\' ayarı etkinleştirilmişse kullanılacaktır.';
$string['invitationregexenabled'] = 'Zoom daveti normal ifadesini ve özelliklerini etkinleştirin.';
$string['invitationregexenabled_help'] = 'Etkinleştirildiğinde, etkinlikte gösterilen zoom daveti, aşağıdaki normal ifade kullanılarak öğelere bölünecek ve her kullanıcıya hangi bölümlerin gösterileceğine karar vermek için yetenekler kullanılacaktır. Zoom/viewjoinurl ve zoom/viewdialin özelliklerine bakın.';
$string['invitationremoveicallink'] = 'Zoom  daveti iCal bağlantısını kaldır';
$string['invitationremoveicallink_help'] = 'Etkinleştirilirse, zoom toplantısı e-posta mesajına dahil edilebilecek iCal bağlantısı davetiye_icallink normal ifade kalıbı kullanılarak çıkarılacaktır.';
$string['invitationremoveinvite'] = 'Zoom daveti mesajını kaldır';
$string['invitationremoveinvite_help'] = 'Etkinleştirilirse, zoom toplantısı e-posta mesajındaki giriş cümlesi, davet_invite normal ifade kalıbı kullanılarak çıkarılacaktır.';
$string['join'] = 'Katıl';
$string['join_meeting'] = 'Toplantıya Katıl';
$string['joinbeforehost'] = 'Barındırıcıdan önce toplantıya katıl';
$string['joinbeforehostenable'] = 'Katılımcıların istedikleri zaman katılmasına izin ver';
$string['joinlink'] = 'katılma bağlantısı';
$string['jointime'] = 'Katılma zamanı';
$string['leavetime'] = 'Ayrılma zamanı';
$string['licenseonjoin'] = 'Toplantı sahibinin toplantıyı başlatırken ve oluştururken bir lisans almasını istiyorsanız bu seçeneği seçin.';
$string['licensesettings'] = 'Lisans ayarları';
$string['licensesettings_desc'] = 'Bu ayarlar, Moodle\'ın Zoom lisansınızı nasıl ele aldığını tanımlar.';
$string['licensesnumber'] = 'Lisans numarası';
$string['lowlicenses'] = 'Lisanslarınızın sayısı sınırı aşarsa, kullanıcı tarafından her yeni etkinlik oluşturduğunuzda, başka bir kullanıcının durumunu düşürerek ona bir PRO lisansı atanacaktır. Seçenek, aktif PRO lisanslarının sayısı 5\'ten fazla olduğunda etkilidir.';
$string['maskparticipantdata'] = 'Katılımcı verilerini maskeleyin';
$string['maskparticipantdata_help'] = 'Katılımcı verilerinin raporlarda görünmesini engeller (katılımcı verilerini maskeleyen siteler için kullanışlıdır, örneğin HIPAA için).';
$string['media'] = 'Ortam';
$string['meeting_finished'] = 'Bitti';
$string['meeting_invite'] = 'Telefon/Çevirme bilgileri';
$string['meeting_invite_hide'] = 'Toplantı davetini gizle';
$string['meeting_invite_show'] = 'Toplantı davetini göster';
$string['meeting_nonexistent_on_zoom'] = 'Zoom\'da yok';
$string['meeting_not_started'] = 'Başlamadı';
$string['meeting_started'] = 'Devam etmekte';
$string['meeting_time'] = 'Başlama zamanı';
$string['meetingcapacitywarning'] = 'Toplantı kapasitesi uyarısı';
$string['meetingcapacitywarning_desc'] = 'Bu ayarla, kursta toplantı sahibinin Zoom lisanslı toplantı kapasitesinden daha fazla aktif ve kayıtlı katılımcı varsa bir uyarı bildirimi gösterebilirsiniz. Bildirim toplantı sahibine (ve alternatif toplantı sahiplerine) Zoom etkinliğine genel bakış sayfasında gösterilecektir. Gerektiğinde daha büyük bir Zoom lisansı almak için toplantı sahibine Zoom hesap sahibine başvurmasını önerecektir. Bu mesajı Moodle dil özelleştirmesi ile değiştirebilirsiniz.';
$string['meetingcapacitywarning_disable'] = 'Toplantı kapasitesi uyarısını devre dışı bırak';
$string['meetingcapacitywarning_enable'] = 'Toplantı kapasitesi uyarısını etkinleştir';
$string['meetingcapacitywarningbodyalthost'] = 'Bu toplantıyı düzenleyen {$a->hostname} Zoom lisansı, <strong>{$a->meetingcapacity} toplantı katılımcısı</strong> kapasitesine sahiptir, ancak bu kursta <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} kayıtlı ve aktif katılımcı</a></strong>.';
$string['meetingcapacitywarningbodyrealhost'] = 'Zoom lisansınızın kapasitesi <strong><a href="{$a->zoomprofileurl}" target="_blank">{$a->meetingcapacity} toplantı katılımcıları</a></strong>\'dır, ancak bu kurs <strong><a href="{$a->courseparticipantsurl}">{$a->eligiblemeetingparticipants} kayıtlı ve aktif katılımcıya</a></strong> sahiptir.';
$string['meetingcapacitywarningcontactalthost'] = 'Bu kurs katılımcılarının tamamının toplantıya katılması gerekiyorsa, lütfen toplantı sahibinden daha büyük bir Zoom lisansı almak için Zoom hesabı sahibiyle iletişime geçmesini isteyin.';
$string['meetingcapacitywarningcontactrealhost'] = 'Bu kurs katılımcılarının tamamının toplantıya katılması gerekiyorsa lütfen daha büyük bir Zoom lisansı almak için Zoom hesap sahibine başvurun.';
$string['meetingcapacitywarningheading'] = 'Toplantı kapasitesi uyarısı:';
$string['meetingparticipantsdeleted'] = 'Toplantı katılımcısı kullanıcı verileri silindi.';
$string['meetingrecordingviewsdeleted'] = 'Toplantı kaydı kullanıcı görünümü verileri silindi.';
$string['modulename'] = 'Zoom toplantısı';
$string['modulename_help'] = 'Zoom, yetkili kullanıcılara çevrimiçi toplantılar yapma olanağı veren bir video ve web konferans platformudur.';
$string['modulenameplural'] = 'Zoom Toplantıları';
$string['month'] = 'Ay(lar)';
$string['month_day_text'] = 'ayın';
$string['newmeetings'] = 'Yeni Toplantılar';
$string['nextoccurrence'] = 'Sonraki oluşum';
$string['nomeetinginstances'] = 'Bu toplantı için hiçbir oturum bulunamadı.';
$string['nooccurrenceleft'] = 'Son olay çoktan bitti';
$string['noparticipants'] = 'Şu anda bu oturum için hiçbir katılımcı bulunamadı.';
$string['norecordings'] = 'Şu anda bu toplantı için kayıt bulunamadı.';
$string['norooms'] = 'Oda Yok';
$string['nosessions'] = 'Belirtilen aralık için oturum bulunamadı.';
$string['nozooms'] = 'Toplantı yok';
$string['nozoomsfound'] = 'Belirtilen kurs için toplantı bulunamadı.';
$string['occurson'] = 'Gerçekleşir';
$string['off'] = 'Kapalı';
$string['oldmeetings'] = 'Sonuçlanan Toplantılar';
$string['on'] = 'Açık';
$string['option_allow_recording_change'] = 'Değişiklik kaydına izin ver';
$string['option_allow_recording_change_help'] = 'Kullanıcının etkinlik oluşturma zamanında kayıt kurulumunu değiştirmesine izin ver';
$string['option_audio'] = 'Ses seçenekleri';
$string['option_audio_help'] = 'Bu seçenekle, kullanıcıların yalnızca Telefon, yalnızca Bilgisayar sesi veya her ikisini birden kullanarak arama yapmasına izin verebilirsiniz.';
$string['option_authenticated_users'] = 'Yalnızca kimliği doğrulanmış kullanıcılar';
$string['option_authenticated_users_help'] = 'Bu seçeneğin etkinleştirilmesi, tüm katılımcıların toplantıya katılabilmeleri için yetkili Zoom hesaplarıyla oturum açmalarını gerektirir. Hiçbir şekilde Moodle\'da oturum açmakla ilgili <em>değil</em>.';
$string['option_auto_recording'] = 'Otomatik kayıt';
$string['option_auto_recording_help'] = 'Bu seçeneğin etkinleştirilmesi toplantıyı otomatik olarak kaydeder';
$string['option_encryption_type'] = 'Şifreleme';
$string['option_encryption_type_endtoendencryption'] = 'Uçtan uca şifreleme';
$string['option_encryption_type_enhancedencryption'] = 'Gelişmiş şifreleme';
$string['option_encryption_type_help'] = 'Bu seçenekle, bu toplantının şifreleme düzeyini ve gizliliğini kontrol edersiniz.\\n\\n*Geliştirilmiş şifreleme*, şifreleme anahtarının Zoom bulutunda saklandığı anlamına gelir.\\n\\n*Uçtan uca şifreleme* şu anlama gelir: şifreleme anahtarı yerel cihazınızda depolanır ve şifreleme anahtarınızı Zoom dahil hiç kimse alamaz.\\n\\nUçtan uca şifrelemeyi etkinleştirdiğinizde, bazı özelliklerin toplantı içinden kullanılamayacağını lütfen unutmayın - [Ayrıntıları Zoom belgelerine bakın](https://support.zoom.us/hc/en-us/articles/360048660871).';
$string['option_host_video'] = 'Barındırıcı videosu';
$string['option_host_video_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantı sahibinin toplantıya katılırken videosunu etkinleştirir. Kapatmayı seçseniz bile sunucunun videosunu başlatma seçeneği olacaktır.';
$string['option_jbh'] = 'Toplantı sahibinden önce katılmayı etkinleştir';
$string['option_jbh_help'] = 'Bu seçeneğin etkinleştirilmesi, katılımcıların toplantı sahibi katılmadan önce veya toplantı sahibi toplantıya katılamadığında katılmasına olanak tanır.\\n\\nBu seçenek, \'Bekleme odası\' seçeneğiyle birbirini dışlar, bu nedenle birini seçmek diğerini devre dışı bırakır.';
$string['option_mute_upon_entry'] = 'Girişi sessiz al';
$string['option_mute_upon_entry_help'] = 'Toplantıya katıldıklarında tüm katılımcıları otomatik olarak sessize alın. Toplantı sahibi, katılımcıların kendi seslerini açıp açamayacağını kontrol eder.';
$string['option_participants_video'] = 'Katılımcılar videosu';
$string['option_participants_video_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantıya katılırken katılımcıların videosunu etkinleştirir. Kapatmayı seçseniz bile, katılımcıların videolarını başlatma seçeneği olacaktır.';
$string['option_proxyhost'] = 'Proxy kullan';
$string['option_proxyhost_desc'] = 'Burada ayarlanan proxy, \'<code>&lt;hostname&gt;:&lt;port&gt;</code>\'  yalnızca Zoom ile iletişim kurmak için kullanılır. Moodle varsayılan proxy ayarlarını kullanmak için boş bırakın. Bunu yalnızca Moodle\'da global bir proxy ayarlamak istemiyorsanız ayarlamanız gerekir.';
$string['option_view_recordings'] = 'Kayıtların görüntülenmesine izin ver';
$string['option_waiting_room'] = 'Bekleme odasını etkinleştir';
$string['option_waiting_room_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantı sahibinin bir katılımcının toplantıya ne zaman katılacağını kontrol etmesine olanak tanır.\\n\\nBu seçenek, \'Toplantı sahibinden önce katıl\' seçeneğiyle birbirini dışlar, bu nedenle birini seçmek diğerini devre dışı bırakır.';
$string['participantdatanotavailable'] = 'Ayrıntılar mevcut değil';
$string['participantdatanotavailable_help'] = 'Katılımcı verileri bu Zoom oturumu için mevcut değil (örn. HIPAA uyumluluğu nedeniyle).';
$string['participantgroups'] = 'Katılımcı grupları';
$string['participants'] = 'Katılımcılar';
$string['password'] = 'Parola';
$string['password_allowed_char'] = 'Parola yalnızca şu karakterleri içerebilir: [a-z A-Z 0-9 @ - _ *].';
$string['password_consecutive'] = 'Maksimum {$a} ardışık karakter (abcd, 1111, 1234, vb.).';
$string['password_length'] = 'Minimum {$a} karakter(ler).';
$string['password_letter'] = 'Şifre en az 1 harf içermelidir.';
$string['password_lower_upper'] = 'Parola hem küçük hem de büyük karakterler içermelidir.';
$string['password_max_length'] = 'Maksimum 10 karakter.';
$string['password_number'] = 'Parola en az 1 sayı içermelidir.';
$string['password_only_numeric'] = 'Parola yalnızca sayı içerebilir ve başka karakter içermemelidir.';
$string['password_special'] = 'Parola en az 1 özel karakter (@-_*) içermelidir.';
$string['passwordprotected'] = 'Parola Korumalı';
$string['pluginadministration'] = 'Zoom toplantısını yönet';
$string['pluginname'] = 'Zoom toplantısı';
$string['privacy:metadata:zoom_breakout_participants'] = 'Zoom toplantı ara odaları katılımcılarının bir listesini depolamak için veritabanı tablosu';
$string['privacy:metadata:zoom_breakout_participants:userid'] = 'Katılımcının kullanıcı kimliği';
$string['privacy:metadata:zoom_meeting_details'] = 'Her toplantı örneği hakkındaki bilgileri depolayan veritabanı tablosu.';
$string['privacy:metadata:zoom_meeting_details:topic'] = 'Kullanıcının katıldığı toplantının adı.';
$string['privacy:metadata:zoom_meeting_participants'] = 'Toplantı katılımcıları hakkındaki bilgileri depolayan veritabanı tablosu.';
$string['privacy:metadata:zoom_meeting_participants:duration'] = 'Katılımcının toplantıda ne kadar kaldığı';
$string['privacy:metadata:zoom_meeting_participants:join_time'] = 'Katılımcının toplantıya katılma zamanı';
$string['privacy:metadata:zoom_meeting_participants:leave_time'] = 'Katılımcının toplantıdan ayrıldığı saat';
$string['privacy:metadata:zoom_meeting_participants:name'] = 'Katılımcının adı';
$string['privacy:metadata:zoom_meeting_participants:user_email'] = 'Katılımcının e-postası';
$string['privacy:metadata:zoom_meeting_view'] = 'Toplantı kayıtlarını görüntüleyen kullanıcıları izlemek için veritabanı tablosu';
$string['privacy:metadata:zoom_meeting_view:userid'] = 'Kaydı görüntüleyen kullanıcının kimliği';
$string['recording'] = 'Kayıt';
$string['recordingadd'] = 'Kayıt Ekle';
$string['recordingdate'] = 'Kayıt Tarihi';
$string['recordingdelete'] = '"{$a}" kaydını silmek istediğinizden emin misiniz?';
$string['recordinghide'] = 'Kaydı Gizle (Şu Anda Görünür)';
$string['recordinglink'] = 'Kayıt Bağlantısı';
$string['recordingname'] = 'Başlık';
$string['recordingnotfound'] = 'Kayıt bulunamadı';
$string['recordingnotvisible'] = 'Kayıt görünmüyor. Bunun bir hata olduğunu düşünüyorsanız lütfen Sistem Yöneticinizle iletişime geçin.';
$string['recordingpasscode'] = 'Kayıt Şifresi';
$string['recordings'] = 'Kayıtlar';
$string['recordingshow'] = 'Kaydı Göster (Şu Anda Gizli)';
$string['recordingshowtoggle'] = 'Kaydı Göster\'i Değiştir';
$string['recordingurl'] = 'Kayıt URL\'si';
$string['recordingview'] = 'Kayıtları Görüntüle';
$string['recordingvisibility'] = 'Bu toplantının kayıtları varsayılan olarak görünür mü?';
$string['recordingvisibility_help'] = 'Bu toplantı için yeni kayıtlar getirildiğinde, varsayılan olarak Moodle\'da görünür olmaları gerekir mi?';
$string['recreatesuccessful'] = 'Toplantı başarıyla yeniden oluşturuldu';
$string['recurrence_option_daily'] = 'Günlük';
$string['recurrence_option_monthly'] = 'Aylık';
$string['recurrence_option_no_time'] = 'Sabit Zaman Yok';
$string['recurrence_option_weekly'] = 'Haftalık';
$string['recurrencetype'] = 'Tekrarlama';
$string['recurringmeeting'] = 'Tekrarlayan';
$string['recurringmeeting_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantıyı bitiş tarihi veya saati olmayan yinelenen bir toplantı haline getirecektir. Daha sonra her zaman erişilebilir.';
$string['recurringmeetingexplanation'] = 'Toplantının bitiş tarihi veya saati yok';
$string['recurringmeetinglong'] = 'Devam eden toplantı (bitiş tarihi veya saati olmayan toplantı)';
$string['recurringmeetingthisis'] = 'Bu yinelenen bir toplantıdır';
$string['recycleonjoin'] = 'Katıldıktan sonra lisansı geri dönüştürün';
$string['redefinelicenses'] = 'Lisansları yeniden tanımlayın';
$string['refreshreports'] = 'Oturum raporlarını yenile';
$string['register'] = 'Kayıt ol';
$string['registration'] = 'Kayıt gerektir';
$string['registration_help'] = 'Bu seçeneğin etkinleştirilmesi, katılımcıları katılmadan önce Zoom toplantısına/web seminerine kaydolmaya zorlar.';
$string['registration_text'] = 'Katılımcıları toplantıya/web seminerine kaydolmaya zorla';
$string['repeatinterval'] = 'Şu aralıklarla tekarla';
$string['report'] = 'Raporlar';
$string['reportapicalls'] = 'Bitmiş API aramaları raporu';
$string['requirepasscode'] = 'Toplantı şifresi gerekli';
$string['requirepasscode_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantı sahibinin toplantı için bir parola belirlemesini gerektirecektir. Toplantıya katılan katılımcıların toplantıya katılmadan önce bu şifreyi girmeleri gerekecektir. Toplantıya Moodle etkinliği içinden giren katılımcıların bu parolayı girmesi gerekmez.';
$string['resetapicalls'] = 'Mevcut API çağrılarının sayısını sıfırlayın';
$string['resetzoomsall'] = 'Tüm kullanıcı notlarını, kayıt kullanıcı görüntüleme verilerini ve toplantı katılımcısı kullanıcı verilerini silin.';
$string['room'] = 'Oda';
$string['roomname'] = 'Oda ismi';
$string['rooms'] = 'Odalar';
$string['schedule'] = 'Planla';
$string['schedulefor'] = 'Toplantı planla';
$string['schedulefor_help'] = 'Başka bir kullanıcı adına toplantı planlayabilirsiniz.  Önkoşul olarak, bu kullanıcı size Zoom\'da planlama ayrıcalığı atamış olmalıdır.  Seçilen kullanıcı, toplantının sahibi olacak ve toplantı için Zoom lisansı kullanılacak olan kullanıcı olacaktır.';
$string['scheduleforself'] = 'Kendiniz için program yapın';
$string['schedulingprivilege'] = 'Planlama ayrıcalığı';
$string['schedulingprivilege_desc'] = 'Bu ayar ile etkinlik eşgörünümü ayarlarında kullanıcılara zamanlama ayrıcalığı seçeneğinin gösterilip gösterilmeyeceğini kontrol edebilirsiniz. Bu ayar yalnızca Moodle etkinlik örneği ayarlarını etkiler. Seçeneği göstermeye karar verseniz bile, kullanıcının son olarak diğer kullanıcı için bir toplantı planlamak üzere Zoom\'da başka bir kullanıcı tarafından verilen planlama ayrıcalığına sahip olması gerekir.';
$string['schedulingprivilege_disable'] = 'Zamanlama ayrıcalığı seçeneğini devre dışı bırak';
$string['schedulingprivilege_enable'] = 'Zamanlama ayrıcalığı seçeneğini etkinleştir';
$string['search:activity'] = 'Zoom - etkinlik bilgileri';
$string['security'] = 'Güvenlik';
$string['selectionarea'] = 'Seçim';
$string['sessions'] = 'Oturum';
$string['sessionsreport'] = 'Oturum raporu';
$string['sesskeyinvalid'] = 'Geçersiz oturum algılandı. Daha fazla ilerleyemiyorum.';
$string['setpasscode'] = 'Şifre ayarla';
$string['showmedia'] = 'Medya bölümünü göster';
$string['showmedia_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantı etkinliği sayfasında Medya bölümünü gösterir.';
$string['showmediaonview'] = 'Toplantı sayfasında Medya bölümünü göster';
$string['showschedule'] = 'Program bölümünü göster';
$string['showschedule_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantı etkinliği sayfasında Zamanlama bölümünü gösterecektir.';
$string['showscheduleonview'] = 'Toplantı sayfasında Plan bölümünü göster';
$string['showsecurity'] = 'Güvenlik bölümünü göster';
$string['showsecurity_help'] = 'Bu seçeneğin etkinleştirilmesi, toplantı etkinliği sayfasındaki Güvenlik bölümünü gösterecektir.';
$string['showsecurityonview'] = 'Toplantı sayfasında Güvenlik bölümünü göster';
$string['start'] = 'Başlat';
$string['start_meeting'] = 'Toplantıyı Başlat';
$string['start_time'] = 'Ne zaman';
$string['starthostjoins'] = 'Barındırıcı katıldığında videoyu başlat';
$string['startpartjoins'] = 'Katılımcı katıldığında video başlat';
$string['starttime'] = 'Başlama zamanı';
$string['status'] = 'Durum';
$string['supplementaryfeaturessettings'] = 'Tamamlayıcı özellikler ayarları';
$string['supplementaryfeaturessettings_desc'] = 'Bu ayarlar, kullanıcılara tamamlayıcı Zoom özelliklerinin sağlanıp sağlanmadığını ve nasıl sağlanacağını kontrol eder.';
$string['title'] = 'Başlık';
$string['topic'] = 'Konu';
$string['trackingfields'] = 'İzleme alanları';
$string['trackingfields_help'] = 'Zoom etkinliklerini etkinleştirmek için izleme alanı adlarını/etiketlerini virgülle ayırarak girin.';
$string['trackingfields_recommendedvalues'] = 'Önerilen değerler:';
$string['unavailable'] = 'Şu anda katılamıyor';
$string['unavailablefinished'] = 'Toplantı çoktan bitti.';
$string['unavailablefirstjoin'] = 'En erken planlanan başlangıç saatinden {$a->mins} dakika önce katılabilirsiniz.';
$string['unavailablenotstartedyet'] = 'Toplantı henüz başlamadı.';
$string['updatemeetings'] = 'Zoom\'dan toplantı ayarlarını güncelleyin';
$string['updatetrackingfields'] = 'İzleme alanı ayarlarını Zoom\'dan güncelleyin';
$string['usepersonalmeeting'] = 'Kişisel toplantı kimliğini kullanın {$a}';
$string['waitingroom'] = 'Bekleme odası';
$string['waitingroomenable'] = 'Bekleme odasını etkinleştir';
$string['webinar'] = 'Webinar';
$string['webinar_already_false'] = '<p><b>Bu modül, web semineri değil, zaten bir toplantı olarak ayarlandı. Toplantıyı oluşturduktan sonra bu ayarı değiştiremezsiniz.</b></p>';
$string['webinar_already_true'] = '<p><b>Bu modül zaten bir web semineri olarak ayarlanmıştı, toplantı değil. Web seminerini oluşturduktan sonra bu ayarı değiştiremezsiniz.</b></p>';
$string['webinar_alwaysshow'] = 'Kullanıcının web seminerleri barındırma lisansına sahip olup olmadığına bakılmaksızın her zaman web semineri seçeneğini göster';
$string['webinar_by_default'] = 'Varsayılan olarak web semineri';
$string['webinar_by_default_desc'] = 'Varsayılan olarak bir web semineri olarak Zoom örneği oluşturun.';
$string['webinar_desc'] = 'Bu ayar ile toplantı oluşturulurken web semineri oluşturma seçeneğinin kullanıcılara gösterilip gösterilmeyeceğini kontrol edebilirsiniz.  Bu ayar yalnızca Moodle etkinlik örneği ayarlarını etkiler.  Seçeneği her zaman göstermeye karar verseniz bile, kullanıcının web seminerlerinin sonunda bir web semineri barındırması için geçerli bir lisansa ihtiyacı olacaktır.';
$string['webinar_disable'] = 'Web seminerlerini devre dışı bırak';
$string['webinar_help'] = 'Bu seçenek yalnızca önceden yetkilendirilmiş Zoom hesapları için kullanılabilir.';
$string['webinar_showonlyiflicense'] = 'Web semineri seçeneğini yalnızca kullanıcının web seminerlerini barındırmak için lisansı varsa göster';
$string['webinarthisis'] = 'Bu bir web semineri';
$string['week'] = 'Haftal(ar)';
$string['weekoption_first'] = 'Birinci';
$string['weekoption_fourth'] = 'Dördüncü';
$string['weekoption_last'] = 'Sonuncu';
$string['weekoption_second'] = 'İkinci';
$string['weekoption_third'] = 'Üçüncü';
$string['zoom:addinstance'] = 'Yeni bir Zoom toplantısı ekle';
$string['zoom:eligiblealternativehost'] = 'Zoom toplantılarında alternatif toplantı sahibi olarak seçilebilir';
$string['zoom:refreshsessions'] = 'Zoom toplantı raporlarını yenile';
$string['zoom:view'] = 'Zoom toplantılarını görüntüleyin';
$string['zoom:viewdialin'] = 'Zoom arama bilgilerini görüntüleyin';
$string['zoom:viewjoinurl'] = 'Zoom katılım url\'sini görüntüle';
$string['zoomerr'] = 'Zoom ile ilgili bir hata oluştu.';
$string['zoomerr_alternativehostusernotfound'] = '{$a} kullanıcısı Zoom\'da bulunamadı.';
$string['zoomerr_apilimit'] = 'Bu API için maksimum günlük oran sınırına ulaşıldı. {$a} konumunda yeniden dene';
$string['zoomerr_field_missing'] = '{$a} bulunamadı';
$string['zoomerr_id_missing'] = 'Bir course_module kimliği veya bir örnek kimliği belirtmelisiniz';
$string['zoomerr_licensesnumber_missing'] = 'Zoom ayarı bulundu, ancak lisans numarası ayarı bulunamadı';
$string['zoomerr_maxretries'] = 'Çağrıyı yapmak için {$a->maxretries} kez yeniden denedi, ancak başarısız oldu: {$a->response}';
$string['zoomerr_meetingnotfound'] = 'Bu toplantı Zoom\'da bulunamıyor. <a href="{$a->recreate}">burada yeniden oluşturabilir</a> veya <a href="{$a->delete}">tamamen silebilirsiniz</a>.';
$string['zoomerr_meetingnotfound_info'] = 'Bu toplantı Zoom\'da bulunamıyor. Sorularınız varsa lütfen toplantı sahibiyle iletişime geçin.';
$string['zoomerr_no_access_token'] = 'Erişim belirteci döndürülmedi';
$string['zoomerr_scopes'] = 'Zoom OAuth yapılandırmasında bu gerekli kapsamlar eksik: {$a}';
$string['zoomerr_usernotfound'] = 'Zoom\'u ilk defa kullanıyorsunuz, bu nedenle, oturum açma kimlik bilgilerinizle <a href="{$a}" target="{blank"> {$a} </a> oturum açarak Zoom hesabınızı etkinleştirmeniz gerekir. Zoom hesabınızı etkinleştirdikten sonra, bu sayfayı yeniden yükleyin ve toplantı ayarlarınızı yapmaya devam edin.';
$string['zoomerr_viewrecordings_off'] = 'Kayıtları Görüntüle kapalı, görev çalıştırılamaz';
$string['zoomurl'] = 'Zoom ana sayfa bağlantısı';
