<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'et', version '4.4'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Ülesande tegevuse manused';
$string['activitydate:submissionsdue'] = 'Tähtaeg:';
$string['activitydate:submissionsopen'] = 'Avaneb:';
$string['activitydate:submissionsopened'] = 'Avatud:';
$string['activityeditor'] = 'Tegevusjuhend';
$string['activityeditor_help'] = 'Tegevused, mis õpilasel on vaja selle tegevuse lõpetamiseks teha. Seda juhendit kuvatakse vaid ülesande esitamise lehel, kus õpilane saab oma tööd muuta ja esitada.';
$string['activityoverview'] = 'Teil on tähelepanu vajavaid ülesandeid';
$string['addattempt'] = 'Luba veel üks katse';
$string['addnewattempt'] = 'Lisa uus katse';
$string['addnewattempt_help'] = 'Sellega luuakse uus tühi esitusvorm, millega saate töötada.';
$string['addnewattemptfromprevious'] = 'Lisa uus eelneval esitamisel põhinev katse';
$string['addnewattemptfromprevious_help'] = 'Saate eelmise esitatud töö sisu kopeerida uude esitatavasse töösse, millega praegu töötate.';
$string['addnewgroupoverride'] = 'Lisa rühma testisätete ülekirjutus';
$string['addnewuseroverride'] = 'Lisa kasutaja testisätete ülekirjutus';
$string['addsubmission'] = 'Lisa esitatav töö';
$string['addsubmission_help'] = 'Sa ei ole esitamist teinud.';
$string['allocatedmarker'] = 'Määratud hindaja';
$string['allocatedmarker_help'] = 'Selle esitatud töö hindajaks on määratud';
$string['allowsubmissions'] = 'Saate lubada kasutajal jätkata selle ülesande vastuste esitamist.';
$string['allowsubmissionsfromdate'] = 'Luba töö esitamine alates';
$string['allowsubmissionsfromdate_help'] = 'Kui see säte on lubatud, siis ei saa õppijad töid esitada enne märgitud aega. Kui see säte on keelatud, siis saavad õppijad töid esitada kohe.';
$string['allowsubmissionsshort'] = 'Luba esitatud töö muutmine';
$string['alwaysshowdescription'] = 'Kuva kirjeldus alati';
$string['alwaysshowdescription_help'] = 'Kui see säte on keelatud, siis näevad õppijad ülesande kirjeldust alles pärast väljal „Luba töö esitamine alates“ määratud kuupäeva.';
$string['applytoteam'] = 'Rakenda hinded ja tagasiside kogu rühmale';
$string['assign:addinstance'] = 'Lisa uus ülesanne';
$string['assign:editothersubmission'] = 'Muuda teise õppija esitatud tööd';
$string['assign:exportownsubmission'] = 'Ekspordi oma esitatud töö';
$string['assign:grade'] = 'Hinda ülesannet';
$string['assign:grantextension'] = 'Pikenda töö esitamise tähtaega';
$string['assign:manageallocations'] = 'Halda esitatud tööde hindajaid';
$string['assign:managegrades'] = 'Vaata üle ja avalda hinded';
$string['assign:manageoverrides'] = 'Halda ülesannete ülekirjutusi';
$string['assign:receivegradernotifications'] = 'Võta vastu hindaja esitatud tööde teatised';
$string['assign:releasegrades'] = 'Avalda hinded';
$string['assign:revealidentities'] = 'Avalikusta õppijate isikud';
$string['assign:reviewgrades'] = 'Vaata hinded üle';
$string['assign:showhiddengrader'] = 'Vaata peidetud hindaja identiteeti.';
$string['assign:submit'] = 'Esita ülesande vastus';
$string['assign:view'] = 'Vaata ülesannet';
$string['assign:viewblinddetails'] = 'Kuva õppijate isikud, kui pimehindamine on lubatud';
$string['assign:viewgrades'] = 'Vaata hindeid';
$string['assign:viewownsubmissionsummary'] = 'Vaata oma esitatud töö kokkuvõtet';
$string['assignfeedback'] = 'Tagasisidelisandmoodul';
$string['assignfeedbackpluginname'] = 'Tagasisidelisandmoodul';
$string['assignmentisdue'] = 'Ülesande tähtaeg on möödas';
$string['assignmentmail'] = '{$a->grader} on postitanud tagasisidet teie ülesandega \'{$a->assignment}\' seotud esitatud töö kohta.

Tagasiside on lisatud esitatud tööle:

    {$a->url}';
$string['assignmentmailhtml'] = '<p>{$a->grader} on postitanud tagasisidet teie ülesandega \'<i>{$a->assignment}</i>\' seotud esitatud töö kohta.</p>
<p>Tagasiside on lisatud <a href="{$a->url}">esitatud tööle</a>.</p>';
$string['assignmentmailsmall'] = '{$a->grader} on postitanud tagasisidet teie ülesandega \'{$a->assignment}\' seotud esitatud töö kohta. Tagasiside on lisatud teie esitatud tööle.';
$string['assignmentname'] = 'Ülesande nimi';
$string['assignmentplugins'] = 'Ülesande lisandmoodulid';
$string['assignmentsperpage'] = 'Ülesandeid lehe kohta';
$string['assignsubmission'] = 'Esitamise lisandmoodul';
$string['assignsubmissionpluginname'] = 'Esitamise lisandmoodul';
$string['assigntimeleft'] = 'Aega jäänud';
$string['attemptheading'] = 'Katse {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Eelnevad soorituskatsed';
$string['attemptnumber'] = 'Soorituskatse number';
$string['attemptreopenmethod'] = 'Soorituskatsed on uuesti avatud';
$string['attemptreopenmethod_help'] = 'Määrab selle, kuidas õppijate esitatud tööd uuesti avatakse. Saadaolevad valikud on järgmised. <ul><li>Mitte kunagi – õppijate esitatud töid ei saa uuesti avada.</li><li>Käsitsi – õpetaja saab õppija esitatud töö käsitsi uuesti avada.</li><li>Automaatselt kuni läbimiseni – õppijate esitatud tööd avatakse automaatselt uuesti niikaua, kuni nad saavad selle ülesande eest hinnetelehel (hinnetelehe häälestamise jaotises) määratud positiivse hinde.</li></ul>';
$string['attemptreopenmethod_manual'] = 'Käsitsi';
$string['attemptreopenmethod_none'] = 'Mitte kunagi';
$string['attemptreopenmethod_untilpass'] = 'Automaatselt kuni läbimiseni';
$string['attemptsettings'] = 'Katse sätted';
$string['availability'] = 'Kättesaadavus';
$string['back'] = 'Tagasi';
$string['backtoassignment'] = 'Tagasi ülesande juurde';
$string['batchoperationconfirmaddattempt'] = 'Kas soovite valitud tööde puhul lubada veel ühe soorituskatse?';
$string['batchoperationconfirmdownloadselected'] = 'Kas soovite kõik valitud esitatud tööd alla laadida?';
$string['batchoperationconfirmgrantextension'] = 'Kas soovite kõigi valitud tööde esitamise tähtaega pikendada?';
$string['batchoperationconfirmlock'] = 'Kas soovite kõik valitud esitatud tööd lukustada?';
$string['batchoperationconfirmremovesubmission'] = 'Eemalda valitud esitamised';
$string['batchoperationconfirmreverttodraft'] = 'Kas soovite valitud esitatud tööd mustandiks märkida?';
$string['batchoperationconfirmsetmarkingallocation'] = 'Kas soovite hindaja määrata kõigi valitud esitatud tööde jaoks?';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Kas soovite hindamise töövoo oleku määrata kõigi valitud esitatud tööde jaoks?';
$string['batchoperationconfirmunlock'] = 'Kas soovite kõik valitud esitatud tööd lukust avada?';
$string['batchoperationlock'] = 'lukusta esitatud tööd';
$string['batchoperationreverttodraft'] = 'märgi esitused mustandiks';
$string['batchoperationsdescription'] = 'Valitutega...';
$string['batchoperationunlock'] = 'ava esitatud tööd';
$string['batchsetallocatedmarker'] = 'Määra hindaja {$a} valitud kasutaja jaoks.';
$string['batchsetmarkingworkflowstateforusers'] = 'Määra hindamise töövoo olek {$a} valitud kasutaja jaoks.';
$string['beginassignment'] = 'Alusta ülesannet';
$string['blindmarking'] = 'Anonüümsed esitused';
$string['blindmarking_help'] = 'Anonüümsete esituste korral on õppijate isikuandmed hindajate eest varjatud. Esituse seadistus lukustatakse, kui see ülesanne on hinnatud.';
$string['blindmarkingenabledwarning'] = 'Selle Tegevuse puhul on pimehindamine lubatud. Hindeid ei lisata hindajaaruandesse, kuni õpilased on läbi hindamistegevuse menüü tuvastatud.';
$string['cachedef_overrides'] = 'Kasutajate ja rühmade ülekirjutuste info';
$string['calendardue'] = '{$a} on tähtaeg saabumas';
$string['calendargradingdue'] = '{$a} on hindamisel';
$string['caneditsubmission'] = 'Sa võid oma tööd pärast tähtaja saabumist muuta ja uuesti esitada, aga sellele lisatakse hilinemise märge.';
$string['changefilters'] = 'Muuda filtreid';
$string['changeuser'] = 'Muuda kasutajat';
$string['choosegradingaction'] = 'Hindamistegevus';
$string['choosemarker'] = 'Valige...';
$string['chooseoperation'] = 'Valige toiming';
$string['clickexpandreviewpanel'] = 'Läbivaatuspaneeli laiendamiseks klõpsake';
$string['collapsegradepanel'] = 'Ahenda hindepaneel';
$string['collapsereviewpanel'] = 'Ahenda läbivaatuspaneel';
$string['comment'] = 'Kommentaar';
$string['completiondetail:submit'] = 'Esita oma töö';
$string['completionsubmit'] = 'Esita oma töö';
$string['configshowrecentsubmissions'] = 'Esitatud tööde teatisi saavad kõik vaadata viimaste tegevuste aruannetest.';
$string['confirmbatchgradingoperation'] = 'Kas soovite tegevuse {$a->operation} kindlasti määrata {$a->count} tudengile?';
$string['confirmstart'] = 'Sa pead ülesande lõpetama {$a} jooksul. Pärast alustamist käivitub taimer, mida ei saa peatada.';
$string['confirmsubmission'] = 'kas soovite kindlasti oma töö hindamisele saata? Pärast ärasaatmist ei saa muudatusi enam teha.';
$string['confirmsubmissionheading'] = 'Kinnita esitamine';
$string['conversionexception'] = 'Ülesannet ei saanud teisendada. Erand: {$a}';
$string['couldnotconvertgrade'] = 'Kasutaja {$a} hinnet ei saanud teisendada.';
$string['couldnotconvertsubmission'] = 'Kasutaja {$a} esitatud tööd ei saanud teisendada.';
$string['couldnotcreatecoursemodule'] = 'Kursusemoodulit ei saanud luua.';
$string['couldnotcreatenewassignmentinstance'] = 'Uut ülesandeeksemplari ei saanud luua.';
$string['couldnotfindassignmenttoupgrade'] = 'Vana ülesandeeksemplari, mida täiendada, ei leitud.';
$string['crontask'] = 'Ülesande mooduli tausttöötlus';
$string['currentassigngrade'] = 'Ülesande hinne hetkel';
$string['currentattempt'] = 'See on {$a}. katse.';
$string['currentattemptof'] = 'See on {$a->attemptnumber}. katse (Lubatud on {$a->maxattempts} katset).';
$string['currentgrade'] = 'Praegune hinne hinnetelehel';
$string['cutoffdate'] = 'Sulgemisaeg';
$string['cutoffdate_help'] = 'Kui see säte on valitud, saavad õppijad pärast määratud tähtaega ülesande vastuse esitada üksnes siis, kui on olemas tähtajapikendus.';
$string['cutoffdatecolon'] = 'Sulgemisaeg: {$a}';
$string['cutoffdatefromdatevalidation'] = 'Sulgemise aeg peab olema hilisem kui tööde esitamise avamise aeg.';
$string['cutoffdatevalidation'] = 'Sulgemise aeg peab olema töö esitamise tähtajast hilisem.';
$string['defaultlayout'] = 'Taasta vaikepaigutus';
$string['defaultsettings'] = 'Ülesande vaikesätted';
$string['defaultsettings_help'] = 'Nende sätetega määratletakse kõigi uute ülesannete vaikeväärtused.';
$string['defaultteam'] = 'Vaikerühm';
$string['deleteallsubmissions'] = 'Kustuta kõik esitamised';
$string['description'] = 'Kirjeldus';
$string['disabled'] = 'Keelatud';
$string['downloadall'] = 'Laadi kõik esitatud tööd alla';
$string['downloadasfolders'] = 'Laadi esitatud tööd alla kaustadena';
$string['downloadasfolders_help'] = 'Kui esitatud töö koosneb rohkem kui ühest failist, saab esitatud tööd alla laadida kaustadena. Iga esitatud töö paigutatakse eraldi kausta, kaustastruktuur säilitatakse ja faile ei nimetata ümber.';
$string['downloadselectedsubmissions'] = 'Laadi valitud esitatud tööd alla';
$string['duedate'] = 'Tähtaeg';
$string['duedate_help'] = 'Ülesande esitamise tähtaeg. Ülesandega seotud töid saab esitada ka pärast märgitud kuupäeva, aga siis märgitakse esitatud tööd hilinenuks. Tööde esitamise lõppkuupäeva määramiseks määrake vastav kuupäev.';
$string['duedateaftersubmissionvalidation'] = 'Tähtaeg peab olema hilisem, kui tööde esitamise avamise aeg.';
$string['duedatecolon'] = 'Tähtaeg: {$a}';
$string['duedatereached'] = 'Ülesande esitamise tähtaeg on möödas';
$string['duedatevalidation'] = 'Tähtaeg ei saa olla varasem, kui tööde esitamise avamise aeg.';
$string['duplicateoverride'] = 'Dubleeri testisätete ülekirjutus';
$string['editaction'] = 'Tegevused...';
$string['editattemptfeedback'] = 'Saate muuta katse number {$a} hinnet ja tagasisidet.';
$string['editingpreviousfeedbackwarning'] = 'Muudate varasema katse tagasisidet. See on {$a->attemptnumber}. katse. Kokku on {$a->totalattempts} katset.';
$string['editingstatus'] = 'Oleku muutmine';
$string['editonline'] = 'Redigeeri veebis';
$string['editoverride'] = 'Muuda testisätete ülekirjutust';
$string['editsubmission'] = 'Muuda esitatud tööd';
$string['editsubmission_help'] = 'Sa saad veel oma esitatud töös muudatusi teha.';
$string['editsubmissionother'] = 'Muuda kasutaja {$a} esitatud tööd';
$string['enabled'] = 'Lubatud';
$string['enabletimelimit'] = 'Luba ajastatud ülesanded';
$string['enabletimelimit_help'] = 'Kui see säte on lubatud, võid ülesande seadistuses määrata ajalimiidi.';
$string['errornosubmissions'] = 'Allaaditavaid töid pole';
$string['errorquickgradingvsadvancedgrading'] = 'Hindeid ei salvestatud, sest see ülesanne kasutab hetkel täpsemat hindamist.';
$string['errorrecordmodified'] = 'Hindeid ei salvestatud, sest keegi on muutnud ühte hinnatavatest töödest peale seda, kui teie selle lehe avasite.';
$string['eventallsubmissionsdownloaded'] = 'Kõik esitatud tööd laaditakse kohe alla.';
$string['eventassessablesubmitted'] = 'Töö on esitatud.';
$string['eventbatchsetmarkerallocationviewed'] = 'Paki hindaja jaotust on vaadatud';
$string['eventbatchsetworkflowstateviewed'] = 'Paki töövoo olekut on vaadatud.';
$string['eventextensiongranted'] = 'Ülesande esitamise tähtaeg on pikendatud.';
$string['eventfeedbackupdated'] = 'Tagasiside on värskendatud';
$string['eventfeedbackviewed'] = 'Tagasisidet on vaadatud';
$string['eventgradingformviewed'] = 'Hindamisvormi on vaadatud';
$string['eventgradingtableviewed'] = 'Hindamistabelit on vaadatud';
$string['eventidentitiesrevealed'] = 'Isikud on avalikustatud.';
$string['eventmarkerupdated'] = 'Määratud hindaja andmed on värskendatud.';
$string['eventoverridecreated'] = 'Ülesandesätete ülekirjutus on loodud';
$string['eventoverridedeleted'] = 'Ülesandesätete ülekirjutus on kustutatud';
$string['eventoverrideupdated'] = 'Ülesandesätete ülekirjutus on värskendatud';
$string['eventremovesubmissionformviewed'] = 'Vaadatud esitamise kinnituse eemaldamine.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Isiku kinnituslehte on vaadatud.';
$string['eventstatementaccepted'] = 'Kasutaja on nõustunud töö esitamise avaldusega.';
$string['eventsubmissionconfirmationformviewed'] = 'Esitatud töö kinnitusvormi on vaadatud.';
$string['eventsubmissioncreated'] = 'Esitatav töö on loodud.';
$string['eventsubmissionduplicated'] = 'Kasutaja tegi oma esitusest duplikaadi.';
$string['eventsubmissionformviewed'] = 'Esitamisvormi on vaadatud.';
$string['eventsubmissiongraded'] = 'Esitatud töö on hinnatud.';
$string['eventsubmissionlocked'] = 'Esitatud tööd on kasutaja jaoks lukustatud.';
$string['eventsubmissionremoved'] = 'Esitus on eemaldatud.';
$string['eventsubmissionstatusupdated'] = 'Esitatud töö olek on värskendatud.';
$string['eventsubmissionstatusviewed'] = 'Esitatud töö olekut on vaadatud.';
$string['eventsubmissionunlocked'] = 'Esitatud töö on kasutaja jaoks avatud.';
$string['eventsubmissionupdated'] = 'Esitatud töö on värskendatud.';
$string['eventsubmissionviewed'] = 'Esitatud tööd on vaadatud.';
$string['eventworkflowstateupdated'] = 'Töövoo olek on värskendatud.';
$string['expandreviewpanel'] = 'Laienda läbivaatuspaneel';
$string['extensionduedate'] = 'Pikendatud tähtaeg';
$string['extensionduedatecurrent'] = 'Tähtaja pikendus';
$string['extensionduedatenone'] = 'Ei ole';
$string['extensionnotafterduedate'] = 'Pikendatud tähtaeg peab olema ülesande tähtajast hilisem';
$string['extensionnotafterfromdate'] = 'Pikendatud tähtaeg peab olema töö esitamise alguskuupäevast hilisem';
$string['feedback'] = 'Tagasiside';
$string['feedbackavailableanonhtml'] = 'Sulle on antud uut tagasisidet lahendatud ülesandele <i>{$a->assignment}</i>\'<br /><br /> Sa näed seda oma esitatud  <a href="{$a->url}"> ülesande lahenduses.';
$string['feedbackavailableanonsmall'] = 'Uus tagasiside ülesandele {$a->assignment}';
$string['feedbackavailableanontext'] = 'Sinu esitatud tööl \'{$a->assignment}\' on uus tagasiside.

Näed seda lisatuna oma esitatud tööle:

{$a->url}';
$string['feedbackavailablehtml'] = '{$a->username} on postitanud tagasisidet teie ülesandega \'<i>{$a->assignment}</i>\' seotud esitatud töö kohta.<br /><br />
Tagasiside on lisatud <a href="{$a->url}">esitatud tööle</a>.';
$string['feedbackavailablesmall'] = '{$a->username} andis tagasisidet ülesande {$a->assignment} kohta';
$string['feedbackavailabletext'] = '{$a->username} postitas tagasisidet teie ülesande \'{$a->assignment}\' vastuse kohta.

Tagasisidet saab vaadata esitatud ülesandevastuse juures:

    {$a->url}';
$string['feedbackplugin'] = 'Tagasisidelisandmoodul';
$string['feedbackpluginforgradebook'] = 'Tagasisidelisandmoodul, mis saadab hinde kommentaarid hinnetelehele.';
$string['feedbackpluginforgradebook_help'] = 'Ainult üks ülesande tagasisidelisandmoodul võib tagasisidet hinnetelehele saata.';
$string['feedbackplugins'] = 'Tagasisidelisandmoodulid';
$string['feedbacksettings'] = 'Tagasiside sätted';
$string['feedbacktypes'] = 'Tagasiside viisid';
$string['filesubmissions'] = 'Failide esitused';
$string['filter'] = 'Filter';
$string['filterdraft'] = 'Mustand';
$string['filtergrantedextension'] = 'Pikendatud tähtaeg';
$string['filternone'] = 'Filtrit pole';
$string['filternotsubmitted'] = 'Esitamata';
$string['filterrequiregrading'] = 'Vajab hindamist';
$string['filtersubmitted'] = 'Esitatud';
$string['fixrescalednullgrades'] = 'See ülesanne sisaldab mõnda ekslikku hinnet. Saad <a href="{$a->link} "> neid hindeid automaatselt parandada </a>.';
$string['fixrescalednullgradesconfirm'] = 'Kas soovid kindlasti parandada ekslikke hindeid? Kõik mõjutatud hinded eemaldatakse.';
$string['fixrescalednullgradesdone'] = 'Hinded parandatud.';
$string['gradeabovemaximum'] = 'Hinne peab olema väiksem või võrdne hindega {$a}.';
$string['gradebelowzero'] = 'Hinne peab olema nullist suurem või sellega võrdne.';
$string['gradebreakdown'] = 'Hinde liigitus';
$string['gradecanbechanged'] = 'Hinnet saab muuta';
$string['gradechangessaveddetail'] = 'Hinde ja tagasiside muudatused on salvestatud';
$string['graded'] = 'Hinnatud';
$string['gradedby'] = 'Hindas';
$string['gradedfollowupsubmit'] = 'Hinnatud - parandatud töö on kätte saadud';
$string['gradedon'] = 'Hindamiskuupäev';
$string['gradeitem:submissions'] = 'Esitatud tööd';
$string['gradelocked'] = 'See hinne on lukus või hinnetelehel üle kirjutatud.';
$string['gradeoutof'] = 'Hinne maksimaalsest {$a}';
$string['gradeoutofhelp'] = 'Hinne';
$string['gradeoutofhelp_help'] = 'Sisestage siia õppija esitatud töö hinne. Hinne võib olla komakoha täpsusega.';
$string['gradersubmissionupdatedhtml'] = '{$a->username} on esitatud ülesandevastust <i>\'{$a->assignment}\' uuendanud {$a->timeupdated}<br /><br />
See asub <a href="{$a->url}">veebilehel</a>.';
$string['gradersubmissionupdatedsmall'] = '{$a->username} on värskendanud oma ülesandega {$a->assignment} seotud esitatud tööd.';
$string['gradersubmissionupdatedtext'] = '{$a->username} on värskendanud oma ülesandega \'{$a->assignment}\' seotud esitatud tööd {$a->timeupdated}

See on saadaval siin:

    {$a->url}';
$string['gradestudent'] = 'Hinnake õppijat: (id={$a->id}, täisnimi={$a->fullname}).';
$string['gradeuser'] = 'Hinne {$a}';
$string['grading'] = 'Hindamine';
$string['gradingchangessaved'] = 'Hinde muudatused on salvestatud.';
$string['gradingduedate'] = 'Meenuta mulle hindamist kuupäevaks';
$string['gradingduedate_help'] = 'Eeldatav kuupäev, kui esitatud tööde hindamine peaks olema lõpetatud. Seda kuupäeva kasutatakse õpetaja töölaual kuvatavate teavituste tähtsuse määramiseks.';
$string['gradingdueduedatevalidation'] = 'Hindamise meeldetuletuskuupäev ei või olla tähtajast varasem.';
$string['gradingduefromdatevalidation'] = 'Hindamise meeldetuletuskuupäev ei või olla varasem kui kuupäev „Luba töö esitamine alates“.';
$string['gradingmethodpreview'] = 'Hindamiskriteerium';
$string['gradingoptions'] = 'Valikud';
$string['gradingstatus'] = 'Hindamise olek';
$string['gradingstudent'] = 'Õppija hindamine';
$string['gradingsummary'] = 'Hindamiskokkuvõte';
$string['grantextension'] = 'Pikenda töö esitamise tähtaega';
$string['grantextensionforusers'] = 'Pikenda esitamise tähtaega {$a} õppija jaoks';
$string['groupoverrides'] = 'Rühma testisätete ülekirjutused';
$string['groupoverridesdeleted'] = 'Rühma testisätete ülekirjutused on kustutatud.';
$string['groupsnone'] = 'Sellel kursusel pole rühmi.';
$string['groupsubmissionsettings'] = 'Rühma tööesituse sätted';
$string['hiddenuser'] = 'Osaleja';
$string['hidegrader'] = 'Peida hindaja identiteet õpilaste eest';
$string['hidegrader_help'] = 'Kui see on lubatud, ei kuvata ülesande hindaja kasutaja identiteeti, nii et õpilased ei näe, kes nende tööd hindas.

Pange tähele, et see säte ei mõjuta hinnetelehe kommentaaride kasti .';
$string['hideshow'] = 'Peida/Kuva';
$string['inactiveoverridehelp'] = '* Õppijal pole selle ülesande soorituskatse tegemiseks õige rühm või roll';
$string['indicator:cognitivedepth'] = 'Kognitiivne ülesanne';
$string['indicator:cognitivedepth_help'] = 'See näitaja põhineb kognitiivsel sügavusel, milleni õpilane on ülesandes jõudnud.';
$string['indicator:cognitivedepthdef'] = 'Kognitiivne ülesanne';
$string['indicator:cognitivedepthdef_help'] = 'Osaleja on selle analüüsivahemiku jooksul saavutanud selle kognitiivse seotuse protsendi, mida Ülesande Tegevused pakuvad (tasemed = vaadet pole, vaade, esita, vaata tagasisidet, kommenteeri tagasisidet, esita pärast tagasiside vaatamist uuesti)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sotsiaalne ülesanne';
$string['indicator:socialbreadth_help'] = 'See näitaja põhineb sotsiaalsel ulatusel, mille õpilane on ülesandetegevuses jõudnud.';
$string['indicator:socialbreadthdef'] = 'Sotsiaalne ülesanne';
$string['indicator:socialbreadthdef_help'] = 'Osaleja on selle analüüsi intervalli jooksul saavutanud ülesande tegevuste pakutava sotsiaalse kaasatuse protsendi (tasemed = ei osale, osaleb üksi, osaleb koos teistega)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['instructionfiles'] = 'Juhendifailid';
$string['introattachments'] = 'Täiendavad failid';
$string['introattachments_help'] = 'Lisada võib ülesandes kasutatavaid täiendavaid faile (nt vastuste malle).';
$string['invalidfloatforgrade'] = 'Märgitud hinne pole arusaadav: {$a}';
$string['invalidgradeforscale'] = 'Sisestatud hinne ei sobi ülesande jaoks valitud hindamisskaalasse';
$string['invalidoverrideid'] = 'Testisätete ülekirjutuse sobimatu ID';
$string['lastmodifiedgrade'] = 'Viimati muudetud (hinne)';
$string['lastmodifiedsubmission'] = 'Viimati muudetud (esitamine)';
$string['latesubmissions'] = 'Hilinenud tööesitamised';
$string['latesubmissionsaccepted'] = 'Lubatud kuni {$a}';
$string['loading'] = 'Laadimine...';
$string['locksubmissionforstudent'] = 'Keela õppija (id={$a->id}, täisnimi={$a->fullname}) tööesitamised.';
$string['locksubmissions'] = 'Lukusta tööde esitamised';
$string['manageassignfeedbackplugins'] = 'Halda ülesande tagasisidelisandmooduleid';
$string['manageassignsubmissionplugins'] = 'Halda ülesande esitamise lisandmooduleid';
$string['marker'] = 'Hindaja';
$string['markerfilter'] = 'Hindaja filter';
$string['markerfilternomarker'] = 'Hindaja puudub';
$string['markingallocation'] = 'Kasuta hindajate määramist';
$string['markingallocation_help'] = 'Kui see säte on lubatud koos hindamise töövooga, saab hindajaid määrata kindlatele õppijatele.';
$string['markinganonymous'] = 'Luba osaline hinnete avaldamine anonüümse hindamise käigus';
$string['markinganonymous_help'] = 'Kui see seadistus koos anonüümsete esituste ja hindamise töövooga on lubatud, siis on lubatud hinnete osaline avaldamine anonüümse hindamise käigus.';
$string['markingworkflow'] = 'Kasuta hindamise töövoogu';
$string['markingworkflow_help'] = 'Kui see säte on lubatud, läbivad hinded mitu töövoo etappi, enne kui need õppijatele avaldatakse. See võimaldab läbida mitu hindamisvooru ja lubab hinded kõikidele õppijatele üheaegselt avaldada.';
$string['markingworkflowstate'] = 'Hindamise töövoo olek';
$string['markingworkflowstate_help'] = 'Võimalikud töövoo olekud võivad olla järgmised (olenevalt teie õigustest).

* Hindamata – hindaja pole veel hindamist alustanud
* Hindamisel – hindaja on hindamist alustanud, kuid pole seda veel lõpetanud
* Hindamine on lõpule viidud – hindaja on hindamise lõpetanud, kuid peab kontrollimiseks või paranduste tegemiseks võib-olla tagasi minema
* Ülevaatamisel – hinde vaatab nüüd üle õpetaja, kes vastutab kvaliteedikontrolli eest
* Avaldamiseks valmis – vastutav õpetaja on hindamisega rahul, kuid ootab, enne kui annab õppijatele juurdepääsu hindele
* Avaldatud – õppija pääseb hinnetele/tagasisidele juurde';
$string['markingworkflowstateinmarking'] = 'Hindamisel';
$string['markingworkflowstateinreview'] = 'Läbivaatamisel';
$string['markingworkflowstatenotmarked'] = 'Hindamata';
$string['markingworkflowstatereadyforrelease'] = 'Avaldamiseks valmis';
$string['markingworkflowstatereadyforreview'] = 'Hindamine on lõpule viidud';
$string['markingworkflowstatereleased'] = 'Avaldatud';
$string['maxattempts'] = 'Katsete maksimumarv';
$string['maxattempts_help'] = 'Maksimaalne töö esitamise katsete arv, mida õppija võib teha. Kui nii mitu katset on tehtud, ei saa õppija esitatud tööd uuesti avada.';
$string['maxgrade'] = 'Maksimumhinne';
$string['maxperpage'] = 'Ülesannete maksimumarv ühel lehel';
$string['maxperpage_help'] = 'Ülesannete maksimumarv, mis hindajale ülesannete hindamislehel kuvatakse. See on mõttekas ajalõppude vältimiseks kursustel, kus on väga palju registreerunuid.';
$string['messageprovider:assign_notification'] = 'Ülesandeteavitused';
$string['modulename'] = 'Ülesanne';
$string['modulename_help'] = 'Ülesande Tegevus võimaldab õpetajal edastada tööülesandeid, koguda töid ja anda hindeid ning tagasisidet.

Õppijad saavad esitada mis tahes digitaalset sisu (faile), nt tekstitöötlusdokumente, arvutustabeleid, pilte või heli- ja videoklippe. Teise võimalusena või lisaks sellele võib ülesande puhul olla vaja, et õppija sisestaks teksti otse tekstiredaktorisse. Ülesannet võib kasutada ka selleks, et tuletada õppijatele meelde „tegelikke“ ülesandeid, mis tuleb lõpetada võrguühenduseta (nt kunstitöö) ning mis ei nõua seega digitaalset sisu. Õppijad saavad töid esitada individuaalselt või mõne rühma liikmena.

Ülesannete läbivaatamisel saavad õpetajad sisestada tagasisidekommentaare ja üles laadida faile (nt õppijate esitatud töid, mida nad on hinnanud, kommentaaridega dokumente või helilist tagasisidet). Ülesandeid saab hinnata numbrilise või kohandatud skaala või täpsema hindamise meetodi (nt punktiarvestusjuhendi) alusel. Lõplikud hinded kantakse hinnetelehele.';
$string['modulename_link'] = 'mod/assignment/view';
$string['modulenameplural'] = 'Ülesanded';
$string['moreusers'] = '{$a} veel...';
$string['multipleteams'] = 'Mitme rühma liige';
$string['multipleteams_desc'] = 'Selle ülesande puhul on töö vaja esitada rühmades. Olete mitme rühma liige. Töö esitamiseks peate olema ainult ühe rühma liige. Rühmadesse kuulumise muutmiseks pöörduge oma õpetaja poole.';
$string['multipleteamsgrader'] = 'Mitme rühma liige, mistõttu ei saa töid esitada.';
$string['newsubmissions'] = 'Esitatud ülesanded';
$string['nextuser'] = 'Järgmine kasutaja';
$string['noattempt'] = 'Katseid pole';
$string['noclose'] = 'Sulgemiskuupäeva pole';
$string['nofiles'] = 'Faile pole.';
$string['nofilters'] = 'Filtreid pole';
$string['nograde'] = 'Hinnet pole.';
$string['nogroupoverrides'] = 'Hetkel ei ole rühmade ülekirjutusi';
$string['nomoresubmissionsaccepted'] = 'Lubatud ainult osalejatele, kellele on antud pikendust.';
$string['none'] = 'Pole';
$string['noonlinesubmissions'] = 'Selle ülesande puhul pole vaja midagi veebi kaudu esitada.';
$string['noopen'] = 'Avamiskuupäeva pole';
$string['nooverridedata'] = 'Peate üle kirjutama vähemalt ühe ülesandesätte.';
$string['nosavebutnext'] = 'Edasi';
$string['nosubmission'] = 'Sellele ülesandele pole veel ühtegi vastust esitatud.';
$string['nosubmissionyet'] = 'Esitusi ei ole veel';
$string['noteam'] = 'Pole ühegi rühma liige';
$string['noteam_desc'] = 'Selle ülesande puhul on töö vaja esitada rühmades. Te pole ühegi rühma liige ega saa seetõttu tööd esitada. Pöörduge oma õpetaja poole, et teid rühma lisataks.';
$string['noteamgrader'] = 'Pole ühegi rühma liige, mistõttu ei saa töid esitada.';
$string['notgraded'] = 'Hindamata';
$string['notgradedyet'] = 'Pole veel hinnatud';
$string['notifications'] = 'Teavitused';
$string['nouseroverrides'] = 'Hetkel ei ole kasutajate ülekirjutusi';
$string['nousers'] = 'Kasutajaid pole';
$string['nousersselected'] = 'Kasutajaid pole valitud';
$string['numberofdraftsubmissions'] = 'Mustandid';
$string['numberofparticipants'] = 'Osalejaid';
$string['numberofsubmissionsneedgrading'] = 'Vajab hindamist';
$string['numberofsubmissionsneedgradinglabel'] = 'Vajavad hindamist: {$a}';
$string['numberofsubmittedassignments'] = 'Esitatud';
$string['numberofteams'] = 'Rühmad';
$string['offline'] = 'Veebipõhist vastust pole vaja esitada';
$string['open'] = 'Avatud';
$string['opensubmissionexists'] = 'Avatud ülesande esitus on juba olemas.';
$string['outlinegrade'] = 'Hinne: {$a}';
$string['outof'] = '{$a->current} / {$a->total}';
$string['overdue'] = '<font color="red">Ülesande tähtajast on möödunud: {$a}</font>';
$string['override'] = 'Kirjuta üle';
$string['overridedeletegroupsure'] = 'Kas soovite rühma {$a} testisätete ülekirjutuse kindlasti kustutada?';
$string['overridedeleteusersure'] = 'Kas soovite kasutaja {$a} testisätete ülekirjutuse kindlasti kustutada?';
$string['overridegroup'] = 'Kirjuta selle rühma sätted üle';
$string['overridegroupeventname'] = '{$a->assign} – {$a->group}';
$string['overrides'] = 'Sätete ülekirjutused';
$string['overrideuser'] = 'Kirjuta selle kasutaja sätted üle';
$string['overrideusereventname'] = '{$a->assign} – kirjuta üle';
$string['page-mod-assign-view'] = 'Ülesandemooduli põhi- ja tööde esitamise leht';
$string['page-mod-assign-x'] = 'Ülesandemooduli mis tahes leht';
$string['paramtimeremaining'] = 'Veel {$a}';
$string['participant'] = 'Osaleja';
$string['pluginadministration'] = 'Ülesande haldus';
$string['pluginname'] = 'Ülesanne';
$string['preventsubmissionnotingroup'] = 'Nõua töö esitamiseks rühma';
$string['preventsubmissionnotingroup_help'] = 'Kui see säte on lubatud, ei saa kasutajad, kes pole rühma liikmed, töid esitada.';
$string['preventsubmissions'] = 'Saate keelata kasutajal selle ülesande uute vastuste esitamise.';
$string['preventsubmissionsshort'] = 'Keela esitatud töö muutmine';
$string['previous'] = 'Eelmine';
$string['previoususer'] = 'Eelmine kasutaja';
$string['privacy:attemptpath'] = '{$a} üritus';
$string['privacy:blindmarkingidentifier'] = 'Anonüümse esituse jaoks kasutatav identifikaator';
$string['privacy:gradepath'] = 'hinne';
$string['privacy:metadata:assigndownloadasfolders'] = 'Kasutaja eelistus, kas mitu faili esitamist tuleks kaustadesse laadida';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Ülesande tagasiside andmed.';
$string['privacy:metadata:assignfilter'] = 'Filtreerimise valikud, nagu „Esitatud”, „Pole esitatud”, „Vajab hindamist” ja „Esitamise tähtaeg pikendatud”';
$string['privacy:metadata:assigngrades'] = 'Salvestab kasutaja hinded ülesande kohta';
$string['privacy:metadata:assignmarkerfilter'] = 'Filtreeri omistatud kokkuvõte määratud markeriga.';
$string['privacy:metadata:assignmentid'] = 'Ülesande ID';
$string['privacy:metadata:assignmessageexplanation'] = 'Sõnumid saadetakse õpilastele sõnumisüsteemi kaudu.';
$string['privacy:metadata:assignoverrides'] = 'Salvetab ülesande ülekirjutatud informatsiooni.';
$string['privacy:metadata:assignperpage'] = 'Ülessannete arv, mida lehel kuvatakse.';
$string['privacy:metadata:assignquickgrading'] = 'Eelistus, kas kiirhindamine on kasutusel või mitte.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Salvestab kasutaja ülesannete esitamiste arvu.';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Ülesandele laekunud esitamiste andmed.';
$string['privacy:metadata:assignuserflags'] = 'Salvestab kasutaja metaandmeid, näiteks pikendatud kuupäevi.';
$string['privacy:metadata:assignusermapping'] = 'Anonüümsete esituste kaardistus';
$string['privacy:metadata:assignworkflowfilter'] = 'Filtreeri erinevate töövoo etappide järgi.';
$string['privacy:metadata:grade'] = 'Selle ülesande esitamise arvuline hinne. Saab määrata skaalade / täpsemate hindamisvormide jms abil, kuid teisendatakse need alati tagasi ujukomaarvuks (floating point number)';
$string['privacy:metadata:grader'] = 'Hindeid andva isiku kasutajatunnus.';
$string['privacy:metadata:groupid'] = 'Grupi ID kuhu kasutaja kuulub.';
$string['privacy:metadata:latest'] = 'Suuresti lihtsustab päringuid, mis otsivad informatsiooni ainult viimase katse kohta.';
$string['privacy:metadata:mailed'] = 'Kas sellele kasutajatele on juba email saadetud?';
$string['privacy:metadata:timecreated'] = 'Loomise aeg';
$string['privacy:metadata:timestarted'] = 'Alustamise aeg';
$string['privacy:metadata:userid'] = 'Kasutaja ID';
$string['privacy:studentpath'] = 'õpiliaste tööd';
$string['privacy:submissionpath'] = 'töö';
$string['quickgrading'] = 'Kiirhindamine';
$string['quickgrading_help'] = 'Kiirhindamine võimaldab teil määrata hinded (ja tulemused) otse esitatud tööde tabelisse. Kiirhindamine ei ühildu täpsema hindamisega ja pole soovitatav juhul, kui hindajaid on mitu.';
$string['quickgradingchangessaved'] = 'Hinde muudatused on salvestatud.';
$string['quickgradingresult'] = 'Kiirhindamine';
$string['recordid'] = 'Tunnus';
$string['relativedatessubmissiontimeleft'] = 'Arvutatud iga õpilase jaoks';
$string['removeallgroupoverrides'] = 'Kustuta kõik rühma testisätete ülekirjutused.';
$string['removealluseroverrides'] = 'Kustuta kõik kasutaja testisätete ülekirjutused.';
$string['removesubmission'] = 'Eemalda töö';
$string['removesubmissionconfirm'] = 'Kas oled kindel, et soovid oma esituse eemaldada?';
$string['removesubmissionconfirmforstudent'] = 'Kas oled kindel, et soovid õpilase {$a} esitatud töö eemaldada?';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Kas oled kindel, et soovid õpilase {$a} esitatud töö eemaldada? Palun pea silmas, et see ei nulli õpilase ajalimiiti. Sa saad aega juurde anda, lisades aega kasutaja ülekirjutusele.';
$string['removesubmissionconfirmwithtimelimit'] = 'Kas oled kindel, et soovid oma esituse eemaldada? Palun pea silmas, et see ei nulli sinu ajalimiiti.';
$string['removesubmissionforstudent'] = 'Eemalda töö õpilaselt: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Valik "Ava uuesti kuni läbimiseni" ei ühildu anonüümsete esitustega, sest hindeid ei kanta hinnetelehele enne, kui õppijate isikud on avalikustatud.';
$string['requireallteammemberssubmit'] = 'Nõua, et töö peavad esitama kõik rühmaliikmed';
$string['requireallteammemberssubmit_help'] = 'Kui see säte on lubatud, peavad kõik õppijate rühma liikmed klõpsama selle ülesande puhul esitamisnuppu, et rühma esitatud töö loetaks esitatuks. Kui see säte on keelatud, loetakse rühma esitatud töö esitatuks kohe, kui õppijate rühma mis tahes liige klõpsab esitamisnuppu.';
$string['requiresubmissionstatement'] = 'Nõua, et õppijad töö esitamise avaldusega nõustuks';
$string['requiresubmissionstatement_help'] = 'Saate nõude, et õppijad kõigi ülesandevastuste puhul nõustuks töö esitamise avaldusega.';
$string['revealidentities'] = 'Avalikusta õppijate isikud';
$string['revealidentitiesconfirm'] = 'Kas soovite kindlasti avalikustada selle ülesande tegijate isikud? Seda toimingut ei saa tagasi võtta. Kui õppijate isikud on avalikustatud, kantakse hinded hinnetelehele.';
$string['reverttodefaults'] = 'Ennista ülesannete vaikesätted';
$string['reverttodraft'] = 'Märgi esitus tagasi mustandiks';
$string['reverttodraftforgroup'] = 'Märgi rühma {$a} esitus tagasi mustandiks';
$string['reverttodraftforstudent'] = 'Saate järgmise õppija esitatud töö määrata mustandiks: (id={$a->id}, fullname={$a->fullname}).';
$string['reverttodraftshort'] = 'Määra esitatud töö mustandiks';
$string['reviewed'] = 'Läbi vaadatud';
$string['save'] = 'Salvesta';
$string['saveallquickgradingchanges'] = 'Salvesta kõik kiirhindamise muudatused';
$string['saveandcontinue'] = 'Salvesta ja jätka';
$string['savechanges'] = 'Salvesta muudatused';
$string['savegradingresult'] = 'Hinne';
$string['savenext'] = 'Salvesta ja kuva järgmine';
$string['saveoverrideandstay'] = 'Salvesta ja sisesta veel üks ülekirjutus';
$string['savingchanges'] = 'Muudatuste salvestamine...';
$string['scale'] = 'Skaala';
$string['search:activity'] = 'Ülesanne – Tegevuse teave';
$string['selectedusers'] = 'Valitud kasutajad';
$string['selectlink'] = 'Vali...';
$string['selectuser'] = 'Vali {$a}';
$string['sendlatenotifications'] = 'Teavita hindajaid, kui töö esitamisega hilinetakse';
$string['sendlatenotifications_help'] = 'Kui see säte on lubatud, saadetakse hindajatele (tavaliselt õpetajatele) sõnum siis, kui õppija esitab ülesande tähtajast hiljem. Sõnumi saatmise meetodid on konfigureeritavad.';
$string['sendnotifications'] = 'Teavita hindajaid esitatud töödest';
$string['sendnotifications_help'] = 'Kui see säte on lubatud, saadetakse hindajatele (tavaliselt õpetajatele) sõnum siis, kui õppija esitab ülesande tähtajast varem, hiljem või õigel ajal. Sõnumi saatmise meetodid on konfigureeritavad.';
$string['sendstudentnotifications'] = 'Teavita õpilast';
$string['sendstudentnotifications_help'] = 'Kui see säte on lubatud, saadetakse õppijatele teavitus värskendatud hinde või tagasiside kohta. Kui ülesanne kasutab hindamise töövoogu või hinded on hindajaaruandes peidetud olekus, saadetakse teavitus alles hinde avalikustamisel.';
$string['sendstudentnotificationsdefault'] = 'Valiku "Teavita õpilast" vaikesäte';
$string['sendstudentnotificationsdefault_help'] = 'Kas õpilaste hindamisel peaks olema "teavita õpilast" valik vaikimisi märgitud?';
$string['sendsubmissionreceipts'] = 'Saada õppijatele töö esitamise kohta teatis';
$string['sendsubmissionreceipts_help'] = 'Selle lülitiga saab aktiveerida õppijale töö esitamise kohta teavituse saatmise. Iga kord, kui õppija on töö esitanud, saadetakse talle selle kohta teavitus.';
$string['setmarkerallocationforlog'] = 'Määra hindaja: (id={$a->id}, täisnimi={$a->fullname}, hindaja={$a->marker}).';
$string['setmarkingallocation'] = 'Määra hindaja';
$string['setmarkingworkflowstate'] = 'Määra hindamistöövoo olek';
$string['setmarkingworkflowstateforlog'] = 'Määra hindamise töövoo olek: (id={$a->id}, täisnimi={$a->fullname}, olek={$a->state}).';
$string['settings'] = 'Ülesandesätted';
$string['showrecentsubmissions'] = 'Kuva viimati esitatud tööd';
$string['status'] = 'Olek';
$string['studentnotificationworkflowstateerror'] = 'Õppijate teavitamiseks peab hindamise töövoo olek olema „Avaldatud“.';
$string['submission'] = 'Töö esitamine';
$string['submissionattachments'] = 'Näita faile ainult esitamise ajal';
$string['submissionattachments_help'] = 'Märgista see ruut, et näha faile ainult esituste lehel. Märgistamata, kuvatakse faile nii ülesande, kui esituste lehel.';
$string['submissioncopiedhtml'] = '<p>Olete teinud koopia oma varasemast ülesandega \'<i>{$a->assignment}</i>\' seotud esitatud tööst.</p>
<p>Saate vaadata oma <a href="{$a->url}">esitatud töö</a> olekut.</p>';
$string['submissioncopiedsmall'] = 'Olete teinud koopia oma varasemast ülesandega {$a->assignment} seotud esitatud tööst';
$string['submissioncopiedtext'] = 'Olete teinud koopia oma varasemast ülesandega \'{$a->assignment}\' seotud esitatud tööst.

Esitatud töö olekut saate vaadata siin:

    {$a->url}';
$string['submissiondrafts'] = 'Nõua õppijatelt nupu Esita klõpsamist';
$string['submissiondrafts_help'] = 'Kui see säte on lubatud, peavad õppijad klõpsama esitamisnuppu, et määrata esitatud töö lõpetatuks. See võimaldab õppijatel esitatud töö mustandversiooni süsteemis hoida. Kui õppijad on juba tööd esitanud ja väärtuse „Ei“ asemel muudetakse selle sätte väärtuseks „Jah“, loetakse need tööd lõpetatuks.';
$string['submissioneditable'] = 'Õppijad saavad seda esitatud tööd muuta';
$string['submissionempty'] = 'Midagi pole esitatud';
$string['submissionlog'] = 'Õppija: {$a->fullname}, olek: {$a->status}';
$string['submissionmodified'] = 'Teil on olemasolevaid esitatud töö andmeid. Lahkuge sellelt lehelt ja proovige uuesti.';
$string['submissionmodifiedgroup'] = 'Keegi teine on esitatud tööd muutnud. Lahkuge sellelt lehelt ja proovige uuesti.';
$string['submissionnotcopiedinvalidstatus'] = 'Esitatud tööd ei kopeeritud, sest seda on pärast uuesti avamist muudetud.';
$string['submissionnoteditable'] = 'Õppijad ei saa seda esitatud tööd muuta';
$string['submissionnotopen'] = 'See ülesanne ei ole õpilastele avatud';
$string['submissionnotready'] = 'See ülesanne pole esitamiseks valmis:';
$string['submissionplugins'] = 'Töö esitamise lisandmoodulid';
$string['submissionreceipthtml'] = '<p>Olete esitanud ülesandega \'<i>{$a->assignment}</i>\' seotud töö.</p>
<p>Saate vaadata oma <a href="{$a->url}">esitatud töö</a> olekut.</p>';
$string['submissionreceiptotherhtml'] = 'Ülesandega<i>{$a->assignment}</i>
seotud töö on esitatud.<br /><br />
Saate vaadata oma <a href="{$a->url}">esitatud töö</a> olekut.';
$string['submissionreceiptothersmall'] = 'Ülesandega {$a->assignment} seotud töö on esitatud.';
$string['submissionreceiptothertext'] = 'Ülesandega {$a->assignment}
seotud töö on esitatud.

Saate vaadata oma esitatud töö olekut:

    {$a->url}';
$string['submissionreceipts'] = 'Saada töö esitamise teatis';
$string['submissionreceiptsmall'] = 'Olete esitanud ülesandega {$a->assignment} seotud töö.';
$string['submissionreceipttext'] = 'Oled edukalt esitanud oma vastuse ülesandele \'{$a->assignment}\'

Esitatud ülesande olekut saad näha aadressil:

    {$a->url}';
$string['submissionsclosed'] = 'Tööde esitamine on suletud';
$string['submissionsettings'] = 'Töö esitamise sätted';
$string['submissionslocked'] = 'Selle ülesande kohta ei saa vastuseid esitada';
$string['submissionslockedshort'] = 'Esitatud töö muutmine pole lubatud';
$string['submissionstatement'] = 'Töö esitamise avaldus';
$string['submissionstatement_help'] = 'Avaldus, millega õpilased peavad nõustuma, et saaksid oma töö esitada';
$string['submissionstatementacceptedlog'] = 'Kasutaja {$a} on töö esitamise avalduse kinnitanud';
$string['submissionstatementdefault'] = 'Käesolev töö on minu loodud, v.a kohtades, kus olen viidanud teiste autorite töödele.';
$string['submissionstatementrequired'] = 'Sa pead selle avaldusega nõustuma, et saaksid töö esitada';
$string['submissionstatementteamsubmission'] = 'Rühmatöö esitamise avaldus';
$string['submissionstatementteamsubmission_help'] = 'Kinnitus, mille iga õpilane peab oma rühmatöö esitamiseks aktsepteerima.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Rühmatöö esitamise avaldus kõikidele grupi liikmetele esitamiseks';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Teatis, millega peab iga õpilane nõustuma, et esitada oma tööd rühmaliikmena.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'See esitatud töö minu enda töö rühmaliikmena, välja arvatud juhul, kui olen tunnistanud teiste inimeste tööde kasutamist.';
$string['submissionstatementteamsubmissiondefault'] = 'See esitatud töö on minu rühma töö, välja arvatud juhul, kui oleme tunnistanud teiste inimeste teoste kasutamist.';
$string['submissionstatus'] = 'Esitatud töö olek';
$string['submissionstatus_'] = 'Esitatud töid pole';
$string['submissionstatus_draft'] = 'Mustand (esitamata)';
$string['submissionstatus_marked'] = 'Hinnatud';
$string['submissionstatus_new'] = 'Esitatud töid pole';
$string['submissionstatus_reopened'] = 'Uuesti avatud';
$string['submissionstatus_submitted'] = 'Esitatud hindamiseks';
$string['submissionstatusheading'] = 'Esitatud töö olek';
$string['submissionsummary'] = '{$a->status}. Viimati muudetud {$a->timemodified}';
$string['submissionteam'] = 'Rühm';
$string['submissiontypes'] = 'Esitamisviisid';
$string['submitaction'] = 'Esita';
$string['submitassignment'] = 'Esita ülesande vastus';
$string['submitassignment_help'] = 'Pärast ülesande vastuse esitamist ei saa seda enam muuta.';
$string['submitforgrading'] = 'Esita hindamiseks';
$string['submitted'] = 'Esitatud';
$string['submittedearly'] = 'Ülesande vastus esitati {$a} varem';
$string['submittedlate'] = 'Ülesande vastuse esitamisega jäädi {$a} hiljaks';
$string['submittedlateshort'] = '{$a} hiljem';
$string['submittedovertime'] = 'Ülesanne esitati {$a} üle ajalimiidi';
$string['submittedundertime'] = 'Ülesanne esitati {$a} enne ajalimiiti';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Tagasisidelisandmoodul';
$string['subplugintype_assignfeedback_plural'] = 'Tagasisidelisandmoodulid';
$string['subplugintype_assignsubmission'] = 'Esitamise lisandmoodul';
$string['subplugintype_assignsubmission_plural'] = 'Töö esitamise lisandmoodulid';
$string['teamname'] = 'Meeskond: {$a}';
$string['teamsubmission'] = 'Õppijad esitavad töö rühmana';
$string['teamsubmission_help'] = 'Kui see säte on lubatud, jagatakse õppijad rühmadesse rühmade vaikekogumi või kohandatud rühmakogumi alusel. Rühma esitatud töö on rühma liikmete seas ühiskasutuses ja kõik rühma liikmed saavad vaadata töös tehtud muudatusi.';
$string['teamsubmissiongroupingid'] = 'Õppijarühmade rühmakogum';
$string['teamsubmissiongroupingid_help'] = 'See on rühmakogum, mida ülesanne kasutab õppijate rühmade leidmiseks. Kui seda pole määratud, kasutatakse rühmade vaikekogumit.';
$string['textinstructions'] = 'Ülesande juhend';
$string['timelimit'] = 'Ajalimiit';
$string['timelimit_help'] = 'Kui see säte on lubatud, kuvatakse ajalimiit ülesande lehel ja ülesande tegemise ajal kuvatakse ka taimerit.';
$string['timelimitnotenabled'] = 'Selle ülesande jaoks ei ole ajalimiiti seadistatud.';
$string['timelimitpassed'] = 'Ajalimiit on ületatud';
$string['timemodified'] = 'Viimati muudetud';
$string['timeremaining'] = 'Aega on jäänud';
$string['timeremainingcolon'] = 'Aega on jäänud: {$a}';
$string['togglezoom'] = 'Suurenda piirkonda / vähenda piirkonnast välja';
$string['ungroupedusers'] = 'Säte „Nõua töö esitamiseks rühma“ on lubatud ja mõned kasutajad pole ühegi rühma liikmed või on mitme rühma liikmed ja ei saa seetõttu töid esitada.';
$string['ungroupedusersoptional'] = 'Säte "Õpilased esitavad tööd rühmades" on aktiveeritud. Kasutajad, kes ei ole kas üheski rühmas või on rohkem kui ühe rühma liikmed esitavad töö "Vaikerühma" liikmetena.';
$string['unlimitedattempts'] = 'Piiramatu';
$string['unlimitedattemptsallowed'] = 'Lubatud on piiramatu arv katseid.';
$string['unlimitedpages'] = 'Piiramatu';
$string['unlocksubmissionforstudent'] = 'Luba esitamine järgmise õppija jaoks: (id={$a->id}, täisnimi={$a->fullname}).';
$string['unlocksubmissions'] = 'Ava esitatud tööd';
$string['unsavedchanges'] = 'Salvestamata muudatused';
$string['unsavedchangesquestion'] = 'Mõni hinnete- või tagasisidemuudatus on salvestamata. Kas soovite muudatused salvestada ja jätkata?';
$string['updategrade'] = 'Värskenda hinnet';
$string['updatetable'] = 'Salvesta ja värskenda tabel';
$string['upgradenotimplemented'] = 'Versioonitäiendust pole rakendatud lisandmoodulis ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Kasutaja töö vaikeväärtused';
$string['userextensiondate'] = 'Tähtaega on pikendatud kuni {$a}';
$string['usergrade'] = 'Kasutaja hinne';
$string['useridlistnotcached'] = 'Hinde muudatusi EI salvestatud, sest polnud võimalik kindlaks määrata, millise esitatud töö jaoks olid need mõeldud.';
$string['useroverrides'] = 'Kasutaja testisätete ülekirjutused';
$string['useroverridesdeleted'] = 'Kasutaja testisätete ülekirjutused on kustutatud.';
$string['usersnone'] = 'Ükski õppija ei pääse sellele ülesandele juurde.';
$string['usersubmissioncannotberemoved'] = 'Tööd {$a} ei saa eemaldada.';
$string['userswhoneedtosubmit'] = 'Kasutajad, kes peavad veel töö esitama: {$a}';
$string['validmarkingworkflowstates'] = 'Sobivad hindamise töövoo olekud';
$string['viewadifferentattempt'] = 'Kuva mõni muu soorituskatse';
$string['viewbatchmarkingallocation'] = 'Saate vaadata paki hindamise jaotuse lehte.';
$string['viewbatchsetmarkingworkflowstate'] = 'Saate vaadata paki hindamise töövoo oleku lehte.';
$string['viewfeedback'] = 'Vaata tagasisidet';
$string['viewfeedbackforuser'] = 'Vaata järgmise kasutaja kohta antud tagasisidet: {$a}';
$string['viewfull'] = 'Vaata kõike';
$string['viewfullgradingpage'] = 'Tagasiside andmiseks ava kogu hindamisleht';
$string['viewgradebook'] = 'Vaata hinnetelehte';
$string['viewgrading'] = 'Kuva kõik esitatud tööd';
$string['viewgradingformforstudent'] = 'Saate vaadata õppija (id={$a->id}, täisnimi={$a->fullname}) hindamise lehte.';
$string['viewownsubmissionform'] = 'Saate vaadata oma ülesande esitamise lehte.';
$string['viewownsubmissionstatus'] = 'Saate vaadata oma esitatud töö oleku lehte.';
$string['viewrevealidentitiesconfirm'] = 'Saate vaadata õppija isiku kinnituslehte.';
$string['viewsubmission'] = 'Vaata esitatud tööd';
$string['viewsubmissionforuser'] = 'Vaata kasutaja {$a} esitatud tööd';
$string['viewsubmissiongradingtable'] = 'Saate vaadata esitatud tööde hindamistabelit.';
$string['viewsummary'] = 'Vaata kokkuvõtet';
$string['workflowfilter'] = 'Töövoofilter';
$string['xofy'] = '{$a->x}/{$a->y}';
