<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'fr', version '4.4'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Je comprends et accepte l’accord sur le traitement des données';
$string['activityoverview'] = 'Vous avez des sessions BigBlueButton planifiées';
$string['bbbduetimeoverstartingtime'] = 'La date de fermeture doit être postérieure à la date d’ouverture.';
$string['bbbdurationwarning'] = 'La durée maximale de cette session est de %duration% minutes.';
$string['bbbrecordallfromstartwarning'] = 'Cette session est enregistrée depuis le début.';
$string['bbbrecordwarning'] = 'Cette session peut être enregistrée.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Ajouter une salle BigBlueButton';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Créer instance de session en direct';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Créer instance avec enregistrements';
$string['bigbluebuttonbn:deleterecordings'] = 'Supprimer des enregistrements';
$string['bigbluebuttonbn:importrecordings'] = 'Importer des enregistrements';
$string['bigbluebuttonbn:join'] = 'Rejoindre une salle BigBlueButton';
$string['bigbluebuttonbn:managerecordings'] = 'Gérer les enregistrements';
$string['bigbluebuttonbn:protectrecordings'] = 'Protéger des enregistrements';
$string['bigbluebuttonbn:publishrecordings'] = 'Publier des enregistrements';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Déprotéger des enregistrements';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Dépublier des enregistrements';
$string['bigbluebuttonbn:view'] = 'Voir une salle BigBlueButton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Afficher tous les formats d’enregistrement';
$string['bigbluebuttondisablednotification'] = 'Le module d’activité BigBlueButton a été désactivé et toutes les activités BigBlueButton existantes ne sont plus accessibles. Avant de réactiver ce plugin, veuillez vous assurer que vous avez lu et accepté l’<a href="{$a}" target="_blank">accord sur le traitement des données</a> avec Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Module d’activité BigBlueButton désactivé.';
$string['cachedef_currentfetch'] = 'Données pour lister les enregistrements récupérés récemment.';
$string['cachedef_recordings'] = 'Métadonnées d’enregistrement';
$string['cachedef_serverinfo'] = 'Informations du serveur distant';
$string['cachedef_subplugins'] = 'Le cache utilisé par les routines de sous-plugins pour accélérer le processus de découverte du plugin, si nécessaire.';
$string['cachedef_validatedurls'] = 'Vérifications du cache des URLs validées';
$string['calendarstarts'] = '{$a} est planifié pour';
$string['cannotperformaction'] = 'Impossible d’effectuer l’action {$a} sur cet enregistrement';
$string['completionattendance'] = 'Nécessite présence (minutes)';
$string['completionattendance_desc'] = 'Entrer et rester dans la salle durant au moins {$a} minute(s).';
$string['completionattendance_event_desc'] = 'L’étudiant est entré dans la salle et est resté dans la session durant au moins {$s} minute(s)';
$string['completionattendancegroup'] = 'Nécessite présence (minutes)';
$string['completionattendancegroup_help'] = 'La participation à la réunion pendant (n) minutes est requise pour achever l’activité.';
$string['completionengagement_desc'] = 'S’engager dans des activités durant la réunion.';
$string['completionengagementchats'] = 'Chats';
$string['completionengagementchats_desc'] = 'Participer à {$a} chat(s).';
$string['completionengagementchats_event_desc'] = 'A participé à un chat {$a} fois';
$string['completionengagementemojis'] = 'Émojis';
$string['completionengagementemojis_desc'] = 'Changer son emoji {$a} fois.';
$string['completionengagementemojis_event_desc'] = 'A changé son emoji {$a} fois';
$string['completionengagementgroup'] = 'Exiger une participation';
$string['completionengagementgroup_help'] = 'Une participation active lors la session est requise pour achever l’activité.';
$string['completionengagementpollvotes'] = 'Votes du sondage';
$string['completionengagementpollvotes_desc'] = 'Voter {$a} fois dans des sondages.';
$string['completionengagementpollvotes_event_desc'] = 'A voté dans des sondages {$a} fois';
$string['completionengagementraisehand'] = 'Exiger des mains levées';
$string['completionengagementraisehand_desc'] = 'Lever la main {$a} fois.';
$string['completionengagementraisehand_event_desc'] = 'A levé la main {$a} fois';
$string['completionengagementtalks'] = 'Prise de parole';
$string['completionengagementtalks_desc'] = 'Prendre la parole {$a} fois';
$string['completionengagementtalks_event_desc'] = 'A pris la parole {$a} fois';
$string['completionupdatestate'] = 'État de la mise à jour de l’achèvement';
$string['completionvalidatestate'] = 'Validation de l’achèvement';
$string['completionvalidatestatetriggered'] = 'La validation de l’achèvement a été déclenchée.';
$string['completionview'] = 'Requiert visualisation';
$string['completionview_desc'] = 'Consulter la réunion';
$string['completionview_event_desc'] = 'A consulté la réunion.';
$string['config_checksum_algorithm'] = 'Algorithme de somme de contrôle du serveur BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 est compatible avec d’anciens serveurs. SHA256 et SHA512 sont plus sûrs. SHA512 est conforme à FIPS 140-2.';
$string['config_default_messages'] = 'Messages par défaut';
$string['config_default_messages_description'] = 'Définir les messages par défaut pour les activités';
$string['config_disablecam_default'] = 'Le réglage « Désactiver la caméra » est activé par défaut';
$string['config_disablecam_default_description'] = 'Si ce réglage est activé, les caméras seront désactivées.';
$string['config_disablecam_editable'] = 'Le réglage « Désactiver la caméra » peut être modifié';
$string['config_disablecam_editable_description'] = 'Le réglage « Désactiver la caméra » peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_disablemic_default'] = 'Le réglage « Désactiver les micros » est activé par défaut';
$string['config_disablemic_default_description'] = 'Si ce réglage est activé, les micros seront désactivés.';
$string['config_disablemic_editable'] = 'Le réglage « Désactiver les micros » peut être modifié';
$string['config_disablemic_editable_description'] = 'Le réglage « Désactiver les micros » peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_disablenote_default'] = 'Le réglage « Désactiver les notes partagées » est activé par défaut';
$string['config_disablenote_default_description'] = 'Si ce réglage est activé, les notes partagées seront désactivées.';
$string['config_disablenote_editable'] = 'Le réglage « Désactiver les notes partagées » peut être modifié';
$string['config_disablenote_editable_description'] = 'Le réglage « Désactiver les notes partagées » peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_disableprivatechat_default'] = 'Le réglage «Désactiver les chats privés» est activé par défaut';
$string['config_disableprivatechat_default_description'] = 'Si ce réglage est activé, les chats privés seront désactivés.';
$string['config_disableprivatechat_editable'] = 'Le réglage « Désactiver les chats privés » peut être modifié';
$string['config_disableprivatechat_editable_description'] = 'Le réglage « Désactiver les chats privés » peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_disablepublicchat_default'] = 'Le réglage « Désactiver les chats publics » est activé par défaut';
$string['config_disablepublicchat_default_description'] = 'Si ce réglage est activé, les chats publics seront désactivés.';
$string['config_disablepublicchat_editable'] = 'Le réglage « Désactiver les chats publics » peut être modifié';
$string['config_disablepublicchat_editable_description'] = 'Le réglage « Désactiver les chats publics » peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_dpa_note'] = 'Remarque : afin de remplir vos obligations en terme de protection des données, avant d’utiliser un fournisseur de service avec ce plugin, vous devez vous assurer d’avoir lu et accepté l’accord sur le traitement des données du fournisseur de service. Pour le service gratuit BigBlueButton par défaut, il s’agit de l’<a href="{$a}" target="_blank">accord sur le traitement des données de Blindside Networks Inc.</a> Veuillez consulter vos spécialistes sur la protection des données pour des conseils.';
$string['config_experimental_features'] = 'Fonctionnalités expérimentales';
$string['config_experimental_features_description'] = 'Configuration pour les fonctionnalités expérimentales.';
$string['config_extended_capabilities'] = 'Capacités étendues';
$string['config_extended_capabilities_description'] = 'Configuration pour des capacités étendues lorsque le serveur BigBlueButton le permet.';
$string['config_general'] = 'Réglages généraux';
$string['config_general_description'] = 'Pour configurer BigBlueButton, vous pouvez soit utiliser votre propre serveur BigBlueButton et votre accréditation, soit obtenir une accréditation sur le <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">portail d’enregistrement de Blindside Networks (s’ouvre dans une nouvelle fenêtre)</a>.';
$string['config_guestaccess_enabled'] = 'Accès invité externe';
$string['config_guestaccess_enabled_description'] = 'Permettre aux utilisateurs qui n’ont pas de compte sur ce site d’accéder à la salle.';
$string['config_hideuserlist_default'] = 'Le réglage « Cacher la liste des utilisateurs » est activé par défaut';
$string['config_hideuserlist_default_description'] = 'Si ce réglage est activé, la liste des utilisateurs de la session sera masquée.';
$string['config_hideuserlist_editable'] = 'Le réglage « Cacher la liste des utilisateurs » peut être modifié';
$string['config_hideuserlist_editable_description'] = 'Le réglage « Cacher la liste des utilisateurs » peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_importrecordings'] = 'Importer des enregistrements';
$string['config_importrecordings_description'] = 'Ces réglages sont spécifiques à une fonctionnalité.';
$string['config_importrecordings_enabled'] = 'Importer des enregistrements activé';
$string['config_importrecordings_enabled_description'] = 'Si ce réglage et si l’enregistrement sont activés, il est possible d’importer des enregistrements de différents cours dans une activité.';
$string['config_importrecordings_from_deleted_enabled'] = 'Importation d’enregistrements d’activités supprimées autorisée';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Si ce réglage et la fonction d’importation d’enregistrements sont activés, il est possible d’importer des enregistrements d’activités qui ne sont plus dans le cours.';
$string['config_locksettings'] = 'Configuration pour les réglages de verrouillage';
$string['config_locksettings_description'] = 'Ces réglages activent ou désactivent les options de l’interface utilisateur pour les réglages de verrouillage et définissent également les valeurs par défaut de ces options.';
$string['config_meetingevents_enabled'] = 'Enregistrer les sessions en direct';
$string['config_meetingevents_enabled_description'] = 'Si ce réglage est activé, les sessions en direct seront traitées après la fin de la session. Cette fonctionnalité doit être activée pour l’Achèvement de l’activité et ne fonctionnera que si le serveur BigBlueButton est capable de traiter les scripts post_events.';
$string['config_muteonstart'] = 'Muet au démarrage';
$string['config_muteonstart_default'] = '« Muet au démarrage » activé par défaut';
$string['config_muteonstart_default_description'] = 'Si ce réglage est activé, la session sera muette au démarrage.';
$string['config_muteonstart_description'] = 'Ces paramètres activent ou désactivent les réglages dans l’interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_muteonstart_editable'] = 'Le réglage « Muet au démarrage » peut être modifié';
$string['config_muteonstart_editable_description'] = 'Le réglage « Muet au démarrage » par défaut peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_participant'] = 'Participants';
$string['config_participant_description'] = 'Ces réglages définissent le rôle par défaut des participants.';
$string['config_participant_moderator_default'] = 'Modérateur';
$string['config_participant_moderator_default_description'] = 'Cette règle est utilisée par défaut quand une nouvelle salle est ajoutée.';
$string['config_poll_interval'] = 'Durée d’actualisation (en secondes) du statut de la salle';
$string['config_poll_interval_description'] = 'La durée entre les requêtes d’actualisation doit être d’au moins 2 secondes. Si nécessaire, elle peut être augmentée pour abaisser la charge sur le serveur distant.';
$string['config_presentation_default'] = 'Fichier de présentation par défaut';
$string['config_presentation_default_description'] = 'Un fichier à utiliser dans toutes les salles peut être fourni.';
$string['config_preuploadpresentation'] = 'Fichier de présentation';
$string['config_preuploadpresentation_description'] = 'Ces réglages activent ou désactivent les réglages dans l’interface utilisateur et définissent également les valeurs par défaut de ces options. Cette fonctionnalité ne fonctionne que si le serveur BigBlueButton peut accéder au serveur Moodle.';
$string['config_preuploadpresentation_editable'] = 'Fichier de présentation sur la page de l’activité';
$string['config_preuploadpresentation_editable_description'] = 'Option dans les réglages de l’activité pour déposer un fichier de présentation à afficher sur la page de l’activité.';
$string['config_profile_picture_enabled'] = 'Afficher les images de profil';
$string['config_profile_picture_enabled_description'] = 'Les images de profil des participants doivent-elles être affichées dans les sessions BigBlueButton ?';
$string['config_recording'] = 'Enregistrement de la réunion';
$string['config_recording_all_from_start_default'] = 'Commencer l’enregistrement dès le début';
$string['config_recording_all_from_start_default_description'] = 'Si ce réglage est activé, le réglage « Commencer l’enregistrement dès le début » sera activé par défaut lors de l’ajout d’une salle BigBlueButton.';
$string['config_recording_all_from_start_editable'] = 'Le réglage « Commencer l’enregistrement dès le début » peut être modifié';
$string['config_recording_all_from_start_editable_description'] = 'Si ce réglage est activé, le réglage « Commencer l’enregistrement dès le début » peut être modifié dans les réglages de l’activité BigBlueButton.';
$string['config_recording_default'] = 'Enregistrement activé par défaut';
$string['config_recording_default_description'] = 'Si ce réglage est activé, le réglage « Enregistrement de la réunion » sera activé par défaut lors de l’ajout d’une salle BigBlueButton.';
$string['config_recording_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_recording_editable'] = 'Le réglage « Enregistrement de la réunion » peut être modifié';
$string['config_recording_editable_description'] = 'Si ce réglage est activé, le réglage « Enregistrement de la réunion » peut être modifié dans les réglages de l’activité BigBlueButton.';
$string['config_recording_hide_button_default'] = 'Cacher le bouton d’enregistrement';
$string['config_recording_hide_button_default_description'] = 'Si ce réglage est activé, le bouton d’enregistrement sera caché';
$string['config_recording_hide_button_editable'] = 'Le réglage « Cacher le bouton d’enregistrement » peut être modifié';
$string['config_recording_hide_button_editable_description'] = 'Si ce réglage est activé, le réglage « Cacher le bouton d’enregistrement » peut être modifié dans les réglages de l’activité BigBlueButton.';
$string['config_recording_protect_editable'] = 'L’état « Enregistrement protégé » peut être modifié';
$string['config_recording_protect_editable_description'] = 'Si ce réglage est activé, l’interface comporte un réglage pour protéger/déprotéger les enregistrements';
$string['config_recording_refresh_period'] = 'Période d’actualisation de l’enregistrement (en secondes)';
$string['config_recording_refresh_period_description'] = 'Fréquence des requêtes d’actualisation des informations distantes d’un enregistrement sur le serveur BigBlueButton.';
$string['config_recording_safe_formats'] = 'Formats d’enregistrement visionnables par tout le monde';
$string['config_recording_safe_formats_description'] = 'Sélectionner les formats visionnables par tout le monde. Tous les autres formats ne sont visionnables que par les enseignants et les autres utilisateurs ayant les capacités mod/bigbluebuttonbn:viewallrecordingformats et
 mod/bigbluebuttonbn:managerecordings.';
$string['config_recordingready_enabled'] = 'Envoyer une notification de disponibilité d’un enregistrement';
$string['config_recordingready_enabled_description'] = 'Si ce réglage est activé, une notification sera envoyée quand un lien d’enregistrement est disponible. Cette fonctionnalité requiert l’activation du script post_publish_recording_ready_callback sur le serveur BigBlueButton.';
$string['config_recordings'] = 'Afficher les enregistrements';
$string['config_recordings_asc_sort'] = 'Trier les enregistrements par ordre chronologique.';
$string['config_recordings_asc_sort_description'] = 'Les enregistrements sont triés par date, par ordre chronologique ou chronologique inverse.';
$string['config_recordings_deleted_default'] = 'La fonctionnalité « Inclure les enregistrements des activités supprimées » est activée par défaut';
$string['config_recordings_deleted_default_description'] = 'Si ce réglage est activé, la table d’enregistrements inclura les enregistrements des activités supprimées.';
$string['config_recordings_deleted_editable'] = 'La fonctionnalité « Inclure les enregistrements des activités supprimées » peut être modifiée';
$string['config_recordings_deleted_editable_description'] = 'La fonctionnalité « Inclure les enregistrements des activités supprimées » par défaut peut être modifiée quand l’instance est ajoutée ou modifiée.';
$string['config_recordings_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_recordings_general'] = 'Afficher les paramètres d’enregistrement';
$string['config_recordings_general_description'] = 'Ces paramètres sont utilisés uniquement si les enregistrements sont affichés';
$string['config_recordings_imported_default'] = 'Afficher uniquement les liens importés activé par défaut';
$string['config_recordings_imported_default_description'] = 'Si ce réglage est activé, la table d’enregistrements ne contiendra que les liens importés vers d’autres enregistrements';
$string['config_recordings_imported_editable'] = 'La fonctionnalité « Afficher uniquement les liens importés » peut être modifiée';
$string['config_recordings_imported_editable_description'] = 'Afficher uniquement les liens importés par défaut peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_recordings_preview_default'] = 'L’aperçu est activé par défaut';
$string['config_recordings_preview_default_description'] = 'Si ce réglage est activé, la table inclut un aperçu de la présentation.';
$string['config_recordings_preview_editable'] = 'La fonctionnalité « Aperçu » peut être modifiée';
$string['config_recordings_preview_editable_description'] = 'La fonctionnalité « Aperçu » peut être modifiée quand l’instance est ajoutée ou modifiée.';
$string['config_scheduled'] = 'Sessions planifiées';
$string['config_scheduled_description'] = 'Ces réglages définissent le comportement par défaut des sessions planifiées.';
$string['config_scheduled_pre_opening'] = 'Disponible avant l’heure d’ouverture';
$string['config_scheduled_pre_opening_description'] = 'Le temps en minutes pour accéder à la salle avant l’heure d’ouverture planifiée.';
$string['config_server_url'] = 'URL du serveur BigBlueButton';
$string['config_server_url_description'] = 'L’URL de votre serveur BigBlueButton.';
$string['config_shared_secret'] = 'Secret partagé BigBlueButton';
$string['config_shared_secret_description'] = 'Le secret de sécurité de votre serveur BigBlueButton.';
$string['config_uidelegation_enabled'] = 'La délégation de l’interface utilisateur est activée';
$string['config_uidelegation_enabled_description'] = 'Ces réglages activent ou désactivent la délégation d’interface utilisateur au serveur BigBlueButton.';
$string['config_userlimit'] = 'Limite d’utilisateurs';
$string['config_userlimit_default'] = 'Limite d’utilisateurs activée par défaut';
$string['config_userlimit_default_description'] = 'Le nombre d’utilisateurs autorisés par défaut quand une nouvelle salle est ajoutée. Si le nombre est 0, il n’y a pas de limite du nombre d’utilisateurs.';
$string['config_userlimit_description'] = 'Ces réglages activent ou désactivent les options dans l’interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_userlimit_editable'] = 'Le réglage « Limite d’utilisateurs » peut être modifié';
$string['config_userlimit_editable_description'] = 'Le nombre limite d’utilisateurs par défaut peut être modifié quand l’instance est ajoutée ou modifiée.';
$string['config_voicebridge'] = 'Conférence vocale';
$string['config_voicebridge_description'] = 'Ces paramètres activent ou désactivent les options dans l’interface utilisateur et définissent également les valeurs par défaut de ces options.';
$string['config_voicebridge_editable'] = 'La conférence vocale peut être modifiée';
$string['config_voicebridge_editable_description'] = 'Un numéro de conférence vocale peut être attribué de manière permanente à une salle. Une fois attribué, le numéro ne peut plus être utilisé pour une autre salle.';
$string['config_waitformoderator'] = 'Attendre un modérateur';
$string['config_waitformoderator_cache_ttl'] = 'Cache TTL de la fonction « Attendre un modérateur »';
$string['config_waitformoderator_cache_ttl_description'] = 'Pour supporter une charge importante de clients, ce plugin utilise un cache. Ce paramètre définit la durée pendant laquelle le cache sera conservé avant que la prochaine requête soit envoyée au serveur BigBlueButton.';
$string['config_waitformoderator_default'] = 'Attendre un modérateur activé par défaut';
$string['config_waitformoderator_default_description'] = 'Si ce réglage est activté, le réglage « Attendre un modérateur » est activé par défaut quand une nouvelle salle BigBlueButton est ajoutée.';
$string['config_waitformoderator_description'] = 'Ces réglages sont spécifiques à cette fonctionnalité';
$string['config_waitformoderator_editable'] = 'Le réglage « Attendre un modérateur » peut être modifié';
$string['config_waitformoderator_editable_description'] = 'Si ce réglage est activé, le réglage « Attendre un modérateur » peut être modifié dans les réglages de l’activité BigBlueButton.';
$string['config_waitformoderator_ping_interval'] = 'Signal serveur (ping) de la fonctionnalité « Attendre un modérateur »';
$string['config_waitformoderator_ping_interval_description'] = 'Fréquence des requêtes (ping) vers le serveur pour vérifier si le modérateur est entré dans la salle.';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton utilise le fichier config.php avec une variable globale obsolète. Veuillez convertir le fichier car il ne sera pas pris en charge dans de futures versions.';
$string['config_warning_curl_not_installed'] = 'Cette fonctionnalité nécessite que l’extension cURL de PHP soit installée et activée. Le réglage ne sera disponible que si cette condition est remplie.';
$string['config_welcome_default'] = 'Message d’accueil par défaut';
$string['config_welcome_default_description'] = 'Le message de bienvenue est affiché quand les participants entrent dans la salle. Si ce champ est laissé vide, la chaîne de caractères « mod_form_field_welcome_default » est utilisée.';
$string['config_welcome_editable'] = 'Le message de bienvenue par défaut est modifiable par les enseignants';
$string['config_welcome_editable_description'] = 'Le message de bienvenue peut être modifié lorsque l’instance est ajoutée ou mise à jour';
$string['credentials_warning'] = 'L’utilisation de l’accréditation serveur par défaut ne sera bientôt plus valable (voir la note ci-dessus pour obtenir une nouvelle accréditation).';
$string['dpainfonotsigned'] = 'Avant d’activer ce plugin, vous devez confirmer que vous avez lu et accepté l’<a href="{$a}" target="_blank">accord sur le traitement des données de Blindside Networks</a>.';
$string['enablingbigbluebutton'] = 'Activation de l’activité BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Afin de remplir vos obligations en terme de protection des données, avant d’activer ce plugin, vous devez confirmer que vous avez lu et accepté l’<a href="{$a}" target="_blank">accord sur le traitement des données de Blindside Networks</a>. Veuillez consulter vos spécialistes en protection des données pour des conseils.';
$string['end_session_confirm'] = 'Voulez-vous vraiment terminer la réunion ?';
$string['end_session_confirm_title'] = 'Voulez-vous vraiment terminer la session ?';
$string['end_session_notification'] = 'La session s’est terminée.';
$string['ends_at'] = 'Se termine';
$string['event_activity_created'] = 'Activité créée';
$string['event_activity_deleted'] = 'Activité supprimée';
$string['event_activity_updated'] = 'Activité modifiée';
$string['event_live_session'] = 'Événement de session en direct';
$string['event_meeting_created'] = 'Réunion créée';
$string['event_meeting_ended'] = 'Réunion fermée (de force)';
$string['event_meeting_joined'] = 'Réunion rejointe';
$string['event_meeting_left'] = 'Réunion quittée';
$string['event_recording_deleted'] = 'Enregistrement supprimé';
$string['event_recording_edited'] = 'Enregistrement modifié';
$string['event_recording_imported'] = 'Enregistrement importé';
$string['event_recording_protected'] = 'Enregistrement protégé';
$string['event_recording_published'] = 'Enregistrement publié';
$string['event_recording_unprotected'] = 'Enregistrement déprotégé';
$string['event_recording_unpublished'] = 'Enregistrement non publié';
$string['event_recording_viewed'] = 'Enregistrement visionné';
$string['event_unknown'] = 'Événement inconnu';
$string['general_error_cannot_create_meeting'] = 'Impossible de créer de réunion.';
$string['general_error_cannot_get_recordings'] = 'Impossible d’obtenir les enregistrements.';
$string['general_error_no_answer'] = 'Réponse vide. Veuillez vérifier l’URL du serveur BigBlueButton et vérifier si le serveur BigBlueButton fonctionne.';
$string['general_error_not_allowed_to_create_instances'] = 'L’utilisateur n’est autorisé à créer aucun type d’instance.';
$string['general_error_not_found'] = 'Activité BigBlueButton d’identifiant {$a} introuvable.';
$string['general_error_unable_connect'] = 'Impossible de se connecter. Vérifier l’URL du serveur BigBlueButton ET vérifier que le serveur est actif.
Informations additionnelles : {$a}';
$string['guest_invitation_full_message'] = 'Bonjour,
<p>Vous êtes invité à une session BigBlueButton <strong>{$a->name}</strong> dans le cours {$a->course_fullname}.</p>
<p>Lien : {$a->guestjoinurl}</p>.
<p>Mot de passe : {$a->guestpassword}</p>
<p>En cas de besoin, veuillez contacter {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Bonjour,

Vous êtes invité à une session BigBlueButton {$a->name} dans le cours {$a->course_fullname}.

Lien : {$a->guestjoinurl}.
Mot de passe : {$a->guestpassword}

En cas de besoin, veuillez contacter {$a->sender}.';
$string['guest_invitation_subject'] = 'Invitation : session {$a->name} dans {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Activité introuvable.';
$string['guestaccess_add'] = 'Ajouter des invités';
$string['guestaccess_add_no_id'] = 'Aucun ID d’instance BigBlueButton fourni.';
$string['guestaccess_copy_link'] = 'Copier le lien';
$string['guestaccess_copy_password'] = 'Copier le mot de passe';
$string['guestaccess_emails'] = 'Adresses de courriel des invités';
$string['guestaccess_emails_help'] = 'Une liste d’adresses de courriels, séparées par des virgules.';
$string['guestaccess_emails_invalidemail'] = 'Adresse de courriel non valide : {$a}';
$string['guestaccess_feature_disabled'] = 'Accès invité désactivé.';
$string['guestaccess_invite_failure'] = 'Erreur {$a->errors} lors de l’invitation de {$a->emails}.';
$string['guestaccess_invite_success'] = 'Une invitation sera envoyée à {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Rejoindre la réunion';
$string['guestaccess_meeting_invalid_password'] = 'Mot de passe incorrect';
$string['guestaccess_meeting_link'] = 'Lien vers la réunion';
$string['guestaccess_meeting_not_started'] = 'La réunion n’a pas encore commencé. Veuillez essayer plus tard.';
$string['guestaccess_meeting_password'] = 'Mot de passe de la réunion';
$string['guestaccess_password'] = 'Mot de passe';
$string['guestaccess_title'] = 'Ajouter des invités à cette réunion';
$string['guestaccess_username'] = 'Nom de l’invité';
$string['index_confirm_end'] = 'Souhaitez-vous terminer la réunion ?';
$string['index_disabled'] = 'désactivé';
$string['index_enabled'] = 'activé';
$string['index_ending'] = 'Fermeture de la réunion… veuiller patienter';
$string['index_error_bbtn'] = 'L’ID BigBlueButton {$a} est incorrect';
$string['index_error_checksum'] = 'Une erreur de somme de contrôle est survenue. Vérifier que le secret saisi est correct.';
$string['index_error_forciblyended'] = 'Impossible de joindre cette réunion, car elle a été fermée manuellement.';
$string['index_error_noinstances'] = 'Il n’y a pas d’instance de salle BigBlueButton';
$string['index_error_unable_display'] = 'Impossible d’afficher les réunions. Veuillez vérifier l’URL du serveur BigBlueButton ET vérifier que le serveur BigBlueButton est bien actif.';
$string['index_heading'] = 'Salles BigBlueButton';
$string['index_heading_actions'] = 'Actions';
$string['index_heading_group'] = 'Groupe';
$string['index_heading_moderator'] = 'Modérateurs';
$string['index_heading_name'] = 'Salle';
$string['index_heading_recording'] = 'Enregistrement';
$string['index_heading_users'] = 'Utilisateurs';
$string['index_heading_viewer'] = 'Participants';
$string['indicator:cognitivedepth'] = 'BigBlueButton cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l’étudiant dans une activité BigBlueButton.';
$string['indicator:socialbreadth'] = 'BigBlueButton social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur est basé sur l’étendue sociale atteinte par l’étudiant dans une activité BigBlueButton.';
$string['instance_type_default'] = 'Salle avec enregistrements';
$string['instance_type_recording_only'] = 'Enregistrements seulement';
$string['instance_type_room_only'] = 'Salle seulement';
$string['instanceprofilewithoutrecordings'] = 'Ce profil d’instance ne peut pas afficher d’enregistrement';
$string['managebbbextplugins'] = 'Gérer les plugins d’extension BigBlueButton';
$string['messageprovider:instance_updated'] = 'Réunion BigBlueButton modifiée';
$string['messageprovider:recording_ready'] = 'Enregistrement BigBlueButton disponible';
$string['minute'] = 'minute';
$string['minutes'] = 'minutes';
$string['mod_form_block_general'] = 'Général';
$string['mod_form_block_guestaccess'] = 'Accès invité';
$string['mod_form_block_participants'] = 'Rôle attribué pendant la session en direct';
$string['mod_form_block_presentation'] = 'Contenu de présentation';
$string['mod_form_block_presentation_default'] = 'Contenu par défaut de la présentation';
$string['mod_form_block_record'] = 'Paramètres d’enregistrement';
$string['mod_form_block_recordings'] = 'Vue enregistrement';
$string['mod_form_block_room'] = 'Paramètres de la salle';
$string['mod_form_block_schedule'] = 'Horaire de la réunion';
$string['mod_form_field_closingtime'] = 'Fermer';
$string['mod_form_field_conference_name'] = 'Nom de la réunion';
$string['mod_form_field_disablecam'] = 'Désactiver les webcams';
$string['mod_form_field_disablemic'] = 'Désactiver les micros';
$string['mod_form_field_disablenote'] = 'Désactiver les notes partagées';
$string['mod_form_field_disableprivatechat'] = 'Désactiver la discussion privée';
$string['mod_form_field_disablepublicchat'] = 'Désactiver la discussion publique';
$string['mod_form_field_duration'] = 'Durée';
$string['mod_form_field_duration_help'] = 'Définir la durée d’une réunion établira la durée maximale d’une réunion, avant que l’enregistrement ne se termine.';
$string['mod_form_field_guestallowed'] = 'Permettre l’accès invité';
$string['mod_form_field_hideuserlist'] = 'Cacher la liste des participants';
$string['mod_form_field_instanceprofiles'] = 'Type de conférence';
$string['mod_form_field_instanceprofiles_help'] = 'Si une réunion doit être enregistrées, choisir « Salle avec enregistrements », sinon, choisir « Salle seulement ». Après l’enregistrement d’une réunion, si aucune autre réunion n’est prévue, choisir « Enregistrements seulement »';
$string['mod_form_field_intro'] = 'Description';
$string['mod_form_field_intro_help'] = 'Une courte description pour la salle.';
$string['mod_form_field_mustapproveuser'] = 'Les invités doivent être approuvés par un modérateur';
$string['mod_form_field_muteonstart'] = 'Muet au début';
$string['mod_form_field_name'] = 'Nom de la salle';
$string['mod_form_field_nosettings'] = 'Aucun paramètre ne peut être modifié';
$string['mod_form_field_openingtime'] = 'Ouvrir';
$string['mod_form_field_participant_add'] = 'Ajouter une attribution';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Modérateur';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Participant';
$string['mod_form_field_participant_list'] = 'Attribution';
$string['mod_form_field_participant_list_action_add'] = 'Ajouter';
$string['mod_form_field_participant_list_action_remove'] = 'Retirer';
$string['mod_form_field_participant_list_text_as'] = 'rejoint la session en tant que';
$string['mod_form_field_participant_list_type_all'] = 'Tous les utilisateurs inscrits';
$string['mod_form_field_participant_list_type_owner'] = 'Propriétaire';
$string['mod_form_field_participant_list_type_role'] = 'Rôle';
$string['mod_form_field_participant_list_type_user'] = 'Utilisateur';
$string['mod_form_field_record'] = 'La session peut être enregistrée.';
$string['mod_form_field_recordallfromstart'] = 'Tout enregistrer du début';
$string['mod_form_field_recordhidebutton'] = 'Masquer le bouton d’enregistrement';
$string['mod_form_field_recordings_deleted'] = 'Inclure les enregistrements des activités supprimées';
$string['mod_form_field_recordings_html'] = 'Afficher la table en HTML';
$string['mod_form_field_recordings_imported'] = 'Afficher uniquement les liens importés';
$string['mod_form_field_recordings_preview'] = 'Afficher l’aperçu de l’enregistrement';
$string['mod_form_field_room_name'] = 'Nom de la conférence';
$string['mod_form_field_userlimit'] = 'Limite utilisateurs';
$string['mod_form_field_userlimit_help'] = 'Limite maximum d’utilisateurs dans une réunion. Indiquer 0 pour permettre un nombre illimité d’utilisateurs.';
$string['mod_form_field_voicebridge'] = 'Conférence vocale [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Erreur de format. Veuillez saisir un nombre entre 1 et 9999.';
$string['mod_form_field_voicebridge_help'] = 'Un nombre entre 1 et 9999 que les participants doivent saisir pour joindre la conférence vocale. Si la valeur est 0, un nombre aléatoire sera généré par BigBlueButton. Le chiffre 7 sera placé devant les 4 chiffres saisis.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Valeur non unique. Ce nombre est utilisé par une autre salle.';
$string['mod_form_field_wait'] = 'Attendre le modérateur';
$string['mod_form_field_wait_help'] = 'Si ce réglage est activé, les participants doivent attendre un modérateur avant de pouvoir entrer dans la salle.';
$string['mod_form_field_welcome'] = 'Message d’accueil';
$string['mod_form_field_welcome_default'] = 'Bienvenue dans %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Le message de bienvenue est affiché quand les participants entrent dans la salle. Si ce champ est laissé vide, un message par défaut défini dans l’administration du site est affiché.';
$string['mod_form_locksettings'] = 'Réglages de verrouillage';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton est un système de conférence web open source conçu pour l’enseignement en ligne, qui permet en temps réel le partage d’audio, de vidéo, de diapositives et d’écran, ainsi que du chat, un tableau blanc multi-utilisateurs, des salles de pause, des sondages et des émojis.

Avec BigBlueButton, on peut créer une salle de réunion pour un cours en ligne, une séance de travail virtuel ou des travaux de groupe avec des étudiants à distance. La réunion peut être enregistrée pour être revue ultérieurement.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Activité BigBlueButton';
$string['nosuchinstance'] = 'Pas d’instance {$a->entity} d’identifiant {$a->id}';
$string['notification_instance_created_intro'] = 'La salle BigBlueButton <a href="{$a->link}">{$a->name}</a> a été créée.';
$string['notification_instance_created_small'] = 'Une salle BigBlueButton nommée {$a->name} a été créée.';
$string['notification_instance_created_subject'] = 'Une salle BigBlueButton a été créée';
$string['notification_instance_description'] = 'Description';
$string['notification_instance_end_date'] = 'Date de fin';
$string['notification_instance_name'] = 'Titre';
$string['notification_instance_start_date'] = 'Date de début';
$string['notification_instance_updated_intro'] = 'La salle BigBlueButton <a href="{$a->link}">{$a->name}</a> a été modifiée.';
$string['notification_instance_updated_small'] = 'La réunion BigBlueButton {$a->name} a été modifiée';
$string['notification_instance_updated_subject'] = 'Votre réunion BigBlueButton a été modifiée';
$string['notification_recording_ready_html'] = 'Un enregistrement est disponible pour une réunion dans la salle BigBlueButton <a href="{$a->link}">{$a->name}</a>.';
$string['notification_recording_ready_plain'] = 'Un enregistrement est disponible pour une réunion dans la salle BigBlueButton {$a->name}. Visitez {$a->link} pour accéder au lien de l’enregistrement.';
$string['notification_recording_ready_small'] = 'Un enregistrement est disponible pour la salle BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'Enregistrement disponible';
$string['pluginadministration'] = 'Administration BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Afin de créer et de rejoindre des sessions BigBlueButton, les données utilisateur doivent être échangées avec le serveur.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Le nom complet de l’utilisateur qui accède au serveur BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'L’ID de l’utilisateur qui accède au serveur BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Configuration de la session BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Une liste de règles qui définissent le rôle des utilisateurs dans la réunion BigBlueButton. Un ID utilisateur peut être enregistré car les autorisations peuvent être accordées par rôle ou par utilisateur.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Stocke les événements déclenchés lors de l’utilisation du plugin.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Le type d’événement déclenché par l’utilisateur.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'L’ID de la réunion à laquelle l’utilisateur a eu accès.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Informations supplémentaires relatives à la réunion ou à l’enregistrement.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'L’horodatage de la création du journal.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'L’identifiant de l’utilisateur qui a déclenché l’événement.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Enregistre les métadonnées des enregistrements.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'L’ID utilisateur de l’utilisateur qui a modifié un enregistrement en dernier.';
$string['progress_createbigbluebuttonbn'] = 'Création de l’activité BigBlueButton ({$a})';
$string['recordings_from_deleted_activities'] = 'Enregistrements d’activités supprimées';
$string['recordingurlnotfound'] = 'L’URL de l’enregistrement n’est pas valide';
$string['removedevents'] = 'Événements supprimés';
$string['removedlogs'] = 'Journaux personnalisés supprimés';
$string['removedrecordings'] = 'Enregistrements supprimés';
$string['removedtags'] = 'Mots-clefs supprimés';
$string['report_join_info'] = '{$a} réunion(s)';
$string['report_play_recording_info'] = '{$a} enregistrement(s) visionnés';
$string['report_room_view'] = 'consulté';
$string['resetevents'] = 'Supprimer les événements';
$string['resetlogs'] = 'Supprimer les journaux personnalisés';
$string['resetlogs_help'] = 'La suppression des journaux causera la perte des références vers les enregistrements.';
$string['resetrecordings'] = 'Supprimer les enregistrements';
$string['resetrecordings_help'] = 'La suppression des enregistrements les rendra indisponibles. Cette action ne peut pas être annulée !';
$string['resettags'] = 'Supprimer les mots-clefs';
$string['search:activity'] = 'BigBlueButton - informations sur l’activité';
$string['search:tags'] = 'BigBlueButton - informations sur les mots-clefs';
$string['sendnotification'] = 'Envoyer une notification';
$string['settings'] = 'Réglages BigBlueButton';
$string['settings_credential_warning'] = 'L’accréditation au serveur BigBlueButton arrivera bientôt à échéance. Voir les <a href="{$a->settingslink}" target="_blank">réglages généraux BigBlueButton (s’ouvre dans une nouvelle fenêtre)</a>.';
$string['settings_credential_warning_no_capability'] = 'L’accréditation au serveur BigBlueButton arrivera bientôt à échéance. Veuillez contacter l’administrateur de votre site.';
$string['started_at'] = 'Débute';
$string['starts_at'] = 'A débuté';
$string['subplugintype_bbbext'] = 'Extension d’activité BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Extensions d’activité BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Rechercher des enregistrements qui n’ont pas encore été trouvés';
$string['taskname:check_pending_recordings'] = 'Récupérer les enregistrements en attente';
$string['userlimitreached'] = 'Le nombre d’utilisateurs permis dans une réunion a été atteint.';
$string['view_conference_action_end'] = 'Terminer la session';
$string['view_conference_action_join'] = 'Entrer dans la session';
$string['view_error_action_not_completed'] = 'L’action n’a pas pu être complétée';
$string['view_error_bigbluebutton'] = 'Une erreur est survenue dans BigBlueButton. {$a}';
$string['view_error_create'] = 'Le serveur BigBlueButton a renvoyé un message d’erreur. La salle n’a pas pu être créée.';
$string['view_error_current_state_not_found'] = 'L’état actuel n’a pas été trouvé. L’enregistrement a peut-être été supprimé ou le serveur BigBlueButton n’est pas compatible avec l’action effectuée.';
$string['view_error_import_no_courses'] = 'Il n’y a pas de cours où chercher des enregistrements.';
$string['view_error_import_no_recordings'] = 'Il n’y a pas d’enregistrements à importer dans ce cours.';
$string['view_error_invalid_session'] = 'La session est échue. Retournez à la page de l’activité.';
$string['view_error_max_concurrent'] = 'Le nombre de sessions simultanées autorisé a été atteint.';
$string['view_error_meeting_not_running'] = 'Une erreur est survenue ; la réunion n’a pas lieu.';
$string['view_error_no_group'] = 'Il n’y a pas de groupes. Veuillez créer des groupes avant d’essayer de joindre la réunion.';
$string['view_error_no_group_student'] = 'Vous n’avez pas été ajouté à un groupe. Veuillez contacter votre enseignant.';
$string['view_error_no_group_teacher'] = 'Il n’y a pas de groupes. Vous devez créer des groupes.';
$string['view_error_unable_join'] = 'Impossible d’entrer dans la salle. Vérifiez l’URL du serveur BigBlueButton ET vérifiez que le serveur BigBlueButton est actif.';
$string['view_error_unable_join_student'] = 'Impossible de se connecter au serveur BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Impossible de se connecter au serveur BigBlueButton. Veuillez contacter un administrateur.';
$string['view_error_url_missing_parameters'] = 'Des paramètres manquent dans cet URL';
$string['view_error_userlimit_reached'] = 'La limite du nombre d’utilisateurs autorisés dans une réunion a été atteinte.';
$string['view_groups_nogroups_warning'] = 'La salle a été configurée pour utiliser les groupes mais il n’y a aucun groupe dans le cours.';
$string['view_groups_notenrolled_warning'] = 'La salle a été configurée pour utiliser les groupes, mais vous n’êtes membre d’aucun groupe.';
$string['view_groups_selection'] = 'Sélectionnez le groupe que vous souhaitez joindre, et confirmez l’action';
$string['view_groups_selection_join'] = 'Joindre';
$string['view_groups_selection_warning'] = 'Il y a une salle pour chaque groupe et vous avez accès à plusieurs d’entre elles. Assurez-vous de choisir la bonne.';
$string['view_login_moderator'] = 'Connexion comme modérateur…';
$string['view_login_viewer'] = 'Connexion comme participant…';
$string['view_message_and'] = 'et';
$string['view_message_conference_has_ended'] = 'La réunion est terminée.';
$string['view_message_conference_in_progress'] = 'La réunion est en cours.';
$string['view_message_conference_not_started'] = 'La réunion n’a pas encore commencé.';
$string['view_message_conference_room_ready'] = 'Cette salle est prête. Vous pouvez rejoindre la réunion maintenant.';
$string['view_message_conference_user_limit_reached'] = 'La limite du nombre d’utilisateurs autorisés dans une réunion a été atteinte.';
$string['view_message_conference_wait_for_moderator'] = 'En attente d’un modérateur pour pouvoir joindre la session.';
$string['view_message_cron_disabled'] = 'La liste des enregistrements n’est peut-être pas à jour. Veuillez contacter l’administrateur du site avec les informations suivantes : {$a}';
$string['view_message_finished'] = 'Cette activité est terminée.';
$string['view_message_has_joined'] = 'a rejoint';
$string['view_message_have_joined'] = 'ont rejoint';
$string['view_message_hour'] = 'heure';
$string['view_message_hours'] = 'heures';
$string['view_message_importrecordings_disabled'] = 'L’importation de liens d’enregistrement est désactivée sur le serveur.';
$string['view_message_minute'] = 'minute';
$string['view_message_minutes'] = 'minutes';
$string['view_message_moderator'] = 'Modérateur';
$string['view_message_moderators'] = 'Modérateurs';
$string['view_message_norecordings'] = 'Aucun enregistrement disponible.';
$string['view_message_notavailableyet'] = 'Cette session n’est pas encore disponible.';
$string['view_message_recordings_disabled'] = 'Les enregistrements sont désactivés sur ce serveur. Les activités BigBlueButton de type « Enregistrements seulement » ne peuvent pas être utilisées.';
$string['view_message_room_closed'] = 'Cette salle est fermée.';
$string['view_message_room_open'] = 'Cette salle est ouverte.';
$string['view_message_room_ready'] = 'Cette salle est prête.';
$string['view_message_session_for'] = 'la session pour';
$string['view_message_session_has_user'] = 'Il y a';
$string['view_message_session_has_users'] = 'Il y a';
$string['view_message_session_no_users'] = 'Il n’y a pas d’utilisateurs dans cette session';
$string['view_message_session_running_for'] = 'Cette session a duré';
$string['view_message_session_started_at'] = 'Session démarrée à';
$string['view_message_tab_close'] = 'Cet onglet (ou fenêtre) doit être fermé(e) manuellement';
$string['view_message_times'] = 'temps';
$string['view_message_user'] = 'Utilisateur';
$string['view_message_users'] = 'Utilisateurs';
$string['view_message_viewer'] = 'Spectateur';
$string['view_message_viewers'] = 'Spectateurs';
$string['view_mobile_message_groups_not_supported'] = 'Cette instance permet de travailler avec des groupes, mais l’application mobile ne prend pas en charge cette fonctionnalité. Veuillez utiliser la version web.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Vous avez dépassé les 45 secondes sur cette page. Veuillez recharger la page pour joindre correctement la réunion.';
$string['view_noguests'] = 'La salle BigBlueButton n’est pas ouverte aux visiteurs anonymes.';
$string['view_nojoin'] = 'Votre rôle ne vous permet pas de joindre cette réunion.';
$string['view_recording'] = 'enregistrement';
$string['view_recording_actionbar'] = 'Barre d’outils';
$string['view_recording_activity'] = 'Activité';
$string['view_recording_button_import'] = 'Import de liens d’enregistrement';
$string['view_recording_button_return'] = 'Retour';
$string['view_recording_course'] = 'Cours';
$string['view_recording_date'] = 'Date';
$string['view_recording_delete_confirmation'] = 'Voulez-vous vraiment supprimer {$a} ?';
$string['view_recording_delete_confirmation_warning_p'] = 'Cet enregistrement a {$a} liens associés qui ont été importés dans différents cours ou activités. Si l’enregistrement est supprimé, ces liens le seront également';
$string['view_recording_delete_confirmation_warning_s'] = 'Cet enregistrement a {$a} lien associé qui a été importé dans une activité ou un cours différent. Si l’enregistrement est supprimé, ce lien le sera également';
$string['view_recording_description'] = 'Description';
$string['view_recording_description_edithint'] = 'Une description peut être indiquée pour aider à identifier l’enregistrement.';
$string['view_recording_description_editlabel'] = 'Modifier la description';
$string['view_recording_duration'] = 'Durée';
$string['view_recording_duration_min'] = 'min';
$string['view_recording_format_errror_unreachable'] = 'L’URL de ce format d’enregistrement ne peut pas être atteint.';
$string['view_recording_format_notes'] = 'Notes';
$string['view_recording_format_podcast'] = 'Podcast';
$string['view_recording_format_presentation'] = 'Présentation';
$string['view_recording_format_screenshare'] = 'Partage d’écran';
$string['view_recording_format_statistics'] = 'Statistiques';
$string['view_recording_format_video'] = 'Vidéo';
$string['view_recording_import_confirmation'] = 'Voulez-vous vraiment importer cet enregistrement ?';
$string['view_recording_length'] = 'Durée';
$string['view_recording_link'] = 'Lien importé';
$string['view_recording_link_warning'] = 'Ce lien mène à un enregistrement créé dans une activité ou un cours différent.';
$string['view_recording_list_action_delete'] = 'Suppression';
$string['view_recording_list_action_edit'] = 'Mise à jour';
$string['view_recording_list_action_play'] = 'Lire';
$string['view_recording_list_action_process'] = 'En traitement';
$string['view_recording_list_action_protect'] = 'Protéger';
$string['view_recording_list_action_publish'] = 'Publication';
$string['view_recording_list_action_unprotect'] = 'Déprotéger';
$string['view_recording_list_action_unpublish'] = 'Unpublishing';
$string['view_recording_list_action_update'] = 'Mise à jour';
$string['view_recording_list_actionbar'] = 'Outils';
$string['view_recording_list_actionbar_delete'] = 'Supprimer';
$string['view_recording_list_actionbar_edit'] = 'Modifier';
$string['view_recording_list_actionbar_hide'] = 'Cacher';
$string['view_recording_list_actionbar_import'] = 'Importer';
$string['view_recording_list_actionbar_protect'] = 'Rendre privé';
$string['view_recording_list_actionbar_publish'] = 'Publier';
$string['view_recording_list_actionbar_show'] = 'Montrer';
$string['view_recording_list_actionbar_unprotect'] = 'Rendre public';
$string['view_recording_list_actionbar_unpublish'] = 'Annuler la publication';
$string['view_recording_list_activity'] = 'Activité';
$string['view_recording_list_course'] = 'Cours';
$string['view_recording_list_date'] = 'Date';
$string['view_recording_list_description'] = 'Description';
$string['view_recording_list_duration'] = 'Durée';
$string['view_recording_list_recording'] = 'Enregistrement';
$string['view_recording_meeting'] = 'Réunion';
$string['view_recording_modal_button'] = 'Appliquer';
$string['view_recording_modal_title'] = 'Définir les valeurs pour l’enregistrement';
$string['view_recording_name'] = 'Nom';
$string['view_recording_name_edithint'] = 'Un nom peut être indiqué pour aider à identifier l’enregistrement.';
$string['view_recording_name_editlabel'] = 'Modifier le nom';
$string['view_recording_playback'] = 'Lecture';
$string['view_recording_preview'] = 'Aperçu';
$string['view_recording_preview_help'] = 'Survolez une image pour la voir en taille réelle';
$string['view_recording_protect_confirmation'] = 'Voulez-vous vraiment protéger ce {$a} ?';
$string['view_recording_protect_confirmation_warning_p'] = 'Cet enregistrement a {$a} liens associés, qui ont été importés dans divers cours ou activités. Si l’enregistrement est protégé, les liens importés le seront également';
$string['view_recording_protect_confirmation_warning_s'] = 'Cet enregistrement a {$a} lien associé, qui a été importé dans un cours ou une activité différente. Si l’enregistrement est protégé, ce lien importé le sera également.';
$string['view_recording_publish_confirmation'] = 'Voulez-vous vraiment publier ce {$a} ?';
$string['view_recording_publish_confirmation_warning_p'] = 'Cet enregistrement a {$a} liens associés, qui ont été importés dans divers cours ou activités. Si l’enregistrement est publié, les liens importés le seront également.';
$string['view_recording_publish_confirmation_warning_s'] = 'Cet enregistrement a {$a} lien associé, qui a été importé dans un cours ou une activité différente. Si l’enregistrement est publié, ce lien le sera également.';
$string['view_recording_publish_link_deleted'] = 'Ce lien ne peut pas être re-publié car cet enregistrement n’existe pas sur le serveur BigBlueButton. Ce lien devrait être supprimé.';
$string['view_recording_publish_link_not_published'] = 'Ce lien ne peut pas être re-publié car l’enregistrement original est dépublié.';
$string['view_recording_recording'] = 'Enregistrement';
$string['view_recording_select_course'] = 'Sélectionner d’abord un cours dans le menu déroulant';
$string['view_recording_tags'] = 'Mots-clefs';
$string['view_recording_unprotect_confirmation'] = 'Voulez-vous vraiment déprotéger cet {$a} ?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Cet enregistrement comprend {$a} liens associés, qui ont été importés dans divers cours ou activités. Si l’enregistrement est déprotégé, les liens importés le seront également.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Cet enregistrement comprend {$a} lien associé, qui a été importé dans divers cours ou activités. Si l’enregistrement est déprotégé, ce lien importé le sera également.';
$string['view_recording_unprotect_link_deleted'] = 'Ce lien ne peut pas être déprotégé car l’enregistrement original n’existe pas sur le serveur BigBlueButton. Le lien doit être supprimé.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Ce lien ne peut pas être déprotégé car l’enregistrement original est protégé.';
$string['view_recording_unpublish_confirmation'] = 'Voulez-vous vraiment supprimer la publication de cet {$a} ?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Cet enregistrement a {$a} liens associés qui ont été importés dans différents cours ou activités. Si la publication de l’enregistrement est supprimée, celles des liens le seront également.';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Cet enregistrement a {$a} lien associé qui a été importé dans une activité ou un cours différent. Si la publication de l’enregistrement est supprimée, celle du lien le sera également.';
$string['view_recording_yui_first'] = 'Premier';
$string['view_recording_yui_go'] = 'Go';
$string['view_recording_yui_last'] = 'Dernier';
$string['view_recording_yui_next'] = 'Suivant';
$string['view_recording_yui_page'] = 'Page';
$string['view_recording_yui_prev'] = 'Précédent';
$string['view_recording_yui_rows'] = 'Lignes';
$string['view_recording_yui_show_all'] = 'Afficher tout';
$string['view_room'] = 'Voir une salle';
$string['view_section_title_presentation'] = 'Fichier de présentation';
$string['view_section_title_recordings'] = 'Enregistrements';
$string['view_warning_default_server'] = 'Ce serveur Moodle utilise un <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">service BigBlueButton gratuit pour Moodle (s’ouvre dans une nouvelle fenêtre)</a> fourni par Blindside Networks, avec les limitations suivantes :
<ol>
<li>la durée maximale de chaque réunion est de 60 minutes,</li>
<li>le nombre maximal d’utilisateurs simultanés par réunion est de 25,</li>
<li>les enregistrements sont supprimés après sept (7) jours et ne peuvent pas être téléchargés,</li>
<li>les caméras des participants ne sont visibles que pour le modérateur.</li>
</ol>';
$string['waitformoderator'] = 'En attente d’un modérateur';
