<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_exaport', language 'fr', version '4.4'.
 *
 * @package     block_exaport
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutme'] = 'À mon sujet';
$string['aboutme_description'] = 'Prédéfini par les information du CV, mais peut être édité pour chaque bloc';
$string['accessoptions'] = 'Qui a accès ?';
$string['add'] = 'Ajouter';
$string['addButton'] = 'Ajouter';
$string['add_directory_structure'] = 'Ajouter une structure de dossier';
$string['add_mixed'] = 'Ajouter un nouvel artefact';
$string['add_this_file'] = 'Ajouter ce fichier';
$string['addbookmark'] = 'Ajouter un signet';
$string['addcategory'] = 'Ajouter une catégorie';
$string['addcomment'] = 'Ajouter un commentaire';
$string['addposterror'] = 'Une erreur s’est produite en ajoutant cet élément à la base de données';
$string['addstdcat'] = 'Importer les catégories standards';
$string['attachincluded'] = 'Annexe ?';
$string['attachment'] = 'Annexe';
$string['autofillview'] = 'Ajouter automatiquement tous les artefacts disponibles à cette vue';
$string['awaiting'] = '($a en attente)';
$string['back'] = 'Retour';
$string['back_to_desp'] = 'Retour vers la langue du portfolio';
$string['backtocourse'] = 'retour au cours';
$string['badges_help'] = 'Le bloc avec les badges qui vous ont été accordés<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Voir vos badges</a>';
$string['badsessionkey'] = 'Mauvaise clé de session';
$string['block_exaport_allowcustomlayout_body'] = 'Autorise l’utilisation de paramètres de disposition personnalisés (similaire aux options ci-dessous) pour les propriétaires des vues';
$string['block_exaport_allowcustomlayout_head'] = 'Options personnalisées de disposition pour les propriétaires de vues';
$string['block_exaport_app_alloweditdelete_body'] = 'N’est utile qu’utilisé en relation avec le bloc Exabis Compétences et Dakora';
$string['block_exaport_app_alloweditdelete_head'] = 'Les étudiants peuvent modifier ou supprimer des items après que l’enseignant les a vus';
$string['block_exaport_app_externaleportfolio_body'] = 'Pour l’application';
$string['block_exaport_app_externaleportfolio_head'] = 'Enregistrer dans Mahara si sélectionné, sinon vers exaport';
$string['block_exaport_confirm_profilefield_create'] = 'Voulez-vous vraiment ajouter le champ de profil obligatoire ?';
$string['block_exaport_confirm_profilefield_exists'] = 'Le champ de profil pour l’enseignant de confiance existe déjà';
$string['block_exaport_copytomyportfolio'] = 'Activer « Copier vers mon portfolio »';
$string['block_exaport_copytomyportfolio_body'] = 'L’utilisateur sera capable de copier les artefacts depuis une catégorie partagée vers son portfolio';
$string['block_exaport_maxbytes'] = 'Taille maximale pour télécharger un fichier dans ePortfolio';
$string['block_exaport_maxbytes_body'] = 'Définit La taille maximale que les fichiers peuvent avoir dans le Portfolio Exabis <br> Valeur pour tout le site : {$a->sitemaxbytes}. Voir les <a href="{$a->settingsurl}">paramètres</a>';
$string['block_exaport_multiplefilesinitem'] = 'Plusieurs fichiers dans l’artefact « Fichier »';
$string['block_exaport_multiplefilesinitem_body'] = 'limite : 10 fichiers';
$string['block_exaport_profilefield_created'] = 'Le champ de profil pour l’enseignant de confiance a été ajouté';
$string['block_exaport_teachercanseeartifactsofstudents_body'] = 'Les enseignants de confiance doivent être configurés depuis leur propre profil et cela fonctionnera seulement si l’option ci-dessus a été activée.<br />{$a}La liste des étudiants pour chaque enseignant de confiance est générée selon leurs inscriptions aux cours.<br />Les étudiants ne peuvent pas désactiver cet accès. L’accès aux autres étudiants peut être donné comme auparavant.';
$string['block_exaport_teachercanseeartifactsofstudents_configurationlink'] = 'Ajouter un champ de profil utilisateur obligatoire';
$string['block_exaport_teachercanseeartifactsofstudents_head'] = 'Un enseignant peut voir TOUS les artefacts de ses propres étudiants';
$string['block_exaport_used_layout'] = 'Disposition utilisée';
$string['block_exaport_used_layout_body'] = 'Modifie la disposition si vous avez des problèmes d’affichage. Actuellement utilisé pour la liste d’artefacts uniquement';
$string['block_exaport_used_layout_clean_old'] = 'Disposition en tuiles (Obsolète - fin du support depuis v4.6.7)';
$string['block_exaport_used_layout_moodle_bootstrap'] = 'Disposition en cartes';
$string['block_exaport_userquota'] = 'Quota de l’utilisateur pour le portfolio Exabis';
$string['block_exaport_userquota_body'] = 'Définit la quantité maximale de données qu’un utilisateur peut stocker dans son propre Portfolio Exabis <br> Valeur pour tout le site : {$a->sitemaxbytes}. Voir <a href="{$a->settingsurl}">¨Paramètres</a>';
$string['blockcontent'] = 'Contenu du bloc';
$string['blocktitle'] = 'ePortfolio Exabis';
$string['blocktitle2'] = 'Titre du bloc';
$string['bookmarknotfound'] = 'Signet non trouvé';
$string['bookmarksall'] = 'Tous les éléments';
$string['bookmarksfiles'] = 'Fichiers';
$string['bookmarkslinks'] = 'Liens';
$string['bookmarksnotes'] = 'Notes';
$string['browsecategory'] = 'Parcourir cette catégorie';
$string['browseportfolio'] = 'Parcourir ce portfolio';
$string['cancelButton'] = 'Annuler';
$string['categories'] = 'Catégories';
$string['category'] = 'Catégorie';
$string['category_not_found'] = 'Impossible de trouver cette catégorie';
$string['category_up'] = 'retour vers la catégorie parent';
$string['categorydeleted'] = 'Catégorie supprimée';
$string['categoryedited'] = 'Catégorie enregistrée';
$string['categoryhead'] = 'Nom de la catégorie';
$string['categorynotempty'] = 'Vous venez de choisir une catégorie';
$string['categorysaved'] = 'catégorie ajoutée';
$string['change'] = 'Changer';
$string['change_layout'] = 'Changer l’affichage';
$string['checkall'] = 'Tout sélectionner';
$string['chooselayout'] = 'de votre pageSélectionner le mode d’affichage';
$string['clearAllFilers'] = 'Réinitialiser tous les filtres';
$string['clicktodownloadscorm'] = 'Cliquer pour télécharger le fichier SCORM';
$string['close'] = 'fermer';
$string['cofigureblock'] = 'Configurer le bloc';
$string['cofigureblock_badge'] = 'Choisir les badges';
$string['cofigureblock_cvinfo'] = 'Choisir les informations du cv';
$string['cofigureblock_cvinfo_certif'] = 'Certifications, accréditations et distinctions';
$string['cofigureblock_cvinfo_cover'] = 'À mon sujet';
$string['cofigureblock_cvinfo_cover_actual'] = 'ajouter le contenu réel « À mon sujet » du CV';
$string['cofigureblock_cvinfo_education_history'] = 'Parcours scolaire';
$string['cofigureblock_cvinfo_employment_history'] = 'Expériences professionnelles';
$string['cofigureblock_cvinfo_goals'] = 'Mes objectifs';
$string['cofigureblock_cvinfo_help'] = 'Vous verrez le statut actuel des éléments sélectionnés dans votre CV. Le bloc de contenu sera mis à jour si vous modifiez n’importe quel élément de votre CV ultérieurement.';
$string['cofigureblock_cvinfo_interests'] = 'Intérêts';
$string['cofigureblock_cvinfo_mbrship'] = 'Adhésions';
$string['cofigureblock_cvinfo_public'] = 'Livres et publications';
$string['cofigureblock_cvinfo_skills'] = 'Mes compétences';
$string['cofigureblock_cvinfo_withfiles'] = 'Avec fichiers annexes';
$string['cofigureblock_header'] = 'Choisir le titre principal';
$string['cofigureblock_item'] = 'Choisir l’élément';
$string['cofigureblock_media'] = 'Choisir un média';
$string['cofigureblock_personalinfo'] = 'Choisir les informations personnelles';
$string['cofigureblock_text'] = 'Choisir le texte';
$string['comment'] = 'Commentaire';
$string['comment_delete_confirmation'] = 'Voulez-vous vraiment supprimer ce commentaire ?';
$string['commentnotfound'] = 'Commentaire non trouvé';
$string['comments'] = 'Commentaires';
$string['commentshouldnotbeempty'] = 'Vous devez entrer un commentaire';
$string['competenceinteraction'] = 'Autorise l’interaction avec le bloc Compétences Exabis, s’il est installé';
$string['competences'] = 'compétences';
$string['competences_old_version'] = 'Une version obsolète du bloc Compétences Exabis (laquelle n’est plus supportée) est installée sur ce serveur';
$string['config_feature_copy_to_course'] = 'Autoriser les étudiants à copier leur ePortfolio vers leurs cours';
$string['configureblock_cvinfo_group_by_category'] = 'Afficher les éléments du CV par catégorie';
$string['contactcomps'] = 'Tout réduire';
$string['copycategory'] = 'Copier vers mon portfolio';
$string['copyitemtocourse'] = 'Copier vers le cours';
$string['couldninsertcomment'] = 'Impossible d’ajouter un commentaire';
$string['couldntcopyfile'] = 'Impossible de copier le fichier vers $a ! Le fichier n’a pas été importé.';
$string['couldntcreatedirectory'] = 'Impossible de créer le dossier';
$string['couldntcreatetempdir'] = 'Impossible de créer un dossier temporaire !';
$string['couldntextractscormfile'] = 'Impossible d’extraire le paquetage SCORM';
$string['couldntinsert'] = 'Impossible d’ajouter $a dans la base de données';
$string['couldntinsertcategory'] = 'Impossible d’insérer la catégorie !';
$string['couldntinsertdesc'] = 'Impossible d’insérer la description !';
$string['couldntupdatecategory'] = 'Impossible de mettre à jour la catégorie !';
$string['couldntupdatedesc'] = 'Impossible de mettre à jour votre description !';
$string['course'] = 'Cours';
$string['create_as_note'] = 'Créer un artefact';
$string['create_view_content_help_text'] = '<ul>
                <li><strong>Organisez votre disposition :</strong> glissez et déposez les blocs de conception et disposez les de façon à raconter votre histoire. Utilisez les colonnes (disponible dans la section « disposition ») pour organiser votre portfolio.</li>
                <li><strong>Ordonnez pour plus de clarté :</strong> Utilisez les en-tête, liens et notes pour structurer votre contenu efficacement.</li>
                <li><strong>Personalisez votre style :</strong> Choisissez des polices et couleurs dans les options disponibles pour ajouter votre touche personnelle.</li>
            </ul>
            <strong>N’oubliez pas : votre ePortfolio informe le monde à propos de vous et de vos compétences. Soyez clair, concis et captivant !</strong>';
$string['create_view_content_help_title'] = 'Écrivez votre histoire unique : construisez votre portfolio';
$string['createepxexport'] = 'Créer un fichier-EPX';
$string['createexport'] = 'Créer le paquetage SCORM';
$string['createexport_directory'] = 'Créer une structure de dossier';
$string['createexportxapi'] = 'Créer un fichier XAPI';
$string['createpage'] = 'Glisser/déposer le contenu des blocs depuis les onglets ci-contre pour créer votre page';
$string['current_category'] = 'Catégorie en cours';
$string['cvgroup'] = 'CV';
$string['cvinformation'] = 'Informations du CV';
$string['cvinformation_help'] = 'Le bloc contenant vos informations du CV exabis ePortfolio, par exemple : parcours scolaire, expériences professionnelles, etc.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Voir votre CV</a>';
$string['date'] = 'Date';
$string['delete'] = 'Supprimer';
$string['delete_all_shareall'] = 'Supprimer les partages ?';
$string['deletecategoryconfirm'] = 'Voulez-vous vraiment supprimer cette catégorie « {$a->name} » ? Toutes les entrées de cette catégorie et les sous-entrées seront supprimées !';
$string['deletefileconfirm'] = 'Voulez-vous vraiment supprimer ce fichier ?';
$string['deletelinkconfirm'] = 'Voulez-vous vraiment supprimer ce lien ?';
$string['deletenoteconfirm'] = 'Voulez-vous vraiment supprimer cette note ?';
$string['deleteposterror'] = 'Une erreur s’est produite pendant la suppression';
$string['descriptionsaved'] = 'Description sauvegardée';
$string['deselectall'] = 'Tout désélectionner';
$string['desp_categories'] = 'Écrits, Jeux de rôles, essais, Compilations
curriculum vitae
Productions de théâtre, expositions
Rapports de projet et réflexions
audio- et vidéos
Rencontres avec des personnes d’autres nationalités
Réflexions sur vos capacités de langue
Rapports
Certifications
Connaissances
Écoute
- Travail individuel
- Travail collaboratif
- Travail de groupe
Lecture
- Travail individuel
- Travail collaboratif
- Travail de groupe
Participer à des conversations
- Travail individuel
- Travail collaboratif
- Travail de groupe
Parler courant
- Travail individuel
- Travail collaboratif
- Travail de groupe
Écrire
- Travail individuel
- Travail collaboratif
- Travail de groupe';
$string['desp_einleitung'] = 'Voici votre portfolio. Vous pouvez montrer partager ce que vous avez accompli par vous-même.';
$string['desp_language'] = 'Langue';
$string['desp_pluginname'] = 'Dossier';
$string['details'] = 'Détails';
$string['developed'] = 'Développé par';
$string['dontincludeurl'] = 'Cochez cette case pour dissocier le signet de l’URL';
$string['download'] = 'Télécharger';
$string['download_pdf'] = 'Télécharger en PDF';
$string['duplicatedurl'] = 'Vous avez déjà marqué cette URL';
$string['edit'] = 'Modifier';
$string['editcategories'] = 'Modifier les catégories';
$string['emailaccess'] = 'Partager par courriel';
$string['emailaccessdescription'] = 'Insérez une adresse de courriel par ligne<br />Chaque destinataire recevra un lien permettant d’accéder à cette vue. Supprimer l’adresse de courriel retirera l’accès à cette vue.';
$string['emailaccessmessage'] = 'Bonjour ! {$a->sendername} a partagé la vue "{$a->viewname}" avec vous. Vous pouvez la consulter ici : {$a->url}';
$string['emailaccessmessageHTML'] = 'Bonjour !<br />{$a->sendername} a partagé la vue "{$a->viewname}" avec vous.<br />Vous pouvez la consulter <a href="{$a->url}">ici</a>.';
$string['emailaccessmessagesubject'] = 'Nouvelle vue partagée pour vous';
$string['endedit'] = 'Stopper l’édition';
$string['enrolled_courses'] = 'En relation avec les cours';
$string['exaport:addinstance'] = 'Ajouter l’ePortfolio Exabis au cours';
$string['exaport:allowposts'] = 'Autoriser l’envoi';
$string['exaport:competences'] = 'Autoriser la gestion des compétences';
$string['exaport:export'] = 'Exporter des fichiers SCORM';
$string['exaport:import'] = 'Importer depuis des fichiers SCORM';
$string['exaport:importfrommoodle'] = 'Importer depuis Moodle';
$string['exaport:myaddinstance'] = 'Ajouter l’ePortfolio Exabis à ma page';
$string['exaport:shareextern'] = 'Partage externe des vues';
$string['exaport:shareintern'] = 'Partage interne des vues';
$string['exaport:use'] = 'Utilisation autorisée';
$string['exaport:viewartifactsfromstudents'] = 'Peut voir les artefacts du portfolio de ses propres étudiants';
$string['expandcomps'] = 'Tout développer';
$string['explaincategories'] = 'Catégories : ici, vous pouvez créer et modifier mes cartégories';
$string['explainexport'] = 'Exporter votre portfolio ici.';
$string['explainimport'] = 'ici vous pouvez importer un paquetage SCORM dans le portfolio. Si des traces d’exportations précédentes sont trouvées l’importation essaiera de conserver les données dans leur structure d’origine.';
$string['explaining'] = 'Le portfolio peut être utilisé pour archiver des adresses web, des fichiers et notes, permettant ainsi aux utilisateurs d\'écrire leurs idées ou commentaires.';
$string['explainingall'] = 'Tous les éléments de votre port-folio';
$string['explainingfile'] = 'Fichiers. Ces fichiers peuvent être partagés avec tous les membres du cours.';
$string['explaininglink'] = 'Liens. Ces liens peuvent être partagés avec tous les membres du cours.';
$string['explainingmoredata'] = '<strong>Votre espace regroupant les traces de votre apprentissage.</strong>
            <ul>
                <li><strong>Ajoutez vos meilleures réalisations :</strong> Téléversez des fichiers, ajoutez des liens hypertextes ou des descriptions de projets, des présentations et plus encore.</li>
                <li><strong>Revenez sur vos expériences passées :</strong> Expliquez ce que vous avez appris, les défis auxquels vous avez fait face, ainsi que vos réussites.</li>
            </ul>
            <strong>Considérez chaque élément ajouté comme une histoire mettant en avant vos compétences et connaissances.</strong>';
$string['explainingnote'] = 'Notes. Ces notes peuvent être partagées avec tous les membres du cours.';
$string['explainingshare'] = 'Pour autoriser un participant à voir ce lien, cliquer sur son nom puis cliquer sur sauvegarder les changements. Il est possible de choisir plusieurs participants.';
$string['explainingshared'] = 'Ces participants ont partagé des liens, des fichiers ou des notes.';
$string['explainingsharefile'] = 'Pour autoriser un participant à voir le fichier, cliquer sur le nom puis cliquer sur sauvegarder les changements. Il est possible de choisir plus d’un participant.';
$string['explainingsharenote'] = 'Pour autoriser un participant à voir la note, cliquer sur le nom puis cliquer sur sauvegarder les changements. Il est possible de choisir plus d’un participant.';
$string['explainingviews'] = 'Gérer vos vues';
$string['explainpersonal'] = 'Informations personnelles';
$string['export'] = 'Exporter vers un fichier';
$string['export_directory'] = 'Exporter une structure de dossier';
$string['export_short'] = 'Exporter';
$string['exportcomment'] = 'Ceci est un fichier exporté depuis un portfolio Exabis. SVP, ne pas supprimer les commentaires. Ils sont nécessaires pour procéder à l’importation !';
$string['exportepx'] = 'Exporter un fichier EPX';
$string['exportviewselect'] = 'Pour exporter tous les éléments d’une vue spécifique,';
$string['externaccess'] = 'Lien vers un ePortfolio externe';
$string['externalaccess'] = 'Accès extérieur';
$string['externcomment'] = 'Partager les commentaires dans un portfolio externe';
$string['fieldstoshow'] = 'Champs à afficher';
$string['file'] = 'Fichier';
$string['filecopiedtocourse'] = 'Fichier copier vers le cours $a->coursename sous le nom de $a->filename';
$string['filenotfound'] = 'Le fichier n’a pas été trouvé.';
$string['filetypenotdetected'] = 'Ce type de fichier $a->filename ($a->title) n’a pas pu être repéré. Le fichier n’a pas été importé !';
$string['filterByTag'] = 'Filtrer par tag';
$string['firstname'] = 'Prénom';
$string['firstnameshared'] = 'Prénom';
$string['forms.item.project_description'] = 'Pourquoi ce projet';
$string['forms.item.project_description_editor'] = 'Pourquoi ce projet';
$string['forms.item.project_description_editor_help'] = '<strong>Expliquez brièvement le but de votre travail :</strong>
            <ul>
                <li>À quelle problématique a-t-il répondu ?</li>
                <li>Quelles compétences souhaitiez vous développer ?</li>
                <li>Quel était le contexte ?</li>
            </ul>';
$string['forms.item.project_description_help'] = '<strong>Expliquez brièvement le but de votre travail :</strong>
            <ul>
                <li>À quelle problématique a-t-il répondu ?</li>
                <li>Quelles compétences souhaitiez vous développer ?</li>
                <li>Quel était le contexte ?</li>
            </ul>';
$string['forms.item.project_process'] = 'Passage à l’acte';
$string['forms.item.project_process_editor'] = 'Passage à l’acte';
$string['forms.item.project_process_editor_help'] = '<strong>Décrivez votre parcours :</strong>
            <ul>
                <li>Quelles étapes avez-vous réalisées pour terminer ce projet ?</li>
                <li>Quels défis avez-vous rencontrés, et comment les avez-vous surmontés ?</li>
                <li>Quelles ressources avez-vous utilisées ?</li>
            </ul>';
$string['forms.item.project_process_help'] = '<strong>Décrivez votre parcours :</strong>
            <ul>
                <li>Quelles étapes avez-vous réalisées pour terminer ce projet ?</li>
                <li>Quels défis avez-vous rencontrés, et comment les avez-vous surmontés ?</li>
                <li>Quelles ressources avez-vous utilisées ?</li>
            </ul>';
$string['forms.item.project_result'] = 'Résultats et enseignements';
$string['forms.item.project_result_editor'] = 'Résultats et enseignements';
$string['forms.item.project_result_editor_help'] = '<strong>Résumez brièvement les résultats de votre projet :</strong>
                <ul>
                    <li>Qu’avez-vous accompli ?</li>
                    <li>Quelles compétences et aptitudes avez-vous développées ou améliorées à travers ce travail ?</li>
                    <li>Qu’avez-vous appris à propos de vous et de vos capacités ?</li>
                    <li>Que feriez vous différemment la prochaine fois ?</li>
                </ul>';
$string['forms.item.project_result_help'] = '<strong>Résumez brièvement les résultats de votre projet :</strong>
                <ul>
                    <li>Qu’avez-vous accompli ?</li>
                    <li>Quelles compétences et aptitudes avez-vous développées ou améliorées à travers ce travail ?</li>
                    <li>Qu’avez-vous appris à propos de vous et de vos capacités ?</li>
                    <li>Que feriez vous différemment la prochaine fois ?</li>
                </ul>';
$string['forms.item.title'] = 'Titre';
$string['go'] = 'Allez !';
$string['gradeitem'] = 'Noter l\'élément';
$string['grouptitle'] = 'Intitulé du groupe';
$string['headertext'] = 'Titre';
$string['headertext_help'] = 'Le bloc pour ajouter une ligne d’en-tête uniquement';
$string['height'] = 'hauteur';
$string['hidesummary'] = '(cacher le sommaire)';
$string['i_shared'] = 'J’ai partagé un portfolio avec vous';
$string['iconfile'] = 'Miniature';
$string['iconfile_merge'] = 'Fusionner cette icône avec celle du dossier';
$string['iconfile_merge_description'] = 'Tentative de fusion (sans garantie) avec l’icône standard du dossier. Cette nouvelle icône remplacera la précédente.';
$string['import'] = 'Importer un paquetage SCORM';
$string['import_short'] = 'Importer';
$string['importedcommentsend'] = 'Fin des commentaires importés';
$string['importedcommentsstart'] = '<br /><br />Commentaires importées:';
$string['importexport'] = 'Importer/Exporter';
$string['in'] = 'à';
$string['incompatible_video'] = 'Pour voir cette video utiliser le lien direct: {$a->link}';
$string['incorrectlinksid'] = 'L’id des liens est incorrect';
$string['incorrectnoteid'] = 'L’Id de la note est incorrect';
$string['internalaccess'] = 'Accès interne';
$string['internalaccessall'] = 'Accès pour <span class=\'block_eportfolio_bold\'>tous</span>';
$string['internalaccessgroups'] = 'Accès réservé aux groupes suivants';
$string['internalaccessusers'] = 'Accès réservé aux utilisateurs suivants';
$string['intro'] = 'Contenu';
$string['intronotempty'] = 'Vous devez saisir du contenu';
$string['invalidassignmentid'] = 'L’id du du devoir est faux';
$string['invalidcourseid'] = 'L’id du cours est non valide';
$string['invalidfileatthisassignment'] = 'Le fichier est introuvable dans ce devoir';
$string['invalidinstance'] = 'Cette instance est non valide';
$string['item'] = 'Elément';
$string['item.project_information'] = 'Informations du projet';
$string['itemgrading'] = 'Notation';
$string['items'] = 'Mes artefacts';
$string['items_help'] = 'Le bloc contenant vos artefacts<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Voir vos artefacts</a>';
$string['lastname'] = 'Nom';
$string['layout_settings'] = 'Paramètres de disposition';
$string['layout_settings_border_width'] = 'Épaisseur de bordure';
$string['layout_settings_border_width_only_bottom'] = 'Seulement la bordure inférieure';
$string['layout_settings_custom_css'] = 'CSS personnalisé';
$string['layout_settings_custom_css_description'] = 'Vous pouvez utiliser vos règles CSS personnalisées ici';
$string['layout_settings_description'] = 'Vous pouvez modifier ici des options de disposition ou utiliser vos propres règles CSS personnalisées pour obtenir la vue que vous souhaitez';
$string['layout_settings_font_size'] = 'Taille de police';
$string['layout_settings_font_weight'] = 'Gras';
$string['layout_settings_view_content'] = 'Contenu des blocs de vue';
$string['layout_settings_view_headers'] = 'En-têtes des blocs de vue';
$string['link'] = 'Lien';
$string['linkedfilenotfound'] = 'Le fichier $a->filename in $a->url ($a->title) n’a pas été trouvé. Le fichier n’a pas été importé!';
$string['list'] = 'Liste';
$string['listofartefacts'] = 'Liste des artefacts';
$string['listofbadges'] = 'Liste des badges';
$string['loginasmode'] = 'Vous ne pouvez pas accéder aux portfolios avec le mode « prendre le rôle de… »';
$string['mailadress'] = 'Adresse de messagerie';
$string['maincategory'] = 'Catégorie principale';
$string['make_it_yours'] = 'Faites-le à votre image';
$string['makeimport'] = 'Importer';
$string['managecategories'] = 'Gérer les catégories';
$string['mandatoryfields'] = 'Le nom du champ, la catégorie et l’introduction sont requis. saisissez-les !';
$string['mandatoryfieldsforcat'] = 'Le nom du fichier est requis. SVP, saisissez-le.';
$string['media'] = 'Média';
$string['media_allowed_notes'] = 'Les URLs des sites suivants sont autorisées:';
$string['media_help'] = 'Le bloc avec des média intégrés, comme par exemple : Youtube, Vimeo, SlideShare, etc.';
$string['mediacontent'] = 'URL ou code d’incorporation';
$string['membercount'] = 'Nombre de membres';
$string['messageprovider:sharing'] = 'Partage de notifications';
$string['mixed'] = 'Artefact';
$string['moodleimport'] = 'Importer depuis les devoirs de Moodle';
$string['moreinfolink'] = 'Afficher plus d’informations…';
$string['movebottom'] = 'Déplacer vers le bas';
$string['movetop'] = 'Déplacer vers le haut';
$string['myfilearea'] = 'Ma zone de fichiers';
$string['myportfolio'] = 'Les artefacts de mon portfolio';
$string['myportfoliotitle'] = 'Module Exabis ePortfolio : ajoutez vos liens et fichiers ici.';
$string['name'] = 'Nom';
$string['new'] = 'Nouveau';
$string['newfile'] = 'Ajouter un nouveau fichier';
$string['newlink'] = 'Ajouter un nouveau lien';
$string['newnote'] = 'Ajouter une nouvelle note';
$string['newview'] = 'Ajouter une vue';
$string['nobookmarksall'] = 'Pas encore d’éléments';
$string['nobookmarksfile'] = 'Pas encore de fichiers';
$string['nobookmarkslink'] = 'Pas encore de liens';
$string['nobookmarksnote'] = 'Pas encore de notes';
$string['nocategories'] = 'Pas encore de catégories';
$string['nocoursetogether'] = 'Pas de cours';
$string['noemails'] = 'Il n’y a pas d’adresse de courriel valide';
$string['noentry'] = 'Aucun enregistrement';
$string['nogroupsfound'] = 'Aucun groupe n’a été trouvé';
$string['noguestpost'] = 'Les utilisateurs invités n’ont pas accès ici';
$string['nomail'] = 'Pas d’adresse de courriel';
$string['nomoodleimportyet'] = 'Vous n’avez encore aucune soumission dans un devoir';
$string['nopicture'] = 'Pas d’image';
$string['noprofilepicture'] = 'Il n’y a pas d’image valable pour le profil';
$string['note'] = 'Note';
$string['notetitle'] = 'Note';
$string['nothingshared'] = 'Aucun Portfolio n’est partagé avec vous';
$string['nothingstructureshared'] = 'Personne de partage une structure avec vous';
$string['notify'] = 'Notifier';
$string['nouserforaccess'] = 'Utilisateur non trouvé (l’identifiant est inconnu)';
$string['nouserforid'] = 'Utilisateur non trouvé (id inconnu)';
$string['nousersfound'] = 'Aucun utilisateur trouvé';
$string['noviews'] = 'SVP créer une nouvelle vue';
$string['opencomps'] = 'Choisissez vos compétences';
$string['other_groups_course'] = 'Autres cours';
$string['other_users_course'] = 'Utilisateurs qui ne sont pas inscrits dans mes cours';
$string['othercourses'] = 'Autres cours';
$string['pdf_customfont'] = 'Téléverser une police personnalisée';
$string['pdf_customfont_help'] = 'Vous pouvez téléverser vos propres fichiers .ttf. Nous essaierons de l’utiliser pour la génération de PDF.';
$string['pdf_settings'] = 'Paramètres PDF';
$string['pdf_settings_description'] = 'Si vous utilisez des caractères spéciaux ou non habituels, le PDF généré peut comporter des erreurs. Vous pouvez essayer d’utiliser différents paramètres de police<br>
            Vos paramètres PDF seront sauvegardés pour cette vue.<br>Par conséquent, si votre vue est partagée avec d’autres utilisateurs, ils verront le PDF avec vos paramètres.<br>
            Les polices non standardisées peuvent perdre des options telles que le gras, l’italique, etc.';
$string['pdf_settings_fontfamily'] = 'Police d\'écriture';
$string['pdf_settings_fontfamily_customgroup'] = 'Polices personnalisées téléversées';
$string['pdf_settings_fontfamily_fixedgroup'] = 'Polices prédéfinies';
$string['pdf_settings_fontsize'] = 'Taille de police de base';
$string['pdf_settings_pageorient'] = 'Orientation de page';
$string['pdf_settings_pageorient.landscape'] = 'Paysage';
$string['pdf_settings_pageorient.portrait'] = 'Portrait';
$string['pdf_settings_pagesize'] = 'Taille de page';
$string['pdf_settings_showmetadata'] = 'Ajouter des métadonnées à la vue';
$string['pdf_settings_showuseremail'] = 'adresse de courriel utilisateur';
$string['pdf_settings_showusername'] = 'nom utilisateur';
$string['pdf_settings_showuserphone'] = 'téléphone utilisateur';
$string['pdf_settings_showuserpicture'] = 'image utilisateur';
$string['pdf_settings_uploadfont'] = 'Téléverser une police personnalisée';
$string['personal'] = 'Information';
$string['personalinformation'] = 'Information personnelle';
$string['personalinformation_help'] = 'Le bloc contenant vos données personnelles, par exemple : nom, adresse de courriel.<br><a href=\'{$a}\' target=\'_blank\' class=\'external-link\'>Voir votre profil</a>';
$string['pluginname'] = 'Exabis ePortfolio';
$string['privacy:metadata:block_exaportcate'] = 'catégories d’utilisateur';
$string['privacy:metadata:block_exaportcate:courseid'] = 'id de cours';
$string['privacy:metadata:block_exaportcate:description'] = 'description';
$string['privacy:metadata:block_exaportcate:internshare'] = 'partage interne ?';
$string['privacy:metadata:block_exaportcate:name'] = 'titre';
$string['privacy:metadata:block_exaportcate:name_short'] = 'titre court';
$string['privacy:metadata:block_exaportcate:parent_ids'] = 'liste des ids parents';
$string['privacy:metadata:block_exaportcate:parent_titles'] = 'liste des titres parents';
$string['privacy:metadata:block_exaportcate:pid'] = 'id catégorie parent';
$string['privacy:metadata:block_exaportcate:shareall'] = 'partagé pour tout le monde ? 0 - non partagé; 1 - partagé pour tout le monde; 2 - partagé pour les groupes';
$string['privacy:metadata:block_exaportcate:source'] = 'source';
$string['privacy:metadata:block_exaportcate:sourceid'] = 'id source';
$string['privacy:metadata:block_exaportcate:sourcemod'] = 'source activité';
$string['privacy:metadata:block_exaportcate:stid'] = 'id type école';
$string['privacy:metadata:block_exaportcate:structure_share'] = 'partagé en tant que structure ? Voir aussi \'structure_shareall\'';
$string['privacy:metadata:block_exaportcate:structure_shareall'] = 'partagé en tant que structure ? 0 - non partagé; 1 - partagé pour tout le monde; 2 - partagé pour les groupes';
$string['privacy:metadata:block_exaportcate:subjid'] = 'id matière en relation';
$string['privacy:metadata:block_exaportcate:timemodified'] = 'dernière modification';
$string['privacy:metadata:block_exaportcate:topicid'] = 'id sujet en relation';
$string['privacy:metadata:block_exaportcate:userid'] = 'id utilisateur';
$string['privacy:metadata:block_exaportitem'] = 'artefacts utilisateur';
$string['privacy:metadata:block_exaportitem:categoryid'] = 'id catégorie';
$string['privacy:metadata:block_exaportitem:courseid'] = 'id cours';
$string['privacy:metadata:block_exaportitem:exampid'] = 'id exemple en relation';
$string['privacy:metadata:block_exaportitem:example_url'] = 'propriétaire artefact';
$string['privacy:metadata:block_exaportitem:externaccess'] = 'accès externe ?';
$string['privacy:metadata:block_exaportitem:externcomment'] = 'commentaire pour les externes';
$string['privacy:metadata:block_exaportitem:fileurl'] = 'url du fichier';
$string['privacy:metadata:block_exaportitem:intro'] = 'introduction';
$string['privacy:metadata:block_exaportitem:iseditable'] = 'est éditable ?';
$string['privacy:metadata:block_exaportitem:langid'] = 'id langue';
$string['privacy:metadata:block_exaportitem:name'] = 'nom';
$string['privacy:metadata:block_exaportitem:parentid'] = 'id parent';
$string['privacy:metadata:block_exaportitem:shareall'] = 'partagé pour tout le monde ?';
$string['privacy:metadata:block_exaportitem:source'] = 'source';
$string['privacy:metadata:block_exaportitem:sourceid'] = 'id source';
$string['privacy:metadata:block_exaportitem:timemodified'] = 'dernière modification';
$string['privacy:metadata:block_exaportitem:type'] = 'type d’artefact';
$string['privacy:metadata:block_exaportitem:url'] = 'url';
$string['privacy:metadata:block_exaportitem:userid'] = 'propriétaire artefact';
$string['privacy:metadata:block_exaportitemcomm'] = 'commentaire pour les artefacts';
$string['privacy:metadata:block_exaportitemcomm:entry'] = 'commentaire';
$string['privacy:metadata:block_exaportitemcomm:itemid'] = 'id artefact';
$string['privacy:metadata:block_exaportitemcomm:timemodified'] = 'dernière modification';
$string['privacy:metadata:block_exaportitemcomm:userid'] = 'auteur du commentaire';
$string['privacy:metadata:block_exaportresume'] = 'données du cv';
$string['privacy:metadata:block_exaportresume:courseid'] = 'id cours';
$string['privacy:metadata:block_exaportresume:cover'] = 'contenu de couverture';
$string['privacy:metadata:block_exaportresume:goalsacademic'] = 'objectifs académiques';
$string['privacy:metadata:block_exaportresume:goalscareers'] = 'objectifs professionnels';
$string['privacy:metadata:block_exaportresume:goalspersonal'] = 'objectifs personnels';
$string['privacy:metadata:block_exaportresume:interests'] = 'centres d’intérêts';
$string['privacy:metadata:block_exaportresume:skillsacademic'] = 'compétences académiques';
$string['privacy:metadata:block_exaportresume:skillscareers'] = 'compétences professionnelles';
$string['privacy:metadata:block_exaportresume:skillspersonal'] = 'compétences personnelles';
$string['privacy:metadata:block_exaportresume:user_id'] = 'propriétaire du cv';
$string['privacy:metadata:block_exaportuser'] = 'données utilisateur pour exabis e-portfolio';
$string['privacy:metadata:block_exaportuser:description'] = 'description';
$string['privacy:metadata:block_exaportuser:user_id'] = 'id utilisateur';
$string['privacy:metadata:block_exaportuser:view_items_layout'] = 'id utilisateur';
$string['privacy:metadata:block_exaportview'] = 'commentaires pour les artefacts';
$string['privacy:metadata:block_exaportview:autofill_artefacts'] = 'remplissages automatiques par les artefacts';
$string['privacy:metadata:block_exaportview:description'] = 'description';
$string['privacy:metadata:block_exaportview:externaccess'] = 'accès externe ?';
$string['privacy:metadata:block_exaportview:externcomment'] = 'commentaire pour les externes ?';
$string['privacy:metadata:block_exaportview:langid'] = 'id langue';
$string['privacy:metadata:block_exaportview:layout'] = 'disposition de la vue';
$string['privacy:metadata:block_exaportview:name'] = 'nom';
$string['privacy:metadata:block_exaportview:shareall'] = 'partagé pour tout le monde ?';
$string['privacy:metadata:block_exaportview:sharedemails'] = 'liste partagée des adresses de courriel';
$string['privacy:metadata:block_exaportview:timemodified'] = 'dernière modification';
$string['privacy:metadata:block_exaportview:userid'] = 'propriétaire de la vue';
$string['privacy:metadata:core_files'] = 'Exabis ePortfolio archive des fichiers qui ont été téléversés par l’utilisateur afin de créer des parties d’artefacts, des parties de CV et commentaires.';
$string['profilepicture'] = 'Photo du profil';
$string['project_description'] = 'Pourquoi ce projet';
$string['project_process'] = 'Passage à l’acte';
$string['project_result'] = 'Résultats et enseignements';
$string['publishedportfolios'] = 'Portfolios publiés';
$string['resume_badges'] = 'Badges';
$string['resume_certif'] = 'Certifications, accréditations et distinctions';
$string['resume_certifdeleted'] = 'Certification, accréditation ou distinction supprimée';
$string['resume_certifsaved'] = 'Certification, accréditation ou distinction enregistrée';
$string['resume_collaps'] = 'Tout réduire';
$string['resume_contribution'] = 'Contribution';
$string['resume_contributiondetails'] = 'Détails de votre contribution';
$string['resume_cover'] = 'À mon sujet';
$string['resume_coversaved'] = 'Présentation sauvegardée';
$string['resume_date'] = 'Date';
$string['resume_deletecertifconfirm'] = 'Voulez-vous vraiment supprimer cette certification, cette accréditation ou cette distinction ?';
$string['resume_deleteeduconfirm'] = 'Voulez-vous vraiment supprimer cette formation ?';
$string['resume_deleteemployconfirm'] = 'Voulez-vous vraiment supprimer cet emploi ?';
$string['resume_deletelinkedinconfirm'] = 'Voulez-vous vraiment supprimer cette adhésion ?';
$string['resume_deletembrshipconfirm'] = 'Voulez-vous vraiment supprimer cette adhésion ?';
$string['resume_deletepublicconfirm'] = 'Voulez-vous vraiment supprimer ce livre ou cette publication ?';
$string['resume_description'] = 'description';
$string['resume_edu'] = 'Formation';
$string['resume_edudeleted'] = 'Formation supprimée';
$string['resume_eduhistory'] = 'Formation';
$string['resume_edusaved'] = 'Formation enregistrée';
$string['resume_employ'] = 'Emploi';
$string['resume_employdeleted'] = 'Emploi supprimé';
$string['resume_employer'] = 'Employeur';
$string['resume_employeraddress'] = 'Adresse de l’employeur';
$string['resume_employhistory'] = 'Expérience professionnelle';
$string['resume_employsaved'] = 'Emploi enregistré';
$string['resume_enddate'] = 'Date de fin';
$string['resume_expand'] = 'Tout réduire';
$string['resume_exportto_europass'] = 'Exporter vers Europass';
$string['resume_exportto_europass_getXML'] = 'Télécharger XML';
$string['resume_exportto_europass_intro'] = '<p>Le profil Europass peut aider les personnes à organiser le développement de leur parcours scolaire et professionnel. Le profil peut être utilisé par les entreprises (employeurs), organisations bénévoles, recruteurs, conseillers d’orientation, organisations de jeunesse, établissements d’enseignement et de formation, et plus, dans le cadre du soutien et des services qu’ils offrent aux personnes.</p>
        <p>Nous proposons un moyen d\'utiliser votre CV d’Exabis ePortfolio dans le profil Europass.<br>
            Le fichier XML généré devra être inséré dans la page <a href="https://europa.eu/europass/eportfolio/screen/cv-editor?lang=fr" target="_blank">Créer votre CV</a><br>
            (il est préférable d’être authentifié sur Europass au préalable)<br>
            Cliquez sur le bouton « Commencer à partir du CV Europass » et téléversez le fichier XML qui sera généré via le bouton ci-dessous
        </p>
  Quelques observations :<br>
  <ul>
    <li>vérifiez bien le résultat obtenu pour ce CV</li>
    <li>les données personnelles seront issues de votre compte Moodle</li>
    <li>vérifiez toutes les dates, téléphones, adresses</li>
    <li>les images provenant des éditeurs HTML ne seront pas exportées</li>
    <li>il faut souvent reformuler des textes à partir des éditeurs-HTML</li>
    <li>l’attachement de fichiers n’est pas implémenté dans la nouvelle version d’Europass, ils ne seront donc pas importés.</li>
  </ul>';
$string['resume_files'] = 'Attachements';
$string['resume_goals'] = 'Objectifs';
$string['resume_goalsacademic'] = 'Objectifs académiques';
$string['resume_goalsacademicsaved'] = 'Objectifs académiques sauvegardés';
$string['resume_goalscareers'] = 'Objectifs professionnels';
$string['resume_goalscareerssaved'] = 'Objectifs professionnels sauvegardés';
$string['resume_goalscomp'] = 'Standards de formation';
$string['resume_goalspersonal'] = 'Objectifs personnels';
$string['resume_goalspersonalsaved'] = 'Objectifs personnels sauvegardés';
$string['resume_institution'] = 'Établissement';
$string['resume_institutionaddress'] = 'Adresse de l’établissement';
$string['resume_interests'] = 'Centres d’intérêts';
$string['resume_interestssaved'] = 'Centre d’intérêts sauvegardés';
$string['resume_jobtitle'] = 'Intitulé de l’emploi';
$string['resume_linkedin'] = 'Profil LinkedIn';
$string['resume_linkedindeleted'] = 'Profil LinkedIn supprimé';
$string['resume_linkedinsaved'] = 'Profil LinkedIn sauvegardé';
$string['resume_mbrship'] = 'Adhésions';
$string['resume_mbrshipdeleted'] = 'Adhésions supprimées';
$string['resume_mbrshipsaved'] = 'Adhésions sauvegardées';
$string['resume_my'] = 'Mon CV';
$string['resume_mygoals'] = 'Mes objectifs';
$string['resume_myskills'] = 'Mes compétences';
$string['resume_position'] = 'Poste';
$string['resume_positiondescription'] = 'Description du poste';
$string['resume_public'] = 'Livres et publications';
$string['resume_publicdeleted'] = 'Livre ou publication supprimé(e)';
$string['resume_publicsaved'] = 'Livres et publications sauvegardés';
$string['resume_qualdescription'] = 'Description de la qualification';
$string['resume_qualification'] = 'Diplôme';
$string['resume_qualname'] = 'Nom du diplôme';
$string['resume_qualtype'] = 'Type de diplôme';
$string['resume_skills'] = 'Compétences';
$string['resume_skillsacademic'] = 'Compétences académiques';
$string['resume_skillsacademicsaved'] = 'Compétences académiques sauvegardées';
$string['resume_skillscareers'] = 'Compétences professionnelles';
$string['resume_skillscareerssaved'] = 'Compétences professionnelles sauvegardées';
$string['resume_skillscomp'] = 'Standards de formation';
$string['resume_skillspersonal'] = 'Compétences personnelles';
$string['resume_skillspersonalsaved'] = 'Compétences personnelles sauvegardées';
$string['resume_startdate'] = 'Date de début';
$string['resume_template_newresume'] = 'Mon nouveau CV';
$string['resume_title'] = 'Titre';
$string['resume_url'] = 'URL';
$string['role'] = 'Rôle';
$string['root_category'] = 'Catégorie Racine';
$string['saveButton'] = 'Sauvegarder';
$string['saveitem'] = 'Sauvegarder';
$string['scormhastobezip'] = 'Le fichier SCORM doit être un fichier ZIP';
$string['searchByTitle'] = 'Rechercher';
$string['selectall'] = 'Tout sélectionner';
$string['selectcomps'] = 'Choisissez des compétences associées à votre téléversement !';
$string['selected_competencies'] = 'Compétence acquise';
$string['selectitems'] = 'Sélectionner les éléments';
$string['settings_allow_loginas_head'] = 'Autoriser la « connexion sous »';
$string['settings_create_desp_categories_head'] = 'Créer des catégories';
$string['settings_disable_externaccess_head'] = 'Désactiver l’option de partage « Accès externe » pour les vues';
$string['settings_disable_external_comments_head'] = 'Désactiver le partage des commentaires dans les vues externes';
$string['settings_disable_shareall_body'] = 'Cliquez <a href="{$a}">ici</a> pour supprimer tous les partages globaux';
$string['settings_disable_shareall_head'] = 'Désactiver le partage avec tous les utilisateurs';
$string['settings_disable_shareemails_head'] = 'Désactiver l’option de partage « Partager par courriel » pour les vues';
$string['settings_interaktion_exacomp_body'] = 'Interaction avec le bloc Exabis Competence Grid, s’il est installé';
$string['settings_interaktion_exacomp_head'] = 'Interaction exabis ePortfolio - Exabis Competence Grid';
$string['settings_layout_settings_description'] = 'Vous pouvez modifier ici des options de disposition ou utiliser vos propres règles CSS personnalisées pour obtenir la vue que vous souhaitez<br>Ces paramètres seront utilisés par défaut <strong>pour toutes les vues</strong>';
$string['settings_layout_settings_heading'] = 'Paramètres de disposition';
$string['share'] = 'Partager';
$string['share_to_other_users'] = 'Rechercher des utilisateurs';
$string['shareallexceptthose'] = 'Accès pour <span class=\'block_eportfolio_bold\'>tous</span> (même ceux qui ne sont pas listés ici) excepté les utilisateurs suivants';
$string['sharedArtefacts'] = 'Grouper les portfolios partagés avec vous';
$string['shared_categories'] = 'Catégories partagées';
$string['shared_views'] = 'Vues partagées';
$string['shareditems_category'] = 'Grouper les portfolios partagés avec vous';
$string['sharedpersons'] = 'Personnes avec des portfolios partagés';
$string['sharedwith'] = 'Partagé avec';
$string['sharedwith_group'] = 'Partagé avec mon groupe';
$string['sharedwith_group_cnt'] = 'Partagé avec les groupes {$a}';
$string['sharedwith_onlyme'] = 'Partagé uniquement avec moi';
$string['sharedwith_shareall'] = 'Partagé avec tous les utilisateurs';
$string['sharedwith_shareexternal'] = 'Partagé en externe';
$string['sharedwith_user_cnt'] = 'Partagé avec les utilisateurs {$a}';
$string['sharejs'] = 'partager';
$string['sharenoneexceptthose'] = 'Accès pour <span class=\'block_eportfolio_bold\'>personne</span> excepté les utilisateurs suivants';
$string['sharetoteacher'] = 'Partager avec tous les enseignants du cours';
$string['shortdescription'] = 'Description courte';
$string['show'] = 'Afficher';
$string['show_mystudents'] = 'Mes étudiants';
$string['show_sharedbyuser'] = 'Partagé par les utilisateurs';
$string['showall'] = 'Afficher les autres cours également';
$string['showallusers'] = 'Afficher les utilisateurs de tous mes cours';
$string['showcourse'] = 'Afficher ce cours uniquement';
$string['showcourseusers'] = 'Afficher uniquement les utilisateurs du cours';
$string['showsummary'] = '(afficher le résumé)';
$string['steckbrief'] = 'Fiche signalétique';
$string['strshare'] = 'Partager';
$string['strunshare'] = 'Retirer le partage';
$string['studentcomps'] = 'Vous pouvez ici autoévaluer si vous avez acquis la compétence avec votre artefact';
$string['subcategory'] = 'Sous-catégorie';
$string['submititem'] = 'Envoyer';
$string['success'] = 'Fichier importé !';
$string['summary'] = 'Résumé (optionnel)';
$string['supported'] = 'Développé par';
$string['tagarea_block_exaportitem'] = 'Mes artefacts du portfolio';
$string['teachercomps'] = 'Vous pouvez ici évaluer si vos étudiants ont acquis la compétence avec cet artefact.';
$string['thiscourse'] = 'Ce cours';
$string['tiles'] = 'Tuiles';
$string['title'] = 'Titre';
$string['titlenotemtpy'] = 'Vous devez saisir un titre';
$string['translation:email'] = 'ariepl.work@gmail.com';
$string['translation:language'] = 'Anglais';
$string['translation:organisation'] = 'GTN GmbH';
$string['translation:person'] = 'Andreas Riepl';
$string['type'] = 'Type';
$string['unknownaction'] = 'Action inconnue';
$string['updateposterror'] = 'Une erreur s’est produite lors de la mise à jour';
$string['updownarrow'] = 'Flèche haut-bas';
$string['uploadfailed'] = 'Le téléchargement a échoué';
$string['url'] = 'URL';
$string['urlnotempty'] = 'Il faut saisir une URL';
$string['userdefinedsort'] = 'Définir votre recherche';
$string['view'] = 'Vue';
$string['view_preview_help'] = 'Prévisualisation de votre vue';
$string['view_preview_help_title'] = 'Prévisualiser';
$string['view_saved'] = 'Vue sauvegardée';
$string['view_sharing'] = 'Partage';
$string['view_sharing_noaccess'] = 'Aucun accès';
$string['view_sharing_updated'] = 'Partage de la vue mis à jour';
$string['view_specialitem_badge'] = 'Badge';
$string['view_specialitem_headline'] = 'Titre principal';
$string['view_specialitem_headline_defaulttext'] = 'Saisissez le titre principal ici';
$string['view_specialitem_media'] = 'Média';
$string['view_specialitem_personal'] = 'Informations personnelles';
$string['view_specialitem_text'] = 'Texte';
$string['view_specialitem_text_defaulttext'] = 'Saisissez le texte ici';
$string['view_specialitem_text_help'] = 'Le bloc contenant le texte personnalisé. Vous pouvez formater le texte selon vos besoins.';
$string['view_specialitems'] = 'Éléments spéciaux';
$string['viewand'] = 'et';
$string['viewcategories'] = 'Gérer les catégories';
$string['viewcontent'] = 'Contenu';
$string['viewdescription'] = 'description';
$string['viewdesign'] = 'Apparence de la vue';
$string['viewinformation'] = 'Information sur la vue';
$string['viewitem'] = 'Élément';
$string['viewitems'] = 'Vos éléments';
$string['viewlayout'] = 'Affichage';
$string['viewlayout1'] = 'Largeurs égales';
$string['viewlayout10'] = 'Largeurs égales';
$string['viewlayout2'] = 'Largeurs égales';
$string['viewlayout3'] = 'Colonne gauche plus grande';
$string['viewlayout4'] = 'Colonne droite plus grande';
$string['viewlayout5'] = 'Largeurs égales';
$string['viewlayout6'] = 'Colonne centrale plus grande';
$string['viewlayout7'] = 'Colonne centrale beaucoup plus grande';
$string['viewlayout8'] = 'Largeurs égales';
$string['viewlayout9'] = 'Colonnes centrales plus grandes';
$string['viewlayoutgroup1'] = 'Une colonne';
$string['viewlayoutgroup2'] = '2 colonnes';
$string['viewlayoutgroup3'] = '3 colonnes';
$string['viewlayoutgroup4'] = '4 colonnes';
$string['viewlayoutgroup5'] = '5 colonnes';
$string['viewnotfound'] = 'Vue non trouvée';
$string['views'] = 'Mes vues';
$string['viewshare'] = 'Partager';
$string['viewtitle'] = 'Titre et description';
$string['what_is_embed_code_content'] = '<p>Le code d’intégration est un code généré par un site Web tiers tel que YouTube ou Twitter, qu’un utilisateur peut copier et coller dans sa propre page Web. Ce code intégré affichera ensuite le même média, la même application ou le même flux sur la page Web de l\'utilisateur que dans la source d’origine.</p>
<p>Nous fournissons des instructions pour les fournisseurs de vidéos les plus populaires tels que YouTube ou Vimeo.</p>
<p><strong>Trouver le code d’intégration sur YouTube :</strong></p>
<ol>
  <li>Accédez à YouTube</a>.</li>
  <li>Accédez à la vidéo que vous souhaitez intégrer.</li>
  <li>Cliquez sur le lien <strong>Partager</strong> sous la vidéo, puis cliquez sur le lien <strong> Intégrer</strong>.</li>
  <li>Appuyez sur le bouton <strong>Copier</strong> dans le pied de page de la fenêtre ouverte.</li>
  <li>Le lien d’intégration sera surligné en bleu et copié dans le presse-papiers.</li>
  <li>Collez le code dans le champ de zone de texte d’exabis ePortfolio.</li>
</ol>
<p><strong>Trouver le code d’intégration sur Vimeo :</strong></p>
<ol>
  <li>Accédez à Vimeo.</li>
  <li>Accédez à la vidéo que vous souhaitez intégrer.</li>
  <li>Cliquez sur le bouton <strong>Partager</strong>, dans le coin supérieur droit de votre vidéo.</li>
  <li>Une fenêtre contextuelle apparaît avec les informations du lien d’intégration. Vous n’aurez besoin de copier que la partie <strong>&lt;<i>iframe</i>&gt;</strong> du lien d’intégration.
Exemple :<br>
<ol>
 <li>
    Le lien d’intégration complet affiche ce qui suit :<br>
    <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;&lt;p&gt;&lt;a href=&quote;https://vimeo.com/1233456789&quote;&gt;1- Automatisation Ouverture[2]&lt;/a&gt; de &lt;a href=&quote;https://vimeo.com/user98765432&quote;&gt;R1 Marketing&lt;/a&gt; sur &lt;a href=&quote;https://vimeo.com&quote;&gt;Vimeo&lt;/a&gt;.&lt;/p&gt;</textarea>
  </li>
  <li>
  Il vous suffit de copier la partie <strong>&lt;<i>iframe</i>&gt;</strong> :<br>
  <textarea disabled=\'true\' style=\'border: none;background-color:white;width:100%;font-size:0.75em;\'>&lt;iframe src=&quote;https://player.vimeo.com/video/1233456789&quote; width=&quote;640&quote; height=&quote;360&quote; frameborder=&quote;0&quote; allow=&quote;autoplay; fullscreen&quote; allowfullscreen&gt;&lt;/iframe&gt;</textarea>
  </li>
</ol>
  <li>Collez ce code dans le champ de zone de texte d’exabis ePortfolio.</li>
</ol>';
$string['what_is_embed_code_title'] = 'Qu’est-ce que le code intégré ?';
$string['whyEportfolio'] = 'Pourquoi ePortfolio';
$string['whyEportfolio_description'] = '<h4>Ne laissez pas votre travail acharné disparaître : créez votre portfolio numérique</h4>
<br>
<p>Imaginez tous les efforts que vous consacrez à vos devoirs, présentations et projets. Avez-vous parfois l’impression que vos documents sont enterrés dans un tiroir après leur soumission ?</p>
<p>Mais voici la bonne nouvelle : ces projets sont la <strong>preuve de vos compétences et de vos connaissances</strong>, et vous pouvez les utiliser pour impressionner des employeurs ou des clients potentiels !</p>
<p><strong>Créez votre portfolio numérique</strong> et présentez vos meilleurs travaux, des présentations, devoirs et projets aux vidéos. C’est plus facile que vous ne le pensez !</p>
<br>
<h4>Qu’est-ce qu’un ePortfolio ?</h4>
<br>
<p>Un <strong>ePortfolio</strong> (portfolio électronique) est une <strong>collection numérique</strong> qui présente vos <strong>compétences, connaissances et expériences</strong>.
Si votre CV met l’accent sur votre formation et votre parcours professionnel, votre ePortfolio va au-delà de cela, en fournissant des <strong>preuves et un contexte</strong> pour vos compétences.
Il vous permet de présenter vos exemples de travail et de <strong>démontrer votre talent</strong> rapidement et efficacement.
En fin de compte, votre ePortfolio est un outil puissant pour <strong>mettre en valeur vos qualifications</strong> et vous démarquer.
</p>
<p><strong>N’oubliez pas que différents rôles peuvent nécessiter différents types d’ePortfolio.</strong>
Cependant, certains éléments clés restent constants.
<strong>Exabis ePortfolio</strong> vous permet de <strong>créer plusieurs vues</strong> adaptées à des postes, des opportunités d’emploi ou d’autres objectifs spécifiques.
</p>
<br>
<h4>Comment créer votre ePortfolio</h4>
<br>
<ol>
<li><strong>Rassemblez votre travail</strong> : commencez par examiner tous vos projets, présentations et devoirs.</li>
<li><strong>Choisissez votre meilleur travail</strong> : sélectionnez les éléments qui mettent en valeur vos compétences les plus fortes et ceux qui ont reçu des commentaires positifs.</li>
<li><strong>Réfléchissez et décrivez</strong> : pensez aux compétences et aux aptitudes que chaque élément démontre. Rédigez une brève description pour fournir un contexte.</li>
<li><strong>Construisez et répétez</strong> : n’ayez pas peur d’expérimenter et d’affiner votre ePortfolio au fur et à mesure que vous apprenez et grandissez.</li>
</ol>
<p><strong>Exabis ePortfolio</strong> peut vous guider à chaque étape, rendant le processus de création de votre ePortfolio fluide et efficace.</p>';
$string['width'] = 'Largeur';
$string['wrongfileid'] = 'Mauvais id de fichier';
$string['wrongfilepostid'] = 'Mauvais id de fichier';
$string['wronglinkid'] = 'Mauvais id de lien';
$string['wrongnoteid'] = 'Mauvais id de note';
$string['wrongnotepostid'] = 'Mauvais postbid de note';
