<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'pulse', language 'ja', version '4.4'.
 *
 * @package     pulse
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'アクション';
$string['apply_customize'] = '適用してカスタマイズする';
$string['apply_save'] = '適用して保存する';
$string['approve'] = '承認';
$string['approved'] = '承認済み';
$string['approvedby'] = 'approvedby';
$string['approvedeclined'] = '承認拒否';
$string['approvedon'] = '承認 {$a->date} by {$a->user}';
$string['approvedsuccess'] = '正常に承認されました。';
$string['approveduser'] = '承認者: {$a->user}';
$string['approveuser'] = 'ユーザを承認する - {$a->course}';
$string['approveuserbtn'] = 'ユーザを承認する';
$string['box'] = 'ボックス';
$string['boxicon'] = 'ボックスアイコン';
$string['boxtype'] = 'ボックスタイプ';
$string['completereaction'] = '完了リアクション';
$string['completewhenavaialble'] = '利用可能時点で完了';
$string['completewhenavaialble_help'] = 'この設定を有効にした場合、活動はユーザがその活動にアクセスできるようになった時点 (つまり、利用制限に基づいて利用可能になった時点) でに完了したとみなされます。';
$string['completion:approval'] = '承認必須';
$string['completion:available'] = '制限を満たす必要がある';
$string['completion:self'] = '完了マークする';
$string['completionapproverules'] = 'Completionapproverules';
$string['completioncriteria'] = '完了クライテリア';
$string['completionfor'] = 'completionfor';
$string['completionrequireapproval'] = '次のいずれかのロールによる承認を必要とする';
$string['completionrequireapproval_help'] = 'この設定を有効にした場合、選択したロールのいずれかがユーザを承認した時点で活動は完了したとみなされます。';
$string['completionself'] = 'この活動を完了するために学生が完了マークする';
$string['completionself_help'] = 'この設定を有効に場合、学生がコースページで完了マークした時点でこの活動は完了したものとみなされます。';
$string['configintro'] = 'パルスグローバル設定';
$string['configparams'] = '設定パラメータ';
$string['configrableparams'] = '設定可能パラメータ';
$string['confirmdeletetemplate'] = '本当にプリセットを削除してもよろしいですか?';
$string['content'] = 'コンテンツ';
$string['content_help'] = 'コンテンツはコースページに表示されます。また、インビテーションのメッセージ本文としての使用されます。';
$string['courserole'] = 'courserole';
$string['createpreset'] = 'プリセットを作成する';
$string['creditesgroup'] = '単位スコア';
$string['credits'] = '単位';
$string['creditsfield'] = '単位ユーザプロファイルフィールド';
$string['creditsfielddesc'] = 'ユーザのプロファイルフィールドのいずれかを選択してユーザの単位レコードを管理します。
<br>
注意: 選択したフィールドをロックして学生が単位スコアを変更しないようにしてください。';
$string['cssclass'] = 'CSSクラス';
$string['danger'] = '危険';
$string['dark'] = 'ダーク';
$string['decline'] = '拒否';
$string['declined'] = '拒否済み';
$string['deletepreset'] = 'パルスプロプリセットテンプレートを削除する';
$string['description'] = '説明';
$string['detailedlog'] = 'スケジュールタスクの詳細ログを表示する - トラブルシューティングの目的のみに使用してください。実運用サイトでは無効にしてください。';
$string['diffnotification'] = '一般的なコンテンツの代わりに通知コンテンツを使用する';
$string['diffnotification_help'] = 'この設定を有効にした場合、インビテーションは (一般的なコンテンツおよびタイトルの代わりに) 通知コンテンツおよび通知件名を使用します。';
$string['disabled'] = '無効';
$string['dislike'] = '好きではない';
$string['displaymode'] = '表示モード';
$string['displaytype:contentonly'] = 'コンテンツのみ';
$string['displaytype:notificationcontent'] = '両方';
$string['displaytype:notificationonly'] = '通知のみ';
$string['enable:disable'] = '有効/無効';
$string['enabled'] = '有効';
$string['enablereminder:first'] = '最初のリマインダを有効にする';
$string['enablereminder:first_help'] = 'この設定を有効にした場合、パルスは最初のリマインダを送信します。';
$string['enablereminder:invitation'] = 'インビテーションを有効にする';
$string['enablereminder:recurring'] = '定期リマインダを有効にする';
$string['enablereminder:recurring_help'] = 'この設定を有効にした場合、パルスは選択した受信対象者に定期リマインダを送信します。定期マインダはユーザが登録解除または一時停止されるまで指定された間隔でユーザに送信されます。';
$string['enablereminder:second'] = '2番目のリマインダを有効にする';
$string['enablereminder:second_help'] = 'この設定を有効にした場合、パルスはスケジュールに基づいて選択した受信対象者に2番目のリマインダを送信します。';
$string['enrolmentemptyenddate'] = '-';
$string['enrolmentemptystartdate'] = '-';
$string['generatereport'] = 'レポートを生成する';
$string['head:firstreminder'] = '最初のリマインダ';
$string['head:recurringreminder'] = '定期リマインダ';
$string['head:secondreminder'] = '2番目のリマインダ';
$string['instancename'] = 'パルス';
$string['instruction'] = 'インストラクション';
$string['invitation'] = 'インビテーション';
$string['invitation_help'] = '選択したロールのユーザすべてにインビテーションを送信します。';
$string['invitationdbpro'] = 'ユーザへのインビテーションが挿入されていません。パルスプロを確認してください。';
$string['invitationnotsend'] = 'インビテーションはユーザに送信されません。';
$string['invitationsubject'] = '通知件名';
$string['invitationsubject_help'] = 'インビテーションの件名をここで追加してください。';
$string['learnmore'] = '詳細情報';
$string['light'] = 'ライト';
$string['like'] = '好き';
$string['logintoreact'] = 'リアクションを適用する前にログインする';
$string['managepresets'] = 'プリセットを管理する';
$string['markcomplete'] = '完了マークする';
$string['messageprovider:mod_pulse'] = '通知を送信する';
$string['modulename'] = 'パルス';
$string['modulename_help'] = 'パルスはMoodleコースにおける学生のエンゲージメントおよびコンプライアンスを向上させるための教師用Swissアーミーナイフです:
<ul><li><strong>通知</strong><br/>
それぞれのパルス活動は学生が利用可能になった時点で通知を送信するよう設定できます。学生の氏名またはコース名等、メッセージをパーソナライズするために使用できるプレースホルダが多数あります。通知は学生、教師、編集権限のない教師または管理者に送信できます。他のコースコンテクストまたはユーザコンテクストのロールもサポートされます (例: 保護者またはスタッフマネージャ)。</li>
<li><strong>完了ワークフロー</strong><br/>
パルスは次の3つの方法で活動完了をサポートします (Moodleのコア活動に加えて): 利用可能となった場合、学生によって完了マークされた場合、他のロールに承認された場合。</li></ul>
<p>すべてのオートメーションと同じように実際に何をしたいのか十分に考えることが不可欠です。理想的にはどのような場合に何が起きるべきか書き出してください。これは私たちがあなたをサポートする際にも役立ちます! もしあなたの期待通りに動作しない場合、最も一般的な問題は以下の通りです:</p>
<ul>
<li>コースが<b>開始されていません</b>。パルスは現在進行中のコースでのみ動作します -> 開始日が過去であるかどうか確認してください。</li>
<li>コースが<b>終了しました</b>。パルスは現在進行中のコースでのみ動作します -> 終了日が設定されているかどうか確認してください。</li>
<li>コースには<b>登録済み学生</b>がいます。パルス (無料) は学生に対してのみ動作します -> 実際にコースにアクティブな登録ステータスのユーザが登録されているかどうか確認してください。</li>
<li>パルスアクティビティは<b>利用可能</b>です。パルスは活動が学生に利用可能な場合にのみ動作します。これは実際に何か (例えば単位を授与する) を実施するかどうか決定するために使用する「トリガ」または「条件」です。-> パルス活動が秘匿されているかどうか、学生が満たしていない制限があるかどうか確認してください。よくわからない場合、あなたが学生としてログインした上で学生がパルス活動を表示できるかどうか確認してください。学生が表示できる場合は「有効」であり、学生が表示できない場合は「無効」です。</li>
<li><b>cronジョブ</b>が実行されていないか、まだ実行されていません - 単位の授与はスケジュールタスクによって実施されます。そのためcronジョブを定期的に実行する必要があります。Moodleは1分毎の実行を推奨しています。そして私たちはあなたがその推奨に従うことを勧めるだけです!</li>
</ul>';
$string['modulename_link'] = 'パルス';
$string['modulenameplural'] = 'パルス';
$string['noreaction'] = 'リアクションなし';
$string['normal'] = 'ノーマル';
$string['notassignedgroup'] = '参加者でフィルタリングするにはユーザがグループに属している必要があります。';
$string['notificationfooter'] = '通知フッタ';
$string['notificationfooterdesc'] = '{$a->placeholders}';
$string['notificationheader'] = '通知ヘッダ';
$string['notificationheaderdesc'] = '{$a->placeholders}';
$string['notifyusers'] = 'コース学生に通知する';
$string['notsameuser'] = 'あなたはリアクションを適用する正しいユーザではありません。';
$string['pluginadministration'] = 'パルス管理';
$string['pluginname'] = 'パルス';
$string['preset_template'] = 'プリセットテンプレート';
$string['preset_template_help'] = 'パルスモジュールコース活動のバックアップファイルをアップロードしてください。';
$string['presetcreated'] = 'パルスプリセットが正常に作成されました。';
$string['presetdeleted'] = 'パルスプリセットが正常に削除されました。';
$string['preseticon'] = 'プリセットアイコン';
$string['presetlist'] = 'プリセットリスト';
$string['presetmodaltitle'] = 'プリセット「 {$a->title} 」を使用する';
$string['presetorder'] = 'プリセットテンプレート並べ替え順';
$string['presets'] = 'パルスプリセット';
$string['presetstatus'] = 'このプリセットをリストに表示する';
$string['presetupdated'] = 'パルスプリセットが正常に更新されました。';
$string['previousreminders'] = '前のリマインダ';
$string['primary'] = 'プライマリ';
$string['privacy:completion'] = '完了';
$string['privacy:invitation'] = 'インビテーション';
$string['privacy:metadata'] = 'パルスプラグインはいかなる個人データも保存しません。';
$string['privacy:metadata:completion:approvalstatus'] = 'ユーザ承認ステータス';
$string['privacy:metadata:completion:approvaltime'] = 'ユーザが他のユーザから承認された時間です。';
$string['privacy:metadata:completion:approveduser'] = '学生ユーザを承認したユーザのIDです。';
$string['privacy:metadata:completion:selfcompletion'] = '自己によるユーザ完了ステータスです。';
$string['privacy:metadata:completion:selfcompletiontime'] = 'ユーザがパルス活動を完了マークした時間です。';
$string['privacy:metadata:completion:timemodified'] = '完了が修正された時間です。';
$string['privacy:metadata:completion:userid'] = 'ユーザのIDです。';
$string['privacy:metadata:pulsecompletion'] = 'パルスユーザ活動完了';
$string['privacy:metadata:pulsemessageexplanation'] = 'インビテーションはメッセージシステム経由で学生に送信されます。';
$string['privacy:metadata:pulseusers'] = 'インビテーション通知ユーザ一覧です。';
$string['privacy:metadata:users:status'] = '通知が以前のものか現在のものかを確認するためのインビテーションのステータスです。';
$string['privacy:metadata:users:timecreated'] = 'ユーザにインビテーションを送信した時間です。';
$string['privacy:metadata:users:userid'] = '通知されたユーザのIDです。';
$string['promotionaltext'] = 'あなたはパルスプロで強力なリマインダ、メールでのリアクションおよび独自プリセットを作成できます。';
$string['pulse:addinstance'] = '新しいパルスを追加する';
$string['pulse:notifyuser'] = '通知を送信する';
$string['pulse:view'] = 'パルスを表示する';
$string['pulse_subject'] = 'パルス元 {Course_FullName} ({Site_FullName})';
$string['pulsenotavailable'] = 'パルスインスタンスはコースに追加されませんでした。';
$string['pulsenotification'] = 'パルス通知';
$string['pulsepro:viewreports'] = 'パルスプロレポートを表示する';
$string['rate'] = '評価';
$string['reaction'] = 'リアクション';
$string['reaction:approve'] = '<a href="{$a->reactionurl}" style="color: #fff;background: #0f6fc5;padding:.375rem .75rem;text-decoration-line: none;" >承認する</a>';
$string['reaction:markcomplete'] = '<a href="{$a->reactionurl}" style="color: #fff;background: #0f6fc5;padding: .375rem .75rem;text-decoration-line: none;" >完了マークする</a>';
$string['reaction:rate'] = '&nbsp;';
$string['reactiondisplaytype'] = '場所';
$string['reactiondisplaytype_help'] = 'リアクションを表示する場所を選択してください。';
$string['reactions'] = 'リアクション';
$string['reactionthankmsg'] = 'ありがとうございます! あなたの回答が保存されました。<br><br> <span>このウィンドウを閉じてください。</span>';
$string['reactiontype'] = 'タイプ';
$string['reactiontype_help'] = 'リアクションタイプのリストです。';
$string['recipients'] = '通知対象者';
$string['recipients_help'] = 'あなたが通知を送信したいロールを選択してください。このコースに登録および選択されたロールのユーザのみ通知を受信できます。ユーザコンテクストの「ユーザ」ロールのユーザはコースに登録されている必要はないことに留意してください。';
$string['remindercontent'] = '通知コンテンツ';
$string['remindercontent_help'] = 'あなたがここに入力したコンテンツは通知対象者に送信されます。';
$string['reminders:availabletime'] = '利用可能時間';
$string['reminders:first'] = '最初のリマインダ';
$string['reminders:recurring'] = '定期リマインダ';
$string['reminders:second'] = '2番目のリマインダ';
$string['reminderschedule'] = '通知スケジュール';
$string['reminderschedule_help'] = 'リマインダ通知スケジュールタイプを定義してください。<br>
固定日付を選択した場合、選択した日付に達した時点でリマインダが送信されます。<br>
相対日付を選択した場合、選択した時間が経過した後にリマインダが送信されます。タイマーはパルス活動がユーザに利用可能になった時点で開始します。';
$string['remindersubject'] = '通知件名';
$string['remindersubject_help'] = 'コンテンツはリマインダ通知の件名として使用されます。';
$string['reports'] = 'パルスレポート';
$string['reportsfilename'] = 'パルスレポート - {$a->name}';
$string['resendnotification'] = '通知を再送する';
$string['resendnotification_help'] = 'この設定を有効にした場合、インビテーションリマインダのスケジュールが変更されます。すでに通知済みのユーザにもインビテーションが送信されます。';
$string['resendnotificationdesc'] = 'インビテーションは再送予定です。';
$string['restrictionmet'] = '制限合致';
$string['schedule:fixeddate'] = '固定日付';
$string['schedule:relativedate'] = '相対日付';
$string['search:activity'] = 'パルス';
$string['secondary'] = 'セカンダリ';
$string['selectpulse'] = 'パルスインスタンスを選択する';
$string['self'] = '自己';
$string['selfmarked'] = '自己完了マーク {$a->date}';
$string['sendnotificaton'] = 'パルス通知を送信する';
$string['sendnotificaton_help'] = 'この設定を有効にした場合、インビテーションが送信されます。';
$string['setup'] = 'セットアップフィールド';
$string['setupcredit'] = 'この機能を使用する場合、あなたはまずユーザプロファイルフィールドを設定する必要があります。この設定に関して、あなたのローカル管理者に尋ねてください。';
$string['showhide'] = '詳細ログ';
$string['statuslabel'] = '有効/無効';
$string['success'] = '成功';
$string['tasklimituser'] = 'タスクごとにユーザを制限する';
$string['tasklimituserdesc'] = 'この設定でタスクごとに処理されるユーザ数を制限してください。タスク終了に時間がかかりすぎる場合、ユーザ数を減らしてください。';
$string['teacher'] = '教師';
$string['title'] = 'タイトル';
$string['title_help'] = 'タイトルは活動名として使用されます。またインビテーション送信時の件名としても使用されます。';
$string['tokenexpired'] = 'トークンの有効期限が切れました! あなたの回答は保存されませんでした。';
$string['update_preset'] = 'プリセットテンプレートを更新する';
$string['updatecompletion'] = 'パルスモジュール完了を更新する';
$string['updateusercredits'] = 'ユーザクレジットを更新する';
$string['usepreset'] = 'プリセットを使用する';
$string['userrole'] = 'userrole';
$string['viewreport'] = 'レポートを表示する';
$string['warning'] = '警告';
