<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'ja', version '4.4'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = '上';
$string['activitynavigationposition'] = '活動ナビゲーションポジション';
$string['activitynavigationpositiondesc'] = '活動ナビゲーションの「上」または「下」を選択してください。「上」は活動の上、「下」は活動の下です。あなたがカスタムCSSを使用したい場合、セレクタ「#activitynavigation」を使用してください。';
$string['advert_alttext'] = 'テーマデザインレベル1広告バナー';
$string['advert_heading'] = 'テーマデザインレベル1';
$string['advert_tagline'] = 'テーマをカスタマイズしたい場合、しかし、開発、PHPの経験およびMoodleテーマの経験がない場合、あなたに「MoodleBites Theme Design Level 1」が最適です! そこではMoodleテーマ開発の分かりやすいイントロダクション、あなたが先に進むための素晴らしい基礎訓練が提供されます。詳細はここをクリックしてください。';
$string['aftercontent'] = 'コンテンツの後';
$string['alert1'] = 'アラート1';
$string['alert2'] = 'アラート2';
$string['alert3'] = 'アラート3';
$string['alert_edit'] = 'アラートを編集する';
$string['alert_general'] = 'お知らせ';
$string['alert_info'] = '情報';
$string['alert_warning'] = '警告';
$string['alertinfodesc'] = 'あなたのアラートの設定を入力してください。';
$string['alertsdesc'] = 'ここではあなたのユーザに3つの異なるスタイルのアラートをMoodleフロントページで表示します。必要でない場合、忘れずに無効にしてください。';
$string['alertsheading'] = 'ユーザアラート';
$string['alertsheadingsub'] = 'あなたのユーザにフロントページで重要なメッセージを表示する';
$string['alerttext'] = 'アラートテキスト';
$string['alerttextdesc'] = 'あなたのアラートに表示したいテキストです。';
$string['alerttitle'] = 'タイトル';
$string['alerttitledesc'] = 'あなたのアラートのメインタイトル/ヘッディングです。';
$string['alerttype'] = 'レベル';
$string['alerttypedesc'] = 'あなたのユーザに知らせるために最適なアラートレベル/タイプを設定します。';
$string['allclasses'] = 'すべてのクラス';
$string['allcourses'] = 'すべてのコース';
$string['allmodules'] = 'すべてのモジュール';
$string['allunits'] = 'すべてのユニット';
$string['alternativecolors'] = '代替色 {$a}';
$string['alternativethemecolor'] = '代替テーマ色 {$a}';
$string['alternativethemecolordesc'] = 'あなたのテーマの代替テーマ色 {$a} を設定します。';
$string['alternativethemecolorname'] = '代替テーマ色セット名 {$a}';
$string['alternativethemecolornamedesc'] = 'この代替テーマ色セットに認識可能な名称を提供してください。';
$string['alternativethemecolors'] = '代替テーマ色';
$string['alternativethemecolorsdesc'] = 'ユーザが選択できる代替テーマ色を定義します。';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'デフォルトボタン背景色 {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'すべてのデフォルトボタン {$a} の背景色を設定します。';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'デフォルトボタン背景ホバー色 {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'すべてのデフォルトボタン {$a} の背景ホバー色を設定します。';
$string['alternativethemedefaultbuttontextcolour'] = 'デフォルトボタンテキスト色 {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'すべてのデフォルトボタン {$a} のテキスト色を設定します。';
$string['alternativethemedefaultbuttontexthovercolour'] = 'デフォルトボタンホバーテキスト色 {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'すべてのデフォルトボタン {$a} のホバーテキスト色を設定します。';
$string['alternativethemefooterblockbackgroundcolour'] = '代替テーマ色 {$a} のフッタブロック背景色';
$string['alternativethemefooterblockbackgroundcolourdesc'] = '代替テーマ色 {$a} のフッタ内のブロック背景色を設定します。';
$string['alternativethemefooterblockhovercolour'] = '代替テーマ色 {$a} のフッタブロックリンクホバー色';
$string['alternativethemefooterblockhovercolourdesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のリンクブロックテキストにホバーされた時の色設定します。';
$string['alternativethemefooterblocktextcolour'] = '代替テーマ色 {$a} のフッタブロックテキスト色';
$string['alternativethemefooterblocktextcolourdesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のブロックテキスト色を設定します。';
$string['alternativethemefooterblockurlcolour'] = '代替テーマ色 {$a} のフッタブロックリンク色';
$string['alternativethemefooterblockurlcolourdesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のブロックリンクテキスト色を設定します。';
$string['alternativethemefootercolor'] = '代替テーマ色 {$a} のフッタ背景色';
$string['alternativethemefootercolordesc'] = '代替テーマ色 {$a} のフッタボックス背景色を設定します。';
$string['alternativethemefooterheadingcolor'] = '代替テーマ色 {$a} のフッタヘッディング色';
$string['alternativethemefooterheadingcolordesc'] = '代替テーマ色 {$a} のフッタヘッディング色を設定します。';
$string['alternativethemefooterhovercolor'] = '代替テーマ色 {$a} のフッタリンクホバー色';
$string['alternativethemefooterhovercolordesc'] = 'あなたの代替テーマ色 {$a} のリンクブロックテキストにフッタ内でホバーされた時の色を設定します。';
$string['alternativethemefootersepcolor'] = '代替テーマ色 {$a} のフッタセパレータ色';
$string['alternativethemefootersepcolordesc'] = 'セパレータはコンテンツを分離するために使用される線です。ここで代替テーマ色 {$a} の線の色を設定します。';
$string['alternativethemefootertextcolor'] = '代替テーマ色 {$a} のフッタテキスト色';
$string['alternativethemefootertextcolordesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のテキスト色を設定します。';
$string['alternativethemefooterurlcolor'] = '代替テーマ色 {$a} のフッタリンク色';
$string['alternativethemefooterurlcolordesc'] = 'あなたの代替テーマ色 {$a} のフッタ内のリンクテキスト色を設定します。';
$string['alternativethemehovercolor'] = '代替テーマホバー色 {$a}';
$string['alternativethemehovercolordesc'] = 'あなたのテーマホバーの代替テーマ色 {$a} を設定します。';
$string['alternativethemeiconcolor'] = '代替アイコン色 {$a}';
$string['alternativethemeiconcolordesc'] = 'すべてのアイコンの代替 {$a} 色を設定します。';
$string['alternativethememycoursesorderenrolbackcolour'] = '代替 {$a} 登録済みコース未アクセス背景色';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = '登録済みでコースにアクセスしていないユーザに代替 {$a} 背景色を設定します。「mycoursesorder」が「最終アクセス ...」に設定された場合に適用されます。';
$string['alternativethemename'] = 'カラースキーマ名';
$string['alternativethemenamedesc'] = 'あなたの代替テーマ色の名称を提供してください。';
$string['alternativethemenavcolor'] = 'ナビゲーションテキスト色 {$a}';
$string['alternativethemenavcolordesc'] = 'ナビゲーションの代替 {$a} テキスト色を設定します。ナビゲーションバーおよびブレッドクラムを装飾的なスタイルにします。';
$string['alternativethemequizsubmitbackgroundcolour'] = '小テスト「すべてを送信して終了する」背景色 {$a}';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = '小テスト「すべてを送信して終了する」ボタンに代替 {$a} 背景色を設定します。';
$string['alternativethemequizsubmitbackgroundhovercolour'] = '小テスト「すべてを送信して終了する」背景ホバー色 {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = '小テスト「すべてを送信して終了する」ボタンに代替 {$a} 背景ホバー色を設定します。';
$string['alternativethemequizsubmittextcolour'] = '小テスト「すべてを送信して終了する」テキスト色 {$a}';
$string['alternativethemequizsubmittextcolourdesc'] = '小テスト「すべてを送信して終了する」ボタンに代替 {$a} テキスト色を設定します。';
$string['alternativethemequizsubmittexthovercolour'] = '小テスト「すべてを送信して終了する」テキストホバー色 {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = '小テスト「すべてを送信して終了する」ボタンに代替 {$a} テキストホバー色を設定します。';
$string['alternativethemesidepreblockbackgroundcolour'] = '代替 {$a} 「side-pre」ブロック背景色';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = '「side-pre」ブロックに代替 {$a} 背景色を設定します。';
$string['alternativethemesidepreblockhovercolour'] = '代替 {$a} 「side-pre」ブロックリンクホバー色';
$string['alternativethemesidepreblockhovercolourdesc'] = '「side-pre」ブロックに代替 {$a} リンクホバー色を設定します。';
$string['alternativethemesidepreblocktextcolour'] = '代替 {$a} 「side-pre」ブロックリンクテキスト色';
$string['alternativethemesidepreblocktextcolourdesc'] = '「side-pre」ブロックに代替 {$a} テキスト色を設定します。';
$string['alternativethemesidepreblockurlcolour'] = '代替 {$a} 「side-pre」ブロックリンク色';
$string['alternativethemesidepreblockurlcolourdesc'] = '「side-pre」ブロックに代替 {$a} リンク色を設定します。';
$string['alternativethemeslidebuttoncolor'] = '代替テーマスライドボタン色 {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'あなたのテーマスライドボタンの代替テーマ色 {$a} を設定します。';
$string['alternativethemeslidebuttonhovercolor'] = '代替テーマスライドボタンホバー色 {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'あなたのテーマスライドボタンの代替テーマ色 {$a} を設定します。';
$string['alternativethemeslidecaptionbackgroundcolor'] = '代替テーマスライドキャプション背景色 {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'あなたのテーマスライドキャプション背景の代替テーマ色 {$a} を設定します。スライドキャプションオプション「横」には適用されません。';
$string['alternativethemeslidecaptiontextcolor'] = '代替テーマスライドキャプションテキスト色 {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'あなたのテーマスライドキャプションテキストの代替テーマ色 {$a} を設定します。スライドキャプションオプション「横」には適用されません。';
$string['alternativethemeslidecolors'] = '代替テーマスライド色';
$string['alternativethemeslidecolorsdesc'] = 'ユーザが選択できる代替テーマスライド色を定義します。';
$string['alternativethemestripebackgroundcolour'] = '代替ストライプ背景色 {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'テーブルのストライプに代替 {$a} 背景色を設定します。';
$string['alternativethemestripetextcolour'] = '代替ストライプテキスト色 {$a}';
$string['alternativethemestripetextcolourdesc'] = 'テーブルのストライプに代替 {$a} テキスト色を設定します。';
$string['alternativethemestripeurlcolour'] = '代替ストライプURL色 {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'テーブルのストライプに代替 {$a} URL色を設定します。';
$string['alternativethemetextcolor'] = '代替テキスト色 {$a}';
$string['alternativethemetextcolordesc'] = 'あなたの代替テキスト {$a} の色を設定します。';
$string['alternativethemeurlcolor'] = '代替リンク色 {$a}';
$string['alternativethemeurlcolordesc'] = 'あなたの代替リンクテキスト {$a} の色を設定します。';
$string['alwaysdisplay'] = '常に表示する';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'あなたのGoogle PlayストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)。';
$string['androidurl'] = 'Android (Google Play) URL';
$string['asconfigintlower'] = '{$a->value} は下限 {$a->lower} より小さな値です。';
$string['asconfigintnan'] = '{$a->value} は数字ではありません。';
$string['asconfigintupper'] = '{$a->value} は上限 {$a->upper} より大きな値です。';
$string['backtotop'] = 'トップに戻る';
$string['badgepreferences'] = 'バッジ';
$string['badgesmi'] = 'バッジ';
$string['badgesmidesc'] = 'ユーザに「moodle/badges:manageownbadges」ケイパビリティがありサイトレベルでバッジが有効にされている場合、バッジメニューアイテムを表示します。';
$string['beforecontent'] = 'コンテンツの前';
$string['below'] = '下';
$string['breadcrumbsimple'] = 'Simple';
$string['breadcrumbstyle'] = 'ブレッドクラムスタイル';
$string['breadcrumbstyled'] = 'Fancy';
$string['breadcrumbstyledesc'] = 'ここであなたはブレッドクラムのスタイルを変更することができます。';
$string['breadcrumbstylednocollapse'] = 'Fancy (折り畳みなし)';
$string['breadcrumbthin'] = 'Thin';
$string['cachesused'] = '使用キャッシュ';
$string['calendarmi'] = 'カレンダー';
$string['calendarmidesc'] = '「moodle/calendar:manageownentries」ケイパビリティのあるユーザにカレンダーメニューアイテムを表示します。';
$string['categoryctidesc'] = 'この設定を有効にした場合、あなたはそれぞれのカテゴリのイメージを設定できます。';
$string['categoryctiheading'] = 'カテゴリコースタイトルイメージ';
$string['categoryctiheadingcategory'] = 'カテゴリコースタイトルイメージ: {$a->category}';
$string['categoryctiheadingcs'] = 'カテゴリコースタイトルイメージ設定';
$string['categoryctiheadingsub'] = 'あなたのカテゴリをコースで表すためイメージを使用する';
$string['categoryctiheight'] = 'カテゴリ「 {$a->category} 」コースタイトルイメージ高';
$string['categoryctiheightdesc'] = 'カテゴリ「 {$a->category} 」のコースタイトルのイメージ高を {$a->lower} から {$a->upper} ピクセルの間で指定してください。末尾に「px」を追加しないでください。数字のみを入力してください。';
$string['categoryctiinfo'] = '{$a->category} 設定';
$string['categoryctiinfodesc'] = 'カテゴリコースタイトルイメージ設定: {$a->category}';
$string['categoryctimage'] = 'カテゴリ「 {$a->category} 」コースタイトルイメージファイル';
$string['categoryctimagedesc'] = 'カテゴリ「 {$a->category} 」のコースタイトルのイメージファイルです。';
$string['categoryctimageurl'] = 'カテゴリ「 {$a->category} 」コースタイトルイメージURL';
$string['categoryctimageurldesc'] = 'カテゴリ「 {$a->category} 」のコースタイトルのイメージURLです。ファイルがアップロードされた場合、これはオーバーライドされます。';
$string['categoryctitextbackgroundcolour'] = 'カテゴリ「 {$a->category} 」コースタイトルテキスト背景色';
$string['categoryctitextbackgroundcolourdesc'] = 'カテゴリ「 {$a->category} 」のコースタイトルのテキスト背景色です。';
$string['categoryctitextbackgroundopacity'] = 'カテゴリ「 {$a->category} 」コースタイトルテキスト背景透明度';
$string['categoryctitextbackgroundopacitydesc'] = 'カテゴリ「 {$a->category} 」のコースタイトルのテキスト背景透明度です。';
$string['categoryctitextcolour'] = 'カテゴリ「 {$a->category} 」コースタイトルテキスト色';
$string['categoryctitextcolourdesc'] = 'カテゴリ「 {$a->category} 」のコースタイトルのテキスト色です。';
$string['categoryiconcategory'] = 'カテゴリアイコン: {$a->category}.';
$string['categoryicondesc'] = 'この設定を有効にした場合、あなたはそれぞれのコースカテゴリにアイコンを設定することができます。';
$string['categoryiconheading'] = 'カテゴリアイコン';
$string['categoryiconheadingsub'] = 'あなたのカテゴリを表すアイコンを使用する';
$string['categoryiconinfo'] = 'カスタムカテゴリアイコンを設定する';
$string['categoryiconinfodesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['categoryimagecategory'] = 'カテゴリのイメージ: {$a->category}';
$string['categoryincoursebreadcrumbfeature'] = 'コースブレッドクラムのカテゴリ';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'コースのブレッドクラムにカテゴリリンクを表示します。';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>About Essential</h3>
<p>Essential is based upon the Bootstrap theme, which was created for Moodle 2.5, with the help of:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Theme Credits</h3>
<p>Original Author: Julian Ridden<br>
Work taken over in July 2014 by:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Work taken over on the 9th October 2014 by:<br>
Gareth J. Barnard<br>
</p>
<h3>Sponsorships</h3>
<p>This theme is provided to you for free, and if you want to express your gratitude for using this theme, please consider sponsoring by:
<h4>PayPal</h4>
<p>Please contact me via my <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle profile\'</a> for details as I am an individual and therefore am unable to have \'buy me now\' buttons under their terms.</p>
<br>Sponsorships help to facilitate maintenance and allow me to provide you with more and better features. Without your support the theme cannot be maintained.</p>
<p>
<h3>Sponsors</h3>
<p>Sponsorships gratefully received with thanks from:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Essential for Moodle 3.3 kindly sponsored by:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM International Institute</li>
</ul>
</p>
<h3>Customisation</h3>
<p>If you like this theme and would like me to customise it, transpose functionality to another theme, build a new theme from scratch or create a child theme then I offer competitive rates. Please contact me via \'http://moodle.org/user/profile.php?id=442195\' to discuss your requirements.</p>
</div></div>';
$string['colordesc'] = 'ここであなたはこのテーマ内で使用される多くの色を変更することができます。';
$string['colorheading'] = '色';
$string['colorheadingsub'] = 'あなたのテーマで使用する色を設定する';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = '連絡先';
$string['contactinfodesc'] = 'あなたの連絡先を入力してください。';
$string['copyright'] = '著作権';
$string['copyrightdesc'] = 'あなたの組織名です。';
$string['coursecategorysettingstitle'] = 'コースカテゴリ設定';
$string['coursecontentsearch'] = 'コースコンテンツ検索';
$string['coursecontentsearchdesc'] = '「ダッシュボード」ページでのコースコンテンツ検索を有効にします。 「$CFG->themedir」内にEssentialがない場合のみ機能します。';
$string['coursegrades'] = 'コース評定';
$string['coursegradesmi'] = 'コース評定';
$string['coursegradesmidesc'] = 'ユーザに「gradereport/user:view」ケイパビリティがありコース「showgrades」設定がコースで設定されている場合、コース評定メニューアイテムを表示します。';
$string['courselistteachericon'] = 'コース一覧教師アイコン';
$string['courselistteachericondesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['coursesettingstitle'] = 'コース設定';
$string['coursetitleposition'] = 'コースタイトルポジション';
$string['coursetitlepositiondesc'] = 'コースの「上」または「内部」を選択してください。「上」は「side-pre」「page-top」および「course-content」リージョン、「内部」はこの設定が導入された「course-content」リージョン内です。';
$string['ctioverride'] = 'コースのカテゴリイメージをオーバーライドする';
$string['ctioverridedesc'] = 'あなたが「enablecategorycti」設定で有効にされたカテゴリコースタイトルイメージをオーバーライドしたい場合、コース設定のコース概要を編集してイメージを追加してください。HTMLモードで編集して「p」タグおよび「br」タグ、そしてテキストエディタで追加された「img」タグ内の「style」「width」および[height]属性、すべての「classes」を取り除いてください。そしてクラス「categorycti」を追加してください。高さ (px) および含まれるテキスト色、背景色および透明度を指定するにはそれぞれ次の属性を使用してください: 「ctih」「ctit」「ctib」「ctio」。例えば次のようになります:<br /><br /><img src="https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" alt="Replacement image" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0.5"><br /><br />このイメージはコース一覧表示時に概要自体には表示されません。';
$string['ctioverrideheight'] = 'コースタイトルイメージ高デフォルトオーバーライド';
$string['ctioverrideheightdesc'] = 'コースタイトルイメージ高のデフォルトオーバーライドを {$a->lower} から {$a->upper} ピクセルの間で指定してください。末尾に「px」を追加しないでください。数字のみを入力してください。';
$string['ctioverridetextbackgroundcolour'] = 'コースタイトルテキスト背景色デフォルトオーバーライド';
$string['ctioverridetextbackgroundcolourdesc'] = 'コースタイトルのテキスト背景色のデフォルトオーバーライドです。';
$string['ctioverridetextbackgroundopacity'] = 'コースタイトルテキスト背景透明度デフォルトオーバーライド';
$string['ctioverridetextbackgroundopacitydesc'] = 'コースタイトルのテキスト背景透明度のデフォルトオーバーライドです。';
$string['ctioverridetextcolour'] = 'コースタイトルテキスト色デフォルトオーバーライド';
$string['ctioverridetextcolourdesc'] = 'コースタイトルのテキスト色のデフォルトオーバーライドです。';
$string['customcss'] = 'カスタムCSS';
$string['customcssdesc'] = 'あなたがこのテキストエリアに追加したCSSルールはすべてのページに適用され、このテーマのカスタマイズを容易にします。';
$string['customscrollbars'] = 'カスタムスクロールバー';
$string['customscrollbarsdesc'] = 'カスタムスクロールバーを使用します。これにより標準的なブラウザのスクロールバーが置換されます。';
$string['dbqueries'] = 'DB読み/書き';
$string['dbtime'] = 'DBクエリ時間';
$string['defaultcategoryicon'] = 'デフォルトカテゴリアイコン';
$string['defaultcategoryicondesc'] = 'デフォルトカテゴリアイコンを設定する';
$string['defaultcategoryimage'] = 'デフォルトカテゴリイメージ';
$string['defaultcategoryimagedesc'] = 'デフォルトカテゴリイメージを設定します。実装時にアイコンをオーバーライドします。';
$string['defaultcolors'] = 'デフォルト色';
$string['displayafterlogin'] = 'ログイン後のみに表示する';
$string['displaybeforelogin'] = 'ログイン前のみに表示する';
$string['displayeditingmenu'] = '編集ボタンを表示する';
$string['displayeditingmenudesc'] = 'デフォルトページ編集ボタンと同じ機能のボタンをヘッダに表示します。';
$string['displayhiddenmycourses'] = '非表示コースを表示する';
$string['displayhiddenmycoursesdesc'] = 'ユーザに非表示コースを閲覧するパーミッションがある場合、「コースメニュー」に非表示コースを表示します。';
$string['displaymycourses'] = 'コースを表示する';
$string['displaymycoursesdesc'] = '「ナビゲーションバー」内にユーザの登録済みコースを表示します。';
$string['docking'] = 'ドッキングを有効にする';
$string['dockingdesc'] = 'この設定を有効にした場合、ドッキングを利用できます。';
$string['dontdisplay'] = '表示しない';
$string['dropdownmenumaxheight'] = 'ドロップダウンメニュー最大高';
$string['dropdownmenumaxheightdesc'] = 'スクロールバーが有効にされた場合のドロップダウンメニューの最大高です。{$a->lower} から {$a->upper} ピクセルの間にしてください。';
$string['dropdownmenuscroll'] = 'ドロップダウンメニューのスクロールバー';
$string['dropdownmenuscrolldesc'] = 'メニューの高さが制限されている場合、ドロップダウンメニューにスクロールバーを配置します。';
$string['editingmenu'] = 'ページ編集スイッチ';
$string['editingmenudesc'] = 'ユーザがページを編集できる場合、現在のページの編集をON/OFFにスイッチできるボタンを表示します。これは通常のページ編集ボタンと同じ機能です。';
$string['enablealert'] = 'アラートを有効にする';
$string['enablealertdesc'] = 'アラートを有効または無効にする';
$string['enablealternativethemecolors'] = '代替テーマ色 {$a} を有効にする';
$string['enablealternativethemecolorsdesc'] = 'この設定を有効にした場合、ユーザは代替テーマ色 {$a} を選択することができます。';
$string['enablecategorycti'] = 'カテゴリコースタイトルイメージを有効にする';
$string['enablecategoryctics'] = 'カテゴリコースタイトルイメージ設定ページを有効にする';
$string['enablecategorycticsdesc'] = 'この設定を有効にした場合、それぞれのトップレベルカテゴリが設定ページを持つことになります。';
$string['enablecategoryctidesc'] = 'この設定を有効にした場合、あなたは「変更を保存する」クリック後にカテゴリコースタイトルイメージを選択できます。';
$string['enablecategoryicon'] = 'カテゴリアイコンを有効にする';
$string['enablecategoryicondesc'] = 'この設定を有効にした場合、あなたは「変更を保存する」ボタンをクリックした後にカテゴリアイコンを選択することができるようになります。';
$string['enablecustomcategoryicon'] = 'カスタムカテゴリアイコンを有効にする';
$string['enablecustomcategoryicondesc'] = 'この設定を有効にした場合、このセクションの下にカテゴリおよびカスタマイズ可能なオプションが表示されます。この設定を有効または無効にした後、変更を保存してください。';
$string['extperfinfoheading'] = '拡張パフォーマンス情報';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'あなたのFacebookページのURLを入力してください (例 https://www.facebook.com/mycollege)。';
$string['facebookurl'] = 'Facebook URL';
$string['favicon'] = 'カスタムファビコン';
$string['favicondesc'] = 'あなたのファビコンをアップロードしてください。.icoファイルにしてください。';
$string['featuredesc'] = 'ここであなたはこのテーマの多くの機能設定を変更することができます。';
$string['featureheading'] = '機能';
$string['featureheadingsub'] = 'あなたのテーマで使用する機能を設定する';
$string['findcoursecontent'] = 'コースコンテンツ:';
$string['fitvids'] = 'FitVidsを使用する';
$string['fitvidsdesc'] = 'あなたの埋め込みビデオをレスポンシブにするためにFitVids (fitvidsjs.com) を有効にします。FitVidsが有効にされて、あなたがビデオを除外したい場合、エディタのHTMLモードで「iframe」タグに「class="fitvidsignore"」を追加してください。例えば次のようになります: <iframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>';
$string['fixedwidthnarrow'] = '固定幅 - 狭い';
$string['fixedwidthnormal'] = '固定幅 - 通常';
$string['fixedwidthwide'] = '固定幅 - 広い';
$string['flatnavigation'] = 'フラットナビゲーションを有効にする';
$string['flatnavigationdesc'] = 'この設定を有効にした場合、ナビゲーションおよび設定ブロックの代わりにフラットナビゲーションが使用されます。';
$string['flickr'] = 'Flickr';
$string['flickrdesc'] = 'あなたのFlickrページのURLを入力してください (例 http://www.flickr.com/photos/mycollege)。';
$string['flickrurl'] = 'Flickr URL';
$string['floatingsubmitbuttons'] = 'フローティング送信ボタン';
$string['floatingsubmitbuttonsdesc'] = 'デスクトップデバイスでフォームを送信するときに使用されるボタンを含む「フローティング」エリアを表示します。これはページのスクロールを減らします。コース登録またはフォーム投稿には使用されません。';
$string['fontcharacterset'] = 'Googleフォント追加文字セット';
$string['fontcharactersetcyrillic'] = 'キリル文字';
$string['fontcharactersetcyrillicext'] = 'キリル文字拡張';
$string['fontcharactersetdesc'] = '異なる言語の追加文字設定を選択してください。多くの文字セットを使用することであなたのMoodleがスローダウンする可能性があります。そのため、本当に必要な文字セットのみ選択してください。';
$string['fontcharactersetgreek'] = 'ギリシア文字';
$string['fontcharactersetgreekext'] = 'ギリシア文字拡張';
$string['fontcharactersetlatinext'] = 'ラテン文字拡張';
$string['fontcharactersetvietnamese'] = 'ベトナム文字';
$string['fontfileeotbody'] = 'ボディEOTフォントファイル';
$string['fontfileeotheading'] = 'ヘッディングEOTフォントファイル';
$string['fontfileotfbody'] = 'ボディOTFフォントファイル';
$string['fontfileotfheading'] = 'ヘッディングOTFフォントファイル';
$string['fontfiles'] = 'フォントファイル';
$string['fontfilesdesc'] = 'ここであなたのフォントファイルをアップロードしてください。';
$string['fontfilesvgbody'] = 'ボディSVGフォントファイル';
$string['fontfilesvgheading'] = 'ヘッディングSVGフォントファイル';
$string['fontfilettfbody'] = 'ボディTTF フォントファイル';
$string['fontfilettfheading'] = 'ヘッディングTTF フォントファイル';
$string['fontfilewoffbody'] = 'ボディWOFFフォントファイル';
$string['fontfilewoffheading'] = 'ヘッディングWOFFフォントファイル';
$string['fontfilewofftwobody'] = 'ボディWOFF2フォントファイル';
$string['fontfilewofftwoheading'] = 'ヘッディングWOFF2フォントファイル';
$string['fontheadingdesc'] = 'あなたのMoodle環境で使用したいフォントを選択および入力してください。';
$string['fontheadingsub'] = 'フォント設定';
$string['fontnamebody'] = 'テキストフォント';
$string['fontnamebodydesc'] = '他のすべてのテキストで使用されるフォントの正確な名称を入力してください。';
$string['fontnameheading'] = 'ヘッディングフォント';
$string['fontnameheadingdesc'] = 'ヘッディングで使用されるフォントの正確な名称を入力してください。';
$string['fontselect'] = 'フォントタイプセレクタ';
$string['fontselectdesc'] = '利用可能なフォントタイプをリストから選択してください。あなたの選択を適用するために保存してください。';
$string['fontsettings'] = 'フォント';
$string['fonttypecustom'] = 'カスタムフォント';
$string['fonttypegoogle'] = 'Googleウェブフォント';
$string['fonttypeuser'] = 'ユーザフォント';
$string['footerblockbackgroundcolour'] = 'フッタブロック背景色';
$string['footerblockbackgroundcolourdesc'] = 'フッタのブロック背景色を設定します。';
$string['footerblockhovercolour'] = 'フッタブロックリンクホバー色';
$string['footerblockhovercolourdesc'] = 'あなたのリンクブロックテキストにフッタ内でホバーされた時の色を設定します。';
$string['footerblocktextcolour'] = 'フッタブロックテキスト色';
$string['footerblocktextcolourdesc'] = 'あなたのフッタ内でのブロックテキスト色を設定します。';
$string['footerblockurlcolour'] = 'フッタブロックリンク色';
$string['footerblockurlcolourdesc'] = 'あなたのフッタ内でのリンクブロックテキスト色を設定します。';
$string['footercolor'] = 'フッタ背景色';
$string['footercolordesc'] = 'フッタボックスの背景色を設定します。';
$string['footercolors'] = 'フッタ色';
$string['footercolorsdesc'] = 'ページフッタの色を変更します。';
$string['footerheading'] = 'フッタ';
$string['footerheadingcolor'] = 'フッタヘッディング色';
$string['footerheadingcolordesc'] = 'フッタのヘッディング色を設定します。';
$string['footerhovercolor'] = 'フッタリンクホバー色';
$string['footerhovercolordesc'] = 'あなたのリンクテキストにフッタ内でホバーされた時の色を設定します。';
$string['footersepcolor'] = 'フッタセパレータ色';
$string['footersepcolordesc'] = 'セパレータはコンテンツを分離するために使用される線です。ここで線の色を設定します。';
$string['footertextcolor'] = 'フッタテキスト色';
$string['footertextcolordesc'] = 'あなたのフッタ内でのテキスト色を設定します。';
$string['footerurlcolor'] = 'フッタリンク色';
$string['footerurlcolordesc'] = 'あなたのフッタ内でのリンクテキスト色を設定します。';
$string['footnote'] = 'フットノート';
$string['footnotedesc'] = 'このテキストエリアに入力した内容はあなたのMoodleサイトすべてのフッタに表示されます。';
$string['forumdiscussionsmi'] = 'ディスカッション';
$string['forumdiscussionsmidesc'] = 'ユーザに「mod/forum:viewdiscussion」ケイパビリティがある場合、ディスカッション (フォーラム) メニューアイテムを表示します。';
$string['forumpostsmi'] = 'フォーラム投稿';
$string['forumpostsmidesc'] = '「mod/forum:viewdiscussion」ケイパビリティのあるユーザにフォーラム投稿メニューアイテムを表示します。';
$string['fppagetopblocks'] = '追加フロントページ「ページトップ」ブロックを有効にする';
$string['fppagetopblocksdesc'] = 'この設定を有効にした場合、サイドブロックおよびコンテンツエリアの上に追加のブロックロケーションを表示します。注意: 1行あたりのブロック数は「fppagetopblocksperrow」設定に依存します。';
$string['fppagetopblocksperrow'] = '1行あたりのページトップブロック';
$string['fppagetopblocksperrowdesc'] = 'フロントページの「ページトップ」ブロックリージョンに {$a->lower} から {$a->upper} の間で1行あたりのブロック数を指定します。';
$string['frontcontent'] = 'フロントページコンテンツエリアを有効にする';
$string['frontcontentarea'] = 'フロントページコンテンツエリアコンテンツ';
$string['frontcontentareadesc'] = 'このボックスに入力した内容はスライドショーとマーケティングボックスの間にページの全幅に表示されます。';
$string['frontcontentdesc'] = 'この設定を有効にした場合、あなたのカスタムコンテンツのためのカスタムコンテンツエリアをスライドショーとマーケティングボックスの間に追加します。';
$string['frontcontentheading'] = 'フロントページコンテンツエリア';
$string['frontpageblocks'] = 'フロントページブロック配置';
$string['frontpageblocksdesc'] = 'あなたはここでフロントページの標準Moodleブロックをコンテンツの前に並べるか後に並べるか指定することができます。';
$string['frontpageblocksheading'] = 'フロントページブロック';
$string['frontpageheading'] = 'フロントページ';
$string['frontpageheadingdesc'] = 'あなたがフロントページに表示したい追加アイテムをここで設定します。';
$string['frontpagehomeblocksperrow'] = '1行あたりのホーム (旧「中央」) ブロック数';
$string['frontpagehomeblocksperrowdesc'] = '「ホームブロック」ブロックリージョンに {$a->lower} から {$a->upper} の間で1行あたりのブロック数を指定します。注意: 編集を簡単にするため、この設定に関わらず編集時には1行あたり2つのブロックが表示されます。';
$string['frontpagemiddleblocks'] = '追加フロントページ「ホーム」ブロックを有効にする';
$string['frontpagemiddleblocksdesc'] = 'この設定を有効にした場合、追加ブロックロケーションをマーケティングスポットの下に表示します。';
$string['frontpagesettingstitle'] = 'フロントページ設定';
$string['fullname'] = 'サイトフルネーム';
$string['fullnamesummary'] = 'フルネームおよび概要';
$string['generalheadingdesc'] = 'ここでテーマの一般設定を設定します。';
$string['generalheadingsub'] = '一般設定';
$string['genericsettings'] = '一般';
$string['googleplus'] = 'Google+';
$string['googleplusdesc'] = 'あなたのGoogle+プロファイルのURLを入力してください (例 https://plus.google.com/+mycollege)。';
$string['googleplusurl'] = 'Google+ URL';
$string['gotobottom'] = 'ページ最下部に移動する';
$string['gotopeople'] = '人に移動する';
$string['haveheaderblock'] = 'ヘッダブロックリージョン';
$string['haveheaderblockdesc'] = 'ブレッドクラムの直後にヘッダブロックリージョンを設置します。';
$string['headerbackground'] = 'ヘッダ背景イメージ';
$string['headerbackgrounddesc'] = 'あなたの背景イメージをアップロードしてください。';
$string['headerbackgroundstyle'] = 'ヘッダ背景スタイル';
$string['headerbackgroundstyledesc'] = 'ヘッダ背景のスタイルを選択してください。';
$string['headerblocksperrow'] = '1行あたりのヘッダブロック';
$string['headerblocksperrowdesc'] = '「ヘッダブロックリージョン」のあるページに {$a->lower} から {$a->upper} の間で1行あたりのブロック数を指定します。';
$string['headerheading'] = 'ヘッダ';
$string['headertextcolor'] = 'ヘッダテキスト色';
$string['headertextcolordesc'] = 'ヘッダのテキスト色を設定します。';
$string['headertitle'] = 'ヘッダタイトル';
$string['headertitledesc'] = 'ヘッダに表示されるタイトルを設定してください。注意: ヘッダタイトルはロゴがない場合のみ使用されます。';
$string['helplink'] = 'ヘルプリンク';
$string['helplinkdesc'] = 'あなたが上でURLを選択した場合、あなたのヘルプサイトの完全なURLを入力してください (http:// または https:// を含んでください)。あなたがメールアドレスを選択した場合、あなたのメールアドレスを入力してください。';
$string['helplinktype'] = 'メニューのヘルプリンクを有効にする';
$string['helplinktypedesc'] = 'ユーザメニューのヘルプオプションを有効にするかどうか選択してください。あなたは新しいウィンドウで開くURLまたはメールアドレスを選択することができます。';
$string['hidedefaulteditingbutton'] = 'デフォルトのページ編集ボタンを隠す';
$string['hidedefaulteditingbuttondesc'] = 'すべてのページからデフォルトのページ編集ボタンを隠します。この設定は「ページ編集ボタンを表示する」設定が有効にされている場合のみ影響します。';
$string['hideonphone'] = 'モバイルでスライドショーを隠す';
$string['hideonphonedesc'] = 'あなたがモバイルでスライドショーを無効にしたい場合、選択してください。';
$string['hideontablet'] = 'タブレットでスライドショーを隠す';
$string['hideontabletdesc'] = 'あなたがタブレットでスライドショーを無効にしたい場合、選択してください。';
$string['hvpcustomcss'] = 'H5PカスタムCSS';
$string['hvpcustomcssdesc'] = 'H5Pモジュール (moodle.org/plugins/mod_hvp) がインストールされている場合のカスタムCSSです。';
$string['icon'] = 'アイコン';
$string['image'] = 'イメージ';
$string['included'] = '含まれるファイル';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'あなたのInstagramページのURLを入力してください (例 http://instagram.com/mycollege)。';
$string['instagramurl'] = 'Instagram URL';
$string['ios'] = 'iPhone/iPad (Appストア)';
$string['iosdesc'] = 'あなたのAppストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください  (https://itunes.apple.com/en/app/moodle-mobile/id633359593)。';
$string['iosicon'] = 'iOSホームスクリーンアイコン';
$string['iosicondesc'] = 'このテーマではiOSおよびAndroidホームスクリーンのデフォルトアイコンを提供しません。必要であれば、あなたのカスタムアイコンをアップロードすることができます。';
$string['iosurl'] = 'iPhone/iPad (Appストア) URL';
$string['ipadicon'] = 'iPadアイコン (非Retina)';
$string['ipadicondesc'] = 'アイコンは72px x 72pxのPNGファイルにしてください。';
$string['ipadretinaicon'] = 'iPadアイコン (Retina)';
$string['ipadretinaicondesc'] = 'アイコンは144px x 144px のPNGファイルにしてください。';
$string['iphoneicon'] = 'iPhone/iPod Touchアイコン (非Retina)';
$string['iphoneicondesc'] = 'アイコンは57px x 57pxのPNGファイルにしてください。';
$string['iphoneretinaicon'] = 'iPhone/iPod Touchアイコン (Retina)';
$string['iphoneretinaicondesc'] = 'アイコンは114px x 114pxのPNGファイルにしてください。';
$string['layout'] = '標準コースレイアウトを使用する';
$string['layoutdesc'] = 'このテーマは両サイドにブロックカラムを配置するよう設計されています。標準的なMoodleコースレイアウトを希望する場合、あなたはこの設定を有効にして古い3カラムレイアウトに戻ることができます。';
$string['left'] = '左';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'あなたのLinkedInプロファイルのURLを入力してください (例 https://www.linkedin.com/company/mycollege)。';
$string['linkedinurl'] = 'LinkedIn URL';
$string['loadtime'] = '読み込み時間';
$string['loggedinas'] = '代替ログイン';
$string['loggedinfrom'] = 'ログイン元';
$string['loggedinfrommi'] = 'ログイン元';
$string['loggedinfrommidesc'] = 'ユーザがMNETリモートユーザの場合、ログイン元メニューアイテムを表示します。';
$string['loginbackground'] = 'ログイン背景イメージ';
$string['loginbackgrounddesc'] = 'あなたのログイン背景イメージをアップロードしてください。下でイメージのスタイルを選択してください。';
$string['loginbackgroundopacity'] = '背景イメージがある場合のログインボックス背景透明度';
$string['loginbackgroundopacitydesc'] = '背景イメージがある場合のログインボックスのログイン背景の透明度です。';
$string['loginbackgroundstyle'] = 'ログイン背景スタイル';
$string['loginbackgroundstyledesc'] = 'アップロードされたイメージのスタイルを選択してください。';
$string['logo'] = 'ロゴ';
$string['logodesc'] = 'あなたのカスタムロゴをヘッダに追加したい場合、ここでアップロードしてください。<br />イメージは以下のデバイスで指定された利用可能なパーセンテージの幅に調整されます。これによりレスポンシブソリューションが提供されます。あなたに多くのソーシャル/アプリアイコンがある場合、結果をダブルチェックしてください。<br />あなたがロゴをアップロードした場合、デフォルトで表示されていた標準アイコンおよび名称と置換されます。';
$string['logodesktopwidth'] = 'ロゴデスクトップ幅';
$string['logodesktopwidthdesc'] = 'デスクトップのロゴイメージコンテナの幅です (>= 980px)。<br />利用可能なスペースのパーセンテージを {$a->lower} から {$a->upper} の間で指定してください。<br />利用可能なスペースは「pagewidth」設定で許可された幅です。イメージは解像度の最大幅のパーセンテージで表示されます。<br />注意: コンテナの最小高は64ピクセルです。イメージ高がそれより小さい高さに計算された場合、ボトムに隙間が生じます。';
$string['logodimerror'] = '無効です。値の直後に「px」または「em」を記述してください。値の前には何も記述しないでください。';
$string['logomobilewidth'] = 'ロゴモバイル幅';
$string['logomobilewidthdesc'] = 'デスクトップのロゴイメージコンテナの幅です (< 980px)。<br />利用可能なスペースのパーセンテージを {$a->lower} から {$a->upper} の間で指定してください。<br />利用可能なスペースは「pagewidth」設定で許可された幅です。イメージは解像度の最大幅のパーセンテージで表示されます。<br />注意: コンテナの最小高は52ピクセルです。イメージ高がそれより小さい高さに計算された場合、ボトムに隙間が生じます。';
$string['marketing1'] = 'マーケティングスポット1';
$string['marketing2'] = 'マーケティングスポット2';
$string['marketing3'] = 'マーケティングスポット3';
$string['marketingbuttontext'] = 'リンクテキスト';
$string['marketingbuttontextdesc'] = 'ボタンに表示されるテキストです。';
$string['marketingbuttonurl'] = 'リンクURL';
$string['marketingbuttonurldesc'] = 'ボタンがリンクするURLです。';
$string['marketingcontent'] = 'コンテンツ';
$string['marketingcontentdesc'] = 'マーケティングボックスに表示されるコンテンツです。簡潔に記載してください。';
$string['marketingdesc'] = 'このテーマではスライドショーの下に3つの「マーケティング」または「広告」を有効にするオプションを提供します。これによりコアな情報を容易に確認して、あなたのユーザへのダイレクトリンクを提供することができます。';
$string['marketingheading'] = 'マーケティングスポット';
$string['marketingheadingsub'] = 'フロントページに情報およびリンクを追加する3つの場所です。';
$string['marketingheight'] = 'マーケティングスポットコンテナの高さ (px)';
$string['marketingheightdesc'] = 'マーケティングスポットコンテナの高さ (ピクセル) を指定してください。あなたのコンテンツに適するよう調整してください。スポット内にイメージまたはリンクがある場合、すべてのスポットにおいてこの値に追加されます。';
$string['marketingicon'] = 'アイコン';
$string['marketingicondesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['marketingimage'] = 'イメージ';
$string['marketingimagedesc'] = 'ここではマーケティングスポット上部にイメージを表示するオプションを提供します。';
$string['marketingimageheight'] = 'マーケティングイメージの高さ (px)';
$string['marketingimageheightdesc'] = 'マーケティングボックスにイメージを表示したい場合、あなたはここで高さ (ピクセル) を指定することができます。';
$string['marketinginfodesc'] = 'あなたのマーケティングスポットの設定を入力してください。';
$string['marketingtitle'] = 'タイトル';
$string['marketingtitledesc'] = 'このマーケティングスポットに表示するタイトルです。';
$string['marketingurltarget'] = 'リンクターゲット';
$string['marketingurltargetdesc'] = 'リンクをどのように開くか選択してください。';
$string['marketingurltargetnew'] = '新しいページ';
$string['marketingurltargetparent'] = '親フレーム';
$string['marketingurltargetself'] = '現在のページ';
$string['memused'] = '使用メモリ';
$string['messagesmi'] = 'メッセージ';
$string['messagesmidesc'] = 'メッセージングが有効にされている場合、メッセージメニューアイテムを表示します。';
$string['mobileappsdesc'] = 'AppストアまたはGoogle Playストアでウェブアプリを取得しましたか? あなたのユーザがアプリをオンラインで取得できるよう、ここでリンクを提供してください。';
$string['mobileappsheading'] = 'Apps';
$string['mobileappsheadingsub'] = 'あなたの学生がモバイルで使用するためのアプリにリンクする';
$string['modulesettingstitle'] = 'モジュール設定';
$string['myclasses'] = 'マイクラス';
$string['mycourses'] = 'マイコース';
$string['mycoursescatsubmenu'] = 'カテゴリおよびコースサブメニュー';
$string['mycoursescatsubmenudesc'] = 'コースのあるトップレベルカテゴリを基にコースをサブメニュー内で整理します。「enablecategoryicon」が「false」の場合、テーマデフォルトがカテゴリアイコンがとして使用されます。「true」の場合、「defaultcategoryicon」の値、同時に「enablecustomcategoryicon」が有効にされている場合はカテゴリ自体のアイコンが使用されます。「mycoursesmax」設定は適用されますがカテゴリレベルでの適用となります。';
$string['mycoursesinfo'] = 'コースメニュー';
$string['mycoursesinfodesc'] = 'ユーザに登録済みコース一覧を動的に表示します';
$string['mycoursesmax'] = '最大コース';
$string['mycoursesmaxdesc'] = '一覧表示されるコースを {$a->lower} から {$a->upper} の間で指定します。「 {$a->lower} 」はすべてを意味します。';
$string['mycoursesorder'] = 'コース順';
$string['mycoursesorderdesc'] = 'コースがどのように並べ替えられるか提示します。コース並べ替え順はコアナビゲーション設定「navsortmycoursessort」で指定できます。';
$string['mycoursesorderenrolbackcolour'] = '登録済みコース未アクセス背景色';
$string['mycoursesorderenrolbackcolourdesc'] = '登録済みでコースにアクセスしていないユーザに背景色を設定します。「mycoursesorder」が「最終アクセス ...」に設定された場合に適用されます。';
$string['mycoursesorderid'] = 'コースID';
$string['mycoursesorderidasc'] = '昇順';
$string['mycoursesorderiddes'] = '降順';
$string['mycoursesorderidorder'] = 'コースID順';
$string['mycoursesorderidorderdesc'] = '「コース並べ替え順」として「コースID」が指定された場合のコースID並べ替え順です。';
$string['mycoursesorderlast'] = '最終アクセス日時、アクセスしていない場合は登録開始日時';
$string['mycoursesordersort'] = 'コース並べ替え順';
$string['mycoursetitle'] = '用語';
$string['mycoursetitledesc'] = 'ドロップダウンメニューの「マイコース」リンクの用語を変更します。「mycoursesorder」が「最終アクセス ...」に設定された場合に適用されます。';
$string['mygrades'] = 'マイ評定';
$string['mygradesmi'] = 'マイ評定';
$string['mygradesmidesc'] = 'ユーザにコースの「gradereport/overview:view」ケイパビリティがある場合、マイ評定アイテムメニューを表示します。サイトレベルではチェックされません。';
$string['mylatestclasses'] = 'マイ最新クラス';
$string['mylatestcourses'] = 'マイ最新コース';
$string['mylatestmodules'] = 'マイ最新モジュール';
$string['mylatestunits'] = 'マイ最新ユニット';
$string['mymodules'] = 'マイモジュール';
$string['myunits'] = 'マイユニット';
$string['navbarabove'] = 'ヘッダの上のナビゲーションバー';
$string['navbarbelow'] = 'ヘッダの下のナビゲーションバー';
$string['navbartitle'] = 'ナビゲーションバータイトル';
$string['navbartitledesc'] = 'ここではナビゲーションに表示されるタイトルを設定します。';
$string['nextsection'] = '次のセクション';
$string['nobreadcrumb'] = '非表示';
$string['noenrolments'] = 'あなたの現在の登録はありません。';
$string['noslidetitle'] = 'スライドタイトルなし {$a->slide}';
$string['notitle'] = 'タイトルなし';
$string['numberofcoursesandsubcatcourses'] = 'コース数 - サブカテゴリコース';
$string['numberofslides'] = 'スライド数';
$string['numberofslides_desc'] = 'スライダのスライド数です。';
$string['oldnavbar'] = '古いナビゲーションバーのポジションを使用する';
$string['oldnavbardesc'] = '古いナビゲーションバーのポジションを使用する場合、このオプションを有効にしてください。ナビゲーションバーをヘッダの下に置きます。';
$string['pagebackground'] = 'ページ背景イメージ';
$string['pagebackgrounddesc'] = 'あなたの背景イメージをアップロードしてください。以下でイメージのスタイルを選択してください。';
$string['pagebackgroundstyle'] = 'ページ背景スタイル';
$string['pagebackgroundstyledesc'] = 'アップロードされたイメージのスタイルを選択してください。';
$string['pagebottomblocksperrow'] = '1行あたりのページボトムブロック';
$string['pagebottomblocksperrowdesc'] = '「ページトップボトムブロック」のあるページに1行あたりいくつのブロックを表示するか {$a->lower} から {$a->upper} の間で指定してください。現在のページは次のとおりです: 管理、コース管理、評定および小テスト編集';
$string['pagetopblocks'] = '追加ページ「ページトップ」ブロックを有効にする';
$string['pagetopblocksdesc'] = 'この設定を有効にした場合、独自の設定を持つ「フロントページ」を除くサイドブロックおよびコンテンツエリアの上に追加のブロックロケーションを表示します。注意: 1行あたりのブロック数は「pagetopblocksperrow」設定に依存します。';
$string['pagetopblocksperrow'] = '1行あたりのページトップブロック';
$string['pagetopblocksperrowdesc'] = '「ページトップブロック」のあるページに1行あたりいくつのブロックを表示するか {$a->lower} から {$a->upper} の間で指定してください。現在のページは次のとおりです: コース、コースカテゴリ、ダッシュボード、マイパブリックおよび印刷';
$string['pagewidth'] = 'ページ幅を設定する';
$string['pagewidthdesc'] = 'あなたのサイトに利用できるページ幅をリストから選択してください。';
$string['participantsmenu'] = '参加者メニュー';
$string['participantsmenudesc'] = 'コースおよびモジュールページに参加者メニューを表示します。';
$string['paypal_click'] = 'Moodleプロファイル';
$string['paypal_desc'] = 'よろしければ、私の {$a->url} の詳細をご覧になり、PayPal経由での出資をお考えください。または必要な開発を継続させるために、あなたの気持ちを伝えるために';
$string['peakmem'] = '最大メモリ';
$string['perf_max'] = '詳細';
$string['perf_min'] = '最小';
$string['perfinfo'] = 'パフォーマンス情報モード';
$string['perfinfodesc'] = '多くのサイトでは詳細なパフォーマンス情報を必要としません。特にユーザが閲覧する場合です。この設定を有効にした場合、不要な情報を取り除いた最小限の形で基本的なページ読み込み情報が表示されます。';
$string['perfinfoheading'] = 'パフォーマンス情報';
$string['pinterest'] = 'Pinterest';
$string['pinterestdesc'] = 'あなたのPinterestページのURLを入力してください (例 http://pinterest.com/mycollege/mypinboard)。';
$string['pinteresturl'] = 'Pinterest URL';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'プリファレンス';
$string['preferencesmidesc'] = 'プリファレンスメニューアイテムを表示します。';
$string['previoussection'] = '前のセクション';
$string['privacy:metadata:preference:courseitemsearchtype'] = '「coursecontentsearch」がチェックされた場合に保存されるコース検索のユーザの選択です (「コースフルネーム」 - 「0」、「すべてのコースコンテンツ」 - 「1」) 。何も表示されない場合、コース検索が無効にされているかユーザがダッシュボードを閲覧していないことが考えられます。';
$string['privacy:request:preference:courseitemsearchtype'] = 'ユーザはコース検索ユーザプリファレンス「 {$a->name} 」に「 {$a->value} 」を選択しました。「0」は「コースフルネームのみ」、「1」は「すべてのコースコンテンツ」を意味します。';
$string['privatefilesmi'] = 'プライベートファイル';
$string['privatefilesmidesc'] = 'ユーザに「moodle/user:manageownfiles」ケイパビリティがある場合、プライベートファイルメニューアイテムを表示します。';
$string['profilebarcustomtitle'] = 'プロファイルバーカスタムブロックタイトル';
$string['profilebarcustomtitledesc'] = 'カスタムプロファイルバーブロックのタイトルです。';
$string['profilelinkmi'] = 'プロファイルリンク';
$string['profilelinkmidesc'] = 'プロファイルリンクメニューアイテムを表示します。';
$string['properties'] = 'プロパティ';
$string['propertiesdesc'] = 'プロパティ一覧です。';
$string['propertiesexport'] = 'JSONストリングとしてプロパティをエクスポートする';
$string['propertiesproperty'] = 'プロパティ';
$string['propertiesreturn'] = '戻る';
$string['propertiessub'] = 'プロパティ';
$string['propertiesvalue'] = '値';
$string['putpropertiesadded'] = '追加:';
$string['putpropertieschanged'] = '変更:';
$string['putpropertiesdesc'] = 'JSONストリングを貼り付けて「変更を保存する」をクリックしてください。警告! 設定値を有効にして「すべてのキャッシュを削除する」を実行しないください。';
$string['putpropertiesfrom'] = 'from';
$string['putpropertiesignorecti'] = 'すべてのコースタイトルイメージ設定を無視します。';
$string['putpropertiesignored'] = '無視:';
$string['putpropertiesname'] = 'プロパティを設置する- 実験用!';
$string['putpropertiesreportfiles'] = '忘れずに次のファイルを設定にアップロードしてください:';
$string['putpropertiessettingsreport'] = '設定レポート:';
$string['putpropertiesunchanged'] = '変更なし:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = '私たちの';
$string['putpropertyproperties'] = 'プロパティ';
$string['putpropertyreport'] = 'レポート:';
$string['putpropertyversion'] = 'バージョン:';
$string['readme_click'] = 'README.txtファイルを読むにはここをクリックしてください。';
$string['readme_desc'] = '{$a->url} Essentialテーマのカスタマイズを含む詳細情報を含みます。';
$string['readme_title'] = 'Essential read-me';
$string['readmore'] = '詳細';
$string['region-footer-left'] = 'フッタ (左)';
$string['region-footer-middle'] = 'フッタ (中央)';
$string['region-footer-right'] = 'フッタ (右)';
$string['region-header'] = 'ヘッダ';
$string['region-hidden-dock'] = 'ユーザから隠す';
$string['region-home'] = 'ホーム';
$string['region-page-top'] = 'ページトップ';
$string['region-side-post'] = '右';
$string['region-side-pre'] = '左';
$string['returntosection'] = '{$a->section} に戻る';
$string['returntosectionfeature'] = 'セクションに戻る';
$string['returntosectionfeaturedesc'] = 'コースモジュール内でセクションに戻る機能を有効にします。';
$string['returntosectiontextlimitfeature'] = 'セクションに戻るテキスト制限';
$string['returntosectiontextlimitfeaturedesc'] = 'ボタンのセクション名の長さを {$a->lower} から {$a->upper} 文字に制限します。';
$string['right'] = '右';
$string['searchallcoursecontent'] = 'すべてのコースコンテンツを検索する';
$string['searchallcoursecontentdefault'] = '「すべてのコースコンテンツを検索する」のデフォルト';
$string['searchallcoursecontentdefaultdesc'] = 'コースコンテンツ検索の「すべてのコースコンテンツを検索する」チェックボックスの値を設定します。「すべてのコースコンテンツを検索する」がチェック解除された場合、コースフルネームのみが検索対象となります。';
$string['searchallcoursecontentenable'] = 'すべてのコースコンテンツの検索を有効にする';
$string['searchallcoursecontentenabledesc'] = 'ユーザがすべてのコースコンテンツの検索を決定できるようにします。この設定を無効にした場合、コース検索に「searchallcoursecontentdefault」の値が適用されます。';
$string['serverload'] = 'サーバ負荷';
$string['sessionsize'] = 'セッションサイズ';
$string['shortname'] = 'サイト省略名';
$string['shortnamesummary'] = '省略名および概要';
$string['siteicon'] = 'サイトアイコン';
$string['siteicondesc'] = 'あなたが使用したいアイコン名を入力してください。<a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ここで</a>リストを確認することができます。「fa-」以下の文字を入力してください。例 star';
$string['skype'] = 'Skypeアカウント';
$string['skypedesc'] = 'あなたの組織のSkypeアカウントのSkypeユーザ名のURLを入力してください (例 skype://my.college)。';
$string['skypeuri'] = 'SkypeアカウントURI';
$string['slidebuttoncolor'] = 'スライドボタン色';
$string['slidebuttoncolordesc'] = 'スライドナビゲーションボタンの色です。';
$string['slidebuttonhovercolor'] = 'スライドボタンホバー色';
$string['slidebuttonhovercolordesc'] = 'スライドナビゲーションボタンのホバー色です。';
$string['slidecaption'] = 'スライドキャプション';
$string['slidecaptionbackgroundcolor'] = 'スライドキャプション背景色';
$string['slidecaptionbackgroundcolordesc'] = 'スライドキャプションの背景色を設定します。スライドキャプションオプション「横」には適用されません。';
$string['slidecaptionbelow'] = 'スライドキャプションイメージ下部';
$string['slidecaptionbelowdesc'] = 'スライドキャプションをイメージの下に置きたい場合、この設定を有効にしてください。';
$string['slidecaptionbeside'] = '横';
$string['slidecaptioncentred'] = 'スライドキャプション中央';
$string['slidecaptioncentreddesc'] = 'スライドキャプションを中央に置きたい場合、この設定を有効にしてください。';
$string['slidecaptiondesc'] = 'スライドで使用するキャプションテキストを入力してください。';
$string['slidecaptionontop'] = '上部';
$string['slidecaptionoptions'] = 'スライドキャプションオプション';
$string['slidecaptionoptionsdesc'] = 'イメージに関するキャプションを表示する場所です。';
$string['slidecaptiontextcolor'] = 'スライドキャプションテキスト色';
$string['slidecaptiontextcolordesc'] = 'スライドキャプションテキストの色です。スライドキャプションオプション「横」には適用されません。';
$string['slidecaptionunderneath'] = '下部';
$string['slidecolor'] = 'スライドテキスト色';
$string['slidecolordesc'] = 'スライドキャプションテキストの色です。';
$string['slideimage'] = 'スライドイメージ';
$string['slideimagedesc'] = '画像が透過されている場合、最適に動作します。';
$string['slideinterval'] = 'スライドインターバル';
$string['slideintervaldesc'] = 'スライドの切り替え間隔をミリ秒で設定してください。';
$string['slideno'] = 'スライド {$a->slide}';
$string['slidenodesc'] = 'スライド {$a->slide} の設定を入力してください。';
$string['slideshowdesc'] = 'ここではあなたのサイトに重要情報を宣伝するため、最大16スライドの動的なスライドショーを作成します。スライドショーはレスポンシブであり画面サイズに合わせてイメージの高さが設定されます。推奨の高さは300pxです。幅が100%にされるため画面サイズより幅が大きい場合、実際の高さは小さくなります。画面サイズが小さい場合、別のイメージを提供する必要なしに高さが動的に減らされます。参考までに「画面幅 < 767px = 高さ165px、画面幅 768px ～ 979px = 高さ 225px、画面幅 > 980px = 高さ 300px」となります。スライドのイメージが選択されない場合、pixフォルダ内のdefault_slideイメージが使用されます。';
$string['slideshowheading'] = 'スライドショー';
$string['slideshowheadingsub'] = 'フロントページのダイナミックスライドショー';
$string['slidetitle'] = 'スライドタイトル';
$string['slidetitledesc'] = 'あなたのスライドの説明的なタイトルを入力してください。';
$string['slideurl'] = 'スライドリンク';
$string['slideurldesc'] = 'スライドイメージリンクのリンク先を入力してください。';
$string['slideurltarget'] = 'リンクターゲット';
$string['slideurltargetdesc'] = 'リンクをどのように開くか選択してください。';
$string['slideurltargetnew'] = '新しいページ';
$string['slideurltargetparent'] = '親フレーム';
$string['slideurltargetself'] = '現在のページ';
$string['socialdesc'] = 'あなたのブランドを宣伝するためのソーシャルネットワークの直リンクを提供してください。これはすべてのページのヘッダに表示されます。';
$string['socialheading'] = 'ソーシャルネットワーキング';
$string['socialheadingsub'] = 'あなたのユーザをソーシャルネットワーキングと関連付ける';
$string['socialnetworks'] = 'ソーシャルネットワーク';
$string['sponsor_desc'] = '私は個人の開発者であるため、「buy me now」ボタンを設置することができません。';
$string['sponsor_desc2'] = 'もお考えください。';
$string['sponsor_title'] = 'Essentialのスポンサーになる';
$string['stylecover'] = 'カバー';
$string['stylefixed'] = '固定';
$string['styleguide'] = 'スタイルガイド';
$string['styleguidedesc'] = 'オリジナルドキュメンテーションコードは「 {$a->origcodelicenseurl} 」にライセンスされています。Holder.jsは「 {$a->holderlicenseurl} 」にライセンスされています。追加コードは「 {$a->thiscodelicenseurl} 」にライセンスされています。これは「 {$a->compatible} 」ライセンスです。コンテンツは「 {$a->contentlicenseurl} 」にライセンスされています。ドキュメンテーションはMoodleでの出力用に適切なFontAwesomeアイコンを使用して書式を整えています。追加CSSはessential_admin_setting_styleguide.phpファイル内のコメント「// Beyond docs.css.」の下にあります。「 {$a->globalsettings} 」セクションは削除されました。';
$string['styleguidesub'] = 'Bootstrap V2.3.2スタイルガイド';
$string['stylestretch'] = 'ストレッチ';
$string['styletiled'] = 'タイル';
$string['switchrolemi'] = 'ロールを切り替える';
$string['switchrolemidesc'] = 'ユーザがロールを切り替えできる場合、ロール切り替えメニューアイテムを表示します。';
$string['tallyinoftotal'] = '{$a->rtally} - {$a->ctally} / {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} / {$a->total}';
$string['themecolor'] = 'テーマ色';
$string['themecolordesc'] = 'あなたのテーマ色を設定します。あなたがMoodleサイト全体で表示したい色のために複数の構成要素が変更されます。';
$string['themecolors'] = 'テーマ色';
$string['themedefaultbuttonbackgroundcolour'] = 'デフォルトボタン背景色';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'すべてのデフォルトボタンの背景色を設定します。';
$string['themedefaultbuttonbackgroundhovercolour'] = 'デフォルトボタン背景ホバー色';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'すべてのデフォルトボタンの背景ホバー色を設定します。';
$string['themedefaultbuttontextcolour'] = 'デフォルトボタンテキスト色';
$string['themedefaultbuttontextcolourdesc'] = 'すべてのデフォルトボタンのテキスト色を設定します。';
$string['themedefaultbuttontexthovercolour'] = 'デフォルトボタンテキストホバー色';
$string['themedefaultbuttontexthovercolourdesc'] = 'すべてのデフォルトボタンのテキストホバー色を設定します。';
$string['themehovercolor'] = 'テーマホバー色';
$string['themehovercolordesc'] = 'あなたのテーマのホバー色を設定します。これはリンク、メニュー等に使用されます。';
$string['themeiconcolor'] = 'アイコン色';
$string['themeiconcolordesc'] = 'すべてのアイコン色を設定します。';
$string['themenavcolor'] = 'ナビゲーションテキスト色';
$string['themenavcolordesc'] = 'ナビゲーションのテキスト色を設定します。ナビゲーションバーおよびブレッドクラムを装飾的なスタイルにします。';
$string['themequizsubmitbackgroundcolour'] = '小テスト「すべてを送信して終了する」背景色';
$string['themequizsubmitbackgroundcolourdesc'] = '小テスト「すべてを送信して終了する」ボタンの背景色を設定します。';
$string['themequizsubmitbackgroundhovercolour'] = '小テスト「すべてを送信して終了する」背景ホバー色';
$string['themequizsubmitbackgroundhovercolourdesc'] = '小テスト「すべてを送信して終了する」ボタンの背景ホバー色を設定します。';
$string['themequizsubmittextcolour'] = '小テスト「すべてを送信して終了する」テキスト色';
$string['themequizsubmittextcolourdesc'] = '小テスト「すべてを送信して終了する」ボタンのテキスト色を設定します。';
$string['themequizsubmittexthovercolour'] = '小テスト「すべてを送信して終了する」テキストホバー色';
$string['themequizsubmittexthovercolourdesc'] = '小テスト「すべてを送信して終了する」ボタンのテキストホバー色を設定します。';
$string['themesidepreblockbackgroundcolour'] = '「side-pre」ブロック背景色';
$string['themesidepreblockbackgroundcolourdesc'] = '「side-pre」ブロックの背景色を設定します。';
$string['themesidepreblockhovercolour'] = '「side-pre」リンクホバー背景色';
$string['themesidepreblockhovercolourdesc'] = '「side-pre」ブロックのリンクホバー色を設定します。';
$string['themesidepreblocktextcolour'] = '「side-pre」ブロックテキスト色';
$string['themesidepreblocktextcolourdesc'] = '「side-pre」ブロックのテキスト色を設定します。';
$string['themesidepreblockurlcolour'] = '「side-pre」ブロックリンク色';
$string['themesidepreblockurlcolourdesc'] = '「side-pre」ブロックのリンク色を設定します。';
$string['themestripebackgroundcolour'] = 'ストライプ背景色';
$string['themestripebackgroundcolourdesc'] = 'テーブルのストライプの背景色を設定します。';
$string['themestripetextcolour'] = 'ストライプテキスト色';
$string['themestripetextcolourdesc'] = 'テーブルのストライプのテキスト色を設定します。';
$string['themestripeurlcolour'] = 'ストライプURL色';
$string['themestripeurlcolourdesc'] = 'テーブルのストライプのURL色を設定します。';
$string['themetextcolor'] = 'テキスト色';
$string['themetextcolordesc'] = 'あなたのテキスト色を設定します。';
$string['themeurlcolor'] = 'リンク色';
$string['themeurlcolordesc'] = 'あなたのリンクテキスト色を設定します。';
$string['thiscourse'] = 'このコース';
$string['togglemarketing'] = 'マーケティングスポット表示スイッチ';
$string['togglemarketingdesc'] = 'あなたが希望するマーケティングスポットの表示または非表示を選択してください。';
$string['toggleslideshow'] = 'スライドショー表示スイッチ';
$string['toggleslideshowdesc'] = 'あなたが希望するスライドショーの表示・非表示を選択してください。';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'あなたのTwitterフィードのURLを入力してください (例 https://www.twitter.com/mycollege)。';
$string['twitterurl'] = 'Twitter URL';
$string['userimageborderradius'] = 'ユーザ写真border-radius';
$string['userimageborderradiusdesc'] = 'サイト全体のユーザ写真のborder-radiusを {$a->lower} から {$a->upper} ピクセルの間で指定してください。「usermenuuserimageborderradius」設定を使用するヘッダを除きます。';
$string['usermenu'] = 'ユーザメニュー';
$string['usermenudesc'] = 'ユーザのメニューです。';
$string['usermenuuserimageborderradius'] = 'ユーザメニュー写真border-radius';
$string['usermenuuserimageborderradiusdesc'] = 'ユーザメニューのユーザ写真のborder-radiusを {$a->lower} から {$a->upper} ピクセルの間で指定してください。';
$string['usersettingstitle'] = 'ユーザ設定';
$string['usesiteicon'] = 'サイトアイコンを使用する';
$string['usesiteicondesc'] = 'ロゴがない場合、サイトアイコンを使用します。';
$string['variablewidth'] = '可変幅';
$string['versionalerttext1'] = 'テーマはMoodleのバージョンのために設計されていません。';
$string['versionalerttext2'] = '予期しない問題が発生しました。あなたのMoodleのバージョンに適合する正しいバージョンを使用してください。';
$string['versionalerttitle'] = 'バージョン警告:';
$string['visibleadminonly'] = '以下のエリアに移動されたブロックは管理者のみ閲覧することができます。';
$string['vk'] = 'VKontakte';
$string['vkdesc'] = 'あなたのVkontakteページのURLを入力してください (例 http://www.vk.com/mycollege)。';
$string['vkurl'] = 'VKontakte URL';
$string['website'] = 'ウェブサイト';
$string['websitedesc'] = 'あなたのウェブサイトのURLを入力してください (例 http://about.me/gjbarnard)。';
$string['websiteurl'] = 'ウェブサイトURL';
$string['windows'] = 'Windowsデスクトップ';
$string['windowsdesc'] = 'あなたのWindowsストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください (http://apps.microsoft.com/windows/en-us/app/9df51338-015c-41b7-8a85-db2fdfb870bc)。';
$string['windowsurl'] = 'WindowsデスクトップURL';
$string['winphone'] = 'Windowsモバイル';
$string['winphonedesc'] = 'あなたのWindows PhoneストアのモバイルアプリのURLを提供してください。モバイルアプリのURLを提供できない場合、Moodle公式モバイルアプリのリンクを使用してください (http://www.windowsphone.com/en-us/store/app/moodlemobile/d0732b88-3c6d-4127-8f24-3fca2452a4dc)。';
$string['winphoneurl'] = 'WindowsモバイルURL';
$string['within'] = '内部';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'あなたのYouTubeチャンネルのURLを入力してください (例 https://www.youtube.com/user/mycollege)。';
$string['youtubeurl'] = 'YouTube URL';
