<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'sk', version '4.4'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'bude to nainštalované';
$string['accept'] = 'Akceptovať';
$string['action'] = 'Akcia';
$string['actionchoice'] = 'Čo chcete robiť so súborom \'{$a}\'?';
$string['actions'] = 'Akcie';
$string['actionsfor'] = 'Akcie pre {$a}';
$string['actionsmenu'] = 'Ponuka akcií';
$string['active'] = 'Aktívny';
$string['activeusers'] = 'Aktívni používatelia';
$string['activities'] = 'Aktivity';
$string['activities_help'] = 'Aktivity, ako napríklad fóra, testy a wiki, umožňujú pridať do kurzu interaktívny obsah.';
$string['activity'] = 'Ativita';
$string['activityclipboard'] = 'Presun tejto aktivity: {$a}';
$string['activityheader'] = 'Menu aktivít';
$string['activityicon'] = 'ikona {$a}';
$string['activityiscurrentlyhidden'] = 'Je nám ľúto, táto aktivita je momentálne skrytá';
$string['activitymodule'] = 'Modul aktivity';
$string['activitymodules'] = 'Moduly aktivít';
$string['activitynotready'] = 'Aktivita ešte nie je pripravená';
$string['activityreport'] = 'Správa o aktivitách';
$string['activityreports'] = 'Správy o aktivitách';
$string['activityselect'] = 'Vyberte túto aktivitu, aby ste ju premiestnili inam';
$string['activitysince'] = 'Aktivita od {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktivita používateľa';
$string['add'] = 'Pridať';
$string['addactivity'] = 'Pridať aktivitu';
$string['addactivitytosection'] = 'Pridať aktivitu do sekcie \'{$a}\'';
$string['addadmin'] = 'Pridať admina';
$string['addblock'] = 'Pridať blok';
$string['addcomment'] = 'Pridať komentár...';
$string['addcondition'] = 'Pridať podmienku';
$string['addcountertousername'] = 'Vytvoriť používateľa pridaním čísla k používateľskému menu';
$string['addcreator'] = 'Pridať tvorcu kurzu';
$string['adddots'] = 'Pridať...';
$string['added'] = 'Pridané {$a}';
$string['addedtogroup'] = 'Pridaný do skupiny {$a}';
$string['addedtogroupnot'] = 'Nepridaný do skupiny "{$a}"';
$string['addedtogroupnotenrolled'] = 'Nepridaný do skupiny {$a}, pretože nie je zapísaný do kurzu';
$string['addfilehere'] = 'Sem pretiahnuť súbory a pridať ich na koniec tejto sekcie';
$string['addfilesdrop'] = 'Súbory sem môžete nahrať potiahnutím alebo kliknutím na položku.';
$string['addinganew'] = 'Nová ({$a})';
$string['addinganewto'] = 'Pridávanie novej aktivity {$a->what} do {$a->to}';
$string['addingdatatoexisting'] = 'Pridať údaje do existujúcej';
$string['additionalcustomnav'] = 'Ďalšia vlastná navigácia';
$string['additionalnames'] = 'Ďalšie mená';
$string['addlinkhere'] = 'Pridať odkaz tu';
$string['addnew'] = 'Pridať nový {$a}';
$string['addnewcategory'] = 'Pridať novú kategóriu';
$string['addnewcourse'] = 'Pridať nový kurz';
$string['addnewuser'] = 'Pridať nového používateľa';
$string['addnousersrecip'] = 'Pridať používateľov, ktorí nenavštívili {$a}, do zoznamu príjemcov';
$string['addpagehere'] = 'Sem vložiť text';
$string['addresource'] = 'Pridať zdroj';
$string['addresourceoractivity'] = 'Pridať aktivitu alebo zdroj';
$string['addresourcetosection'] = 'Pridať zdroj do sekcie \'{$a}\'';
$string['address'] = 'Adresa';
$string['addsections'] = 'Pridať sekcie';
$string['addstudent'] = 'Pridať študenta';
$string['addsubcategory'] = 'Pridať podkategóriu';
$string['addteacher'] = 'Pridať učiteľa';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'Ručné vytvorenie nového používateľského účtu';
$string['adminhelpassignadmins'] = 'Administrátori môžu robiť všetko a všade v rámci prostredia Moodle';
$string['adminhelpassigncreators'] = 'Tvorcovia kurzov môžu vytvárať nové kurzy';
$string['adminhelpassignsiteroles'] = 'Aplikovať roly v rámci celého portálu vybraným používateľom';
$string['adminhelpassignstudents'] = 'Ísť do kurzu a pridať študentov cez administrátorské menu';
$string['adminhelpauthentication'] = 'Môžete použiť interné používateľské kontá alebo externé databázy';
$string['adminhelpbackup'] = 'Konfigurovať automatické zálohy a ich zoznamy';
$string['adminhelpconfiguration'] = 'Konfigurovať ako bude stránka vyzerať a pracovať';
$string['adminhelpconfigvariables'] = 'Nastaviť premenné, ktoré ovplyvnia základné operácie na stránke';
$string['adminhelpcourses'] = 'Definovať kurzy, kategórie a prideľovanie ľudí do nich';
$string['adminhelpeditorsettings'] = 'Definovať základné nastavenia pre HTML editor';
$string['adminhelpedituser'] = 'Prehľadávať zoznam používateľských kont a ich úpravu';
$string['adminhelpenvironment'] = 'Skontrolujte, ako váš server vyhovuje súčasným a budúcim požiadavkám na inštaláciu';
$string['adminhelpfailurelogs'] = 'Prehľadávať záznamy neúspešných prihlásení';
$string['adminhelplanguage'] = 'Pre kontrolu a úpravu aktuálnej jazykovej verzie';
$string['adminhelplogs'] = 'Prezrieť záznamy všetkých aktivít na stránkach';
$string['adminhelpmanageblocks'] = 'Spravovať inštalované bloky a ich nastavenia';
$string['adminhelpmanagedatabase'] = 'Priamy prístup do databázy (veľmi opatrne!)';
$string['adminhelpmanagefilters'] = 'Vybrať textové filtre a s nimi súvisiace nastavenia';
$string['adminhelpmanagemodules'] = 'Spravujte nainštalované moduly a ich nastavenia';
$string['adminhelpmanageroles'] = 'Vytvoriť a definovať roly, ktoré môžu byť aplikované používateľom';
$string['adminhelpmymoodle'] = 'Konfigurovať bloky Môj moodle pre používateľov';
$string['adminhelpreports'] = 'Záznamy o portáli';
$string['adminhelpsitefiles'] = 'Pre publikovanie hlavných súborov a načítanie vytvorených externých záloh';
$string['adminhelpsitesettings'] = 'Nastavenie vzhľadu titulnej stránky';
$string['adminhelpstickyblocks'] = 'Nastavenie povinných blokov';
$string['adminhelpthemes'] = 'Nastavenie vzhľadu stránok (farby, písma atď.)';
$string['adminhelpuploadusers'] = 'Import nových používateľských účtov z textového súboru';
$string['adminhelpusers'] = 'Definovať používateľov a nastavenie spôsobu ich overovania';
$string['adminhelpxmldbeditor'] = 'Rozhranie na úpravu XMLDB súborov. Iba pre vývojárov';
$string['administration'] = 'Administratíva';
$string['administrationsite'] = 'Administratíva portálu';
$string['administrator'] = 'Administrátor';
$string['administratordescription'] = 'Administrátori obvykle môžu robiť všetko na portáli a v kurzoch.';
$string['administrators'] = 'Administrátori';
$string['administratorsall'] = 'Všetci administrátori';
$string['administratorsandteachers'] = 'Administrátori a učitelia';
$string['advanced'] = 'Rozšírené';
$string['advancedfilter'] = 'Rozšírené vyhľadávanie';
$string['advancedsettings'] = 'Rozšírené nastavenia';
$string['afterresource'] = 'Za zdrojom "{$a}"';
$string['aftersection'] = 'Po sekcii "{$a}"';
$string['again'] = 'opäť';
$string['agelocationverification'] = 'Overenie veku a krajiny';
$string['ajaxuse'] = 'AJAX a Javascript';
$string['all'] = 'Všetko';
$string['allactions'] = 'Všetko';
$string['allactivities'] = 'Všetky aktivity';
$string['allcategories'] = 'Všetky kategórie';
$string['allchanges'] = 'Všetky zmeny';
$string['alldays'] = 'Všetky dni';
$string['allfiles'] = 'Všetky súbory';
$string['allgroups'] = 'Všetky skupiny';
$string['alllogs'] = 'Všetky záznamy';
$string['allmods'] = 'Všetky {$a}';
$string['allow'] = 'Povoliť';
$string['allowinternal'] = 'Povoliť taktiež interné metódy';
$string['allownone'] = 'Nepovoliť nikoho';
$string['allownot'] = 'Nepovoliť';
$string['allowstealthmodules'] = 'Povoliť tajné aktivity';
$string['allowstealthmodules_help'] = 'Ak je táto možnosť povolená, aktivity sa dajú sprístupniť, ale nezobrazia sa vo viditeľných častiach stránky kurzu. Odkazy na tajné aktivity musia byť poskytnuté z iných zdrojov, napríklad aktivity typu stránka. Tajné aktivity sa ale zobrazujú v známkovom výkaze a v iných prehľadoch.';
$string['allparticipants'] = 'Všetci účastníci';
$string['allteachers'] = 'Všetci učitelia';
$string['alphanumerical'] = 'Môže obsahovať iba písmená abecedy, čísla, pomlčku (-) alebo bodku (.)';
$string['alreadyconfirmed'] = 'Registrácia už bola potvrdená';
$string['alternatename'] = 'Alternatívne meno';
$string['always'] = 'Vždy';
$string['and'] = '{$a->one} a {$a->two}';
$string['answer'] = 'Odpoveď';
$string['any'] = 'Ľubovoľný';
$string['appearance'] = 'Vzhľad';
$string['apply'] = 'Použiť';
$string['applyfilters'] = 'Použiť filtre';
$string['approve'] = 'Schváliť';
$string['areyousure'] = 'Ste si istý?';
$string['areyousuretorestorethis'] = 'Chcete pokračovať ďalej?';
$string['areyousuretorestorethisinfo'] = 'Neskôr v tomto procese bude možnosť pridávať zálohy do existujúceho kurzu alebo vytvoriť si kompletne nový kurz.';
$string['asc'] = 'Vzostupne';
$string['assessment'] = 'Ohodnotenie';
$string['assignadmins'] = 'Prideliť administrátorov';
$string['assigncreators'] = 'Prideliť tvorcov kurzov';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Prideliť role v rámci celého portálu';
$string['authenticateduser'] = 'Overený používateľ';
$string['authenticateduserdescription'] = 'Všetci prihlásení používatelia';
$string['authentication'] = 'Overovanie';
$string['authenticationplugins'] = 'Zásuvné moduly autentifikácie';
$string['autosubscribe'] = 'Auto-prihlasovanie do fóra';
$string['autosubscribeno'] = 'Nie: Neprihlasovať ma automaticky do diskusií';
$string['autosubscribeyes'] = 'Áno: Prihlásiť ma do diskusie, keď pošlem prvý príspevok';
$string['availability'] = 'Dostupnosť';
$string['availablecourses'] = 'Dostupné kurzy';
$string['back'] = 'Späť';
$string['backto'] = 'Späť na {$a}';
$string['backtocourselisting'] = 'Naspäť do zoznamu kurzov';
$string['backtohome'] = 'Návrat na domovskú stránku';
$string['backtopageyouwereon'] = 'Naspäť na stránku, kde ste boli';
$string['backup'] = 'Zálohovanie';
$string['backupactivehelp'] = 'Vyberte si, či chcete robiť automatizované zálohy';
$string['backupadhocpending'] = 'Prebieha úloha adhoc zálohovania kurzu';
$string['backupcancelled'] = 'Zálohovanie zrušené';
$string['backupcoursefileshelp'] = 'Ak povolené, tak potom súbory kurzov budú zahrnuté do automatických záloh.';
$string['backupdate'] = 'Dátum zálohovania';
$string['backupdatenew'] = '&nbsp; {$a->TAG} je teraz {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} bol {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detaily zálohovania';
$string['backuperrorinvaliddestination'] = 'Adresár pre zálohovanie neexistuje alebo nie je zapisovateľný.';
$string['backupexecuteathelp'] = 'Zvoľte si čas spustenia automatizovaných zálohovaní';
$string['backupfailed'] = 'Niektoré z Vašich kurzov neboli uložené!';
$string['backupfilename'] = 'záloha';
$string['backupfinished'] = 'Záloha prebehla úspešne';
$string['backupfromthissite'] = 'Bola záloha vytvorená v tomto portáli?';
$string['backupgradebookhistoryhelp'] = 'Ak je povolené, bude zaznamenávaná história úprav výkazu známok v automatizovaných zálohách. Poznámka: pre správnu funkcionalitu nesmie byť na serveri zakázaná história známok (disablegradehistory).';
$string['backupincludemoduleshelp'] = 'Vyberte, či chcete zahrnúť moduly kurzov, s alebo bez údajov používateľa, v automatických zálohách';
$string['backupincludemoduleuserdatahelp'] = 'Vyberte si, či chcete zahrnúť údaje používateľov v automatizovaných zálohovaniach';
$string['backupinfo'] = 'Vytvorte si kópiu tohto kurzu vrátane všetkého aktuálneho obsahu a aktivít. Záložný súbor môžete použiť na obnovenie tohto kurzu.';
$string['backuplogdetailed'] = 'Detailný záznam o vykonávaní';
$string['backuploglaststatus'] = 'Posledný záznam o vykonávaní';
$string['backupmissinguserinfoperms'] = 'Poznámka: táto záloha neobsahuje údaje používateľov. Aktivity cvičenie a tvorivá dielňa nebudú v tejto zálohe zahrnuté, pretože nie sú kompatibilné s týmto typom zálohy.';
$string['backupnext'] = 'Ďalšia záloha';
$string['backupnonisowarning'] = 'Pozor: táto záloha nie je v Unicode z verzie Moodle nižšej ako 1.6. Ak táto záloha obsahuje ľubovoľné texty v inom kódovaní ako iso-8859-1, je možné že jej obnova bude POŠKODENÁ. Viď <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> ohľadom informácií o správnom obnovení takejto zálohy.';
$string['backupnotyetrun'] = 'Čakanie na automatické zálohovanie';
$string['backuporiginalname'] = 'Názov zálohy';
$string['backuproleassignments'] = 'Priradenia rol pre tieto roly pri zálohovaní';
$string['backupsavetohelp'] = 'Celá cesta k adresáru, kde si chcete uložiť zálohované súbory.';
$string['backupsitefileshelp'] = 'Súbory portálu využívané v kurzoch budú zahrnuté v automatických zálohách.';
$string['backuptakealook'] = 'Prosím prezrite si Vaše záznamy o zálohovaniach: {$a}';
$string['backupuserfileshelp'] = 'Vyberte, či súbory používateľov (napr: obrázok v profile), majú byť zahrnuté do automatických záloh';
$string['backupversion'] = 'Verzia zálohy';
$string['badges'] = 'Odznaky';
$string['block'] = 'Blok';
$string['blockconfiga'] = 'Konfigurácia bloku: {$a}';
$string['blockconfigbad'] = 'Tento blok nebol správne vložený a tak nemôže poskytnúť konfiguračné rozhranie';
$string['blocks'] = 'Bloky';
$string['blocksaddedit'] = 'Pridať/Upraviť bloky';
$string['blockseditoff'] = 'Vypnúť úpravu blokov';
$string['blocksediton'] = 'Zapnúť úpravu blokov';
$string['blocksetup'] = 'Navrhnúť tabuľky blokov';
$string['blocksuccess'] = '{$a} tabuľky boli navrhnuté správne';
$string['brief'] = 'Stručný';
$string['bulkactions'] = 'Hromadné operácie';
$string['bulkactionselect'] = '{$a} výber hromadnej operácie';
$string['bulkcancel'] = 'Zavrieť hromadné úpravy';
$string['bulkmovecoursessuccess'] = 'Do kategórie {$a->category} bolo úspešne presunutých {$a->courses}  kurzov';
$string['bulkselection'] = 'Vybránné: {$a}';
$string['bycourseorder'] = 'Podľa poradia kurzov';
$string['byname'] = 'podľa {$a}';
$string['bypassed'] = 'Obídené';
$string['cachecontrols'] = 'Ovládanie cache pamäte';
$string['calltofeedback'] = 'Tvorcovia tohto softvéru by chceli vašu spätnú väzbu';
$string['calltofeedback_give'] = 'Poskytnúť spätnú väzbu o tomto softvéri';
$string['calltofeedback_remind'] = 'Pripomenúť neskôr';
$string['cancel'] = 'Zrušiť';
$string['cancelled'] = 'Zrušené';
$string['categories'] = 'Kategórie kurzov';
$string['categoriesandcourses'] = 'Kategórie kurzov a kurzy';
$string['category'] = 'Kategória';
$string['categoryadded'] = 'Kategória \'{$a}\' bola pridaná';
$string['categorybulkaction'] = 'Hromadné operácie pre vybrané kategórie';
$string['categorycontents'] = 'Podkategórie a kurzy';
$string['categorycurrentcontents'] = 'Obsah {$a}';
$string['categorydeleted'] = 'Kategória \'{$a}\' bola odstránená';
$string['categoryduplicate'] = 'Kategória nazvaná \'{$a}\' už existuje!';
$string['categoryheader'] = 'Menu kategórie';
$string['categoryhidden'] = '(skryté)';
$string['categorymodifiedcancel'] = 'Kategória bola zmenená! Zrušte operáciu a opakujte.';
$string['categoryname'] = 'Názov kategórie';
$string['categorypath'] = 'Cesta kategórie';
$string['categorysubcategoryof'] = '{$a->category} - podkategórie v {$a->parentcategory}';
$string['categoryupdated'] = 'Kategória \'{$a}\' bola aktualizovaná';
$string['changedpassword'] = 'Zmenené heslo';
$string['changepassword'] = 'Zmeniť heslo';
$string['changesmade'] = 'Vykonané zmeny';
$string['changesmadereallygoaway'] = 'Urobili ste zmeny. Naozaj chcete odísť preč a stratiť všetky zmeny?';
$string['changessaved'] = 'Zmeny uložené';
$string['check'] = 'Kontrolovať';
$string['checkactual'] = 'Aktuálny';
$string['checkall'] = 'Kontrolovať všetko';
$string['checkerror'] = 'Chyba pri získavaní výsledku kontroly "{$a}". Ďalšie informácie nájdete v konzole prehliadača.';
$string['checkexpected'] = 'Očakávaný';
$string['checkingbackup'] = 'Kontrola zálohy';
$string['checkingcourse'] = 'Kontrola kurzu';
$string['checkingforbbexport'] = 'Kontrola BlackBoard exportu';
$string['checkinginstances'] = 'Kontrola častí';
$string['checkingsections'] = 'Kontrola sekcií';
$string['checklanguage'] = 'Skontrolovať jazyk';
$string['checkloading'] = 'Získanie výsledku kontroly "{$a}"';
$string['checknone'] = 'Nekontrolovať nič';
$string['checks'] = 'Kontroly';
$string['checksok'] = 'Všetky "{$a}" kontroly sú v poriadku';
$string['childcoursenotfound'] = 'Nebol nájdený odvodený kurz!';
$string['childcourses'] = 'Odvodené kurzy';
$string['choose'] = 'Vybrať si';
$string['choosecourse'] = 'Vybrať kurz';
$string['choosedots'] = 'Vybrať ...';
$string['chooselivelogs'] = 'Alebo sledovať súčasnú činnosť';
$string['chooselogs'] = 'Vyberte si, ktoré pripojenia chcete vidieť';
$string['choosereportfilter'] = 'Vybrať si filter na správu';
$string['choosetheme'] = 'Vybrať tému';
$string['chooseuser'] = 'Vybrať používateľa';
$string['city'] = 'Mesto';
$string['cleaningtempdata'] = 'Vyčistiť dočasné údaje';
$string['clear'] = 'Vyčistiť';
$string['clearfilterrow'] = 'Odstrániť riadok filtra';
$string['clearfilters'] = 'Vymazať filtre';
$string['clearsearch'] = 'Vymazať vstup vyhľadávania';
$string['clickhelpiconformoreinfo'] = '... pokračovanie ... Kliknite na ikonu nápovedy pre prečítanie celého článku';
$string['clickhere'] = 'Kliknite sem ...';
$string['clicktochangeinbrackets'] = '{$a} (Kliknite pre zmenu)';
$string['clicktohideshow'] = 'Kliknite na rozbalenie alebo zbalenie';
$string['closeblockdrawer'] = 'Otvoriť panel bloku';
$string['closebuttontitle'] = 'Zavrieť';
$string['closecourseindex'] = 'Zavrieť index kurzu';
$string['closedrawer'] = 'Zavrieť lištu';
$string['closewindow'] = 'Zavrieť toto okno';
$string['collapse'] = 'Zbaliť';
$string['collapseall'] = 'Zbaliť všetko';
$string['collapsecategory'] = 'Zbaliť {$a}';
$string['comebacklater'] = 'Prosím vráťte sa neskôr.';
$string['commentincontext'] = 'Zobraziť túto poznámku v kontexte';
$string['comments'] = 'Poznámky';
$string['commentscount'] = 'Komentáre ({$a})';
$string['commentsnotenabled'] = 'Komentáre nie sú povolené';
$string['commentsrequirelogin'] = 'Pre prehliadanie komentárov sa potrebujete prihlásiť.';
$string['comparelanguage'] = 'Porovnať a upraviť súčasný jazyk';
$string['complete'] = 'Podrobný';
$string['completed'] = 'Dokončené';
$string['completereport'] = 'Podrobná správa';
$string['configuration'] = 'Konfigurácia';
$string['confirm'] = 'Potvrdiť';
$string['confirmaccount'] = 'Potvrdiť účet';
$string['confirmcheckfull'] = 'Naozaj chcete potvrdiť {$a}?';
$string['confirmcoursemove'] = 'Naozaj chcete presunúť kurz ({$a->course}) do kategórie ({$a->category})?';
$string['confirmdeletesection'] = 'Ste si úplne istý, že chcete definitívne vymazať "{$a}" vrátane všetkých aktivít?';
$string['confirmed'] = 'Vaša registrácia bola potvrdená';
$string['confirmednot'] = 'Vaša registrácia ešte nebola potvrdená! Skontrolujte si prosím potvrdzovací mail vo Vašej mailovej schránke';
$string['considereddigitalminor'] = 'Ste považovaný za digitálne maloletého pre vytvorenie účtu.';
$string['content'] = 'Obsah';
$string['contentbank'] = 'Banka obsahu';
$string['contentexport_aboutthiscourse'] = 'Sumár kurzu';
$string['contentexport_coursesummary'] = 'Tento súbor je súčasťou obsahu stiahnutého z  <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Tento súbor je súčasťou obsahu stiahnutého z <a href="{$a->courselink}">{$a->coursename}</a> od {$a->userfullname} dňa {$a->date}.';
$string['contentexport_modulesummary'] = 'Tento súbor je súčasťou obsahu stiahnutého z <a href="{$a->courselink}">{$a->coursename}</a> od {$a->userfullname} dňa {$a->date}.  Všimnite si, že se obsah a niektoré súbory väčšie než {$a->maxfilesize}  nie sú stiahnuté.';
$string['contentexport_viewfilename'] = 'Zobraziť súbor {$a}';
$string['context'] = 'Kontext';
$string['contextlevel'] = 'Úroveň kontextu';
$string['contextname'] = 'Názov kontextu';
$string['contextparent'] = 'Rodič';
$string['contexturl'] = 'URL kontextu';
$string['continue'] = 'Pokračovať';
$string['continuetocourse'] = 'Kliknite sem pre vstup do testu';
$string['convertingwikitomarkdown'] = 'Konvertovať Wiki do Markdown';
$string['cookiesenabled'] = 'Cookies musia byť zapnuté na Vašom prehliadači';
$string['cookiesenabled_help'] = 'Tieto stránky používajú dva súbory cookie.

Hlavným používaným súborom cookie je súbor session, ktorý sa obvykle nazýva
MoodleSession. Tento súbor cookie je treba povoliť v prehliadači,
zaisťuje kontinuitu vašej práce na portáli a udržuje informácie o vašom
prihlásení. Pri odhlásení alebo ukončení prehliadača je tento súbor cookie
odstránený jednak z prehliadača, ako aj zo serveru.

Druhý súbor cookie iba uľahčuje používateľovi prácu. Obvykle sa nazýva
MOODLEID. Slúži k zapamätaniu vášho používateľského mena v prehliadači.
To znamená, že pri návrate na tento portál bude pole s používateľským menom na
stránke prihlásenia už vyplnené. Tento súbor cookie je možné zakázať. Pri
každom prihlásení však budete musieť zadať svoje používateľské meno.';
$string['cookiesenabled_help_html'] = 'Na tomto portáli sa používajú dva súbory cookie:<br/><br/>

Týmto zásadným je súbor cookie relácie, obvykle nazývaný MoodleSession. Tento súbor cookie musíte vo svojom prehliadači povoliť, aby ste zaistili kontinuitu a zostali prihlásený pri prehliadaní stránok. Keď sa odhlásite alebo zatvoríte prehliadač, tento súbor cookie bude zničený (vo vašom prehliadači a na serveri).<br/><br/>

Ďalšia cookie je čisto pre pohodlie, obvykle sa nazýva MOODLEID alebo podobne. Pamätá si iba vaše používateľské meno v prehliadači. To znamená, že keď sa vrátite na túto stránku, pole používateľského mena na prihlasovacej stránke je už za vás vyplnené. Tento súbor cookie je bezpečné odmietnuť – pri každom prihlásení budete musieť znova zadať svoje používateľské meno.';
$string['cookiesenabledonlysession'] = 'Cookies musia byť zapnuté na Vašom prehliadači';
$string['cookiesenabledonlysession_help'] = 'Tento portál používa jednu reláciu cookie, obvykle nazvanú MoodleSession. Tento súbor cookie musíte vo svojom prehliadači povoliť, zaistiť kontinuitu a zostať pri prechádzaní stránok prihlásený. Pri odhlásení alebo zavretí prehliadača je tento súbor cookie vymazaný (vo Vašom prehliadači a na serveri).';
$string['cookiesnotenabled'] = 'Bohužiaľ, cookies nie sú zapnuté na Vašom prehliadači.';
$string['cookiesnotice'] = 'Upozornenie na cookie';
$string['copy'] = 'kopírovať';
$string['copyasnoun'] = 'kopírovanie';
$string['copycourse'] = 'Kopírovať kurz';
$string['copyingcoursefiles'] = 'Kopírujú sa súbory kurzu';
$string['copyingsitefiles'] = 'Kopírujú sa súbory portálu použité v kurze';
$string['copyinguserfiles'] = 'Kopírujú sa súbory používateľov';
$string['copyingzipfile'] = 'Kopírujú sa súbory zip';
$string['copyrightnotice'] = 'Upozornenie o autorských právach';
$string['copytoclipboard'] = 'Skopírovať do schránky';
$string['coresystem'] = 'Základný systém';
$string['cost'] = 'Náklady';
$string['costdefault'] = 'Východiskové náklady';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Krajina';
$string['course'] = 'Kurz';
$string['courseadministration'] = 'Administratíva kurzu';
$string['courseapprovedemail'] = 'Váš požadovaný kurz je schválený, <a href="{$a->url}">{$a->názov}</a> a vy ste {$a->učiteľ}.';
$string['courseapprovedemail2'] = 'Kurz, o vytvorenie ktorého ste požiadali, bol vytvorený: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Nepodarilo sa uložiť kurz ako schválený';
$string['courseapprovedsubject'] = 'Váš kurz bol schválený';
$string['courseavailable'] = 'Tento kurz je prístupný pre študentov';
$string['courseavailablenot'] = 'Tento kurz nie je prístupný pre študentov';
$string['coursebackup'] = 'Záloha kurzu';
$string['coursebulkaction'] = 'Hromadné operácie pre vybrané kurzy';
$string['coursecategories'] = 'Kategórie kurzu';
$string['coursecategory'] = 'Kategória kurzu';
$string['coursecategory_help'] = '<p>Váš Moodle administrátor môže zriadiť niekoľko kategórií kurzov.</p>

<p>Napríklad, "Veda", "Humanitné predmety", "Zdravie obyvateľstva" atď.</p>

<p>Vyberte si najvhodnejšiu pre váš kurz. Táto voľba ovplyvní, kde
bude váš kurz zobrazený. Toto môže napomôcť študentom pri nájdení
vášho kurzu.</p>';
$string['coursecategorydeleted'] = 'Vymazaná kategória kurzov {$a}';
$string['coursecatmanagement'] = 'Správa kurzov a kategórií';
$string['coursecompletion'] = 'Ukončenie kurzu';
$string['coursecompletions'] = 'Ukončenie kurzov';
$string['coursecreators'] = 'Tvorca kurzu';
$string['coursecreatorsdescription'] = 'Tvorcovia kurzov môžu vytvárať nové kurzy.';
$string['coursedeleted'] = 'Vymazaný kurz {$a}';
$string['coursedetails'] = 'Detaily kurzu';
$string['coursedisplay'] = 'Vzhľad kurzu';
$string['coursedisplay_help'] = 'Sekcie kurzu môžu byť zobrazené na jednej stránke alebo rozdelené na niekoľko stránok.';
$string['coursedisplay_multi'] = 'Zobraziť jednu sekciu na stránke';
$string['coursedisplay_single'] = 'Zobraziť všetky sekcie na stránke';
$string['courseduration'] = 'Dĺžka kurzu';
$string['courseduration_desc'] = 'Dĺžka kurzu sa používa pre vypočítanie posledného dňa kurzu. Posledný deň kurzu sa používa iba v protokoloch. Používatelia môžu vstúpiť do kurzu aj neskôr.';
$string['courseenddateenabled'] = 'Dátum ukončenia kurzu je štandardne povolený';
$string['courseenddateenabled_desc'] = 'Toto nastavenie určuje, či dátum ukončenia kurzu bude pre nové kurzy predvolene zapnutý a nastaví sa na dátum vypočítaný z trvania kurzu.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Súbory kurzu (zastaralé)';
$string['coursefilesedit'] = 'Upraviť  súbory kurzu';
$string['coursefileswarning'] = 'Súbory kurzu sú zastaralé';
$string['coursefileswarning_help'] = 'Súbory kurzu sú zastaralé od Moodle 2.0. Použite namiesto nich v čo najväčšej miere externé úložiská.';
$string['courseformatdata'] = 'Formát dát kurzu';
$string['courseformatoptions'] = 'Formátovacie voľby pre {$a}';
$string['courseformats'] = 'Formáty kurzu';
$string['courseformatudpate'] = 'Aktualizácia formátu';
$string['coursegrades'] = 'Známky v kurze';
$string['courseheader'] = 'Menu kurzu';
$string['coursehelpcategory'] = 'Umiestnenie kurzu v zozname kurzov pre jeho ľahšie nájdenie študentmi';
$string['coursehelpforce'] = 'Vnútiť režim skupín nastavený kurzom pre každú aktivitu.';
$string['coursehelpformat'] = 'Hlavná stránka kurzu bude zobrazená v tomto formáte';
$string['coursehelphiddensections'] = 'Spôsob zobrazenia skrytých sekcií kurzu študentom';
$string['coursehelpmaximumupload'] = 'Určenie najväčšej veľkosti súboru, ktorý môžu študenti nahrať na server. Je to obmedzené nastavením na portáli.';
$string['coursehelpnewsitemsnumber'] = 'Počet posledných oznámení zobrazených na domovskej stránke kurzu v bloku posledných oznámení. (0 znamená, že blok noviniek nebude zobrazený).';
$string['coursehelpnumberweeks'] = 'Počet sekcií v kurze (platí iba pre niektoré formáty kurzu).';
$string['coursehelpshowgrades'] = 'Povoliť zobrazenie známok. Nemá to ale vplyv na zobrazenie hodnotení v jednotlivých aktivitách.';
$string['coursehidden'] = 'Tento kurz je v súčasnosti pre študentov neprístupný';
$string['courseinfo'] = 'Informácie o kurze';
$string['courselegacyfiles'] = 'Súbory kurzu (zastaralé)';
$string['courselegacyfiles_help'] = 'Súbory kurzu poskytujú spätnú kompatibilitu s Moodle verziou 1.9 a staršou. Všetky súbory v tomto priestore sú vždy dostupné všetkým účastníkom (nezáleží na tom, či sa na ne odkazuje alebo nie). Tiež nie je žiaden spôsob zistiť, kde a ktoré súbory sú v Moodle použité.

Ak používate toto miesto na uloženie súborov kurzu, môžete mať problémy so súkromím a bezpečnosťou. Taktiež môžu chýbať v zálohách kurzov, importoch a nie je možné ich viacnásobne využívať. Je preto doporučené, aby ste tento priestor nepoužívali, ak presne neviete, čo robíte.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Súbory kurzu: {$a}';
$string['coursenotaccessible'] = 'Tento kurz nepovoľuje verejný prístup';
$string['courseoverview'] = 'Prehľad kurzu';
$string['courseoverviewfiles'] = 'Obrázok kurzu';
$string['courseoverviewfiles_help'] = 'Obrázok kurzu sa zobrazí v časti Moje kurzy a v zozname dostupných kurzov na úvodnej stránke. Správcovia stránok môžu povoliť ďalšie typy súborov a používanie viacerých súborov. Ak použijete viacero súborov, všetky sa zobrazia v zozname dostupných kurzov na domovskej stránke.';
$string['courseoverviewfilesext'] = 'Prípony súborov obrázku kurzu';
$string['courseoverviewfileslimit'] = 'Limit počtu súborov obrázkov kurzu';
$string['courseoverviewgraph'] = 'Graf prehľadu kurzu';
$string['courseprofiles'] = 'Profily kurzu';
$string['coursereasonforrejecting'] = 'Vaše dôvody pre neakceptovanie tejto žiadosti';
$string['coursereasonforrejectingemail'] = 'Toto bude mailované žiadateľovi';
$string['coursereject'] = 'Zamietnuť žiadosť o kurz';
$string['courserejected'] = 'Kurz bol zamietnutý a žiadateľ bol o tom informovaný.';
$string['courserejectemail'] = 'Žiaľ, Vaša žiadosť o kurz bola zamietnutá z nasledovného dôvodu

{$a}';
$string['courserejectreason'] = 'Vysvetlite svoje dôvody na zamietnutie žiadosti o kurz<br />(toto bude mailované žiadateľovi)';
$string['courserejectsubject'] = 'Váš kurz bol zamietnutý';
$string['coursereport'] = 'Výkaz kurzu';
$string['coursereports'] = 'Výkazy kurzu';
$string['courserequest'] = 'Žiadosť o vytvorenie nového kurzu';
$string['courserequestdetails'] = 'Podrobnosti o kurze, ktorý žiadate vytvoriť';
$string['courserequestfailed'] = 'Z nejakého dôvodu nemohla byť vaša žiadosť o vytvorenie kurzu uložená.';
$string['courserequestintro'] = 'Použite tento formulár na žiadosť o vytvorenie kurzu <br />Pokúste sa uviesť maximum informácií,<br />aby administrátor pochopil vašu žiadosť.';
$string['courserequestreason'] = 'Dôvody pre žiadosť o vytvorenie kurzu';
$string['courserequestroleerror'] = 'Rola tvorcov v konfigurácii nových kurzov je neplatná. Prečítajte si prosím <a href="{$a}">zásady pre používateľov</a>.';
$string['courserequestsuccess'] = 'Vaša žiadosť o kurz bola úspešne odoslaná.';
$string['courserequestsupport'] = 'Dodatočné informácie, ktoré by mohli pomôcť administrátorovi pri vyhodnotení Vašej požiadavky';
$string['courserequestwarning'] = 'Používateľ, ktorý žiada o zaradenie do tohto kurzu, bude automatický zaradený a bude mu pridelená rola {$a}.';
$string['courserestore'] = 'Obnoviť kurz zo zálohy';
$string['coursereuse'] = 'Opätovné použitie kurzu';
$string['coursereusenavigationmenu'] = 'Navigácia v ponuke opätovného použitia kurzu';
$string['courses'] = 'Kurzy';
$string['coursesearch'] = 'Vyhľadanie kurzov';
$string['coursesearch_help'] = 'Môžete vyhľadávať viaceré slovné spojenia naraz:

* slovo: vyhľadá toto slovo vo vnútri textu.
* +slovo: vyhľadá iba presný výraz.
* -slovo: nezobrazí výsledky obsahujúce toto slovo.';
$string['coursesectionsummaries'] = 'Súhrn sekcie kurzu';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Hromadná úprava {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Upraviť {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Východzie nastavenia kurzu';
$string['coursesmovedout'] = 'Kurzy boli presunuté z {$a}';
$string['coursespending'] = 'Kurzy, ktoré čakajú na schválenie';
$string['coursestart'] = 'Štart kurzu';
$string['coursesummary'] = 'Sumár kurzu';
$string['coursesummary_help'] = 'Krátky opis vášho kurzu. Obsah, ktorý sem pridáte, je možné vyhľadávať.';
$string['coursetitle'] = 'Kurz: {$a->course}';
$string['coursetitlebulkediting'] = 'Hromadná úprava kurzu: {$a->course}';
$string['coursetitleediting'] = 'Upraviť kurz: {$a->course}';
$string['courseupdates'] = 'Aktualizácia kurzov';
$string['coursevisibility'] = 'Viditeľnosť kurzu';
$string['coursevisibility_help'] = '* Zobraziť: Kurz sa zobrazí v zozname kurzov a študenti k nemu majú prístup
* Skryť: Prístup je obmedzený na učiteľov a ďalších používateľov s možnosťou zobraziť skryté kurzy.';
$string['create'] = 'Vytvoriť';
$string['createaccount'] = 'Vytvoriť moje nové konto';
$string['createcategory'] = 'Vytvoriť kategóriu';
$string['createfolder'] = 'Vytvoriť priečinok v {$a}';
$string['createnew'] = 'Vytvoriť novú';
$string['createnewcategory'] = 'Vytvoriť novú kategóriu';
$string['createnewcourse'] = 'Vytvoriť nový kurz';
$string['createnewsubcategory'] = 'Vytvoriť novú podkategóriu';
$string['createsubcategoryof'] = 'Vytvoriť podkategóriu v {$a}';
$string['createuser'] = 'Vytvoriť používateľa';
$string['createziparchive'] = 'Vytvoriť zip archív';
$string['creatingblocks'] = 'Vytvárajú sa bloky';
$string['creatingblocksroles'] = 'Vytvárajú sa blokové priradenia a prepisovanie rol';
$string['creatingblogsinfo'] = 'Vytváranie informácií k blogom';
$string['creatingcategoriesandquestions'] = 'Vytvárajú sa kategórie a otázky';
$string['creatingcoursemodules'] = 'Vytvárajú sa moduly kurzu';
$string['creatingcourseroles'] = 'Vytvárajú sa priradenia a prepisovanie rol kurzu';
$string['creatingevents'] = 'Vytvárajú sa udalosti';
$string['creatinggradebook'] = 'Vytvárajú sa knihy bodov';
$string['creatinggroupings'] = 'Vytvárajú sa zoskupenia';
$string['creatinggroupingsgroups'] = 'Pridávanie skupín do zoskupení';
$string['creatinggroups'] = 'Vytvárajú sa skupiny';
$string['creatinglogentries'] = 'Vytvárajú sa prihlasovacie zoznamy';
$string['creatingmessagesinfo'] = 'Vytvárajú sa informácie o správach';
$string['creatingmodroles'] = 'Vytvárajú sa priradenia a prepisovanie rol na úrovni modulu';
$string['creatingnewcourse'] = 'Vytvára sa nový kurz';
$string['creatingrolesdefinitions'] = 'Vytvárajú sa definície rol';
$string['creatingscales'] = 'Vytvárajú sa stupnice';
$string['creatingsections'] = 'Vytvárajú sa sekcie';
$string['creatingtemporarystructures'] = 'Vytvárajú sa dočasné štruktúry';
$string['creatinguserroles'] = 'Vytvárajú sa priradenia a prepisovanie rol na úrovni používateľov';
$string['creatingusers'] = 'Vytvárajú sa používatelia';
$string['creatingxmlfile'] = 'Vytvára sa XML súbor';
$string['currency'] = 'Mena';
$string['currentcourse'] = 'Aktuálny kurz';
$string['currentcourseadding'] = 'Aktuálny kurz, pridávajú sa do neho údaje';
$string['currentcoursedeleting'] = 'Aktuálny kurz, vymazáva sa ako prvý';
$string['currentlanguage'] = 'Aktuálny jazyk';
$string['currentlocaltime'] = 'Váš aktuálny miestny čas';
$string['currentpicture'] = 'Aktuálny obrázok';
$string['currentrelease'] = 'Informácia o aktuálnej verzii';
$string['currenttheme'] = 'Aktuálna téma';
$string['currentversion'] = 'Aktuálna verzia';
$string['databasechecking'] = 'Aktualizujem Moodle databázu z verzie {$a->oldversion} na {$a->newversion}';
$string['databaseperformance'] = 'Činnosť databázy';
$string['databasesetup'] = 'Nastavovanie databázy';
$string['databasesuccess'] = 'Databáza bola úspešne aktualizovaná';
$string['databaseupgradebackups'] = 'Zálohovaná verzia je momentálne {$a}';
$string['databaseupgradeblocks'] = 'Verzia blokov je momentálne {$a}';
$string['databaseupgradegroups'] = 'Verzia skupín je teraz {$a}';
$string['databaseupgradelocal'] = 'Verzia úprav lokálnej databázy je teraz {$a}';
$string['databaseupgrades'] = 'Aktualizácia databázy';
$string['dataformats'] = 'Formát údajov';
$string['date'] = 'Dátum';
$string['datechanged'] = 'Dátum zmenený';
$string['datemostrecentfirst'] = 'Dátum - aktuálny ako prvý';
$string['datemostrecentlast'] = 'Dátum - aktuálny ako posledný';
$string['day'] = 'deň';
$string['days'] = 'dni';
$string['decodinginternallinks'] = 'Dekódovanie interných linkov';
$string['default'] = 'Predvolené';
$string['defaultcategoryname'] = 'Kategória 1';
$string['defaultcompetencescale'] = 'Východzia stupnica kompetencie';
$string['defaultcompetencescaledesc'] = 'Binárna stupnica, ktorá neposkytuje ďalšie informácie nad rámec splnenia alebo nesplnenia.';
$string['defaultcompetencescalenotproficient'] = 'Nekvalifikovaný';
$string['defaultcompetencescaleproficient'] = 'Kvalifikovaný';
$string['defaultcoursestudent'] = 'Študent';
$string['defaultcoursestudentdescription'] = 'Študenti majú vo všeobecnosti v kurze menej oprávnení.';
$string['defaultcoursestudents'] = 'Študenti';
$string['defaultcoursesummary'] = 'Tu napíšte výstižný a zaujímavý odsek, ktorý vysvetľuje, o čom je tento kurz';
$string['defaultcourseteacher'] = 'Učiteľ';
$string['defaultcourseteacherdescription'] = 'Učitelia majú všetky právomoci v kurze vrátane zmien aktivít a hodnotenia študentov.';
$string['defaultcourseteachers'] = 'Učitelia';
$string['defaulteditor'] = 'Východzí editor';
$string['defaulthomepageuser'] = 'Domovská stránka';
$string['defaulthomepageuser_help'] = 'Na ktorú stránku by ste mali byť presmerovaní po prihlásení na portál?';
$string['delete'] = 'Odstrániť';
$string['deleteablock'] = 'Odstrániť blok';
$string['deleteall'] = 'Odstrániť všetko';
$string['deleteallcannotundo'] = 'Vymazať všetko - bez možnosti vrátiť sa späť';
$string['deleteallcomments'] = 'Vymazať všetky komentáre';
$string['deleteallratings'] = 'Vymazať všetky hodnotenia';
$string['deletecategory'] = 'Vymazať kategóriu: {$a}';
$string['deletecategorycheck'] = 'Naozaj chcete úplne odstrániť túto kategóriu<b>\'{$a}\'</b>?<br />
Týmto presuniete všetky kurzy do rodičovskej (nadradenej) kategórie, ak taká existuje, alebo do kategórie Rôzne.';
$string['deletecategorycheck2'] = 'Ak vymažete túto kategóriu, rozhodnite, čo urobíte z kurzmi a kategóriami kurzov, ktoré obsahuje.';
$string['deletecategoryempty'] = 'Táto kategória je prázdna';
$string['deletecheck'] = 'Odstrániť {$a} ?';
$string['deletecheckfiles'] = 'Naozaj chcete vymazať tieto súbory?';
$string['deletecheckfull'] = 'Ste si istý, že chcete definitívne vymazať používateľa {$a} vrátane jeho zaradení, aktivity a iných používateľských údajov?';
$string['deletechecktype'] = 'Naozaj chcete vymazať {$a->type}?';
$string['deletechecktypename'] = 'Naozaj chcete vymazať {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Chystáte sa odstrániť tieto súbory';
$string['deletecommentbyon'] = 'Odstrániť komentár zapísaný {$a->user} v {$a->time}';
$string['deletecompletely'] = 'Všetko odstrániť';
$string['deletecourse'] = 'Odstrániť kurz';
$string['deletecoursecheck'] = 'Naozaj chcete úplne odstrániť tento kurz a všetky údaje, ktoré obsahuje?';
$string['deleted'] = 'Odstránené';
$string['deletedactivity'] = 'Odstránená aktivita {$a}';
$string['deletedcourse'] = '{$a} bolo úplne odstránené';
$string['deletednot'] = 'Nemôže odstrániť {$a} !';
$string['deletepicture'] = 'Odstrániť';
$string['deletesection'] = 'Vymazať';
$string['deleteselected'] = 'Odstrániť vybraté';
$string['deleteselectedkey'] = 'Vymazať vybraný kľúč';
$string['deletingcourse'] = 'Odstraňovanie {$a}';
$string['deletingexistingcoursedata'] = 'Odstraňujú sa  údaje existujúceho kurzu';
$string['deletingolddata'] = 'Odstraňujú sa staré údaje';
$string['department'] = 'Oddelenie';
$string['deprecatedeventname'] = '{$a} (už sa nepoužíva)';
$string['desc'] = 'Zostupné';
$string['description'] = 'Opis';
$string['deselectall'] = 'Odznačiť všetko';
$string['deselectnos'] = 'Zrušiť výber všetkých \'Nie\'';
$string['detailedless'] = 'Menej detailný';
$string['detailedmore'] = 'Detailnejší';
$string['details'] = 'Podrobnosti';
$string['digitalminor'] = 'Digitálne maloletý';
$string['digitalminor_desc'] = 'Požiadajte svojho rodiča alebo zákonného zástupcu, aby kontaktoval:';
$string['directory'] = 'Adresár';
$string['disable'] = 'Deaktivovať';
$string['disabledcomments'] = 'Komentáre sú zakázané';
$string['dismissnotification'] = 'Toto oznámenie zrušiť';
$string['displayingfirst'] = 'Len prvých {$a->count} {$a->things} je zobrazených.';
$string['displayingrecords'] = 'Zobrazuje sa {$a} záznamov';
$string['displayingusers'] = 'Zobrazuje používateľov {$a->start} do {$a->end}';
$string['displayonpage'] = 'Zobraziť na stránke';
$string['dndcourse'] = 'Kurz môžete potiahnuť a zmeniť jeho poradie alebo presunúť do inej kategórie.';
$string['dndenabled_inbox'] = 'Pre nahranie súborov z vášho počítača ich potiahnite sem';
$string['dndnotsupported'] = 'Nahrávanie súborov ťahaním  myšou nie je podporované';
$string['dndnotsupported_help'] = 'Váš prehliadač nepodporuje ťahanie súborov myšou. Táto funkcia je dostupná vo všetkých najnovších verziách prehliadačov Chrome, Firefox, Safari a tiež aj Internet Explorer verzie 10 a vyššej.';
$string['dndnotsupported_insentence'] = 'Ťahanie súborov myšou nie je podporované';
$string['dnduploadwithoutcontent'] = 'Toto nahrávanie nemá žiadny obsah';
$string['dndworkingfile'] = 'Pre nahranie súborov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingfilelink'] = 'Pre nahranie súborov alebo odkazov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingfiletext'] = 'Pre nahranie súborov alebo textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingfiletextlink'] = 'Pre nahranie súborov, odkazov, alebo textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkinglink'] = 'Pre nahranie odkazov textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingtext'] = 'Pre nahranie textov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['dndworkingtextlink'] = 'Pre nahranie textov alebo odkazov ich stačí potiahnuť do príslušnej sekcie kurzu.';
$string['documentation'] = 'Moodle dokumentácia';
$string['dontsortcategories'] = 'Neradiť kategórie';
$string['dontsortcourses'] = 'Neradiť kurzy';
$string['down'] = 'Dolu';
$string['download'] = 'Stiahnuť';
$string['downloadall'] = 'Stiahnuť všetko';
$string['downloadexcel'] = 'Stiahnuť vo formáte Excel';
$string['downloadfile'] = 'Stiahnuť súbor';
$string['downloadods'] = 'Stiahnuť vo formáte ODS';
$string['downloadtext'] = 'Stiahnuť v textovom formáte';
$string['doyouagree'] = 'Prečítali ste si podmienky a porozumeli ste im?';
$string['droptoupload'] = 'Pre nahranie súborov ich potiahnite sem';
$string['duplicate'] = 'Duplikát';
$string['duplicatedmodule'] = '{$a} (kópia)';
$string['duplicatedsection'] = '{$a} (kópia)';
$string['edhelpaspellpath'] = 'Pre použitie kontroly pravopisu v editore MUSÍTE mať nainštalovaný na vašom serveri <strong>aspell 0.50</strong>, alebo novší a musíte určiť správnu cestu ku binárnemu súboru aspell. Na Unix-Linux systémoch je táto cesta obyčajne <strong>/usr/bin/aspell</strong>, ale je možné že to bude inak.';
$string['edhelpbgcolor'] = 'Definovať farbu pozadia editora.<br />Platné hodnoty sú napríklad:#ffffff alebo biela';
$string['edhelpcleanword'] = 'Toto nastavenie aktivuje alebo deaktivuje špecifický formát filtrovania Wordu.';
$string['edhelpenablespelling'] = 'Aktivovať alebo deaktivovať kontrolu pravopisu. Ak je voľba aktivovaná,<strong>aspell</strong> musí byť nainštalovaný na serveri. Druhá hodnota je <strong>default dictionary</strong>. Táto hodnota bude použitá vtedy, ak aspell nemá slovník pre vlastný zvolený jazyk používateľa.';
$string['edhelpfontfamily'] = 'Vlastnosti príbuzných fontov je zoznam názvov príbuzných fontov a/alebo druhových mien. Príbuzné názvy musia byť oddelené čiarkou.';
$string['edhelpfontlist'] = 'Definovať fonty použité v roletovom editovacom menu.';
$string['edhelpfontsize'] = 'Východiskové nastavenie veľkosti fontu nastavuje veľkosť fontu.<br />Platné hodnoty sú napríklad: stredná, veľká, menšia, väčšia, 10pt, 11px.';
$string['edit'] = 'Upraviť';
$string['edita'] = 'Upraviť {$a}';
$string['editcategorysettings'] = 'Upraviť nastavenia kategórie';
$string['editcategorythis'] = 'Upraviť túto kategóriu';
$string['editcoursesettings'] = 'Upraviť nastavenia kurzu';
$string['editfiles'] = 'Upraviť súbory';
$string['editgroupprofile'] = 'Upraviť profil skupiny';
$string['editinga'] = 'Upraviť {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Túto hodnotu nemôžete upravovať!';
$string['editmode'] = 'Režim úprav';
$string['editmyprofile'] = 'Upraviť profil';
$string['editorbgcolor'] = 'Farba pozadia';
$string['editorcleanonpaste'] = 'Prilepiť v čistom Word HTML formáte';
$string['editorcommonsettings'] = 'Bežné nastavenia';
$string['editordefaultfont'] = 'Východiskový font';
$string['editorenablespelling'] = 'Aktivovať kontrolu pravopisu';
$string['editorfontlist'] = 'Zoznam fontov';
$string['editorfontsize'] = 'Východisková veľkosť fontu';
$string['editorpreferences'] = 'Preferencie editora';
$string['editorresettodefaults'] = 'Obnoviť východiskové hodnoty';
$string['editorsettings'] = 'Nastavenia editora';
$string['editorshortcutkeys'] = 'Klávesové skratky editora';
$string['editsection'] = 'Upraviť nastavenia';
$string['editsectionname'] = 'Zmeniť názov sekcie';
$string['editsectionsettings'] = 'Upraviť nastavenia sekcie';
$string['editsectiontitle'] = 'Upraviť sekciu: {$a}';
$string['editsettings'] = 'Upraviť nastavenia';
$string['editsummary'] = 'Upraviť zhrnutie';
$string['editthisactivity'] = 'Upraviť túto aktivitu';
$string['editthiscategory'] = 'Upraviť túto kategóriu';
$string['edittitle'] = 'Upraviť názov';
$string['edittitleinstructions'] = 'Pre zrušenie stlačte Escape, pre dokončenie Enter';
$string['edituser'] = 'Upraviť používateľské kontá';
$string['edulevel'] = 'Všetky udalosti';
$string['edulevel_help'] = '* Výuka - akcie vykonávané učiteľom, napr. aktualizácia zdrojov
* Účasť - akcie vykonávané študentom, napr. diskusný príspevok
* Ostatné - akcie vykonávané používateľom s inou rolou ako učiteľ alebo študent';
$string['edulevelother'] = 'Iné';
$string['edulevelparticipating'] = 'Zúčastnený';
$string['edulevelteacher'] = 'Vyučovanie';
$string['email'] = 'Emailová adresa';
$string['emailactive'] = 'Aktivovaný email';
$string['emailagain'] = 'Email (znovu)';
$string['emailalreadysent'] = 'E-mail s obnovením hesla bol odoslaný. Skontrolujte prosím Váš e-mail.';
$string['emailcharset'] = 'Znaková sada mailu';
$string['emailconfirm'] = 'Potvrďte Vaše konto';
$string['emailconfirmation'] = 'Dobrý deň,

požiadali ste o vytvorenie nového konta na \'{$a->sitename}\' použitím Vašej emailovej adresy.

Na potvrdenie Vášho nového konta choďte prosím na nasledujúcu webovú adresu:

{$a->link}

Vo väčšine emailových programov by sa mala objaviť ako modrý odkaz, na ktorý stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna Vášho web prehliadača.

Ak potrebujete akúkoľvek pomoc, prosím kontaktujte administrátora stránky, {$a->admin}';
$string['emailconfirmationresend'] = 'Znova odoslať potvrdzovací e-mail';
$string['emailconfirmationsubject'] = '{$a}: potvrdenie konta';
$string['emailconfirmsent'] = '<p>Na Vašu emailovú adresu by mal byť odoslaný email <b>{$a}</b></p>

<p>Obsahuje jednoduchý návod na dokončenie Vašej registrácie.</p>

<p>Ak problémy pretrvávajú, kontaktujte administrátora stránky.</p>';
$string['emailconfirmsentfailure'] = 'Potvrdzovací e-mail sa nepodarilo odoslať';
$string['emailconfirmsentsuccess'] = 'Potvrdzovací e-mail bol úspešne odoslaný';
$string['emaildigest'] = 'Štruktúrovaný typ emailu';
$string['emaildigest_help'] = 'Toto je denný súhrn nových príspevkov nastavených v diskusných fórach ako východzie.

* Bez súhrnu - dostanete e-mail pri každom príspevku;
* Súhrn - kompletné príspevky - dostanete jeden súhrnný e-mail denne obsahujúci kompletný obsah každého príspevku do fóra;
* Súhrn - iba predmety - dostanete jeden súhrnný e-mail denne obsahujúci iba predmet každého príspevku do fóra.

V každom diskusnom fóre si môžete vybrať iné nastavenie.';
$string['emaildigestcomplete'] = 'Kompletný (denne so všetkými príspevkami)';
$string['emaildigestoff'] = 'Neštruktúrovaný (jednoduchý email s príspevkami z fór)';
$string['emaildigestsubjects'] = 'Predmety (denne len s predmetmi)';
$string['emaildisable'] = 'Táto emailová adresa je neaktívna';
$string['emaildisableclick'] = 'Kliknite sem pre deaktiváciu všetkých emailov, ktoré dostávate na Vašu adresu';
$string['emaildisplay'] = 'Viditeľnosť emailov';
$string['emaildisplay_help'] = '* Skryté - vašu e-mailovú adresu môžu zobraziť len používatelia s príslušnými oprávneniami, napríklad učitelia.
* Viditeľné pre všetkých - Vašu e-mailovú adresu môžu vidieť všetci používatelia na portáli.
* Viditeľná pre účastníkov kurzov - Vašu e-mailovú adresu si môžu pozrieť len účastníci kurzov, v ktorých ste zapísaní.';
$string['emaildisplaycourse'] = 'Viditeľné pre účastníkov kurzu';
$string['emaildisplaycoursemembersonly'] = '(Viditeľné pre ostatných účastníkov kurzu)';
$string['emaildisplayeveryone'] = '(Viditeľné pre všetkých)';
$string['emaildisplayhide'] = '(Skryté pre všetkých okrem používateľov s príslušnými oprávneniami)';
$string['emaildisplayno'] = 'Skryté';
$string['emaildisplayyes'] = 'Viditeľné pre všetkých';
$string['emailenable'] = 'Táto emailová adresa je aktivovaná';
$string['emailenableclick'] = 'Kliknite sem pre opätovnú aktiváciu zasielania všetkých mailov na túto adresu.';
$string['emailexists'] = 'Táto emailová adresa je už zaregistrovaná.';
$string['emailexistshintlink'] = 'Obnoviť zabudnuté meno alebo heslo.';
$string['emailexistssignuphint'] = 'Možno ste vytvorili konto v minulosti. {$a}';
$string['emailformat'] = 'Emailový formát';
$string['emailmustbereal'] = 'Pozor: Vaša emailová adresa musí byť skutočná';
$string['emailnotallowed'] = 'Emailové adresy v týchto doménach nie sú povolené ({$a})';
$string['emailnotfound'] = 'Tento email nebol nájdený v databáze';
$string['emailonlyallowed'] = 'Tento email nemôže byť použitý. Povolené domény sú {$a}';
$string['emailpasswordchangeinfo'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne vy) požaduje zmenu hesla k Vášmu účtu na stránkach  \'{$a->sitename}\'.

Vaše heslo zmeníte na stránke:

{$a->link}

Vo väčšine emailových programov by sa mala objaviť ako modrý odkaz, na ktorý stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna Vášho web prehliadača.

Ak potrebujete pomoc, obráťte sa na správcu týchto stránok:
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne vy) požaduje zmenu hesla k Vášmu účtu na stránkach  \'{$a->sitename}\'.

Vaše konto je však zablokované a nemôže byť resetované. Obráťte sa na správcu tohto portálu: {$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne vy) požaduje zmenu hesla k Vášmu účtu na stránkach  \'{$a->sitename}\'.

Na týchto stránkach bohužiaľ nie je možné zmeniť heslo, spojte sa so správcom:
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Zmeniť informáciu hesla';
$string['emailpasswordconfirmation'] = 'Dobrý deň {$a->firstname},

Niekto (pravdepodobne Vy) si vyžiadal nové heslo pre Vaše konto na \'{$a->sitename}\'.

Aby ste to potvrdili a dostali nové heslo e-mailom, navštívte nasledovnú www stránku:

{$a->link}

Vo väčšine emailových programov, by sa mala objaviť ako modrá linka, na ktorú stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna Vášho web prehliadača.

Ak potrebujete akúkoľvek pomoc, kontaktujte prosím  administrátora siete,
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: potvrdenie zmeny hesla';
$string['emailpasswordconfirmmaybesent'] = '<p>Ak ste zadali správne meno alebo unikátnu e-mailovú adresu, mali by ste dostať e-mail.</p>
<p>Obsahuje jednoduché pokyny na potvrdenie a ukončenie zmeny hesla.
Ak budú vaše problémy pokračovať, kontaktujte administrátora portálu.</p>';
$string['emailpasswordconfirmnoemail'] = '<p> Zadaný používateľský účet nemá zadanú e-mailovú adresu. </p><p> Kontaktujte správcu portálu. </p>';
$string['emailpasswordconfirmnotsent'] = '<p>Údaje o používateľovi sa nezhodujú so žiadnym existujúcim účtom</p>
<p>Skontrolujte zadané informácie a opakujte to znovu. Ak Váš problém pretrváva, kontaktujte administrátora.</p>';
$string['emailpasswordconfirmsent'] = 'Na Vašu emailovú adresu by mal byť odoslaný email<b>{$a}</b><br />
Obsahuje jednoduchý návod na potvrdenie a kompletizáciu procesu zmeny hesla.
Ak problémy pretrvávajú, kontaktujte administrátora stránky.';
$string['emailpasswordsent'] = 'Ďakujeme, že ste potvrdili zmenu hesla.

Na Vašu emailovú adresu by mal byť odoslaný email potvrdzujúci Vaše nové heslo<br />
<b>{$a->email}</b>.<br />
Nové heslo bolo automaticky generované - možno si ho budete chcieť <a href="{$a->link}">zmeniť</a> na ľahšie zapamätateľné.';
$string['emailresetconfirmation'] = 'Dobrý deň {$a->firstname},

pre používateľský účet \'{$a->username}\' na {$a->sitename} bola vytvorená žiadosť o zmenu hesla.

Pre potvrdenie a nastavenie nového hesla pre Vaše konto, kliknite na nasledujúci odkaz: <a href="{$a->link}">{$a->link}</a>

(Tento odkaz platí {$a->resetminutes} minút od vyžiadanie zmeny hesla)

Ak ste o zmenu hesla nežiadali, žiadna činnosť nie je potrebná.

V prípade, že potrebujete pomoc, kontaktujte administrátora,
{$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: žiadosť o zmenu hesla';
$string['emailresetconfirmsent'] = 'Na Váš email bol o <b>{$a}</b> odoslaný email.
<br />Obsahuje jednoduché inštrukcie pre potvrdenie a dokončenie zmeny hesla. Ak Váš problém naďalej pretrváva, kontaktujte administrátora.';
$string['emailstop'] = 'Zakázať upozornenia';
$string['emailtoprivatefiles'] = 'Môžete poslať súbory ako prílohy emailu. Jednoducho ich priložte do emailu a odošlite na {$a}.';
$string['emailtoprivatefilesdenied'] = 'Váš administrátor zakázal možnosť nahrávania vlastných, súkromných súborov.';
$string['emailvia'] = '{$a->name} cez {$a->siteshortname}';
$string['emojicategoryactivities'] = 'Činnosti';
$string['emojicategoryanimalsnature'] = 'Zvieratá a príroda';
$string['emojicategoryflags'] = 'Vlajky';
$string['emojicategoryfooddrink'] = 'Jedlo a pitie';
$string['emojicategoryobjects'] = 'Predmety';
$string['emojicategorypeoplebody'] = 'Ľudia a telo';
$string['emojicategoryrecent'] = 'Nedávne';
$string['emojicategorysmileysemotion'] = 'Smajlíky a emócie';
$string['emojicategorysymbols'] = 'Symboly';
$string['emojicategorytravelplaces'] = 'Cestovanie a miesta';
$string['emptycmids'] = 'ID prázdneho modulu kurzu';
$string['emptydragdropregion'] = 'prázdna oblasť';
$string['emptysectionids'] = 'ID prázdnej sekcie';
$string['enable'] = 'Aktivovať';
$string['encryptedcode'] = 'Šifrovací kód';
$string['enddate'] = 'Posledný deň kurzu';
$string['enddate_help'] = 'Dátum ukončenia neobmedzuje prístup študentov ku kurzu. Určuje, či je kurz uvedený v časti Moje kurzy ako uplynulý.';
$string['enddatewithtaskenabled'] = 'Dátum ukončenia kurzu';
$string['enddatewithtaskenabled_help'] = 'Dátum, kedy je kurz skrytý pre študentov a tí k nemu už nemajú prístup.';
$string['english'] = 'Angličtina';
$string['enrolmentmethods'] = 'Metódy zápisu';
$string['entercourse'] = 'Kliknite pre vstup do tohto kurzu';
$string['enteremail'] = 'Vložte Vašu emailovú adresu';
$string['enteremailaddress'] = 'Vložte Vašu emailovú adresu na obnovu Vášho hesla. Nové heslo Vám bude zaslané emailom.';
$string['enterusername'] = 'Vložte Vaše používateľské meno';
$string['entries'] = 'Záznamy';
$string['error'] = 'Chyba';
$string['errorcreatingactivity'] = 'Nie je možné vytvoriť inštanciu aktivity \'{$a}\'';
$string['errorfiletoobig'] = 'Súbor bol väčší ako povolené maximum {$a} bytov';
$string['errornouploadrepo'] = 'Pre tento portál nie je povolený žiadne úložisko';
$string['errorwhenconfirming'] = 'Vaše údaje ešte nie sú potvrdené, pretože sa vyskytla chyba. Ak ste klikli na odkaz v emaili, aby ste sa tam dostali, ubezpečte sa, že riadok nebol porušený. Na zopakovanie voľby použite funkcie \'vystrihnúť\' a \'prilepiť\', aby ste dosiahli správne fungovanie odkazu.';
$string['eventcommentcreated'] = 'Komentár bol vytvorený';
$string['eventcommentdeleted'] = 'Komentár bol vymazaný';
$string['eventcommentsviewed'] = 'Zobrazené komentáre';
$string['eventconfiglogcreated'] = 'Vytvorený protokol komunikácie';
$string['eventcontentviewed'] = 'Zobrazený obsah';
$string['eventcoursebackupcreated'] = 'Záloha kurzu vytvorená';
$string['eventcoursecategorycreated'] = 'Kategória bola vytvorená';
$string['eventcoursecategorydeleted'] = 'Kategória bola vymazaná';
$string['eventcoursecategoryupdated'] = 'Kategória bola aktualizovaná';
$string['eventcoursecategoryviewed'] = 'Kategória bola zobrazená';
$string['eventcoursecontentdeleted'] = 'Obsah kurzu bol vymazaný';
$string['eventcoursecreated'] = 'Kurz bol vytvorený';
$string['eventcoursedeleted'] = 'Kurz bol odstránený';
$string['eventcourseended'] = 'Kurz skončil';
$string['eventcourseinformationviewed'] = 'Obsah kurzu bol zobrazený';
$string['eventcoursemodulecreated'] = 'Modul kurzu bol vytvorený';
$string['eventcoursemoduledeleted'] = 'Modul kurzu bol odstránený';
$string['eventcoursemoduleinstancelistviewed'] = 'Zobrazený zoznam inštancií modulov kurzu';
$string['eventcoursemoduleupdated'] = 'Modul kurzu bol aktualizovaný';
$string['eventcoursemoduleviewed'] = 'Zobrazené moduly kurzu';
$string['eventcourseresetended'] = 'Resetovanie kurzu bolo ukončené';
$string['eventcourseresetstarted'] = 'Resetovanie kurzu bolo začaté';
$string['eventcourserestored'] = 'Kurz bol obnovený';
$string['eventcoursesectioncreated'] = 'Sekcia kurzu vytvorená';
$string['eventcoursesectiondeleted'] = 'Sekcia kurzu bola odstránená';
$string['eventcoursesectionupdated'] = 'Sekcia kurzu bola aktualizovaná';
$string['eventcoursessearched'] = 'Vyhľadané kurzy';
$string['eventcoursestarted'] = 'Kurz začal';
$string['eventcourseupdated'] = 'Kurz bol aktualizovaný';
$string['eventcourseuserreportviewed'] = 'Zobrazené';
$string['eventcourseviewed'] = 'Kurz bol prehliadnutý';
$string['eventdashboardreset'] = 'Reset nástenky';
$string['eventdashboardsreset'] = 'Reset násteniek';
$string['eventdashboardviewed'] = 'Zobrazená nástenka';
$string['eventdatabasetextfieldcontentreplaced'] = 'Globálne vyhľadávanie a nahradzovanie v databáze';
$string['eventemailfailed'] = 'Email nebol odoslaný';
$string['eventmycoursesviewed'] = 'Moje kurzy zobrazené';
$string['eventname'] = 'Názov udalosti';
$string['eventrecentactivityviewed'] = 'Zobrazená posledná aktivita';
$string['eventsearchindexed'] = 'Hľadané údaje boli indexované';
$string['eventsearchresultsviewed'] = 'Výsledky vyhľadávania boli zobrazené';
$string['eventsectionviewed'] = 'Sekcia zobrazená';
$string['eventunknownlogged'] = 'Neznáma udalosť';
$string['eventurlblocked'] = 'Adresa URL bola zablokovaná';
$string['eventusercreated'] = 'Používateľ bol vytvorený';
$string['eventuserdeleted'] = 'Používateľ bol odstránený';
$string['eventuserfeedbackgiven'] = 'Kliknuté na odkaz pre spätnú väzbu';
$string['eventuserfeedbackremind'] = 'Pripomenúť neskôr pre kliknutie na odkaz na spätnú väzbu';
$string['eventuserinfocategorycreated'] = 'Bola vytvorená kategória poľa profilu používateľa';
$string['eventuserinfocategorydeleted'] = 'Kategória poľa profilu používateľa bola odstránená';
$string['eventuserinfocategoryupdated'] = 'Kategória poľa profilu používateľa bola aktualizovaná';
$string['eventuserinfofieldcreated'] = 'Bolo vytvorené používateľské pole profilu';
$string['eventuserinfofielddeleted'] = 'Používateľské pole profilu bolo odstránené';
$string['eventuserinfofieldupdated'] = 'Používateľské pole profilu bolo aktualizované';
$string['eventuserlistviewed'] = 'Zobrazený zoznam používateľov';
$string['eventuserloggedout'] = 'Používateľ sa odhlásil';
$string['eventuserpasswordpolicyfailed'] = 'Heslo používateľa nespĺňa zásady bezpečných hesiel';
$string['eventuserpasswordupdated'] = 'Používateľské heslo bolo aktualizované';
$string['eventuserprofileviewed'] = 'Zobrazený používateľský profil';
$string['eventuserupdated'] = 'Používateľ bol aktualizovaný';
$string['everybody'] = 'Každý';
$string['executeat'] = 'Vykonať';
$string['existing'] = 'Existujúci';
$string['existingadmins'] = 'Existujúci administrátori';
$string['existingcourse'] = 'Existujúci kurz';
$string['existingcourseadding'] = 'Existujúci kurz, pripojiť k nemu údaje';
$string['existingcoursedeleting'] = 'Existujúci kurz, najprv ho vymazať';
$string['existingcreators'] = 'Existujúci tvorcovia kurzov';
$string['existingstudents'] = 'Zapísaní študenti';
$string['existingteachers'] = 'Existujúci učitelia';
$string['expand'] = 'Rozbaliť';
$string['expandall'] = 'Rozbaliť všetko';
$string['expandcategory'] = 'Rozbaliť {$a}';
$string['explanation'] = 'Vysvetlenie';
$string['explanationdigitalminor'] = 'Tieto informácie sú potrebné aby sme zistili, či je váš vek dostatočný na to, aby ste udelili digitálny súhlas. Je to vek, kedy môže jednotlivec súhlasiť s podmienkami a jeho údaje môžu byť legálne ukladané a spracovávané.';
$string['extendperiod'] = 'Čas predĺženia';
$string['extendsession'] = 'Predĺžiť reláciu';
$string['failedloginattempts'] = '{$a->attempts} neúspešných pokusov o prihlásenie do systému od Vášho posledného prihlásenia';
$string['failedtaskbody'] = '<p>Dobrý deň {$a->firstname},</p> <p>Úloha <b>{$a->taskname}</b> niekoľkokrát zlyhala a vyžaduje pozornosť.</p> <p><a href="{$a->link}">Zobraziť úlohu</a></p>';
$string['failedtaskcontexturlname'] = 'Správa o stave';
$string['failedtasksubject'] = 'Úloha se nepodarila: {$a}';
$string['favourites'] = 'Označené hviezdičkou ako obľúbené';
$string['feedback'] = 'Spätná väzba';
$string['file'] = 'Súbor';
$string['fileexists'] = 'Súbor s názvom {$a} už existuje';
$string['filemissing'] = '{$a} chýba';
$string['filereaderror'] = 'Súbor "{$a}" nie je možné prečítať. Skontrolujte prosím, či je to naozaj súbor a nie priečinok.';
$string['files'] = 'Súbory';
$string['filesanduploads'] = 'Súbory a nahrávanie';
$string['filesfolders'] = 'Súbory/priečinky';
$string['fileuploadwithcontent'] = 'Neočakávaný parameter "content" pri nahrávaní súboru';
$string['filloutallfields'] = 'Vyplňte prosím všetky políčka tohto formulára';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filtre';
$string['filtersetmatchdescription'] = 'Ako by malo byť kombinovaných viacero filtrov';
$string['filtertype'] = 'Typ filtra';
$string['findmorecourses'] = 'Vyhľadaj ďalšie kurzy';
$string['first'] = 'Prvý';
$string['firstaccess'] = 'Prvý prístup';
$string['firstname'] = 'Krstné meno';
$string['firstnamephonetic'] = 'Krstné meno - foneticky';
$string['firstpage'] = 'Prvá stránka';
$string['firstsiteaccess'] = 'Prvý prístup ku stránke';
$string['firsttime'] = 'Ste tu prvý raz?';
$string['folder'] = 'Priečinok';
$string['folderclosed'] = 'Zavretý priečinok';
$string['folderopened'] = 'Otvorený priečinok';
$string['followingoptional'] = 'Nasledujúce položky sú nepovinné';
$string['followingrequired'] = 'Nasledujúce položky sú povinné';
$string['for'] = 'Pre';
$string['force'] = 'Vyžadovať';
$string['forcelanguage'] = 'Preferovať určitý jazyk';
$string['forceno'] = 'Nenastaviť';
$string['forcepasswordchange'] = 'Vyžadovať zmenu hesla';
$string['forcepasswordchange_help'] = 'Vyzvať používateľa na zmenu hesla pri ďalšom prihlásení.';
$string['forcepasswordchangecheckfull'] = 'Naozaj chcete vynútiť zmenu hesla pre {$a}?';
$string['forcepasswordchangenot'] = 'Nepodarilo sa vynútiť zmenu hesla pre {$a}';
$string['forcepasswordchangenotice'] = 'Pre pokračovanie je nutné zmeniť heslo';
$string['forcepasswordresetfailurenotice'] = 'Vaše aktuálne heslo už nespĺňa nastavené zásady pre heslá. Požiadajte o pomoc svojho Moodle administrátora
{$a}';
$string['forcepasswordresetnotice'] = 'Vaše aktuálne heslo už nespĺňa nastavené zásady pre heslá, musíte ho resetovať.
{$a}';
$string['forcetheme'] = 'Vnútiť tému';
$string['forgotaccount'] = 'Zabudli ste heslo?';
$string['forgotten'] = 'Zabudli ste používateľské meno a heslo?';
$string['forgottenduplicate'] = 'Táto emailová adresa je zdieľaná viacerými účtami, prosím použite používateľské meno';
$string['forgotteninvalidurl'] = 'Neplatné heslo - reset URL';
$string['format'] = 'Formát';
$string['format_help'] = 'Formát kurzu určuje rozloženie stránky kurzu.

* Jedna aktivita - kurz obsahuje len jednu aktivitu alebo zdroj.
* Spoločenský - Kurz je sústredený okolo hlavného fóra na stránke kurzu. Ďalšie aktivity a zdroje možno pridať pomocou bloku Sociálne aktivity.
* Vlastné sekcie - Kurz je rozdelený na prispôsobiteľné sekcie.
* Týždenné sekcie - Kurz je rozdelený na sekcie zodpovedajúce každému týždňu, počnúc dátumom začiatku kurzu.';
$string['formathtml'] = 'HTML formát';
$string['formatmarkdown'] = 'Markdown formát';
$string['formatplain'] = 'Textový formát';
$string['formattext'] = 'Moodle auto-formát';
$string['forumpreferences'] = 'Preferencie fóra';
$string['framesetinfo'] = 'Dokument v rámcoch obsahuje:';
$string['from'] = 'Od';
$string['fromdate'] = 'Od';
$string['fromsender'] = 'Od';
$string['frontpagecategorycombo'] = 'Combo zoznam';
$string['frontpagecategorynames'] = 'Zobraziť zoznam kategórii';
$string['frontpagecourselist'] = 'Zobraziť zoznam kurzov';
$string['frontpagecoursesearch'] = 'Pole pre vyhľadávanie kurzu';
$string['frontpagedescription'] = 'Sumár titulnej stránky';
$string['frontpagedescriptionhelp'] = 'Tento text bude zobrazený na hlavnej stránke pri použití súhrnu kurzu/stránky.';
$string['frontpageenrolledcourselist'] = 'Zapísané kurzy';
$string['frontpageformat'] = 'Formát hlavnej stránky';
$string['frontpageformatloggedin'] = 'Formát hlavnej stránky pri prihlásení';
$string['frontpagenews'] = 'Oznámenia';
$string['frontpagesettings'] = 'Nastavenia hlavnej stránky';
$string['fulllistofcourses'] = 'Všetky kurzy';
$string['fullname'] = 'Celý názov';
$string['fullnamecourse'] = 'Celý názov kurzu';
$string['fullnamecourse_help'] = 'Názov kurzu zobrazený v časti Moje kurzy a tiež v zozname kurzov na domovskej stránke.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Celé meno';
$string['fullprofile'] = 'Celý profil';
$string['fullsitename'] = 'Celý názov stránky';
$string['functiondisabled'] = 'Táto funkcia je momentálne neaktívna';
$string['general'] = 'Všeobecné';
$string['geolocation'] = 'zemepisná šírka - dĺžka';
$string['gettheselogs'] = 'Získať tieto logy';
$string['go'] = 'Ísť';
$string['gpl'] = 'Copyright (C) 1999 onwards Martin Dougiamas (https://moodle.com)

Tento program je slobodný softvér; môžete ho šíriť a/alebo upravovať podľa podmienok Všeobecnej verejnej licencie GNU, ako ju vydala Nadácia slobodného softvéru (Free Software Foundation); buď podľa verzie 2 licencie, alebo (podľa vášho výberu) podľa akejkoľvek novšej verzie.

Tento program sa šíri v nádeji, že bude užitočný, ale BEZ AKEJKOĽVEK ZÁRUKY; dokonca ani bez implicitnej záruky PREDAJNOSTI alebo VHODNOSTI NA KONKRÉTNY ÚČEL.

Všetky podrobnosti nájdete na informačnej stránke o licencii Moodle: https://moodledev.io/general/license.';
$string['gpl3'] = 'Copyright (C) 1999 onwards Martin Dougiamas (https://moodle.com)

Tento program je slobodný softvér: môžete ho šíriť a/alebo upravovať podľa podmienok Všeobecnej verejnej licencie GNU, ako ju vydala Nadácia slobodného softvéru, buď verzie 3 licencie, alebo (podľa vlastného uváženia) ktorejkoľvek novšej verzie.

Tento program sa šíri v nádeji, že bude užitočný, ale BEZ AKEJKOĽVEK ZÁRUKY; dokonca ani bez implicitnej záruky PREDAJNOSTI alebo VHODNOSTI NA KONKRÉTNY ÚČEL.

Všetky podrobnosti nájdete na informačnej stránke o licencii Moodle: https://moodledev.io/general/license.';
$string['gpllicense'] = 'GPL licencia';
$string['gradenoun'] = 'Známka';
$string['grades'] = 'Známky';
$string['gradeverb'] = 'Známka';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> je pre túto stránku povolený. V prípade, že nevložíte Vašu profilovú fotografiu, Moodle sa namiesto nej pokúsi nahrať Gravatar obrázok.';
$string['group'] = 'Skupina';
$string['groupadd'] = 'Pridať novú skupinu';
$string['groupaddusers'] = 'Pridať zvolených používateľov do skupiny';
$string['groupfor'] = 'pre skupinu';
$string['groupinfo'] = 'Informácie o zvolenej skupine';
$string['groupinfoedit'] = 'Upraviť nastavenia skupín';
$string['groupinfomembers'] = 'Informácie o zvolených členoch skupiny';
$string['groupinfopeople'] = 'Informácie o zvolených ľuďoch';
$string['groupmembers'] = 'Členovia skupiny';
$string['groupmemberssee'] = 'Prezrieť si členov skupiny';
$string['groupmembersselected'] = 'Členovia zvolenej skupiny';
$string['groupmode'] = 'Režim skupiny';
$string['groupmodeforce'] = 'Vyžadovať režim skupiny';
$string['groupmy'] = 'Moja skupina';
$string['groupnonmembers'] = 'Ľudia nezaradení do skupiny';
$string['groupnotamember'] = 'Prepáčte, ale nie ste členom tejto skupiny';
$string['grouprandomassign'] = 'Náhodne prideliť všetkých do skupín';
$string['groupremove'] = 'Odstrániť zvolenú skupinu';
$string['groupremovemembers'] = 'Odstrániť zvolených členov skupiny';
$string['groups'] = 'Skupiny';
$string['groupsnone'] = 'Žiadne skupiny';
$string['groupsseparate'] = 'Oddelené skupiny';
$string['groupsvisible'] = 'Viditeľné skupiny';
$string['guest'] = 'Hosť';
$string['guestdescription'] = 'Hostia majú minimálne privilégiá a nemôžu vkladať text.';
$string['guestskey'] = 'Povoliť vstup hostí, ktorí majú kľúč';
$string['guestsno'] = 'Nepovoliť vstup hostí';
$string['guestsnotallowed'] = 'Prepáčte, \'{$a}\' nepovoľuje vstup hostí.';
$string['guestsyes'] = 'Povoliť vstup hostí bez kľúča';
$string['guestuser'] = 'Hosťovský používateľ';
$string['guestuserinfo'] = 'Tento používateľ je zvláštnym používateľom, ktorý má prístup len na čítanie do niektorých kurzov.';
$string['help'] = 'Pomoc';
$string['helpprefix2'] = 'Pomoc s {$a}';
$string['helpwiththis'] = 'Pomoc s týmto';
$string['hiddenassign'] = 'Skryté pridelenie rol';
$string['hiddenfromstudents'] = 'Skryté pred študentmi';
$string['hiddenoncoursepage'] = 'Dostupné ale nezobrazuje sa na hlavnej stránke kurzu';
$string['hiddensections'] = 'Skryté sekcie';
$string['hiddensections_help'] = 'Skryté sekcie sa môžu študentom na stránke kurzu zobrazovať ako "nedostupné" alebo môžu byť úplne skryté.';
$string['hiddensectionscollapsed'] = 'Skryté sekcie sa zobrazujú ako nedostupné';
$string['hiddensectionsinvisible'] = 'Skryté sekcie budú pre ostatných úplne neviditeľné';
$string['hiddenwithbrackets'] = '(skryté)';
$string['hide'] = 'Skryť';
$string['hideadvancedsettings'] = 'Skryť rozšírené nastavenia';
$string['hidechartdata'] = 'Skryť údaje grafu';
$string['hidefromstudents'] = 'Skryť na stránke kurzu';
$string['hideoncoursepage'] = 'Sprístupniť, ale nezobrazovať na stránke kurzu';
$string['hidepopoverwindow'] = 'Skryť vyskakovacie okno';
$string['hidesection'] = 'Skryť sekciu {$a}';
$string['hidesettings'] = 'Skryť nastavenia';
$string['hideshowblocks'] = 'Skryť alebo zobraziť bloky';
$string['highlight'] = 'Zvýraznenie';
$string['highlighted'] = 'Zvýraznené';
$string['highlightoff'] = 'Odstrániť zvýraznenie';
$string['hits'] = 'Obľúbené';
$string['hitsoncourse'] = 'Obľúbené v {$a->coursename} pre {$a->username}';
$string['hitsoncoursetoday'] = 'Dnešná obľúbenosť v {$a->coursename} pre {$a->username}';
$string['home'] = 'Domov';
$string['homeheader'] = 'Hlavné menu';
$string['hour'] = 'hodina';
$string['hours'] = 'hodín';
$string['howtomakethemes'] = 'Ako urobiť nové témy';
$string['htmleditor'] = 'Použite HTML editor';
$string['htmleditoravailable'] = 'Editor HTML je dostupný';
$string['htmleditordisabled'] = 'Vo Vašom používateľskom profile ste deaktivovali editor HTML';
$string['htmleditordisabledadmin'] = 'Administrátor deaktivoval editor HTML na tejto stránke';
$string['htmleditordisabledbrowser'] = 'Editor HTML nie je dostupný, pretože nepoužívate kompatibilný prehliadač (IE 5.5 a vyšší, Mozilla/Firefox)';
$string['htmlfilesonly'] = 'Iba HTML súbory';
$string['htmlformat'] = 'Pekný HTML formát';
$string['icon'] = 'Ikona';
$string['idnumber'] = 'Číslo ID';
$string['idnumbercourse'] = 'ID číslo kurzu';
$string['idnumbercourse_help'] = 'Používa sa len na prepojenie kurzu s externými systémami. Ak nemáte oficiálne ID kurzu, nechajte ho prázdne.';
$string['idnumbercoursecategory'] = 'Identifikátor (ID) kategórie';
$string['idnumbercoursecategory_help'] = 'Identifikátor kategórie kurzu sa používa pri synchronizácii s externými systémami. Tento identifikátor sa nikde nezobrazuje. Pokiaľ neviete identifikátor kategórie, nechajte toto pole prázdne.';
$string['idnumbergroup'] = 'ID číslo skupiny';
$string['idnumbergroup_help'] = 'Tento identifikátor skupiny sa používa iba pri komunikácii s externými systémami a nie je zobrazovaný nikde na tomto portáli. Ak má táto skupina nejaké jednoznačné kódové označenie, môžete ho sem vložiť, inak ho ponechajte prázdne.';
$string['idnumbergrouping'] = 'ID číslo zoskupenia';
$string['idnumbergrouping_help'] = 'Tento identifikátor zoskupenia sa používa iba pri komunikácii s externými systémami a nie je zobrazovaný nikde na tomto portáli. Ak má toto zoskupenie nejaké jednoznačné kódové označenie, môžete ho sem vložiť, inak ho ponechajte prázdne.';
$string['idnumbermod'] = 'Identifikátor';
$string['idnumbermod_help'] = 'Nastavenie názvu identifikátora poskytuje možnosť identifikácie aktivity v známkach pri ich výpočtoch. V opačnom prípade nemusí byť identifikátor vyplnený.

Identifikátor môže byť nastavený aj v známkovom výkaze, ale upravovaný môže iba na stránke aktualizácie aktivity.';
$string['idnumbertaken'] = 'Tento identifikátor už existuje';
$string['imagealt'] = 'Opis obrázku';
$string['import'] = 'Import';
$string['importdata'] = 'Importovať údaje kurzu';
$string['importdataexported'] = 'Export údajov z \'odkiaľ\' kurzu prebehol úspešne.<br />
Pokračujte v importovaní údajov do \'to\' kurzu.';
$string['importdatafinished'] = 'Import údajov bol ukončený! Teraz vstúpte do vášho kurzu';
$string['importdatafrom'] = 'Vyhľadajte kurz, z ktorého sa majú importovať údaje:';
$string['importinfo'] = 'Importovať položky z iných kurzov, ako sú aktivity, bloky alebo udalosti kalendára. Neimportujú sa žiadne údaje používateľov.';
$string['inactive'] = 'Neaktívny';
$string['include'] = 'Zahrnúť';
$string['includeallusers'] = 'Zahrnúť všetkých používateľov';
$string['includecoursefiles'] = 'Zahrnúť súbory kurzu';
$string['includecourseusers'] = 'Zahrnúť používateľov kurzu';
$string['included'] = 'Zahrnuté';
$string['includelogentries'] = 'Zahrnúť záznamy o prihlasovaní do kurzov';
$string['includemodules'] = 'Zahrnúť moduly';
$string['includemoduleuserdata'] = 'Zahrnúť používateľské údaje modulu';
$string['includeneededusers'] = 'Zahrnúť potrebných používateľov';
$string['includenoneusers'] = 'Nezahrnúť žiadnych používateľov';
$string['includeroleassignments'] = 'Zahrnúť priradenia rol';
$string['includesitefiles'] = 'Zahrnúť súbory portálu použité v tomto kurze';
$string['includesubcategories'] = 'Zahrnúť podkategórie';
$string['includeuserfiles'] = 'Zahrnúť súbory používateľov';
$string['increasesections'] = 'Zvýšiť počet sekcií';
$string['indicator:accessesafterend'] = 'Prístupy po dátume ukončenia';
$string['indicator:accessesafterend_help'] = 'Tento ukazovateľ indikuje prístup študentov po ukončení kurzu';
$string['indicator:accessesbeforestart'] = 'Prístupy pred dátumom začiatku kurzu';
$string['indicator:accessesbeforestart_help'] = 'Tento ukazovateľ indikuje prístup študentov pred začiatkom kurzu.';
$string['indicator:activitiesdue'] = 'Aktivity s termínom';
$string['indicator:activitiesdue_help'] = 'Používateľ má aktivity s termínom';
$string['indicator:anycourseaccess'] = 'Ľubovoľný prístup do kurzu';
$string['indicator:anycourseaccess_help'] = 'Tento indikátor reflektuje prístup k akémukoľvek kurzu, do ktorého je používateľ zapísaný.';
$string['indicator:anywrite'] = 'Akákoľvek akcia zápisu';
$string['indicator:anywrite_help'] = 'Tento ukazovateľ predstavuje akýkoľvek výstup (odovzdanie, odoslanie) študenta.';
$string['indicator:anywriteincourse'] = 'Akýkoľvek príspevok v kurze';
$string['indicator:anywriteincourse_help'] = 'Tento ukazovateľ predstavuje akúkoľvek akciu pri zápise (odoslanie), ktorú študent vykoná v nejakej činnosti.';
$string['indicator:completeduserprofile'] = 'Používateľský profil je dokončený';
$string['indicator:completeduserprofile_help'] = 'Tento ukazovateľ znamená, že študent skompletizoval svoj používateľský profil.';
$string['indicator:completeduserprofiledef'] = 'Používateľský profil je dokončený';
$string['indicator:completeduserprofiledef_help'] = 'Zásady platné na portáli boli dohodnuté a používateľ vyplnil nasledovné polia: inštitúcia, oddelenie, adresa, mesto, štát, URL.';
$string['indicator:completionenabled'] = 'Sledovanie plnenia je povolené';
$string['indicator:completionenabled_help'] = 'Tento ukazovateľ znamená, že v kurze bolo povolené sledovanie plnenia.';
$string['indicator:nostudent'] = 'Zápisy študentov';
$string['indicator:nostudent_help'] = 'Tento ukazovateľ ukazuje dostupnosť študentov v kurze.';
$string['indicator:noteacher'] = 'Dostupnosť učiteľov';
$string['indicator:noteacher_help'] = 'Tento ukazovateľ ukazuje dostupnosť učiteľov v kurze.';
$string['indicator:potentialcognitive'] = 'Potenciálna kognitívna hĺbka kurzu';
$string['indicator:potentialcognitive_help'] = 'Tento indikátor je odvodený z potenciálnej kognitívnej hĺbky, ktorú môže študent dosiahnuť svojou aktivitou v kurze.';
$string['indicator:potentialcognitivedef'] = 'Potenciálna kognitívna hĺbka kurzu';
$string['indicator:potentialcognitivedef_help'] = 'Miera, do akej ponúka kurz "hlboké" kognitívne zapojenie, napríklad odovzdanie práce pre spätnú väzbu, možnosť preskúmať prácu ostatných a príležitosť revidovať a znovu odovzdať prácu.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Potenciálna sociálna šírka kurzu';
$string['indicator:potentialsocial_help'] = 'Tento indikátor je odvodený z potenciálnej sociálnej šírky kurzu, ktorú môže študent dosiahnuť svojou aktivitou v kurze.';
$string['indicator:potentialsocialdef'] = 'Potenciálna sociálna šírka kurzu';
$string['indicator:potentialsocialdef_help'] = 'Miera, do akej ponúka kurz "široké" sociálne angažovanie, interakciu s ostatnými účastníkmi a s komunitou mimo kurzu.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Počet akcií čítania (prezerania)';
$string['indicator:readactions_help'] = 'Tento indikátor udáva počet čítaní (prezeraní) študentom.';
$string['indicator:userforumstracking'] = 'Používateľ sleduje diskusné fóra';
$string['indicator:userforumstracking_help'] = 'Tento ukazovateľ ukazuje, či si študent zapína sledovanie v diskusných fórach.';
$string['info'] = 'Informácie';
$string['inprogress'] = 'prebieha';
$string['insertresourceoractivitybefore'] = 'Vložte aktivitu alebo zdroj pred \'{$a->activityname}\'';
$string['institution'] = 'Inštitúcia';
$string['instudentview'] = 'V študentskom pohľade';
$string['interests'] = 'Záujmy';
$string['interestslist'] = 'Zoznam záujmov';
$string['interestslist_help'] = 'Zadajte svoje záujmy, po jednom. Budú zobrazené vo Vašom profile ako štítky.';
$string['invalidemail'] = 'Neplatná emailová adresa';
$string['invalidlogin'] = 'Neplatný pokus o prihlásenie, skúste ešte raz';
$string['invalidtaskclassname'] = 'Neplatná trieda úlohy {$a}';
$string['invalidtaskid'] = 'Neplatné ID úlohy';
$string['invalidusername'] = 'Používateľské meno môže obsahovať iba malé alfanumerické znaky (čísla a písmená), podtržník (_), pomlčku (-), bodku (.) alebo symbol @ .';
$string['invalidusernameupload'] = 'Neplatné používateľské meno';
$string['ip_address'] = 'IP adresa';
$string['jump'] = 'Ísť';
$string['jumpto'] = 'Ísť na...';
$string['keep'] = 'Zachovať';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Smer jazyka zľava doprava';
$string['langrtl'] = 'Smer jazyka sprava doľava';
$string['language'] = 'Jazyk';
$string['languagegood'] = 'Tento balíček jazykových nastavení je aktuálny! :-)';
$string['languageselector'] = 'Výber jazyka';
$string['last'] = 'Posledný';
$string['lastaccess'] = 'Posledný prístup';
$string['lastcourseaccess'] = 'Posledný prístup do kurzu';
$string['lastedited'] = 'Posledná úprava';
$string['lastip'] = 'Posledná IP adresa';
$string['lastlogin'] = 'Posledné prihlásenie';
$string['lastmodified'] = 'Posledná zmena';
$string['lastname'] = 'Priezvisko';
$string['lastnamephonetic'] = 'Priezvisko - foneticky';
$string['lastpage'] = 'Posledná stránka';
$string['lastsiteaccess'] = 'Posledný prístup ku stránke';
$string['lastyear'] = 'Posledný rok';
$string['latestlanguagepack'] = 'Overte si aktuálny balíček jazykových nastavení na moodle.org';
$string['layouttable'] = 'Usporiadanie tabuľky';
$string['leavetokeep'] = 'Túto položku nevypĺňajte, ak si chcete zachovať pôvodné heslo';
$string['legacylogginginuse'] = 'Tento portál má aktuálne povolený zápis to zastaralého logovacieho systému. Zápis doň bol odmietnutý. Zmeňte zápis na niektorý z podporovaných, ako napr. "standard" alebo "externý".';
$string['legacythemeinuse'] = 'Tento portál je zobrazený v režime kompatibility, pretože Váš prehliadač je príliš starý.';
$string['license'] = 'Licencia';
$string['licenses'] = 'Licencie';
$string['liketologin'] = 'Chcete sa teraz prihlásiť pod plným používateľským účtom?';
$string['list'] = 'Zoznam';
$string['listfiles'] = 'Zoznam súborov v {$a}';
$string['listofallpeople'] = 'Zoznam všetkých ľudí';
$string['listofcourses'] = 'Zoznam kurzov';
$string['loading'] = 'Nahrávanie';
$string['loadinghelp'] = 'Nahrávam ...';
$string['local'] = 'Lokálny';
$string['localplugins'] = 'Lokálne zásuvné moduly';
$string['localpluginsmanage'] = 'Spravovať lokálne zásuvné moduly';
$string['location'] = 'Poloha';
$string['locktimeout'] = 'Operácia vypršala počas čakania na uzamknutie.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Ste prihlásený ako {$a}';
$string['loggedinasguest'] = 'Práve používate hosťovský prístup';
$string['loggedinnot'] = 'Nie ste prihlásený.';
$string['login'] = 'Prihlásiť sa';
$string['login_failure_logs'] = 'Záznamy o neúspešných pokusoch o prihlásenie';
$string['loginactivity'] = 'Prehľad prihlásení';
$string['loginagain'] = 'Prihláste sa znova';
$string['loginalready'] = 'Už ste prihlásený(á)';
$string['loginas'] = 'Prihlásiť sa ako';
$string['loginaspasswordexplain'] = '<p>Musíte zadať špeciálne "loginas password", aby ste mohli použiť túto vlastnosť.<br />Ak ho neviete, kontaktujte administrátora servera.</p>';
$string['loginguest'] = 'Prístup ako hosť';
$string['loginsite'] = 'Prihlásiť sa na portál';
$string['loginsteps'] = 'Na úplný prístup do kurzov na tomto portáli si najprv potrebujete vytvoriť konto.';
$string['loginstepsnone'] = '<p>Dobrý deň!</p>
<p>Aby ste mohli úplne vstúpiť do kurzov, musíte si vytvoriť svoje konto.</p>
<p>Potrebujete si stanoviť používateľské meno a heslo a použiť ho vo formulári na tejto strane!</p>
<p>Ak si už niekto pred Vami vybral také isté používateľské meno, budete to musieť skúsiť ešte raz a použiť iné používateľské meno.</p>';
$string['loginto'] = 'Prihlásenie do {$a}';
$string['logoof'] = 'Logo';
$string['logout'] = 'Odhlásiť sa';
$string['logoutconfirm'] = 'Naozaj sa chcete odhlásiť?';
$string['logs'] = 'Záznamy o prihláseniach';
$string['logtoomanycourses'] = '<a href="{$a->url}">more</a>';
$string['logtoomanyusers'] = '<a href="{$a->url}">more</a>';
$string['lookback'] = 'Ísť späť';
$string['mailadmins'] = 'Informovať administrátorov';
$string['mailstudents'] = 'Informovať študentov';
$string['mailteachers'] = 'Informovať učiteľov';
$string['maincoursepage'] = 'Hlavná stránka kurzu';
$string['makeafolder'] = 'Vytvoriť priečinok';
$string['makeavailable'] = 'Sprístupniť';
$string['makeavailablecmtitle'] = 'Sprístupniť aktivitu';
$string['makeeditable'] = 'Ak zapisujete \'{$a}\' prostredníctvom web serverového procesu (napr. Apache), potom môžete zapisovať tento súbor priamo z tejto stránky';
$string['makethismyhome'] = 'Nastaviť toto ako moju východziu domovskú stránku';
$string['makeunavailable'] = 'Zneprístupniť';
$string['manageblocks'] = 'Bloky';
$string['managecategories'] = 'Spravovať kategórie kurzov';
$string['managecategorythis'] = 'Spravovať túto kategóriu';
$string['managecombined'] = 'Spravovať kategórie kurzov a kurzy';
$string['managecontentbanktypes'] = 'Spravovať typy obsahu';
$string['managecourses'] = 'Spravovať kurzy';
$string['managedatabase'] = 'Spravovať databázu';
$string['managedataformats'] = 'Spravovať dátové formáty';
$string['manageeditorfiles'] = 'Správa súborov ktoré používa editor';
$string['managefilters'] = 'Filtre';
$string['managemodules'] = 'Administrácia modulov';
$string['manageroles'] = 'Roly a oprávnenia';
$string['markallread'] = 'Označiť všetko ako prečítané';
$string['markedthistopic'] = 'Táto sekcia je zvýraznená ako aktuálna';
$string['markthistopic'] = 'Označiť túto sekciu ako aktuálnu';
$string['match'] = 'Priradiť';
$string['matchingsearchandrole'] = 'Zhoda \'{$a->search}\' a {$a->role}';
$string['matchofthefollowing'] = 'z nasledujúcich:';
$string['maxareabytesreached'] = 'Veľkosť súboru alebo celková veľkosť niekoľkých súborov je väčšia ako zostávajúce voľné miesto.';
$string['maxfilesize'] = 'Maximálna veľkosť pre nové súbory: {$a}';
$string['maxfilesreached'] = 'K tejto položke môžete pripojiť maximálne {$a} súborov';
$string['maximumchars'] = 'Maximum {$a} znakov';
$string['maximumgrade'] = 'Maximálna známka';
$string['maximumgradex'] = 'Maximálna známka: {$a}';
$string['maximumshort'] = 'Maximum';
$string['maximumupload'] = 'Maximálna veľkosť sťahovania';
$string['maximumupload_help'] = 'Maximálna veľkosť súboru, ktorý môžu študenti nahrať do kurzu. Okrem toho môžete ďalej obmedziť maximálnu veľkosť nahrávania pre každú aktivitu.';
$string['maxnumberweeks'] = 'Maximálny počet sekcií kurzu';
$string['maxnumberweeks_desc'] = 'Týmto nastavíte maximálny počet sekcií v rozbaľovacej ponuke počtu sekcií kurzu (platí iba pre niektoré formáty kurzu).';
$string['maxnumcoursesincombo'] = 'Zobraziť <a href="{$a->link}">zoznam {$a->numberofcourses} kurzov</a>';
$string['maxsectionslimit'] = 'Nie je možné vytvoriť novú sekciu, pretože by prekročila maximálny počet sekcií povolených pre tento kurz ({$a}).';
$string['maxsize'] = 'Maximálna veľkosť: {$a}';
$string['maxsizeandareasize'] = 'Maximálna veľkosť pre nové súbory: {$a->size}, celkový limit: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maximálna veľkosť súborov: {$a->size}, maximálny počet súborov: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maximálna veľkosť  súborov: {$a->size}, maximálny počet príloh: {$a->attachments}, maximálna celková veľkosť: {$a->areasize}';
$string['memberincourse'] = 'Ľudia v kurze';
$string['menu'] = 'Menu';
$string['message'] = 'Správa';
$string['messagebody'] = 'Telo správy';
$string['messagedselectedusers'] = 'Vybraným používateľom bola poslaná správa a zoznam príjemcov bol resetovaný.';
$string['messagedselectedusersfailed'] = 'Niektorí príjemcovia možno nedostali mail.';
$string['messageprovider:asyncbackupnotification'] = 'Oznámenie o asynchrónnom zálohovaní/obnovení';
$string['messageprovider:availableupdate'] = 'Sú dostupné oznámenia o aktualizáciách';
$string['messageprovider:backup'] = 'Oznámenia o zálohovaní';
$string['messageprovider:badgecreatornotice'] = 'Oznámenia tvorcu Odznaku';
$string['messageprovider:badgerecipientnotice'] = 'Oznámenia príjemcu Odznaku';
$string['messageprovider:competencyplancomment'] = 'Komentár zverejnený v študijnom pláne';
$string['messageprovider:competencyusercompcomment'] = 'Komentár zverejnený na kompetencii';
$string['messageprovider:coursecompleted'] = 'Kurz je dokončený';
$string['messageprovider:coursecontentupdated'] = 'Zmeny obsahu kurzu';
$string['messageprovider:courserequestapproved'] = 'Schválenie žiadosti o vytvorenie kurzu';
$string['messageprovider:courserequested'] = 'Nová žiadosť o vytvorenie kurzu';
$string['messageprovider:courserequestrejected'] = 'Zamietnutie žiadosti o vytvorenie kurzu';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Uvítacia správa pre nové zápisy do kurzu';
$string['messageprovider:errors'] = 'Dôležité chyby na stránke';
$string['messageprovider:errors_help'] = 'Toto sú dôležité chyby o ktorých by mal administrátor vedieť.';
$string['messageprovider:failedtaskmaxdelay'] = 'Úloha dosiahne maximálne oneskorenie pri zlyhaní';
$string['messageprovider:gradenotifications'] = 'Notifikácie známok';
$string['messageprovider:infected'] = 'Notifikácie zlyhania antivíru';
$string['messageprovider:insights'] = 'Poznatky vygenerované prediktívnymi modelmi';
$string['messageprovider:instantmessage'] = 'Súkromné správy medzi používateľmi';
$string['messageprovider:instantmessage_help'] = 'Tento oddiel nastavuje, čo sa stane so so správami, ktoré sú Vám zaslané od ostatných používateľov tohto portálu.';
$string['messageprovider:messagecontactrequests'] = 'Notifikácia žiadostí o kontakty cez správy';
$string['messageprovider:newlogin'] = 'Nové oznámenia na prihlásenie';
$string['messageprovider:notices'] = 'Upozornenie o menej závažných problémoch';
$string['messageprovider:notices_help'] = 'Toto sú menej závažné chyby o ktorých by mal administrátor vedieť.';
$string['messageprovider:reportbuilderschedule'] = 'Plánovanie generátora vlastných reportov';
$string['messageselect'] = 'Označiť tohto používateľa ako príjemcu pošty';
$string['messageselectadd'] = 'Poslať správu';
$string['middlename'] = 'Stredné meno';
$string['migratinggrades'] = 'Migrácia známok';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minúta';
$string['minutes'] = 'minúty';
$string['miscellaneous'] = 'Rôzne';
$string['missingcategory'] = 'Musíte si vybrať kategóriu';
$string['missingdescription'] = 'Chýba opis';
$string['missingemail'] = 'Chýba emailová adresa';
$string['missingfirstname'] = 'Chýba krstné meno';
$string['missingfromdisk'] = 'Chýba na disku';
$string['missingfullname'] = 'Chýba celé meno';
$string['missinglastname'] = 'Chýba priezvisko';
$string['missingname'] = 'Chýba meno';
$string['missingnewpassword'] = 'Chýba nové heslo';
$string['missingpassword'] = 'Chýba heslo';
$string['missingrecaptchachallengefield'] = 'Chybne zadané reCHAPTCHA pole, prosím skúste znova.';
$string['missingreqreason'] = 'Chýba dôvod';
$string['missingshortname'] = 'Chýba skrátené meno';
$string['missingshortsitename'] = 'Chýba skrátený názov stránky';
$string['missingsitedescription'] = 'Chýba opis portálu';
$string['missingsitename'] = 'Chýba názov stránky';
$string['missingstrings'] = 'Nájsť nepreložené slová alebo texty';
$string['missingstudent'] = 'Musíte si niečo vybrať';
$string['missingsummary'] = 'Chýbajúce zhrnutie';
$string['missingteacher'] = 'Musíte si niečo vybrať';
$string['missingurl'] = 'Chýba URL adresa';
$string['missingusername'] = 'Chýbajúce používateľské meno';
$string['moddoesnotsupporttype'] = 'Modul {$a->modname} nepodporuje nahrávanie súboru typu {$a->type}';
$string['modhide'] = 'Skryť';
$string['modified'] = 'Modifikované';
$string['modshow'] = 'Zobraziť';
$string['modshowcmtitle'] = 'Zobraziť aktivitu';
$string['moduleintro'] = 'Opis';
$string['modulesetup'] = 'Nastavovanie modulových tabuliek';
$string['modulesuccess'] = '{$a} tabuľky boli nastavené správne';
$string['modulesused'] = 'Použité moduly';
$string['modvisible'] = 'Dostupnosť';
$string['modvisible_help'] = '* Zobraziť na stránke kurzu: Dostupné pre študentov (v závislosti od obmedzení prístupu, ktoré môžu byť nastavené).
* Skryť na stránke kurzu: Nie je k dispozícii študentom.';
$string['modvisiblehiddensection'] = 'Dostupnosť';
$string['modvisiblehiddensection_help'] = '* Skryť na stránke kurzu: Nie je k dispozícii študentom.
* Sprístupniť, ale nezobrazovať na stránke kurzu: Dostupné študentom, ak poskytnete odkaz. Aktivity sa budú naďalej zobrazovať v hodnotiacej správe a iných správach.';
$string['modvisiblewithstealth'] = 'Dostupnosť';
$string['modvisiblewithstealth_help'] = '* Zobraziť na stránke kurzu: Dostupné pre študentov (v závislosti od obmedzení prístupu, ktoré môžu byť nastavené).
* Skryť na stránke kurzu: Nie je k dispozícii študentom.
* Sprístupniť, ale nezobrazovať na stránke kurzu: Dostupné študentom, ak poskytnete odkaz. Aktivity sa budú naďalej zobrazovať v hodnotiacej správe a iných správach.';
$string['month'] = 'Mesiac';
$string['months'] = 'Mesiace';
$string['moodledocs'] = 'Moodle Docs';
$string['moodledocslink'] = 'Dokumentácia pre túto stránku (anglicky)';
$string['moodlelogo'] = 'Moodle logo';
$string['moodlenet:cannotconnecttoserver'] = 'Nedá sa pripojiť k serveru MoodleNet';
$string['moodlenet:columnname'] = 'Názov';
$string['moodlenet:columnsenddate'] = 'Odoslať dátum';
$string['moodlenet:columnsendstatus'] = 'Odoslať stav';
$string['moodlenet:columntype'] = 'Typ';
$string['moodlenet:configoauthservice'] = 'Vyberte službu MoodleNet OAuth 2, aby ste umožnili zdieľanie na danej lokalite MoodleNet. Ak služba ešte neexistuje, budete si ju musieť <a href="{$a}">vytvoriť</a>.';
$string['moodlenet:deletedactivity'] = 'Odstránená aktivita';
$string['moodlenet:deletedcourse'] = 'Odstránený kurz';
$string['moodlenet:eventresourceexported'] = 'Zdroj bol exportovaný';
$string['moodlenet:gotomoodlenet'] = 'Prejdite na koncepty MoodleNet';
$string['moodlenet:issuerisnotauthorized'] = 'Vydavateľ MoodleNet nie je autorizovaný';
$string['moodlenet:issuerisnotenabled'] = 'Vydavateľ MoodleNet nie je povolený';
$string['moodlenet:issuerisnotset'] = 'Vydavateľ MoodleNet nie je nastavený v administrácii stránky';
$string['moodlenet:nosharedresources'] = 'V súčasnosti nie sú k dispozícii žiadne zdieľané zdroje na zobrazenie.';
$string['moodlenet:outboundsettings'] = 'Nastavenia odchádzajúcej siete MoodleNet';
$string['moodlenet:packagingandsending'] = 'Balenie súboru a odoslanie do MoodleNet...';
$string['moodlenet:sharefailtext'] = 'Pri zdieľaní vášho obsahu na MoodleNet sa vyskytla chyba.<br>Skúste to, prosím, znova neskôr.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Pri zdieľaní vášho obsahu na MoodleNet sa vyskytla chyba.<br>Skúste to, prosím, znova neskôr alebo <a href="{$a}">kontaktujte podporu lokality</a>.';
$string['moodlenet:sharefailtitle'] = 'Niečo sa pokazilo';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Veľkosť zdieľaného prostriedku ({$a->file size} bajtov) presahuje limit {$a->filesizelimit} bajtov.';
$string['moodlenet:sharenoticeactivity'] = 'Táto aktivita je zdieľaná so sieťou MoodleNet ako zdroj.';
$string['moodlenet:sharenoticecourse'] = 'Tento kurz je zdieľaný so sieťou MoodleNet ako zdroj.';
$string['moodlenet:sharenoticepartial'] = 'Vybrané aktivity sú zdieľané so sieťou MoodleNet ako zdroj.';
$string['moodlenet:sharenoticepartialactivitynumber'] = 'Do kurzu bude zahrnutých {$a} aktivít.';
$string['moodlenet:shareprogress'] = 'Priebeh zdieľania na MoodleNet';
$string['moodlenet:shareprogressinfo'] = 'V zozname sa zobrazujú kurzy a aktivity, ktoré ste zdieľali v sieti MoodleNet.<br>Kliknutím na názov zdroja ho zobrazíte v sieti MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Skoro hotové! Navštívte svoje koncepty v sieti MoodleNet a dokončite zdieľanie svojho obsahu.';
$string['moodlenet:sharesuccesstitle'] = 'Uložené do konceptov MoodleNet';
$string['moodlenet:sharetomoodlenet'] = 'Zdieľať na MoodleNet';
$string['moodlenet:sharetyperesource'] = 'zdroj';
$string['moodlenet:sharinglargefile'] = 'Veľké súbory môžu chvíľu trvať.';
$string['moodlenet:sharingstatus'] = 'Zdieľanie na MoodleNet';
$string['moodlenet:sharingto'] = 'Zdieľanie s:';
$string['moodlerelease'] = 'Moodle verzia';
$string['moodleservicesandsupport'] = 'Služby a podpora';
$string['moodleversion'] = 'Moodle verzia';
$string['more'] = 'viac';
$string['moreactions'] = 'Viac akcií';
$string['morehelp'] = 'Viac nápovedy';
$string['morehelpaboutmodule'] = 'Ďalšia pomoc k aktivite {$a}';
$string['moreinfo'] = 'Viac informácií';
$string['moreinformation'] = 'Viac informácií o tejto chybe';
$string['moremenu'] = 'Viac';
$string['morenavigationlinks'] = 'Viac ...';
$string['moreprofileinfoneeded'] = 'Povedzte o sebe viac';
$string['mostrecently'] = 'aktuálny';
$string['move'] = 'Presunúť';
$string['movecategoriessuccess'] = 'Úspešne bolo presunutých {$a->count} kategórií do kategórie "{$a->to}"';
$string['movecategoriestotopsuccess'] = 'Úspešne bolo presunutých {$a->count} kategórií do najvyššej úrovne';
$string['movecategorycontentto'] = 'Presunúť do';
$string['movecategorysuccess'] = 'Kategória \'{$a->moved}\' bola úspešne presunutá do kategórie \'{$a->to}\'';
$string['movecategoryto'] = 'Presunúť kategóriu do:';
$string['movecategorytotopsuccess'] = 'Kategórae \'{$a->moved}\' bola úspešne presunutá do najvyššej úrovne';
$string['movecontent'] = 'Presunúť {$a}';
$string['movecontentafter'] = 'Po "{$a}"';
$string['movecontentstoanothercategory'] = 'Presunúť obsah do inej kategórie';
$string['movecontenttothetop'] = 'Na začiatok zoznamu';
$string['movecoursemodule'] = 'Presunúť aktivitu';
$string['movecoursesection'] = 'Presunúť sekciu';
$string['movecourseto'] = 'Presunúť kurz do:';
$string['movedown'] = 'Presunúť nadol';
$string['movefilestohere'] = 'Presunúť súbory sem';
$string['movefull'] = 'Presunúť {$a} na toto miesto';
$string['movehere'] = 'Presunúť sem';
$string['moveleft'] = 'Presunúť doľava';
$string['moveright'] = 'Presunúť doprava';
$string['movesection'] = 'Presunúť sekciu {$a}';
$string['moveselectedcategoriesto'] = 'Presunúť vybrané kategórie do';
$string['moveselectedcoursesto'] = 'Presunúť označené kurzy do ..';
$string['movetoanotherfolder'] = 'Presunúť do iného priečinka';
$string['moveup'] = 'Presunúť nahor';
$string['mustchangepassword'] = 'Nové heslo musí byť rozdielne ako to súčasné';
$string['mustconfirm'] = 'Musíte potvrdiť svoj účet';
$string['mycourses'] = 'Moje kurzy';
$string['myfiles'] = 'Moje súkromné súbory';
$string['myfilesmanage'] = 'Spravovať moje súkromné súbory';
$string['myhome'] = 'Nástenka';
$string['mymoodledashboard'] = 'Moja Nástenka';
$string['myprofile'] = 'Môj profil';
$string['name'] = 'Meno';
$string['namedfiletoolarge'] = 'Súbor \'{$a-> filename}\' je príliš veľký a nie je možné ho nahrať';
$string['nameforlink'] = 'Ako chcete nazvať tento odkaz?';
$string['nameforpage'] = 'Názov';
$string['navigation'] = 'Navigácia';
$string['needed'] = 'Potrebné';
$string['networkdropped'] = 'Zistili sme, že vaše pripojenie k Internetu je nespoľahlivé alebo bolo prerušené.<br /> Zmeny nie je možné uložiť, kým sa spojenie nezlepší.';
$string['never'] = 'Nikdy';
$string['neverdeletelogs'] = 'Nikdy nevymazávať záznamy o prihláseniach';
$string['new'] = 'Nový';
$string['newaccount'] = 'Nové konto';
$string['newactivityname'] = 'Nový názov pre aktivitu {$a}';
$string['newcourse'] = 'Nový kurz';
$string['newloginnotificationbodyfull'] = '<p>Dobrý deň, {$a->userfullname},</p>
 <p>Váš účet {$a->sitename} bol práve prihlásený z nového zariadenia.</p>
<ul>
<li>Váš účet: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Zariadenie: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Ak ste to boli vy, nemusíte robiť nič.</p>
<p>Ak túto aktivitu nepoznávate, <a href="{$a->changepasswordlink}">zmeňte si heslo</a></p>';
$string['newloginnotificationbodysmall'] = 'Váš účet {$a} bol práve prihlásený z nového zariadenia.';
$string['newloginnotificationtitle'] = 'Nové prihlásenie k vášmu účtu {$a}';
$string['newpassword'] = 'Nové heslo';
$string['newpassword_help'] = 'Nechajte prázdne pre zachovanie súčasného hesla.';
$string['newpasswordfromlost'] = '<strong>POZOR:</strong> Vaše <strong>súčasné heslo</strong> Vám bude poslané v <strong>druhom</strong> maili (z dvoch). Uistite sa, že ste dostali náhradné heslo predtým, ako budete pokračovať na tejto obrazovke.';
$string['newpasswordtext'] = 'Dobrý deň {$a->firstname},

Vaše heslo účtu na \'{$a->sitename}\' bolo zmenené a bolo vám generované nové aktuálne heslo.

Vaše aktuálne prihlasovacie informácie sú:

   používateľské meno: {$a->username}
   heslo: {$a->newpassword}

Ak chcete zmeniť Vaše heslo, navštívte prosím túto stránku:

   {$a->link}

Vo väčšine programov pre čítanie elektronickej pošty by sa mal tento odkaz objaviť ako modrá linka, na ktorú stačí kliknúť. Ak to nefunguje, skopírujte adresu do riadku pre adresu vo vrchnej časti okna vášho web prehliadača.

S pozdravom \'{$a->sitename}\' administrátor,

{$a->signoff}';
$string['newpicture'] = 'Nový obrázok';
$string['newpicture_help'] = '<p>Môžete načítať obrázok z vášho PC na tento server a tento bude
následne použitý na viacerých miestach.</p>

<p>Z tohoto dôvodu sú najlepšie detailne zábery vašej tváre, ale
môžete použiť ľubovoľné obrázky. </p>

<p>Obrázky musia byť v JPG alebo PNG formáte (znamená to, že obyčajne
majú príponu .jpg alebo .png).</p>

<p>Obrázok môžete získať štyrmi spôsobmi: </p>

<ol>
<li>Použitím digitálneho fotoaparátu. Vaše obrázky s najväčšou pravdepodobnosťou budú v PC v správnom formáte.</li>

<li>Môžete použiť skener a naskenovať obrázky
resp. fotografie. Uistite sa, že tieto sú uložené vo formáte JPG alebo
PNG.</li>

<li>Ak máte umelecké sklony, môžete nakresliť obrázok v kresliacom programe. </li>

<li>Nakoniec, môžete "ukradnúť" obrázky z
internetu.  <a target="google"
href="http://images.google.com/">http://images.google.com</a> je super
miesto na nájdenie obrázku. Ak ste našli správny obrázok, pravým
tlačidlom myši vyberte v menu možnosť "Uložiť obrázok ako...". (Táto
voľba sa v závislosti od PC môže mierne líšiť.) </li>

</ol>

<p>Na načítanie obrázku kliknite na tlačidlo "Prezerať" na tejto
editovacej stránke a vyberte si obrázok z disku vášho počítača.</p>

<p>POZOR: Uistite sa, že obrázok nie je väčší ako je maximálne určená
veľkosť, lebo v takom prípade tento nebude načítaný. </p>

<p>Potom kliknite na "Aktualizácia môjho profilu" a obrázok bude
prispôsobený a zmenšený na 100 * 100 pixelov.</p>

<p>Po návrate na vašu profilovú stránku sa môže zdať, že obrázok
nebol zmenený. V takomto prípade použite tlačítko "Obnoviť" vo vašom
prehliadači. </p>';
$string['newpictureusernotsetup'] = 'Obrázok profilu možno pridať až potom, čo boli uložené všetky nutné polia profilu';
$string['newsectionname'] = 'Nový názov pre sekciu {$a}';
$string['newsitem'] = 'nová novinka';
$string['newsitems'] = 'oznámenia';
$string['newsitemsnumber'] = 'Počet oznámení na zobrazenie';
$string['newsitemsnumber_help'] = 'Fórum oznamov má predvolene nastavený nútený odber. Môžu do neho písať len učitelia a ostatní používatelia s príslušným oprávnením.

Ak fórum oznámení nepotrebujete, nastavte túto hodnotu na nulu.

Toto nastavenie tiež určuje, koľko posledných oznámení sa zobrazí v bloku najnovších oznámení.';
$string['newuser'] = 'Nový používateľ';
$string['newusernewpasswordsubj'] = 'Nové používateľské konto';
$string['newusernewpasswordtext'] = 'Dobrý deň {$a->firstname},

Na portáli \'{$a->sitename}\' Vám bolo vytvorené nové konto a dostali ste dočasné heslo.

Váš súčasný login je:
meno: {$a->username}
heslo: {$a->newpassword}
(toto heslo budete musieť zmeniť po Vašom prvom prihlásení)

Na začatie používania portálu \'{$a->sitename}\' sa prihláste na odkaze
{$a->link}.

V najčastejších v mailových programoch je tento odkaz modrý a môžete naň kliknúť. Ak sa to nedá, skopírujte si adresu do zadávacieho riadku Vašeho web prehliadača.

S pozdravom od administrátora portálu \'{$a->sitename}\',

{$a->signoff}';
$string['newusers'] = 'Noví používatelia';
$string['newwindow'] = 'Nové okno';
$string['next'] = 'Ďalší';
$string['nextpage'] = 'Ďalšia stránka';
$string['nextsection'] = 'Ďalšia sekcia';
$string['no'] = 'Nie';
$string['noblockstoaddhere'] = 'K tejto stránke nemôžete pridať žiadne bloky.';
$string['nobody'] = 'Nikto';
$string['nochange'] = 'Žiadna zmena';
$string['nocomments'] = 'Bez komentárov';
$string['nocourses'] = 'Žiadne kurzy';
$string['nocoursesfound'] = 'Žiaden kurz neobsahuje slová \'{$a}\'';
$string['nocoursestarttime'] = 'Kurz neobsahuje začiatočný dátum';
$string['nocoursesyet'] = 'Žiadne kurzy v tejto kategórii';
$string['nodstpresets'] = 'Administrátor nezapol podporu pre letný a zimný čas.';
$string['nofilesselected'] = 'Neoznačili ste žiadne súbory na obnovenie zo zálohy';
$string['nofilesyet'] = 'Do Vášho kurzu ešte neboli vložené žiadne súbory';
$string['nofiltersapplied'] = 'Neboli aplikované žiadne filtre';
$string['nograde'] = 'Žiadna známka';
$string['nohelpforactivityorresource'] = 'Pre tento zdroj alebo aktivitu nie je k dispozícii žiadna nápoveda';
$string['noimagesyet'] = 'Do Vášho kurzu ešte neboli vložené žiadne obrázky';
$string['nologsfound'] = 'Neboli nájdené žiadne záznamy';
$string['nomatchingusers'] = 'Žiadny používatelia sa nezhodujú s \'{$a}\'';
$string['nomorecourses'] = 'Nenašiel sa žiaden ďalší kurz, ktorý by vyhovoval podmienkam';
$string['nomoreidnumber'] = 'Nepoužívate ID číslo  aby ste predišli možným kolíziám';
$string['none'] = 'Žiadne';
$string['noneditingteacher'] = 'Učiteľ bez práv úprav';
$string['noneditingteacherdescription'] = 'Učitelia bez práv úprav môžu učiť v kurzoch a hodnotiť študentov, ale nemôžu meniť aktivity';
$string['nonstandard'] = 'Neštandardný';
$string['nopendingcourses'] = 'Nie sú žiadne kurzy čakajúce na schválenie';
$string['nopotentialadmins'] = 'Nie sú potenciálni administrátori';
$string['nopotentialcreators'] = 'Nie sú potenciálni tvorcovia kurzov';
$string['nopotentialstudents'] = 'Nie sú potenciálni študenti';
$string['nopotentialteachers'] = 'Nie sú potenciálni učitelia';
$string['norecentactivity'] = 'Žiadna súčasná aktivita';
$string['noreplybouncemessage'] = 'Odpovedali ste na emailovú adresu, na ktorú sa nedá odpovedať. Ak ste sa pokúšali odpovedať na príspevok z fóra, použite namiesto toho prosím tieto {$a} fóra.

Tu sa nachádza obsah Vášho emailu:';
$string['noreplybouncesubject'] = '{$a} - vrátený mail';
$string['noreplyname'] = 'Neodpovedajte na tento mail';
$string['noresetrecord'] = 'Neexistuje požiadavka na obnovu hesla. Zopakaujte požiadavku o obnovu hesla opäť.';
$string['noresults'] = 'Žiadne výsledky';
$string['noresultsfor'] = 'Žiadne výsledky pre „{$a}“';
$string['normal'] = 'Normálny';
$string['normalfilter'] = 'Normálne vyhľadávanie';
$string['nosite'] = 'Nie je možné nájsť kurzy na úrovni portálu';
$string['nostudentsfound'] = 'Nenájdené žiadne {$a}';
$string['nostudentsingroup'] = 'V tejto skupine zatiaľ nie sú žiadni študenti';
$string['nostudentsyet'] = 'Zatiaľ žiadni študenti nie sú prihlásení do tohto kurzu.';
$string['nosuchemail'] = 'Nie je taká  emailová adresa';
$string['notavailable'] = 'Nie je k dispozícii';
$string['notavailablecourse'] = '{$a} nie je dostupný';
$string['noteachersyet'] = 'Zatiaľ žiadni učitelia v tomto kurze';
$string['noteachingupcomingcourses'] = 'Nadchádzajúce kurzy nemajú žiadnych učiteľov ani študentov';
$string['notenrolled'] = '{$a} nie je prihlásený do tohto kurzu.';
$string['notenrolledprofile'] = 'Tento profil nie je dostupný, pretože používateľ nie je zapísaný do tohto kurzu.';
$string['noteusercannotrolldatesoncontext'] = '<strong>Poznámka:</strong> Schopnosť zmeniť dátumy v kurze pri obnovovaní bola zakázaná, pretože Vám na ňu chýbajú oprávnenia.';
$string['noteuserschangednonetocourse'] = '<strong>Poznámka:</strong> Používatelia kurzu musia byť obnovení, ak sa obnovujú používateľské údaje. Toto nastavenie bolo zmenené pre Vás.';
$string['nothingnew'] = 'Žiadna nedávna aktivita';
$string['nothingtodisplay'] = 'Nič na zobrazenie';
$string['notice'] = 'Oznámenie';
$string['noticenewerbackup'] = 'Táto záloha súboru bola vytvorená s Moodle {$a->backuprelease} ({$a->backupversion}) a je vyššia, ako aktuálna verzia Moodle {$a->serverrelease} ({$a->serverversion}). Toto môže spôsobiť niektoré problémy, pretože spätná kompatibilita zálohovaných súborov nemôže byť garantovaná.';
$string['notifications'] = 'Oznámenia';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, Používateľ: {$a->info}, Celé meno: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Tieto záznamy si môžete prezrieť na {$a}';
$string['notifyloginfailuresmessagestart'] = 'Tu je zoznam neúspešných pokusov o prihlásenie na {$a}, odkedy ste boli o tom naposledy upozornený';
$string['notifyloginfailuressubject'] = '{$a} :: Oznámenie o neúspešných pokusoch o prihlásenie';
$string['notincluded'] = 'Nezahrnuté';
$string['notingroup'] = 'Prepáčte, ale musíte byť členom skupiny, aby ste si mohli prezerať túto stránku.';
$string['notpublic'] = 'Neverejné!';
$string['nousersfound'] = 'Neboli nájdení používatelia';
$string['nousersmatching'] = 'Neboli nájdení žiadni používatelia, vyhovujúci \'{$a}\'';
$string['nousersyet'] = 'Zatiaľ nie sú používatelia';
$string['novalidcourses'] = 'Žiadne kurzy k zobrazeniu';
$string['now'] = 'teraz';
$string['numattempts'] = '{$a} neúspešných pokusov o prihlásenie';
$string['numberofcourses'] = 'Počet kurzov';
$string['numberweeks'] = 'Počet sekcií';
$string['numday'] = '{$a} deň';
$string['numdays'] = '{$a} dní';
$string['numhours'] = '{$a} hodín';
$string['numletters'] = '{$a} písmen';
$string['numminutes'] = '{$a} minút';
$string['nummonth'] = '{$a} mesiac';
$string['nummonths'] = '{$a} mesiacov';
$string['numseconds'] = '{$a} sekúnd';
$string['numviews'] = '{$a} názorov';
$string['numweek'] = '{$a} týždeň';
$string['numweeks'] = '{$a} týždňov';
$string['numwords'] = '{$a} slov';
$string['numyear'] = '{$a} rok';
$string['numyears'] = '{$a} rokov';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Súčasné heslo';
$string['olduserdirectory'] = 'Toto je STARÝ používateľský adresár, ktorý sa už nepoužíva. Môžete ho vymazať, pretože súbory, ktoré obsahoval, boli kopírované do NOVÉHO používateľského adresára.';
$string['opendrawerblocks'] = 'Otvoriť panel bloku';
$string['opendrawerindex'] = 'Otvoriť index kurzu';
$string['opensinnewwindow'] = 'Otvára sa v novom okne';
$string['operator_and'] = 'a';
$string['operator_andnot'] = 'a';
$string['operator_or'] = 'alebo';
$string['optional'] = 'nepovinné';
$string['options'] = 'možnosti';
$string['order'] = 'Poradie';
$string['originalpath'] = 'Pôvodné umiestnenie';
$string['orphanedactivitiesinsectionno'] = 'Osirotené aktivity (sekcia {$a})';
$string['other'] = 'Iné';
$string['outline'] = 'Prehľad';
$string['outlinereport'] = 'Prehľadná správa';
$string['page'] = 'Stránka';
$string['pagea'] = 'Strana {$a}';
$string['pagedcontentnavigation'] = 'Navigácia stránkovania';
$string['pagedcontentnavigationactiveitem'] = 'Súčasná stránka, stránka {$a}';
$string['pagedcontentnavigationitem'] = 'Ísť na stránku {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Zobraziť {$a} položiek na jednej stránke';
$string['pageheaderconfigablock'] = 'Konfiguruje sa blok v {$a->fullname}';
$string['pagepath'] = 'Adresa stránky';
$string['pageshouldredirect'] = 'Táto stránka by sa mala automaticky presmerovať. Ak sa nič neudeje, prosím použite priložený odkaz.';
$string['parentcategory'] = 'Nadradená kategória';
$string['parentcoursenotfound'] = 'Nebol nájdený rodičovský (nadradený) kurz!';
$string['parentfolder'] = 'Rodičovský priečinok';
$string['participants'] = 'Účastníci';
$string['participantslist'] = 'Zoznam účastníkov';
$string['participationratio'] = 'Pomer účastníkov';
$string['participationreport'] = 'Záznamy o účastníkoch';
$string['password'] = 'Heslo';
$string['passwordchanged'] = 'Heslo bolo zmenené';
$string['passwordconfirmchange'] = 'Potvrdiť zmenu hesla';
$string['passwordextlink'] = 'Nasledujúci odkaz je poskytnutý na získanie Vašeho zabudnutého hesla. Odkazuje sa mimo Moodle.';
$string['passwordforgotten'] = 'Zabudnuté heslo';
$string['passwordforgotteninstructions'] = 'Potrebujeme nájsť informácie o Vás v databáze. Zadajte prosím <strong>alebo</strong> Váš login v Moodle alebo mailovú adresu, s ktorou ste sa registrovali. Nemusíte zadať obe.';
$string['passwordforgotteninstructions2'] = 'Ak chcete obnoviť heslo, vyplňte vaše prihlasovacie meno alebo emailovú adresu. Ak vás systém nájde v databáze, bude vám zaslaný email na adresu, ktorú máte vo vašom profile. Mail bude obsahovať  inštrukce, ako sa úspešne prihlásiť.';
$string['passwordnohelp'] = 'Nepodarilo sa nájsť Vaše zabudnuté heslo. Prosím kontaktujte administrátora Moodle.';
$string['passwordpolicynomatch'] = 'Vaše aktuálne heslo už neodpovedá nastaveným zásadám pre hesla.
   {$a}';
$string['passwordrecovery'] = 'Áno, pomôžte mi prihlásiť sa';
$string['passwordsdiffer'] = 'Tieto heslá nie sú správne';
$string['passwordsent'] = 'Heslo bolo poslané';
$string['passwordsenttext'] = '<p>Na vašu adresu {$a->email} bol poslaný email.</p>
<p><b>Skontroluje si prosím poštu, kvôli novému heslu</b></p>
<p>Nové heslo bolo automaticky vytvorené, takže ho môžete <a href="{$a->link}">zmeniť na niečo ľahšie zapamätateľné</a>.</p>';
$string['passwordset'] = 'Vaše heslo bolo nastavené.';
$string['path'] = 'Adresa';
$string['pathnotexists'] = 'Na Vašom serveri neexistuje cesta!';
$string['pathslasherror'] = 'Cesta sa nemôže končiť lomítkom!';
$string['paymentinstant'] = 'Použite tlačidlo v spodnej časti stránky na zaplatenie a budete zapísaný do kurzu v priebehu niekoľkých minút.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> čakajúci</small>)';
$string['paymentrequired'] = 'Tento kurz vyžaduje zaplatenie poplatku pre vstup';
$string['payments'] = 'Platby';
$string['paymentsorry'] = 'Ďakujeme za Vašu platbu! Bohužiaľ, Vaša platba ešte nebola úplne spracovaná a Vy ešte nie ste registrovaný pre vstup do kurzu "{$a->fullname}". Prosím, skúste sa prihlásiť do kurzu o niekoľko sekúnd. Ak problém pretrváva, oznámte to prosím {$a->teacher} alebo administrátorovi stránky.';
$string['paymentthanks'] = 'Ďakujeme za Vašu platbu! Teraz ste zapísaný do kurzu:<br />"{$a}"';
$string['pendingrequests'] = 'Nespracované žiadosti';
$string['percents'] = '{$a} %';
$string['periodending'] = 'Obdobie končí ({$a})';
$string['perpage'] = 'Na stranu';
$string['perpagea'] = 'Na stranu: {$a}';
$string['personal'] = 'Osobný';
$string['personalprofile'] = 'Osobný profil';
$string['phone'] = 'Telefón';
$string['phone1'] = 'Telefón';
$string['phone2'] = 'Mobilný telefón';
$string['phpinfo'] = 'PHP info';
$string['picture'] = 'Obrázok';
$string['pictureof'] = 'Obrázok: {$a}';
$string['pictureofuser'] = 'Obrázok používateľa';
$string['placeholdertypeorselect'] = 'Zadať alebo vybrať ...';
$string['pleaseclose'] = 'Prosím zavrite toto okno.';
$string['pleasesearchmore'] = 'Prosím pokračujte vo vyhľadávaní';
$string['pleaseusesearch'] = 'Prosím použite vyhľadávanie';
$string['plugin'] = 'Zásuvný modul';
$string['pluginarea'] = 'Plocha';
$string['plugincheck'] = 'Kontrola zásuvných modulov';
$string['plugindeletefiles'] = 'Všetky údaje prepojené s pluginom \'{$a->name}\' boli vymazané z databázy.  Aby ste predišli opätovnej samoinštalácii pluginu, mali by ste zo serveru vymazať nasledujúci adresár: {$a->directory}.  ';
$string['pluginitemid'] = 'ID položky';
$string['pluginmissingfromdisk'] = '{$a->name} (Chýba na disku)';
$string['pluginsetup'] = 'Nastavenie tabuliek zásuvných modulov';
$string['policyaccept'] = 'Rozumiem a súhlasím';
$string['policyagree'] = 'Najprv musíte súhlasiť s podmienkami používania tejto stránky. Súhlasíte s nimi?';
$string['policyagreement'] = 'Súhlas s podmienkami portálu';
$string['policyagreementclick'] = 'Odkaz na súhlas s podmienkami a politikou portálu';
$string['popup'] = 'vyskakovacie (popup) okno';
$string['popupwindow'] = 'Otvoriť súbor v novom okne';
$string['popupwindowname'] = 'Vyskakovacie (popup) okno';
$string['post'] = 'Diskusný príspevok';
$string['posts'] = 'Diskusné príspevky';
$string['potentialadmins'] = 'Potenciálni administrátori';
$string['potentialcreators'] = 'Potenciálni tvorcovia kurzov';
$string['potentialstudents'] = 'Potenciálni študenti';
$string['potentialteachers'] = 'Potenciálni učitelia';
$string['poweredbymoodle'] = 'Používa <a href="https://moodle.com"> Moodle </a>';
$string['preferences'] = 'Preferencie';
$string['preferredlanguage'] = 'Preferovaný jazyk';
$string['preferredtheme'] = 'Preferovaná téma';
$string['preprocessingbackupfile'] = 'Pripravujem súbor so zálohou';
$string['prev'] = 'Predchádzajúci';
$string['preview'] = 'Náhľad';
$string['previeworchoose'] = 'Prehliadať, alebo vybrať tému';
$string['previewthemename'] = 'Náhľad témy "{$a}"';
$string['previous'] = 'Predchádzajúci';
$string['previouslyselectedusers'] = 'Predošle vybraný používatelia sa nezhodujú s \'{$a}\'';
$string['previouspage'] = 'Predchádzajúca stránka';
$string['previoussection'] = 'Predchádzajúca sekcia';
$string['primaryadminsetup'] = 'Nastavenie účtu administrátora';
$string['privacy:metadata:config_log'] = 'Záznamy zmien konfigurácie.';
$string['privacy:metadata:config_log:name'] = 'Názov nastavenia zmien.';
$string['privacy:metadata:config_log:oldvalue'] = 'Predchádzajúca hodnota pre toto nastavenie.';
$string['privacy:metadata:config_log:plugin'] = 'Zásuvný modul bol zmenený.';
$string['privacy:metadata:config_log:timemodified'] = 'Čas uskutočnenia zmeny.';
$string['privacy:metadata:config_log:userid'] = 'Používateľ, ktorý uskutočnil zmenu.';
$string['privacy:metadata:config_log:value'] = 'Nová hodnota pre toto nastavenie.';
$string['privacy:metadata:events_queue'] = 'Fronta udalostí používateľa čakajúcich na spracovanie.';
$string['privacy:metadata:events_queue:eventdata'] = 'Údaje uložené v danej udalosti.';
$string['privacy:metadata:events_queue:stackdump'] = 'Akákoľvek stracktrace spojená s touto udalosťou.';
$string['privacy:metadata:events_queue:timecreated'] = 'Čas vytvorenia udalosti.';
$string['privacy:metadata:events_queue:userid'] = 'ID používateľa spojené s touto udalosťou';
$string['privacy:metadata:log'] = 'Zbierka minulých udalostí';
$string['privacy:metadata:log:action'] = 'Opis akcie';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurz';
$string['privacy:metadata:log:info'] = 'Dodatočné informácie';
$string['privacy:metadata:log:ip'] = 'IP adresa používaná v čase udalosti';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Čas uskutočnenia akcie';
$string['privacy:metadata:log:url'] = 'URL adresa týkajúca sa udalosti';
$string['privacy:metadata:log:userid'] = 'ID používateľa, ktorý vykonal akciu';
$string['privacy:metadata:moodlenet_share_progress'] = 'Podrobnosti o postupe zdieľania MoodleNet';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'ID pridruženého modulu kurzu';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'ID pridruženého kurzu';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Adresa URL vrátená zo siete MoodleNet po úspešnom zdieľaní';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Výsledný stav zdieľania';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Čas uskutočnenia zdieľania';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Typ zdieľanej položky, ktorá bola vykonaná';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Používateľ, ktorý vykonal zdieľanie';
$string['privacy:metadata:oauth2_refresh_token'] = 'Obnoviť token používaný v komunikácii OAuth 2.0';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'ID poskytovateľa, ktorému odpovedá token';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID používateľa, ktorému odpovedá token';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Čas, kedy bol vytvorený token';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Čas poslednej aktualizácie tokenu';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Obnovovací token pre príslušné rozsahy a používateľa';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID používateľa, ktorému je token priradený';
$string['privacy:metadata:task_adhoc'] = 'Stav adhoc úloh';
$string['privacy:metadata:task_adhoc:component'] = 'Komponent vlastniaci úlohu';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Najskorší čas spustenia úlohy.';
$string['privacy:metadata:task_adhoc:userid'] = 'Používateľ spúšťajúci úlohu';
$string['privacy:metadata:task_log'] = 'Výstup protokolu';
$string['privacy:metadata:task_log:component'] = 'Komponent vlastniaci úlohu';
$string['privacy:metadata:task_log:userid'] = 'Používateľ, ktorému patrí úloha';
$string['privacy:metadata:upgrade_log'] = 'Protokol o aktualizácii';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Akákoľvek backtrace spojená s týmto krokom aktualizácie';
$string['privacy:metadata:upgrade_log:details'] = 'Ďalšie informácie týkajúce sa aktualizácie.';
$string['privacy:metadata:upgrade_log:info'] = 'Hlavné informácie pre tento krok aktualizácie.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Zásuvný modul, ktorý bol aktualizovaný.';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Nová verzia pre aktualizáciu.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Čas, kedy bola uskutočnená aktualizácia.';
$string['privacy:metadata:upgrade_log:type'] = 'Typ záznamu protokolu.';
$string['privacy:metadata:upgrade_log:userid'] = 'Používateľ, ktorý spustil aktualizáciu.';
$string['privacy:metadata:upgrade_log:version'] = 'Stará verzia zásuvného modulu.';
$string['private_files_handler'] = 'Uložiť prílohy z e-mailu do súkromných súborov používateľa';
$string['private_files_handler_name'] = 'E-mail do súkromných súborov';
$string['privatefiles'] = 'Súkromné súbory';
$string['privatefilesmanage'] = 'Spravovať súkromné súbory';
$string['proceed'] = 'Pokračovať';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Tento profil nebude zobrazený dovtedy, kým nebude tento používateľ zapísaný minimálne do jedného kurzu.';
$string['progress'] = 'Pokrok';
$string['publicprofile'] = 'Verejný profil';
$string['publicsitefileswarning'] = 'Upozornenie: súbory tu umiestnené budú prístupné pre každého';
$string['publicsitefileswarning2'] = 'Poznámka: súbory tu uložené sú dostupné každému, kto pozná, alebo uhádne URL. Z dôvodov bezpečnosti je doporučované, aby boli súbory záloh okamžite vymazané potom, čo boli obnovené.';
$string['publicsitefileswarning3'] = 'Poznámka: Tu uložené súbory sú dostupné pre každého, kto vie (alebo uhádne) URL. <br />Z dôvodov bezpečnosti by mali byť súbory so zálohami uložené iba v bezpečnom adresári backupdata.';
$string['question'] = 'Otázka';
$string['questionsinthequestionbank'] = 'Otázky v banke otázok';
$string['queued'] = 'Vo fronte';
$string['quotausage'] = 'Práve ste použili {$a->used} z vášho {$a->total} limitu.';
$string['readinginfofrombackup'] = 'Načítať informácie zo zálohy';
$string['readme'] = 'Čítaj ma';
$string['recentactivity'] = 'Aktuálna činnosť';
$string['recentactivityreport'] = 'Kompletná správa o Vašej aktuálnej činnosti';
$string['recipientslist'] = 'Zoznam príjemcov';
$string['recommended'] = 'Odporúčané';
$string['recreatedcategory'] = 'Znovuvytvorená kategória {$a}';
$string['redirect'] = 'Presmerovať';
$string['reducesections'] = 'Znížiť počet sekcií';
$string['refresh'] = 'Obnoviť';
$string['refreshingevents'] = 'Obnovujú sa udalosti';
$string['registration'] = 'Registrácia Moodle';
$string['registrationcontact'] = 'Kontakt pre verejnosť';
$string['registrationcontactno'] = 'Nie, nechcem byť kontaktovaný inými ľuďmi.';
$string['registrationcontactyes'] = 'Áno, poskytnem formulár iných používateľov Moodle, aby ma mohli kontaktovať';
$string['registrationemail'] = 'Oznámenia cez e-mail';
$string['registrationinfo'] = '<p>Táto stránka dovoľuje registrovať Vašu Moodle
www stránku na domovskej stránke Moodle (moodle.org). Registrácia je bezplatná. Hlavnou výhodou registrácie je, že budete pridaní do slabo frekventovanej mail-konferencie, kde budú oznamované dôležité informácie (napr.problémy s bezpečnosťou alebo oznamy o nových verziách Moodle).</p>
<p>Vaše informácie budú len pre potrebu vývoja Moodle a nebudú šírené tretím osobám. Využijeme ich len na účely grantovej podpory a zisťovania štatistických údajov o Moodle komunite ako celku.</p>
<p>Ak chcete, môžete povoliť pridanie Vašej URL adresy, mena www stránky a krajiny do verejného zoznamu Moodle stránok.</p>
<p>Všetky nové registrácie sú overované manuálne predtým, než sú zaradené do zoznamu. Ak ste už zaradení, môžete kedykoľvek aktualizovať Vaše registračné odoslaním vyplneného formulára.</p>';
$string['registrationinfotitle'] = 'Informácie o registrácii';
$string['registrationsend'] = 'Poslať registračné informácie na domovskú stránku Moodle (moodle.org)';
$string['registrationyes'] = 'Áno, informujte ma o dôležitých Moodle udalostiach (nové verzie, bezpečnostné informácie a aktualizácie)';
$string['reject'] = 'Odmietnuť';
$string['rejectdots'] = 'Zamietnuť...';
$string['relativedatesmode'] = 'Režim relatívnych dátumov';
$string['relativedatesmode_help'] = 'Zobraziť údaje kurzu alebo aktivity vo vzťahu k dátumu začatia kurzu používateľom.

Dátum začatia kurzu používateľa bude dátum zápisu, ak nie je zapísaný pred začiatkom kurzu. V takom prípade bude dátum začatia začiatok kurzu.

VAROVANIE: Toto je experimentálna funkcia a nie všetky aktivity ju môžu podporovať. Po vytvorené kurzu už toto nastavení kurzu nie je možné zmeniť.';
$string['relativedatesmode_warning'] = '<strong> Upozornenie: </strong> Režim relatívnych dátumov nie je možné zmeniť po vytvorení kurzu.';
$string['reload'] = 'Reload';
$string['remoteappuser'] = 'Vzdialený používateľ {$a}';
$string['remove'] = 'Odstrániť';
$string['removeadmin'] = 'Odstrániť administrátora';
$string['removecreator'] = 'Odstrániť tvorcu kurzov';
$string['removestudent'] = 'Odstrániť študenta';
$string['removeteacher'] = 'Odstrániť učiteľa';
$string['rename'] = 'Premenovať';
$string['renamefileto'] = 'Premenovať <b>{$a}</b> na';
$string['report'] = 'Záznamy';
$string['reports'] = 'Záznamy';
$string['reporttype'] = 'Typ zostavy';
$string['repositories'] = 'Úložiská';
$string['requestcourse'] = 'Požiadať o vytvorenie nového kurzu';
$string['requestedby'] = 'Žiadané kým';
$string['requestedcourses'] = 'Žiadané kurzy';
$string['requestreason'] = 'Dôvod žiadosti';
$string['requests'] = 'Žiadosti';
$string['required'] = 'Požadované';
$string['requirespayment'] = 'Tento kurz vyžaduje zaplatenie poplatku pre vstup';
$string['resendemail'] = 'Opätovné odoslanie potvrdzujúceho e-mailu';
$string['reset'] = 'Reset';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Vyčistenie kurzu';
$string['resetinfo'] = 'Táto stránka dovoľuje vymazať užívateľské údaje z kurzu pri uchovaní aktivít a ostatných nastavení. Prosím všimnite si výber položiek nižšie. Ktoré z nich vyznačíte, tie budú navždy odstránené.';
$string['resetnotimplemented'] = 'Reset nie je implementovaný';
$string['resetrecordexpired'] = 'Odkaz na obnovu hesla je starší {$a} a jeho platnosť vypršala. Požiadajte o obnovu hesla znova.';
$string['resetstartdate'] = 'Vyčistiť začiatočný dátum';
$string['resetstatus'] = 'Stav';
$string['resettable'] = 'Obnoviť tabuľku predvolieb';
$string['resettask'] = 'Úloha';
$string['resettodefaults'] = 'Prestaviť na predvolené hodnoty';
$string['resortcourses'] = 'Zoradiť kurzy';
$string['resortsubcategoriesby'] = 'Zoradenie podkategórií od {$a} vzostupne';
$string['resortsubcategoriesbyreverse'] = 'Zoradenie podkategórií od {$a} zostupne';
$string['resource'] = 'Zdroj';
$string['resourcedisplayauto'] = 'Automaticky';
$string['resourcedisplaydownload'] = 'Vynútiť stiahnutie';
$string['resourcedisplayembed'] = 'Vložiť';
$string['resourcedisplayframe'] = 'V rámci';
$string['resourcedisplaynew'] = 'Nové okno';
$string['resourcedisplayopen'] = 'Otvoriť';
$string['resourcedisplaypopup'] = 'V novom okne';
$string['resources'] = 'Zdroje';
$string['resources_help'] = 'Rozličné zdroje umožňujú vloženie skoro ľubovoľného web obsahu do kurzu.';
$string['restore'] = 'Obnoviť zo zálohy';
$string['restorecancelled'] = 'Obnova zrušená';
$string['restorecannotassignroles'] = 'Pri obnove je potrebné priradiť roly a nemáte na to oprávnenie.';
$string['restorecannotcreateorassignroles'] = 'Pri obnove je potrebné vytvoriť alebo priradiť roly a nemáte na to oprávnenie.';
$string['restorecannotcreateuser'] = 'Obnova kurzu zo zálohovacieho súboru potrebuje vytvoriť používateľa \'{$a}\' a vy na to nemáte oprávnenie.';
$string['restorecannotoverrideperms'] = 'Pri obnove je potrebné prepísať oprávnenia a nemáte na to oprávnenie.';
$string['restorecoursenow'] = 'Obnoviť tento kurz teraz!';
$string['restoredaccount'] = 'Obnovené konto';
$string['restoredaccountinfo'] = 'Toto heslo bolo importované z iného servera, pričom sa nezachovalo heslo. Pre nastavenie nového hesla pomocou mailu kliknite na "Pokračovať".';
$string['restorefinished'] = 'Obnova prebehla úspešne';
$string['restoreinfo'] = 'Pomocou záložného súboru môžete obnoviť predchádzajúcu verziu kurzu alebo vytvoriť nový kurz.';
$string['restoremnethostidmismatch'] = 'Mnet ID používateľa \'{$a}\' neodpovedá lokálnemu Mnet ID hostiteľa.';
$string['restoreto'] = 'Obnoviť do';
$string['restoretositeadding'] = 'Upozornenie: Chystáte sa obnoviť titulnú stránku portálu a pridať k údaje k existujúcej!';
$string['restoretositedeleting'] = 'Upozornenie: Chystáte sa obnoviť titulnú stránku portálu a predtým vymazať údaje existujúcej!';
$string['restoreuserconflict'] = 'Pokus o obnovenie používateľa \'{$a}\' zo zálohovacieho súboru spôsobí konflikt.';
$string['restoreuserinfofailed'] = 'Proces obnovy kurzu bol zastavený, pretože nemáte oprávnenie obnoviť údaje používateľov.';
$string['restoreusersprecheck'] = 'Kontrolovanie používateľských údajov';
$string['restoreusersprecheckerror'] = 'Pri kontrole používateľských údajov boli zistené problémy';
$string['restricted'] = 'Obmedzený';
$string['resultsfound'] = 'Bolo nájdených {$a} výsledkov';
$string['retry'] = 'Opakovať';
$string['returningtosite'] = 'Vrátiť sa na túto webovú stránku?';
$string['returntooriginaluser'] = 'Návrat na {$a}';
$string['revert'] = 'Vrátiť';
$string['role'] = 'Rola';
$string['roleassignments'] = 'Priradenie rol';
$string['rolemappings'] = 'Mapovania rol';
$string['rolerenaming'] = 'Premenovanie rol';
$string['rolerenaming_help'] = 'Zmena zobrazovaných názvov rolí v tomto kurze.';
$string['rolerenaming_success'] = 'Názvy rolí kurzu boli aktualizované.';
$string['roles'] = 'Roly';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Počet aktuálnych RSS článkov';
$string['rsserror'] = 'Chyba pri čítaní RSS údajov';
$string['rsserrorauth'] = 'Váš RSS odkaz neobsahuje platný autentifikačný token';
$string['rsserrorguest'] = 'K tomuto zdroju správ pristupujete ako anonymní hostia. Tí ale nemajú právo čítať správy. Navštívte originálnu adresu zdroja týchto správ (URL) ako oprávnený užívateľ a získajte nový odkaz pre tento zdroj.';
$string['rsskeyshelp'] = '<p>Pre zaistenie ochrany a súkromia, odkazy RSS správ obsahujú špeciálny token, ktorý identifikuje užívateľa, pre ktorého sú určené. Toto zabráni ostatným užívateľom pred vstupom do oblastí Moodle, kde by tento prístup cez RSS nemali.</p><p>Tento token je automaticky vytvorený pri prvom vstupe do oblasti Moodle, ktorá produkuje RSS správy. V prípade, že Váš RSS token bol nejakým spôsobom ohrozený, môžete si vyžiadať nový, kliknutím na Resetovať odkaz. Po vygenerovaní nového tokenu budú všetky existujúce odkazy neplatné.</p>';
$string['rsstype'] = 'RSS kanály pre túto aktivitu';
$string['save'] = 'Uložiť';
$string['saveandnext'] = 'Uložiť a ísť ďalej';
$string['savechanges'] = 'Uložiť zmeny';
$string['savechangesanddisplay'] = 'Uložiť a zobraziť';
$string['savechangesandreturn'] = 'Uložiť a vrátiť sa späť';
$string['savechangesandreturntocourse'] = 'Uložiť a návrat do kurzu';
$string['savecomment'] = 'Uložiť komentár';
$string['savedat'] = 'Uložené:';
$string['savepreferences'] = 'Uložiť preferencie';
$string['saveto'] = 'Uložiť do';
$string['scale'] = 'Stupnica';
$string['scale_help'] = '<p>Učitelia môžu vytvárať pre hodnotenie jednotlivých činností v kurze vlastné
stupnice.</p>

<p>Názvom stupnice by malo byť slovné spojenie, ktoré ju jasne opisuje; názov sa
zobrazuje v zoznamoch pre výber stupnice a tiež na tlačidlách kontextovej
nápovedy.</p>

<p>Stupnica sama o sebe je definovaná vzostupným rozsahom hodnotenia, v ktorom sú
po jednom položky oddelené čiarkami. Príklad:</p>

<p class="indent">
  <i>Neuspokojivý, Dostatočný, Priemerný, Dobrý, Veľmi dobrý, Vynikajúci</i>
</p>

<p>Stupnice by mali tiež obsahovať opis jednotlivých stupňov hodnotenia a ich
použitia v praxi. Tento popis sa bude zobrazovať na stránkach nápovedy.</p>

<p>Vaše stránky môžu tiež mať jednu alebo viac "štandardných" stupníc, ktoré pre
celý systém definuje administrátor. Tieto stupnice budú k dispozícii vo všetkých
kurzoch.</p>';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Stupnice';
$string['scalescustom'] = 'Vlastná stupnica';
$string['scalescustomcreate'] = 'Pridať novú stupnicu';
$string['scalescustomno'] = 'Zatiaľ nebola vytvorená žiadna vlastná stupnica';
$string['scalesstandard'] = 'Štandardná stupnica';
$string['scalestandard'] = 'Štandardná stupnica';
$string['scalestandard_help'] = '<p>Štandardná stupnica je tá, ktorá je dostupná a použiteľná pre všetky kurzy.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Na vytvorenie vlastnej stupnice, použite odkaz \'Stupnice...\' vo Vašom administrátorskom menu kurzu.';
$string['scalestip2'] = 'Ak chcete vytvoriť vlastné stupnice, kliknite na odkaz Známky v bloku Administratíva a zvoľte si v menu príkaz Upraviť, Stupnice.';
$string['schedule'] = 'Zoznam';
$string['screenshot'] = 'Snímok obrazovky';
$string['search'] = 'Hľadať';
$string['search_help'] = 'Pre jednoduché vyhľadávanie jedného alebo viacerých slov hocikde v texte ich zadajte oddelené medzerami. Budú použité všetky, ktoré majú viac ako dva znaky.';
$string['searchactivities'] = 'Hľadať aktivity podľa názvu alebo opisu';
$string['searchagain'] = 'Hľadať opäť';
$string['searchbyemail'] = 'Vyhľadávať podľa emailovej adresy';
$string['searchbyusername'] = 'Vyhľadávať podľa používateľského mena';
$string['searchcoursecategories'] = 'Hľadať kategórie';
$string['searchcourses'] = 'Vyhľadať kurzy';
$string['searchgroups'] = 'Hľadať skupiny';
$string['searchitems'] = 'Hľadať položky';
$string['searchoptions'] = 'Možnosti vyhľadávania';
$string['searchresults'] = 'Výsledky hľadania';
$string['searchusers'] = 'Hľadať používateľov';
$string['sec'] = 'sekunda';
$string['seconds'] = 'sekundy';
$string['secondsleft'] = '{$a} sek';
$string['secondstotime172800'] = '2 dni';
$string['secondstotime259200'] = '3 dni';
$string['secondstotime345600'] = '4 dni';
$string['secondstotime432000'] = '5 dní';
$string['secondstotime518400'] = '6 dní';
$string['secondstotime604800'] = '1 týždeň';
$string['secondstotime86400'] = '1 deň';
$string['secretalreadyused'] = 'Odkaz na potvrdenie zmeny hesla už bol použitý. Heslo nebolo zmenené.';
$string['secs'] = 'sekundy/sekúnd';
$string['section'] = 'Sekcia';
$string['sectionactionnotsupported'] = 'Akcia "{$a}" nie je na tomto mieste podporovaná';
$string['sectionname'] = 'Názov sekcie';
$string['sectionoutline'] = 'Osnova sekcie';
$string['sections'] = 'Sekcie';
$string['seealsostats'] = 'Viď tiež: štatistiky';
$string['selctauser'] = 'Vyberte používateľa';
$string['select'] = 'Vybrať';
$string['selectacategory'] = 'Vyberte kategóriu';
$string['selectacountry'] = 'Vybrať krajinu';
$string['selectacourse'] = 'Vyberte kurz';
$string['selectacoursesite'] = 'Vyberte kurz alebo portál';
$string['selectagroup'] = 'Vyberte skupinu';
$string['selectall'] = 'Vybrať všetko';
$string['selectallusersonpage'] = 'Vyberte všetkých používateľov na tejto stránke';
$string['selectalluserswithcount'] = 'Vyberte všetkých {$a} používateľov';
$string['selectamodule'] = 'Prosím vyberte modul aktivity';
$string['selectanaction'] = 'Vyberte akciu';
$string['selectanoptions'] = 'Vyberte možnosť';
$string['selectaregion'] = 'Vybrať oblasť';
$string['selectcategorysort'] = 'Ktoré kategórie si prajete triediť?';
$string['selectcategorysortby'] = 'Vyberte, ako chcete triediť kategórie';
$string['selectcoursesortby'] = 'Vyberte, ako chcete triediť kurzy';
$string['selectdefault'] = 'Vyberte predvolený';
$string['selectedcategories'] = 'Vybrané kategórie';
$string['selectedfile'] = 'Vybraný súbor';
$string['selectednowmove'] = '{$a} súbory označené pre presun. Teraz prejdite na cieľové miesto a stlačte \'Presunúť súbory sem\'';
$string['selectfiles'] = 'Vybrať súbory';
$string['selectfiltertype'] = 'Vybrať';
$string['selectgroupsseparate'] = 'Vybrať oddelené skupiny';
$string['selectgroupsvisible'] = 'Vybrať viditeľné skupiny';
$string['selectitem'] = 'Vybrať "{$a}"';
$string['selectmoduletoviewhelp'] = 'Vyberte modul aktivity alebo zdroja na zobrazenie príslušnej nápovedy.

Dvojitým kliknutím na aktivitu alebo zdroj ho môžete pridať do kurzu.';
$string['selectnos'] = 'Vybrať všetky \'nie\'';
$string['selectperiod'] = 'Vybrať obdobie';
$string['selecttheme'] = 'Vybrať tému';
$string['selectthemename'] = 'Vybrať tému "{$a}"';
$string['senddetails'] = 'Posielať moje údaje prostredníctvom emailu';
$string['sent'] = 'Odoslané';
$string['separate'] = 'Individuálne';
$string['separateandconnected'] = 'Individuálne a vzťahové spôsoby poznávania';
$string['separateandconnectedinfo'] = 'Stupnica založená na teórii individuálneho a vzťahového poznávania. Táto teória opisuje dva nezávislé spôsoby, ako môžeme hodnotiť a učiť sa o veciach, ktoré vidíme alebo počujeme.
<ul>
<li><strong>Individuálne poznávanie</strong> ostáva čo najobjektívnejšie bez zahnutia pocitov a emócií. V diskusiách s inými ľuďmi takíto účastníci zvyčajne obhajujú svoje idey a využívajú diery v protivníkovej argumentácii.</li>
<li><strong>Vzťahové poznávanie</strong> charakterizuje ľudí citlivejších k ostatným. Sú zruční v empatii a väčšinou zvyknú počúvať a spytovať sa, až kým nechápu podstatu a "nerozumejú veci z ich smeru pohľadu". Učia sa snahou zdieľať skúsenosti, ktoré ich priviedli k vedomostiam naučeným od iných ľudí. </li>
</ul>';
$string['servererror'] = 'V komunikácii so serverom sa vyskytla chyba';
$string['serverlocaltime'] = 'Miestny čas serveru';
$string['sessionforceclean'] = 'V rámci tohto sedenia boli ako bezpečnostné opatrenia zakázané skripty generované používateľom';
$string['sessiontimeoutsoon'] = 'Vaše sedenie vyprší. Chcete v ňom pokračovať?';
$string['setcategorytheme'] = 'Vybrať tému kategórie';
$string['setmode'] = 'Nastaviť režim';
$string['setpassword'] = 'Nastaviť heslo';
$string['setpasswordinstructions'] = 'Zadajte prosím nové heslo a potom uložte zmeny.';
$string['settings'] = 'Nastavenia';
$string['share'] = 'Zdieľať';
$string['shortname'] = 'Skrátené meno';
$string['shortnamecollisionwarning'] = '[*] = Táto skratka je už použitá v inom kurze a musí byť zmenená.';
$string['shortnamecourse'] = 'Skrátené meno kurzu';
$string['shortnamecourse_help'] = 'Názov zobrazený v oblastiach s obmedzeným priestorom. Musí byť jedinečný.';
$string['shortnametaken'] = 'Krátke meno je už použité pre iný kurz ({$a})';
$string['shortnameuser'] = 'Krátke používateľské meno';
$string['shortsitename'] = 'Skrátený názov stránky  (napr. jedno slovo)';
$string['show'] = 'Zobraziť';
$string['showactions'] = 'Ukázať možnosti';
$string['showactivitydates'] = 'Zobraziť dátumy aktivity';
$string['showactivitydates_help'] = 'Zobraziť dátumy aktivít na stránke kurzu.';
$string['showadvancededitor'] = 'Rozšírené';
$string['showadvancedsettings'] = 'Zobraziť rozšírené nastavenia';
$string['showall'] = 'Zobraziť všetky {$a}';
$string['showallcourses'] = 'Zobraziť všetky kurzy';
$string['showallusers'] = 'Zobraziť všetkých používateľov';
$string['showblockcourse'] = 'Zobraziť zoznam kurzov s blokmi';
$string['showcategory'] = 'Zobraziť {$a}';
$string['showchartdata'] = 'Zobraziť údaje grafu';
$string['showcomments'] = 'Ukázať/skryť komentáre';
$string['showcommentsnonjs'] = 'Ukázať komentáre';
$string['showdescription'] = 'Zobraziť opis na titulnej stránke kurzu';
$string['showdescription_help'] = 'Či sa má vyššie vložený úvodný opis zobraziť na stránke kurzu pod odkazom na príslušnú aktivitu alebo študijného materiálu.';
$string['showgrades'] = 'Zobraziť študentom výkaz známok';
$string['showgrades_help'] = 'Umožniť študentom zobraziť zoznam všetkých ich známok z kurzov.';
$string['showingacourses'] = 'Ukázať všetky {$a} kurzy';
$string['showingxofycourses'] = 'Ukázať kurzy od {$a->start} do {$a->end} z {$a->total} kurzov';
$string['showless'] = 'Zobraziť menej';
$string['showlistofcourses'] = 'Zobraziť zoznam kurzov';
$string['showmodulecourse'] = 'Zobraziť zoznam kurzov s aktivitami';
$string['showmore'] = 'Zobraziť viac';
$string['showoncoursepage'] = 'Zobraziť na stránke kurzu';
$string['showonly'] = 'Zobraziť iba';
$string['showperpage'] = 'Zobraziť {$a} na jednej stránke';
$string['showpopoverwindow'] = 'Zobraziť vyskakovacie okno';
$string['showrecent'] = 'Zobraziť aktuálnu činnosť';
$string['showreports'] = 'Zobraziť správu o aktivitách';
$string['showreports_help'] = 'Umožniť študentom prezerať si správy o vlastnej činnosti prostredníctvom ich profilovej stránky.';
$string['showsettings'] = 'Zobraziť nastavenia';
$string['showtheselogs'] = 'Zobraziť tieto prihlásenia';
$string['showthishelpinlanguage'] = 'Ukázať túto nápovedu v jazyku: {$a}';
$string['sidepanel'] = 'Bočný panel';
$string['signoutofotherservices'] = 'Odhláste sa zo všetkých webových aplikácií';
$string['signoutofotherservices_help'] = 'Odhláste sa zo všetkých zariadení a systémov, ktoré používajú webové služby, napríklad z mobilnej aplikácie. Relácie prehliadača zostanú aktívne.';
$string['since'] = 'Od';
$string['sincelast'] = 'od posledného prihlásenia';
$string['site'] = 'Portál';
$string['sitedefault'] = 'Východzia stránka portálu';
$string['sitedefaultspecified'] = 'Výchozia stránka ({$a})';
$string['siteerrors'] = 'Chyby na stránke';
$string['sitefiles'] = 'Súbory stránky';
$string['sitefilesused'] = 'Súbory portálu použité v tomto kurze';
$string['sitehome'] = 'Domovská stránka';
$string['sitelegacyfiles'] = 'Zdedené (legacy) súbory portálu';
$string['sitelogs'] = 'Záznamy o prihláseniach na stránku';
$string['sitenews'] = 'Oznámenia portálu';
$string['sitepages'] = 'Stránky portálu';
$string['sitepartlist'] = 'Nemáte požadované oprávnenie prezerať zoznam účastníkov';
$string['sitepartlist0'] = 'Musíte byť učiteľom stránky, aby ste si mohli prezerať zoznam účastníkov stránky';
$string['sitepartlist1'] = 'Musíte byť učiteľom, aby ste si mohli prezerať zoznam účastníkov stránky';
$string['sites'] = 'Stránky';
$string['sitesection'] = 'Pridať vlastný obsah';
$string['sitesettings'] = 'Miestne nastavenia';
$string['siteteachers'] = 'Učitelia stránky';
$string['size'] = 'Veľkosť';
$string['sizeb'] = 'bajty';
$string['sizegb'] = 'GB';
$string['sizekb'] = 'KB';
$string['sizemb'] = 'MB';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Preskočené';
$string['skiptocategorylisting'] = 'Prejsť na zoznam kategórií';
$string['skiptocoursedetails'] = 'Prejsť na podrobné informácie o kurze';
$string['skiptocourselisting'] = 'Prejsť na zoznam kurzov';
$string['socialheadline'] = 'Sociálne fórum - posledné témy';
$string['someallowguest'] = 'Niektoré kurzy môžu povoliť vstup hostí';
$string['someerrorswerefound'] = 'Niektoré informácie chýbali, alebo neboli správne. Pozrite nižšie pre podrobnosti.';
$string['sort'] = 'Roztriediť';
$string['sortby'] = 'Roztriediť podľa';
$string['sortbyx'] = 'Roztriediť podľa {$a} vzostupne';
$string['sortbyxreverse'] = 'Roztriediť podľa {$a} zostupne';
$string['sorting'] = 'Triedenie';
$string['sourcerole'] = 'Zdrojová rola';
$string['specifyname'] = 'Musíte uviesť meno.';
$string['standard'] = 'Štandardný';
$string['starpending'] = '([*] = kurz čaká na akceptáciu)';
$string['startdate'] = 'Dátum začiatku kurzu';
$string['startdate_help'] = 'Tento dátum určuje začiatok prvého týždňa kurzu v týždennom formáte. Je to aj dátum začiatku pre protikoly aktivít kurzu.

Ak obnovíte kurz a zmeníte tento dátum, všetky dátumy v kurze sa presunú vzhľadom na nový dátum začiatku.';
$string['startdatewithtaskenabled'] = 'Dátum začiatku kurzu';
$string['startdatewithtaskenabled_help'] = 'Dátum, od ktorého je kurz viditeľný pre študentov. Pred týmto dátumom nebudú mať ku kurzu prístup.

Tento dátum určuje aj začiatok prvého týždňa pre kurz v týždennom formáte a je dátumom začiatku pre protokoly aktivít kurzu. Ak obnovíte kurz a zmeníte tento dátum, všetky dátumy v kurze sa posunú vzhľadom na nový dátum začiatku.';
$string['startingfrom'] = 'Začínajúci z';
$string['startsignup'] = 'Začnite teraz vytvorením nového účtu!';
$string['state'] = 'Štát/VÚC';
$string['statistics'] = 'Štatistika';
$string['statisticsgraph'] = 'Graf štatistík';
$string['stats'] = 'Štatistika';
$string['statslogins'] = 'Prihlásenia';
$string['statsmodedetailed'] = 'Detailný (používateľský) pohľad';
$string['statsmodegeneral'] = 'Všeobecný pohľad';
$string['statsnodata'] = 'Pre túto kombináciu kurzu a časového intervalu nie sú v databáze žiadne údaje.';
$string['statsnodatauser'] = 'Pre túto kombináciu kurzu, používateľa a časového intervalu nie sú v databáze žiadne údaje.';
$string['statsoff'] = 'Štatistiky nie sú v súčasnosti povolené';
$string['statsreads'] = 'Pohľady';
$string['statsreport1'] = 'Prihlásenia';
$string['statsreport10'] = 'Aktivita používateľov';
$string['statsreport11'] = 'Najaktívnejšie kurzy';
$string['statsreport12'] = 'Najaktívnejšie kurzy (vážené)';
$string['statsreport13'] = 'Najviac používateľov (v kurze)';
$string['statsreport14'] = 'Kurzy s najvyššou participáciou (podľa pomeru príspevky/pohľady)';
$string['statsreport2'] = 'Náhľady (učitelia a študenti)';
$string['statsreport3'] = 'Diskusie (učitelia a študenti)';
$string['statsreport4'] = 'Všetky aktivity (učitelia a študenti)';
$string['statsreport5'] = 'Všetky študentské aktivity (pohľady a diskusie)';
$string['statsreport7'] = 'Používateľské aktivity (pohľady a diskusie)';
$string['statsreport8'] = 'Všetky aktivity používateľa';
$string['statsreport9'] = 'Prihlásenia (na portáli)';
$string['statsreportactivity'] = 'Všetky aktivity (učitelia a študenti)';
$string['statsreportactivitybyrole'] = 'Všetky aktivity (pohľady a diskusie)';
$string['statsreportforuser'] = 'pre';
$string['statsreportlogins'] = 'Prihlásenia';
$string['statsreportreads'] = 'Všetky aktivity (učitelia a študenti)';
$string['statsreporttype'] = 'Typ záznamov';
$string['statsreportwrites'] = 'Diskusie (učitelia a študenti)';
$string['statsstudentactivity'] = 'Študentské aktivity';
$string['statsstudentreads'] = 'Študentské náhľady';
$string['statsstudentwrites'] = 'Študentské diskusie';
$string['statsteacheractivity'] = 'Učiteľské aktivity';
$string['statsteacherreads'] = 'Učiteľské náhľady';
$string['statsteacherwrites'] = 'Učiteľské diskusie';
$string['statstimeperiod'] = 'Obdobie - posledné:';
$string['statsuniquelogins'] = 'Jedinečné prihlásenia';
$string['statsuseractivity'] = 'Všetky aktivity';
$string['statsuserlogins'] = 'Prihlásenia';
$string['statsuserreads'] = 'Náhľady';
$string['statsuserwrites'] = 'Diskusie';
$string['statswrites'] = 'Príspevky';
$string['status'] = 'Status';
$string['statuschecks'] = 'Kontroly stavu';
$string['statuscritical'] = 'Kritický';
$string['statuserror'] = 'Chyba';
$string['statusinfo'] = 'Informácia';
$string['statusna'] = 'N/A';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Neznáme';
$string['statuswarning'] = 'Upozornenie';
$string['stringsnotset'] = 'Nasledovné spojenia nie sú definované v {$a}';
$string['studentnotallowed'] = 'Prepáčte, nemôžete vstúpiť do tohto kurzu ako \'{$a}\'';
$string['students'] = 'Študenti';
$string['studentsandteachers'] = 'Študenti a učitelia';
$string['subcategories'] = 'Podkategórie';
$string['subcategory'] = 'Podkategória';
$string['subcategoryof'] = 'Podkategória {$a}';
$string['subject'] = 'Predmet';
$string['submit'] = 'Odovzdať';
$string['success'] = 'Úspech';
$string['successduration'] = 'Úspech ({$a} sekúnd)';
$string['summary'] = 'Zhrnutie';
$string['summary_help'] = '<p>Súhrn je krátky text, ktorý by mal pripraviť študentov na činnosť v rámci
danej témy/týždňa.</p>

<p>Súhrn by mal byť čo najkratší, aby sa hlavná stránka kurzu neúmerne
nepredlžovala.</p>

<p>Ak sa domnievate, že daná téma vyžaduje podrobnejší opis, môže byť
vhodnejšie uložiť ho ako samostatný materiál a do témy vložiť iba
odkaz.</p>';
$string['summaryof'] = 'Zhrnutie z  {$a}';
$string['suspended'] = 'Pozastavený';
$string['suspendedusers'] = 'Pozastavení používatelia';
$string['switchdevicedefault'] = 'Prepnúť na štandardnú tému';
$string['switchdevicerecommended'] = 'Prepnúť na odporúčanú tému pre Vaše zaradenie';
$string['switchrolereturn'] = 'Návrat do mojej pôvodnej roly';
$string['switchroleto'] = 'Prepnúť rolu na ...';
$string['switchroleto_help'] = 'Vyberte rolu, aby ste získali predstavu o tom, ako niekto s touto rolou uvidí kurz.

Avšak, tento pohľad nemusí byť dokonalý (<a href="https://docs.moodle.org/en/Switch_roles">Zobraziť podrobnosti a alternatívy</a>).';
$string['tag'] = 'Tag';
$string['tagalready'] = 'Toto kľúčové slovo už existuje';
$string['tagmanagement'] = 'Pridať/vymazať tagy';
$string['tags'] = 'Tagy';
$string['targetrole'] = 'Cieľová rola';
$string['teacheronly'] = 'iba pre {$a}';
$string['teacherroles'] = '{$a} úlohy';
$string['teachers'] = 'Učitelia';
$string['textcopiedtoclipboard'] = 'Text skopírovaný do schránky';
$string['textediting'] = 'Textový editor';
$string['textediting_help'] = 'Ak je vybraný HTML editor ako napr. Atto či TinyMCE, vstupné pole textu bude mať panel nástrojov s tlačítkami pre jednoduché pridávanie obsahu.

Ak je zvolený formát "Jednoduchý text ", pre zadávanie textu možno zvoliť formát ako je HTML alebo Markdown.

Zoznam dostupných textových editorov je určený administrátorom portálu.';
$string['texteditor'] = 'Používajte štandardné webové formáty';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Čisto textový formát';
$string['thanks'] = 'Vďaka';
$string['theme'] = 'Téma';
$string['themepreviewdescription'] = '{$a} opis témy';
$string['themepreviewimage'] = '{$a} obrázok náhľadu';
$string['themes'] = 'Témy';
$string['themesaved'] = 'Nová téma uložená';
$string['therearecourses'] = 'Existuje {$a} kurzov';
$string['thereareno'] = 'V tomto kurze nie sú žiadne {$a}';
$string['thiscategory'] = 'Táto kategória';
$string['thiscategorycontains'] = 'Táto kategórie obsahuje';
$string['time'] = 'Čas';
$string['timecreated'] = 'Čas vytvorenia';
$string['timecreatedcourse'] = 'Časový priebeh kurzu bol vytvorený';
$string['timesplitting:deciles'] = 'Posledná desatina';
$string['timesplitting:deciles_help'] = 'Táto intervalová analýza rozdeľuje kurz na desatiny (10 rovnakých častí), v ktorých sú predpovede vytvárané na základe údajov iba z predchádzajúcej desatiny.';
$string['timesplitting:decilesaccum'] = 'Všetky predchádzajúce desatiny';
$string['timesplitting:decilesaccum_help'] = 'Táto intervalová analýza rozdeľuje kurz na desatiny (10 rovnakých častí), v ktorých sú predpovede vytvárané na základe údajov zo všetkých predchádzajúcich desatín.';
$string['timesplitting:nosplitting'] = 'Bez časového limitu';
$string['timesplitting:nosplitting_help'] = 'V tomto modeli nie je definovaná žiadna intervalová analýza.';
$string['timesplitting:onemonthafterstart'] = 'Jeden mesiac po začiatku';
$string['timesplitting:onemonthafterstart_help'] = 'Tento interval analýzy generuje predikciu 1 mesiac po analyzovateľnom začiatku.';
$string['timesplitting:oneweekafterstart'] = 'Jeden týždeň po začiatku';
$string['timesplitting:oneweekafterstart_help'] = 'Tento interval analýzy generuje predikciu 1 týždeň po analyzovateľnom začiatku.';
$string['timesplitting:past3days'] = 'Posledné 3 dni';
$string['timesplitting:past3days_help'] = 'Tento interval analýzy generuje predikciu každé 3 dni. Výpočty ukazovateľov budú založené na posledných 3 dňoch.';
$string['timesplitting:pastmonth'] = 'Minulý mesiac';
$string['timesplitting:pastmonth_help'] = 'Tento interval analýzy generuje predikciu každý mesiac. Výpočty ukazovateľov budú založené na minulom mesiaci.';
$string['timesplitting:pastweek'] = 'Minulý týždeň';
$string['timesplitting:pastweek_help'] = 'Tento interval analýzy generuje predikciu každý týždeň. Výpočty ukazovateľov budú založené na minulom týždni.';
$string['timesplitting:quarters'] = 'Posledná štvrtina';
$string['timesplitting:quarters_help'] = 'Táto intervalová analýza rozdeľuje kurz na štvrtiny (4 rovnaké časti), v ktorých sú predpovede vytvárané na základe údajov iba z najnovšej predchádzajúcej štvrtiny.';
$string['timesplitting:quartersaccum'] = 'Všetky predošlé štrvtiny';
$string['timesplitting:quartersaccum_help'] = 'Táto intervalová analýza rozdeľuje kurz na štvrtiny (4 rovnaké časti), v ktorých sú predpovede vytvárané na základe údajov zo všetkých predchádzajúcich štvrtín.';
$string['timesplitting:singlerange'] = 'Od začiatku do konca';
$string['timesplitting:singlerange_help'] = 'Táto intervalová analýza považuje celý kurz za jeden časový úsek.';
$string['timesplitting:tenpercentafterstart'] = '10% po štarte';
$string['timesplitting:tenpercentafterstart_help'] = 'Tento interval analýzy generuje predikciu po dokončení 10% kurzu.';
$string['timesplitting:upcoming3days'] = 'Nadchádzajúce 3 dni';
$string['timesplitting:upcoming3days_help'] = 'Tento interval analýzy generuje predikciu každé 3 dni. Výpočty ukazovateľov budú založené na nasledujúcich 3 dňoch.';
$string['timesplitting:upcomingfortnight'] = 'Nadchádzajúce 2 týždne';
$string['timesplitting:upcomingfortnight_help'] = 'Tento interval analýzy generuje predikciu každé 3 dni. Výpočty ukazovateľov budú založené na nasledujúcich 3 dňoch.';
$string['timesplitting:upcomingweek'] = 'Nadchádzajúci týždeň';
$string['timesplitting:upcomingweek_help'] = 'Tento interval analýzy generuje predikciu každý týždeň. Výpočty ukazovateľov budú založené z nadchádzajúceho týždňa.';
$string['timezone'] = 'Časové pásmo';
$string['to'] = 'Do';
$string['tocontent'] = 'Na položku "{$a}"';
$string['tocreatenewaccount'] = 'Preskočiť na vytvorenie nového konta ';
$string['todate'] = 'Do';
$string['today'] = 'Dnes';
$string['todaylogs'] = 'Dnešné záznamy';
$string['toeveryone'] = 'pre všetkých';
$string['toggleemojipicker'] = 'Prepnúť výber emoji.';
$string['togglesearch'] = 'Prepnúť vyhľadávanie';
$string['toomanybounces'] = 'Táto emailová adresa má veľa chýb. <b>Musíte</b>ju opraviť, aby ste mohli ďalej pokračovať.';
$string['toomanytags'] = 'Vyhľadávací reťazec obsahuje príliš veľa slov, niektoré budú ignorované.';
$string['toomanytoshow'] = 'Je priveľa používateľov, aby mohli byť zobrazení';
$string['toomanyusersmatchsearch'] = 'Príliš veľa používateľov ({$a->count}) vyhovuje \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'Príliš veľa používateľov ({$a}) na zobrazenie';
$string['toonly'] = 'iba pre {$a}';
$string['top'] = 'Vrch';
$string['topic'] = 'Téma';
$string['topichide'] = 'Ukryť túto položku od  {$a}';
$string['topicoutline'] = 'Prehľad témy';
$string['topicshow'] = 'Ukázať túto položku {$a}';
$string['toplevelcategory'] = 'Kategória najvyššej úrovne';
$string['torecipient'] = 'Do';
$string['total'] = 'Spolu';
$string['totopofsection'] = 'Na začiatok sekcie "{$a}"';
$string['trackforums'] = 'Sledovanie fór';
$string['trackforumsno'] = 'Nie: nezachovaj sledovanie príspevkov ktoré som už videl';
$string['trackforumsyes'] = 'Áno: zvýrazni pre mňa nové príspevky';
$string['trysearching'] = 'Skúste vyhľadávanie namiesto toho';
$string['turneditingoff'] = 'Vypnúť upravovanie';
$string['turneditingon'] = 'Zapnúť upravovanie';
$string['unabletocopytoclipboard'] = 'Nie je možné skopírovať text do schránky';
$string['unauthorisedlogin'] = 'Používateľský účet "{$a}" nie je na tejto stránke dostupný';
$string['undecided'] = 'Nerozhodnutý';
$string['unexistingcmid'] = 'ID modulu kurzu nebol nájdený';
$string['unexistingsectionid'] = 'ID sekcia kurzu nebola nájdená';
$string['unfinished'] = 'Neukončený';
$string['unknowncategory'] = 'Neznáma kategória';
$string['unknownerror'] = 'Neznáma chyba';
$string['unknownuser'] = 'Neznámy používateľ';
$string['unlimited'] = 'Neohraničený';
$string['unpacking'] = 'Rozbaľujem  {$a}';
$string['unsafepassword'] = 'Heslo nie je bezpečné - skúste niečo iné';
$string['untilcomplete'] = 'Kým neukončí';
$string['unusedaccounts'] = 'Kontá nepoužívané viac než {$a} dní sú automaticky odhlásené';
$string['unzip'] = 'Rozbaliť';
$string['unzippingbackup'] = 'Rozzipovať zálohu';
$string['up'] = 'Hore';
$string['update'] = 'Aktualizovať';
$string['updated'] = 'Aktualizované {$a}';
$string['updatemymoodleoff'] = 'Koniec úprav stránky';
$string['updatemymoodleon'] = 'Začiatok úprav stránky';
$string['updatemyprofile'] = 'Aktualizovať profil';
$string['updatesevery'] = 'Aktualizuje každých {$a} sekúnd';
$string['updatethis'] = 'Aktualizovať {$a}';
$string['updatethiscourse'] = 'Aktualizovať tento kurz';
$string['updatinga'] = 'Aktualizácia: {$a}';
$string['updatingain'] = 'Aktualizácia: {$a->what} v {$a->in}';
$string['upload'] = 'Preniesť';
$string['uploadafile'] = 'Preniesť súbor';
$string['uploadcantwrite'] = 'Nepodarilo sa zapísať súbor na disk';
$string['uploadedfile'] = 'Súbor bol úspešne prenesený';
$string['uploadedfileto'] = 'Preniesť {$a->file} do {$a->directory}';
$string['uploadedfiletoobig'] = 'Prepáčte, ale tento súbor je veľmi veľký (limit je {$a} bytov)';
$string['uploadextension'] = 'Nahranie súboru bolo zrušené nejakým PHP rozšírením';
$string['uploadfailednotrecovering'] = 'Váš prenos súboru nebol úspešný, pretože sa tu vyskytol problém s jedným z týchto súborov, {$a->name}.<br />
Tu je záznam tohto problému:<br />
{$a->problem}<br />
Proces sa už nebude opakovať';
$string['uploadfilelog'] = 'Preniesť záznam pre súbor {$a}';
$string['uploadformlimit'] = 'Prenášaný súbor {$a} prekročil povolenú nastavenú maximálnu veľkosť';
$string['uploadlabel'] = 'Nadpis:';
$string['uploadlimitwithsize'] = 'Rovnaké obmedzenie veľkosti ako pre: {$a->contextname} ({$a->displaysize})';
$string['uploadnewfile'] = 'Nahrať nový súbor';
$string['uploadnofilefound'] = 'Nebol nájdený súbor - ste si istý, že ste nejaký vybrali na prenos?';
$string['uploadnotallowed'] = 'Prenosy nie sú povolené';
$string['uploadnotempdir'] = 'Chýbajúci dočasný adresár';
$string['uploadoldfilesdeleted'] = 'Starý súbor (súbory) boli vymazané';
$string['uploadpartialfile'] = 'Súbor bol prenesený len čiastočne';
$string['uploadproblem'] = 'Pri prenose súboru \'{$a}\' sa vyskytol neznámy problém (možno bol súbor príliš veľký)';
$string['uploadrenamedchars'] = 'Súbor bol premenovaný z {$a->oldname} na {$a->newname} kvôli neplatným znakom.';
$string['uploadrenamedcollision'] = 'Súbor bol premenovaný z {$a->oldname} na {$a->newname}, pretože sa tu vyskytol problém v mene súboru.';
$string['uploadserverlimit'] = 'Prenášaný súbor prekročil povolenú maximálnu veľkosť nastavenú serverom';
$string['uploadthisfile'] = 'Preniesť tento súbor';
$string['url'] = 'URL';
$string['used'] = 'Použitý';
$string['usedinnplaces'] = 'Použité v {$a} miestach';
$string['user'] = 'Používateľ';
$string['useraccount'] = 'Používateľský účet';
$string['useractivity'] = 'Aktivita';
$string['userconfirmed'] = 'Potvrdené {$a}';
$string['userdata'] = 'Údaje používateľa';
$string['userdeleted'] = 'Toto používateľské konto bolo odstránené';
$string['userdescription'] = 'Opis';
$string['userdescription_help'] = 'Toto pole umožňuje vložiť text, ktorý sa potom zobrazí vo vašom profile všetkých používateľom. ';
$string['userdetails'] = 'Podrobnosti používateľa';
$string['userfiles'] = 'Súbory používateľa';
$string['userlist'] = 'Zoznam používateľov';
$string['usermatchedon'] = 'Tento používateľ zodpovedá vyhľadávaniu pomocou nasledujúceho poľa';
$string['usermenu'] = 'Používateľské menu';
$string['usermenugoback'] = 'Návrat do používateľského menu';
$string['username'] = 'Používateľské meno';
$string['usernameemail'] = 'Používateľské meno alebo email';
$string['usernameemailmatch'] = 'Toto meno a mailová adresa nie sú pre jedného používateľa.';
$string['usernameexists'] = 'Toto používateľské meno už existuje, vyberte si nové';
$string['usernamelowercase'] = 'Sú povolené iba písmená malej abecedy';
$string['usernamenotfound'] = 'Meno používateľa nebolo nájdené v databáze';
$string['usernameoremail'] = 'Zadajte alebo login alebo email';
$string['usernotconfirmed'] = 'Nemožno potvrdiť {$a}';
$string['userpic'] = 'Obrázok používateľa';
$string['userpreferences'] = 'Používateľské preferencie';
$string['users'] = 'Používatelia';
$string['userselectorautoselectunique'] = 'Ak sa iba jeden používateľ zhoduje s vyhľadávaním,  ostatných zvoľte automaticky. ';
$string['userselectorpreserveselected'] = 'Uchovať zvolených používateľov, aj keď sa nezhodujú s vyhľadávaním';
$string['userselectorsearchanywhere'] = 'Kdekoľvek';
$string['userselectorsearchexactmatchonly'] = 'iba presné zhody';
$string['userselectorsearchfromstart'] = 'od začiatku';
$string['userselectorsearchmatching'] = 'Zhody:';
$string['usersnew'] = 'Noví používatelia';
$string['usersnoaccesssince'] = 'Zobraziť používateľov, ktorí neboli aktívni viac ako';
$string['userswithfiles'] = 'Používatelia so súbormi';
$string['useruploadtype'] = 'Typ nahrania používateľa: {$a}';
$string['userzones'] = 'Používateľské zóny';
$string['usetheme'] = 'Použiť tému';
$string['usingexistingcourse'] = 'Použiť existujúci kurz';
$string['validatehtml'] = 'Validovať HTML';
$string['valuealreadyused'] = 'Táto hodnota už bola použitá.';
$string['version'] = 'Verzia';
$string['view'] = 'Náhľad';
$string['viewallcourses'] = 'Zobraziť všetky kurzy';
$string['viewallcoursescategories'] = 'Zobraziť všetky kurzy a kategórie';
$string['viewallresults'] = 'Zobraziť všetky výsledky ({$a})';
$string['viewallsubcategories'] = 'Zobraziť všetky podkategórie';
$string['viewfileinpopup'] = 'Zobraziť súbor v novom okne';
$string['viewing'] = 'Prehľad:';
$string['viewmore'] = 'Zobraziť viac';
$string['viewprofile'] = 'Zobraziť profil';
$string['viewresults'] = 'Zobraziť výsledky pre {$a}';
$string['views'] = 'Náhľady';
$string['viewsolution'] = 'prezrieť si riešenie';
$string['visible'] = 'Viditeľné';
$string['visible_help'] = 'Táto voľba vám umožňuje kurz skryť, aby sa nezobrazoval v zozname kurzov. Vstúpiť doň potom môžu iba učitelia a administrátori.';
$string['visibletostudents'] = 'Viditeľné pre {$a}';
$string['warning'] = 'Upozornenie';
$string['warningdeleteresource'] = 'Upozornenie: Na {$a} sa odkazuje v inom zdroji. Prajete si ho aktualizovať?';
$string['wcagcheck'] = 'Kontrola pokynov pre prístupnosť webového obsahu (WCAG).';
$string['webpage'] = 'Webová stránka';
$string['week'] = 'Týždeň';
$string['weekhide'] = 'Ukryť tento týždeň pred {$a}';
$string['weeklyoutline'] = 'Týždenný prehľad';
$string['weeks'] = 'týždňov';
$string['weekshow'] = 'Ukázať tento týždeň {$a}';
$string['welcomeback'] = 'Vitajte, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Vitajte v kurze {$a}';
$string['welcometocoursetext'] = 'Vitajte v kurze {$a->coursename}!

Jednou z prvých vecí, ktoré by ste mali urobiť, je úprava Vašej profilovej stránku v rámci kurzu, aby sme sa mohli o Vás niečo viac dozvedieť:

<a href="{$a->profileurl}">{$a->profileurl}<a>';
$string['welcometosite'] = 'Vitajte, {$a->firstname}! 👋';
$string['whatforlink'] = 'Co chcete urobiť s týmto odkazom?';
$string['whatforpage'] = 'Co chcete urobiť s týmto textom?';
$string['whatisyourage'] = 'Aký je váš vek?';
$string['whattocallzip'] = 'Ako chcete pomenovať zip súbor?';
$string['whattodo'] = 'Čo robiť';
$string['wheredoyoulive'] = 'V ktorej krajine žijete?';
$string['whyisthisrequired'] = 'Prečo je toto potrebné?';
$string['windowclosing'] = 'Toto okno by sa malo automaticky zatvoriť. Ak sa tak nestane, prosím zatvorte ho.';
$string['withchosenfiles'] = 'So zvolenými súbormi';
$string['withdisablednote'] = '{$a} (vypnuté)';
$string['withoutuserdata'] = 'bez údajov používateľa';
$string['withselectedusers'] = 'S označenými používateľmi...';
$string['withuserdata'] = 's údajmi používateľa';
$string['wontrunfuturescheduledtask'] = 'Nespustí sa úloha, ktorá nezlyhala, a ktorej spustenie je naplánované v budúcnosti';
$string['wordforstudent'] = 'Vaše označenie pre študenta';
$string['wordforstudenteg'] = 'Napr. študent, účastník atď.';
$string['wordforstudents'] = 'Vaše označenie pre študentov';
$string['wordforstudentseg'] = 'Napr. študenti, účastníci atď.';
$string['wordforteacher'] = 'Vaše označenie pre učiteľa';
$string['wordforteachereg'] = 'Napr. učiteľ, tútor, facilitátor atď.';
$string['wordforteachers'] = 'Vaše označenie pre učiteľov';
$string['wordforteacherseg'] = 'Napr. učitelia, tútori, facilitátori atď.';
$string['writingblogsinfo'] = 'Zapisujú sa informácie o blogoch';
$string['writingcategoriesandquestions'] = 'Zapisujú sa  kategórie a otázky';
$string['writingcoursedata'] = 'Zapisujú sa  údaje kurzu';
$string['writingeventsinfo'] = 'Zapisujú sa informácie o udalostiach';
$string['writinggeneralinfo'] = 'Zapisujú sa  základné informácie';
$string['writinggradebookinfo'] = 'Zapisujú sa informácie do knihy bodov';
$string['writinggroupingsgroupsinfo'] = 'Zapisujú sa informácie o skupinách a zoskupeniach';
$string['writinggroupingsinfo'] = 'Zapisujú sa informácie o zoskupeniach';
$string['writinggroupsinfo'] = 'Zapisujú sa informácie o skupinách';
$string['writingheader'] = 'Zapisujú sa  hlavičky';
$string['writingloginfo'] = 'Zapisujú sa  informácie o prístupoch';
$string['writingmessagesinfo'] = 'Zapisujú sa informácie pre správy';
$string['writingmoduleinfo'] = 'Zapisujú sa  informácie o moduloch';
$string['writingscalesinfo'] = 'Zapisujú sa informácie o stupniciach';
$string['writinguserinfo'] = 'Zapisujú sa  informácie o používateľoch';
$string['wrongpassword'] = 'Nesprávne heslo pre tohto používateľa';
$string['year'] = 'rok';
$string['years'] = 'roky';
$string['yes'] = 'Áno';
$string['youareabouttocreatezip'] = 'Práve sa chystáte vytvoriť zip súbor obsahujúci';
$string['youaregoingtorestorefrom'] = 'Práve sa chystáte obnovovať z:';
$string['youhaveupcomingactivitiesdue'] = 'Máte nadchádzajúce aktivity s termínom';
$string['youhaveupcomingactivitiesdueinfo'] = 'Dobrý deň {$a},

<br/> <br/> Máte termín nadchádzajúcich aktivít:';
$string['youneedtoenrol'] = 'Na splnenie Vami požadovanej akcie je potrebné sa prihlásiť do toho kurzu.';
$string['yourlastlogin'] = 'Vaše posledné prihlásenie bolo';
$string['yourself'] = 'seba';
$string['yourteacher'] = 'Váš {$a}';
$string['yourwordforx'] = 'Vaše označenie pre \'{$a}';
$string['zippingbackup'] = 'Záloha sa práve zozipováva';
