<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_security', language 'sk', version '4.4'.
 *
 * @package     report_security
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['check_configrw_details'] = '<p>Doporučuje sa zmeniť oprávnenia k súboru config.php tak, aby do nemohol byť upravovaný web serverom.
Toto opatrenie síce výrazne nezlepší bezpečnosť serveru, ale aspoň spomalí alebo obmedzí prieniky.</p>';
$string['check_configrw_name'] = 'Zapisovateľný config.php';
$string['check_configrw_ok'] = 'PHP skripty nemôžu zapisovať do súboru config.php';
$string['check_configrw_warning'] = 'PHP skripty môžu meniť súbor config.php';
$string['check_cookiesecure_details'] = '<p>Ak povolíte komunikáciu cez HTTPS, mali by ste tiež povoliť zabezpečený prenos cookies. Tiež by ste mali pridať trvalé presmerovanie z HTTP na HTTPS.</p>';
$string['check_cookiesecure_error'] = 'Prosím povoľte zabezpečené cookies';
$string['check_cookiesecure_name'] = 'Zabezpečené cookies';
$string['check_cookiesecure_ok'] = 'Zabezpečené cookies sú povolené';
$string['check_crawlers_details'] = '<p>Ak povolíte prehľadávanie vašich kurzov vyhľadávačom Google, môžu webové vyhľadávače vstupovať do vašich kurzov s právami hosťa. Toto nastavenie nemá zmysel, ak je zakázaná možnosť "Prihlásiť sa ako hosť".';
$string['check_crawlers_error'] = 'Je povolené prehľadávanie vyhľadávačom Google, ale hosťovský prístup je zakázaný.';
$string['check_crawlers_info'] = 'Vyhľadávače môžu vstupovať do kurzov ako hostia.';
$string['check_crawlers_name'] = 'Prehľadávanie vyhľadávačom Google';
$string['check_crawlers_ok'] = 'Prehľadávanie vyhľadávačom Google je vypnuté.';
$string['check_defaultuserrole_details'] = '<p>Všetci prihlásení používatelia majú oprávnenia vyplývajúce z tzv. "Východzej roly pre všetkých používateľov". Uistite sa, že táto východzia rola nemá pridelené žiadne riskantné schopnosti.</p>
<p>Jediným podporovaným starým typom tejto východzej roly je <em>Registrovaný používateľ</em>. Schopnosť vidieť kurz tu nesmie byť povolená.</p>';
$string['check_defaultuserrole_error'] = 'Bola zistená chyba v definícii východzej roly pre všetkých používateľov: "{$a}"!';
$string['check_defaultuserrole_name'] = 'Východzia rola pre všetkých používateľov';
$string['check_defaultuserrole_notset'] = 'Východzia rola nie je nastavená.';
$string['check_defaultuserrole_ok'] = 'Východzia rola pre všetkých používateľov je OK.';
$string['check_displayerrors_details'] = '<p>Na produkčných serveroch sa nedoporučuje zobrazovanie chybových hlásení PHP (<code>display_errors</code>).  Zobrazené informácie môžu obsahovať citlivé údaje o vašom serveri.</p>';
$string['check_displayerrors_error'] = 'PHP nastavenie display_errors je zapnuté. Je doporučené ho vypnúť.';
$string['check_displayerrors_name'] = 'Zobrazovanie chýb PHP';
$string['check_displayerrors_ok'] = 'Zobrazovanie chýb PHP je zakázané.';
$string['check_emailchangeconfirmation_details'] = '<p>Je doporučené, aby používatelia museli potvrdiť svoju novú e-mailovú adresu pri jej zmene v používateľskom profile. Ak tento krok vynecháte, môže byť váš server zneužitý k rozosielaniu nevyžiadanej pošty (spamu).</p>
<p>Emailový záznam môže byť overovacím zásuvným modulom zamknutý, táto možnosť tu nie je uvažovaná.</p>';
$string['check_emailchangeconfirmation_error'] = 'Používatelia môžu zadať ľubovoľnú emailovú adresu.';
$string['check_emailchangeconfirmation_info'] = 'Používatelia môžu zadať emailovú adresu iba z dovolených domén.';
$string['check_emailchangeconfirmation_name'] = 'Potvrdenie zmeny e-mailu';
$string['check_emailchangeconfirmation_ok'] = 'Používatelia musia potvrdiť zmenu e-mailovej adresy.';
$string['check_embed_details'] = '<p>Neobmedzené vkladanie objektov do HTML je veľmi nebezpečné. Akýkoľvek registrovaný používateľ potom môže zahájiť XSS útok proti iným používateľom serveru. Na produkčných serveroch by to malo byť zakázané.</p>';
$string['check_embed_error'] = 'Vkladanie objektov do HTML je povolené - toto je veľmi nebezpečné nastavenie.';
$string['check_embed_name'] = 'Povolené značky EMBED a OBJECT';
$string['check_embed_ok'] = 'Vkladanie objektov do HTML je obmedzené.';
$string['check_frontpagerole_details'] = '<p>Všetci prihlásení používatelia majú vzhľadom k činnostiam na titulnej stránke oprávnenie vyplývajúce z tzv. "Východzej roly na titulnej stránke". Uistite sa, že táto východzia rola nemá pridelené žiadne riskantné schopnosti.</p>
<p>Ak nastavujete schopnosti na titulnej stránke, potom sa doporučuje vytvoriť pre tento účel úplne novú rolu.</p>';
$string['check_frontpagerole_error'] = 'Bola zistená chyba v definícii východzej roly na titulnej stránke: "{$a}"!';
$string['check_frontpagerole_name'] = 'Rola na titulnej stránke';
$string['check_frontpagerole_notset'] = 'Rola na titulnej stránke nie je nastavená.';
$string['check_frontpagerole_ok'] = 'Rola na titulnej stránke je OK.';
$string['check_guestrole_details'] = '<p>Rola hosťa sa používa pre používateľov prihlásených ako Hosť, pre neprihlásených používateľov a pre dočasný prístup do kurzu. Uistite sa, že táto rola nemá pridelené žiadne riskantné schopnosti.</p>
<p>Jediným podporovaným starým typom tejto východzej roly je <em>Hosť</em>.</p>';
$string['check_guestrole_error'] = 'Je zistená chyba v definícii roly hosťa: "{$a}"!';
$string['check_guestrole_name'] = 'Rola hosťa';
$string['check_guestrole_notset'] = 'Rola hosťa nie je nastavená.';
$string['check_guestrole_ok'] = 'Rola hosťa je OK.';
$string['check_openprofiles_details'] = '<p>Otvorené používateľské profily môžu byť zneužité k publikovaniu nežiadúceho webového obsahu (porno, reklama, ...) v poli Opis používateľa. Doporučuje sa buď <code>Vnútiť prihlásenie pre zobrazovanie profilov</code> alebo <code>Vnútiť prihlásenie</code>.';
$string['check_openprofiles_error'] = 'Profily používateľov sú dostupné anonymným návštevníkom bez prihlásenia.';
$string['check_openprofiles_name'] = 'Otvorené používateľské profily';
$string['check_openprofiles_ok'] = 'Pre zobrazenie profilov je nutné sa prihlásiť.';
$string['check_passwordpolicy_details'] = '<p>Doporučuje sa definovať Zásady bezpečného hesla. Uhádnutie hesiel je často najjednoduchšia cesta k získaniu neoprávneného prístupu na váš server.
Na druhej strane, nenastavujte pravidlá príliš prísne - to vedie k tomu, že používatelia si heslo nezapamätajú a niekde si ho zapisujú, co opäť vedie k zníženiu zabezpečenia.</p>';
$string['check_passwordpolicy_error'] = 'Zásady bezpečného hesla nie sú definované.';
$string['check_passwordpolicy_name'] = 'Zásady bezpečného hesla';
$string['check_passwordpolicy_ok'] = 'Zásady bezpečného hesla sú nastavené';
$string['check_riskadmin_detailsok'] = '<p>Prosím skontrolujte zoznam administrátorov:<br />{$a}</p>';
$string['check_riskadmin_detailswarning'] = '<p>Zoznam administrátorov:<br />{$a->admins}</p>
<p>Rola Administrátor sa priraďuje iba v hlavnom systémovom kontexte. Nasledujúcim používateľom je priradená rola Administrátora v nevhodnom kontexte:<br />{$a->unsupported}</p>';
$string['check_riskadmin_name'] = 'Administrátori';
$string['check_riskadmin_ok'] = 'Počet administrátorov: {$a}';
$string['check_riskadmin_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) skontrolujte priradenie roly</a>';
$string['check_riskadmin_warning'] = 'Bolo nájdených {$a->admincount} administrátorov a {$a->unsupcount} nepodporovaných priradení rol.';
$string['check_riskbackup_details_overriddenroles'] = '<p>Tieto aktívne predefinovania umožňujú zahrnúť používateľské údaje v zálohách. Uistite sa, že toto oprávnenie je nutné.</p> {$a}';
$string['check_riskbackup_details_systemroles'] = '<p>Nasledovný systém rol v súčasnosti povoľuje používateľom zahrnúť používateľské údaje v zálohách. Uistite sa, že toto oprávnenie je nutné.</p> {$a}';
$string['check_riskbackup_details_users'] = '<p>Z dôvodu vyššie uvedených rol a predefinovaní majú nasledovné používateľské kontá v súčasnej situácii oprávnenie vytvoriť zálohy obsahujúce súkromné údaje používateľov zapísaných do kurzu. Uistite sa, že sú (a) dôveryhodní a (b) chránení silnými heslami:</p> {$a}';
$string['check_riskbackup_detailsok'] = 'Neexistujú žiadne roly, ktoré povoľujú zálohovanie používateľských údajov. Treba však zobrať do úvahu, že administrátori so schopnosťou "doanything" pravdepodobne stále toto oprávnenie majú.';
$string['check_riskbackup_editoverride'] = '<a href="{$a->url}">{$a->name} v kontexte {$a->contextname}</a>';
$string['check_riskbackup_editrole'] = '<a href="{$a->url}">{$a->name}</a>';
$string['check_riskbackup_name'] = 'Zálohovanie používateľských údajov';
$string['check_riskbackup_ok'] = 'Žiadne roly explicitne nepovoľujú zálohovanie používateľských údajov.';
$string['check_riskbackup_unassign'] = '<a href="{$a->url}">{$a->fullname} ({$a->email}) v kontexte {$a->contextname}</a>';
$string['check_riskbackup_warning'] = 'Bolo nájdených {$a->rolecount} rol, {$a->overridecount} predefinovaní a {$a->usercount} používateľov so schopnosťou zálohovania používateľských údajov.';
$string['check_riskxss_details'] = '<p>Príznakom RISK_XSS sú označené riskantné schopnosti, ktoré by mali byť povolené iba dôveryhodným používateľom.</p>
<p>Skontrolujte si nasledovný zoznam a uistite sa, že sa jedná o osoby, ktorým môžete na tomto serveri dôverovať, čo sa bezpečnosti týka:<br />{$a}</p>';
$string['check_riskxss_name'] = 'XSS dôveryhodní používatelia';
$string['check_riskxss_warning'] = 'RISK_XSS - bolo nájdených {$a} používateľov, ktorí musia byť dôveryhodní.';
$string['check_unsecuredataroot_details'] = '<p>Dátový adresár nesmie byť dostupný cez web. Najlepšie je použiť adresár mimo verejného web adresára.</p>
<p>Ak presuniete dátový adresár, potrebujete aktualizovať hodnotu <code>$CFG->dataroot</code> v súbore <code>config.php</code>.</p>';
$string['check_unsecuredataroot_error'] = 'Dátový adresár <code>{$a}</code> je nesprávne umiestnený a jeho obsah je dostupný cez web!';
$string['check_unsecuredataroot_name'] = 'Umiestnenie dátového adresára';
$string['check_unsecuredataroot_ok'] = 'Dátový adresár nesmie byť dostupný cez web.';
$string['check_unsecuredataroot_warning'] = 'Dátový adresár <code>{$a}</code> je nesprávne umiestnený a jeho obsah môže byť dostupný cez web.';
$string['check_webcron_details'] = '<p>Spustenie cronu z webového prehliadača môže odhaliť výhradné informácie anonymným používateľom. Odporúča sa cron spúšťať iba z príkazového riadku, alebo nastaviť heslo crona pre vzdialený prístup.</p>';
$string['check_webcron_name'] = 'Webový cron';
$string['check_webcron_ok'] = 'Anonymní používatelia nemajú prístup ku cronu.';
$string['check_webcron_warning'] = 'Anonymní používatelia majú prístup ku cronu.';
$string['configuration'] = 'Nastavenie';
$string['description'] = 'Opis';
$string['details'] = 'Podrobnosti';
$string['issue'] = 'Problém';
$string['pluginname'] = 'Prehľad zabezpečenia';
$string['security:view'] = 'Zobraziť prehľad zabezpečenia';
$string['timewarning'] = 'Spracovanie údajov môže trvať dlho - prosím čakajte...';
