<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'assign', language 'el', version '4.4'.
 *
 * @package     assign
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activityattachments'] = 'Συνημμένα αρχεία δραστηριότητας ανάθεσης εργασίας';
$string['activitydate:submissionsdue'] = 'Λήξη:';
$string['activitydate:submissionsopen'] = 'Ανοίγει:';
$string['activitydate:submissionsopened'] = 'Άνοιξε:';
$string['activityeditor'] = 'Οδηγίες δραστηριότητας';
$string['activityeditor_help'] = 'Οι ενέργειες που θα θέλατε να ολοκληρώσει ο μαθητής για την εργασία αυτή. Αυτό εμφανίζεται μόνο στη σελίδα υποβολής όπου ο μαθητής επεξεργάζεται και υποβάλλει την εργασία του.';
$string['activityoverview'] = 'Έχετε εργασίες που πρέπει να δείτε';
$string['addattempt'] = 'Να επιτρέπεται και άλλη προσπάθεια';
$string['addnewattempt'] = 'Προσθήκη μίας νέας προσπάθειας';
$string['addnewattempt_help'] = 'Αυτό θα δημιουργήσει μια νέα κενή υποβολή για να εργαστείτε.';
$string['addnewattemptfromprevious'] = 'Προσθήκη νέας προσπάθειας βασισμένη σε προηγούμενη υποβολή';
$string['addnewattemptfromprevious_help'] = 'Αυτό θα αντιγράψει τα περιεχόμενα της προηγούμενης υποβολής σας σε μια νέα υποβολή για να εργαστείτε σε αντίγραφο.';
$string['addnewgroupoverride'] = 'Προσθήκη παράκαμψης ομάδας';
$string['addnewuseroverride'] = 'Προσθήκη παράκαμψης χρήστη';
$string['addsubmission'] = 'Προσθήκη υποβολής';
$string['addsubmission_help'] = 'Δεν έχετε κάνει ακόμη υποβολή.';
$string['allocatedmarker'] = 'Βαθμολογητής που εκχωρήθηκε';
$string['allocatedmarker_help'] = 'Βαθμολογητής που εκχωρήθηκε για αυτή την υποβολή.';
$string['allowsubmissions'] = 'Επέτρεψε στο χρήστη να συνεχίζει να προσθέτει υποβολές σε αυτή την εργασία.';
$string['allowsubmissionsfromdate'] = 'Ημερομηνία έναρξης υποβολών';
$string['allowsubmissionsfromdate_help'] = 'Εάν ενεργοποιηθεί, οι μαθητές δεν θα μπορούν να υποβάλουν πριν από αυτήν την ημερομηνία. Εάν απενεργοποιηθεί, οι μαθητές θα μπορούν να ξεκινήσουν αμέσως την υποβολή τους.';
$string['allowsubmissionsshort'] = 'Να επιτρέπονται αλλαγές στην υποβολή';
$string['alwaysshowdescription'] = 'Εμφάνιση περιγραφής πάντα';
$string['alwaysshowdescription_help'] = 'Αν απενεργοποιηθεί, η περιγραφή της ανάθεσης εργασίας παραπάνω θα γίνει ορατή για τους μαθητές μόνο κατά την ημερομηνία «Ημερομηνία έναρξης υποβολών» και μετά.';
$string['applytoteam'] = 'Εφαρμογή βαθμών και ανατροφοδότησης σε ολόκληρη την ομάδα';
$string['assign:addinstance'] = 'Προσθήκη νέας εργασίας';
$string['assign:editothersubmission'] = 'Επεξεργασία υποβολής κάποιου άλλου μαθητή';
$string['assign:exportownsubmission'] = 'Εξαγωγή της δικής σας υποβολής';
$string['assign:grade'] = 'Βαθμός εργασίας';
$string['assign:grantextension'] = 'Χορήγηση παράτασης';
$string['assign:manageallocations'] = 'Διαχείριση βαθμολογητών στους οποίους εκχωρήθηκαν υποβολές εργασιών';
$string['assign:managegrades'] = 'Επανεξέταση και ανακοίνωση βαθμολογιών';
$string['assign:manageoverrides'] = 'Διαχείριση παρακάμψεων εργασίας';
$string['assign:receivegradernotifications'] = 'Λάβετε ειδοποιήσεις υποβολής βαθμολογητών';
$string['assign:releasegrades'] = 'Ανακοίνωση βαθμολογιών';
$string['assign:revealidentities'] = 'Εμφάνιση ταυτότητας μαθητών';
$string['assign:reviewgrades'] = 'Εξέταση βαθμολογιών';
$string['assign:showhiddengrader'] = 'Δείτε την ταυτότητα ενός κρυμμένου βαθμολογητή';
$string['assign:submit'] = 'Υποβολή εργασίας';
$string['assign:view'] = 'Εμφάνιση εργασίας';
$string['assign:viewblinddetails'] = 'Δείτε τα αναγνωριστικά των μαθητών όταν είναι ενεργοποιημένες οι ανώνυμες υποβολές';
$string['assign:viewgrades'] = 'Εμφάνιση Βαθμών';
$string['assign:viewownsubmissionsummary'] = 'Προβολή σύνοψης υποβολής';
$string['assignfeedback'] = 'Πρόσθετο ανατροφοδότησης';
$string['assignfeedbackpluginname'] = 'Πρόσθετο ανατροφοδότησης';
$string['assignmentisdue'] = 'Η προθεσμία έχει λήξει';
$string['assignmentmail'] = 'Ο/Η βαθμολογητής {$a->grader} έχει αναρτήσει κάποια ανατροφοδότηση για την υποβολή της εργασίας σας για την ανάθεση «{$a->assignment}». Μπορείτε να την δείτε προσαρτημένη στην εργασία που υποβάλατε: {$a->url}.';
$string['assignmentmailhtml'] = '<p>Ο/Η βαθμολογητής {$a->grader} έχει αναρτήσει κάποια ανατροφοδότηση για την υποβολή της εργασίας σας για την ανάθεση <i>«{$a->assignment}»</i>.</p><p>Μπορείτε να την δείτε προσαρτημένη στην <a href="{$a->url}">εργασία που υποβάλατε</a>.</p>';
$string['assignmentmailsmall'] = 'Ο/Η βαθμολογητής {$a->grader} έχει αναρτήσει κάποια ανατροφοδότηση για την υποβολή της εργασίας σας για την ανάθεση <i>«{$a->assignment}»</i>. Μπορείτε να την δείτε προσαρτημένη στην εργασία που υποβάλατε.';
$string['assignmentname'] = 'Όνομα εργασίας';
$string['assignmentplugins'] = 'Πρόσθετα εργασιών';
$string['assignmentsperpage'] = 'Εργασίες ανά σελίδα';
$string['assignsubmission'] = 'Πρόσθετο υποβολής';
$string['assignsubmissionpluginname'] = 'Πρόσθετο υποβολής';
$string['assigntimeleft'] = 'Υπολειπόμενος χρόνος';
$string['attemptheading'] = 'Προσπάθεια {$a->attemptnumber}: {$a->submissionsummary}';
$string['attempthistory'] = 'Προηγούμενες προσπάθειες';
$string['attemptnumber'] = 'Αριθμός προσπάθειας';
$string['attemptreopenmethod'] = 'Πρόσθετες προσπάθειες';
$string['attemptreopenmethod_help'] = 'Αυτή η ρύθμιση καθορίζει εάν ένας μαθητής μπορεί να κάνει επιπλέον προσπάθειες για την εργασία. Για κάθε προσπάθεια, ο βαθμός και οι ανατροφοδοτήσεις αποθηκεύονται και μπορούν να προβληθούν από τον διδάσκοντα και τον μαθητή. Οι διαθέσιμες επιλογές είναι:

* Ποτέ - Μόνο μία προσπάθεια είναι δυνατή.
* Χειροκίνητα - Πρόσθετες προσπάθειες μπορεί να επιτρέπονται από έναν εκπαιδευτικό
* Αυτόματα έως την επιτυχία - Επιπρόσθετες προσπάθειες επιτρέπονται αυτόματα έως ότου ο μαθητής επιτύχει τον βαθμό επιτυχίας που έχει οριστεί στο βαθμολόγιο για αυτήν την εργασία.';
$string['attemptreopenmethod_manual'] = 'Χειροκίνητα';
$string['attemptreopenmethod_none'] = 'Ποτέ';
$string['attemptreopenmethod_untilpass'] = 'Αυτόματα μέχρι να επιτύχει';
$string['attemptsettings'] = 'Ρυθμίσεις προσπάθειας';
$string['availability'] = 'Διαθεσιμότητα';
$string['back'] = 'Πίσω';
$string['backtoassignment'] = 'Επιστροφή στην εργασία';
$string['batchoperationconfirmaddattempt'] = 'Να επιτρέπεται νέα προσπάθεια για τις επιλεγμένες υποβολές;';
$string['batchoperationconfirmdownloadselected'] = 'Λήψη επιλεγμένων υποβολών;';
$string['batchoperationconfirmgrantextension'] = 'Να δοθεί παράταση σε όλες τις επιλεγμένες υποβολές;';
$string['batchoperationconfirmlock'] = 'Κλείδωμα όλων των επιλεγμένων υποβολών;';
$string['batchoperationconfirmremovesubmission'] = 'Διαγραφή επιλεγμένων υποβολών;';
$string['batchoperationconfirmreverttodraft'] = 'Επαναφορά των επιλεγμένων υποβολών σε προσχέδιο;';
$string['batchoperationconfirmsetmarkingallocation'] = 'Ορισμός εκχωρήσεων βαθμολόγησης για όλες τις επιλεγμένες υποβολές;';
$string['batchoperationconfirmsetmarkingworkflowstate'] = 'Ορισμός της κατάστασης ροής εργασίας βαθμολόγησης για όλες τις επιλεγμένες υποβολές;';
$string['batchoperationconfirmunlock'] = 'Ξεκλείδωμα όλων των επιλεγμένων υποβολών;';
$string['batchoperationlock'] = 'κλείδωμα υποβολών';
$string['batchoperationreverttodraft'] = 'επαναφορά υποβολών σε προσχέδιο';
$string['batchoperationsdescription'] = 'Με τα επιλεγμένα...';
$string['batchoperationunlock'] = 'ξεκλείδωμα υποβολών';
$string['batchsetallocatedmarker'] = 'Ορίστε τον βαθμολογητή που εκχωρείται για τους {$a} επιλεγμένους χρήστες.';
$string['batchsetmarkingworkflowstateforusers'] = 'Ορίστε την κατάσταση ροής εργασίας βαθμολόγησης για {$a} επιλεγμένους(-ο) χρήστες(-η).';
$string['beginassignment'] = 'Ξεκινήστε την εργασία';
$string['blindmarking'] = 'Ανώνυμες υποβολές';
$string['blindmarking_help'] = 'Οι ανώνυμες υποβολές αποκρύπτουν την ταυτότητα των μαθητών από τους βαθμολογητές. Οι ρυθμίσεις ανώνυμης υποβολής θα κλειδώνονται μόλις γίνει υποβολή ή βαθμολόγηση σε σχέση με αυτή την ανάθεση εργασίας.';
$string['blindmarkingenabledwarning'] = 'Οι ανώνυμες υποβολές είναι ενεργοποιημένες για αυτήν τη δραστηριότητα. Οι βαθμοί δεν θα προστεθούν στο βαθμολόγιο έως ότου αποκαλυφθούν οι ταυτότητες των μαθητών μέσω του μενού ενεργειών βαθμολόγησης.';
$string['cachedef_overrides'] = 'Πληροφορίες παράκαμψης χρήστη και ομάδας';
$string['calendardue'] = '{$a} οφείλεται';
$string['calendargradingdue'] = '{$a} οφείλεται για βαθμολόγηση';
$string['caneditsubmission'] = 'Μπορείτε να επεξεργαστείτε την υποβολή σας και να την υποβάλετε μετά τη λήξη της προθεσμίας, όμως θα επισημανθεί ως εκπρόθεσμη.';
$string['changefilters'] = 'Αλλαγή φίλτρων';
$string['changeuser'] = 'Αλλαγή χρήστη';
$string['choosegradingaction'] = 'Ενέργεια βαθμολόγησης';
$string['choosemarker'] = 'Επέλεξε....';
$string['chooseoperation'] = 'Επιλογή διαδικασίας';
$string['clickexpandreviewpanel'] = 'Κάντε κλικ για να αναπτύξετε το πλαίσιο εξέτασης';
$string['collapsegradepanel'] = 'Σύμπτυξη πίνακα βαθμών';
$string['collapsereviewpanel'] = 'Σύμπτυξη πίνακα εξέτασης';
$string['comment'] = 'Σχόλιο';
$string['completiondetail:submit'] = 'Κάντε μια υποβολή';
$string['completionsubmit'] = 'Κάντε μια υποβολή';
$string['configshowrecentsubmissions'] = 'Όλοι μπορούν να δουν ειδοποιήσεις υποβολών σε πρόσφατες αναφορές δραστηριοτήτων.';
$string['confirmbatchgradingoperation'] = 'Είστε βέβαιοι ότι θέλετε {$a->operation} για {$a->count} μαθητές;';
$string['confirmstart'] = 'Έχετε {$a} για να ολοκληρώσετε αυτή την εργασία. Όταν ξεκινήσετε, το χρονόμετρο θα αρχίσει να μετρά αντίστροφα και δεν μπορεί να διακοπεί.';
$string['confirmsubmission'] = 'Σίγουρα θέλετε να υποβάλετε την εργασία σας προς βαθμολόγηση; Δε θα μπορείτε να κάνετε περαιτέρω αλλαγές.';
$string['confirmsubmissionheading'] = 'Επιβεβαίωση υποβολής';
$string['conversionexception'] = 'Δεν ήταν δυνατή η μετατροπή της ανάθεσης. Η εξαίρεση ήταν: {$a}.';
$string['couldnotconvertgrade'] = 'Δεν ήταν δυνατή η μετατροπή του βαθμού για την εργασία για τον χρήστη {$a}.';
$string['couldnotconvertsubmission'] = 'Δεν ήταν δυνατή η μετατροπή της εργασίας που υποβλήθηκε από τον χρήστη {$a}.';
$string['couldnotcreatecoursemodule'] = 'Δεν ήταν δυνατή η δημιουργία του μαθήματος.';
$string['couldnotcreatenewassignmentinstance'] = 'Δεν ήταν δυνατή η δημιουργία νέου στιγμιοτύπου ανάθεσης εργασίας.';
$string['couldnotfindassignmenttoupgrade'] = 'Δεν ήταν δυνατή η εύρεση παλιού στιγμιοτύπου ανάθεσης εργασίας για αναβάθμιση.';
$string['crontask'] = 'Επεξεργασία παρασκηνίου για το άρθρωμα ανάθεσης εργασίας';
$string['currentassigngrade'] = 'Τρέχων βαθμός στην εργασία';
$string['currentattempt'] = 'Αυτή είναι η {$a} προσπάθεια.';
$string['currentattemptof'] = 'Αυτή είναι η {$a->attemptnumber} προσπάθεια ( {$a->maxattempts} προσπάθειες επιτρέπονται).';
$string['currentgrade'] = 'Τωρινός βαθμός στο βαθμολόγιο';
$string['cutoffdate'] = 'Ημερομηνία τερματισμού (υποβολών)';
$string['cutoffdate_help'] = 'Αν οριστεί, δε θα γίνονται δεκτές υποβολές εργασιών μετά από αυτήν την ημερομηνία αυτή χωρίς παράταση. Εάν δεν οριστεί, οι υποβολές θα γίνονται πάντοτε δεκτές.';
$string['cutoffdatecolon'] = 'Ημερομηνία τερματισμού (υποβολών): {$a}';
$string['cutoffdatefromdatevalidation'] = 'Η ημερομηνία διακοπής δεν μπορεί να είναι νωρίτερα από την ημερομηνία έναρξης υποβολών των εργασιών.';
$string['cutoffdatevalidation'] = 'Η ημερομηνία διακοπής δεν μπορεί να είναι νωρίτερα από την οφειλόμενη ημερομηνία.';
$string['defaultlayout'] = 'Επαναφορά προεπιλεγμένης διάταξης';
$string['defaultsettings'] = 'Προεπιλεγμένες ρυθμίσεις εργασιών';
$string['defaultsettings_help'] = 'Αυτές οι ρυθμίσεις ορίζουν τις προεπιλογές για όλες τις νέες αναθέσεις εργασιών.';
$string['defaultteam'] = 'Προεπιλεγμένη ομάδα';
$string['deleteallsubmissions'] = 'Διαγραφή όλων των υποβολών';
$string['description'] = 'Περιγραφή';
$string['disabled'] = 'Ανενεργό';
$string['downloadall'] = 'Λήψη όλων των υποβολών';
$string['downloadasfolders'] = 'Λήψη υποβολών σε φακέλους';
$string['downloadasfolders_help'] = 'Η λήψη υποβολών εργασιών μπορεί να γίνεται και σε φακέλους. Κάθε υποβολή τότε τοποθετείται σε ξεχωριστό φάκελο, με την δομή τυχόν υποφακέλων να διατηρείται και χωρίς μετονομασία αρχείων.';
$string['downloadselectedsubmissions'] = 'Λήψη επιλεγμένων υποβολών';
$string['duedate'] = 'Οφειλόμενη ημερομηνία';
$string['duedate_help'] = 'Αυτό συμβαίνει όταν η ανάθεση έχει λήξει. Οι υποβολές θα εξακολουθούν να επιτρέπονται μετά την ημερομηνία αυτή, αλλά οι εργασίες που υποβάλλονται μετά από αυτή την ημερομηνία επισημαίνονται ως καθυστερημένες. Για να παρεμποδίσετε υποβολές μετά από μια συγκεκριμένη ημερομηνία, ορίστε μια ημερομηνία τερματισμού υποβολών.';
$string['duedateaftersubmissionvalidation'] = 'Η ημερομηνία λήξης πρέπει να είναι αργότερα από την ημερομηνία από την οποία επιτρέπονται οι υποβολές.';
$string['duedatecolon'] = 'Οφειλόμενη ημερομηνία: {$a}';
$string['duedatereached'] = 'Η οφειλόμενη ημερομηνία για την εργασία αυτή έχει τώρα περάσει';
$string['duedatevalidation'] = 'Η οφειλόμενη ημερομηνία δεν μπορεί να είναι νωρίτερα από την ημερομηνία έναρξης υποβολών.';
$string['duplicateoverride'] = 'Παράκαμψη διπλότυπων';
$string['editaction'] = 'Ενέργειες...';
$string['editattemptfeedback'] = 'Επεξεργασία του βαθμού και της ανατροφοδότησης για την προσπάθεια με αριθμό {$a}.';
$string['editingpreviousfeedbackwarning'] = 'Επεξεργάζεστε την ανατροφοδότηση για μια προηγούμενη προσπάθεια. Αυτή είναι η προσπάθεια Νο {$a->attemptnumber} από συνολικά {$a->totalattempts}.';
$string['editingstatus'] = 'Επεξεργασία κατάστασης';
$string['editonline'] = 'Επεξεργασία εντός σύνδεσης';
$string['editoverride'] = 'Παράκαμψη επεξεργασίας';
$string['editsubmission'] = 'Επεξεργασία υποβολής';
$string['editsubmission_help'] = 'Μπορείτε ακόμη να κάνετε τροποποίηση της υποβολής σας.';
$string['editsubmissionother'] = 'Επεξεργασία υποβολής για {$a}';
$string['enabled'] = 'Ενεργοποιημένο';
$string['enabletimelimit'] = 'Ενεργοποίηση αναθέσεων εργασιών με χρονικό όριο';
$string['enabletimelimit_help'] = 'Αν ενεργοποιηθεί, μπορείτε να ορίσετε ένα χρονικό όριο στη σελίδα ρυθμίσεων ανάθεσης εργασίας.';
$string['errornosubmissions'] = 'Δεν υπάρχουν υποβολές για λήψη';
$string['errorquickgradingvsadvancedgrading'] = 'Οι βαθμοί δεν αποθηκεύτηκαν επειδή αυτή η ανάθεση χρησιμοποιεί αυτήν την περίοδο προχωρημένη βαθμολόγηση';
$string['errorrecordmodified'] = 'Οι βαθμοί δεν αποθηκεύτηκαν επειδή κάποιος τροποποίησε μία ή περισσότερες εγγραφές πιο πρόσφατα από όταν φορτώσατε τη σελίδα.';
$string['eventallsubmissionsdownloaded'] = 'Γίνεται λήψη όλων των υποβολών.';
$string['eventassessablesubmitted'] = 'Έχει γίνει υποβολή εργασίας.';
$string['eventbatchsetmarkerallocationviewed'] = 'Η δέσμη ορισμών βαθμολογητών που εκχωρούνται εμφανίστηκε';
$string['eventbatchsetworkflowstateviewed'] = 'Η δέσμη ορισμών καταστάσεων ροής εργασίας εμφανίστηκε.';
$string['eventextensiongranted'] = 'Έχει χορηγηθεί παράταση.';
$string['eventfeedbackupdated'] = 'Η ανατροφοδότηση ενημερώθηκε';
$string['eventfeedbackviewed'] = 'Η ανατροφοδότηση εμφανίστηκε';
$string['eventgradingformviewed'] = 'Η φόρμα βαθμολόγησης προβλήθηκε';
$string['eventgradingtableviewed'] = 'Ο πίνακας βαθμολόγησης προβλήθηκε';
$string['eventidentitiesrevealed'] = 'Οι ταυτότητες έχουν αποκαλυφθεί.';
$string['eventmarkerupdated'] = 'Η εκχώρηση βαθμολογητή ενημερώθηκε.';
$string['eventoverridecreated'] = 'Η παράκαμψη εργασίας δημιουργήθηκε';
$string['eventoverridedeleted'] = 'Η παράκαμψη εργασίας διαγράφηκε';
$string['eventoverrideupdated'] = 'Η παράκαμψη εργασίας ενημερώθηκε';
$string['eventremovesubmissionformviewed'] = 'Η επιβεβαίωση διαγραφής της υποβολής έχει προβληθεί.';
$string['eventrevealidentitiesconfirmationpageviewed'] = 'Η σελίδα επιβεβαίωσης αποκάλυψης ταυτότητας προβλήθηκε.';
$string['eventstatementaccepted'] = 'Ο χρήστης έχει αποδεχθεί τη δήλωση της υποβολής.';
$string['eventsubmissionconfirmationformviewed'] = 'Η φόρμα επιβεβαίωσης υποβολής έχει προβληθεί.';
$string['eventsubmissioncreated'] = 'Η υποβολή δημιουργήθηκε';
$string['eventsubmissionduplicated'] = 'Ο χρήστης δημιούργησε αντίγραφο της υποβολής του.';
$string['eventsubmissionformviewed'] = 'Έγινε προβολή της φόρμας υποβολής.';
$string['eventsubmissiongraded'] = 'Η υποβολή έχει βαθμολογηθεί.';
$string['eventsubmissionlocked'] = 'Οι υποβολές έχουν κλειδωθεί για έναν χρήστη.';
$string['eventsubmissionremoved'] = 'Η υποβολή αφαιρέθηκε.';
$string['eventsubmissionstatusupdated'] = 'Η κατάσταση της υποβολής έχει ενημερωθεί.';
$string['eventsubmissionstatusviewed'] = 'Η κατάσταση της υποβολής έχει προβληθεί.';
$string['eventsubmissionunlocked'] = 'Οι υποβολές έχουν ξεκλειδωθεί για έναν χρήστη.';
$string['eventsubmissionupdated'] = 'Η υποβολή ενημερώθηκε.';
$string['eventsubmissionviewed'] = 'Η υποβολή έχει προβληθεί.';
$string['eventworkflowstateupdated'] = 'Η κατάσταση της ροής εργασίας ενημερώθηκε.';
$string['expandreviewpanel'] = 'Αναπτύξτε το πλαίσιο εξέτασης';
$string['extensionduedate'] = 'Οφειλόμενη ημερομηνία παράτασης';
$string['extensionnotafterduedate'] = 'Η οφειλόμενη ημερομηνία παράτασης πρέπει να είναι μετά την οφειλόμενη ημερομηνία';
$string['extensionnotafterfromdate'] = 'Η ημερομηνία παράτασης πρέπει να είναι μετά από την ημερομηνία έναρξης υποβολών';
$string['feedback'] = 'Ανατροφοδότηση';
$string['feedbackavailableanonhtml'] = 'Έχετε νέα ανατροφοδότηση σχετικά με την υποβολή σας για την ανάθεση «<i>{$a->assignment}</i>»<br /><br />
Μπορείτε να την δείτε προσαρτημένη στην <a href="{$a->url}">υποβολή εργασίας για την ανάθεση</a>.';
$string['feedbackavailableanonsmall'] = 'Νέα ανατροφοδότηση για την ανάθεση {$a->assignment}';
$string['feedbackavailableanontext'] = 'Έχετε νέα ανατροφοδότηση σχετικά με την
υποβολή σας για την ανάθεση «<i>{$a->assignment}</i>»

Μπορείτε να την δείτε προσαρτημένη στην υποβολή της εργασίας σας για την ανάθεση:

 {$a->url}';
$string['feedbackavailablehtml'] = 'Ο/Η χρήστης {$a->username} έχει αναρτήσει κάποια ανατροφοδότηση για την υποβολή της εργασίας σας για την ανάθεση <i>«{$a->assignment}»</i>. Μπορείτε να την δείτε προσαρτημένη στην <a href="{$a->url}">εργασία που υποβάλατε</a>.';
$string['feedbackavailablesmall'] = 'Ο/Η χρήστης {$a->username} έχει δώσει ανατροφοδότηση για την εργασία {$a->assignment}';
$string['feedbackavailabletext'] = 'Ο/Η χρήστης {$a->username} έχει αναρτήσει κάποια ανατροφοδότηση για την υποβολή της εργασίας σας για την ανάθεση «{$a->assignment}». Μπορείτε να την δείτε προσαρτημένη στην εργασία που υποβάλατε: {$a->url}';
$string['feedbackplugin'] = 'Πρόσθετο ανατροφοδότησης';
$string['feedbackpluginforgradebook'] = 'Πρόσθετο ανατροφοδότησης που προωθεί σχόλια στο βαθμολόγιο';
$string['feedbackpluginforgradebook_help'] = 'Μόνο ένα πρόσθετο ανατροφοδότησης εργασιών μπορεί να προωθεί ανατροφοδότηση στο βαθμολόγιο.';
$string['feedbackplugins'] = 'Πρόσθετα ανατροφοδότησης';
$string['feedbacksettings'] = 'Ρυθμίσεις ανατροφοδότησης';
$string['feedbacktypes'] = 'Τύποι ανατροφοδότησης';
$string['filesubmissions'] = 'Υποβολές αρχείων';
$string['filter'] = 'Φίλτρο';
$string['filterdraft'] = 'Προσχέδιο';
$string['filtergrantedextension'] = 'Χορηγήθηκε παράταση';
$string['filternone'] = 'Κανένα φίλτρο';
$string['filternotsubmitted'] = 'Δεν υποβλήθηκαν';
$string['filterrequiregrading'] = 'Χρειάζεται βαθμολόγηση';
$string['filtersubmitted'] = 'Υποβλήθηκε';
$string['fixrescalednullgrades'] = 'Αυτή η ανάθεση περιέχει κάποιους λανθασμένους βαθμούς. Μπορείτε να <a href="{$a->link}">διορθώσετε αυτόματα αυτούς τους βαθμούς</a>. Αυτό μπορεί να επηρεάσει τα σύνολα μαθημάτων.';
$string['fixrescalednullgradesconfirm'] = 'Είστε βέβαιοι ότι θέλετε να διορθώσετε λανθασμένους βαθμούς; Όλοι οι βαθμοί που επηρεάζονται θα χαθούν. Αυτό μπορεί να επηρεάσει τα σύνολα μαθημάτων.';
$string['fixrescalednullgradesdone'] = 'Οι βαθμοί διορθώθηκαν.';
$string['gradeabovemaximum'] = 'Ο βαθμός πρέπει να είναι μικρότερος ή ίσος με {$a}.';
$string['gradebelowzero'] = 'Ο βαθμός πρέπει να είναι μεγαλύτερος ή ίσος με το μηδέν (0).';
$string['gradebreakdown'] = 'Ανάλυση βαθμού';
$string['gradecanbechanged'] = 'Ο βαθμός μπορεί να αλλάξει';
$string['gradechangessaveddetail'] = 'Οι αλλαγές στο βαθμό και στην ανατροφοδότηση αποθηκεύτηκαν';
$string['graded'] = 'Βαθμολογήθηκε';
$string['gradedby'] = 'Βαθμολογήθηκε από';
$string['gradedfollowupsubmit'] = 'Βαθμολογήθηκε - υποβλήθηκε εκ νέου';
$string['gradedon'] = 'Βαθμολογήθηκε στις';
$string['gradeitem:submissions'] = 'Υποβολές';
$string['gradelocked'] = 'Αυτός ο βαθμός είναι κλειδωμένος ή έχει παρακαμφθεί στο βαθμολόγιο.';
$string['gradeoutof'] = 'Βαθμός στα {$a}';
$string['gradeoutofhelp'] = 'Βαθμός';
$string['gradeoutofhelp_help'] = 'Εισαγάγετε τον βαθμό για την υποβολή του μαθητή εδώ. Μπορείτε να συμπεριλάβετε δεκαδικά ψηφία.';
$string['gradersubmissionupdatedhtml'] = 'Ο/Η μαθητής/τρια {$a->username} τροποποίησε την υποβολή για την εργασία <i>«{$a->assignment}» στις {$a->timeupdated}</i><br /><br />
Η υποβολή είναι <a href="{$a->url}">διαθέσιμη στον ιστότοπο</a>.';
$string['gradersubmissionupdatedsmall'] = 'Ο/Η μαθητής/τρια {$a->username} έχει ενημερώσει την υποβολή για την ανάθεση {$a->assignment}.';
$string['gradersubmissionupdatedtext'] = 'Ο/Η μαθητής/τρια {$a->username} τροποποίησε την υποβολή που είχε κάνει για την εργασία «{$a->assignment}» στις {$a->timeupdated}. Η νέα υποβολή είναι διαθέσιμη εδώ: {$a->url}.';
$string['gradestudent'] = 'Βαθμολόγηση μαθητή: (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}).';
$string['gradeuser'] = 'Βαθμολόγηση {$a}';
$string['grading'] = 'Βαθμολόγηση...';
$string['gradingchangessaved'] = 'Οι αλλαγές στη βαθμολογία αποθηκεύτηκαν';
$string['gradingduedate'] = 'Υπενθύμιση βαθμολόγησης μέχρι';
$string['gradingduedate_help'] = 'Η αναμενόμενη ημερομηνία κατά την οποία θα πρέπει να συμπληρωθεί η βαθμολόγηση των υποβολών. Αυτή η ημερομηνία χρησιμοποιείται για να δοθεί προτεραιότητα στις ειδοποιήσεις ταμπλό για τους διδάσκοντες.';
$string['gradingdueduedatevalidation'] = 'Η ημερομηνία «Υπενθύμιση βαθμολόγησης μέχρι» δεν μπορεί να είναι προγενέστερη από την οφειλόμενη ημερομηνία.';
$string['gradingduefromdatevalidation'] = 'Η υπενθύμιση μου για βαθμολόγηση μέχρι κάποια ημερομηνία δεν μπορεί να είναι νωρίτερα από την ημερομηνία έναρξης υποβολών.';
$string['gradingmethodpreview'] = 'Κριτήρια βαθμολόγησης';
$string['gradingoptions'] = 'Επιλογές';
$string['gradingstatus'] = 'Κατάσταση βαθμολόγησης';
$string['gradingstudent'] = 'Βαθμολόγηση μαθητή';
$string['gradingsummary'] = 'Περίληψη βαθμολογίας';
$string['grantextension'] = 'Χορήγηση παράτασης';
$string['grantextensionforusers'] = 'Χορήγηση παράτασης για {$a} μαθητές';
$string['groupoverrides'] = 'Παρακάμψεις ομάδας';
$string['groupoverridesdeleted'] = 'Διαγραφή παρακάμψεων ομάδας';
$string['groupsnone'] = 'Δεν υπάρχουν προσβάσιμες για εσάς ομάδες.';
$string['groupsubmissionsettings'] = 'Ρυθμίσεις ομαδικής υποβολής';
$string['hiddenuser'] = 'Συμμετέχων';
$string['hidegrader'] = 'Απόκρυψη ταυτότητας βαθμολογητή από τους μαθητές';
$string['hidegrader_help'] = 'Εάν ενεργοποιηθεί, δεν εμφανίζεται η ταυτότητα οποιουδήποτε χρήστη βαθμολογεί την υποβολή εκχώρησης, έτσι ώστε οι μαθητές να μην μπορούν να δουν ποιος βαθμολόγησε την εργασία τους.

Σημειώστε ότι αυτή η ρύθμιση δεν έχει καμία επίδραση στο πλαίσιο σχολίων στη σελίδα βαθμολόγησης.';
$string['hideshow'] = 'Απόκρυψη/Εμφάνιση';
$string['inactiveoverridehelp'] = '* Αυτή η παράκαμψη είναι ανενεργή, επειδή η πρόσβαση του χρήστη στη δραστηριότητα είναι περιορισμένη. Αυτό μπορεί να οφείλεται σε αναθέσεις ομάδων ή ρόλων, σε άλλους περιορισμούς πρόσβασης ή στην απόκρυψη της δραστηριότητας.';
$string['indicator:cognitivedepth'] = 'Βάθος κατανόησης Ανάθεσης εργασίας';
$string['indicator:cognitivedepth_help'] = 'Αυτός ο δείκτης βασίζεται στο βάθος κατανόησης που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα εργασίας.';
$string['indicator:cognitivedepthdef'] = 'Βάθος κατανόησης Ανάθεσης εργασίας';
$string['indicator:cognitivedepthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο βάθος κατανόησης που προσφέρεται από τις δραστηριότητες ανάθεσης εργασίας κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία εμφάνιση, Εμφάνιση, Υποβολή, Εμφάνιση σχολίων, Σχόλιο σχετικά με την ανατροφοδότηση, Επανυποβολή μετά την εμφάνιση της ανατροφοδότησης)';
$string['indicator:cognitivedepthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Βάθος_κατανόησης';
$string['indicator:socialbreadth'] = 'Κοινωνικό εύρος Ανάθεσης εργασίας';
$string['indicator:socialbreadth_help'] = 'Αυτός ο δείκτης βασίζεται στο κοινωνικό εύρος που επιτεύχθηκε από τον μαθητή σε μια δραστηριότητα εργασίας.';
$string['indicator:socialbreadthdef'] = 'Κοινωνικό εύρος Ανάθεσης εργασίας';
$string['indicator:socialbreadthdef_help'] = 'Ο συμμετέχων έχει φτάσει αυτό το ποσοστό αφοσίωσης στο κοινωνικό εύρος που προσφέρεται από τις δραστηριότητες ανάθεσης εργασίας κατά τη διάρκεια αυτού του διαστήματος ανάλυσης (Επίπεδα = Καμία αφοσίωση, Συμμετέχων μόνος, Συμμετέχων με άλλους)';
$string['indicator:socialbreadthdef_link'] = 'Δείκτες_μαθησιακής_αναλυτικής#Κοινωνικό_εύρος';
$string['instructionfiles'] = 'Αρχεία οδηγιών';
$string['introattachments'] = 'Επιπρόσθετα αρχεία';
$string['introattachments_help'] = 'Μπορούν να προστεθούν επιπρόσθετα αρχεία για χρήση στην ανάθεση εργασίας, όπως υποδείγματα απαντήσεων.';
$string['invalidfloatforgrade'] = 'Ο βαθμός που δόθηκε δεν έγινε κατανοητός: {$a}';
$string['invalidgradeforscale'] = 'Ο βαθμός που δόθηκε δεν ήταν έγκυρος για την τρέχουσα κλίμακα';
$string['invalidoverrideid'] = 'Άκυρο αναγνωριστικό παράκαμψης';
$string['lastmodifiedgrade'] = 'Τελευταία τροποποίηση (βαθμολόγηση)';
$string['lastmodifiedsubmission'] = 'Τελευταία τροποποιημένη (υποβολή)';
$string['latesubmissions'] = 'Καθυστερημένες υποβολές';
$string['latesubmissionsaccepted'] = 'Επιτρέπεται μέχρι {$a}';
$string['loading'] = 'Φόρτωση...';
$string['locksubmissionforstudent'] = 'Παρεμπόδιση περαιτέρω υποβολών για τον μαθητή: (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}).';
$string['locksubmissions'] = 'Κλείδωμα υποβολών';
$string['manageassignfeedbackplugins'] = 'Διαχείριση πρόσθετων ανατροφοδότησης για εργασίες';
$string['manageassignsubmissionplugins'] = 'Διαχείριση πρόσθετων υποβολής για εργασίες';
$string['marker'] = 'Βαθμολογητής';
$string['markerfilter'] = 'Φίλτρο βαθμολογητή';
$string['markerfilternomarker'] = 'Κανένας βαθμολογητής';
$string['markingallocation'] = 'Χρήση εκχώρησης βαθμολογητών';
$string['markingallocation_help'] = 'Εάν ενεργοποιηθεί μαζί με τη ροή εργασίας βαθμολόγησης, οι βαθμολογητές μπορούν να εκχωρηθούν σε συγκεκριμένους μαθητές.';
$string['markingworkflow'] = 'Χρήση ροής εργασίας βαθμολόγησης';
$string['markingworkflow_help'] = 'Εάν ενεργοποιηθεί, οι βαθμοί θα περάσουν από μια σειρά σταδίων ροής εργασίας προτού ανακοινωθούν στους μαθητές. Αυτό επιτρέπει πολλαπλούς γύρους βαθμολόγησης και επιτρέπει την ανακοίνωση βαθμών σε όλους τους μαθητές ταυτόχρονα.';
$string['markingworkflowstate'] = 'Κατάσταση ροής εργασίας βαθμολόγησης';
$string['markingworkflowstate_help'] = 'Οι πιθανές καταστάσεις (στάδια) της ροής εργασίας μπορεί να περιλαμβάνουν (ανάλογα με τα δικαιώματά σας):

* Χωρίς βαθμολογία - ο βαθμολογητής δεν ξεκίνησε ακόμη
* Βαθμολογείται - ο βαθμολογητής ξεκίνησε αλλά δεν ολοκλήρωσε ακόμη
* Ολοκληρωμένη βαθμολόγηση - ο βαθμολογητής ολοκλήρωσε αλλά ίσως χρειαστεί να επανέλθει για έλεγχο/διορθώσεις
* Εξετάζεται - η βαθμολόγηση είναι τώρα στη διάθεση του διδάσκοντος που είναι υπεύθυνος για τον έλεγχο ποιότητας
* Έτοιμη προς ανακοίνωση - ο υπεύθυνος διδάσκων είναι ικανοποιημένος με την βαθμολόγηση αλλά μπορεί να περιμένει πριν δώσει στους μαθητές πρόσβαση στη βαθμολόγηση
* Ανακοινώθηκε - ο μαθητής έχει πρόσβαση στη βαθμολογία/ανατροφοδότηση';
$string['markingworkflowstateinmarking'] = 'Σε βαθμολόγηση';
$string['markingworkflowstateinreview'] = 'Εξετάζεται';
$string['markingworkflowstatenotmarked'] = 'Μη βαθμολογημένη';
$string['markingworkflowstatereadyforrelease'] = 'Βαθμολογία ανακοινώσιμη';
$string['markingworkflowstatereadyforreview'] = 'Βαθμολόγηση ολοκληρωμένη';
$string['markingworkflowstatereleased'] = 'Ανακοινώθηκε';
$string['maxattempts'] = 'Μέγιστος αριθμός προσπαθειών';
$string['maxattempts_help'] = 'Ο μέγιστος αριθμός προσπαθειών υποβολής που μπορεί να γίνει από έναν μαθητή. Αφού συμπληρωθεί αυτός ο αριθμός προσπαθειών, δεν θα είναι δυνατή νέα υποβολή από τον μαθητή.';
$string['maxgrade'] = 'Μέγιστος Βαθμός';
$string['maxperpage'] = 'Μέγιστος αριθμός αναθέσεων ανά σελίδα';
$string['maxperpage_help'] = 'Ο μέγιστος αριθμός αναθέσεων (εργασιών) που μπορεί να εμφανίσει ο βαθμολογητής στη σελίδα βαθμολόγησης. Αυτή η ρύθμιση είναι χρήσιμη για να παρεμποδίσετε τα σφάλματα χρονικού ορίου σε μαθήματα με μεγάλο αριθμό συμμετεχόντων.';
$string['messageprovider:assign_notification'] = 'Ειδοποιήσεις αναθέσεων';
$string['modulename'] = 'Ανάθεση εργασίας';
$string['modulename_help'] = 'Το άρθρωμα δραστηριότητας «Ανάθεση εργασίας» επιτρέπει σε έναν διδάσκοντα να αναθέτει καθήκοντα, να συλλέγει εργασίες και να παρέχει βαθμούς και ανατροφοδότηση. Οι μαθητές μπορούν να υποβάλουν οποιοδήποτε ψηφιακό περιεχόμενο (αρχεία), όπως έγγραφα επεξεργαστών κειμένου, υπολογιστικά φύλλα, εικόνες ή ήχους και βίντεο κλιπ. Εναλλακτικά, ή επιπλέον, η εργασία μπορεί να απαιτεί από τους μαθητές να πληκτρολογούν κείμενο απευθείας στον επεξεργαστή κειμένου. Μια δραστηριότητα εργασίας μπορεί επίσης να χρησιμοποιηθεί για να υπενθυμίσει στους μαθητές αναθέσεις «πραγματικού κόσμου», που οφείλουν να ολοκληρώσουν εκτός σύνδεσης, όπως έργα τέχνης, και συνεπώς να μην απαιτούν οποιοδήποτε ψηφιακό περιεχόμενο. Οι μαθητές μπορούν να υποβάλουν εργασίες ατομικά ή ως μέλη μιας ομάδας. Κατά την εξέταση των εργασιών, οι εκπαιδευτικοί μπορούν να αφήνουν σχόλια ανατροφοδότησης και να ανεβάζουν αρχεία, όπως βαθμολογημένες υποβολές μαθητών, έγγραφα με σχόλια ή με ηχογραφημένη προφορική ανατροφοδότηση. Οι αναθέσεις μπορούν να βαθμολογηθούν χρησιμοποιώντας μια αριθμητική ή προσαρμοσμένη κλίμακα ή μια προχωρημένη μέθοδο βαθμολόγησης όπως μια ρουμπρίκα (Κλίμακα Διαβαθμισμένων Κριτηρίων, rubric). Οι τελικοί βαθμοί καταγράφονται στο βαθμολόγιο.';
$string['modulename_link'] = '';
$string['modulenameplural'] = 'Αναθέσεις εργασιών';
$string['moreusers'] = '{$a} περισσότεροι...';
$string['multipleteams'] = 'Μέλος περισσότερων από μία ομάδων';
$string['multipleteams_desc'] = 'Η ανάθεση απαιτεί την υποβολή σε ομάδες. Είστε μέλος περισσότερων από μία ομάδων. Για να μπορέσετε να υποβάλετε εργασία πρέπει να είστε μέλος μόνο μιας ομάδας. Επικοινωνήστε με τον διδάσκοντά σας για να αλλάξετε την συμμετοχή σας σε ομάδες.';
$string['multipleteamsgrader'] = 'Μέλος περισσότερων από μία ομάδων, οπότε δεν είναι σε θέση να υποβάλει εργασίες.';
$string['newsubmissions'] = 'Οι εργασίες υποβλήθηκαν';
$string['nextuser'] = 'Επόμενος χρήστης';
$string['noattempt'] = 'Καμία προσπάθεια';
$string['noclose'] = 'Δεν υπάρχει ημερομηνία λήξης';
$string['nofiles'] = 'Καθόλου αρχεία.';
$string['nofilters'] = 'Καθόλου φίλτρα';
$string['nograde'] = 'Κανένας βαθμός.';
$string['nogroupoverrides'] = 'Δεν υπάρχουν προς το παρόν παρακάμψεις ομάδας.';
$string['nomoresubmissionsaccepted'] = 'Επιτρέπονται μόνο στους συμμετέχοντες που τους έχει χορηγηθεί παράταση';
$string['none'] = 'Κανένα';
$string['noonlinesubmissions'] = 'Δεν απαιτείται κάποια υποβολή';
$string['noopen'] = 'Δεν υπάρχει ανοιχτή ημερομηνία';
$string['nooverridedata'] = 'Πρέπει να παρακάμψετε τουλάχιστον μία από τις ρυθμίσεις της εργασίας.';
$string['nosavebutnext'] = 'Επόμενο';
$string['nosubmission'] = 'Δεν έχει υποβληθεί τίποτα για την εργασία αυτή';
$string['nosubmissionyet'] = 'Δεν έχουν γίνει ακόμη υποβολές';
$string['noteam'] = 'Δεν είναι μέλος καμίας ομάδας';
$string['noteam_desc'] = 'Αυτή η ανάθεση απαιτεί την υποβολή σε ομάδες. Δεν είστε μέλος οποιασδήποτε ομάδας, έτσι δεν μπορείτε να δημιουργήσετε μια υποβολή. Επικοινωνήστε με τον διδάσκοντά σας για να προστεθείτε σε μια ομάδα.';
$string['noteamgrader'] = 'Δεν είστε μέλος κάποιας ομάδας, οπότε δεν είστε σε θέση να υποβάλετε εργασίες.';
$string['notgraded'] = 'Χωρίς βαθμό';
$string['notgradedyet'] = 'Δεν βαθμολογήθηκαν ακόμα';
$string['notifications'] = 'Ειδοποιήσεις';
$string['nouseroverrides'] = 'Δεν υπάρχουν προς το παρόν παρακάμψεις χρήστη.';
$string['nousers'] = 'Δεν υπάρχουν χρήστες';
$string['nousersselected'] = 'Δεν επιλέχθηκε κανένας χρήστης';
$string['numberofdraftsubmissions'] = 'Προσχέδια';
$string['numberofparticipants'] = 'Συμμετέχοντες';
$string['numberofsubmissionsneedgrading'] = 'Απαιτείται βαθμολόγηση';
$string['numberofsubmissionsneedgradinglabel'] = 'Χρειάζεται βαθμολόγηση: {$a}';
$string['numberofsubmittedassignments'] = 'Υποβλήθηκαν';
$string['numberofteams'] = 'Ομάδες';
$string['offline'] = 'Δεν απαιτείται καμία υποβολή εντός σύνδεσης';
$string['open'] = 'Άνοιγμα';
$string['outlinegrade'] = 'Βαθμός: {$a}';
$string['outof'] = '{$a->current} από {$a->total}';
$string['overdue'] = 'Η εργασία είναι εκπρόθεσμη κατά: {$a}';
$string['override'] = 'Παράκαμψη';
$string['overridedeletegroupsure'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την παράκαμψη για την ομάδα {$a};';
$string['overridedeleteusersure'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την παράκαμψη για τον χρήστη {$a};';
$string['overridegroup'] = 'Παράκαμψη ομάδας';
$string['overridegroupeventname'] = '{$a->assign} - {$a->group}';
$string['overrides'] = 'Παρακάμψεις';
$string['overrideuser'] = 'Παράκαμψη χρήστη';
$string['overrideusereventname'] = '{$a->assign} - Παράκαμψη';
$string['page-mod-assign-view'] = 'Κύρια σελίδα και σελίδα υποβολής αρθρώματος ανάθεσης';
$string['page-mod-assign-x'] = 'Σελίδα οποιουδήποτε αρθρώματος ανάθεσης';
$string['paramtimeremaining'] = '{$a} υπολείπονται';
$string['participant'] = 'Συμμετέχοντας';
$string['pluginadministration'] = 'Διαχείριση αναθέσεων';
$string['pluginname'] = 'Ανάθεση εργασίας';
$string['preventsubmissionnotingroup'] = 'Απαίτηση για υποβολή ανά ομάδες';
$string['preventsubmissionnotingroup_help'] = 'Εάν ενεργοποιηθεί, οι χρήστες που δεν είναι μέλη μιας ομάδας δεν θα είναι σε θέση να υποβάλουν εργασίες.';
$string['preventsubmissions'] = 'Παρεμπόδιση του χρήστη να κάνει περισσότερες υποβολές για αυτή την ανάθεση εργασίας.';
$string['preventsubmissionsshort'] = 'Αποτρέψτε τις αλλαγές υποβολής';
$string['previous'] = 'Προηγούμενο';
$string['previoususer'] = 'Προηγούμενος χρήστης';
$string['privacy:attemptpath'] = 'προσπάθεια {$a}';
$string['privacy:blindmarkingidentifier'] = 'Το αναγνωριστικό που χρησιμοποιείται για ανώνυμες υποβολές';
$string['privacy:gradepath'] = 'βαθμός';
$string['privacy:metadata:assigndownloadasfolders'] = 'Μια προτίμηση χρήστη για το αν πρέπει να λαμβάνονται πολλαπλά αρχεία υποβολής σε φακέλους';
$string['privacy:metadata:assignfeedbackpluginsummary'] = 'Δεδομένα ανατροφοδότησης για την ανάθεση.';
$string['privacy:metadata:assignfilter'] = 'Επιλογές φίλτρου όπως «Υποβλήθηκε», «Δεν έχει υποβληθεί», «Απαιτείται βαθμολόγηση» και «Δόθηκε παράταση»';
$string['privacy:metadata:assigngrades'] = 'Αποθηκεύει τους βαθμούς χρηστών για την ανάθεση';
$string['privacy:metadata:assignmarkerfilter'] = 'Φιλτράρισμα της περίληψης ανάθεσης από τον βαθμολογητή που ορίστηκε.';
$string['privacy:metadata:assignmentid'] = 'Αναγνωριστικό ανάθεσης εργασίας';
$string['privacy:metadata:assignmessageexplanation'] = 'Μηνύματα στέλνονται στους μαθητές μέσω του συστήματος ανταλλαγής μηνυμάτων.';
$string['privacy:metadata:assignoverrides'] = 'Αποθηκεύει πληροφορίες παράκαμψης για την ανάθεση εργασίας';
$string['privacy:metadata:assignperpage'] = 'Αριθμός αναθέσεων που εμφανίζονται ανά σελίδα.';
$string['privacy:metadata:assignquickgrading'] = 'Προτίμηση χρήσης ή όχι γρήγορης βαθμολόγησης.';
$string['privacy:metadata:assignsubmissiondetail'] = 'Αποθηκεύει πληροφορίες υποβολής χρηστών';
$string['privacy:metadata:assignsubmissionpluginsummary'] = 'Δεδομένα υποβολής για την ανάθεση.';
$string['privacy:metadata:assignuserflags'] = 'Αποθηκεύει μεταδεδομένα χρηστών, όπως παρατάσεις προθεσμιών';
$string['privacy:metadata:assignusermapping'] = 'Η αντιστοίχιση για ανώνυμες υποβολές';
$string['privacy:metadata:assignworkflowfilter'] = 'Φιλτράρισμα ανά διαφορετικό στάδιο ροής εργασίας.';
$string['privacy:metadata:grade'] = 'Ο αριθμητικός βαθμός για αυτήν την υποβολή εργασίας. Μπορεί να προσδιοριστεί με κλίμακες/προχωρημένες φόρμες βαθμολόγησης κλπ. αλλά θα μετατρέπεται πάντοτε τελικά σε έναν αριθμό κινητής υποδιαστολής.';
$string['privacy:metadata:grader'] = 'Το αναγνωριστικό χρήστη του προσώπου που βαθμολογεί.';
$string['privacy:metadata:groupid'] = 'Το αναγνωριστικό ομάδας της οποίας ο χρήστης είναι μέλος.';
$string['privacy:metadata:latest'] = 'Απλουστεύει σε μεγάλο βαθμό τα ερωτήματα που θέλουν να αντλήσουν πληροφορίες μόνο για την τελευταία προσπάθεια.';
$string['privacy:metadata:mailed'] = 'Έχει ήδη ειδοποιηθεί μέσω ηλε.ταχυδρομείου αυτός ο χρήστης;';
$string['privacy:metadata:timecreated'] = 'Χρόνος δημιουργίας';
$string['privacy:metadata:userid'] = 'Αναγνωριστικό του χρήστη';
$string['privacy:studentpath'] = 'υποβολέςμαθητή';
$string['privacy:submissionpath'] = 'υποβολή';
$string['quickgrading'] = 'Γρήγορη βαθμολόγηση';
$string['quickgrading_help'] = 'Η γρήγορη βαθμολόγηση σας επιτρέπει να αξιολογείτε με βαθμούς (και μαθησιακά αποτελέσματα) άμεσα στον πίνακα υποβολών. Η γρήγορη βαθμολόγηση δεν είναι συμβατή με την προχωρημένη βαθμολόγηση και δεν συνιστάται όταν υπάρχουν πολλοί βαθμολογητές.';
$string['quickgradingchangessaved'] = 'Οι αλλαγές στην βαθμολογία αποθηκεύτηκαν';
$string['quickgradingresult'] = 'Γρήγορη βαθμολόγηση';
$string['recordid'] = 'Αναγνωριστικό';
$string['relativedatessubmissiontimeleft'] = 'Υπολογισμένο για κάθε μαθητή';
$string['removeallgroupoverrides'] = 'Διαγραφή όλων των παρακάμψεων ομάδας';
$string['removealluseroverrides'] = 'Διαγραφή όλων των παρακάμψεων χρήστη';
$string['removesubmission'] = 'Διαγραφή υποβολής';
$string['removesubmissionconfirm'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την υποβολή σας;';
$string['removesubmissionconfirmforstudent'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την υποβολή για τον/την {$a};';
$string['removesubmissionconfirmforstudentwithtimelimit'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την υποβολή για τον/την {$a}; Λάβετε υπόψη ότι αυτό δε θα μηδενίσει το χρονικό όριο του μαθητή. Μπορείτε να δώσετε περισσότερο χρόνο προσθέτοντας μια παράκαμψη χρονικού ορίου για τον χρήστη.';
$string['removesubmissionconfirmwithtimelimit'] = 'Είστε βέβαιοι ότι θέλετε να διαγράψετε την υποβολή σας; Λάβετε υπόψη ότι αυτό δε θα επαναφέρει το χρονικό σας όριο.';
$string['removesubmissionforstudent'] = 'Διαγραφή υποβολής για μαθητή: (id={$a->id}, fullname={$a->fullname}).';
$string['reopenuntilpassincompatiblewithblindmarking'] = 'Η επιλογή ξανα-ανοίγματος μέχρι να επιτευχθεί επιτυχία δεν είναι συμβατή με τις ανώνυμες υποβολές, επειδή οι βαθμοί δεν εμφανίζονται στο βαθμολόγιο μέχρι να αποκαλυφθούν οι ταυτότητες των μαθητών.';
$string['requireallteammemberssubmit'] = 'Απαιτείται η υποβολή όλων των μελών της ομάδας';
$string['requireallteammemberssubmit_help'] = 'Αυτή η ρύθμιση πρέπει να χρησιμοποιείται σε συνδυασμό με τη ρύθμιση «Να απαιτείται από τους μαθητές να κάνουν κλικ στο κουμπί υποβολής» των ρυθμίσεων υποβολής.

Εάν ενεργοποιηθεί, όλα τα μέλη της ομάδας πρέπει να κάνουν κλικ στο κουμπί υποβολής για να θεωρηθεί ότι η ομαδική υποβολή έχει υποβληθεί. Εάν απενεργοποιηθεί, κάθε μέλος της ομάδας μπορεί να κάνει κλικ στο κουμπί υποβολής.';
$string['requiresubmissionstatement'] = 'Να απαιτείται οι μαθητές να αποδεχθούν τη δήλωση υποβολής';
$string['requiresubmissionstatement_help'] = 'Να απαιτείται οι μαθητές να αποδεχθούν τη δήλωση υποβολής για όλες τις υποβολές σε αυτή την εργασία.';
$string['revealidentities'] = 'Αποκάλυψη των ταυτοτήτων των μαθητών';
$string['revealidentitiesconfirm'] = 'Είστε βέβαιοι ότι θέλετε να αποκαλύψετε ταυτότητες μαθητών για αυτή την εργασία; Αυτή η λειτουργία δεν μπορεί να ανακληθεί. Μόλις αποκαλυφθούν οι ταυτότητες των μαθητών, οι βαθμολογίες θα εμφανιστούν στο βαθμολόγιο.';
$string['reverttodefaults'] = 'Επαναφορά στις προεπιλογές ανάθεσης (εργασίας)';
$string['reverttodraft'] = 'Επαναφορά της υποβολής σε κατάσταση προσχεδίου';
$string['reverttodraftforgroup'] = 'Ανάκληση της υποβολής σε προσχέδιο για την ομάδα {$a}.';
$string['reverttodraftforstudent'] = 'Επαναφορά υποβολής σε προσχέδιο για τον μαθητή: (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}).';
$string['reverttodraftshort'] = 'Επαναφορά υποβολής σε προσχέδιο';
$string['reviewed'] = 'Εξετάστηκε';
$string['save'] = 'Αποθήκευση';
$string['saveallquickgradingchanges'] = 'Αποθήκευση όλων των αλλαγών γρήγορης βαθμολόγησης';
$string['saveandcontinue'] = 'Αποθήκευση και συνέχεια';
$string['savechanges'] = 'Αποθήκευση αλλαγών';
$string['savegradingresult'] = 'Βαθμός';
$string['savenext'] = 'Αποθήκευση και εμφάνιση επόμενου';
$string['saveoverrideandstay'] = 'Αποθήκευση και εισαγωγή κι άλλης παράκαμψης';
$string['savingchanges'] = 'Αποθήκευση αλλαγών...';
$string['scale'] = 'Κλίμακα';
$string['search:activity'] = 'Ανάθεση (εργασίας) - πληροφορίες δραστηριότητας';
$string['selectedusers'] = 'Επιλεγμένοι χρήστες';
$string['selectlink'] = 'Επιλογή...';
$string['selectuser'] = 'Επιλογή {$a}';
$string['sendlatenotifications'] = 'Ειδοποίησε τους βαθμολογητές για καθυστερημένες υποβολές';
$string['sendlatenotifications_help'] = 'Εάν ενεργοποιηθεί, οι βαθμολογητές (συνήθως διδάσκοντες) λαμβάνουν ένα μήνυμα κάθε φορά που ένας μαθητής υποβάλλει μια εργασία αργά. Οι μέθοδοι μηνυμάτων μπορούν να ρυθμιστούν.';
$string['sendnotifications'] = 'Ειδοποίηση των βαθμολογητών για τις υποβολές';
$string['sendnotifications_help'] = 'Εάν ενεργοποιηθεί, οι βαθμολογητές (συνήθως διδάσκοντες) λαμβάνουν ένα μήνυμα όποτε ένας μαθητής υποβάλλει μια εργασία, νωρίς, στην ώρα του και αργά. Οι μέθοδοι μηνυμάτων είναι διαμορφώσιμες.';
$string['sendstudentnotifications'] = 'Ειδοποίηση μαθητή';
$string['sendstudentnotifications_help'] = 'Εάν ενεργοποιηθεί, οι μαθητές λαμβάνουν ένα μήνυμα σχετικά με την ενημερωμένη βαθμολογία ή την ανατροφοδότηση. Εάν η ροή εργασίας βαθμολόγησης είναι ενεργοποιημένη σε αυτή την ανάθεση εργασίας, οι ειδοποιήσεις θα σταλούν μόνο όταν η βαθμολογία γίνει «Ανακοινώθηκε».';
$string['sendstudentnotificationsdefault'] = 'Προεπιλογή για «Ειδοποίηση μαθητή»';
$string['sendstudentnotificationsdefault_help'] = 'Ορίστε την προεπιλεγμένη τιμή για το πλαίσιο επιλογής «Ειδοποίηση μαθητών» στην φόρμα βαθμολόγησης.';
$string['sendsubmissionreceipts'] = 'Αποστολή απόδειξης υποβολής στους μαθητές';
$string['sendsubmissionreceipts_help'] = 'Αυτός ο διακόπτης επιτρέπει την αποστολή αποδεικτικών υποβολής για τους μαθητές. Οι μαθητές θα λαμβάνουν ειδοποίηση κάθε φορά που υποβάλουν επιτυχώς μια εργασία.';
$string['setmarkerallocationforlog'] = 'Ορισμός εκχώρησης βαθμολογητή: (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}, βαθμολογητής={$a->marker}).';
$string['setmarkingallocation'] = 'Ορισμός βαθμολογητή που εκχωρείται';
$string['setmarkingworkflowstate'] = 'Ορισμός κατάστασης ροής εργασίας βαθμολόγησης';
$string['setmarkingworkflowstateforlog'] = 'Ορισμός κατάστασης ροής εργασίας βαθμολόγησης : (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}, κατάσταση={$a->state}).';
$string['settings'] = 'Ρυθμίσεις ανάθεσης (εργασίας)';
$string['showrecentsubmissions'] = 'Εμφάνιση πρόσφατων υποβολών';
$string['status'] = 'Κατάσταση';
$string['studentnotificationworkflowstateerror'] = 'Η κατάσταση ροής εργασίας βαθμολόγησης πρέπει να είναι «Ανακοινώθηκε» για να γίνει ενημέρωση μαθητών.';
$string['submission'] = 'Υποβολή';
$string['submissionattachments'] = 'Εμφάνιση αρχείων μόνο κατά την υποβολή';
$string['submissioncopiedhtml'] = '<p>Έχετε δημιουργήσει αντίγραφο της προηγούμενης υποβολής εργασίας για «<i>{$a->assignment}</i>». </p><p>Μπορείτε να δείτε την κατάσταση για την <a href="{$a->url}">υποβολή εργασίας </a>σας.</p>';
$string['submissioncopiedsmall'] = 'Αντιγράψατε την προηγούμενη υποβολή εργασίας για την ανάθεση {$a->assignment}';
$string['submissioncopiedtext'] = 'Έχετε δημιουργήσει ένα αντίγραφο της προηγούμενης υποβολής της εργασίας σας για «{$a->assignment». Μπορείτε να δείτε την κατάσταση της υποβολής της εργασίας σας: {$a->url}';
$string['submissiondrafts'] = 'Απαιτείται οι μαθητές να πατάνε το κουμπί υποβολής';
$string['submissiondrafts_help'] = 'Εάν ενεργοποιηθεί, οι μαθητές θα πρέπει να κάνουν κλικ σε ένα κουμπί «Υποβολή» για να δηλώσουν την υποβολή τους ως τελική. Αυτό επιτρέπει στους μαθητές να διατηρούν έκδοση προσχεδίου της υποβολής τους στο σύστημα. Εάν αυτή η ρύθμιση αλλάξει από «Όχι» σε «Ναι» αφού κάποιοι μαθητές έχουν ήδη κάνει υποβολές, αυτές θα θεωρηθούν ως τελικές.';
$string['submissioneditable'] = 'Ο μαθητής μπορεί να επεξεργαστεί αυτήν την υποβολή';
$string['submissionempty'] = 'Τίποτα δεν υποβλήθηκε';
$string['submissionlog'] = 'Μαθητής: {$a->fullname}, Κατάσταση: {$a->status}';
$string['submissionmodified'] = 'Υπάρχουν ήδη δεδομένα υποβολής. Παρακαλούμε, αφήστε αυτήν την ιστοσελίδα και δοκιμάστε ξανά.';
$string['submissionmodifiedgroup'] = 'Η υποβολή έχει τροποποιηθεί από κάποιον άλλο. Παρακαλούμε, αφήστε αυτήν την ιστοσελίδα και δοκιμάστε ξανά.';
$string['submissionnotcopiedinvalidstatus'] = 'Η υποβολή δεν αντιγράφηκε επειδή έχει τροποποιηθεί από τότε που ξανάνοιξε.';
$string['submissionnoteditable'] = 'Ο μαθητής δεν μπορεί να επεξεργαστεί αυτήν την υποβολή';
$string['submissionnotready'] = 'Αυτή η εργασία δεν είναι έτοιμη να υποβληθεί:';
$string['submissionplugins'] = 'Πρόσθετα υποβολής';
$string['submissionreceipthtml'] = '<p>Έχετε υποβάλλει την εργασία σας για «<i>{$a->assignment}</i>».</p><p>Μπορείτε να δείτε την κατάσταση της <a href="{$a->url}">υποβολής σας</a>.</p>';
$string['submissionreceiptotherhtml'] = 'Η υποβολή της εργασίας σας για «<i>{$a->assignment}</i>» έχει ολοκληρωθεί.<br /><br />
Μπορείτε να δείτε την κατάσταση για την <a href="{$a->url}">υποβολή εργασίας</a> σας.';
$string['submissionreceiptothersmall'] = 'Η υποβολή της εργασίας σας για «{$a->assignment}» έχει ολοκληρωθεί.';
$string['submissionreceiptothertext'] = 'Η υποβολή της εργασίας σας για «{$a->assignment}» έχει ολοκληρωθεί.
 Μπορείτε να δείτε την κατάσταση της υποβολής εργασίας σας: {$a->url}»';
$string['submissionreceipts'] = 'Αποστολή αποδεικτικών υποβολής';
$string['submissionreceiptsmall'] = 'Έχετε υποβάλει την εργασία σας για το {$a->assignment}';
$string['submissionreceipttext'] = 'Ολοκληρώσατε μια υποβολή εργασίας για «{$a->assignment}». Μπορείτε να δείτε την κατάσταση της υποβολής εργασίας: {$a->url}';
$string['submissionsclosed'] = 'Οι υποβολές έκλεισαν';
$string['submissionsettings'] = 'Ρυθμίσεις υποβολής';
$string['submissionslocked'] = 'Αυτή η ανάθεση δεν δέχεται υποβολές';
$string['submissionslockedshort'] = 'Οι αλλαγές των υποβολών δεν επιτρέπονται';
$string['submissionstatement'] = 'Δήλωση υποβολής';
$string['submissionstatement_help'] = 'Δήλωση που κάθε μαθητής πρέπει να αποδεχθεί προκειμένου να υποβάλει την εργασία του.';
$string['submissionstatementacceptedlog'] = 'Δήλωση υποβολής αποδεκτή από τον χρήστη {$a}';
$string['submissionstatementdefault'] = 'Είμαι ο αποκλειστικός συγγραφέας αυτής της εργασίας που υποβάλω, εκτός από τα τμήματα που σαφώς έχω αναφέρει την πηγή τους.';
$string['submissionstatementrequired'] = 'Απαιτείται να αποδεχτείτε αυτή τη δήλωση πριν υποβάλετε την αίτησή σας.';
$string['submissionstatementteamsubmission'] = 'Δήλωση υποβολής ομάδας';
$string['submissionstatementteamsubmission_help'] = 'Δήλωση που κάθε μαθητής πρέπει να αποδεχθεί για να υποβάλει την εργασία της ομάδας του.';
$string['submissionstatementteamsubmissionallsubmit'] = 'Δήλωση υποβολής ομάδας, όταν υποβάλλουν όλα τα μέλη της ομάδας';
$string['submissionstatementteamsubmissionallsubmit_help'] = 'Δήλωση που κάθε μαθητής πρέπει να αποδεχθεί για να υποβάλει την εργασία του ως μέλος της ομάδας.';
$string['submissionstatementteamsubmissionallsubmitdefault'] = 'Αυτή η υποβολή είναι έργο δικό μου ως μέλος της ομάδας, εκτός από τα τμήματα για τα οποία σαφώς έχω αναγνωρίσει τη χρήση των έργων άλλων ανθρώπων.';
$string['submissionstatementteamsubmissiondefault'] = 'Αυτή η υποβολή είναι έργο της ομάδας μου, εκτός από τα τμήματα για τα οποία σαφώς αναγνωρίσαμε τη χρήση των έργων άλλων ανθρώπων.';
$string['submissionstatus'] = 'Κατάσταση Υποβολής';
$string['submissionstatus_'] = 'Καμία υποβολή';
$string['submissionstatus_draft'] = 'Προσχέδιο (δεν υποβλήθηκε)';
$string['submissionstatus_marked'] = 'Βαθμολογήθηκε';
$string['submissionstatus_new'] = 'Καμία υποβολή';
$string['submissionstatus_reopened'] = 'Άνοιξε ξανά';
$string['submissionstatus_submitted'] = 'Υποβλήθηκε για βαθμολόγηση';
$string['submissionstatusheading'] = 'Κατάσταση Υποβολής';
$string['submissionsummary'] = '{$a->status}. Τελευταία τροποποίηση στις {$a->timemodified}';
$string['submissionteam'] = 'Ομάδα';
$string['submissiontypes'] = 'Τύποι υποβολών';
$string['submitaction'] = 'Υποβολή';
$string['submitassignment'] = 'Υποβολή εργασίας';
$string['submitassignment_help'] = 'Από τη στιγμή που θα υποβληθεί η εργασία δεν θα μπορείτε να κάνετε οποιαδήποτε αλλαγή.';
$string['submitforgrading'] = 'Υποβολή για βαθμολόγηση';
$string['submitted'] = 'Υποβλήθηκε';
$string['submittedearly'] = 'Η εργασία υποβλήθηκε νωρίτερα κατά {$a}';
$string['submittedlate'] = 'Η εργασία υποβλήθηκε {$a} αργότερα';
$string['submittedlateshort'] = '{$a} αργά';
$string['submittedovertime'] = 'Η εργασία υποβλήθηκε {$a} πέραν του χρονικού ορίου';
$string['submittedundertime'] = 'Η εργασία υποβλήθηκε {$a} πριν του χρονικού ορίου';
$string['subpagetitle'] = '{$a->contextname} - {$a->subpage}';
$string['subplugintype_assignfeedback'] = 'Πρόσθετο ανατροφοδότησης';
$string['subplugintype_assignfeedback_plural'] = 'Πρόσθετα ανατροφοδότησης';
$string['subplugintype_assignsubmission'] = 'Πρόσθετο υποβολής';
$string['subplugintype_assignsubmission_plural'] = 'Πρόσθετα υποβολής';
$string['teamname'] = 'Ομάδα: {$a}';
$string['teamsubmission'] = 'Οι μαθητές υποβάλουν εργασίες σε ομάδες';
$string['teamsubmission_help'] = 'Εάν ενεργοποιηθεί, οι μαθητές θα χωριστούν σε ομάδες με βάση το προεπιλεγμένο σύνολο ομάδων ή μια προσαρμοσμένη ομαδοποίηση. Μια υποβολή εργασίας ομάδας θα είναι κοινόχρηστη μεταξύ των μελών της ομάδας και όλα τα μέλη της ομάδας θα βλέπουν ο ένας τις αλλαγές του άλλου στην υποβολή.';
$string['teamsubmissiongroupingid'] = 'Ομαδοποίηση για ομάδες μαθητών';
$string['teamsubmissiongroupingid_help'] = 'Αυτή είναι η ομαδοποίηση που θα χρησιμοποιήσει η εργασία για την εύρεση ομάδων για ομάδες μαθητών. Εάν δεν έχει οριστεί, θα χρησιμοποιηθεί το προεπιλεγμένο σύνολο ομάδων.';
$string['textinstructions'] = 'Οδηγίες ανάθεσης';
$string['timelimit'] = 'Χρονικό όριο';
$string['timelimit_help'] = 'Αν ενεργοποιηθεί, το χρονικό όριο αναγράφεται στη σελίδα της εργασίας και εμφανίζεται ένα χρονόμετρο αντίστροφης μέτρησης κατά τη διάρκειά της.';
$string['timelimitnotenabled'] = 'Το χρονικό όριο δεν είναι ενεργοποιημένο για την εργασία.';
$string['timelimitpassed'] = 'Το χρονικό όριο έχει λήξει';
$string['timemodified'] = 'Τελευταία τροποποίηση';
$string['timeremaining'] = 'Χρόνος που απομένει';
$string['timeremainingcolon'] = 'Χρόνος που απομένει: {$a}';
$string['togglezoom'] = 'Μεγέθυνση/σμίκρυνση περιοχής';
$string['ungroupedusers'] = 'Η ρύθμιση «Απαίτηση για υποβολή ανά ομάδες» είναι ενεργοποιημένη και ορισμένοι χρήστες είτε δεν είναι μέλη κάποιας ομάδας, είτε είναι μέλη περισσότερων από μία ομάδων, οπότε δεν μπορούν να υποβάλουν εργασίες.';
$string['ungroupedusersoptional'] = 'Η ρύθμιση «Οι μαθητές υποβάλλουν σε ομάδες» είναι ενεργοποιημένη και ορισμένοι χρήστες είτε δεν είναι μέλος καμίας ομάδας, είτε είναι μέλος περισσότερων από μία ομάδων. Παρακαλούμε, λάβετε υπόψη ότι οι μαθητές αυτοί θα υποβάλλουν ως μέλη της προεπιλεγμένης ομάδας.';
$string['unlimitedattempts'] = 'Χωρίς περιορισμό';
$string['unlimitedattemptsallowed'] = 'Επιτρέπεται απεριόριστος αριθμός προσπαθειών.';
$string['unlimitedpages'] = 'Χωρίς περιορισμό';
$string['unlocksubmissionforstudent'] = 'Να επιτρέπονται οι υποβολές για τον μαθητή: (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}).';
$string['unlocksubmissions'] = 'Ξεκλείδωμα υποβολών';
$string['unsavedchanges'] = 'Μη αποθηκευμένες αλλαγές';
$string['unsavedchangesquestion'] = 'Υπάρχουν αλλαγές στους βαθμούς ή την ανατροφοδότηση που δεν έχουν αποθηκευτεί. Θέλετε να αποθηκεύσετε τις αλλαγές και να συνεχίσετε;';
$string['updategrade'] = 'Ανανέωση βαθμού';
$string['updatetable'] = 'Αποθηκεύστε και ενημερώστε τον πίνακα';
$string['upgradenotimplemented'] = 'Η αναβάθμιση δεν υλοποιήθηκε για το πρόσθετο ({$a->type} {$a->subtype})';
$string['userassignmentdefaults'] = 'Προεπιλογές ανάθεσης μαθητή';
$string['userextensiondate'] = 'Παραχωρήθηκε παράταση μέχρι: {$a}';
$string['usergrade'] = 'Βαθμός χρήστη';
$string['useridlistnotcached'] = 'Οι αλλαγές βαθμού ΔΕΝ αποθηκεύτηκαν, καθώς δεν ήταν δυνατό να προσδιοριστεί για ποια υποβολή ήταν.';
$string['useroverrides'] = 'Παρακάμψεις χρηστών';
$string['useroverridesdeleted'] = 'Διαγραφή παρακάμψεων χρηστών';
$string['usersnone'] = 'Κανένας μαθητής δεν έχει πρόσβαση σε αυτή την ανάθεση (εργασίας).';
$string['usersubmissioncannotberemoved'] = 'Η υποβολή του {$a} δεν μπορεί να διαγραφεί.';
$string['userswhoneedtosubmit'] = 'Χρήστες που πρέπει να υποβάλουν: {$a}';
$string['validmarkingworkflowstates'] = 'Έγκυρες καταστάσεις ροής εργασίας βαθμολόγησης';
$string['viewadifferentattempt'] = 'Εμφάνιση μιας διαφορετικής προσπάθειας';
$string['viewbatchmarkingallocation'] = 'Εμφάνιση σελίδας δέσμης ορισμών βαθμολογητών που εκχωρούνται.';
$string['viewbatchsetmarkingworkflowstate'] = 'Εμφάνιση σελίδας δέσμης ορισμών κατάστασης ροής εργασίας βαθμολόγησης.';
$string['viewfeedback'] = 'Εμφάνιση ανατροφοδότησης';
$string['viewfeedbackforuser'] = 'Εμφάνιση ανατροφοδότησης για τον χρήστη: {$a}';
$string['viewfull'] = 'Πλήρης προβολή';
$string['viewfullgradingpage'] = 'Άνοιγμα της πλήρους σελίδας βαθμολόγησης για παροχή ανατροφοδότησης';
$string['viewgradebook'] = 'Εμφάνιση βαθμολογίου';
$string['viewgrading'] = 'Εμφάνιση όλων των υποβολών';
$string['viewgradingformforstudent'] = 'Εμφάνιση σελίδας βαθμολόγησης για μαθητή: (αναγνωριστικό={$a->id}, πλήρες όνομα={$a->fullname}).';
$string['viewownsubmissionform'] = 'Εμφάνιση της δικής σας σελίδας υποβολής εργασίας.';
$string['viewownsubmissionstatus'] = 'Εμφάνιση της δικής σας σελίδας κατάστασης υποβολής εργασίας.';
$string['viewrevealidentitiesconfirm'] = 'Εμφάνιση σελίδας επιβεβαίωσης αποκάλυψης ταυτότητας μαθητών.';
$string['viewsubmission'] = 'Εμφάνιση υποβολής';
$string['viewsubmissionforuser'] = 'Εμφάνιση υποβολής για χρήστη: {$a}';
$string['viewsubmissiongradingtable'] = 'Εμφάνιση πίνακα βαθμολόγησης υποβολής.';
$string['viewsummary'] = 'Εμφάνιση περίληψης';
$string['workflowfilter'] = 'Φίλτρο ροής εργασίας';
$string['xofy'] = '{$a->x} από {$a->y}';
