<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_brickfield', language 'el', version '4.4'.
 *
 * @package     tool_brickfield
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility'] = 'Προσβασιμότητα';
$string['accessibilitydisabled'] = 'Το κιτ εργαλείων προσβασιμότητας Brickfield δεν είναι ενεργοποιημένο σε αυτόν τον ιστότοπο. Επικοινωνήστε με τον διαχειριστή του ιστοτόπου σας για ενεργοποίηση.';
$string['accessibilityreport'] = 'Εργαλειοθήκη προσβασιμότητας';
$string['accessibilitytool'] = 'Εργαλείο προσβασιμότητας Brickfield';
$string['accessibilitytools'] = 'Εργαλεία προσβασιμότητας Brickfield';
$string['activate'] = 'Ενεργοποίηση';
$string['activated'] = 'Το πρόσθετο είναι ενεργοποιημένο και έτοιμο για χρήση.';
$string['activationform'] = 'Εγγραφή στο Brickfield';
$string['activationheader'] = 'Ενεργοποίηση Brickfield';
$string['activationinfo'] = '<p>Για να χρησιμοποιήσετε αυτό το πρόσθετο, πρέπει να παρέχετε έγκυρα κλειδιά για αυτόν τον ιστότοπο σε αυτή τη φόρμα.</p><p>Παρακαλούμε, <a href="{$a}" data-action="send_info" target="_blank">Εγγραφείτε στην Πύλη του Brickfield (ανοίγει σε νέο παράθυρο)</a> για να λάβετε αυτά τα κλειδιά αν δεν τα έχετε ήδη.</p><p>Μετά την ενεργοποίηση, τα κλειδιά σας θα επικυρωθούν μέσω προγραμματισμένων εργασιών cron.</p>';
$string['activityresults:pluginname'] = 'Αναφορά εργαλείου προσβασιμότητας κατά ανάλυση δραστηριότητας';
$string['activityresults:toolname'] = 'Περίληψη ανάλυσης δραστηριότητας';
$string['activityresults:toolshortname'] = 'Ανάλυση δραστηριότητας';
$string['advanced:pluginname'] = 'Προχωρημένη αναφορά εργαλείου προσβασιμότητας';
$string['advanced:toolname'] = 'Προχωρημένη περίληψη';
$string['advanced:toolshortname'] = 'Προχωρημένα';
$string['allcourses'] = 'Όλα τα μαθήματα που αξιολογήθηκαν ({$a})';
$string['allcoursescat'] = 'Όλα τα μαθήματα που αξιολογήθηκαν για την κατηγορία {$a->catname} ({$a->count})';
$string['analysis:byrequest'] = 'Κατόπιν αιτήματος';
$string['analysis:disabled'] = 'Απενεργοποιημένο';
$string['analysistype'] = 'Ενεργοποίηση αιτημάτων ανάλυσης';
$string['analysistype_desc'] = 'Να επιτρέπεται η ανάλυση προσβασιμότητας περιεχομένου';
$string['analysistypedisabled'] = 'Η ανάλυση περιεχομένου είναι απενεργοποιημένη';
$string['bannercontentone'] = 'Η Εργαλειοθήκη Προσβασιμότητας για Επιχειρήσεις (Enterprise Accessibility Toolkit) διαθέτει ένα πλήρες σύνολο λειτουργιών/χαρακτηριστικών για να βοηθήσει τον οργανισμό σας να βελτιώσει την προσβασιμότητα των μαθημάτων σας. <a href="{$a}">Επικοινωνήστε με τα Εργαστήρια Εκπαίδευσης Brickfield</a> για να κλείσετε ένα δωρεάν δοκιμαστικό των προηγμένων λειτουργιών.';
$string['bannercontenttwo'] = 'Δημιουργήστε μια αποτελεσματική και περιεκτική πλατφόρμα διδασκαλίας και μάθησης, βρίσκοντας περιεχόμενο που δεν πληροί τις οδηγίες, διορθώνοντας τα ζητήματα και εξασφαλίζοντας τη μελλοντική χρήση του περιεχομένου του μαθήματος Moodle με προσβάσιμα αρχεία, πρόγραμμα επεξεργασίας και βελτιωμένα χαρακτηριστικά.';
$string['bannerheadingone'] = 'Αναβάθμιση στο Enterprise Accessibility Toolkit (κιτ εργαλείων προσβασιμότητας επιχειρήσεων)';
$string['batch'] = 'Όριο παρτίδας';
$string['brickfield'] = 'Εργαλειοθήκη Brickfield';
$string['brickfield:viewcoursetools'] = 'Προβολή αναφορών ανά μάθημα';
$string['brickfield:viewsystemtools'] = 'Δείτε αναφορές για όλα τα μαθήματα';
$string['bulkprocesscaches'] = 'Μαζική επεξεργασία κρυφής μνήμης';
$string['bulkprocesscourses'] = 'Διαδικασία ελέγχου προσβασιμότητας μαζικής παρτίδας';
$string['buttonone'] = 'Λάβετε ένα δωρεάν δοκιμαστικό';
$string['cachepending'] = 'Τα περιληπτικά δεδομένα συγκεντρώνονται';
$string['checkdesc:alinksdontopennewwindow'] = 'Οι σύνδεσμοι που ανοίγουν σε νέο παράθυρο πρέπει να προειδοποιούν τους χρήστες εκ των προτέρων.';
$string['checkdesc:amustcontaintext'] = 'Ένας σύνδεσμος πρέπει να περιέχει κείμενο για να γίνει αντιληπτός.';
$string['checkdesc:areadontopennewwindow'] = 'Οι περιοχές, που χρησιμοποιούνται σε χάρτες εικόνων, και ανοίγουν  ένα νέο παράθυρο πρέπει να προειδοποιούν τους χρήστες εκ των προτέρων.';
$string['checkdesc:areahasaltvalue'] = 'Από τις περιοχές, που χρησιμοποιούνται σε χάρτες εικόνων, δεν πρέπει να λείπει το "alt" (εναλλακτικό) κείμενο, σχετικό/παρόμοιο με τις εικόνες.';
$string['checkdesc:asuspiciouslinktext'] = 'Το κείμενο συνδέσμου πρέπει να είναι περιγραφικό και να παρέχει πλαίσιο συμφραζομένων σχετικά με τον προορισμό του.';
$string['checkdesc:basefontisnotused'] = 'Τα στοιχεία Basefont (παραδοσιακά χρησιμοποιούνται για μορφοποίηση) δεν είναι προσβάσιμα και δεν πρέπει να χρησιμοποιούνται.';
$string['checkdesc:blinkisnotused'] = 'Τα στοιχεία που αναβοσβήνουν, τα οποία ανάβουν και σβήνουν, δεν είναι (εύκολα/πάντα) προσβάσιμα και δεν πρέπει να χρησιμοποιούνται.';
$string['checkdesc:boldisnotused'] = 'Δεν πρέπει να χρησιμοποιούνται στοιχεία "Bold" (b) (έντονα, με πάχος), αντίθετα πρέπει να χρησιμοποιούνται "strong" (έντονα, δυνατά).';
$string['checkdesc:contenttoolong'] = 'Το συνολικό μήκος του περιεχομένου της σελίδας δεν πρέπει να υπερβαίνει τις 500 λέξεις.';
$string['checkdesc:csstexthascontrast'] = 'Η χρωματική αντίθεση μεταξύ του κειμένου και του υπόβαθρου είναι πολύ χαμηλή.';
$string['checkdesc:embedhasassociatednoembed'] = 'Από τα στοιχεία ενσωμάτωσης (για ενσωμάτωση πολυμέσων) δεν πρέπει να λείπουν τα αντίστοιχα στοιχεία "noembed".';
$string['checkdesc:headerh3'] = 'Οι κεφαλίδες που ακολουθούν μετά τις κεφαλίδες H3 (η επιλογή επεξεργαστή κειμένου large header) δεν πρέπει να σπάνε την ιεραρχία επικεφαλίδων σελίδας.';
$string['checkdesc:headershavetext'] = 'Μια κεφαλίδα πρέπει να περιέχει κείμενο για να γίνει αντιληπτή.';
$string['checkdesc:iisnotused'] = 'Δεν πρέπει να χρησιμοποιούνται στοιχεία με πλάγια γράμματα (i), αντίθετα θα πρέπει να χρησιμοποιούνται τα "em" (έμφαση).';
$string['checkdesc:imgaltisdifferent'] = 'Το εναλλακτικό κείμενο "Alt" των εικόνων δεν πρέπει να είναι το όνομα του αρχείου της εικόνας.';
$string['checkdesc:imgaltistoolong'] = 'Το εναλλακτικό κείμενο "Alt" των εικόνων δεν πρέπει να υπερβαίνει τον μέγιστο επιτρεπόμενο αριθμό (125) χαρακτήρων.';
$string['checkdesc:imgaltnotemptyinanchor'] = 'Το εναλλακτικό κείμενο "Alt" των εικόνων δεν πρέπει να είναι κενό, ειδικά όταν η εικόνα είναι σύνδεσμος για μετάβαση αλλού.';
$string['checkdesc:imgaltnotplaceholder'] = 'Το εναλλακτικό κείμενο "Alt" των εικόνων δεν πρέπει να είναι απλό κείμενο κράτησης θέσης, π.χ. «εικόνα».';
$string['checkdesc:imghasalt'] = 'Το εναλλακτικό κείμενο "Alt" των εικόνων δεν πρέπει να λείπει από τα στοιχεία εικόνας, εκτός εάν είναι καθαρά διακοσμητικά χωρίς νόημα.';
$string['checkdesc:imgwithmaphasusemap'] = 'Οι χάρτες εικόνας, με δυνατότητα πατήματος κλικ σε περιοχές, χρειάζονται αντίστοιχα στοιχεία "usemap" (χάρτης χρήστη) και "map" (χάρτης).';
$string['checkdesc:legendtextnotempty'] = 'Τα στοιχεία "Legend", που χρησιμοποιούνται για λεζάντες στοιχείων πεδίου, πρέπει να περιέχουν κείμενο.';
$string['checkdesc:marqueeisnotused'] = 'Τα στοιχεία "Marquee" (αυτόματη κύλιση) δεν είναι (εύκολα/πάντα) προσβάσιμα και δεν πρέπει να χρησιμοποιούνται.';
$string['checkdesc:noheadings'] = 'Καμία κεφαλίδα δεν καθιστά το περιεχόμενο λιγότερο δομημένο και πιο δύσκολο να διαβαστεί.';
$string['checkdesc:objectmusthaveembed'] = 'Από τα στοιχεία "Object" (για την ενσωμάτωση εξωτερικών πόρων) δεν πρέπει να λείπουν τα αντίστοιχα στοιχεία "embed" (ενσωμάτωσης).';
$string['checkdesc:objectmusthavetitle'] = 'Από τα στοιχεία "Object" (για την ενσωμάτωση εξωτερικών πόρων) δεν πρέπει να λείπουν οι αντίστοιχες περιγραφές "title" (τίτλου).';
$string['checkdesc:objectmusthavevalidtitle'] = 'Τα στοιχεία "Object" (για την ενσωμάτωση εξωτερικών πόρων) πρέπει να έχουν αντίστοιχους τίτλους "titles" με κείμενο.';
$string['checkdesc:strikeisnotused'] = 'Τα στοιχεία "Strike" (διαγεγραμμένα, με γραμμή) δεν πρέπει να χρησιμοποιούνται, αλλά αντί αυτών να χρησιμοποιείται "del" (διαγράφεται).';
$string['checkdesc:tabledatashouldhaveth'] = 'Από τους πίνακες ιδανικά δεν πρέπει να λείπουν κεφαλίδες.';
$string['checkdesc:tablesummarydoesnotduplicatecaption'] = 'Οι  περιλήψεις "summaries" και οι λεζάντες "captions", των πινάκων δεν πρέπει να είναι πανομοιότυπες.';
$string['checkdesc:tabletdshouldnotmerge'] = 'Οι πίνακες ιδανικά δεν πρέπει να έχουν συγχωνευμένα κελιά.';
$string['checkdesc:tablethshouldhavescope'] = 'Το εύρος σειράς ή στήλης πίνακα (που χρησιμοποιείται για την αντιστοίχιση σειράς και στήλης σε κάθε κελί) πρέπει να δηλώνονται.';
$string['checkidvalidation'] = 'Εργασία για έλεγχο τυχόν μη έγκυρων αναγνωριστικών ελέγχου';
$string['checkscompleted'] = 'Έλεγχοι που ολοκληρώθηκαν: {$a}';
$string['checktype'] = 'Έλεγχος ομάδας';
$string['checktype:form'] = 'Μορφή';
$string['checktype:image'] = 'Εικόνα';
$string['checktype:layout'] = 'Διάταξη';
$string['checktype:link'] = 'Σύνδεσμος';
$string['checktype:media'] = 'Πολυμέσα';
$string['checktype:table'] = 'Πίνακας';
$string['checktype:text'] = 'Κείμενο';
$string['checktyperesults:pluginname'] = 'Αναφορά εργαλείου προσβασιμότητας τύπων περιεχομένου';
$string['checktyperesults:toolname'] = 'Περίληψη τύπων περιεχομένου';
$string['checktyperesults:toolshortname'] = 'Τύποι περιεχομένου';
$string['cmpercent'] = 'Συνολικό ποσοστό δραστηριοτήτων';
$string['cmpercenterrors'] = 'Συνολικό ποσοστό σφαλμάτων';
$string['cmpercenttitle'] = 'Συνολική % ανάλυση δραστηριοτήτων έναντι σφαλμάτων';
$string['confirmationmessage'] = 'Αυτό το μάθημα έχει προγραμματιστεί για ανάλυση. Η ανάλυση θα ολοκληρωθεί το νωρίτερο στις {$a}. Ελέγξτε ξανά μετά.';
$string['contactadmin'] = 'Παρακαλούμε, επικοινωνήστε με τον διαχειριστή σας για να ολοκληρώσετε την καταχώρηση.';
$string['contactus'] = 'Επικοινωνήστε μαζί μας';
$string['contentfive'] = 'Αυτόματη διόρθωση μη ενημερωμένων ετικετών HTML.';
$string['contentfour'] = 'Προσδιορίστε ποιες δραστηριότητες έχουν τα περισσότερα προβλήματα προσβασιμότητας για να δώσετε προτεραιότητα στις προσπάθειές σας.';
$string['contentone'] = 'Αξιολογήστε αυτόματα το περιεχόμενο των μαθημάτων και τις αξιολογήσεις σας για ζητήματα προσβασιμότητας';
$string['contentsix'] = 'Δώστε στους διδάσκοντες έγκαιρες συμβουλές για τη δημιουργία καλύτερου περιεχομένου.';
$string['contentthree'] = 'Παρέχετε στους μαθητές σας περιεχόμενο σε προσβάσιμες μορφές όπως Audio, ePub και Electronic Braille.';
$string['contenttwo'] = 'Ενημερώστε μαζικά τυχόν ασαφή κείμενα ή κείμενα με ελλείψεις, για συνδέσμους ιστού, περιγραφές εικόνων και υπότιτλους βίντεο.';
$string['contenttypeerrors'] = 'Συνολικά αποτελέσματα δοκιμών περιεχομένου δραστηριότητας ανά μάθημα και ανά τύπο περιεχομένου.';
$string['contentyperesults'] = 'Σύνολο επιτυχόντων/αποτυχόντων για περιοχές περιεχομένου ανά μάθημα.';
$string['contextid'] = 'Αναγνωριστικό συμφραζομένων';
$string['core_course'] = 'Μάθημα';
$string['core_question'] = 'Τράπεζες ερωτήσεων';
$string['count'] = 'Πλήθος';
$string['country'] = 'Χώρα';
$string['country_help'] = 'Χώρα του ιστοτόπου';
$string['coursecount'] = 'Αριθμός μαθημάτων';
$string['deletehistoricaldata'] = 'Διαγραφή αποτελεσμάτων ιστορικών ελέγχων';
$string['dependency'] = 'Εξαρτάται από';
$string['emptycategory'] = 'Δεν βρέθηκαν μαθήματα για την κατηγορία {$a}';
$string['emptytagcourses'] = 'Δεν βρέθηκαν αποτελέσματα για μαθήματα με διαμορφωμένες ετικέτες';
$string['enableaccessibilitytools'] = 'Ενεργοποίηση εργαλείων προσβασιμότητας';
$string['enableaccessibilitytools_desc'] = 'Η εργαλειοθήκη προσβασιμότητας βοηθά στον εντοπισμό ζητημάτων προσβασιμότητας στα μαθήματα.';
$string['error:nocoursespecified'] = 'Αυτή η συνοπτική αναφορά απαιτεί έγκυρο αναγνωριστικό μαθήματος. Παρακαλούμε, να αποκτάτε πρόσβαση στην εργαλειοθήκη προσβασιμότητας μέσα από ένα μάθημα, μέσω του μενού ενεργειών, το οποίο στη συνέχεια θα παρέχει αυτό το απαιτούμενο αναγνωριστικό μαθήματος.';
$string['errorlink'] = 'Επεξεργασία στιγμιοτύπου σφάλματος για {$a}';
$string['errors'] = 'Σφάλματα: {$a}';
$string['errors:pluginname'] = 'Εργαλείο προσβασιμότητας λίστας σφαλμάτων';
$string['errors:toolname'] = 'Σύνοψη/περίλιψη λίστας σφαλμάτων';
$string['errors:toolshortname'] = 'Λίστα σφαλμάτων';
$string['eventanalysis_requested'] = 'Ζητήθηκε ανάλυση περιεχομένου';
$string['eventanalysis_requesteddesc'] = 'Ζητήθηκε ανάλυση περιεχομένου για το μάθημα {$a}.';
$string['eventreport_downloaded'] = 'Έγινε λήψη της σύνοψης προσβασιμότητας';
$string['eventreport_downloadeddesc'] = 'Έγινε λήψη της σύνοψης προσβασιμότητας για το μάθημα με αναγνωριστικό {$a}.';
$string['eventreport_viewed'] = 'Η αναφορά προσβασιμότητας προβλήθηκε';
$string['eventreport_vieweddesc'] = 'Η αναφορά προσβασιμότητας προβλήθηκε για το μάθημα με αναγνωριστικό {$a}, αναγνωριστικό κατηγορίας {$a->category} και καρτέλα {$a->tab}.';
$string['failed'] = 'Αποτυχία';
$string['failedcount'] = 'Αποτυχία: {$a}';
$string['footerheading'] = 'Τμήμα υποσέλιδου';
$string['fullcachedone'] = 'Απενεργοποίηση για επανασυμπλήρωση κρυφής μνήμης';
$string['hashcorrect'] = 'Ο κωδικός που εισαγάγατε είναι σωστός.';
$string['hashincorrect'] = 'Ο κωδικός που εισαγάγατε είναι λανθασμένος.';
$string['headingfive'] = 'Διορθώσεις HTML';
$string['headingfour'] = 'Στοχευμένη προσπάθεια';
$string['headingone'] = 'Αξιολόγηση περιεχόμενου';
$string['headingsix'] = 'Υποστήριξη απόδοσης';
$string['headingthree'] = 'Προσβάσιμοι μορφότυποι αρχείων';
$string['headingtwo'] = 'Αποκατάσταση';
$string['hideshow'] = 'Απόκρυψη/εμφάνιση';
$string['inactive'] = 'Το πρόσθετο είναι ανενεργό και δεν μπορεί να χρησιμοποιηθεί. Παρακαλούμε, εισαγάγετε έγκυρα κλειδιά καταχώρησης και πατήστε «Ενεργοποίηση».';
$string['innercontextid'] = 'Εσωτερικό πλαίσιο συμφραζομένων';
$string['installed'] = 'Το πρόσθετο εγκαταστάθηκε';
$string['installedcli'] = 'Το πρόσθετο εγκαταστάθηκε μέσω γραμμής εντολών';
$string['installeddescription'] = 'Το πρόσθετο εγκαταστάθηκε... ανακατεύθυνση στη φόρμα ενεργοποίησης.';
$string['invalidaccessibilitytool'] = 'Ζητήθηκε μη έγκυρο πρόσθετο προσβασιμότητας.';
$string['invalidcategoryid'] = 'Μη έγκυρη κατηγορία. Ελέγξτε τα δεδομένα σας.';
$string['invalidcourseid'] = 'Μη έγκυρο μάθημα. Ελέγξτε τα δεδομένα σας.';
$string['invalidlinkphrases'] = 'κλικ|κάντε κλικ εδώ|εδώ|περισσότερα|περισσότερα εδώ|πληροφορίες|πληροφορίες εδώ|πληροφορίες|πληροφορίες εδώ|διαβάστε περισσότερα|διαβάστε περισσότερα εδώ|περισσότερες πληροφορίες|περισσότερες πληροφορίες εδώ|περισσότερες λεπτομέρειες|περισσότερες λεπτομέρειες εδώ';
$string['language'] = 'Γλώσσα';
$string['language_help'] = 'Γλώσσα του ιστότοπου';
$string['messageprovider:warningcheckid'] = 'Προειδοποίηση για μη έγκυρα αναγνωριστικά ελέγχων';
$string['mobileservice'] = 'Οι υπηρεσίες κινητής τηλεφωνίας ενεργοποιήθηκαν ({$a})';
$string['module'] = 'Άρθρωμα';
$string['modulename'] = 'Όνομα';
$string['moreinfo'] = 'Περισσότερες πληροφορίες';
$string['noerrorsfound'] = 'Δεν βρέθηκαν κοινά σφάλματα προσβασιμότητας για τις παραμέτρους της αναζήτησής σας. Συγχαρητήρια!';
$string['norecords'] = 'Δεν βρέθηκαν σχετικές εγγραφές για τις παραμέτρους της αναζήτησής σας.';
$string['notregistered'] = 'Η εργαλειοθήκη προσβασιμότητας πρέπει να καταχωρηθεί.';
$string['notvalidated'] = 'Η εργαλειοθήκη προσβασιμότητας είναι λειτουργική κατά την διάρκεια της επικύρωσης.';
$string['numcourses'] = 'Αριθμός μαθημάτων ({$a})';
$string['numfactivities'] = 'Αριθμός δραστηριοτήτων ({$a})';
$string['numfiles'] = 'Αριθμός αρχείων ({$a})';
$string['numinstances'] = 'Αριθμός στιγμιοτύπων';
$string['numusers'] = 'Αριθμός χρηστών ({$a})';
$string['pagedesc:checktype'] = '<p>Προκειμένου να συνοψίσουμε και να αναλύσουμε τα αποτελέσματα των διαφόρων ελέγχων που πραγματοποιήθηκαν, ομαδοποιούμε αυτούς τους ελέγχους σε διαφορετικούς τύπους περιεχομένου. Ως εκ τούτου, όλα τα αποτελέσματα ελέγχου προσβασιμότητας που σχετίζονται με εικόνα βρίσκονται στην ομάδα τύπου περιεχομένου «Εικόνα», όλα τα αποτελέσματα ελέγχου προσβασιμότητας που σχετίζονται με τη διάταξη βρίσκονται στην ομάδα τύπου περιεχομένου «Διάταξη» και ούτω καθεξής.</p><p>Οι δραστηριότητες περιλαμβάνονται είτε ως δραστηριότητες, πόροι ή περιοχές περιεχομένου που σχετίζονται με τα ίδια τα μαθήματα.</p><p>Η σελίδα γραφήματος τύπου περιεχομένου εμφανίζει την ανάλυση σφαλμάτων ανά ομάδα τύπων περιεχομένου: Εικόνα, Διάταξη, Σύνδεσμος, Πολυμέσο, Πίνακας και Κείμενο.</p>';
$string['pagedesc:pertarget'] = '<p>Προκειμένου να συνοψίσουμε και να αναλύσουμε τα αποτελέσματα ελέγχων ανά δραστηριότητα, ομαδοποιούμε αυτά τα αποτελέσματα ελέγχου στις διάφορες δραστηριότητες που εντοπίστηκαν.</p><p>Οι δραστηριότητες περιλαμβάνονται είτε ως δραστηριότητες, πόροι ή άλλες περιοχές περιεχομένου που σχετίζονται με τα ίδια τα μαθήματα. Κάθε δραστηριότητα χωρίς ανιχνευμένα σφάλματα θεωρείται ότι πέτυχε και κάθε δραστηριότητα στην οποία ανιχνεύτηκαν ένα ή περισσότερα σφάλματα θεωρείται ότι απέτυχε. Στη συνέχεια εμφανίζεται η αναλογία των επιτυχημένων δραστηριοτήτων προς τις αποτυχημένες.</p><p>Η σελίδα γραφήματος ανάλυσης δραστηριότητας εμφανίζει την αναλογία επιτυχημένων προς αποτυχημένα στιγμιοτύπων συνολικά, ανά δραστηριότητα, π.χ. ανάθεση εργασίας, μάθημα, ετικέτα κ.λπ.</p>';
$string['pagedesctitle:checktype'] = 'Επεξήγηση τύπων περιεχομένου';
$string['pagedesctitle:pertarget'] = 'Επεξήγηση ανάλυσης δραστηριότητας';
$string['passed'] = 'Επιτυχία';
$string['passedcount'] = 'Επιτυχία: {$a}';
$string['passrate'] = 'Ποσοστό επιτυχίας: {$a}%';
$string['pdf:filename'] = 'Brickfield_Summaryreport_CourseID-{$a}';
$string['percheckerrors'] = 'Αριθμός συγκεκριμένων δοκιμών και σφαλμάτων ανά έλεγχο ανά μάθημα.';
$string['perpage'] = 'Στοιχεία προς εμφάνιση ανά σελίδα';
$string['pluginname'] = 'Εργαλειοθήκη προσβασιμότητας';
$string['printable:downloadpdf'] = 'Λήψη PDF';
$string['printable:pluginname'] = 'Συνοπτική αναφορά εργαλείου προσβασιμότητας';
$string['printable:printreport'] = 'Εκτυπώσιμη αναφορά';
$string['printable:toolname'] = 'Συνοπτική αναφορά';
$string['printable:toolshortname'] = 'Συνοπτική αναφορά';
$string['privacy:metadata'] = 'Το πρόσθετο αναφοράς ελέγχου προσβασιμότητας δεν αποθηκεύει προσωπικά δεδομένα.';
$string['processanalysisrequests'] = 'Επεξεργασία αιτημάτων ανάλυσης περιεχομένου';
$string['registernow'] = 'Παρακαλούμε, κάντε καταχώρηση τώρα.';
$string['registration'] = 'Φόρμα καταχώρησης';
$string['registrationinfo'] = '<p>Αυτή η διαδικασία εγγραφής σάς επιτρέπει να χρησιμοποιείτε την starter έκδοση (βασική) της εργαλειοθήκης πρόσβασης Brickfield για τον καταχωρημένο Moodle ιστότοπό σας.</p><p>Αυτή η χρήση υπόκειται στους <a href="{$a}" target="_blank">Όρους και προϋποθέσεις των Εκπαιδευτικών Εργαστηρίων Brickfield (ανοίγουν σε νέο παράθυρο)</a> και στους οποίους συμφωνείτε με τη χρήση αυτού του προϊόντος.</p>';
$string['release'] = 'Διανομή Moodle ({$a})';
$string['remaining'] = '(Απομένουν {$a} σφάλματα)';
$string['response:0'] = 'Αυτή η διεύθυνση URL δεν οδηγεί πουθενά';
$string['response:404'] = 'Η σελίδα με αυτή την διεύθυνση URL δεν βρέθηκε';
$string['schedule:blocknotscheduled'] = '<p>Αυτό το μάθημα δεν έχει προγραμματιστεί ακόμη για ανάλυση, για να βρείτε κοινά προβλήματα προσβασιμότητας.</p>';
$string['schedule:notscheduled'] = '<p>Αυτό το μάθημα δεν έχει προγραμματιστεί ακόμη για ανάλυση για εύρεση κοινών προβλημάτων προσβασιμότητας.</p><p>Κάνοντας κλικ στο πλήκτρο «Υποβολή για ανάλυση», επιβεβαιώνετε ότι θέλετε όλο το σχετικό περιεχόμενο HTML του μαθήματος, όπως περιγραφές ενοτήτων μαθημάτων, περιγραφές δραστηριοτήτων, ερωτήσεις, σελίδες και πολλά άλλα, να προγραμματιστούν για ανάλυση.</p><p>Αυτή η ανάλυση θα πραγματοποιήσει πολλούς κοινούς ελέγχους προσβασιμότητας στο περιεχόμενο HTML του μαθήματος σας και τα αποτελέσματα θα εμφανιστούν στη συνέχεια σε αυτές τις σελίδες αναφοράς εργαλειοθήκης προσβασιμότητας. Η ανάλυση θα υποβληθεί σε επεξεργασία στο παρασκήνιο, με χρονοπρογραμματισμένες εργασίες, οπότε η ταχύτητα ολοκλήρωσής της θα εξαρτάται από τους χρόνους εργασιών και τα χρονοπρογράμματα εκτέλεσης εργασιών.</p>';
$string['schedule:requestanalysis'] = 'Υποβολή για ανάλυση';
$string['schedule:scheduled'] = 'Αυτό το μάθημα έχει προγραμματιστεί για ανάλυση.';
$string['schedule:sitenotscheduled'] = 'Το καθολικό (ανεξάρτητο από μάθημα) περιεχόμενο δεν έχει προγραμματιστεί ακόμη για ανάλυση, για να βρει κοινά ζητήματα προσβασιμότητας.</p><p>Κάνοντας κλικ στο πλήκτρο «Υποβολή για ανάλυση», επιβεβαιώνετε ότι θέλετε όλο το σχετικό καθολικό (ανεξάρτητο από μάθημα) περιεχόμενο να προγραμματιστεί για ανάλυση.</p><p>Αυτή η ανάλυση θα πραγματοποιήσει πολλούς κοινούς ελέγχους προσβασιμότητας σε αυτό το περιεχόμενο και τα αποτελέσματα θα εμφανιστούν στη συνέχεια σε αυτές τις σελίδες αναφοράς εργαλειοθήκης προσβασιμότητας. Η ανάλυση θα υποβληθεί σε επεξεργασία στο παρασκήνιο, με χρονοπρογραμματισμένες εργασίες, οπότε η ταχύτητα ολοκλήρωσής της θα εξαρτάται από τους χρόνους εργασιών και τα χρονοπρογράμματα εκτέλεσης εργασιών.</p>';
$string['schedule:sitescheduled'] = 'Το καθολικό (ανεξάρτητο από το μάθημα) περιεχόμενο έχει χρονοπρογραμματιστεί για ανάλυση.';
$string['secretkey'] = 'Κλειδί API';
$string['secretkey_help'] = 'Αυτός ο κωδικός λαμβάνεται μέσω ηλε.ταχυδρομείου μετά την εγγραφή.';
$string['sendfollowinginfo'] = '<p>Οι ακόλουθες πληροφορίες αποστέλλονται περιοδικά για να συμβάλλουν μόνο στα συνολικά στατιστικά στοιχεία. Δεν θα δημοσιοποιηθούν σε καμία κεντρική λίστα.</p> {$a}';
$string['settings'] = 'Ρυθμίσεις εργαλειοθήκης προσβασιμότητας';
$string['sitehash'] = 'Μυστικό κλειδί';
$string['sitehash_help'] = 'Αυτός ο κωδικός λαμβάνεται μέσω ηλε.ταχυδρομείου μετά την εγγραφή.';
$string['taberrors'] = 'Έλεγχος για σφάλματα';
$string['targetavetitle'] = 'Μέσος όρος σφαλμάτων ανά δραστηριότητα';
$string['targetpercentage'] = 'Ποσοστό στιγμιοτύπων που πέτυχαν/όχι ανά δραστηριότητα';
$string['targetratio'] = 'Αναλογία επιτυχίας δραστηριότητας';
$string['tblcheck'] = 'Έλεγχος';
$string['tblcheckexample'] = 'Παράδειγμα';
$string['tblcheckfailed'] = 'Έλεγχοι που απέτυχαν';
$string['tblchecksummary'] = 'Σύνοψη';
$string['tbledit'] = 'Επεξεργασία';
$string['tblerrorcount'] = 'Σφάλματα';
$string['tblhtmlcode'] = 'Υφιστάμενος κώδικας HTML';
$string['tblinstance'] = 'Στιγμιότυπο';
$string['tblline'] = 'Γραμμή';
$string['tbloverallpercentage'] = 'Συνολικά σφάλματα %';
$string['tblpercentage'] = 'Ποσοστό';
$string['tblpreview'] = 'Προεπισκόπηση';
$string['tbltarget'] = 'Δραστηριότητα';
$string['tblupdateto'] = 'Ενημέρωση σε';
$string['titleactivityresultsall'] = 'Αποτελέσματα ανά δραστηριότητα: όλα τα μαθήματα που αξιολογήθηκαν ({$a->count} μαθήματα)';
$string['titleactivityresultspartial'] = 'Αποτελέσματα ανά δραστηριότητα: μάθημα {$a->name}';
$string['titleall'] = 'Λεπτομέρειες σφάλματος: όλα τα μαθήματα που ελέγχθηκαν ({$a->count} μαθήματα)';
$string['titlechecktyperesultsall'] = 'Αποτελέσματα ανά τύπο περιεχομένου: όλα τα μαθήματα που αξιολογήθηκαν ({$a->count} μαθήματα)';
$string['titlechecktyperesultspartial'] = 'Αποτελέσματα ανά τύπο περιεχομένου: μάθημα {$a->name}';
$string['titleerrorsall'] = 'Λεπτομέρειες σφάλματος: όλα τα μαθήματα που ελέγχθηκαν ({$a->count} μαθήματα)';
$string['titleerrorscount'] = 'Λεπτομέρειες σφάλματος: (εμφανίζονται τα πρώτα {$a} σφάλματα)';
$string['titleerrorspartial'] = 'Λεπτομέρειες σφάλματος: μάθημα {$a->name}';
$string['titlepartial'] = 'Λεπτομέρειες σφάλματος: μάθημα {$a->name}';
$string['titleprintableall'] = 'Μάθημα {$a->name}';
$string['titleprintablepartial'] = 'Μάθημα {$a->name}';
$string['tools'] = 'Αναφορές';
$string['toperrors'] = 'Κορυφαία σφάλματα';
$string['toptargets'] = 'Αποτυχημένες δραστηριότητες';
$string['totalactivities'] = 'Σύνολο δραστηριοτήτων';
$string['totalactivitiescount'] = 'Σύνολο δραστηριοτήτων: {$a}';
$string['totalareas'] = 'Σύνολο περιοχών';
$string['totalerrors'] = 'Συνολικά σφάλματα';
$string['totalgrouperrors'] = 'Σύνολο (άθροισμα) σφαλμάτων ανά τύπο περιεχομένου';
$string['updatesummarydata'] = 'Ενημέρωση περίληψης δεδομένων ιστοτόπου';
$string['usersmobileregistered'] = 'Αριθμός χρηστών με καταχωρημένες κινητές συσκευές ({$a})';
$string['validationerror'] = 'Η επικύρωση του κλειδιού καταχώρησης απέτυχε. Ελέγξτε ότι οι καταχωρημένες διευθύνσεις URL και τα κλειδιά του ιστοτόπου σας είναι σωστά.';
$string['warningcheckidbody'] = 'Υπάρχει πρόβλημα με έναν έλεγχο Brickfield ο οποίος είναι ενεργός αλλά δεν αναφέρεται στη βάση δεδομένων. Παρακαλούμε, ερευνήστε το.';
$string['warningcheckidsubject'] = 'Προειδοποίηση αναγνωριστικού ελέγχου Εργαλειοθήκης Brickfield';
