<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'feedback', language 'no', version '4.4'.
 *
 * @package     feedback
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['add_item'] = 'Legg til spørsmål';
$string['add_pagebreak'] = 'Sett inn sideskift';
$string['adjustment'] = 'Justering';
$string['after_submit'] = 'Etter innsending';
$string['allowfullanonymous'] = 'Tillat full anonymitet';
$string['analysis'] = 'Analyse';
$string['anonymous'] = 'Anonym';
$string['anonymous_edit'] = 'Ta med brukers navn';
$string['anonymous_entries'] = 'Anonyme svar ({$a})';
$string['anonymous_user'] = 'Anonym bruker';
$string['answerquestions'] = 'Svar på spørsmålene';
$string['append_new_items'] = 'Legg til nye elementer';
$string['autonumbering'] = 'Automatisk nummerering av av spørsmål';
$string['autonumbering_help'] = 'Aktiverer eller deaktiverer automatisk nummerering av hvert spørsmål';
$string['average'] = 'Gjennomsnitt';
$string['bold'] = 'Fet';
$string['calendarend'] = '{$a} stenger';
$string['calendarstart'] = '{$a} åpner';
$string['cannotaccess'] = 'Denne feedbacken er kun tilgjengelig fra et kurs';
$string['cannotcreatepagebreak'] = 'Sideskift kan ikke legges inn i starten av en feedback, og kun ett sideskift kan legges til på slutten.';
$string['cannotsavetempl'] = 'Lagring av maler er ike tillatt';
$string['captcha'] = 'CaptCHA';
$string['captchanotset'] = 'CAPTCHA er ikke satt.';
$string['check'] = 'Flersvar';
$string['check_values'] = 'Mulige svar';
$string['checkbox'] = 'Flersvar - flere avkrysninger tillatt';
$string['choosefile'] = 'Velg en fil';
$string['chosen_feedback_response'] = 'Valgt tilbakemelding på undersøkelsen';
$string['closebeforeopen'] = 'Du har satt avslutningdatoen til å være før åpningsdatoen.';
$string['complete_the_form'] = 'Svar på spørsmålene';
$string['completed'] = 'Fullført';
$string['completed_feedbacks'] = 'Innsendte svar';
$string['completedon'] = 'Fullført den {$a}';
$string['completiondetail:submit'] = 'Send Feedback';
$string['completionsubmit'] = 'Send inn Feedback';
$string['configallowfullanonymous'] = 'Hvis satt til "ja", kan brukere fullføre en tilbakemeldingsaktivitet på portalens hjem uten å måtte logge på.';
$string['confirmdeleteentry'] = 'Er du sikker på at du vil slette denne oppføringen?';
$string['confirmdeleteitem'] = 'Er du sikker på at du vil slette dette elementet?';
$string['confirmdeletetemplate'] = 'Er du sikker på at du vil slette denne malen?';
$string['confirmusetemplate'] = 'Er du sikker på at du vil bruke denne malen?';
$string['continue_the_form'] = 'Fortsett med å svare på spørsmålene';
$string['count_of_nums'] = 'Antall siffer';
$string['courseid'] = 'KursID';
$string['creating_templates'] = 'Lagre disse spørsmålene som en ny mal';
$string['delete_entry'] = 'Slett oppføring';
$string['delete_item'] = 'Slett spørsmål';
$string['delete_old_items'] = 'Slett gamle elementer';
$string['delete_pagebreak'] = 'Slett sideskift';
$string['delete_template'] = 'Slett mal';
$string['delete_templates'] = 'Slett maler...';
$string['depending'] = 'Avhengigheter';
$string['depending_help'] = 'Det er mulig å vise elementer avhengig av verdier fra andre elementer.<br />
<strong>Her har du et eksempel:</strong><br />
<ul>
<li>Lag først det elementet som et annet element skal være avhengig av</li>
<li>Legg til et sideskift</li>
<li>Legg så til elementene som skal være avhengig av det forrige som du la til. Velg elementet fra listen over mulige avhengige elementer og legg til en verdi i feltet "Avhengig verdi"</li>
</ul>
<strong>Strukturen skal se ut som dette:</strong>
<ol>
<li>Element Q: Har du bil? A: ja/nei</li>
<li>Sideskift</li>
<li>Element Q: Hvilken farge er det på bilen din?<br />
(dette elementet avhenger av at element 1 har verdien = ja)</li>
<li>Element Q: Hvorfor har du ikke bil?<br />
(dette elementet avhenger av at element 1 har verdien = nei)</li>
<li>.... andre elementer</li>
</ol>';
$string['dependitem'] = 'Avhengig element';
$string['dependvalue'] = 'Avhengig verdi';
$string['description'] = 'Beskrivelse';
$string['do_not_analyse_empty_submits'] = 'Ikke ta med tomme innsendinger i analysen';
$string['downloadresponseas'] = 'Last ned alle responser som:';
$string['drop_feedback'] = 'Fjern fra dette kurset';
$string['dropdown'] = 'Flersvar - bare ett alternativ tillatt (Nedtrekksmeny med alternativer)';
$string['dropdown_values'] = 'Svar';
$string['dropdownlist'] = 'Flersvar - ett svar fra nedtrekksmeny';
$string['dropdownrated'] = 'Nedtrekksmeny (vektet)';
$string['edit_item'] = 'Endre spørsmålet';
$string['edit_items'] = 'Endre spørsmål';
$string['email_notification'] = 'Send e-postvarsel ved innsendinger';
$string['email_notification_help'] = 'Dersom aktivert vil administratorer varsles via e-post ved hver innsending.';
$string['emailteachermail'] = '{$a->username} har fullført spørreskjemaet: \'{$a->feedback}\'
Du kan se responsen her:
{$a->url}';
$string['emailteachermailhtml'] = '<p>{$a->username} har fullført spørreskjemaet: <i>\'{$a->feedback}\'</i></p><p>
Du kan se responsen <a href="{$a->url}">her</a>.</p>';
$string['entries_saved'] = 'Svarene dine er nå lagret. Tusen takk!';
$string['eventresponsedeleted'] = 'Respons slettet';
$string['eventresponsesubmitted'] = 'Respons sent';
$string['export_questions'] = 'Eksporter spørsmål';
$string['export_to_excel'] = 'Eksporter til Excel';
$string['feedback:addinstance'] = 'Legg til en ny Feedback';
$string['feedback:complete'] = 'Fullfør en Feedback';
$string['feedback:createprivatetemplate'] = 'Opprett en privat mal';
$string['feedback:createpublictemplate'] = 'Opprett en felles mal';
$string['feedback:deletesubmissions'] = 'Slett fullførte innsendinger';
$string['feedback:deletetemplate'] = 'Slett mal';
$string['feedback:edititems'] = 'Endre elementer';
$string['feedback:mapcourse'] = 'Koble kurs til globale Feedback-er';
$string['feedback:receivemail'] = 'Motta e-postvarsel';
$string['feedback:view'] = 'Vis Feedback';
$string['feedback:viewanalysepage'] = 'Vis analysesiden etter innsending';
$string['feedback:viewreports'] = 'Vis rapporter';
$string['feedback_is_not_for_anonymous'] = 'Feedback er ikke for anonyme besvarelser';
$string['feedback_is_not_open'] = 'Feedback er ikke åpen';
$string['feedbackclose'] = 'Tillat svar til';
$string['feedbackcompleted'] = '{$a->username} fullførte {$a->feedbackname}';
$string['feedbackopen'] = 'Tillat svar fra';
$string['feedbackupdated'] = 'Tilbakemelding oppdatert.';
$string['file'] = 'Fil';
$string['filter_by_course'] = 'Filtrer pr. kurs';
$string['handling_error'] = 'Det oppstod en feil i Feedback-modulen';
$string['hide_no_select_option'] = 'Skjul "Ikke valgt"-opsjonen';
$string['horizontal'] = 'Horisontal';
$string['import_questions'] = 'Importer spørsmål';
$string['import_successfully'] = 'Importen var vellykket';
$string['importfromthisfile'] = 'Importer fra denne filen';
$string['includeuserinrecipientslist'] = 'Inkluder {$a} i mottakerlisten';
$string['indicator:cognitivedepth'] = 'Kognitiv feedback';
$string['indicator:cognitivedepth_help'] = 'Denne indikatoren er basert på kognitiv dybde vist av studenten i en Feedback-aktivitet.';
$string['indicator:cognitivedepthdef'] = 'Feedback - kognitivt engasjement';
$string['indicator:cognitivedepthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det kognitive engasjementet som tilbys av Feedback-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen visning, visning, innsending)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Sosial feedback';
$string['indicator:socialbreadth_help'] = 'Denne indikatoren er basert på sosial bredde vist av studenten i en Feedback-aktivitet.';
$string['indicator:socialbreadthdef'] = 'Feedback - sosialt engasjement';
$string['indicator:socialbreadthdef_help'] = 'Deltakeren har nådd denne prosentandelen av det sosiale engasjementet som tilbys av Feedback-aktivitetene i løpet av dette analyseintervallet (Nivåer = Ingen deltagelse, deltaker alene, deltaker med andre)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['info'] = 'Informasjon';
$string['infotype'] = 'Informasjonstype';
$string['insufficient_responses'] = 'utilstrekkelige responser';
$string['insufficient_responses_for_this_group'] = 'Det er utilstrekkelig antall responser for denne gruppen';
$string['insufficient_responses_help'] = 'For at feedback skal være reelt anonym må det være minst to svar.';
$string['item_label'] = 'Overskrift';
$string['item_name'] = 'Spørsmål';
$string['label'] = 'Tekstfelt';
$string['labelcontents'] = 'Innhold';
$string['mapcourse'] = 'Koble feedback til kurs';
$string['mapcourse_help'] = 'Som standard vil feedback-skjemaer opprettet på hovedsiden være tilgjengelig for alle kurs på portalen og vil vises i kurs som har aktivert feedback-blokken. Du kan tvinge spørreskjemaet til å vises ved å gjøre blokken obligatorisk. Du kan også begrensehvilke kurs som skal ha tilgang til spørreskjemaet ved å koble det mot bestemte kurs.';
$string['mapcourseinfo'] = 'Dette er en undersøkelse som er tilgjengelig for alle kurs som har slått på Feedback-blokken. Du kan likevel begrense undersøkelsen.';
$string['mapcoursenone'] = 'Ingen kurs er tilkoblet. Feedback er tilgjengelig for alle kurs.';
$string['mapcourses'] = 'Koble Feedback til kurs';
$string['mappedcourses'] = 'Tilkoblede kurs';
$string['mappingchanged'] = 'Kursmapping ble endret';
$string['maximal'] = 'Maksimalt';
$string['messageprovider:message'] = 'Feedback påminnelse';
$string['messageprovider:submission'] = 'Feedback meldinger';
$string['minimal'] = 'Minimum';
$string['mode'] = 'Modus';
$string['modulename'] = 'Feedback';
$string['modulename_help'] = 'Tilbakemeldingsaktiviteten gjør det mulig for en lærer å lage en tilpasset undersøkelse for å samle inn tilbakemeldinger fra deltakere ved å bruke en rekke spørsmålstyper, inkludert flervalg, ja/nei eller tekstinndata.

Tilbakemeldingssvar kan være anonyme om ønskelig, og resultatene kan vises til alle deltakere eller begrenset til kun lærere. Eventuelle tilbakemeldingsaktiviteter på portalens hjem kan også fullføres av ikke-påloggede brukere.

Tilbakemeldingsaktiviteter kan brukes

* For kursevalueringer, bidra til å forbedre innholdet for senere deltakere
* For å gjøre det mulig for deltakere å melde seg på kursmoduler, arrangementer etc.
* For gjesteundersøkelser av kursvalg, skoleretningslinjer mm.
* For antimobbeundersøkelser der elever kan rapportere hendelser anonymt';
$string['modulename_link'] = 'mod/feedback/view';
$string['modulenameplural'] = 'Feedback';
$string['move_item'] = 'Flytt dette spørsmålet';
$string['multichoice'] = 'Flervalg';
$string['multichoice_values'] = 'Flervalg svar';
$string['multichoiceoption'] = '<span class="weight">({$a->weight}) </span>{$a->name}';
$string['multichoicerated'] = 'Flervalg (vektet)';
$string['multichoicetype'] = 'Flervalgstype';
$string['multiplesubmit'] = 'Tillat mer enn en innsending';
$string['multiplesubmit_help'] = 'Dersom satt til Ja

* For anonyme undersøkelser: Deltakere kan levere et ubegrenset antall besvarelse og alle responser blir registrert.
* For ikke-anonyme undersøkelser: Deltakere kan levere et ubegrenset antall besvarelse og kune den siste responsen blir registrert.';
$string['name'] = 'Navn';
$string['name_required'] = 'Navn er obligatorisk';
$string['nameandlabelformat'] = '({$a->label}) {$a->name}';
$string['next_page'] = 'Neste side';
$string['no_handler'] = 'Det er ikke definert noen handling for';
$string['no_itemlabel'] = 'Ingen overskrift';
$string['no_itemname'] = 'Manger elementnavn';
$string['no_items_available_yet'] = 'Det er ikke blitt lagt til spørsmål';
$string['no_templates_available_yet'] = 'Ingen maler tilgjengelig ennå';
$string['non_anonymous'] = 'Brukerens navn vil bli lagret og vist sammen med svaret.';
$string['non_anonymous_entries'] = 'Ingen anonyme svar ({$a})';
$string['non_respondents_students'] = 'Studenter som ikke har svart ({$a})';
$string['not_completed_yet'] = 'Ikke fullført ennå';
$string['not_selected'] = 'Ikke valgt';
$string['not_started'] = 'Ikke startet';
$string['numberoutofrange'] = 'Dette tallet er utenfor det gyldige intervallet';
$string['numeric'] = 'Numerisk svar';
$string['numeric_range_from'] = 'Serie fra';
$string['numeric_range_to'] = 'Serie til';
$string['of'] = 'av';
$string['oldvaluespreserved'] = 'Alle gamle spørsmål med tildelte verdier blir lagret';
$string['oldvalueswillbedeleted'] = 'Gjeldende spørsmål med svar du har fått vil bli slettet';
$string['only_one_captcha_allowed'] = 'Det kan bare være EN captcha i samme Feedback';
$string['openafterclose'] = 'Du har spesifisert en startdato som kommer etter sluttdatoen.';
$string['overview'] = 'Oversikt';
$string['page'] = 'Side';
$string['page-mod-feedback-x'] = 'Alle sider i Feedbackmodulen';
$string['page_after_submit'] = 'Visningsside etter fullført';
$string['pagebreak'] = 'Sideskift';
$string['pluginadministration'] = 'Feedback administrasjon';
$string['pluginname'] = 'Feedback';
$string['position'] = 'Posisjon';
$string['previewquestions'] = 'Forhåndsvis spørsmål';
$string['previous_page'] = 'Forrige side';
$string['privacy:metadata:completed'] = 'En oppføring med besvarelsene til feedbacken.';
$string['privacy:metadata:completed:anonymousresponse'] = 'Om besvarelsen er anonym.';
$string['privacy:metadata:completed:timemodified'] = 'Tidspunktet for siste endring av besvarelsen.';
$string['privacy:metadata:completed:userid'] = 'ID\'en til brukeren som fullførte feedback-aktiviteten.';
$string['privacy:metadata:completedtmp'] = 'En oppføring som viser de pågående besvarelsene.';
$string['privacy:metadata:value'] = 'En oppføring med svaret til et spørsmål.';
$string['privacy:metadata:value:value'] = 'Det valgte svaret.';
$string['privacy:metadata:valuetmp'] = 'En oppføring med spørsmålsvar til et pågående forsøk';
$string['public'] = 'Offentlig';
$string['question'] = 'Spørsmål';
$string['questionandsubmission'] = 'Spørsmåls- og innleveringsinnstillinger';
$string['questions'] = 'Spørsmål';
$string['questionslimited'] = 'Viser bare de {$a} spørsmålene, vis individuelle svar eller last ned tabelldata for å vise alle.';
$string['radio'] = 'Flervalg - ett riktig svar';
$string['radio_values'] = 'Svaralternativer';
$string['ready_feedbacks'] = 'Innsendte Feedback';
$string['required'] = 'Obligatorisk';
$string['resetting_data'] = 'Tilbakestill Feedback-svarene';
$string['resetting_feedbacks'] = 'Tilbakestiller Feedback';
$string['response_nr'] = 'Respons nr:';
$string['responses'] = 'Responser';
$string['responsetime'] = 'Svarstid';
$string['save_as_new_item'] = 'Lagre som nytt spørsmål';
$string['save_as_new_template'] = 'Lagre som ny mal';
$string['save_entries'] = 'Send inn dine svar';
$string['save_item'] = 'Lagre spørsmålet';
$string['saving_failed'] = 'Lagringen mislykkes';
$string['search:activity'] = 'Feedback - aktivitetsinformasjon';
$string['search_course'] = 'Søk i kurset';
$string['searchcourses'] = 'Søk kurs';
$string['searchcourses_help'] = 'Søk etter koden eller kursnavnet som du vil koble til denne Feedback-en.';
$string['selected_dump'] = 'Valgte indekser av  $SESSION variabelen vises under:';
$string['send'] = 'Send';
$string['send_message'] = 'Send melding';
$string['show_all'] = 'Vis alt';
$string['show_analysepage_after_submit'] = 'Vis analysesiden etter innsending';
$string['show_entries'] = 'Vis responser';
$string['show_entry'] = 'Vis respons';
$string['show_nonrespondents'] = 'Vis brukere som ikke har svart';
$string['site_after_submit'] = 'webadresse etter innsending';
$string['sort_by_course'] = 'Sorter etter kurs';
$string['started'] = 'Startet';
$string['startedon'] = 'Startet den {$a}';
$string['subject'] = 'Emne';
$string['switch_item_to_not_required'] = 'Angi som ikke påkrevd';
$string['switch_item_to_required'] = 'Angi som påkrevd';
$string['template'] = 'Mal';
$string['template_deleted'] = 'Mal slettet';
$string['template_saved'] = 'Malen er lagret';
$string['templates'] = 'Maler';
$string['textarea'] = 'Lang tekstsvar';
$string['textarea_height'] = 'Antall linjer';
$string['textarea_width'] = 'Bredde';
$string['textfield'] = 'Korttekst svar';
$string['textfield_maxlength'] = 'Maksimum antall bokstaver som godtas';
$string['textfield_size'] = 'Bredde på tekstfeltet';
$string['there_are_no_settings_for_recaptcha'] = 'Det finnes ingen innstillinger for captcha';
$string['this_feedback_is_already_submitted'] = 'Du har allerede fullført denne aktiviteten.';
$string['typemissing'] = 'Mangler verdien "type"';
$string['update_item'] = 'Lagre endringene på dette spørsmålet';
$string['url_for_continue'] = 'Lenke til neste aktivitet';
$string['url_for_continue_help'] = 'Som standard vil brukeren havne på kurssiden etter innsending av en Feedback. Du kan angi en URL her hvis fortsett-knappen skal lede til et annet sted.';
$string['use_one_line_for_each_value'] = 'Bruk en linje for hvert svaralternativ!';
$string['use_this_template'] = 'Bruk denne malen';
$string['using_templates'] = 'Bruk en mal';
$string['vertical'] = 'Vertikal';
$string['whatfor'] = 'Hva ønsker du å gjøre?';
