<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'moodle', language 'no', version '4.4'.
 *
 * @package     moodle
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abouttobeinstalled'] = 'vil bli installert';
$string['accept'] = 'Aksepter';
$string['action'] = 'Handling';
$string['actionchoice'] = 'Hva ønsker du å gjøre med fila \'{$a}\'?';
$string['actions'] = 'Handlinger';
$string['actionsfor'] = 'Handlinger for {$a}';
$string['actionsmenu'] = 'Handlingsmeny';
$string['active'] = 'Aktiv';
$string['activeusers'] = 'Aktive brukere';
$string['activities'] = 'Aktiviteter';
$string['activities_help'] = 'Aktiviterer som forum, quizer og wikier - aktiverer at interaktivt innhold kan legges til i kurset.';
$string['activity'] = 'Aktivitet';
$string['activityclipboard'] = 'Flytter denne aktiviteten: {$a}';
$string['activityheader'] = 'Aktivitetsmeny';
$string['activityicon'] = '{$a}-ikonet';
$string['activityiscurrentlyhidden'] = 'Beklager, denne aktiviteten er ikke tilgjengelig akkurat nå.';
$string['activitymodule'] = 'Aktivitetsmodul';
$string['activitymodules'] = 'Aktivitetsmoduler';
$string['activitynotready'] = 'Aktiviteten er ikke klar ennå';
$string['activityreport'] = 'Aktivitetsrapport';
$string['activityreports'] = 'Aktivitetsrapporter';
$string['activityselect'] = 'Velg denne aktiviteten til å flyttes et annet sted';
$string['activitysince'] = 'Aktivitet siden {$a}';
$string['activitytypetitle'] = '{$a->activity} - {$a->type}';
$string['activityweighted'] = 'Aktivitet pr bruker';
$string['add'] = 'Legg til';
$string['addactivity'] = 'Legg til en aktivitet ...';
$string['addactivitytosection'] = 'Legg til en aktivitet til seksjonen \'{$a}\'';
$string['addadmin'] = 'Legg til administrator';
$string['addblock'] = 'Legg til en blokk';
$string['addcomment'] = 'Legg til en kommentar ...';
$string['addcondition'] = 'Legg til betingelse';
$string['addcountertousername'] = 'Opprett brukere ved å legge til tall til brukernavnet';
$string['addcreator'] = 'Legg til kursprodusent';
$string['adddots'] = 'Legg til...';
$string['added'] = 'La til {$a}';
$string['addedtogroup'] = 'Lagt til gruppe {$a}';
$string['addedtogroupnot'] = 'Ikke lagt til gruppe {$a}';
$string['addedtogroupnotenrolled'] = 'Ble ikke lagt til gruppe {$a} fordi brukeren ikke er påmeldt kurset';
$string['addfilehere'] = 'Slipp filer her for å legge dem til nederst i denne delen';
$string['addfilesdrop'] = 'Du kan dra og slippe filer for å laste de opp eller klikke for å velge.';
$string['addinganew'] = 'Ny {$a}';
$string['addinganewto'] = 'Legger til {$a->what} til {$a->to}';
$string['addingdatatoexisting'] = 'Legger data til eksisterende';
$string['additionalcustomnav'] = 'Ekstra tilpasset navigering';
$string['additionalnames'] = 'Ekstra navn';
$string['addlinkhere'] = 'Legg til lenke her';
$string['addnew'] = 'Legg til ny {$a}';
$string['addnewcategory'] = 'Legg til ny kategori';
$string['addnewcourse'] = 'Legg til nytt kurs';
$string['addnewuser'] = 'Legg til ny bruker';
$string['addnousersrecip'] = 'Legg til brukere som ikke har aksessert denne {$a} til mottakerlisten';
$string['addpagehere'] = 'Legg til tekst her';
$string['addresource'] = 'Legg til en ressurs ...';
$string['addresourceoractivity'] = 'Legg til en aktivitet eller ressurs';
$string['addresourcetosection'] = 'Legg til en ressurs til seksjon \'{$a}\'';
$string['address'] = 'Adresse';
$string['addsections'] = 'Legg til seksjoner';
$string['addstudent'] = 'Legg til student';
$string['addsubcategory'] = 'Legg til en underkategori';
$string['addteacher'] = 'Legg til lærer';
$string['admin'] = 'Admin';
$string['adminhelpaddnewuser'] = 'For manuelt å opprette en ny brukerkonto';
$string['adminhelpassignadmins'] = 'Administratorer kan gjøre alt og bevege seg overalt på portalen';
$string['adminhelpassigncreators'] = 'Produsenter kan opprette nye kurs';
$string['adminhelpassignsiteroles'] = 'Tildel angitte brukere den definerte site-rollen';
$string['adminhelpassignstudents'] = 'Gå til et kurs og legg til studenter fra Admin-menyen';
$string['adminhelpauthentication'] = 'Du kan bruke interne brukerkonti eller eksterne databaser';
$string['adminhelpbackup'] = 'Sett opp automatiske sikkerhetskopier og når de skal lages';
$string['adminhelpconfiguration'] = 'Angi portalens utseende og oppførsel';
$string['adminhelpconfigvariables'] = 'Innstilling for portalens generelle funksjonalitet';
$string['adminhelpcourses'] = 'Sett opp kurs og kategorier, og meld inn lærere og studenter, editer forestående kurs';
$string['adminhelpeditorsettings'] = 'Innstillinger for HTML-redigering';
$string['adminhelpedituser'] = 'Bla gjennom listen av brukerkonti og rediger hvilke som helst av dem';
$string['adminhelpenvironment'] = 'Sjekk hvor godt tjenermaskinen tilfredstiller installasjonskravene til gjeldende og framtidige versjoner';
$string['adminhelpfailurelogs'] = 'Se gjennom logger for mislykket innlogging';
$string['adminhelplanguage'] = 'For å sjekke og redigere språkpakken som er i bruk';
$string['adminhelplogs'] = 'Bla gjennom aktivitetsloggene på portalen';
$string['adminhelpmanageblocks'] = 'Administrer installerte blokker og deres innstillinger';
$string['adminhelpmanagedatabase'] = 'Direkte tilgang til databasen (Vær forsiktig!)';
$string['adminhelpmanagefilters'] = 'Velg tekstfilter og relaterte innstillinger';
$string['adminhelpmanagemodules'] = 'Kontroller installerte moduler og deres innstillinger';
$string['adminhelpmanageroles'] = 'Opprett og definer roller som kan tildeles brukere';
$string['adminhelpmymoodle'] = 'Konfigurer Mine moodle-blokker for brukerne';
$string['adminhelpreports'] = 'Rapporter på portalnivå';
$string['adminhelpsitefiles'] = 'For å publiser generelle filer eller laste opp eksterne sikkerhetskopier';
$string['adminhelpsitesettings'] = 'Angi utseende på portalens forside';
$string['adminhelpstickyblocks'] = 'Konfigurer Moodle med blokker som vises på alle sider';
$string['adminhelpthemes'] = 'Velg utseende på portalen (farger, skrifttyper etc.)';
$string['adminhelpuploadusers'] = 'Hent inn nye brukerkonti fra en tekstfil';
$string['adminhelpusers'] = 'Angi brukere og godkjenningsmetoder';
$string['adminhelpxmldbeditor'] = 'Grensesnitt for å redigere XMLDB-filer. Bare for utviklere.';
$string['administration'] = 'Administrasjon';
$string['administrationsite'] = 'Administrer portalen';
$string['administrator'] = 'Administrator';
$string['administratordescription'] = 'Administratorer kan vanligvis gjøre alt på denne portalen, og i alle kurs.';
$string['administrators'] = 'Administratorer';
$string['administratorsall'] = 'Alle administratorer';
$string['administratorsandteachers'] = 'Administratorer og lærere';
$string['advanced'] = 'Avansert';
$string['advancedfilter'] = 'Avansert søk';
$string['advancedsettings'] = 'Avanserte innstillinger';
$string['afterresource'] = 'Etter ressurs "{$a}"';
$string['aftersection'] = 'Etter seksjon "{$a}"';
$string['again'] = 'igjen';
$string['agelocationverification'] = 'Bekreftelse av alder og sted';
$string['ajaxuse'] = 'AJAX og Javascript';
$string['all'] = 'Alle';
$string['allactions'] = 'Alle handlinger';
$string['allactivities'] = 'Alle aktiviteter';
$string['allcategories'] = 'Alle kategorier';
$string['allchanges'] = 'Alle forandringer';
$string['alldays'] = 'Alle dager';
$string['allfiles'] = 'Alle filer';
$string['allgroups'] = 'Alle grupper';
$string['alllogs'] = 'Alle logger';
$string['allmods'] = 'Alle {$a}';
$string['allow'] = 'Tillat';
$string['allowinternal'] = 'Tillat også interne metoder';
$string['allownone'] = 'Ikke tillat noen';
$string['allownot'] = 'Ikke tillat';
$string['allowstealthmodules'] = 'Tillat usynlige, men aktive aktiviteter';
$string['allowstealthmodules_help'] = 'Hvis aktivert kan aktiviteter gjøres tilgjengelige, men ikke vises på kurssiden. Slik aktiviteter må i så fall lenkes til på annet vis, f.eks. fra en sideressurs. Slike aktiviteter vil vises i karakterboka og i andre rapporter.';
$string['allparticipants'] = 'Alle deltakere';
$string['allteachers'] = 'Alle lærere';
$string['alphanumerical'] = 'Kan bare inneholde tall, bokstaver, bindestrek (-) og punktum (.)';
$string['alreadyconfirmed'] = 'Registreringen er allerede godkjent';
$string['alternatename'] = 'Alternativt navn';
$string['always'] = 'Alltid';
$string['and'] = '{$a->one} og {$a->two}';
$string['answer'] = 'Svar';
$string['any'] = 'En av';
$string['appearance'] = 'Utseende';
$string['apply'] = 'Utfør';
$string['applyfilters'] = 'Bruk filtre';
$string['approve'] = 'Godkjenn';
$string['areyousure'] = 'Er du sikker?';
$string['areyousuretorestorethis'] = 'Ønsker du å fortsette?';
$string['areyousuretorestorethisinfo'] = 'Senere i denne prosessen vil du ha mulighet til å legge denne sikkerhetskopien til en eksisterende kurs eller å lage et helt nytt kurs.';
$string['asc'] = 'Stigende';
$string['assessment'] = 'Vurdering';
$string['assignadmins'] = 'Legg til administrator';
$string['assigncreators'] = 'Legg til kursprodusenter';
$string['assignedrolecount'] = '{$a->role}: {$a->count}';
$string['assignsiteroles'] = 'Tildel roller for hele portalen';
$string['authenticateduser'] = 'Godkjent bruker';
$string['authenticateduserdescription'] = 'Innloggede brukere';
$string['authentication'] = 'Godkjenning';
$string['authenticationplugins'] = 'Autentiseringsmoduler';
$string['autosubscribe'] = 'Automatisk abonnement på forum';
$string['autosubscribeno'] = 'Nei, jeg ønsker ikke å automatisk abonnere på forumdiskusjoner';
$string['autosubscribeyes'] = 'Ja, når jeg skriver innlegg, kan jeg føres opp som abonnent til den diskusjonen';
$string['availability'] = 'Tilgjengelighet';
$string['availablecourses'] = 'Tilgjengelige kurs';
$string['back'] = 'Tilbake';
$string['backto'] = 'Tilbake til {$a}';
$string['backtocourselisting'] = 'Tilbake til kurslisten';
$string['backtohome'] = 'Tilbake til startsiden';
$string['backtopageyouwereon'] = 'Tilbake til forrige besøkte side';
$string['backup'] = 'Sikkerhetskopiering';
$string['backupactivehelp'] = 'Velg om automatisk sikkerhetskopiering skal kjøre';
$string['backupadhocpending'] = 'Adhoc kurssikkerhetskopiering venter';
$string['backupcancelled'] = 'Sikkerhetskopiering avbrutt';
$string['backupcoursefileshelp'] = 'Dersom dette slåes på, blir kursfiler automatisk tatt med i sikkerhetskopier';
$string['backupdate'] = 'Dato for sikkerhetskopiering';
$string['backupdatenew'] = '{$a->TAG} er nå {$a->weekday}, {$a->mday} {$a->month} {$a->year}<br />';
$string['backupdateold'] = '{$a->TAG} var {$a->weekday}, {$a->mday} {$a->month} {$a->year}';
$string['backupdaterecordtype'] = '<br />{$a->recordtype} - {$a->recordname}<br />';
$string['backupdetails'] = 'Detaljer om sikkerhetskopiering';
$string['backuperrorinvaliddestination'] = 'Sikkerhetskopimappen eksisterer ikke eller så kan den ikke skrives til.';
$string['backupexecuteathelp'] = 'Angi når automatisk sikkerhetskopiering skal kjøre.';
$string['backupfailed'] = 'Noen av kursene dine ble ikke lagret.';
$string['backupfilename'] = 'Sikkerhetskopi';
$string['backupfinished'] = 'Sikkerhetskopiering fullført';
$string['backupfromthissite'] = 'Ble denne sikkerhetskopien tatt på denne portalen?';
$string['backupgradebookhistoryhelp'] = 'Dersom aktivert vil karakterhistorien tas med i automatiske sikkerhetskopier. Merk at karakterhistorie må være aktivert i serverinnstillingene for at dette skal fungere.';
$string['backupincludemoduleshelp'] = 'Velg om du vil inkludere kursmoduler (med eller uten brukerdata) i automatiske sikkerhetskopier';
$string['backupincludemoduleuserdatahelp'] = 'Velg om du ønsker at modulenes brukerdata skal være med i sikkerhetskopiene.';
$string['backupinfo'] = 'Lag en kopi av dette kurset, inkludert alt innhold og aktivitet per dags dato. Du kan bruke sikkerhetskopifilen til å gjenopprette dette kurset eller bruke det på et annet nettsted.';
$string['backuplogdetailed'] = 'Detaljert logg for sikkerhetskopiering';
$string['backuploglaststatus'] = 'Logg for siste sikkerhetkopiering';
$string['backupmissinguserinfoperms'] = 'MERK: Denne sikkerhetskopien inneholder ingen brukerdata. Øvelse og Workshop aktiviteter vil ikke tas med i sikkerhetskopien, siden disse to modulene ikke er kompatible med denne typen sikkerhetskopi.';
$string['backupnext'] = 'Neste sikkerhetskopiering';
$string['backupnonisowarning'] = 'OBS: denne sikkerhetskopien er fra en versjon som ikke er Unicode (før 1.6). Hvis denne sikkerhetskopien inneholder noen tekster som ikke er ISO-8859-1, kan de bli ØDELAGT hvis du forsøker å gjenopprette dem til denne Unicode-versjonen av Moodle. See <a href="http://docs.moodle.org/en/Backup_FAQ">Backup FAQ</a> for mer informasjon om hvordan du kan gjenopprette denne sikkerhetskopien korrekt.';
$string['backupnotyetrun'] = 'Automatisk sikkerhetskopiering er satt på vent';
$string['backuporiginalname'] = 'Navn på sikkerhetskopi';
$string['backuproleassignments'] = 'Backuprolleoppgaaver for disse rollene';
$string['backupsavetohelp'] = 'Fullstendig adresse til katalogen der du vil lagre sikkerhetskopifilene';
$string['backupsitefileshelp'] = 'Hvis denne er slått på vil portalfiler brukt i kurs bli inkludert i automatiserte sikkerhetskopier.';
$string['backuptakealook'] = 'Du bør ta en titt på loggene for sikkerhetskopiering i {$a}';
$string['backupuserfileshelp'] = 'Velg om brukerfiler (f.eks. bilder i profiler) skal være med i automatiske sikkerhetskopier';
$string['backupversion'] = 'Versjon av sikkerhetskopi';
$string['badges'] = 'Utmerkelser';
$string['block'] = 'Blokk';
$string['blockconfiga'] = 'Setter innstillinger for blokken {$a}';
$string['blockconfigbad'] = 'Denne blokken er ikke riktig innstallert og det kan derfor ikke vise et innstillingspanel.';
$string['blocks'] = 'Blokker';
$string['blocks_main'] = 'Blokker hovedinnhold';
$string['blocks_supplementary'] = 'Blokker ekstrainnhold';
$string['blocksaddedit'] = 'Legg til/ Endre blokker';
$string['blockseditoff'] = 'Slå av blokkredigering';
$string['blocksediton'] = 'Slå på blokkredigering';
$string['blocksetup'] = 'Setter opp blokktabeller';
$string['blocksuccess'] = '{$a} tabeller ble satt opp korrekt';
$string['brief'] = 'Kort';
$string['bulkactions'] = 'Massehandlinger';
$string['bulkactionselect'] = '{$} valg for massehandlinger';
$string['bulkcancel'] = 'Lukk masseredigering';
$string['bulkmovecoursessuccess'] = 'Vellykket flytting av {$a->courses} kurs til {$a->category}';
$string['bulkselection'] = '{$a} er valgt';
$string['bycourseorder'] = 'Etter kursrekkefølge';
$string['byname'] = 'etter {$a}';
$string['bypassed'] = 'Utelatt';
$string['cachecontrols'] = 'Cache-kontroller';
$string['calltofeedback'] = 'Skaperne av denne programvaren ønsker tilbakemeldingene dine.';
$string['calltofeedback_give'] = 'Gi tilbakemelding om denne programvaren';
$string['calltofeedback_remind'] = 'Minn meg på det senere';
$string['cancel'] = 'Avbryt';
$string['cancelled'] = 'Avbrutt';
$string['categories'] = 'Kurskategorier';
$string['categoriesandcourses'] = 'Kurskategorier og kurs';
$string['category'] = 'Kategori';
$string['categoryadded'] = 'Kategorien \'{$a}\' ble lagt til';
$string['categorybulkaction'] = 'Massehandlinger for valgte kategorier';
$string['categorycontents'] = 'Underkategorier og kurs';
$string['categorycurrentcontents'] = 'Innhold av {$a}';
$string['categorydeleted'] = 'Kategorien \'{$a}\' ble slettet';
$string['categoryduplicate'] = 'Kategorien \'{$a}\' eksisterer allerede!';
$string['categoryheader'] = 'Kategorimeny';
$string['categoryhidden'] = '(skjult)';
$string['categorymodifiedcancel'] = 'Kategorien ble endret! Avbryt og prøv igjen.';
$string['categoryname'] = 'Kategorinavn';
$string['categorypath'] = 'Kategoristi';
$string['categorysubcategoryof'] = '{$a->category} - underkategori tip {$a->parentcategory}';
$string['categoryupdated'] = 'Kategorien \'{$a}\' ble oppdatert';
$string['changedpassword'] = 'Passordet er endret';
$string['changepassword'] = 'Endre passord';
$string['changesmade'] = 'Endringer utført';
$string['changesmadereallygoaway'] = 'Du har gjort endringer. Er du sikker på at du vil forlate denne siden og miste alle endringene du har gjort?';
$string['changessaved'] = 'Endringer lagret';
$string['check'] = 'Sjekk';
$string['checkactual'] = 'Aktuelle';
$string['checkall'] = 'Sjekk alle';
$string['checkerror'] = 'Feil ved å hente resultatet av sjekk \'{$a}\'. Sjekk nettleserkonsollen for mer informasjon.';
$string['checkexpected'] = 'Forventede';
$string['checkingbackup'] = 'Sjekker sikkerhetskopi';
$string['checkingcourse'] = 'Sjekker kurs';
$string['checkingforbbexport'] = 'Ser etter BlackBoard eksport';
$string['checkinginstances'] = 'Sjekker eksempler';
$string['checkingsections'] = 'Sjekker seksjoner';
$string['checklanguage'] = 'Sjekk språk';
$string['checkloading'] = 'Får resultatet av sjekken \'{$a}\'';
$string['checknone'] = 'Ikke sjekk noen';
$string['checks'] = 'Tester';
$string['checksok'] = 'Alle \'{$a}\' tester OK';
$string['childcoursenotfound'] = 'Fant ikke underkurs!';
$string['childcourses'] = 'Underkurs';
$string['choose'] = 'Velg';
$string['choosecourse'] = 'Velg et kurs';
$string['choosedots'] = 'Velg...';
$string['chooselivelogs'] = 'Eller overvåk gjeldende aktivitet';
$string['chooselogs'] = 'Velg hvilke logger du vil se';
$string['choosereportfilter'] = 'Velg rapportfilter';
$string['choosetheme'] = 'Velg sidetema';
$string['chooseuser'] = 'Velg en bruker';
$string['city'] = 'Sted';
$string['cleaningtempdata'] = 'Sletter midlertidige data';
$string['clear'] = 'Tøm';
$string['clearfilterrow'] = 'Fjern filterrad';
$string['clearfilters'] = 'Tøm filtre';
$string['clearsearch'] = 'Tøm søkefelt';
$string['clickhelpiconformoreinfo'] = '... fortsetter ... Klikk på hjelp-ikonet for å lese hele artikkelen';
$string['clickhere'] = 'Klikk her...';
$string['clicktochangeinbrackets'] = '{$a} (Klikk for å endre)';
$string['clicktohideshow'] = 'Klikk for å utvide/skjule';
$string['closeblockdrawer'] = 'Lukk blokkområdet';
$string['closebuttontitle'] = 'Lukk';
$string['closecourseindex'] = 'Lukk kursindeks';
$string['closedrawer'] = 'Lukk skuffen';
$string['closewindow'] = 'Lukk dette vinduet';
$string['collapse'] = 'Skjul';
$string['collapseall'] = 'Skjul alle';
$string['collapsecategory'] = 'Skjul {$a}';
$string['comebacklater'] = 'Vennligst kom tilbake senere.';
$string['commentincontext'] = 'Finn denne kommentaren i konteksten';
$string['comments'] = 'Kommentarer';
$string['commentscount'] = 'Kommentarer ({$a})';
$string['commentsnotenabled'] = 'Kommentarfunksjonen er ikke aktivert';
$string['commentsrequirelogin'] = 'Du må logge inn for å se kommentarer.';
$string['comparelanguage'] = 'Sammenlign og rediger gjeldende språk';
$string['complete'] = 'Fullført';
$string['completed'] = 'Fullført';
$string['completereport'] = 'Fullstendig rapport';
$string['configuration'] = 'Oppsett';
$string['confirm'] = 'Bekreft';
$string['confirmaccount'] = 'Bekreft konto';
$string['confirmcheckfull'] = 'Er du helt sikker på at du vil bekrefte {$a} ?';
$string['confirmcoursemove'] = 'Er du sikker på at du ønsker å flytte dette kurset ({$a->course}) til denne kategorien ({$a->category})?';
$string['confirmdeletesection'] = 'Er du helt sikker på at du ønsker å slette "{$a}" og alle aktivitetene den inneholder?';
$string['confirmed'] = 'Registreringen din er godkjent.';
$string['confirmednot'] = 'Registreringen er enda ikke bekreftet. Vennligst sjekk innboksen din for en bekreftelsesepost.';
$string['considereddigitalminor'] = 'Du er ikke gammel nok til å lage en bruker på denne portalen.';
$string['content'] = 'Innhold';
$string['contentbank'] = 'Innholdsbank';
$string['contentexport_aboutthiscourse'] = 'Kort kursbeskrivelse';
$string['contentexport_coursesummary'] = 'Denne fila er en en del av innholdet nedlastet fra <a href="{$a->courselink}">{$a->coursename}</a>.';
$string['contentexport_footersummary'] = 'Denne fila er en del av innholdet nedlastet fra <a href="{$a->courselink}">{$a->coursename}</a> av {$a->userfullname} den {$a->date}.';
$string['contentexport_modulesummary'] = 'Denne siden er en del av innholdet lastet ned fra <a href="{$a->modulelink}">{$a->modulename}</a> den {$a->date}. Merk at innhold og filer større enn {$a->maxfilesize} ikke er lastet ned.';
$string['contentexport_viewfilename'] = 'Vis fila {$a}';
$string['context'] = 'Kontekst';
$string['contextlevel'] = 'Kontekstnivå';
$string['contextname'] = 'Kontekstnavn';
$string['contextparent'] = 'Forelder';
$string['contexturl'] = 'Kontekst-URL';
$string['continue'] = 'Fortsett';
$string['continuetocourse'] = 'Klikk her for å gå til kurset ditt';
$string['convertingwikitomarkdown'] = 'Konverterer wikien til Markdown-format';
$string['cookiesenabled'] = 'Informasjonskapsler (Cookies) må være satt på i nettleseren din.';
$string['cookiesenabled_help'] = 'Denne siden benytter to cookies:

Den viktigste cookien er den for sesjoner kalt MoodleSession.
Du må tillate denne i nettleseren for å beholde innloggingsinformasjonen om deg
fra side til side i Moodle. Når du logger ut eller lukker nettleseren slettes
cookien automatisk, både fra nettleseren din og fra serveren.

Den andre informasjonskapselen er bare til for bekvemmelighet. Den kalles
oftest noe som MOODLEID. Det den gjør er å huske brukernavnet ditt i
nettleseren. Dette betyr at neste gang du besøker samme nettside blir dette
feltet ferdigutfylt. Det er trygt å avvise denne cookien, det betyr
i praksis bare at du må taste inn brukernavnet manuelt hver gang du skal logge
inn.';
$string['cookiesenabled_help_html'] = 'To informasjonskapsler brukes på denne siden:<br/><br/>

Den essensielle er øktinformasjonskapselen, vanligvis kalt MoodleSession. Du må tillate denne informasjonskapselen i nettleseren din for å gi kontinuitet og forbli pålogget når du surfer på nettstedet. Når du logger ut eller lukker nettleseren, blir denne informasjonskapselen ødelagt (i nettleseren din og på serveren).<br/><br/>

Den andre informasjonskapselen er kun for enkelhets skyld, vanligvis kalt MOODLEID eller lignende. Den husker bare brukernavnet ditt i nettleseren. Dette betyr at når du kommer tilbake til denne siden, er brukernavnfeltet på innloggingssiden allerede fylt ut for deg. Det er trygt å nekte denne informasjonskapselen - du må bare skrive inn brukernavnet ditt hver gang du logger på.';
$string['cookiesenabledonlysession'] = 'Informasjonskapsler (Cookies) må være satt på i nettleseren din.';
$string['cookiesenabledonlysession_help'] = 'Denne portalen bruke en cookiesesjon,, vanligvis kalt MoodleSession. Du må tillate denne cookien i nettleseren for å få kontiuitet og være logget inn på portalen. Nårdu logger ut eller lukker nettleseren vil cookien ødelegges (både i nettleseren og på serveren).';
$string['cookiesnotenabled'] = 'Informasjonskapsler er dessverre ikke slått på i nettleseren din';
$string['cookiesnotice'] = 'Informasjonskapsler melding';
$string['copy'] = 'kopier';
$string['copyasnoun'] = 'kopi';
$string['copycourse'] = 'Kopier kurs';
$string['copyingcoursefiles'] = 'Kopierer kursfiler';
$string['copyingsitefiles'] = 'Kopierer portalfiler som brukes i kurs';
$string['copyinguserfiles'] = 'Kopierer brukerfiler';
$string['copyingzipfile'] = 'Kopierer zip-fil';
$string['copyrightnotice'] = 'Kopibeskyttelse';
$string['copytoclipboard'] = 'Kopier til utklippstavle';
$string['coresystem'] = 'Globalt nivå';
$string['cost'] = 'Pris';
$string['costdefault'] = 'Standardpris';
$string['counteditems'] = '{$a->count} {$a->items}';
$string['country'] = 'Land';
$string['course'] = 'Kurs';
$string['courseadministration'] = 'Kursadministrasjon';
$string['courseapprovedemail'] = 'Kurset du ba om <a href="{$a->url}">{$a->name}</a>, er godkjent, og du er nå en {$a->teacher}.';
$string['courseapprovedemail2'] = 'Kurset du ba om er godkjent: <a href="{$a->url}">{$a->name}</a>.';
$string['courseapprovedfailed'] = 'Kurset ditt er ikke godkjent!';
$string['courseapprovedsubject'] = 'Kurset ditt har blitt godkjent!';
$string['courseavailable'] = 'Dette kurset er tilgjengelig for studenter';
$string['courseavailablenot'] = 'Dette kurset er ikke tilgjengelig for studenter';
$string['coursebackup'] = 'Sikkerhetskopi av kurs';
$string['coursebulkaction'] = 'Massehandlinger for valgte kurs';
$string['coursecategories'] = 'Kurskategorier';
$string['coursecategory'] = 'Studiekategori';
$string['coursecategory_help'] = '<P>Administratoren har satt opp forskjellige
   kategorier for sidene.

<P>F.eks. &quot;Yrkesutdanninger&quot;, &quot;Oppdragsstudier&quot;, &quot;Grunnkurs&quot;, &quot;VK1&quot;, &quot;VK2&quot; eller
lignende.

<P>Velg den kategorien ditt fag/din side tilhører.
   Dette vil gjøre det enklere for elevene/studentene å
   finne sin klasseside.';
$string['coursecategorydeleted'] = 'Slett kurskategori {$a}';
$string['coursecatmanagement'] = 'Kurs-og kategoriadministrasjon';
$string['coursecompletion'] = 'Kursfullføring';
$string['coursecompletions'] = 'Kursfullføringer';
$string['coursecreators'] = 'Kursprodusenter';
$string['coursecreatorsdescription'] = 'Kursopprettere kan opprette nye kurs.';
$string['coursedeleted'] = 'Slett kurs {$a}';
$string['coursedetails'] = 'Kursdetaljer';
$string['coursedisplay'] = 'Kurslayout';
$string['coursedisplay_help'] = 'Kursseksjoner kan vises på én side eller delt over flere sider.';
$string['coursedisplay_multi'] = 'Vis en seksjon pr. side';
$string['coursedisplay_single'] = 'Vis alle seksjonene på en side';
$string['courseduration'] = 'Kursets varighet';
$string['courseduration_desc'] = 'Kursets varighet blir brukt til å beregne kursets sluttdato. Kursets sluttdato brukes bare i rapporter og for om det skal inkluderes i brukeres kurslister. Brukere kan fortsatt melde seg på kurset selv om sluttdatoen er passert.';
$string['courseenddateenabled'] = 'Aktiver kursets sluttdato som standard';
$string['courseenddateenabled_desc'] = 'Denne innstillingen bestemmer om kursets sluttdato skal aktiveres som standard for nye kurs og med en sluttdato som automatisk beregnes etter startdatoen.';
$string['courseextendednamedisplay'] = '{$a->shortname} {$a->fullname}';
$string['coursefiles'] = 'Arvede kursfiler';
$string['coursefilesedit'] = 'Endre arvede kursfiler';
$string['coursefileswarning'] = 'Lokale kursfiler i hvert kurs er utdatert fra Moodle 2.0. ';
$string['coursefileswarning_help'] = 'Lokale kursfiler i hvert kurs er utdatert fra Moodle 2.0. Vennligst benytt eksterne fillagre så mye som mulig i stedet.';
$string['courseformatdata'] = 'Kursformat data';
$string['courseformatoptions'] = 'Formatinnstillinger for {$a}';
$string['courseformats'] = 'Kursformat';
$string['courseformatudpate'] = 'Oppdater format';
$string['coursegrades'] = 'Kurskarakterer';
$string['courseheader'] = 'Kursmeny';
$string['coursehelpcategory'] = 'Plasser kurset i kursoversikten og gjør det enklere for brukerne å finne det.';
$string['coursehelpforce'] = 'Tving kursets gruppemodus på alle aktiviteter i kurset.';
$string['coursehelpformat'] = 'Kursets hovedside vil vises i dette formatet.';
$string['coursehelphiddensections'] = 'Hvordan skjulte deler av kurset vises for studentene.';
$string['coursehelpmaximumupload'] = 'Angi største filstørrelse som kan lastes opp i dette kurset. Filstørrelsen er begrenset av de globale innstillingene.';
$string['coursehelpnewsitemsnumber'] = 'Antall nyheter som skal vises i nyhetsblokken på kursets hovedside. Dersom den settes til "0" vil ikke nyhetsforumet bli opprettet.';
$string['coursehelpnumberweeks'] = 'Antall seksjoner i kurset (gjelder kun bestemte kursformater)';
$string['coursehelpshowgrades'] = 'Aktiverer visning av karakterboka. Hindrer ikke at karakterer vises i de enkelte aktivitetene.';
$string['coursehidden'] = 'Dette kurset er for tiden ikke tilgjengelig for studenter';
$string['courseinfo'] = 'Kursinformasjon';
$string['courselegacyfiles'] = 'Arvede kursfiler';
$string['courselegacyfiles_help'] = 'Det kursbaserte filområdet er med for å gi bakoverkompatibilitet med tidligere versjoner av Moodle. (1.9 og tidligere)
Alle filer i dette filområdet er alltid tilgjengelig for kursdeltakerne (om de er lenket eller ikke), og det finnes ingen måte å avgjøre om disse filene er i bruk eller ikke.

Dersom du bruker dette filområdet til å lagre kursfiler, kan du få noen sikkerhets- og begrensningsproblemer, likeså må du forvente å miste filer ved sikkerhetskopiering, kursimport og hver gang innhold deles eller blir gjenbrukt. Vi anbefaler derfor at du IKKE benytter dette filområdet - så fremt du virkelig vet hva du holder på med.';
$string['courselegacyfiles_link'] = 'coursefiles2';
$string['courselegacyfilesofcourse'] = 'Arvede kursfiler: {$a}';
$string['coursenotaccessible'] = 'Dette kurset er ikke åpent for allmenheten';
$string['courseoverview'] = 'Kursoversikt';
$string['courseoverviewfiles'] = 'Kursbilde';
$string['courseoverviewfiles_help'] = 'Kursbildet vises i kursoversiktsblokken på startsiden. Portaladministratoren kan tillate opplating av flere filer og filtyper. Ved opplasting av flere filer vil de øvrige bli vist sammen med kursbeskrivelsen i kurskatalogen.';
$string['courseoverviewfilesext'] = 'Filtyper for kursbilder';
$string['courseoverviewfileslimit'] = 'Grense for kursbildefiler';
$string['courseoverviewgraph'] = 'Kursoversikt graf';
$string['courseprofiles'] = 'Kurs';
$string['coursereasonforrejecting'] = 'Hva er årsaken til at du ikke godtar dette';
$string['coursereasonforrejectingemail'] = 'Dette vil bli sendt på mail til den som har foreslått det';
$string['coursereject'] = 'Avslå søknad om ny kurs';
$string['courserejected'] = 'Søknad om ny kurs ble avslått og søkeren har fått beskjed.';
$string['courserejectemail'] = 'Beklager, men søknaden om å opprette et nytt kurs ble ikke innvilget. Begrunnelsen for avslaget er som følger: {$a}';
$string['courserejectreason'] = 'Skisser opp hovedgrunnene til at kurset ble avvist<br />(Dette blir sendt til søkeren)';
$string['courserejectsubject'] = 'Søknaden om å få opprette et kurs bla avsått';
$string['coursereport'] = 'Kursrapporter';
$string['coursereports'] = 'Kursrapporter';
$string['courserequest'] = 'Kurssøknad';
$string['courserequestdetails'] = 'Detaljer for kurset du ønsker opprettet';
$string['courserequestfailed'] = 'Av en eller annen grunn ble ikke kurssøknaden lagret';
$string['courserequestintro'] = 'Bruk dette skjemaet for å søke om å få opprettet et kurs. <br /> Fyll inn så mye informasjon som mulig, <br /> slik at administratorene kan forstå hvorfor du ønsker dette kurset.';
$string['courserequestreason'] = 'Grunner til å ha et slikt kurs';
$string['courserequestroleerror'] = 'Oppretternes rolle i ny kurskonfigurasjon er ugyldig. Se <a href="{$a}">brukerretningslinjene</a>.';
$string['courserequestsuccess'] = 'Kursforespørsel sendt inn.';
$string['courserequestsupport'] = 'Utfyllende informasjon for å hjelpe administratoren å vurdere søknaden.';
$string['courserequestwarning'] = 'Brukeren som ber om dette kurset vil automatisk bli innmeldt og tildelt rollen: {$a}';
$string['courserestore'] = 'Gjenopprett kurs';
$string['coursereuse'] = 'Gjenbruk av kurs';
$string['coursereusenavigationmenu'] = 'Kurs gjenbruk navigasjonsmeny';
$string['courses'] = 'Kurs';
$string['coursesearch'] = 'Søk';
$string['coursesearch_help'] = 'Du kan søke etter flere ord på en gang og kan avgrense søket slik:

* ord - finn hvilken som helst samsvar med dette ordet i teksten
* + ord - bare eksakte samsvarende ord blir funnet
* -ord - ikke inkluder resultater som inneholder dette ordet.';
$string['coursesectionsummaries'] = 'Sammendrag av kursseksjoner';
$string['coursesectiontitle'] = '{$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitlebulkediting'] = 'Masseredigering {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesectiontitleediting'] = 'Rediger {$a->sectionname}: {$a->sectiontitle} | {$a->course}';
$string['coursesettings'] = 'Standard kursinnstillinger';
$string['coursesmovedout'] = 'Kursene ble flyttet fra {$a}';
$string['coursespending'] = 'Kurs som venter på godkjenning';
$string['coursestart'] = 'Kursstart';
$string['coursesummary'] = 'Kurssammendrag';
$string['coursesummary_help'] = 'Kursets sammendrag vises i kursoversikten. Et søk etter kurs omfatter også teksten i disse sammedragene.';
$string['coursetitle'] = 'Kurs: {$a->course}';
$string['coursetitlebulkediting'] = 'Masseredigering av kurs: {$a->course}';
$string['coursetitleediting'] = 'Rediger kurs: {$a->course}';
$string['courseupdates'] = 'Oppdateringer i kurset';
$string['coursevisibility'] = 'Kurs synlighet';
$string['coursevisibility_help'] = '* Vis: Emnet vises i listen over emner og studenter kan få tilgang til det.
* Skjul: Tilgang er begrenset til lærere og andre brukere med mulighet til å se skjulte kurs.';
$string['create'] = 'Lag';
$string['createaccount'] = 'Lag en ny brukerkonto';
$string['createcategory'] = 'Lag kategori';
$string['createfolder'] = 'Lag en mappe i {$a}';
$string['createnew'] = 'Lag ny';
$string['createnewcategory'] = 'Opprett ny kategori';
$string['createnewcourse'] = 'Opprett nytt kurs';
$string['createnewsubcategory'] = 'Opprett ny underkategori';
$string['createsubcategoryof'] = 'Lag en underkategori til {$a}';
$string['createuser'] = 'Opprett bruker';
$string['createziparchive'] = 'Lag ziparkiv';
$string['creatingblocks'] = 'Lager blokker';
$string['creatingblocksroles'] = 'Oppretter blokknivå rolle-rettigheter og overstyringer';
$string['creatingblogsinfo'] = 'Lager blogginfo';
$string['creatingcategoriesandquestions'] = 'Lager kategorier og spørsmål';
$string['creatingcoursemodules'] = 'Lager kursmoduler';
$string['creatingcourseroles'] = 'Oppretter kursnivå rolle-rettigheter og overstyringer';
$string['creatingevents'] = 'Lager hendelser';
$string['creatinggradebook'] = 'Lager karakterbok';
$string['creatinggroupings'] = 'Oppretter tilgangsgrupper';
$string['creatinggroupingsgroups'] = 'Legger til grupper i tilgangsgrupper';
$string['creatinggroups'] = 'Lager grupper';
$string['creatinglogentries'] = 'Lager loggoppføringer';
$string['creatingmessagesinfo'] = 'Lager meldingsinfo';
$string['creatingmodroles'] = 'Oppretter modulnivå rolle-rettigheter og overstyringer';
$string['creatingnewcourse'] = 'Lager nytt kurs';
$string['creatingrolesdefinitions'] = 'Oppretter rolledefinisjoner';
$string['creatingscales'] = 'Lager karakterskalaer';
$string['creatingsections'] = 'Lager seksjoner';
$string['creatingtemporarystructures'] = 'Lager midlertidige strukturer';
$string['creatinguserroles'] = 'Oppretter brukernivå rolle-rettigheter og overstyringer';
$string['creatingusers'] = 'Lager brukere';
$string['creatingxmlfile'] = 'Lager XML-fil';
$string['currency'] = 'Valuta';
$string['currentcourse'] = 'Gjeldende kurs';
$string['currentcourseadding'] = 'Legger data til gjeldende kurs';
$string['currentcoursedeleting'] = 'Sletter gjeldende kurs først';
$string['currentlanguage'] = 'Gjeldende språk';
$string['currentlocaltime'] = 'din lokale tid';
$string['currentpicture'] = 'Bildet du bruker nå';
$string['currentrelease'] = 'Informasjon om denne versjonen av Moodle';
$string['currenttheme'] = 'Gjeldende design';
$string['currentversion'] = 'Gjeldende versjon';
$string['databasechecking'] = 'Oppgraderer Moodles database fra versjon {$a->oldversion} til {$a->newversion}';
$string['databaseperformance'] = 'Databaseytelse';
$string['databasesetup'] = 'Setter opp database';
$string['databasesuccess'] = 'Databasen ble oppgradert';
$string['databaseupgradebackups'] = 'Versjon av sikkerhetskopi er nå {$a}';
$string['databaseupgradeblocks'] = 'Bloksversjon er nå {$a}';
$string['databaseupgradegroups'] = 'Gruppeversjonen er nå {$a}';
$string['databaseupgradelocal'] = 'Lokal versjon for databasetilpasninger er nå {$a}';
$string['databaseupgrades'] = 'Oppgraderer database';
$string['dataformats'] = 'Dataformater';
$string['date'] = 'Dato';
$string['datechanged'] = 'Datoen er endret';
$string['datemostrecentfirst'] = 'Dato - nyeste først';
$string['datemostrecentlast'] = 'Dato - nyeste sist';
$string['day'] = 'dag';
$string['days'] = 'dager';
$string['decodinginternallinks'] = 'Omtolker interne lenker';
$string['default'] = 'Standard';
$string['defaultcategoryname'] = 'Kategori 1';
$string['defaultcompetencescale'] = 'Standard læringsmålskala';
$string['defaultcompetencescaledesc'] = 'En binær vurderingsskala gir kun informasjon om brukeren er godkjent eller ikke.';
$string['defaultcompetencescalenotproficient'] = 'Ikke godkjent ennå';
$string['defaultcompetencescaleproficient'] = 'Godkjent';
$string['defaultcoursestudent'] = 'Student';
$string['defaultcoursestudentdescription'] = 'Studenter har generelt mindre rettigheter i et kurs.';
$string['defaultcoursestudents'] = 'Studenter';
$string['defaultcoursesummary'] = 'Skriv et kort og relevant avsnitt her';
$string['defaultcourseteacher'] = 'Lærer';
$string['defaultcourseteacherdescription'] = 'Lærere kan gjøre hva som helst i et kurs, inkludert endre aktiviteter og vurdere studenter.';
$string['defaultcourseteachers'] = 'Lærere';
$string['defaulteditor'] = 'Standard redigeringsverktøy';
$string['defaulthomepageuser'] = 'Startside';
$string['defaulthomepageuser_help'] = 'Startsiden din er den første lenken i navigasjonsmenyen.';
$string['delete'] = 'Slett';
$string['deleteablock'] = 'Slett en blokk';
$string['deleteall'] = 'Slett alle';
$string['deleteallcannotundo'] = 'Slette alle - kan ikke angres';
$string['deleteallcomments'] = 'Slett alle kommentarer';
$string['deleteallratings'] = 'Slett alle vurderinger';
$string['deletecategory'] = 'Slett kategori: {$a}';
$string['deletecategorycheck'] = 'Er du helt sikker på at du vil slette denne kategorien, <b>\'{$a}\'</b>?<br /> Dette vil flytte alle alle kurs til kategorien over hvis det er noen, eller til kategorien "Diverse".';
$string['deletecategorycheck2'] = 'Hvis du sletter denne kategorien, må du bestemme hva du vil gjøre med underkategorier og kurs den inneholder.';
$string['deletecategoryempty'] = 'Denne kategorien er tom.';
$string['deletecheck'] = 'Slett {$a} ?';
$string['deletecheckfiles'] = 'Er du helt sikker på at du vil slette disse filene?';
$string['deletecheckfull'] = 'Er du sikker på at du vil slette brukeren {$a}, inkludert brukerens påmeldinger, aktivitetsfullføringer og brukerdata ?';
$string['deletechecktype'] = 'Er du sikker på at du vil slette {$a->type}?';
$string['deletechecktypename'] = 'Er du sikker på at du vil slette {$a->type} "{$a->name}"?';
$string['deletecheckwarning'] = 'Du holder på å slette disse filene';
$string['deletecommentbyon'] = 'Slett kommentaren som ble skrevet {$a->time} av {$a->user}';
$string['deletecompletely'] = 'Slett fullstendig';
$string['deletecourse'] = 'Slett et kurs';
$string['deletecoursecheck'] = 'Er du sikker på at du vil slette dette kurset og alt den inneholder?';
$string['deleted'] = 'Slettet';
$string['deletedactivity'] = 'Slettet {$a}';
$string['deletedcourse'] = '{$a} er fullstendig slettet';
$string['deletednot'] = 'Kunne ikke slette {$a}.';
$string['deletepicture'] = 'Slett';
$string['deletesection'] = 'Slett';
$string['deleteselected'] = 'Slett valgte';
$string['deleteselectedkey'] = 'Slett valgte nøkkel';
$string['deletingcourse'] = 'Sletter {$a}';
$string['deletingexistingcoursedata'] = 'Sletter eksisterende kursdata';
$string['deletingolddata'] = 'Sletter gamle data';
$string['department'] = 'Avdeling';
$string['deprecatedeventname'] = '{$a} (ikke lengre i bruk)';
$string['desc'] = 'Synkende';
$string['description'] = 'Beskrivelse';
$string['deselectall'] = 'Opphev valg';
$string['deselectnos'] = 'Avvelg alle \'Nei\'';
$string['detailedless'] = 'Mindre detaljert';
$string['detailedmore'] = 'Mer detaljert';
$string['details'] = 'Detaljer';
$string['digitalminor'] = 'Mindreårig';
$string['digitalminor_desc'] = 'For å opprette en konto på denne portalen må dine foresatte kontakte følgede person:';
$string['directory'] = 'Katalog';
$string['disable'] = 'Slå av';
$string['disabledcomments'] = 'Kommentarer er deaktivert';
$string['dismissnotification'] = 'Avvise dette varselet';
$string['displayingfirst'] = 'Kun de første {$a->count} {$a->things} vises';
$string['displayingrecords'] = 'Viser {$a} poster';
$string['displayingusers'] = 'Viser brukere {$a->start} til {$a->end}';
$string['displayonpage'] = 'Vis på siden';
$string['dndcourse'] = 'Du kan dra og slippe dette kurset for å endre på dets posisjon i listen eller flytte det til en annen kategori.';
$string['dndenabled_inbox'] = 'Du kan dra og slippe filer her for å legge dem til.';
$string['dndnotsupported'] = 'Dra og slipp-opplasting støttes ikke';
$string['dndnotsupported_help'] = 'Nettleseren din støtter ikke Dra og slipp. Dette er en funksjon som støttes i alle nyere versjoner av Chrome, Firefox og Safari samt Internet Explorer v10 og nyere.';
$string['dndnotsupported_insentence'] = 'dra og slipp støttes ikke';
$string['dnduploadwithoutcontent'] = 'Denne opplastingen har ikke noe innhold';
$string['dndworkingfile'] = 'Dra og slipp filer inn i kursets seksjoner for å laste dem opp.';
$string['dndworkingfilelink'] = 'Dra og slipp filer eller lenker inn i kursets seksjoner for å laste dem opp.';
$string['dndworkingfiletext'] = 'Dra og slipp fller eller tekst inn i kursets seksjoner for å laste dem opp.';
$string['dndworkingfiletextlink'] = 'Dra og slipp filer, tekster og lenker inn i kursets seksjoner for å laste dem opp.';
$string['dndworkinglink'] = 'Dra og slipp lenker inn i kursets seksjoner for å legge den til.';
$string['dndworkingtext'] = 'Dra og slipp tekst inn i kursseksjoner for å legge den til.';
$string['dndworkingtextlink'] = 'Dra og slipp tekst eller lenker inn i kursseksjoner for å laste dem opp.';
$string['documentation'] = 'Moodle dokumentasjon';
$string['dontsortcategories'] = 'Ikke sorter kategorier';
$string['dontsortcourses'] = 'Ikke sorter kurs';
$string['down'] = 'Ned';
$string['download'] = 'Last ned';
$string['downloadall'] = 'Last ned alle';
$string['downloadexcel'] = 'Last ned i MS Excel-format';
$string['downloadfile'] = 'Last ned fil';
$string['downloadods'] = 'Last ned i ODS format';
$string['downloadtext'] = 'Last ned i tekstformat';
$string['doyouagree'] = 'Har du lest og forstått disse betingelsene?';
$string['droptoupload'] = 'Her slipper du filen/filene du vil laste opp.';
$string['duplicate'] = 'Dupliser';
$string['duplicatedmodule'] = '{$a} (kopi)';
$string['duplicatedsection'] = '{$a} (kopi)';
$string['edhelpaspellpath'] = 'For å bruke stavekontroll i redigeringsprogammet må du ha <strong>aspell 0.50</strong> eller nyere installert på tjenermaskinen din, og du må angi riktig filbane til programmet. På Unix/Linux-systemer ligger programmet vanligvis på <strong>/usr/bin/aspell</strong>, men det kan også ligge et annet sted.';
$string['edhelpbgcolor'] = 'Bestem bakgrunnsfarge for redigeringsfeltet. <br /> Gyldige verdier er for eksempel <I> #FFFFFF </i>eller <i>white</>.';
$string['edhelpcleanword'] = 'Denne innstillingen slår <i>Word</i>-spesifikk formatering av eller på.';
$string['edhelpenablespelling'] = 'Skru stavekontrollen av eller på. Når den står på, må <strong>aspell</strong> være installert på tjenermaskinen. Du kan også sette denne innstillingen på <strong>default dicionary</strong>. Denne innstillingen brukes når det ikke finnes stavekontroll for brukerens språk.';
$string['edhelpfontfamily'] = 'Egenskapen fontfamilie er en liste med navn på fontfamilier. Familienavn må skilles med komma.';
$string['edhelpfontlist'] = 'Angi fontene som brukes i rullemenyen ved tekst- og HTML-redigering.';
$string['edhelpfontsize'] = 'Standard fontstørrelse bestemmer størrelsen på en font. <br />Gyldige verdier er for eksempel: medium, large, smaller, larger, 10pt, 11px.';
$string['edit'] = 'Rediger';
$string['edita'] = 'Rediger {$a}';
$string['editcategorysettings'] = 'Rediger kategori-innstillinger';
$string['editcategorythis'] = 'Endre kategorinavn og beskrivelse';
$string['editcoursesettings'] = 'Rediger kursinnstillinger';
$string['editfiles'] = 'Rediger filer';
$string['editgroupprofile'] = 'Rediger gruppebeskrivelse';
$string['editinga'] = 'Redigerer {$a}';
$string['editingteachershort'] = 'Editor';
$string['editlock'] = 'Denne verdien kan ikke endres!';
$string['editmode'] = 'Redigeringsmodus';
$string['editmyprofile'] = 'Endre profil';
$string['editorbgcolor'] = 'Bakgrunnsfarge';
$string['editorcleanonpaste'] = 'Rensk opp i Word-HTML ved klipp-og-lim';
$string['editorcommonsettings'] = 'Standardinnstillinger';
$string['editordefaultfont'] = 'Standardfont';
$string['editorenablespelling'] = 'Slå på stavekontroll';
$string['editorfontlist'] = 'Fontliste';
$string['editorfontsize'] = 'Standard fontstørrelse';
$string['editorpreferences'] = 'Editorpreferanser';
$string['editorresettodefaults'] = 'Bruk standardverdiene';
$string['editorsettings'] = 'Redigering';
$string['editorshortcutkeys'] = 'Editor snarveier';
$string['editsection'] = 'Endre innstillinger';
$string['editsectionname'] = 'Rediger seksjonsoverskrift';
$string['editsectionsettings'] = 'Rediger seksjon-innstillinger';
$string['editsectiontitle'] = 'Rediger seksjon {$a}';
$string['editsettings'] = 'Endre innstillinger';
$string['editsummary'] = 'Rediger overskrift';
$string['editthisactivity'] = 'Rediger denne aktiviteten';
$string['editthiscategory'] = 'Endre kategorinavn og beskrivelse';
$string['edittitle'] = 'Endre tittel';
$string['edittitleinstructions'] = 'Klikk på ESC for å avbryte eller ENTER-tasten når du er ferdig.';
$string['edituser'] = 'Rediger brukerkontoer';
$string['edulevel'] = 'Alle hendelser';
$string['edulevel_help'] = '*Undervisning - handlinger utført av en lærer, f.eks. oppdatering av en ressurs.
*Deltaking - handlinger utført av en kursdeltaker, f.eks. skriving av innlegg i et forum
*Andre - handlinger utført av noen med en annen roller enn lærer eller student';
$string['edulevelother'] = 'Annet';
$string['edulevelparticipating'] = 'Deltar';
$string['edulevelteacher'] = 'Lærer';
$string['email'] = 'E-postadresse';
$string['emailactive'] = 'E-post aktivert';
$string['emailagain'] = 'E-post (igjen)';
$string['emailalreadysent'] = 'En epost med nytt passord har alt blitt sendt. Vennligst sjekk epostkontoen din.';
$string['emailcharset'] = 'Tegnsett i e-post';
$string['emailconfirm'] = 'Godkjenn kontoen din';
$string['emailconfirmation'] = 'Hei,

En forespørsel om at det opprettes en brukerkonto på \'{$a->sitename}\' er mottatt fra din epostadresse.

Gå til denne nettadressen for å bekrefte kontoen:

{$a->link}

Enkelte e-postlesere vil av sikkerhetshensyn gjøre lenken ovenfor uklikkbar. Da må du kopiere adressen og lime den inn i adressefeltet i nettlesseren din.

OBS: Bekreft ved å klikke på denne lenken straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli annulert og du må begynne på nytt!

Hvis du trenger hjelp, ta kontakt med portal-administrator, {$a->admin}';
$string['emailconfirmationresend'] = 'Send bekreftelsesepost på nytt';
$string['emailconfirmationsubject'] = '{$a}: kontobekreftelse';
$string['emailconfirmsent'] = '<p>En e-post er nå sendt til adressen <b>{$a}</b></p>
<p>Den inneholder informasjon om hvordan du fullfører registreringen.</p><br />
<strong>OBS!</strong> Bekreft via URL straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli automatisk annullert og du må begynne på nytt.
<p>Hvis du fortsatt har problemer, vennligst ta kontakt med administrator for portalen.</p>';
$string['emailconfirmsentfailure'] = 'Bekreftelsesepost ikke sendt.';
$string['emailconfirmsentsuccess'] = 'Vellykket sending av bekreftelsesepost';
$string['emaildigest'] = 'Type samlepost';
$string['emaildigest_help'] = 'Dette er standardinnstillingen for den daglige oppsummering i forumene.

* Ingen opppsummering - Du vil motta en epost for hvert foruminnlegg;
* Oppsummering - hele innlegg - Du vil motta en epost hver dag som inneholder alle foruminnleggene;
* Oppsummering - kun emnefelt - Du vil motta en epost hver dag som inneholder emnefeltene fra hvert foruminnlegg.

Du kan endre disse innstillingene for hvert forum etter eget ønske.';
$string['emaildigestcomplete'] = 'Komplett (daglig epost-utsendelse med hele innlegg)';
$string['emaildigestoff'] = 'Ingen oppsamling (en e-post per foruminnlegg)';
$string['emaildigestsubjects'] = 'Tema (daglig epost-utsendelse med bare tema)';
$string['emaildisable'] = 'Denne e-postadressen er koblet ut';
$string['emaildisableclick'] = 'Klikk her for å hindre all epost i å bli sendt til denne adressen.';
$string['emaildisplay'] = 'E-postvisning';
$string['emaildisplay_help'] = '* Skjult - Bare brukere med passende tillatelser som lærere kan se e-postadressen din.
* Synlig for alle - Alle brukere på siden kan se e-postadressen din.
* Synlig for kursdeltakere - Kun deltakere på kurs du er påmeldt kan se e-postadressen din.';
$string['emaildisplaycourse'] = 'Synlig for kursdeltakere';
$string['emaildisplaycoursemembersonly'] = '(Synlig for andre kursdeltakere)';
$string['emaildisplayeveryone'] = '(Synlig for alle)';
$string['emaildisplayhide'] = '(Skjult for alle unntatt brukere med passende tillatelser)';
$string['emaildisplayno'] = 'Skjult';
$string['emaildisplayyes'] = 'Synlig for alle';
$string['emailenable'] = 'Denne e-postadressen er i bruk';
$string['emailenableclick'] = 'Klikk her for å aktivere denne adressen igjen.';
$string['emailexists'] = 'Denne e-posten er allerede registrert.';
$string['emailexistshintlink'] = 'Gjenopprett glemt brukernavn eller passord';
$string['emailexistssignuphint'] = 'Kanskje har du opprettet en konto tidligere? {$a}';
$string['emailformat'] = 'E-postformat';
$string['emailmustbereal'] = 'Merk: E-postadressen din må være en virkelig e-postadresse. Har du skrevet den riktig?';
$string['emailnotallowed'] = 'E-postadresser fra disse domenene er ikke tillatt:({$a})';
$string['emailnotfound'] = 'Fant ikke e-postadressen i databasen';
$string['emailonlyallowed'] = 'Denne e-postadressen har en adresse som ikke er tillatt. Tillatte epostdomener er: {$a}.';
$string['emailpasswordchangeinfo'] = 'Hei {$a->firstname},

Noen (antakelig deg) har bedt om nytt passord for din brukerkonto \'{$a->username}\' på \'{$a->sitename}\'.

For å endre passordet ditt ber vi deg går til følgende adresse:

{$a->link}

I de fleste e-post programmer burde lenken over fremkomme som en internett-lenke du kan klikke på. Hvis dette ikke ser ut til å virke kan du kopiere lenken til adressefeltet i nettleseren din.

Trenger du mer hjelp kan du kontakte
{$a->admin}';
$string['emailpasswordchangeinfodisabled'] = 'Hei {$a->firstname},

Noen (antakeligvis deg) har bedt om et nytt passord for kontoen din på \'{$a->sitename}\'.

Dessverre er kontoen din sperret og det kan ikke opprettes noe nytt passord. Vennligst ta kontakt med portaladministratoren,
{$a->admin}';
$string['emailpasswordchangeinfofail'] = 'Hei {$a->firstname},

Noen (antakelig deg) har bedt om nytt passord for din brukerkonto på \'{$a->sitename}\'.

Dessverre er det ikke lov å be om nye passord på denne portalen siden dette styres av andre systemer.

Trenger du mer hjelp kan du kontakte {$a->admin}';
$string['emailpasswordchangeinfosubject'] = 'Informasjon for passordbytte';
$string['emailpasswordconfirmation'] = 'Hei {$a->firstname},

Noen (sannsynligvis du) har bedt om et nytt passord for kontoen din på \'{$a->sitename}\'.
For å bekrefte dette og få et nytt passord sendt til din e-post, må du gå til følgende adresse:

{$a->link}

Enkelte e-postlesere vil av sikkerhetshensyn gjøre lenken ovenfor uklikkbar. Da må du kopiere adressen og lime den inn i adressefeltet i nettlesseren din.

Bekreft via URL straks du har fått e-posten. Går det for lang tid vil bekreftelsesprosessen bli annulert automatisk og du må begynne på nytt.

Hvis du trenger hjelp, kan du ta kontakt med administrator
{$a->admin}';
$string['emailpasswordconfirmationsubject'] = '{$a}: Bekreftelse av passordbytte';
$string['emailpasswordconfirmmaybesent'] = '<p>Hvis du la inn korrekt informasjon vil du straks motta en e-post. </p>
<p>Den inneholder enkle instruksjoner for å bekrefte og fullføre endring av passord.
Hvis du fortsatt har problemer, vær vennlig og ta kontakt med administrator.</p>';
$string['emailpasswordconfirmnoemail'] = '<p>Denne brukerkontoen er ikke registrert med en epostadresse.</p>
   <p>Vennligst kontakt portaladministratoren.</p>';
$string['emailpasswordconfirmnotsent'] = '<p>Brukerinformasjonen du bidro med stemmer ikke med noen eksisterende brukerkontoer.</p>
   <p>Vennligst se over informasjonen du skrev inn, og prøv på nytt.
Dersom problemene fortsetter, vennligst kontakt portaladministratoren.</p>';
$string['emailpasswordconfirmsent'] = 'En e-post skal være sendt til din adresse <b>{$a}</b>.
<br />Den inneholder enkle instruksjoner for åbekrefte og fullføre endringen av passord.
Hvis du fortsatt har problemer, kan du ta kontakt med administrator';
$string['emailpasswordsent'] = '<p>Takk for bekreftelse av passordbytte.</p>
<p>En e-post med brukernavnet og ditt midlertidige passord er sendt til din adresse <br /><b>{$a->email}</b>.<br />
Det nye passordet ble automatisk generert og du vil måtte bytte passordet straks etter innlogging.</p>';
$string['emailresetconfirmation'] = 'Hei {$a->firstname},

En tilbakestilling av passordet ble bedt om for kontoen din \'{$a->username}\' på {$a->sitename}.

For å bekrefte denne forespørselen og angi et nytt passord for kontoen din, gå til følgende nettadresse:
<a href="{$a->link}">{$a->link}</a>


(Denne koblingen er gyldig i {$a->resetminutes} minutter fra det tidspunktet denne tilbakestillingen ble forespurt første gang.)

Hvis denne tilbakestillingen av passordet ikke ble bedt om av deg, er ingen handling nødvendig.

Hvis du trenger hjelp, vennligst kontakt portaladministratoren, {$a->admin}';
$string['emailresetconfirmationsubject'] = '{$a}: Forespørsel om nytt passord';
$string['emailresetconfirmsent'] = 'En epost har blitt sendt til din adresse <b>{$a}</b>
<br/>Den inneholder instruksjoner for hvordan du kan bekrefte og fullføre endringen av passord. Hvis du fortsetter å oppleve vanskeligheter, kontakt portaladministratoren.';
$string['emailstop'] = 'Deaktiver varsler';
$string['emailtoprivatefiles'] = 'Du kan også sende epost-vedlegg rett til ditt private filområde. Legg ganske enkelt til vedleggene i en epost og send den til {$a}';
$string['emailtoprivatefilesdenied'] = 'Administratoren har deaktivert muligheten for å laste opp private filer.';
$string['emailvia'] = '{$a->name} (via {$a->siteshortname})';
$string['emojicategoryactivities'] = 'Aktiviteter';
$string['emojicategoryanimalsnature'] = 'Dyr og natur';
$string['emojicategoryflags'] = 'Flagg';
$string['emojicategoryfooddrink'] = 'Mat og drikke';
$string['emojicategoryobjects'] = 'Objekter';
$string['emojicategorypeoplebody'] = 'Mennesker og figurer';
$string['emojicategoryrecent'] = 'Nylige';
$string['emojicategorysmileysemotion'] = 'Smilefjes og følelser';
$string['emojicategorysymbols'] = 'Symboler';
$string['emojicategorytravelplaces'] = 'Reise og steder';
$string['emptycmids'] = 'Tomme kursmodul ID-er';
$string['emptydragdropregion'] = 'Tomt område';
$string['emptysectionids'] = 'Tomme seksjons ID-er';
$string['enable'] = 'Slå på';
$string['encryptedcode'] = 'Kryptert kode';
$string['enddate'] = 'Kursets sluttdato';
$string['enddate_help'] = 'Sluttdatoen begrenser ikke studenttilgang til kurset. Den avgjør om et emne er oppført som Tidligere i mine emner.';
$string['enddatewithtaskenabled'] = 'Kurs sluttdato';
$string['enddatewithtaskenabled_help'] = 'Datoen kurset blir skjult og deltakere ikke lenger får tilgang til det.';
$string['english'] = 'Engelsk';
$string['enrolmentmethods'] = 'Påmeldingsmetoder';
$string['entercourse'] = 'Klikk her for å gå til kurset';
$string['enteremail'] = 'Skriv inn e-postadressen din';
$string['enteremailaddress'] = 'Skriv inn din e-postadresse for å slette det gamle passordet og få et nytt tilsendt på e-post.';
$string['enterusername'] = 'Skriv inn brukernavnet ditt';
$string['entries'] = 'Oppføringer';
$string['error'] = 'Feil';
$string['errorcreatingactivity'] = 'Kunne ikke opprette en instans av aktiviteten \'{$a}\'';
$string['errorfiletoobig'] = 'Kunne ikke opprette en instans av aktiviteten \'{$a}\'';
$string['errornouploadrepo'] = 'Det er ikke opprettet noe filområde for denne kursportalen.';
$string['errorwhenconfirming'] = 'Kontoen er ikke bekreftet enda pga. en feil. Hvis du klikket på en lenke i en e-post for å komme hit, var den ubrutt? Du må kanskje skrive inn lenken manuelt eller kopiere og lime den inn i nettleserens adresselinje.';
$string['eventcommentcreated'] = 'Kommentar skrevet';
$string['eventcommentdeleted'] = 'Kommentar slettet';
$string['eventcommentsviewed'] = 'Kommentarer vist';
$string['eventconfiglogcreated'] = 'Konfigurasjonslogg opprettet';
$string['eventcontentviewed'] = 'Innhold sett';
$string['eventcoursebackupcreated'] = 'Opprettet sikkerhetskopi av kurset';
$string['eventcoursecategorycreated'] = 'Kategori opprettet';
$string['eventcoursecategorydeleted'] = 'Kategori slettet';
$string['eventcoursecategoryupdated'] = 'Kategori oppdatert';
$string['eventcoursecategoryviewed'] = 'Kategori vist';
$string['eventcoursecontentdeleted'] = 'Kursinnhold slettet';
$string['eventcoursecreated'] = 'Kurs opprettet';
$string['eventcoursedeleted'] = 'Kurs slettet';
$string['eventcourseended'] = 'Kurs avsluttet';
$string['eventcourseinformationviewed'] = 'Kurssammendrag vist';
$string['eventcoursemodulecreated'] = 'Kursmodul opprettet';
$string['eventcoursemoduledeleted'] = 'Kursmodul slettet';
$string['eventcoursemoduleinstancelistviewed'] = 'Liste over kursmoduler er vist';
$string['eventcoursemoduleupdated'] = 'Kursmodul oppdatert';
$string['eventcoursemoduleviewed'] = 'Kursmodul vist';
$string['eventcourseresetended'] = 'Tilbakestillingen av kurset er avsluttet';
$string['eventcourseresetstarted'] = 'Tilbakestillingen av kurset har startet';
$string['eventcourserestored'] = 'Kurs gjenopprettet';
$string['eventcoursesectioncreated'] = 'Kursseksjon opprettet';
$string['eventcoursesectiondeleted'] = 'Kursseksjon slettet';
$string['eventcoursesectionupdated'] = 'Kursseksjon oppdatert';
$string['eventcoursessearched'] = 'Søkt i kurs';
$string['eventcoursestarted'] = 'Kurs startet';
$string['eventcourseupdated'] = 'Kurs oppdatert';
$string['eventcourseuserreportviewed'] = 'Kursbrukerrapport vist';
$string['eventcourseviewed'] = 'Kurs vist';
$string['eventdashboardreset'] = 'Tilbakestill Dashbord';
$string['eventdashboardsreset'] = 'Brukernes Dashbord er tilbakestilt';
$string['eventdashboardviewed'] = 'Dashbord vist';
$string['eventdatabasetextfieldcontentreplaced'] = 'Database global søk og erstatt';
$string['eventemailfailed'] = 'Epost kunne ikke sendes';
$string['eventmycoursesviewed'] = 'Mine kurs sett';
$string['eventname'] = 'Navn på hendelse';
$string['eventrecentactivityviewed'] = 'Siste aktivitet vist';
$string['eventsearchindexed'] = 'Søkedata indeksert';
$string['eventsearchresultsviewed'] = 'Søkeresultater vist';
$string['eventsectionviewed'] = 'Seksjon vist';
$string['eventunknownlogged'] = 'Ukjent hendelse';
$string['eventurlblocked'] = 'URL\'en er blokkert';
$string['eventusercreated'] = 'Bruker opprettet';
$string['eventuserdeleted'] = 'Bruker slettet';
$string['eventuserfeedbackgiven'] = 'Tilbakemeldingskoblingen klikket';
$string['eventuserfeedbackremind'] = 'Minn meg senere tilbakemeldingskoblingen klikket';
$string['eventuserinfocategorycreated'] = 'Profilfeltkategori opprettet';
$string['eventuserinfocategorydeleted'] = 'Profilfeltkategori slettet';
$string['eventuserinfocategoryupdated'] = 'Profilfeltkategori oppdatert';
$string['eventuserinfofieldcreated'] = 'Profilfelt opprettet';
$string['eventuserinfofielddeleted'] = 'Profilfelt slettet';
$string['eventuserinfofieldupdated'] = 'Profilfelt oppdatert';
$string['eventuserlistviewed'] = 'Brukerliste sett';
$string['eventuserloggedout'] = 'Bruker logget ut';
$string['eventuserpasswordpolicyfailed'] = 'Retningslinjer for svake brukerpassord';
$string['eventuserpasswordupdated'] = 'Brukerens passord oppdatert';
$string['eventuserprofileviewed'] = 'Brukerprofil sett';
$string['eventuserupdated'] = 'Bruker oppdatert';
$string['everybody'] = 'Alle';
$string['executeat'] = 'Kjør ved';
$string['existing'] = 'Eksisterende';
$string['existingadmins'] = 'Eksisterende administratorer';
$string['existingcourse'] = 'Eksisterende kurs';
$string['existingcourseadding'] = 'Eksisterende kurs, legger data til den';
$string['existingcoursedeleting'] = 'Eksisterende kurs, sletter det først';
$string['existingcreators'] = 'Eksisterende kursprodusenter';
$string['existingstudents'] = 'Innmeldte studenter';
$string['existingteachers'] = 'Eksisterende lærere';
$string['expand'] = 'Utvid';
$string['expandall'] = 'Utvid alt';
$string['expandcategory'] = 'Utvid {$a}';
$string['explanation'] = 'Forklaring';
$string['explanationdigitalminor'] = 'Denne informasjonen er påkrevd for å bestemme om din aldere er over lavalderen for samtykke. Dette er alderen for når en person kan samtykke til vilkår og betingelser og at dataene deres på lovlig vis blir lagret og behandlet.';
$string['extendperiod'] = 'Utvidet periode';
$string['extendsession'] = 'Utvid sesjon';
$string['failedloginattempts'] = '{$a->attempts} mislykkede innlogginger siden sist';
$string['failedtaskbody'] = '<p>Hei {$a->firstname},</p>
<p>Oppgaven <b>{$a->taskname}</b> har mislyktes flere ganger og må sjekkes.</p>
<p><a href="{$a->link}">Se oppgave</a></p>';
$string['failedtaskcontexturlname'] = 'Statusrapport';
$string['failedtasksubject'] = 'Oppgave mislyktes: {$a}';
$string['favourites'] = 'Favoritter';
$string['feedback'] = 'Tilbakemelding';
$string['file'] = 'Fil';
$string['fileexists'] = 'Det eksisterer allerede en fil med navnet {$a}';
$string['filemissing'] = '{$a} mangler';
$string['filereaderror'] = 'Kan ikke lese filen \'{$a}\'. Vennligst sjekk at det vikrelig er en fil og ikke en mappe.';
$string['files'] = 'Filer';
$string['filesanduploads'] = 'Filer og opplastinger';
$string['filesfolders'] = 'Filer/mapper';
$string['fileuploadwithcontent'] = 'Filopplastinger skal ikke inneholde noen innholdsparametre';
$string['filloutallfields'] = 'Vennligst fyll ut alle feltene i skjemaet';
$string['filter'] = 'Filter';
$string['filteroption'] = '{$a->criteria}: {$a->value}';
$string['filterrowlegend'] = 'Filter {$a}';
$string['filters'] = 'Filtere';
$string['filtersetmatchdescription'] = 'Hvordan flere filtre skal kombineres';
$string['filtertype'] = 'Filtertype';
$string['findmorecourses'] = 'Finn flere kurs ...';
$string['first'] = 'Første';
$string['firstaccess'] = 'Opprettet';
$string['firstname'] = 'Fornavn';
$string['firstnamephonetic'] = 'Fornavn - fonetisk';
$string['firstpage'] = 'Første side';
$string['firstsiteaccess'] = 'Første innlogging';
$string['firsttime'] = 'Er det første gang du er her?';
$string['folder'] = 'Mappe';
$string['folderclosed'] = 'Lukket mappe';
$string['folderopened'] = 'Åpen mappe';
$string['followingoptional'] = 'Følgende er valgfritt å fylle ut';
$string['followingrequired'] = 'Følgende må fylles ut';
$string['for'] = 'For';
$string['force'] = 'Tving';
$string['forcelanguage'] = 'Tving språk';
$string['forceno'] = 'Ikke tving';
$string['forcepasswordchange'] = 'Tving passordbytte';
$string['forcepasswordchange_help'] = 'Dette valget tvinger brukeren til å bytte passord ved neste innlogging.';
$string['forcepasswordchangecheckfull'] = 'Er du sikker på at du vil tvinge passordskifte til {$a} ?';
$string['forcepasswordchangenot'] = 'Ikke mulig å tvinge passordskifte for {$a}';
$string['forcepasswordchangenotice'] = 'Du må endre passordet for å fortsette';
$string['forcepasswordresetfailurenotice'] = 'Ditt nåværende passord tilfredstiller ikke lengre passordkravene. Vennligst kontakt portaladministratoren for hjelp. {$a}';
$string['forcepasswordresetnotice'] = 'Ditt nåværende passord tilfredstiller ikke lengre passordkravene. Du må endre passord for å logge inn. {$a}';
$string['forcetheme'] = 'Tving utseende';
$string['forgotaccount'] = 'Glemt passordet?';
$string['forgotten'] = 'Har du glemt brukernavn eller passord?';
$string['forgottenduplicate'] = 'E-postadressen deles av flere kontoer, vennligst skriv inn brukernavnet i stedet.';
$string['forgotteninvalidurl'] = 'Tilbakestillings-URL for ugyldig passord';
$string['format'] = 'Format';
$string['format_help'] = 'Kursformatet bestemmer utseendet på kurssiden

* Enkeltaktivitetsformat - For å vise en enkelt aktivitet (f.eks. quiz eller SCORM-pakke) på kurssiden
* Sosialt format - Et forum bli vist på kurssiden
* Emneformat - Kurssiden er delt inn i emneseksjoner
* Ukeformat - Kurssiden er delt inn i ukeseksjoner. Den første uka starter med "Kursets startdato"';
$string['formathtml'] = 'HTML-format';
$string['formatmarkdown'] = 'Markdown-format';
$string['formatplain'] = 'Ren tekst';
$string['formattext'] = 'Autoformat';
$string['forumpreferences'] = 'Forumpreferanser';
$string['framesetinfo'] = 'Dette rammesett-dokumentet inneholder:';
$string['from'] = 'Fra';
$string['fromdate'] = 'Fra';
$string['fromsender'] = 'Fra';
$string['frontpagecategorycombo'] = 'Kombiliste';
$string['frontpagecategorynames'] = 'Vis en liste over kategorier';
$string['frontpagecourselist'] = 'Vis en liste over kurs';
$string['frontpagecoursesearch'] = 'Kurs søkeblokk';
$string['frontpagedescription'] = 'Forsidesammendrag';
$string['frontpagedescriptionhelp'] = 'Denne beskrivelsen kan vises på forsiden ved å bruke kurs/portalbeskrivelsesblokken.';
$string['frontpageenrolledcourselist'] = 'Påmeldte kurs';
$string['frontpageformat'] = 'Forsideformat';
$string['frontpageformatloggedin'] = 'Format på forsiden når en er logget inn';
$string['frontpagenews'] = 'Nyheter';
$string['frontpagesettings'] = 'Forside innstillinger';
$string['fulllistofcourses'] = 'Alle kurs';
$string['fullname'] = 'Fullt navn';
$string['fullnamecourse'] = 'Kursnavn';
$string['fullnamecourse_help'] = 'Navnet som vises i Mine kurs og i listen over tilgjengelige kurs på hjemmesiden.';
$string['fullnamedisplay'] = '{$a->firstname} {$a->lastname}';
$string['fullnameuser'] = 'Fullt navn';
$string['fullprofile'] = 'Full profil';
$string['fullsitename'] = 'Portalens navn';
$string['functiondisabled'] = 'Den funksjonen er for tiden ikke tilgjengelig';
$string['general'] = 'Generell';
$string['geolocation'] = 'bredde- og lengdegrad';
$string['gettheselogs'] = 'Hent disse loggene';
$string['go'] = 'Kjør';
$string['gpl'] = 'Copyright (C) 1999 og utover Martin Dougiamas (https://moodle.com)

Dette programmet er gratis programvare; du kan omdistribuere det og/eller endre det under vilkårene i GNU General Public License som publisert av Free Software Foundation; enten versjon 2 av lisensen, eller (etter eget valg) en senere versjon.

Dette programmet distribueres i håp om at det vil være nyttig, men UTEN NOEN GARANTI; selv uten den underforståtte garantien for SALGBARHET eller EGNETHET FOR ET BESTEMT FORMÅL.

Se informasjonssiden for Moodle License for full informasjon: https://moodledev.io/general/license';
$string['gpl3'] = 'Copyright (C) 1999 og utover Martin Dougiamas (https://moodle.com)

Dette programmet er gratis programvare: du kan omdistribuere det og/eller endre det under vilkårene i GNU General Public License som publisert av Free Software Foundation, enten versjon 3 av lisensen, eller (etter eget valg) en hvilken som helst senere versjon.

Dette programmet distribueres i håp om at det vil være nyttig, men UTEN NOEN GARANTI; selv uten den underforståtte garantien for SALGBARHET eller EGNETHET FOR ET BESTEMT FORMÅL.

Se informasjonssiden for Moodle License for full informasjon: https://moodledev.io/general/license';
$string['gpllicense'] = 'GPL lisens';
$string['gradenoun'] = 'Karakter';
$string['grades'] = 'Karakterbok';
$string['gradeverb'] = 'Karakter';
$string['gravatarenabled'] = '<a href="http://www.gravatar.com/">Gravatar</a> er aktivert på denne portalen. Dersom du ikke laster opp et profilbilde vil Moodle forsøke å hente et bilde fra Gravatar.';
$string['group'] = 'Gruppe';
$string['groupadd'] = 'Legg til ny gruppe';
$string['groupaddusers'] = 'Legg den/de valgte til gruppen';
$string['groupfor'] = 'For gruppe';
$string['groupinfo'] = 'Info om valgt gruppe';
$string['groupinfoedit'] = 'Rediger gruppeinstillinger';
$string['groupinfomembers'] = 'Info om valgte medlemmer';
$string['groupinfopeople'] = 'Info om valgte personer';
$string['groupmembers'] = 'Gruppemedlemmer';
$string['groupmemberssee'] = 'Se gruppemedlemmer';
$string['groupmembersselected'] = 'Medlemmer i valgt gruppe';
$string['groupmode'] = 'Gruppemodus';
$string['groupmodeforce'] = 'Tving gruppemodus';
$string['groupmy'] = 'Min gruppe';
$string['groupnonmembers'] = 'Brukere uten gruppe';
$string['groupnotamember'] = 'Beklager, du er ikke medlem av gruppen';
$string['grouprandomassign'] = 'Fordel alle til grupper automatisk';
$string['groupremove'] = 'Fjern valgt gruppe';
$string['groupremovemembers'] = 'Fjern valgte medlemmer';
$string['groups'] = 'Grupper';
$string['groupsnone'] = 'Ingen grupper';
$string['groupsseparate'] = 'Separate grupper';
$string['groupsvisible'] = 'Synlige grupper';
$string['guest'] = 'Gjest';
$string['guestdescription'] = 'Gjester har minimale rettigheter og kan vanligvis ikke skrive inn tekst noe sted.';
$string['guestskey'] = 'Tillat gjester som har påmeldingsnøkkel';
$string['guestsno'] = 'Ikke tillat gjester';
$string['guestsnotallowed'] = 'Beklager, \'{$a}\' er ikke åpen for gjester.';
$string['guestsyes'] = 'Tillat gjester uten påmeldingsnøkkel';
$string['guestuser'] = 'Gjestebruker';
$string['guestuserinfo'] = 'Denne brukeren er en spesialbruker som har lesetilgang til noen kurs.';
$string['help'] = 'Hjelp';
$string['helpprefix2'] = 'Hjelp med {$a}';
$string['helpwiththis'] = 'Hjelp med dette';
$string['hiddenassign'] = 'Skjult vurdering';
$string['hiddenfromstudents'] = 'Skjult for studenter';
$string['hiddenoncoursepage'] = 'Tilgjengelig, men ikke vist på kurssiden.';
$string['hiddensections'] = 'Skjulte seksjoner';
$string['hiddensections_help'] = 'Skjulte deler kan vises for studentene som \'ikke tilgjengelige\' på kurssiden, eller holdes helt skjult.';
$string['hiddensectionscollapsed'] = 'Skjulte seksjoner er vist som ikke tilgjengelige';
$string['hiddensectionsinvisible'] = 'Skjulte seksjoner er helt usynlige';
$string['hiddenwithbrackets'] = '(skjult)';
$string['hide'] = 'Skjul';
$string['hideadvancedsettings'] = 'Skjul avanserte innstillinger';
$string['hidechartdata'] = 'Skjul diagramdata';
$string['hidefromstudents'] = 'Skjul på kurssiden';
$string['hideoncoursepage'] = 'Gjør tilgjengelig, men ikke vis på kurssiden';
$string['hidepopoverwindow'] = 'Skjul popovervinduet';
$string['hidesection'] = 'Skjul sekjson {$a}';
$string['hidesettings'] = 'Skjul innstillinger';
$string['hideshowblocks'] = 'Skjul eller vis blokker';
$string['highlight'] = 'Uthev';
$string['highlighted'] = 'Uthevet';
$string['highlightoff'] = 'Fjern utheving';
$string['hits'] = 'Treff';
$string['hitsoncourse'] = 'Treff på {$a->coursename} av {$a->username}';
$string['hitsoncoursetoday'] = 'Dagens treff på {$a->coursename} av {$a->username}';
$string['home'] = 'Hjem';
$string['homeheader'] = 'Hjemmemeny';
$string['hour'] = 'time';
$string['hours'] = 'timer';
$string['howtomakethemes'] = 'Hvordan lage nye design';
$string['htmleditor'] = 'Bruk HTML-editoren';
$string['htmleditoravailable'] = 'HTML-editoren er tilgjengelig';
$string['htmleditordisabled'] = 'Du har koblet ut HTML-editoren i din profil';
$string['htmleditordisabledadmin'] = 'Administratoren har koblet ut HTML-editoren på denne siden.';
$string['htmleditordisabledbrowser'] = 'HTML-editoren er ikke tilgjengelig fordi den ikke blir støttet av nettleseren din.';
$string['htmlfilesonly'] = 'Bare HTML-filer';
$string['htmlformat'] = 'HTML-format';
$string['icon'] = 'Ikon';
$string['idnumber'] = 'ID-nummer';
$string['idnumbercourse'] = 'Kurs IDnummer';
$string['idnumbercourse_help'] = 'Brukes kun for å koble kurset med eksterne systemer. La stå tomt hvis du ikke har en offisiell kurs-ID.';
$string['idnumbercoursecategory'] = 'Kategori ID-nummer';
$string['idnumbercoursecategory_help'] = 'ID-nummeret til en kurskategori brukes bare når kurskategorien skal matches mot eksterne systemer og blir ikke vist andre steder på kursportalen. Dersom kategorien har et offisielt kodenavn kan det legges inn, i alle andre situasjoner kan du la feltet stå tomt.';
$string['idnumbergroup'] = 'Gruppe ID-nummer';
$string['idnumbergroup_help'] = 'ID-nummeret til en gruppe brukes bare når det skal matches med eksterne systemer og blir ikke vist andre steder på kursportalen. Dersom gruppen har en offisiell gruppekode kan du skrive den inn her, ellers kan du la feltet stå tomt.';
$string['idnumbergrouping'] = 'Tilgangsgruppe ID-nummer';
$string['idnumbergrouping_help'] = 'ID-nummeret til en tilgangsgruppe brukes bare når det skal matches mot eksterne systemer og blir ikke vist andre steder på kursportalen. Dersom en tilgangsgruppe har en offisiell kode kan du skrive den inn her, ellers kan du la feltet stå tomt.';
$string['idnumbermod'] = 'ID-nummer';
$string['idnumbermod_help'] = 'ID-numre er en måte å identifisere aktiviteten dersom du trenger å gjøre beregninger i karakterboka. Dersom en aktivitet ikke er inkludert i noen karakterberegning av denne typen kan du trygt la være å fylle ut dette feltet.

Manglende ID-nummer kan også legges til i karakterboka, men de kan bare endres i aktivitetens innstillinger.';
$string['idnumbertaken'] = 'Dette ID-nummeret er allerede brukt';
$string['imagealt'] = 'Bildebeskrivelse';
$string['import'] = 'Importér';
$string['importdata'] = 'Importér kursdata';
$string['importdataexported'] = 'Data er hentet fra \'kildekurset\'.<br /> Fortsett med å importere til \'målkurset\'.';
$string['importdatafinished'] = 'Importen er ferdig! Gå videre til kurset ditt';
$string['importdatafrom'] = 'Finn et kurs å importere data fra';
$string['importinfo'] = 'Importer elementer fra andre kurs, for eksempel aktiviteter, blokker eller kalenderhendelser. Ingen brukerdata vil bli importert.';
$string['inactive'] = 'Inaktiv';
$string['include'] = 'Ta med';
$string['includeallusers'] = 'Ta med alle brukere';
$string['includecoursefiles'] = 'Ta med kursfiler';
$string['includecourseusers'] = 'Ta med deltakere i kurset';
$string['included'] = 'Tatt med';
$string['includelogentries'] = 'Ta med loggoppføringer';
$string['includemodules'] = 'Ta med moduler';
$string['includemoduleuserdata'] = 'Ta med modulens brukerdata';
$string['includeneededusers'] = 'Ta med nødvendige brukere';
$string['includenoneusers'] = 'Ikke ta med brukere';
$string['includeroleassignments'] = 'Inkluder rolleoppgaver';
$string['includesitefiles'] = 'Inkluder portalfiler brukt i dette kurset';
$string['includesubcategories'] = 'Inkluder underkategorier';
$string['includeuserfiles'] = 'Ta med brukerfiler';
$string['increasesections'] = 'Øk antall seksjoner';
$string['indicator:accessesafterend'] = 'Kurs tilgjengelig etter sluttdato';
$string['indicator:accessesafterend_help'] = 'Denne indikatoren forteller om studenten benyttet kurset etter kursets sluttdato.';
$string['indicator:accessesbeforestart'] = 'Kurs tilgjengelig før startdato';
$string['indicator:accessesbeforestart_help'] = 'Denne indikatoren forteller om studenten benyttet kurset før kursets startdato.';
$string['indicator:activitiesdue'] = 'Forfalte aktiviteter';
$string['indicator:activitiesdue_help'] = 'Denne brukeren har forfalte aktiviteter.';
$string['indicator:anycourseaccess'] = 'Enhver kurstilgang';
$string['indicator:anycourseaccess_help'] = 'Denne indikatoren reflekterer tilgang til alle kurser som brukeren er påmeldt.';
$string['indicator:anywrite'] = 'Enhver skrivehandling';
$string['indicator:anywrite_help'] = 'Denne indikatoren representerer innsendingsaktiviteter utført av studenten.';
$string['indicator:anywriteincourse'] = 'Enhver skrivehandling i kurset';
$string['indicator:anywriteincourse_help'] = 'Denne indikatoren representerer alle bidrag fra studenten i alle kursets aktiviteter.';
$string['indicator:completeduserprofile'] = 'Brukerprofilen er fullført';
$string['indicator:completeduserprofile_help'] = 'Denne indikatoren forteller om studenten har fullført brukerprofilen.';
$string['indicator:completeduserprofiledef'] = 'Brukerprofilen er fullstendig';
$string['indicator:completeduserprofiledef_help'] = 'Brukervilkårene er godtatt og brukeren har fyllt ut følgende felt: Institusjon, Avdeling, Adresse, Sted, Land og URL.';
$string['indicator:completionenabled'] = 'Fullførtsporing aktivert';
$string['indicator:completionenabled_help'] = 'Denne indikatoren forteller om fullførtsporing er aktivert i dette kurset.';
$string['indicator:nostudent'] = 'Studentpåmeldinger';
$string['indicator:nostudent_help'] = 'Denne indikatoren reflekterer tilgjengeligheten til studenter på kurset.';
$string['indicator:noteacher'] = 'Lærerens tilgjengelighet';
$string['indicator:noteacher_help'] = 'Denne indikatoren reflekterer tilgjengeligheten til lærere på kurset.';
$string['indicator:potentialcognitive'] = 'Kursets potensielle kognitive dybde';
$string['indicator:potentialcognitive_help'] = 'Denne indikatoren er basert på den potensielle kognitive dybden som kan oppnås av studenten ved å delta i kursaktivitetene.';
$string['indicator:potentialcognitivedef'] = 'Kurs potensiell kognitiv dybde';
$string['indicator:potentialcognitivedef_help'] = 'I hvilken grad kurset tilbyr "dyp" kognitivt engasjement, f.eks. innsending av arbeid for tilbakemelding, mulighet til å gjennomgå arbeid fra andre, og mulighet til å revidere og sende inn arbeid på nytt.';
$string['indicator:potentialcognitivedef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:potentialsocial'] = 'Kursets potensielle sosiale bredde';
$string['indicator:potentialsocial_help'] = 'Denne indikatoren er basert på den potensielle sosiale bredden som kan oppnås av studenten ved å delta i kursaktivitetene.';
$string['indicator:potentialsocialdef'] = 'Kurs potensiell sosial bredde';
$string['indicator:potentialsocialdef_help'] = 'I hvilken grad kurset tilbyr "bredt" sosialt engasjement, samspill med andre deltakere og med praksisfellesskapet utenfor klassen.';
$string['indicator:potentialsocialdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indicator:readactions'] = 'Antall lesehandlinger';
$string['indicator:readactions_help'] = 'Denne indikatoren representerer antall visninger som er gjort av studenten.';
$string['indicator:userforumstracking'] = 'Bruker har aktivert forumsporing';
$string['indicator:userforumstracking_help'] = 'Denne indikatoren representerer hvorvidt studenten har sporing aktivert i forumene.';
$string['info'] = 'Informasjon';
$string['inprogress'] = 'Pågår';
$string['insertresourceoractivitybefore'] = 'Legg til en aktivitet eller ressurs før «{$a->activityname}»';
$string['institution'] = 'Institusjon';
$string['instudentview'] = 'i studentvisning';
$string['interests'] = 'Interesser';
$string['interestslist'] = 'Liste med interesser';
$string['interestslist_help'] = 'Skriv inn dine interesser, en etter en. De vil bli vist på din profilside som tagger.';
$string['invalidemail'] = 'Feil e-postadresse';
$string['invalidlogin'] = 'Feil under innlogging. Prøv på nytt';
$string['invalidtaskclassname'] = 'Ugyldig oppgaveklasse {$a}';
$string['invalidtaskid'] = 'Ugyldig oppgave-ID';
$string['invalidusername'] = 'Brukernavnet kan bare inneholde tall, små bokstaver, understrek, bindestrek, punktum eller @';
$string['invalidusernameupload'] = 'Ugyldig brukernavn';
$string['ip_address'] = 'IP-adresse';
$string['jump'] = 'Gå til';
$string['jumpto'] = 'Fortsett til...';
$string['keep'] = 'Behold';
$string['labelvalue'] = '{$a->label}: {$a->value}';
$string['langltr'] = 'Skriftretning fra venstre til høyre';
$string['langrtl'] = 'Skriftretning fra høyre til venstre';
$string['language'] = 'Språk';
$string['languagegood'] = 'Språkpakken er oppdatert.';
$string['languageselector'] = 'Språkvelger';
$string['last'] = 'Siste';
$string['lastaccess'] = 'Sist innlogget';
$string['lastcourseaccess'] = 'Siste innlogging i kurset';
$string['lastedited'] = 'Sist redigert';
$string['lastip'] = 'Siste IP-adresse';
$string['lastlogin'] = 'Siste innlogging';
$string['lastmodified'] = 'Sist endret';
$string['lastname'] = 'Etternavn';
$string['lastnamephonetic'] = 'Etternavn - fonetisk';
$string['lastpage'] = 'Siste side';
$string['lastsiteaccess'] = 'Siste innlogging på portalen';
$string['lastyear'] = 'I fjor';
$string['latestlanguagepack'] = 'Se etter siste versjon språkfil på moodle.org';
$string['layouttable'] = 'Layout tabell';
$string['leavetokeep'] = 'La denne stå blank for å beholde gjeldende passord';
$string['legacylogginginuse'] = 'Denne portalen har for øyeblikket den forrige versjonen av logging aktivert. Skriving til denne logg-databasen er ikke lenger støttet. Vennligst bytt til en støttet logg-database som "standard" eller "ekstern".';
$string['legacythemeinuse'] = 'Denne portalen vises nå i kompatibilitetsmodus fordi nettleseren din er for gammel.';
$string['license'] = 'Lisens';
$string['licenses'] = 'Lisenser';
$string['liketologin'] = 'Har du lyst til å logge inn med en komplett brukerkonto?';
$string['list'] = 'Liste';
$string['listfiles'] = 'Liste over filer i {$a}';
$string['listofallpeople'] = 'Vis alle';
$string['listofcourses'] = 'Kursliste';
$string['loading'] = 'Laster';
$string['loadinghelp'] = 'Laster...';
$string['local'] = 'Lokal';
$string['localplugins'] = 'Lokale moduler';
$string['localpluginsmanage'] = 'Administrere lokale moduler';
$string['location'] = 'Sted';
$string['locktimeout'] = 'Handlingen utløp på tid mens den ventet på en lås.';
$string['log_excel_date_format'] = 'yyyy mmmm d h:mm';
$string['loggedinas'] = 'Du er logget inn som {$a}';
$string['loggedinasguest'] = 'Du er nå inne som gjest';
$string['loggedinnot'] = 'Du er ikke logget inn.';
$string['login'] = 'Logg inn';
$string['login_failure_logs'] = 'Logg over mislykkede innlogginger';
$string['loginactivity'] = 'Innloggingsaktivitet';
$string['loginagain'] = 'Logg inn på nytt';
$string['loginalready'] = 'Du er allerede innlogget';
$string['loginas'] = 'Logg inn som';
$string['loginaspasswordexplain'] = '<p>Du må skrive inn det spesielle "logg inn som passord" for å bruke denne tjenesten.<br />Hvis du ikke kjenner til det, spør administrator for nettjeneren.';
$string['loginguest'] = 'Tilgang som gjest';
$string['loginsite'] = 'Logg inn på portalen';
$string['loginsteps'] = 'Hei! For å få full tilgang til denne portalen må du først opprette en brukerkonto.';
$string['loginstepsnone'] = '<p>Hei!</p><p>For å få full tilgang til kurs må du
opprette en konto.</p><p> Du må skrive et brukernavn og passord i dette skjemaet.</p><p>Hvis noen allerede har valgt brukernavnet du oppgir, må du prøve på nytt med et annet.</p>';
$string['loginto'] = 'Logg inn på {$a}';
$string['logoof'] = 'Logo av {$a}';
$string['logout'] = 'Logg ut';
$string['logoutconfirm'] = 'Ønsker du virkelig å logge ut?';
$string['logs'] = 'Logger';
$string['logtoomanycourses'] = '[ <a href="{$a->url}">mer</a> ]';
$string['logtoomanyusers'] = '[ <a href="{$a->url}">mer</a> ]';
$string['lookback'] = 'Se tilbake';
$string['mailadmins'] = 'Meld fra til administratorene';
$string['mailstudents'] = 'Meld fra til studentene';
$string['mailteachers'] = 'Meld fra til lærerne';
$string['maincoursepage'] = 'Kursets hovedside';
$string['makeafolder'] = 'Opprett mappe';
$string['makeavailable'] = 'Gjør tilgjengelig';
$string['makeavailablecmtitle'] = 'Gjør aktivitet tilgjengelig';
$string['makeeditable'] = 'Hvis du gjør \'{$a}\' skrivbar av tjeneren (f.eks. apache) kan du redigere denne fila direkte fra denne siden';
$string['makethismyhome'] = 'Gjør dette til min standard startside';
$string['makeunavailable'] = 'Gjør utilgjengelig';
$string['manageblocks'] = 'Blokker';
$string['managecategories'] = 'Administrere kurskategorier';
$string['managecategorythis'] = 'Administrer denne kategorien';
$string['managecombined'] = 'Administrere kurskategorier og kurs';
$string['managecontentbanktypes'] = 'Administrer innholdstyper';
$string['managecourses'] = 'Administrer kurs';
$string['managedatabase'] = 'Behandle database';
$string['managedataformats'] = 'Administrer dataformater';
$string['manageeditorfiles'] = 'Administrer filer brukt av forfatteren';
$string['managefilters'] = 'Filtre';
$string['managemodules'] = 'Moduler';
$string['manageroles'] = 'Roller og tillatelser';
$string['markallread'] = 'Merk alle som lest';
$string['markedthistopic'] = 'Dette emnet er markert som det mest aktuelle emnet nå';
$string['markthistopic'] = 'Uthev denne emneboksen som mest aktuell';
$string['match'] = 'Filtrer';
$string['matchingsearchandrole'] = 'Finn samsvar mellom \'{$a->search}\' og  {$a->role}';
$string['matchofthefollowing'] = 'av følgende:';
$string['maxareabytesreached'] = 'Denne filen (eller den sammenlagte størrelsen av flere filer) er større enn plassen som er igjen i dette området.';
$string['maxfilesize'] = 'Maks størrelse for nye filer: {$a}';
$string['maxfilesreached'] = 'Du har tillatelse til å legge til maksimum {$a} fil(er) til dette elementet.';
$string['maximumchars'] = 'Maks {$a} tegn';
$string['maximumgrade'] = 'Høyeste karakter';
$string['maximumgradex'] = 'Høyeste karakter: {$a}';
$string['maximumshort'] = 'Maks';
$string['maximumupload'] = 'Maksimum opplastningsstørrelse';
$string['maximumupload_help'] = 'Maksimal filstørrelse tillatt for studentopplastinger til kurset. I tillegg kan du begrense maksimal opplastingsstørrelse for hver aktivitet ytterligere.';
$string['maxnumberweeks'] = 'Maksimum antall seksjoner';
$string['maxnumberweeks_desc'] = 'Dette styrer maksverdien som skal vises i "Antall seksjoner"(gjelder kun bestemte kursformat).';
$string['maxnumcoursesincombo'] = 'Vis <a href="{$a->link}">{$a->numberofcourses} kurs</a>.';
$string['maxsectionslimit'] = 'Kan ikke legge til en ny seksjon siden det vil gjøre at kurset får flere seksjoner enn det som er tillatt for dette kurset ({$a}).';
$string['maxsize'] = 'Maks størrelse: {$a}';
$string['maxsizeandareasize'] = 'Maks størrelse for nye filer: {$a->size}, samlet grense: {$a->areasize}';
$string['maxsizeandattachments'] = 'Maks størrelse for nye filer: {$a->size}, maks antall vedlegg: {$a->attachments}';
$string['maxsizeandattachmentsandareasize'] = 'Maks størrelse for nye filer: {$a->size}, maks antall vedlegg: {$a->attachments}, samlet grense: {$a->areasize}';
$string['memberincourse'] = 'Deltakere i kurs';
$string['menu'] = 'Meny';
$string['message'] = 'Melding';
$string['messagebody'] = 'Meldingskropp';
$string['messagedselectedusers'] = 'Meldingen til de valgte brukerne er sendt og mottakerlisten har blitt tilbakestilt.';
$string['messagedselectedusersfailed'] = 'Noe gikk galt da melding ble sendt til utvalgte brukere. Noen har kanskje mottatt meldingen.';
$string['messageprovider:asyncbackupnotification'] = 'Varslinger for asynkron sikkerhetskopiering/gjenoppretting';
$string['messageprovider:availableupdate'] = 'Tilgjengelige varslinger om oppdateringer';
$string['messageprovider:backup'] = 'Sikkerhetskopimeldinger';
$string['messageprovider:badgecreatornotice'] = 'Meldinger til utstederen av utmerkelsen';
$string['messageprovider:badgerecipientnotice'] = 'Meldinger til mottakere av utmerkelsen';
$string['messageprovider:competencyplancomment'] = 'Kommenterte en opplæringsplan';
$string['messageprovider:competencyusercompcomment'] = 'Kommenterte et læringsmål';
$string['messageprovider:coursecompleted'] = 'Kurs fullført';
$string['messageprovider:coursecontentupdated'] = 'Kursinnholdet endres';
$string['messageprovider:courserequestapproved'] = 'Melding om godkjenning av kursønske';
$string['messageprovider:courserequested'] = 'Melding om kursønske';
$string['messageprovider:courserequestrejected'] = 'Melding om avslag på kursønske';
$string['messageprovider:enrolcoursewelcomemessage'] = 'Velkomstmelding for nye kurspåmeldinger';
$string['messageprovider:errors'] = 'Viktige feilmeldinger på denne portalen';
$string['messageprovider:errors_help'] = 'Dette er viktige feilmeldinger som en administrator bør kjenne til.';
$string['messageprovider:failedtaskmaxdelay'] = 'Task reaches its maximum fail delay';
$string['messageprovider:gradenotifications'] = 'Karaktervarslinger';
$string['messageprovider:infected'] = 'Antivirus feilmeldinger.';
$string['messageprovider:insights'] = 'Innsikt generert av prediksjonsmodeller';
$string['messageprovider:instantmessage'] = 'Personlige meldinger mellom brukere';
$string['messageprovider:instantmessage_help'] = 'Denne seksjonen konfigurerer hva som skal skje med meldinger som sendes rett til deg fra andre brukere på portalen.';
$string['messageprovider:messagecontactrequests'] = 'Meldingskontakt krever varslinger';
$string['messageprovider:newlogin'] = 'Nye påloggingsvarsler';
$string['messageprovider:notices'] = 'Melding om mindre problemer';
$string['messageprovider:notices_help'] = 'Dette er meldinger som en administrator kan være interessert i å se.';
$string['messageprovider:reportbuilderschedule'] = 'Tilpassede tidsplaner for rapportbygger';
$string['messageselect'] = 'Velg denne brukeren som meldingsmottaker';
$string['messageselectadd'] = 'Send en melding';
$string['middlename'] = 'Mellomnavn';
$string['migratinggrades'] = 'Slår sammen karakterer';
$string['min'] = 'min';
$string['mins'] = 'min';
$string['minute'] = 'minutt';
$string['minutes'] = 'minutter';
$string['miscellaneous'] = 'Diverse';
$string['missingcategory'] = 'Du må velge en kategori';
$string['missingdescription'] = 'Mangler beskrivelse';
$string['missingemail'] = 'Mangler e-postadresse';
$string['missingfirstname'] = 'Mangler fornavn';
$string['missingfromdisk'] = 'Mangler fra disk';
$string['missingfullname'] = 'Mangler fullt navn';
$string['missinglastname'] = 'Mangler etternavn';
$string['missingname'] = 'Mangler navn';
$string['missingnewpassword'] = 'Mangler nytt passord';
$string['missingpassword'] = 'Mangler passord';
$string['missingrecaptchachallengefield'] = 'reCAPTCHA-tegnene stemte ikke. Prøv igjen.';
$string['missingreqreason'] = 'Mangler grunn';
$string['missingshortname'] = 'Mangler kort navn';
$string['missingshortsitename'] = 'Mangler kort kursnavn';
$string['missingsitedescription'] = 'Mangler kursbeskrivelse';
$string['missingsitename'] = 'Mangler kursnavn';
$string['missingstrings'] = 'Se etter manglende oversettelser';
$string['missingstudent'] = 'Du må velge noe';
$string['missingsummary'] = 'Mangler sammendrag';
$string['missingteacher'] = 'Du må velge noe';
$string['missingurl'] = 'Manglende URL';
$string['missingusername'] = 'Mangler brukernavn';
$string['moddoesnotsupporttype'] = 'Modulen {$a->modname} støtter ikke opplastinger av typen {$a->type}';
$string['modhide'] = 'Skjul';
$string['modified'] = 'Endret';
$string['modshow'] = 'Vis';
$string['modshowcmtitle'] = 'Vis aktivitet';
$string['moduleintro'] = 'Beskrivelse';
$string['modulesetup'] = 'Setter opp modultabell';
$string['modulesuccess'] = '{$a} tabeller opprettet';
$string['modulesused'] = 'Moduler brukt';
$string['modvisible'] = 'Tilgjengelighet';
$string['modvisible_help'] = '* Vis på kurssiden: Tilgjengelig for studenter (med forbehold om eventuelle tilgangsbegrensninger som kan settes).
* Skjul på kurssiden: Ikke tilgjengelig for studenter.';
$string['modvisiblehiddensection'] = 'Tilgjengelighet';
$string['modvisiblehiddensection_help'] = '* Skjul på kurssiden: Ikke tilgjengelig for studenter.
* Gjør tilgjengelig, men ikke vis på kurssiden: Tilgjengelig for studenter hvis du oppgir en lenke. Aktiviteter vil fortsatt vises i karakterboken og andre rapporter.';
$string['modvisiblewithstealth'] = 'Tilgjengelighet';
$string['modvisiblewithstealth_help'] = '* Vis på kurssiden: Tilgjengelig for studenter (med forbehold om eventuelle tilgangsbegrensninger som kan settes).
* Skjul på kurssiden: Ikke tilgjengelig for studenter.
* Gjør tilgjengelig, men ikke vis på kurssiden: Tilgjengelig for studenter hvis du oppgir en lenke. Aktiviteter vil fortsatt vises i karakterboken og andre rapporter.';
$string['month'] = 'Måned';
$string['months'] = 'Måneder';
$string['moodledocs'] = 'Moodle dokumentasjon';
$string['moodledocslink'] = 'Dokumentasjon for denne siden';
$string['moodlelogo'] = 'Moodlelogo';
$string['moodlenet:cannotconnecttoserver'] = 'Kan ikke koble til MoodleNet server';
$string['moodlenet:columnname'] = 'Navn';
$string['moodlenet:columnsenddate'] = 'Send dato';
$string['moodlenet:columnsendstatus'] = 'Send status';
$string['moodlenet:columntype'] = 'Type';
$string['moodlenet:configoauthservice'] = 'Velg en MoodleNet OAuth 2-tjeneste for å aktivere deling til det MoodleNet-nettstedet. Hvis tjenesten ikke eksisterer ennå, må du <a href="{$a}">opprette</a> den.';
$string['moodlenet:deletedactivity'] = 'Slettet aktivitet';
$string['moodlenet:deletedcourse'] = 'Slettet kurs';
$string['moodlenet:eventresourceexported'] = 'Ressurs eksportert';
$string['moodlenet:gotomoodlenet'] = 'Gå til MoodleNet utkast';
$string['moodlenet:issuerisnotauthorized'] = 'MoodleNet utgiver er ikke autorisert';
$string['moodlenet:issuerisnotenabled'] = 'MoodleNet utgiver er ikke aktivert';
$string['moodlenet:issuerisnotset'] = 'MoodleNet-utsteder er ikke angitt ved portaladministrasjon';
$string['moodlenet:nosharedresources'] = 'Det er ingen delte ressurser å vise for øyeblikket';
$string['moodlenet:outboundsettings'] = 'MoodleNet utgående innstillinger';
$string['moodlenet:packagingandsending'] = 'Pakker ned filen og sender til MoodleNet';
$string['moodlenet:sharefailtext'] = 'Det oppsto en feil under deling av innholdet ditt til MoodleNet.<br>Prøv igjen senere.';
$string['moodlenet:sharefailtextwithsitesupport'] = 'Det oppsto en feil under deling av innholdet ditt til MoodleNet.<br>Prøv igjen senere eller <a href="{$a}">kontakt portalens brukerstøtte</a>.';
$string['moodlenet:sharefailtitle'] = 'Noe gikk galt';
$string['moodlenet:sharefilesizelimitexceeded'] = 'Størrelsen på ressursen som deles ({$a->filesize} bytes) overskrider grensen med {$a->filesizelimit} bytes.';
$string['moodlenet:sharenoticeactivity'] = 'Denne aktiviteten deles med MoodleNet som en ressurs.';
$string['moodlenet:sharenoticecourse'] = 'Dette kurset deles med MoodleNet som en ressurs.';
$string['moodlenet:sharenoticepartial'] = 'De valgte aktivitetene deles med MoodleNet som en ressurs.';
$string['moodlenet:sharenoticepartialactivitynumber'] = '{$a} aktiviteter vil bli inkludert i kurset';
$string['moodlenet:shareprogress'] = 'MoodleNet-delingsfremdrift';
$string['moodlenet:shareprogressinfo'] = 'Listen viser kurs og aktiviteter du har delt med MoodleNet.<br>Klikk på ressursnavnet for å se i MoodleNet.';
$string['moodlenet:sharesuccesstext'] = 'Nesten ferdig! Besøk utkastene dine i MoodleNet for å fullføre deling av innholdet ditt.';
$string['moodlenet:sharesuccesstitle'] = 'Lagret til MoodleNet utkast';
$string['moodlenet:sharetomoodlenet'] = 'Del til MoodleNet';
$string['moodlenet:sharetyperesource'] = 'ressurs';
$string['moodlenet:sharinglargefile'] = 'Store filer kan ta lang tid.';
$string['moodlenet:sharingstatus'] = 'Deling til MoodleNet';
$string['moodlenet:sharingto'] = 'Deler til:';
$string['moodlerelease'] = 'Moodle utgivelse';
$string['moodleservicesandsupport'] = 'Tjenester og støtte';
$string['moodleversion'] = 'Moodle versjon';
$string['more'] = 'mer';
$string['moreactions'] = 'Flere handlinger';
$string['morehelp'] = 'Mer hjelp';
$string['morehelpaboutmodule'] = 'Mer hjelp for aktiviteten {$a}';
$string['moreinfo'] = 'Mer informasjon';
$string['moreinformation'] = 'Mer informasjon...';
$string['moremenu'] = 'Mer';
$string['morenavigationlinks'] = 'Mer...';
$string['moreprofileinfoneeded'] = 'Fortell oss mer om deg selv';
$string['mostrecently'] = 'siste';
$string['move'] = 'Flytt';
$string['movecategoriessuccess'] = 'Flyttingen av {$a->count} kategorier til kategorien \'{$a->to}\' var vellykket.';
$string['movecategoriestotopsuccess'] = 'Flyttingen av {$a->count} kategorier til toppnivået var vellykket.';
$string['movecategorycontentto'] = 'Flytt til';
$string['movecategorysuccess'] = 'Flyttingen av kategorien \'{$a->moved}\' til kategorien \'{$a->to}\' var vellykket';
$string['movecategoryto'] = 'Flytt kategori til:';
$string['movecategorytotopsuccess'] = 'Flyttingen av kategorien \'{$a->moved}\' til toppnivået var vellykket';
$string['movecontent'] = 'Flytt {$a}';
$string['movecontentafter'] = 'Etter "{$a}"';
$string['movecontentstoanothercategory'] = 'Flytt innholdet til en annen kategori';
$string['movecontenttothetop'] = 'Til toppen av listen';
$string['movecoursemodule'] = 'Flytt aktivitet';
$string['movecoursesection'] = 'Flytt seksjon';
$string['movecourseto'] = 'Flytt kurs til:';
$string['movedown'] = 'Flytt ned';
$string['movefilestohere'] = 'Flytt filer hit';
$string['movefull'] = 'Flytt {$a} til denne plasseringen';
$string['movehere'] = 'Flytt hit';
$string['moveleft'] = 'Flytt til venstre';
$string['moveright'] = 'Flytt til høyre';
$string['movesection'] = 'Flytt seksjon {$a}';
$string['moveselectedcategoriesto'] = 'Flytt valgte kategorier til';
$string['moveselectedcoursesto'] = 'Flytt valgte kurs til...';
$string['movetoanotherfolder'] = 'Flytt til ei annen mappe';
$string['moveup'] = 'Flytt opp';
$string['mustchangepassword'] = 'Det nye passordet må være forskjellig fra det forrige';
$string['mustconfirm'] = 'Du må godkjenne brukerkontoen din';
$string['mycourses'] = 'Mine kurs';
$string['myfiles'] = 'Mine private filer';
$string['myfilesmanage'] = 'Administrere mine private filer';
$string['myhome'] = 'Dashbord';
$string['mymoodledashboard'] = 'Min Moodle kontrollpanel';
$string['myprofile'] = 'Min profil';
$string['name'] = 'Navn';
$string['namedfiletoolarge'] = 'Filen \'{$a->filename}\' er for stor og kunne ikke lastes opp';
$string['nameforlink'] = 'Hva ønsker du å kalle denne lenken?';
$string['nameforpage'] = 'Navn';
$string['navigation'] = 'Navigering';
$string['needed'] = 'Nødvendig';
$string['networkdropped'] = 'Vi har oppdaget at internettilkoblingen din er ustabil eller har blitt avbrutt. <br />
Vær oppmerksom på at endringer ikke kan ha blitt lagret ordentlig før tilkoblingen din blir bedre.';
$string['never'] = 'Aldri';
$string['neverdeletelogs'] = 'Slett aldri logger';
$string['new'] = 'Ny';
$string['newaccount'] = 'Ny brukerkonto';
$string['newactivityname'] = 'Nytt navn for aktivitet {$a}';
$string['newcourse'] = 'Nytt kurs';
$string['newloginnotificationbodyfull'] = '<p>Hei, {$a->userfullname},</p>
<p>Din {$a->sitename}-konto ble nettopp logget på fra en ny enhet.</p>
<ul>
<li>Din konto: {$a->username} {$a->useremail}</li>
<li>{$a->logintime}</li>
<li>Enhet: {$a->logindevice}</li>
<li>IP: {$a->loginip}</li>
</ul>
<p>Hvis dette var deg, trenger du ikke gjøre noe.</p>
<p>Hvis du ikke gjenkjenner denne aktiviteten, vennligst <a href="{$a->changepasswordlink}">endre passordet ditt</a>.</p>';
$string['newloginnotificationbodysmall'] = '{$a}-kontoen din ble nettopp logget på fra en ny enhet.';
$string['newloginnotificationtitle'] = 'Ny pålogging til {$a}-kontoen din';
$string['newpassword'] = 'Ditt ønskede passord';
$string['newpassword_help'] = '<p>La feltet stå tomt for å beholde gjeldende passord.</p>';
$string['newpasswordfromlost'] = '<strong>NB:</strong> Ditt <strong>nåværende passord</strong> har blitt sendt til deg i den<strong>andre</strong> av de to meldinger sendt til deg i forbindelse med prosessen for å gjenopprette passordet. Pass på at du har mottatt erstatningspassordet før du fortsetter med dette skjermbildet.';
$string['newpasswordtext'] = 'Hei {$a->firstname},
Ditt passord på \'{$a->sitename}\' er slettet og du har fått et midlertidig passord.
Din innloggingsinformasjon er nå:
   brukernavn: {$a->username}
      passord: {$a->newpassword}

Med vennlig hilsen
{$a->signoff}';
$string['newpicture'] = 'Nytt bilde';
$string['newpicture_help'] = '<P>Du kan laste opp et bilde fra datamaskinen din serveren. Dette bildet blir
brukt flere steder i systemet for å representere deg, blant annet i din profil.
<P>Det anbefales at du laster opp et bilde av deg selv. Bildet bør være et
nærbilde av ansiktet ditt, ettersom det ikke blir vist særlig stort i Moodle.
<P>Merk at bildet bør være kvadratisk, ellers blir det automatisk beskjært.<p>
Dersom du har et bilde av deg f.eks. på en nettside (hjemmeside) kan du først
høyreklikke på bildet, velg &quot;Lagre bilde som...&quot; og deretter lagre det på
harddisken eller diskett. Når du har gjort dette kan du bla bildet fram i Moodle
og laste det opp (kopiere) til serveren. </p>
<p>Bildet må være i JPG- eller PNG-format (dvs. filnavnet slutter vanligvis på .jpg
eller .png). </p>
<p>Du kan lage en helt ny bildefil med en av metodene nedenfor: </p>
<ol>
  <li>Du kan bruke et digitalt kamera. Dette innebærer at bildet lett kan hentes
  fra din datamaskin og i riktig format. dator och i rätt format. </li>
  <li>Du kan bruke en skanner for å skanne et papirbilde. Sørg for å lagre
  bildet i JPG- eller PNG-format. </li>
  <li>Du kan hente det fra Internett. Høyreklikk på bildet og velg &quot;Lagre bilde
  som&quot;. </li>
</ol>
<p>For å laste opp bildet til Moodle klikker du på knappen &quot;Bla gjennom...&quot; på
denne siden og velger bildet fra harddisken din (eller CD-ROM, diskett etc.) </p>
<p>OBS! Pass på at bildet ikke er større enn angitt maks størrelse, ellers blir
det ikke lastet opp.&nbsp; </p>
<p>Klikk deretter på &quot;Lagre endringer i min profil&quot; nederst til høyre - bildet beskjæres til
et kvadrat og skaleres ned til en størrelse på 100x100 piksler. </p>
<p>Når du kommer til din profil vises kanskje ikke det nye bildet. Dersom dette
skjer, må du klikke på &quot;Oppdater&quot; (F5) i nettleseren din. </p>';
$string['newpictureusernotsetup'] = 'Et profilbilde kan bare legges til etter at all påkrevd profilinformasjon er lagret.';
$string['newsectionname'] = 'Nytt navn for seksjon {$a}';
$string['newsitem'] = 'nyhet';
$string['newsitems'] = 'kunngjøringer';
$string['newsitemsnumber'] = 'Antall kunngjøringer som skal vises';
$string['newsitemsnumber_help'] = 'Oppslagstavla har tvunget abonnement satt som standard. Bare lærere og andre brukere med riktig tillatelse kan legge ut innlegg i den.

Hvis du ikke trenger et kunngjøringsforum, sett dette til null.

Denne innstillingen bestemmer også hvor mange nylige kunngjøringer som vises i den siste oppslagstavla.';
$string['newuser'] = 'Ny bruker';
$string['newusernewpasswordsubj'] = 'Ny brukerkonto';
$string['newusernewpasswordtext'] = 'Hei {$a->firstname},

En ny konto er opprettet for deg på \'{$a->sitename}\' og du har fått et midlertidig passord

Din aktuelle innloggingsinformasjon er nå:
brukernavn: {$a->username}
passord: {$a->newpassword}
(Du må forandre passordet når du logger inn første gang.)

For å begynne og bruke \'{$a->sitename}\', logger du inn på {$a->link}.

Om du trenger hjelp kan du kontakte
{$a->signoff}';
$string['newusers'] = 'Nye brukere';
$string['newwindow'] = 'Nytt vindu';
$string['next'] = 'Neste';
$string['nextpage'] = 'Neste side';
$string['nextsection'] = 'Neste seksjon';
$string['no'] = 'Nei';
$string['noblockstoaddhere'] = 'Det finnes ingen blokker å legge til på denne siden.';
$string['nobody'] = 'Ingen';
$string['nochange'] = 'Ingen endring';
$string['nocomments'] = 'Ingen kommentarer';
$string['nocourses'] = 'Ingen kurs';
$string['nocoursesfound'] = 'Ingen kurs med ordene \'{$a}\' ble funnet';
$string['nocoursestarttime'] = 'Kurset har ingen startdato';
$string['nocoursesyet'] = 'Ingen kurs i denne kategorien';
$string['nodstpresets'] = 'Administratoren har ikke skrudd på støtte for sommertid.';
$string['nofilesselected'] = 'Ingen filer valgt for tilbakeføring';
$string['nofilesyet'] = 'Ingen filer er lastet opp til siden ennå';
$string['nofiltersapplied'] = 'Ingen filtere';
$string['nograde'] = 'Ingen karakter';
$string['nohelpforactivityorresource'] = 'Det er for tiden ingen hjelp assosiert med denne ressursen eller aktiviteten';
$string['noimagesyet'] = 'Ingen bilder er lastet opp til siden ennå';
$string['nologsfound'] = 'Ingen logger er funnet';
$string['nomatchingusers'] = 'Ingen brukere samsvarte med \'{$a}\'';
$string['nomorecourses'] = 'Ingen flere sider ble funnet';
$string['nomoreidnumber'] = 'For å unngå kollisjoner brukes ikke id-nummer';
$string['none'] = 'Ingen';
$string['noneditingteacher'] = 'Lærer uten redigeringsrettigheter';
$string['noneditingteacherdescription'] = 'Gjestelærere kan undervise i et kurs og evaluere studenter, men ikke endre aktiviteter';
$string['nonstandard'] = 'Ikke-standard';
$string['nopendingcourses'] = 'Det er ingen kurs som venter på godkjenning';
$string['nopotentialadmins'] = 'Ingen potensielle adminer';
$string['nopotentialcreators'] = 'Ingen potensielle kursprodusenter';
$string['nopotentialstudents'] = 'Ingen potensielle studenter';
$string['nopotentialteachers'] = 'Ingen potensielle lærere';
$string['norecentactivity'] = 'Ingen nylig aktivitet';
$string['noreplybouncemessage'] = 'Du har svart på en e-post som ikke kan besvares. Hvis du prøvde å svare på et foruminnlegg, ber vi deg om å heller bruke forumene på {$a} .

Under vises e-posten du sendte:';
$string['noreplybouncesubject'] = '{$a} - returnert e-post';
$string['noreplyname'] = 'Ikke svar på denne e-posten';
$string['noresetrecord'] = 'Det er ingen oppføringer om denne forespørselen om nytt passord. Vennligst start en ny prosess for å få nytt passord.';
$string['noresults'] = 'Ingen resultater';
$string['noresultsfor'] = 'Ingen resultater for «{$a}»';
$string['normal'] = 'Normal';
$string['normalfilter'] = 'Normalt søk';
$string['nosite'] = 'Fant ikke kurset på site-nivå';
$string['nostudentsfound'] = 'Ingen {$a} funnet';
$string['nostudentsingroup'] = 'Det er ingen studenter på dette kurset ennå';
$string['nostudentsyet'] = 'Det er ingen påmeldte studenter i dette kurset';
$string['nosuchemail'] = 'E-postadressen finnes ikke';
$string['notavailable'] = 'Ikke tilgjengelig';
$string['notavailablecourse'] = '{$a} er ikke tilgjengelig';
$string['noteachersyet'] = 'Ingen lærere i dette kurset ennå';
$string['noteachingupcomingcourses'] = 'Kommende kurs uten studenter eller lærere';
$string['notenrolled'] = '{$a} er ikke meldt på dette kurset enda.';
$string['notenrolledprofile'] = 'Denne profilen er ikke tilgjengelig siden aktuell bruker ikke er påmeldt i dette kurset.';
$string['noteusercannotrolldatesoncontext'] = '<strong>MERK:</strong> Muligheten til å rullere datoer ved gjenoppretting fra denne sikkerhetskopien er deaktivert siden du ikke har tilstrekkelig rettigheter.';
$string['noteuserschangednonetocourse'] = 'OBS: Brukerkontoene må også gjenopprettes når du gjenoppretter brukerdata. Denne innstillingen er endret for deg.';
$string['nothingnew'] = 'Ingen nylig aktivitet';
$string['nothingtodisplay'] = 'Ingenting å vise';
$string['notice'] = 'Merknad';
$string['noticenewerbackup'] = 'Denne sikkerhetskopien er laget med Moodle {$a->backuprelease} ({$a->backupversion}) og den er nyere enn den versjonen av Moodle du har installert, {$a-<serverrelease} ({$a->serverversion}). Siden nye moduler ikke alltid kan brukes på eldre versjoner, kan dette føre til problemer.';
$string['notifications'] = 'Varslinger';
$string['notifyloginfailuresmessage'] = '{$a->time}, IP: {$a->ip}, bruker: {$a->info}, brukers fulle navn: {$a->name}';
$string['notifyloginfailuresmessageend'] = 'Du kan se disse loggene på {$a}';
$string['notifyloginfailuresmessagestart'] = 'Her er en liste over mislykkede innlogginger på {$a} siden sist du ble varslet.';
$string['notifyloginfailuressubject'] = '{$a}:: Varsel om mislykkede innlogginger';
$string['notincluded'] = 'Ikke inkludert';
$string['notingroup'] = 'Beklager, du må være med i en gruppe for å se denne siden.';
$string['notpublic'] = 'Ikke offentlig!';
$string['nousersfound'] = 'Ingen brukere funnet';
$string['nousersmatching'] = 'Ingen treff på bruker \'{$a}\' ble funnet';
$string['nousersyet'] = 'Det finnes ingen brukere ennå';
$string['novalidcourses'] = 'Ingen gyldige kurs å vise';
$string['now'] = 'nå';
$string['numattempts'] = '{$a} mislykkede innloggingsforsøk';
$string['numberofcourses'] = 'Antall kurs';
$string['numberweeks'] = 'Antall seksjoner';
$string['numday'] = '{$a} dag';
$string['numdays'] = '{$a} dager';
$string['numhours'] = '{$a} timer';
$string['numletters'] = '{$a} bokstaver';
$string['numminutes'] = '{$a} minutter';
$string['nummonth'] = '{$a} måned';
$string['nummonths'] = '{$a} måneder';
$string['numseconds'] = '{$a} sekunder';
$string['numviews'] = '{$a} visninger';
$string['numweek'] = '{$a} uke';
$string['numweeks'] = '{$a} uker';
$string['numwords'] = '{$a} ord';
$string['numyear'] = '{$a} år';
$string['numyears'] = '{$a} år';
$string['ok'] = 'OK';
$string['oldpassword'] = 'Gjeldende passord';
$string['olduserdirectory'] = 'Dette er den GAMLE brukerkatalogen og trengs ikke lenger. Du kan trygt fjerne den. Filene den inneholder har blitt kopiert til den NYE brukerkatalogen.';
$string['opendrawerblocks'] = 'Åpne blokkskuff';
$string['opendrawerindex'] = 'Åpne kursindeks';
$string['opensinnewwindow'] = 'Åpnes i nytt vindu';
$string['operator_and'] = 'og';
$string['operator_andnot'] = 'og';
$string['operator_or'] = 'eller';
$string['optional'] = 'valgfri';
$string['options'] = 'alternativer';
$string['order'] = 'Sortering';
$string['originalpath'] = 'Original sti';
$string['orphanedactivitiesinsectionno'] = 'Aktiviteter uten tilknytning (seksjon {$a})';
$string['other'] = 'Andre';
$string['outline'] = 'Oversikt';
$string['outlinereport'] = 'Oversiktsrapport';
$string['page'] = 'Side';
$string['pagea'] = 'Side {$a}';
$string['pagedcontentnavigation'] = 'Sidesetting navigering';
$string['pagedcontentnavigationactiveitem'] = 'Nåværende side, side {$a}';
$string['pagedcontentnavigationitem'] = 'Gå til side {$a}';
$string['pagedcontentpagingbaritemsperpage'] = 'Vis {$a} elementer per side';
$string['pageheaderconfigablock'] = 'Setter opp en boks i {$a->fullname}';
$string['pagepath'] = 'Sti til siden';
$string['pageshouldredirect'] = 'Denne siden skal automatisk videresende. Dersom ingenting skjer kan du bruke lenken under.';
$string['parentcategory'] = 'Overordnet kategori';
$string['parentcoursenotfound'] = 'Overordnet kurs ble ikke funnet.';
$string['parentfolder'] = 'Overordnet mappe';
$string['participants'] = 'Deltakere';
$string['participantslist'] = 'Deltakerliste';
$string['participationratio'] = 'Deltaker forholdstall';
$string['participationreport'] = 'Deltakerrapport';
$string['password'] = 'Passord';
$string['passwordchanged'] = 'Passordet er endret';
$string['passwordconfirmchange'] = 'Bekreft passordbytte';
$string['passwordextlink'] = 'Følgende lenke tilbyes for at du kan gjenopprette ditt tapte passord. Dette vil ta deg ut av Moodle.';
$string['passwordforgotten'] = 'Glemt passord';
$string['passwordforgotteninstructions'] = 'Brukerinformasjonen din må først finnes fram fra Moodle databasen. Vær vennlig å legge inn <strong>enten</strong> ditt Moodle brukernavn eller den registerte epost-adressen i passende felt. Det er ikke behov for at du legger inn begge deler.';
$string['passwordforgotteninstructions2'] = 'For å tilbakestille passordet må du fylle inn ENTEN brukernavnet ELLER epostadressen ditt.

Dersom vi finner deg i databasen får du en e-post med instruksjoner om hvordan du skal få logget inn.

Får du ingen e-post innen rimelig tid betyr det at e-informasjonen du skrev inn var feil. Har du flere e-postadresser bør du sjekke alle før du kontakter Support.';
$string['passwordnohelp'] = 'Ingen hjelp tilgjengelig for å finne ditt tapte passord. Vær vennlig kontakt din Moodle administrator.';
$string['passwordpolicynomatch'] = 'Ditt nåværende passord tilfredstiller ikke lengre passordkravene. {$a}';
$string['passwordrecovery'] = 'Ja, hjelp meg å logge inn';
$string['passwordsdiffer'] = 'Passordene stemmer ikke overens';
$string['passwordsent'] = 'Passordet er sendt';
$string['passwordsenttext'] = '<p>En e-post er sendt til deg på {$a->email}.</p>
   <p><b>Vennligst sjekk e-posten din for nytt passord</b></p>
   <p>Det nye passordet er laget automatisk, så du burde
   <a href="{$a->link}">endre det til noe enklere</a>.</p>
   <p>Slett denne e-posten når du er ferdig med å bytte passord.</p>';
$string['passwordset'] = 'Passordet ditt har blitt satt.';
$string['path'] = 'Sti';
$string['pathnotexists'] = 'Filbanen finnes ikke på tjeneren!';
$string['pathslasherror'] = 'Filbanen kan ikke ende med en skråstrek.';
$string['paymentinstant'] = 'Bruk knappen under for å betale og melde deg på kurset.';
$string['paymentpending'] = '(<small><b><u>{$a}</u></b> pågående </small>)';
$string['paymentrequired'] = 'Dette er et kurs som krever betaling';
$string['payments'] = 'Innbetalinger';
$string['paymentsorry'] = 'Takk for betalingen! Dessverre er ikke innbetalingen ferdigbehandlet, så du har ennå ikke blitt registrert som student på kurset "{$a->fullname}".
Prøv å gå videre til kurset om noen sekunder. Hvis problemene fortsetter kan du ta kontakt med {$a->teacher} eller portalens administrator.';
$string['paymentthanks'] = 'Takk for betalingen. Du er nå påmeldt kurset: "{$a}".';
$string['pendingrequests'] = 'Forespørselen er under vurdering';
$string['percents'] = '{$a}%';
$string['periodending'] = 'Perioden slutter ({$a})';
$string['perpage'] = 'Per side';
$string['perpagea'] = 'Per side: {$a}';
$string['personal'] = 'Personlig';
$string['personalprofile'] = 'Personlig profil';
$string['phone'] = 'Telefon';
$string['phone1'] = 'Telefon';
$string['phone2'] = 'Mobiltelefon';
$string['phpinfo'] = 'PHP-info';
$string['picture'] = 'Bilde';
$string['pictureof'] = 'Bilde av {$a}';
$string['pictureofuser'] = 'Profilbilde';
$string['placeholdertypeorselect'] = 'Skriv inn eller velg';
$string['pleaseclose'] = 'Vennligst lukk dette vinduet';
$string['pleasesearchmore'] = 'Vennligst forsøk flere søk';
$string['pleaseusesearch'] = 'Vennligst prøv søkefunksjonen';
$string['plugin'] = 'Modul';
$string['pluginarea'] = 'Område';
$string['plugincheck'] = 'Sjekk moduler';
$string['plugindeletefiles'] = 'Alle data assossiert med modulen  \'{$a->name}\'  er nå slettet fra databasen. For å forhindre at modulen reinstallerer seg selv må du slette modulen fra serveren: {$a->directory} ';
$string['pluginitemid'] = 'Element-ID';
$string['pluginmissingfromdisk'] = '{$a->name} (Mangler fra disk)';
$string['pluginsetup'] = 'Setter opp modultabeller';
$string['policyaccept'] = 'Jeg forstår og godtar';
$string['policyagree'] = 'Du må godta avtalen for å bruke denne portalen. Godtar du den?';
$string['policyagreement'] = 'Avtale for bruk av portalen';
$string['policyagreementclick'] = 'Brukervilkår';
$string['popup'] = 'popup';
$string['popupwindow'] = 'Åpne fila i et nytt vindu';
$string['popupwindowname'] = 'Popup-vindu';
$string['post'] = 'Innlegg';
$string['posts'] = 'Innlegg';
$string['potentialadmins'] = 'Mulige administratorer';
$string['potentialcreators'] = 'Mulige kursprodusenter';
$string['potentialstudents'] = 'Mulige studenter';
$string['potentialteachers'] = 'Mulige lærere';
$string['poweredbymoodle'] = 'Drevet av <a href="https://moodle.com">Moodle</a>';
$string['preferences'] = 'Preferanser';
$string['preferredlanguage'] = 'Språk';
$string['preferredtheme'] = 'Foretrukket design';
$string['preprocessingbackupfile'] = 'Forbereder sikkerhetskopifilen';
$string['prev'] = 'Forrige';
$string['preview'] = 'Forhåndsvis';
$string['previeworchoose'] = 'Forhåndsvis eller endre design';
$string['previewthemename'] = 'Forhåndsvis designet «{$a}»';
$string['previous'] = 'Forrige';
$string['previouslyselectedusers'] = 'Tidligere valgte brukere som ikke samsvarer med \'{$a}\'';
$string['previouspage'] = 'Forrige side';
$string['previoussection'] = 'Forrige seksjon';
$string['primaryadminsetup'] = 'Setup administrator konto';
$string['privacy:metadata:config_log'] = 'Loggen med konfigursjonsendringer.';
$string['privacy:metadata:config_log:name'] = 'Navnet på innstillingen som ble endret';
$string['privacy:metadata:config_log:oldvalue'] = 'Den tidligere verdien for denne innstillingen';
$string['privacy:metadata:config_log:plugin'] = 'Modulen som ble endret.';
$string['privacy:metadata:config_log:timemodified'] = 'Når endringen ble gjort';
$string['privacy:metadata:config_log:userid'] = 'Brukeren som gjorde endringen.';
$string['privacy:metadata:config_log:value'] = 'Den nye veriden for denne innstillingen.';
$string['privacy:metadata:events_queue'] = 'Køen med brukerhendelser som venter på å bli behandlet.';
$string['privacy:metadata:events_queue:eventdata'] = 'Datene lagret i hendelsen';
$string['privacy:metadata:events_queue:stackdump'] = 'Enhver stacktrace tilknyttet denne hendelsen.';
$string['privacy:metadata:events_queue:timecreated'] = 'Når denne hendelsen ble opprettet';
$string['privacy:metadata:events_queue:userid'] = 'Bruker-ID-en som er tilknyttet denne hendelsen';
$string['privacy:metadata:log'] = 'En samling tidligere hendelser';
$string['privacy:metadata:log:action'] = 'En beskrivelse av handlingen';
$string['privacy:metadata:log:cmid'] = 'cmid';
$string['privacy:metadata:log:course'] = 'kurs';
$string['privacy:metadata:log:info'] = 'Tilleggsinformasjon';
$string['privacy:metadata:log:ip'] = 'IP-adressen brukt på tidspunktet for hendelsen';
$string['privacy:metadata:log:module'] = 'modul';
$string['privacy:metadata:log:time'] = 'Tidspunktet handlingen skjedde';
$string['privacy:metadata:log:url'] = 'URLen relatert til hendelsen.';
$string['privacy:metadata:log:userid'] = 'ID\'en til brukeren som gjennomførte handlingen';
$string['privacy:metadata:moodlenet_share_progress'] = 'MoodleNet deler fremdriftsdetaljer';
$string['privacy:metadata:moodlenet_share_progress:cmid'] = 'Tilknyttet kursmodul-ID';
$string['privacy:metadata:moodlenet_share_progress:courseid'] = 'Tilknyttet kurs-ID';
$string['privacy:metadata:moodlenet_share_progress:resourceurl'] = 'Den returnerte url fra MoodleNet etter en vellykket deling';
$string['privacy:metadata:moodlenet_share_progress:status'] = 'Den resulterende statusen til andelen';
$string['privacy:metadata:moodlenet_share_progress:timecreated'] = 'Tidspunktet delingen ble utført';
$string['privacy:metadata:moodlenet_share_progress:type'] = 'Type deling som ble utført';
$string['privacy:metadata:moodlenet_share_progress:userid'] = 'Brukeren som utførte delingen';
$string['privacy:metadata:oauth2_refresh_token'] = 'Oppdater token brukt i OAuth 2.0-kommunikasjon';
$string['privacy:metadata:oauth2_refresh_token:issuerid'] = 'IDen til utstederen som tokenet tilsvarer';
$string['privacy:metadata:oauth2_refresh_token:scopehash'] = 'ID-en til brukeren som tokenet tilsvarer';
$string['privacy:metadata:oauth2_refresh_token:timecreated'] = 'Tidspunktet for da tokenet ble opprettet';
$string['privacy:metadata:oauth2_refresh_token:timemodified'] = 'Tidspunktet for da tokenet sist ble oppdatert';
$string['privacy:metadata:oauth2_refresh_token:token'] = 'Oppdateringstokenet for de respektive scope og brukerne';
$string['privacy:metadata:oauth2_refresh_token:userid'] = 'ID-en til brukeren som tokenet tilsvarer';
$string['privacy:metadata:task_adhoc'] = 'Adhoc oppgavestatus';
$string['privacy:metadata:task_adhoc:component'] = 'Komponenten som eier oppgaven.';
$string['privacy:metadata:task_adhoc:nextruntime'] = 'Den tidligste tiden oppgaven skal kjøre.';
$string['privacy:metadata:task_adhoc:userid'] = 'Brukeren å kjøre oppgaven som.';
$string['privacy:metadata:task_log'] = 'Loggdestinasjon for en logg';
$string['privacy:metadata:task_log:component'] = 'Komponenten som eier oppgaven.';
$string['privacy:metadata:task_log:userid'] = 'Brukeren som oppgaven hører til hos.';
$string['privacy:metadata:upgrade_log'] = 'Oppgraderingsloggen.';
$string['privacy:metadata:upgrade_log:backtrace'] = 'Eventuelle backtrace knyttet til dette oppgraderingstrinnet.';
$string['privacy:metadata:upgrade_log:details'] = 'Ekstrainformasjon relatert til oppgraderingen.';
$string['privacy:metadata:upgrade_log:info'] = 'Hovedinformasjonen for dette oppgraderingssteget.';
$string['privacy:metadata:upgrade_log:plugin'] = 'Modulen som ble oppgradert';
$string['privacy:metadata:upgrade_log:targetversion'] = 'Den nye versjonen det ble oppgradert til.';
$string['privacy:metadata:upgrade_log:timemodified'] = 'Når oppgraderingen ble utført.';
$string['privacy:metadata:upgrade_log:type'] = 'Typen logginnlegg.';
$string['privacy:metadata:upgrade_log:userid'] = 'Brukeren som oppgradert';
$string['privacy:metadata:upgrade_log:version'] = 'Modulens gamle versjon';
$string['private_files_handler'] = 'Lagre epostvedlegg i brukerens private lagringsområde.';
$string['private_files_handler_name'] = 'Epost til Private filer';
$string['privatefiles'] = 'Private filer';
$string['privatefilesmanage'] = 'Administrer private filer';
$string['proceed'] = 'Fortsett';
$string['profile'] = 'Profil';
$string['profilenotshown'] = 'Denne profilbeskrivelsen vil ikke vises før en bruker er påmeldt i minst ett kurs.';
$string['progress'] = 'Progresjon';
$string['publicprofile'] = 'Offentlig profil';
$string['publicsitefileswarning'] = 'Merk: Filer plassert her vil hvem som helst ha tilgang til';
$string['publicsitefileswarning2'] = '<strong>MERK:</strong> Filer du plasserer her er fritt tilgjengelig for alle som vet (eller kan gjette) URL-en. Av sikkerhetshensyn anbefales det at alle sikkerhetskopifiler slettes straks de er benyttet.';
$string['publicsitefileswarning3'] = 'MERK: Filer du laster opp her kan nås av alle som vet (eller kan gjette) URL-en. Av sikkerhetsgrunner bør du alltid lagre backupfiler i den sikre mappen "backupdata".';
$string['question'] = 'Spørsmål';
$string['questionsinthequestionbank'] = 'Spørsmål i testbanken';
$string['queued'] = 'I kø';
$string['quotausage'] = 'Du har brukt {$a->used} av din totale grense på {$a->limit}';
$string['readinginfofrombackup'] = 'Leser informasjon fra sikkerhetskopi';
$string['readme'] = 'LES MEG';
$string['recentactivity'] = 'Siste aktiviteter';
$string['recentactivityreport'] = 'Full rapport over nylige aktiviteter';
$string['recipientslist'] = 'Mottakerliste';
$string['recommended'] = 'Anbefalt';
$string['recreatedcategory'] = 'Gjenopprettet kategori {$a}';
$string['redirect'] = 'Videresend';
$string['reducesections'] = 'Minske antall seksjoner';
$string['refresh'] = 'Oppdatér';
$string['refreshingevents'] = 'Oppdaterer tilstelninger';
$string['registration'] = 'Moodleregistrering';
$string['registrationcontact'] = 'Kontakt med offentligheten';
$string['registrationcontactno'] = 'Nei, jeg ønsker ikke å bli kontaktet av andre personer';
$string['registrationcontactyes'] = 'Ja, sørg for at andre moodlere kan komme i kontakt med meg.';
$string['registrationemail'] = 'E-postvarsling';
$string['registrationinfo'] = '<p>Denne siden lar deg registrere din Moodleside hos moodle.org. Registrering er gratis. Hovedfordelen med dette er at du blir lagt til en e-postliste med lite trafikk med viktige beskjeder som sikkerhetsadvarsler og nye versjoner av Moodle.</p> <p>Standard er at din informasjon holdes privat og vil aldri bli videreformidlet til andre. Den eneste årsaken til at vi samler inn denne informasjonen er for brukerstøtte og å lage et statistisk, helhetlig bilde av bruken av Moodle.<p>Hvis du velger dette kan du la navnet på siden, land og adresse bli lagt til listen over Moodlesider.</p> <p>Alle nyregistreringer bekreftes manuelt før de legges ut på listen, men du kan også endre denne informasjonen (og oppføringen på listen over Moodlesider) senere ved å fylle ut dette skjemaet på nytt.</p>';
$string['registrationinfotitle'] = 'Registreringsinformasjon';
$string['registrationsend'] = 'Send informasjon til moodle.org';
$string['registrationyes'] = 'Ja, gi meg beskjed om nye Moodle-versjoner, sikkerhetsvarsler og andre viktige nyheter';
$string['reject'] = 'Avvis';
$string['rejectdots'] = 'Avvis...';
$string['relativedatesmode'] = 'Relativ datomodus';
$string['relativedatesmode_help'] = 'Vis kurs- eller aktivitetsdatoer i forhold til brukerens startdato i kurset.

Brukerens kursstartdato vil være deres påmeldingsstartdato, med mindre de er påmeldt før kurset begynner, i så fall startdatoen vil være kursstart dato.

<strong> ADVARSEL: Dette er en eksperimentell funksjon og kanskje ikke alle aktiviteter støtter den. Når kurset er opprettet, kan denne kursinnstillingen ikke lenger endres. </strong>';
$string['relativedatesmode_warning'] = '<strong>Advarsel:</strong> Relativ datomodus kan ikke endres etter at kurset er opprettet.';
$string['reload'] = 'Last på nytt';
$string['remoteappuser'] = 'Ekstern {$a} Bruker';
$string['remove'] = 'Fjern';
$string['removeadmin'] = 'Fjern admin';
$string['removecreator'] = 'Fjern kursprodusent';
$string['removestudent'] = 'Fjern student';
$string['removeteacher'] = 'Fjern lærer';
$string['rename'] = 'Gi nytt navn';
$string['renamefileto'] = 'Gi <b>{$a}</b> nytt navn til';
$string['report'] = 'Rapport';
$string['reports'] = 'Rapporter';
$string['reporttype'] = 'Rapporttype';
$string['repositories'] = 'Filarkiver';
$string['requestcourse'] = 'Søk om oppretting av kurs';
$string['requestedby'] = 'Søknad fra';
$string['requestedcourses'] = 'Ønskede kurs';
$string['requestreason'] = 'Grunn for kurssøknaden';
$string['requests'] = 'Forespørsler';
$string['required'] = 'Obligatorisk';
$string['requirespayment'] = 'Dette kurset krever innbetaling for å gi tilgang';
$string['resendemail'] = 'Send bekreftelses-epost på nytt';
$string['reset'] = 'Tilbakestill';
$string['resetcomponent'] = 'Komponent';
$string['resetcourse'] = 'Tilbakestill kurset';
$string['resetinfo'] = 'Slett alle brukerdata og tilbakestill dette kurset til sin opprinnelige tilstand, og hold aktiviteter og innstillinger intakte.';
$string['resetnotimplemented'] = 'Resetting ikke implementert';
$string['resetrecordexpired'] = 'Lenken for nytt passord som du benyttet er mer enn {$a} minutter gammel og har utløpt. Vennligst be om nytt passord på nytt.';
$string['resetstartdate'] = 'Tilbakestill startdato';
$string['resetstatus'] = 'Status';
$string['resettable'] = 'Tilbakestill tabellpreferanser';
$string['resettask'] = 'Oppgave';
$string['resettodefaults'] = 'Tilbakestill til standarsinnstillinger';
$string['resortcourses'] = 'Sorter kurs';
$string['resortsubcategoriesby'] = 'Sorter underkategoriene etter {$a} stigende';
$string['resortsubcategoriesbyreverse'] = 'Sorter underkategoriene etter {$a} synkende';
$string['resource'] = 'Ressurs';
$string['resourcedisplayauto'] = 'Automatisk';
$string['resourcedisplaydownload'] = 'Tving nedlasting';
$string['resourcedisplayembed'] = 'Innebygg';
$string['resourcedisplayframe'] = 'I ramme';
$string['resourcedisplaynew'] = 'Nytt vindu';
$string['resourcedisplayopen'] = 'Åpne';
$string['resourcedisplaypopup'] = 'I et popup-vindu';
$string['resources'] = 'Ressurser';
$string['resources_help'] = 'Ressurstyper aktiverer neste all slags webinnhold for bruk i kurs.';
$string['restore'] = 'Gjenoppretting';
$string['restorecancelled'] = 'Gjenoppretting avbrutt';
$string['restorecannotassignroles'] = 'Gjenopprettingen medfører rolletildelinger og du har ikke tillatelse til å gjøre dette';
$string['restorecannotcreateorassignroles'] = 'Gjenopprettingen medfører oppretting eller tildeling av roller og du har ikke tillatelse til å gjøre dette';
$string['restorecannotcreateuser'] = 'Gjenopprettingsmodulen har behov for å opprette brukeren  \'{$a}\'  fra sikkherhetskopien og du har ikke rett til å opprette brukere.';
$string['restorecannotoverrideperms'] = 'Gjenopprettingen medfører at tillatelser må overstyres og du har ikke tillatelse til å gjøre dette';
$string['restorecoursenow'] = 'Gjennopprett denne siden nå.';
$string['restoredaccount'] = 'Gjenopprettet brukerkonto';
$string['restoredaccountinfo'] = 'Denne brukerkontoen ble importert fra en annen installasjon og passorder er gått tapt. Klikk på "Fortsett" for å angi nytt passord via e-post';
$string['restorefinished'] = 'Gjenoppretting fullført';
$string['restoreinfo'] = 'Bruk en sikkerhetskopifil for å gjenopprette en tidligere versjon av et kurs, eller for å opprette et nytt kurs.';
$string['restoremnethostidmismatch'] = 'MNet host id for brukeren \'{$a}\' matcher ikke local MNet host ID.';
$string['restoreto'] = 'Gjenopprett til';
$string['restoretositeadding'] = 'Advarsel: Du er i ferd med å gjenopprette hovedsiden ved å legge til data til den!';
$string['restoretositedeleting'] = 'Advarsel: Du er i ferd med å gjenopprette/erstatte hovedsiden ved å først slette eksisterende!';
$string['restoreuserconflict'] = 'Dersom du gjenopprette bruker \'{$a}\' fra sikkerhetskopien vil det gi konflikt med eksisterende bruker.';
$string['restoreuserinfofailed'] = '<strong>ADVARSEL:</strong> For å kunne gjenopprette brukerdata (i aktiviteter, filer, meldinger osv...) må rettigheten "moodle/restore:userinfo" være på "Tillat" og denne rettigheten er ikke satt. Gjenopprettingsprosessen er derfor stoppet.';
$string['restoreusersprecheck'] = 'Sjekker brukerdata';
$string['restoreusersprecheckerror'] = 'Det ble oppdaget noen problemer under sjekk av brukerdata.';
$string['restricted'] = 'Begrenset';
$string['resultsfound'] = '{$a} resultater funnet';
$string['retry'] = 'Prøv på nytt';
$string['returningtosite'] = 'Registrert bruker?';
$string['returntooriginaluser'] = 'Tilbake til {$a}';
$string['revert'] = 'Tilbakestill';
$string['role'] = 'Rolle';
$string['roleassignments'] = 'Rolletildelinger';
$string['rolemappings'] = 'Rolletildelinger';
$string['rolerenaming'] = 'Gi rolle nytt navn';
$string['rolerenaming_help'] = 'Endre visningsnavnene til rollene i dette kurset.';
$string['rolerenaming_success'] = 'Kursrollenavn oppdatert.';
$string['roles'] = 'Roller';
$string['rss'] = 'RSS';
$string['rssarticles'] = 'Antall nye RSS-utsendinger';
$string['rsserror'] = 'Feil ved lesing av RSS-data';
$string['rsserrorauth'] = 'RSS-lenken din inneholder ingen gyldig kodestreng.';
$string['rsserrorguest'] = 'Denne feeden bruker gjestetilgang til å hente data, men gjester har ikke tilgang til å lese data. Gå til orginalinnstillingene hvor denne feeden kommer fra (URL\'en) som gyldig bruker og hent en ny RSS lenke der.';
$string['rsskeyshelp'] = '<p>For å styrke sikkerheten og personvernet, inneholder RSS-strømmer en spesiell token som identifiserer brukeren de sendes til. Dette forhindrer andre brukere å få tilgang til områder i Moodle de ikke skal ha adgang til via RSS-strømmer. </p>
<p>Dette tokenet opprettes automatisk første gangen du går inn på et område i Moodle som genererer en RSS-strøm. Dersom du tror at noen har fått rede på din RSS-token kan du resette den her. Merk at dine tidligere lagrede RSS-strømmer fra Moodle da blir ugyldige og må legges inn på nytt.</p>';
$string['rsstype'] = 'RSS-utsending for denne aktiviteten';
$string['save'] = 'Lagre';
$string['saveandnext'] = 'Lagre og vis neste';
$string['savechanges'] = 'Lagre endringer';
$string['savechangesanddisplay'] = 'Lagre og vis';
$string['savechangesandreturn'] = 'Lagre og gå tilbake';
$string['savechangesandreturntocourse'] = 'Lagre og gå tilbake til kurset';
$string['savecomment'] = 'Lagre kommentar';
$string['savedat'] = 'Lagret:';
$string['savepreferences'] = 'Lagre preferanser';
$string['saveto'] = 'Lagre til';
$string['scale'] = 'Skala';
$string['scale_help'] = '<p>
Lærere kan lage nye standardskalaer som de kan bruke i et kurs for alle typer
vurdering.&nbsp;
</p>

<p>
Navnet på skalaen børe være en gjenkjennelig frase. Den vises i listen over
skalaer man kan velge mellom og på hjelpeknapper som dukker opp i riktig
sammenheng.
</p>

<p>
Selve skalaen består av en kommaseparert liste i en viss rekkefølge som går fra
det negative til det positive. Eksempel:&nbsp;
</p>

<blockquote><i>Ikke godkjent, Dårlig, Midt på tre, Bra, Veldig bra, Utmerket </i></blockquote>

<p>
Skalaen bør også inneholde en bra beskrivelse av hva den betyr og hvordan man
forventer at den brukes. Denne beskrivelsen vises på hjelpesider som både
studenter og lærere kan se.
</p>

<p>
I tillegg kan det være en eller flere standardskalaer på nettstedet som
administrator har definert. Disse blir tilgjengelig for alle klasser.
</p>';
$string['scale_link'] = 'grade/scale';
$string['scales'] = 'Skalaer';
$string['scalescustom'] = 'Egendefinerte skalaer';
$string['scalescustomcreate'] = 'Legg til ny skala';
$string['scalescustomno'] = 'Ingen egendefinerte skalaer er laget enda';
$string['scalesstandard'] = 'Standardskalaer';
$string['scalestandard'] = 'Standard skala';
$string['scalestandard_help'] = '<p>En standard skala er en som er tilgjengelig for alle kurs på portalen.</p>';
$string['scalestandard_link'] = 'grade/scale';
$string['scalestip'] = 'Bruk Skala-lenken i kursets administrasjonsmeny for å lage egne karakterskalaer.';
$string['scalestip2'] = 'Du oppretter egne karakterskaler slik: Administrasjon > Karakterer og velg Endre skalaer.';
$string['schedule'] = 'Planlegg';
$string['screenshot'] = 'Skjermbilde';
$string['search'] = 'Søk';
$string['search_help'] = 'For standard søk med ett eller flere ord hvor som helst i teksten - bare skriv dem inn med mellomrom. Alle ord med mer enn to bokstaver kan brukes.';
$string['searchactivities'] = 'Søk etter aktiviteter med navn eller beskrivelse';
$string['searchagain'] = 'Søk på nytt';
$string['searchbyemail'] = 'Søk via e-postadressen';
$string['searchbyusername'] = 'Søk via brukernavn';
$string['searchcoursecategories'] = 'Søk kategorier';
$string['searchcourses'] = 'Søk etter studiesider';
$string['searchgroups'] = 'Søk etter grupper';
$string['searchitems'] = 'Søk etter elementer';
$string['searchoptions'] = 'Søkevalg';
$string['searchresults'] = 'Søkeresultater';
$string['searchusers'] = 'Søk etter brukere';
$string['sec'] = 'sek';
$string['seconds'] = 'sekunder';
$string['secondsleft'] = '{$a} sekunder';
$string['secondstotime172800'] = '2 dager';
$string['secondstotime259200'] = '3 dager';
$string['secondstotime345600'] = '4 dager';
$string['secondstotime432000'] = '5 dager';
$string['secondstotime518400'] = '6 dager';
$string['secondstotime604800'] = '1 uke';
$string['secondstotime86400'] = '1 dag';
$string['secretalreadyused'] = 'Lenken for godkjenning av passordendring er allerede benyttet, passordet ble ikke endret.<p>Denne feilmeldingen kommer som regel fordi du har prøvd å klikke enda en gang på lenken i tilsendt e-post for passordskifte - en prosess du har fullført allerede. Slike lenker er bare for engangs bruk. Prøv heller å logge inn på vanlig måte.</p>';
$string['secs'] = 'sek';
$string['section'] = 'Kategori';
$string['sectionactionnotsupported'] = 'Du kan ikke utføre handlingen "{$a}" her.';
$string['sectionname'] = 'Seksjonsnavn';
$string['sectionoutline'] = 'Seksjonsoversikt';
$string['sections'] = 'Kategorier';
$string['seealsostats'] = 'Se også: statistikk';
$string['selctauser'] = 'Velg en bruker';
$string['select'] = 'Velg';
$string['selectacategory'] = 'Vennligst velg en kategori';
$string['selectacountry'] = 'Velg et land';
$string['selectacourse'] = 'Velg et kurs';
$string['selectacoursesite'] = 'Velg et kurs eller portal';
$string['selectagroup'] = 'Velg en gruppe';
$string['selectall'] = 'Velg alle';
$string['selectallusersonpage'] = 'Velg alle brukere på denne siden';
$string['selectalluserswithcount'] = 'Velg alle {$a} brukere';
$string['selectamodule'] = 'Vennligst velg en aktivitetsmodul';
$string['selectanaction'] = 'Velg en handling';
$string['selectanoptions'] = 'Velg et alternativ';
$string['selectaregion'] = 'Velg en region';
$string['selectcategorysort'] = 'Hvilke kategorier ønsker du å sortere?';
$string['selectcategorysortby'] = 'Velg hvordan du ønsker å sortere kategorier';
$string['selectcoursesortby'] = 'Velg hvordan du ønsker å sortere kurs';
$string['selectdefault'] = 'Velg standard';
$string['selectedcategories'] = 'Valgte kategorier';
$string['selectedfile'] = 'Valgt fil';
$string['selectednowmove'] = '{$a} filer er valgt for flytting. Gå dit du vil ha dem og klikk "Flytt filer hit"';
$string['selectfiles'] = 'Valgte filer';
$string['selectfiltertype'] = 'Velg';
$string['selectgroupsseparate'] = 'Velg separate grupper';
$string['selectgroupsvisible'] = 'Velg synlige grupper';
$string['selectitem'] = 'Velg \'{$a}\'';
$string['selectmoduletoviewhelp'] = 'Velg en modul for å se hjelpen som er tilknyttet.

Dobbelklikk på en aktivitet eller ressurs for å legge den til raskt.';
$string['selectnos'] = 'Velg alle \'nei\'';
$string['selectperiod'] = 'Velg periode';
$string['selecttheme'] = 'Velg design';
$string['selectthemename'] = 'Velg design \'{$a}\'';
$string['senddetails'] = 'Send mine detaljer via e-post';
$string['sent'] = 'Sendt';
$string['separate'] = 'Adskilt';
$string['separateandconnected'] = 'Individuell (rasjonell) og sosial (empatisk) måte å lære på';
$string['separateandconnectedinfo'] = 'Skalaen er basert på teorien om separat og sammenhengende kunnskap. Denne teorien beskriver to forskjellige måter vi kan evaluere og lære om tingene vi ser og hører. <ul> <li> <strong> Separate vitere </strong> forblir så objektive som mulig uten å inkludere følelser og følelser. I en diskusjon med andre mennesker liker de å forsvare sine egne ideer ved å bruke logikk for å finne hull i motstanderens ideer. </li> <li> <strong> Relasjons-vitere </strong> er mer følsomme for andre mennesker. De er dyktige i empati og har en tendens til å lytte og stille spørsmål til de føler at de kan koble seg sammen og "forstå ting fra deres synspunkt". De lærer ved å prøve å dele erfaringene som førte til kunnskapen de finner hos andre mennesker. </li> </ul>';
$string['servererror'] = 'Det oppstod en feil i kommunikasjonen med serveren.';
$string['serverlocaltime'] = 'Tjenerens lokale tid';
$string['sessionforceclean'] = 'Som en sikkerhetsforanstaltning har brukergenererte skript blitt deaktivert når du er logget inn som en annen bruker.';
$string['sessiontimeoutsoon'] = 'Du har vært inaktiv for lenge og du er i ferd med å logges ut. Ønsker du å forbli innlogget?';
$string['setcategorytheme'] = 'Angi eget design for kategorien';
$string['setmode'] = 'Angi modus';
$string['setpassword'] = 'Sett passord';
$string['setpasswordinstructions'] = 'Vennligst legg inn ditt nye passord og lagre endringene.';
$string['settings'] = 'Innstillinger';
$string['share'] = 'Del';
$string['shortname'] = 'Kort navn';
$string['shortnamecollisionwarning'] = '[*]= Kortnavnet er allerede brukt av et annet kurs og må endres når/hvis kurset godkjennes';
$string['shortnamecourse'] = 'Kursets kortnavn';
$string['shortnamecourse_help'] = 'Navnet vises i områder med begrenset plass. Det må være unikt.';
$string['shortnametaken'] = 'Kortnavnet er allerede brukt av et annet kurs ({$a})';
$string['shortnameuser'] = 'Brukerens kortnavn';
$string['shortsitename'] = 'Kort navn på kurset (ett enkelt ord)';
$string['show'] = 'Vis';
$string['showactions'] = 'Vis handlinger';
$string['showactivitydates'] = 'Vis aktivitetsdatoer';
$string['showactivitydates_help'] = 'Vis aktivitetsdatoer på kurssiden.';
$string['showadvancededitor'] = 'Avansert';
$string['showadvancedsettings'] = 'Vis avanserte innstillinger';
$string['showall'] = 'Vis alle {$a}';
$string['showallcourses'] = 'Vis alle kurs';
$string['showallusers'] = 'Vis alle brukere';
$string['showblockcourse'] = 'Vis kurs med blokker';
$string['showcategory'] = 'Vis {$a}';
$string['showchartdata'] = 'Vis diagramdata';
$string['showcomments'] = 'Vis/skjul kommentarer';
$string['showcommentsnonjs'] = 'Vis kommentarer';
$string['showdescription'] = 'Vis beskrivelsen på kurssiden';
$string['showdescription_help'] = 'Hvis aktivert, vil beskrivelsen over vises på kurssiden rett under lenken til aktiviteten eller ressursen.';
$string['showgrades'] = 'Vis karakterbok til studentene';
$string['showgrades_help'] = 'La elevene se en liste over alle karakterene deres i kurset.';
$string['showingacourses'] = 'Viser alle {$a} kursene';
$string['showingxofycourses'] = 'Viser kurs {$a->start} til {$a->end} av {$a->total} kurs';
$string['showless'] = 'Vis mindre';
$string['showlistofcourses'] = 'Vis liste over kurs';
$string['showmodulecourse'] = 'Vis kurs med aktivitet';
$string['showmore'] = 'Vis mer';
$string['showoncoursepage'] = 'Vis på kurssiden';
$string['showonly'] = 'Vis bare';
$string['showperpage'] = 'Vis {$a} pr side';
$string['showpopoverwindow'] = 'Vis popovervindu';
$string['showrecent'] = 'Vis siste aktivitet';
$string['showreports'] = 'Vis aktivitetsrapport';
$string['showreports_help'] = 'La elevene se sine egne aktivitetsrapporter via profilsiden deres.';
$string['showsettings'] = 'Vis innstillinger';
$string['showtheselogs'] = 'Vis disse loggene';
$string['showthishelpinlanguage'] = 'Vis hjelp i språket: {$a}';
$string['sidepanel'] = 'Sidepanel';
$string['signoutofotherservices'] = 'Logg ut over alt';
$string['signoutofotherservices_help'] = 'Når avhuket, vil brukeren logges ut av alle systemer og enheter som bruker webservicene, slik som mobilappen.';
$string['since'] = 'Siden';
$string['sincelast'] = 'siden siste innlogging';
$string['site'] = 'Portal';
$string['sitedefault'] = 'Portalstandard';
$string['sitedefaultspecified'] = 'Portalstandard ({$a})';
$string['siteerrors'] = 'Mislykket innlogging';
$string['sitefiles'] = 'Portalfiler';
$string['sitefilesused'] = 'Portalfiler brukt i dette kurset';
$string['sitehome'] = 'Forsiden';
$string['sitelegacyfiles'] = 'Arvede portalfiler';
$string['sitelogs'] = 'Logger for portalen';
$string['sitenews'] = 'Portalnyheter';
$string['sitepages'] = 'Forsideressurser';
$string['sitepartlist'] = 'Du har ikke nødvendig tillatelse til å se deltakerlista.';
$string['sitepartlist0'] = 'Du må være lærer på portalen for å få se portal-deltakerlisten';
$string['sitepartlist1'] = 'Du må være lærer for å få lov til å se listen over deltakere på portalen';
$string['sites'] = 'Portaler';
$string['sitesection'] = 'Legg til emne';
$string['sitesettings'] = 'Innstillinger for portalen';
$string['siteteachers'] = 'Lærere på portalen';
$string['size'] = 'Størrelse';
$string['sizeb'] = 'bytes';
$string['sizegb'] = 'Gb';
$string['sizekb'] = 'Kb';
$string['sizemb'] = 'Mb';
$string['sizepb'] = 'PB';
$string['sizetb'] = 'TB';
$string['skipped'] = 'Hoppet over';
$string['skiptocategorylisting'] = 'Hopp over kategorivisninger';
$string['skiptocoursedetails'] = 'Hopp over detaljert kursinformasjon';
$string['skiptocourselisting'] = 'Hopp over kursvisninger';
$string['socialheadline'] = 'Sosialt forum - nyeste emner';
$string['someallowguest'] = 'Noen kurs kan tillate gjestebesøk';
$string['someerrorswerefound'] = 'Noe informasjon manglet eller var feil. Se nedenfor for detaljer.';
$string['sort'] = 'Sorter';
$string['sortby'] = 'Sorter etter';
$string['sortbyx'] = 'Sorter stigende etter {$a}';
$string['sortbyxreverse'] = 'Sorter synkende etter {$a}';
$string['sorting'] = 'Sorterer';
$string['sourcerole'] = 'Opprinnelig rolle';
$string['specifyname'] = 'Du må oppgi et navn';
$string['standard'] = 'Standard';
$string['starpending'] = '([*] =kurs som venter på godkjenning)';
$string['startdate'] = 'Dato for studiestart';
$string['startdate_help'] = 'Denne datoen bestemmer starten på den første uken for et kurs i ukesformat. Det er også startdato for logger over kursaktiviteter.

Hvis du nullstiller kurset og endrer denne datoen, flyttes alle datoer i kurset i forhold til ny startdato.';
$string['startdatewithtaskenabled'] = 'Kurs startdato';
$string['startdatewithtaskenabled_help'] = 'Datoen da kurset blir synlig for studentene. Før denne datoen vil de ikke få tilgang til kurset.

Denne datoen bestemmer også starten på den første uken for et kurs i ukesformat, og er startdatoen for logger over kursaktiviteter. om du nullstiller kurset og endrer denne datoen, vil alle datoer i kurset bli flyttet i forhold til ny startdato.';
$string['startingfrom'] = 'Starter fra';
$string['startsignup'] = 'Registrer deg';
$string['state'] = 'Fylke';
$string['statistics'] = 'Statistikk';
$string['statisticsgraph'] = 'Statistikk graf';
$string['stats'] = 'Statistikk';
$string['statslogins'] = 'Innlogginger';
$string['statsmodedetailed'] = 'Detaljert visning (bruker)';
$string['statsmodegeneral'] = 'Generell visning';
$string['statsnodata'] = 'Det er ingen tilgjengelige data for den kombinasjon av kurs- og tidsperiode.';
$string['statsnodatauser'] = 'Det er ingen tilgjengelige data for den kombinasjon av kurs, bruker og tidsperiode.';
$string['statsoff'] = 'Statistikk er ikke slått på nå';
$string['statsreads'] = 'Visninger';
$string['statsreport1'] = 'Innlogginger';
$string['statsreport10'] = 'Brukeraktivitet';
$string['statsreport11'] = 'Mest aktive kurs';
$string['statsreport12'] = 'Mest aktive kurs (vektet)';
$string['statsreport13'] = 'Kurs med flest deltakere';
$string['statsreport14'] = 'Kurs med flest visninger og innlegg';
$string['statsreport2'] = 'Visninger (alle roller)';
$string['statsreport3'] = 'Innlegg (alle roller)';
$string['statsreport4'] = 'All aktivitet (alle roller)';
$string['statsreport5'] = 'All aktivitet (visninger og innlegg)';
$string['statsreport7'] = 'Brukeraktivitet (visninger og innlegg)';
$string['statsreport8'] = 'All brukeraktivitet';
$string['statsreport9'] = 'Innlogginger (portalen)';
$string['statsreportactivity'] = 'All aktivitet (alle roller)';
$string['statsreportactivitybyrole'] = 'All aktivitet (visninger og innlegg)';
$string['statsreportforuser'] = 'for';
$string['statsreportlogins'] = 'Innlogginger';
$string['statsreportreads'] = 'Oversikt (lærer og student)';
$string['statsreporttype'] = 'Rapporttype';
$string['statsreportwrites'] = 'Bidrag (lærer og student)';
$string['statsstudentactivity'] = 'Studentaktivitet';
$string['statsstudentreads'] = 'Studentsidevisninger';
$string['statsstudentwrites'] = 'Studentbidrag';
$string['statsteacheractivity'] = 'Læreraktivitet';
$string['statsteacherreads'] = 'Læreroversikt';
$string['statsteacherwrites'] = 'Lærerbidrag';
$string['statstimeperiod'] = 'Tidsperiode - siste:';
$string['statsuniquelogins'] = 'Unike innlogginger';
$string['statsuseractivity'] = 'All aktivitet';
$string['statsuserlogins'] = 'Innlogginger';
$string['statsuserreads'] = 'Sidevisninger';
$string['statsuserwrites'] = 'Bidrag';
$string['statswrites'] = 'Innlegg';
$string['status'] = 'Status';
$string['statuschecks'] = 'Statussjekker';
$string['statuscritical'] = 'Kritisk';
$string['statuserror'] = 'Feil';
$string['statusinfo'] = 'Informasjon';
$string['statusna'] = 'I/T';
$string['statusok'] = 'OK';
$string['statusunknown'] = 'Ukjent';
$string['statuswarning'] = 'Advarsel';
$string['stringsnotset'] = 'Følgende er ikke definert i {$a}';
$string['studentnotallowed'] = 'Beklager, men du har ikke tilgang til dette kurset som \'{$a}\'';
$string['students'] = 'Studenter';
$string['studentsandteachers'] = 'Studenter og lærere';
$string['subcategories'] = 'Underkategorier';
$string['subcategory'] = 'Underkategori';
$string['subcategoryof'] = 'Underkategori til {$a}';
$string['subject'] = 'Emne';
$string['submit'] = 'Lagre endringer';
$string['success'] = 'Vellykket';
$string['successduration'] = 'Suksess ({$a} sekunder)';
$string['summary'] = 'Sammendrag';
$string['summary_help'] = 'Ideen med et sammendrag er en kort tekst for å forberede studentene på aktivitetene innen emnet eller uken. Teksten vises på kurssiden under seksjonsnavnet.';
$string['summaryof'] = 'Sammendrag av {$a}';
$string['suspended'] = 'Utestengt';
$string['suspendedusers'] = 'Utestengte brukere';
$string['switchdevicedefault'] = 'Bytt til standard design';
$string['switchdevicerecommended'] = 'Bytt til anbefalt design for din enhet';
$string['switchrolereturn'] = 'Returner til min vanlige rolle';
$string['switchroleto'] = 'Bytt rolle til ...';
$string['switchroleto_help'] = 'Velg en rolle for å få et innblikk i hvordan denne rollen vil oppleve kurset.

Vennligst merk at denne metoden ikke viser kurset helt eksakt likt som en denne rollen vil oppleve kurset (<a href="https://docs.moodle.org/en/Switch_roles">Klikk her for mer informasjon</a>).';
$string['tag'] = 'Tagg';
$string['tagalready'] = 'Denne taggen eksisterer fra før';
$string['tagmanagement'] = 'Legg til/slett tagger';
$string['tags'] = 'Tagger';
$string['targetrole'] = 'Målrolle';
$string['teacheronly'] = 'kun synlig for {$a}';
$string['teacherroles'] = '{$a} roller';
$string['teachers'] = 'Lærere';
$string['textcopiedtoclipboard'] = 'Tekst kopiert til utklippstavlen';
$string['textediting'] = 'Teksteditor';
$string['textediting_help'] = 'Når en HTML-editro som f.eks. Atto eller TinyMCE er valgt, vil tekstområder vises med en verktøylinje for å enkelt legge til innhold.

Når "Rent tekstområde" er valgt, vil tekstområder vises med en nedtrekksmeny der du kan velge mellom HTML eller Markdown som format for å legge inn tekst.

Listen med tilgjengelige teksteditorer bestemmes av administratoren.';
$string['texteditor'] = 'Bruk standard nettskjema';
$string['textellipsis'] = '{$a}...';
$string['textformat'] = 'Rent tekstformat';
$string['thanks'] = 'Takk';
$string['theme'] = 'Design';
$string['themepreviewdescription'] = '{$a} designbeskrivelse';
$string['themepreviewimage'] = '{$a} forhåndsvisningsbilde';
$string['themes'] = 'Design';
$string['themesaved'] = 'Nytt design lagret';
$string['therearecourses'] = 'Det er {$a} kurs';
$string['thereareno'] = 'Det er ingen {$a} i dette kurset.';
$string['thiscategory'] = 'Denne kategorien';
$string['thiscategorycontains'] = 'Denne kategorien inneholder';
$string['time'] = 'Tid';
$string['timecreated'] = 'Tid opprettet';
$string['timecreatedcourse'] = 'Tidspunkt for opprettelsen av kurset';
$string['timesplitting:deciles'] = 'Siste tidel';
$string['timesplitting:deciles_help'] = 'Dette analyseintervallet deler kurset inn i desentiler (10 like store deler), der hver forutsigelse er basert på dataene fra forrige desentil.';
$string['timesplitting:decilesaccum'] = 'Alle tidligere tideler';
$string['timesplitting:decilesaccum_help'] = 'Dette analyseintervallet deler kurset inn i desentiler (10 like store deler), der hver forutsigelse er basert på dataene fra hver av de tidligere desentilene.';
$string['timesplitting:nosplitting'] = 'Ingen tidsbegrensninger';
$string['timesplitting:nosplitting_help'] = 'Det er ikke spesifisert noe analyseintervall for denne modellen.';
$string['timesplitting:onemonthafterstart'] = 'en måned etter start';
$string['timesplitting:onemonthafterstart_help'] = 'Dette analyseintervallet genererer en prediksjon 1 måned etter den analyserbare starten.';
$string['timesplitting:oneweekafterstart'] = 'En uke etter start';
$string['timesplitting:oneweekafterstart_help'] = 'Dette analyseintervallet genererer en prediksjon 1 uke etter den analyserbare starten.';
$string['timesplitting:past3days'] = 'Siste 3 dager';
$string['timesplitting:past3days_help'] = 'Dette analyseintervallet genererer prediksjoner hver tredje dag. Indikatorberegningene vil baseres på de 3 siste dagene.';
$string['timesplitting:pastmonth'] = 'Siste måned';
$string['timesplitting:pastmonth_help'] = 'Dette analyseintervallet genererer prediksjoner hver måned. Indikatorberegningene vil baseres på den siste måneden.';
$string['timesplitting:pastweek'] = 'Siste uke';
$string['timesplitting:pastweek_help'] = 'Dette analyseintervallet genererer prediksjoner hver uke. Indikatorberegningene vil baseres på den siste uken.';
$string['timesplitting:quarters'] = 'Siste kvartal';
$string['timesplitting:quarters_help'] = 'Dette analyseintervallet deler kurset inn i kvartiler (4 like store deler), der hver forutsigelse er basert på dataene fra forrige kvartil.';
$string['timesplitting:quartersaccum'] = 'Alle forrige kvartaler';
$string['timesplitting:quartersaccum_help'] = 'Dette analyseintervallet  deler kurset inn i kvartiler (4 like store deler), der hver forutsigelse er basert på dataene fra hver av de tidligere kvartilene.';
$string['timesplitting:singlerange'] = 'Fra start til slutt';
$string['timesplitting:singlerange_help'] = 'Dette analyseintervallet anser kurset som en helhet uten å dele det opp.';
$string['timesplitting:tenpercentafterstart'] = '10% etter start';
$string['timesplitting:tenpercentafterstart_help'] = 'Dette analyseintervallet genererer en prediksjon etter at 10% av kurset er fullført.';
$string['timesplitting:upcoming3days'] = 'Neste 3 dager';
$string['timesplitting:upcoming3days_help'] = 'Dette analyseintervallet genererer prediksjoner hver tredje dag. Indikatorberegningene vil baseres på de 3 kommende dagene.';
$string['timesplitting:upcomingfortnight'] = 'De neste 14 dagene';
$string['timesplitting:upcomingfortnight_help'] = 'Dette analyseintervallet genererer prediksjoner annenhver uke. Indikatorberegningene vil baseres på de 2 kommende ukene.';
$string['timesplitting:upcomingweek'] = 'Kommende uke';
$string['timesplitting:upcomingweek_help'] = 'Dette analyseintervallet genererer prediksjoner hver uke. Indikatorberegningene vil baseres på den kommende uken.';
$string['timezone'] = 'Tidssone';
$string['to'] = 'Til';
$string['tocontent'] = 'Til element "{$a}"';
$string['tocreatenewaccount'] = 'Hopp over å lage ny brukerkonto';
$string['todate'] = 'Til';
$string['today'] = 'I dag';
$string['todaylogs'] = 'Dagens logger';
$string['toeveryone'] = 'til alle';
$string['toggleemojipicker'] = 'Vi emoji-velger';
$string['togglesearch'] = 'Veksle inndata for søk';
$string['toomanybounces'] = 'Post til den e-postadressen har kommet i retur så mange ganger at du <b>må</> skifte til en annen for å få fortsette.';
$string['toomanytags'] = 'Dette søket inkluderte for mange tagger; Noen kan ha blitt ignorert.';
$string['toomanytoshow'] = 'Det er for mange brukere til at alle kan vises';
$string['toomanyusersmatchsearch'] = 'For mange brukere ({$a->count}) samsvarte med  \'{$a->search}\'';
$string['toomanyuserstoshow'] = 'For mange brukere ({$a}) som kan vises';
$string['toonly'] = 'bare til {$a}';
$string['top'] = 'Topp';
$string['topic'] = 'Emne';
$string['topichide'] = 'Gjem dette emnet for {$a}';
$string['topicoutline'] = 'Emneoversikt';
$string['topicshow'] = 'Vis dette emnet til {$a}';
$string['toplevelcategory'] = 'Kategori på toppnivå';
$string['torecipient'] = 'Til';
$string['total'] = 'Totalt';
$string['totopofsection'] = 'Til toppen av seksjonen "{$a}"';
$string['trackforums'] = 'Hold orden på foruminnlegg';
$string['trackforumsno'] = 'Nei: Ikke hold styring på innleggene jeg har sett';
$string['trackforumsyes'] = 'Ja: Marker nye innlegg for meg';
$string['trysearching'] = 'Prøv å søke isteden';
$string['turneditingoff'] = 'Slå redigering av';
$string['turneditingon'] = 'Slå redigering på';
$string['unabletocopytoclipboard'] = 'Kunne ikke kopiere tekst til utklippstavlen';
$string['unauthorisedlogin'] = 'Brukerkontoen "{$a}" er ikke tilgjengelig på denne portalen.';
$string['undecided'] = 'Ubestemt';
$string['unexistingcmid'] = 'Kursmodul-ID ikke funnet';
$string['unexistingsectionid'] = 'Kursseksjons-ID ikke funnet';
$string['unfinished'] = 'Uavsluttet';
$string['unknowncategory'] = 'Ukjent kategori';
$string['unknownerror'] = 'Ukjent feil';
$string['unknownuser'] = 'Ukjent bruker';
$string['unlimited'] = 'Ubegrenset';
$string['unpacking'] = 'Pakker ut {$a}';
$string['unsafepassword'] = 'Usikkert passord - prøv et annet';
$string['untilcomplete'] = 'Til den er ferdig';
$string['unusedaccounts'] = 'Kontoer som ikke er tatt i bruk innen {$a} dager blir automatisk slettet';
$string['unzip'] = 'Pakk opp zip-fil';
$string['unzippingbackup'] = 'Pakker opp sikkerhetskopi';
$string['up'] = 'Opp';
$string['update'] = 'Oppdater';
$string['updated'] = 'Oppdatert {$a}';
$string['updatemymoodleoff'] = 'Avslutt redigering av denne siden';
$string['updatemymoodleon'] = 'Tilpass denne siden';
$string['updatemyprofile'] = 'Oppdater profilen';
$string['updatesevery'] = 'Oppdaterer hvert {$a} sekund';
$string['updatethis'] = 'Oppdater {$a}';
$string['updatethiscourse'] = 'Oppdater dette kurset';
$string['updatinga'] = 'Oppdaterer {$a}';
$string['updatingain'] = 'Oppdaterer {$a->what} i {$a->in}';
$string['upload'] = 'Laste opp';
$string['uploadafile'] = 'Laste opp ei fil';
$string['uploadcantwrite'] = 'Fillagringen mislykkes';
$string['uploadedfile'] = 'Fila ble lastet opp uten feil';
$string['uploadedfileto'] = 'Lastet opp {$a->file} til {$a->directory}';
$string['uploadedfiletoobig'] = 'Beklager, men den fila er for stor(grensen er på {$a} bytes)';
$string['uploadextension'] = 'Filopplastingen ble stoppet på grunn av PHP-filtypen.';
$string['uploadfailednotrecovering'] = 'Filopplastingen var mislykka fordi det var et problem med en av filene, {$a->name}.<br />Her finner du en logg over problemene: <br />{$a->problem}</br>';
$string['uploadfilelog'] = 'Last opp logg for fila {$a}';
$string['uploadformlimit'] = 'Den opplastede fila {$a} var større enn maksimumsgrensen som ble satt i skjemaet.';
$string['uploadlabel'] = 'Tittel:';
$string['uploadlimitwithsize'] = '{$a->contextname} opplastingsgrense ({$a->displaysize})';
$string['uploadnewfile'] = 'Last opp ny fil';
$string['uploadnofilefound'] = 'Fant ingen filer. Er du sikker på at du valgte ei?';
$string['uploadnotallowed'] = 'Det er ikke lov å laste opp';
$string['uploadnotempdir'] = 'Mangler tilgang til midlertidig mappe.';
$string['uploadoldfilesdeleted'] = 'Den gamle filen i opplastingsområdet ditt ble slettet/De gamle filene i opplastingsområdet ditt ble slettet.';
$string['uploadpartialfile'] = 'Filen ble bare delvis lastet opp.';
$string['uploadproblem'] = 'Det oppstod et problem under opplasting av filen \'{$a}\'  (kanskje den var for stor?)';
$string['uploadrenamedchars'] = 'Filen ble døpt om fra {$a->oldname} til {$a->newname} på grunn av ugyldige tegn.';
$string['uploadrenamedcollision'] = 'Filen ble døpt om fra {$a->oldname} til {$a->newname} fordi det allerede fantes en fil med det navnet.';
$string['uploadserverlimit'] = 'Den opplastede filen var større enn maksimal  størrelse for opplasting på denne tjenermaskina.';
$string['uploadthisfile'] = 'Last opp denne filen';
$string['url'] = 'URL';
$string['used'] = 'Brukt';
$string['usedinnplaces'] = 'Brukt {$a} steder';
$string['user'] = 'Bruker';
$string['useraccount'] = 'Brukerkonto';
$string['useractivity'] = 'Aktivitet';
$string['userconfirmed'] = 'Bekreftet {$a}';
$string['userdata'] = 'Brukerdata';
$string['userdeleted'] = 'Denne brukeren er slettet';
$string['userdescription'] = 'Skriv litt om deg selv';
$string['userdescription_help'] = 'Denne boksen lar deg skrive inn noe tekst om deg selv. Andre kan se hva du skriver inn her.';
$string['userdetails'] = 'Brukerdetaljer';
$string['userfiles'] = 'Brukerfiler';
$string['userlist'] = 'Brukerliste';
$string['usermatchedon'] = 'Denne brukeren matcher søket via følgende felt';
$string['usermenu'] = 'Brukermeny';
$string['usermenugoback'] = 'Gå tilbake til brukermeny';
$string['username'] = 'Brukernavn';
$string['usernameemail'] = 'Brukernavn eller e-post';
$string['usernameemailmatch'] = 'Brukernavnet og passordet tilhører ikke samme bruker';
$string['usernameexists'] = 'Dette brukernavnet finnes allerede, vennligst velg et annet';
$string['usernamelowercase'] = 'Kun små bokstaver tillatt';
$string['usernamenotfound'] = 'Fant ikke brukernavnet i databasen';
$string['usernameoremail'] = 'Enten brukernavn eller e-postadresse';
$string['usernotconfirmed'] = 'Kunne ikke bekrefte {$a}';
$string['userpic'] = 'Brukerbilde';
$string['userpreferences'] = 'Brukerpreferanser';
$string['users'] = 'Brukere';
$string['userselectorautoselectunique'] = 'Dersom bare ett treff, velg treffet automatisk';
$string['userselectorpreserveselected'] = 'Behold valgte brukere, selv om de ikke lenger samsvarer med søket';
$string['userselectorsearchanywhere'] = 'Hvor som helst';
$string['userselectorsearchexactmatchonly'] = 'bare nøyaktige treff';
$string['userselectorsearchfromstart'] = 'fra start';
$string['userselectorsearchmatching'] = 'Treff:';
$string['usersnew'] = 'Nye brukere';
$string['usersnoaccesssince'] = 'Inaktiv i minst';
$string['userswithfiles'] = 'Brukerfiler';
$string['useruploadtype'] = 'Opplastingstype for brukere: {$a}';
$string['userzones'] = 'Brukersoner';
$string['usetheme'] = 'Bruk design';
$string['usingexistingcourse'] = 'Bruker eksisterende kurs';
$string['validatehtml'] = 'Validér HTML';
$string['valuealreadyused'] = 'Denne verdien er allerede i bruk';
$string['version'] = 'Versjon';
$string['view'] = 'Visning';
$string['viewallcourses'] = 'Vis alle kurs';
$string['viewallcoursescategories'] = 'Vis alle kurs og kategorier';
$string['viewallresults'] = 'Se alle resultater ({$a})';
$string['viewallsubcategories'] = 'Vis alle underkategorier';
$string['viewfileinpopup'] = 'Vis filen i et popup-vindu';
$string['viewing'] = 'Visning';
$string['viewmore'] = 'Vis flere';
$string['viewprofile'] = 'Vis profilen';
$string['viewresults'] = 'Se resultater for ({$a})';
$string['views'] = 'Visninger';
$string['viewsolution'] = 'vis løsning';
$string['visible'] = 'Synlig';
$string['visible_help'] = 'Dette alternativet lar deg skjule studiesidene dine fullstendig.

Siden blir ikke vist i kursoversikten (bortsett fra for lærere og
administratorer på portalen).

Selv om studenter eller andre prøver å finne siden direkte via dens nettadresse (URL) får de likevel ikke tilgang.';
$string['visibletostudents'] = 'Synlig for {$a}';
$string['warning'] = 'Advarsel';
$string['warningdeleteresource'] = 'Advarsel: {$a} blir referert til i en ressurs. Vil du oppdatere ressursen?';
$string['wcagcheck'] = 'Web Content Accessibility Guidelines (WCAG) sjekk';
$string['webpage'] = 'Webside';
$string['week'] = 'Uke';
$string['weekhide'] = 'Gjem denne uken for {$a}';
$string['weeklyoutline'] = 'Ukeformat';
$string['weeks'] = 'uker';
$string['weekshow'] = 'Vis denne uken til {$a}';
$string['welcomeback'] = 'Velkommen, {$a->firstname}! 👋';
$string['welcometocourse'] = 'Velkommen til {$a}';
$string['welcometocoursetext'] = 'Hei!

Dette er en bekreftelse på at du er påmeldt kurset {$a->coursename}.';
$string['welcometosite'] = 'Velkommen {$a->firstname}! 👋';
$string['whatforlink'] = 'Hva vil du gjøre med lenken?';
$string['whatforpage'] = 'Hva vil du gjøre med teksten?';
$string['whatisyourage'] = 'Hvor gammel er du?';
$string['whattocallzip'] = 'Hva vil du kalle zip-fila?';
$string['whattodo'] = 'Hva skal du gjøre';
$string['wheredoyoulive'] = 'I hvilket land bor du?';
$string['whyisthisrequired'] = 'Hvorfor er dette påkrevd?';
$string['windowclosing'] = 'Dette vinduet skulle stenges automatisk. Dersom ikke, steng det nå.';
$string['withchosenfiles'] = 'Med valgte filer';
$string['withdisablednote'] = '{$a} (deaktivert)';
$string['withoutuserdata'] = 'uten brukerdata';
$string['withselectedusers'] = 'Med valgte brukere';
$string['withuserdata'] = 'med brukerdata';
$string['wontrunfuturescheduledtask'] = 'Vil ikke kjøre oppgave som ikke har mislyktes og som er planlagt å kjøre i fremtiden';
$string['wordforstudent'] = 'Ditt ord for student';
$string['wordforstudenteg'] = 'eks. student, elev osv.';
$string['wordforstudents'] = 'Ditt ord for studenter';
$string['wordforstudentseg'] = 'eks. studenter, elever osv.';
$string['wordforteacher'] = 'Ditt ord for lærer';
$string['wordforteachereg'] = 'eks. lærer, veileder, moderator osv.';
$string['wordforteachers'] = 'Ditt ord for lærere';
$string['wordforteacherseg'] = 'eks. lærere, veiledere, moderatorer osv.';
$string['writingblogsinfo'] = 'Skriver blogginfo';
$string['writingcategoriesandquestions'] = 'Skriver kategorier og spørsmål';
$string['writingcoursedata'] = 'Skriver kursdata';
$string['writingeventsinfo'] = 'Skriver info om hendelser';
$string['writinggeneralinfo'] = 'Skriver generell info';
$string['writinggradebookinfo'] = 'Skriver karakterbokinfo';
$string['writinggroupingsgroupsinfo'] = 'Skriver info om tilgangsgrupper - grupper';
$string['writinggroupingsinfo'] = 'Skriver info om tilgangsgrupper';
$string['writinggroupsinfo'] = 'Skriver gruppeinfo';
$string['writingheader'] = 'Skriver overskrift';
$string['writingloginfo'] = 'Skriver logginfo';
$string['writingmessagesinfo'] = 'Skriver meldingsinfo';
$string['writingmoduleinfo'] = 'Skriver modulinfo';
$string['writingscalesinfo'] = 'Skriver info om skalaer';
$string['writinguserinfo'] = 'Skriver brukerinfo';
$string['wrongpassword'] = 'Feil passord til dette brukernavnet';
$string['year'] = 'år';
$string['years'] = 'år';
$string['yes'] = 'Ja';
$string['youareabouttocreatezip'] = 'Du holder på å lage ei zip-fil som inneholder';
$string['youaregoingtorestorefrom'] = 'Du tilbakefører fra';
$string['youhaveupcomingactivitiesdue'] = 'Du har kommende aktiviteter';
$string['youhaveupcomingactivitiesdueinfo'] = 'Hei {$a},

<br/><br/>Fristen for å gjøre følgende aktiviteter går snart ut:';
$string['youneedtoenrol'] = 'For å utføre denne handlingen må du være påmeldt i dette kurset.';
$string['yourlastlogin'] = 'Du var sist innlogget';
$string['yourself'] = 'deg selv';
$string['yourteacher'] = 'din {$a}';
$string['yourwordforx'] = 'Ditt ord for \'{$a}\'';
$string['zippingbackup'] = 'Pakker sikkerhetskopi';
