<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'backup', language 'hu', version '4.4'.
 *
 * @package     backup
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['asyncbackupcomplete'] = 'A biztonsági mentés befejeződött';
$string['asyncbackupcompletebutton'] = 'Tovább';
$string['asyncbackupcompletedetail'] = 'A biztonsági mentés sikeresen véget ért.  <br/> A biztonsági mentést eléri a <a href="{$a}">helyreállítási oldalon.</a>';
$string['asyncbackuperror'] = 'A biztonsági mentés nem sikerült';
$string['asyncbackuperrordetail'] = 'A biztonsági mentés nem sikerült. Forduljon a rendszergazdához!';
$string['asyncbackuppending'] = 'A biztonsági mentés függőben';
$string['asyncbackupprocessing'] = 'A biztonsági mentés folyamatban';
$string['asyncbadexecution'] = 'Hibás a biztonsági mentés vezérlése, a(z) {$a} értéke 2 legyen!';
$string['asynccheckprogress'] = 'A folyamatot bármikor ellenőrizheti a <a href="{$a}">helyreállítási oldalon.</a>';
$string['asyncemailenable'] = 'Értesítések bekapcsolása';
$string['asyncemailenabledetail'] = 'Bekapcsolása esetén a felhasználók értesítést kapnak, ha egy aszinkron helyreállítási/biztonsági mentési folyamat véget ér.';
$string['asyncgeneralsettings'] = 'Aszinkron helyreállítás/biztonsági mentés';
$string['asyncmessagebody'] = 'Értesítés';
$string['asyncmessagebodydefault'] = 'A(z) {operation} (ID: {backupid}) sikeresen véget ért. Itt megtekintheti: <a href="{link}">{link}</a>.';
$string['asyncmessagebodydetail'] = 'Az aszinkron helyreállítási/biztonsági mentési folyamat végén küldendő értesítés.';
$string['asyncmessagesubject'] = 'Tárgy';
$string['asyncmessagesubjectdefault'] = 'A Moodle {operation} siekresen véget ért';
$string['asyncmessagesubjectdetail'] = 'Értesítés tárgya';
$string['asyncnowait'] = 'Nem szükséges várakozni, a folyamat a háttérben folytatódik.';
$string['asyncprocesspending'] = 'Folyamat függőben';
$string['asyncrestorecomplete'] = 'A helyreállítás véget ért';
$string['asyncrestorecompletebutton'] = 'Tovább';
$string['asyncrestorecompletedetail'] = 'A helyreállítás sikeresen véget ért. A Tovább gombra kattintva áttérhet a  <a href="{$a}">helyreállított elem kurzusa</a> pontra.';
$string['asyncrestoreerror'] = 'A helyreállítás nem sikerült';
$string['asyncrestoreerrordetail'] = 'A helyreállítás nem sikerült. Forduljon a rendszergazdához!';
$string['asyncrestoreinprogress'] = 'Helyreállítás folyamatban';
$string['asyncrestoreinprogress_help'] = 'Itt láthatók az aszinkron kurzus-helyreállítások.';
$string['asyncrestorepending'] = 'A helyreállítás függőben';
$string['asyncrestoreprocessing'] = 'A helyreállítás folyamatban';
$string['asyncreturn'] = 'Vissza a kurzushoz';
$string['autoactivedescription'] = 'Döntse el, legyen-e automatikus biztonsági mentés. Ha a kézit választja, az automatikus biztonsági mentés csak az automatikus biztonsági mentési CLI-kódon keresztül lesz elérhető. Ezt vagy kézi úton a parancssorból, vagy a cronon keresztül használhatja.';
$string['autoactivedisabled'] = 'Kikapcsolva';
$string['autoactiveenabled'] = 'Bekapcsolva';
$string['autoactivemanual'] = 'Kézi';
$string['automatedbackupschedule'] = 'Ütemezés';
$string['automatedbackupschedulehelp'] = 'Válassza ki, mely napokon kerüljön sorra az automatikus biztonsági mentés.';
$string['automatedbackupsinactive'] = 'A portál rendszergazdája nem kapcsolta be az automatikus biztonsági mentést.';
$string['automatedbackupstatus'] = 'Az automatikus biztonsági mentés állapota';
$string['automateddeletedays'] = 'Ennél régebbi biztonsági mentések törlése';
$string['automatedmaxkept'] = 'Megtartandó biztonsági mentések száma';
$string['automatedmaxkepthelp'] = 'Megadja az egyes kurzusokról frissen készült megtartandó biztonsági mentések maximális számát. A régebbiek automatikusan törlődnek.';
$string['automatedminkept'] = 'Megtartandó biztonsági mentések minimális száma';
$string['automatedminkepthelp'] = 'A megadott napnál régebbi biztonsági mentések  törlődnek. Előfordulhat, hogy egy nem aktív kurzusról nem készül biztonsági mentés. Ennek elkerülésére minimális számú biztonsági mentést kell megadni.';
$string['automatedsettings'] = 'Az automatikus biztonsági mentés beállításai';
$string['automatedsetup'] = 'Az automatikus biztonsági mentés beállítása';
$string['automatedstorage'] = 'Az automatikus biztonsági mentés tárolása';
$string['automatedstoragehelp'] = 'Válassza ki az automatikus biztonsági mentés tárolásának helyét.';
$string['backupactivity'] = 'Biztonsági mentéshez kapcsolódó tevékenység: {$a}';
$string['backupcourse'] = 'Biztonsági mentés erről a kurzusról: {$a}';
$string['backupcoursedetails'] = 'A kurzus adatai';
$string['backupcoursesection'] = 'Fejezet: {$a}';
$string['backupcoursesections'] = 'Kurzusfejezetek';
$string['backupdate'] = 'Teljesítés dátuma';
$string['backupdetails'] = 'A biztonsági mentés részletei';
$string['backupdetailsnonstandardinfo'] = 'A kiválasztott állomány nem a Moodle szokásos biztonsági mentési állománya. A helyreállítási folyamat megpróbálja először átalakítani a szokásos formába, majd helyreállítani az állományt.';
$string['backupfile'] = 'Biztonsági mentés';
$string['backupformat'] = 'Forma';
$string['backupformatimscc1'] = 'IMS Common Cartridge 1.0';
$string['backupformatimscc11'] = 'IMS Common Cartridge 1.1';
$string['backupformatmoodle1'] = 'Moodle 1';
$string['backupformatmoodle2'] = 'Moodle 2';
$string['backupformatunknown'] = 'Ismeretlen forma';
$string['backuplog'] = 'Műszaki adatok és figyelmeztetések';
$string['backupmode'] = 'Mód';
$string['backupmode10'] = 'Általános';
$string['backupmode20'] = 'Importálás';
$string['backupmode30'] = 'Elosztó';
$string['backupmode40'] = 'Ugyanaz a portál';
$string['backupmode50'] = 'Automatikus';
$string['backupmode60'] = 'Átalakított';
$string['backupmode70'] = 'Aszinkron';
$string['backupsection'] = 'Biztonsági mentés erről a kurzusfejezetről: {$a}';
$string['backupsettings'] = 'A biztonsági mentés beállításai';
$string['backupsitedetails'] = 'Portál adatai';
$string['backupstage16action'] = 'Tovább';
$string['backupstage1action'] = 'Következő';
$string['backupstage2action'] = 'Következő';
$string['backupstage4action'] = 'Biztonsági mentés végrehajtása';
$string['backupstage8action'] = 'Tovább';
$string['backupthenrestore'] = 'A biztonsági mentés megtörtént. Visszaállítás megkezdése.';
$string['backuptype'] = 'Típus';
$string['backuptypeactivity'] = 'Tevékenység';
$string['backuptypecourse'] = 'Kurzus';
$string['backuptypesection'] = 'Rész';
$string['backupversion'] = 'Biztonsági mentés verziója';
$string['cannotfindassignablerole'] = 'A biztonsági mentés állományában lévő {$a} szerep az Ön által hozzárendelhető szerepek egyikével sem azonosítható.';
$string['choosefilefromactivitybackup'] = 'Tevékenység biztonsági mentésének területe';
$string['choosefilefromactivitybackup_help'] = 'A tevékenységhez tartozó biztonsági mentések.';
$string['choosefilefromautomatedbackup'] = 'Automatikus biztonsági mentések';
$string['choosefilefromautomatedbackup_help'] = 'Az automatikusan létrehozott biztonsági mentések.';
$string['choosefilefromcoursebackup'] = 'A kurzus biztonsági mentésének területe';
$string['choosefilefromcoursebackup_help'] = 'A kurzushoz tartozó biztonsági mentések.';
$string['choosefilefromuserbackup'] = 'Saját biztonsági mentések területe';
$string['choosefilefromuserbackup_help'] = 'Személyes biztonsági mentések minden kurzushoz, anonimizált felhasználói adatokkal.';
$string['config_keep_groups_and_groupings'] = 'Alapesetben megtartja a mostani csoportokat és csoportosításokat.';
$string['config_keep_roles_and_enrolments'] = 'Alapesetben megtartja a mostani szerepeket és beiratkozásokat.';
$string['config_overwrite_conf'] = 'Aktuális kurzusbeállítás felülírásának engedélyezése';
$string['config_overwrite_course_fullname'] = 'Alapesetben felülírja a kurzus teljes címét egy másolatbeli címmel. Ehhez be kell jelölni a "Kurzusbeállítás felülírása" pontot és az aktuális felhasználónak jogosultnak kell lenni a kurzus teljes címének a módosítására  (moodle/course:changefullname)';
$string['config_overwrite_course_shortname'] = 'Alapesetben felülírja a kurzus rövid címét egy másolatbeli címmel. Ehhez be kell jelölni a "Kurzusbeállítás felülírása" pontot és az aktuális felhasználónak jogosultnak kell lenni a kurzus rövid címének  a módosítására  (moodle/course:changeshortname)';
$string['config_overwrite_course_startdate'] = 'Alapesetben felülírja a kurzus kezdési időpontját egy másolatbeli időponttal. Ehhez be kell jelölni a "Kurzusbeállítás felülírása" pontot és az aktuális felhasználónak jogosultnak kell lenni a helyreállítási kurzusidőpontoknak a görgetésére  (moodle/restore:rolldates)';
$string['configgeneralactivities'] = 'Beállítja, alapesetben bekerülnek-e a tevékenységek a biztonsági mentésbe.';
$string['configgeneralanonymize'] = 'Bejelölése esetén alaphelyzetben minden felhasználói adatot elrejt';
$string['configgeneralbadges'] = 'Beállítja, alapesetben bekerülnek-e a kitűzők a biztonsági mentésbe.';
$string['configgeneralblocks'] = 'Beállítja, alapesetben bekerülnek-e a blokkok a biztonsági mentésbe.';
$string['configgeneralcalendarevents'] = 'Beállítja, alapesetben bekerülnek-e a naptáresemények a biztonsági mentésbe';
$string['configgeneralcomments'] = 'Beállítja, alapesetben bekerülnek-e a megjegyzések a biztonsági mentésbe.';
$string['configgeneralcompetencies'] = 'Beállítja, alapesetben bekerülnek-e a készségek a biztonsági mentésbe';
$string['configgeneralcontentbankcontent'] = 'Beállítja, alapesetben bekerül-e tartalombank a biztonsági mentésbe.';
$string['configgeneralfiles'] = 'Beállítja, alapesetben bekerülnek-e az állományok a biztonsági mentésbe. Ne feledje: kikapcsolása esetén a biztonsági mentésbe csak az állományokra mutató hivatkozások kerülnek bele. Ez nem gond, ha a helyreállítás ugyanazon a portálon történik és nem kerül sor a \'Kukában lévő állományok törlése\' használatára (filescleanupperiod).';
$string['configgeneralfilters'] = 'Beállítja, alapesetben bekerülnek-e a szűrők a biztonsági mentésbe.';
$string['configgeneralgroups'] = 'Beállítja, alapesetben bekerülnek-e csoportok és csoportosítások a biztonsági mentésbe.';
$string['configgeneralhistories'] = 'Beállítja, alapesetben bekerülnek-e a felhasználói előzmények a biztonsági mentésbe.';
$string['configgenerallogs'] = 'Bejelölése esetén alaphelyzetben a naplók bekerülnek a biztonsági mentésbe.';
$string['configgeneralpermissions'] = 'Bekapcsolása esetén a szerepengedélyek importálására kerül sor. Ez felülírhatja a meglévő engedélyeket.';
$string['configgeneralquestionbank'] = 'Bekapcsolása esetén a kérdésbank alapesetben bekerül a biztonsági mentésekbe. FIGYELEM! Kikapcsolásával a kérdésbankot használó tevékenységek, pl. a teszt, nem kerül bele a biztonsági mentésekbe!';
$string['configgeneralroleassignments'] = 'Bejelölése esetén alaphelyzetben a szerep-hozzárendelések is bekerülnek a biztonsági mentésbe.';
$string['configgeneralusers'] = 'Beállítja, alapesetben bekerülnek-e a felhasználók a biztonsági mentésbe.';
$string['configgeneraluserscompletion'] = 'Bejelölése esetén alaphelyzetben a felhasználói teljesítés adatai is bekerülnek a biztonsági mentésbe.';
$string['configlegacyfiles'] = 'Beállítja, alapesetben bekerülnek-e a korábbi kurzusállományok a biztonsági mentésbe.. A Moodle 2.0 előtti kurzusállományok minősülnek korábbi kurzusállományoknak.';
$string['configloglifetime'] = 'Itt adja meg a biztonsági mentések megőrizendő naplózásának időtartamát. Az ennél régebbi naplókat a rendszer automatikusan törli. Lehetőleg rövid időt állítson be, mert ez a naplózás igen terjedelmesre duzzadhat.';
$string['configrestoreactivities'] = 'Beállítja az alapesetet a tevékenységek helyreállításához.';
$string['configrestorebadges'] = 'Beállítja az alapesetet a kitűzők helyreállításához.';
$string['configrestoreblocks'] = 'Beállítja az alapesetet a blokkok helyreállításához.';
$string['configrestorecalendarevents'] = 'Beállítja az alapesetet a naptáresemények helyreállításához.';
$string['configrestorecomments'] = 'Beállítja az alapesetet a megjegyzések helyreállításához.';
$string['configrestorecompetencies'] = 'Beállítja az alapesetet a készségek helyreállításához.';
$string['configrestorecontentbankcontent'] = 'Beállítja az alapesetet a tartalombank helyreállításához.';
$string['configrestoreenrolments'] = 'Beállítja az alapesetet a beiratkozási módszerek helyreállításához.';
$string['configrestorefilters'] = 'Beállítja az alapesetet a szűrők helyreállításához.';
$string['configrestoregroups'] = 'Beállítja az alapesetet a csoportok és csoportosítások helyreállításhoz, ha azok szerepelnek a biztonsági mentésben.';
$string['configrestorehistories'] = 'Beállítja az alapesetet a felhasználói előzmények helyreállításához, ha azok szerepelnek a biztonsági mentésben.';
$string['configrestorelogs'] = 'Bekapcsolása esetén a naplókat alapesetben helyreállítja, ha azok szerepelnek a biztonsági mentésben.';
$string['configrestorepermissions'] = 'Bekapcsolása esetén a szerepengedélyek helyreállnak. Ez felülírhatja a meglévő engedélyeket.';
$string['configrestoreroleassignments'] = 'Bekapcsolása esetén alapesetben helyreállítja a szerepek hozzárendelését, ha az szerepel a biztonsági mentésben.';
$string['configrestoreusers'] = 'Beállítja az alapesetet a felhasználók helyreállításához, ha azok szerepelnek a biztonsági mentésben.';
$string['configrestoreuserscompletion'] = 'Bekapcsolása esetén alapesetben helyreállítja a felhasználói teljesítésről szóló információt, ha az szerepel a biztonsági mentésben.';
$string['confirmcancel'] = 'Biztonsági mentés törlése';
$string['confirmcancelimport'] = 'Importálás törlése';
$string['confirmcancelno'] = 'Ne törölje';
$string['confirmcancelquestion'] = 'Biztosan törli? Ezzel minden megadott adat elvész.';
$string['confirmcancelrestore'] = 'Helyreállítás törlése';
$string['confirmcancelyes'] = 'Biztonsági mentés törlése';
$string['confirmnewcoursecontinue'] = 'Figyelmeztetés új kurzusra';
$string['confirmnewcoursecontinuequestion'] = 'A kurzus-helyreállítási folyamat során ideiglenes (rejtett) kurzus jön létre. A folyamat megszakításához kattintson a Mégse gombra. A helyreállítás alatt ne zárja be a böngészőt.';
$string['copiesinprogress'] = 'A kurzus másolása folyamatban. <a href="{$a}"> Tekintse meg a folyamatban lévő másolatokat. </a>';
$string['copycoursedesc'] = 'Másolat készítése a kurzusról bármely kurzuskategóriába.';
$string['copycourseheading'] = 'Kurzus másolása';
$string['copycoursetitle'] = 'A(z) {$a} kurzus másolása';
$string['copydest'] = 'Cél';
$string['copyfieldnotfound'] = 'Nem található adat az alábbi kötelező mező(k)nél: {$a}';
$string['copyformfail'] = 'Az Ajax kurzusmásolási űrlap leadása sikertelen.';
$string['copyingcourse'] = 'Kurzus másolása folyamatban';
$string['copyingcourseshortname'] = 'másolás';
$string['copyop'] = 'Aktuális művelet';
$string['copyprogressheading'] = 'Kurzusmásolás folyamatban';
$string['copyprogressheading_help'] = 'Ez a táblázat az összes befejezetlen kurzusmásolat állapotát mutatja.';
$string['copyprogresstitle'] = 'Kurzusmásolás előrehaladása';
$string['copyreturn'] = 'Másolás és visszatérés';
$string['copysource'] = 'Forrás';
$string['copyview'] = 'Másolás és megtekintés';
$string['coursecategory'] = 'A visszaállítandó kurzusok kategóriája';
$string['courseid'] = 'Eredeti azonosító';
$string['coursesettings'] = 'Kurzusbeállítások';
$string['coursetitle'] = 'Cím';
$string['currentstage1'] = 'Kezdő beállítások';
$string['currentstage16'] = 'Kész';
$string['currentstage2'] = 'Sémabeállítások';
$string['currentstage4'] = 'Megerősítés és ellenőrzés';
$string['currentstage8'] = 'Biztonsági mentés végrehajtása';
$string['enableasyncbackup'] = 'Aszinkron biztonsági mentések bekapcsolása';
$string['enableasyncbackup_help'] = 'Bekapcsolása esetén minden biztonsági mentés és helyreállítás aszinkron módon történik. Ez jobb felhasználói élményt nyújt, lehetővé téve a felhasználóknak egyéb műveletek végrehajtását amíg a mentés vagy a visszaállítás zajlik. Nem érinti az importálási és exportálási műveleteket.';
$string['enterasearch'] = 'Adjon meg egy keresést.';
$string['error_block_for_module_not_found'] = 'Egyedüli blokkpéldány (azonosítója: {$a->bid}) fordul elő a kurzusmodulban (azonosítója: {$a->mid}). A blokkról nem készül biztonsági másolat.';
$string['error_course_module_not_found'] = 'Egyedüli blokkpéldány (azonosítója: {$a->bid}) fordul elő. A blokkról nem készül biztonsági másolat.';
$string['errorcopyingbackupfile'] = 'Helyreállítás előtt nem sikerült a biztonsági mentést az ideiglenes könyvtárba másolni.';
$string['errorfilenamemustbezip'] = 'A megadandó állománynak tömörítettnek és .zip kiterjesztésűnek kell lenni ';
$string['errorfilenamerequired'] = 'A biztonsági mentéshez érvényes állománynevet kell megadnia';
$string['errorfilenametoolong'] = 'Az állománynév nem lehet hosszabb 255 karakternél.';
$string['errorinvalidformat'] = 'Ismeretlen formájú biztonsági mentés';
$string['errorinvalidformatinfo'] = 'A kiválasztott állomány nem a Moodle szokásos biztonsági mentési állománya, helyreállítása nem lehetséges.';
$string['errorminbackup20version'] = 'A biztonsági mentés állománya a Moodle biztonsági mentésének egy fejlesztési változatával ({$a->backup}) készült. A minimálisan használandó változat: {$a->min}. A visszaállítás nem sikerült.';
$string['errorrestorefrontpagebackup'] = 'A kezdőoldalon csak kezdőoldali mentéseket állíthat helyre.';
$string['executionsuccess'] = 'A biztonsági mentés állományának létrehozása sikerült. ';
$string['extractingbackupfileto'] = 'Biztonsági mentés visszaállításának helye: {$a}';
$string['failed'] = 'A biztonsági mentés nem sikerült';
$string['filealiasesrestorefailures'] = 'Névhelyettesítők a hibák helyreállításához';
$string['filealiasesrestorefailures_help'] = 'A névhelyettesítők szimbolikus hivatkozások más fájlokra, beleértve a külső tárolókban tároltakat. Néhány esetben a Moodle nem tudja helyreállítani őket - például amikor egy másik portálon lévő állományok biztonsági mentésének a visszaállítására kerül sor, vagy ha a hivatkozott fájl nem létezik.

További részletekről és a hiba okáról a helyreállítást naplózó fájlból tájékozódhat.';
$string['filealiasesrestorefailures_link'] = 'restore/filealiases';
$string['filealiasesrestorefailuresinfo'] = 'A biztonsági mentésben szereplő néhány névhelyettesítőt nem sikerült helyreállítani. Az alábbi felsorolás tartalmazza feltételezett helyüket és az eredeti portálon általuk hivatkozott forrásfájlt.';
$string['filename'] = 'Állománynév';
$string['filereferencesincluded'] = 'A biztonsági mentésben külső tartalmakra való állományhivatkozások szerepelnek. Ezek helyreállítása más portálokon nem fog működni.';
$string['filereferencesnotsamesite'] = 'A biztonsági mentés másik portálról származik, az állományhivatkozásokat nem lehet helyreállítani.';
$string['filereferencessamesite'] = 'A biztonsági mentés erről a portálról származik, az állományhivatkozásokat helyre lehet állítani.';
$string['generalactivities'] = 'Tevékenységekkel és tananyagokkal együtt';
$string['generalanonymize'] = 'Adatok elrejtése';
$string['generalbackdefaults'] = 'A biztonsági mentés általános alapbeállításai';
$string['generalbadges'] = 'Kitűzők hozzáadása';
$string['generalblocks'] = 'Blokkokkal együtt';
$string['generalcalendarevents'] = 'Szerepeljenek a naptáresemények';
$string['generalcomments'] = 'Megjegyzésekkel együtt';
$string['generalcompetencies'] = 'Szerepeljenek a készségek';
$string['generalcontentbankcontent'] = 'A tartalombank tartalmával együtt';
$string['generalenrolments'] = 'Szerepeljenek a beiratkozási módszerek';
$string['generalfiles'] = 'Állományok hozzáadása';
$string['generalfilters'] = 'Szűrőkkel együtt';
$string['generalgradehistories'] = 'Előzményekkel együtt';
$string['generalgroups'] = 'csoportok és csoportosítások felvétele';
$string['generalhistories'] = '	
Előzményekkel együtt';
$string['generallegacyfiles'] = 'Korábbi kurzusállományok bevonása';
$string['generallogs'] = 'Naplókkal együtt';
$string['generalpermissions'] = 'Engedély-felülírások megőrzése';
$string['generalquestionbank'] = 'A kérdésbank legyen része';
$string['generalrestoredefaults'] = 'A helyreállítás általános alapértékei';
$string['generalrestoresettings'] = 'A helyreállítás általános beállításai';
$string['generalroleassignments'] = 'Szerep-hozzárendelésekkel együtt';
$string['generalsettings'] = 'Biztonsági mentések általános beállításai';
$string['generalusers'] = 'Felhasználókkal együtt';
$string['generaluserscompletion'] = 'A felhasználói teljesítés adataival együtt';
$string['hidetypes'] = 'Típusok elrejtése';
$string['importbackupstage16action'] = 'Tovább';
$string['importbackupstage1action'] = 'Következő';
$string['importbackupstage2action'] = 'Következő';
$string['importbackupstage4action'] = 'Importálás végrehajtása';
$string['importbackupstage8action'] = 'Tovább';
$string['importcurrentstage0'] = 'Kurzusválasztás';
$string['importcurrentstage1'] = 'Kezdő beállítások';
$string['importcurrentstage16'] = 'Kész';
$string['importcurrentstage2'] = 'Sémabeállítások';
$string['importcurrentstage4'] = 'Megerősítés és ellenőrzés';
$string['importcurrentstage8'] = 'Importálás végrehajtása';
$string['importfile'] = 'Biztonsági mentés állományának feltöltése';
$string['importgeneralduplicateadminallowed'] = 'Rendszergazdai ütközésfeloldás engedélyezése';
$string['importgeneralduplicateadminallowed_desc'] = 'Ha a portálon van  \'admin\' nevű felhasználói fiók, akkor ilyen nevet tartalmazó biztonsági mentés esetén ütközés léphet föl. Bekapcsolása esetén az ütközés a biztonsági mentésben szereplő felhasználónév \'admin_xyz\'-re módosításával feloldható.';
$string['importgeneralmaxresults'] = 'Maximális importálandó kurzusszám';
$string['importgeneralmaxresults_desc'] = 'Ez határozza meg az importálási folyamat első lépése során felsorolt kurzusok számát';
$string['importgeneralsettings'] = 'Általános importálási alapértékek';
$string['importrootsettings'] = 'Beállítások importálása';
$string['importsettings'] = 'Általános importálási beállítások';
$string['importsuccess'] = 'Az importálás kész. A Tovább gombra kattintva térhet vissza a kurzushoz';
$string['includeactivities'] = 'Hozzávesz:';
$string['includeditems'] = 'Hozzávett tételek:';
$string['includefilereferences'] = 'Állományhivatkozások külső tartalmakra';
$string['includesection'] = '{$a} fejezet';
$string['includeuserinfo'] = 'Felhasználói adatok';
$string['inprogress'] = 'A biztonsági mentés folyamatban';
$string['jumptofinalstep'] = 'Ugrás az utolsó lépésre';
$string['keep'] = 'Megőriz';
$string['keptroles'] = 'A szerepbeosztások megőrzése';
$string['keptroles_help'] = 'Válassza ki, hogy mely szerepeket és a hozzájuk beosztott felhasználókat kívánja megőrizni az új kurzusban. A felhasználó adatai csak a \'Felhasználó adataival együtt\' bekapcsolásakor másolódnak át.';
$string['locked'] = 'Zárolva';
$string['lockedbyconfig'] = 'A biztonsági mentés alapbeállításai zárolták ezt a beállítást';
$string['lockedbyhierarchy'] = 'Függőségek révén zárolva';
$string['lockedbypermission'] = 'Nincs kellő jogosultsága a beállítás módosításához';
$string['loglifetime'] = 'Naplók megőrizendők';
$string['managefiles'] = 'Biztonsági mentés állományainak kezelése';
$string['mergerestoredefaults'] = 'Alapértékek helyreállítása másik kurzusba olvadás esetén';
$string['missingfilesinpool'] = 'Néhány állományt a biztonsági mentés során nem lehetett elmenteni, ezeket nem lehet visszaállítani.';
$string['module'] = 'Modul';
$string['moodleversion'] = 'Moodle-verzió';
$string['morecoursesearchresults'] = 'Több mint {$a} kurzus található, az első {$a} eredmény jelenik meg';
$string['moreresults'] = 'Túl sok a találat, adjon meg egy konkrétabb keresést.';
$string['nomatchingcourses'] = 'Nincs megjeleníthető kurzus';
$string['norestoreoptions'] = 'A visszaállításhoz nincs kategória vagy kurzus.';
$string['originalwwwroot'] = 'A biztonsági mentés webcíme';
$string['overwrite'] = 'Felülír';
$string['pendingasyncdeletedetail'] = 'A kurzushoz függőben lévő biztonsági mentés kapcsolódik. <br />Annak a végéig a kurzusokat nem lehet törölni.';
$string['pendingasyncdetail'] = 'Aszinkron biztonsági mentés esetén egy tananyaghoz egyszerre csak egy függőben lévő biztonsági mentés kapcsolódhat. <br /> Több aszinkron biztonsági mentés egy tananyaghoz nem rendelhető hozzá, mert az több azonos tartalmú biztonsági mentést eredményezhetne.';
$string['pendingasyncedit'] = 'A kurzushoz aszinkron biztonsági mentés van függőben. A mentés végéig ne szerkessze a kurzust.';
$string['pendingasyncerror'] = 'A tananyaghoz biztonsági mentés van függőben';
$string['preparingdata'] = 'Adatok előkészítése';
$string['preparingui'] = 'Oldalmegjelenítés előkészítése';
$string['previousstage'] = 'Előző';
$string['privacy:metadata:backup:detailsofarchive'] = 'Az archívum különféle kurzushoz kapcsolódó felhasználói adatokat, pl. osztályzatokat, beiratkozásokat és tevékenységadatokat tartalmazhat.';
$string['privacy:metadata:backup:externalpurpose'] = 'Az archívum célja olyan kurzushoz kapcsolódó adatok tárolása, amelyeket a későbbiekben helyreállíthat.';
$string['privacy:metadata:backup_controllers'] = 'A mentési műveletek felsorolása';
$string['privacy:metadata:backup_controllers:itemid'] = 'A kurzus azonosítója';
$string['privacy:metadata:backup_controllers:operation'] = 'A végrehajtott művelet, pl. helyreállítás.';
$string['privacy:metadata:backup_controllers:timecreated'] = 'A lépés létrehozásának a dátuma';
$string['privacy:metadata:backup_controllers:timemodified'] = 'A lépés módosításának a dátuma';
$string['privacy:metadata:backup_controllers:type'] = 'A művelet tárgyának típusa, pl. tevékenység.';
$string['qcategory2coursefallback'] = 'Az eredetileg a biztonsági mentés állományában a rendszer/kurzuskategória környezetében lévő "{$a->name}" kérdéskategória visszaállítás során a kurzuskörnyezetben jön létre';
$string['qcategorycannotberestored'] = 'A(z) "{$a->name}" kérdéskategória visszaállítás során nem hozható létre';
$string['question2coursefallback'] = 'Az eredetileg a biztonsági mentés állományában a rendszer/kurzuskategória környezetében lévő "{$a->name}" kérdéskategória visszaállítás során a kurzuskörnyezetben jön létre';
$string['questioncannotberestored'] = 'A(z) "{$a->name}" kérdések visszaállítás során nem hozhatók létre';
$string['recyclebin_desc'] = 'Ezek a beállítások a kukára is érvényesek lesznek.';
$string['replacerestoredefaults'] = 'Alapértékek helyreállítása másik kurzusba való, tartalom törlésével járó helyreállítás esetén';
$string['restoreactivity'] = 'Tevékenység visszaállítása';
$string['restorecourse'] = 'Kurzus visszaállítása';
$string['restorecoursesettings'] = 'Kurzusbeállítások';
$string['restoredcourseid'] = 'Helyreállított kurzusazonosító: {$a}';
$string['restoreexecutionsuccess'] = 'A kurzus helyreállítása sikerült.';
$string['restorefileweremissing'] = 'Néhány állományt nem lehetett visszaállítani, mert kimaradtak a a biztonsági mentésből.';
$string['restorenewcoursefullname'] = 'Új kurzusnév';
$string['restorenewcourseshortname'] = 'Új rövid kurzuscím';
$string['restorenewcoursestartdate'] = 'Új kezdési időpont';
$string['restorerolemappings'] = 'Szerep-hozzárendelések visszaállítása';
$string['restorerootsettings'] = 'Beállítások visszaállítása';
$string['restoresection'] = 'Fejezet visszaállítása';
$string['restorestage1'] = 'Megerősítés';
$string['restorestage16'] = 'Ellenőrzés';
$string['restorestage16action'] = 'Visszaállítás végrehajtása';
$string['restorestage1action'] = 'Következő';
$string['restorestage2'] = 'Cél';
$string['restorestage2action'] = 'Következő';
$string['restorestage32'] = 'Feldolgozás';
$string['restorestage32action'] = 'Tovább';
$string['restorestage4'] = 'Beállítások';
$string['restorestage4action'] = 'Következő';
$string['restorestage64'] = 'Kész';
$string['restorestage64action'] = 'Tovább';
$string['restorestage8'] = 'Séma';
$string['restorestage8action'] = 'Következő';
$string['restoretarget'] = 'Cél visszaállítása';
$string['restoretocourse'] = 'Visszaállítás ebbe a kurzusba:';
$string['restoretocurrentcourse'] = 'Visszaállítás ebbe a kurzusba:';
$string['restoretocurrentcourseadding'] = 'A kurzus biztonsági mentésének egyesítése ezzel a kurzussal';
$string['restoretocurrentcoursedeleting'] = 'A kurzus tartalmának törlése, azután visszaállítás';
$string['restoretoexistingcourse'] = 'Visszaállítás egy létező kurzusba';
$string['restoretoexistingcourseadding'] = 'A kurzus biztonsági mentésének egyesítése egy létező kurzussal';
$string['restoretoexistingcoursedeleting'] = 'A létező kurzus tartalmának törlése, azután visszaállítás';
$string['restoretonewcourse'] = 'Visszaállítás új kurzusként';
$string['restoringcourse'] = 'A kurzus-visszaállítás folyamatban';
$string['restoringcourseshortname'] = 'Visszaállítás';
$string['rootenrolmanual'] = 'Visszaállítás kézi beiratkozásként.,';
$string['rootsettingactivities'] = 'Tevékenységekkel és tananyagokkal együtt';
$string['rootsettinganonymize'] = 'Felhasználói adatok elrejtése';
$string['rootsettingbadges'] = 'Kitűzők hozzáadása';
$string['rootsettingblocks'] = 'Blokkokkal együtt';
$string['rootsettingcalendarevents'] = 'Naptári események szerepeltetése';
$string['rootsettingcomments'] = 'Megjegyzésekkel együtt';
$string['rootsettingcompetencies'] = 'Készségekkel együtt';
$string['rootsettingcontentbankcontent'] = 'A tartalombank tartalmával együtt';
$string['rootsettingcustomfield'] = 'Egyedi mezőkkel együtt';
$string['rootsettingenrolments'] = 'Beiratkozási módszerekkel együtt';
$string['rootsettingenrolments_always'] = 'Mindig "Igen"';
$string['rootsettingenrolments_never'] = 'Nem, a felhasználókat kézi beiratkozásúként állítsa vissza';
$string['rootsettingenrolments_withusers'] = 'Igen, de csak felhasználókkal együtt';
$string['rootsettingfiles'] = 'Állományok hozzáadása';
$string['rootsettingfilters'] = 'Szűrőkkel együtt';
$string['rootsettinggradehistories'] = 'Pontozási előzményekkel együtt';
$string['rootsettinggroups'] = 'csoportok és csoportosítások felvétele';
$string['rootsettingimscc1'] = 'Átalakítás IMS Common Cartridge 1.0 formára';
$string['rootsettingimscc11'] = 'Átalakítás IMS Common Cartridge 1.1 formára';
$string['rootsettinglegacyfiles'] = 'Korábbi kurzusállományok bevonása';
$string['rootsettinglogs'] = 'Kurzusnaplókkal együtt';
$string['rootsettingpermissions'] = 'Engedélyfelülírásokkal együtt';
$string['rootsettingquestionbank'] = 'A kérdésbank legyen része';
$string['rootsettingroleassignments'] = 'Felhasználói szerep-hozzárendelésekkel együtt';
$string['rootsettings'] = 'A biztonsági mentés beállításai';
$string['rootsettingusers'] = 'Beiratkozott felhasználókkal együtt';
$string['rootsettinguserscompletion'] = 'A felhasználói teljesítés adataival együtt';
$string['samesitenotification'] = 'A biztonsági mentés csak az állományokra való hivatkozásokat tartalmazza. A helyreállítás csak ezen a portálon fog működni.';
$string['sectionactivities'] = 'Tevékenységek';
$string['sectioninc'] = 'A biztonsági mentés része (nincs felhasználói adat)';
$string['sectionincanduser'] = 'A biztonsági mentés része felhasználói adatokkal együtt';
$string['selectacategory'] = 'Válasszon kategóriát';
$string['selectacourse'] = 'Válasszon kurzust';
$string['setting_course_fullname'] = 'Kurzusnév';
$string['setting_course_shortname'] = 'Rövid kurzuscím';
$string['setting_course_startdate'] = 'Kurzus kezdési időpontja';
$string['setting_keep_groups_and_groupings'] = 'Aktuális csoportok és csoportosítások megőrzése';
$string['setting_keep_roles_and_enrolments'] = 'Aktuális szerepek és beiratkozások megőrzése';
$string['setting_overwrite_conf'] = 'Kurzusbeállítás felülírása';
$string['setting_overwrite_course_fullname'] = 'Kurzus teljes címének felülírása';
$string['setting_overwrite_course_shortname'] = 'Kurzus rövid címének a felülírása';
$string['setting_overwrite_course_startdate'] = 'Kurzus kezdetének felülírása';
$string['showtypes'] = 'Típusok megjelenítése';
$string['sitecourseformatwarning'] = 'Ez kezdőoldali mentés, csak a kezdőoldalon állítható helyre.';
$string['skiphidden'] = 'Rejtett kurzusok kihagyása';
$string['skiphiddenhelp'] = 'A rejtett kurzusok kimaradjanak?';
$string['skipmodifdays'] = 'óta nem módosult kurzusok kimaradnak';
$string['skipmodifdayshelp'] = 'ennyi ideje nem módosult kurzusok kimaradnak';
$string['skipmodifprev'] = 'Utolsó biztonsági mentés óta nem módosult kurzusok kimaradnak';
$string['skipmodifprevhelp'] = 'Au utolsó biztonsági mentés óta nem módosult kurzusok kimaradjanak? Ehhez a naplózást be kell kapcsolni.';
$string['status'] = 'Állapot';
$string['storagecourseandexternal'] = 'A kurzus biztonsági mentési állományainak területe és a megadott könyvtár';
$string['storagecourseonly'] = 'A kurzus biztonsági mentési állományainak területe';
$string['storageexternalonly'] = 'Megadott könyvtár az automatikus biztonsági mentésekhez';
$string['successful'] = 'Sikeres biztonsági mentés!';
$string['successfulcopy'] = 'A másolás sikerült';
$string['successfulrestore'] = 'Sikeres helyreállítás!';
$string['timetaken'] = 'Felhasznált idő';
$string['title'] = 'Cím';
$string['totalcategorysearchresults'] = 'Összes kategória: {$a}';
$string['totalcoursesearchresults'] = 'Összes kurzus: {$a}';
$string['undefinedrolemapping'] = 'A szerep-hozzárendelés \'{$a}\' archetípus esetén nincs meghatározva.';
$string['unnamedsection'] = 'Névtelen szakasz';
$string['userdata'] = 'Felhasználó adataival együtt';
$string['userdata_help'] = 'Bekapcsolása esetén minden olyan felhasználó adatai - fórumüzenetek, leadott feladatok adatai stb. -átkerülnek az új kurzusba, akik esetén \'A szerepbeosztások megőrzése\' alatt valamely szerep ki van választva.';
$string['userinfo'] = 'Felhasználói adatok';
