<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'cs', version '4.4'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'Procházet všechny kurzy';
$string['addon.block_myoverview.nocoursesenrolled'] = 'Zatím nejste zapsáni v žádném kurzu.';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Prohlédněte si všechny dostupné kurzy níže a začněte se učit.';
$string['addon.block_myoverview.noresult'] = 'Vašemu vyhledávání neodpovídají žádné kurzy.';
$string['addon.block_myoverview.noresultdescription'] = 'Zkuste upravit své filtry nebo si projděte všechny kurzy níže.';
$string['addon.blog.errorloadentries'] = 'Chyba při načítání položek blogu.';
$string['addon.blog.showonlyyourentries'] = 'Zobrazit pouze svoje záznamy';
$string['addon.calendar.calendarevent'] = 'Událost Kalendáře';
$string['addon.calendar.calendarevents'] = 'Události Kalendáře';
$string['addon.calendar.calendarreminders'] = 'Připomenutí kalendáře';
$string['addon.calendar.currentmonth'] = 'Aktuální měsíc';
$string['addon.calendar.defaultnotificationtime'] = 'Výchozí čas oznámení';
$string['addon.calendar.errorloadevent'] = 'Chyba při načítání události.';
$string['addon.calendar.errorloadevents'] = 'Chyba při načítání událostí.';
$string['addon.calendar.monthlyview'] = 'Měsíční pohled';
$string['addon.calendar.noevents'] = 'Nejsou žádné události';
$string['addon.calendar.reminders'] = 'Připomenutí';
$string['addon.calendar.setnewreminder'] = 'Nastavit novou připomínku';
$string['addon.competency.errornocompetenciesfound'] = 'Nebyly nalezeny žádné kompetence';
$string['addon.competency.nocompetencies'] = 'Žádné kompetence';
$string['addon.coursecompletion.complete'] = 'Absolvováno';
$string['addon.coursecompletion.couldnotloadreport'] = 'Nelze načíst zprávu o absolvování kurzu. Zkuste to prosím později.';
$string['addon.enrol_self.confirmselfenrol'] = 'Opravdu se chcete do tohoto kurzu zapsat?';
$string['addon.enrol_self.errorselfenrol'] = 'Při zápisu došlo k chybě.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Konfigurovat zařízení';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Vaši uživatelé nedostávají na svých mobilních zařízeních žádná oznámení z tohoto webu. Povolte mobilní oznámení na stránce Nastavení oznámení.';
$string['addon.messages.contactlistempty'] = 'Seznam kontaktů je prázdný';
$string['addon.messages.contactname'] = 'Jméno kontaktu';
$string['addon.messages.deletemessage'] = 'Odstranit zprávu';
$string['addon.messages.deletemessageconfirmation'] = 'Opravdu chcete tuto zprávu odstranit? Bude smazána pouze z historie zpráv a bude nadále viditelná uživatelem, který poslal nebo přijal zprávu.';
$string['addon.messages.errordeletemessage'] = 'Chyba při odstraňování zprávy.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Chyba při načítání kontaktů ze serveru.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Chyba při načítání diskusí ze serveru.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Chyba při načítání zpráv ze serveru.';
$string['addon.messages.errorwhileretrievingusers'] = 'Chyba při načítání uživatelů ze serveru.';
$string['addon.messages.messagenotsent'] = 'Zpráva nebyla odeslána. Zkuste to prosím později.';
$string['addon.messages.newmessages'] = 'Nové zprávy';
$string['addon.messages.nousersfound'] = 'Nenalezeni žádní uživatelé';
$string['addon.messages.showdeletemessages'] = 'Zobrazit odstraněné zprávy';
$string['addon.messages.type_blocked'] = 'Blokováno';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Výsledky hledání';
$string['addon.messages.type_strangers'] = 'Další';
$string['addon.messages.useentertosenddescdesktop'] = 'Pokud je zakázáno, můžete zprávu odeslat pomocí kláves Ctrl + Enter.';
$string['addon.messages.useentertosenddescmac'] = 'Pokud je zakázáno, můžete zprávu odeslat pomocí kláves Ctrl + Enter.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Nelze odeslat zprávu(y) do konverzace {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Nelze odeslat zprávu (y) uživateli {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Přijměte prosím prohlášení o odeslání.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'Podrobnosti úkolu a formulář pro odeslání budou k dispozici na <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'Tento úkol bude přijímat příspěvky od <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'V aplikaci nemůžete přidat nebo upravit řešení úkolu, protože jsme nemohli získat stav řešení z webu.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Některé metody známkování zatím nejsou aplikací podporovány a nemohou být změněny.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'V aplikaci nemůžete odeslat známku úkolu, protože jsme nemohli získat stav řešení z webu.';
$string['addon.mod_assign.duedateno'] = 'Bez termínu ukončení';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'V aplikaci nemůžete přidat nebo upravit řešení úkolu, protože některé doplňky nepodporují úpravy.';
$string['addon.mod_assign.errorshowinginformation'] = 'Nelze zobrazit informace o řešení úkolu.';
$string['addon.mod_assign.feedbacknotsupported'] = 'Tento komentář aplikace nepodporuje a nemusí obsahovat všechny informace.';
$string['addon.mod_assign.gradenotsynced'] = 'Známky nejsou synchronizovány';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Nejsou zobrazeni účastníci bez odevzdaného řešení úkolu.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'Počet konceptů: {{count}}.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'Účastníků je {{count}}.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'Počet příspěvků, které je třeba hodnotit, je {{count}}.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'Počet odeslaných úkolů: {{count}}.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'Existuje {{count}} týmů.';
$string['addon.mod_assign.submissionnotsupported'] = 'Tento formát řešení úkolu aplikace nepodporuje a nemusí obsahovat všechny informace.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'známka uživatele';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'Známka úkolu byla na webu upravena.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'Řešení úkolu bylo na webu upraveno.';
$string['addon.mod_chat.confirmloss'] = 'Jsi si jistá? Historie chatu může být ztracena.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Chyba při připojování k chatu.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Chyba při načítání dat chatu.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Chyba při načítání uživatelů chatu.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Chyba při načítání zpráv ze serveru.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Chyba při odeslání zprávy.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'Pro odesílání zpráv musíte být online';
$string['addon.mod_chat.nosessionsfound'] = 'Nebyly nalezeny žádné relace';
$string['addon.mod_chat.showincompletesessions'] = 'Zobrazit neúplné relace';
$string['addon.mod_choice.errorgetchoice'] = 'Chyba při načítání  dat ankety.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% uživatelů zvolilo možnost: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Vaše poslední odpověď musí být synchronizována předtím, než je zahrnuta do výsledků.';
$string['addon.mod_data.edittagsnotsupported'] = 'Litujeme, aplikace nepodporuje úpravy štítků.';
$string['addon.mod_data.errorapproving'] = 'Chyba při schvalování nebo odmítnutí položky.';
$string['addon.mod_data.errordeleting'] = 'Chyba při mazání položky.';
$string['addon.mod_data.gettinglocation'] = 'Získání polohy';
$string['addon.mod_data.locationnotenabled'] = 'Poloha není povolena';
$string['addon.mod_data.locationpermissiondenied'] = 'Oprávnění k přístupu k vaší poloze bylo zamítnuto.';
$string['addon.mod_data.mylocation'] = 'Moje poloha';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Je nám líto, aplikace nepodporuje vyhledávání podle značek.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Dotazník se souborem CAPTCHA nemůže být  v režinu offline dokončen, pokud není nakonfigurován režim offline nebo server je vypnutý.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'Existuje {{count}} odeslaných odpovědí.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'Tento dotazník byl uložen k pozdějšímu odevzdání.';
$string['addon.mod_feedback.questionscountdescription'] = 'Existuje {{count}} otázek.';
$string['addon.mod_folder.emptyfilelist'] = 'Žádný soubor k zobrazení.';
$string['addon.mod_forum.errorgetforum'] = 'Chyba při načítání dat fóra.';
$string['addon.mod_forum.errorgetgroups'] = 'Chyba při načítání nastavení skupiny.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Fórum v tomto řazení není k dispozici';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Zkuste změnit řazení nebo přejděte online a prohlédněte si toto fórum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Nelze vytvořit novou diskusi ve všech skupinách.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'V tomto diskusním fóru nejsou žádná témata';
$string['addon.mod_forum.group'] = 'Skupina';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} diskusí';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} odpovědí';
$string['addon.mod_forum.postingroup'] = 'Odesílání do skupiny "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Obnovit diskusní příspěvky';
$string['addon.mod_glossary.browsemode'] = 'Prohlížení příspěvků';
$string['addon.mod_glossary.byalphabet'] = 'Abecedně';
$string['addon.mod_glossary.byauthor'] = 'Skupina podle autora';
$string['addon.mod_glossary.bycategory'] = 'Skupina podle kategorie';
$string['addon.mod_glossary.bynewestfirst'] = 'Nejnovější nejdříve';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Posledně aktualizované';
$string['addon.mod_glossary.bysearch'] = 'Hledat';
$string['addon.mod_glossary.cannoteditentry'] = 'Záznam nelze upravit';
$string['addon.mod_glossary.entriestobesynced'] = 'Příspěvky, které mají být synchronizovány';
$string['addon.mod_glossary.entrypendingapproval'] = 'Tato položka čeká na schválení.';
$string['addon.mod_glossary.errordeleting'] = 'Chyba při mazání záznamu.';
$string['addon.mod_glossary.errorloadingentries'] = 'Při načítání položek došlo k chybě.';
$string['addon.mod_glossary.errorloadingentry'] = 'Při načítání položky došlo k chybě.';
$string['addon.mod_glossary.errorloadingglossary'] = 'Při načítání slovníku došlo k chybě.';
$string['addon.mod_glossary.noentriesfound'] = 'Nebyly nalezeny žádné záznamy.';
$string['addon.mod_glossary.searchquery'] = 'Vyhledávací dotaz';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Stáhnout soubor H5P';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Chyba při získávání údajů o činnosti H5P.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'Balíček H5P není stažen. Abyste jej mohli používat, musíte jej stáhnout.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'Balíček H5P byl od posledního stažení upraven. Abyste jej mohli používat, musíte jej stáhnout znovu.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} pokusů';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'K zobrazení balíčku H5P budete muset být online.';
$string['addon.mod_h5pactivity.viewattempt'] = 'Zobrazit pokus {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Zobrazit popis';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'Tato přednáška obsahuje skok na náhodnou stránku. V aplikaci ji nelze zkoušet, dokud nebude spuštěna na webu.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'Tento pokus již nelze prohlédnout, protože byl dokončen další pokus.';
$string['addon.mod_lesson.finishretakeoffline'] = 'Tento pokus byl dokončen offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'Offline pokus byl synchronizován. Chcete jej zobrazit?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'Pokus byl dokončen na webových stránkách.';
$string['addon.mod_lti.errorgetlti'] = 'Chyba při získávání dat modulu.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'Spuštěná URL není platná.';
$string['addon.mod_lti.launchactivity'] = 'Zahájit aktivitu';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Chyba při načítání obsahu stránky.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'O tento test se můžete pokusit v aplikaci, ale pokus budete muset odeslat v prohlížeči z následujících důvodů:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'Tento pokus testu nemůže být odeslán z následujících důvodů:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'Tento pokus nebyl synchronizován od {{$a}}. Pokud budete pokračovat v pokusu na jiném zařízení, pak může dojít ke ztrátě dat.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'Při ukládání odpovědi došlo k chybě. Jste si jisti, že chcete test ukončit?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'Tento test nelze v aplikaci spustit, protože chování není aplikací podporováno:';
$string['addon.mod_quiz.errordownloading'] = 'Chyba při stahování požadovaných dat.';
$string['addon.mod_quiz.errorgetattempt'] = 'Chyba při získávání dat pokusu.';
$string['addon.mod_quiz.errorgetquestions'] = 'Chyba při získávání úlohy.';
$string['addon.mod_quiz.errorgetquiz'] = 'Chyba při získávání dat testu.';
$string['addon.mod_quiz.errorparsequestions'] = 'Při čtení úloh došlo k chybě. Prosím spusťte pokus testu ve webovém prohlížeči.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'Tento test nelze v aplikaci spustit, protože obsahuje pouze úlohy, které nejsou aplikací podporovány:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'Tento test nelze v aplikaci spustit, protože podmínka omezení přístupu není aplikací podporovány:';
$string['addon.mod_quiz.errorsaveattempt'] = 'Při ukládání dat pokusu došlo k chybě.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Váš pokus byl odeslán a uložen. Jakmile budete znovu online, bude odeslána na web.';
$string['addon.mod_quiz.finishnotsynced'] = 'Ukončeno bez synchronizace';
$string['addon.mod_quiz.opentoc'] = 'Otevřete navigaci.';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offline pokus byl vyřazen, jelikož byl dokončen na webu nebo nebyl nalezen.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Některé odpovědi režimu offline byly vyřazeny, protože tyto úlohy byly na webu upraveny.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Pokus o nebyl dokončen, protože některé odpovědi v režimu offline byly vyřazeny. Zkontrolujte prosím vaše odpovědi a pak znovu pokus odešlete.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'Tento test obsahuje otázky, které aplikace nepodporuje:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Chyba při načítání obsahu.';
$string['addon.mod_resource.openthefile'] = 'Otevřít';
$string['addon.mod_resource.resourcestatusoutdated'] = 'Tento soubor se od posledního otevření změnil.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'K dispozici je novější verze tohoto souboru. Chcete-li to zobrazit, připojte zařízení k internetu.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Nelze vypočítat známku.';
$string['addon.mod_scorm.dataattemptshown'] = 'Tato data patří k pokusu číslo {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'Při vytváření nového offline pokusu došlo k chybě. Prosím, zkuste to znovu.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Chyba při stahování SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Chyba při načítání SCORM dat.';
$string['addon.mod_scorm.errorinvalidversion'] = 'Litujeme, aplikace podporuje pouze SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Stažení SCORM balíčků je na stránkách Moodle zakázáno. Obraťte se na správce webu Moodle.';
$string['addon.mod_scorm.errornovalidsco'] = 'Tato SCORM nemá viditelnou SCO pro stažení.';
$string['addon.mod_scorm.errorpackagefile'] = 'Litujeme, aplikace podporuje pouze ZIP balíčky.';
$string['addon.mod_scorm.errorsyncscorm'] = 'Při synchronizaci došlo k chybě. Prosím, zkuste to znovu.';
$string['addon.mod_scorm.offlineattemptnote'] = 'Tento pokus obsahuje data, která nebyla synchronizována.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'Tento pokus nelze odeslat, protože jste překonal maximální počet pokusů.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'Tento SCORM není stažen. Bude automaticky stažen, když jej otevřete.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'Tento SCORM byl od posledního stažení změněn. Bude automaticky stažen, když jej otevřete.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Některá offline data pokusu {{number}} byla zrušena, protože by nebylo možné vytvořit na nový pokus';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Některé pokusy nemohou být synchronizovány s webem, protože poslední online pokus není dokončen. Prosím, dokončete nejprve online pokus.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Je nám líto, došlo k chybě odeslání průzkumu. Prosím zkuste to znovu.';
$string['addon.mod_survey.errorgetsurvey'] = 'Chyba při načítání dat průzkumu.';
$string['addon.mod_survey.results'] = 'Výsledky';
$string['addon.mod_url.accessurl'] = 'Přístup k URL';
$string['addon.mod_url.pointingtourl'] = 'Adresa URL, na kterou zdroj odkazuje.';
$string['addon.mod_wiki.errorloadingpage'] = 'Při načítání stránky došlo k chybě.';
$string['addon.mod_wiki.errornowikiavailable'] = 'Tato wiki ještě nemá žádný obsah.';
$string['addon.mod_wiki.gowikihome'] = 'Přejít na výchozí stránku Wiki';
$string['addon.mod_wiki.subwiki'] = 'Subwiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'Název by neměl být prázdný';
$string['addon.mod_wiki.viewpage'] = 'Zobrazit stránku';
$string['addon.mod_wiki.wikipage'] = 'Wiki stránka';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Strategie hodnocení {{$a}} není podporována';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'Musíte zadat název.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'Odevzdaný úkol byl na webu změněn.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'Úkol byl na webu změněn.';
$string['addon.notes.warningnotenotsent'] = 'Nepodařilo se přidat nebo smazat poznámky. {{error}}';
$string['addon.notifications.allownotifications'] = 'Povolit oznámení';
$string['addon.notifications.errorgetnotifications'] = 'Chyba při načítání oznámení.';
$string['addon.notifications.notifications'] = 'Oznámení';
$string['addon.notifications.playsound'] = 'Přehrát zvuk';
$string['addon.notifications.therearentnotificationsyet'] = 'Nejsou žádná sdělení.';
$string['addon.notifications.typeofnotification'] = 'Typ oznámení';
$string['addon.privatefiles.couldnotloadfiles'] = 'Seznam souborů nelze načíst.';
$string['addon.privatefiles.emptyfilelist'] = 'Nejsou k dispozici žádné soubory k zobrazení.';
$string['addon.privatefiles.erroruploadnotworking'] = 'V současné době bohužel není možné nahrát soubory na váš web.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Odstranit všechna data stažená z webu?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Odstranit stažená data ze všech kurzů?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Odstranit všechna stažená data z "{{name}}"?';
$string['addon.storagemanager.coursedownloads'] = 'Stahování kurzů';
$string['addon.storagemanager.courseinfo'] = 'Stáhněte si obsah kurzu, abyste mohli pracovat offline. Vaše aktivita se automaticky synchronizuje, až bude zařízení opět online.';
$string['addon.storagemanager.deleteallsitedata'] = 'Odstranit všechna data stažená z webu';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'Tímto smažete všechna stažená data z "{{name}}", včetně všech stažených kurzů a dat, která vám umožňují pracovat offline.';
$string['addon.storagemanager.deletecourses'] = 'Odstranit stažená data ze všech kurzů';
$string['addon.storagemanager.deletedata'] = 'Odstranit stažená data';
$string['addon.storagemanager.deletedatafrom'] = 'Odstranit všechna stažená data z "{{name}}"';
$string['addon.storagemanager.downloaddatafrom'] = 'Stáhnout {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Stažené kurzy';
$string['addon.storagemanager.downloads'] = 'Stahování';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Chyba při mazání stažených dat.';
$string['addon.storagemanager.managedownloads'] = 'Správa stahování';
$string['addon.storagemanager.totaldownloads'] = 'Celkové stahování';
$string['addon.storagemanager.totalspaceusage'] = 'Celkový využitý prostor';
$string['addon.tinymce.enabletinymceeditor'] = 'Použít textový editor TinyMCE';
$string['addon.tinymce.enabletinymceeditordescription'] = 'Pokročilý textový editor s dalšími funkcemi formátování.';
$string['addon.tinymce.license'] = 'Společnosti Moodle Pty Ltd byla udělena komerční licence TinyMCE kompatibilní s licencí Apache 2.0.';
$string['appstoredescription'] = 'DŮLEŽITÉ: Tato oficiální Moodle Mobile aplikace bude pracovat pouze s Moodle stránkami, které byly nastaveny tak, aby tuto aplikaci podporovaly. Prosím, poraďte se se svým správcem Moodle, pokud narazíte na problémy s připojením.
Pokud byly vaše Moodle stránky správně nastaveny, můžete použít tuto aplikaci:

- k procházení obsahu vašich kurzů, a to i v režimu offline,
- k přijímání upozornění na nové zprávy a další události,
- pro rychlé vyhledání a zkontaktování účastníků ve vašich kurzech,
- pro vkládání fotografií, obrázků, videí, zvukových záznamů a dalších souborů z vašeho mobilního zařízení,
- k prohlížení známek ve vašich kurzech
- a mnoho dalších věcí!

Pro nejnovější informace o aplikaci navštivte prosím http://docs.moodle.org/en/Mobile_app.

Oceníme kvalitní recenze týkající se stávajících funkcí, stejně jako vaše podněty pro další vývoj této aplikace.

Aplikace vyžaduje následující oprávnění:
Záznam zvuku - Pro záznam zvuku nahrát do Moodle
Čtení a úprava obsahu karty SD - obsah je stažen na SD kartu, takže jje můžete v režimu offline prohlížet
Přístup k síti - aby bylo možné spojení se stránkami Moodle, zkontrolujte, zda jste připojeni či nikoli, jinak přejděte do režimu offline
Spuštění při startu - obdržíte lokální notifikaci, i když je aplikace běžící na pozadí
Zabránění přechodu telefonu do režimu spánku - tak můžete dostávat vnucená upozornění kdykoliv';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Prezentace Apple Keynote';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Tabulka Apple Numbers';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Dokument Apple Pages';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Zvuk z Disku Google';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google dokumenty';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Nákres Google';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Soubor Disku Google';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Složka Disku Google';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Formuláře Google';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion tabulky';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Prezentace Google';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Skripty Google Apps';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Weby Google';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Tabulky Google';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Video z Disku Google';
$string['core.ajaxendpointnotfound'] = 'Koncový bod AJAX nebyl nalezen. To se může stát, pokud je web Moodle příliš starý nebo blokuje přístup k tomuto koncovému bodu. Aplikace Moodle podporuje pouze systémy Moodle {{$a}} a novější.';
$string['core.browser'] = 'Prohlížeč';
$string['core.calculating'] = 'Počítání';
$string['core.cannotconnect'] = 'Nelze se připojit k webu';
$string['core.cannotdownloadfiles'] = 'Vaše škola nebo poskytovatel výuky zakázal stahování souborů.';
$string['core.cannotinstallapk'] = 'Soubory .apk nelze nainstalovat';
$string['core.cannotinstallapkinfo'] = 'Z bezpečnostních důvodů z této aplikace nemůžete do zařízení instalovat neznámé aplikace. Pokud přesto chcete pokračovat v instalaci, musíte ji otevřít v prohlížeči.';
$string['core.cannotlogoutpageblocks'] = 'Než budete pokračovat, uložte nebo zahoďte změny.';
$string['core.cannotopeninapp'] = 'Tento soubor nemusí na tomto zařízení fungovat očekávaným způsobem. Chcete jej přesto otevřít?';
$string['core.cannotopeninappdownload'] = 'Tento soubor nemusí na tomto zařízení fungovat očekávaným způsobem. Chcete si jej přesto stáhnout?';
$string['core.captureaudio'] = 'Nahrát zvuk';
$string['core.capturedimage'] = 'Vyfocený obrázek.';
$string['core.captureimage'] = 'Vyfotit';
$string['core.capturevideo'] = 'Nahrát video';
$string['core.certificaterror'] = 'Vaše zařízení nemůže důvěřovat certifikátu tohoto webu: {{details}}';
$string['core.clearsearch'] = 'Vymazat vyhledávání';
$string['core.clearstoreddata'] = 'Vymazat úložiště {{$a}}';
$string['core.clicktoseefull'] = 'Kliknutím zobrazit celý obsah.';
$string['core.comments.commentsnotworking'] = 'Komentáře nelze načíst';
$string['core.comments.warningcommentsnotsent'] = 'Komentáře se nepodařilo synchronizovat.  {{error}}';
$string['core.confirmcanceledit'] = 'Jste si jisti, že chcete opustit tuto stránku? Všechny změny budou ztraceny.';
$string['core.confirmleavepagedescription'] = 'Neuložené změny budou ztraceny.';
$string['core.confirmleavepagetitle'] = 'Opustit stránku?';
$string['core.confirmleaveunknownchanges'] = 'Opravdu chcete opustit tuto stránku? Pokud máte nějaké neuložené změny, budou ztraceny.';
$string['core.confirmloss'] = 'Jsi si jistý? Všechny změny budou ztraceny.';
$string['core.confirmopeninbrowser'] = 'Chcete jej otevřít v prohlížeči?';
$string['core.confirmremoveselectedfile'] = 'Toto trvale smaže \'{{filename}}\'. Toto nelze vrátit zpět.';
$string['core.confirmremoveselectedfiles'] = 'Tímto budou trvale smazány vybrané soubory. Toto nelze vrátit zpět.';
$string['core.connectandtryagain'] = 'Připojte se k internetu a zkuste to znovu.';
$string['core.connectionlost'] = 'Připojení k webu bylo ztraceno';
$string['core.contactsupport'] = 'Kontaktujte podporu';
$string['core.contactverb'] = 'Kontakt';
$string['core.contenteditingsynced'] = 'Obsah, který upravujete byl synchronizován.';
$string['core.contentlinks.chooseaccount'] = 'Vyberte si účet';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Vyberte si účet otevřením odkazu.';
$string['core.contentlinks.confirmurlothersite'] = 'Tento odkaz patří k jinému webu. Chcete jej otevřít?';
$string['core.contentlinks.errornoactions'] = 'Nelze najít akci, kterou chcete provést s tímto odkazem.';
$string['core.contentlinks.errornosites'] = 'Nelze najít žádné stránky řešící tento odkaz.';
$string['core.contentlinks.errorredirectothersite'] = 'Adresa URL přesměrování nemůže ukazovat na jiné stránky.';
$string['core.copiedtoclipboard'] = 'Text byl zkopírován do schránky';
$string['core.copytoclipboard'] = 'Zkopírovat do schránky';
$string['core.course.activitydisabled'] = 'Vaše organizace zakázal tuto činnost v mobilní aplikaci.';
$string['core.course.activitynotavailableoffline'] = 'Tato aktivita není k dispozici offline.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Tato aktivita je doplněk třetí strany, který ještě není aplikací podporován.';
$string['core.course.activityrequiresconnection'] = 'Tato aktivita je k dispozici pouze s připojením k internetu. Pokud je vaše zařízení offline, nebudete k němu mít přístup.';
$string['core.course.allsections'] = 'Všechny sekce';
$string['core.course.aria:sectionprogress'] = 'Pokrok sekce:';
$string['core.course.availablespace'] = 'Momentálně máte k dispozici {{available}} volného místa.';
$string['core.course.cannotdeletewhiledownloading'] = 'Soubory nelze během stahování aktivity smazat. Počkejte prosím na dokončení stahování.';
$string['core.course.changesofflinemaybelost'] = 'Veškeré změny, které v této aktivitě provedete offline, se nemusí uložit.<br><br>Abyste nepřišli o svůj postup, připojte zařízení k internetu.';
$string['core.course.confirmdownload'] = 'Chystáte se stahovat  {{size}}.{{availableSpace}} Opravdu chcete pokračovat?';
$string['core.course.confirmdownloadunknownsize'] = 'Nebyli jsme schopni vypočítat velikost stahování. {{availableSpace}} Opravdu chcete pokračovat?';
$string['core.course.confirmdownloadzerosize'] = 'Chystáte se začít stahovat. {{AvailableSpace}} Opravdu chcete pokračovat?';
$string['core.course.confirmlimiteddownload'] = 'Momentálně nejste připojeni k Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'Chystáte se stáhnout <strong> alespoň </strong>  {{size}}.{{availableSpace}}  Opravdu  chcete pokračovat?';
$string['core.course.couldnotloadsectioncontent'] = 'Nelze načíst obsah sekce. Zkuste to prosím později.';
$string['core.course.couldnotloadsections'] = 'Nelze načíst sekce. Zkuste to prosím později.';
$string['core.course.downloadcoursesprogressdescription'] = 'Stahování kurzů: staženo {{count}} z {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Stahování sekce: staženo {{count}} z {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Chyba stahování kurzu.';
$string['core.course.errordownloadingsection'] = 'Chyba při stahování sekce.';
$string['core.course.errorgetmodule'] = 'Chyba při načítání';
$string['core.course.insufficientavailablequota'] = 'Vaše zařízení nemohlo přidělit prostor pro uložení tohoto stahování. Může to být vyhrazení místa pro aktualizace aplikací a systému. Nejdříve prosím vymažte nějaký úložný prostor.';
$string['core.course.insufficientavailablespace'] = 'Pokoušíte se stáhnout {{size}}. Vaše zařízení tak nebude mít dostatek místa pro normální provoz. Nejdříve prosím vymažte nějaký úložný prostor.';
$string['core.course.lastaccessedactivity'] = 'Poslední navštívená aktivita';
$string['core.course.manualcompletionnotsynced'] = 'Ruční splnění není synchronizováno.';
$string['core.course.modulenotfound'] = 'Zdroj nebo aktivita nebyla nalezena. Ujistěte se prosím, že jste online a jsou stále dostupné.';
$string['core.course.nextactivity'] = 'Další aktivita';
$string['core.course.nextactivitynotfound'] = 'Další aktivita nenalezena. Je možné, že byla skryta nebo smazána.';
$string['core.course.nocontentavailable'] = 'V tuto chvíli není k dispozici žádný obsah.';
$string['core.course.previousactivity'] = 'Předchozí aktivita';
$string['core.course.previousactivitynotfound'] = 'Předchozí aktivita nebyla nalezena. Je možné, že byla skryta nebo smazána.';
$string['core.course.refreshcourse'] = 'Obnovit kurz';
$string['core.course.useactivityonbrowser'] = 'Můžete i nadále používat jej pomocí prohlížeče zařízení.';
$string['core.course.warningmanualcompletionmodified'] = 'Ruční splnění aktivity bylo na webu změněno.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Některá offline ruční splnění kurzu "{{name}}" byla odstraněna. {{error}';
$string['core.coursenogroups'] = 'Nejste členem žádné skupiny tohoto kurzu.';
$string['core.courses.browserenrolinstructions'] = 'Přesměrujeme vás do prohlížeče vašeho zařízení. Po dokončení registrace se vraťte do této aplikace.';
$string['core.courses.cannotretrievemorecategories'] = 'Kategorie hlubší než úroveň {{$a}} nelze načíst.';
$string['core.courses.completeenrolmentbrowser'] = 'Dokončete registraci v prohlížeči';
$string['core.courses.downloadcourses'] = 'Stáhnout všechny kurzy';
$string['core.courses.enrolme'] = 'Zapsat se';
$string['core.courses.errorloadcategories'] = 'Při načítání kategorií došlo k chybě.';
$string['core.courses.errorloadcourses'] = 'Při načítání kurzů došlo k chybě.';
$string['core.courses.errorloadplugins'] = 'Doplňky, které tento kurz vyžaduje, nelze správně načíst. Načtěte opět aplikaci a zkuste to znovu.';
$string['core.courses.errorsearching'] = 'Při vyhledávání došlo k chybě.';
$string['core.courses.filtermycourses'] = 'Filtrovat mé kurzy';
$string['core.courses.notenrollable'] = 'Do tohoto kurzu se nemůžete sami zapsat.';
$string['core.courses.otherenrolments'] = 'Další zápisy';
$string['core.courses.password'] = 'Klíč zápisu';
$string['core.courses.refreshcourses'] = 'Obnovit kurzy';
$string['core.courses.searchcoursesadvice'] = 'Můžete použít tlačítko Vyhledat kurzy, pracovat jako host nebo se zapsat do kurzů, které to umožňují.';
$string['core.courses.showonlyenrolled'] = 'Zobrazit pouze moje kurzy';
$string['core.courses.totalcoursesearchresults'] = 'Celkem kurzů:  {{$a}}';
$string['core.currentdevice'] = 'Aktuální zařízení';
$string['core.datastoredoffline'] = 'Data byla uložena na zařízení, protože nemohla být odeslána. Budou odeslána automaticky později.';
$string['core.deletedoffline'] = 'Odstraněno offline';
$string['core.deleting'] = 'Odstraňování';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Odstranit';
$string['core.dismiss'] = 'Odmítnout';
$string['core.dontshowagain'] = 'Nezobrazovat znovu.';
$string['core.downloaded'] = 'Staženo';
$string['core.downloading'] = 'Stahování';
$string['core.editor.hidetoolbar'] = 'Skrýt panel nástrojů';
$string['core.editor.toggle'] = 'Přepnout editor';
$string['core.emptysplit'] = 'Pokud je levý panel prázdný nebo se nahrává, zobrazí se tato stránka prázdná.';
$string['core.endingtime'] = 'Čas ukončení: {{$a}}';
$string['core.errorchangecompletion'] = 'Při změně stavu dokončení došlo k chybě. Prosím zkuste to znovu.';
$string['core.errorcode'] = 'Chybový kód: {{errorCode}}';
$string['core.errordeletefile'] = 'Chyba při odstraňování souboru. Prosím zkuste to znovu.';
$string['core.errordetailshide'] = 'Skrýt podrobnosti o chybě';
$string['core.errordetailsshow'] = 'Zobrazit podrobnosti o chybě';
$string['core.errordownloading'] = 'Chyba při stahování souboru.';
$string['core.errordownloadingsomefiles'] = 'Chyba při stahování souborů modulu. Některé soubory mohou chybět.';
$string['core.errorfileexistssamename'] = 'Soubor s tímto názvem již existuje.';
$string['core.errorinvalidform'] = 'Zkontrolujte prosím, zda jsou vyplněna všechna povinná pole a zadané údaje jsou ve správném formátu.';
$string['core.errorinvalidresponse'] = 'Neočekávaná odpověď pro webovou službu {{method}}.';
$string['core.errorloadingcontent'] = 'Chyba při načítání obsahu.';
$string['core.errorofflinedisabled'] = 'Prohlížení offline je na vašem webu zakázáno. Chcete-li používat aplikaci, musíte být připojeni k internetu.';
$string['core.erroropenfiledownloading'] = 'Chyba při otevírání souboru: musíte počkat, až se stahování dokončí.';
$string['core.erroropenfilenoapp'] = 'Chyba při otevírání souboru: žádnou aplikací nelze otevřít tento typ souboru.';
$string['core.erroropenfilenoextension'] = 'Chyba při otevírání souboru: soubor nemá příponu.';
$string['core.erroropenpopup'] = 'Tato aktivita se pokouší otevřít vyskakovací okno. Tato možnost není v této aplikaci podporována.';
$string['core.errorrenamefile'] = 'Chyba při přejmenování souboru. Prosím zkuste to znovu.';
$string['core.errorsitesupport'] = 'Pokud problém přetrvává, kontaktujte podporu webu.';
$string['core.errorsomedatanotdownloaded'] = 'Pokud jste tuto aktivitu stáhli, všimněte si, že některá data nejsou během procesu stahování stahována z důvodu výkonu a využití dat.';
$string['core.errorsomethingwrong'] = 'Něco se pokazilo. Prosím zkuste to znovu.';
$string['core.errorsync'] = 'Při synchronizaci došlo k chybě. Zkuste to prosím znovu.';
$string['core.errorsyncblocked'] = '{{$a}} nelze nyní synchronizovat z důvodu probíhajícího procesu. Zkuste to prosím znovu později. Pokud problém přetrvává, zkuste restartovat aplikaci.';
$string['core.errorurlschemeinvalidscheme'] = 'Tato adresa URL je určena k použití v jiné aplikaci: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'V této aplikaci nelze otevřít tuto adresu URL.';
$string['core.exactalarmsturnedoff'] = 'Oznámení v reálném čase jsou vypnutá';
$string['core.exactalarmsturnedoffmessage'] = 'Chcete-li mít jistotu, že vám žádná důležitá upozornění neuniknou, zapněte v nastavení zařízení možnost „Budíky a připomenutí“.';
$string['core.filedeletedsuccessfully'] = 'Úspěšně jste smazali "{{filename}}"';
$string['core.filenameexist'] = 'Jméno souboru již existuje: {{$a}}';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.fileuploader.camera'] = 'Kamera';
$string['core.fileuploader.confirmuploadfile'] = 'Chystáte nahrát {$a}. Jste si jisti, že chcete pokračovat?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'Nebyli jsme schopni vypočítat velikost nahrávaného souboru. Jste si jisti, že chcete pokračovat?';
$string['core.fileuploader.discardrecording'] = 'Zahodit záznam';
$string['core.fileuploader.errorcapturingaudio'] = 'Chyba snímání zvuku.';
$string['core.fileuploader.errorcapturingimage'] = 'Chyba snímání obrazu.';
$string['core.fileuploader.errorcapturingvideo'] = 'Chyba snímání videa.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Chyba při načítání snímku z alba.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'Při nahrávání souboru musíte být online.';
$string['core.fileuploader.errornoapp'] = 'Pro provedení této akce nemáte nainstalovanou aplikaci .';
$string['core.fileuploader.errorreadingfile'] = 'Chyba při čtení souboru.';
$string['core.fileuploader.errorwhileuploading'] = 'Při pokusu o nahrání souboru došlo k chybě .';
$string['core.fileuploader.file'] = 'Soubor';
$string['core.fileuploader.fileuploaded'] = 'Soubor byl úspěšně nahrán.';
$string['core.fileuploader.maxbytesfile'] = 'Soubor {{$a.file}} je příliš veliký. Maximální velikost nahrávaného souboru je {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Povolení k přístupu k mikrofonu bylo odepřeno.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Přístup k mikrofonu je omezen.';
$string['core.fileuploader.pauserecording'] = 'Pozastavit nahrávání';
$string['core.fileuploader.photoalbums'] = 'Fotoalba';
$string['core.fileuploader.readingfile'] = 'Čtení souboru';
$string['core.fileuploader.readingfileperc'] = 'Načítání souboru: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Obnovit nahrávání';
$string['core.fileuploader.selectafile'] = 'Vyberte soubor';
$string['core.fileuploader.startrecordinginstructions'] = 'Klepnutím zahájíte nahrávání';
$string['core.fileuploader.uploadafile'] = 'Nahrát soubor';
$string['core.fileuploader.uploading'] = 'Nahrávání';
$string['core.fileuploader.uploadingperc'] = 'Nahrávání: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Přejít na {{$a}}';
$string['core.h5p.errorgetemail'] = 'Chyba při získávání e-mailu uživatele. Zkontrolujte připojení a zkuste to znovu.';
$string['core.h5p.offlinedisabled'] = 'Stránka neumožňuje stahování balíčků H5P.';
$string['core.h5p.play'] = 'Spustit H5P';
$string['core.hasdatatosync'] = '{{$a}} má offline data, která mají být synchronizována.';
$string['core.howtoobtaincoordinates'] = 'Své souřadnice můžete získat pomocí aplikace GPS nebo <a href="{{url}}">aplikace Mapy</a>.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Tento obsah nefunguje?';
$string['core.image'] = 'Obrázek';
$string['core.imageviewer'] = 'Prohlížeč obrázků';
$string['core.ioscookieshelp'] = 'Vložený obsah může vyžadovat fungování souborů cookie. Přejděte do nastavení systému iOS aplikace, povolte možnost „Povolit sledování mezi weby“ a zkuste to znovu.';
$string['core.lastdownloaded'] = 'Poslední stažení';
$string['core.lastsync'] = 'Poslední synchronizace';
$string['core.leave'] = 'Odejít';
$string['core.loadmore'] = 'Načíst další';
$string['core.locationnolongeravailable'] = 'Vyhledání vaší polohy již není k dispozici. {{howToObtain}}';
$string['core.login.authenticating'] = 'Autentizace';
$string['core.login.changepasswordbutton'] = 'Změnit heslo';
$string['core.login.changepasswordhelp'] = 'Pokud máte problémy se změnou hesla, zkuste to znovu později nebo se obraťte na školu či poskytovatele výuky.';
$string['core.login.changepasswordreconnectinstructions'] = 'Pokud jste heslo nezměnili správně, budete požádáni, abyste to udělali znovu.';
$string['core.login.changepasswordsupportsubject'] = 'Potřebuji pomoc se změnou hesla';
$string['core.login.confirmdeletesite'] = 'Jste si jisti, že chcete odebrat účet na {{sitename}}?';
$string['core.login.connect'] = 'Připojit!';
$string['core.login.connecttomoodle'] = 'Připojit k Moodle';
$string['core.login.connecttomoodleapp'] = 'Pokoušíte se připojit k běžnému serveru Moodle. Stáhněte si oficiální aplikaci Moodle pro přístup na tento web.';
$string['core.login.connecttoworkplaceapp'] = 'Pokoušíte se připojit k webu Moodle Workplace. Stáhněte si aplikaci Moodle Workplace pro přístup na tento web.';
$string['core.login.credentialsdescription'] = 'Pro přihlášení uveďte své uživatelské jméno a heslo.';
$string['core.login.credentialshelp'] = 'Máte-li problémy s přihlášením, zkuste to znovu později nebo kontaktujte svou školu či poskytovatele výuky.';
$string['core.login.credentialssupportsubject'] = 'Potřebujete pomoc s přihlášením';
$string['core.login.emailconfirmsentnoemail'] = '<p>Na vaši adresu měl být zaslán e-mail.</p><p>Obsahuje snadné pokyny k dokončení registrace.</p>';
$string['core.login.emailnotmatch'] = 'E-maily se neshodují';
$string['core.login.erroraccesscontrolalloworigin'] = 'Cross-Origin volání -  váš pokus o provedení byl odmítnut. Zkontrolujte prosím https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'Při odstraňování tohoto účtu došlo k chybě. Prosím, zkuste to znovu.';
$string['core.login.errorexampleurl'] = 'URL https://campus.example.edu je pouze příklad URL adresy, nejedná se o skutečný web. <strong> Použijte prosím adresu URL vaší školy nebo organizace. </strong>';
$string['core.login.errorqrnoscheme'] = 'Tato URL adresa není platná přihlašovací URL adresa.';
$string['core.login.errorupdatesite'] = 'Při aktualizaci tokenu webu došlo k chybě.';
$string['core.login.exceededloginattempts'] = 'Potřebujete pomoc s přihlášením? Vyzkoušejte {{recoverPassword}} nebo kontaktujte podporu svého webu.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'obnov své heslo';
$string['core.login.exceededloginattemptssupportsubject'] = 'Nemohu se přihlásit';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Potřebujete pomoc s přihlášením? Zkuste kontaktovat podporu vašeho webu.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Potřebujete pomoc s přihlášením? Zkuste {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'Zdá se, že máte potíže s přístupem ke svému účtu. Můžete kontaktovat svou školu nebo poskytovatele výuky nebo to zkusit znovu později.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'Nemohu obnovit heslo';
$string['core.login.faqcannotfindmysiteanswer'] = 'Pokud jste zkusili hledat podle URL adresy a stále nemůžete najít své stránky Moodle, kontaktujte prosím osobu, která se stará o Moodle ve vaší škole nebo vzdělávací organizaci.';
$string['core.login.faqcannotfindmysitequestion'] = 'Nemohu najít své stránky podle URL adresy.';
$string['core.login.faqcantloginanswer'] = '<p>Jakmile se připojíte ke svému webu Moodle, měli byste být schopni se přihlásit pomocí svého obvyklého uživatelského jména a hesla.</p><br><p>Pokud jste zapomněli své uživatelské jméno nebo heslo, vyberte možnost <strong >Ztracené heslo?</strong>. Pokud máte stále potíže s přihlášením nebo nevidíte žádné možnosti pro získání uživatelského jména nebo hesla, kontaktujte prosím osobu, která se stará o Moodle ve vaší škole nebo vzdělávací organizaci.</p>';
$string['core.login.faqcantloginquestion'] = 'Nemohu se přihlásit.';
$string['core.login.faqmore'] = 'Další odpovědi naleznete v <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">našich nejčastějších dotazech</a>.';
$string['core.login.faqsetupsiteanswer'] = 'Navštivte {{$link}} a podívejte se na různé možnosti, jak si vytvořit své vlastní stránky Moodle.';
$string['core.login.faqsetupsitelinktitle'] = 'Začít.';
$string['core.login.faqsetupsitequestion'] = 'Chci si založit vlastní stránky Moodle.';
$string['core.login.faqtestappanswer'] = 'Chcete-li aplikaci otestovat na ukázkovém webu Moodle, zadejte do pole <strong>Vaše stránky</strong> „učitel“ nebo „student“ a klepněte na <strong>Připojit k webu</strong>.';
$string['core.login.faqtestappquestion'] = 'Mohu aplikaci otestovat na demo webu?';
$string['core.login.faqwhatisurlanswer'] = '<p>Pokud nemůžete najít své stránky podle názvu, zkuste místo toho hledat podle adresy URL svého webu Moodle (nebo webové adresy).</p><p>Jak najít adresu svého webu:</p><ol>< li>Otevřete webový prohlížeč a přejděte na přihlašovací stránku svého webu Moodle.</li><li>V horní části stránky v adresním řádku uvidíte URL adresu svého webu Moodle, např. "campus.example.edu".<br>{{$image}}</li><li>Zkopírujte adresu URL (nekopírujte /login ani to, co následuje poté), vložte ji do <strong>Vaše stránky< /strong> v aplikaci a poté klepněte na <strong>Připojit se ke svému webu</strong></li><li>Nyní se můžete na svůj web přihlásit pomocí svého uživatelského jména a hesla.</li></ol>< p>Pokud jste zkusili hledat podle URL adresy a stále nemůžete najít své stránky Moodle, kontaktujte prosím osobu, která se stará o Moodle ve vaší škole nebo vzdělávací organizaci.</p>';
$string['core.login.faqwhatisurlquestion'] = 'Jak najdu své stránky?';
$string['core.login.faqwhereisqrcode'] = 'Kde najdu QR kód?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>Pokud to vaše škola nebo poskytovatel výuky povolil, najdete QR kód na webových stránkách ve spodní části stránky s uživatelským profilem.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Najít stránky';
$string['core.login.invalidaccount'] = 'Zkontrolujte prosím své přihlašovací údaje a zkuste to znovu.';
$string['core.login.invalidmoodleversion'] = 'Verze tohoto webu Moodle je příliš stará. Aplikace Moodle funguje s weby, které používají {{$a}} nebo novější.';
$string['core.login.invalidsite'] = 'Adresa URL stránky je chybná';
$string['core.login.invalidtime'] = 'Neplatný čas';
$string['core.login.invalidvaluemax'] = 'Maximální hodnota je {{$a}}';
$string['core.login.invalidvaluemin'] = 'Minimální hodnota je {{$a}}';
$string['core.login.loginbutton'] = 'Přihlásit se';
$string['core.login.mobileservicesnotenabled'] = 'Na vašem webu nejsou povoleny mobilní služby.';
$string['core.login.morewaystologin'] = 'Další způsoby přihlášení';
$string['core.login.notloggedin'] = 'Musíte být přihlášeni.';
$string['core.login.onboardingcreatemanagecourses'] = 'Vytvářet a spravovat své kurzy';
$string['core.login.onboardingenrolmanagestudents'] = 'Zapsat se a spravovat své studenty';
$string['core.login.onboardinggetstarted'] = 'Začínáme s Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'Už mám stránky Moodle';
$string['core.login.onboardingimalearner'] = 'Jsem student';
$string['core.login.onboardingimaneducator'] = 'Jsem pedagog';
$string['core.login.onboardingineedasite'] = 'Potřebuji stránky Moodle';
$string['core.login.onboardingprovidefeedback'] = 'Poskytnout aktuální zpětnou vazbu';
$string['core.login.onboardingtoconnect'] = 'Pro připojení k aplikaci Moodle potřebujete stránky Moodle';
$string['core.login.onboardingwelcome'] = 'Vítejte v aplikaci Moodle!';
$string['core.login.or'] = 'NEBO';
$string['core.login.passwordrequired'] = 'Je požadováno heslo';
$string['core.login.policyacceptmandatory'] = 'Rozumím a souhlasím s povinnými zásadami webu';
$string['core.login.recaptchachallengeimage'] = 'Změnit obrázek reCAPTCHA';
$string['core.login.recaptchaexpired'] = 'Ověření vypršelo. Odpovězte na bezpečnostní otázku znovu.';
$string['core.login.recaptchaincorrect'] = 'Odpověď na bezpečnostní otázku je nesprávná.';
$string['core.login.reconnect'] = 'Znovu připojit';
$string['core.login.reconnecthelp'] = 'Pokud máte problémy s opětovným připojením, zkuste to znovu později nebo se obraťte na školu či poskytovatele výuky.';
$string['core.login.reconnectsupportsubject'] = 'Potřebujete pomoc s obnovením připojení';
$string['core.login.reconnecttosite'] = 'Znovu se připojte k webu';
$string['core.login.removeaccount'] = 'Odstranit účet';
$string['core.login.searchby'] = 'Hledat pomocí:';
$string['core.login.selectsite'] = 'Vyberte prosím svůj účet:';
$string['core.login.signupplugindisabled'] = '{{$a}} není povoleno.';
$string['core.login.signuprequiredfieldnotsupported'] = 'Registrační formulář obsahuje povinné vlastní pole, které není v aplikaci podporováno. Vytvořte si prosím svůj účet pomocí webového prohlížeče.';
$string['core.login.siteaddress'] = 'Adresa vaší stránky';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'Počet nepřečtených oznámení: {{count}}.';
$string['core.login.sitehasredirect'] = 'Váš web obsahuje alespoň jedno přesměrování HTTP. Aplikace nemůže sledovat přesměrování, může to být problém, který brání připojení aplikace k vašim stránkám.';
$string['core.login.siteinmaintenance'] = 'Váš web je v režimu údržby';
$string['core.login.sitenotallowed'] = 'Tato stránka již není dostupná.';
$string['core.login.sitepolicynotagreederror'] = 'Zásady bezpečnosti nebyly odsouhlaseny.';
$string['core.login.siteurl'] = 'URL adresa stránky';
$string['core.login.siteurlrequired'] = 'Je požadováno URL webu, tj.  <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Stále se nemůže připojit?';
$string['core.login.toggleremove'] = 'Upravit seznam účtů';
$string['core.login.unsupportedsite'] = 'Stránka není přístupná prostřednictvím aplikace';
$string['core.login.unsupportedsitemessage'] = 'K webu {{site}} nelze prostřednictvím této aplikace přistupovat.<br><br>Stále k němu můžete přistupovat pomocí webového prohlížeče.';
$string['core.login.usernamerequired'] = 'Požadováno uživatelské jméno';
$string['core.login.visitchangepassword'] = 'Chcete navštívit stránky a změnit heslo?';
$string['core.login.webservicesnotenabled'] = 'Váš hostitelský web možná nemá povoleny webové služby. Požádejte o pomoc svého správce.';
$string['core.login.youcanstillconnectwithcredentials'] = 'Stále se můžete připojit ke stránkám zadáním uživatelského jména a hesla.';
$string['core.login.yourenteredsite'] = 'Připojit se ke svým stránkám';
$string['core.lostconnection'] = 'Vaše relace vypršela. Chcete-li pokračovat, přihlaste se znovu.';
$string['core.mainmenu.switchaccount'] = 'Přepnout účet';
$string['core.mainmenu.usermenutourdescription'] = 'Místo, kde můžete zkontrolovat své hodnocení, změnit své preference nebo přepnout účty.';
$string['core.mainmenu.usermenutourtitle'] = 'Prozkoumat svou osobní oblast';
$string['core.needhelp'] = 'Potřebujete pomoc?';
$string['core.needinternettoaccessit'] = 'Pro přístup k němu musíte být připojeni k internetu.';
$string['core.networkerroriframemsg'] = 'Tento obsah není k dispozici v režimu offline. Připojte se prosím k internetu a zkuste to znovu.';
$string['core.networkerrormsg'] = 'Při připojování k webu došlo k problému. Zkontrolujte připojení a zkuste to znovu.';
$string['core.nooptionavailable'] = 'Není k dispozici žádná možnost';
$string['core.nopasswordchangeforced'] = 'Nelze pokračovat beze změny hesla.';
$string['core.nopermissionerror'] = 'Je nám líto, ale momentálně k tomu nemáte oprávnění';
$string['core.notapplicable'] = 'n/a';
$string['core.notavailablecontentinapp'] = 'Tento obsah není v aplikaci k dispozici, ale můžete jej otevřít ve webovém prohlížeči pomocí následujícího tlačítka.';
$string['core.notavailableoffline'] = 'Tento obsah není k dispozici offline. Připojte se k internetu a zkuste to znovu.';
$string['core.notdownloadable'] = 'Nelze stáhnout';
$string['core.notnow'] = 'Teď ne';
$string['core.notsent'] = 'Neodesláno';
$string['core.nummore'] = '{{$a}} dalších';
$string['core.openfile'] = 'Otevřít soubor';
$string['core.openfilewithextension'] = 'Otevřete soubor {{extension}}';
$string['core.openfullimage'] = 'Zde klikněte pro zobrazení obrázku v plné velikosti';
$string['core.openinbrowser'] = 'Otevřít v prohlížeči';
$string['core.openinbrowserdescription'] = 'Budete přesměrováni do webového prohlížeče';
$string['core.openmodinbrowser'] = 'Otevřít {{$a}} v prohlížeči';
$string['core.opensecurityquestion'] = 'Otevřít bezpečnostní otázku';
$string['core.opensettings'] = 'Otevřít nastavení';
$string['core.openwith'] = 'Otevřít  s ...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Přehrát';
$string['core.policy.havereadandagreepolicy'] = 'Přečetl jsem si {{policyname}} a souhlasím s nimi';
$string['core.policy.nopoliciesyet'] = 'Zatím žádné zásady a dohody.';
$string['core.policy.policyacceptmandatory'] = 'Rozumím a souhlasím s povinnými zásadami webu';
$string['core.policy.sitepolicynotagreederror'] = 'Zásady webu nebyly odsouhlaseny.';
$string['core.policy.viewpolicy'] = 'Zobrazit zásady {{policyname}}.';
$string['core.pulltorefresh'] = 'Stáhněte pro obnovu';
$string['core.qrscanner'] = 'QR skener';
$string['core.question.cannotdeterminestatus'] = 'Stav nelze určit';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Váš web zatím nepodporuje připojování souborů k odpovědím.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Váš web zatím nepodporuje úpravy vložených souborů.';
$string['core.question.errorquestionnotsupported'] = 'Tento typ úlohy není aplikací podporován: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Klepnutím vyberte potom klepněte na místo umístění.';
$string['core.question.questionmessage'] = 'Úloha {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'Budete přesměrováni na web.';
$string['core.reminders.atthetime'] = 'V době konání akce';
$string['core.reminders.custom'] = 'Vlastní...';
$string['core.reminders.customreminder'] = 'Vlastní připomenutí';
$string['core.reminders.delete'] = 'Smazat připomenutí';
$string['core.reminders.reminderset'] = 'Připomenutí nastaveno na {{$a}}';
$string['core.reminders.reminderunset'] = 'Připomenutí bylo smazáno';
$string['core.reminders.setareminder'] = 'Nastavit připomenutí';
$string['core.reminders.setareminderfor'] = 'Nastavit připomenutí pro „{{title}}“ ({{label}})';
$string['core.reminders.setreminder'] = 'Nastavit připomenutí';
$string['core.reminders.timebefore'] = '{{value}} {{units}} před';
$string['core.reminders.value'] = 'Hodnota';
$string['core.removedownloadeddata'] = 'Odstranit stažená data';
$string['core.removefiles'] = 'Odstranit soubory {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'Na toto zobrazení mohou být použity filtry. Chcete-li upravit filtry nebo změnit pořadí řazení, <a href="{{$a}}">otevřete tento přehled ve svém prohlížeči.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Skrýt sloupce';
$string['core.reportbuilder.showcolumns'] = 'Zobrazit sloupce';
$string['core.requireduserdatamissing'] = 'Tento uživatel nemá některá požadovaná data v profilu. Prosím, vyplňte tato data v systému Moodle a zkuste to znovu. <br> {{$a}}';
$string['core.resume'] = 'Shrnutí';
$string['core.retry'] = 'Opakovat';
$string['core.scanqr'] = 'Naskenovat QR kód';
$string['core.scrollbackward'] = 'Přejít zpět';
$string['core.scrollforward'] = 'Přejít vpřed';
$string['core.search.allcategories'] = 'Všechny kategorie';
$string['core.search.empty'] = 'Co hledáte?';
$string['core.search.filtercategories'] = 'Filtrovat výsledky podle';
$string['core.search.filtercourses'] = 'Hledejte v';
$string['core.search.noresults'] = 'Žádné výsledky pro „{{$a}}“';
$string['core.search.noresultshelp'] = 'Zkontrolujte překlepy nebo zkuste použít jiná klíčová slova';
$string['core.search.resultby'] = 'Od {{$a}}';
$string['core.searching'] = 'Hledání';
$string['core.serverconnection'] = 'Chyba při připojování k serveru: {{details}}';
$string['core.settings.about'] = 'O aplikaci';
$string['core.settings.appsettings'] = 'Nastavení aplikace';
$string['core.settings.appversion'] = 'Verze aplikace';
$string['core.settings.cannotsyncloggedout'] = 'Tento web nelze synchronizovat, protože jste se odhlásili. Zkuste to znovu, až budete znovu přihlášeni.';
$string['core.settings.cannotsyncoffline'] = 'Synchronizace stránek se nezdařila, protože vaše zařízení není připojeno k internetu.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Vaše zařízení není připojeno k Wi-Fi. Připojte se k síti Wi-Fi nebo v nastavení aplikace vypněte Spořič dat.';
$string['core.settings.changelanguage'] = 'Změnit na {{$a}}';
$string['core.settings.changelanguagealert'] = 'Změnou jazyka se aplikace restartuje.';
$string['core.settings.colorscheme'] = 'Barevné schéma';
$string['core.settings.colorscheme-dark'] = 'Tmavé';
$string['core.settings.colorscheme-light'] = 'Světlé';
$string['core.settings.colorscheme-system'] = 'Výchozí systém';
$string['core.settings.colorscheme-system-notice'] = 'Výchozí režim systému bude záviset na podpoře vašeho zařízení.';
$string['core.settings.compilationinfo'] = 'Informace o kompilaci';
$string['core.settings.connecttosync'] = 'Vaše zařízení je offline. Chcete-li synchronizovat stránky, připojte se k internetu.';
$string['core.settings.connectwifitosync'] = 'Chcete-li stránky synchronizovat, připojte se k síti Wi-Fi nebo vypněte Spořič dat.';
$string['core.settings.copyinfo'] = 'Zkopírujte informace o zařízení do schránky';
$string['core.settings.cordovadevicemodel'] = 'Cordova Device model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova Device OS verze';
$string['core.settings.cordovadeviceplatform'] = 'Platforma Cordova Device';
$string['core.settings.cordovadeviceuuid'] = 'Cordova Device UUID';
$string['core.settings.cordovaversion'] = 'Cordova verze';
$string['core.settings.debugdisplaydescription'] = 'Je-li tato možnost povolena, budou chybové výpisy zobrazovat více informací o chybě, pokud je to možné.';
$string['core.settings.developeroptions'] = 'Vývojářské možnost';
$string['core.settings.deviceinfo'] = 'Informace o zařízení';
$string['core.settings.deviceos'] = 'OS zařízení';
$string['core.settings.displayformat'] = 'Formát zobrazení';
$string['core.settings.enableanalytics'] = 'Povolit analýzu';
$string['core.settings.enableanalyticsdescription'] = 'Je-li povoleno, aplikace bude shromažďovat anonymní využití dat.';
$string['core.settings.enabledownloadsection'] = 'Povolit stahování sekcí';
$string['core.settings.enablepinchtozoom'] = 'Povolit přiblížení/oddálení prsty';
$string['core.settings.enablerichtexteditor'] = 'Povolit textový editor';
$string['core.settings.enablerichtexteditordescription'] = 'Pokud je povoleno, bude při zadávání obsahu k dispozici textový editor.';
$string['core.settings.encryptedpushsupported'] = 'Podporována šifrovaná oznámení push';
$string['core.settings.entriesincache'] = '{{$a}} položek v mezipaměti';
$string['core.settings.estimatedfreespace'] = 'Odhadované volné místo';
$string['core.settings.filesystemroot'] = 'Kořen souborového systému';
$string['core.settings.fontsize'] = 'Velikost textu';
$string['core.settings.forcedsetting'] = 'Toto nastavení bylo vynuceno konfigurací vašeho webu.';
$string['core.settings.helpusimprove'] = 'Pomozte nám vylepšit tuto aplikaci';
$string['core.settings.ioscookies'] = 'Sledování mezi webovými stránkami';
$string['core.settings.ioscookiesdescription'] = 'Vložený obsah z webu může k fungování vyžadovat soubory cookie mezi weby. Chcete-li jej povolit, přejděte do nastavení systému iOS aplikace a povolte možnost „Povolit sledování mezi weby“.';
$string['core.settings.legaldisclaimer'] = 'Právní vyloučení odpovědnosti';
$string['core.settings.localnotifavailable'] = 'Je dostupné lokání oznámení';
$string['core.settings.locationhref'] = 'Zobrazení web URL';
$string['core.settings.logintosync'] = 'Pro synchronizaci se přihlaste';
$string['core.settings.navigatorlanguage'] = 'Jazyk navigátoru';
$string['core.settings.navigatoruseragent'] = 'Navigátor userAgent';
$string['core.settings.networkstatus'] = 'Stav připojení k Internetu';
$string['core.settings.opensourcelicenses'] = 'Licence Open Source';
$string['core.settings.privacypolicy'] = 'Zásady ochrany osobních údajů';
$string['core.settings.publisher'] = 'Vydavatel';
$string['core.settings.pushid'] = 'Odeslat ID oznámení';
$string['core.settings.reportinbackground'] = 'Zobrazovat chyby automaticky';
$string['core.settings.screen'] = 'Informace na obrazovce';
$string['core.settings.showdownloadoptions'] = 'Zobrazit možnosti stahování';
$string['core.settings.siteinfo'] = 'Informace o webu';
$string['core.settings.sitesynccompleted'] = 'Synchronizace webu dokončena.';
$string['core.settings.sitesyncfailed'] = 'Synchronizace webu se nezdařila';
$string['core.settings.spaceusage'] = 'Použitý prostor';
$string['core.settings.syncdatasaver'] = 'Spořič dat: Synchronizujte pouze při připojení k Wi-Fi';
$string['core.settings.synchronization'] = 'Synchronizace';
$string['core.settings.synchronizenow'] = 'Právě synchonizuji';
$string['core.settings.synchronizenowhelp'] = 'Synchronizace webu odešle čekající změny a veškerou offline aktivitu uloženou v zařízení a bude synchronizovat některá data, jako jsou zprávy a oznámení.';
$string['core.settings.syncsettings'] = 'Nastavení synchronizace';
$string['core.settings.wificonnection'] = 'Připojení WiFi';
$string['core.settings.youradev'] = 'Nyní jste vývojář';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Vyberte účet pro uložení souboru.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'Soubor s tímto názvem již existuje. Chcete existující soubor nahradit nebo jej přejmenovat na "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'Nejsou zde uloženy žádné stránky. Před sdílením souborů s aplikací přidejte prosím web.';
$string['core.sharedfiles.nosharedfiles'] = 'Na tomto webu nejsou uložené žádné sdílené soubory.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'Nemáte žádné nahrané soubory. Pokud chcete nahrát soubor z jiné aplikace, vyhledejte tento soubor a klikněte na tlačítko "Otevřít v".';
$string['core.sharedfiles.rename'] = 'Přejmenovat';
$string['core.sharedfiles.replace'] = 'Nahradit';
$string['core.sharedfiles.sharedfiles'] = 'Sdílené soubory';
$string['core.sharedfiles.successstorefile'] = 'Soubor byl úspěšně uložen. Vyberte soubor, který chcete nahrát do vašich soukromých souborů nebo připojit ji do některých činností.';
$string['core.sitenotfoundhelp'] = 'Nemůžeme najít web, který jste zadali. Zkontrolujte prosím překlepy nebo to zkuste znovu později. Pokud se vám tato zpráva stále zobrazuje, kontaktujte svou školu nebo poskytovatele výuky.';
$string['core.siteunavailablehelp'] = 'Stránka "{{site}}" není momentálně dostupná. Zkuste to znovu později nebo kontaktujte svou školu nebo poskytovatele výuky.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Promiňte...';
$string['core.start'] = 'Zahájení';
$string['core.startingtime'] = 'Počáteční čas: {{$a}}';
$string['core.storingfiles'] = 'Ukládání souborů';
$string['core.submittedoffline'] = 'Odesláno (offline)';
$string['core.swipenavigationtourdescription'] = 'Přejetím doleva a doprava navigovat kolem.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'Aplikace nepodporuje pole štítků.';
$string['core.tag.tagareabadgedescription'] = 'Existuje {{count}} položek.';
$string['core.tag.warningareasnotsupported'] = 'Některé oblasti štítků se nezobrazí, protože nejsou aplikací podporovány.';
$string['core.thereisdatatosync'] = 'K dispozici jsou v  offline režimu {{$a}}, které mají být synchronizovány.';
$string['core.toggledelete'] = 'Přepnout tlačítka mazání';
$string['core.tryagain'] = 'Zkuste znovu';
$string['core.turnon'] = 'Zapnout';
$string['core.turnonexactalarms'] = 'Zapnout upozornění v reálném čase';
$string['core.turnonnotifications'] = 'Zapnout oznámení';
$string['core.turnonnotificationsmessage'] = 'Chcete dostávat upozornění na aktivity a úkoly?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'Upozornění!';
$string['core.unexpectederror'] = 'Neočekávaná chyba. Zavřete a znovu otevřete aplikaci a zkuste to znovu, prosím.';
$string['core.unicodenotsupported'] = 'Některá emojis nejsou na tomto webu podporována. Takové znaky budou při odeslání zprávy odstraněny.';
$string['core.unicodenotsupportedcleanerror'] = 'Při čištění Unicode znaků byl nalezen prázdný text.';
$string['core.unknown'] = 'Neznámý';
$string['core.unzipping'] = 'Rozbalení';
$string['core.updaterequired'] = 'Je vyžadována aktualizace aplikace';
$string['core.updaterequireddesc'] = 'Aktualizujte prosím aplikaci na verzi {{$a}}';
$string['core.user.completeprofile'] = 'Kompletní profil';
$string['core.user.completeprofilehelp'] = 'Pokud máte problémy s vyplněním svého profilu, zkuste to znovu později nebo se obraťte na školu či poskytovatele výuky.';
$string['core.user.completeprofilenotice'] = 'Než budete pokračovat, vyplňte prosím povinná pole ve svém uživatelském profilu.';
$string['core.user.completeprofilereconnectinstructions'] = 'Pokud jste svůj profil nevyplnili správně, budete požádáni, abyste to udělali znovu.';
$string['core.user.completeprofilesupportsubject'] = 'Potřebuji pomoc s dokončením mého profilu';
$string['core.user.completeyourprofile'] = 'Vyplňte svůj profil';
$string['core.user.contact'] = 'Kontakt';
$string['core.user.detailsnotavailable'] = 'Podrobnosti o tomto uživateli nejsou k dispozici.';
$string['core.user.errorloaduser'] = 'Při načítání uživatele došlo k chybě.';
$string['core.user.sendemail'] = 'E-mail';
$string['core.user.support'] = 'Kontaktovat podporu webu';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'Uživatel s ID {{id}}';
$string['core.usernologin'] = 'Ověření tohoto účtu bylo zrušeno';
$string['core.viewcode'] = 'Zobrazit kód';
$string['core.vieweditor'] = 'Zobrazit editor';
$string['core.viewembeddedcontent'] = 'Zobrazení vloženého obsahu';
$string['core.viewer.decreasetextsize'] = 'Zmenšit velikost textu';
$string['core.viewer.enterreadingmode'] = 'Přejít do režimu čtení';
$string['core.viewer.exitreadingmode'] = 'Ukončit režim čtení';
$string['core.viewer.increasetextsize'] = 'Zvětšit velikost textu';
$string['core.viewer.openreadingmodesettings'] = 'Otevřít nastavení režimu čtení';
$string['core.viewer.readingthemeauto'] = 'Aplikace shody';
$string['core.viewer.readingthemedark'] = 'Tmavý';
$string['core.viewer.readingthemehcm'] = 'Vysoký kontrast';
$string['core.viewer.readingthemelight'] = 'Světlý';
$string['core.viewer.readingthemesepia'] = 'Sépie';
$string['core.wanttochangesite'] = 'Chcete změnit stránky nebo se odhlásit?';
$string['core.warningofflinedatadeleted'] = 'Offline změny z {{component}} "{{name}}" byla odstraněna. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Novější změny této aktivity byly provedeny z jiného zařízení.';
$string['core.warnopeninbrowser'] = '<p>Chystáte se opustit aplikaci a otevřít v prohlížeči svého zařízení následující adresu URL. Chcete pokračovat?</p> <p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Proč se to děje?';
$string['core.wsfunctionnotavailable'] = 'Funkce webových služeb není k dispozici.';
$string['core.youreoffline'] = 'Jste offline';
$string['core.youreonline'] = 'Jste zpět online';
$string['core.zoomin'] = 'Přiblížit';
$string['core.zoomout'] = 'Oddálit';
$string['freemium.biometriclogin'] = 'Biometrické přihlášení';
$string['freemium.biometriclogindescription'] = 'Vložte prst do čtečky otisků prstů.';
$string['freemium.biometricloginenablefaceid'] = 'Povolit FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Povolit otisk prstu';
$string['freemium.biometricloginenabletouchid'] = 'Povolit TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Přihlášení pomocí FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Přihlášení pomocí otisku prstu';
$string['freemium.biometricloginloginwithtouchid'] = 'Přihlášení pomocí TouchID';
$string['freemium.biometricloginskip'] = 'Prozatím přeskočit';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} povolena.';
$string['freemium.biometricloginturnoff'] = 'Tuto funkci můžete kdykoli zapnout a vypnout v nastavení.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Otisk prstu';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Použít biometrické přihlášení pomocí otisku prstu nebo obličeje.';
$string['freemium.change'] = 'Změna';
$string['freemium.coursesbatchdownloaddisabled'] = 'Stahování kurzů v dávce není pro tento web povoleno.';
$string['freemium.coursesdownloadlimitreached'] = 'Byl dosažen limit stahování kurzů! Můžete mít staženo pouze {{limit}} kurzů. Kontaktujte svého administrátora, aby zvýšil tento limit nebo některé stažené kurzy ze svého zařízení odstraňte.';
$string['freemium.downloadmainapplicationrequired'] = 'K tomuto webu se můžete připojit pouze pomocí speciální aplikace.';
$string['freemium.downloadmainapplicationsuggestion'] = 'Stránka, ke které se pokoušíte připojit, má vyhrazenou aplikaci, kterou můžete vyzkoušet.';
$string['freemium.feature_biometriclogin'] = 'Biometrické přihlášení';
$string['freemium.feature_coursesdownload'] = 'Stažené kurzy';
$string['freemium.feature_multimediapushnotifications'] = 'Multimediální push notifikace';
$string['freemium.feature_pushnotificationsdevices'] = 'Zařízení pro oznámení push';
$string['freemium.feature_qrlogin'] = 'Ověření pomocí QR kódu';
$string['freemium.feature_remotethemes'] = 'Vzdálená témata';
$string['freemium.feature_sitelogo'] = 'Logo webu';
$string['freemium.notallowed'] = 'Nepovoleno';
$string['freemium.nottoday'] = 'Dnes ne';
$string['freemium.qrlogindisabled'] = 'Pro web není povoleno ověřování v aplikaci pomocí QR kódu:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'Platnost QR kódu vypršela. Obnovte stránku pomocí QR kódu a znovu ji naskenujte.';
$string['freemium.qrloginipmismatch'] = 'Zdá se, že zařízení, které používáte k připojení, není ve stejné síti jako zařízení, které zobrazuje QR kód. Ujistěte se prosím, že jsou obě zařízení připojena ke stejné síti (např. ke stejné síti Wi-Fi).<br><br>Pokud chyba přetrvává, obraťte se na správce svého webu.';
$string['freemium.ratetheapp'] = 'Baví vás naše aplikace?';
$string['freemium.ratetheapp_feedbackko'] = 'Řekněte nám, co je špatně';
$string['freemium.ratetheapp_feedbackmessage'] = 'Vaše zpětná vazba bude anonymní';
$string['freemium.ratetheapp_feedbackok'] = 'Poslat zpětnou vazbu';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Sem něco napište';
$string['freemium.ratetheapp_feedbacksent'] = 'Dík! Vaše zpětná vazba byla úspěšně odeslána.';
$string['freemium.ratetheapp_sendtostore'] = 'Mohl byste si najít chvilku a ohodnotit naši aplikaci? Pomůže nám to aplikaci vylepšit.';
$string['freemium.remindmelater'] = 'Připomenout později';
$string['freemium.settingsoptionsfacial'] = 'Povolit přihlášení pomocí obličeje';
$string['freemium.settingsoptionsfingerprint'] = 'Povolit přihlášení pomocí otisku prstu';
$string['freemium.subscription'] = 'Předplatné stránek';
$string['freemium.subscriptiondetails'] = 'Podrobnosti o předplatném';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} vlastní jazykové řetězce jsou ignorovány';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} vlastní položky nabídky jsou ignorovány';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} nakonfigurované zakázané funkce jsou stále povoleny';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Váš vlastní motiv se nepoužívá';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Logo vašeho webu se nepoužívá';
$string['freemium.subscriptionfeature_limited'] = 'Omezeno na {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Neomezeno';
$string['freemium.subscriptionplan'] = 'Plán předplatného';
$string['freemium.subscriptionplan_expired'] = 'platnost vypršela';
$string['freemium.subscriptionplan_free'] = 'Volné';
$string['freemium.subscriptionplan_upgrade'] = 'Upgradujte svůj plán';
$string['freemium.subscriptionplan_validuntil'] = 'platné do {{ datum }}';
$string['freemium.subscriptionplandescription'] = 'Plány předplatného uvádějí, která omezení platí pro tento web.';
$string['freemium.subscriptionplanlearnmore'] = 'Další informace';
$string['freemium.upsell_renewexpired'] = 'Vaše předplatné vypršelo';
$string['freemium.upsell_renewexpiring'] = 'Vaše předplatné vyprší za {{ dnů }} dnů';
$string['freemium.upsell_renewtitle'] = 'Obnovit předplatné';
$string['freemium.upsell_upgradefreeaccept'] = 'Upgrade';
$string['freemium.upsell_upgradefreemessage'] = 'Momentálně máte bezplatný plán, upgradujte, abyste odemkli další funkce.';
$string['freemium.upsell_upgradefreepostpone'] = 'Později';
$string['freemium.upsell_upgradefreetitle'] = 'Upgradujte svůj plán';
$string['pluginname'] = 'Jazykové řetězce Moodle App';
$string['privacy_metadata'] = 'Tento modul neukládá žádná uživatelská data.';
$string['workplace.teams.isoverdue'] = 'Má položky po termínu nebo jim vypršela platnost';
