<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'es', version '4.4'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Agregando un Encuentro';
$string['addingappointments'] = 'Agregando Encuentros';
$string['addremoveattendees'] = 'Agregar o quitar asistentes';
$string['addsession'] = 'Agregar una sesión';
$string['addtimeframe'] = 'Agregar período de tiempo';
$string['advanced'] = 'Avanzado';
$string['allowcancellations'] = 'Permitir cancelación';
$string['allowcancellations_help'] = 'Si está marcado, los asistentes podrán cancelar su inscripción';
$string['allowcancellationsdefault'] = 'Permitir cancelación por defecto';
$string['allowcancellationsdefault_help'] = 'Si está marcado, cuando se creen nuevas sesiones para esta actividad,  la configuración por defecto admitirá la cancelación de inscripciones';
$string['allowwaitlist'] = 'Permitir lista de espera';
$string['allowwaitlist_help'] = 'Cuando "Habilitar lista de espera" está marcado, los participantes podrán inscribirse a una sesión de Encuentro incluso si el cupo está cubierto.<br />

Cuando un participante se inscribe a una sesión cuyo cupo está completo, recibirá un correo informándole que está en lista de espera y será notificado cuando una haya un lugar disponible en la sesión.';
$string['alreadysignedup'] = 'Ya te has registrado en esta sesión de Encuentro.';
$string['appointment'] = 'Encuentro';
$string['appointment:addattendees'] = 'Agregar asistentes a una sesión de Encuentro';
$string['appointment:addinstance'] = 'Agregar';
$string['appointment:configurecancellation'] = 'Permite la configuración de cancelación de inscripción, al agregar/editar una actividad de Encuentro.';
$string['appointment:editsessions'] = 'Agregar, editar, copiar y borrar sesiones de Encuentro';
$string['appointment:managecustomfields'] = 'Gestionar campos personalizados para sesiones de Encuentro.';
$string['appointment:overbook'] = 'Registrarse en sesiones completas que no tienen habilitada lista de espera.';
$string['appointment:removeattendees'] = 'Eliminar asistentes de una sesión de Encuentro';
$string['appointment:signup'] = 'Registrarse en una sesión';
$string['appointment:takeattendance'] = 'Tomar asistencia';
$string['appointment:view'] = 'Ver actividades y sesiones de Encuentro';
$string['appointment:viewattendees'] = 'Ver listado de asistencia y asistentes';
$string['appointment:viewcancellations'] = 'Ver las cancelaciones';
$string['appointmentactivity'] = 'Actividad Encuentro';
$string['appointmentcustomfields'] = 'Campos personalizados de Encuentro';
$string['appointmentname'] = 'Nombre del Encuentro';
$string['appointments'] = 'Encuentros';
$string['appointmentsession'] = 'Sesión de Encuentro';
$string['appointmentsessiondates'] = 'Fechas de sesión de Encuentro';
$string['appointmentsessions'] = 'Sesiones de Encuentro';
$string['appointmentsettings'] = 'Ajustes de Encuentro';
$string['approvalreqd'] = 'Aprobación requerida';
$string['approvalreqd_help'] = 'Cuando "Aprobación requerida" está marcada, un participante necesitará la aprobación del gestor para poder asistir a una sesión de Encuentro.';
$string['approve'] = 'Aprobar';
$string['attendance'] = 'Asistencia';
$string['attendanceinstructions'] = 'Selecciona usuarios que asistieron a la sesión:';
$string['attendedsession'] = 'Sesión asistida';
$string['attendees'] = 'Asistentes';
$string['attendeestablesummary'] = 'Personas que planearon asistir o han asistido a esta sesión.';
$string['availableplaceholders'] = 'Marcadores de posición disponibles';
$string['availableseats'] = '{$a} cupos disponibles';
$string['book'] = 'Reserva';
$string['bookedat'] = '<strong>Reservado:</strong> {$a}';
$string['bookedvscapacity'] = 'Reservado / Cupo';
$string['bookingcancelled'] = 'Tu inscripción ha sido cancelada.';
$string['bookingcompleted'] = 'Tu incripción ha sido completada.';
$string['bookingfull'] = 'Completo';
$string['bookingopen'] = 'Abierto';
$string['break'] = 'Intervalo';
$string['break_help'] = 'Esta configuración define el intervalo a dejar entre sesiones. Si se deja en 0 significa que no habrá ningún tiempo libre entre una sesión y otra.';
$string['calendareventdescriptionbooking'] = 'Te has inscrito a esta <a href="{$a}">Appointment session</a>.';
$string['calendareventdescriptionsession'] = 'Has creado esta <a href="{$a}">Appointment session</a>.';
$string['calendaroptions'] = 'Opciones de calendario';
$string['cancel'] = 'Cancelar';
$string['cancelbooking'] = 'Cancelar reserva';
$string['cancellationinstrmngr'] = '# Notificación para el gestor';
$string['cancellationinstrmngr_help'] = 'Cuando **Enviar notificación al gestor** está marcado, el texto en el campo **Notificación para el gestor** se envía al gestor para informarle que han cancelado una inscripción a una sesión de Encuentro.';
$string['cancellationmessage'] = 'Mensaje de cancelación';
$string['cancellationmessage_help'] = 'Este mensaje se envía cada vez que los usuarios cancelan su inscripción a una sesión.';
$string['cancellations'] = 'Cancelaciones';
$string['cancellationstablesummary'] = 'Listado de personas que han cancelado sus inscripciones.';
$string['cancelreason'] = 'Motivo de la cancelación';
$string['cannotapproveatcapacity'] = 'No puedes aprobar más asistentes debido a que esta sesión está llena.';
$string['cannotsignupsessioninprogress'] = 'No puedes inscribirte, esta sesión está en progreso';
$string['cannotsignupsessionover'] = 'No puedes inscribirte, esta sesión finalizó.';
$string['capacity'] = 'Cupo';
$string['capacity_help'] = '**Cupo** es la cantidad de inscripciones posibles a una sesión.

Cuando una sesión de Encuentro cubre su cupo, los detalles de la sesión no aparecen en la página del curso. Los detalles se verán grisados en la página "Ver todas las sesiones y el participante no podrá inscribirse a la sesión.
&nbsp;';
$string['closed'] = 'Cerrada';
$string['completionattended'] = 'El estudiante debe agendar y asistir a la cita para completar esta actividad';
$string['completionattended_help'] = 'Si se activa, la actividad se considerará completada si el registro de asistencia del estudiante está marcado como completo o con asistencia parcial.';
$string['completionbooked'] = 'El participante debe reservar un encuentro para completar esta actividad';
$string['completionbooked_help'] = 'Si está habilitada, la actividad se considerará completada si el estado del alumno es "Reservado", "Asistió totalmente" o "Asistió parcialmente". Si el participante canceló, está en la lista de espera o su asistencia está marcada como "No se presentó", la actividad no se considerará completa.';
$string['completiondetail:attended'] = 'Asistencia y cita';
$string['completiondetail:booked'] = 'Reservar asistencia';
$string['confirmationinstrmngr'] = '# Notificación para el gestor';
$string['confirmationinstrmngr_help'] = 'Cuando se marca "Enviar aviso al gestor", el texto en el campo "Aviso para el gestor" se envía para informarle que un usuario se ha inscripto a una sesión de Encuentro.';
$string['confirmationmessage'] = 'Mensaje de confirmación';
$string['confirmationmessage_help'] = 'Este mensaje se envía cada vez que los usuarios se inscriben a una sesión.';
$string['confirmcancelbooking'] = 'Confirmar cancelación';
$string['courseresetsessions'] = 'Remover todas las sesiones';
$string['courseresetsignups'] = 'Remover las inscripciones de todas las sesiones';
$string['crontask'] = 'Trabajos de mantenimiento de Encuentro';
$string['currentstatus'] = 'Estatus actual';
$string['customisednotifications'] = 'Notificaciones personalizadas';
$string['date'] = 'Fecha';
$string['decidelater'] = 'Decidir después';
$string['decline'] = 'Rechazar';
$string['delete'] = 'Borrar';
$string['deleteappointmentconfirm'] = '¿Estás completamente seguro que deseas eliminar este encuentro y todas sus reservas?';
$string['deletesession'] = 'Borrar sesión';
$string['deletetimeframe'] = 'Borrar período de tiempo';
$string['details'] = 'Detalles';
$string['duplicate'] = 'Duplicar';
$string['duplicateappointment'] = 'Duplicar encuentro';
$string['editingappointment'] = 'Editando encuentro';
$string['email:message'] = 'Mensaje';
$string['email:subject'] = 'Asunto';
$string['emailmanager'] = 'Enviar notificación al gestor';
$string['emailmanagercancellation'] = '# Enviar notificación al gestor';
$string['emailmanagercancellation_help'] = 'Cuando "Enviar notificación al gestor" está marcada, se enviará un correo al gestor notificándole que la reserva de un Encuentro ha sido cancelada.';
$string['emailmanagerconfirmation'] = '# Enviar notificación al gestor';
$string['emailmanagerconfirmation_help'] = 'Cuando "enviar notificación al gestor" esté marcado, un correo electrónico de confirmación se enviará al gestor cuando un estudiante se inscriba a una sesión de Encuentros.';
$string['emailmanagerreminder'] = '# Enviar notificación al gestor';
$string['emailmanagerreminder_help'] = 'Cuando se marca "Enviar aviso al gestor", se enviará un mensaje de recordatorio al gestor del participante unos días antes de la fecha de inicio de la sesión de Encuentro.';
$string['empty'] = 'Vacío';
$string['endtime'] = 'Hora de finalización';
$string['entitiysession'] = 'Sesión';
$string['error:cancellationsnotallowed'] = 'No estás habilitado/a para cancelar esta inscripción.';
$string['error:canttakeattendanceforunstartedsession'] = 'No se puede tomar asistencia para una sesión que aún no comenzó.';
$string['error:eventoccurred'] = 'No puedes cancelar un evento que ya se realizó.';
$string['error:invaliduserid'] = 'ID de usuario inválido';
$string['error:manageremailaddressmissing'] = 'Actualmente no tenés asignado un gestor en el sistema. Por favor contactá al administrador del sitio.';
$string['error:sessionsplitexceeds'] = 'El tiempo de corte de la sesión excede la duración de la misma.';
$string['error:sessionstartafterend'] = 'La hora de inicio de la sesión es posterior a la hora de finalización de la sesión.';
$string['errorcannoteditsessions'] = 'No tienes permiso editar sesiones';
$string['errorcannotviewappointment'] = 'No tienes permiso para ver este encuentro';
$string['errorcannotviewattendees'] = 'No tienes permiso para ver asistentes';
$string['eventaddsession'] = 'Sesión agregada';
$string['eventapproverequests'] = 'Solicitudes de aprobación de sesión';
$string['eventattendancetaken'] = 'Asistencia a la sesión tomada';
$string['eventattendeesviewed'] = 'Asistentes a la sesión vistos';
$string['eventcancelbooking'] = 'Reservas canceladas';
$string['eventcourseappointmentviewed'] = 'Instancias vistas de sesiones de Encuentro';
$string['eventcoursemoduleviewed'] = 'Instancia del módulo de Encuentro vista';
$string['eventdeletesession'] = 'Sesión eliminada';
$string['eventsignup'] = 'Registro de sesión';
$string['eventupdatesession'] = 'Sesión actualizada';
$string['full'] = 'La fecha está completa';
$string['fullfilter'] = 'Completa';
$string['goback'] = 'Ir atrás';
$string['icalendarheading'] = 'Archivos adjuntos de iCalendar';
$string['joinwaitlist'] = 'Agregarse a la lista de espera';
$string['location'] = 'Ubicación';
$string['managecustomfields'] = 'Gestionar campos personalizados';
$string['modulename'] = 'Reserva de Encuentro';
$string['modulename_help'] = 'Encuentro es un módulo de actividad para que los profesores realicen un seguimiento de las actividades presenciales.

Permite al profesor configurar un sistema de reservas para una o varias sesiones presenciales, para que los participantes se inscriban.

Este módulo de actividad es adecuado tanto para sesiones 1 a 1 como para actividades de varias sesiones, como seminarios.

Las sesiones pueden tener varias fechas y horas dentro de una sola actividad de Encuentro y se pueden crear de forma masiva utilizando los intervalos de tiempo especificados en la configuración.

La actividad permite el seguimiento de la asistencia.';
$string['modulename_link'] = 'Appointments';
$string['modulenameplural'] = 'Encuentros';
$string['multipleappointments'] = 'Múltiples encuentros';
$string['noactionableunapprovedrequests'] = 'No hay solicitudes no aprobadas procesables';
$string['noremindersneedtobesent'] = 'No se necesita enviar recordatorios.';
$string['nosignedupusers'] = 'Ningún usuario se registró para esta sesión.';
$string['notset'] = 'Sin ajustar';
$string['notsignedup'] = 'No estás registrado para esta sesión.';
$string['partiallyfull'] = 'Parcialmente completa';
$string['placeholder:alldates'] = '[todaslasfechas]';
$string['placeholder:appointmentname'] = '[nombredelencuentro]';
$string['placeholder:attendeeslink'] = '[enlacedeasistentes]';
$string['placeholder:details'] = '[detalles]';
$string['placeholder:finishtime'] = '[tiempodefinalización]';
$string['placeholder:firstname'] = '[nombre/s]';
$string['placeholder:lastname'] = '[apellido/s]';
$string['placeholder:reminderperiod'] = '[períododerecordatorio]';
$string['placeholder:sessiondate'] = '[fechadelasesión]';
$string['placeholder:starttime'] = '[horadeinicio]';
$string['pluginadministration'] = 'Administración de Encuentro';
$string['pluginname'] = 'Encuentro';
$string['potentialattendees'] = 'Potenciales asistentes';
$string['privacy:metadata:appointment_signups'] = 'Registro de usuarios en sesiones de Encuentro';
$string['privacy:metadata:appointment_signups:id'] = 'El ID del registro';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'El tiempo en que el recordatorio se envió por última vez';
$string['privacy:metadata:appointment_signups:sessionid'] = 'El id de la sesión';
$string['privacy:metadata:appointment_signups_status'] = 'El estatus de un usuario que se registró a una sesión';
$string['privacy:metadata:appointment_signups_status:grade'] = 'La calificación otorgada por asistir a la sesión';
$string['privacy:metadata:appointment_signups_status:note'] = 'Almacena el motivo de una sesión cancelada';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'El ID del registro';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'El estado del registro, por ejemplo, cancelado, rechazado, asistió totalmente';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'La hora en que se creó la inscripción.';
$string['privacy:metadata:userid'] = 'El ID del usuario que accedió a la actividad Encuentro';
$string['remindermessage'] = 'Mensaje recordatorio';
$string['remindermessage_help'] = 'Este mensaje se envía unos días antes de la fecha de inicio de una sesión.';
$string['reminderperiod'] = 'Días antes de enviar el mensaje';
$string['reminderperiod_help'] = 'El mensaje recordatorio se enviará este número de días antes del inicio de la sesión.';
$string['requestmessage'] = 'Mensaje requerido';
$string['requestmessage_help'] = 'Cuando **Aprobación requerida** está habilitada, la sección **Solicitar mensaje** está disponible.

La sección **Mensaje requerido** muestra los avisos enviados al participante y a su gestor con respecto al proceso de aprobación para que el alumno asista a la sesión de Encuentro.

**Asunto:** es la línea de asunto que aparece en los correos electrónicos de aprobación de solicitudes enviados al gestor y al participante.

**Mensaje:** es el texto del correo electrónico que se envía al participante para informarle que su solicitud para asistir a la sesión de Encuentro se envió a su gestor para su aprobación.

**Aviso para el gestor:** es el texto del correo electrónico enviado al gestor del participante solicitando aprobación para asistir a la sesión de Encuentro.';
$string['requeststablesummary'] = 'Personas solicitando asistir a esta sesión.';
$string['room'] = 'Sala';
$string['saveattendance'] = 'Guardar asistencia';
$string['search:activity'] = 'Actividades de Encuentro';
$string['seatsavailable'] = 'Cupos disponibles';
$string['seatsbooked'] = 'Cupos reservados';
$string['sessionavailability'] = 'Disponibilidad de sesión';
$string['sessiondatetime'] = 'Fecha/hora de la sesión';
$string['sessiondescription'] = 'Descripción';
$string['sessionduration'] = 'Duración de la sesión';
$string['sessionfinished'] = 'Finalizada';
$string['sessionfinishtime'] = 'Hora de finalización de la sesión';
$string['sessioninprogress'] = 'sesión en curso';
$string['sessionisfull'] = 'Esta sesión está completa. Necesitarás elegir otro horario o hablar con tu docente.';
$string['sessionnotstarted'] = 'Sin comenzar';
$string['sessionrequiresmanagerapproval'] = 'Este sesión requiere la aprobación del gestor para reservar.';
$string['sessions'] = 'Sesiones';
$string['sessionsdetailstablesummary'] = 'Descripción completa de la sesión actual.';
$string['sessionstartdate'] = 'Fecha de inicio de la sesión';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (zona horaria: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (zona horaria: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Hora de inicio de sesión';
$string['sessionstatus'] = 'Estatus de la sesión';
$string['setting:defaultcancellationmessagedefault'] = 'Le informamos que su reserva para la siguiente sesión ha sido cancelada:
<br><br>***RESERVA CANCELADA***<br><br>
Participante: [firstname] [lastname]<br>
Encuentro: [appointmentname]<br><br>
Fecha(s):<br>
[alldates]<br><br>
Ubicación: [session:location]<br>
Lugar: [session:venue]<br>
Sala: [session:room]';
$string['setting:defaultcancellationsubjectdefault'] = 'Cancelación de reserva de Encuentro';
$string['setting:defaultconfirmationmessagedefault'] = 'Esto es para confirmar que reservaste el siguiente Encuentro:
<br><br>
Participante: [firstname] [lastname]<br>
Encuentro: [appointmentname]<br><br>
Fecha(s):<br>
[alldates]<br><br>
Ubicación: [session:locationsession:venue]<br>
Lugar: [sesión:lugar]<br>
Sala: [session:room]<br><br>
***Por favor, llegar diez minutos antes de que comience el Encuentro***<br><br>
Para reprogramar o cancelar su reserva<br>
Para volver a programar tu reserva, debes cancelar esta y luego reservar una nueva sesión.<br>
Para cancelar tu reserva, regresa a la página de Encuentro y luego selecciona \'Cancelar\'.<br><br>
[details]<br><br>
Recibirás un recordatorio [reminderperiod] días hábiles antes del Encuentro.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Confirmación de reserva de Encuentro: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindermessagedefault'] = 'Este es un recordatorio de que reservaste el siguiente Encuentro:<br><br>
Participante: [firstname] [lastname]<br>
Encuentro: [appointmentname]<br><br>
Fecha(s):<br>
[alldates]<br><br>
Ubicación: [session:location]<br>
Lugar: [session:venue]<br>
Sala: [session:room]<br><br>
***Por favor, llegar diez minutos antes de que comience el Encuentro***<br><br>
Para reprogramar o cancelar tu reserva<br>
Para volver a programar tu reserva, debés cancelar esta reserva y luego reservar una nueva sesión.<br>
Para cancelar tu reserva, regresá a la página de Encuentros y luego seleccioná \'Cancelar\'.<br><br>
[details]';
$string['setting:defaultremindersubjectdefault'] = 'Recordatorio de reserva del Encuentro: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestmessagedefault'] = 'Tu solicitud para reservar el siguiente Encuentro se ha enviado a tu gestor:

Participante: [nombre] [apellido]
Encuentro: [appointmentname]

Fecha/s:
[alldates]

Ubicación: [session:location]
Lugar: [session:venue]
Sala: [sesión:sala]';
$string['setting:defaultrequestsubjectdefault'] = 'Solicitud de reserva de Encuentro: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultupdatemessagedefault'] = 'Esto es para informarte que el Encuentro que reservaste o para el que te anotaste en la lista de espera, ha tenido un cambio:<br><br>
Participante:   [firstname] [lastname]<br>
Encuentro:   [appointmentname]<br><br>
Fecha(s):<br>
[alldates]<br><br>
Ubicación:   [session:location]<br>
Lugar:   [session:venue]<br>
Sala:   [session:room]<br><br>
***Por favor, tené en cuenta que ésta no es una confirmación de reserva de Encuentro***<br><br>
Para cancelar tu reserva o tu lugar en la lista de espera, volvé a la página de Encuentro y luego seleccioná \'Cancelar\'.<br><br>
[details]<br><br>';
$string['setting:defaultupdatesubjectdefault'] = 'Actualización de Encuentro: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultwaitlistedmessagedefault'] = 'Esto es para informarte que fuiste agregado/a a la lista de espera para:<br><br>
Encuentro: [appointmentname]<br>
Ubicación: [session:location]<br>
Participante: [firstname] [lastname]<br><br>
***Tené en cuenta que ésta no es una confirmación de reserva de un Encuentro***<br><br>
Al estar en la lista de espera, registraste su interés en este Encuentro y serás contactado/a directamente cuando las sesiones estén disponibles.<br><br>
Para eliminarte de esta lista de espera, regresá a este Encuentro y hacé clic en Cancelar. Tener en cuenta que no hay un correo electrónico de confirmación de eliminación de la lista de espera.';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Aviso para lista de espera de [appointmentname]';
$string['setting:oneemailperday'] = 'Enviar un correo electrónico separado para cada día en eventos que abarquen varios días';
$string['setting:oneemailperday_caption'] = 'Correo electrónico separado para cada día';
$string['settings'] = 'Ajustes';
$string['shortname'] = '# Nombre corto';
$string['shortname_help'] = '**Nombre corto** es la descripción de la sesión que aparece en el calendario de cuando **Mostrar en el calendario** está habilitado.';
$string['showoncalendar'] = 'Configuración de visualización del calendario';
$string['showoncalendar_help'] = 'Cuando **Sitio** está seleccionado las sesiones de Encuentro se mostrarán en el Calendario del sitio como un Evento Global. Todos los usuarios del sitio verán estas sesiones.

Cuando **Curso** está seleccionado todas las sesiones de Encuentro se mostrarán en el calendario de curso como un Evento de curso en el calendario a nivel de sitio y visible para todos los usuarios matriculados en el curso.

Cuando **Ninguno** está seleccionado, las sesiones de Encuentro sólo se mostrarán como Evento de Usuario en el calendario de un usuario que confirmó asistencia, siempre que se haya seleccionado la opción **Mostrar en el calendario del usuario**.';
$string['sign-ups'] = 'Inscripciones';
$string['signupforthissession'] = 'Registrate para esta sesión de Encuentro';
$string['split'] = 'División automática';
$string['split_help'] = 'Esta configuración define la duración de cada sesión creada dentro del marco de tiempo. Establecerlo en 0 deshabilita la opción.';
$string['status'] = 'Estatus';
$string['status_approved'] = 'Aprobado';
$string['status_booked'] = 'Reservada';
$string['status_declined'] = 'Rechazada';
$string['status_fully_attended'] = 'Asistió totalmente';
$string['status_no_show'] = 'No asistió';
$string['status_partially_attended'] = 'Asistió parcialmente';
$string['status_requested'] = 'Requerido';
$string['status_user_cancelled'] = 'Usuario cancelado';
$string['status_waitlisted'] = 'Lista de espera';
$string['suppressemail'] = 'Eliminar notificación por correo electrónico';
$string['suppressemail_help'] = 'Utilizar esta opción si se desea agregar/eliminar usuarios de forma silenciosa de una sesión de Encuentro. Cuando se activa esta opción, el correo electrónico de confirmación no se envía a los usuarios seleccionados.';
$string['takeattendance'] = 'Tomar asistencia';
$string['thirdpartyemailaddress'] = 'Direcciones de correo electrónico de terceros';
$string['thirdpartyemailaddress_help'] = '**Dirección(es) de correo electrónico de terceros** es un campo opcional que se usa para especificar la dirección de correo electrónico de un tercero (como un tutor externo) que luego recibirá mensajes de confirmación cada vez que un usuario se registre en una sesión.
Al introducir **múltiples direcciones de correo electrónico**, separar cada dirección con una coma. Por ejemplo: bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Notificar a terceros sobre sesiones con lista de espera';
$string['thirdpartywaitlist_help'] = 'Cuando se selecciona **Notificar a un tercero sobre las sesiones con lista de espera**, se notificará a los terceros cuando un participante se registre para una sesión en la lista de espera.

Cuando **Notificar a terceros sobre sesiones en lista de espera** no está habilitado, los terceros sólo recibirán una notificación cuando un usuario se registre (o cancele) para una sesión programada.';
$string['timecancelled'] = 'Horario cancelado';
$string['timeframes'] = 'Plazo';
$string['timerequested'] = 'Tiempo requerido';
$string['timesignedup'] = 'Hora de registro';
$string['timestart'] = 'Hora de inicio';
$string['unapprovedrequests'] = 'Solicitudes no aprobadas';
$string['unknowndate'] = '(fecha desconocida)';
$string['unknowntime'] = '(horario desconocido)';
$string['updatemessage'] = 'Mensaje actualizado';
$string['updatemessage_help'] = 'Este mensaje se envía cada vez que se cambie una sesión.';
$string['usercalentry'] = 'Mostrar entrada en el calendario del usuario';
$string['usercalentry_help'] = 'Cuando está activa, esta configuración agrega una entrada de evento de usuario al calendario de un asistente de una sesión de Encuentro. Cuando está desactivado, esto evita que aparezca un evento duplicado en el calendario de un asistente a la sesión, donde tiene la configuración de visualización del calendario establecida en Curso o Sitio.';
$string['usercancelledon'] = 'Usuario cancelado el {$a}';
$string['usernotsignedup'] = 'Estado: no inscripto';
$string['usersignedup'] = 'Estado: inscripto';
$string['usersignedupon'] = 'Usuario inscripto en {$a}';
$string['userwillbewaitlisted'] = 'Esta sesión actualmente se encuentra completa. Haciendo clic en botón "Inscribirse", tendrás lugar en la lista de espera de las sesiones.';
$string['venue'] = 'Lugar';
$string['waitlistedmessage'] = 'Mensaje para lista de espera';
$string['waitlistedmessage_help'] = 'Este mensaje se envía cada vez que los usuarios se registran en una sesión con lista de espera.';
