<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'appointment', language 'it', version '4.4'.
 *
 * @package     appointment
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addingappointment'] = 'Aggiunta meeting';
$string['addingappointments'] = 'Aggiunta meeting';
$string['addremoveattendees'] = 'Aggiungi/rimuovi partecipanti';
$string['addsession'] = 'Aggiungi sessione';
$string['addtimeframe'] = 'Aggiungi periodo di tempo';
$string['advanced'] = 'Avanzato';
$string['allowcancellations'] = 'Consenti cancellazioni';
$string['allowcancellations_help'] = 'I partecipanti potranno cancellare le proprie prenotazioni';
$string['allowcancellationsdefault'] = 'Consenti di default le cancellazioni';
$string['allowcancellationsdefault_help'] = 'L\'impostazione di default quando si creano nuove sessioni in questa attività.';
$string['allowwaitlist'] = 'Abilita lista di attesa';
$string['allowwaitlist_help'] = 'Con la lista di attesa attiva, i corsisti potranno prenotare meeting anche se la sessione è al completo.<br />

I corsisti che si prenotano riceveranno un\'email che li avviserà che sono in lista di attesa e che saranno avvisati qualora si dovesse rendere libero il posto.';
$string['alreadysignedup'] = 'Hai già prenotato questo meeting.';
$string['appointment'] = 'Meeting';
$string['appointment:addattendees'] = 'Aggiunere partecipanti ad una sessione';
$string['appointment:addinstance'] = 'Aggiungere istanza';
$string['appointment:configurecancellation'] = 'Consente la configurazione della cancellazione delle prenotazioni quando si aggiunge o modifica un\'attività meeting.';
$string['appointment:editsessions'] = 'Aggiungere, modificare, copiare ed eliminare meeting';
$string['appointment:managecustomfields'] = 'Gestire campi personalizzati delle sessioni di meeting';
$string['appointment:overbook'] = 'Prenotare sessioni al completo che non hanno la lista di attesa abilitata';
$string['appointment:removeattendees'] = 'Rimuovere partecipanti da sessioni di meeting';
$string['appointment:signup'] = 'Prenotare sessione';
$string['appointment:takeattendance'] = 'Registrare presenza';
$string['appointment:view'] = 'Visualizzare attività meeting e relative sessioni';
$string['appointment:viewattendees'] = 'Visualizzare elenco presenze e partecipanti';
$string['appointment:viewcancellations'] = 'Visualizzare cancellazioni';
$string['appointmentactivity'] = 'Attività meeting';
$string['appointmentcustomfields'] = 'Campi personalizzati del meeting';
$string['appointmentname'] = 'Nome meeting';
$string['appointments'] = 'Meeting';
$string['appointmentsession'] = 'Sessione del meeting';
$string['appointmentsessiondates'] = 'Date della sessione del meeting';
$string['appointmentsessions'] = 'Sessioni del meeting';
$string['appointmentsettings'] = 'Impostazioni meeting';
$string['approvalreqd'] = 'Approvazione obbligatoria';
$string['approvalreqd_help'] = 'Con l\'approvazione obbligatoria, un corsista dovrà ricevere l\'approvazione del proprio manager per partecipare alla sessione del meeting.';
$string['approve'] = 'Approva';
$string['attendance'] = 'Pressenza';
$string['attendanceinstructions'] = 'Selezionare gli utenti che hanno presenziato alla sessione';
$string['attendedsession'] = 'Sessioni presenziate';
$string['attendees'] = 'Partecipanti';
$string['attendeestablesummary'] = 'Persone che hanno in programma di partecipare o hanno partecipato alla sessione.';
$string['availableplaceholders'] = 'Segnaposto disponibili';
$string['availableseats'] = '{$a} posti disponibili';
$string['book'] = 'Prenota';
$string['bookedat'] = '<strong>Prenotato:</strong> {$a}';
$string['bookedvscapacity'] = 'Prenotato / Capienza';
$string['bookingcancelled'] = 'La tua prenotazione è stata cancellata.';
$string['bookingcompleted'] = 'La tua prenotazione è stata registrata.';
$string['bookingfull'] = 'Al completo';
$string['bookingopen'] = 'Aperta';
$string['break'] = 'Durata break';
$string['break_help'] = 'Imposta la durata del break tra sessioni. Impostare a zero per indicare che non sono previsti break.';
$string['calendareventdescriptionbooking'] = 'Hai prenotato la seguente <a href="{$a}">Sessione del meeting</a>.';
$string['calendareventdescriptionsession'] = 'Hai creato la seguente <a href="{$a}">Sessione del meeting</a>.';
$string['calendaroptions'] = 'Opzioni calendario';
$string['cancel'] = 'Cancella';
$string['cancelbooking'] = 'Cancella prenotazione';
$string['cancellationinstrmngr'] = '# Notifica per i manager';
$string['cancellationinstrmngr_help'] = 'Selezionando **Invia notifica ai manager**, il testo redatto nel campo "Notifica ai manager" sarà inviato via email al manager del partecipante in caso di cancellazione della prenotazione.';
$string['cancellationmessage'] = 'Messaggio di cancellazione';
$string['cancellationmessage_help'] = 'Messaggio inviato quando un utente cancella la propria prenotazione di una sessione.';
$string['cancellations'] = 'Cancellazioni';
$string['cancellationstablesummary'] = 'Elenco delle persone che hanno cancellato la loro partecipazione.';
$string['cancelreason'] = 'Motivo della cancellazione';
$string['cannotapproveatcapacity'] = 'Non è possibile approvare altri partecipanti poiché la sessione è al completo.';
$string['cannotsignupsessioninprogress'] = 'Non è possibile partecipare, la sessione è in corso.';
$string['cannotsignupsessionover'] = 'Non è possibile partecipare, la sessione è terminata.';
$string['capacity'] = 'Capienza';
$string['capacity_help'] = 'La **Capienza** è il numero di posti disponibili in una sessione.

Quando la capacità viene raggiunta, i dettagli della sessione non compariranno nella pagina home del corso. I dettagli inoltre appariranno non attivi nella pagina "Visualizza sessioni" e non sarà più possibile effettuare prenotazioni.
&nbsp;';
$string['closed'] = 'Chiuso';
$string['completionattended'] = 'Il partecipante deve prenotare e partecipare per completare l\'attività';
$string['completionattended_help'] = 'L\'attività sarà considerata come completata se la presenza del partecipante risulta "Presente" o "Parzialmente presente".';
$string['completionbooked'] = 'Lo studente deve prenotare per completare l\'attività';
$string['completionbooked_help'] = 'L\'attività sarà considerata come completata se la presenza del partecipante risulta "Prenotato", "Presente" o "Parzialmente presente". Se il partecipante ha cancellato la prenotazione si trova in lista di attesa o il suo stato è "Assente", l\'attività non sarà considerata completata.';
$string['completiondetail:attended'] = 'Partecipa al meeting';
$string['completiondetail:booked'] = 'Prenota meeting';
$string['confirmationinstrmngr'] = '# Notifica per i manager';
$string['confirmationinstrmngr_help'] = 'Selezionando **Invia notifica ai manager**, il testo redatto nel campo "Notifica ai manager" sarà inviato via email al manager del partecipante in caso di prenotazione di una sessione.';
$string['confirmationmessage'] = 'Messaggio di conferma';
$string['confirmationmessage_help'] = 'Messaggio inviato ogni volta che un utente prenota una sessione.';
$string['confirmcancelbooking'] = 'Conferma cancellazione';
$string['courseresetsessions'] = 'Rimuovi tutte le sessioni';
$string['courseresetsignups'] = 'Rimuovi tutte le prenotazioni delle sessioni';
$string['crontask'] = 'Operazioni di manutenzione meeting';
$string['currentstatus'] = 'Stato attuale';
$string['customisednotifications'] = 'Notifiche personalizzate';
$string['date'] = 'Data';
$string['decidelater'] = 'Decidi dopo';
$string['decline'] = 'Rifiuta';
$string['delete'] = 'Elimina';
$string['deleteappointmentconfirm'] = 'Sei sicuro di eliminare questo meeting e tutte le prenotazioni associate?';
$string['deletesession'] = 'Elimina sessione';
$string['deletetimeframe'] = 'Elimina periodo di tempo';
$string['details'] = 'Dettagli';
$string['duplicate'] = 'Duplica';
$string['duplicateappointment'] = 'Duplica meeting';
$string['editingappointment'] = 'Modifica meeting';
$string['email:message'] = 'Messaggio';
$string['email:subject'] = 'Oggetto';
$string['emailmanager'] = 'Invia notifica ai manager';
$string['emailmanagercancellation'] = '# Invia notifica ai manager';
$string['emailmanagercancellation_help'] = 'Selezionando **Invia notifica ai manager**, sarà inviata una email al manager del partecipante in caso di cancellazione della prenotazione.';
$string['emailmanagerconfirmation'] = '# Invia notifica ai manager';
$string['emailmanagerconfirmation_help'] = 'Selezionando **Invia notifica ai manager**, sarà inviata una email di conferma al manager del partecipante in caso di prenotazione di una sessione.';
$string['emailmanagerreminder'] = '# Invia notifica ai manager';
$string['emailmanagerreminder_help'] = 'Selezionando **Invia notifica ai manager**, sarà inviata una email di promemoria al manager del partecipante alcuni giorni prima dell’inizio della sessione.';
$string['empty'] = 'Vuoto';
$string['endtime'] = 'Orario di fine';
$string['entitiysession'] = 'Sessione';
$string['error:cancellationsnotallowed'] = 'Non sei autorizzato a cancellare questa prenotazione.';
$string['error:canttakeattendanceforunstartedsession'] = 'Non è possibile registrare la presenza di sessioni che non sono cominciate.';
$string['error:eventoccurred'] = 'Non è possibile cancellare un evento che è già trascorso.';
$string['error:invaliduserid'] = 'User ID non valido';
$string['error:manageremailaddressmissing'] = 'Al momento non hai nessun manager assegnato. Per favore contatta l\'amministratore del sito.';
$string['error:sessionsplitexceeds'] = 'La suddivisione automatica è superiore alla durate della sessione.';
$string['error:sessionstartafterend'] = 'L\'orario di inizio della sessione e successivo all\'orario di fine.';
$string['errorcannoteditsessions'] = 'Non sei autorizzato a modificare sessioni';
$string['errorcannotviewappointment'] = 'Non sei autorizzato a visualizzare questo meeting';
$string['errorcannotviewattendees'] = 'Non sei autorizzato a visualizzare l\'elenco dei partecipanti';
$string['eventaddsession'] = 'Aggiunta di sessione';
$string['eventapproverequests'] = 'Approvazione prenotazione sessione';
$string['eventattendancetaken'] = 'Partecipazione alla sessione';
$string['eventattendeesviewed'] = 'Visualizzazione partecipanti alla sessione';
$string['eventcancelbooking'] = 'Cancellazione prenotazione sessione';
$string['eventcourseappointmentviewed'] = 'Visualizzazione istanza meeting del corso';
$string['eventcoursemoduleviewed'] = 'Visualizzazione istanza meeting del modulo';
$string['eventdeletesession'] = 'Eliminazione sessione';
$string['eventsignup'] = 'Prenotazione sessione';
$string['eventupdatesession'] = 'Aggiornamento sessione';
$string['full'] = 'La data è al completo';
$string['fullfilter'] = 'Completo';
$string['fullybooked'] = 'Al completo';
$string['goback'] = 'Indietro';
$string['icalendarheading'] = 'Allegati iCal';
$string['joinwaitlist'] = 'Entra in lista di attesa';
$string['location'] = 'Luogo';
$string['managecustomfields'] = 'Gestione campi personalizzati';
$string['modulename'] = 'Prenotazione meeting';
$string['modulename_help'] = 'Il Meeting è una attività che consente di tracciare attività in presenza.

I docenti avranno la possibilità di impostare un sistema di prenotazione di eventi in presenza sia per singoli partecipanti sia per gruppi di persone.

Il Meeting supporta sia sessioni 1 a 1 sia sessioni multiple come i seminari.

All\'interno di uno stesso meeting è possibile avere sessioni in ate diverse che possono anche essere create in massa utilizzando gli slot temporali indicati durante la configurazione.

Il meeting inoltre consente la registrazione delle presenze.';
$string['modulename_link'] = 'Appointments';
$string['modulenameplural'] = 'Meeting';
$string['multipleappointments'] = 'Meeting multipli';
$string['noactionableunapprovedrequests'] = 'Non ci sono richieste non approvate da gestire.';
$string['noremindersneedtobesent'] = 'Non ci sono promemoria da inviare.';
$string['nosignedupusers'] = 'Non ci sono prenotazioni di questa sessione.';
$string['notset'] = 'Non impostato';
$string['notsignedup'] = 'Non hai prenotato questa sessione';
$string['partiallyfull'] = 'Parzialmente completo';
$string['placeholder:alldates'] = '[alldates]';
$string['placeholder:appointmentname'] = '[appointmentname]';
$string['placeholder:attendeeslink'] = '[attendeeslink]';
$string['placeholder:details'] = '[details]';
$string['placeholder:finishtime'] = '[finishtime]';
$string['placeholder:firstname'] = '[firstname]';
$string['placeholder:lastname'] = '[lastname]';
$string['placeholder:reminderperiod'] = '[reminderperiod]';
$string['placeholder:sessiondate'] = '[sessiondate]';
$string['placeholder:starttime'] = '[starttime]';
$string['placeholdersdesc'] = 'Segnaposto';
$string['placeholdersdesc_help'] = 'I segnaposto consentono di aggiungere un contenuto dinamico, ad es. Il segnaposto [firstname] verrà sostituito con il nome dell\'utente nella notifica consegnata all\'utente.';
$string['pluginadministration'] = 'Gestione meeting';
$string['pluginname'] = 'Meeting';
$string['potentialattendees'] = 'Partecipanti potenziali';
$string['privacy:metadata:appointment_signups'] = 'Prenotazione';
$string['privacy:metadata:appointment_signups:id'] = 'ID della prenotazione';
$string['privacy:metadata:appointment_signups:mailedreminder'] = 'Orario di invio più recente del promemoria';
$string['privacy:metadata:appointment_signups:sessionid'] = 'ID della sessione';
$string['privacy:metadata:appointment_signups_status'] = 'Stato della prenotazione dell\'utente';
$string['privacy:metadata:appointment_signups_status:grade'] = 'Punteggio assegnato presenziando alla sessione';
$string['privacy:metadata:appointment_signups_status:note'] = 'Motivo della cancellazione';
$string['privacy:metadata:appointment_signups_status:signupid'] = 'ID della prenotazione';
$string['privacy:metadata:appointment_signups_status:statuscode'] = 'Stato della prenotazione';
$string['privacy:metadata:appointment_signups_status:timecreated'] = 'Orario di creazione della prenotazione';
$string['privacy:metadata:userid'] = 'ID dell\'utente che ha acceduto l’attività Meeting';
$string['remindermessage'] = 'Messaggio di promemoria';
$string['remindermessage_help'] = 'Messaggio inviato nei giorni antecedenti l\'inizio della sessione.';
$string['reminderperiod'] = 'Numero di giorni antecedenti';
$string['reminderperiod_help'] = 'L\'invio del messaggio di promemoria sarà inviato il numero impostato di giorni antecedenti la data di inizio della sessione.';
$string['requestmessage'] = 'Messaggio di richiesta';
$string['requestmessage_help'] = 'Abilitando **Approvazione obbligatoria**, si renderà disponibile la sezione **Messaggio di richiesta**.

La sezione **Messaggio di richiesta** visualizza la notifica, inviata al partecipante a al suo manager, riguardante il processo di approvazione necessario affinché il partecipante possa presenziare al Meeting.

**Oggetto** è l\'oggetto del messaggio che sarà inviato per email a manager e al partecipante.

**Messaggio** è il corpo del messaggio inviato al partecipante per informarlo che la sua richiesta di prenotazione è stata inviata al manager per approvazione.

** Notifica per il manager** è il corpo del messaggio inviato al manager per richiedere l’approvazione.';
$string['requeststablesummary'] = 'Persone che hanno richiesto di partecipare alla sessione.';
$string['room'] = 'Sala';
$string['saveattendance'] = 'Salva partecipazione';
$string['search:activity'] = 'Attività meeting';
$string['seatsavailable'] = 'Posti disponibili';
$string['seatsbooked'] = 'Posti prenotati';
$string['sessionavailability'] = 'Disponibilità delle sessione';
$string['sessiondatetime'] = 'Data/ora delle sessione';
$string['sessiondescription'] = 'Descrizione';
$string['sessionduration'] = 'Durata della sessione';
$string['sessionfinished'] = 'Terminata';
$string['sessionfinishtime'] = 'Orario di fine sessione';
$string['sessioninprogress'] = 'sessione in corso';
$string['sessionisfull'] = 'La sessione è al completo. È necessario selezionare una data diversa oppure rivolgere all\'istruttore.';
$string['sessionnotstarted'] = 'Non iniziato';
$string['sessionrequiresmanagerapproval'] = 'Per prenotare questa sessione è richiesta l\'approvazione del proprio manager.';
$string['sessions'] = 'Sessioni';
$string['sessionsdetailstablesummary'] = 'Descrizione estesa della sessione.';
$string['sessionstartdate'] = 'Data di inizio sessione';
$string['sessionstartdateandtime'] = '{$a->startdate}, {$a->starttime} - {$a->endtime} (Fuso orario: {$a->timezone})';
$string['sessionstartdateandtimewithouttimezone'] = '{$a->startdate}, {$a->starttime} - {$a->endtime}';
$string['sessionstartfinishdateandtime'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime} (fuso orario: {$a->timezone})';
$string['sessionstartfinishdateandtimewithouttimezone'] = '{$a->startdate} - {$a->enddate}, {$a->starttime} - {$a->endtime}';
$string['sessionstarttime'] = 'Data di inizio della sessione';
$string['sessionstatus'] = 'Stato della sessione';
$string['setting:defaultcancellationmessagedefault'] = 'La prenotazione del seguente meeting è stata cancellata:
<br><br>
***PRENOTAZIONE CANCELLATA***<br><br>
Participante:   [firstname] [lastname]<br>
Meeting:   [appointmentname]<br><br>
Date:<br>
[alldates]<br><br>
Luogo:   [session:location]<br>
Sede:   [session:venue]<br>
Sala:   [session:room]';
$string['setting:defaultcancellationsubjectdefault'] = 'Cancellazione prenotazione';
$string['setting:defaultconfirmationmessagedefault'] = 'La prenotazione al seguente meeting è confermata:
Participante:   [firstname] [lastname]<br>
Meeting:   [appointmentname]<br><br>
Date:<br>
[alldates]<br><br>
Luogo:   [session:location]<br>
Sede:   [session:venue]<br>
Sala:   [session:room]<br><br>
*** Si raccomanda di arrivare 10 minuti prima dell\'inizio del meeting***<br><br>
Cambio di prenotazione o cancellazione<br>
Per cambiare la propria prenotazione è necessario prima cancellarla e poi effettuare di nuovo la prenotazione.<br>
Per cancellare la propria prenotazione, recarsi sulla pagina del meeting e cliccare sul pulsante \'Cancella\'.
<br><br>
[details]<br><br>
Un promemoria sarà inviato [reminderperiod] giorni lavortivi antecedenti l\'inizio del meeting.<br><br>';
$string['setting:defaultconfirmationsubjectdefault'] = 'Conferma prenotazione meeting: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultremindermessagedefault'] = 'Si rammenta la prenotazione del seguente meeting:<br><br>
Participante:   [firstname] [lastname]<br>
Meeting:   [appointmentname]<br><br>
Date:<br>
[alldates]<br><br>
Luogo:   [session:location]<br>
Sede:   [session:venue]<br>
Sala:   [session:room]<br><br>
*** Si raccomanda di arrivare 10 minuti prima dell\'inizio del meeting***<br><br>
Cambio di prenotazione o cancellazione<br>
Per cambiare la propria prenotazione è necessario prima cancellarla e poi effettuare di nuovo la prenotazione.<br>
Per cancellare la propria prenotazione, recarsi sulla pagina del meeting e cliccare sul pulsante \'Cancella\'.
<br><br>
[details]';
$string['setting:defaultremindersubjectdefault'] = 'Promemoria prenotazione meeting: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultrequestmessagedefault'] = 'La richiesta di prenotazione del meeting è stata inviata al manager:

Participante:   [firstname] [lastname]
Meeting:   [appointmentname]

Date:
[alldates]

Luogo:   [session:location]
Sede:   [session:venue]
Sala:   [session:room]';
$string['setting:defaultrequestsubjectdefault'] = 'Richiesta prenotazione meeting: [appointmentname], [starttime]-[finishtime]';
$string['setting:defaultupdatemessagedefault'] = 'Il meeting prenotato o prenotato in lista di attesa è stato modificato:
<br><br>
Participante:   [firstname] [lastname]<br>
Meeting:   [appointmentname]<br><br>
Date:<br>
[alldates]<br><br>
Luogo:   [session:location]<br>
Sede:   [session:venue]<br>
Sala:   [session:room]<br><br>
*** Questo messaggio non costituisce conferma della prenotazione***<br><br>
Per cancellare la propria prenotazione o la prenotazione in lista di attesa, recarsi sulla pagina del meeting e cliccare sul pulsante \'Cancella\'.
<br><br>
[details]';
$string['setting:defaultupdatesubjectdefault'] = 'Aggiornamento meeting: [appointmentname], [starttime]-[finishtime], [sessiondate]';
$string['setting:defaultwaitlistedmessagedefault'] = 'L\'inserimento in lista di attesa è confermato:<br><br>
Participante:   [firstname] [lastname]<br>
Meeting:   [appointmentname]<br><br>
Date:<br>
[alldates]<br><br>
Luogo:   [session:location]<br>
Sede:   [session:venue]<br>
Sala:   [session:room]<br><br>
*** Questo messaggio non costituisce conferma della prenotazione***<br><br>
L’inserimento in lista di attesa hai manifestato interesse al meeting e sarai avvisato nel caso si liberino delle sessioni.<br><br>
Per cancellare la propria prenotazione in lista di attesa, recarsi sulla pagina del meeting e cliccare sul pulsante \'Cancella\'.
Da notare che la rimozione dalla lista di attesa non genererà messaggi di conferma della rimozione.';
$string['setting:defaultwaitlistedsubjectdefault'] = 'Inserimento in lista di attesa: [appointmentname]';
$string['setting:oneemailperday'] = 'Invia email separate per eventi su più giorni';
$string['setting:oneemailperday_caption'] = 'Email separate per ciascun giorno';
$string['settings'] = 'Impostazioni';
$string['shortname'] = '# Nome abbreviato';
$string['shortname_help'] = 'Il **Nome abbreviato** è la descrizione che comparirà nel calendario della formazione quando è abilitato **Visualizza nel calendario**.';
$string['showoncalendar'] = 'Opzione visualizzazione nel calendario';
$string['showoncalendar_help'] = 'Sono disponibili le seguenti opzioni:

**Sito** - le sessioni delle attività Meeting saranno visualizzate nel calendario come Eventi globali. Tutti gli utenti potranno visualizzare l\'evento.

**Corso** - le sessioni delle attività Meeting saranno visualizzate nel calendario come Eventi di corso e saranno visibili agli iscritti al corso.

**Nessuno** - le sessioni delle attività Meeting saranno visualizzate nel calendario come Eventi dell\'utente per i soli corsisti confermati, sempre che sia stata attiva l\'impostazione **Visualizza nel calendario dell\'utente**.';
$string['sign-ups'] = 'Prenotazioni';
$string['signupforthissession'] = 'Prenotazioni della sessione';
$string['split'] = 'Suddivisione automatica';
$string['split_help'] = 'Consente di stabilire la durata di ciascuna sessione creata all’interno del periodo di tempo. Impostare a 0 per disabilitare.';
$string['status'] = 'Stato';
$string['status_approved'] = 'Approvata';
$string['status_booked'] = 'Prenotata';
$string['status_declined'] = 'Respinto';
$string['status_fully_attended'] = 'Presente';
$string['status_no_show'] = 'Assente';
$string['status_partially_attended'] = 'Parzialmente presente';
$string['status_requested'] = 'Richiesta';
$string['status_user_cancelled'] = 'Cancellata dall\'utente';
$string['status_waitlisted'] = 'In lista di attesa';
$string['suppressemail'] = 'Evita email di notifica';
$string['suppressemail_help'] = 'Consente di evitare l\'invio di email di notifica quando si rimuovono/inseriscono utenti nelle sessioni.';
$string['takeattendance'] = 'Partecipa';
$string['thirdpartyemailaddress'] = 'Indirizzi email di terzi';
$string['thirdpartyemailaddress_help'] = 'Consente di indicare indirizzi email di terzi (ad esempio un istruttore esterno) dove recapitare i messaggi di prenotazione delle sessioni.
Per inserire **più indirizzi email**, separare gli indirizzi con una virgola, come ad esempio: bob@example.com,joe@example.com';
$string['thirdpartywaitlist'] = 'Avvisa i terzi delle prenotazioni in lista di attesa';
$string['thirdpartywaitlist_help'] = 'Consente di recapitare a terzi i messaggi di prenotazione in lista di attesa delle sessioni. Deselezionando l\'impostazione i terzi saranno avvisati solamente delle prenotazioni e cancellazioni delle sessioni.';
$string['timecancelled'] = 'Orario della cancellazione';
$string['timeframes'] = 'Periodi di tempo';
$string['timerequested'] = 'Orario delle richeista';
$string['timesignedup'] = 'Orario della prenotazione';
$string['timestart'] = 'Orario di inizio';
$string['unapprovedrequests'] = 'Richieste non approvate';
$string['unknowndate'] = '(data sconosciuta)';
$string['unknowntime'] = '(orario sconosciuto)';
$string['updatemessage'] = 'Messaggio di aggiornamento';
$string['updatemessage_help'] = 'Messaggio inviato in presenza di modifiche alle sessioni.';
$string['usercalentry'] = 'Visualizza nel calendario dell\'utente';
$string['usercalentry_help'] = 'La sessione prenotata comparirà nel calendario del corsista come evento utente. È possibile disabilitare l\'opzione per evitare duplicazioni nel calendario quando si impostano le opzioni di visualizzazione del calendario a "Sito" o "Corso".';
$string['usercancelledon'] = 'Cancellazione dell\'utente del {$a}';
$string['usernotsignedup'] = 'Stato: non prenotato';
$string['usersignedup'] = 'Stato: prenotato';
$string['usersignedupon'] = 'Prenotato il {$a}';
$string['userwillbewaitlisted'] = 'La sessione è al completo. Cliccando su "Prenota", sarai inserito nella lista di attesa della sessione.';
$string['venue'] = 'Sede';
$string['waitlistedat'] = '<strong>In lista d\'attesa:</strong> {$a}';
$string['waitlistedmessage'] = 'Messaggio lista di attesa';
$string['waitlistedmessage_help'] = 'Messaggio inviato quando si prenota una sessione in lista di attesa.';
