<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'message', language 'pt', version '4.4'.
 *
 * @package     message
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptandaddcontact'] = 'Aceitar e adicionar aos contactos';
$string['addcontact'] = 'Adicionar contacto';
$string['addcontactconfirm'] = 'Tem a certeza de que pretende adicionar {$a} aos seus contactos?';
$string['addtofavourites'] = 'Marcar com estrela';
$string['addtoyourcontacts'] = 'Adicionar aos contactos';
$string['addtoyourcontactsandmessage'] = 'Adicionar aos contactos e enviar mensagem';
$string['ago'] = '{$a} atrás';
$string['allusers'] = 'Todas as mensagens de todos os utilizadores';
$string['backto'] = 'Voltar para {$a}';
$string['backupmessageshelp'] = 'Se ativar esta opção, as mensagens instantâneas serão incluídas nas cópias de segurança automáticas do site.';
$string['blockcontact'] = 'Bloquear contacto';
$string['blockedusers'] = 'Utilizadores bloqueados';
$string['blocknoncontacts'] = 'Bloquear mensagens de pessoas que não estão na minha lista de contactos';
$string['blockuser'] = 'Bloquear utilizador';
$string['blockuserconfirm'] = 'Tem a certeza de que pretende bloquear {$a}?';
$string['blockuserconfirmbutton'] = 'Bloquear';
$string['cancelselection'] = 'Cancelar a seleção de mensagens';
$string['cantblockuser'] = 'Não pode bloquear \'{$a}\' porque tem um papel com permissão para enviar mensagens para todos os utilizadores.';
$string['contactableprivacy'] = 'Aceitar mensagens de:';
$string['contactableprivacy_coursemember'] = 'Os Meus contactos e qualquer um das minhas disciplinas';
$string['contactableprivacy_onlycontacts'] = 'Apenas os Meus contactos';
$string['contactableprivacy_site'] = 'Qualquer utilizador do site';
$string['contactblocked'] = 'Contacto bloqueado';
$string['contactrequests'] = 'Pedidos de contacto';
$string['contactrequestsent'] = 'Pedido de contacto enviado';
$string['contacts'] = 'Contactos';
$string['conversationactions'] = 'Menu de ações das conversações';
$string['decline'] = 'Rejeitar';
$string['defaultmessageoutputs'] = 'Configurações das notificações';
$string['deleteallconfirm'] = 'Tem a certeza de que pretende apagar esta conversação por completo? Não será apagada para os outros participantes da conversação.';
$string['deleteallmessages'] = 'Apagar todas as mensagens';
$string['deleteallselfconfirm'] = 'Tem a certeza de que pretende apagar esta conversação pessoal?';
$string['deleteconversation'] = 'Apagar conversação';
$string['deleteforeveryone'] = 'Apagar para mim e para todos';
$string['deleteforeveryoneselectedmessagesconfirm'] = 'Tem a certeza de que pretende apagar as mensagens selecionadas?';
$string['deleteselectedmessages'] = 'Apagar as mensagens selecionadas';
$string['deleteselectedmessagesconfirm'] = 'Tem a certeza de que pretende apagar as mensagens selecionadas? Isso não as apagará dos outros participantes da conversação.';
$string['deleteselectedmessagesconfirmselfconversation'] = 'Tem a certeza de que pretende apagar as mensagens pessoais selecionadas?';
$string['disableall'] = 'Desativar notificações';
$string['disabled'] = 'O sistema de mensagens foi desativado neste site';
$string['disallowed'] = 'Bloqueado';
$string['editmessages'] = 'Editar mensagens';
$string['emailtagline'] = 'Este e-mail é uma cópia de uma mensagem enviada para si no site "{$a->sitename}". Aceda a <a href="{$a->url}">{$a->url}</a> para responder.';
$string['enabled'] = 'Ativado';
$string['errorcallingprocessor'] = 'Erro ao chamar método de envio definido';
$string['errorconversationdoesnotexist'] = 'Conversação não existe';
$string['errormessagetoolong'] = 'A mensagem é mais longa do que o máximo permitido.';
$string['errortranslatingdefault'] = 'Ocorreu um erro na tradução dada pelo módulo, irá usar as configurações predefinidas do site.';
$string['eventgroupmessagesent'] = 'Enviada mensagem para grupo';
$string['eventmessagecontactadded'] = 'Contacto de mensagem adicionado';
$string['eventmessagecontactremoved'] = 'Contacto de mensagem removido';
$string['eventmessagedeleted'] = 'Mensagem apagada';
$string['eventmessagesent'] = 'Mensagem enviada';
$string['eventmessageuserblocked'] = 'Utilizador bloqueado';
$string['eventmessageuserunblocked'] = 'Utilizador desbloqueado';
$string['eventmessageviewed'] = 'Mensagem visualizada';
$string['eventnotificationsent'] = 'Notificação enviada';
$string['eventnotificationviewed'] = 'Notificação visualizada';
$string['forced'] = 'Bloqueado';
$string['forcedmessage'] = 'Ativado';
$string['groupconversations'] = 'Grupo';
$string['groupinfo'] = 'Informação do grupo';
$string['guestnoeditmessage'] = 'Os visitantes não podem alterar as definições das mensagens';
$string['guestnoeditmessageother'] = 'Os visitantes não podem alterar as definições das mensagens de outro utilizador';
$string['hidemessagewindow'] = 'Ocultar janela de mensagens';
$string['hidenotificationwindow'] = 'Ocultar janela de notificações';
$string['individualconversations'] = 'Privada';
$string['info'] = 'Informação do utilizador';
$string['isnotinyourcontacts'] = '{$a} não pertence aos seus contactos';
$string['loadmore'] = 'Carregar mais';
$string['loggedin'] = 'Online';
$string['loggedoff'] = 'Offline';
$string['managemessageoutputs'] = 'Predefinições das notificações';
$string['message'] = 'Mensagem';
$string['messagecontactrequest'] = '{$a->user} está a solicitar que adicione como seu contacto. Visite a sua <a href="{$a->url}">página de solicitações de contacto</a> para responder à solicitação';
$string['messagecontactrequestsubject'] = '{$a->sitename}: Solicitação de contacto de {$a->user}';
$string['messagecontentaudio'] = 'Áudio';
$string['messagecontentimage'] = 'Imagem';
$string['messagecontentmultimediageneral'] = 'Outra media';
$string['messagecontentvideo'] = 'Vídeo';
$string['messagedrawerviewcontact'] = 'Detalhes do utilizador {$a}';
$string['messagedrawerviewcontacts'] = 'Contactos da mensagem';
$string['messagedrawerviewconversation'] = 'Conversação com {$a}';
$string['messagedrawerviewgroupinfo'] = 'Detalhes do grupo {$a}';
$string['messagedrawerviewoverview'] = 'Visão global das mensagens';
$string['messagedrawerviewsearch'] = 'Resultados da pesquisa de mensagens para {$a}';
$string['messagedrawerviewsettings'] = 'Configurações da mensagem';
$string['messageoutputs'] = 'Módulos de notificação';
$string['messagepreferences'] = 'Preferências das mensagens';
$string['messages'] = 'Mensagens';
$string['messagesselected:'] = 'Mensagens selecionadas:';
$string['messagetextrequired'] = 'Insira o texto da mensagem';
$string['messagingdatahasnotbeenmigrated'] = 'As suas mensagens estão temporariamente indisponíveis devido a atualizações na infraestrutura de mensagens. Por favor, aguarde que termine a migração.';
$string['muteconversation'] = 'Ignorar';
$string['mutedconversation'] = 'Conversação ignorada';
$string['newmessage'] = 'Nova mensagem';
$string['newmessagesearch'] = 'Selecione ou procure um contacto para enviar uma nova mensagem.';
$string['newonlymsg'] = 'Mostrar apenas as recentes';
$string['nocontactrequests'] = 'Sem pedidos de contacto';
$string['nocontacts'] = 'Sem contactos';
$string['nocontactsgetstarted'] = 'Sem contactos';
$string['nofavourites'] = 'Nenhuma conversação com estrela';
$string['noframesjs'] = 'Usar interface mais acessível';
$string['nogroupconversations'] = 'Nenhuma conversação de grupo';
$string['noindividualconversations'] = 'Nenhuma conversação privada';
$string['nomessagesfound'] = 'Não foram encontradas mensagens';
$string['noncontacts'] = 'Outros contactos';
$string['nonotifications'] = 'Não tem notificações';
$string['noparticipants'] = 'Sem participantes';
$string['noreply'] = 'Não responda a esta mensagem';
$string['notificationdatahasnotbeenmigrated'] = 'As suas notificações estão temporariamente indisponíveis devido a atualizações na infraestrutura de notificações. Por favor, aguarde que termine a migração.';
$string['notificationimage'] = 'Imagem da notificação';
$string['notificationpreferences'] = 'Preferências das notificações';
$string['notifications'] = 'Notificações';
$string['notificationwindow'] = 'Janela da notificação';
$string['notincontacts'] = 'Tem de adicionar {$a} aos seus contactos para poder enviar mensagens.';
$string['notincontactsheading'] = '{$a} não pertence aos seus contactos';
$string['numparticipants'] = '{$a} participantes';
$string['off'] = 'Off';
$string['offline'] = 'Offline';
$string['on'] = 'On';
$string['online'] = 'Online';
$string['otherparticipants'] = 'Outros participantes';
$string['outputnotavailable'] = 'Não está disponível';
$string['page-message-x'] = 'Qualquer página de mensagens';
$string['participants'] = 'Participantes';
$string['pendingcontactrequests'] = 'Tem {$a} solicitações de contacto pendentes';
$string['permitted'] = 'Permitido';
$string['privacy'] = 'Privacidade';
$string['privacy:export:conversationprefix'] = 'Conversação:';
$string['privacy:metadata:core_favourites'] = 'As conversas marcadas com uma estrela pelo utilizador';
$string['privacy:metadata:message_contact_requests'] = 'A lista de pedidos de contacto';
$string['privacy:metadata:message_contact_requests:requesteduserid'] = 'O ID do utilizador que recebeu o pedido de contacto';
$string['privacy:metadata:message_contact_requests:timecreated'] = 'Data e hora em que o pedido de contacto foi criado';
$string['privacy:metadata:message_contact_requests:userid'] = 'O ID do utilizador que enviou o pedido de contacto';
$string['privacy:metadata:message_contacts'] = 'A lista de contactos';
$string['privacy:metadata:message_contacts:contactid'] = 'O ID do utilizador que é o cantacto';
$string['privacy:metadata:message_contacts:timecreated'] = 'Data e hora em que o contacto foi criado';
$string['privacy:metadata:message_contacts:userid'] = 'O ID do utilizador cuja lista de contacto estamos a visualizar';
$string['privacy:metadata:message_conversation_actions'] = 'A lista de ações das conversações do utilizador';
$string['privacy:metadata:message_conversation_actions:action'] = 'A ação que foi executada';
$string['privacy:metadata:message_conversation_actions:conversationid'] = 'O ID da conversação a que pertence esta ação';
$string['privacy:metadata:message_conversation_actions:timecreated'] = 'Data e hora em que a ação foi criada';
$string['privacy:metadata:message_conversation_actions:userid'] = 'O ID do utilizador que executou esta ação';
$string['privacy:metadata:message_conversation_members'] = 'Lista de utilizadores na conversação';
$string['privacy:metadata:message_conversation_members:conversationid'] = 'ID da conversação';
$string['privacy:metadata:message_conversation_members:timecreated'] = 'Data e hora em que o membro foi criado';
$string['privacy:metadata:message_conversation_members:userid'] = 'O ID do utilizador numa conversação';
$string['privacy:metadata:message_user_actions'] = 'A lista de ações do utilizador da mensagem';
$string['privacy:metadata:message_user_actions:action'] = 'A ação que foi executada';
$string['privacy:metadata:message_user_actions:messageid'] = 'O ID da mensagem a que pertence esta ação';
$string['privacy:metadata:message_user_actions:timecreated'] = 'Data e hora em que a ação foi criada';
$string['privacy:metadata:message_user_actions:userid'] = 'O ID do utilizador que executou esta ação';
$string['privacy:metadata:message_users_blocked'] = 'A lista de utilizadores bloqueados';
$string['privacy:metadata:message_users_blocked:blockeduserid'] = 'O ID do utilizador que foi bloqueado';
$string['privacy:metadata:message_users_blocked:timecreated'] = 'Data e hora em que a ação de bloqueio foi criada';
$string['privacy:metadata:message_users_blocked:userid'] = 'O ID do utilizador que executou a ação de bloqueio';
$string['privacy:metadata:messages'] = 'Mensagens';
$string['privacy:metadata:messages:conversationid'] = 'O ID da conversação';
$string['privacy:metadata:messages:customdata'] = 'Dados personalizados normalmente contêm IDs internos e um URL público da imagem do remetente (utilizador ou grupo)';
$string['privacy:metadata:messages:fullmessage'] = 'A mensagem completa';
$string['privacy:metadata:messages:fullmessageformat'] = 'O formato da mensagem completa';
$string['privacy:metadata:messages:fullmessagehtml'] = 'O formato da mensagem completa';
$string['privacy:metadata:messages:smallmessage'] = 'Versão reduzida da mensagem';
$string['privacy:metadata:messages:subject'] = 'O assunto da mensagem';
$string['privacy:metadata:messages:timecreated'] = 'Data e hora em que a mensagem foi criada';
$string['privacy:metadata:messages:useridfrom'] = 'O ID do utilizador que enviou a mensagem';
$string['privacy:metadata:notifications'] = 'Notificações';
$string['privacy:metadata:notifications:component'] = 'O componente responsável pelo envio da notificação';
$string['privacy:metadata:notifications:contexturl'] = 'O URL relacionado com esta notificação';
$string['privacy:metadata:notifications:contexturlname'] = 'O nome do contexto';
$string['privacy:metadata:notifications:customdata'] = 'Os dados personalizados normalmente contêm IDs internos e um URL público da imagem do remetente (se existir).';
$string['privacy:metadata:notifications:eventtype'] = 'O tipo de evento';
$string['privacy:metadata:notifications:fullmessage'] = 'A notificação completa';
$string['privacy:metadata:notifications:fullmessageformat'] = 'O formato da notificação';
$string['privacy:metadata:notifications:fullmessagehtml'] = 'O HTML da notificação';
$string['privacy:metadata:notifications:smallmessage'] = 'Uma pequena mensagem da notificação';
$string['privacy:metadata:notifications:subject'] = 'O assunto da notificação';
$string['privacy:metadata:notifications:timecreated'] = 'Data e hora em que foi criada a notificação';
$string['privacy:metadata:notifications:timeread'] = 'A data e hora em que a notificação foi lida';
$string['privacy:metadata:notifications:useridfrom'] = 'O ID do utilizador que enviou a notificação';
$string['privacy:metadata:notifications:useridto'] = 'O ID do utilizador que recebeu a notificação';
$string['privacy:metadata:preference:core_message_settings'] = 'Configurações relacionadas com troca de mensagens';
$string['privacy:request:preference:set'] = 'O valor da configuração \'{$a->name}\' era \'{$a->value}\'';
$string['privacy_desc'] = 'Pode restringir as pessoas que podem enviar-lhe uma mensagem';
$string['processorsettings'] = 'Configurações do processador';
$string['providerenabled'] = 'Estado da ativação do envio de "{$a}"';
$string['providerprocesorisdisallowed'] = '"{$a->provider}" via "{$a->processor}" está bloqueado';
$string['providerprocesorislocked'] = '"{$a->provider}" via "{$a->processor}" está ativado';
$string['removecontact'] = 'Remover contacto';
$string['removecontactconfirm'] = 'Tem a certeza de que pretende remover {$a} dos seus contactos?';
$string['removecoursefilter'] = 'Remover filtro para a disciplina {$a}';
$string['removefromfavourites'] = 'Remover estrela';
$string['removefromyourcontacts'] = 'Remover dos contactos';
$string['requirecontacttomessage'] = 'Tem de pedir a {$a} que o adicione como um contacto para lhe(s) poder enviar mensagens.';
$string['requiresconfiguration'] = 'Requer configuração';
$string['searchcombined'] = 'Pesquisar pessoas e mensagens';
$string['searchforuser'] = 'Procurar um utilizador';
$string['searchforuserorcourse'] = 'Procurar um utilizador ou uma disciplina';
$string['searchmessages'] = 'Procurar mensagens';
$string['seeall'] = 'Ver todas';
$string['selectmessagestodelete'] = 'Selecione as mensagens a apagar';
$string['selectnotificationtoview'] = 'Selecione da lista de notificações ao lado para ver mais detalhes';
$string['selfconversation'] = 'Área pessoal';
$string['selfconversationdefaultmessage'] = 'Guarde rascunhos de mensagens, hiperligações, notas, etc. para aceder mais tarde.';
$string['send'] = 'Enviar';
$string['sendbulkmessage'] = 'Enviar mensagem para {$a} participantes';
$string['sendbulkmessagesent'] = 'Mensagem enviada para {$a} utilizadores';
$string['sendbulkmessagesentsingle'] = 'Mensagem enviada para 1 utilizador';
$string['sendbulkmessagesingle'] = 'Enviar mensagem para 1 participante';
$string['sendcontactrequest'] = 'Enviar pedido de contacto';
$string['sender'] = '{$a}:';
$string['sendingviaenabled'] = 'Estado da ativação do envio de "{$a->provider}" via "{$a->processor}"';
$string['sendingvialocked'] = 'Estado do bloqueio do envio de "{$a->provider}" via "{$a->processor}"';
$string['sendmessage'] = 'Enviar mensagem';
$string['sendmessageto'] = 'Enviar mensagem para {$a}';
$string['sendmessagetopopup'] = 'Enviar mensagem para {$a} - nova janela';
$string['settings'] = 'Configurações';
$string['showmessagewindownonew'] = 'Mostrar janela de mensagem sem novas mensagens';
$string['showmessagewindowwithcount'] = 'Mostrar janela de mensagem com {$a} mensagens novas';
$string['shownotificationwindownonew'] = 'Mostrar janela da notificação sem novas notificações';
$string['shownotificationwindowwithcount'] = 'Mostrar janela da notificação com {$a} notificações novas';
$string['togglemessagemenu'] = 'Alternar a caixa de mensagens';
$string['togglenotificationmenu'] = 'Alternar o menu de notificações';
$string['totalconversations'] = '{$a} conversações';
$string['touserdoesntexist'] = 'Não pode enviar uma mensagem ao utilizador com ID ({$a}) que não existe.';
$string['unabletomessage'] = 'Não é permitido enviar mensagens para este utilizador';
$string['unblock'] = 'Desbloquear';
$string['unblockcontact'] = 'Desbloquear contacto';
$string['unblockuser'] = 'Desbloquear utilizador';
$string['unblockuserconfirm'] = 'Tem a certeza de que pretende desbloquear {$a}?';
$string['unknownuser'] = 'Utilizador desconhecido';
$string['unmuteconversation'] = 'Não ignorar';
$string['unreadconversations'] = 'Tem {$a} conversações não lidas';
$string['unreadmessages'] = 'Tem {$a} mensagens não lidas';
$string['unreadnewgroupconversationmessage'] = 'Nova mensagem de {$a->name} na conversação {$a->conversationname}';
$string['unreadnewmessage'] = 'Nova mensagem de {$a}';
$string['unreadnotification'] = 'Notificação não lida: {$a}';
$string['unreadnotifications'] = 'Tem {$a} notificações não lidas';
$string['useentertosend'] = 'Usar \'Enter\' para enviar';
$string['usercantbemessaged'] = 'Não pode enviar mensagens para este utilizador devido às suas preferências de mensagem. Tente adicioná-lo como contacto.';
$string['userwouldliketocontactyou'] = '{$a} gostaria de entrar em contacto consigo';
$string['viewfullnotification'] = 'Ver notificação completa';
$string['viewmessageswith'] = 'Visualizar mensagens com {$a}';
$string['viewnotificationresource'] = 'Ir para: {$a}';
$string['viewunreadmessageswith'] = 'Ver mensagens não lidas com {$a}';
$string['waitingforcontactaccept'] = 'A aguardar ser adicionado como contacto';
$string['wouldliketocontactyou'] = 'Gostaria de entrar em contacto consigo';
$string['writeamessage'] = 'Escreva a mensagem...';
$string['you'] = 'Eu:';
$string['youhaveblockeduser'] = 'Bloqueou este utilizador.';
$string['yourcontactrequestpending'] = 'O seu pedido de contacto com {$a} está pendente';
