<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'editor_tinymce', language 'lt', version '4.4'.
 *
 * @package     editor_tinymce
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advanced:address'] = 'Adresas';
$string['advanced:anchor_delta_height'] = '';
$string['advanced:anchor_delta_width'] = '';
$string['advanced:anchor_desc'] = 'Įterpti / redaguoti prieraišą';
$string['advanced:backcolor_desc'] = 'Pasirinkti fono spalvą';
$string['advanced:block'] = 'Formatas';
$string['advanced:blockquote'] = 'Įtrauka';
$string['advanced:blockquote_desc'] = 'Įtrauka';
$string['advanced:bold_desc'] = 'Paryškintasis (Ctrl+B)';
$string['advanced:bullist_desc'] = 'Nesurikiuotas sąrašas';
$string['advanced:charmap_delta_height'] = '';
$string['advanced:charmap_delta_width'] = '';
$string['advanced:charmap_desc'] = 'Įterpti pasirinktinį simbolį';
$string['advanced:cleanup_desc'] = 'Valyti netinkamą kodą';
$string['advanced:clipboard_msg'] = 'Funkcijos Kopijuoti / Iškirpti / Įklijuoti neprieinamos naršyklėse „Mozilla“ ir „Firefox“. Ar norite daugiau informacijos apie šią problemą?';
$string['advanced:code'] = 'Kodas';
$string['advanced:code_desc'] = 'Redaguoti HTML šaltinį';
$string['advanced:colorpicker_delta_height'] = '';
$string['advanced:colorpicker_delta_width'] = '';
$string['advanced:copy_desc'] = 'Kopijuoti';
$string['advanced:custom1_desc'] = 'Čia galite įvesti pasirinktinį aprašą';
$string['advanced:cut_desc'] = 'Iškirpti';
$string['advanced:dd'] = 'Apibrėžimo aprašas';
$string['advanced:div'] = '„Div“ žymė';
$string['advanced:dt'] = 'Apibrėžimo terminas';
$string['advanced:font_size'] = 'Šrifto dydis';
$string['advanced:fontdefault'] = 'Šriftų grupė';
$string['advanced:forecolor_desc'] = 'Pasirinkti teksto spalvą';
$string['advanced:h1'] = '1 antraštė';
$string['advanced:h2'] = '2 antraštė';
$string['advanced:h3'] = '3 antraštė';
$string['advanced:h4'] = '4 antraštė';
$string['advanced:h5'] = '5 antraštė';
$string['advanced:h6'] = '6 antraštė';
$string['advanced:help_desc'] = 'Žinynas';
$string['advanced:help_shortcut'] = 'Spauskite ALT-F10 įrankių juostai. Spauskite ALT-0 pagalbai';
$string['advanced:hr_desc'] = 'Įterpti horizontaliąją liniuotę';
$string['advanced:image_delta_height'] = '';
$string['advanced:image_delta_width'] = '';
$string['advanced:image_desc'] = 'Įterpti / redaguoti vaizdą';
$string['advanced:image_props_desc'] = 'Vaizdo ypatybės';
$string['advanced:indent_desc'] = 'Įtrauka';
$string['advanced:italic_desc'] = 'Pasvirasis (Ctrl+I)';
$string['advanced:justifycenter_desc'] = 'Lygiuoti centre';
$string['advanced:justifyfull_desc'] = 'Lygiuoti abiejose pusėse';
$string['advanced:justifyleft_desc'] = 'Lygiuoti kairėje';
$string['advanced:justifyright_desc'] = 'Lygiuoti dešinėje';
$string['advanced:link_delta_height'] = '';
$string['advanced:link_delta_width'] = '70';
$string['advanced:link_desc'] = 'Įterpti / redaguoti nuorodą';
$string['advanced:more_colors'] = 'Daugiau spalvų...';
$string['advanced:newdocument'] = 'Ar tikrai norite ištrinti visą turinį?';
$string['advanced:newdocument_desc'] = 'Naujas dokumentas';
$string['advanced:numlist_desc'] = 'Surikiuotas sąrašas';
$string['advanced:outdent_desc'] = 'Atvirkštinė įtrauka';
$string['advanced:paragraph'] = 'Pastraipa';
$string['advanced:paste_desc'] = 'Įklijuoti';
$string['advanced:path'] = 'Kelias';
$string['advanced:pre'] = 'Suformatuota iš anksto';
$string['advanced:redo_desc'] = 'Perdaryti (Ctrl+Y)';
$string['advanced:removeformat_desc'] = 'Pašalinti formatavimą';
$string['advanced:rich_text_area'] = 'Raiškaus teksto sritis';
$string['advanced:samp'] = 'Kodo pavyzdys';
$string['advanced:shortcuts_desc'] = 'Pritaikomumo pagalba';
$string['advanced:striketrough_desc'] = 'Perbraukimas';
$string['advanced:style_select'] = 'Stiliai';
$string['advanced:sub_desc'] = 'Apatinis indeksas';
$string['advanced:sup_desc'] = 'Viršutinis indeksas';
$string['advanced:toolbar'] = 'Įrankių juosta';
$string['advanced:toolbar_focus'] = 'Nukreipti į įrankių mygtukus – Alt+Q, nukreipti į rengyklę– Alt-Z, nukreipti į elemento kelią – Alt-X';
$string['advanced:underline_desc'] = 'Pabrauktasis (Ctrl+U)';
$string['advanced:undo_desc'] = 'Anuliuoti (Ctrl+Z)';
$string['advanced:unlink_desc'] = 'Atsieti';
$string['advanced:visualaid_desc'] = 'Perjungti gaires / nematomus elementus';
$string['advanced_dlg:'] = '&nbsp;';
$string['advanced_dlg:about_author'] = 'Autorius';
$string['advanced_dlg:about_general'] = 'Apie';
$string['advanced_dlg:about_help'] = 'Žinynas';
$string['advanced_dlg:about_license'] = 'Licencija';
$string['advanced_dlg:about_loaded'] = 'Įkelti papildiniai';
$string['advanced_dlg:about_plugin'] = 'Papildinys';
$string['advanced_dlg:about_plugins'] = 'Papildiniai';
$string['advanced_dlg:about_title'] = 'Apie „TinyMCE“';
$string['advanced_dlg:about_version'] = 'Versija';
$string['advanced_dlg:accessibility_help'] = 'Pritaikomumo pagalba';
$string['advanced_dlg:accessibility_usage_title'] = 'Bendras naudojimas';
$string['advanced_dlg:anchor_invalid'] = 'Nurodykite galiojantį prieraišo pavadinimą.';
$string['advanced_dlg:anchor_name'] = 'Prieraišo pavadinimas';
$string['advanced_dlg:anchor_title'] = 'Įterpti / redaguoti prieraišą';
$string['advanced_dlg:charmap_title'] = 'Pasirinkti pasirinktinį simbolį';
$string['advanced_dlg:charmap_usage'] = 'Naršymui naudokite rodykles į kairę ir į dešinę.';
$string['advanced_dlg:code_title'] = 'HTML rengyklė';
$string['advanced_dlg:code_wordwrap'] = 'Žodžių kėlimas';
$string['advanced_dlg:colorpicker_color'] = 'Spalva:';
$string['advanced_dlg:colorpicker_name'] = 'Pavadinimas:';
$string['advanced_dlg:colorpicker_named_tab'] = 'Įvardyta';
$string['advanced_dlg:colorpicker_named_title'] = 'Įvardytosios spalvos';
$string['advanced_dlg:colorpicker_palette_tab'] = 'Paletė';
$string['advanced_dlg:colorpicker_palette_title'] = 'Paletės spalvos';
$string['advanced_dlg:colorpicker_picker_tab'] = 'Parinkiklis';
$string['advanced_dlg:colorpicker_picker_title'] = 'Spalvų parinkiklis';
$string['advanced_dlg:colorpicker_title'] = 'Pasirinkti spalvą';
$string['advanced_dlg:image_align'] = 'Lygiuotė';
$string['advanced_dlg:image_align_baseline'] = 'Bazinė linija';
$string['advanced_dlg:image_align_bottom'] = 'Apačioje';
$string['advanced_dlg:image_align_left'] = 'Kairėje';
$string['advanced_dlg:image_align_middle'] = 'Viduryje';
$string['advanced_dlg:image_align_right'] = 'Dešinėje';
$string['advanced_dlg:image_align_textbottom'] = 'Teksto apačioje';
$string['advanced_dlg:image_align_texttop'] = 'Teksto viršuje';
$string['advanced_dlg:image_align_top'] = 'Viršuje';
$string['advanced_dlg:image_alt'] = 'Vaizdo aprašas';
$string['advanced_dlg:image_border'] = 'Kraštinė';
$string['advanced_dlg:image_dimensions'] = 'Matmenys';
$string['advanced_dlg:image_hspace'] = 'Horizontalusis tarpas';
$string['advanced_dlg:image_list'] = 'Vaizdų sąrašas';
$string['advanced_dlg:image_src'] = 'Vaizdo URL';
$string['advanced_dlg:image_title'] = 'Įterpti / redaguoti vaizdą';
$string['advanced_dlg:image_vspace'] = 'Vertikalusis tarpas';
$string['advanced_dlg:invalid_color_value'] = 'Neteisinga spalvos reikšmė';
$string['advanced_dlg:link_is_email'] = 'Jūsų įvestas URL yra el. pašto adresas. Ar norite įtraukti būtiną priešvardį „mailto:“?';
$string['advanced_dlg:link_is_external'] = 'Jūsų įvestas URL yra išorinis saitas. Ar norite įtraukti būtiną priešvardį „http://“?';
$string['advanced_dlg:link_list'] = 'Saitų sąrašas';
$string['advanced_dlg:link_target'] = 'Paskirties vieta';
$string['advanced_dlg:link_target_blank'] = 'Atidaryti saitą naujame lange';
$string['advanced_dlg:link_target_same'] = 'Atidaryti saitą tame pačiame lange';
$string['advanced_dlg:link_title'] = 'Įterpti / redaguoti nuorodą';
$string['advanced_dlg:link_titlefield'] = 'Pavadinimas';
$string['advanced_dlg:link_url'] = 'Saito URL';
$string['advhr:advhr_desc'] = 'Horizontalioji liniuotė';
$string['advhr:delta_height'] = '';
$string['advhr:delta_width'] = '10';
$string['advhr_dlg:normal'] = 'Normalus';
$string['advhr_dlg:noshade'] = 'Be šešėlio';
$string['advhr_dlg:size'] = 'Aukštis';
$string['advhr_dlg:width'] = 'Plotis';
$string['advhr_dlg:widthunits'] = 'Vienetai';
$string['advimage:delta_height'] = '';
$string['advimage:delta_width'] = '10';
$string['advimage:image_desc'] = 'Įterpti / redaguoti vaizdą';
$string['advimage_dlg:align'] = 'Lygiuotė';
$string['advimage_dlg:align_baseline'] = 'Bazinė linija';
$string['advimage_dlg:align_bottom'] = 'Apačioje';
$string['advimage_dlg:align_left'] = 'Kairėje';
$string['advimage_dlg:align_middle'] = 'Viduryje';
$string['advimage_dlg:align_right'] = 'Dešinėje';
$string['advimage_dlg:align_textbottom'] = 'Teksto apačioje';
$string['advimage_dlg:align_texttop'] = 'Teksto viršuje';
$string['advimage_dlg:align_top'] = 'Viršuje';
$string['advimage_dlg:alt'] = 'Vaizdo aprašas';
$string['advimage_dlg:alt_image'] = 'Alternatyvusis vaizdas';
$string['advimage_dlg:border'] = 'Kraštinė';
$string['advimage_dlg:classes'] = 'Klasės';
$string['advimage_dlg:constrain_proportions'] = 'Ribojamosios proporcijos';
$string['advimage_dlg:dialog_title'] = 'Įterpti / redaguoti vaizdą';
$string['advimage_dlg:dimensions'] = 'Matmenys';
$string['advimage_dlg:example_img'] = 'Išvaizdos peržiūros vaizdas';
$string['advimage_dlg:general'] = 'Bendra';
$string['advimage_dlg:height'] = 'Aukštis';
$string['advimage_dlg:hspace'] = 'Horizontalusis tarpas';
$string['advimage_dlg:id'] = 'ID';
$string['advimage_dlg:image_list'] = 'Vaizdų sąrašas';
$string['advimage_dlg:langcode'] = 'Kalbos kodas';
$string['advimage_dlg:langdir'] = 'Kalbos kryptis';
$string['advimage_dlg:list'] = 'Vaizdų sąrašas';
$string['advimage_dlg:long_desc'] = 'Ilgojo aprašo saitas';
$string['advimage_dlg:ltr'] = 'Iš kairės į dešinę';
$string['advimage_dlg:map'] = 'Daugiasaitis vaizdas';
$string['advimage_dlg:misc'] = 'Kita';
$string['advimage_dlg:missing_alt'] = 'Ar tikrai norite tęsti neįtraukę vaizdo aprašo? Be aprašo vaizdas gali būti neprieinamas kai kuriems negalią turintiems naudotojams, naudojantiems teksto naršyklę arba naršantiems internete esant išjungtai vaizdo rodymo funkcijai.';
$string['advimage_dlg:mouseout'] = 'patraukus pelės žymiklį';
$string['advimage_dlg:mouseover'] = 'nukreipus pelės žymiklį';
$string['advimage_dlg:preview'] = 'Peržiūra';
$string['advimage_dlg:rtl'] = 'Iš dešinės į kairę';
$string['advimage_dlg:src'] = 'Vaizdo URL';
$string['advimage_dlg:style'] = 'Stilius';
$string['advimage_dlg:swap_image'] = 'Sukeisti vaizdus';
$string['advimage_dlg:tab_advanced'] = 'Išplėsta';
$string['advimage_dlg:tab_appearance'] = 'Išvaizda';
$string['advimage_dlg:tab_general'] = 'Bendra';
$string['advimage_dlg:title'] = 'Pavadinimas';
$string['advimage_dlg:vspace'] = 'Vertikalusis tarpas';
$string['advimage_dlg:width'] = 'Plotis';
$string['advlink:delta_height'] = '';
$string['advlink:delta_width'] = '10';
$string['advlink:link_desc'] = 'Įterpti / redaguoti nuorodą';
$string['advlink_dlg:accesskey'] = 'Prieigos klavišas';
$string['advlink_dlg:advanced_props'] = 'Išplėstinės ypatybės';
$string['advlink_dlg:advanced_tab'] = 'Išplėsta';
$string['advlink_dlg:anchor_names'] = 'Prieraišai';
$string['advlink_dlg:classes'] = 'Klasės';
$string['advlink_dlg:encoding'] = 'Paskirties vietos simbolių kodavimas';
$string['advlink_dlg:event_props'] = 'Įvykiai';
$string['advlink_dlg:events_tab'] = 'Įvykiai';
$string['advlink_dlg:general_props'] = 'Bendrosios ypatybės';
$string['advlink_dlg:general_tab'] = 'Bendra';
$string['advlink_dlg:height'] = 'Aukštis';
$string['advlink_dlg:id'] = 'ID';
$string['advlink_dlg:is_email'] = 'Jūsų įvestas URL yra el. pašto adresas. Ar norite įtraukti būtiną priešvardį „mailto:“?';
$string['advlink_dlg:is_external'] = 'Jūsų įvestas URL yra išorinis saitas. Ar norite įtraukti būtiną priešvardį „http://“?';
$string['advlink_dlg:langcode'] = 'Kalbos kodas';
$string['advlink_dlg:langdir'] = 'Kalbos kryptis';
$string['advlink_dlg:link_list'] = 'Saitų sąrašas';
$string['advlink_dlg:list'] = 'Saitų sąrašas';
$string['advlink_dlg:ltr'] = 'Iš kairės į dešinę';
$string['advlink_dlg:mime'] = 'Paskirties vietos MIME tipas';
$string['advlink_dlg:popup'] = '„Javascript“ iššokantysis langas';
$string['advlink_dlg:popup_dependent'] = 'Priklausomasis (tik „Mozilla“ / „Firefox“)';
$string['advlink_dlg:popup_location'] = 'Rodyti vietos juostą';
$string['advlink_dlg:popup_menubar'] = 'Rodyti meniu juostą';
$string['advlink_dlg:popup_name'] = 'Lango pavadinimas';
$string['advlink_dlg:popup_opts'] = 'Parinktys';
$string['advlink_dlg:popup_position'] = 'Vieta (X/Y)';
$string['advlink_dlg:popup_props'] = 'Iššokančiojo lango ypatybės';
$string['advlink_dlg:popup_resizable'] = 'Nustatyti langą kaip keičiamo dydžio';
$string['advlink_dlg:popup_return'] = 'Įterpti Grąžinti klaidingą';
$string['advlink_dlg:popup_scrollbars'] = 'Rodyti slinkties juostas';
$string['advlink_dlg:popup_size'] = 'Dydis';
$string['advlink_dlg:popup_statusbar'] = 'Rodyti būsenos juostą';
$string['advlink_dlg:popup_tab'] = 'Iššokantysis langas';
$string['advlink_dlg:popup_toolbar'] = 'Rodyti įrankių juostas';
$string['advlink_dlg:popup_url'] = 'Iššokančiojo lango URL';
$string['advlink_dlg:rel'] = 'Ryšys Puslapis su paskirties vieta';
$string['advlink_dlg:rev'] = 'Ryšys Paskirties vieta su puslapiu';
$string['advlink_dlg:rtl'] = 'Iš dešinės į kairę';
$string['advlink_dlg:style'] = 'Stilius';
$string['advlink_dlg:tabindex'] = 'Tabuliacijos indeksas';
$string['advlink_dlg:target'] = 'Paskirties vieta';
$string['advlink_dlg:target_blank'] = 'Atidaryti naujame lange';
$string['advlink_dlg:target_langcode'] = 'Paskirties kalba';
$string['advlink_dlg:target_name'] = 'Paskirties vietos pavadinimas';
$string['advlink_dlg:target_parent'] = 'Atidaryti pirminiame lange / rėmelyje';
$string['advlink_dlg:target_same'] = 'Atidaryti šiame lange / rėmelyje';
$string['advlink_dlg:target_top'] = 'Atidaryti viršutiniame rėmelyje (pakeičia visus rėmelius)';
$string['advlink_dlg:title'] = 'Įterpti / redaguoti nuorodą';
$string['advlink_dlg:titlefield'] = 'Pavadinimas';
$string['advlink_dlg:url'] = 'Saito URL';
$string['advlink_dlg:width'] = 'Plotis';
$string['advlist:circle'] = 'Apskritimas';
$string['advlist:def'] = 'Numatyta';
$string['advlist:disc'] = 'Diskas';
$string['advlist:lower_alpha'] = 'Mažoji alfa';
$string['advlist:lower_greek'] = 'Mažoji graikų';
$string['advlist:lower_roman'] = 'Mažoji romėnų';
$string['advlist:square'] = 'Kvadratas';
$string['advlist:types'] = 'Tipai';
$string['advlist:upper_alpha'] = 'Didžioji alfa';
$string['advlist:upper_roman'] = 'Didžioji romėnų';
$string['aria:rich_text_area'] = 'Raiškaus teksto sritis';
$string['autosave:restore_content'] = 'Atkurti automatiškai įrašytą turinį.';
$string['autosave:unload_msg'] = 'Išėję iš šio puslapio prarasite visus atliktus keitimus.';
$string['autosave:warning_message'] = 'Atkūrę įrašytą turinį prarasite visą dabar rengyklėje esantį turinį. Ar tikrai norite atkurti įrašytą turinį?';
$string['availablebuttons'] = 'Galimi mygtukai';
$string['colors:000000'] = 'Juoda';
$string['colors:000080'] = 'Tamsiai mėlyna';
$string['colors:0000FF'] = 'Mėlyna';
$string['colors:003300'] = 'Tamsiai žalia';
$string['colors:003366'] = 'Tamsiai žydra';
$string['colors:008000'] = 'Žalia';
$string['colors:008080'] = 'Žalsvai mėlyna';
$string['colors:00CCFF'] = 'Dangaus mėlyna';
$string['colors:00FF00'] = 'Gelsvai žalsva';
$string['colors:00FFFF'] = 'Vandens';
$string['colors:333300'] = 'Tamsiai alyvuogių';
$string['colors:333333'] = 'Labai tamsi pilka';
$string['colors:333399'] = 'Indigo';
$string['colors:3366FF'] = 'Karališka mėlyna';
$string['colors:339966'] = 'Jūros žalia';
$string['colors:33CCCC'] = 'Turkio';
$string['colors:666699'] = 'Pilkšvai mėlyna';
$string['colors:800000'] = 'Kaštoninė';
$string['colors:800080'] = 'Violetinė';
$string['colors:808000'] = 'Alyvuogių';
$string['colors:808080'] = 'Pilka';
$string['colors:993300'] = 'Ryški oranžinė';
$string['colors:993366'] = 'Ruda';
$string['colors:999999'] = 'Vidutiniškai pilka';
$string['colors:99CC00'] = 'Geltonai žalia';
$string['colors:99CCFF'] = 'Šviesiai mėlyna';
$string['colors:C0C0C0'] = 'Sidabrinė';
$string['colors:CC99FF'] = 'Slyvų';
$string['colors:CCFFCC'] = 'Blyškiai žalia';
$string['colors:CCFFFF'] = 'Blyškiai žydra';
$string['colors:FF0000'] = 'Raudona';
$string['colors:FF00FF'] = 'Purpurinė';
$string['colors:FF6600'] = 'Oranžinė';
$string['colors:FF9900'] = 'Gintaro';
$string['colors:FF99CC'] = 'Rožinė';
$string['colors:FFCC00'] = 'Aukso';
$string['colors:FFCC99'] = 'Persikų';
$string['colors:FFFF00'] = 'Geltona';
$string['colors:FFFF99'] = 'Šviesiai geltona';
$string['colors:FFFFFF'] = 'Balta';
$string['common:apply'] = 'Taikyti';
$string['common:browse'] = 'Naršyti';
$string['common:cancel'] = 'Atšaukti';
$string['common:class_name'] = 'Klasė';
$string['common:clipboard_msg'] = 'Funkcijos Kopijuoti / Iškirpti / Įklijuoti neprieinamos naršyklėse „Mozilla“ ir „Firefox“. Ar norite daugiau informacijos apie šią problemą?';
$string['common:clipboard_no_support'] = 'Jūsų naršyklė dabar nepalaiko. Naudokite klaviatūros sparčiuosius klavišus.';
$string['common:close'] = 'Uždaryti';
$string['common:edit_confirm'] = 'Ar naudodami šią teksto sritį norite įjungti WYSIWYG režimą?';
$string['common:insert'] = 'Įterpti';
$string['common:invalid_data'] = 'Klaida: įvestos klaidingos reikšmės (pažymėta raudonai).';
$string['common:invalid_data_min'] = '{#field} turi būti skaičius, didesnis nei {#min}';
$string['common:invalid_data_number'] = '{#field} privalo būti skaičius';
$string['common:invalid_data_size'] = '{#field} privalo būti skaičius arba procentai';
$string['common:more_colors'] = 'Daugiau spalvų...';
$string['common:not_set'] = 'Nenustatyta';
$string['common:popup_blocked'] = 'Atsiprašome, bet pastebėjome, kad jūsų jūsų iššokančiųjų langų blokavimo programa išjungė langą, kuriame pateiktos taikomosios programos funkcijos. Norėdami naudotis visomis šio įrankio galimybėmis išjunkite iššokančiųjų langų blokavimą šioje svetainėje.';
$string['common:update'] = 'Atnaujinti';
$string['common:value'] = '(vertė)';
$string['contextmenu:align'] = 'Lygiuotė';
$string['contextmenu:center'] = 'Centre';
$string['contextmenu:full'] = 'Iš abiejų pusių';
$string['contextmenu:left'] = 'Kairėje';
$string['contextmenu:right'] = 'Dešinėje';
$string['customconfig'] = 'Pasirinktinė konfigūracija';
$string['customconfig_desc'] = 'Tinkinta išplėstinė TinyMCE konfigūracija JSON formatu, pavyzdžiui: {"option1" : "value2", "option2" : "value2"}. Bet kurios čia nurodytos parinktys nepaiso standartinių ir papildinio nustatymų.';
$string['customtoolbar'] = 'Rengyklės įrankių juosta';
$string['customtoolbar_desc'] = 'Kiekvienoje eilutėje yra kableliais atskirtų mygtukų pavadinimų sąrašas, naudokite „wrap“ kaip grupės skyriklį, tuščios eilutės nepaisomos. Numatytųjų TinyMCE mygtukų sąrašą žr. <a href="{$a}" target="_blank">{$a}</a>.<br />Visada bus rodoma pirmoji eilutė, o kaip bus matomos antra ir trečia įrankių juostos galima perjungti.';
$string['directionality:ltr_desc'] = 'Kryptis Iš kairės į dešinę';
$string['directionality:rtl_desc'] = 'Kryptis Iš dešinės į kairę';
$string['emotions:delta_height'] = '';
$string['emotions:delta_width'] = '';
$string['emotions:emotions_desc'] = 'Jaustukai';
$string['emotions_dlg:cool'] = 'Kietas';
$string['emotions_dlg:cry'] = 'Verkiantis';
$string['emotions_dlg:desc'] = 'Jaustukai';
$string['emotions_dlg:embarassed'] = 'Susigėdęs';
$string['emotions_dlg:foot_in_mouth'] = 'Koja burnoje';
$string['emotions_dlg:frown'] = 'Susiraukęs';
$string['emotions_dlg:innocent'] = 'Nekaltas';
$string['emotions_dlg:kiss'] = 'Bučinys';
$string['emotions_dlg:laughing'] = 'Juokiasi';
$string['emotions_dlg:money_mouth'] = 'Pinigai burnoje';
$string['emotions_dlg:sealed'] = 'Tylintis';
$string['emotions_dlg:smile'] = 'Šypsena';
$string['emotions_dlg:surprised'] = 'Nustebęs';
$string['emotions_dlg:title'] = 'Įterpti jaustuką';
$string['emotions_dlg:tongue_out'] = 'Rodo liežuvį';
$string['emotions_dlg:undecided'] = 'Galvojantis';
$string['emotions_dlg:usage'] = 'Naršymui naudokite rodykles į kairę ir į dešinę.';
$string['emotions_dlg:wink'] = 'Mirksintis';
$string['emotions_dlg:yell'] = 'Klyksmas';
$string['fontselectlist'] = 'Galimų šriftų sąrašas';
$string['fullpage:delta_height'] = '';
$string['fullpage:delta_width'] = '10';
$string['fullpage:desc'] = 'Dokumento ypatybės';
$string['fullpage_dlg:active_color'] = 'Aktyvi spalva';
$string['fullpage_dlg:add'] = 'Įtraukti naują elementą';
$string['fullpage_dlg:add_base'] = 'Bazinis elementas';
$string['fullpage_dlg:add_comment'] = 'Komentarų mazgas';
$string['fullpage_dlg:add_link'] = 'Nuorodos elementas';
$string['fullpage_dlg:add_meta'] = 'Metaelementas';
$string['fullpage_dlg:add_script'] = 'Scenarijaus elementas';
$string['fullpage_dlg:add_style'] = 'Stiliaus elementas';
$string['fullpage_dlg:add_title'] = 'Pavadinimo elementas';
$string['fullpage_dlg:advanced_props'] = 'Išplėsta';
$string['fullpage_dlg:advanced_tab'] = 'Išplėsta';
$string['fullpage_dlg:appearance_bgprops'] = 'Fono ypatybės';
$string['fullpage_dlg:appearance_linkprops'] = 'Saitų spalvos';
$string['fullpage_dlg:appearance_marginprops'] = 'Teksto paraštės';
$string['fullpage_dlg:appearance_style'] = 'Stilių aprašo ir stilių ypatybės';
$string['fullpage_dlg:appearance_tab'] = 'Išvaizda';
$string['fullpage_dlg:appearance_textprops'] = 'Teksto ypatybės';
$string['fullpage_dlg:author'] = 'Autorius';
$string['fullpage_dlg:base_element'] = 'Bazinis elementas';
$string['fullpage_dlg:bgcolor'] = 'Fono spalva';
$string['fullpage_dlg:bgimage'] = 'Fono vaizdas';
$string['fullpage_dlg:bottom_margin'] = 'Apatinė paraštė';
$string['fullpage_dlg:charset'] = 'Koduotė';
$string['fullpage_dlg:comment_element'] = 'Komentaras';
$string['fullpage_dlg:content'] = 'Turinys';
$string['fullpage_dlg:copyright'] = 'Autoriaus teisės';
$string['fullpage_dlg:defer'] = 'Atidėti';
$string['fullpage_dlg:doctypes'] = 'Dokumento tipas';
$string['fullpage_dlg:encoding'] = 'Simbolių kodavimas';
$string['fullpage_dlg:font_face'] = 'Šriftas';
$string['fullpage_dlg:font_size'] = 'Šrifto dydis';
$string['fullpage_dlg:fontface'] = 'Šriftų grupė';
$string['fullpage_dlg:fontsize'] = 'Šrifto dydis';
$string['fullpage_dlg:general_props'] = 'Bendra';
$string['fullpage_dlg:head_elements'] = 'Antraštės elementai';
$string['fullpage_dlg:hover_color'] = 'Laikyti virš spalvos';
$string['fullpage_dlg:href'] = 'HREF';
$string['fullpage_dlg:hreflang'] = 'HREF kalba';
$string['fullpage_dlg:info'] = 'Informacija';
$string['fullpage_dlg:langcode'] = 'Kalbos kodas';
$string['fullpage_dlg:langdir'] = 'Kalbos kryptis';
$string['fullpage_dlg:langprops'] = 'Kalba ir kodavimas';
$string['fullpage_dlg:language'] = 'Kalba';
$string['fullpage_dlg:left_margin'] = 'Kairioji paraštė';
$string['fullpage_dlg:link_color'] = 'Saito spalva';
$string['fullpage_dlg:link_element'] = 'Saito elementas';
$string['fullpage_dlg:ltr'] = 'Iš kairės į dešinę';
$string['fullpage_dlg:media'] = 'Medija';
$string['fullpage_dlg:meta_description'] = 'Aprašas';
$string['fullpage_dlg:meta_element'] = 'Metaelementas';
$string['fullpage_dlg:meta_index_follow'] = 'Indeksuoti ir atidaryti saitus';
$string['fullpage_dlg:meta_index_nofollow'] = 'Indeksuoti ir neatidaryti saitų';
$string['fullpage_dlg:meta_keywords'] = 'Raktiniai žodžiai';
$string['fullpage_dlg:meta_noindex_follow'] = 'Neindeksuoti, bet atidaryti saitus';
$string['fullpage_dlg:meta_noindex_nofollow'] = 'Neindeksuoti ir neatidaryti saitų';
$string['fullpage_dlg:meta_props'] = 'Metainformacija';
$string['fullpage_dlg:meta_robots'] = 'Robotai';
$string['fullpage_dlg:meta_tab'] = 'Bendra';
$string['fullpage_dlg:meta_title'] = 'Pavadinimas';
$string['fullpage_dlg:movedown'] = 'Perkelti pasirinktą elementą žemyn';
$string['fullpage_dlg:moveup'] = 'Perkelti pasirinktą elementą aukštyn';
$string['fullpage_dlg:name'] = 'Pavadinimas';
$string['fullpage_dlg:properties'] = 'Ypatybės';
$string['fullpage_dlg:rel'] = 'Ryšys';
$string['fullpage_dlg:remove'] = 'Pašalinti pažymėtą elementą';
$string['fullpage_dlg:rev'] = 'Peržiūra';
$string['fullpage_dlg:right_margin'] = 'Dešinioji paraštė';
$string['fullpage_dlg:rtl'] = 'Iš dešinės į kairę';
$string['fullpage_dlg:script_element'] = 'Scenarijaus elementas';
$string['fullpage_dlg:src'] = 'Šaltinis';
$string['fullpage_dlg:style'] = 'Stilius';
$string['fullpage_dlg:style_element'] = 'Stiliaus elementas';
$string['fullpage_dlg:stylesheet'] = 'Stilių aprašas';
$string['fullpage_dlg:target'] = 'Paskirties vieta';
$string['fullpage_dlg:text_color'] = 'Teksto spalva';
$string['fullpage_dlg:textcolor'] = 'Spalva';
$string['fullpage_dlg:title'] = 'Dokumento ypatybės';
$string['fullpage_dlg:title_element'] = 'Pavadinimo elementas';
$string['fullpage_dlg:top_margin'] = 'Viršutinė paraštė';
$string['fullpage_dlg:type'] = 'Tipas';
$string['fullpage_dlg:value'] = 'Reikšmė';
$string['fullpage_dlg:visited_color'] = 'Peržiūrėta spalva';
$string['fullpage_dlg:xml_pi'] = 'XML aprašas';
$string['fullscreen:desc'] = 'Perjungti viso ekrano režimą';
$string['iespell:download'] = '„ieSpell“ neaptikta. Ar norite jį įdiegti dabar?';
$string['iespell:iespell_desc'] = 'Vykdyti rašybos tikrinimą';
$string['insertdatetime:date_fmt'] = '%Y-%m-%d';
$string['insertdatetime:day_long'] = 'Sekmadienis, Pirmadienis, Antradienis, Trečiadienis, Ketvirtadienis, Penktadienis, Šeštadienis, Sekmadienis';
$string['insertdatetime:day_short'] = 'Sekm., Pirm., Antr., Treč., Ketv., Penk., Šešt., Sekm.';
$string['insertdatetime:insertdate_desc'] = 'Įterpti datą';
$string['insertdatetime:inserttime_desc'] = 'Įterpti laiką';
$string['insertdatetime:months_long'] = 'Sausis, Vasaris, Kovas, Balandis, Gegužė, Birželis, Liepa, Rugpjūtis, Rugsėjis, Spalis, Lapkritis, Gruodis';
$string['insertdatetime:months_short'] = 'Sau., Vas., Kov., Bal., Geg., Bir., Lie., Rgp., Rgs., Spl., Lap., Grd.';
$string['insertdatetime:time_fmt'] = '%H:%M:%S';
$string['layer:absolute_desc'] = 'Perjungti absoliutųjį išdėstymą';
$string['layer:backward_desc'] = 'Perkelti atgal';
$string['layer:content'] = 'Naujas lygmuo...';
$string['layer:forward_desc'] = 'Perkelti pirmyn';
$string['layer:insertlayer_desc'] = 'Įterpti naują lygmenį';
$string['media:delta_height'] = '';
$string['media:delta_width'] = '10';
$string['media:desc'] = 'Įterpti / redaguoti įdėtąją mediją';
$string['media:edit'] = 'Redaguoti įdėtąją mediją';
$string['media_dlg:advanced'] = 'Išplėsta';
$string['media_dlg:align'] = 'Lygiuoti';
$string['media_dlg:align_bottom'] = 'Apačioje';
$string['media_dlg:align_bottom_left'] = 'Apačios kairėje';
$string['media_dlg:align_bottom_right'] = 'Apačios dešinėje';
$string['media_dlg:align_center'] = 'Centre';
$string['media_dlg:align_left'] = 'Kairėje';
$string['media_dlg:align_right'] = 'Dešinėje';
$string['media_dlg:align_top'] = 'Viršuje';
$string['media_dlg:align_top_left'] = 'Viršaus kairėje';
$string['media_dlg:align_top_right'] = 'Viršaus dešinėje';
$string['media_dlg:altsource1'] = 'Alternatyvus šaltinis 1';
$string['media_dlg:altsource2'] = 'Alternatyvus šaltinis 2';
$string['media_dlg:audio'] = 'HTML5 garso įrašas';
$string['media_dlg:autogotourl'] = 'Automatiškai atidaryti URL';
$string['media_dlg:autohref'] = 'Auto HREF';
$string['media_dlg:autostart'] = 'Automatinis paleidimas';
$string['media_dlg:balance'] = 'Balansas';
$string['media_dlg:base'] = 'Bazinis';
$string['media_dlg:baseurl'] = 'Bazinis URL';
$string['media_dlg:bgcolor'] = 'Fonas';
$string['media_dlg:cache'] = 'Talpykla';
$string['media_dlg:captioningid'] = 'Antraštės ID';
$string['media_dlg:center'] = 'Centre';
$string['media_dlg:class_name'] = 'Klasė';
$string['media_dlg:console'] = 'Konsolė';
$string['media_dlg:constrain_proportions'] = 'Ribojamosios proporcijos';
$string['media_dlg:controller'] = 'Valdiklis';
$string['media_dlg:controls'] = 'Valdikliai';
$string['media_dlg:correction'] = 'Nėra pataisų';
$string['media_dlg:currentmarker'] = 'Dabartinis žymeklis';
$string['media_dlg:currentposition'] = 'Dabartinė padėtis';
$string['media_dlg:defaultframe'] = 'Numatytasis rėmelis';
$string['media_dlg:embedded_audio_options'] = 'Įdėtojo garso parinktys';
$string['media_dlg:embeddedaudio'] = 'Įdėtasis garsas';
$string['media_dlg:enabled'] = 'Įjungta';
$string['media_dlg:enablejavascript'] = 'Įjungti „JavaScript“';
$string['media_dlg:endtime'] = 'Pabaigos laikas';
$string['media_dlg:file'] = 'Failas / URL';
$string['media_dlg:flash'] = '„Flash“';
$string['media_dlg:flash_options'] = '„Flash“ parinktys';
$string['media_dlg:flashvars'] = '„Flash“ kintamieji';
$string['media_dlg:fullscreen'] = 'Viso ekrano režimas';
$string['media_dlg:general'] = 'Bendra';
$string['media_dlg:hidden'] = 'Paslėptas';
$string['media_dlg:href'] = 'HREF';
$string['media_dlg:hspace'] = 'Horizotalusis tarpas';
$string['media_dlg:html5_audio_options'] = 'Garso parinktys';
$string['media_dlg:html5_video_options'] = 'HTML5 vaizdo įrašo parinktys';
$string['media_dlg:id'] = 'ID';
$string['media_dlg:iframe'] = 'Iframe';
$string['media_dlg:imagestatus'] = 'Vaizdo būsena';
$string['media_dlg:invokeurls'] = 'Iškviesti URL';
$string['media_dlg:kioskmode'] = 'Viešojo terminalo režimas';
$string['media_dlg:list'] = 'Sąrašas';
$string['media_dlg:liveconnect'] = 'SWLiveConnect';
$string['media_dlg:loop'] = 'Ciklas';
$string['media_dlg:maintainaspect'] = 'Tvarkyti proporcijas';
$string['media_dlg:menu'] = 'Rodyti meniu';
$string['media_dlg:mute'] = 'Nutildyti';
$string['media_dlg:name'] = 'Pavadinimas';
$string['media_dlg:nojava'] = 'Be „Java“';
$string['media_dlg:numloop'] = 'Ciklų skaičius';
$string['media_dlg:play'] = 'Automatinis paleidimas';
$string['media_dlg:playcount'] = 'Įrašo leidimo skaitiklis';
$string['media_dlg:playeveryframe'] = 'Paleisti kiekvieną rėmelį';
$string['media_dlg:poster'] = 'Plakatas';
$string['media_dlg:prefetch'] = 'Išankstinis iškvietimas';
$string['media_dlg:preload'] = 'Išankstinis įkėlimas';
$string['media_dlg:preload_auto'] = 'Leisti naudotojo naršyklei nuspręsti';
$string['media_dlg:preload_metadata'] = 'Iš anksto įkelti vaizdo įrašo metaduomenis';
$string['media_dlg:preload_none'] = 'Neįkelti iš anksto';
$string['media_dlg:preview'] = 'Peržiūra';
$string['media_dlg:progress'] = 'Eiga';
$string['media_dlg:qt_options'] = '„QuickTime“ parinktys';
$string['media_dlg:qt_stream_warn'] = 'Srautu siunčiami RTSP ištekliai turi būti įtraukti į išplėstiniame skirtuke esantį lauką „QT Src“. Taip pat į  lauką „Src“ turite įtraukti ir nesiunčiamą versiją.';
$string['media_dlg:qtsrc'] = 'QT šaltinis';
$string['media_dlg:qtsrcchokespeed'] = 'Prislopinimo greitis';
$string['media_dlg:quality'] = 'Kokybė';
$string['media_dlg:quicktime'] = '„QuickTime“';
$string['media_dlg:rate'] = 'Dažnis';
$string['media_dlg:realmedia'] = '„Real Media“';
$string['media_dlg:rmp_options'] = '„Real Media Player“ parinktys';
$string['media_dlg:salign'] = 'S lygiuotė';
$string['media_dlg:scale'] = 'Mastelis';
$string['media_dlg:scriptcallbacks'] = 'Scenarijaus atgaliniai iškvietimai';
$string['media_dlg:shockwave'] = 'Shockwave';
$string['media_dlg:shockwave_options'] = '„Shockwave“ parinktys';
$string['media_dlg:shuffle'] = 'Maišymas';
$string['media_dlg:size'] = 'Matmenys';
$string['media_dlg:sound'] = 'Garsas';
$string['media_dlg:source'] = 'Šaltinis';
$string['media_dlg:starttime'] = 'Pradžios laikas';
$string['media_dlg:stretchtofit'] = 'Ištempti, kad tilptų';
$string['media_dlg:swstretchhalign'] = 'Ištempti horizontaliąją lygiuotę';
$string['media_dlg:swstretchstyle'] = 'Ištempti Stilių';
$string['media_dlg:swstretchvalign'] = 'Ištempti vertikaliąją lygiuotę';
$string['media_dlg:target'] = 'Paskirties vieta';
$string['media_dlg:targetcache'] = 'Paskirties vietos talpykla';
$string['media_dlg:title'] = 'Įterpti / redaguoti įdėtąją mediją';
$string['media_dlg:type'] = 'Tipas';
$string['media_dlg:uimode'] = 'UI režimas';
$string['media_dlg:video'] = 'HTML5 vaizdo įrašas';
$string['media_dlg:volume'] = 'Garsumas';
$string['media_dlg:vspace'] = 'Vertikalusis tarpas';
$string['media_dlg:windowlessvideo'] = 'Vaizdas be lango';
$string['media_dlg:windowsmedia'] = 'Windows Media';
$string['media_dlg:wmode'] = 'W režimas';
$string['media_dlg:wmp_options'] = '„Windows Media Player“ parinktys';
$string['nonbreaking:nonbreaking_desc'] = 'Įterpti nekeliamojo tarpo simbolį';
$string['pagebreak:desc'] = 'Įterpti puslapio lūžį';
$string['paste:paste_text_desc'] = 'Įklijuoti kaip paprastąjį tekstą';
$string['paste:paste_word_desc'] = 'Įklijuoti iš programos „Word“';
$string['paste:plaintext_mode'] = 'Dabar įklijuojama paprastojo teksto režimu. Spustelėkite dar kartą, kad vėl perjungtumėte įprastą įklijavimo režimą.';
$string['paste:plaintext_mode_stick'] = 'Įklijavimas dabar veikia paprasto teksto režimu. Spustelėkite dar kartą, kad grįžtumėte į įprastą įklijavimo režimą.';
$string['paste:selectall_desc'] = 'Pasirinkti viską';
$string['paste_dlg:text_linebreaks'] = 'Išlaikyti eilučių lūžius';
$string['paste_dlg:text_title'] = 'Norėdami į langą įklijuoti tekstą, naudokite klaviatūros klavišus CTRL+V.';
$string['paste_dlg:word_title'] = 'Norėdami į langą įklijuoti tekstą, naudokite klaviatūros klavišus CTRL+V.';
$string['pluginname'] = 'TinyMCE HTML rengyklė (sena)';
$string['preview:preview_desc'] = 'Peržiūra';
$string['print:print_desc'] = 'Spausdinti';
$string['privacy:metadata'] = 'TinyMCE HTML rengyklės papildinys nesaugo jokių asmeninių duomenų.';
$string['save:cancel_desc'] = 'Atšaukti visus keitimus';
$string['save:save_desc'] = 'Įrašyti';
$string['searchreplace:delta_height'] = '20';
$string['searchreplace:delta_width'] = '10';
$string['searchreplace:replace_desc'] = 'Rasti / keisti';
$string['searchreplace:search_desc'] = 'Rasti';
$string['searchreplace_dlg:allreplaced'] = 'Pakeisti visi paieškos eilutės atvejai.';
$string['searchreplace_dlg:direction'] = 'Kryptis';
$string['searchreplace_dlg:down'] = 'Žemyn';
$string['searchreplace_dlg:findnext'] = 'Rasti kitą';
$string['searchreplace_dlg:findwhat'] = 'Ką rasti';
$string['searchreplace_dlg:mcase'] = 'Skirti didžiąsias ir mažąsias raides';
$string['searchreplace_dlg:notfound'] = 'Paieška baigta. Paieškos eilutės nepavyko rasti.';
$string['searchreplace_dlg:replace'] = 'Keisti';
$string['searchreplace_dlg:replace_title'] = 'Rasti / keisti';
$string['searchreplace_dlg:replaceall'] = 'Keisti viską';
$string['searchreplace_dlg:replacewith'] = 'Keisti į';
$string['searchreplace_dlg:search_title'] = 'Rasti';
$string['searchreplace_dlg:searchnext_desc'] = 'Rasti dar kartą';
$string['searchreplace_dlg:up'] = 'Aukštyn';
$string['settings'] = 'Bendrieji nustatymai';
$string['simple:bold_desc'] = 'Paryškintasis (Ctrl+B)';
$string['simple:bullist_desc'] = 'Nesurikiuotas sąrašas';
$string['simple:cleanup_desc'] = 'Valyti netinkamą kodą';
$string['simple:italic_desc'] = 'Pasvirasis (Ctrl+I)';
$string['simple:numlist_desc'] = 'Surikiuotas sąrašas';
$string['simple:redo_desc'] = 'Perdaryti (Ctrl+Y)';
$string['simple:striketrough_desc'] = 'Perbraukimas';
$string['simple:underline_desc'] = 'Pabrauktasis (Ctrl+U)';
$string['simple:undo_desc'] = 'Anuliuoti (Ctrl+Z)';
$string['spellchecker:desc'] = 'Perjungti rašybos tikrintuvą';
$string['spellchecker:ignore_word'] = 'Nepaisyti žodžio';
$string['spellchecker:ignore_words'] = 'Nepaisyti visko';
$string['spellchecker:langs'] = 'Kalbos';
$string['spellchecker:learn_word'] = 'Išmokti žodį';
$string['spellchecker:menu'] = 'Rašybos tikrintuvo parametrai';
$string['spellchecker:no_mpell'] = 'Rašybos klaidų nerasta.';
$string['spellchecker:no_sug'] = 'Nėra pasiūlymų';
$string['spellchecker:sug'] = 'Pasiūlymai';
$string['spellchecker:wait'] = 'Palaukite...';
$string['style:delta_height'] = '';
$string['style:delta_width'] = '40';
$string['style:desc'] = 'Redaguoti CSS stilių';
$string['style_dlg:apply'] = 'Taikyti';
$string['style_dlg:background'] = 'Fono spalva';
$string['style_dlg:background_attachment'] = 'Priedas';
$string['style_dlg:background_color'] = 'Fono spalva';
$string['style_dlg:background_hpos'] = 'Horizontali padėtis';
$string['style_dlg:background_image'] = 'Fono vaizdas';
$string['style_dlg:background_repeat'] = 'Kartoti';
$string['style_dlg:background_tab'] = 'Fonas';
$string['style_dlg:background_vpos'] = 'Vertikali padėtis';
$string['style_dlg:block'] = 'Blokas';
$string['style_dlg:block_display'] = 'Rodyti';
$string['style_dlg:block_letterspacing'] = 'Tarpai tarp raidžių';
$string['style_dlg:block_tab'] = 'Blokas';
$string['style_dlg:block_text_align'] = 'Teksto lygiuotė';
$string['style_dlg:block_text_indent'] = 'Teksto įtrauka';
$string['style_dlg:block_vertical_alignment'] = 'Vertikalioji lygiuotė';
$string['style_dlg:block_whitespace'] = 'Matomas tarpas';
$string['style_dlg:block_wordspacing'] = 'Tarpai tarp žodžių';
$string['style_dlg:border'] = 'Rėmelis';
$string['style_dlg:border_tab'] = 'Kraštinė';
$string['style_dlg:bottom'] = 'Apačioje';
$string['style_dlg:box'] = 'Dėžė';
$string['style_dlg:box_clear'] = 'Valyti';
$string['style_dlg:box_float'] = 'Slankiojimas';
$string['style_dlg:box_height'] = 'Aukštis';
$string['style_dlg:box_tab'] = 'Laukas';
$string['style_dlg:box_width'] = 'Plotis';
$string['style_dlg:bullet_image'] = 'Ženklelio vaizdas';
$string['style_dlg:clip'] = 'Iškarpa';
$string['style_dlg:color'] = 'Spalva';
$string['style_dlg:height'] = 'Aukštis';
$string['style_dlg:left'] = 'Kairėje';
$string['style_dlg:list'] = 'Sąrašas';
$string['style_dlg:list_tab'] = 'Sąrašas';
$string['style_dlg:list_type'] = 'Tipas';
$string['style_dlg:margin'] = 'Paraštė';
$string['style_dlg:overflow'] = 'Perpilda';
$string['style_dlg:padding'] = 'Užpildymas';
$string['style_dlg:placement'] = 'Išdėstymas';
$string['style_dlg:position'] = 'Vieta';
$string['style_dlg:positioning_tab'] = 'Vietos nustatymas';
$string['style_dlg:positioning_type'] = 'Tipas';
$string['style_dlg:right'] = 'Dešinėje';
$string['style_dlg:same'] = 'Tas pats viskam';
$string['style_dlg:style'] = 'Stilius';
$string['style_dlg:text'] = 'Tekstas';
$string['style_dlg:text_blink'] = 'mirksėjimas';
$string['style_dlg:text_case'] = 'Raidžių lygis';
$string['style_dlg:text_color'] = 'Spalva';
$string['style_dlg:text_decoration'] = 'Dekoracija';
$string['style_dlg:text_font'] = 'Šriftas';
$string['style_dlg:text_lineheight'] = 'Eilutės aukštis';
$string['style_dlg:text_none'] = 'nėra';
$string['style_dlg:text_overline'] = 'Pabraukta viršuje';
$string['style_dlg:text_props'] = 'Tekstas';
$string['style_dlg:text_size'] = 'Dydis';
$string['style_dlg:text_striketrough'] = 'Perbraukimas';
$string['style_dlg:text_style'] = 'Stilius';
$string['style_dlg:text_tab'] = 'Tekstas';
$string['style_dlg:text_underline'] = 'Pabraukimas';
$string['style_dlg:text_variant'] = 'Variantas';
$string['style_dlg:text_weight'] = 'Storis';
$string['style_dlg:title'] = 'Redaguoti CSS stilių';
$string['style_dlg:toggle_insert_span'] = 'Pasirinkus įterpti tarpą';
$string['style_dlg:top'] = 'Viršuje';
$string['style_dlg:visibility'] = 'Matomumas';
$string['style_dlg:width'] = 'Plotis';
$string['style_dlg:zindex'] = 'Z indeksas';
$string['subplugintype_tinymce'] = 'Papildinys';
$string['subplugintype_tinymce_plural'] = 'Papildiniai';
$string['table:cell'] = 'Langelis';
$string['table:cell_desc'] = 'Lentelės langelių ypatybės';
$string['table:cellprops_delta_height'] = '';
$string['table:cellprops_delta_width'] = '10';
$string['table:col'] = 'Stulpelis';
$string['table:col_after_desc'] = 'Įterpti stulpelį po';
$string['table:col_before_desc'] = 'Įterpti stulpelį prieš';
$string['table:copy_row_desc'] = 'Kopijuoti lentelės eilutę';
$string['table:cut_row_desc'] = 'Iškirpti lentelės eilutę';
$string['table:del'] = 'Naikinti lentelę';
$string['table:delete_col_desc'] = 'Šalinti stulpelį';
$string['table:delete_row_desc'] = 'Naikinti eilutę';
$string['table:desc'] = 'Įterpia naują eilutę';
$string['table:merge_cells_delta_height'] = '';
$string['table:merge_cells_delta_width'] = '10';
$string['table:merge_cells_desc'] = 'Sulieti lentelės langelius';
$string['table:paste_row_after_desc'] = 'Įklijuoti lentelės eilutę po';
$string['table:paste_row_before_desc'] = 'Įklijuoti lentelės eilutę prieš';
$string['table:props_desc'] = 'Lentelės ypatybės';
$string['table:row'] = 'Eilutė';
$string['table:row_after_desc'] = 'Įterpti eilutę po';
$string['table:row_before_desc'] = 'Įterpti eilutę prieš';
$string['table:row_desc'] = 'Lentelės eilutės ypatybės';
$string['table:rowprops_delta_height'] = '';
$string['table:rowprops_delta_width'] = '10';
$string['table:split_cells_desc'] = 'Skaidyti sulietas lentelės eilutes';
$string['table:table_delta_height'] = '';
$string['table:table_delta_width'] = '10';
$string['table_dlg:advanced_props'] = 'Išplėstinės ypatybės';
$string['table_dlg:advanced_tab'] = 'Išplėsta';
$string['table_dlg:align'] = 'Lygiuotė';
$string['table_dlg:align_bottom'] = 'Apačioje';
$string['table_dlg:align_default'] = 'Numatyta';
$string['table_dlg:align_left'] = 'Kairėje';
$string['table_dlg:align_middle'] = 'Centre';
$string['table_dlg:align_right'] = 'Dešinėje';
$string['table_dlg:align_top'] = 'Viršuje';
$string['table_dlg:bgcolor'] = 'Fono spalva';
$string['table_dlg:bgimage'] = 'Fono vaizdas';
$string['table_dlg:border'] = 'Kraštinė';
$string['table_dlg:bordercolor'] = 'Kraštinės spalva';
$string['table_dlg:caption'] = 'Lentelės pavadinimas';
$string['table_dlg:cell_all'] = 'Atnaujinti visus lentelės langelius';
$string['table_dlg:cell_cell'] = 'Atnaujinti esamą langelį';
$string['table_dlg:cell_col'] = 'Atnaujinti visus langelius stulpelyje';
$string['table_dlg:cell_limit'] = 'Viršijote didžiausią langelių skaičių iš {$cells}.';
$string['table_dlg:cell_row'] = 'Atnaujinti visus eilutės langelius';
$string['table_dlg:cell_title'] = 'Lentelės langelių ypatybės';
$string['table_dlg:cell_type'] = 'Langelio tipas';
$string['table_dlg:cellpadding'] = 'Langelio paraštė';
$string['table_dlg:cellspacing'] = 'Tarpas tarp langelių';
$string['table_dlg:col_limit'] = 'Viršijote didžiausią stulpelių skaičių iš {$cols}.';
$string['table_dlg:colgroup'] = 'Stulpelių grupė';
$string['table_dlg:cols'] = 'Stulpeliai';
$string['table_dlg:frame'] = 'Rėmelis';
$string['table_dlg:frame_all'] = 'visi';
$string['table_dlg:frame_cols'] = 'stulpeliai';
$string['table_dlg:frame_groups'] = 'grupės';
$string['table_dlg:frame_none'] = 'nėra';
$string['table_dlg:frame_rows'] = 'eilutės';
$string['table_dlg:general_props'] = 'Bendrosios ypatybės';
$string['table_dlg:general_tab'] = 'Bendra';
$string['table_dlg:height'] = 'Aukštis';
$string['table_dlg:id'] = 'ID';
$string['table_dlg:langcode'] = 'Kalbos kodas';
$string['table_dlg:langdir'] = 'Kalbos kryptis';
$string['table_dlg:ltr'] = 'Iš kairės į dešinę';
$string['table_dlg:merge_cells_title'] = 'Sulieti lentelės langelius';
$string['table_dlg:mime'] = 'Paskirties vietos MIME tipas';
$string['table_dlg:missing_scope'] = 'Ar tikrai norite tęsti nenurodydami šios lentelės antraštės langelio apimties? Be jos kai kuriems negalią turintiems naudotojams gali būti sunku suprasti lentelės turinį arba rodomus duomenis.';
$string['table_dlg:row_all'] = 'Atnaujinti visas lentelės eilutes';
$string['table_dlg:row_even'] = 'Atnaujinti lygines lentelės eilutes';
$string['table_dlg:row_limit'] = 'Viršijote didžiausią eilučių skaičių iš {$rows}.';
$string['table_dlg:row_odd'] = 'Atnaujinti nelygines lentelės eilutes';
$string['table_dlg:row_row'] = 'Atnaujinti esamą eilutę';
$string['table_dlg:row_title'] = 'Lentelės eilutės ypatybės';
$string['table_dlg:rowgroup'] = 'Eilučių grupė';
$string['table_dlg:rows'] = 'Eilutės';
$string['table_dlg:rowtype'] = 'Eilutės tipas';
$string['table_dlg:rtl'] = 'Iš dešinės į kairę';
$string['table_dlg:rules'] = 'Taisyklės';
$string['table_dlg:rules_above'] = 'viršuje';
$string['table_dlg:rules_below'] = 'apačioje';
$string['table_dlg:rules_border'] = 'kraštinė';
$string['table_dlg:rules_box'] = 'laukas';
$string['table_dlg:rules_hsides'] = 'horizontalios pusės';
$string['table_dlg:rules_lhs'] = 'LHS';
$string['table_dlg:rules_rhs'] = 'RHS';
$string['table_dlg:rules_void'] = 'anuliuoti';
$string['table_dlg:rules_vsides'] = 'vertikalios pusės';
$string['table_dlg:scope'] = 'Aprėptis';
$string['table_dlg:style'] = 'Stilius';
$string['table_dlg:summary'] = 'Suvestinė';
$string['table_dlg:tbody'] = 'Lentelės tekstas';
$string['table_dlg:td'] = 'Duomenys';
$string['table_dlg:tfoot'] = 'Lentelės poraštė';
$string['table_dlg:th'] = 'Antraštė';
$string['table_dlg:thead'] = 'Lentelės antraštė';
$string['table_dlg:title'] = 'Įterpti / modifikuoti lentelę';
$string['table_dlg:valign'] = 'Vertikalioji lygiuotė';
$string['table_dlg:width'] = 'Plotis';
$string['template:desc'] = 'Įterpti iš anksto apibrėžto šablono turinį';
$string['template_dlg:cdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:day_long'] = 'Sekmadienis, Pirmadienis, Antradienis, Trečiadienis, Ketvirtadienis, Penktadienis, Šeštadienis, Sekmadienis';
$string['template_dlg:day_short'] = 'Sekm., Pirm., Antr., Treč., Ketv., Penk., Šešt., Sekm.';
$string['template_dlg:desc'] = 'Įterpti iš anksto apibrėžto šablono turinį';
$string['template_dlg:desc_label'] = 'Aprašas';
$string['template_dlg:label'] = 'Šablonas';
$string['template_dlg:mdate_format'] = '%Y-%m-%d %H:%M:%S';
$string['template_dlg:months_long'] = 'Sausis, Vasaris, Kovas, Balandis, Gegužė, Birželis, Liepa, Rugpjūtis, Rugsėjis, Spalis, Lapkritis, Gruodis';
$string['template_dlg:months_short'] = 'Sau., Vas., Kov., Bal., Geg., Bir., Lie., Rgp., Rgs., Spl., Lap., Grd.';
$string['template_dlg:preview'] = 'Peržiūra';
$string['template_dlg:select'] = 'Pasirinkti šabloną';
$string['template_dlg:title'] = 'Šablonai';
$string['template_dlg:warning'] = 'Įspėjimas: atnaujinus šabloną į skirtingą gali būti prarasti duomenys.';
$string['visualblocks:desc'] = 'Rodyti / slėpti bloko elementus';
$string['visualchars:desc'] = 'Vaizdinių valdiklių simboliai įjungti / išjungti.';
$string['wordcount:words'] = 'Žodžiai:';
$string['xhtmlxtras:abbr_delta_height'] = '';
$string['xhtmlxtras:abbr_delta_width'] = '10';
$string['xhtmlxtras:abbr_desc'] = 'Santrumpa';
$string['xhtmlxtras:acronym_delta_height'] = '';
$string['xhtmlxtras:acronym_delta_width'] = '10';
$string['xhtmlxtras:acronym_desc'] = 'Akronimas';
$string['xhtmlxtras:attribs_delta_height'] = '';
$string['xhtmlxtras:attribs_delta_width'] = '10';
$string['xhtmlxtras:attribs_desc'] = 'Įterpti / redaguoti atributus';
$string['xhtmlxtras:cite_delta_height'] = '';
$string['xhtmlxtras:cite_delta_width'] = '10';
$string['xhtmlxtras:cite_desc'] = 'Citata';
$string['xhtmlxtras:del_delta_height'] = '';
$string['xhtmlxtras:del_delta_width'] = '10';
$string['xhtmlxtras:del_desc'] = 'Naikinimas';
$string['xhtmlxtras:ins_delta_height'] = '';
$string['xhtmlxtras:ins_delta_width'] = '10';
$string['xhtmlxtras:ins_desc'] = 'Įterpimas';
$string['xhtmlxtras_dlg:attrib_tab'] = 'Atributai';
$string['xhtmlxtras_dlg:attribs_title'] = 'Įterpti / redaguoti atributus';
$string['xhtmlxtras_dlg:attribute_attrib_tab'] = 'Atributai';
$string['xhtmlxtras_dlg:attribute_events_tab'] = 'Įvykiai';
$string['xhtmlxtras_dlg:attribute_label_accesskey'] = 'Prieigos raktas';
$string['xhtmlxtras_dlg:attribute_label_cite'] = 'Cituoti';
$string['xhtmlxtras_dlg:attribute_label_class'] = 'Klasė';
$string['xhtmlxtras_dlg:attribute_label_datetime'] = 'Data / laikas';
$string['xhtmlxtras_dlg:attribute_label_id'] = 'ID';
$string['xhtmlxtras_dlg:attribute_label_langcode'] = 'Kalba';
$string['xhtmlxtras_dlg:attribute_label_langdir'] = 'Teksto kryptis';
$string['xhtmlxtras_dlg:attribute_label_style'] = 'Stilius';
$string['xhtmlxtras_dlg:attribute_label_tabindex'] = 'Tabuliacijos indektas';
$string['xhtmlxtras_dlg:attribute_label_title'] = 'Pavadinimas';
$string['xhtmlxtras_dlg:attribute_option_ltr'] = 'Iš kairės į dešinę';
$string['xhtmlxtras_dlg:attribute_option_rtl'] = 'Iš dešinės į kairę';
$string['xhtmlxtras_dlg:events_tab'] = 'Įvykiai';
$string['xhtmlxtras_dlg:fieldset_attrib_tab'] = 'Elemento atributai';
$string['xhtmlxtras_dlg:fieldset_events_tab'] = 'Elemento įvykiai';
$string['xhtmlxtras_dlg:fieldset_general_tab'] = 'Bendrieji nustatymai';
$string['xhtmlxtras_dlg:general_tab'] = 'Bendra';
$string['xhtmlxtras_dlg:insert_date'] = 'Įterpti dabartinę datą / laiką';
$string['xhtmlxtras_dlg:option_ltr'] = 'Iš kairės į dešinę';
$string['xhtmlxtras_dlg:option_rtl'] = 'Iš dešinės į kairę';
$string['xhtmlxtras_dlg:remove'] = 'Šalinti';
$string['xhtmlxtras_dlg:title_abbr_element'] = 'Santrumpos elementas';
$string['xhtmlxtras_dlg:title_acronym_element'] = 'Akronimo elementas';
$string['xhtmlxtras_dlg:title_cite_element'] = 'Citatos elementas';
$string['xhtmlxtras_dlg:title_del_element'] = 'Naikinamas elementas';
$string['xhtmlxtras_dlg:title_ins_element'] = 'Įterpiamas elementas';
