<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'sr_cr', version '4.4'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Можете прегледати овај тест, али ако је ово стварни покушај решавања, бићете блокирани јер:';
$string['action'] = 'Акција';
$string['activityoverview'] = 'Приближава се рок за решавање тестова';
$string['adaptive'] = 'Адаптивни режим';
$string['adaptive_help'] = 'Ако је омогућен адаптивни режим, онда је полазнику дозвољено да унутар истог покушаја решавања теста више пута одговори на питање. На пример, ако је одговор означен као нетачан, полазнику ће бити дозвољено да одмах поново одговори. Међутим, зависно од подешавања "Примени казнене поене", за сваки погрешан одговор обично ће бити одузет одговарајући број казнених поена.';
$string['add'] = 'Додај';
$string['addaquestion'] = 'ново питање';
$string['addarandomquestion'] = 'ново насумично одабрано питање';
$string['addarandomquestion_help'] = 'Када се додају насумична питања, то резултира тиме да се у тест додају насумично одабрана питања из категорије. Ово значи да ће сваки полазник вероватно добити различит скуп питања, а када тест дозвољава поновне покушаје онда је вероватно да ће сваки покушај садржати нови скуп питања.';
$string['addarandomquestion_success'] = 'Насумично изабрана питања су додата';
$string['addarandomselectedquestion'] = 'Додај насумично изабрано питање...';
$string['addasection'] = 'нови наслов секције';
$string['adddescriptionlabel'] = 'Додај опис';
$string['addingquestion'] = 'Додавање питања';
$string['addingquestions'] = '<p>Овај део странице је место на којем уређујете своју базу питања. Питања се чувају у категоријама које вам помажу да питања их организујете. Питања се могу користити у било ком тесту вашег курса или. чак, у другим курсевима, ако одлучите да их \'објавите\'. </p>
<p>Након што изаберете или креирате категорију питања, можете да правите нова или уређујете постојећа питања. Можете да изаберете било које од ових питања и додате их у ваш тест који се налази на супротној страни ове странице. </p>';
$string['addmoreoverallfeedbacks'] = 'Додај још {no} поља за повратне информације';
$string['addnewgroupoverride'] = 'Додај измену за групу';
$string['addnewpagesafterselected'] = 'Додај нове странице после изабраних питања';
$string['addnewquestionsqbank'] = 'Додај питања у категорију {$a->catname}: {$a->link}';
$string['addnewuseroverride'] = 'Додај измену подешавања за корисника';
$string['addpagebreak'] = 'Додај прелом странице';
$string['addpagehere'] = 'Додај страницу овде';
$string['addquestion'] = 'Додај питање';
$string['addquestionfrombankatend'] = 'Додај из банке питања на крај';
$string['addquestionfrombanktopage'] = 'Додај из банке питања на страницу {$a}';
$string['addquestions'] = 'Додаj питања';
$string['addquestionstoquiz'] = 'Додај питања у текући тест';
$string['addrandom'] = 'Додај {$a} насумичних питања';
$string['addrandom1'] = '<< Додај';
$string['addrandom2'] = 'случајна питања';
$string['addrandomfromcategory'] = 'Додај насумично одабрана питања из категорије';
$string['addrandomquestion'] = 'Додај насумично одабрана питања';
$string['addrandomquestionatend'] = 'Додај насумично одабрано питања на крај';
$string['addrandomquestiontopage'] = 'Додај насумично изабрано питање на страницу {$a}';
$string['addrandomquestiontoquiz'] = 'Додај насумично одабрана питања у тест {$a}';
$string['addselectedquestionstoquiz'] = 'Додај изабрана питања у тест';
$string['addselectedtoquiz'] = 'Додај изабрано у тест';
$string['addtoquiz'] = 'Додај у тест';
$string['affectedstudents'] = 'Утицало је на {$a}';
$string['aftereachquestion'] = 'Након додавања сваког питања';
$string['afternquestions'] = 'Након додавања {$a} питања';
$string['age'] = 'старост';
$string['allattempts'] = 'Сви покушаји';
$string['allinone'] = 'Неограничено';
$string['allowreview'] = 'Дозволи преглед';
$string['alreadysubmitted'] = 'Вероватно сте већ предали тест.';
$string['alternativeunits'] = 'Алтернативне мерне јединице';
$string['alwaysavailable'] = 'Увек доступно';
$string['alwayslatest'] = 'Увек најновије';
$string['analysisoptions'] = 'Опције анализе';
$string['analysistitle'] = 'Табела анализе питања';
$string['answer'] = 'Одговор';
$string['answered'] = 'Одговорено';
$string['answerhowmany'] = 'Један или више тачних одговора?';
$string['answers'] = 'Одговори';
$string['answersingleno'] = 'Дозвољено је више тачних одговора';
$string['answersingleyes'] = 'Само један одговор је тачан';
$string['answertoolong'] = 'Одговор је предугачак након линије {$a} (макс. 255 знакова)';
$string['anytags'] = 'Било које ознаке';
$string['aon'] = 'AON формат';
$string['areyousureremoveselected'] = 'Да ли сте сигурни да желите да обришете сва изабрана питања?';
$string['asshownoneditscreen'] = 'Као што је приказано на страници за уређивање';
$string['attempt'] = 'Покушај број {$a}';
$string['attemptalreadyclosed'] = 'Овај покушај је већ завршен.';
$string['attemptclosed'] = 'Покушај још увек није затворен';
$string['attemptduration'] = 'Трајање';
$string['attemptedon'] = 'Датум предаје теста';
$string['attempterror'] = 'Тренутно вам није дозвољено да покушате овај тест због  {$a}';
$string['attempterrorcontentchange'] = 'Овај преглед теста више не постоји (када се тест уређује, сви прегледи који су у току аутоматски се бришу).';
$string['attempterrorcontentchangeforuser'] = 'Овај покушај решавања теста више не постоји.';
$string['attempterrorinvalid'] = 'Неисправна ID ознака покушаја решавања теста';
$string['attemptfirst'] = 'Први покушај';
$string['attemptgradeddelay'] = 'Одлагање обавештења о оцењеном покушају';
$string['attemptgradeddelay_desc'] = 'Одлагање се примењује пре слања обавештења о оцењеном покушају решавања теста како би се оставило довољно времена предавачу да измени оцену.';
$string['attemptincomplete'] = 'Овај покушај (корисника: {$a}) још није завршен.';
$string['attemptlast'] = 'Последњи покушај';
$string['attemptnumber'] = 'Покушај';
$string['attemptquiz'] = 'Покушај решавања теста';
$string['attemptquiznow'] = 'Започни тест';
$string['attemptreviewtitle'] = '{$a}: Преглед покушаја';
$string['attemptreviewtitlepaged'] = '{$a->name}: Преглед покушаја (страница {$a->currentpage} од {$a->totalpages})';
$string['attempts'] = 'Покушаји';
$string['attempts_help'] = 'Укупан број дозвољених покушаја (не и број додатних покушаја).';
$string['attemptsallowed'] = 'Дозвољен број покушаја';
$string['attemptsdeleted'] = 'Број избрисаних покушаја';
$string['attemptselection'] = 'Изаберите које покушаје треба анализирати по кориснику:';
$string['attemptsexist'] = 'Тест је већ у употреби, не можете више додавати или брисати питања.';
$string['attemptsnum'] = 'Укупан број покушајa: {$a}';
$string['attemptsnumthisgroup'] = 'Укупан број покушаја: {$a->total} ({$a->group} из ове групе)';
$string['attemptsnumyourgroups'] = 'Укупан број покушаја: {$a->total} ({$a->group} из ваше групе)';
$string['attemptsonly'] = 'Прикажи само полазнике са покушајима';
$string['attemptstate'] = 'Статус';
$string['attemptstillinprogress'] = 'Покушај је још у току';
$string['attemptsummarytitle'] = '{$a}: Резиме покушаја';
$string['attemptsunlimited'] = 'Неограничен број покушаја';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (страница {$a->currentpage} од {$a->totalpages})';
$string['autosaveperiod'] = 'Временско кашњење приликом аутоматског чувања одговора';
$string['autosaveperiod_desc'] = 'У току решавања теста одговори полазника могу аутоматски да се снимају. То се чини кад год полазници унесу неку промену након које прође дати број минута. Ово подразумева компромис: краћа задршка повећава оптерећење сервера, али с друге смањује могућност да полазници изгубе своје одговоре. Ако желите значајно да скратите ово време задршке требало би то постепено да чините и да пратите како се мења оптерећење сервера. Ако сервер постане преоптерећен продужите дату минутажу. Ако унесете вредност 0 искључићете аутоматско чување одговора.';
$string['back'] = 'Повратак на преглед питања';
$string['backtocourse'] = 'Повратак на курс';
$string['backtoquestionlist'] = 'Повратак на списак питања';
$string['backtoquiz'] = 'Повратак на уређивање теста';
$string['bestgrade'] = 'Највиша оцена';
$string['bothattempts'] = 'Прикажи полазнике са и без покушаја';
$string['browsersecurity'] = 'Безбедност прозора веб читача';
$string['browsersecurity_help'] = 'Ако је изабрано "Искачући прозор преко целог екрана са делимично укљученим JavaScript опцијама за безбедност",

* тест ће се покренути само ако полазник има веб читач са укљученом подршком за JavaScript
* тест ће се појавити у искачућем прозору преко целог екрана, који покрива све остале прозоре и који нема дугмад за навигавију
* полазницима ће, колико је год то могуће, бити онемогућено да користе команде попут "копирај" и "налепи"';
$string['cachedef_overrides'] = 'Информације о изменама подешавања за кориснике и групе';
$string['calculated'] = 'Рачунско';
$string['calculatedquestion'] = 'Рачунско питање није подржано у линији {$a}. Питање ће бити игнорисано.';
$string['cannotcreatepath'] = 'Не може се креирати путања ({$a})';
$string['cannoteditafterattempts'] = 'Не можете да додате или уклоните питања због тога што већ има покушаја решавања теста. ({$a})';
$string['cannotfindprevattempt'] = 'Није могуће пронаћи претходни покушај';
$string['cannotfindquestionregard'] = 'Није било могуће добити питања за поновно оцењивање';
$string['cannotinsert'] = 'Не може се уметнути питање';
$string['cannotinsertrandomquestion'] = 'Није било могуће убацити ново насумично одабрано питање';
$string['cannotloadquestion'] = 'Није било могуће учитати опције питања';
$string['cannotloadtypeinfo'] = 'Није могуће учитати информације везане за тип питања';
$string['cannotopen'] = 'Не може се отворити извозна датотека ({$a})';
$string['cannotremoveallsectionslots'] = 'Изабрали сте сва питања испод наслова секције \'{$a}\', Није дозвољено да уклоните сва питања испод наслова секције.';
$string['cannotremoveslots'] = 'Није могуће уклонити питања.';
$string['cannotrestore'] = 'Није било могуће вратити податке за сесије питања';
$string['cannotreviewopen'] = 'Не можете да прегледате овај покушај, још увек је отворен';
$string['cannotsavelayout'] = 'Није било могуће сачувати';
$string['cannotsavenumberofquestion'] = 'Није било могуће сачувати број питања по једно страници';
$string['cannotsavequestion'] = 'Не може се сачувати списак питања';
$string['cannotsetgrade'] = 'Није било могуће поставити нову максималну оцену за тест';
$string['cannotsetsumgrades'] = 'Покушај да се подеси сума оцена није успео';
$string['cannotstartgradesmismatch'] = 'Није могуће започети покушај решавања овог теста. Оцена теста је подешена на {$a->grade}, али ниједно од питања у тесту нема подешену оцену. Ово може бити поправљено на страници \'Уреди тест\'.';
$string['cannotstartmissingquestion'] = 'Не можете да започнете решавање овог теста. У тест је укључуено питање које не постоји.';
$string['cannotstartnoquestions'] = 'Није могуће започети покушај решавања овог теста. Тест још увек није подешен. Ниједно питање није додато.';
$string['cannotwrite'] = 'Не може се уписивати у извозну датотеку ({$a})';
$string['canredoquestions'] = 'Дозволи поновно одговорање унутар покушаја';
$string['canredoquestions_desc'] = 'Ако је ова опција омогућена, полазници ће, након што дају одговор на питање, видети дугме \'Покушајте са другим питањем попут овог\'. То им омогућава да покушају да одговоре на слично (насумично изабрано) питања, или на исто питање поново, без потребе да предају читав тест и започну нови покушај његовог решавања. Ова опција је корисна када се ради о тестовима за вежбање.

Ово подешавање утиче само на питања и понашања питања (на пример \'непосредне повратне информације\', или \'интерактивно са вишеструким покушајима\') код којих је могуће да се заврши питање пре него што се преда покушај решавања теста.';
$string['canredoquestions_help'] = 'Ако је ова опција омогућена, полазници ће, након што дају одговор на питање, видети дугме \'Покушајте са другим питањем попут овог\'. То им омогућава да покушају да одговоре на слично (насумично изабрано) питања, или на исто питање поново, без потребе да предају читав тест и започну нови покушај његовог решавања. Ова опција је корисна када се ради о тестовима за вежбање.

Ово подешавање утиче само на питања и понашања питања (на пример \'непосредне повратне информације\', или \'интерактивно са вишеструким покушајима\') код којих је могуће да се заврши питање пре него што се преда покушај решавања теста.';
$string['canredoquestionsyes'] = 'Да, пружите могућност да покушају да одговоре на друго питање';
$string['caseno'] = 'Не, величина слова није битна';
$string['casesensitive'] = 'Разликовање малих и ВЕЛИКИХ слова';
$string['caseyes'] = 'Да, величина слова мора да се поклапа';
$string['categoryadded'] = 'Категорија \'{$a}\' је додата';
$string['categorydeleted'] = 'Категорија \'{$a}\' је обрисана';
$string['categorynoedit'] = 'Немате овлашћења за мењање категорије \'{$a}\'.';
$string['categoryupdated'] = 'Категорија је успешно измењена';
$string['close'] = 'Затвори прозор';
$string['closebeforeopen'] = 'Датум затварања теста мора бити после датума отварања теста.';
$string['closed'] = 'Затворено';
$string['closepreview'] = 'Затвори преглед';
$string['closereview'] = 'Затвори преглед';
$string['comment'] = 'Коментар';
$string['commentorgrade'] = 'Коментаришите или измените оцену';
$string['comments'] = 'Коментари';
$string['completedon'] = 'Завршено';
$string['completionattemptsexhausted'] = 'Прелазна оцена или сви доступни покушаји завршени';
$string['completionattemptsexhausted_help'] = 'Означи да је тест завршен када полазник потроши максималан број покушаја.';
$string['completiondetail:minattempts'] = 'Решите тест: {$a}';
$string['completiondetail:passorexhaust'] = 'Добијте прелазну оцену или довршите све доступне покушаје';
$string['completionminattempts'] = 'Минималан број покушаја';
$string['completionminattemptsdesc'] = 'Минималан број потребних покушаја: {$a}';
$string['completionminattemptserror'] = 'Минимални број покушаја мора бити мањи или једнак дозвољеном броју покушаја.';
$string['completionminattemptsgroup'] = 'Захтевај покушаје';
$string['completionpassorattemptsexhausteddesc'] = 'Полазник мора да постигне прелазну оцену, или да исцрпи све расположиве покушаје да би завршио ову активност';
$string['configadaptive'] = 'Уколико изаберете \'Да\' за ову опцију онда ће полазнику бити дозвољено да више пута одговори на питање, чак у оквиру истог покушаја решавања теста.';
$string['configattemptsallowed'] = 'Ограничење у броју покушаја који су полазницима дозвољени на тесту';
$string['configdecimaldigits'] = 'Број цифара након децималне тачке које треба приказати када се показују оцене.';
$string['configdecimalplaces'] = 'Број цифара након децималне тачке које треба приказати када се показују оцене за тест.';
$string['configdecimalplacesquestion'] = 'Број цифара након децималне тачке које треба приказати када се показују оцене за појединачна потања.';
$string['configdelay1'] = 'Уколико подесите временски размак, онда ће полазник након првог покушаја морати толико времена да сачека пре него што буде могао поново да покуша да уради тест.';
$string['configdelay1st2nd'] = 'Уколико овде подесите временски размак, полазници не могу да други пут ураде тест пре него што не протекне толико времене од њиховог првог покушаја.';
$string['configdelay2'] = 'Уколико овде подесите временски размак, онда полазник мора да сачека толико времене да прође пре него што започне свој трећи (и сваки наредни) покушај решавања теста.';
$string['configdelaylater'] = 'Уколико овде подесите временски размак, онда полазник не може да започне трећи, четврти,... покушај пре него толико времена не прође од краја претходног покушаја решавања теста.';
$string['configeachattemptbuildsonthelast'] = 'Уколико су дозвољени вишеструки покушаји онда сваки нови покушај садржи резултате претходног покушаја.';
$string['configgrademethod'] = 'Када су вишеструки покушаји дозвољени који метод треба користити за израчунавање полазникове завршне оцене за тест.';
$string['configintro'] = 'Вредности које сте овде подесили дефинише подразумеване вредности које се користе у обрасцу за подешавање када креирате нови тест. Можете, такође, да конфигуришете која подешавања теста се сматрају напредним.';
$string['configmaximumgrade'] = 'Подразумевана оцена на основу које ће се градирати оцене на тесту';
$string['confignavmethod'] = 'Код слободне навигације на питања се може одговарати било којим редоследом, Код секвенцијалне навигације на питања се мора одговарати строго утврђеним редоследом';
$string['confignewpageevery'] = 'Код додавања питања у тест, прелом странице ће аутоматски бити убачен према подешавању које одве одаберете,';
$string['configoutcomesadvanced'] = 'Ако је ова опција укључена онда ће \'Исходи\' у обрасцу за уређивање теста бити смештени у делу за напредна подешавања.';
$string['configpenaltyscheme'] = 'Казнени бодови који се одузимају за сваки погрешан одговор у адаптивном режиму.';
$string['configpopup'] = 'Принудно отварање теста у искачућем прозору, уз коришћење JavaScript опција, које ће покушати да ограниче коришћење команди "копирај", "налепи" итд., у току решавања теста.';
$string['configrequirepassword'] = 'Полазници морају да унесу ову лозинку пре него што покушају да реше тест.';
$string['configrequiresubnet'] = 'Полазници могу да покушају да реше тест само са ових рачунара.';
$string['configreviewoptions'] = 'Ове опције контролишу које информације ће корисници моћи да виде када буду прегледали покушај или када буду гледали извештаје о тесту.';
$string['configshowblocks'] = 'Прикажи блокове током решавања теста.';
$string['configshowuserpicture'] = 'Прикажи слику корисника на екрану током покушаја решавања теста.';
$string['configshufflewithin'] = 'Ако омогућоте ову опцију, онда ће делови који сачињавају појединачно питање бити насумочно измешани сваки пут када полазник започне да решава овај тест. Понуђена опција је такође укљученљ у подешаваљима питања.';
$string['configtimelimit'] = 'Подраумевано временско ограничење за тестове у минутима. 0 значи да нема временског ограничења.';
$string['configtimelimitsec'] = 'Подраумевано временско огрничење за тестове у секундама. 0 значи да нема временског ограничења.';
$string['configurerandomquestion'] = 'Конфигуриши питање';
$string['confirmclose'] = 'Када предате своје одговоре нећете више бити у могућности да их мењате.';
$string['confirmremovequestion'] = 'Да ли сте сигурни да желите да уклоните ово {$a} питање?';
$string['confirmremovesectionheading'] = 'Да ли сте сигурни да желите да уклоните наслов секције \'{$a}\'?';
$string['confirmserverdelete'] = 'Да ли сте сигурни да желите да уклоните сервер <b>{$a}</b> са списка?';
$string['connectionerror'] = 'Мрежна веза је изгубљена. (Аутоматско чување није успело).

Запишите све одговора унетих на овој страници у последњих неколико минута, а затим покушајте поново да се повежете.

Када се веза поново успостави ваши одговори би требало да буду сачувани а ова порука ће нестати.';
$string['connectionok'] = 'Мрежна веза је поново успостављена. Можете безбедно да наставите.';
$string['containercategorycreated'] = 'Ова категорија је креирана са циљем да се у њу сместе све оригиналне категорије које се помере на ниво сајта из доле наведених разлога.';
$string['continueattemptquiz'] = 'Наставите са својим покушајем';
$string['continuepreview'] = 'Настави последњи преглед';
$string['copyingfrom'] = 'Креирање копије питања \'{$a}\'';
$string['copyingquestion'] = 'Копирање питања';
$string['correct'] = 'Тачно';
$string['correctanswer'] = 'Тачан одговор';
$string['correctanswerformula'] = 'Формула тачног одговора';
$string['correctansweris'] = 'Тачан одговор: {$a}';
$string['correctanswerlength'] = 'Значајне цифре';
$string['correctanswers'] = 'Тачни одговори';
$string['correctanswershows'] = 'Taчан одговор садржи';
$string['corrresp'] = 'Тачан одговор';
$string['countdown'] = 'Бројач';
$string['countdownfinished'] = 'Тест се ускоро затвара, време је да предате своје одговоре.';
$string['countdowntenminutes'] = 'Тест се затвара за десет минута.';
$string['coursetestmanager'] = 'Тест Менаџер формат';
$string['createcategoryandaddrandomquestion'] = 'Креирај категорију и додај насумично одабрано питање';
$string['createfirst'] = 'Морате прво креирати нека питања са кратким одговорима.';
$string['createmultiple'] = 'Додајте тесту неколико насумично одабраних питања';
$string['createnewquestion'] = 'Креирај ново питање';
$string['createquestionandadd'] = 'Креирај ново питање и додај га тесту.';
$string['custom'] = 'Произвољан формат';
$string['dataitemneed'] = 'Морате додати бар један скуп ставки података да бисте добили валидно питање';
$string['datasetdefinitions'] = 'Поново употребљене дефиниције сета података за категорију {$a}';
$string['datasetnumber'] = 'Број';
$string['daysavailable'] = 'Доступни дани';
$string['decimaldigits'] = 'Број децимала у оценама';
$string['decimalplaces'] = 'Децимална места у оценама';
$string['decimalplaces_help'] = 'Ово подешавање одређује број цифара који треба приказати иза децималне тачке када се приказују оцена. Ово утиче само на приказ оцена, али не и на оцене сачуване у бази података, нити на интерна израчунавања која се изводе са пуном прецизношћу.';
$string['decimalplacesquestion'] = 'Децимална места у оценама за питања';
$string['decimalplacesquestion_help'] = 'Број цифара који се приказају иза децималне тачке када се приказују оцене за појединачна питања.';
$string['decimalpoints'] = 'Децимална места';
$string['default'] = 'Подразумевано';
$string['defaultgrade'] = 'Подразумевана оцена питања';
$string['defaultinfo'] = 'Подразумевана категорија за питања';
$string['delay1'] = 'Временски размак између првог и другог покушаја';
$string['delay1st2nd'] = 'Принудни временски размак између првог и другог покушаја';
$string['delay1st2nd_help'] = '<p>Уколико подесите временски размак, полазник мора након свог првог покушаја да сачека да толико времена прође пре него што му буде дозвољено да поново покуша да реши тест.</p>';
$string['delay2'] = 'Временски размак између свих осталих покушаја';
$string['delaylater'] = 'Принудни временски размак између накнадних покушаја';
$string['delaylater_help'] = '<p>Уколико овде подесите временски размак, полазник мора да сачека да толико времена прође пре него што започне свој трећи и сваки наредни покушај решавања теста.</p>';
$string['deleteattemptcheck'] = 'Да ли сте апсолутно сигурни да желите да обришете ове покушаје?';
$string['deleteselected'] = 'Обриши означено';
$string['deletingquestionattempts'] = 'Обриши покушаје питања';
$string['description'] = 'Опис';
$string['disabled'] = 'Онемогућено';
$string['displayoptions'] = 'Опције приказа';
$string['donotuseautosave'] = 'Не користи опцију за аутоматско чување';
$string['download'] = 'Кликните за преузимање извезене датотеке са категоријама';
$string['downloadextra'] = '(датотека се чува и међу датотекама курса у /backupdata/quiz директоријуму)';
$string['dragtoafter'] = 'Након {$a}';
$string['dragtostart'] = 'На почетак';
$string['duplicateresponse'] = 'Овај одговор је игнорисан зато што је једнак одговору који сте дали раније.';
$string['eachattemptbuildsonthelast'] = 'Сваки покушај се наставља на претходни';
$string['eachattemptbuildsonthelast_help'] = '<p>Ако је дозвољено више покушаја решавања теста и ово подешавање је постављено на <b>Да</b>, онда ће сваки нови покушај садржати резултате претходног. То дозвољава да се решавање теста заврши у више покушаја.</p>

<p>Да би се приказао нови примерак теста при сваком покушају, изаберите вредност <b>Не</b> за ово подешавање.</p>';
$string['edit_slotdisplaynumber_hint'] = 'Уредите број питања (максимално 16 знакова)';
$string['edit_slotdisplaynumber_label'] = 'Нова вредност за {$a}';
$string['editcategories'] = 'Уреди категорије';
$string['editcategory'] = 'Уреди категорију';
$string['editcatquestions'] = 'Уређивање питања у категорији';
$string['editingquestion'] = 'Уређивање питања';
$string['editingquiz'] = 'Уређивање теста';
$string['editingquiz_help'] = 'Приликом креирања теста, основни појмови су:

* Тест, који садржи питања на једној или више страница
* Банка питања, која садржи копије свих питања организованих у категорије
* Насумично одабрано питање - полазник добија различита питања сваки пут када покуша да решава тест, односно различити полазници могу да добију различита питања тј. тест.';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Уређивање теста: {$a}';
$string['editmaxmark'] = 'Уреди максималну оцену';
$string['editoverride'] = 'Уреди измену';
$string['editqcats'] = 'Уређивање категорија питања';
$string['editquestion'] = 'Уреди питање';
$string['editquestions'] = 'Уреди питања';
$string['editquiz'] = 'Уреди тест';
$string['editquizquestions'] = 'Уреди питања теста';
$string['emailconfirmautosubmitsmall'] = 'Хвала вам што сте послали своје одговоре на тест \'{$a->quizname}\'';
$string['emailconfirmbody'] = 'Поштовани/а {$a->username},

Хвала што сте послали своје одговоре на тест \'{$a->quizname}\' на курсу \'{$a->coursename}\' у {$a->submissiontime}.

Ова порука је потврда да су ваши одговори сачувани.

Овом тесту можете да приступите на {$a->quizurl}.';
$string['emailconfirmbodyautosubmit'] = 'Поштовани/а {$a->username},

Време за тест \'{$a->quizname}\' на курсу \'{$a->coursename}\' је истекло. Ваши одговори предати су аутоматски у {$a->submissiontime}.

Ова порука потврђује да су ваши одговори сачувани.

Овом тесту можете приступити на {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Хвала што се предали своје одоговоре за тест \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Потврда о слању теста: {$a->quizname}';
$string['emailmanualgradedbody'] = 'Поштовани/а {$a->username},

Ваши одговори на питања у тесту \'{$a->quizname}\' на курсу \'{$a->coursename}\' предати у {$a->attempttimefinish} сада су оцењени.

Моћи ћете да видите свој резултат и повратне информације ако посетите \'{$a->quizurl}\' и прегледате свој покушај.';
$string['emailmanualgradedsubject'] = 'Ваш покушај решавања теста {$a->quizname} је оцењен';
$string['emailnotifybody'] = 'Поштовани/а {$a->username},

{$a->studentname} је завршио/ла тест \'{$a->quizname}\' ({$a->quizurl}) на курсу \'{$a->coursename}\'.

Овај покушај можете прегледати на  {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} је завршио/ла тест {$a->quizname}. Погледајте на {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} је завршио/ла тест {$a->quizname}';
$string['emailoverduebody'] = 'Поштовани/а {$a->username},

Започели сте решавање теста \'{$a->quizname}\'
на курсу \'{$a->coursename}\', али нисте предали своје одговоре. Потребно је да их предате до {$a->attemptduedate}.

Ако, још увек. желите да пошаљете своје одговоре, молимо вас да одете на {$a->attemptsummaryurl} и кликнете на дугме \'Предај\'. Ово морате да урадите пре {$a->attemptgraceend}, у супротном ваш покушај решавања теста се неће рачунати.';
$string['emailoverduesmall'] = 'Нисте предали свој покушај решавања теста {$a->quizname}. Молимо вас да одете на {$a->attemptsummaryurl} пре {$a->attemptgraceend}, ако још увек желите да предате своје одговоре.';
$string['emailoverduesubject'] = 'Покушај решавања теста {$a->quizname} касни';
$string['empty'] = 'Празно';
$string['enabled'] = 'Омогућено';
$string['endtest'] = 'Заврши покушај...';
$string['erroraccessingreport'] = 'Не можете да приступите овом извештају';
$string['errorinquestion'] = 'Грешка у питању';
$string['errormissingquestion'] = 'Грешка: Систем не може да пронађе питање чији је идентификатор {$a}';
$string['errornotnumbers'] = 'Грешка - одговори морају бити нумерички';
$string['errorunexpectedevent'] = 'Неочекивани кôд догађаја {$a->event} пронађен за питање {$a->questionid} у покушају {$a->attemptid}.';
$string['essay'] = 'Есеј';
$string['essayquestions'] = 'Питања';
$string['eventattemptautosaved'] = 'Покушај решавања теста је аутоматски сачуван';
$string['eventattemptdeleted'] = 'Покушај решавања теста обрисан';
$string['eventattemptmanualgradingcomplete'] = 'Ручно оцењивање покушаја решавања теста је завршено';
$string['eventattemptpreviewstarted'] = 'Преглед покушаја решавања теста покренут';
$string['eventattemptquestionrestarted'] = 'Покушај решавања теста поново покренут';
$string['eventattemptreviewed'] = 'Покушај решавања теста приказан';
$string['eventattemptsummaryviewed'] = 'Резиме покушаја приказан';
$string['eventattemptupdated'] = 'Покушај решавања теста ажуриран';
$string['eventattemptviewed'] = 'Покушај решавања теста приказан';
$string['eventeditpageviewed'] = 'Страница за уређивање теста приказана';
$string['eventoverridecreated'] = 'Измена подешавања теста креирана';
$string['eventoverridedeleted'] = 'Измена подешавања теста обрисана';
$string['eventoverrideupdated'] = 'Измена подешавања теста ажурирана';
$string['eventpagebreakcreated'] = 'Прелом странице креиран';
$string['eventpagebreakdeleted'] = 'Прелом странице обрисан';
$string['eventquestionmanuallygraded'] = 'Питање ручно оцењено';
$string['eventquizattemptabandoned'] = 'Покушај решавања теста напуштен';
$string['eventquizattemptregraded'] = 'Покушај решавања теста поново оцењен';
$string['eventquizattemptreopened'] = 'Покушај решавања теста је поново отворен';
$string['eventquizattemptstarted'] = 'Покушај решавања теста започет';
$string['eventquizattemptsubmitted'] = 'Покушај решавања теста предат';
$string['eventquizattempttimelimitexceeded'] = 'Време за решавање теста прекорачено';
$string['eventquizgradeitemcreated'] = 'Ставка за оцењивање у тесту је креирана';
$string['eventquizgradeitemdeleted'] = 'Ставка за оцењивање у тесту је обрисана';
$string['eventquizgradeitemorderchanged'] = 'Редослед ставки за оцењивање у тесту је промењен';
$string['eventquizgradeitemupdated'] = 'Ставка за оцењивање у тесту је ажурирана';
$string['eventquizgradeupdated'] = 'Оцена теста ажурирана';
$string['eventquizrepaginated'] = 'Странице теста реорганизоване';
$string['eventreportviewed'] = 'Извештај о тесту приказан';
$string['eventsectionbreakcreated'] = 'Прелом секције креиран';
$string['eventsectionbreakdeleted'] = 'Прелом секције обрисан';
$string['eventsectionshuffleupdated'] = 'Насумични редослед питања у секцији ажуриран';
$string['eventsectiontitleupdated'] = 'Наслов секције ажуриран';
$string['eventslotcreated'] = 'Слот креиран';
$string['eventslotdeleted'] = 'Слот обрисан';
$string['eventslotdisplayedquestionnumberupdated'] = 'Слот који приказује број питања ажуриран';
$string['eventslotgradeitemupdated'] = 'Слот ставки за оцењивање ажуриран';
$string['eventslotmarkupdated'] = 'Ознака слота ажурирана';
$string['eventslotmoved'] = 'Слот премештен';
$string['eventslotrequirepreviousupdated'] = 'Слот захтева претходно ажурирање';
$string['everynquestions'] = 'Свака/их {$a} питања';
$string['everyquestion'] = 'Свако питање';
$string['everythingon'] = 'Све на';
$string['existingcategory'] = 'Постојећа категорија';
$string['exportcategory'] = 'извези категорију';
$string['exporterror'] = 'Дошло је до грешке у току обраде извоза';
$string['exportingquestions'] = 'Питања се извозе у датотеку';
$string['exportname'] = 'Назив датотеке';
$string['exportquestions'] = 'Извези питања у датотеку';
$string['extraattemptrestrictions'] = 'Додатна ограничења приликом покушаја';
$string['false'] = 'Погрешно';
$string['feedback'] = 'Повратне информације';
$string['feedbackerrorboundaryformat'] = 'Граничне вредности оцене за повратне информације морају бити проценти или бројеви. Вредност коју сте унели за границу {$a} није препозната.';
$string['feedbackerrorboundaryoutofrange'] = 'Граничне вредности оцене за повратне информације морају бити између 0% и 100%. Вредност коју сте унели за границу {$a} је ван дозвољеног опсега.';
$string['feedbackerrorjunkinboundary'] = 'Морате попунити поља за граничне вредности оцена за повратне информације. Немојте прескакати поља, већ их редом попуњавајте.';
$string['feedbackerrorjunkinfeedback'] = 'Морате попунити поља повратних информација. Немојте прескакати поља, већ их редом попуњавајте.';
$string['feedbackerrororder'] = 'Граничне вредности оцена за повратне информације морају бити поређане почевши од највише. Вредност коју сте унели за границу {$a} је изван низа.';
$string['file'] = 'Датотека';
$string['fileformat'] = 'Формат датотеке';
$string['fillcorrect'] = 'Унесите тачан одговор';
$string['filloutnumericalanswer'] = 'Обезбедите бар један могући одговор и одступање. Први одговор који се поклапа биће коришћен за утврђивање оцене и повратних информација. Ако поставите повратне информације без одговора на крају, оне ће бити приказане полазницима чији се одговори не поклапају ни са једним од осталих одговора.';
$string['filloutoneanswer'] = 'Морате понудити најмање један могући одговор. Одговори који се не попуне неће се користити. \'*\' се може користити као џокер знак који замењује било који низ знакова. Први одговор који се поклопи са датим користиће се за одређивање резултата и повратних информација.';
$string['filloutthreequestions'] = 'Морате испунити бар три питања са одговарајућим решењима. Можете додати још нетачних одговора давањем решења уз празна питања. Ставке у којима су и питање и одговор празни неће се узимати у обзир.';
$string['fillouttwochoices'] = 'Морате испунити бар два одговора. Празни одговори се неће користити.';
$string['finishattemptdots'] = 'Заврши покушај...';
$string['finishreview'] = 'Заврши преглед';
$string['forceregeneration'] = 'Обавезно обнављање';
$string['formatnotfound'] = 'Није пронађен формат {$a} за увоз/извоз';
$string['formulaerror'] = 'Грешка у формули!';
$string['fractionsaddwrong'] = 'Позитивне оцене које сте одабрали у збиру не дају 100%<br />Наиме њихов збир је {$a}%<br />Да ли желите да се вратите назад и исправите питање?';
$string['fractionsnomax'] = 'Један од одговора би требао носити 100% оцене, тако да је <br />могуће добити максималну оцену за ово питање.<br />Да ли желите да се вратите назад и исправите питање?';
$string['fromfile'] = 'из датотеке:';
$string['functiondisabledbysecuremode'] = 'Ова функционалност је тренутно онемогућена';
$string['generalfeedback'] = 'Опште повратне информације';
$string['generalfeedback_help'] = 'Опште повратне информације представљају текст који се приказује након давања одговора на питање. За разлику од повратних информација за појединачно питање које зависе од датог одговора, опште повратне информације су увек исте.';
$string['gobacktoquiz'] = 'Врати се';
$string['graceperiod'] = 'Додатно време за предају теста';
$string['graceperiod_desc'] = 'Ако је опција \'Шта радити када време истекне\' подешено на \'Постоји додатни временски период...\', онда је ово подразумевано додатно време које се дозвољава.';
$string['graceperiod_help'] = 'Ако је опција \'Шта радити када време истекне\' подешено на \'Постоји додатни временски период...\', онда је ово додатно време које се дозвољава.';
$string['graceperiodmin'] = 'Додатно време за коначну предају';
$string['graceperiodmin_desc'] = 'Постоји потенцијални проблем на самом крају теста. Са једне стране, желимо да полазници имају могућност да раде тест све до последње секунде - уз помоћ тајмера који аутоматски предаје тест када време истекне. Са друге стране, сервер тада може бити преоптерећен па ће му бити потребно неко време да обради одговоре. Стога ћемо прихватати одговоре и након што рок за предају истекне, унутар овог додатног времена (у секундама), тако да полазници неће бити оштећени због тога што је сервер спор. Међутим, полазници ово могу да злоупотребе тако што ће у току овог додатног времена одговарати на питања. Морате да направите компромис на основу тога колико имате поверења у перформансе свог сервера у току решавања теста.';
$string['graceperiodtoosmall'] = 'Додатно време мора бити веће од {$a}.';
$string['grade'] = 'Оцена';
$string['gradeall'] = 'Оцени све';
$string['gradeaverage'] = 'Просечна оцена';
$string['gradeboundary'] = 'Гранична вредност оцене';
$string['gradeessays'] = 'Оцени есеје';
$string['gradehighest'] = 'Највиша оцена';
$string['gradeitemdefaultname'] = 'Нова ставка за оцењивање {$a}';
$string['gradeitemdelete'] = 'Обришите ставку за оцењивање {$a}';
$string['gradeitemedit'] = 'Уредите назив ставке за оцењивање {$a}';
$string['gradeitemmarkscheme'] = 'Доделите ставке за оцењивање';
$string['gradeitemnewname'] = 'Нови назив ставке за оцењивање {$a}';
$string['gradeitemnoneselected'] = '[ниједнa]';
$string['gradeitemnoslots'] = 'Овај тест још увек нема питања. Прво додајте питања, а затим се вратите овде да бисте подесили ставке за оцењивање.';
$string['gradeitems'] = 'Ставке за оцењивање';
$string['gradeitemsautosetup'] = 'Подесите оцену за сваку секцију';
$string['gradeitemsetup'] = 'Подешавање ставки за оцењивање';
$string['gradeitemsnoneyet'] = 'Креирајте ставке за оцењивање у оквиру свог квиза. Доделите питања или делове теста овим ставкама за оцењивање како бисте оцене поделили на различите области.';
$string['gradeitemsremoveall'] = 'Ресетујте подешавање';
$string['gradeitemsremoveallconfirm'] = 'Желите ли да ресетујете подешавања ставки за оцењивање?';
$string['gradeitemsremoveallmessage'] = 'Ово ће обрисати све ставке за оцењивање и опозвати доделу питања и делова теста из њих.<br><br>Ова акција неће утицати на сама питања и делове теста, нити на постојеће покушаје у оквиру квиза.';
$string['gradeitemsremovealltitle'] = 'Ресетујте подешавање ставки за оцењивање';
$string['grademethod'] = 'Начин оцењивања';
$string['grademethod_help'] = '<p>Када је дозвољен већи број покушаја решавањa теста, постоје различити начини за израчунавање полазникове коначне оцене.</p>

<p><b>Највиша оцена</b><p>
<ul>
<p>Коначна оцена је највиша (најбоља) оцена постигнута у било ком покушају.</p>
</ul>

<p><b>Просечна оцена</b><p>
<ul>
<p>Коначна оцена је просечна оцена (аритметичка средина) свих покушаја.</p>
</ul>

<p><b>Прва оцена</b><p>
<ul>
<p>Коначна оцена је оцена добијена приликом првог покушаја решавања теста (остали покушаји се игноришу).</p>
</ul>

<p><b>Последња оцена</b><p>
<ul>
<p>Коначна оцена је оцена добијена приликом последњег покушаја решавања теста.</p>
</ul>';
$string['gradesdeleted'] = 'Избрисано оцена теста:';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Прелазна оцена не може бити нула јер овај тест има постављен метод завршетка који захтева прелазну оцену. Молимо, унесите вредност различиту од нуле.';
$string['gradetopassoutof'] = 'Пролазна оцена: {$a->grade} од {$a->maxgrade}';
$string['gradingdetails'] = 'Оцена за овај одговор је: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Са претходним казненим бодовима оцена је <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Овим одговором сте зарадили {$a} казнених бодова.';
$string['gradingdetailszeropenalty'] = 'Нисте зарадили казнене бодове за овај одговор';
$string['gradingmethod'] = 'Метод оцењивања: {$a}';
$string['groupoverrides'] = 'Измене подешавања за групе';
$string['groupoverridesdeleted'] = 'Измене подешавања за групе обрисане';
$string['groupsnone'] = 'Не постоје групе којима можете приступити.';
$string['guestsno'] = 'Нажалост, гости не могу ни да виде ни да решавају тестове';
$string['hidebreaks'] = 'Сакриј преломе страница';
$string['hidereordertool'] = 'Сакриј алат за реорганизовање';
$string['history'] = 'Историјат одзива система:';
$string['howquestionsbehave_desc'] = 'Подразумевано подешавање за тo како се питања понашају у тесту';
$string['imagedisplay'] = 'Слика за приказ';
$string['import_help'] = 'Ова функција вам омогућава да питања увезете из екстерних текстуалних датотека.

Ако ваша датотека садржи тзв. non-ascii знакове онда она мора да користи UTF-8 кодни распоред. Посебно будите опрезни са датотекама које су генерисале Microsoft Office апликације, пошто оне обично користе специјалан кодни распоред који неће бити исправно обрађен.

Формати за увоз и извоз су прилагодљиви ресурси. Други, опциони, формати могу се пронаћи у бази "Modules and Plugins" на сајту moodle.org.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'категорија увоза';
$string['importerror'] = 'Дошло је до грешке у току обраде увоза';
$string['importfilearea'] = 'Увоз из датотеке која је већ међу датотекама курса';
$string['importfileupload'] = 'Увоз из новоучитане датотеке...';
$string['importfromthisfile'] = 'Увоз из ове датотеке';
$string['importingquestions'] = 'Увоз {$a} питања из датотеке';
$string['importmax10error'] = 'Постоји грешка у питању. Не може бити више од десет одговора';
$string['importmaxerror'] = 'Постоји грешка у питању. Има превише одговора.';
$string['importquestions'] = 'Увези питања из датотеке';
$string['inactiveoverridehelp'] = '* Ова измена је неактивна, јер је приступ корисника активности ограничен. То може бити због групе или улоге који су кориснима додељени, због  других ограничења приступа или због тога што је активност скривена.';
$string['incorrect'] = 'Нетачно';
$string['indicator:cognitivedepth'] = 'Тест - когнитивни аспект';
$string['indicator:cognitivedepth_help'] = 'Овај индикатор се заснива на когнитивној дубини коју је полазник постигао у оквиру активности \'Тест\'.';
$string['indicator:cognitivedepthdef'] = 'Тест - когнитивни аспект';
$string['indicator:cognitivedepthdef_help'] = 'Учесник је постигао овај проценат когнитивног ангажмана који нуде активности Тест током овог интервала анализе (Нивои = Без прегледа, Преглед, Предаја одговора, Преглед повратних информација, Коментар на повратне информације, Поновна предаја одговора након прегледа повратних информација)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Тест - социјални аспект';
$string['indicator:socialbreadth_help'] = 'Овај индикатор се заснива на обиму социјалних интеракција који је полазник постигао у оквиру активности \'Тест\'.';
$string['indicator:socialbreadthdef'] = 'Тест - социјални аспект';
$string['indicator:socialbreadthdef_help'] = 'Учесник је постигао овај проценат социјалног ангажмана који нуде активносит Тест током овог интервала анализе (Нивои = Без учешћа, Учесник сâм, Учесник са другима)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Одговори појединаца на свако питање';
$string['info'] = 'Информације';
$string['infoshort'] = 'и';
$string['initialnumfeedbacks'] = 'Почетни број поља за свеобухватне повратне информације';
$string['initialnumfeedbacks_desc'] = 'Када се креира нови тест, обезбедите овај број празних поља за свеобухватне повратне информације. Једном, када је тест креиран, образац приказује број поља неопходних за одговарајући број повратних информација у тесту. Ово подешавање мора да буде најмање 1.';
$string['inprogress'] = 'У току';
$string['introduction'] = 'Опис';
$string['invalidattemptid'] = 'Такав id покушаја не постоји';
$string['invalidcategory'] = 'Идентификатор категорије није ваљан';
$string['invalidoverrideid'] = 'Неисправна ID ознака измене';
$string['invalidquestionid'] = 'Неисправан id питања';
$string['invalidquizid'] = 'Неисправан идентификатор теста';
$string['invalidrandomslot'] = 'Невалидан идентификатор слота насумично одабраног питања';
$string['invalidsource'] = 'Извор није прихваћен као валидан.';
$string['invalidsourcetype'] = 'Није валидан тип извора';
$string['invalidstateid'] = 'Неисправан id статуса';
$string['lastanswer'] = 'Ваш одговор је био';
$string['lastautosave'] = 'Последње пут сачувано: {$a}';
$string['layout'] = 'Изглед (распоред питања)';
$string['layoutasshown'] = 'Изглед странице као што је приказано.';
$string['layoutasshownwithpages'] = 'Изглед странице као што је приказано. <small>(Нова страница аутоматски на сваких  {$a} питања.)</small>';
$string['layoutshuffledandpaged'] = 'Питања су насумично измешана са {$a} питања по страници.';
$string['layoutshuffledsinglepage'] = 'Питања насумично измешана, сва приказана на једној страници.';
$string['link'] = 'Линк';
$string['listitems'] = 'Списак ставки у тесту';
$string['literal'] = 'Знак';
$string['loadingquestionsfailed'] = 'Број неуспелих учитавања питања: $a';
$string['makecopy'] = 'Сачувај као ново питање';
$string['managetypes'] = 'Управљање типовима питања и серверима';
$string['manualgradequestion'] = 'Ручно оцени питање {$a->question} у {$a->quiz} од стране корисника {$a->user}';
$string['manualgrading'] = 'Оцењивање';
$string['mark'] = 'Предајте';
$string['markall'] = 'Предајте страницу';
$string['marks'] = 'Оцене';
$string['marks_help'] = 'Оцена добијена за свако питање, као и свеукупни резултат покушаја. Можете да изаберете Оцене само ако је изабрана опција Максималне оцене.';
$string['match'] = 'Спаривање';
$string['matchanswer'] = 'Спаривање одговора';
$string['matchanswerno'] = 'Спаривање одговора {$a}';
$string['max'] = 'Максимално';
$string['maxmark'] = 'Максимална оцена';
$string['maxmarks'] = 'Максималне оцене';
$string['maxmarks_help'] = 'Максимална оцена доступна за свако питање.';
$string['messageprovider:attempt_grading_complete'] = 'Обавештење да је ваш покушај оцењен';
$string['messageprovider:attempt_overdue'] = 'Упозорење када ваш покушај решавања теста касни';
$string['messageprovider:confirmation'] = 'Потврда о предаји ваших покушаја решавања теста';
$string['messageprovider:submission'] = 'Обавештење о предатим тестовима ваших полазника';
$string['min'] = 'Минимално';
$string['minutes'] = 'Минут(а)';
$string['missingcategory'] = 'Недостаје категорија питања';
$string['missingcorrectanswer'] = 'Морате задати тачан одговор';
$string['missingitemtypename'] = 'Недостаје назив';
$string['missingquestion'] = 'Недостаје назив питања након линије {$a}';
$string['modulename'] = 'Тест';
$string['modulename_help'] = 'Модул \'Тест\' омогућава предавачима да дизајнирају тестове који се састоје од различитих типова питања, укључујући вишеструки избор, спаривање, кратак одговор, нумеричка питања итд.

Предавач може да дозволи да се тест решава више пута, са измешаним редоследом питања или насумично изабраним питањима из банке, приликом сваког покушаја. Такође, могуће је подесити временско ограничење за решавање теста.

Сваки покушај се аутоматски оцењује, са изузетком есејског типа питања, а оцена се бележи у књигу оцена.

Предавач може да изабере да ли ће и када полазницима бити приказни савети, повратне информације и тачни одговори

Тестови могу да се користе:

* као завршни испити
* као мини тестови након што полазници имају задатак да прочитају одређени текст, или на крају неке теме (области)
* као припрема за завршни испит, користећи питања са претходних  испита
* за пружање непосредних повратних информација о постигнућима
* за самосталну процену знања';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Тестови';
$string['moveselectedonpage'] = 'Премести изабрана питања на страницу: {$a}';
$string['multichoice'] = 'Вишеструки избор';
$string['multipleanswers'] = 'Одаберите бар један одговор.';
$string['mustbesubmittedby'] = 'Овај покушај мора бити предат до {$a}.';
$string['name'] = 'Назив';
$string['navigatenext'] = 'Следећа страница';
$string['navigateprevious'] = 'Претходна страница';
$string['navmethod'] = 'Метод навигације';
$string['navmethod_free'] = 'Слободна навигација';
$string['navmethod_help'] = 'Када је укључена секвенцијална навигација полазници морају да одговарају на питања оним редоследом како су она поређана у тесту и не могу да се враћају на претходне или прескачу странице.';
$string['navmethod_seq'] = 'Секвенцијална навигација';
$string['navnojswarning'] = 'Упозорење: ови линкови неће сачувати ваше одговоре. Користите дугме "Следеће" на дну странице.';
$string['neverallononepage'] = 'Никад, сва питања на једну страницу';
$string['newattemptfail'] = 'Грешка: Није било могуће започети нови покушај решавања теста';
$string['newcategory'] = 'Нова категорија';
$string['newpage'] = 'Нова страница';
$string['newpage_help'] = '<p>Код тестове са пуно питања има смисла поделити тест на неколико страница тако што ће се ограничити број питања по једној страници. Када се тесту додају питања, преломи страница биће аутоматски уметнити сходно подешавању које сте овде изабрали. Ипак, такође је могуће да касније, током уређивања странице, ручно премештате преломе страница.
</p>';
$string['newpageevery'] = 'Аутоматски старуј нову страницу';
$string['newsectionheading'] = 'Нови наслов';
$string['noanswers'] = 'Ниједан одговор није изабран!';
$string['noattempts'] = 'Није било покушаја да се реши овај тест';
$string['noattemptsfound'] = 'Није пронађен ниједан покушај.';
$string['noattemptstoshow'] = 'Нема покушаја за приказ';
$string['nocategory'] = 'Погрешна или неспецифицирана категорија';
$string['noclose'] = 'Нема датума затварања теста';
$string['nocommentsyet'] = 'Још нема коментара';
$string['noconnection'] = 'Тренутно није успостављена веза са веб сервисом који може да обради ово питање. Молимо контактирајте свог администратора';
$string['nodataset'] = 'ништа - није џокер знак';
$string['nodatasubmitted'] = 'Ниједан податак није послат.';
$string['noessayquestionsfound'] = 'Нису пронађена питања која се ручно оцењују';
$string['nogradewarning'] = 'Овај тест се не оцењује, тако да не можете да подесите свеобухватну повратну информацију.';
$string['nomoreattempts'] = 'Немате више право да покушавате да решите тест';
$string['none'] = 'Ниједна';
$string['noopen'] = 'Нема датума отварања теста';
$string['nooverridedata'] = 'Морате да измените барем једно од подешавања теста';
$string['nopossibledatasets'] = 'Нема могућих скупова података';
$string['noquestionintext'] = 'Текст питања не садржи уметнута питања';
$string['noquestions'] = 'Ниједно питање још није додато';
$string['noquestionsfound'] = 'Нема питања';
$string['noquestionsinquiz'] = 'Не постоје питања у овом тесту';
$string['noquestionsnotinuse'] = 'Ово насумично одрабрано питање није у употреби јер је његова категорија празна';
$string['noquestionsonpage'] = 'Празна страница';
$string['noresponse'] = 'Без одговора';
$string['noreview'] = 'Није Вам дозвољен преглед овог теста';
$string['noreviewattempt'] = 'Није Вам дозвољено да прегледате овај покушај';
$string['noreviewshort'] = 'Преглед није дозвољен';
$string['noreviewuntil'] = 'Није Вам дозвољен преглед овог теста до {$a}';
$string['noreviewuntilshort'] = 'Доступно {$a}';
$string['noscript'] = 'JavaScript мора бити омогућен да бисте наставили даље!';
$string['notavailabletostudents'] = 'Напомена: Овај тест није још доступан вашим полазницима.';
$string['notenoughrandomquestions'] = 'Нема довољно питања у категорији {$a->category} за креирање питања {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Није дефинисано довољно потпитања!<br />Да ли желите да се вратите назад и исправите питање?';
$string['notifyattemptsgradedtask'] = 'Слање обавештења о оцењеним покушајима решавања теста';
$string['notimedependentitems'] = 'Модул за тестове тренутно не подржава временски ограничена питања. Подесите временко ограничење за читав тест. Да ли желите да изаберете друго питање (или да ипак употребите тренутно питање)?';
$string['notyetgraded'] = 'Још није оцењено';
$string['notyetviewed'] = 'Још није прегледано';
$string['notyourattempt'] = 'Ово није Ваш покушај!';
$string['noview'] = 'Пријављеном кориснику није дозвољено да прегледа овај тест';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} су начинили {$a->attemptnum} покушаја';
$string['numberabbr'] = '#';
$string['numerical'] = 'Нумеричко';
$string['numquestionsx'] = 'Питања: {$a}';
$string['oneminute'] = '1 минут';
$string['onlyteachersexport'] = 'Само предавачи могу да извозе питања';
$string['onlyteachersimport'] = 'Само предавачи са правима уређивања могу да увозе питања';
$string['onthispage'] = 'Ова страница';
$string['open'] = 'Није одговорено';
$string['openafterclose'] = 'Није могуће ажурирати тест. Навели сте датум отварања након датума затварања.';
$string['openclosedatesupdated'] = 'Ажурирани су датуми отварања и затварања теста';
$string['optional'] = 'опционо';
$string['orderandpaging'] = 'Редослед питања и организација страница';
$string['orderandpaging_help'] = 'Бројеви 10, 20, 30... поред сваког питања указују на редослед питања у тесту. Бројеви се повећавају у корацима по 10 како би се оставио простор за убацивање додатних питања. Да бисте променили редослед питања, промените број а онда кликните на дугме "Промени редослед питања".

Да бисте додали прелом странице након одређеног питања, означите поље за потврду одмах поред самог питања а затим кликните на дугме "Додај нове странице после изабраних питања"

Да бисте организовали питања на више страница кликните на дугме "Реорганизуј странице" и изаберите жељени број питања по страници.';
$string['orderingquiz'] = 'Редослед питања и организација страница';
$string['orderingquizx'] = 'Редослед и организација страница: {$a}';
$string['outcomesadvanced'] = 'Исходи су напредна подешавања';
$string['outof'] = '{$a->grade} од {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} од {$a->maxgrade}';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Свеобухватне повратне информације';
$string['overallfeedback_help'] = 'Свеобухватнe повратнe информацијe представљају текст који се приказује након решавња теста. Ако се додатно одреде граничне вредности оцена (као проценти или бројеви), текст који ће бити приказан зависи од добијене оцене.';
$string['overdue'] = 'Закаснели';
$string['overduehandling'] = 'Када време истeкне';
$string['overduehandling_desc'] = 'Шта се обично догађа ако полазник не преда тест пре него што време истекне.';
$string['overduehandling_help'] = 'Ово подешавање контролише шта се догађа ако полазник не успе да преда свој покушај решавања теста пре него што време истекне. Ако полазници активно раде на тесту у том тренутку, онда ће тајмер аутоматски предати покушај уместо њих, али ако су одјављен са система, онда ово подешавање контролише шта ће се десити.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Покушаји морају бити предати пре него што време истекне, или се неће рачунати';
$string['overduehandlingautosubmit'] = 'Започети покушаји се аутоматски предају';
$string['overduehandlinggraceperiod'] = 'Постоји додатни временски период у ком се започети покушаји решавања могу предати, али се на питања више не може одговарати';
$string['overduemustbesubmittedby'] = 'Време за овај покушај решавање теста је истекло. Покушај је већ требало предати. Ако желите да овај тест буде оцењен морате га предати до {$a}. Ако то не урадите до наведеног рока, оцене за овај покушај се неће рачунати.';
$string['override'] = 'Измена';
$string['overridecannotchange'] = 'Корисник или група се не могу променити након што је креирана измена подешавања.';
$string['overridecannotsetbothgroupanduser'] = 'И група и корисник се не могу подесити у исто време.';
$string['overridedeletegroupsure'] = 'Да ли сте сигурни да желите да обришете измену подешавања за групу {$a}?';
$string['overridedeleteusersure'] = 'Да ли сте сигурни да желите да обришете измену подешавања за корисника {$a}?';
$string['overridegroup'] = 'Измени подешавања за групу';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'Вредности за покушаје морају бити већа од нуле';
$string['overrideinvalidexistingid'] = 'Постојећа измена подешавања не постоји.';
$string['overrideinvalidgroup'] = 'Дата група не постоји.';
$string['overrideinvalidquiz'] = 'Подешена ID ознака теста не постоји.';
$string['overrideinvalidtimelimit'] = 'Временско ограничење мора бити веће од нуле.';
$string['overrideinvaliduser'] = 'Дати корисник не постоји.';
$string['overridemissingdelete'] = 'ID ознака(е) измене(а) подешавања {$а} не могу бити обрисане јер не постоје или нису део датог теста.';
$string['overridemultiplerecordsexist'] = 'За истог корисника/групу није могуће извршити вишеструке измене подешавања.';
$string['overridemustsetuserorgroup'] = 'Корисник или група морају бити подешени.';
$string['overrides'] = 'Измене';
$string['overridesforquiz'] = 'Измене подешавања: {$a}';
$string['overridesnoneforgroups'] = 'За овај тест нису креиране измене подешавања теста за групе.';
$string['overridesnoneforusers'] = 'За овај тест нису креиране измене подешавања теста за кориснике.';
$string['overridessummary'] = 'Постоје измене подешавања ({$a})';
$string['overridessummarygroup'] = 'Групе: {$a}';
$string['overridessummarythisgroup'] = 'Постоје измене подешавања ({$a}) за ову групу';
$string['overridessummaryuser'] = 'Корисници: {$a}';
$string['overridessummaryyourgroups'] = 'Постоје измене подешавања ({$a}) за вашу групу';
$string['overrideuser'] = 'Измени подешавања за корисника';
$string['overrideusereventname'] = '{$a->quiz} - Измена';
$string['page-mod-quiz-attempt'] = 'Страница покушаја решавања теста';
$string['page-mod-quiz-edit'] = 'Страница за уређивање теста';
$string['page-mod-quiz-report'] = 'Било која страница извештаја о тесту';
$string['page-mod-quiz-review'] = 'Страница за преглед покушаја решавања теста';
$string['page-mod-quiz-summary'] = 'Страница са резимеом покушаја';
$string['page-mod-quiz-view'] = 'Страница са информацијама о тесту';
$string['page-mod-quiz-x'] = 'Било која страница тест модула';
$string['pageshort'] = 'Стр.';
$string['pagesize'] = 'Величина странице';
$string['parent'] = 'Надређени';
$string['parentcategory'] = 'Надређена категорија';
$string['parsingquestions'] = 'Парсирање питања из увозне датотеке.';
$string['partiallycorrect'] = 'Делимично тачно';
$string['penalty'] = 'Казнени бодови';
$string['penaltyscheme'] = 'Примени казнене бодове';
$string['penaltyscheme_help'] = '<p>Ако је тест покренут у адаптивном моду онда је полазницима дозвољено да, након погрешног одговора, покушају поново. У том случају можда ћете пожелети да уведете казнене поене за сваки погрешан одговор како бисте умањили финалну оцену. Вредност казнених поена се одређује појединачно за свако питање приликом подешавања и уређивања питања.</p>

<p>Ово подешавање је без утицаја уколико тест није покренут у адаптивном моду.</p>';
$string['percentcorrect'] = 'Проценат тачности';
$string['pleaseclose'] = 'Ваш захтев је прослеђен. Можете да затворите прозор';
$string['pluginadministration'] = 'Администрација теста';
$string['pluginname'] = 'Тест';
$string['popup'] = 'Прикажи тест у \'безбедном\' прозору';
$string['popupblockerwarning'] = 'Овај део теста се ради у безбедном моду, што значи да морате решавати тест у безбедном прозору. Молимо искључите све алате за спречавање појаве искачућих прозора. Хвала.';
$string['popupnotice'] = 'Полазници ће видети тест у \'сигурном\' прозору';
$string['preprocesserror'] = 'Дошло је до грешке у току претходне обраде!';
$string['preview'] = 'Преглед';
$string['previewquestion'] = 'Преглед питања';
$string['previewquiz'] = 'Прегледај {$a}';
$string['previewquiznow'] = 'Прегледај тест сада';
$string['previewquizstart'] = 'Започни тест';
$string['previous'] = 'Претходно стање';
$string['privacy:metadata:core_question'] = 'Активност \'Тест\' чува информације о коришћењу питања у подсистему core_question.';
$string['privacy:metadata:quiz'] = 'Активност \'Тест\' користи извештаје о тесту.';
$string['privacy:metadata:quiz_attempts'] = 'Детаљне информације о сваком покушају решавања теста.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Број покушаја.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Тренутна страница на којој је корисник.';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Време када је корисник обавештен да је ручно оцењивање његовог покушаја завршено';
$string['privacy:metadata:quiz_attempts:preview'] = 'Да ли је ово преглед теста.';
$string['privacy:metadata:quiz_attempts:state'] = 'Тренутни статус покушаја.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Збир оцена у покушају.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Време када је статус покушаја проверен.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Време када је покушај завршен.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Време када је покушај ажуриран.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Време када је покушај ажуриран путем офлајн ажурирања.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Време када је покушај започет.';
$string['privacy:metadata:quiz_grades'] = 'Детаљне информације о укупној оцени за овај тест.';
$string['privacy:metadata:quiz_grades:grade'] = 'Укупна оцена за овај тест.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Тест који је оцењен.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Време када је оцена измењена.';
$string['privacy:metadata:quiz_grades:userid'] = 'Корисник који је оцењен.';
$string['privacy:metadata:quiz_overrides'] = 'Детаљне информације о изменама за овај тест.';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Тест са информацијама о изменама';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Нове време затварања теста.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Ново временско ограничење за тест.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Нове време oтварања теста.';
$string['privacy:metadata:quiz_overrides:userid'] = 'Корисник је измењен';
$string['privacy:metadata:quizaccess'] = 'Активност \'Тест\' користи правила за приступ тесту.';
$string['publish'] = 'Објави';
$string['publishedit'] = 'Да би сте додали или уредили питања у овој категорији морате имати одговарајуће право приступа';
$string['qbrief'] = 'П. {$a}';
$string['qname'] = 'назив';
$string['qti'] = 'IMS QTI формат';
$string['qtypename'] = 'тип, назив';
$string['question'] = 'Питање';
$string['questionbank'] = 'из банке питања';
$string['questionbankmanagement'] = 'Управљање банком питања';
$string['questionbehaviour'] = 'Карактеристике питања';
$string['questioncats'] = 'Категорије питања';
$string['questiondeleted'] = 'Ово питање је обрисано. Обратите се свом предавача.';
$string['questiondependencyadd'] = 'Нема ограничења када на питање {$a->thisq} може да се одговори • Кликни за промену';
$string['questiondependencyfree'] = 'Нема ограничења за ово питање';
$string['questiondependencyremove'] = 'На питање {$a->thisq} не може да се одговори док претходно питање {$a->previousq} није завршено • Кликни за промену';
$string['questiondependsonprevious'] = 'На ово питање не може да се одговори док претходно питање није завршено';
$string['questiondraftonly'] = 'Питање \'{$a}\' је у статусу \'Радна верзија\'. Да бисте га користили у тесту, идите у банку питања и промените статус питања на \'Спремно\'.';
$string['questiondraftwillnotwork'] = 'Ово питање је у статусу \'Радна верзија\'. Да бисте га користили у тесту, идите у банку питања и промените статус питања на \'Спремно\'.';
$string['questioninuse'] = 'Питање \'{$a->questionname}\' се тренутно користи у <br />{$a->quiznames}<br />Питање неће бити обрисано из ових тестова, већ само са списка категорије.';
$string['questionmissing'] = 'Недостаје питање за ову сесију';
$string['questionname'] = 'Назив питања';
$string['questionnonav'] = '<span class="accesshide">Питање </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Информација </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Питање {$a} није учитано из базе података';
$string['questionorder'] = 'Редослед питања';
$string['questionposition'] = 'Нова позиција у редоследу за питање {$a}';
$string['questions'] = 'Питања';
$string['questionsetpreview'] = 'Преглед скупа питања';
$string['questionsinclhidden'] = 'Питања (укључујући и скривена)';
$string['questionsinthisquiz'] = 'Питања у овом тесту';
$string['questionsmatchingfilter'] = 'Питања која одговарају овом филтеру: {$a}';
$string['questionsperpage'] = 'Број питања по страници';
$string['questionsperpageselected'] = 'Број питања по страници је подешен, тако да је тренутно број страница фиксиран. Услед тога контроле за реорганизацију страница су искључене. Ово можете да промените на {$a}.';
$string['questionsperpagex'] = 'Број питања по страници: {$a}';
$string['questiontext'] = 'Текст питања';
$string['questiontextisempty'] = '[Нема текста питања]';
$string['questiontype'] = 'Тип питања {$a}';
$string['questiontypesetupoptions'] = 'Опције подешавања за типове питања:';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (најновија)';
$string['quiz:addinstance'] = 'Додавање новог теста';
$string['quiz:attempt'] = 'Покушај решавања тестова';
$string['quiz:deleteattempts'] = 'Обриши покушаје решавања теста';
$string['quiz:emailconfirmsubmission'] = 'Добијање потврде о предаји ваших сопствених тестова';
$string['quiz:emailnotifyattemptgraded'] = 'Добијање поруке са обавештењем када је ваш покушај оцењен';
$string['quiz:emailnotifysubmission'] = 'Добијање поруке са обавештењем о предатим тестовима ваших полазника';
$string['quiz:emailwarnoverdue'] = 'Добијање упозорење када ваш покушај решавања теста касни';
$string['quiz:grade'] = 'Оцени тестове ручно';
$string['quiz:ignoretimelimits'] = 'Занемари временско ограничење теста';
$string['quiz:manage'] = 'Управљање тестовима';
$string['quiz:manageoverrides'] = 'Управљање изменама подешавања теста';
$string['quiz:preview'] = 'Прегледај тестова';
$string['quiz:regrade'] = 'Поново оцени покушаје';
$string['quiz:reopenattempts'] = 'Поново отворите покушаје решавања теста који никад нису предати';
$string['quiz:reviewmyattempts'] = 'Прегледај сопствене покушаје';
$string['quiz:view'] = 'Преглед информација о тесту';
$string['quiz:viewoverrides'] = 'Преглед измена подешавања теста';
$string['quiz:viewreports'] = 'Преглед извештаја о тесту';
$string['quizavailable'] = 'Тест је доступан до: {$a}';
$string['quizclose'] = 'Тест доступан до:';
$string['quizclosed'] = 'Тест је затворен дана {$a}';
$string['quizcloses'] = 'Тест се затвара';
$string['quizcloseson'] = 'Овај тест се затвара {$a}.';
$string['quizeventcloses'] = '{$a} се затвара';
$string['quizeventopens'] = '{$a} се отвара';
$string['quizisclosed'] = 'Овај тест је затворен';
$string['quizisclosedwillopen'] = 'Тест је затворен (отвара се {$a})';
$string['quizisopen'] = 'Овај тест је отворен';
$string['quizisopenwillclose'] = 'Тест је отворен (затвара се {$a})';
$string['quiznavigation'] = 'Навигација теста';
$string['quizopen'] = 'Тест доступан од:';
$string['quizopenclose'] = 'Датуми отварања и затварања';
$string['quizopenclose_help'] = 'Полазници могу само да започну своје покушаје решавања теста након датума отварања и морају да их заврше пре датума затварања.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Овај тест је отворен';
$string['quizopenedon'] = 'Овај тест је отворен {$a}';
$string['quizopens'] = 'Тест се отвара дана';
$string['quizopenwillclose'] = 'Овај тест је отворен, биће затоворен {$a}';
$string['quizordernotrandom'] = 'Редослед теста није измешан';
$string['quizorderrandom'] = '* Редослед теста је измешан';
$string['quizreport'] = 'Извештај о тесту';
$string['quizsettings'] = 'Подешавања теста';
$string['quizsetupnavigation'] = 'Навигација за подешавање теста';
$string['quiztimer'] = 'Тајмер теста';
$string['quizwillopen'] = 'Овај тест се отвара {$a}';
$string['random'] = 'Насумично одабрано питање';
$string['randomcatwithsubcat'] = '{$a} и поткатегорије';
$string['randomcoursecatwithsubcat'] = 'Било која категорија унутар категорије курсева {$a}';
$string['randomcoursewithsubcat'] = 'Било која категорија на овом курсу';
$string['randomcreate'] = 'Креирај насумично одабрана питања';
$string['randomediting'] = 'Уређивање насумично одабраног питања';
$string['randomfaultynosubcat'] = 'Погрешно питање';
$string['randomfromcategory'] = 'Насумично одабрано питање из категорије';
$string['randomfromexistingcategory'] = 'Насумично одабрано питање из постојеће категорије';
$string['randomfromunavailabletag'] = '{$a} (није расположиво)';
$string['randommodulewithsubcat'] = 'Било која категорија овог теста';
$string['randomnosubcat'] = 'Питања само из ове категорије, не и њених поткатегорија';
$string['randomnumber'] = 'Број насумично изабраних питања';
$string['randomqname'] = 'Насумично изабрано питање на основу услова за филтрирање';
$string['randomqnamecat'] = 'Насумична категорија ({$a->category}) на основу услова задатих помоћу филтера';
$string['randomqnamecattags'] = 'Насумична категорија ({$a->category}) на основу услова задатих помоћу филтера са ознакама: {$a->tags}';
$string['randomqnametags'] = 'Насумично изабрано питање на основу услова за филтрирање са ознакама: {$a}';
$string['randomquestion'] = 'Насумично одабрано питање';
$string['randomquestion_help'] = 'Насумично питање је начин да се у тест убаци питање случајно изабрано из одређене категорије или помоћу одређене ознаке.';
$string['randomquestiontags'] = 'Ознаке';
$string['randomquestiontags_help'] = 'Можете додатно ограничити критеријуме за избор тако што ћете овде навести ознаке питања.

"Насумична" питања биће изабрана од питања која имају све ове ознаке.';
$string['randomquestionusinganewcategory'] = 'Насумично одабрано питање користећи нову категорију';
$string['randomsystemwithsubcat'] = 'Било која категорија на нивоу система';
$string['randomwithsubcat'] = 'Питања из ове категорије и њених поткатегорија';
$string['readytosend'] = 'Управо ћете послати своје решење теста на оцењивање. Да ли сте сигурни да желите да наставите?';
$string['reattemptquiz'] = 'Поновни покушај решавања теста';
$string['recentlyaddedquestion'] = 'Недавно додато питање!';
$string['recurse'] = 'Укључи и питања из поткатегорија';
$string['redoesofthisquestion'] = 'Друга питања на која су овде давани одговори: {$a}';
$string['redoquestion'] = 'Покушајте са другим питањем попут овог';
$string['regrade'] = 'Поново оцени све покушаје';
$string['regradecomplete'] = 'Сви покушаји су поново оцењени';
$string['regradecount'] = '{$a->changed} од укупно {$a->attempt} оцена је промењено';
$string['regradedisplayexplanation'] = 'Покушаји који се мењају током поновног оцењивања се приказују као линкови на прозор за преглед питања';
$string['regradenotallowed'] = 'Немате дозволу за поновно оцењивање овог теста';
$string['regradingquestion'] = 'Поновно оцењивање "{$a}".';
$string['regradingquiz'] = 'Поновно оцењивање теста "{$a}"';
$string['remove'] = 'Уклони';
$string['removeallgroupoverrides'] = 'Обриши све измене подешавања за групе';
$string['removeallquizattempts'] = 'Обриши све покушаје решавања теста';
$string['removealluseroverrides'] = 'Обриши све изменe подешавања за кориснике';
$string['removeemptypage'] = 'Уклони празну страницу';
$string['removepagebreak'] = 'Уклони прелом странице';
$string['removeselected'] = 'Уклони изабране';
$string['rename'] = 'Преименуј';
$string['renderingserverconnectfailed'] = 'Сервер {$a} није успео да обради RQP захтев. Проверите да ли је URL адреса тачна.';
$string['reopenattempt'] = 'Поново отвори';
$string['reopenattemptareyousuremessage'] = 'Ово ће поново отворити покушај решавања теста {$a->attemptnumber} корисника {$a->attemptuser}.';
$string['reopenattemptareyousuretitle'] = 'Поново отворите покушај решавања теста?';
$string['reopenattemptwrongstate'] = 'Покушај {$a->attemptid} је у погрешном статусу ({$a->state}) да би могао бити поново отворен.';
$string['reopenedattemptwillbeinprogress'] = 'Покушај решавања теста остаће отворен и може се наставити.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Покушај решавања теста остаће отворен и може се наставити све док се тест не затвори дана {$a}.';
$string['reopenedattemptwillbesubmitted'] = 'Покушај решавања теста биће одмах послат на оцењивање.';
$string['reorderquestions'] = 'Промени редослед питања';
$string['reordertool'] = 'Прикажи алат за реорганизовање';
$string['repaginate'] = 'Реорганизуј странице са {$a} питања по једној страници';
$string['repaginatecommand'] = 'Реорганизуј странице';
$string['repaginatenow'] = 'Реорганизуј странице сад';
$string['replace'] = 'Замени';
$string['replacementoptions'] = 'Опције за замену';
$string['report'] = 'Извештаји';
$string['reportanalysis'] = 'Анализа питања';
$string['reportattemptsfrom'] = 'Покушаји следећих корисника:';
$string['reportattemptsthatare'] = 'Покушаји чији је статус:';
$string['reportdisplayoptions'] = 'Опције приказа';
$string['reportfullstat'] = 'Детаљна статистика';
$string['reportmulti_percent'] = 'Проценти';
$string['reportmulti_q_x_student'] = 'Одговори полазника';
$string['reportmulti_resp'] = 'Индивидуални одговори';
$string['reportmustselectstate'] = 'Морате да изаберете бар један статус';
$string['reportnotfound'] = 'Извештај није познат ({$a})';
$string['reportoverview'] = 'Преглед';
$string['reportregrade'] = 'Поновна оцена покушаја решавања теста';
$string['reportresponses'] = 'Детаљни одговори';
$string['reports'] = 'Извештаји';
$string['reportshowonly'] = 'Прикажи само покушаје';
$string['reportshowonlyfinished'] = 'Приказ највише једног завршеног покушаја по кориснику ({$a})';
$string['reportsimplestat'] = 'Једноставна статистика';
$string['reportusersall'] = 'сви корисници који су решавали тест';
$string['reportuserswith'] = 'уписани корисници који су решавали тест';
$string['reportuserswithorwithout'] = 'уписани корисници који јесу или нису решавали тест';
$string['reportuserswithout'] = 'уписани корисници који нису решавали тест';
$string['reportwhattoinclude'] = 'Шта укључити у извештај';
$string['requirepassword'] = 'Неопходна је лозинка';
$string['requirepassword_help'] = '<p>Ово поље није обавезно</p>

<p>Ако овде одредите лозинку од учесника ће се захтевати да исту унесу пре него што им се дозволи да покушају да реше тест.</p>';
$string['requiresubnet'] = 'Захтевана мрежна адреса';
$string['requiresubnet_help'] = '<p>Ово поље није обавезно.</p>

<p>Можете ограничити приступ тесту само на неке подмреже у оквиру LAN мреже или Интернета навођењем списка парцијалних или потпуних IP адресних бројева одвојених зарезима.</p>

<p>То је посебно корисно за надгледане тестове, када желите да будете сигурни да само присутни у одређеној просторији могу да приступе тесту.</p>

<p>На пример:  <b>192.168. , 231.54.211.0/20, 231.3.56.211</b></p>

<p>Постоје три типа IP бројева које можете користити (не можете употребити текстуална имена домена, као што је рецимо primer.com):
<ol>
<li>Потпуне IP aдресе, као што је <b>192.168.10.1</b>, које ће означавати појединачне рачунаре (или proxy сервере).</li>
<li>Парцијалне адресе, као што је <b>192.168</b>, које ће обухватати све адресе које почињу тим бројевима.</li>
<li>CIDR нотација, као што је <b>231.54.211.0/20</b>, која дозвољава детаљнију спецификацију подмрежа.</li>
</ol>
</p>

<p>Празнине се игноришу.</p>';
$string['response'] = 'Одговор';
$string['responses'] = 'Одговори полазника';
$string['results'] = 'Резултати';
$string['returnattempt'] = 'Повратак на покушај';
$string['reuseifpossible'] = 'поново искористи претходно уклоњено';
$string['reverttodefaults'] = 'Врати тест на стандардна подешавања';
$string['review'] = 'Преглед';
$string['reviewafter'] = 'Дозволити преглед након што се тест затвори';
$string['reviewalways'] = 'Дозволити преглед у било које време';
$string['reviewattempt'] = 'Прегледај покушај';
$string['reviewbefore'] = 'Дозволити преглед док је тест отворен';
$string['reviewclosed'] = 'Након што се тест затвори';
$string['reviewduring'] = 'Током покушаја решавања';
$string['reviewimmediately'] = 'Одмах након покушаја';
$string['reviewnever'] = 'Никад немој дозволити преглед';
$string['reviewofquestion'] = 'Преглед питања {$a->question} у {$a->quiz} од стране корисника {$a->user}';
$string['reviewopen'] = 'Касније, док је тест још увек отворен';
$string['reviewoptions'] = 'Полазници могу да прегледају';
$string['reviewoptionsheading'] = 'Опције за преглед';
$string['reviewoptionsheading_help'] = 'Ова опције контролишу које информације полазници могу да виде када прегледају покушај решавања теста односно када гледају извештај са теста.

**У току покушаја** - ово подешавање је релевантно само за нека понашања, као што је \'интерактивно са вишеструким покушајима\',  које може да приказује повратне информације у току покушаја.

**Одмах након покушаја** - ово подешавање се примењује у прва два минута након што је полазник кликнуо на дугме \'Предај све и заврши\'.

**Касније, док је тест још увек отворен** - ово подешавање се примењује, након та прва два минута па све док је тест отворен.

**Након што је тест затворен** - ово подешавање се примењује након што прође датум затварања теста. Ако тест нема датум затварања, овај услов никада неће бити постигнут.';
$string['reviewoverallfeedback'] = 'Свеобухватне повратне информације';
$string['reviewoverallfeedback_help'] = 'Повратне информације које се дају на крају покушаја решавања теста, у зависности од укупне оцене полазника.';
$string['reviewresponse'] = 'Преглед одговора';
$string['reviewresponsetoq'] = 'Прегледај одговоре (питање {$a})';
$string['reviewthisattempt'] = 'Прегледај свој одговор на овај покушај';
$string['rqp'] = 'Удаљено питање';
$string['rqps'] = 'Удаљена питања';
$string['sameasoverall'] = 'Исто као и за свеукупне оцене';
$string['save'] = 'Сачувај';
$string['saveandedit'] = 'Сачувај промене и уреди питања';
$string['saveattemptfailed'] = 'Неуспело чување актуелног покушаја решења теста.';
$string['savedfromdeletedcourse'] = 'Сачувано са курса "{$a}" који је обрисан';
$string['savegrades'] = 'Сачувај оцене';
$string['savemanualgradingfailed'] = 'Измена није сачувана. Проверите поруку у наставку и покушајте поново.';
$string['savemyanswers'] = 'Сачувај моје одговоре';
$string['savenosubmit'] = 'Сачувај без предавања';
$string['saveoverrideandstay'] = 'Сачувај и унеси другу измену';
$string['savequiz'] = 'Сачувај цео тест';
$string['saving'] = 'Чување';
$string['savingnewgradeforquestion'] = 'Чување нове оцене за питање са идентификатором {$a}.';
$string['savingnewmaximumgrade'] = 'Чување нове максималне оцене';
$string['score'] = 'Необрађени резултат';
$string['scores'] = 'Резултати';
$string['search:activity'] = 'Тест - инормације о активности';
$string['sectionheadingedit'] = 'Уреди наслов \'{$a}\'';
$string['sectionheadingremove'] = 'Уклони наслов \'{$a}\'';
$string['sectionnoname'] = 'Секција без наслова';
$string['seequestions'] = '(Погледај питања)';
$string['select'] = 'Селектуј';
$string['selectall'] = 'Изабери све';
$string['selectattempt'] = 'Одабери покушај';
$string['selectcategory'] = 'Изабери категорију';
$string['selectedattempts'] = 'Изабрани покушаји...';
$string['selectmultipleitems'] = 'Изабери више ставки';
$string['selectmultipletoolbar'] = 'Изабери више трака са алаткама';
$string['selectnone'] = 'Поништи избор свега';
$string['selectquestionslot'] = 'Изабери питање {$a}';
$string['selectquestiontype'] = '-- Избаери тип питања --';
$string['serveradded'] = 'Сервер је додат';
$string['serveridentifier'] = 'Идентификатор';
$string['serverinfo'] = 'Информације о серверу';
$string['servers'] = 'Сервери';
$string['serverurl'] = 'URL сервера';
$string['shortanswer'] = 'Питање са кратким одговором';
$string['show'] = 'Прикажи';
$string['showall'] = 'Прикажи сва питања на једној страници';
$string['showblocks'] = 'Прикажи блокове током решавања теста';
$string['showblocks_help'] = 'Ако је подешенo на \'да\', онда ће у току решавања теста бити приказани  уобичајени блокови.';
$string['showbreaks'] = 'Прикажи преломе страница';
$string['showcategorycontents'] = 'Прикажи садржај категорија {$a->arrow}';
$string['showcorrectanswer'] = 'Да ли да се уз повратне информације прикажу и тачни одговори?';
$string['showdetailedmarks'] = 'Прикажи детаље оцене';
$string['showeachpage'] = 'Прикажи једну по једну страницу';
$string['showfeedback'] = 'Да ли да се прикажу и повратне информације након давања одговора на питања?';
$string['showinsecurepopup'] = 'Употребити \'безбедни\' искачући прозор за покушаје';
$string['showlargeimage'] = 'Велика слика';
$string['shownoattempts'] = 'Прикажи полазнике без покушаја';
$string['shownoattemptsonly'] = 'Прикажи само полазнике без покушаја';
$string['shownoimage'] = 'Без слике';
$string['showreport'] = 'Прикажи извештај';
$string['showsmallimage'] = 'Мала слика';
$string['showteacherattempts'] = 'Прикажи покушаје предавача да реши тест';
$string['showuserpicture'] = 'Прикажи слику корисника';
$string['showuserpicture_help'] = 'Ако је ова опција омогућена, име и слика полазника биће приказана на екрану током решавања теста, као и приликом прегледа. Ово олакшава проверу да ли су се полазници пријавили на систме са својим налогом, на тесту који се раде у учионици под контролом проктора (наставника).';
$string['shuffle'] = 'Измешај';
$string['shuffleanswers'] = 'Измешај одговоре';
$string['shuffledrandomly'] = 'Насумично измешано';
$string['shufflequestions'] = 'Измешај';
$string['shufflequestions_help'] = 'Ако је ова опција омогућена, онда ће сваки пут када се покуша решавање теста, редослед питања у овој секцији бити измешана и поређана другачијим насумично редоследом.

Ово може отежати полазницима да размењују одговоре између себе али, такође, отежава и могућност полазницима да дискутују одређено питање са предавачем.';
$string['shufflewithin'] = 'Измешај редослед одговора у оквиру питања';
$string['shufflewithin_help'] = 'Ако омогућите ову опцију, делови од којих се састоје појединачна питања биће насумично измешани сваки пут кад полазник покуша да реши овај тест, под условом да је иста опција омогућена и у подешавањима самих питања. Ово подешавање се примењује само на питања која се састоје из више делова, као што су питања типа вишеструког избора или питања са спаривањем одговора.';
$string['singleanswer'] = 'Одаберите један одговор';
$string['sortage'] = 'Сортирај по времену креирања';
$string['sortalpha'] = 'Сортирај по имену';
$string['sortquestionsbyx'] = 'Поређај питања по {$a}';
$string['sortsubmit'] = 'Сортирај питања';
$string['sorttypealpha'] = 'Сортирај по типу, имену';
$string['specificapathnotonquestion'] = 'Задата путања датотеке није на датом питању';
$string['specificquestionnotonquiz'] = 'Задато питање није у датом тесту';
$string['startagain'] = 'Почни поново';
$string['startattempt'] = 'Започни покушај решавања';
$string['startedon'] = 'Започето';
$string['startnewpreview'] = 'Започните нови преглед';
$string['stateabandoned'] = 'Никад предати';
$string['statefinished'] = 'Завршени';
$string['statefinisheddetails'] = 'Предато {$a}';
$string['stateinprogress'] = 'У току';
$string['statenotloaded'] = 'Статус за питање  {$a} није учитан из базе података';
$string['stateoverdue'] = 'Закаснели';
$string['stateoverduedetails'] = 'Мора се предати до {$a}';
$string['status'] = 'Статус';
$string['stoponerror'] = 'Стани при појави грешке';
$string['submission_confirmation'] = 'Пошаљите све своје одговоре и завршите?';
$string['submission_confirmation_unanswered'] = 'Питања без одговора: {$a}';
$string['submitallandfinish'] = 'Предај све одговоре и заврши тест';
$string['subneterror'] = 'Нажалост, овај тест је закључан, односно доступан је само са појединих локација. Тренутно Ваш рачунар није један од оних којима је дозвољено да користе овај тест.';
$string['subnetnotice'] = 'Овом тесту се може приступити само са одређених места. Ваш рачунар се не налази у мрежи са које је приступ дозвољен. Ипак, као предавач свакако можете да прегледате тест.';
$string['subplugintype_quiz'] = 'Извештај';
$string['subplugintype_quiz_plural'] = 'Извештаји';
$string['subplugintype_quizaccess'] = 'Правило за приступ тесту';
$string['subplugintype_quizaccess_plural'] = 'Правила за приступ тесту';
$string['substitutedby'] = 'биће замењено са';
$string['summaryofattempt'] = 'Резиме покушаја';
$string['summaryofattempts'] = 'Ваши покушаји';
$string['temporaryblocked'] = 'Привремено Вам није дозвољено да поново покушате да решите тест.<br /> Моћи ћете поново да му приступите дана:';
$string['theattempt'] = 'Покушај решавања';
$string['theattempt_help'] = 'Да ли полазник уопште може да прегледа покушај.';
$string['time'] = 'Време';
$string['timecompleted'] = 'Завршено';
$string['timedelay'] = 'Није вам дозвољено да радите тест јер још није протекло довољно времена између провг и другог покушаја решавања теста';
$string['timeleft'] = 'Преостало време';
$string['timelimit'] = 'Временско ограничење';
$string['timelimit_help'] = 'Ако је ова опција омогућена, на почетној страници теста биће наведено временско ограничење, а у блоку за навигацију теста биће приказан тајмер.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Нажалост, време за решавање теста је истекло!';
$string['timestr'] = '%H:%M:%S дана %d.%m.%y.';
$string['timesup'] = 'Време је истекло!';
$string['timetaken'] = 'Утрошено време';
$string['timing'] = 'Подешавање времена';
$string['tofile'] = 'у датотеку';
$string['tolerance'] = 'Одступање';
$string['toomanyrandom'] = 'Број потребних насумичних питања је већи него број питања која постоје у категорији!';
$string['top'] = 'Највиши ниво';
$string['totalmarks'] = 'Максимално бодова за сва питања';
$string['totalmarksx'] = 'Максимално бодова за сва питања: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Укупно {$a} питања у категорији.';
$string['true'] = 'Тачно';
$string['truefalse'] = 'Тачно/нетачно';
$string['type'] = 'Тип';
$string['unfinished'] = 'отворено';
$string['ungraded'] = 'Неоцењено';
$string['unit'] = 'Јединица';
$string['unknowntype'] = 'Тип питања није подржан у реду {$a}. Питање ће бити игнорисано.';
$string['updatefilterconditon'] = 'Ажурирајте услове за филтрирање';
$string['updatefilterconditon_success'] = 'Услови за филтрирање успешно су ажурирани';
$string['updateoverdueattemptstask'] = 'Ажурирање покушаја решавања теста који су предати за кашњењем';
$string['updatequizslotswithrandomxofy'] = 'Ажурирање теста са подацима о "насумичном" питању ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Ажурирај подешавања теста';
$string['updatingatttemptgrades'] = 'Ажурирање оцена покушаја';
$string['updatingfinalgrades'] = 'Ажурирање коначних оцена';
$string['updatingthegradebook'] = 'Ажурирање књиге оцена';
$string['upgradesure'] = '<div>Модул \'Тест\' ће извести обимне промене табела са тестовима у бази података. Ова надоградња још увек није довољно тестирана. Пре него што наставите строго вам препоручујемо да направите резервну копију ваше базе података.</div>';
$string['upgradingquizattempts'] = 'Надоградња покушаја решавања теста: тест {$a->done}/{$a->outof} (Идентификатор теста {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Надоградња врло старих покушаја решавања теста: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Након брисања курса, ова категорија је сачувана и премештена на ниво сајта, због тога што се питања из ове категорије користе у тестовима других курсева.';
$string['useroverrides'] = 'Измене подешавања за кориснике';
$string['useroverridesdeleted'] = 'Измене подешавања за кориснике обрисане';
$string['usersnone'] = 'Ниједан полазник нема приступ овом тесту';
$string['validate'] = 'Провери';
$string['viewallanswers'] = 'Приказ {$a} покушаја решавања теста';
$string['viewallreports'] = 'Погледај извештаје за {$a} покушаја';
$string['viewed'] = 'Прегледано';
$string['warningmissingtype'] = '<b>Ово питање припада типу који још увек није инсталиран на вашем Moodleu.<br />Молимо обавестите свог Moodle администратора.</b>';
$string['wheregrade'] = 'Где је моја оцена?';
$string['wildcard'] = 'Џокер знак';
$string['windowclosing'] = 'Овај прозор ће се убрзо затворити.';
$string['withsummary'] = 'са сумарном статистиком';
$string['wronguse'] = 'Не можете тако да користите ову страницу';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Потребно је да се упишете на овај курс пре него што покушате решавање овог теста';
$string['yourfinalgradeis'] = 'Ваша коначна оцена на овом тесту је {$a}.';
