<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'attendance', language 'de', version '4.4'.
 *
 * @package     attendance
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['Aacronym'] = 'U';
$string['Afull'] = 'Unentschuldigt';
$string['Eacronym'] = 'E';
$string['Efull'] = 'Entschuldigt';
$string['Lacronym'] = 'V';
$string['Lfull'] = 'Verspätet';
$string['Pacronym'] = 'A';
$string['Pfull'] = 'Anwesend';
$string['absenteereport'] = 'Abwesenheitsbericht';
$string['acronym'] = 'Abkürzung';
$string['add'] = 'Hinzufügen';
$string['addedrecip'] = '{$a} neue/n Empfänger/in hinzugefügt';
$string['addedrecips'] = '{$a} neue Empfänger/innen hinzugefügt';
$string['addmultiplesessions'] = 'Wiederkehrende Termine';
$string['addsession'] = 'Termin hinzufügen';
$string['adduser'] = 'Teilnehmer/in hinzufügen';
$string['addwarning'] = 'Warnung hinzufügen';
$string['all'] = 'Alle';
$string['allcourses'] = 'Alle Kurse';
$string['allowupdatestatus'] = 'Teilnehmer/innen erlauben, die Anwesenheit zu ändern';
$string['allowupdatestatus_desc'] = 'Wenn gesetzt, dann sind Teilnehmer/innen in der Lage, ihren eigenen Anwesenheitsstatus für die Sitzung zu ändern, nachdem sie schon selbst einen Status erfasst haben.';
$string['allowupdatestatus_help'] = 'Wenn gesetzt, dann sind Teilnehmer/innen in der Lage, ihren eigenen Anwesenheitsstatus für die Sitzung zu ändern, nachdem sie schon selbst einen Status erfasst haben.';
$string['allpast'] = 'Alle vergangenen';
$string['allsessions'] = 'Alle Termine';
$string['allsessionstotals'] = 'Summen für ausgewählte Termine';
$string['attendance:addinstance'] = 'Neue Anwesenheitsliste hinzufügen';
$string['attendance:canbelisted'] = 'Erscheint in der Liste';
$string['attendance:changeattendances'] = 'Anwesenheit ändern';
$string['attendance:changepreferences'] = 'Einstellungen ändern';
$string['attendance:export'] = 'Berichte exportieren';
$string['attendance:import'] = 'Termine aus einer CSV-Datei importieren';
$string['attendance:manageattendances'] = 'Anwesenheit verwalten';
$string['attendance:managetemporaryusers'] = 'Temporäre Teilnehmer/innen verwalten';
$string['attendance:manualautomark'] = 'Manuell';
$string['attendance:takeattendances'] = 'Anwesenheit eintragen';
$string['attendance:view'] = 'Anwesenheit einsehen';
$string['attendance:viewreports'] = 'Berichte ansehen';
$string['attendance:viewsummaryreports'] = 'Zusammenfassenden Kursbericht ansehen';
$string['attendance:warningemails'] = 'Kann abonniert werden, um E-Mails über abwesende Teilnehmer/innen zu erhalten';
$string['attendance_already_submitted'] = 'Ihre Anwesenheit wurde bereits erfasst.';
$string['attendance_no_status'] = 'Es wurde kein gültiger Status gefunden - Sie könnten zu spät dran sein, um Ihre Anwesenheit zu erfassen.';
$string['attendancedata'] = 'Anwesenheitsdaten';
$string['attendancefile'] = 'Datei für die Anwesenheiten (im CSV-Format)';
$string['attendancefile_help'] = 'Die Datei muss eine CSV-Datei sein, die aus einer Überschriftenzeile und den Einträgen bestehen muss, um den/die Nutzer/in und die Anwesenheitszeit zu erfassen. Beispielsweise (E-Mail, Anwesenheitszeit) oder (Nutzername,Status).';
$string['attendancegrade'] = 'Anwesenheitshäufigkeit';
$string['attendancenotset'] = 'Sie müssen Ihre Anwesenheit eintragen';
$string['attendancenotstarted'] = 'Die Anwesenheitsliste für diesen Kurs startet zu einem späteren Zeitpunkt.';
$string['attendancepercent'] = 'Anwesend in Prozent';
$string['attendancereport'] = 'Anwesenheit';
$string['attendanceslogged'] = 'Erfasste Anwesenheiten';
$string['attendancestaken'] = 'Teilgenommene Anwesenheiten';
$string['attendancesuccess'] = 'Anwesenheitsliste gespeichert';
$string['attendanceupdated'] = 'Anwesenheitsliste geändert';
$string['attendanceuserreport'] = 'Anwesenheitsbericht';
$string['attforblockdirstillexists'] = 'Das obsolete mod/attforblock Verzeichnis ist noch nicht gelöscht - Sie müssen dieses Verzeichnis löschen, bevor Sie dieses Upgrade durchführen können.';
$string['attrecords'] = 'Aufzeichnungen zur Anwesenheit';
$string['autoassignstatus'] = 'Automatisch den höchstmöglichen Status auswählen';
$string['autoassignstatus_help'] = 'Wenn dies ausgewählt ist, wird automatisch der höchstmögliche Status den Nutzer/innen zugewiesen.';
$string['automark'] = 'Automatische Bewertung';
$string['automark_help'] = 'Automatische Statusänderung erlauben
Wenn diese Einstellung auf "Ja" gesetzt ist, erhalten die Nutzer/innen automatisch den Status in Abhängigkeit Ihres Erstzugriffs auf den Kurs.
Wenn die Einstellung auf "Am Ende des Termins auf nicht bewertet setzen" gesetzt ist, wird bei jedem/r Teilnehmer/in, der seine / ihre Anwesenheit noch nicht erfasst hat, der nicht bewertete Status gesetzt.';
$string['automarkall'] = 'Ja';
$string['automarkclose'] = 'Am Ende des Termins auf nicht bewertet setzen';
$string['automarkingcomplete'] = 'Automatisches Markieren manuell zulassen';
$string['automarkingnotavailableyet'] = 'Automatisches Markieren abgeschlossen';
$string['automarkingnotenabled'] = 'Diese Sitzung verwendet die automatische Markierung beim Sitzungsende. Die Sitzung wurde bisher noch nicht beendet.';
$string['automarktask'] = 'Auf Termine überprüfen, die eine automatische Markierung benötigen';
$string['automarkuseempty'] = 'Automatische Kennzeichnung der Statusverfügbarkeit';
$string['automarkuseempty_desc'] = 'Wenn die Option aktiviert ist, werden Statuselemente, die eine leere/unversetzte Einstellung "verfügbar für" haben, während der automatischen Markierung erlaubt';
$string['autorecorded'] = 'Vom System automatisch erfasst';
$string['availability'] = 'Verfügbarkeit des Selbstmarkierens';
$string['availability_help'] = 'Verfügbarkeit dieses Status beschränken. <br>Wenn die Option "Begrenzte Zeit" ausgewählt ist, geben Sie die Anzahl von Minuten an, die dieser Status nach Sitzungsbeginn verfügbar ist. Dies gilt, wenn die Teilnehmer/innen ihre eigene Anwesenheit selbst markieren.';
$string['availabilityalways'] = 'Immer';
$string['availabilitylimitedtime'] = 'Begrenzte Zeit';
$string['availabilityno'] = 'Nein';
$string['availablebeforesession'] = 'Vor dem Sitzungsbegin verfügbar';
$string['availablebeforesession_help'] = 'Wenn Teilnehmer/innen ihre eigene Anwesenheit markieren, erlauben Sie, dass dieser Status vor Sitzungsbeginn markiert wird.';
$string['averageattendance'] = 'Durchschnittliche Anwesenheit';
$string['averageattendancegraded'] = 'Durchschnittliche Anwesenheit';
$string['backtoparticipants'] = 'Zurück zur Teilnehmerliste';
$string['below'] = 'Unter {$a}%';
$string['calclose'] = 'Schließen';
$string['calendarevent'] = 'Kalenderereignis für diesen Termin erzeugen';
$string['calendarevent_help'] = 'Wenn aktiviert, dann wird ein Kalenderereignis für diesen Termin erzeugt.
Wenn deaktiviert, dann werden alle bisher existierenden Kalenderereignisse für die Termine gelöscht.';
$string['caleventcreated'] = 'Kalendereintrag für den Termin erfolgreich erstellt';
$string['caleventdeleted'] = 'Kalendereintrage für den erfolgreich gelöscht';
$string['calmonths'] = 'Januar,Februar,März,April,Mai,Juni,Juli,August,September,Oktober,November,Dezember';
$string['calshow'] = 'Datum auswählen';
$string['calweekdays'] = 'So,Mo,Die,Mi,Do,Fr,Sa';
$string['cannottakeforgroup'] = 'Sie können für die Gruppe \'{$a}\' keine Anwesenheiten erfassen';
$string['cannottakethisgroup'] = 'Da Sie nicht Mitglied der Gruppe sind, für die die Veranstaltung vorgesehen ist, konnte die Anmeldung nicht erfasst werden.';
$string['cantaddstatus'] = 'Sie müssen eine Abkürzung und eine Beschreibung hinzufügen, wenn Sie einen neuen Status definieren.';
$string['canthidestatus'] = 'Sie können diesen Status nicht verbergen, da er bereits innerhalb dieser Anwesenheitsaktivität verwendet wird.';
$string['categoryreport'] = 'Kurskategorie Bericht';
$string['changeattendance'] = 'Anwesenheit ändern';
$string['changeduration'] = 'Dauer ändern';
$string['changesession'] = 'Termin ändern';
$string['checkweekdays'] = 'Wählen Sie Wochentage aus, die innerhalb des von Ihnen gewählten Zeitraums liegen.';
$string['closed'] = 'Dieser Termin steht gerade nicht zur Selbsterfassung zur Verfügung';
$string['column'] = 'Spalte';
$string['columnmap'] = 'Spaltenzuordnung';
$string['columnmap_help'] = 'Wählen Sie für jedes Feld die entsprechende Spalte in der CSV-Datei aus.';
$string['columns'] = 'Spalten';
$string['commonsession'] = 'Alle Teilnehmer/innen';
$string['commonsessions'] = 'Alle Teilnehmer/innen';
$string['confirm'] = 'Bestätigen';
$string['confirmcolumnmappings'] = 'Spaltenzuweisungen bestätigen';
$string['confirmdeletehiddensessions'] = 'Sind Sie sicher, dass Sie {$a->count} Termine, die vor dem Kursbeginn ({$a->date}) geplant sind, löschen möchten?';
$string['confirmdeleteuser'] = 'Sind Sie sicher, dass Sie Teilnehmer/in \'{$a->fullname}\' ({$a->email}) löschen möchten? <br/> Alle Aufzeichnungen der Anwesenheit werden dabei für diese/n Teilnehmer/in dauerhaft gelöscht.';
$string['copyfrom'] = 'Daten zur Anwesenheit kopieren von';
$string['countofselected'] = 'Anzahl markierter Objekte';
$string['course'] = 'Kurs';
$string['coursemessage'] = 'Teilnehmer/innen anschreiben';
$string['courseshortname'] = 'Kurzname des Kurses';
$string['coursesummary'] = 'Zusammenfassender Kursbericht';
$string['createmultiplesessions'] = 'Mehrere Termine erstellen';
$string['createmultiplesessions_help'] = 'Diese Funktion ermöglicht Ihnen, wiederkehrende Termine in einem Schritt zu erstellen. Sie starten an dem Tag des oben definierten Ereignisses und wiederholen sich bis zum Ende des angegebenen \'Wiederholen bis\'-Datums.

  * <strong>Wiederholen am</strong>: Wählen Sie die Wochentage aus, an denen die Veranstaltungen stattfindet, z.B. Montag/Mittwoch/Freitag).
  * <strong>Wiederholen alle</strong>: Dies erlaubt das Setzen einer Terminfrequenz. Wenn Ihre Veranstaltung wöchentlich stattfindet, wählen Sie 1;  wenn sie alle zwei Wochen stattfindet, wählen Sie 2; alle drei Wochen, wählen Sie 3, und so weiter.
  * <strong>Wiederholen bis</strong>: Wählen Sie den letzten Tag des Ereignisses (den letzen Tag, an dem Sie die Anwesenheit erfassen möchten).';
$string['createonesession'] = 'Einen Termine für diesen Kurs erstellen';
$string['csvdelimiter'] = 'CSV Trennzeichen';
$string['currentlyselectedusers'] = 'Aktuell ausgewählte Nutzer/innen';
$string['customexportfields'] = 'Profilfelder exportieren';
$string['customexportfields_help'] = 'Diese zusätzlichen Profilfelder werden im Export einbezogen';
$string['customfields'] = 'Nutzerdefinierte Felder';
$string['date'] = 'Datum';
$string['days'] = 'Tage';
$string['defaultdisplaymode'] = 'Standardmäßiger Anzeigemodus';
$string['defaults'] = 'Voreinstellungen';
$string['defaultsessionsettings'] = 'Standardmäßige Termin-Einstellungen';
$string['defaultsessionsettings_help'] = 'Diese Einstellungen definieren den Standard für alle neuen Termine';
$string['defaultsettings'] = 'Standardmäßige Einstellungen zur Anwesenheit';
$string['defaultsettings_help'] = 'Diese Einstellungen definieren den Standard für alle neuen Anwesenheiten';
$string['defaultstatus'] = 'Standardeinstellung zum Status';
$string['defaultsubnet'] = 'Standardmäßige Netzwerkadresse';
$string['defaultsubnet_help'] = 'Die Erfassung von Anwesenheiten kann auf bestimmte Subnetze beschränkt werden. Dazu listen Sie die vollen oder Teil-IP-Adressen in einer Komma separierten Liste auf. Dies ist der Standardwert für neu erstellte Termine.';
$string['defaultview'] = 'Standardansicht beim Login';
$string['defaultview_desc'] = 'Dies ist die standardmäßige Ansicht für Trainer/innen beim ersten Login.';
$string['defaultwarnings'] = 'Standardmäßiger Katalog für Warnungen';
$string['defaultwarningsettings'] = 'Standardmäßige Einstellungen für Warnungen';
$string['defaultwarningsettings_help'] = 'Diese Einstellungen legen den Standard für alle neuen Warnungen fest';
$string['delete'] = 'löschen';
$string['deletecheckfull'] = 'Möchten Sie wirklich {$a} inklusive aller Nutzerdaten löschen?';
$string['deletedgroup'] = 'Die Gruppe, die diesem Termin zugewiesen wurde, ist gelöscht worden';
$string['deletehiddensessions'] = 'Alle versteckten Termine löschen';
$string['deletelogs'] = 'Daten zur Anwesenheit löschen';
$string['deleteselected'] = 'Ausgewählte löschen';
$string['deletesession'] = 'Termin löschen';
$string['deletesessions'] = 'Alle Termine löschen';
$string['deleteuser'] = 'Teilnehmer/in löschen';
$string['deletewarningconfirm'] = 'Sind Sie sicher, dass Sie diese Warnung löschen möchten?';
$string['deletingsession'] = 'Termin für diesen Kurses löschen';
$string['deletingstatus'] = 'Status für diesen Kurses löschen';
$string['description'] = 'Beschreibung';
$string['display'] = 'Anzeige';
$string['displaymode'] = 'Anzeigemodus';
$string['donotusepaging'] = 'Seitenaufteilung nicht verwenden';
$string['downloadexcel'] = 'Als Excel-Datei herunterladen';
$string['downloadooo'] = 'Als OpenDocument herunterladen';
$string['downloadtext'] = 'Als Textdatei herunterladen';
$string['duration'] = 'Dauer';
$string['editsession'] = 'Termin bearbeiten';
$string['edituser'] = 'Teilnehmer/in bearbeiten';
$string['emailcontent'] = 'Inhalt der E-Mail';
$string['emailcontent_default'] = 'Hallo %userfirstname%,
Ihre Anwesenheit %attendencename% im Kurs %coursename% ist unter die kritische Anwesenheitsschwelle %warningpercent% gefallen und beträgt zur Zeit %percent%.
Wir hoffen, dass es Ihnen gut geht.

Um das Beste aus diesem Kurs herauszuholen, sollten Sie Ihre Anwesenheitszeit erhöhen. Bitte melden Sie sich, falls Sie zusätzliche Unterstützung benötigen.';
$string['emailcontent_help'] = 'Wenn eine Warnung an eine/n Teilnehmer/in verschickt wird, wird der Inhalt der E-Mail aus dieser Einstellung eingefügt. Folgende Platzhalter können verwendet werden:
<ul>
<li>%coursename%</li>
<li>%userfirstname%</li>
<li>%userlastname%</li>
<li>%userid%</li>
<li>%warningpercent%</li>
<li>%attendancename%</li>
<li>%cmid%</li>
<li>%numtakensessions%</li>
<li>%points%</li>
<li>%maxpoints%</li>
<li>%percent%</li>
</ul>';
$string['emailsubject'] = 'Betreff der E-Mail';
$string['emailsubject_default'] = 'Anwesenheitswarnung';
$string['emailsubject_help'] = 'Beim Senden einer Warnung an Teilnehmer/innen wird der Betreff aus diesem Feld verwendet.';
$string['emailuser'] = 'E-Mail an Nutzer/in';
$string['emailuser_help'] = 'Wenn dies aktiviert ist, wird eine Warnung an Teilnehmer/innen gesendet.';
$string['emptyacronym'] = 'Leere Akronyme sind nicht erlaubt. Der Statuseintrag wurde nicht aktualisiert.';
$string['emptydescription'] = 'Leere Beschreibungen sind nicht erlaubt. Der Statuseintrag wurde nicht aktualisiert.';
$string['enablecalendar'] = 'Kalenderereignis erstellen';
$string['enablecalendar_desc'] = 'Wenn dies aktiviert wird, wird ein Kalenderereignis für jeden Termin erzeugt. Nach Änderungen an dieser Einstellung, sollten Sie den Bericht zum Zurücksetzen des Kalenders laufen lassen.';
$string['enablewarnings'] = 'Warnungen aktivieren';
$string['enablewarnings_desc'] = 'Dies erlaubt es, eine Warnung für eine Anwesenheitsaktivität festzulegen, die als E-Mail-Benachrichtigung an Teilnehmer/innen geschickt wird, wenn diese unter die definierte Anwesenheitsschwelle fallen. <br/><strong>WARNUNG: Dies ist eine neue Funktionalität und wurde noch nicht ausführlich getestet. Die Nutzung erfolgt auf eigenes Risiko. Bitte geben Sie Rückmeldung in den Moodle Foren, wenn Sie der Ansicht sind, dass dies gut funktioniert.</strong>';
$string['encoding'] = 'Kodierung';
$string['encoding_help'] = 'Dies bezieht sich auf die Art der Strichcodekodierung, die auf dem Studierendenausweis verwendet wird. Typische Arten von Strichcodekodierungsschemata beinahlten Code-39, Code-128 und UPC-A.';
$string['endofperiod'] = 'Ende des Zeitraums';
$string['endtime'] = 'Ende des Termins';
$string['enrolmentend'] = 'Einschreibung endet: {$a}';
$string['enrolmentstart'] = 'Einschreibung beginnt: {$a}';
$string['enrolmentsuspended'] = 'Einschreibung unterbrochen';
$string['enterpassword'] = 'Kennwort eingeben';
$string['error:coursehasnoattendance'] = 'Der Kurs mit dem Kurznamen {$a} hat keine Aktivitäten des Typs Anwesenheit.';
$string['error:coursenotfound'] = 'Ein Kurs mit dem Kurznamen {$a} kann nicht gefunden werden.';
$string['error:qrcode'] = '"Teilnehmer/innen erlauben, die eigene Anwesenheit zu erfassen" muss aktiviert sein, um den QR-Code nutzen zu können! Überspringen.';
$string['error:sessioncourseinvalid'] = 'Ein Kurs des Termins ist ungültig! Überspringen.';
$string['error:sessiondateinvalid'] = 'Ein Datum des Termins ist ungültig! Überspringen.';
$string['error:sessionendinvalid'] = 'Eine Endzeit des Termins ist ungültig! Überspringen.';
$string['error:sessionstartinvalid'] = 'Eine Startzeit des Termins ist ungültig! Überspringen.';
$string['error:statusnotfound'] = 'Nutzer/in {$a->extuser} hat einen Statuswert,  der nicht gefunden werden konnte: {$a->status}';
$string['error:timenotreadable'] = 'Nutzer/in {$a->extuser} hat eine erfasste Zeit, die nicht korrekt interpretiert werden konnte: {$a->scantime}';
$string['error:userduplicate'] = 'Nutzer/in {$a} wurde während des Imports doppelt gefunden. Bitte fügen Sie nur ein Eintrag pro Nutzer hinzu.';
$string['error:usernotfound'] = 'Eine Person mit {$a->userfield}, was für {$a->extuser} eingestellt wurde, konnte nicht gefunden werden';
$string['errorgroupsnotselected'] = 'Wählen Sie eine oder mehrere Gruppen aus';
$string['errorinaddingsession'] = 'Fehler beim Hinzufügen des Termins';
$string['erroringeneratingsessions'] = 'Fehler beim Erstellen des Termins';
$string['eventdurationupdated'] = 'Die Dauer des Termins wurde aktualisiert';
$string['eventreportviewed'] = 'Bericht angesehen';
$string['eventscreated'] = 'Kalenderereignisse wurden erzeugt';
$string['eventsdeleted'] = 'Kalenderereignisse wurden gelöscht';
$string['eventsessionadded'] = 'Termin hinzugefügt';
$string['eventsessiondeleted'] = 'Termin gelöscht';
$string['eventsessionipshared'] = 'IP-Konflikt bei der Selbsterfassung der Anwesenheit';
$string['eventsessionsimported'] = 'Termine wurden importiert';
$string['eventsessionupdated'] = 'Termin aktualisiert';
$string['eventstatusadded'] = 'Status hinzugefügt';
$string['eventstatusupdated'] = 'Status aktualisiert';
$string['eventstudentattendancesessionsupdated'] = 'Anwesenheitsbericht aktualisiert';
$string['eventstudentattendancesessionsviewed'] = 'Terminebericht gesehen';
$string['eventtaken'] = 'Anwesenheit erfasst';
$string['eventtakenbystudent'] = 'Anwesenheit durch Teilnehmer/in erfasst';
$string['export'] = 'Export';
$string['extrarestrictions'] = 'Zusätzliche Einschränkungen';
$string['formattexttype'] = 'Formatieren';
$string['from'] = 'von:';
$string['gradebookexplanation'] = 'In der Bewertung eintragen';
$string['gradebookexplanation_help'] = 'Das Modul \'Anwesenheit\' zeigt Ihre Anwesenheitsbewertung auf Grund der Punkte, die Sie bisher gesammelt haben im Vergleich zur bisher möglichen Punktzahl (zukünftige Lektionen sind nicht berücksichtigt). Ihre Kursbewertung hingegen zeigt die Anwesenheitsbewertung im Vergleich zur Maximalpunktzahl am Ende des Kurses (mit allen zukünftigen Lektionen). Die beiden Bewertungen können also unterschiedlich sein, beruhen aber auf dem selben Prozentwert.

Haben Sie z.B. bisher 8 von 10 Punkten (80% Anwesenheit) bei Halbzeit eines Kurses, der 50 Punkte Wert ist, zeigt die Anwesenheitsbewertung 8/10 und die Kursbewertung 16/20. Die 16 Punkte werden Sie nur erhalten, wenn Ihre Anwesenheit bei 80% bleibt. Sie wird aber steigen oder fallen, je nachdem, wie häufig Sie bis zum Kursende noch anwesend sein werden.';
$string['graded'] = 'Bewertete Termine';
$string['gridcolumns'] = 'Tabellenspalten';
$string['group'] = 'Gruppe';
$string['groups'] = 'Gruppen';
$string['groupsession'] = 'Teilnehmergruppe';
$string['groupsessionsby'] = 'Termine gruppieren nach';
$string['hiddensessions'] = 'Versteckte Termine';
$string['hiddensessions_help'] = 'Termine werdenversteckt, wenn der Kursbeginn nach Beginn des Termins ist. Sie können damit ältere Termine verstecken, wenn Sie diese nicht löschen wollen. Beachten Sie, dass Sie in der Bewertung angeben, nur die sichtbaren Zeitfenster in die Bewertung einzubeziehen.';
$string['hiddensessionsdeleted'] = 'Alle versteckten Termine wurden gelöscht';
$string['hideextrauserdetails'] = 'Zusätzliche Nutzerdetails verbergen';
$string['hidensessiondetails'] = 'Verberge Termin-Details';
$string['identifyby'] = 'Teilnehmer/innen auswählen nach';
$string['import'] = 'Import';
$string['importfile'] = 'Importdatei';
$string['importfile_help'] = 'Die CSV-Datei muss eine Kopfzeile und Felder zur Identifizierung der Gruppen, der Uhrzeit und der zu erstellenden Daten der Termine enthalten.<br/>Auf der nächsten Seite nach der Dateiablage werden Ihnen Beispiele aller Felder angezeigt, denen Sie Ihre eigenen Felder zuordnen können.<br/>Beispiel:<br/>groups;sessiondate;from;to<br/>groupA:05-10-2022;13:00;14:00<br/>groupB;05-10-2022;14:00;15:00';
$string['importsessions'] = 'Termine importieren';
$string['importstatus'] = 'Statusfeld';
$string['importstatus_help'] = 'Dies ermöglicht es, einen Statuswert (zum Beispiel A,E,V,U) für den Import einzutragen.';
$string['includeabsentee'] = 'Termin bei der Erstellung des Abwesenheitsberichts einbeziehen';
$string['includeabsentee_help'] = 'Wenn dies ausgewählt ist, wird der Termin in den Abwesenheitsbericht einbezogen.';
$string['includeall'] = 'Alle Termine auswählen';
$string['includedescription'] = 'Beschreibung des Termins einbeziehen';
$string['includenottaken'] = 'Nicht belegte Termine einbeziehen';
$string['includeqrcode'] = 'QR-Code einbeziehen';
$string['includeremarks'] = 'Bemerkungen einschließen';
$string['incorrectpassword'] = 'Sie haben ein ungültiges Passwort eingegeben. Damit wurde Ihre Anwesenheit nicht erfasst. Bitte geben Sie das korrekte Passwort ein.';
$string['incorrectpasswordshort'] = 'Falsches Kennwort. Die Anwesenheit wurde nicht erfasst.';
$string['indetail'] = 'Detaillierter ...';
$string['indicator:cognitivedepth'] = 'Anwesenheit kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die ein/e Nutzer/in in einer Anwesenheitsinstanz erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Anwesenheit kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Der/Die Teilnehmer/in hat diesen Prozentsatz an kognitivem Engagement erreicht, das durch die Anwesenheit während dieses Analyseintervalls (Ebenen = Keine Ansicht, Ansicht) dargeboten wurde';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Anwesenheit sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die ein/e Nutzer/in in einer Anwesenheitsinstanz erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Anwesenheit sozial';
$string['indicator:socialbreadthdef_help'] = 'Der/Die Teilnehmer/in hat diesen Prozentsatz an sozialem Engagement erreicht, das durch die Anwesenheit während dieses Analyseintervalls (Ebenen = Keine Teilnahme, Teilnahme einzeln) dargeboten wurde';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['invalidaction'] = 'Sie müssen eine Aktion auswählen';
$string['invalidemails'] = 'Sie müssen gültige Nutzeraccounts als Empfänger eingeben. Folgende Nutzer/innen konnten nicht gefunden werden: {$a}';
$string['invalidimportfile'] = 'Dateiformat ist ungültig.';
$string['invalidsessionenddate'] = 'Dieses Datum kann nicht vor dem Startzeitpunkt liegen';
$string['invalidsessionendtime'] = 'Die Endzeit muss später als die Startzeit sein';
$string['invalidstatus'] = 'Sie haben einen ungültigen Status ausgewählt, bitte versuchen Sie es erneut';
$string['iptimemissing'] = 'Ungültige Minuten für Freigabe';
$string['jumpto'] = 'Direkt zu ...';
$string['keepsearching'] = 'Suche fortsetzen';
$string['lasttaken'] = 'Zuletzt aufgenommene Anwesenheiten';
$string['manualtriggerauto'] = 'Automatisches Markieren manuell auslösen';
$string['marksessionimportcsvhelp'] = 'Mit diesem Formular können Sie eine CSV-Datei hochladen, die eine Nutzerkennung und Status beinhaltet. Das Statusfeld kann dabei entweder die Status-Kurzbezeichnung (zum Beispiel A,E,V,U) beinhalten oder die Zeit der Teilnahme des/der Nutzers/in (zum Beispiel 01.01.1970 8:00). Diese zwei Varianten können in einer Datei aber nicht gemischt werden. Wenn ein Zeitstempel importiert wird, dann versucht das System diesem den höchstmöglich verfügbaren Statuswert zuzuweisen.';
$string['maxpossible'] = 'Mögliches Maximum';
$string['maxpossible_help'] = 'Zeigt die Punktzahl an, die jede/r Teilnehmer/in noch erreichen kann, wenn diese/r die Maximalpunkte für jeden Termin, der noch nicht stattgefunden hat, erhält.
    <ul>
    <li><strong>Punkte</strong>: Maximal mögliche Punkte, die über für Termine erreicht werden können.</li>
    <li><strong>Prozentsatz</strong>: Maximaler Prozentsatz, die für alle Termine erreicht werden kann.</li>
    </ul>';
$string['maxpossiblepercentage'] = 'Maximaler Prozentsatz';
$string['maxpossiblepoints'] = 'Maximale Punktzahl';
$string['maxwarn'] = 'Maximale Zahl an E-Mail-Warnungen';
$string['maxwarn_help'] = 'Maximale Anzahl an Warnungen, die versendet werden sollen (es wird nur eine Warnung pro Termin verschickt)';
$string['mergeuser'] = 'Teilnehmer/in zusammenführen';
$string['messagedselecteduserfailed'] = 'Fehler beim Senden einer Nachricht an einen oder mehrere Nutzer/innen. Schalten Sie bitte das Debugging ein, um mehr zu erfahren.';
$string['mobilesessionfrom'] = 'Termine anzeigen, die vor dem letzten liegen';
$string['mobilesessionfrom_help'] = 'Ermöglicht es, die Liste der in der App angezeigten Termine durch Markierungen einzuschränken - zeigt nur Termine an, die nach dieser Auswahl beginnen.';
$string['mobilesessionto'] = 'Zukünftige Termine anzeigen';
$string['mobilesessionto_help'] = 'Ermöglicht es, die Liste der Termine so zu einzuschränken, dass nur eine kleine Anzahl von zukünftigen Terminen angezeigt wird.';
$string['mobilesettings'] = 'Einstellungen für Moodle Mobile';
$string['mobilesettings_help'] = 'Diese Einstellungen steuern das Verhalten von Moodle Mobile';
$string['modulename'] = 'Anwesenheit';
$string['modulename_help'] = 'Das Modul \'Anwesenheit\' ermöglicht die Erfassung von An- und Abwesenheiten und verschafft Teilnehmer/innen einen Überblick über ihre bisherige Teilnahme.

Trainer/innen können eine Serie von Terminen anlegen und die Teilnahme der Teilnehmer/innen darin jeweils mit \'Anwesend\', \'Verspätet\', \'Entschuldigt\' und \'Unentschuldigt\' erfassen.

Berichte können für einzelne Teilnehmer/innen oder für Gruppen erzeugt werden.';
$string['modulenameplural'] = 'Anwesenheit';
$string['months'] = 'Monate';
$string['moreattendance'] = 'Anwesenheit für diese Seite wurde erfolgreich erfasst';
$string['moveleft'] = 'Nach links schieben';
$string['moveright'] = 'Nach rechts schieben';
$string['multisessionexpanded'] = 'Wiederkehrende Termine ausklappen';
$string['multisessionexpanded_desc'] = 'Wenn neue Termine hinzugefügt werden, wird der Abschnitt "Wiederkehrende Termine" standardmäßig ausgeklappt angezeigt.';
$string['mustselectusers'] = 'Sie müssen Teilnehmer/innen für den Export auswählen';
$string['name'] = 'Name';
$string['newdate'] = 'Neues Datum';
$string['newduration'] = 'Neue Dauer';
$string['newstatusset'] = 'Neue Statusgruppe';
$string['noabsentstatusset'] = 'Die verwendete Statusgruppe hat keinen Status, der genutzt werden kann, wenn keiner ausgewählt ist.';
$string['noattendanceusers'] = 'Es ist nicht möglich Daten zu exportieren weil keine Teilnehmer/innen im Kurs eingeschrieben sind.';
$string['noattforuser'] = 'Für diese/n Teilnehmer/in gibt es keine Anwesenheitsdaten.';
$string['noautomark'] = 'Deaktiviert';
$string['nocapabilitytotakethisattendance'] = 'Sie haben versucht, die Anwesenheit des Termins mit der ID {$a} zu verändern, haben aber keine Berechtigung dazu.';
$string['nodescription'] = 'Regulärer Termin für den Kurs';
$string['noeventstoreset'] = 'Es gibt keine Kalenderereignisse, die eine Aktualisierung benötigen.';
$string['nogroups'] = 'Sie können keine Gruppen-Termine hinzufügen, denn für diesen Kurs sind keine Gruppen vorhanden.';
$string['noguest'] = 'Gäste dürfen keine Anwesenheitsdaten einsehen.';
$string['noofdaysabsent'] = 'Zahl der Fehltage';
$string['noofdaysexcused'] = 'Zahl der entschuldigten Fehltage';
$string['noofdayslate'] = 'Zahl der Tage mit Verspätung';
$string['noofdayspresent'] = 'Zahl der Anwesenheitstage';
$string['nosessiondayselected'] = 'Es wurde kein Tag mit einem Termine ausgewählt';
$string['nosessionexists'] = 'Für diesen Kurs ist kein Termin erfasst.';
$string['nosessionsselected'] = 'Keine Termine ausgewählt';
$string['notfound'] = 'Für diesen Kurs gibt es keine Anwesenheitserfassung!';
$string['notifytask'] = 'Warnungen an Nutzer/innen verschicken';
$string['notmember'] = 'kein Mitglied';
$string['notset'] = 'nicht gesetzt';
$string['nounmarkedstatusset'] = 'Für diese Sitzung ist kein unmarkierter Status konfigurie<a href="{$a->url}">rt (ID: {$a->sessionid}). Um dies zu beheben, aktualisieren Sie den gesetzten Status</a>.';
$string['noupgradefromthisversion'] = 'Das Update des Moduls \'attforblock\' zum Modul \'Anwesenheit\' kann nicht ausgeführt werden. Bitte löschen Sie attforblock oder aktualisieren Sie es auf die neueste Version, bevor Sie das neue Modul \'Anwesenheit\' installieren.';
$string['numsessions'] = 'Anzahl der Termine';
$string['numsessionstaken'] = 'Anzahl der durchgeführten Sitzungen';
$string['olddate'] = 'Vormaliges Datum';
$string['onactivitycompletion'] = 'Nach Abschluss der Aktivität';
$string['onlyselectedusers'] = 'Ausgewählte Nutzer/innen exportieren';
$string['overallsessions'] = 'Über alle Termine';
$string['overallsessions_help'] = 'Zeigt die Statistik für alle Termine inklusive der noch nicht stattgefundenen (Vergangenheit und Zukunft):
    <ul>
    <li><strong>Termine</strong>: Gesamtzahl der Termine.</li>
    <li><strong>Punkte</strong>: Erhaltene Punkte basierend auf den besuchten Terminen.</li>
    <li><strong>Prozentsatz</strong>: Prozentsatz der erhaltenen Punkte über die maximal mögliche Punktzahl für alle Termine.</li>
    </ul>';
$string['oversessionstaken'] = 'Übernommene Termine';
$string['oversessionstaken_help'] = 'Zeigt die Statistik für die Termine, für die Anwesenheiten eingetragen wurden:
    <ul>
    <li><strong>Termine</strong>: Anzahl der bereits stattgefundenen TErmine.</li>
    <li><strong>Punkte</strong>: Erhaltene Punkte auf Basis der stattgefundenen Termine.</li>
    <li><strong>Prozentsatz</strong>: Prozentsatz der erhaltenen Punkte über die maximal mögliche Punktzahl der stattgefundenen Termine.</li>
    </ul>';
$string['pageof'] = 'Seite {$a->page} von {$a->numpages}';
$string['participant'] = 'Teilnehmer/in';
$string['password'] = 'Passwort';
$string['passwordgrp'] = 'Passwort für Teilnehmer/innen';
$string['passwordgrp_help'] = 'Wenn dies gesetzt ist, müssen Teilnehmer/innen erst dieses Passwort eingeben, bevor sie ihre Anwesenheit für diesen Termin erfassen können. Wenn Sie dieses Feld leer lassen, wird kein Passwort abgefragt.';
$string['passwordheader'] = 'Kennwort eingeben, um die Anwesenheit zu erfassen';
$string['passwordrequired'] = 'Sie müssen das Passwort für diesen Termin eingeben, bevor Sie Ihre Anwesenheit dafür erfassen können.';
$string['percentage'] = 'Prozentsatz';
$string['percentageallsessions'] = 'Prozentsatz über alle Termine';
$string['percentagesessionscompleted'] = 'Prozentsatz über übernommene Termine';
$string['pluginadministration'] = 'Adminsitration der Anwesenheit';
$string['pluginname'] = 'Anwesenheit';
$string['points'] = 'Punkte';
$string['pointsallsessions'] = 'Punkte über alle Termine';
$string['pointssessionscompleted'] = 'Punkte über übernommene Termine';
$string['preferences_desc'] = 'Änderungen an den Statusgruppen wirken sich auf bestehende Anwesenheitsterminen aus und können sich auf die Bewertung auswirken.';
$string['preventsharederror'] = 'Die Selbsterfassung wurde für einen Termin deaktiviert, weil es so aussieht, dass dieses Endgerät bereits zur Erfassung der Anwesenheit einer anderen Person genutzt wurde.';
$string['preventsharedip'] = 'Verhindern, dass Teilnehmer/innen eine IP-Adresse miteinander teilen können';
$string['preventsharedip_help'] = 'Verhindern, dass Teilnehmer/innen dasselbe Endgerät (über die IP-Adresse identifiziert) nutzen, um die Anwesenheit für andere zu erfassen.';
$string['preventsharediptime'] = 'Zeit, nach der die IP-Adresse wieder verwendet werden kann (Minuten)';
$string['preventsharediptime_help'] = 'Erlaubt es, eine IP-Adresse, die für die Erfassung einer Anwesenheit verwendet wurde, nach Ablauf dieser Zeit wieder zu verwenden.';
$string['preview'] = 'Dateivorschau';
$string['previewhtml'] = 'Vorschau HTML-Format';
$string['priorto'] = 'Das Datum des Termins liegt vor dem Kursbeginn ({$a}), weswegen neue frühere Termine verborgen (nicht erreichbar) sind. Sie können das Startdatum des Kurses jederzeit in den Kurseinstellungen ändern, um auf diesen Termin zugreifen zu können. <br> Bitte ändern Sie das Datum des Termins oder bestätigen Sie mit einem Klick auf den Button "Hinzufügen". <br>';
$string['privacy:metadata:attendancelog'] = 'Log der Nutzeranwesenheiten aufgezeichnet.';
$string['privacy:metadata:attendancesessions'] = 'Termine für die die Anwesenheit erfasst wird.';
$string['privacy:metadata:attendancewarningdone'] = 'Log für Warnungen, die an Nutzer/innen über deren Anwesenheitseintrag versendet wurden.';
$string['privacy:metadata:duration'] = 'Dauer des Termins in Sekunden';
$string['privacy:metadata:groupid'] = 'Gruppen-ID, die mit dem Termin verknüpft ist.';
$string['privacy:metadata:ipaddress'] = 'IP-Adresse mit der die Anwesenheit erfasst wurde.';
$string['privacy:metadata:lasttaken'] = 'Zeitstempel wann der Termin mit Anwesenheitserfassung zuletzt besucht wurde.';
$string['privacy:metadata:lasttakenby'] = 'Nutzer-ID des/der Nutzers/Nutzerin, der/die für diesen Termin zuletzt die Anwesenheit erfasst hat';
$string['privacy:metadata:notifyid'] = 'Termin-ID einer Anwesenheit, für die eine Warnung vorliegt.';
$string['privacy:metadata:remarks'] = 'Kommentare zu der Anwesenheit eines/einer Nutzers/Nutzerin.';
$string['privacy:metadata:sessdate'] = 'Zeitstempel wann der Termin beginnt.';
$string['privacy:metadata:sessionid'] = 'ID der Anwesenheitstermin.';
$string['privacy:metadata:statusid'] = 'ID des Anwesenheitsstatus eines Teilnehmenden.';
$string['privacy:metadata:statusset'] = 'Statuskatalog zu der eine Status-ID gehört.';
$string['privacy:metadata:studentid'] = 'ID des/der Teilnehmer/in, der/die die Anwesenheit erfasst hat.';
$string['privacy:metadata:takenby'] = 'Nutzer-ID des/der Nutzers/Nutzerin, der/die Anwesenheit für den/die Teilnehmer/in erfasst hat.';
$string['privacy:metadata:timemodified'] = 'Zeitstempel wann der Termine zuletzt geändert wurde';
$string['privacy:metadata:timesent'] = 'Zeitstempel der verschickten Warnung.';
$string['privacy:metadata:timetaken'] = 'Zeitstempel wann die Anwesenheit für den/die Teilnehmer/in erfasst wurde.';
$string['privacy:metadata:userid'] = 'Nutzer-ID an die die Warnung versendet wird.';
$string['processingfile'] = 'Datei wird verarbeitet';
$string['qr_cookie_error'] = 'QR Termin ist abgelaufen.';
$string['qr_pass_wrong'] = 'QR Passwort ist falsch oder abgelaufen.';
$string['qrcode'] = 'QR-Code';
$string['qrcodeandpasswordheader'] = 'QR-Code scannen oder das Kennwort verwenden, um Ihre Anwesenheit zu erfassen';
$string['qrcodeheader'] = 'QR-Code scannen, um die Anwesenheit zu erfassen';
$string['qrcodevalidafter'] = 'Sekunden';
$string['qrcodevalidbefore'] = 'QR-Code gültig für:';
$string['randompassword'] = 'Zufälliges Passwort';
$string['remark'] = 'Bemerkung für: {$a}';
$string['remarks'] = 'Bemerkungen';
$string['repeatasfollows'] = 'Den obigen Termin wie folgt wiederholen';
$string['repeatevery'] = 'Wiederholen alle';
$string['repeaton'] = 'Wiederholen am';
$string['repeatuntil'] = 'Wiederholen bis';
$string['report'] = 'Bericht';
$string['reportsessiondate'] = 'Datum des Termins';
$string['reportsessionduration'] = 'Dauer des Termins';
$string['reportsessionlasttaken'] = 'Letzter Termin (Trainer/in)';
$string['required'] = 'Erforderlich*';
$string['requiredentries'] = 'Temporäre Einträge überschreiben die Anwesenheitsaufzeichnungen von den Teilnehmer/innen';
$string['requiredentry'] = 'Hilfestellung zur Zusammenführung von temporären Teilnehmer/innen';
$string['requiredentry_help'] = '<p align="center"><b>Anwesenheit</b></p>
<p align="left"><strong>Nutzerkonten zusammenführen</strong></p>
<p align="left">
<table border="2" cellpadding="4">
<tr>
<th>Moodle Teilnehmer/in</th>
<th>Temporäre/r Nutzer/in</th>
<th>Aktion</th>
</tr>
<tr>
<td>Anwesenheiten</td>
<td>Anwesenheiten</td>
<td>Temporäre/r Nutzer/in wird den/die Moodle Teilnehmer/in überschreiben</td>
</tr>
<tr>
<td>Keine Anwesenheiten</td>
<td>Anwesenheiten</td>
<td>Die temporären Anwesenheiten werden auf den Moodle Teilnehmer übertragen</td>
</tr>
<tr>
<td>Anwesenheiten</td>
<td>Keine Anwesenheiten</td>
<td>Temporäre/r Nutzer/in wird gelöscht</td>
</tr>
<tr>
<td>Keine Anwesenheiten</td>
<td>Keine Anwesenheiten</td>
<td>Temporäre/r Nutzer/in wird gelöscht</td>
</tr>
</table>

</p>
<p align="left"><strong>Temporäre/r Nutzer/in wird auf jeden Fall nach der Zusammenführung gelöscht.</strong></p>';
$string['requiresubnet'] = 'IP-Adresse verlangen';
$string['requiresubnet_help'] = 'Die Eintragung der Anwesenheit kann für bestimmte Subnetze mittels einer kommasseparierten Liste von vollständigen oder Teil-IP-Adressen eingeschränkt werden.';
$string['resetcaledarcreate'] = 'Kalenderereignisse wurden aktiviert, aber einige bestehende Termine haben noch keine entsprechenden Ereignisse. Möchten Sie Kalenderereignisse für alle bestehenden Termine erstellen?';
$string['resetcaledardelete'] = 'Kalenderereignisse wurden deaktiviert, aber einige bestehende Termine haben entsprechende Ereignisse, die gelöscht werden sollten. Möchten Sie alle bestehenden Ereignisse löschen?';
$string['resetcalendar'] = 'Kalender zurücksetzen';
$string['resetdescription'] = 'Beachten Sie, dass beim Löschen von Anwesenheits-Daten auch die Datenbankinformation geändert wird. Sie können ältere Termine einfach verbergen, wenn Sie den Beginn des Kurses verschoben haben!';
$string['resetstatuses'] = 'Alle Status auf die Voreinstellungen zurücksetzen';
$string['restoredefaults'] = 'Voreinstellungen wieder herstellen';
$string['resultsperpage'] = 'Ergebnisse pro Seite';
$string['resultsperpage_desc'] = 'Anzahl der Teilnehmer/innen pro Seite';
$string['rotateqrcode'] = 'QR-Code erneuern';
$string['rotateqrcode_cleartemppass_task'] = 'Aufgabe zum Löschen temporärer Passwörter, die durch die Funktion zur Erneuerung der QR Codes erzeugt wurden.';
$string['rotateqrcodeexpirymargin'] = 'Zeitspanne für QR Code Erneuerung / Passwortablauf (in Sekunden)';
$string['rotateqrcodeexpirymargin_desc'] = 'Zeitspanne (in Sekunden), in dem bereits abgelaufene QR Codes / Passwörter noch akzeptiert werden.';
$string['rotateqrcodeinterval'] = 'Zeitspanne zur Erneuerung von QR-Code / Passwort (in Sekunden)';
$string['rotateqrcodeinterval_desc'] = 'Zeitspanne (in Sekunden), nach der der QR Code / Passwort erneuert wird.';
$string['save'] = 'Anwesenheit speichern';
$string['saveandshownext'] = 'Speichern und nächste Seite';
$string['scantime'] = 'Erfasste Zeit';
$string['scantime_help'] = 'Dies erlaubt es, einen Zeitstempel (erfasste Zeit der Anwesenheit, zum Beispiel 01.01.1970 8:00) für den Import einzutragen. Während des Imports wird dieser Eintrag programmatisch nutzbar konvertiert und danach verwendet, um zu entscheiden, welchem Status dieser Wert zugewiesen werden kann. Kontrollieren Sie bitte das Ergebnis danach. Eine richtige Statuszuweisung kann nicht garantiert werden!';
$string['search:activity'] = 'Anwesenheit - Information zur Aktivität';
$string['selectactivity'] = 'Aktivität auswählen';
$string['session'] = 'Termin';
$string['session_help'] = 'Termin';
$string['sessionadded'] = 'Termin erfolgreich hinzugefügt';
$string['sessionalreadyexists'] = 'Für dieses Datum gibt es bereits einen Termin';
$string['sessiondate'] = 'Datum';
$string['sessiondays'] = 'Tage mit Terminen';
$string['sessiondeleted'] = 'Termin erfolgreich gelöscht';
$string['sessiondescription'] = 'Terminbeschreibung';
$string['sessionduplicate'] = 'Es existiert bereits ein duplizierter Termin für den Kurs {$a->course} in der Anwesenheit: {$a->activity}, {$a->date}';
$string['sessionexist'] = 'Termin nicht hinzugefügt, da er bereits existiert.';
$string['sessiongenerated'] = 'Ein Termin wurde erfolgreich erzeugt';
$string['sessions'] = 'Termine';
$string['sessionsallcourses'] = 'Alle Kurse';
$string['sessionsbyactivity'] = 'Anwesenheits-Aktivität';
$string['sessionsbycourse'] = 'Kurs';
$string['sessionsbydate'] = 'Woche';
$string['sessionscompleted'] = 'Gewählte Termine';
$string['sessionscurrentcourses'] = 'Aktueller Kurs';
$string['sessionsgenerated'] = '{$a} Termine wurden erfolgreich erzeugt';
$string['sessionsids'] = 'IDs der Termine:';
$string['sessionsnotfound'] = 'Im gewählten Zeitraum gibt es keine Termine.';
$string['sessionstartdate'] = 'Anfangsdatum';
$string['sessionstotal'] = 'Gesamtzahl der Termine';
$string['sessionsupdated'] = 'Sitzungen wurden aktualisiert';
$string['sessiontype'] = 'Art';
$string['sessiontype_help'] = 'Sie können Termine für alle Teilnehmer/innen oder für Gruppen hinzufügen. Die verschiedenen Arten hängen von dem Gruppenmodus der Aktivität ab.

* Im Modus "Keine Gruppen" können Sie nur Termine für alle Teilnehmer/innen erstellen.
* Im Modus "Getrennte Gruppen" können Sie nur Termine für Gruppen erstellen.
* Im Modus "Sichtbare Gruppen" können Sie beide Termin-Arten anlegen.';
$string['sessiontypeshort'] = 'Typ';
$string['sessionunknowngroup'] = 'Ein Termin hat unbekannte Gruppen: {$a}';
$string['sessionupdated'] = 'Termin erfolgreich geändert';
$string['set_by_student'] = 'Selbst eingetragen';
$string['setallstatuses'] = 'Status setzen für';
$string['setallstatusesto'] = 'Status auf «{$a}» setzen';
$string['setperiod'] = 'Eingestellte Zeit in Minuten, um die IP wieder freizugeben';
$string['settings'] = 'Einstellungen';
$string['setunmarked'] = 'Dies automatisch setzen, wenn nicht ausgewählt';
$string['setunmarked_help'] = 'Wenn dies im Termin aktiviert ist, wird dieser Status gesetzt, wenn ein/e Teilnehmer/in seine/ihre Anwesenheit nicht erfasst hat.';
$string['showdefaults'] = 'Voreinstellungen anzeigen';
$string['showduration'] = 'Dauer anzeigen';
$string['showextrauserdetails'] = 'Zeige weitere Nutzerdetails';
$string['showqrcode'] = 'QR-Code zeigen';
$string['showsessiondescriptiononreport'] = 'Beschreibung des Termins im Bericht anzeigen';
$string['showsessiondescriptiononreport_desc'] = 'Zeigt die Beschreibung des Termins der Übersicht der Anwesenheitsberichte an.';
$string['showsessiondetails'] = 'Zeige Termindetails';
$string['somedisabledstatus'] = '(Einige Auswahlmöglichkeiten wurden entfernt nachdem der Termin bereits begonnen hat.)';
$string['sortedgrid'] = 'Sortiertes Raster';
$string['sortedlist'] = 'Sortierte Liste';
$string['startofperiod'] = 'Beginn des Zeitraums';
$string['starttime'] = 'Startzeit';
$string['status'] = 'Status';
$string['statusall'] = 'alle';
$string['statusdeleted'] = 'Status gelöscht';
$string['statuses'] = 'Stati';
$string['statusset'] = 'Status {$a} gesetzt';
$string['statussetsettings'] = 'Status Katalog';
$string['statustotalcount'] = 'Status {$a} - Gesamtzahl';
$string['statustotalcountcurrentweek'] = 'Status {$a} - Gesamtzahl für diese Woche';
$string['statustotalcountpreviousweek'] = 'Status {$a} - Gesamtzahl der die letzte Woche';
$string['statusunselected'] = 'nicht ausgewählt';
$string['strftimedm'] = '%d. %b.';
$string['strftimedmw'] = '<nobr>%a., %d. %b.</nobr>';
$string['strftimedmy'] = '%d. %b. %Y';
$string['strftimedmyhm'] = '%d. %b. %Y %H:%M';
$string['strftimedmyw'] = '<nobr>%a, %d.%m.%y</nobr>';
$string['strftimeh'] = '%H:%M';
$string['strftimehm'] = '%H:%M';
$string['strftimeshortdate'] = '%d.%m.%Y';
$string['studentid'] = 'Teilnehmer-ID';
$string['studentmarked'] = 'Ihre Anwesenheit wurde für diesen Termin erfasst.';
$string['studentmarking'] = 'Erfassung durch die Teilnehmer/innen';
$string['studentpassword'] = 'Kennwort für Teilnehmer/innen';
$string['studentrecordingexpanded'] = 'Erfassung durch Teilnehmer/innen ausgeklappt';
$string['studentrecordingexpanded_desc'] = 'Zeigt den Abschnitt "Erfassung durch Teilnehmer/innen" standardmäßig ausgeklappt, wenn ein neuer Termin hinzugefügt wird.';
$string['studentscanmark'] = 'Teilnehmer/innen erlauben, die Anwesenheit selbst zu erfassen';
$string['studentscanmark_desc'] = 'Wenn gesetzt, können Teilnehmer/innen ihre Anwesenheit selbst erfassen.';
$string['studentscanmark_help'] = 'Wenn gesetzt, dann sind Teilnehmer/innen in der Lage, ihren eigenen Anwesenheitsstatus für die Sitzung zu ändern.';
$string['studentscanmarksessiontime'] = 'Teilnehmer/innen erfassen ihre Anwesenheit';
$string['studentscanmarksessiontime_desc'] = 'Wenn dies aktiviert ist, können Teilnehmer/innen Ihre Anwesenheit nur erfassen, während der Termins stattfindet.';
$string['studentscanmarksessiontimeend'] = 'Ende des Termins (Minuten)';
$string['studentscanmarksessiontimeend_desc'] = 'Wenn der Termin über kein Endzeitpunkt verfügt, für wie viele Minuten soll es Teilnehmer/innen möglich sein, ihre Anwesenheit zu erfassen.';
$string['studentsearlyopentime'] = 'Registrierungsöffnung vor Veranstaltungsbeginn';
$string['studentsearlyopentime_help'] = 'Diese Option ermöglicht es Trainer/innen, die Sitzung früher zu eröffnen, so dass die Anwesenheit vor dem eigentlichen Sitzungsbeginn markiert werden kann.';
$string['submit'] = 'Absenden';
$string['submitattendance'] = 'Anwesenheit erfassen';
$string['submitattendancefuture'] = 'Zukünftige Abwesenheit melden';
$string['submitpassword'] = 'Kennwort absenden';
$string['subnet'] = 'Subnetz';
$string['subnetactivitylevel'] = 'Subnetz-Einstellungen auf Aktivitätenebene erlauben';
$string['subnetactivitylevel_desc'] = 'Wenn dies aktiviert ist, können Trainer/innen die standardmäßig gesetzten Subnetz Einstellungen auf der Aktivitätsebene überschreiben. Sonst wird der eingestellte Standardwert verwendet, wenn eine Lerneinheit hinzugefügt wird.';
$string['subnetwrong'] = 'Die Anwesenheit kann nur von bestimmten Orten aus eingetragen werden und dieser Computer befindet sich nicht auf der erlaubten Liste.';
$string['summary'] = 'Zusammenfassung';
$string['tablerenamefailed'] = 'Umbenennen der alten attforblock-Tabelle schlug fehl.';
$string['tactions'] = 'Aktion';
$string['takeattendance'] = 'Anwesenheit erfassen';
$string['takensessions'] = 'Abgehaltene Lerneinheiten';
$string['tcreated'] = 'Erstellt';
$string['tempaddform'] = 'Temporäre/n Teilnehmer/in hinzufügen';
$string['tempexists'] = 'Es existiert bereits ein/e temporäre Teilnehmer/in mit dieser E-Mail-Adresse';
$string['temptable'] = 'Liste temporärer Teilnehmer/innen';
$string['tempuser'] = 'Temporäre/r Teilnehmer/in';
$string['tempusermerge'] = 'Temporäre/n Teilnehmer/in zusammenführen';
$string['tempusers'] = 'Temporäre Teilnehmer/innen';
$string['tempusersedit'] = 'Temporäre/r Teilnehmer/in bearbeiten';
$string['tempuserslist'] = 'Temporäre Teilnehmer/innen';
$string['thirdpartyemails'] = 'Andere Teilnehmer/innen benachrichtigen';
$string['thirdpartyemails_help'] = 'Liste an weiteren Teilnehmer/innen, die benachrichtigt werden (benötigt das Recht mod/attendance:viewreports).';
$string['thirdpartyemailsubject'] = 'Anwesenheitswarnung';
$string['thirdpartyemailtext'] = 'Die Anwesenheit von {$a->firstname} {$a->lastname} im Kurs {$a->coursename} {$a->aname} ist weniger als {$a->warningpercent} ({$a->percent})';
$string['thirdpartyemailtextfooter'] = 'Sie erhalten diese Mitteilung, weil der/die Trainer/in dieses Kurses Sie auf die Empfängerliste gesetzt hat.';
$string['thiscourse'] = 'Dieser Kurs';
$string['time'] = 'Zeit';
$string['timeahead'] = 'Wiederkehrende Termine, die die Dauer eines Jahres überschreiten können nicht erzeigt werden. Bitte passen Sie das Start- und Endedatum an.';
$string['timemodified'] = 'Zeit geändert';
$string['timetaken'] = 'Zeiterfassung genommen';
$string['to'] = 'bis:';
$string['todate'] = 'bis jetzt';
$string['totalnumsessions'] = 'Gesamtzahl der Sitzungen';
$string['triggered'] = 'Zuerst benachrichtigt';
$string['tuseremail'] = 'E-Mail';
$string['tusername'] = 'Vollständiger Name';
$string['ungraded'] = 'Unbewertete Termine';
$string['unknowngroup'] = 'Unbekannte Gruppe';
$string['unknownstatus'] = 'Unbekannte Status-ID: {$a}';
$string['update'] = 'Ändern';
$string['updateattendance'] = 'Anwesenheit ändern';
$string['uploadattendance'] = 'Anwesenheiten mittels CSV hochladen';
$string['usedefaultsubnet'] = 'Standard verwenden';
$string['usemessageform'] = 'oder nutzen Sie das unten stehende Formular, um die Nachricht an die ausgewählten Nutzer/innen zu schicken.';
$string['userexistingstatus'] = 'Ihre Anwesenheit wurde bereits erfasst als: <strong>{$a}</strong>. Nutzen Sie bitte das folgende Formular, um dies bei Bedarf zu ändern.';
$string['userexists'] = 'Es existiert bereits ein/e echte/r Teilnehmer/in mit dieser E-Mail-Adresse';
$string['userid'] = 'Nutzer-ID';
$string['userimportfield'] = 'Externer-Nutzer-Feld';
$string['userimportfield_help'] = 'Feld der hochgeladenen CSV-Datei, das die Nutzerkennung enthält';
$string['userimportto'] = 'Moodle Nutzerfeld';
$string['userimportto_help'] = 'Moodle Feld, das die Daten vom CSV-Export zuordnet';
$string['users'] = 'Teilnehmer/innen zum exportieren';
$string['usersessiongrade'] = 'Nutzerbewertung zum Termin';
$string['usersessionremarks'] = 'Nutzerbemerkungen zum Termin';
$string['usersessiontaken'] = 'Nutzerwahl zum Termin';
$string['userstatus'] = 'Nutzerstatus zum Termin';
$string['usestatusset'] = 'Gesetzter Status';
$string['variable'] = 'Variable';
$string['variablesupdated'] = 'Variable geändert';
$string['versionforprinting'] = 'Druckversion';
$string['viewmode'] = 'Ansichtsmodus';
$string['warnafter'] = 'Anzahl an erfassten Termine vor Warnung';
$string['warnafter_help'] = 'Warnungen werden nur ausgelöst, wenn der/die Teilnehmer/in seine/ihre Anwesenheit für mindestens diese Zahl an Terminen erfasst hat.';
$string['warningdeleted'] = 'Warnung gelöscht';
$string['warningdesc'] = 'Diese Warnungen werden automatisch neuen Anwesenheitsaktivitäten hinzugefügt. Wenn mehr als eine Warnung exakt zur selben Zeit ausgelöst werden, wird nur die Warnung mit dem niedrigeren Schwellenwert verschickt.';
$string['warningdesc_course'] = 'Die Warnungsschwelle, die hier gesetzt ist, beeinflusst den Abwesenheitsbericht und erlaubt es, dass Teilnehmer/innen und Dritte informiert werden können. Wenn mehr als eine Warnung exakt zur selben Zeit ausgelöst werden, wird nur die Warnung mit dem niedrigeren Schwellenwert verschickt.';
$string['warningfailed'] = 'Sie können keine Warnung erzeugen, bei der der Prozentsatz gleich der Zahl der Termine ist.';
$string['warningpercent'] = 'Warnen, wenn der Prozentsatz darunter fällt';
$string['warningpercent_help'] = 'Eine Warnung wird ausgelöst, wenn der Gesamtprozentsatz unter diesen Wert sinkt.';
$string['warnings'] = 'Texte für Warnungen';
$string['warningthreshold'] = 'Schwelle für Warnung';
$string['warningupdated'] = 'Warnungen wurden aktualisiert';
$string['week'] = 'Woche(n)';
$string['weekcommencing'] = 'Woche vom';
$string['weeks'] = 'Wochen';
$string['youcantdo'] = 'Sie können keine Aktionen ausführen.';
