<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'de', version '4.4'.
 *
 * @package     quiz
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Sie können diesen Test in der Vorschau ansehen. Wäre dies ein realer Versuch, würde dies abgeblockt, weil:';
$string['action'] = 'Aktion';
$string['activityoverview'] = 'Sie haben fällige Tests.';
$string['adaptive'] = 'Mehrfachbeantwortung';
$string['adaptive_help'] = 'Mit dieser Funktion wird es möglich eine Frage mehrfach innerhalb eines Testversuchs zu beantworten. Ist eine Frage falsch bewertet, können Teilnehmer/innen diese direkt nochmals beantworten. Ist die Option \'Punktabzüge\' aktiviert werden diese berücksichtigt.';
$string['add'] = 'Hinzufügen';
$string['addaquestion'] = 'Neue Frage';
$string['addarandomquestion'] = 'Zufallsfrage';
$string['addarandomquestion_help'] = 'Eine Zufallsfrage wird zufällig aus allen Fragen der gewählten Kategorie ausgewählt. Das führt dazu, dass verschiedene Teilnehmer/innen eine unterschiedliche Auswahl von Fragen im Test zur Beantwortung erhalten. Falls mehrere Versuche beim Test erlaubt sind, werden bei jedem Versuch die Fragen erneut zufällig gewählt.';
$string['addarandomquestion_success'] = 'Zufallsfragen wurden hinzugefügt';
$string['addarandomselectedquestion'] = 'Zufallsfrage hinzufügen ...';
$string['addasection'] = 'eine neue Abschnittsüberschrift';
$string['adddescriptionlabel'] = 'Textfeld hinzufügen';
$string['addingquestion'] = 'Frage hinzufügen';
$string['addingquestions'] = '<p>Diese Spalte der Seite dient der Verwaltung der Testfragen. Fragen werden zwecks besseren Überblicks in Kategorien gespeichert und können von jedem Test Ihres Kurses oder sogar von anderen Kursen (wenn die Option "Veröffentlichen" ausgewählt ist) benutzt werden. </p><p>Nachdem Sie eine Kategorie eingerichtet haben, können Sie Fragen erzeugen oder bearbeiten. Sie können jede einzelne dieser Fragen auswählen und Ihrem Test in der anderen Spalte hinzufügen.</p>';
$string['addmoreoverallfeedbacks'] = '{no} weitere Feedbackfelder hinzufügen';
$string['addnewgroupoverride'] = 'Gruppenänderung hinzufügen';
$string['addnewpagesafterselected'] = 'Neue Seite nach markierter Frage hinzufügen';
$string['addnewquestionsqbank'] = 'Fragen zur Kategorie {$a->catname} hinzufügen: {$a->link}';
$string['addnewuseroverride'] = 'Nutzeränderung hinzufügen';
$string['addpagebreak'] = 'Seitenwechsel hinzufügen';
$string['addpagehere'] = 'Seite hier hinzufügen';
$string['addquestion'] = 'Frage hinzufügen';
$string['addquestionfrombankatend'] = 'Frage aus der Fragensammlung hinzufügen';
$string['addquestionfrombanktopage'] = 'Aus der Fragensammlung zu Seite {$a} hinzufügen';
$string['addquestions'] = 'Fragen hinzufügen';
$string['addquestionstoquiz'] = 'Fragen zu aktuellem Test hinzufügen';
$string['addrandom'] = '{$a} Zufallsfragen hinzufügen';
$string['addrandom1'] = 'Zum Test hinzufügen';
$string['addrandom2'] = 'Zufallsfragen';
$string['addrandomfromcategory'] = 'Zufallsfragen hinzufügen aus der Kategorie:';
$string['addrandomquestion'] = 'Zufallsfrage hinzufügen';
$string['addrandomquestionatend'] = 'Zufallsfrage am Ende hinzufügen';
$string['addrandomquestiontopage'] = 'Zufallsfrage zu Seite {$a} hinzufügen';
$string['addrandomquestiontoquiz'] = 'Zufallsfrage zum Test {$a} hinzufügen';
$string['addselectedquestionstoquiz'] = 'Ausgewählte Fragen zum Test hinzufügen';
$string['addselectedtoquiz'] = 'Auswahl zum Test hinzufügen';
$string['addtoquiz'] = 'Hinzufügen';
$string['affectedstudents'] = 'Bestimmt für {$a}';
$string['aftereachquestion'] = 'Nach jedem Hinzufügen einer Frage';
$string['afternquestions'] = 'Nach dem Hinzufügen von {$a} Fragen';
$string['age'] = 'Alter';
$string['allattempts'] = 'Alle Versuche';
$string['allinone'] = 'Unbegrenzt';
$string['allowreview'] = 'Überprüfung erlauben';
$string['alreadysubmitted'] = 'Es sieht so aus, als hätten Sie diesen Versuch schon eingetragen.';
$string['alternativeunits'] = 'Alternative Einheiten';
$string['alwaysavailable'] = 'Immer verfügbar';
$string['alwayslatest'] = 'Immer die neueste';
$string['analysisoptions'] = 'Analyseoptionen';
$string['analysistitle'] = 'Statistische Analyse der Ergebnisse';
$string['answer'] = 'Antwort';
$string['answered'] = 'Beantwortet';
$string['answerhowmany'] = 'Eine oder mehrere Antworten';
$string['answers'] = 'Antworten';
$string['answersingleno'] = 'Mehrere Antworten erlauben';
$string['answersingleyes'] = 'Nur eine Antwort erlauben';
$string['answertoolong'] = 'Die Antwort ist nach Zeile {$a} zu lang (max. 255 Zeichen).';
$string['anytags'] = 'Jeder Tag';
$string['aon'] = 'AON';
$string['areyousureremoveselected'] = 'Möchten Sie wirklich alle ausgewählten Fragen entfernen?';
$string['asshownoneditscreen'] = 'Wie in Bearbeitungsansicht gezeigt';
$string['attempt'] = 'Versuch {$a}';
$string['attemptalreadyclosed'] = 'Dieser Versuch wurde bereits beendet.';
$string['attemptclosed'] = 'Der Versuch wurde bisher noch nicht geschlossen.';
$string['attemptduration'] = 'Dauer';
$string['attemptedon'] = 'Versucht am';
$string['attempterror'] = 'Sie dürfen diesen Test aktuell nicht versuchen: {$a}';
$string['attempterrorcontentchange'] = 'Die Testvorschau steht nicht mehr zur Verfügung. (Wenn ein Test editiert wird, werden alle laufenden Vorschaufenster gelöscht.)';
$string['attempterrorcontentchangeforuser'] = 'Dieser Testversuch existiert nicht mehr.';
$string['attempterrorinvalid'] = 'Ungültige ID eines Testversuchs';
$string['attemptfirst'] = 'Erster Versuch';
$string['attemptgradeddelay'] = 'Verzögerung für Mitteilungen, dass Testversuche bewertet wurden';
$string['attemptgradeddelay_desc'] = 'Vor dem Senden von Mitteilungen, dass Testversuche bewertet wurden, wird eine Verzögerung angewendet, damit Trainer/innen Zeit habe, die Bewertung möglicherweise zu ändern.';
$string['attemptincomplete'] = 'Dieser Versuch von {$a} ist noch nicht vollständig abgeschlossen.';
$string['attemptlast'] = 'Letzter Versuch';
$string['attemptnumber'] = 'Versuch';
$string['attemptquiz'] = 'Test versuchen';
$string['attemptquiznow'] = 'Test jetzt durchführen';
$string['attemptreviewtitle'] = '{$a}: Überprüfung des Testversuchs';
$string['attemptreviewtitlepaged'] = '{$a->name}: Überprüfung des Testversuchs (Seite {$a->currentpage} von {$a->totalpages})';
$string['attempts'] = 'Versuche';
$string['attempts_help'] = 'Die Gesamtzahl der erlaubten Versuche (ohne Zusatzversuche)';
$string['attemptsallowed'] = 'Erlaubte Versuche';
$string['attemptsdeleted'] = 'Die Testversuche wurden gelöscht.';
$string['attemptselection'] = 'Welche Versuche pro Nutzer/in analysieren:';
$string['attemptsexist'] = 'Sie können jetzt keine Fragen mehr hinzufügen oder entfernen.';
$string['attemptsnum'] = 'Versuche: {$a}';
$string['attemptsnumthisgroup'] = 'Versuche: {$a->total} ({$a->group} von dieser Gruppe)';
$string['attemptsnumyourgroups'] = 'Versuche: {$a->total} ({$a->group} von Ihrer Gruppe)';
$string['attemptsonly'] = 'Nur Teilnehmer/innen anzeigen, die bereits Versuche durchgeführt haben.';
$string['attemptstate'] = 'Status';
$string['attemptstillinprogress'] = 'Versuch dauert noch an';
$string['attemptsummarytitle'] = '{$a}: Zusammenfassung des Testversuchs';
$string['attemptsunlimited'] = 'unbegrenzt';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (Seite {$a->currentpage} von {$a->totalpages})';
$string['autosaveperiod'] = 'Verzögerung zur automatischen Speicherung';
$string['autosaveperiod_desc'] = 'Antworten können während der Testversuche automatisch gespeichert werden. Die Antworten werden gespeichert, sobald es eine Änderung gibt und die Zeit abgelaufen ist. Eine kürzere Verzögerung erhöht die Serverlast, verringert jedoch die Wahrscheinlichkeit, dass Antworten verloren gehen. Wenn Sie die Verzögerung viel kürzer einstellen möchten, sollten Sie den Wert schrittweise verkürzen und die Serverlast überwachen. Wenn die Last zu hoch wird, verlängern Sie die Verzögerung wieder. Wenn Sie die Verzögerung auf 0 setzen, wird das automatische Speichern deaktiviert.';
$string['back'] = 'Zurück zur vorherigen Antwort';
$string['backtocourse'] = 'Zurück zum Kurs';
$string['backtoquestionlist'] = 'Zurück zur Fragenliste';
$string['backtoquiz'] = 'Zurück zur Testbearbeitung';
$string['bestgrade'] = 'Beste Bewertung';
$string['bothattempts'] = 'Teilnehmer/innen mit und ohne durchgeführte Versuche anzeigen';
$string['browsersecurity'] = 'Browsersicherheit';
$string['browsersecurity_help'] = 'Wenn \'Vollbildmodus mit JavaScript-Sicherheit\'  ausgewählt wird

* startet der Test nur, wenn JavaScript im Browser aktiviert ist
* wird der Test im Vollbildmodus ohne weitere Navigationsmöglichkeiten ausgeführt
* sind - soweit dies möglich ist - Funktionen wie Kopieren und Einfügen inaktiv.';
$string['cachedef_overrides'] = 'Informationen zu Nutzer- und Gruppenänderungen';
$string['calculated'] = 'Berechnung';
$string['calculatedquestion'] = 'Die Berechnungsfrage in Zeile {$a} wird nicht unterstützt. Die Frage wird ignoriert.';
$string['cannotcreatepath'] = 'Pfad kann nicht angelegt werden ({$a}).';
$string['cannoteditafterattempts'] = 'Sie können keine Frage(n) hinzufügen oder entfernen, da bereits Testversuche registriert sind. ({$a})';
$string['cannotfindprevattempt'] = 'Es wurden keine früheren Versuche gefunden, auf denen aufgebaut werden kann.';
$string['cannotfindquestionregard'] = 'Fehler beim Holen von Fragen zur Bewertung';
$string['cannotinsert'] = 'Frage kann nicht eingefügt werden.';
$string['cannotinsertrandomquestion'] = 'Es kann keine neue Zufallsfrage eingefügt werden.';
$string['cannotloadquestion'] = 'Frageoptionen konnten nicht geladen werden';
$string['cannotloadtypeinfo'] = 'Laden von fragespezifischen Informationen zum Fragetyp war nicht möglich';
$string['cannotopen'] = 'Exportdatei kann nicht geöffnet werden ({$a}).';
$string['cannotremoveallsectionslots'] = 'Sie haben alle Fragen unter der Abschnittsüberschrift "{$a}" ausgewählt. Es ist nicht erlaubt, alle Fragen unter einer Abschnittsüberschrift zu entfernen.';
$string['cannotremoveslots'] = 'Fragen können nicht entfernt werden';
$string['cannotrestore'] = 'Frageabschnitte konnten nicht wiederhergestellt werden';
$string['cannotreviewopen'] = 'Sie können diesen Versuch nicht überprüfen, weil er noch geöffnet ist.';
$string['cannotsavelayout'] = 'Das Layout konnte nicht gespeichert werden.';
$string['cannotsavenumberofquestion'] = 'Die Anzahl der Fragen pro Seite konnte nicht gespeichert werden.';
$string['cannotsavequestion'] = 'Die Fragenliste kann nicht gespeichert werden.';
$string['cannotsetgrade'] = 'Die neue Maximalbewertung des Tests konnte nicht gesetzt werden.';
$string['cannotsetsumgrades'] = 'Einstellungen für Zwischenbewertungen konnten nicht gesetzt werden.';
$string['cannotstartgradesmismatch'] = 'Für diesen Test kann kein Versuch gestartet werden. Der Test soll mit \'{$a->grade}\' bewertet werden, aber bisher fehlen die Bewertungen zu den Fragen. Wählen Sie den Punkt \'Test bearbeiten\'.';
$string['cannotstartmissingquestion'] = 'Für diesen Test kann kein Versuch beginnen. Die Testdefinition enthält eine nicht existierende Frage.';
$string['cannotstartnoquestions'] = 'Für diesen Test kann kein Versuch gestartet werden. Der Test ist noch nicht fertig angelegt, denn bisher fehlen die Fragen.';
$string['cannotwrite'] = 'Exportdatei kann nicht erstellt werden ({$a})';
$string['canredoquestions'] = 'Neubearbeitung in einem Versuch erlauben';
$string['canredoquestions_desc'] = 'Die Option legt fest, dass nach dem Beenden einer bestimmten Frage eine Taste \'Versuchen Sie eine weitere Frage wie diese hier\' angezeigt wird. Dies ermöglicht es, eine andere Antwort für die gleiche Frage zu versuchen, ohne den ganzen Testversuch abzusenden und einen neuen Versuch zu starten. Diese Option ist vor allem nützlich zum Üben.

Die Option wirkt sich nur auf Fragen (keine Freitextfragen) und Verhaltensweisen (z.B. Direkte Auswertung oder Interaktiv mit mehreren Versuchen) aus, bei denen die Frage beendet werden kann, ohne den Versuch abzugeben.';
$string['canredoquestions_help'] = 'Die Option legt fest, dass nach dem Beenden einer bestimmten Frage eine Taste \'Versuchen Sie eine weitere Frage wie diese hier\' angezeigt wird. So kann eine andere Antwort für die gleiche Frage versucht werden, ohne den ganzen Testversuch schließen und einen ganz neuen Testversuch zu starten. Diese Option ist vor allem nützlich zum Üben.

Die Option wirkt sich nur auf Fragen (keine Freitextfragen) und Verhaltensweisen (z.B. Direkte Auswertung oder Interaktiv mit mehreren Versuchen) aus, bei denen die Frage beendet werden kann, ohne den Versuch abzugeben.';
$string['canredoquestionsyes'] = 'Ja, erlauben Sie die Möglichkeit, um eine weitere Frage zu beantworten.';
$string['caseno'] = 'Nein, Groß-/Kleinschreibung ist unwichtig';
$string['casesensitive'] = 'Groß-/Kleinschreibung';
$string['caseyes'] = 'Ja, Groß-/Kleinschreibung muss stimmen';
$string['categoryadded'] = 'Kategorie \'{$a}\' angelegt';
$string['categorydeleted'] = 'Kategorie \'{$a}\' gelöscht';
$string['categorynoedit'] = 'Sie haben keinen Bearbeitungszugriff auf Kategorie \'{$a}\'.';
$string['categoryupdated'] = 'Die Kategorie wurde erfolgreich aktualisiert.';
$string['close'] = 'Fenster schließen';
$string['closebeforeopen'] = 'Der Endzeitpunkt muss nach dem Startzeitpunkt liegen.';
$string['closed'] = 'Beendet';
$string['closepreview'] = 'Vorschau schließen';
$string['closereview'] = 'Überprüfung schließen';
$string['comment'] = 'Kommentar';
$string['commentorgrade'] = 'Kommentieren oder Bewertung überarbeiten';
$string['comments'] = 'Kommentare';
$string['completedon'] = 'Abgeschlossen';
$string['completionattemptsexhausted'] = 'Bestehensgrenze oder alle möglichen Versuche erreicht';
$string['completionattemptsexhausted_help'] = 'Der Test wird als abgeschlossen markiert, wenn Teilnehmer/innen die maximale Anzahl von Versuchen erreichen.';
$string['completiondetail:minattempts'] = 'Versuche starten: {$a}';
$string['completiondetail:passorexhaust'] = 'Bestehensgrenze erreichen oder alle verfügbaren Versuche ausschöpfen';
$string['completionminattempts'] = 'Minimale Anzahl von Versuchen:';
$string['completionminattemptsdesc'] = 'Minimale Anzahl von erforderlichen Versuchen: {$a}';
$string['completionminattemptserror'] = 'Die minimale Anzahl von Versuchen muss kleiner oder gleich den erlaubten Versuchen sein.';
$string['completionminattemptsgroup'] = 'Versuche notwendig';
$string['completionpassorattemptsexhausteddesc'] = 'Teilnehmer/innen müssen die Bestehensgrenze erreichen oder alle verfügbaren Versuche ausschöpfen, um diese Aktivität abzuschließen';
$string['configadaptive'] = 'Wenn die Option \'Ja\' gewählt ist, besteht für die Teilnehmer/innen die Möglichkeit, während eines Testversuches mehrere Antworten auf eine Frage zu geben.';
$string['configattemptsallowed'] = 'Beschränkung der Anzahl an Antwortversuchen  während des Tests.';
$string['configdecimaldigits'] = 'Anzahl der Nachkommastellen, die in Bewertungen angezeigt werden';
$string['configdecimalplaces'] = 'Anzahl der Nachkommastellen, die in Bewertungen für den Test angezeigt werden';
$string['configdecimalplacesquestion'] = 'Anzahl der Nachkommastellen, die in Bewertungen für einzelne Fragen angezeigt werden';
$string['configdelay1'] = 'Wählen Sie eine Zeitverzögerung, wenn Sie möchten, dass Teilnehmer/innen vor einem weiteren Versuch ein Pause einhalten sollen.';
$string['configdelay1st2nd'] = 'Wenn Sie eine Zeitverzögerung aktivieren, können Teilnehmer/innen einen zweiten Testversuch erst nach der eingegeben Zeit durchführen.';
$string['configdelay2'] = 'Wählen Sie eine Zeitverzögerung, wenn Sie möchten, dass Teilnehmer/innen vor einem dritten oder weiteren Versuch ein Pause einhalten sollen.';
$string['configdelaylater'] = 'Wenn Sie eine Zeitverzögerung aktivieren, können Teilnehmer/innen einen weiteren Testversuch erst nach der eingegeben Zeit durchführen.';
$string['configeachattemptbuildsonthelast'] = 'Wenn mehrere Versuche erlaubt sind, dann enthält jeder Versuch die Ergebnisse des vorhergegangenen Versuchs.';
$string['configgrademethod'] = 'Welche Methode zur Bewertungsberechnung soll im Test verwendet werden, wenn mehrere Versuche erlaubt sind?';
$string['configintro'] = 'Die hier definierten Werte sind die Standardwerte, die auf der Einstellungsseite angezeigt werden, wenn einen neuer Test angelegt wird. Sie können auch festlegen, welche Testeinstellungen als erweitert betrachtet werden.';
$string['configmaximumgrade'] = 'Der Standardwert für diese Testbewertung liegt außerhalb des gewählten Wertes.';
$string['confignavmethod'] = 'In der selbstgewählten Navigation können die Aufgaben beliebig angesteuert und Fragen in beliebiger Reihenfolge beantwortet werden. In der vorgegebenen Navigation müssen Fragen in der definierten Reihenfolge beantwortet werden.';
$string['confignewpageevery'] = 'Wenn Sie Fragen zur Testseite hinzufügen, werden in Abhängigkeit der hier gewählten Einstellung an der entsprechenden Stelle automatisch Seitenumbrüche eingefügt.';
$string['configoutcomesadvanced'] = 'Wenn diese Option aktiviert ist, werden die Lernziele als erweiterte Einstellungen in der Testerstellung angezeigt.';
$string['configpenaltyscheme'] = 'Im Modus Mehrfachbeantwortung werden bei jeder falschen Antwort Punktabzüge angewandt.';
$string['configpopup'] = 'Mit Hilfe von JavaScript wird versucht, \'Copy&Paste\' während des Testdurchgangs zu verhindern.';
$string['configrequirepassword'] = 'Teilnehmer/innen müssen ein Kennwort eingeben, bevor sie den Test durchführen können.';
$string['configrequiresubnet'] = 'Teilnehmer/innen können den Test nur von diesen Computern aus durchführen.';
$string['configreviewoptions'] = 'Diese Einstellungen geben an, welche Informationen angezeigt werden, wenn Nutzer/innen einen Testversuch oder den Testbericht überprüfen.';
$string['configshowblocks'] = 'Blöcke bei den Testversuchen zeigen';
$string['configshowuserpicture'] = 'Nutzerbild anzeigen, während ein Versuch läuft';
$string['configshufflewithin'] = 'Wenn diese Option aktiviert ist, werden die Teile, die die individuellen Fragen darstellen, jedes Mal zufällig gewählt, wenn ein/e Teilnehmer/in einen Versuch dieses Tests startet, vorausgesetzt, dass die Auswahl auch in den Frage-Einstellungen ermöglicht wird.';
$string['configtimelimit'] = 'Standard Zeitlimit für Tests in Minuten. 0 bedeutet \'kein Zeitlimit\'.';
$string['configtimelimitsec'] = 'Standard Zeitlimit für Tests in Sekunden. 0 bedeutet \'kein Zeitlimit\'.';
$string['configurerandomquestion'] = 'Konfiguration der Fragen';
$string['confirmclose'] = 'Sobald Sie Ihre Antworten gesendet haben, können Sie keine Änderungen mehr vornehmen.';
$string['confirmremovequestion'] = 'Möchten Sie diese Frage \'{$a}\' wirklich entfernen?';
$string['confirmremovesectionheading'] = 'Möchten Sie wirklich die Abschnittsüberschrift \'{$a}\' löschen?';
$string['confirmserverdelete'] = 'Möchten Sie wirklich den Server <b>{$a}</b> aus der Liste löschen?';
$string['connectionerror'] = 'Netzwerkverbindung verloren. Das automatische Speichern ist fehlgeschlagen.

Notieren Sie sich alle in den letzten Minuten eingegebenen Antworten und versuchen Sie, die Verbindung wieder herzustellen.

Sobald die Verbindung wiederhergestellt wurde, sollten Sie die Antworten erneut speichern. Diese Nachricht verschwindet dann.';
$string['connectionok'] = 'Die Netzwerkverbindung wurde wieder hergestellt. Arbeiten Sie nun vorsichtig weiter.';
$string['containercategorycreated'] = 'Die Kategorie wurde aus den unten genannten Gründen angelegt, um alle Fragen aus anderen Kategorien aufzunehmen.';
$string['continueattemptquiz'] = 'Versuch fortsetzen';
$string['continuepreview'] = 'Letzte Vorschau fortsetzen';
$string['copyingfrom'] = 'Erstellen einer Kopie der Frage \'{$a}\'';
$string['copyingquestion'] = 'Frage kopieren';
$string['correct'] = 'Richtig';
$string['correctanswer'] = 'Richtige Antwort';
$string['correctanswerformula'] = 'Formel für richtige Antwort';
$string['correctansweris'] = 'Richtige Antwort: {$a}';
$string['correctanswerlength'] = 'Signifikante Zahlen';
$string['correctanswers'] = 'Richtige Antworten';
$string['correctanswershows'] = 'Die richtige Antwort zeigt';
$string['corrresp'] = 'Richtige Antwort';
$string['countdown'] = 'Countdown';
$string['countdownfinished'] = 'Der Test wird gleich beendet und Sie sollten jetzt Ihre Antworten abschicken.';
$string['countdowntenminutes'] = 'Der Test endet in 10 Minuten.';
$string['coursetestmanager'] = 'Kurs-Testmanager/in-Format';
$string['createcategoryandaddrandomquestion'] = 'Kategorie anlegen und Zufallsfrage hinzufügen';
$string['createfirst'] = 'Sie müssen zuerst einige Kurztextfragen anlegen.';
$string['createmultiple'] = 'Mehrere Zufallsfrage zum Test hinzufügen';
$string['createnewquestion'] = 'Eine neue Frage anlegen';
$string['createquestionandadd'] = 'Eine neue Frage erstellen und zum Test hinzufügen.';
$string['custom'] = 'Eigenes Format';
$string['dataitemneed'] = 'Sie müssen einen Datensatz hinzufügen, um eine gültige Frage zu erzeugen.';
$string['datasetdefinitions'] = 'Wiederverwendbare Datensatzdefinitionen für Kategorie {$a}';
$string['datasetnumber'] = 'Anzahl';
$string['daysavailable'] = 'Tage verfügbar';
$string['decimaldigits'] = 'Nachkommastellen in Bewertungen';
$string['decimalplaces'] = 'Nachkommastellen in Bewertungen';
$string['decimalplaces_help'] = 'Mit dieser Einstellung wird die Anzahl der angezeigten Nachkommastellen für Bewertungen festgelegt. Die Einstellung beeinflusst ausschließlich die Darstellung der Werte, nicht aber die Werte in der Datenbank oder die internen Berechnungen.';
$string['decimalplacesquestion'] = 'Nachkommastellen für die Fragenbewertung';
$string['decimalplacesquestion_help'] = 'Anzahl der Nachkommastellen, die in Bewertungen für einzelne Fragen angezeigt werden';
$string['decimalpoints'] = 'Nachkommastellen';
$string['default'] = 'Standard';
$string['defaultgrade'] = 'Standardbewertung (Punkte)';
$string['defaultinfo'] = 'Standardkategorie für Fragen';
$string['delay1'] = 'Pause zwischen 1. und 2. Versuch';
$string['delay1st2nd'] = 'Vorgegebene Pause zwischen 1. und 2. Versuch';
$string['delay1st2nd_help'] = 'Wenn diese Option aktiviert ist, können Studierende einen zweiten Testversuch erst nach Ablauf der festgelegten Zeit durchführen.';
$string['delay2'] = 'Pause bei späteren Versuchen';
$string['delaylater'] = 'Vorgegebene Pause zwischen weiteren Versuchen';
$string['delaylater_help'] = 'Wenn diese Option aktiviert ist, können Studierende einen dritten und weitere Testversuche erst nach Ablauf der festgelegten Zeit durchführen.';
$string['deleteattemptcheck'] = 'Möchten Sie wirklich diese Versuche löschen?';
$string['deleteselected'] = 'Auswahl löschen';
$string['deletingquestionattempts'] = 'Löschen der Testversuche';
$string['description'] = 'Beschreibung';
$string['disabled'] = 'Deaktiviert';
$string['displayoptions'] = 'Anzeigeoptionen';
$string['donotuseautosave'] = 'Nicht automatisch speichern';
$string['download'] = 'Klick zum Download der exportierten Kategorien';
$string['downloadextra'] = '(Datei ist auch im Kursverzeichnis backupdata/quiz abgelegt.)';
$string['dragtoafter'] = 'Nach {$a}';
$string['dragtostart'] = 'Am Anfang';
$string['duplicateresponse'] = 'Ihre Antwort wurde ignoriert, weil Sie bereits vorher eine gleichwertige Antwort gegeben haben.';
$string['eachattemptbuildsonthelast'] = 'Jeder Versuch basiert auf dem vorigen';
$string['eachattemptbuildsonthelast_help'] = 'Wenn mehrere Versuche erlaubt sind und diese Option aktiviert ist, enthält jeder neue Testversuch das Ergebnis des vorherigen. Dies erlaubt die Fertigstellung eines Tests mit Hilfe mehrerer Versuche.';
$string['edit_slotdisplaynumber_hint'] = 'Fragenummer bearbeiten (maximal 16 Zeichen)';
$string['edit_slotdisplaynumber_label'] = 'Neuer Wert für {$a}';
$string['editcategories'] = 'Kategorien bearbeiten';
$string['editcategory'] = 'Kategorie bearbeiten';
$string['editcatquestions'] = 'Fragen bearbeiten';
$string['editingquestion'] = 'Frage wird bearbeitet';
$string['editingquiz'] = 'Test wird bearbeitet';
$string['editingquiz_help'] = 'Für die Zusammenstellung von Tests gibt es mehrere Möglichkeiten:

* Test - Ein Test enthält Fragen, die auf einer oder über mehrere Seiten verteilt angezeigt werden
* Fragensammlung - Ein Test wird aus der Fragensammlung zusammengestellt, in der alle Fragen kategorisiert als Kopie vorkommen
* Zufallsfragen - Jede Person erhält bei jedem neuen Versuch andere Fragen. Unterschiedliche Personen bekommen unterschiedliche Fragen vorgelegt';
$string['editingquiz_link'] = 'mod/quiz/edit';
$string['editingquizx'] = 'Test bearbeiten: {$a}';
$string['editmaxmark'] = 'Höchste Bewertung bearbeiten';
$string['editoverride'] = 'Änderung bearbeiten';
$string['editqcats'] = 'Kategorien bearbeiten';
$string['editquestion'] = 'Frage bearbeiten';
$string['editquestions'] = 'Fragen bearbeiten';
$string['editquiz'] = 'Testfragen bearbeiten';
$string['editquizquestions'] = 'Testfragen bearbeiten';
$string['emailconfirmautosubmitsmall'] = 'Danke, dass Sie Ihre Antworten zum Test \'{$a->quizname}\' gesendet haben.';
$string['emailconfirmbody'] = 'Guten Tag {$a->username},

vielen Dank für die Abgabe Ihrer Antworten zu \'{$a->quizname}\' im Kurs \'{$a->coursename}\' am {$a->submissiontime}.

Diese E-Mail bestätigt, dass Ihre Abgabe sicher angekommen ist.

Sie können auf den Test zugreifen unter {$a->quizurl}.

Ihr E-Learning-Team';
$string['emailconfirmbodyautosubmit'] = 'Hallo {$a->username},

die Zeit für den Test \'{$a->quizname}\' im Kurs \'{$a->coursename}\' ist abgelaufen. Ihre Antworten wurden automatisch um {$a->submissiontime} gesendet.

Diese Nachricht bestätigt, dass Ihre Antworten gespeichert wurden.

Sie können auf diesen Test über {$a->quizurl} zugreifen.';
$string['emailconfirmsmall'] = 'Danke für die Übermittlung Ihrer Antworten zu \'{$a->quizname}\'';
$string['emailconfirmsubject'] = 'Bestätigung der Testlösungen für {$a->quizname}';
$string['emailmanualgradedbody'] = 'Hallo {$a->studentname},

Ihre Antworten zu \'{$a->quizname}\' im Kurs \'{$a->coursename}\' von {$a->attempttimefinish} sind jetzt bewertet worden.

Sie können Ihre Punktzahl und das Feedback einsehen, indem Sie \'{$a->quizurl}\' besuchen und Ihren Versuch überprüfen.';
$string['emailmanualgradedsubject'] = 'Ihr Versuch bei {$a->quizname} wurde bewertet.';
$string['emailnotifybody'] = 'Guten Tag {$a->username},

{$a->studentname} hat den Test \'{$a->quizname}\' ({$a->quizurl})
im Kurs \'{$a->coursename}\' beendet.

Sie können diesen Versuch unter {$a->quizreviewurl} überprüfen.

Ihr E-Learning-Team';
$string['emailnotifysmall'] = '{$a->studentname} hat {$a->quizname} abgeschlossen. Siehe {$a->quizreviewurl}';
$string['emailnotifysubject'] = '{$a->studentname} hat den Test {$a->quizname} beendet';
$string['emailoverduebody'] = 'Guten Tag {$a->studentname},

Sie haben den Test \'{$a->quizname}\' im Kurs {$a->coursename} begonnen. Der Testversuch wurde von Ihnen jedoch bisher nicht abgeschlossen. Dies sollten Sie bis zu diesem Termin nachholen: {$a->attemptduedate}.

Um den Testversuch jetzt abzuschließen, gehen Sie auf {$a->attemptsumaryurl} und klicken Sie die Taste \'Abgeben\'. Wenn Sie dies nicht vor dem {$a->attemptgracend} tun, wird der Versuch nicht gewertet.

Ihr E-Learning-Team';
$string['emailoverduesmall'] = 'Sie haben den Testversuch in {$a->quizname} nicht abgeschlossen. Gehen Sie vor dem {$a->attemptgraceend} zu {$a->attemptsummaryurl}, wenn Sie den Versuch noch abschließen möchten.';
$string['emailoverduesubject'] = 'Testversuch nun überfällig für {$a->quizname}';
$string['empty'] = 'Leer';
$string['enabled'] = 'Aktiviert';
$string['endtest'] = 'Versuch abschließen ...';
$string['erroraccessingreport'] = 'Sie können nicht auf den Bericht zugreifen.';
$string['errorinquestion'] = 'Fehler in der Frage';
$string['errormissingquestion'] = 'Fehler: Die Frage mit der ID {$a} fehlt';
$string['errornotnumbers'] = 'Fehler: Die Antwort muss eine Zahl sein.';
$string['errorunexpectedevent'] = 'Unerwarteter Ablaufcode {$a->event}  für Frage {$a->questionid} im Versuch {$a->attemptid} gefunden';
$string['essay'] = 'Freitext';
$string['essayquestions'] = 'Freitext-Fragen';
$string['eventattemptautosaved'] = 'Testversuch automatisch gespeichert';
$string['eventattemptdeleted'] = 'Testversuch gelöscht';
$string['eventattemptmanualgradingcomplete'] = 'Manuelle Benotung des Testversuchs abgeschlossen';
$string['eventattemptpreviewstarted'] = 'Vorschau des Testversuchs angezeigt';
$string['eventattemptquestionrestarted'] = 'Frage im Testversuch neu gestartet';
$string['eventattemptreviewed'] = 'Testversuch überprüft';
$string['eventattemptsummaryviewed'] = 'Übersicht des Testversuchs angezeigt';
$string['eventattemptupdated'] = 'Testversuch aktualisiert';
$string['eventattemptviewed'] = 'Testversuch angezeigt';
$string['eventeditpageviewed'] = 'Testbearbeitungsseite angezeigt';
$string['eventoverridecreated'] = 'Testüberschreibung angelegt';
$string['eventoverridedeleted'] = 'Testüberschreibung gelöscht';
$string['eventoverrideupdated'] = 'Testüberschreibung aktualisiert';
$string['eventpagebreakcreated'] = 'Seitenumbruch eingefügt';
$string['eventpagebreakdeleted'] = 'Seitenumbruch gelöscht';
$string['eventquestionmanuallygraded'] = 'Frage manuell bewertet';
$string['eventquizattemptabandoned'] = 'Testversuch aufgegeben';
$string['eventquizattemptregraded'] = 'Testersuch neu bewertet';
$string['eventquizattemptreopened'] = 'Testversuch neu geöffnet';
$string['eventquizattemptstarted'] = 'Testversuch gestartet';
$string['eventquizattemptsubmitted'] = 'Testversuch eingereicht';
$string['eventquizattempttimelimitexceeded'] = 'Zeit für Testversuch überschritten';
$string['eventquizgradeitemcreated'] = 'Bewertungselement angelegt';
$string['eventquizgradeitemdeleted'] = 'Bewertungselement gelöscht';
$string['eventquizgradeitemorderchanged'] = 'Bewertungselement umsortiert';
$string['eventquizgradeitemupdated'] = 'Bewertungselement aktualisiert';
$string['eventquizgradeupdated'] = 'Testbewertung aktualisiert';
$string['eventquizrepaginated'] = 'Testseiten neu aufgeteilt';
$string['eventreportviewed'] = 'Testbericht angezeigt';
$string['eventsectionbreakcreated'] = 'Abschnittsumbruch hinzugefügt';
$string['eventsectionbreakdeleted'] = 'Abschnittsumbruch gelöscht';
$string['eventsectionshuffleupdated'] = 'Abschnittsmischung aktualisiert';
$string['eventsectiontitleupdated'] = 'Abschnittstitel aktualisiert';
$string['eventslotcreated'] = 'Frageslot angelegt';
$string['eventslotdeleted'] = 'Frageslot gelöscht';
$string['eventslotdisplayedquestionnumberupdated'] = 'Angezeigte Fragenummer des Slots aktualisiert';
$string['eventslotgradeitemupdated'] = 'Slot Bewertungselement aktualisiert';
$string['eventslotmarkupdated'] = 'Bewertung des Frageslots aktualisiert';
$string['eventslotmoved'] = 'Frageslot verschoben';
$string['eventslotrequirepreviousupdated'] = 'Frageslot-Abhängigkeit aktualisiert';
$string['everynquestions'] = 'Nach {$a} Fragen';
$string['everyquestion'] = 'Jede Frage';
$string['everythingon'] = 'Alles einschalten';
$string['existingcategory'] = 'Bestehende Kategorie';
$string['exportcategory'] = 'Exportkategorie';
$string['exporterror'] = 'Beim Export ist ein Fehler aufgetreten.';
$string['exportingquestions'] = 'Die Fragen werden in eine Exportdatei übertragen.';
$string['exportname'] = 'Dateiname';
$string['exportquestions'] = 'Fragen in Datei exportieren';
$string['extraattemptrestrictions'] = 'Weitere Zugriffsbeschränkungen';
$string['false'] = 'Falsch';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'Die Bewertungsgrenzen für das Feedback müssen entweder in Prozent oder als Zahl angegeben werden. Der von Ihnen eingegebene Grenzwert {$a} wurde nicht erkannt. Bei Prozentwerten darf kein Leerzeichen zwischen der Zahl und dem Prozentwert stehen. Als Dezimaltrenner ist ein Punkt zu verwenden.';
$string['feedbackerrorboundaryoutofrange'] = 'Die Bewertungsgrenzen für das Feedback müssen zwischen 0% und 100% liegen. Der von Ihnen eingegebene Grenzwert {$a} liegt außerhalb. Bei Prozentwerten darf kein Leerzeichen zwischen der Zahl und dem Prozentwert stehen.';
$string['feedbackerrorjunkinboundary'] = 'Sie müssen die Bewertungsgrenzen in den Feedback-Feldern ausfüllen, ohne Lücken zu lassen.';
$string['feedbackerrorjunkinfeedback'] = 'Sie müssen die Feedback-Felder ausfüllen, ohne Lücken zu lassen.';
$string['feedbackerrororder'] = 'Bewertungsgrenzen für das Feedback müssen mit dem größten Wert beginnen und bis zum kleinsten Wert fortgeführt werden. Der von Ihnen eingegebene Grenzwert {$a} liegt nicht in der Reihe.';
$string['file'] = 'Datei';
$string['fileformat'] = 'Dateiformat';
$string['fillcorrect'] = 'Korrektur eintragen';
$string['filloutnumericalanswer'] = 'Sie müssen mindestens eine mögliche Antwort und einen Toleranzwert angeben. Die erste passende Antwort wird verwendet, um die Bewertung und das Feedback zu bestimmen. Falls Sie sich entscheiden, am Ende ein Feedback ohne vorherige Antwort zu geben, so wird dies allen denjenigen gezeigt, deren Antworten auf keine der Vorgaben passen.';
$string['filloutoneanswer'] = 'Sie müssen mindestens ein Antwortfeld ausfüllen. Leere Felder werden ignoriert. \'*\' kann als Platzhalter für beliebige Buchstaben benutzt werden. Die erste passende Antwort wird verwendet, um die Bewertung und das Feedback zu bestimmen.';
$string['filloutthreequestions'] = 'Sie müssen mindestens drei Fragen auswählen. Leere Fragen werden nicht verwendet.';
$string['fillouttwochoices'] = 'Sie müssen mindestens zwei Antwortfelder ausfüllen. Leere Felder werden ignoriert.';
$string['finishattemptdots'] = 'Versuch beenden...';
$string['finishreview'] = 'Überprüfung beenden';
$string['forceregeneration'] = 'Erneuerung erzwingen';
$string['formatnotfound'] = 'Das Import-Export-Format {$a} wurde nicht gefunden.';
$string['formulaerror'] = 'Formularfehler!';
$string['fractionsaddwrong'] = 'Die positiven Bewertungen, die Sie gewählt haben, ergeben keine 100%.
<br />Statt dessen ergeben sie {$a}%.
<br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['fractionsnomax'] = 'Eine dieser Antworten sollte 100% sein, damit
<br />es möglich ist, die volle Punktzahl für diese Frage zu bekommen.
<br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['fromfile'] = 'aus der Datei:';
$string['functiondisabledbysecuremode'] = 'Diese Funktion ist aktuell deaktiviert';
$string['generalfeedback'] = 'Allgemeines Feedback';
$string['generalfeedback_help'] = 'Das allgemeine Feedback besteht aus dem Text, den die Teilnehmer/innen nach dem Versuch sehen, eine Frage zu beantworten. Anders als das Feedback, das vom Fragetyp und der Nutzerantwort abhängt, wird der Text des allgemeinen Fragen-Feedbacks allen Teilnehmer/innen gezeigt';
$string['gobacktoquiz'] = 'Zurück zum Test';
$string['graceperiod'] = 'Nachfrist für Abgabe';
$string['graceperiod_desc'] = 'Wenn für den Zeitablauf gewählt wurde "Nachfrist: offene Versuche können abgeschlossen, aber Fragen nicht mehr beantwortet werden." wird diese zusätzliche Zeitdauer gewährt.';
$string['graceperiod_help'] = 'Wenn die Option "\'Nachfrist: offene Versuche können ..." für den Zeitablauf gewählt ist, wird diese zusätzliche Zeitdauer gewährt.';
$string['graceperiodmin'] = 'Letzte Nachfrist für Abgabe';
$string['graceperiodmin_desc'] = 'Wenn der Test für alle Teilnehmer/innen zum gleichen Zeitpunkt endet, müssen u.U. sehr viele Daten auf einmal abgespeichert werden. Daher kann ein Zeitraum festgelegt werden für den das Abspeichen der Testdaten noch zulässig ist, obwohl der Zeitraum eigentlich abgelaufen ist. Die Länge des erforderlichen Zeitraums hängt von der Teilnehmerzahl und vom Testumfang ab, sowie der Leistungsstärke des Servers. Der Wert wird in Sekunden eingegeben. Damit wird verhindert. dass es zu Problemen beim Abspeichern der Eingaben durch Serverengpässe kommt.';
$string['graceperiodtoosmall'] = 'Die Nachfrist muss länger sein als {$a}.';
$string['grade'] = 'Bewertung';
$string['gradeall'] = 'Alle bewerten';
$string['gradeaverage'] = 'Durchschnitt';
$string['gradeboundary'] = 'Bewertungsgrenze';
$string['gradeessays'] = 'Freitexte bewerten';
$string['gradehighest'] = 'Bester Versuch';
$string['gradeitemdefaultname'] = 'Neues Bewertungselement {$a}';
$string['gradeitemdelete'] = 'Bewertungselement {$a} löschen';
$string['gradeitemedit'] = 'Name von Bewertungselement {$a} bearbeiten';
$string['gradeitemmarkscheme'] = 'Bewertungselemente zuordnen';
$string['gradeitemnewname'] = 'Neuer Name für Bewertungselement {$a}';
$string['gradeitemnoneselected'] = '[keine]';
$string['gradeitemnoslots'] = 'Für diesen Test gibt es noch keine Fragen. Bitte fügen Sie zuerst Fragen hinzu und kehren Sie dann hierher zurück, um die Bewertungselemente einzurichten.';
$string['gradeitems'] = 'Bewertungsaspekte';
$string['gradeitemsautosetup'] = 'Richten Sie eine Bewertung für jeden Abschnitt ein';
$string['gradeitemsetup'] = 'Einrichtung von Bewertungselementen';
$string['gradeitemsnoneyet'] = 'Erstellen Sie Bewertungselemente in Ihrem Test. Ordnen Sie diesen Bewertungselementen Fragen oder Testabschnitte zu, um die Bewertungsergebnisse in verschiedene Bereiche aufzuschlüsseln.';
$string['gradeitemsremoveall'] = 'Einrichtung zurücksetzen';
$string['gradeitemsremoveallconfirm'] = 'Einrichtung der Bewertungselemente zurücksetzen?';
$string['gradeitemsremoveallmessage'] = 'Dadurch werden alle Bewertungselemente gelöscht und die Zuweisung von Fragen und Abschnitten wird aufgehoben. <br><br>Diese Aktion wirkt sich weder auf die Fragen und Abschnitte selbst noch auf bestehende Versuche im Test aus.';
$string['gradeitemsremovealltitle'] = 'Einrichtung der Bewertungselemente zurücksetzen';
$string['grademethod'] = 'Bewertungsmethode';
$string['grademethod_help'] = 'Wenn mehrere Versuche erlaubt sind, gibt es unterschiedliche Möglichkeiten, eine abschließende Bewertung für die Teilnehmer/innen festzulegen:

* Beste Bewertung aus allen Versuchen
* Durchschnitt aus allen Versuchen
* Erster Versuch (alle weiteren Versuche werden
ignoriert)
* Letzter Versuch (alle weiteren Versuche werden
ignoriert)';
$string['gradesdeleted'] = 'Testbewertungen wurden gelöscht';
$string['gradesofar'] = '{$a->method}: {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'Die Bestehensgrenze kann nicht Null sein. Der Aktivitätsabschluss dieses Tests ist so festgelegt, dass eine Bestehensgrenze erforderlich ist. Legen Sie bitte einen Wert ungleich Null fest.';
$string['gradetopassoutof'] = 'Bestehensgrenze: {$a->grade} von {$a->maxgrade}';
$string['gradingdetails'] = 'Punkte: {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'Mit früheren Abzügen ergibt dies <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Die Arbeit berücksichtigt einen Abzug von {$a}.';
$string['gradingdetailszeropenalty'] = 'Sie erhalten für diese Arbeit keine Abzüge.';
$string['gradingmethod'] = 'Bewertungsmethode: {$a}';
$string['groupoverrides'] = 'Gruppenänderungen';
$string['groupoverridesdeleted'] = 'Gruppenänderungen gelöscht';
$string['groupsnone'] = 'Es gibt in diesem Kurs keine Gruppen, die Sie nutzen können.';
$string['guestsno'] = 'Gäste können einen Test weder sehen noch ausprobieren.';
$string['hidebreaks'] = 'Seitenumbrüche verbergen';
$string['hidereordertool'] = 'Neuanordnung verbergen';
$string['history'] = 'Frühere Antworten:';
$string['howquestionsbehave_desc'] = 'Standardeinstellung für das Verhalten von Fragen in einem Test';
$string['imagedisplay'] = 'Abbildung einfügen';
$string['import_help'] = 'Die Funktion ermöglicht es Fragen aus einer Textdatei zu importieren.

Wenn die Datei Sonderzeichen (z.B. Umlaute) enthält, muss sie UTF-8 codiert sein. Dateien, die mit Microsoft Office erstellt werden, nutzen meist andere Codierungen und führen zu fehlerhaften Zeichendarstellungen.
Die verfügbaren Import- und Exportfunktionen hängen von den installierten Plugins auf Ihrem System ab. Zusätzliche Formate können in der Module- und Plugindatenbank verfügbar sein.';
$string['import_link'] = 'question/import';
$string['importcategory'] = 'Kategorie-Import';
$string['importerror'] = 'Beim Import ist ein Fehler aufgetreten';
$string['importfilearea'] = 'Der Dateiimport in die Kursdateien erfolgt ...';
$string['importfileupload'] = 'Dateiimport von hochgeladener Datei ...';
$string['importfromthisfile'] = 'Import aus dieser Datei';
$string['importingquestions'] = 'Import von {$a} Fragen aus Datei';
$string['importmax10error'] = 'In der Frage ist ein Fehler aufgetreten. Sie dürfen höchstens zehn Antworten formulieren.';
$string['importmaxerror'] = 'Fehler in der Frage: zu viele Antworten.';
$string['importquestions'] = 'Frage aus einer Datei importieren';
$string['inactiveoverridehelp'] = '* Diese Nutzeränderung ist inaktiv, weil kein Zugang zur Aktivität besteht. Das kann aufgrund der Gruppenzugehörigkeit oder Rolle sein, aufgrund anderer Zugriffsbeschränkungen oder weil die Aktivität verborgen ist.';
$string['incorrect'] = 'Falsch';
$string['indicator:cognitivedepth'] = 'Test kognitiv';
$string['indicator:cognitivedepth_help'] = 'Dieser Indikator basiert auf der kognitiven Tiefe, die eine Person in einer Testaktivität erreicht hat.';
$string['indicator:cognitivedepthdef'] = 'Test kognitiv';
$string['indicator:cognitivedepthdef_help'] = 'Die Person hat diesen Prozentsatz des kognitiven Engagements erreicht, das die Testaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Ansicht, Ansicht, Beiträge, Feedback anzeigen, Feedback kommentieren, Beiträge nach Feedback überarbeiten).';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Test sozial';
$string['indicator:socialbreadth_help'] = 'Dieser Indikator basiert auf der sozialen Breite, die eine Person in einer Testaktivität erreicht hat.';
$string['indicator:socialbreadthdef'] = 'Test sozial';
$string['indicator:socialbreadthdef_help'] = 'Die Person hat diesen Prozentsatz des soziale Engagements erreicht, das die Testaktivitäten während dieses Analyseintervalls aufzeigen (Ebenen = Keine Teilnahme, Teilnahme allein, Teilnahme mit anderen).';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['indivresp'] = 'Antworten der einzelnen Personen zu jeder Frage';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Anzahl von Feedback-Feldern';
$string['initialnumfeedbacks_desc'] = 'Diese Option legt fest, wie viele Felder für das Feedback vorhanden sind, wenn ein neuer Test angelegt wird. Sobald der Test angelegt wurde, zeigt das Formular so viele Felder wie für die Feedbacks im Test notwendig sind. Der eingetragene Wert muss mindestens 1 sein.';
$string['inprogress'] = 'In Bearbeitung';
$string['introduction'] = 'Beschreibung';
$string['invalidattemptid'] = 'Keine solche Versuchs-ID vorhanden';
$string['invalidcategory'] = 'Ungültige Kategorie-ID';
$string['invalidoverrideid'] = 'Ungültige ID-Änderung';
$string['invalidquestionid'] = 'Ungültige Frage-ID';
$string['invalidquizid'] = 'Ungültige Test-ID';
$string['invalidrandomslot'] = 'Ungültige Zufallsfrage-ID';
$string['invalidsource'] = 'Die Quelle ist ungültig.';
$string['invalidsourcetype'] = 'Ungültiger Quellentyp.';
$string['invalidstateid'] = 'Ungültige Status-ID';
$string['lastanswer'] = 'Ihre letzte Antwort war';
$string['lastautosave'] = 'Zuletzt gespeichert: {$a}';
$string['layout'] = 'Fragenanordnung';
$string['layoutasshown'] = 'Seitenlayout wie angezeigt.';
$string['layoutasshownwithpages'] = 'Seitenlayout wie angezeigt. <small>(Automatisch neue Seite nach {$a} Fragen.)</small>';
$string['layoutshuffledandpaged'] = 'Zufällige Reihenfolge der Fragen. {$a} Fragen/Seite.';
$string['layoutshuffledsinglepage'] = 'Zufällige Reihenfolge der Fragen. Alle Fragen auf einer Seite.';
$string['link'] = 'Link';
$string['listitems'] = 'Liste der Testfragen';
$string['literal'] = 'Schreibweise';
$string['loadingquestionsfailed'] = 'Das Laden der Fragen ist gescheitert: {$a}';
$string['makecopy'] = 'Als neue Frage abspeichern';
$string['managetypes'] = 'Fragetypen und Server verwalten';
$string['manualgradequestion'] = 'Manuelle Bewertung der Frage {$a->question} in {$a->quiz} für {$a->user}';
$string['manualgrading'] = 'Bewertung';
$string['mark'] = 'Abschicken';
$string['markall'] = 'Seite bewerten lassen';
$string['marks'] = 'Punkte';
$string['marks_help'] = 'Bewertungen für jede Frage und das Gesamtergebnis für den Versuch. Sie können nur Bewertungen auswählen, wenn eine maximale Bewertung angegeben ist.';
$string['match'] = 'Zuordnung';
$string['matchanswer'] = 'Zugeordnete Antwort';
$string['matchanswerno'] = 'Zutreffende Antworten {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Höchste Bewertung';
$string['maxmarks'] = 'Max. Punkte';
$string['maxmarks_help'] = 'Maximale Punkte, die für jede Frage verfügbar sind';
$string['messageprovider:attempt_grading_complete'] = 'Mitteilung, dass Ihr Testversuch bewertet wurde';
$string['messageprovider:attempt_overdue'] = 'Systemnachricht zur Fälligkeit von Testabgaben';
$string['messageprovider:confirmation'] = 'Systemnachricht bei eigener Testabgabe';
$string['messageprovider:submission'] = 'Systemnachricht bei Testabgaben von Teilnehmer/innen';
$string['min'] = 'Min';
$string['minutes'] = 'Minuten';
$string['missingcategory'] = 'Fehlende Fragekategorie';
$string['missingcorrectanswer'] = 'Die richtige Antwort muss angegeben werden.';
$string['missingitemtypename'] = 'Name fehlt';
$string['missingquestion'] = 'Diese Frage gibt es wahrscheinlich nicht mehr.';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Führen Sie im Kurs Ihre eigenen Tests durch. Legen Sie den Ablauf des Tests für Teilnehmer/innen fest und erstellen Sie Ihre Testfragen.

Wählen Sie aus verschiedenen Testfragetypen, darunter Multiple-Choice-Fragen, Zuordnungsfragen, Kurzantworten und numerische Fragen aus und geben Sie richtige und falsche Antworten für die automatische Bewertung ein. Ein Feedback zu den Fragen und Antwortoptionen gibt den Teilnehmer/innen Hilfe bei der eigenen Auswertung des abgeschlossenen Tests.

Hinweis: Tests werden unterschiedlich eingesetzt und haben sehr umfangreiche Einstelloptionen.

Jeder Versuch wird automatisch bewertet, mit Ausnahme von Freitextfragen, und die Endnote wird in den Bewertungen festgehalten.

Eine Test-Aktivität kann verwendet werden

* Als Prüfung im Kurs
* Als Mini-Test für Leseaufträge oder am Ende eines Themas
* Als Prüfungsübung mit Fragen aus vergangenen Prüfungen
* Um unmittelbares Feedback zur Leistung zu geben
* Als Selbsttest zur Selbsteinschätzung';
$string['modulename_link'] = 'mod/quiz/view';
$string['modulenameplural'] = 'Tests';
$string['moveselectedonpage'] = 'Verschieben der ausgewählten Fragen zur Seite: {$a}';
$string['multichoice'] = 'Multiple-Choice';
$string['multipleanswers'] = 'Wählen Sie eine oder mehrere richtige Antworten.';
$string['mustbesubmittedby'] = 'Dieser Versuch muss abgegeben werden vor {$a}.';
$string['name'] = 'Name';
$string['navigatenext'] = 'Nächste Seite';
$string['navigateprevious'] = 'Vorherige Seite';
$string['navmethod'] = 'Navigation';
$string['navmethod_free'] = 'Selbstgewählt';
$string['navmethod_help'] = 'Wenn die vorgegebene Navigation aktiviert ist, müssen Teilnehmer/innen den Test in der definierten Reihenfolge abarbeiten, dürfen keine Seiten zurückgehen und keine Seiten überspringen.';
$string['navmethod_seq'] = 'Vorgegeben';
$string['navnojswarning'] = 'Achtung: Mit diesen Links werden Ihre Antworten nicht gespeichert. Verwenden Sie die Taste \'Weiter\' am Ende der Seite.';
$string['neverallononepage'] = 'Nie, alle Fragen auf einer Seite';
$string['newattemptfail'] = 'Fehler: Ein neuer Versuch des Tests konnte nicht begonnen werden.';
$string['newcategory'] = 'Neue Kategorie';
$string['newpage'] = 'Neue Seite';
$string['newpage_help'] = 'Bei längeren Tests ist es sinnvoll, die Fragen auf mehrere Seiten zu verteilen. Wenn Sie bei der Testzusammenstellung Fragen hinzufügen, werden an der entsprechenden Stelle automatisch Seitenumbrüche eingefügt. Sie können die Seitenumbrüche später manuell anpassen.';
$string['newpageevery'] = 'Automatisch eine neue Seite beginnen';
$string['newsectionheading'] = 'Neue Abschnittsüberschrift';
$string['noanswers'] = 'Es wurden keine Antworten ausgewählt!';
$string['noattempts'] = 'Dieser Test ist noch nicht bearbeitet.';
$string['noattemptsfound'] = 'Keine Versuche gefunden';
$string['noattemptstoshow'] = 'Es gibt keine Versuche, die angezeigt werden können.';
$string['nocategory'] = 'Sie haben keine oder eine falsche Kategorie ausgewählt.';
$string['noclose'] = 'Kein Abgabedatum';
$string['nocommentsyet'] = 'Derzeit keine Kommentare vorhanden';
$string['noconnection'] = 'Es gibt derzeit keine Verbindung zu einem Webservice, der diese Frage beantworten kann. Nehmen Sie Kontakt mit dem Administrator auf.';
$string['nodataset'] = 'nichts - es gibt keine Wildcard';
$string['nodatasubmitted'] = 'Keine Daten abgegeben';
$string['noessayquestionsfound'] = 'Keine Freitext-Fragen gefunden';
$string['nogradewarning'] = 'Dieser Test wird nicht bewertet. Daher können Sie kein Gesamtfeedback einstellen, das sich je nach Bewertung unterscheidet.';
$string['nomoreattempts'] = 'Kein Versuch mehr zugelassen';
$string['none'] = '--';
$string['noopen'] = 'Kein Startzeitpunkt';
$string['nooverridedata'] = 'Sie müssen mindestens eine Testeinstellung ändern.';
$string['nopossibledatasets'] = 'Keine Datensätze möglich';
$string['noquestionintext'] = 'Der Fragetext enthält keine Frageformulierung.';
$string['noquestions'] = 'Es wurden noch keine Fragen eingetragen.';
$string['noquestionsfound'] = 'Keine Fragen gefunden';
$string['noquestionsinquiz'] = 'Es gibt keine Fragen in diesem Test.';
$string['noquestionsnotinuse'] = 'Diese Zufallsfrage wird nicht genutzt, da ihre Kategorie leer ist.';
$string['noquestionsonpage'] = 'Leere Seite';
$string['noresponse'] = 'Keine Antwort';
$string['noreview'] = 'Sie dürfen diesen Test nicht überprüfen.';
$string['noreviewattempt'] = 'Sie dürfen diesen Versuch nicht  erneut prüfen.';
$string['noreviewshort'] = 'Bewertung nicht erlaubt';
$string['noreviewuntil'] = 'Sie dürfen diesen Test bis {$a} nicht überprüfen.';
$string['noreviewuntilshort'] = '{$a} verfügbar';
$string['noscript'] = 'JavaScript muss aktiviert sein!';
$string['notavailabletostudents'] = 'Hinweis: Dieser Test ist momentan für Teilnehmer/innen nicht verfügbar.';
$string['notenoughrandomquestions'] = 'Es sind nicht genug Fragen in der Kategorie {$a->category} vorhanden, um die Frage \'{$a->name}\' ({$a->id}) hinzuzufügen.';
$string['notenoughsubquestions'] = 'Es wurden noch nicht genügend Unterfragen definiert! <br />Möchten Sie zurückgehen und diese Frage korrigieren?';
$string['notifyattemptsgradedtask'] = 'Mitteilungen senden, dass Testversuche bewertet wurden';
$string['notimedependentitems'] = 'Zeitabhängige Einzelaufgaben werden zur Zeit vom Testmodul nicht unterstützt. Sie können jedoch ein Zeitlimit für den gesamten Test festlegen. Wollen Sie eine andere Frage auswählen (oder die derzeitige Frage trotzdem nutzen)?';
$string['notyetgraded'] = 'Bisher nicht bewertet';
$string['notyetviewed'] = 'Bisher nicht angesehen';
$string['notyourattempt'] = 'Dies ist nicht Ihr Versuch!';
$string['noview'] = 'Angemeldete Nutzer/innen dürfen diesen Test nicht sehen';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} haben {$a->attemptnum} Versuche durchgeführt.';
$string['numberabbr'] = '#';
$string['numerical'] = 'Numerisch';
$string['numquestionsx'] = 'Fragen: {$a}';
$string['oneminute'] = '1 Minute';
$string['onlyteachersexport'] = 'Nur Trainer/innen können Fragen exportieren';
$string['onlyteachersimport'] = 'Nur Trainer/innen mit Bearbeitungsrecht können Fragen importieren';
$string['onthispage'] = 'Diese Seite';
$string['open'] = 'Nicht beantwortet';
$string['openafterclose'] = 'Der Test konnte nicht aktualisiert werden. Sie haben ein Startdatum nach dem Enddatum angegeben.';
$string['openclosedatesupdated'] = 'Start- und Schlusstermin des Tests wurden aktualisiert';
$string['optional'] = 'optional';
$string['orderandpaging'] = 'Reihenfolge und Seitenumbrüche';
$string['orderandpaging_help'] = 'Die Zahlen 10, 20, 30, ... neben jeder Frage zeigt deren Reihenfolge an. Die Zahlenfolge in 10er-Schritten lässt Platz, um weitere Fragen zwischendrin einfügen zu können. Um die Reihenfolge der Fragen zu ändern, ändern Sie die Zahlen und klicken Sie auf die Taste \'Neu sortieren\'.

Um Seitenumbrüche nach bestimmten Fragen einzufügen, markieren Sie das Kontrollfeld \'Neue Seite nach markierter Frage hinzufügen\'.

Um Fragen über eine Reihe von Seiten anzuordnen, klicken Sie auf die Taste \'Seitenumbrüche durchführen\' und wählen Sie die gewünschte Anzahl von Fragen pro Seite.';
$string['orderingquiz'] = 'Reihenfolge und Seitenumbrüche';
$string['orderingquizx'] = 'Reihenfolge und Seitenwechsel: {$a}';
$string['outcomesadvanced'] = 'Lernziele als erweiterte Einstellungen';
$string['outof'] = '{$a->grade} von {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} von {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Gesamtfeedback';
$string['overallfeedback_help'] = 'Das Gesamtfeedback ist der Text, welcher am Ende eines Testdurchlaufs angezeigt wird. Indem zusätzliche Bewertungsgrenzen – als Prozentwert (z.B. 31.3%) oder als Zahlwert (z.B. 7) – eingetragen werden, kann der Text je nach Testergebnis unterschiedlich lauten.';
$string['overdue'] = 'Überfällig';
$string['overduehandling'] = 'Wenn die Zeit abgelaufen ist';
$string['overduehandling_desc'] = 'Grundeinstellung für den Test wenn Teilnehmer/innen einen Testversuch nicht abschließen bevor der Zeitraum abgelaufen ist.';
$string['overduehandling_help'] = 'Die Einstellung legt fest, was passiert, wenn Teilnehmer/innen den Test nicht rechtzeitig abschließen. Wenn die Teilnehmer/innen zu diesem Zeitpunkt aktiv am Test arbeiten, wird der aktuelle Bearbeitungsstand automatisch abgegeben. Sind sie nicht angemeldet, so entscheidet diese Einstellung.';
$string['overduehandling_link'] = 'mod/quiz/timing';
$string['overduehandlingautoabandon'] = 'Der Testversuch muss abgegeben werden, bevor die Zeit abgelaufen ist, damit er gewertet werden kann.';
$string['overduehandlingautosubmit'] = 'Der Testversuch wird automatisch abgegeben.';
$string['overduehandlinggraceperiod'] = 'Nachfrist: offene Versuche können abgeschlossen, aber Fragen nicht mehr beantwortet werden.';
$string['overduemustbesubmittedby'] = 'Der Versuch ist überfällig und sollte bereits abgegeben worden sein. Wenn Sie möchten, dass Ihr Testversuch bewertet wird, müssen Sie ihn abgeben bis {$a}. Falls Sie dies nicht tun, wird keine Bewertung für diesen Versuch gezählt.';
$string['override'] = 'Überschreiben';
$string['overridecannotchange'] = 'Nutzer/in oder Gruppe können nach der Erstellung einer Überschreibung nicht mehr geändert werden';
$string['overridecannotsetbothgroupanduser'] = 'Gruppe und Nutzer/in können nicht gleichzeitig festgelegt werden';
$string['overridedeletegroupsure'] = 'Sind Sie sicher, dass Sie die Änderung für die Gruppe {$a} löschen möchten?';
$string['overridedeleteusersure'] = 'Sind Sie sicher, dass Sie die Änderung für Nutzer/in {$a} löschen möchten?';
$string['overridegroup'] = 'Gruppe ändern';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrideinvalidattempts'] = 'Der Wert der Versuche muss größer als Null sein.';
$string['overrideinvalidexistingid'] = 'Vorhandene Überschreibung ist nicht vorhanden.';
$string['overrideinvalidgroup'] = 'Die angegebene Gruppe existiert nicht.';
$string['overrideinvalidquiz'] = 'Die gesetzte Test-ID existiert nicht.';
$string['overrideinvalidtimelimit'] = 'Das Zeitlimit muss größer als Null sein.';
$string['overrideinvaliduser'] = 'Nutzer/in existiert nicht.';
$string['overridemissingdelete'] = 'Die Änderungs-ID(s) {$a} konnten nicht gelöscht werden, da sie nicht existieren oder nicht Teil im angegebenen Test sind.';
$string['overridemultiplerecordsexist'] = 'Nutzer/in oder Gruppe können nicht mehrfache Überschreibungen bekommen.';
$string['overridemustsetuserorgroup'] = 'Nutzer/in oder Gruppe müssen gesetzt sein.';
$string['overrides'] = 'Überschreibungen';
$string['overridesforquiz'] = 'Einstellungsänderungen: {$a}';
$string['overridesnoneforgroups'] = 'Für diesen Test gibt es keine Überschreibung von Gruppeneinstellungen';
$string['overridesnoneforusers'] = 'Für diesen Test gibt es keine Überschreibung von Nutzereinstellungen';
$string['overridessummary'] = 'Vorhandene Überschreibungen von Einstellungen ({$a})';
$string['overridessummarygroup'] = 'Gruppen: {$a}';
$string['overridessummarythisgroup'] = 'Vorhandene Überschreibungen von Einstellungen ({$a}) für diese Gruppe';
$string['overridessummaryuser'] = 'Nutzer/innen: {$a}';
$string['overridessummaryyourgroups'] = 'Vorhandene Überschreibungen von Einstellungen ({$a}) für Gruppen';
$string['overrideuser'] = 'Nutzer/in ändern';
$string['overrideusereventname'] = '{$a->quiz} - Änderung';
$string['page-mod-quiz-attempt'] = 'Seite des Testversuchs';
$string['page-mod-quiz-edit'] = 'Testbearbeitungsseite';
$string['page-mod-quiz-report'] = 'Jede Seite des Testberichts';
$string['page-mod-quiz-review'] = 'Seite der Überprüfung des Testversuchs';
$string['page-mod-quiz-summary'] = 'Übersicht des Testversuchs';
$string['page-mod-quiz-view'] = 'Informationsseite des Tests';
$string['page-mod-quiz-x'] = 'Jede Testseite';
$string['pageshort'] = 'P';
$string['pagesize'] = 'Seitengröße';
$string['parent'] = 'Übergeordnete Kategorie';
$string['parentcategory'] = 'Übergeordnete Kategorie';
$string['parsingquestions'] = 'Fragen aus der Importdatei werden ausgewertet (parsing)';
$string['partiallycorrect'] = 'Teilweise richtig';
$string['penalty'] = 'Abzug';
$string['penaltyscheme'] = 'Abzüge festlegen';
$string['penaltyscheme_help'] = 'Wenn diese Option aktiviert ist, wird ein Punktabzug für eine Frage, die nicht korrekt beantwortet wurde, angewandt. Die Höhe des Punktabzugs  wird in den Einstellungen der Frage festgelegt. Diese Einstellung zeigt nur Wirkung, wenn der Modus Mehrfachbeantwortung aktiviert ist.';
$string['percentcorrect'] = 'Prozent richtig';
$string['pleaseclose'] = 'Ihre Anfrage wurde bearbeitet. Sie können das Fenster jetzt schließen.';
$string['pluginadministration'] = 'Test-Administration';
$string['pluginname'] = 'Test';
$string['popup'] = '"Sicheres" Fenster für Testversuch nutzen';
$string['popupblockerwarning'] = 'Dieser Bereich des Tests läuft im sicheren Modus ab, d.h. Sie müssen den Test in einem sicheren Fenster bearbeiten. Bitte schalten Sie den Popup-Blocker Ihres Browsers aus.';
$string['popupnotice'] = 'Teilnehmer/innen sehen den Test in einem sicheren Fenster.';
$string['preprocesserror'] = 'Fehler bei der Verarbeitung (pre-processing)!';
$string['preview'] = 'Vorschau';
$string['previewquestion'] = 'Vorschau der Frage';
$string['previewquiz'] = 'Vorschau für {$a}';
$string['previewquiznow'] = 'Vorschau ansehen';
$string['previewquizstart'] = 'Testvorschau';
$string['previous'] = 'Letzter Zustand';
$string['privacy:metadata:core_question'] = 'Die Testaktivität speichert die Verwendung von Testfragen im Subsystem \'core_question\'.';
$string['privacy:metadata:quiz'] = 'Die Testaktivität verwendet den Testbericht';
$string['privacy:metadata:quiz_attempts'] = 'Details zu jedem Versuch des Tests';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Versuchsnummer';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'Seite, die Nutzer gerade bearbeitet';
$string['privacy:metadata:quiz_attempts:gradednotificationsenttime'] = 'Zeitpunkt, zu dem die Person benachrichtigt wurde, dass die manuelle Bewertung ihres Versuchs abgeschlossen war';
$string['privacy:metadata:quiz_attempts:preview'] = 'Ob eine Vorschau des Tests genutzt wird';
$string['privacy:metadata:quiz_attempts:state'] = 'Derzeitiger Status des Versuchs';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'Summe der Bewertungen im Versuch';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'Zeitpunkt zu dem der Status geprüft wurde.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'Zeitpunkt zu dem Versuch beendet wurde';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'Zeitpunkt zu dem Versuch aktualisiert wurde';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'Zeitpunkt zu dem Versuch aktualisiert wurde bei Offline Versuch';
$string['privacy:metadata:quiz_attempts:timestart'] = 'Zeitpunkt zu dem Versuch gestartet wurde';
$string['privacy:metadata:quiz_grades'] = 'Details zur Gesamtbewertung des Tests';
$string['privacy:metadata:quiz_grades:grade'] = 'Gesamtbewertung des Tests';
$string['privacy:metadata:quiz_grades:quiz'] = 'Test, der bewertet wurde';
$string['privacy:metadata:quiz_grades:timemodified'] = 'Zeitpunkt an dem Bewertung geändert wurde';
$string['privacy:metadata:quiz_grades:userid'] = 'Nutzer, der bewertet wurde';
$string['privacy:metadata:quiz_overrides'] = 'Details zu Überschreibungen für diesen Test';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Test mit überschriebenen Informationen';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'Neues Enddatum für Test';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'Neue Zeitbegrenzung für Test';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'Neuer Starttermin für Test';
$string['privacy:metadata:quiz_overrides:userid'] = 'Nutzer/in, der/die überschrieben wurde';
$string['privacy:metadata:quizaccess'] = 'Die Testaktivität verwendet Testzugriffsregeln';
$string['publish'] = 'Veröffentlichen';
$string['publishedit'] = 'Um Fragen in dieser Kategorie zu bearbeiten, müssen Sie über die erforderlichen Rechte verfügen.';
$string['qbrief'] = 'F {$a}';
$string['qname'] = 'Name';
$string['qti'] = 'IMS-QTI';
$string['qtypename'] = 'Typ, Name';
$string['question'] = 'Frage';
$string['questionbank'] = 'aus einer Fragensammlung';
$string['questionbankmanagement'] = 'Fragensammlung verwalten';
$string['questionbehaviour'] = 'Frageverhalten';
$string['questioncats'] = 'Fragenkategorien';
$string['questiondeleted'] = 'Diese Frage wurde gelöscht. Fragen Sie bitte Ihre Trainer/innen.';
$string['questiondependencyadd'] = 'Keine Beschränkung für einen Versuch der Frage \'{$a->thisq}\'. Zum Wechseln klicken.';
$string['questiondependencyfree'] = 'Keine Beschränkung für diese Frage';
$string['questiondependencyremove'] = 'Die Frage \'{$a->thisq}\' kann erst versucht werden, wenn die vorherige Frage \'{$a->previousq}\' abgeschlossen ist. Zum Wechseln klicken.';
$string['questiondependsonprevious'] = 'Diese Frage kann erst versucht werden, wenn die vorherige Frage abgeschlossen ist.';
$string['questiondraftonly'] = 'Die Frage \'{$a}\' befindet sich im Entwurfsstatus. Um die Frage im Test zu verwenden, gehen Sie zur Fragensammlung und ändern Sie den Status auf bereit.';
$string['questiondraftwillnotwork'] = 'Die Frage befindet sich im Entwurfsstatus. Um die Frage im Test zu verwenden, gehen Sie zur Fragensammlung und ändern Sie den Status auf bereit.';
$string['questioninuse'] = 'Die Frage \'{$a->questionname}\' wird aktuell benutzt in:<br />{$a->quiznames}<br />. Die Frage kann nicht aus diesen Tests gelöscht werden, sondern nur aus der Kategorienliste ausgetragen.';
$string['questionmissing'] = 'Frage für diesen Abschnitt fehlt';
$string['questionname'] = 'Titel der Frage';
$string['questionnonav'] = '<span class="accesshide">Frage </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'Frage {$a} wurde nicht aus der Datenbank geladen';
$string['questionorder'] = 'Fragenreihenfolge';
$string['questionposition'] = 'Neue Position der Frage {$a}';
$string['questions'] = 'Fragen';
$string['questionsetpreview'] = 'Vorschau für Fragenset';
$string['questionsinclhidden'] = 'Fragen (auch die verborgenen)';
$string['questionsinthisquiz'] = 'Fragen für diesen Test';
$string['questionsmatchingfilter'] = 'Fragen, die diese Filterkriterien erfüllen: {$a}';
$string['questionsperpage'] = 'Zahl der Fragen pro Seite';
$string['questionsperpageselected'] = 'Die Einstellung \'Fragen pro Seite\' wurde festgelegt, so dass die Steuerung der Seitenumbrüche im Moment deaktiviert ist. Sie können dies aber ändern: {$a}.';
$string['questionsperpagex'] = 'Fragen pro Seite: {$a}';
$string['questiontext'] = 'Fragetext';
$string['questiontextisempty'] = '[Leerer Fragetext]';
$string['questiontype'] = 'Fragetyp {$a}';
$string['questiontypesetupoptions'] = 'Setup-Optionen für Fragetypen';
$string['questionversion'] = 'v{$a}';
$string['questionversionlatest'] = 'v{$a} (neueste)';
$string['quiz:addinstance'] = 'Neuen Test hinzufügen';
$string['quiz:attempt'] = 'Tests absolvieren';
$string['quiz:deleteattempts'] = 'Testversuche löschen';
$string['quiz:emailconfirmsubmission'] = 'Bestätigung für eigene Testabgaben empfangen';
$string['quiz:emailnotifyattemptgraded'] = 'Mitteilung empfangen, wenn Ihr Versuch bewertet wurde';
$string['quiz:emailnotifysubmission'] = 'Systemnachricht bei Testabgaben von Teilnehmer/innen empfangen';
$string['quiz:emailwarnoverdue'] = 'Warnung bei der Fälligkeit von Testabgaben empfangen';
$string['quiz:grade'] = 'Tests manuell bewerten';
$string['quiz:ignoretimelimits'] = 'Zeitgrenzen für Test ignorieren';
$string['quiz:manage'] = 'Tests verwalten';
$string['quiz:manageoverrides'] = 'Überschreibungen für den Test verwalten';
$string['quiz:preview'] = 'Test-Vorschau';
$string['quiz:regrade'] = 'Neubewertung der Testversuche';
$string['quiz:reopenattempts'] = 'Nie eingereichte Testversuche erneut öffnen';
$string['quiz:reviewmyattempts'] = 'Eigene Testversuche überprüfen';
$string['quiz:view'] = 'Test-Informationen anzeigen';
$string['quiz:viewoverrides'] = 'Überschreibungen für den Test anzeigen';
$string['quiz:viewreports'] = 'Test-Berichte anzeigen';
$string['quizavailable'] = 'Der Test ist verfügbar bis {$a}';
$string['quizclose'] = 'Testschließung';
$string['quizclosed'] = 'Dieser Test schließt am {$a}';
$string['quizcloses'] = 'Testschließung';
$string['quizcloseson'] = 'Der Test ist verfügbar bis {$a}';
$string['quizeventcloses'] = '{$a} endet';
$string['quizeventopens'] = '{$a} beginnt';
$string['quizisclosed'] = 'Dieser Test wurde bereits beendet';
$string['quizisclosedwillopen'] = 'Test geschlossen (Beginn {$a})';
$string['quizisopen'] = 'Aktuell läuft dieser Test';
$string['quizisopenwillclose'] = 'Test geöffnet (Ende {$a})';
$string['quiznavigation'] = 'Test-Navigation';
$string['quizopen'] = 'Testöffnung';
$string['quizopenclose'] = 'Anfangs- und Endzeiten';
$string['quizopenclose_help'] = 'Teilnehmer/innen dürfen ihre Versuche nach dem Beginn anfangen und müssen sie vor den Ende beendet haben.';
$string['quizopenclose_link'] = 'mod/quiz/timing';
$string['quizopened'] = 'Der Test ist geöffnet';
$string['quizopenedon'] = 'Der Test beginnt am {$a}';
$string['quizopens'] = 'Testöffnung';
$string['quizopenwillclose'] = 'Der Test ist geöffnet und wird geschlossen am {$a} um';
$string['quizordernotrandom'] = 'Die Reihenfolge des Tests ist nicht zufällig';
$string['quizorderrandom'] = '* Die Reihenfolge des Tets ist zufällig';
$string['quizreport'] = 'Testbericht';
$string['quizsettings'] = 'Test-Einstellungen';
$string['quizsetupnavigation'] = 'Navigation von Testeinrichtung';
$string['quiztimer'] = 'Stoppuhr';
$string['quizwillopen'] = 'Dieser Test wird geöffnet: {$a}';
$string['random'] = 'Zufallsfrage';
$string['randomcatwithsubcat'] = '{$a} und Unterkategorien';
$string['randomcoursecatwithsubcat'] = 'Jede Kategorie im Kursbereich {$a}';
$string['randomcoursewithsubcat'] = 'Jede Kategorie in diesem Kurs';
$string['randomcreate'] = 'Zufallsfragen erstellen';
$string['randomediting'] = 'Zufallsfrage wird bearbeitet';
$string['randomfaultynosubcat'] = 'Fehlerhafte Frage';
$string['randomfromcategory'] = 'Zufallsfrage aus der Kategorie:';
$string['randomfromexistingcategory'] = 'Zufallsfrage in einer bestehenden Kategorie';
$string['randomfromunavailabletag'] = '{$a} (unavailable)';
$string['randommodulewithsubcat'] = 'Jede Kategorie in diesem Test';
$string['randomnosubcat'] = 'Fragen nur aus dieser Kategorie, nicht aus deren Unterkategorien.';
$string['randomnumber'] = 'Anzahl der Zufallsfragen';
$string['randomqname'] = 'Zufallsfragen basieren auf Filterbedingungen';
$string['randomqnamecat'] = 'Zufällig ({$a->category}) basierend auf Filterbedingung';
$string['randomqnamecattags'] = 'Zufällig ({$a->category}) basierend auf Filterbedingung mit Tags: {$a->tags}';
$string['randomqnametags'] = 'Zufallsfrage basierend auf Filterbedingung mit Tags {$a}';
$string['randomquestion'] = 'Zufallsfrage';
$string['randomquestion_help'] = 'Eine Zufallsfrage ist eine Option, eine zufällig gewählte Frage aus einer bestimmten Kategorie oder mit einem bestimmten Tag in eine Aktivität einzufügen.';
$string['randomquestiontags'] = 'Tags';
$string['randomquestiontags_help'] = 'Sie können die Auswahlkriterien weiter einschränken, indem Sie hier Tags angeben.

Die \'zufälligen\' Fragen werden aus den Fragen mit all diesen Tags ausgewählt.';
$string['randomquestionusinganewcategory'] = 'Zufallsfrage in einer neuen Kategorie';
$string['randomsystemwithsubcat'] = 'Jede Kategorie auf Systemebene';
$string['randomwithsubcat'] = 'Fragen aus dieser Kategorie und aus deren Unterkategorien.';
$string['readytosend'] = 'Möchten Sie wirklich Ihren Test jetzt zur Bewertung abschicken?';
$string['reattemptquiz'] = 'Test wiederholen';
$string['recentlyaddedquestion'] = 'Kürzlich hinzugefügte Frage!';
$string['recurse'] = 'Fragen aus Unterkategorien einbeziehen';
$string['redoesofthisquestion'] = 'Andere Fragen wurden versucht: {$a}';
$string['redoquestion'] = 'Versuchen Sie eine weitere Frage wie diese hier';
$string['regrade'] = 'Alle Versuche neu bewerten';
$string['regradecomplete'] = 'Alle Versuche wurden neu bewertet.';
$string['regradecount'] = '{$a->changed} von {$a->attempt} Bewertungen wurden geändert.';
$string['regradedisplayexplanation'] = 'Versuche, die bei der Neubewertung verändert wurden, werden als Hyperlinks angezeigt.';
$string['regradenotallowed'] = 'Sie haben nicht das Recht, diesen Tests neu zu bewerten.';
$string['regradingquestion'] = 'Neubewertung "{$a}"';
$string['regradingquiz'] = 'Neubewertung Test "{$a}"';
$string['remove'] = 'Entfernen';
$string['removeallgroupoverrides'] = 'Alle Gruppenänderungen löschen';
$string['removeallquizattempts'] = 'Alle Testversuche entfernen';
$string['removealluseroverrides'] = 'Alle Nutzeränderungen löschen';
$string['removeemptypage'] = 'Entferne leere Seite';
$string['removepagebreak'] = 'Seitenwechsel entfernen';
$string['removeselected'] = 'Ausgewählte entfernen';
$string['rename'] = 'Umbenennen';
$string['renderingserverconnectfailed'] = 'Der Server {$a} konnte die RQP-Anfrage nicht verarbeiten. Prüfen Sie, ob die eingegebene URL richtig ist.';
$string['reopenattempt'] = 'Erneut öffnen';
$string['reopenattemptareyousuremessage'] = 'Hiermit wird der Testversuch {$a->attemptnumber} von {$a->attemptuser} erneut geöffnet.';
$string['reopenattemptareyousuretitle'] = 'Versuch erneut öffnen?';
$string['reopenattemptwrongstate'] = 'Versuch {$a->attemptid} ist im falschen Zustand ({$a->state}), um erneut geöffnet zu werden.';
$string['reopenedattemptwillbeinprogress'] = 'Der erneut geöffnete Versuch bleibt offen und kann fortgesetzt werden.';
$string['reopenedattemptwillbeinprogressuntil'] = 'Der erneut geöffnete Versuch bleibt offen und kann fortgesetzt werden, bis der Test {$a} endet.';
$string['reopenedattemptwillbesubmitted'] = 'Der Versuch wird sofort zur Bewertung eingereicht.';
$string['reorderquestions'] = 'Neuanordnung der Fragen';
$string['reordertool'] = 'Neuanordnung anzeigen';
$string['repaginate'] = 'Seitenumbrüche mit {$a} Fragen pro Seite durchführen';
$string['repaginatecommand'] = 'Seitenumbrüche durchführen';
$string['repaginatenow'] = 'Seitenumbrüche durchführen';
$string['replace'] = 'Ersetze';
$string['replacementoptions'] = 'Erzetzungsoptionen';
$string['report'] = 'Berichte';
$string['reportanalysis'] = 'Ergebnisanalyse';
$string['reportattemptsfrom'] = 'Versuche von';
$string['reportattemptsthatare'] = 'Versuche in diesem Status';
$string['reportdisplayoptions'] = 'Anzeigeoptionen';
$string['reportfullstat'] = 'Ausführliche Statistik';
$string['reportmulti_percent'] = 'Mehrere Prozentsätze';
$string['reportmulti_q_x_student'] = 'Mehrere Teilnehmer/innen';
$string['reportmulti_resp'] = 'Individuelle Antworten';
$string['reportmustselectstate'] = 'Es muss mindest ein Status gewählt werden.';
$string['reportnotfound'] = 'Bericht unbekannt ({$a})';
$string['reportoverview'] = 'Übersicht';
$string['reportregrade'] = 'Testversuche löschen';
$string['reportresponses'] = 'Detailantworten';
$string['reports'] = 'Berichte';
$string['reportshowonly'] = 'Nur Versuche anzeigen';
$string['reportshowonlyfinished'] = 'Max. einen fertigen Versuch pro Teilnehmer/in anzeigen ({$a})';
$string['reportsimplestat'] = 'Einfache Statistik';
$string['reportusersall'] = 'Alle mit Testversuchen';
$string['reportuserswith'] = 'Eingeschriebene Nutzer/innen mit Testversuchen';
$string['reportuserswithorwithout'] = 'Eingeschriebene Nutzer/innen mit oder ohne Testversuch';
$string['reportuserswithout'] = 'Eingeschriebene Nutzer/innen ohne Testversuch';
$string['reportwhattoinclude'] = 'Was in Bericht einbezogen wird';
$string['requirepassword'] = 'Kennwort';
$string['requirepassword_help'] = 'Wenn Sie ein Kennwort festlegen, müssen die Teilnehmer/innen zuerst das Kennwort eingeben, bevor sie den Test starten können.';
$string['requiresubnet'] = 'IP-Adresse';
$string['requiresubnet_help'] = 'Sie können den Testzugriff auf bestimmte Rechner oder IP-Adressen beschränken, wenn z.B. nur Teilnehmer/innen den Test in einem bestimmten Raum durchführen dürfen. Die zugelassenen IP-Adressen geben Sie in einer kommagetrennten Liste teilweise oder vollständig an (z.B. <b>192.168. , 231.54.211.0/20, 231.3.56.211</b>).';
$string['response'] = 'Eingabe';
$string['responses'] = 'Eingaben';
$string['results'] = 'Ergebnisse';
$string['returnattempt'] = 'Zurück zum Versuch';
$string['reuseifpossible'] = 'Wiederverwendung kürzlich entfernt';
$string['reverttodefaults'] = 'Test auf die Voreinstellung zurücksetzen';
$string['review'] = 'Überprüfung';
$string['reviewafter'] = 'Überprüfung erlauben, wenn der Test abgeschlossen ist';
$string['reviewalways'] = 'Überprüfung immer erlauben';
$string['reviewattempt'] = 'Versuch überprüfen';
$string['reviewbefore'] = 'Überprüfung erlauben, solange der Test offen ist';
$string['reviewclosed'] = 'Wenn der Test abgeschlossen ist';
$string['reviewduring'] = 'Während des Versuchs';
$string['reviewimmediately'] = 'Direkt nach dem Versuch';
$string['reviewnever'] = 'Keine Überprüfung erlauben';
$string['reviewofquestion'] = 'Überprüfung der Frage {$a->question} in {$a->quiz} für {$a->user}';
$string['reviewopen'] = 'Später, während der Test noch geöffnet ist';
$string['reviewoptions'] = 'Was sollen die Teilnehmer/innen zu welchem Zeitpunkt überprüfen?';
$string['reviewoptionsheading'] = 'Überprüfungsoptionen';
$string['reviewoptionsheading_help'] = 'Mit diesen Optionen legen Sie fest, welche Informationen angezeigt werden, wenn Teilnehmer/innen einen Versuch überprüfen oder sich den Ergebnisbericht anschauen.

**Während des Versuchs** – Einstellungen sind nur mit gewissen Frageverhalten wie \'Mehrfachbeantwortung\' relevant und steuern zum Beispiel das Feedback im direkten Zusammenhang mit der aktuell bearbeiteten Frage.

**Direkt nach dem Versuch** steuert, was während zwei Minuten, nachdem der Test abgeschickt und beendet wurde, angezeigt wird.

**Später, während der Test noch geöffnet ist** steuert, was danach und vor dem Zeitpunkt der Testschließung angezeigt wird.

**Wenn der Test abgeschlossen ist** – Einstellungen treten nach dem Zeitpunkt der Testschließung in Kraft. Wenn kein Termin für die Testschließung definiert ist, kommt diese Einstellung nie zur Anwendung.';
$string['reviewoverallfeedback'] = 'Gesamtfeedback';
$string['reviewoverallfeedback_help'] = 'Das Feedback wird am Ende des Versuchs gegeben und ist abhängig vom Gesamtergebnis.';
$string['reviewresponse'] = 'Antwort überprüfen';
$string['reviewresponsetoq'] = 'Antwort überprüfen (Frage {$a})';
$string['reviewthisattempt'] = 'Überprüfung der eigenen Antworten dieses Versuchs';
$string['rqp'] = 'Remote-Frage';
$string['rqps'] = 'Remote-Fragen';
$string['sameasoverall'] = 'Genauso wie bei Gesamtbewertung';
$string['save'] = 'Speichern';
$string['saveandedit'] = 'Speichern und Fragen bearbeiten';
$string['saveattemptfailed'] = 'Der derzeitige Testversuch konnte nicht gespeichert werden.';
$string['savedfromdeletedcourse'] = 'Aus dem gelöschten Kurs "{$a}" gespeichert.';
$string['savegrades'] = 'Bewertungen speichern';
$string['savemanualgradingfailed'] = 'Änderung nicht gespeichert. Prüfen Sie bitte die folgende Nachricht und versuchen Sie es erneut.';
$string['savemyanswers'] = 'Meine Antworten auswerten';
$string['savenosubmit'] = 'Zwischenspeichern';
$string['saveoverrideandstay'] = 'Speichern und weitere Änderung anlegen';
$string['savequiz'] = 'Diesen gesamten Test speichern';
$string['saving'] = 'Wird gespeichert';
$string['savingnewgradeforquestion'] = 'Neue Bewertung für Frage-ID {$a} wird gesichert';
$string['savingnewmaximumgrade'] = 'Neue Maximalbewertung wird gesichert';
$string['score'] = 'Punktzahl';
$string['scores'] = 'Punkte';
$string['search:activity'] = 'Test - Aktivitätsinfo';
$string['sectionheadingedit'] = 'Überschrift \'{$a}\' bearbeiten';
$string['sectionheadingremove'] = 'Überschrift \'{$a}\' löschen';
$string['sectionnoname'] = 'Abschnitt ohne Titel';
$string['seequestions'] = '(Siehe Fragen)';
$string['select'] = 'Auswählen';
$string['selectall'] = 'Alle auswählen';
$string['selectattempt'] = 'Versuch auswählen';
$string['selectcategory'] = 'Wählen Sie eine Kategorie';
$string['selectedattempts'] = 'Ausgewählte Versuche ...';
$string['selectmultipleitems'] = 'Mehrere Elemente auswählen';
$string['selectmultipletoolbar'] = '"Mehrere auswählen"-Werkzeuge';
$string['selectnone'] = 'Alle abwählen';
$string['selectquestionslot'] = 'Frage {$a} auswählen';
$string['selectquestiontype'] = '-- Wählen Sie einen Fragentyp --';
$string['serveradded'] = 'Server hinzugefügt';
$string['serveridentifier'] = 'Identifizierung';
$string['serverinfo'] = 'Serverinformation';
$string['servers'] = 'Server';
$string['serverurl'] = 'Server-URL';
$string['shortanswer'] = 'Kurzantwort';
$string['show'] = 'Anzeigen';
$string['showall'] = 'Alle Fragen auf einer Seite anzeigen';
$string['showblocks'] = 'Blöcke bei den Testversuchen anzeigen';
$string['showblocks_help'] = 'Ja bedeutet: die Kursblöcke sind auch während des Testversuchs sichtbar';
$string['showbreaks'] = 'Seitenumbrüche anzeigen';
$string['showcategorycontents'] = 'Kategorie-Inhalte {$a->arrow} anzeigen';
$string['showcorrectanswer'] = 'Beim Feedback die richtigen Antworten anzeigen?';
$string['showdetailedmarks'] = 'Bewertungsdetails anzeigen';
$string['showeachpage'] = 'Seiten einzeln anzeigen';
$string['showfeedback'] = 'Nach dem Antworten das Feedback anzeigen?';
$string['showinsecurepopup'] = 'Browsersicherheit';
$string['showlargeimage'] = 'Großes Bild';
$string['shownoattempts'] = 'Teilnehmer/innen anzeigen, die keine Versuche durchgeführt haben';
$string['shownoattemptsonly'] = 'Nur Teilnehmer/innen anzeigen, die keine Versuche durchgeführt haben';
$string['shownoimage'] = 'Kein Bild';
$string['showreport'] = 'Bericht anzeigen';
$string['showsmallimage'] = 'Kleines Bild';
$string['showteacherattempts'] = 'Versuche der Trainer/innen anzeigen';
$string['showuserpicture'] = 'Nutzerbild anzeigen';
$string['showuserpicture_help'] = 'Wenn diese Option aktiviert ist, werden Name und Profilbild während des Testversuchs und bei der Überprüfung angezeigt. Das macht es einfacher, während einer Prüfung festzustellen, ob Teilnehmer/innen die Prüfung mit ihrem eigenen Account durchführen.';
$string['shuffle'] = 'Mischen';
$string['shuffleanswers'] = 'Antworten mischen';
$string['shuffledrandomly'] = 'Zufälllige Reihenfolge';
$string['shufflequestions'] = 'Fragen mischen';
$string['shufflequestions_help'] = 'Wenn diese Option aktiviert ist, werden die Testfragen in diesem Abschnitt bei jedem Versuch in einer anderen zufälligen Reihenfolge gemischt.

Dies soll verhindern, dass Teilnehmer/innen ihre Antworten untereinander teilen, erschwert aber auch die Diskussion über eine bestimmte Frage mit Trainer/innen.';
$string['shufflewithin'] = 'Antworten innerhalb der Fragen mischen';
$string['shufflewithin_help'] = 'Wenn diese Option aktiviert ist, werden die Elemente, aus welchen sich eine einzelne Frage zusammensetzt, bei jedem Versuch zufällig gemischt, vorausgesetzt, diese Option ist auch in den Einstellungen der Frage aktiviert. Die Funktion hat nur Auswirkungen auf Fragen, die aus mehreren Teilen bestehen, wie Multiple-Choice- oder Zuordnungsfragen.';
$string['singleanswer'] = 'Wählen Sie eine der Antworten.';
$string['sortage'] = 'Sortieren nach Alter';
$string['sortalpha'] = 'Alphabetisch sortieren';
$string['sortquestionsbyx'] = 'Fragen nach {$a} sortieren';
$string['sortsubmit'] = 'Nach Fragen sortieren';
$string['sorttypealpha'] = 'Sortieren nach Typ, Name';
$string['specificapathnotonquestion'] = 'Der angegebene Dateipfad zeigt nicht auf die angegebene Frage';
$string['specificquestionnotonquiz'] = 'Die angegebene Frage kommt nicht im angegebenen Test vor';
$string['startagain'] = 'Erneut starten';
$string['startattempt'] = 'Versuch beginnen';
$string['startedon'] = 'Begonnen';
$string['startnewpreview'] = 'Neue Vorschau beginnen';
$string['stateabandoned'] = 'Nie abgegeben';
$string['statefinished'] = 'Beendet';
$string['statefinisheddetails'] = 'Abgegeben {$a}';
$string['stateinprogress'] = 'In Bearbeitung';
$string['statenotloaded'] = 'Status der Frage {$a} wurde nicht aus der Datenbank geladen';
$string['stateoverdue'] = 'Überfällig';
$string['stateoverduedetails'] = 'Muss abgegeben werden bis {$a}';
$string['status'] = 'Status';
$string['stoponerror'] = 'Bei Fehler anhalten';
$string['submission_confirmation'] = 'Alle Antworten absenden und beenden?';
$string['submission_confirmation_unanswered'] = 'Fragen ohne Antwort: {$a}';
$string['submitallandfinish'] = 'Abgeben';
$string['subneterror'] = 'Der Zugang zum Test wurde beschränkt. Aktuell ist der von Ihnen benutzte Computer nicht freigegeben, um damit den Test durchführen können.';
$string['subnetnotice'] = 'Der Zugang zum Test wurde beschränkt. Aktuell ist der von Ihnen benutzte Computer nicht freigegeben, um damit den Test durchführen können. Als Trainer/in dürfen Sie aber von überall aus zugreifen.';
$string['subplugintype_quiz'] = 'Bericht';
$string['subplugintype_quiz_plural'] = 'Berichte';
$string['subplugintype_quizaccess'] = 'Zugriffsregel';
$string['subplugintype_quizaccess_plural'] = 'Zugriffsregeln';
$string['substitutedby'] = 'wird ersetzt durch';
$string['summaryofattempt'] = 'Zusammenfassung der Versuche';
$string['summaryofattempts'] = 'Ihre Versuche';
$string['temporaryblocked'] = 'Sie können für einige Zeit keinen neuen Versuch durchführen. </br>Machen Sie einen weiteren Versuch ab:';
$string['theattempt'] = 'Versuch';
$string['theattempt_help'] = 'Diese Option bestimmt, ob Teilnehmer/innen ihren Versuch überprüfen dürfen.';
$string['time'] = 'Zeit';
$string['timecompleted'] = 'Beendet';
$string['timedelay'] = 'Bis zum nächsten Testversuch muss einige Zeit verstreichen.';
$string['timeleft'] = 'Verbleibende Zeit';
$string['timelimit'] = 'Zeitbegrenzung';
$string['timelimit_help'] = 'In der Grundeinstellung haben Tests kein Zeitlimit. Mit der Aktivierung des Zeitlimits läuft für die Teilnehmer/innen sichtbar eine Uhr rückwärts mit.';
$string['timelimit_link'] = 'mod/quiz/timing';
$string['timelimitexeeded'] = 'Die Zeit für den Test ist abgelaufen!';
$string['timestr'] = '%H:%M:%S am %d/%m/%y';
$string['timesup'] = 'Zeit ist abgelaufen.';
$string['timetaken'] = 'Verbrauchte Zeit';
$string['timing'] = 'Zeit';
$string['tofile'] = 'zur Datei';
$string['tolerance'] = 'Toleranz';
$string['toomanyrandom'] = 'Die Anzahl der benötigten Zufallsfragen ist größer als die Anzahl der in der Kategorie enthaltenen Fragen! ({$a})';
$string['top'] = 'Spitze';
$string['totalmarks'] = 'Gesamtpunktzahl';
$string['totalmarksx'] = 'Summe der Punkte: {$a}';
$string['totalquestionsinrandomqcategory'] = 'Summe der {$a} Fragen in der Kategorie.';
$string['true'] = 'Wahr';
$string['truefalse'] = 'Wahr/falsch';
$string['type'] = 'Typ';
$string['unfinished'] = 'offen';
$string['ungraded'] = 'Unbewertet';
$string['unit'] = 'Einheit';
$string['unknowntype'] = 'Der Fragetyp in Zeile {$a} wird nicht unterstützt. Die Frage wird ignoriert.';
$string['updatefilterconditon'] = 'Filterbedingungen aktualisieren';
$string['updatefilterconditon_success'] = 'Filterbedingungen erfolgreich aktualisiert';
$string['updateoverdueattemptstask'] = 'Aktualisierung überfälliger Testversuche';
$string['updatequizslotswithrandomxofy'] = 'Test-Slots werden mit \'zufälligen\' Fragendaten aktualisiert ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Testeinstellungen aktualisieren';
$string['updatingatttemptgrades'] = 'Versuchsbewertungen aktualisieren';
$string['updatingfinalgrades'] = 'Endbewertungen aktualisieren';
$string['updatingthegradebook'] = 'Bewertungen werden aktualisiert';
$string['upgradesure'] = '<div>Das Testmodul nimmt eine Reihe von weitreichenden Veränderungen an den Datenbanktabellen vor. Diese Funktion wurde noch nicht sehr umfassend getestet. Sie sollten daher unbedingt eine Sicherung Ihrer Datenbank vornehmen, bevor Sie fortfahren.</div>';
$string['upgradingquizattempts'] = 'Testversuche werden aktualisiert: {$a->done}/{$a->outof} (Test-ID {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Sehr alte Testversuche werden aktualisiert: {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Die Kategorie wurde nach dem Löschen des Kurses verschoben, weil die Fragen noch in anderen Kursen genutzt werden.';
$string['useroverrides'] = 'Nutzeränderungen';
$string['useroverridesdeleted'] = 'Nutzeränderungen gelöscht';
$string['usersnone'] = 'Teilnehmer/innen haben keinen Zugriff auf diesen Test.';
$string['validate'] = 'Gültig';
$string['viewallanswers'] = '{$a} ausgefüllte Tests anzeigen';
$string['viewallreports'] = 'Berichte für {$a} Versuche anzeigen';
$string['viewed'] = 'Angezeigt';
$string['warningmissingtype'] = '<b>Diese Frage ist von einem Typ, der bisher noch nicht in Ihrem Moodle installiert wurde.<br />Bitte fragen Sie Ihren Administrator.';
$string['wheregrade'] = 'Wo ist meine Bewertung?';
$string['wildcard'] = 'Wildcard';
$string['windowclosing'] = 'Das Fenster wird in Kürze geschlossen.';
$string['withsummary'] = 'mit zusammenfassender Statistik';
$string['wronguse'] = 'Sie können diese Seite nicht auf diese Art verwenden.';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Sie können den Test nur durchführen, wenn Sie in diesem Kurs als Teilnehmer/in eingeschrieben sind.';
$string['yourfinalgradeis'] = 'Ihre Gesamtbewertung für diesen Test: {$a}';
