<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'sl', version '4.4'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Dejanja';
$string['activityname'] = 'Ime dejavnosti';
$string['activityname_help'] = 'Besedilo, ki ga mora ime dejavnosti vsebovati ali mu biti enako. Velikost črk ni pomembna.';
$string['activityoresourceis'] = 'Dejavnost ali vir je {$a}';
$string['addacondition'] = 'Dodaj pogoj';
$string['addarule'] = 'Dodaj pravilo';
$string['addinstructions'] = 'Dodaj več informacij';
$string['additionalresources'] = 'Dodatni viri';
$string['addlevel'] = 'Dodaj stopnjo';
$string['addondeactivated'] = 'XP+ onemogočen';
$string['addondeactivatedinfo'] = 'Vtičniki XP niso med seboj združljivi, zaradi česar je bil XP+ onemogočen. Pričakovana je različica {$a->localxpversion} dodatka Level Up XP+ (local_xp)';
$string['addoninstallationerror'] = 'Zaznana je težava z dodatkom (local_xp). Zdi se, da ni pravilno nameščen. Administrator mora zaključiti njegovo namestitev.';
$string['addonnotactivated'] = 'Dodatek ni aktiviran.';
$string['addrulesformhelp'] = 'V zadnjem stolpcu se določi število točk napredka, ki jih udeleženec pridobi, ko uspešno izpolni kriterij.';
$string['admindefaultrulesintro'] = 'Ta pravila bodo uporabljena kot privzeta, ko bo uporabnik dodal blok.';
$string['admindefaultsettingsintro'] = 'Spodnje nastavitve bodo uporabljene kot privzete, ko bo blok na novo dodan v predmet. Nekatere nastavitve je mogoče zakleniti. V tem primeru bodo uporabljene v vseh primerih vtičnika.';
$string['admindefaultvisualsintro'] = 'Nastavljeno bo uporabljeno kot privzeto, ko bo uporabnik na novo dodal blok v predmetu.';
$string['adminnoticeaddondeactivatedmessage'] = 'Level Up XP+ je bil onemogočen!

To obvestilo ste prejeli kot opozorilo, ker je bil Level Up XP+ onemogočen za preprečitev morebitnih težav. Vtičnika Level Up XP (block_xp) in Level Up XP+ (local_xp) trenutno nista združljiva med seboj. Do te težave pride, ko je XP nadgrajen na novo glavno različico, medtem ko XP+ ostane zastarel.

To neskladje lahko povzroči izgubo funkcionalnosti, napake in druge nepričakovane posledice. Za odpravo težave morate nadgraditi Level Up XP+.

- Različica Level Up XP (block_xp): {$a->blockxpversion}
- Različica Level Up XP+ (local_xp): {$a->localxpversion}
- Pričakovana različica Level Up XP+: {$a->localxpversionexpected}

Dodatni viri:
- [Dokumentacija za nadgradnjo](https://docs.levelup.plus/xp/docs/upgrade)
- [Dokumentacija o deaktivaciji XP+](https://docs.levelup.plus/xp/docs/addon-deactivated)
- [Dokumentacija o združljivosti](https://docs.levelup.plus/xp/docs/requirements-compatibility)

--

To obvestilo je bilo poslano vsem skrbnikom. Če želite onemogočiti vsa obvestila za skrbnike, obiščite nastavitve za skrbnike vtičnika Level Up XP.';
$string['adminnoticeaddondeactivatedsubject'] = 'Vtičnik XP+ je onemogočen!';
$string['adminnoticeoutofsyncmessage'] = 'Obvestilo o nezdružljivosti vtičnikov Level Up XP in Level Up XP+!

To obvestilo ste prejeli kot opozorilo, ker sta vtičnika Level Up XP (block_xp) in Level Up XP+ (local_xp) trenutno "neusklajena" in nezdružljiva. Ta težava nastane, ko je XP nadgrajen na novo glavno različico, medtem ko XP+ ostane zastarel.

To neskladje lahko povzroči izgubo funkcionalnosti, napake in druge nepričakovane posledice. Da preprečite težave, morate nadgraditi Level Up XP+.

**Pomembno!** V prihodnje, če bosta ta dva vtičnika neusklajena, se bo Level Up XP+ samodejno onemogočil. V izogib temu pravočasno zagotovite, da ne nadgradite Level Up XP na novo glavno različico brez hkratne nadgradnje Level Up XP+.

- Različica Level Up XP (block_xp): {$a->blockxpversion}
- Različica Level Up XP+ (local_xp): {$a->localxpversion}
- Pričakovana različica Level Up XP+: {$a->localxpversionexpected}

Dodatni viri:

- [Dokumentacija o nadgradnji](https://docs.levelup.plus/xp/docs/upgrade)
- [Dokumentacija o združljivosti](https://docs.levelup.plus/xp/docs/requirements-compatibility)

--

To obvestilo je bilo poslano vsem administratorjem. Če želite onemogočiti vsa skrbniška obvestila, obiščite nastavitve za Level Up XP v skrbniškem vmesniku.';
$string['adminnoticeoutofsyncsubject'] = 'Obvestilo o nezdružljivosti vtičnikov XP!';
$string['adminnotices'] = 'Skrbniška obvestila';
$string['adminnotices_desc'] = 'Ko je omogočeno, lahko skrbniki spletnega mesta občasno prejmejo pomembna obvestila o združljivosti, varnosti in razpoložljivosti novejših različic Level Up XP+.';
$string['adminscanearnxp'] = 'Administratorji lahko prejmejo točke';
$string['adminscanearnxp_desc'] = 'Privzeto administratorji niso vključeni v skupino uporabnikov, ki lahko pridobivajo točke. To je zato, ker imajo administratorji vedno dovoljenje _block/xp:earnxp_, ki jim omogoča neprekinjeno zbiranje točk povsod. To nastavitev lahko uporabite, da omogočite tudi administratorjem pridobivanje točk.';
$string['allcoursesreset'] = 'Vsi predmeti so bili ponastavljeni.';
$string['anonymity'] = 'Anonimnost';
$string['anonymity_help'] = 'Ta nastavitev določa, ali lahko udeleženci vidijo imena in slike drugih uporabnikov.';
$string['apply'] = 'Uporabi';
$string['awardaxpwhen'] = '<strong>{$a}</strong> točk se pridobi, ko:';
$string['badgeaward'] = 'Značka za podelitev';
$string['badgeawarddesc'] = 'Značka, ki se podeli, ko uporabnik doseže stopnjo.';
$string['basepoints'] = 'Izhodiščne točke';
$string['basepointslineardesc'] = 'Najmanjši razkorak med posameznimi stopnjami.';
$string['basepointsrelativedesc'] = 'Število točk na začetku.';
$string['basexp'] = 'Baza algoritma';
$string['blockappearance'] = 'Videz bloka';
$string['blockappearancemovedtopluginsettings'] = 'Nastavitve videza bloka so zdaj na voljo pod nastavitvami vtičnika.';
$string['cachedef_filters'] = 'Filtri za stopnje';
$string['cachedef_metadata'] = 'Metapodatki';
$string['cachedef_ruleevent_eventslist'] = 'Seznam nekaterih dogodkov';
$string['canjoinfromdatex'] = 'Pridružite se lahko od {$a} dalje.';
$string['cannotbesetindefaults'] = 'Tega ni mogoče nastaviti v privzetih vrednostih.';
$string['cannotearnpoints'] = 'Ne more pridobivati točk.';
$string['cannotshowblockconfig'] = 'Tukaj se ponavadi prikažejo nastavitve videza, vendar vašega bloka ni bilo mogoče najti. Če želite spremeniti videz bloka, se vrnite nazaj ({$a}) (ali na mesto, kjer ste dodali blok), vklopite način urejanja in sledite možnosti "Nastavi blok" v spustnem meniju bloka. Če bloka ne najdete, ga dodajte ponovno.';
$string['cannotshowblockconfigsys'] = 'Tukaj se ponavadi prikažejo nastavitve videza, vendar vašega bloka ni bilo mogoče najti. Lahko da ga ni na osnovni strani ({$a->fp}) oziroma na pregledni plošči ({$a->mysys}) uporabnikov ali pa je prisoten na obeh mestih. Če želite urediti nastavitve od tukaj, se prepričajte, da je blok prikazan samo na enem od obeh mest.';
$string['changecourse'] = 'Zamenjaj predmet';
$string['changelevelformhelp'] = 'Če spremenite število stopenj, bodo značke stopenj začasno onemogočene, zato da se preprečijo stopnje z manjkajočimi značkami. Če spremenite število stopenj, pojdite na stran »Videz«, da ponovno omogočite značke po meri, takoj ko shranite ta obrazec.';
$string['changetocourse'] = 'Pojdi na predmet';
$string['changetositewide'] = 'Nazaj na spletno mesto';
$string['cheatguard'] = 'Zaščita pred goljufijami';
$string['cheatguardsettingsmovednotice'] = 'Nastavitve zaščite pred goljufijami so bile premaknjene, [Pravila dogodkov]({$a->url}).';
$string['checkaddoncompatibility'] = 'Združljivost dodatka Level Up XP';
$string['chooseacondition'] = 'Izberi pogoj';
$string['clearfilter'] = 'Počisti filter';
$string['clicktoselectcm'] = 'Kliknite za izbiro dejavnosti ali vira';
$string['cmselector'] = 'Izbirnik modula';
$string['coefxp'] = 'Koeficient algoritma';
$string['colon'] = '{$a->a}: {$a->b}';
$string['comparisonmethod'] = 'Metoda primerjave';
$string['compatibilitycheck'] = 'Test združljivosti';
$string['completionrules'] = 'Pravila zaključevanja';
$string['completionrules_help'] = 'Pravila zaključevanja so razdeljena v tri kategorije: zaključek dejavnosti, zaključek poglavja in zaključek predmeta. Dodajanje pogojev kategorijam bo določilo, kdaj in koliko točk se podeli.

Pravila se ocenjujejo v vrstnem redu, v katerem so prikazana na zaslonu. Takoj, ko je pogoj izpolnjen, se dodelijo ustrezne točke in nadaljnja pravila se ne bodo vrednotila.

[Podrobnosti](https://docs.levelup.plus/xp/docs/completion-rules?ref=blockxp_help)';
$string['completionrulesintro'] = 'Podelitev točk udeležencem, ko zaključijo dejavnosti, poglavja ali predmete.';
$string['completionruleslegacyusednotice'] = 'Imate obstoječa pravila dogodkov, ki že uporabljajo pogoje zaključevanja. Priporočamo, da jih odstranite v korist spodnjih metod, saj lahko uporaba obeh, pravil dogodkov in pravil zaključevanja, podvoji dodeljene točke.';
$string['condition'] = 'Pogoj';
$string['configblockrankingsnapshot'] = 'Prikaži izsek lestvice';
$string['configblockrankingsnapshot_help'] = 'V bloku se bo prikazoval izsek lestvice z uvrstitvijo udeleženca. Izsek bo predvidoma prikazoval še najbližje uvrščena posameznika glede na uporabnika (t. i. soseda). Da ta prikaz deluje, je treba omogočiti lestvico in prikaz rangiranja.';
$string['configdescription'] = 'Uvod';
$string['configdescription_help'] = 'Kratka uvodna predstavitev v bloku, ki se udeležencu prikaže pod trenutno doseženo stopnjo. Udeleženec lahko izključi to sporočilo. V tem primeru se mu ne bo več prikazalo.';
$string['configheader'] = 'Nastavitve';
$string['configrecentactivity'] = 'Prikazuj nedavne dosežke';
$string['configrecentactivity_help'] = 'Če je to omogočeno, potem se bo v bloku prikazoval kratek seznam nedavnih dogodkov, za katere je bil udeleženec nagrajen s točkami napredka.';
$string['configtitle'] = 'Naslov';
$string['configtitle_help'] = 'Naslov bloka.';
$string['congratulationsyouleveledup'] = 'Čestitke!';
$string['coolthanks'] = 'Super, hvala!';
$string['coursea'] = 'Predmet "{$a}"';
$string['courselog'] = 'Dnevnik';
$string['courselogintro'] = 'Dnevnik prikazuje sledena dejanja in število dodeljenih točk.';
$string['coursereport'] = 'Poročilo';
$string['coursereportintro'] = 'Poročilo vsebuje podrobnosti o vsakem udeležencu in omogoča ukrepanje bodisi posamično bodisi za vse skupaj.';
$string['courserules'] = 'Pravila';
$string['courseselectedcolon'] = 'Izbran predmet:';
$string['coursesettings'] = 'Nastavitve predmeta';
$string['coursevisuals'] = 'Videz';
$string['currencysign'] = 'Simbol točk';
$string['currencysign_help'] = 'S to nastavitvijo lahko spremenite pomen točk. Izpisana bo poleg števila točk, ki jih ima vsak uporabnik, kot nadomestilo za omembo izkustvenih točk.

Izberite enega od ponujenih simbolov ali naložite svojega.';
$string['currencysignxp'] = 'XP (izkustvene točke)';
$string['customizelevels'] = 'Prilagodi stopnje';
$string['dangerzone'] = 'Nevarno območje';
$string['dataformat'] = 'Format';
$string['defaultlevels'] = 'Privzete stopnje';
$string['defaultrules'] = 'Privzeta pravila';
$string['defaultrulesformhelp'] = 'To so privzeta pravila, ki jih omogoča vtičnik. Pravila samodejno podajo privzete točke in ignorirajo nekatere odvečne dogodke. Vaša lastna pravila imajo prednost pred njimi.';
$string['defaultsettings'] = 'Privzete nastavitve';
$string['defaultvisuals'] = 'Privzet videz';
$string['deletecondition'] = 'Izbriši pogoj';
$string['deleterule'] = 'Izbriši pravilo';
$string['description'] = 'Opis';
$string['difference'] = 'Razl.';
$string['difficulty'] = 'Metoda izračuna točk';
$string['difficultyflat'] = 'Enakomerno';
$string['difficultyflatdesc'] = 'Vse stopnje zahtevajo enako število točk.';
$string['difficultylinear'] = 'Naraščajoče';
$string['difficultylineardesc'] = 'Postopoma je potrebno več, da se stopnja doseže.';
$string['difficultylinearincrdesc'] = 'Število točk uporabljenih za postopno težavnost.';
$string['difficultypointincrease'] = 'Povečanje točk';
$string['difficultyrelative'] = 'Snežena kepa';
$string['difficultyrelativedesc'] = 'Zahtevnost doseganja stopenj se eksponentno povečuje.';
$string['difficultyrelativeincrdesc'] = 'Odstotek točk za povečanje glede na prejšnjo raven.';
$string['discoverlevelupplus'] = 'Razišči Level Up XP+';
$string['dismissnotice'] = 'Prezri obvestilo';
$string['displayeveryone'] = 'Prikazuj vse';
$string['displaynneighbours'] = 'Prikaži {$a} sos.';
$string['displayoneneigbour'] = 'Prikaži enega soseda';
$string['displayparticipantsidentity'] = 'Prikazuj identitete udeležencev';
$string['displayrank'] = 'Prikaži rang';
$string['displayrelativerank'] = 'Prikaži relativni rang';
$string['documentation'] = 'Dokumentacija';
$string['drops'] = 'Cekini';
$string['drops_help'] = 'V video igrah lahko nekateri liki _odvržejo_ predmete ali točke na tla, da jih igralec pobere. Ti predmeti in točke se lahko imenujejo cekini (angl. drops).

V Level Up XP so cekini kratke kode (npr. `[xpdrop id=1 secret=abcdef]`), ki jih lahko izvajalec postavi v običajno vsebino v Moodlu. Ko udeleženec naleti nanje, bodo ti cekini _pobrani_ in podeljeno mu bo določeno število točk.

Trenutno so cekini uporabnikom nevidni in točke prejmejo pasivno, ko jih prvič srečajo.

Cekine je mogoče uporabiti za pametno dodeljevanje točk skozi spremljanje, kako udeleženec vstopa v interakcijo z določeno vrsto vsebine v Moodlu.
Tukaj je nekaj možnih idej:

- Postavite cekin v povratne informacije Kviza, ki je vidna samo za pravilne rezultate.
- Postavite cekin naključno in globoko v vsebino, da nagradite tiste, ki intenzivno proučujejo vsebino.
- Postavite cekin v zanimivo forumsko razpravo.
- Postavite cekin na težko dostopno stran v dejavnosti Lekcije.

[Več informacij](https://docs.levelup.plus/xp/docs/how-to/use-drops?ref=blockxp_help)';
$string['dropsintro'] = 'Cekini so delčki kode, ki so neposredno postavljeni v vsebino in dajejo točke, ko jih uporabnik sreča.';
$string['editcondition'] = 'Uredi pogoj';
$string['editingdefaultsettingsinwholesitemodenotice'] = '**Pozor!** Ne spreminjate trenutno aktivnih nastavitev, ampak privzete vrednosti. Ker se Level Up XP uporablja na celotnem spletnem mestu, je vaš namen najverjetneje spremeniti nastavitve na celotnem spletnem mestu. [Pomaknite se sem]({$a->url}), če želite spremeniti te nastavitve, ali sledite povezavi "Nastavitve" v samem bloku XP.';
$string['editinstructions'] = 'Uredi informacije';
$string['enablecheatguard'] = 'Vključi zaščito pred goljufijami';
$string['enablecheatguard_help'] = 'Zaščita pred goljufijami ponuja preprost brezplačen mehanizem, ki preprečuje zlorabo sistema z uporabo očitnih tehnik udeležencev, kot je nenehno osveževanje iste strani ali ponavljanje istega dejanja.

[Več informacij](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Omogoči stran z informacijami';
$string['enableinfos_help'] = 'Ko je izbrano "Ne", stran z informacijami udeležencem ne bo prikazana.';
$string['enableladder'] = 'Omogoči lestvico';
$string['enableladder_help'] = 'Ko je nastavljeno na "Ne", lestvica udeležencem ne bo prikazana.';
$string['enablelevelupnotif'] = 'Omogoči obveščanje o napredovanju';
$string['enablelevelupnotif_help'] = 'Ko je nastavljeno na »Da«, bo ob napredovanju na višjo stopnjo udeležencem prikazano pojavno okno s čestitkami.';
$string['enablelogging'] = 'Omogoči beleženje';
$string['enablexpgain'] = 'Omogoči pridobivanje točk';
$string['enablexpgain_help'] = 'Ko je nastavljeno na \'Ne\', je udeležencem onemogočeno pridobivanje točk. Ta nastavitev je koristna, kadar želimo zamrzniti stanje pridobljenih točk v določenem trenutku ali omogočiti pridobivanje točk v določenem terminu.

Prosimo, upoštevajte, da je pridobivanje točk mogoče nadzorovati tudi z uporabo možnosti _block/xp:earnxp_.';
$string['entersearchterm'] = 'Vnesite iskalni niz';
$string['envcheckaddonincompatibilitymessage'] = 'Vtičnik Level Up XP+ (local_xp) ni združljiv z vtičnikom Level Up XP (block_xp). Zaradi tega bo XP+ onemogočen. Da to preprečite, prosimo nadgradite oba vtičnika. Za več informacij obiščite:
https://docs.levelup.plus/xp/docs/compatibility';
$string['erroraddondeactivated'] = 'Level Up XP+ je bil onemogočen. Za več informacij si oglejte [dokumentacijo]({$a->docsurl}).';
$string['errorcontextcoursemismatchforwholesite'] = 'URL te <em>Level Up XP</em> strani se ne ujema s trenutno konfiguracijo vtičnika. Vaša trenutna konfiguracija zahteva, da je <em>Level Up XP</em> uporabljen na nivoju \'celotnega spletnega mesta\', vendar ta stran pričakuje uporabo vtičnika na nivoju \'predmeta\'. Kliknite <a href="{$a->nexturl}">tukaj</a> za premik na ustrezno stran. Konfiguracijo uredi administrator s spremembo nastavitve \'block_xp_context\'.';
$string['errorcontextcoursemismatchpercourse'] = 'URL te <em>Level Up XP</em> strani se ne ujema s trenutno konfiguracijo vtičnika. Vaša trenutna konfiguracija zahteva, da je <em>Level Up XP</em> uporabljen na nivoju "predmeta", vendar ta stran pričakuje uporabo vtičnika na nivoju "celotnega spletnega mesta". Težava najverjetneje izvira iz <em>bloka</em>, ki je bil dodan na pregledno ploščo ali domačo stran, medtem, ko je bila v uporabi drugačna konfiguracija. Blok je treba odstraniti z omenjenih strani in ga uporabiti samo znotraj posameznih predmetov.';
$string['errorformvalues'] = 'Obstaja nekaj težav z vrednostmi v obrazcu. Prosimo, popravite jih.';
$string['errorlevelsincorrect'] = 'Najmanjše število stopenj je 2';
$string['errornotalllevelsbadgesprovided'] = 'Vse značke stopenj niso bile podane. Manjkajoče število značk: {$a}';
$string['errorunknownevent'] = 'Napaka: neznani dogodek';
$string['errorunknownmodule'] = 'Napaka: neznana aktivnost';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Število zahtevanih točk je manjše ali enako prejšnji stopnji.';
$string['event_user_leveledup'] = 'Uporabnik je napredoval';
$string['eventis'] = 'Dogodek je {$a}';
$string['eventname'] = 'Ime dogodka';
$string['eventproperty'] = 'Lastnost dogodka';
$string['eventsrules'] = 'Pravila dogodkov';
$string['eventsrules_help'] = 'Ta vtičnik uporablja atribute dogodkov za pripisovanje točk dejanjem udeležencev.
Uporabite spodnji obrazec za dodajanje svojih pravil ali spreminjanje privzetih pravil.

Priporočljivo je, da preverite stran _Log_, da ugotovite, kateri dogodki se sprožijo, ko udeleženci izvajajo dejanja v predmetu.

Dodatni viri:

- [Kako se izračunajo točke?](https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Odpravljanje težav pri pravilih](https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventsrulesintro'] = 'Opazujte dejanja in dodeljujte točke udeležencem, ko jih izvajajo.';
$string['eventtime'] = 'Čas dogodka';
$string['export'] = 'Izvoz';
$string['exportdata'] = 'Izvoz podatkov';
$string['filterbyuser'] = 'Uporabniški filter';
$string['filterellipsis'] = 'Filter ...';
$string['filtermodules'] = 'Filtriraj module';
$string['filterparticipants'] = 'Filtriraj uporabnike';
$string['for1day'] = 'Za 1 dan';
$string['for1month'] = 'Za 1 mesec';
$string['for1week'] = 'Za 1 teden';
$string['for3days'] = 'Za 3 dni';
$string['forever'] = 'Za vedno';
$string['forthewholesite'] = 'Za celotno spletno mesto';
$string['give'] = 'daj';
$string['gotofullladder'] = 'Pojdi na celotno lestvico';
$string['graderules'] = 'Pravila ocen';
$string['graderules_help'] = 'Udeleženci bodo prejeli toliko točk, kolikor znaša njihova ocena.
Ocena 5/10 in ocena 5/100 bosta udeležencu prinesli 5 točk.
Če se ocena udeleženca večkrat spremeni, bo prejel točke enake najvišji oceni, ki jo je dosegel.
Udeležencem se točke nikoli ne odvzamejo, negativne ocene pa se ignorirajo.

Primer: Alice odda nalogo in prejme oceno 40/100. V _Level Up XP_ Alice prejme 40 točk za svojo oceno.
Alice ponovno odda svojo nalogo, vendar je tokrat njena ocena znižana na 25/100. Alicine točke v Level Up XP ostanejo nespremenjene.
Ob njenem zadnjem poskusu Alice doseže 60/100 in prejme dodatnih 20 točk v _Level Up XP_. Skupno število njenih točk je 60.

[Več v dokumentaciji _Level Up XP_](https://docs.levelup.plus/xp/docs/how-to/grade-based-rewards?ref=blockxp_help)';
$string['graderulesintro'] = 'Pravila ocen omogočajo uporabnikom, da prejmejo točke, ki so enake ocenam, ki jih prejmejo.';
$string['grid'] = 'Mreža';
$string['hasbadgeaward'] = 'Značka za podelitev nastavljena';
$string['hasdescription'] = 'Opis nastavljen';
$string['hasname'] = 'Ime nastavljeno';
$string['hasnobadgeaward'] = 'Ni značke za podelitev';
$string['hasnodescription'] = 'Ni opisa';
$string['hasnoname'] = 'Ni imena';
$string['hasnopopupmessage'] = 'Ni pojavnega sporočila';
$string['haspopupmessage'] = 'Pojavno sporočilo nastavljeno';
$string['hideparticipantsidentity'] = 'Skrij identitete udeležencev';
$string['hiderank'] = 'Skrij rang';
$string['importpoints'] = 'Uvozi točke';
$string['importpoints_help'] = 'Uvoz se lahko uporabi za _povečanje_ točk udeležencem ali za njihovo _preglasitev_ s podano vrednostjo.

Upoštevajte, da uvoz __ne__ uporablja iste oblike kot izvoženo poročilo. Zahtevana oblika je opisana v [dokumentaciji](https://docs.levelup.plus/xp/docs/how-to/import-points/importing-points-from-csv?ref=localxp_help), kjer je na voljo tudi [vzorec datoteke](https://docs.levelup.plus/xp/docs/how-to/import-points/importing-points-from-csv?ref=localxp_help#sample-file).';
$string['importpointsintro'] = 'Uvozite točke iz datoteke CSV in po želji pošljite sporočilo prejemniku.';
$string['incourses'] = 'V predmetih';
$string['ineffective'] = 'Neučinkovito';
$string['infos'] = 'Informacije';
$string['infos_help'] = 'Stran z informacijami udeležencem ponuja pregled stopenj in točk, potrebnih za njihovo dosego. Prav tako prikazuje ime vsake stopnje ter njen opis.';
$string['infosintro'] = 'Stran z informacijami prikazuje seznam stopenj in nekatere njihove podrobnosti.';
$string['installed'] = 'Nameščeno';
$string['instructions'] = 'Navodila';
$string['instructions_help'] = 'Navodila bodo prikazana na strani z informacijami. Uporabite jih lahko za zapis informacij in navodil glede stopenj, pridobivanja točk itd.';
$string['invalidxp'] = 'Neveljavne vrednosti točk';
$string['join'] = 'Pridruži se';
$string['joinleadeboardconfirmnote'] = 'Odlično, veseli nas, da ste z nami!

Prosimo, upoštevajte, da po pridružitvi velja čakalno obdobje, preden lahko zapustite lestvico, če si premislite.';
$string['joinleadeboardlockednote'] = 'Lestvici se ne morete pridružiti.';
$string['joinleaderboard'] = 'Pridruži se lestvici';
$string['keeplogs'] = 'Beleži dogodke';
$string['ladder'] = 'Lestvica';
$string['ladder_help'] = 'Lestvica razvršča udeležence glede na njihove točke. Ko se uporablja znotraj predmeta skupaj s skupinami, lahko ustvari razvrstitev za vsako skupino udeležencev.

Na voljo je več možnosti za prilagoditev lestvice, kar ustvarja različne izkušnje za udeležence.';
$string['ladderadditionalcols'] = 'Dodatni stolpci';
$string['ladderadditionalcols_help'] = 'Ta nastavitev določa, kateri dodatni stolpci naj bodo prikazani na lestvici. Pritisnite in držite tipko CTRL ali CMD, da izberete več možnih stolpcev, ali da prekličete izbiro stolpca.';
$string['ladderempty'] = 'Lestvica je trenutno prazna. Vrni se kasneje.';
$string['ladderintro'] = 'Lestvica prikazuje razvrstitev posameznikov glede na skupno število točk.';
$string['ladderiso'] = 'Izoliraj udeležence';
$string['ladderiso_help'] = 'Ustvari ločene lestvice za različne skupine.

- Privzeto (skupinski način): Sledi skupinskemu načinu predmeta za ustvarjanje lestvic za vsako skupino.
- Z uporabo kohort: Na lestvici posameznika se bodo pojavili le člani iste kohorte.

[Več informacij](https://docs.levelup.plus/xp/docs/leaderboard-isolation)';
$string['ladderisocohorts'] = 'Z uporabo kohort';
$string['ladderisodefault'] = 'Privzeto (skupinski način)';
$string['ladderparticipation'] = 'Sodelovanje';
$string['ladderparticipation_help'] = 'Določa, ali se od uporabnikov pričakuje, da sodelujejo na lestvici, ali pa se lahko pridružijo oziroma jo zapustijo po lastni izbiri.

- Samodejno, brez možnosti izstopa: Vsi uporabniki se lestvici pridružijo samodejno in je ne morejo zapustiti.
- Samodejno, z možnostjo izstopa: Vsi uporabniki se lestvici pridružijo samodejno, vendar jo lahko zapustijo.
- Izbirno, s prijavo: Uporabniki se morajo izrecno pridružiti lestvici, če želijo sodelovati.

Uporabniki si lahko premislijo ter se po izstopu znova pridružijo ali izstopijo iz lestvice. Vendar pa iz praktičnih razlogov in uporabniške izkušnje uporabniki po pridružitvi k lestvici tri dni ne morejo izstopiti.

[Več informacij](https://docs.levelup.plus/xp/docs/leaderboard-opt-out)';
$string['ladderparticipationforced'] = 'Samodejno, brez možnosti izstopa';
$string['ladderparticipationoptin'] = 'Izbirno, s prijavo';
$string['ladderparticipationoptout'] = 'Samodejno, z možnostjo izstopa';
$string['ladderparticipationreset'] = 'Izbriši status sodelovanja vseh.';
$string['ladderparticipationreset_help'] = 'Ob izbiri bo izbrisan status sodelovanja vseh uporabnikov. Uporabniki bodo morali znova izbrati sodelovanje.';
$string['laddersettingsmovednotice'] = 'Nastavitve lestvice so bile premaknjene na [stran Lestvica]({$a->url}).';
$string['learnmore'] = 'Izvedite več';
$string['leave'] = 'Zapusti';
$string['leaveleadeboardconfirmnote'] = 'Ali ste prepričani, da želite zapustiti lestvico?

Ko jo zapustite, izgubite dostop do razvrstitve, vendar se lahko kasneje vedno znova pridružite, če si premislite.';
$string['leaveleadeboardlockednote'] = 'Lestvice ne morete zapustiti.';
$string['leaveleadeboardlockeduntilnote'] = 'Lestvice ne morete zapustiti do {$a}.';
$string['leaveleaderboard'] = 'Zapusti lestvico';
$string['level'] = 'Stopnja';
$string['levelbadge'] = 'Značka stopnje';
$string['levelbadges'] = 'Značke stopenj';
$string['levelbadges_help'] = 'Naložite slike, da nadomestite videz posameznih stopenj.

Datoteke morajo biti poimenovane [stopnja].[format], na primer 1.png, 2.jpg itd.

Priporočamo slike velikosti 100x100 slikovnih pik, v katerem koli od naslednjih formatov: GIF, JPEG, PNG in SVG.';
$string['levelbadgesformhelp'] = 'Poimenujte datoteke: [številka stopnje].[format], na primer: 1.png, 2.jpg ... Priporočljiva velikost slike je 100x100.';
$string['levelcount'] = 'Število stopenj';
$string['leveldesc'] = 'Opis stopnje';
$string['leveldesc_help'] = 'Kratek opis stopnje, ki bo prikazan na strani z informacijami poleg stopnje. Opišemo lahko nagrado ob doseženi stopnji; posredujemo navodila, kako doseči stopnjo; opišemo stopnjo na igriv način (npr. _Samo najbolj pogumne duše lahko dosežejo to stopnjo._) itd.';
$string['leveldescriptiondesc'] = 'Kratek opis stopnje, prikazan na strani z informacijami.';
$string['levelname'] = 'Ime stopnje';
$string['levelname_help'] = 'Kratko ime stopnje, ki se prikaže namesto privzetih imen: _Stopnja # 1_, _Stopnja # 2_ itd. V kolikor želite preimenovati imena stopenj, vam priporočamo, da to naredite za vse uporabljene stopnje.';
$string['levelpointslength'] = 'Dolžina';
$string['levelpointsstart'] = 'Začetek';
$string['levels'] = 'Stopnje';
$string['levelsappearance'] = 'Videz stopenj';
$string['levelssaved'] = 'Stopnje so bile shranjene.';
$string['levelswillbereset'] = 'Opozorilo! Če boste shranili ta obrazec, se bodo ponovno izračunale stopnje vseh udeležencev.';
$string['levelup'] = 'Nova stopnja!';
$string['levelupoptionsunavailableforlevelone'] = 'Možnosti povezane z doseganjem stopenj niso na voljo za prvo stopnjo.';
$string['levelupplus'] = 'Level Up XP+';
$string['levelx'] = 'Stopnja #{$a}';
$string['likenotice'] = '<strong>Vam je vtičnik všeč?</strong> Prosimo, vzemite si trenutek, <a href="{$a->moodleorg}" target="_blank">dodajte ga med priljubljene</a> na strani Moodle.org in <a href="{$a->github}" target="_blank">ocenite na GitHubu</a>.';
$string['limitparticipants'] = 'Omejitev prikaza udeležencev';
$string['limitparticipants_help'] = 'Ta nastavitev nadzoruje, kdo je prikazan na lestvici. Sosedje so udeleženci, uvrščeni nad in pod trenutnim uporabnikom. Na primer, ko izberete »Prikaži 2 sos.«, bosta prikazana samo dva soseda: udeleženec, ki je uvrščen neposredno nad in neposredno pod uporabnikom.';
$string['list'] = 'Seznam';
$string['logging'] = 'Beleženje';
$string['manually'] = 'Ročno';
$string['maxactionspertime'] = 'Maks. število dejanj v časovnem okvirju';
$string['maxactionspertime_help'] = 'Največje število dejanj, ki bodo prispevala točke v danem časovnem okvirju. Vsako nadaljnje dejanje bo prezrto. Če je ta vrednost prazna ali enaka nič, nima vpliva.';
$string['maxlevelexcl'] = 'najvišja stopnja!';
$string['menu'] = 'Meni';
$string['messageprovider:adminnotice'] = 'Skrbniško obvestilo';
$string['missing'] = 'Manjka';
$string['movecondition'] = 'Premakni pogoj';
$string['moverule'] = 'Premakni pravilo';
$string['name'] = 'Ime';
$string['namecontains'] = 'Vključuje "{$a}"';
$string['nameequalsto'] = 'Je enako "{$a}"';
$string['navbardisplay'] = 'Prikaži v navigacijski vrstici';
$string['navbardisplay_desc'] = 'Ko je omogočeno, bo stopnja uporabnika prikazana v zgornji navigacijski vrstici. Če je vtičnik uporabljen na nivoju »predmetov«, bo prikazano samo znotraj predmetov. Upoštevajte, da je ta funkcija močno odvisna od teme in morda ne bo delovala dobro ali sploh ne bo delovala v kombinaciji z nestandardno temo. [Več o tem](https://docs.levelup.plus/xp/docs/navbar-display)';
$string['navcompletionrules'] = 'Zaključevanje';
$string['navdrops'] = 'Cekini';
$string['naveventrules'] = 'Pravila dogodkov';
$string['navgraderules'] = 'Pravila ocen';
$string['navimport'] = 'Uvoz';
$string['navinfos'] = 'Informacije';
$string['navladder'] = 'Lestvica';
$string['navlevels'] = 'Stopnje';
$string['navlevelssetup'] = 'Nastavitve';
$string['navlog'] = 'Dnevnik';
$string['navpoints'] = 'Točke';
$string['navpromo'] = 'XP+';
$string['navreport'] = 'Poročilo';
$string['navrules'] = 'Pravila';
$string['navsettings'] = 'Nastavitve';
$string['navvisuals'] = 'Videz';
$string['newversioninstallednotice'] = 'Nameščena je bila nova različica! Oglejte si, kaj je novega v [opombah ob izdaji]({$a->releasenotesurl}).';
$string['nextlevelin'] = 'naslednja stopnja čez';
$string['noconditionsyet'] = 'Pogojev še ni!';
$string['noconditionsyetintro'] = 'Pričnite z dodajanjem pogojev.';
$string['nodescription'] = 'Ni opisa';
$string['noissuesidentified'] = 'Ni zaznanih težav';
$string['nologsrecordedyet'] = 'Ni dnevniških zapisov.';
$string['noname'] = 'Ni imena';
$string['noneareavailable'] = 'Niso na voljo.';
$string['notecompatibilityissues'] = 'Prosimo, upoštevajte spodaj navedene težave s kompatibilnostjo:';
$string['notesomesettingslocked'] = 'Nekaterih nastavitev morda ni mogoče urejati, če jih je skrbnik zaklenil.';
$string['nothingmatchesfilter'] = 'Nič ne ustreza filtru.';
$string['notparticipating'] = 'Ne sodeluje';
$string['notranked'] = 'Ni uvrščen';
$string['numberoflevels'] = 'Število stopenj';
$string['occasionally'] = 'Občasno';
$string['onlyparticipantscanaccessranking'] = 'Dostop do uvrstitev je omogočen samo tistim, ki sodelujejo na lestvici.';
$string['outofsync'] = 'Nezdružljivost vtičnikov XP';
$string['outofsyncexcessive'] = 'Neusklajeno - kritično';
$string['outofsyncexcessiveinfo'] = 'XP+ je občutno starejši od XP, kar lahko povzroči nepričakovane težave. V prihodnje se bo XP+ samodejno onemogočil.';
$string['outofsyncinfo'] = 'Vtičnika XP nista združljiva, kar lahko povzroči nepričakovane težave. V prihodnje se bo XP+ samodejno onemogočil. Pričakovana različica za Level Up XP+ (local_xp) je {$a->localxpversion} .';
$string['pagecurrentnotvisibletoviewers'] = 'Ta stran trenutno ni vidna udeležencem.';
$string['pagecurrentvisibletoviewers'] = 'Ta stran je trenutno vidna udeležencem.';
$string['pagesettings'] = 'Nastavitve strani';
$string['participant'] = 'Udeleženec';
$string['participants'] = 'Udeleženci';
$string['participatesinleaderboard'] = 'Sodeluje na lestvici.';
$string['participatesnotinleaderboard'] = 'Ne sodeluje na lestvici.';
$string['participatetolevelup'] = 'Sodelujte, pridobite točke in napredujte po stopnjah!';
$string['participating'] = 'Sodeluje';
$string['perpagecolon'] = 'Na stran:';
$string['pickaconditiontype'] = 'Izberi tip pogoja';
$string['pluginavailabilityxpdesc'] = 'Ta vtičnik omogoča izvajalcem, da omejijo dostop do virov/dejavnosti glede na doseženo stopnjo udeležencev.';
$string['pluginenrolxpdesc'] = 'Ta vtičnik omogoča samodejni vpis v predmete glede na doseženo stopnjo v drugem predmetu.';
$string['pluginname'] = 'Level Up XP';
$string['pluginshortcodesdesc'] = 'Ta vtičnik omogoča izvajalcem, da prilagodijo svoja gradiva tako, da v vsebino vključijo elemente, povezane z XP (točke, stopnja, lestvica …), pa tudi skrijejo ali prikažejo vsebino glede na stopnjo udeleženca.';
$string['pluginsoutofsync'] = '__XP vtičniki niso združljivi! __

Med vtičnikoma Level Up XP in Level Up XP+ so zaznane težave z združljivostjo. V prihodnje se bo Level Up XP+ samodejno onemogočil, če ne bo združljiv. Da to preprečite, se obrnite na skrbnika spletnega mesta. [Preberite več]({$a->url})';
$string['pluginxmaybeincompatible'] = 'Ta različica {$a->name} ({$a->component}) je morda nezdružljiva s sistemom Moodle {$a->version}.';
$string['pointsintimelinker'] = 'na';
$string['pointsperlevel'] = 'Točke na stopnjo';
$string['pointsrequired'] = 'Zahtevane točke';
$string['pointstoaward'] = 'Možne točke';
$string['pointstoaward_help'] = 'Število točk, ki se podelijo, ko je pogoj izpolnjen.';
$string['popupnotificationmessage'] = 'Pojavno obvestilo s sporočilom';
$string['popupnotificationmessagedesc'] = 'Neobvezno sporočilo za prikaz v pojavnem obvestilu, ki čestita uporabniku za dosego stopnje.';
$string['potentialmoodleincompatibility'] = 'Možna nezdružljivost z Moodlom';
$string['previewpopupnotification'] = 'Predogled pojavnega obvestila';
$string['privacy:metadata:log'] = 'Shranjuje dnevnik dogodkov';
$string['privacy:metadata:log:eventname'] = 'Ime dogodka';
$string['privacy:metadata:log:time'] = 'Datum dogodka';
$string['privacy:metadata:log:userid'] = 'Uporabnik, ki je pridobil točke';
$string['privacy:metadata:log:xp'] = 'Točke, ki so bile podeljene za dogodek';
$string['privacy:metadata:prefintro'] = 'Evidenca, ali je uporabnik prezrl uvodno obvestilo bloka';
$string['privacy:metadata:prefladderpagesize'] = 'Najpogosteje uporabljena velikost strani uporabnikov pri ogledu lestvice';
$string['privacy:metadata:preflevelup'] = 'Evidenca, ali naj se uporabniku prikazujejo obvestila o napredovanju na novo stopnjo';
$string['privacy:metadata:prefnotices'] = 'Evidenca, ali je uporabnik zaprl obvestilo podpore';
$string['privacy:metadata:prefseenpromo'] = 'Evidenca, kdaj si je uporabnik ogledal predstavitveno stran';
$string['privacy:metadata:xp'] = 'Shranjuje točke in stopnje uporabnikov';
$string['privacy:metadata:xp:lvl'] = 'Dosežena stopnja uporabnika';
$string['privacy:metadata:xp:userid'] = 'Uporabnik';
$string['privacy:metadata:xp:xp'] = 'Dosežene točke uporabnika';
$string['privacy:path:addon'] = 'Dodatek';
$string['privacy:path:level'] = 'Stopnja';
$string['privacy:path:logs'] = 'Dnevniki';
$string['progress'] = 'Napredek';
$string['progressbar'] = 'Vrstica napredka';
$string['promocheatguard'] = 'Zaščita pred goljufijami ni zasnovana za daljše časovne okvire. Razmislite o nadgradnji na <em>Level Up XP+</em> za omogočanje večjih časovnih okvirov in drugih funkcij. <a href="{$a->url}">Več o tem preberite tukaj</a>.';
$string['promocontactintro'] = 'Za več informacij nas kontaktirajte.';
$string['promocontactus'] = 'Stopite v stik';
$string['promoemailusat'] = 'Pošljite nam e-pošto na _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ups! Sporočila ni bilo mogoče poslati ... Prosimo, pišite nam neposredno na: {$a}. Hvala!';
$string['promogetnow'] = 'Pridobite XP+ zdaj!';
$string['promoifpreferemailusat'] = 'Pst! Če vam je ljubše, nam pošljite e-pošto neposredno na _{$a}_.';
$string['promointro'] = 'Spoznajte nadgradnjo Level Up XP. Odklenite dodatne funkcije z Level Up XP+!';
$string['promointroinstalled'] = 'Dodatek _Level Up XP+_ je nameščen v vašem sistemu in vse njegove funkcije so omogočene.';
$string['promorulesdidyouknow'] = 'Ste vedeli, da lahko udeleženci z <em>Level Up XP+</em> prejmejo točke za <em>zaključek predmeta</em>, <em>zaključek dejavnosti/virov</em> in tudi na podlagi prejetih <em>ocen</em>? <a href="{$a->url} ">Odkrijte več tukaj</a>.';
$string['promoyourmessagewassent'] = 'Hvala. Vaše sporočilo je bilo poslano. Odgovorili vam bomo v najkrajšem možnem času.';
$string['property:action'] = 'Dejanje dogodka';
$string['property:component'] = 'Komponenta dogodka';
$string['property:crud'] = 'CRUD dogodka';
$string['property:eventname'] = 'Ime dogodka';
$string['property:target'] = 'Cilj dogodka';
$string['provisionstates'] = 'Samodejno dodeljevanje uporabnikov';
$string['provisionstates_desc'] = 'Privzeto se uporabniki pojavijo na lestvici (in v poročilu v načinu za celotno spletno mesto) šele potem, ko jih XP zazna. Samodejno dodeljevanje uporabnikov je napredna možnost, ki samodejno ustvari vnose za manjkajoče uporabnike, ki so okvirno prepoznani glede na njihovo vlogo. To se izvaja periodično prek načrtovanega opravila, ki se privzeto izvaja enkrat dnevno. [Več informaci](https://docs.levelup.plus/xp/docs/automatic-user-provisioning)';
$string['questpromonotice'] = 'Popeljite gamifikacijo na višjo raven, odkrijte [Level Up Quest]({$a->questurl}).';
$string['questreleasenotice'] = '🎉 Z veseljem izpostavljamo naš **nov vtičnik za igrifikacijo**, imenovan **Level Up Quest**   . Spremenite svoje predmete v **razburljive pustolovščine**, polne **aktivirajočih strategij** in **zmagoslavja** 🤯! Oglejte si [Questovo spletno mesto]({$a->questurl}) in našo [objavo ob izdaji]({$a->questblogurl}). 👈';
$string['quickeditpoints'] = 'Hitro urejanje točk';
$string['rank'] = 'Rang';
$string['ranked'] = 'Uvrščen';
$string['ranking'] = 'Rangiranje';
$string['ranking_help'] = 'Rang je absolutni položaj trenutnega uporabnika na lestvici. Relativni rang je razlika v točkah napredka med uporabnikom in njegovimi sosedi.';
$string['reallydeleteuserstate'] = 'Brisanje uporabnika je namenjeno le temu, da uporabnika odstranite z lestvice. Za druge namene vam priporočamo, da nastavite njegove točke na 0. Upoštevajte, da brisanje ne vpliva na možnost ponovnega pridobivanja točk.

Pomembno! Pri uporabi _Level Up XP_ na nivoju celotnega spletnega mesta, brisanje uporabnika povzroči izbris iz poročila, kar pomeni, da ponovni pripis točk ni možen. Če uporabljate _Level Up XP_ na nivoju predmeta, se lahko udeleženec ponovno pojavi v poročilu, če je vpisan v ta predmet.

Ali res želite izbrisati točke tega uporabnika?';
$string['reallydeleteuserstateandlogs'] = 'Če izbrišete uporabnika, ga odstranite z lestvice in odstranite vse z njim povezane dnevniške zapise.

Odstranjevanje dnevniških zapisov lahko uporabniku omogoči, da ponovno prejme točke za pretekla dejanja. Če želite uporabniku zgolj ponastaviti točke, priporočamo, da točke namesto tega nastavite na 0. Upoštevajte, da brisanje uporabnika ne vpliva na možnost ponovnega pridobivanja točk.

Pomembno! V primeru uporabe _Level Up XP_ na nivoju celotnega spletnega mesta brisanje vpliva na izbris iz poročila, kar pomeni, da uporabnikom v tem primeru ne boste mogli znova dodeliti točk. Če pa uporabljate _Level Up XP_ na nivoju predmeta, se bo udeleženec morda še vedno pojavil v poročilu, če je vpisan v ta predmet.

Ali res želite izbrisati točke in dnevnike tega uporabnika?';
$string['reallyresetallcourselevelstodefaults'] = 'Ste prepričani, da želite ponastaviti VSE STOPNJE predmetov na privzete stopnje? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetallcoursestodefaults'] = 'Ste prepričani, da želite ponastaviti PRAVILA VSEH predmetov na privzete nastavitve? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetallcoursevisualstodefaults'] = 'Ste prepričani, da želite ponastaviti VSE VIDEZE STOPENJ v predmetih na privzete nastavitve? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetcourselevelstodefaults'] = 'Ali res želite ponastaviti stopnje predmeta na privzete stopnje? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetcourserulestodefaults'] = 'Ste prepričani, da želite ponastaviti pravila tega predmeta na privzete nastavitve? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetcoursevisualstodefaults'] = 'Ste prepričani, da želite ponastaviti videz stopenj predmeta na privzeti videz? Tega dejanja ni mogoče razveljaviti.';
$string['reallyresetdata'] = 'Ste prepričani, da želite ponastaviti dosežene stopnje in točke vseh udeležencev v tem predmetu?';
$string['reallyresetgroupdata'] = 'Ste prepričani, da želite ponastaviti dosežene stopnje in točke vseh udeležencev v tej skupini?';
$string['reallyreverttopluginsdefaults'] = 'Ste prepričani, da želite ponastaviti privzeta pravila na privzete nastavitve vtičnika? Tega dejanja ni mogoče razveljaviti.';
$string['recentrewards'] = 'Nedavni dosežki';
$string['recommended'] = 'Priporočeno';
$string['recommendedplugins'] = 'Priporočeni vtičniki';
$string['releasenotes'] = 'Opombe ob izdaji';
$string['remaining'] = 'preostaja';
$string['removefilter'] = 'Odstrani filter';
$string['reportisempty'] = 'Poročilo je prazno. Udeleženci še niso pridobili točk.';
$string['reportisemptyenrolstudents'] = 'Poročilo je prazno. So udeleženci vključeni v ta predmet?';
$string['requires'] = 'Zahteva';
$string['resetallcoursestodefaults'] = 'Ponastavi vse predmete na privzete nastavitve';
$string['resetallcoursestodefaultsintro'] = 'Kliknite spodnji gumb, da ponastavite vse predmete na zgornje privzete nastavitve.';
$string['resetcoursedata'] = 'Ponastavi podatke predmeta';
$string['resetcourserulestodefaults'] = 'Ponastavi pravila predmeta na privzete nastavitve';
$string['resetgroupdata'] = 'Ponastavi podatke skupine';
$string['resetladderparticiptionofeveryone'] = 'Ponastavi status sodelovanja vseh uporabnikov';
$string['resetlevelstodefaults'] = 'Ponastavi stopnje na privzete nastavitve';
$string['resettodefaults'] = 'Ponastavi na privzete vrednosti';
$string['resetvisualstodefaults'] = 'Ponastavi videz na privzete nastavitve';
$string['resultsfilteredforn'] = 'Filtrirani rezultati za {$a}.';
$string['reverttopluginsdefaults'] = 'Povrni privzete nastavitve vtičnika';
$string['reverttopluginsdefaultsintro'] = 'Uporabite spodnji gumb, če želite, da se zgornje privzete vrednosti vrnejo na privzete nastavitve vtičnika. To ne vpliva na pravila obstoječih predmetov.';
$string['reward'] = 'Dosežek';
$string['rule'] = 'Pravilo';
$string['rule:contains'] = 'vključuje';
$string['rule:eq'] = 'je enako';
$string['rule:eqs'] = 'je strogo enako';
$string['rule:gt'] = 'je večje kot';
$string['rule:gte'] = 'je večje ali enako kot';
$string['rule:lt'] = 'je manjše kot';
$string['rule:lte'] = 'je manjše ali enako kot';
$string['rule:regex'] = 'ustreza regex';
$string['ruleadded'] = 'Pogoj je bil dodan.';
$string['rulecm'] = 'Dejavnost ali vir';
$string['rulecm_help'] = 'Ta pogoj je izpolnjen, ko se v navedeni dejavnosti ali viru izvrši dejanje.';
$string['rulecmdesc'] = 'Dejavnost ali vir je \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Dejavnost ali vir je: \'{$a->contextname}\' v \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Ta pogoj zahteva, da se dogodek izvede v določeni učni dejavnosti ali viru.';
$string['ruleevent'] = 'Izbran dogodek';
$string['ruleeventdesc'] = 'Dogodek je \'{$a->eventname}\'';
$string['ruleeventinfo'] = 'Iz seznama izberite dogodek, ki ga mora udeleženec izvesti.';
$string['rulefilterany'] = 'Katerikoli';
$string['rulefilteranycm'] = 'Katerakoli dejavnost';
$string['rulefilteranycmdesc'] = 'Ta pogoj bo ustrezal katerikoli dejavnosti.';
$string['rulefilteranycourse'] = 'Katerikoli predmet';
$string['rulefilteranycoursedesc'] = 'Ta pogoj bo ustrezal kateremkoli predmetu.';
$string['rulefilteranydesc'] = 'Ta pogoj ustreza vsemu.';
$string['rulefilteranysection'] = 'Katerikoli odsek';
$string['rulefilteranysectiondesc'] = 'Ta pogoj bo ustreza kateremkoli odseku.';
$string['rulefiltercm'] = 'Določena dejavnost';
$string['rulefiltercmdesc'] = 'Izbor določene dejavnosti ali vira v predmetu.';
$string['rulefiltercmname'] = 'Ime dejavnosti';
$string['rulefiltercmnamedesc'] = 'Pogoj temelji na imenu dejavnosti';
$string['rulefilternone'] = 'Nič';
$string['rulefiltersection'] = 'Določen odsek';
$string['rulefiltersectiondesc'] = 'Izbor določenega odseka v predmetu.';
$string['rulefilterthiscourse'] = 'Ta predmet';
$string['rulefilterthiscoursedesc'] = 'Osredotoči se na ta predmet.';
$string['ruleproperty'] = 'Lastnost dogodka';
$string['rulepropertydesc'] = 'Lastnost \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Ta pogoj je namenjen naprednim uporabnikom z dobrim poznavanjem dnevniških dogodkov in njihovih nastavitev.';
$string['ruleset'] = 'Nabor pogojev';
$string['ruleset:all'] = 'VSI pogoji so izpolnjeni';
$string['ruleset:any'] = 'KATERIKOLI pogoj je izpolnjen';
$string['ruleset:none'] = 'NOBEN pogoj ni izpolnjen';
$string['rulesetinfo'] = 'Združitev več pogojev v enega.';
$string['rulesformhelp'] = '<p>Vtičnik uporablja dogodke za podeljevanje točk udeležencem za izvedena dejanja. S spodnjim obrazcem lahko dodate svoja pravila in si ogledate privzeta.</p>
<p>Priporočljivo je, da preverite <a href="{$a->log}">dnevnik vtičnika</a>, da ugotovite, kateri dogodki se sprožijo med izvajanjem dejanj, in da si preberete več o dogodkih: <a href="{$a->list}">seznam vseh dogodkov</a>, <a href="{$a->doc}">dokumentacija razvijalca</a>. </p>
<p>Upoštevajte, da vtičnik ignorira:
<ul>
     <li>Dejanja, ki jih izvajajo skrbniki, gostje ali uporabniki, ki niso prijavljeni.</li>
     <li>Dejanja, ki jih izvedejo uporabniki brez zmogljivosti <em>block/xp:earnxp</em>.</li>
     <li>Ponavljajoča dejanja v kratkem časovnem intervalu (preprečevanje goljufanja).</li>
     <li>Dogodke, ki so označeni kot <em>anonimni</em>, npr. v anonimnih Odzivih.</li>
     <li>Dogodke, ki ne sodijo v kategorijo <em>Sodelovanje</em>.</li>
</ul>
</p>';
$string['rulesscope'] = 'Obseg';
$string['rulesscope_help'] = 'Obseg pravil določa, kdaj se uporabljajo.

Pravila lahko ustvarimo v dveh obsegih: na ravni celotnega spletnega mesta in na ravni posameznega predmeta. Kadar je to mogoče, se najprej ocenijo pravila za posamezne predmete, nato pa še pravila za celotno spletno mesto. Ta pristop omogoča izvajalcem, da ustvarijo splošna pravila, ki veljajo po celotnem spletnem mestu, nato pa jih prilagodijo za posamezne predmete.

- Celotno spletno mesto: Ta pravila veljajo na celotni spletni strani, razen kadar so v veljavi pravila za posamezne predmete.
- Predmet: Ta pravila veljajo samo znotraj določenega predmeta. Imajo prednost pred pravili za celotno spletno stran.';
$string['ruletypecmcompletion'] = 'Zaključek dejavnosti';
$string['ruletypecmcompletiondesc'] = 'Točke se podelijo, ko je dejavnost označena kot zaključena.';
$string['ruletypecoursecompletion'] = 'Zaključek predmeta';
$string['ruletypecoursecompletiondesc'] = 'Točke se podelijo, ko je predmet označen kot zaključen.';
$string['ruletypesectioncompletion'] = 'Zaključek odseka';
$string['ruletypesectioncompletiondesc'] = 'Točke se podelijo, ko je odsek označen kot zaključen.';
$string['searchandselectcourse'] = 'Poišči in izberi predmet';
$string['searchandselectmodule'] = 'Poišči in izberi dejavnost ali vir';
$string['selectcourse'] = 'Izberi predmet';
$string['send'] = 'Pošlji';
$string['setpoints'] = 'Določite točke';
$string['settingsoutdatedxppnotice'] = 'Če vidite spodnje nastavitve, to pomeni, da je nameščena zastarela različica XP+. Prosite svojega skrbnika, da težavo reši z namestitvijo najnovejše različice.';
$string['shortcode:xpbadge'] = 'Značka, ki se povezuje s trenutno doseženo stopnjo uporabnika.';
$string['shortcode:xpiflevel'] = 'Prikažite to vsebino, ko se ujema dosežena stopnja uporabnika.';
$string['shortcode:xpiflevel_help'] = 'Za oblikovanje kratke kode si oglejte spodnje primere. Če je stopnja strogo določena, bo vsebina prikazana ne glede na druga pravila.
Pravila _greater_ in _less than_ se morajo ujemati z vsebino, ki bo prikazana. Bodite previdni, saj se lahko zgodi, da se vsebina nikoli ne prikaže.
Upoštevajte, da bodo izvajalci in uporabniki z možnostmi urejanja vedno videli vse.

```
[xpiflevel 1 3 5]
    Prikazano, če je stopnja uporabnika natanko 1, 3 ali 5.
[/xpiflevel]

[xpiflevel >3]
    Prikazano, če je stopnja uporabnika večja od 3.
[/xpiflevel]

[xpiflevel >=3]
    Prikazano, če je stopnja uporabnika večja ali enaka 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Prikazano, če je stopnja uporabnika večja ali enaka 10 IN je strogo manjša od 20  ALI je natančno enaka 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Se ne prikaže, saj uporabnikova stopnja ne more biti hkrati manjša ali enaka 10 IN večja ali enaka 20.
[/xpiflevel]
```

Upoštevajte, da te kratke kode ne morejo biti ugnezdene ena v drugo.';
$string['shortcode:xpladder'] = 'Prikaži del lestvice okoli trenutnega ranga uporabnika.';
$string['shortcode:xpladder_help'] = 'Privzeto bo prikazana bližnja okolica lestvice uporabnika.

```
[xpladder]
```

Za prikaz najboljših 10 udeležencev (namesto uporabniku blizu uvrščenih), nastavite parameter `top`. Dodatno lahko nastavite število prikazanih v lestvici  npr. `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Povezava na celotno lestvico bo samodejno prikazana pod tabelo. Če ne želite prikazati te povezave, dodajte argument `hidelink`.

```
[xpladder hidelink]
```

Tabela privzeto ne vsebuje stolpca napredka, ki prikazuje vrstico napredka. Če je bil ta stolpec izbran v dodatnih stolpcih v nastavitvah lestvice, lahko uporabite argument `withprogress` za prikaz.

```
[xpladder withprogress]
`` `

V primeru uporabe skupin, bo lestvica skušala prikazati lestvico za ustrezno skupino.';
$string['shortcode:xplevelname'] = 'Prikaži ime stopnje.';
$string['shortcode:xplevelname_help'] = 'Privzeto oznaka prikazuje ime trenutne stopnje uporabnika.
Alternativno lahko uporabite `level` argument za prikaz imena specifične stopnje.

```
[xplevelname]
[xplevelname level=5]
```

Če je`level` argument nastavljen in stopnja ne obstaja, ne bo prikazano nič.';
$string['shortcode:xppoints'] = 'Prikaži število točk, oblikovanih kot točke napredka.';
$string['shortcode:xppoints_help'] = 'Privzeto to prikazuje število točk trenutnega uporabnika. Po želji lahko določite številko, da prepišete to vrednost.

Slog točk bo odvisen od tega, ali je prikazana poljubna vrednost ali točke trenutnega uporabnika. Argument `plain` lahko uporabite za odstranitev kakršnegakoli sloga.

```
[xppoints]
[xppoints 500]
[xppoints 123 plain]
```';
$string['shortcode:xpprogressbar'] = 'Vrstica napredka trenutnega uporabnika do naslednje stopnje.';
$string['sitewide'] = 'Celotno spletno mesto';
$string['somefeaturesrequireotherplugins'] = 'Nekatere funkcionalnosti zahtevajo namestitev dodatnih vtičnikov.';
$string['someoneelse'] = 'Nekdo drug';
$string['somethinghappened'] = 'Nekaj se je zgodilo';
$string['taskadminnotices'] = 'Skrbniška obvestila';
$string['taskcollectionloggerpurge'] = 'Počisti dnevnike zbiranja';
$string['taskstateprovisioner'] = 'Skrbnik stanja';
$string['taskusagereport'] = 'Poročilo o uporabi';
$string['teamleaderboard'] = 'Lestvica skupin';
$string['teamleaderboard_help'] = 'Lestvica skupin prikazuje razvrstitev skupin glede na skupno število točk, ki so jih zbrali njihovi člani.

Skupine so lahko sestavljene iz skupin v predmetu ali kohort. Na voljo so tudi možnosti za prilagoditev različno velikim skupinam.

[Podrobnosti](https://docs.levelup.plus/xp/docs/how-to/setup-team-leaderboard/team-leaderboard?ref=blockxp_help)';
$string['teamleaderboardintro'] = 'Lestvica skupin je razvrstitev skupin glede na točke vseh njihovih članov.';
$string['teams'] = 'Skupine';
$string['thankyou'] = 'Hvala!';
$string['timebetweensameactions'] = 'Čas med enakimi dejanji';
$string['timebetweensameactions_help'] = 'To je minimalni čas, ki mora preteči, da se enako dejanje, ki se je že zgodilo, ponovno upošteva. Dejanje se šteje za enako, če je bilo postavljeno v isti kontekst in element (npr. branje objave na forumu se šteje za enako, če je bila ista objava ponovno prebrana). Če je ta vrednost prazna ali enaka nič, se ne upošteva.';
$string['timeformaxactions'] = 'Časovni okvir za največje število dejanj';
$string['timeformaxactions_help'] = 'Časovni okvir (v sekundah), v katerem uporabnik ne sme preseči največjega števila dejanj.';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}min';
$string['tinytimenow'] = 'zdaj';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}w';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Skupaj';
$string['tryme'] = 'Preizkusi!';
$string['unavailable'] = 'Ni na voljo';
$string['unknownactivitya'] = 'Neznana dejavnost ({$a})';
$string['unknownbadgea'] = 'Neznana značka ({$a})';
$string['unknownconditiona'] = 'Neznan pogoj ({$a})';
$string['unknowneventa'] = 'Neznan dogodek ({$a})';
$string['unknownsectiona'] = 'Neznan odsek ({$a})';
$string['unknowntypea'] = 'Neznan tip ({$a})';
$string['unlockfeaturewithxpplus'] = 'Odklenite funkcionalnost z XP+. <a href="{$a}">Več informacij</a>';
$string['unstableversioninstalled'] = 'Nameščena različica je nestabilna.';
$string['unstableversioninstalledinfo'] = 'Ta različica Level Up XP (block_xp) je še v razvoju in velja za nestabilno. Prosimo, uporabite uradno izdajo.';
$string['updateandpreview'] = 'Posodobitev in predogled';
$string['upgradingplugins'] = 'Nadgradnja vtičnikov';
$string['urlaccessdeprecated'] = 'Dostop prek tega URL-ja je potekel, prosimo, posodobite povezave.';
$string['usagereport'] = 'Deli poročilo o uporabi';
$string['usagereport_desc'] = 'Periodično delite anonimne informacije o uporabi z razvijalci vtičnika. Te informacije bodo pomagale bolje razumeti, kako se vtičnik uporablja, in bodo vplivale na nadaljnji razvoj. Podatki v skupni rabi vsebujejo osnovne informacije o spletnem mestu Moodle (URL, različica) in podatke o uporabi vtičnika (število uporabnikov, ki zaslužijo točke, pregled nastavitev, uporabljena pravila ...).';
$string['usealgo'] = 'Uporabi algoritem';
$string['usecustomlevelbadges'] = 'Uporabi značke stopenj po meri';
$string['usecustomlevelbadges_help'] = 'Ko je nastavljeno na "Da", morate zagotoviti sliko za vsako stopnjo.';
$string['userladderparticipation'] = 'Sodelovanje na lestvici';
$string['userladderparticipation_help'] = 'Določa, ali uporabnik trenutno sodeluje na lestvici. To ne vpliva na lestvico skupin.';
$string['userladderparticipationlocked'] = 'Zakleni sodelovanje do';
$string['userladderparticipationlocked_help'] = 'Datum, od katerega lahko uporabnik prosto spremeni svojo odločitev glede sodelovanja.';
$string['usingalgo'] = 'Uporaba algoritma';
$string['value'] = 'Vrednost';
$string['valuessaved'] = 'Vrednosti so bile uspešno shranjene.';
$string['viewas'] = 'Poglej kot';
$string['viewlogs'] = 'Poglej dnevniške zapise';
$string['viewtheladder'] = 'Ogled lestvice';
$string['visualsintro'] = 'Naložite slike, da prilagodite videz stopenj.';
$string['wewillreplyat'] = 'Odgovorili bomo ob: _{$a}_.';
$string['when'] = 'Kdaj';
$string['wherearexpused'] = 'Kje se točke uporabijo?';
$string['wherearexpused_desc'] = 'Ko je nastavljeno na "V predmetih", bodo pridobljene točke upoštevane le za predmet, v katerem je bil blok dodan. Ko je nastavljeno na »Za celotno spletno mesto«, bo uporabnik napredoval v spletnem mestu in ne selektivno znotraj predmetov. Upoštevane bodo vse točke, pridobljene v spletnem mestu.';
$string['whoops'] = 'Ups!';
$string['xp'] = 'Točke napredka';
$string['xp:addinstance'] = 'Dodaj nov blok';
$string['xp:earnxp'] = 'Pridobivanje točk';
$string['xp:manage'] = 'Upravljajte z vsemi vidiki točk';
$string['xp:myaddinstance'] = 'Dodaj blok na Pregledno ploščo';
$string['xp:view'] = 'Poglej blok in z njim povezane strani';
$string['xp:viewlogs'] = 'Poglej dnevnik';
$string['xp:viewreport'] = 'Poglej poročilo';
$string['xpgaindisabled'] = 'Pridobivanje točk onemogočeno';
$string['xpplusrequired'] = 'zahtevane XP+';
$string['xprequired'] = 'zahtevane XP';
$string['xptogo'] = 'manjka še [[{$a}]]';
$string['youleveledupexcl'] = 'Nova stopnja!';
$string['youreachedlevel'] = 'Dosežena je stopnja:';
$string['youreachedlevela'] = '{$a}. stopnja je dosežena!';
$string['yourmessage'] = 'Vaše sporočilo';
$string['yourownrules'] = 'Vaša pravila';
