<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_ludilearn', language 'es_mx', version '4.4'.
 *
 * @package     format_ludilearn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achiever'] = 'Triunfador';
$string['achiever_desc'] = 'Motivado por la habilidad y la maestría';
$string['addsections'] = 'Añadir secciones';
$string['assignment'] = 'Asignación de elementos del juego';
$string['assignment_help'] = 'Recordatorio: Ludilearn es un formato de curso potente, pero su eficacia depende del dominio de los conceptos de ludificación y de su estrategia pedagógica.<br><br>
La asignación determina cómo se asignan los elementos del juego a los alumnos. Los tres modos de asignación son:<br><br>
* Automático: mediante el algoritmo de Ludilearn, que asigna automáticamente un elemento del juego según el perfil del alumno (aplicado a todos los cursos). Si sus alumnos acceden a un curso basado en juegos por primera vez, deberán completar un cuestionario de 5 minutos.
* Manual: seleccionando un elemento del juego de su elección para todos los alumnos y para todo el curso.
* Por sección: seleccionando un elemento del juego de su elección para todos los alumnos en cada sección del curso.';
$string['assignmentbysection'] = 'Asignación de elementos del juego por sección';
$string['automatic'] = 'Automática: basado en un cuestionario y el algoritmo LudiLearn';
$string['avatar'] = 'Avatar';
$string['averagetime'] = 'Tiempo promedio';
$string['backtocourse'] = 'Continuar';
$string['badge'] = 'Insignia';
$string['ball'] = 'Bola';
$string['bed'] = 'Cama';
$string['besttime'] = 'Mejor tiempo';
$string['body'] = 'Cuerpo';
$string['bysection'] = 'Por sección';
$string['check_format_options_changements'] = 'Verificar cambios en las opciones de formato';
$string['completion'] = 'Finalización';
$string['condition'] = 'Condición';
$string['currentsection'] = 'Esta sección';
$string['decoration'] = 'Decoración';
$string['default'] = 'Predeterminado';
$string['default_game_element'] = 'Elemento de juego predeterminado';
$string['default_game_element_help'] = 'El elemento de juego predeterminado es el elemento de juego que se asignará a todas las secciones';
$string['deletesection'] = 'Eliminar sección';
$string['desk'] = 'Escritorio';
$string['disruptor'] = 'Disruptor';
$string['disruptor_desc'] = 'Motivados por el cambio';
$string['do_not_like_following_rules'] = 'No me gusta seguir reglas';
$string['editgameeleements'] = 'Editar elementos del juego';
$string['editsection'] = 'Editar sección';
$string['editsectionname'] = 'Editar nombre de sección';
$string['editsettingsfailed'] = 'Algo no va bien. Los cambios no se han aplicado.';
$string['editsettingssuccess'] = 'Se han aplicado los cambios realizados.';
$string['enjoy_being_part_of_a_team'] = 'Disfruto ser parte de un equipo';
$string['enjoy_group_activities'] = 'Disfruto de las actividades en grupo.';
$string['enjoy_managing_challenging_tasks'] = 'Disfruto gestionando tareas desafiantes.';
$string['enjoy_overcoming_difficult_circumstances'] = 'Disfruto superar circunstancias difíciles.';
$string['equip'] = 'Equipar';
$string['equiped'] = 'Equipado';
$string['error'] = 'Error';
$string['execute'] = 'Ejecutar';
$string['face'] = 'Cara';
$string['figurehead'] = 'Figurón';
$string['first'] = 'st';
$string['flag'] = 'Bandera';
$string['free_spirit'] = 'Espíritu libre';
$string['freespirit'] = 'Espíritu libre';
$string['freespirit_desc'] = 'Motivado por la autonomía';
$string['gameelement'] = 'Elemento del juego';
$string['gameelements'] = 'Elementos del juego';
$string['gameprofile'] = 'Perfil del jugador';
$string['gameprofile_desc'] = 'En base a tus respuestas, aquí está tu perfil de jugador de HEXAD-12:';
$string['gameprofile_title'] = 'Resultados del perfil del jugador de HEXAD-12';
$string['gamify'] = 'Ludificar';
$string['globalsettings'] = 'Configuraciones globales';
$string['grade'] = 'Calificaciones';
$string['happy_to_help_others'] = 'Estoy feliz de ayudar a otros.';
$string['head'] = 'Cabeza';
$string['hexad_scores_details'] = 'Sus resultados completos';
$string['hexadchart_desc'] = 'Gráfico de radar que muestra las puntuaciones de su perfil de jugador de HEXAD-12';
$string['hidefromothers'] = 'Ocultar sección';
$string['highschool'] = 'Escuela secundaria/preparatoria';
$string['hull'] = 'Cáscara';
$string['important_to_follow_my_own_path'] = 'Es importante para mí seguir mi propio camino.';
$string['independence_is_important_to_me'] = 'La independencia es importante para mí.';
$string['inventory'] = 'Inventario';
$string['items'] = 'Elementos';
$string['itemunlocked'] = 'Elementos desboqueados';
$string['lamp'] = 'Lámpara';
$string['leftarm'] = 'Brazo izquierdo';
$string['lesson'] = 'Lección';
$string['ludilearn:manage'] = 'Gestionar cursos ludificados';
$string['ludilearn:view'] = 'Ver curso ludificado';
$string['manual'] = 'Manualmente para todo el curso';
$string['maxscore'] = 'Puntaje máximo';
$string['maxserie'] = 'Serie máxima';
$string['me'] = 'Yo';
$string['missinganswers'] = 'Debes responder esta pregunta para validar el cuestionario';
$string['navigation'] = 'Navegación de perfiles HEXAD-12';
$string['newsectionname'] = 'Nuevo nombre para la sección {$a}';
$string['nogamification'] = 'Sin ludificación';
$string['nogamified'] = 'No ludificado';
$string['not_at_all_agree'] = 'No estoy del todo de acuerdo';
$string['notgamify'] = 'No ludificar';
$string['number_question'] = 'de 12:';
$string['ofpenalties'] = 'de penalizaciones';
$string['others'] = 'Otros';
$string['parameters'] = 'Configuraciones';
$string['partner_text'] = '<p>Desarrollado por <a href="https://pimenko.com">Pimenko</a>.<br>
Para retroalimentación técnica, utilice el <a href="https://github.com/DigiDago/moodle-format_ludilearn">repositorio de Github</a><br><br>
<b>Acerca de Ludilearn+</b><br><br>
El proyecto LudiMoodle+, liderado por la Universidad de Lyon, ha recibido una subvención del gobierno francés, gestionada por la Agencia Nacional de Investigación Francesa en el marco del programa Francia 2030, con la referencia «ANR-22-FRAN-0005»</p>';
$string['partner_text2'] = '<p> <b> Socios del proyecto </b> </p>';
$string['pet'] = 'Mascota';
$string['philanthropist'] = 'Filántropo';
$string['philanthropist_desc'] = 'Motivados por el significado y la utilidad';
$string['picture'] = 'Imagen';
$string['player'] = 'Jugador';
$string['player_desc'] = 'Motivado por la recompensa';
$string['plugin_description'] = 'El curso ofrece ludificación con elementos de juego (puntuación, insignia, progresión, avatar, cronómetro, clasificación) asignados automáticamente en función del perfil del alumno o elegidos por el profesor.';
$string['pluginname'] = 'Ludilearn';
$string['privacy:metadata:format_ludilearn_answers'] = 'La tabla format_ludilearn_answers almacena las respuestas al cuestionario HEXAD-12.';
$string['privacy:metadata:format_ludilearn_answers:questionid'] = 'La ID de la pregunta.';
$string['privacy:metadata:format_ludilearn_answers:score'] = 'El puntaje obtenido por el usuario para la pregunta.';
$string['privacy:metadata:format_ludilearn_answers:userid'] = 'La ID del usuario.';
$string['privacy:metadata:format_ludilearn_attributio'] = 'La tabla format_ludilearn_attributio almacena los elementos del juego asignados a cada usuario.';
$string['privacy:metadata:format_ludilearn_attributio:gameelementid'] = 'La ID del elemento del juego.';
$string['privacy:metadata:format_ludilearn_attributio:timecreated'] = 'La hora en que se asignó el elemento de juego al usuario.';
$string['privacy:metadata:format_ludilearn_attributio:userid'] = 'La ID del usuario';
$string['privacy:metadata:format_ludilearn_cm_user'] = 'La tabla format_ludilearn_cm_user almacena los datos relacionados con los elementos del juego en un módulo de curso asignado a cada usuario.';
$string['privacy:metadata:format_ludilearn_cm_user:attributionid'] = 'La ID de atribución';
$string['privacy:metadata:format_ludilearn_cm_user:cmid'] = 'La ID del módulo del curso.';
$string['privacy:metadata:format_ludilearn_cm_user:name'] = 'El nombre de los datos.';
$string['privacy:metadata:format_ludilearn_cm_user:value'] = 'El valor de los datos.';
$string['privacy:metadata:format_ludilearn_profile'] = 'La tabla format_ludilearn_profile almacena el perfil de jugador HEXAD-12 de cada usuario.';
$string['privacy:metadata:format_ludilearn_profile:combinedaffinities'] = 'El perfil del jugador HEXAD-12 del usuario.';
$string['privacy:metadata:format_ludilearn_profile:type'] = 'El tipo de elemento de juego asignado al usuario.';
$string['privacy:metadata:format_ludilearn_profile:userid'] = 'La ID del usuario';
$string['privacy:metadata:ludilearn_gameeele_user'] = 'La tabla ludilearn_gameeele_user almacena todos los datos relacionados con los elementos del juego asignados a cada usuario.';
$string['privacy:metadata:ludilearn_gameeele_user:attributionid'] = 'La ID de atribución';
$string['privacy:metadata:ludilearn_gameeele_user:name'] = 'El nombre de los datos.';
$string['privacy:metadata:ludilearn_gameeele_user:value'] = 'El valor de los datos.';
$string['professional'] = 'Profesional';
$string['progress'] = 'Progresión de tareas';
$string['progression'] = 'Progresión';
$string['propulsion'] = 'Propulsión';
$string['questionnaire'] = 'Cuestionario de perfil de jugador HEXAD-12 con 12 preguntas';
$string['questionnaire:question1'] = 'Me hace feliz poder ayudar a los demás.';
$string['questionnaire:question10'] = 'Es importante para mí seguir mi propio camino.';
$string['questionnaire:question11'] = 'Me veo como un rebelde';
$string['questionnaire:question12'] = 'Las recompensas son una excelente manera de motivarme.';
$string['questionnaire:question2'] = 'Disfruto de las actividades en grupo.';
$string['questionnaire:question3'] = 'El bienestar de los demás es importante para mí.';
$string['questionnaire:question4'] = 'Me gusta ser parte de un equipo';
$string['questionnaire:question5'] = 'Me gusta dominar tareas difíciles.';
$string['questionnaire:question6'] = 'Disfruto salir victorioso de circunstancias difíciles.';
$string['questionnaire:question7'] = 'Ser independiente es importante para mí.';
$string['questionnaire:question8'] = 'No me gusta seguir reglas';
$string['questionnaire:question9'] = 'Si la recompensa es suficiente, me esforzaré.';
$string['questionshexad'] = 'Ayúdanos a adaptarlo a su perfil de jugador de <a href="https://gamified.uk/UserTypeTest2023/user-type-test.php" target="_blank" rel="noopener" aria-label="HEXAD-12 player profile test (abre en una ventana nueva)">HEXAD-12</a> indicando cómo se corresponde con usted cada frase.<br>Escala: 1 (Nada de acuerdo) a 7 (Totalmente de acuerdo).';
$string['questionshexad_title'] = 'Usted está a punto de acceder a un curso ludificado.';
$string['ranking'] = 'Clasificación';
$string['rating_scale'] = 'Valorar de 1 (Nada de acuerdo) a 7 (Totalmente de acuerdo)';
$string['reference_time'] = 'Tiempo de referencia';
$string['report'] = 'Reporte';
$string['rewards_are_good_for_motivation'] = 'Las recompensas son una buena manera de motivarme.';
$string['rightarm'] = 'Brazo derecho';
$string['sail'] = 'Navegar';
$string['save_questionnaire'] = 'Guardar las respuestas del cuestionario';
$string['saved'] = 'Guardado';
$string['school'] = 'Escuela';
$string['score'] = 'Puntaje';
$string['score_separator'] = ':';
$string['second'] = 'o';
$string['seconds'] = 'segundos';
$string['section0name'] = 'General';
$string['sectionname'] = 'Sección';
$string['see_myself_as_rebel'] = 'Me veo como un rebelde';
$string['settings:avatardescription'] = 'El elemento de juego de avatar permite a los alumnos ganar objetos y personalizar su representación visual en el curso. Los alumnos desbloquean objetos como peinados, ropa y accesorios a medida que avanzan en el curso.
1. En las actividades con calificación, el desbloqueo de objetos de avatar se basa en obtener una puntuación superior al límite establecido para obtener un objeto. Por ejemplo, si el límite se establece en el 80 %, el alumno deberá obtener una puntuación superior al 80 % en una actividad con calificación para desbloquear un nuevo objeto de avatar.
2. En las actividades que solo requieren completar la actividad, esta desbloquea un objeto de avatar.
3. En las actividades que combinan puntuación y finalización, se utiliza la puntuación obtenida. La finalización de la actividad no tiene ningún impacto adicional.';
$string['settings:badgebronze'] = 'Umbral de insignia de bronce';
$string['settings:badgebronze_help'] = 'Este parámetro define el porcentaje mínimo de la calificación que un estudiante debe alcanzar para recibir una insignia de bronce en una actividad calificada. Por ejemplo, si el umbral se establece en el 70 %:<br> * Para una actividad calificada sobre 100 puntos, el estudiante debe obtener al menos 70 puntos.<br>
* Para una actividad calificada sobre 100 puntos, el estudiante debe obtener al menos 70 puntos.
* Para un examen calificado sobre 50 puntos, el estudiante debe obtener al menos 35 puntos.';
$string['settings:badgedescription'] = 'Este elemento del juego recompensa a los estudiantes con insignias por completar actividades. Se adapta automáticamente a los diferentes tipos de actividades del curso.
1. En las actividades con calificación, se otorgan automáticamente tres niveles de insignias (Oro, Plata, Bronce) cuando la calificación del estudiante alcanza o supera el límite definido para cada nivel.
2. En las actividades sin calificación con finalización, los estudiantes reciben insignias de Oro directamente al completar la actividad.
3. En el caso de una actividad con calificación con finalización, los estudiantes podrán obtener uno de los tres niveles de insignias (Oro, Plata, Bronce) y una insignia adicional vinculada a la finalización.';
$string['settings:badgegold'] = 'Umbral de insignia de oro';
$string['settings:badgegold_help'] = 'Este parámetro define el porcentaje mínimo de la calificación que un estudiante debe alcanzar para recibir una insignia dorada en una actividad calificada. Por ejemplo, si el umbral se establece en 90 %:<br>
* Para una actividad calificada sobre 100 puntos, el estudiante debe obtener al menos 90 puntos.<br>
* Para un examen calificado sobre 50 puntos, el estudiante debe obtener al menos 45 puntos.';
$string['settings:badgesilver'] = 'Umbral de insignia de plata';
$string['settings:badgesilver_help'] = 'Este parámetro define el porcentaje mínimo de la calificación que un estudiante debe alcanzar para recibir una insignia de plata en una actividad calificada. Por ejemplo, si el umbral se establece en el 85 %:<br>
* Para una actividad calificada sobre 100 puntos, el estudiante debe obtener al menos 85 puntos.<br>
* Para un examen calificado sobre 50 puntos, el estudiante debe obtener al menos 42,5 puntos.';
$string['settings:bonuscompletion'] = 'Bono por finalización';
$string['settings:bonuscompletion_help'] = 'El bono por finalización consiste en una cantidad fija de puntos que se otorgan cuando un alumno completa una actividad sin calificación ni finalización.<br>
Esta bonificación se aplica de forma uniforme a todas las actividades del curso que solo tienen habilitada la opción de finalización (por ejemplo, ver un recurso o participar en un foro sin calificación). Esta bonificación anima a los alumnos a interactuar con todos los elementos del curso, incluso aquellos que no se califican directamente.';
$string['settings:multiplier'] = 'Multiplicador';
$string['settings:multiplier_help'] = 'El multiplicador es un coeficiente que se aplica uniformemente a todos los puntos obtenidos en el curso para reforzar el aspecto lúdico del sistema de puntuación.<br>
El valor predeterminado es 1. Aumentarlo (a 2 o 10, por ejemplo) ajustará todas las puntuaciones obtenidas.<br>
Esta opción permite crear una dimensión más lúdica sin alterar el equilibrio entre las actividades del curso.';
$string['settings:nogamifieddescription'] = '<p>El elemento no lúdico aparece en todas las actividades no lúdicas y recursos del curso.</p>';
$string['settings:nosetting'] = 'Este elemento del juego funciona automáticamente según la estructura y la configuración de su curso. No requiere configuración adicional y no hay opciones para ajustar.';
$string['settings:penalties'] = 'Penalizaciones por puntos perdidos';
$string['settings:penalties_help'] = 'Este parámetro define la cantidad de segundos que se añaden al tiempo final del examen por cada respuesta incorrecta a una pregunta del alumno. Cada punto perdido suma el tiempo del parámetro de penalización.<br />
Por ejemplo, si la penalización es de 20 segundos y un alumno obtiene 0 puntos en un examen de 2 puntos, se añadirán 40 segundos a su tiempo final.';
$string['settings:percentagecompletion'] = 'Porcentaje adicional para actividades calificadas con finalización';
$string['settings:percentagecompletion_help'] = 'Esta configuración define una bonificación adicional que se otorga cuando un alumno completa una actividad calificada y con estado de finalización (por ejemplo, tareas, exámenes o lecciones).
La bonificación se calcula como un porcentaje de la calificación máxima de la actividad. Por ejemplo, si este porcentaje se establece en el 10 %:<br>
* Una tarea con una calificación de 100 puntos otorgará una bonificación de 10 puntos al completarla.<br>
* Un examen con una calificación de 50 puntos otorgará una bonificación de 5 puntos al completarla.<br>
Esta bonificación se suma a la calificación y recompensa a los alumnos por completar la actividad, independientemente de su rendimiento.';
$string['settings:progressiondescription'] = 'El elemento de juego de progreso muestra el progreso general del alumno a lo largo del curso en forma de recorrido. Se adapta automáticamente a los diferentes tipos de actividades.
1. En las actividades con calificación, el progreso se corresponde directamente con el porcentaje de la calificación obtenida. Por ejemplo, si un alumno obtiene un 80 % en un examen, su progreso en esta actividad será del 80 %.
2. En las actividades con solo finalización, el progreso aumenta un 100 % en cuanto la actividad se marca como completada.
3. En las actividades que combinan calificación y finalización, la calificación obtenida determina el progreso; la finalización no tiene ningún impacto adicional.';
$string['settings:rankingdescription'] = 'El elemento de clasificación proporciona una vista comparativa del rendimiento de los alumnos con el de otros alumnos del curso. Se adapta automáticamente a los diferentes tipos de actividad del curso.
1. En las actividades con calificación, el puntaje obtenido se convierte directamente en puntos que contribuyen a la clasificación. Por ejemplo, una calificación del 80% sobre 100 puntos se traduce en 80 puntos en la clasificación. Si 6 alumnos obtienen una mejor calificación, aparecerán en la séptima posición de la clasificación.
2. Las actividades que solo requieren la finalización no afectan a la clasificación.
3. En el caso de las actividades que combinan calificación y finalización, solo se tiene en cuenta la calificación para la clasificación.';
$string['settings:scoredescription'] = 'El elemento de juego de puntaje permite a los alumnos acumular puntos al completar las actividades del curso. Se adapta automáticamente a los diferentes tipos de actividades ofrecidas.
1. En las actividades con calificación, el puntaje se basa directamente en la calificación obtenida. Por ejemplo, una calificación de 16 sobre 20 equivale a 16 puntos.

Se aplica un coeficiente de multiplicación para transformar estos puntos en una puntuación, como en los juegos. Por ejemplo, un coeficiente de 80 representará 1280 puntos en el sistema de puntuación.
2. En las actividades que solo requieren finalización, se otorga una cantidad fija llamada bono por finalización al completarlas. Por ejemplo, al finalizar la actividad, el alumno recibe 150 puntos.
3. En el caso de las actividades que combinan calificación y finalización, la puntuación tiene en cuenta tanto la calificación como un porcentaje adicional. Por ejemplo, completar la actividad añadirá un 20 % adicional a la puntuación total.';
$string['settings:thresholdtoearn'] = 'Umbral para desbloquear un elemento avatar';
$string['settings:thresholdtoearn_help'] = 'Este parámetro define la puntuación mínima (en porcentaje) que un alumno debe alcanzar en una actividad calificada para desbloquear un nuevo elemento de avatar. Por ejemplo, si el umbral se establece en 80 %:<br />
* Una puntuación del 81 % en un examen desbloqueará un elemento de avatar<br />.
* Una puntuación del 79 % no desbloqueará nada, incluso si se completa la actividad.
Ajusta este umbral según la dificultad de tus actividades y la frecuencia con la que usted quiere que los alumnos desbloqueen nuevos elementos de avatar.';
$string['settings:timerdescription'] = 'El elemento de juego con temporizador añade una dimensión temporal a los exámenes de su curso. Funciona exclusivamente con actividades de tipo examen. El elemento muestra el tiempo que tarda el alumno en completar el examen, con penalizaciones por errores.<br>
- El tiempo empleado por el alumno se contabiliza a nivel del examen.<br>
- El mejor tiempo del alumno se registra y se muestra en el examen, y el tiempo promedio del examen se muestra en la sección del curso.<br>
- En caso de error en el examen, se añade tiempo adicional (penalización).<br>';
$string['settings:updateprogression'] = 'Actualizar progreso de los usuarios';
$string['settings:updateprogressiondescription'] = '<br>Actualizar el progreso de todos los usuarios del curso. Esta acción es irreversible.<br>
Esto puede ser útil cuando se cambian los elementos del juego asignados, ya que el progreso no se actualiza automáticamente.<br>';
$string['settingsname'] = 'Personalización de elementos de juego de LudiLearn';
$string['showfromothers'] = 'Mostrar sección';
$string['socialiser'] = 'Socializador';
$string['socialiser_desc'] = 'Motivado por las relaciones sociales y el sentido de pertenencia.';
$string['sportstuff'] = 'Cosas de deporte';
$string['th'] = 'o';
$string['theme'] = 'Tema';
$string['third'] = 'o';
$string['timer'] = 'Cronómetro';
$string['tools'] = 'Herramientas';
$string['totally_agree'] = 'Estoy totalmente de acuerdo';
$string['tshirt'] = 'Playera';
$string['updatescore'] = 'Actualizar la puntuación de los elementos del juego';
$string['wellbeing_of_others_is_important'] = 'El bienestar de los demás es importante para mí.';
$string['will_effort_if_reward_is_enough'] = 'Si la recompensa es suficiente, haré un esfuerzo.';
$string['world'] = 'Mundo';
$string['world_help'] = 'El universo es el diseño utilizado para los elementos del juego. Elija el diseño más adecuado para sus alumnos.';
