<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_xp', language 'uk', version '4.4'.
 *
 * @package     block_xp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Дії';
$string['activityoresourceis'] = 'Діяльність або ресурс {$a}';
$string['addacondition'] = 'Додати умову';
$string['addarule'] = 'Додати правило';
$string['addinstructions'] = 'Додайте більше інформації';
$string['additionalresources'] = 'Додаткові ресурси';
$string['addoninstallationerror'] = 'Ми виявляємо проблему з надбудовою (local_xp), здається, що вона не встановлена належним чином. Адміністратор має завершити його встановлення.';
$string['addonnotactivated'] = 'Аддон не активований.';
$string['addrulesformhelp'] = 'В останньому стовпчику визначається кількість отриманих балів досвіду, коли умови задовольняються.';
$string['admindefaultrulesintro'] = 'Наступні правила будуть використовуватися за замовчуванням для курсів, до яких додано блок.';
$string['admindefaultsettingsintro'] = 'Наведені нижче налаштування використовуватимуться за замовчуванням, коли блок знову додається до курсу. Деякі налаштування можна заблокувати, і в цьому випадку їх значення суворо дотримуються у всіх екземплярах плагіна.';
$string['admindefaultvisualsintro'] = 'Наведені нижче будуть використовуватися за замовчуванням, коли блок знову додається до курсу.';
$string['anonymity'] = 'Анонімність';
$string['anonymity_help'] = 'Цей параметр визначає, чи можуть учасники бачити ім’я та аватар один одного.';
$string['awardaxpwhen'] = '<strong>{$a}</strong> бали заробляються, коли:';
$string['basexp'] = 'База алогритмів';
$string['blockappearance'] = 'Зовнішній вигляд блоку';
$string['blockappearancemovedtopluginsettings'] = 'Налаштування вигляду блоку переміщено на сторінку налаштувань плагіна.';
$string['cachedef_filters'] = 'Фільтри рівня';
$string['cachedef_ruleevent_eventslist'] = 'Список деяких подій';
$string['cannotshowblockconfig'] = 'Зазвичай я показував тут налаштування зовнішнього вигляду, але я не міг знайти ваш блок. Щоб змінити зовнішній вигляд блоку, поверніться назад [тут]({$a}) (або туди, де ви додали блок), увімкніть режим редагування та дотримуйтесь параметра «Налаштувати» у спадному меню блоку. Якщо ви не можете знайти блок, додайте його до свого курсу ще раз.';
$string['cannotshowblockconfigsys'] = 'Зазвичай я показував тут налаштування зовнішнього вигляду, але я не міг знайти ваш блок. Він може бути відсутнім на [головній сторінці]({$a->fp}) і на [інформаційній панелі за замовчуванням]({$a->mysys}) ваших користувачів або присутній в обох. Щоб змінити налаштування звідси, переконайтеся, що вони відображаються лише в одному з них.';
$string['changelevelformhelp'] = 'Якщо змінити число рівнів, значки користувача буде тимчасово відключено, щоб запобігти рівням без значків. Перейдіть на сторінку \'Вигляд\' для повторного включення призначених для користувача значків після збереження цієї форми.';
$string['cheatguard'] = 'Захист від шахрайства';
$string['clicktoselectcm'] = 'Натисніть, щоб вибрати діяльність або ресурс';
$string['cmselector'] = 'Селектор модуля курсу';
$string['coefxp'] = 'Коефіцієнт алгоритму';
$string['colon'] = '{$a->a}: {$a->b}';
$string['configdescription'] = 'Вступ';
$string['configdescription_help'] = 'Короткий вступ відображається в блоці, нижче рівня студента. Учні мають можливість відхилити повідомлення, і в такому випадку вони більше не побачать його.';
$string['configheader'] = 'Налаштування';
$string['configrecentactivity'] = 'Показати останні нагороди';
$string['configrecentactivity_help'] = 'Якщо ввімкнено, блок відображатиме короткий список останніх подій, які нагородили студента балами.';
$string['configtitle'] = 'Назва';
$string['configtitle_help'] = 'Назва блоку.';
$string['congratulationsyouleveledup'] = 'Вітаємо!';
$string['coolthanks'] = 'Клас, так тримати!';
$string['courselog'] = 'Події курсу';
$string['coursereport'] = 'Звіт курсу';
$string['courserules'] = 'Правила курсу';
$string['courseselectedcolon'] = 'Вибраний курс:';
$string['coursesettings'] = 'Налаштування курсу';
$string['coursevisuals'] = 'Змінити оформлення';
$string['customizelevels'] = 'Змінити рівні';
$string['dangerzone'] = 'НЕБЕЗПЕЧНА ЗОНА';
$string['defaultlevels'] = 'Рівні за замовчуванням';
$string['defaultrules'] = 'Правила за замовчуванням';
$string['defaultrulesformhelp'] = 'Це стандартні правила, надані плагіном, вони автоматично дають бали за замовчуванням і ігнорують деякі зайві події. Ваші власні правила мають перевагу над ними.';
$string['defaultsettings'] = 'Налаштування за замовчуванням';
$string['defaultvisuals'] = 'Візуальні елементи за замовчуванням';
$string['deletecondition'] = 'Видалити умову';
$string['deleterule'] = 'Видалити правило';
$string['description'] = 'Опис';
$string['difference'] = 'Порівн.';
$string['discoverlevelupplus'] = 'Відкрийте для себе рівень XP+';
$string['dismissnotice'] = 'Відхилити повідомлення';
$string['displayeveryone'] = 'Показати всіх';
$string['displaynneighbours'] = 'Показати {$a} сусідів';
$string['displayoneneigbour'] = 'Відобразити одного сусіда';
$string['displayparticipantsidentity'] = 'Відобразити особи учасників';
$string['displayrank'] = 'Показати ранг';
$string['displayrelativerank'] = 'Показати відносний ранг';
$string['documentation'] = 'Документація';
$string['editinstructions'] = 'Редагувати інформацію';
$string['enablecheatguard'] = 'Увімкнути захист від накруток';
$string['enablecheatguard_help'] = 'Захист від накруток пропонує простий недорогий механізм для запобігання зловживанням учнями системою за допомогою очевидних прийомів, таких як нескінченне оновлення однієї і тієї ж сторінки або повторення однієї і тієї ж дії знову і знову.

[Докладніше](https://levelup.plus/docs/article/level-up-cheat-guard?ref=blockxp_help)';
$string['enableinfos'] = 'Увімкнути інформаційну сторінку';
$string['enableinfos_help'] = 'Якщо встановлено значення «Ні», учні не зможуть переглядати інформаційну сторінку.';
$string['enableladder'] = 'Включити лідерів';
$string['enableladder_help'] = 'При установці \'Ні\', студенти не зможуть бачити лідерів.';
$string['enablelevelupnotif'] = 'Включити інформування про підвищення рівня';
$string['enablelevelupnotif_help'] = 'При установці \'Так\', Студентам буде відображатися спливаюче вікно з привітанням про досягнення нового рівня.';
$string['enablelogging'] = 'Включити записи подій';
$string['enablexpgain'] = 'Увімкнути отримання балів';
$string['enablexpgain_help'] = 'Якщо встановлено значення «Ні», ніхто не зароблятиме бали на курсі. Це корисно, щоб заморозити отримані очки або включити його в певний момент часу.

Зверніть увагу, що цим також можна керувати більш детально за допомогою можливості _block/xp:earnxp_.';
$string['entersearchterm'] = 'Введіть пошуковий термін';
$string['errorcontextcoursemismatchforwholesite'] = 'URL-адреса цієї сторінки <em>Level Up XP</em> не відповідає поточній конфігурації плагіна. Ваша поточна конфігурація оголошує, що <em>Level Up XP</em> буде використовуватися "Для всього сайту", однак ця сторінка очікувала, що це використовуватиметься "На курс". Будь ласка, <a href="{$a->nexturl}">натисніть тут</a>, щоб перейти на потрібну сторінку. Знайдіть налаштування адміністратора \'block_xp_context\', якщо ви хочете змінити свою конфігурацію.';
$string['errorcontextcoursemismatchpercourse'] = 'URL-адреса цієї сторінки <em>Level Up XP</em> не відповідає поточній конфігурації плагіна. Ваша поточна конфігурація оголошує, що <em>Level Up XP</em> використовуватиметься "На курс", але ця сторінка очікує, що вона використовуватиметься "Для всього сайту". Найімовірніше, він походить від <em>блоку</em>, який був доданий на інформаційну панель або першу сторінку в іншій конфігурації. Ви повинні видалити блок з останніх сторінок і використовувати блок лише з окремих курсів.';
$string['errorformvalues'] = 'Є деякі помилки в значеннях форм, будь ласка, виправте їх.';
$string['errorlevelsincorrect'] = 'Мінімальна кількість рівнів 2';
$string['errornotalllevelsbadgesprovided'] = 'Не всі значки для рівнів були надані. відсутні: {$a}';
$string['errorunknownevent'] = 'Помилка: невідома подія';
$string['errorunknownmodule'] = 'Помилка: Невідомий модуль';
$string['errorxprequiredlowerthanpreviouslevel'] = 'Необхідні бали нижчі або рівні попередньому рівню.';
$string['event_user_leveledup'] = 'Рівень досягнень користувача';
$string['eventis'] = 'Подія {$a}';
$string['eventname'] = 'Назва події';
$string['eventproperty'] = 'Властивість події';
$string['eventsrules'] = 'Правила подій';
$string['eventsrules_help'] = 'Цей плагін використовує події для приписування балів діям, які виконують студенти.
Ви можете використовувати форму нижче, щоб додати власні правила та змінити правила за замовчуванням.

Радимо перевірити сторінку _Log_ плагіна, щоб визначити, які події запускаються, коли студенти виконують дії в курсі.

Додаткові ресурси:

- [Як обчислюються бали досвіду?](https://levelup.plus/docs/article/how-are-experience-points-calculated?ref=blockxp_help)
- [Правила усунення несправностей](https://levelup.plus/docs/article/event-rule-not-working?ref=blockxp_help)';
$string['eventtime'] = 'Завжди';
$string['filtermodules'] = 'Модулі фільтрів';
$string['for1day'] = 'Протягом 1 дня';
$string['for1month'] = 'Протягом місяця';
$string['for1week'] = 'Протягом тижня';
$string['for3days'] = 'Протягом 3 днів';
$string['forever'] = 'Назавжди';
$string['forthewholesite'] = 'За весь сайт';
$string['give'] = 'give';
$string['gotofullladder'] = 'Перейти до повної драбини';
$string['grid'] = 'Сітка';
$string['hideparticipantsidentity'] = 'Приховати особи учасників';
$string['hiderank'] = 'Приховати ранг';
$string['incourses'] = 'У курсах';
$string['ineffective'] = 'Неефективний';
$string['infos'] = 'Шкала';
$string['instructions'] = 'Більше інформації';
$string['invalidxp'] = 'Недійсне значення балів';
$string['keeplogs'] = 'Зберігати журнали';
$string['ladder'] = 'Рейтинг';
$string['ladderadditionalcols'] = 'Додаткові колонки';
$string['ladderadditionalcols_help'] = 'Цей параметр визначає, які додаткові стовпці відображаються на драбині. Натисніть клавішу CTRL або CMD, клацаючи, щоб вибрати більше одного стовпця або скасувати виділення вибраного стовпця.';
$string['ladderempty'] = 'Наразі драбина порожня, обов’язково поверніться пізніше!';
$string['level'] = 'Рівень';
$string['levelbadges'] = 'Значки досягнень';
$string['levelbadgesformhelp'] = 'Назвіть файли [назва].[розширення], наприклад: 1.png, 2.jpg, etc... Рекомендований розмір 100x100.';
$string['levelcount'] = 'Лічильник рівня';
$string['leveldesc'] = 'Опис рівня';
$string['leveldesc_help'] = 'Короткий опис рівня, він відображається на інформаційній сторінці поряд з самим рівнем. Ви можете використовувати це, щоб описати нагороду для учнів, які досягли рівня, включити інструкції, як працювати над цим рівнем, описати рівень у ігровій формі (наприклад, _Відомо, що цього рівня досягають лише найсміливіші душі_) тощо. .';
$string['levelname'] = 'Назва рівня';
$string['levelname_help'] = 'Коротка назва для відображення замість стандартних _Level #1_, _Level #2_ тощо, які іноді відображаються. Якщо ви даєте імена деяким рівням, ми рекомендуємо дати ім’я всім!';
$string['levels'] = 'Рівні';
$string['levelswillbereset'] = 'Увага! Збереження цієї форми перерахує рівні для всіх!';
$string['levelup'] = 'Рівень Досягнень!';
$string['levelupplus'] = 'Вищий рівень XP+';
$string['levelx'] = 'Рівень #{$a}';
$string['likenotice'] = '<strong>Чи подобається вам плагін?</strong> Будь-ласка знайдіть час щоб <a href="{$a->moodleorg}" target="_blank">додати до закладок</a> Moodle.org і <a href="{$a->github}" target="_blank">поставити зірку на GitHub</a>.';
$string['limitparticipants'] = 'Обмежте кількість учасників';
$string['limitparticipants_help'] = 'Цей параметр визначає, хто відображатиметься в таблиці лідерів. Сусіди – це учасники, які знаходяться вище і нижче поточного користувача. Наприклад, при виборі «Відобразити 2 сусідів» відображатимуться лише два учасники, які мають вищий і нижчий рейтинг, ніж поточний користувач.';
$string['list'] = 'Список';
$string['logging'] = 'Записи подій';
$string['manually'] = 'Вручну';
$string['maxactionspertime'] = 'Макс.кількість дій';
$string['maxactionspertime_help'] = 'Максимальна кількість дій, які будуть зараховані для отримання балів протягом заданого періоду часу. Будь-які подальші дії будуть ігноровані. Якщо це значення порожнє або дорівнює нулю, воно не застосовується.';
$string['movecondition'] = 'Посунути значення';
$string['moverule'] = 'Посунути правило';
$string['name'] = 'Ім\'я';
$string['navinfos'] = 'Інформація';
$string['navladder'] = 'Лідер';
$string['navlevels'] = 'Рівні';
$string['navlevelssetup'] = 'Налаштування';
$string['navlog'] = 'Записи';
$string['navpoints'] = 'Окуляри';
$string['navpromo'] = 'XP+';
$string['navreport'] = 'Звіти';
$string['navrules'] = 'Правила';
$string['navsettings'] = 'Налаштування';
$string['navvisuals'] = 'Вигляд';
$string['nodescription'] = 'Без опису';
$string['nologsrecordedyet'] = 'Журнали ще не записані.';
$string['noname'] = 'Без назви';
$string['notesomesettingslocked'] = 'Зауважте, що деякі налаштування не можна редагувати, якщо їх заблокував адміністратор.';
$string['occasionally'] = 'Зрідка';
$string['participant'] = 'Учасник';
$string['participatetolevelup'] = 'Практикуйся та навчайся щоб отриматити бали для підвищення свого професійного рівня!';
$string['perpagecolon'] = 'На сторінку:';
$string['pickaconditiontype'] = 'Виберіть тип умови';
$string['pluginname'] = 'Вищий рівень XP';
$string['pluginsoutofsync'] = '__Плагіни не синхронізовані!__

Це означає, що ви оновили _Level Up XP_, але не _Level Up XP+_. Хоча ми робимо все можливе, щоб запобігти будь-яким проблемам, деякі функції можуть більше не працювати належним чином, в тому числі в самому _Level Up XP_. Ми рекомендуємо оновити _Level Up XP+_ до останньої версії. [Докладніше]({$a->url})';
$string['pointsintimelinker'] = 'пер';
$string['pointsrequired'] = 'Необхідні бали';
$string['privacy:metadata:log'] = 'Зберігає журнал подій';
$string['privacy:metadata:log:eventname'] = 'Назва події';
$string['privacy:metadata:log:time'] = 'Дата, коли це сталося';
$string['privacy:metadata:log:userid'] = 'Користувач, який набрав бали';
$string['privacy:metadata:log:xp'] = 'Бали, нараховані за подію';
$string['privacy:metadata:prefintro'] = 'Записує, чи відхилив користувач вступ до блоку';
$string['privacy:metadata:prefladderpagesize'] = 'Бажаний користувачем розмір сторінки під час перегляду драбини';
$string['privacy:metadata:preflevelup'] = 'Записує, чи повинен користувач бачити сповіщення про підвищення рівня';
$string['privacy:metadata:prefnotices'] = 'Записує, чи закрив користувач сповіщення служби підтримки';
$string['privacy:metadata:prefseenpromo'] = 'Записує, коли користувач переглядав рекламну сторінку';
$string['privacy:metadata:xp'] = 'Зберігає бали та рівень користувачів';
$string['privacy:metadata:xp:lvl'] = 'Рівень користувача';
$string['privacy:metadata:xp:userid'] = 'Користувач';
$string['privacy:metadata:xp:xp'] = 'Окуляри користувача';
$string['privacy:path:level'] = 'Рівень';
$string['privacy:path:logs'] = 'Журнали';
$string['progress'] = 'Досягнення';
$string['progressbar'] = 'Індикатор виконання';
$string['promocheatguard'] = 'Цей захист не призначений для охоплення тривалих періодів часу. Будь ласка, подумайте про оновлення до <em>Level Up XP+</em>, щоб розблокувати більший час та інші функції. <a href="{$a->url}">Докладніше тут</a>.';
$string['promocontactintro'] = 'Зв\'яжіться з нами для отримання додаткової інформації. Ми не кусаємось і відповідаємо швидко!';
$string['promocontactus'] = 'Зв\'язатись';
$string['promoemailusat'] = 'Напишіть нам на _levelup@branchup.tech_.';
$string['promoerrorsendingemail'] = 'Ой! Нам не вдалося надіслати повідомлення... надішліть нам електронний лист безпосередньо на адресу: {$a}. Спасибі!';
$string['promoifpreferemailusat'] = 'Psst! Якщо бажаєте, надішліть нам електронний лист безпосередньо на адресу _{$a}_.';
$string['promointro'] = 'Станьте майстром гри та розкрийте рівень на повну силу. Розблокуйте додаткові функції з Level Up XP+!';
$string['promointroinstalled'] = 'Доповнення _Level Up XP+_ встановлено у вашій системі, і всі його функції ввімкнено.';
$string['promorulesdidyouknow'] = 'Чи знаєте ви, що з <em>Level Up XP+</em> студенти можуть отримувати бали за <em>завершення курсів</em> і <em>заходів</em> або навіть отримувати бали відповідно до своїх <em>оцінок? </em>? <a href="{$a->url}">Дізнайтеся більше тут</a>.';
$string['promoyourmessagewassent'] = 'Дякую, Ваше повідомлення надіслано. Ми повернемося до вас дуже скоро.';
$string['property:action'] = 'Дії з подіями';
$string['property:component'] = 'Компонент дія';
$string['property:crud'] = 'Подія CRUD (Створення, читання, оновлення, видалення)';
$string['property:eventname'] = 'Назва події';
$string['property:target'] = 'Мета події';
$string['rank'] = 'Місце';
$string['ranking'] = 'Рейтинг';
$string['ranking_help'] = 'Ранг – це абсолютна позиція поточного користувача в драбині. Відносний ранг – це різниця в балах досвіду між користувачем та його сусідами.';
$string['reallydeleteuserstate'] = 'Видалення користувача корисно лише для видалення його зі сходів. З будь-яких інших причин ми рекомендуємо натомість встановити їх точки на 0. Зауважте, що їх видалення не впливає на їх здатність заробляти бали в майбутньому.

Важливо, що під час використання _Level Up XP_ для всього сайту, їх видалення призведе до того, що вони зникнуть зі звіту, і в цьому випадку ви не зможете повторно призначити їм бали. Однак, якщо ви використовуєте _Level Up XP_ для кожного курсу, студент все одно може з’являтися у звіті, якщо він зареєстрований на курсі.

Ви дійсно хочете видалити бали цього користувача?';
$string['reallyresetallcoursestodefaults'] = 'Дійсно скинути всі правила курсів до правил за замовчуванням? Ця дія не є оборотною.';
$string['reallyresetcourserulestodefaults'] = 'Дійсно скинути правила курсу до правил за замовчуванням? Ця дія не є оборотною.';
$string['reallyresetdata'] = 'Дійсно скинути рівні та бали всіх учасників цього курсу?';
$string['reallyresetgroupdata'] = 'Дійсно скинути рівні та очки для всіх у цій групі?';
$string['reallyreverttopluginsdefaults'] = 'Дійсно скинути правила за замовчуванням до значень за замовчуванням, запропонованих плагіном? Ця дія не є оборотною.';
$string['recentrewards'] = 'Останні нагороди';
$string['releasenotes'] = 'Примітки до випуску';
$string['reportisempty'] = 'Звіт порожній, студент ще не набрав бали.';
$string['reportisemptyenrolstudents'] = 'Звіт порожній, чи зараховано студентів на цей курс?';
$string['requires'] = 'Вимагає';
$string['resetallcoursestodefaults'] = 'Скиньте всі курси до значень за замовчуванням';
$string['resetallcoursestodefaultsintro'] = 'Натисніть кнопку нижче, щоб скинути всі курси до наведених вище значень за замовчуванням.';
$string['resetcoursedata'] = 'Скинути дані курсу';
$string['resetcourserulestodefaults'] = 'Скиньте правила курсу до значень за замовчуванням';
$string['resetgroupdata'] = 'Скинути дані групи';
$string['reverttopluginsdefaults'] = 'Поверніться до налаштувань плагіна за замовчуванням';
$string['reverttopluginsdefaultsintro'] = 'Скористайтеся наведеною нижче кнопкою, якщо ви хочете повернути наведені вище налаштування за замовчуванням до значень плагіна. Це не впливає на правила в існуючих курсах.';
$string['reward'] = 'Нагорода';
$string['rule'] = 'Правило';
$string['rule:contains'] = 'містить';
$string['rule:eq'] = 'дорівнює';
$string['rule:eqs'] = 'строго дорівнює';
$string['rule:gt'] = 'більше';
$string['rule:gte'] = 'більше або дорівнює';
$string['rule:lt'] = 'менше';
$string['rule:lte'] = 'менше або дорівнює';
$string['rule:regex'] = 'відповідає формальним виразам';
$string['rulecm'] = 'Активність або ресурс';
$string['rulecm_help'] = 'Ця умова виконується, коли подія відбувається у вказаній діяльності або ресурсі.';
$string['rulecmdesc'] = 'Діяльність або ресурс \'{$a->contextname}\'.';
$string['rulecmdescwithcourse'] = 'Діяльність або ресурс: \'{$a->contextname}\' в \'{$a->coursename}\'.';
$string['rulecminfo'] = 'Ця умова вимагає, щоб дія відбувалася в певній діяльності або ресурсі.';
$string['ruleevent'] = 'Конкретна подія';
$string['ruleeventdesc'] = 'Подія \'{$a->eventname}';
$string['ruleeventinfo'] = 'Виберіть дію, яку мають виконати користувачі, із підпорядкованого списку подій.';
$string['ruleproperty'] = 'Властивості події';
$string['rulepropertydesc'] = 'Властивість \'{$a->property}\' {$a->compare} \'{$a->value}\'.';
$string['rulepropertyinfo'] = 'Ця умова призначена для досвідчених користувачів із технічним розумінням подій та їх властивостей.';
$string['ruleset'] = 'Набір умов';
$string['ruleset:all'] = 'Всі умови істинні';
$string['ruleset:any'] = 'Будь-які умови, вірні';
$string['ruleset:none'] = 'Жодна з умов не є істинна';
$string['rulesetinfo'] = 'Об’єднайте кілька умов в одну.';
$string['rulesformhelp'] = '<p>Цей плагін використовує події, щоб приписувати вказівки діям, які виконують студенти. Ви можете використовувати форму нижче, щоб додати власні правила та переглянути правила за умовчанням.</p>
<p>Рекомендується перевірити <a href="{$a->log}">журнал</a> плагіна, щоб визначити, які події запускаються під час виконання дій у курсі, а також дізнатися більше про події самі: <a href="{$a->list}">список усіх подій</a>, <a href="{$a->doc}">документація для розробників</a>.</p>
<p>Нарешті, зверніть увагу, що плагін завжди ігнорує:
<ul>
     <li>Дії, які виконують адміністратори, гості або не ввійшли користувачі.</li>
     <li>Дії, які виконують користувачі, які не мають можливості <em>block/xp:earnxp</em>.</li>
     <li>Повторні дії протягом короткого інтервалу часу, щоб запобігти шахрайству.</li>
     <li>Події, які позначені як <em>анонімні</em>, напр. в анонімному Відгуку.</li>
     <li>І події освітнього рівня не рівні <em>Участь</em>.</li>
</ul>
</p>';
$string['searchandselectcourse'] = 'Знайдіть і виберіть курс';
$string['searchandselectmodule'] = 'Знайдіть і виберіть діяльність або ресурс';
$string['send'] = 'Надіслати';
$string['setpoints'] = 'Встановити точки';
$string['shortcode:xpbadge'] = 'Значок, що відповідає рівню поточного користувача.';
$string['shortcode:xpiflevel'] = 'Відображати вміст, коли рівень поточного користувача відповідає.';
$string['shortcode:xpiflevel_help'] = 'Зверніться до прикладів нижче, щоб відформатувати цей короткий код. Якщо рівень строго вказано, вміст буде відображатися незалежно від інших правил.
Правила _більше_ і _менше_ мають збігатися, щоб вміст відображався. Будьте обережні, оскільки це іноді може призвести до того, що вміст ніколи не відображатиметься!
Зауважте, що викладачі або інші користувачі з можливостями редагування завжди бачитимуть усе.

```
[xpiflevel 1 3 5]
    Відображається, якщо рівень користувача дорівнює точно 1, 3 або 5.
[/xpiflevel]

[xpiflevel >3]
    Відображається, якщо рівень користувача перевищує 3.
[/xpiflevel]

[xpiflevel >=3]
    Відображається, якщо рівень користувача більше або дорівнює 3.
[/xpiflevel]

[xpiflevel >=10 <20 30]
    Відображається, якщо рівень користувача більше або дорівнює 10 І строго менше 20
    АБО точно дорівнює 30.
[/xpiflevel]

[xpiflevel <=10 >=20]
    Ніколи не відображається, оскільки рівень користувача ніколи не може бути меншим або рівним 10 І більше або рівним 20.
[/xpiflevel]
```

Зауважте, що ці шорткоди НЕ МОЖНА бути вкладеними один в одного.';
$string['shortcode:xpladder'] = 'Покажіть частину драбини.';
$string['shortcode:xpladder_help'] = 'За замовчуванням відображатиметься частина драбини, що оточує поточного користувача.

```
[xpladder]
```

Щоб відобразити 10 найкращих студентів замість сусідів поточного користувача, встановіть параметр `top`. Ви можете за бажанням встановити кількість користувачів, які відображатимуться, наприклад `top=20`.

```
[xpladder top]
[xpladder top=15]
```

Посилання на повну драбину автоматично відображатиметься під таблицею, якщо ви не хочете відображати таке посилання, додайте аргумент `hidelink`.

```
[xpladder hidelink]
```

За замовчуванням таблиця не містить стовпець прогресу, який відображає індикатор виконання. Якщо такий стовпець вибрано в додаткових стовпцях у налаштуваннях драбини, ви можете використовувати аргумент `withprogress` для його відображення.

```
[xpladder withprogress]
```

Зауважте, що коли курс використовує групи, драбинка найкраще вгадає, до якої групи відображати драбину.';
$string['shortcode:xplevelname'] = 'Відобразити назву рівня.';
$string['shortcode:xplevelname_help'] = 'За замовчуванням тег відображає назву поточного рівня користувача. Крім того, ви можете використовувати аргумент `level` для відображення назви певного рівня.

```
[xplevelname]
[xplevelname level=5]
```

Якщо надано аргумент `level`, а рівень не існує, нічого не відображатиметься.';
$string['shortcode:xppoints'] = 'Відобразити кількість точок, відформатованих як очки досвіду.';
$string['shortcode:xpprogressbar'] = 'Індикатор прогресу поточного користувача до наступного рівня.';
$string['someoneelse'] = 'Хтось інший';
$string['somethinghappened'] = 'Щось трапилося';
$string['taskcollectionloggerpurge'] = 'Очистіть журнали збору';
$string['taskusagereport'] = 'Звіт про використання';
$string['thankyou'] = 'Дякую!';
$string['timebetweensameactions'] = 'Час, необхідний між однаковими діями';
$string['timebetweensameactions_help'] = 'Мінімальний час, необхідний для дії, яка вже відбулася раніше, приймається знову. Дія вважається ідентичною, якщо вона була поміщена в той самий контекст і об’єкт, читання повідомлення на форумі вважатиметься ідентичним, якщо той самий пост буде прочитаний знову. Якщо це значення порожнє або дорівнює нулю, воно не застосовується.';
$string['timeformaxactions'] = 'Терміни для макс. дії';
$string['timeformaxactions_help'] = 'Терміни (в секундах), протягом якого користувач не повинен перевищувати максимальну кількість дій.';
$string['tinytimedays'] = '{$a}d';
$string['tinytimehours'] = '{$a}h';
$string['tinytimeminutes'] = '{$a}m';
$string['tinytimenow'] = 'зараз';
$string['tinytimeolderyearformat'] = '%b %Y';
$string['tinytimeseconds'] = '{$a}s';
$string['tinytimeweeks'] = '{$a}w';
$string['tinytimewithinayearformat'] = '%b %e';
$string['total'] = 'Всього';
$string['unknowneventa'] = 'Невідома подія ({$a})';
$string['updateandpreview'] = 'Оновити та переглянути';
$string['upgradingplugins'] = 'Оновлення плагінів';
$string['urlaccessdeprecated'] = 'Доступ через цю URL-адресу не підтримується, будь ласка, оновіть свої посилання.';
$string['usagereport'] = 'Поділіться звітом про використання';
$string['usagereport_desc'] = 'Періодично діліться анонімною інформацією про використання з розробниками плагінів. Ця інформація допоможе краще зрозуміти, як використовується плагін, і вплине на його розвиток. Спільна інформація містить основну інформацію про сайт Moodle (URL, версія) та інформацію про використання плагіна (кількість балів користувачів, огляд налаштувань, використовувані правила, ...).';
$string['usealgo'] = 'Використовувати алгоритми';
$string['usecustomlevelbadges'] = 'Використовувати власні значки';
$string['usecustomlevelbadges_help'] = 'Коли встановлено Так, ви повинні надати оригінал зображення для кожного рівня.';
$string['usingalgo'] = 'Використання алгоритму';
$string['value'] = 'Змінні';
$string['valuessaved'] = 'Змінні були успішно збережені.';
$string['viewas'] = 'Переглянути як';
$string['viewtheladder'] = 'Хто лідер?';
$string['visualsintro'] = 'Завантажте зображення, щоб налаштувати вигляд рівнів.';
$string['wewillreplyat'] = 'Ми відповімо за адресою: _{$a}_.';
$string['when'] = 'Коли';
$string['wherearexpused'] = 'Де використовуються бали?';
$string['wherearexpused_desc'] = 'Якщо встановлено значення «На курсах», отримані бали будуть враховувати лише курс, до якого було додано блок. Якщо встановлено значення «Для всього сайту», користувач буде «підвищувати рівень» на сайті, а не вибірково за курс, будуть використані всі очки, отримані на сайті.';
$string['whoops'] = 'Опс!';
$string['xp'] = 'Набрані бали';
$string['xp:addinstance'] = 'Додайте новий блок';
$string['xp:earnxp'] = 'Заробіток балів';
$string['xp:manage'] = 'Керуйте всіма аспектами очок досвіду';
$string['xp:myaddinstance'] = 'Додати блок на мою власну панель';
$string['xp:view'] = 'Переглянути блок і його сторінки';
$string['xp:viewlogs'] = 'Перегляньте журнали';
$string['xp:viewreport'] = 'Переглянути звіт';
$string['xpgaindisabled'] = 'Набір балів вимкнено';
$string['xprequired'] = 'Потрібно балів';
$string['xptogo'] = '[[{$a}]] залишити';
$string['youreachedlevel'] = 'Ви досягли рівня:';
$string['youreachedlevela'] = 'Ви досягли рівня {$a}!';
$string['yourmessage'] = 'Твоє повідомлення';
$string['yourownrules'] = 'Свої власні правила';
