<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'uk', version '4.4'.
 *
 * @package     forum
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionsforgraderinterface'] = 'Дії для інтерфейсу оцінювача';
$string['actionsforpost'] = 'Дії для публікації';
$string['activitydate:due'] = 'Термін спливає:';
$string['activityoverview'] = 'Є нові повідомлення на форумі';
$string['addanewdiscussion'] = 'Додати тему обговорення';
$string['addanewquestion'] = 'Додати нове питання';
$string['addanewtopic'] = 'Додати нову тему';
$string['addreply'] = 'Додати відповідь';
$string['addtofavourites'] = 'Розпочати обговорення';
$string['advancedsearch'] = 'Розширений пошук';
$string['alldiscussions'] = 'Всі обговорення';
$string['allforums'] = 'Усі форуми';
$string['allowdiscussions'] = 'Чи може {$a} брати участь в цьому форумі?';
$string['allowsallsubscribe'] = 'Цей форум дозволяє кожному вибирати, бути адресатом чи ні';
$string['allowsdiscussions'] = 'У цьому форумі кожний може створити одну тему для обговорення.';
$string['allsubscribe'] = 'Стати адресатом усіх форумів';
$string['allunsubscribe'] = 'Вийти з числа адресатів усіх форумів';
$string['allusers'] = 'Усі користувачі';
$string['alreadyfirstpost'] = 'Це завжди перше повідомлення в дискусії';
$string['anyfile'] = 'Будь-які файли';
$string['areaattachment'] = 'Прикріплення';
$string['areapost'] = 'Повідомлення';
$string['attachment'] = 'Вкладення';
$string['attachment_help'] = 'Ви також можете вкласти один або більше файлів до повідомлення форуму. Якщо ви вкажете на файл картинки, то вона буде показана в кінці повідомлення.';
$string['attachmentname'] = 'Вкладення {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachmentnopost'] = 'Ви не можете експортувати вкладені файли без коду повідомлення';
$string['attachments'] = 'Вкладення';
$string['attachmentswordcount'] = 'Підрахунок вкладень та слів';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} приватно відповідає {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} відповідає {$a->author}';
$string['availability'] = 'Доступність';
$string['blockafter'] = 'Ліміт повідомлень для блокування';
$string['blockafter_help'] = 'Ця установка вказує максимальну кількість повідомлень, які студенти можуть написати за вказаний період. Користувачі з правом mod/forum:postwithoutthrottling не підпадають під обмеження.';
$string['blockperiod'] = 'Період часу для блокування';
$string['blockperiod_help'] = 'Студенти можуть бути обмежені можливою кількістю повідомлень форуму за вказаний період. Користувачі з правом mod/forum:postwithoutthrottling не підпадають під обмеження.';
$string['blockperioddisabled'] = 'Не блокувати';
$string['blogforum'] = 'Стандартний форум у форматі блогу';
$string['bynameondate'] = '{$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Статус відстеження форуму для користувача';
$string['calendardue'] = '{$a} завершується';
$string['cancelreply'] = 'Скасувати відповідь';
$string['cannotadd'] = 'Не вдається додати дискусію в цей форум';
$string['cannotadddiscussion'] = 'Додання тем обговорення на цей форум вимагає членства у групі.';
$string['cannotadddiscussionall'] = 'Ви не маєте права створювати нові теми дискусії для всіх учасників';
$string['cannotadddiscussiongroup'] = 'Ви не можете створити дискусію, оскільки не є членом жодної групи.';
$string['cannotaddsubscriber'] = 'Не вдається додати до цього форуму адресата з кодом {$a}';
$string['cannotaddteacherforumto'] = 'Не вдалося додати конвертований форум викладачів до секції 0 у курсі';
$string['cannotcreatediscussion'] = 'Не вдається створити нову дискусію';
$string['cannotcreateinstanceforteacher'] = 'Не вдається створити новий модуль курсу за зразком форуму викладачів';
$string['cannotdeletepost'] = 'Ви не можете видаляти це повідомлення!';
$string['cannoteditposts'] = 'Ви не можете редагувати повідомлення інших користувачів!';
$string['cannotexportforum'] = 'Ви не можете експортувати цей форум';
$string['cannotfavourite'] = 'Вибачте, але у вас немає дозволу позначати обговорення зірочкою.';
$string['cannotfinddiscussion'] = 'Не вдається знайти дискусію на цьому форумі';
$string['cannotfindfirstpost'] = 'Не вдається знайти перше повідомлення в цьому форумі';
$string['cannotfindorcreateforum'] = 'Не вдалося знайти або створити головний форум оголошень для сайту';
$string['cannotfindparentpost'] = 'Не знайдено початок гілки для повідомлення {$a}';
$string['cannotmovefromsingleforum'] = 'Не вдається перемістити дискусію з одиночого дискусійного форума';
$string['cannotmovenotvisible'] = 'Форум невидимий';
$string['cannotmovetonotexist'] = 'Ви не можете перемістити до цього форуму - його не існує';
$string['cannotmovetonotfound'] = 'Цільового форуму не знайдено в цьому курсі.';
$string['cannotmovetosingleforum'] = 'Не можна перемістити дискусію до одиночного простого обговорення';
$string['cannotpindiscussions'] = 'На жаль, у вас немає дозволу закріплювати обговорення.';
$string['cannotpurgecachedrss'] = 'Не вдалося очистити кешовані RSS-канали для джерела та/або призначення форуму(ів) - перевірте ваш файл permissionsforums';
$string['cannotremovesubscriber'] = 'Не вдалося видалити  з цього форуму адресата з кодом {$a}!';
$string['cannotreply'] = 'Ви не можете відповідати на це повідомлення';
$string['cannotsplit'] = 'Дискусії з цього форуму не можна відокремлювати';
$string['cannotsubscribe'] = 'Вибачте, але вам потрібно бути в групі, щоб підписатися на цей форум.';
$string['cannottrack'] = 'Не вдалося зупинити відстеження цього форуму';
$string['cannotunsubscribe'] = 'Не вдалося відписати вас з цього форуму';
$string['cannotupdatepost'] = 'Ви не можете редагувати на цьому форумі';
$string['cannotuseseperategroupsandsingletopic'] = 'Окремі групи не можна використовувати для одного простого обговорення.';
$string['cannotusesingletopicandseperategroups'] = 'Одне просте обговорення не можна використовувати з окремими групами.';
$string['cannotviewpostyet'] = 'Ви ще не можете читати дописи інших студентів у цьому обговоренні, тому що ви ще не дописували.';
$string['cannotviewusersposts'] = 'Немає записів, створених цим користувачем, які б ви могли переглядати.';
$string['cleanreadtime'] = 'Відмітити старі повідомлення як прочитані (год.)';
$string['clicktofavourite'] = 'Ви не позначили це обговорення зірочкою. Натисніть, щоб зірочкою.';
$string['clicktolockdiscussion'] = 'Натисніть, щоб заблокувати це обговорення';
$string['clicktosubscribe'] = 'Ви не підписані на цю дискусію. Натисніть, щоб підписатися.';
$string['clicktounfavourite'] = 'Ви позначили це обговорення. Натисніть, щоб зняти зірочку.';
$string['clicktounlockdiscussion'] = 'Натисніть, щоб розблокувати цю дискусію';
$string['clicktounsubscribe'] = 'Ви підписані на цю дискусію. Натисніть, щоб відписатися.';
$string['close'] = 'Закрити';
$string['closegrader'] = 'Закрити оцінювач';
$string['completiondetail:discussions'] = 'Почати обговорення: {$a}';
$string['completiondetail:posts'] = 'Зробіть повідомлення на форумі: {$a}';
$string['completiondetail:replies'] = 'Опублікувати відповіді: {$a}';
$string['completiondiscussions'] = 'Студент повинен створити дискусію:';
$string['completiondiscussionsdesc'] = 'Студент повинен створити принаймні {$a} обговорення';
$string['completiondiscussionsgroup'] = 'Вимагає дискусії';
$string['completiondiscussionshelp'] = 'вимога дискусії виконана';
$string['completionposts'] = 'Студент повинен почати дискусію або дати відповідь';
$string['completionpostsdesc'] = 'Студент має опублікувати принаймні {$a} обговорення або відповіді/відповіді';
$string['completionpostsgroup'] = 'Вимагає повідомлення';
$string['completionpostshelp'] = 'вимога початку дискусії або відповіді виконана';
$string['completionreplies'] = 'Студент повинен надіслати відповідь:';
$string['completionrepliesdesc'] = 'Студент має опублікувати принаймні {$a} відповідей/відповідей';
$string['completionrepliesgroup'] = 'Вимагає відповіді';
$string['completionreplieshelp'] = 'вимога відповіді виконана';
$string['configcleanreadtime'] = 'Час дня для очищення старих повідомлень з таблиці "читання".';
$string['configdigestmailtime'] = 'Люди, які вважають за краще мати електронні листи, надіслані їм у формі дайджесту, будуть отримувати їх щодня. Цей параметр визначає, в який час дня щоденна розсилка буде здійснюватися.';
$string['configdisplaymode'] = 'Режим обговорення, який використовується типово.';
$string['configenablerssfeeds'] = 'Це налаштування дозволить робити зміни у форматі RSS для всіх форумів. Вам потрібно вручну налаштувати це забезпечення для усіх форумів.';
$string['configenabletimedposts'] = 'Встановіть «так», якщо ви хочете дозволити встановлення періодів відображення під час публікації нового обговорення на форумі.';
$string['configlongpost'] = 'Будь-яка публікація більше такої довжини (в символах, не включаючи HTML) вважається довгою. Публікації, що відображаються на домашній сторінці сайту, на сторінках курсів у соціальному форматі або в профілі користувачів, скорочуються до природного розриву десь між значеннями forum_shortpost і forum_longpost.';
$string['configmanydiscussions'] = 'Максимальна кількість обговорень на одній сторінці';
$string['configmaxattachments'] = 'Типова максимальна кількість вкладених файлів у повідомленні.';
$string['configmaxbytes'] = 'Типовий максимальний обсяг для всіх вкладень у всіх форумах на даному сайті (це пов\'язано з обмеженнями в курсі і іншими локальними параметрами)';
$string['configoldpostdays'] = 'Кількість днів, після яких будь-яке повідомлення помічається як прочитане.';
$string['configreplytouser'] = 'Чи повинні повідомлення вміщувати адреси відправників, щоб інші могли їм відповісти поза форумом? Навіть, якщо ви вкажете "Так", користувачі у власному профілі можуть вказати, чи показувати їх електронну пошту.';
$string['configrssarticlesdefault'] = 'Якщо RSS стрічки дозволено, то встановлює типову кількість статей (дискусій або повідомлень)';
$string['configrsstypedefault'] = 'Якщо RSS стрічки дозволено, то встановлює стандартний тип діяльності.';
$string['configshortpost'] = 'Повідомлення, яке менше за цей розмір (не включаючи теги HTML), вважати коротким (див.нижче).';
$string['configsubscriptiontype'] = 'Налаштування за замовчуванням для режиму підписки.';
$string['configtrackingtype'] = 'Типові налаштування для читання повідомлень.';
$string['configtrackreadposts'] = 'Вкажіть "Так", якщо ви бажаєте, щоб всі повідомленні позначалися як прочитані/непрочитані для кожного користувача.';
$string['configusermarksread'] = 'Вкажіть "Так", якщо ви бажаєте, щоб користувачі вручну відмічали повідомлення як прочитані. Якщо "Ні", тоді після перегляду повідомлення автоматично позначаються як прочитані.';
$string['confirmsubscribe'] = 'Ви дійсно хочете підписатися на форум \'{$a}\'?';
$string['confirmsubscribediscussion'] = 'Ви справді хочете підписатися на дискусію \'{$a->discussion}\' у форумі \'{$a->forum}\'?';
$string['confirmunsubscribe'] = 'Ви дійсно хочете відписатися з форуму \'{$a}\'?';
$string['confirmunsubscribediscussion'] = 'Ви справді хочете відписатися з дискусії \'{$a->discussion}\' у форумі \'{$a->forum}\'?';
$string['couldnotadd'] = 'Повідомлення не додане через невідому помилку';
$string['couldnotdeletereplies'] = 'Видалення неможливо: на дане повідомлення вже були відповіді';
$string['couldnotupdate'] = 'Повідомлення не оновлене через невідому помилку';
$string['created'] = 'Створено';
$string['crontask'] = 'Форум розсилок і технічного обслуговування';
$string['cutoffdate'] = 'Термін неприйняття здачі';
$string['cutoffdate_help'] = 'Якщо встановлено, форум не прийматиме повідомлення після цієї дати.';
$string['cutoffdatereached'] = 'На цьому форумі досягнуто граничної дати, тому ви більше не можете публікувати на ньому повідомлення.';
$string['cutoffdatevalidation'] = 'Термін неприйняття здачі повинен бути після кінцевого терміну здачі';
$string['delete'] = 'Видалити';
$string['deleteddiscussion'] = 'Тему обговорення було видалено';
$string['deletedpost'] = 'Повідомлення було видалено';
$string['deletedposts'] = 'Ці повідомлення були видалені';
$string['deleteduser'] = 'Видалений користувач';
$string['deletesure'] = 'Ви впевнені, що хочете видалити це повідомлення?';
$string['deletesureplural'] = 'Ви впевнені, що хочете видалити це повідомлення і усі відповіді на нього? (Кількість повідомлень: {$a})';
$string['digestmailheader'] = 'Ваш щоденний огляд нових повідомлень з форумів {$a->sitename}. Щоб змінити налаштування розсилки зайдіть на {$a->userprefs}.';
$string['digestmailpost'] = 'Змінити ваші уподобання дайджесту форума';
$string['digestmailpostlink'] = 'Змінити ваші налаштування дайджесту форума: {$a}';
$string['digestmailprefs'] = 'ваш обліковий запис';
$string['digestmailsubject'] = '{$a}: огляд форума';
$string['digestmailtime'] = 'Час надсилання дайджесту з форуму';
$string['digestsentusers'] = 'Електронний огляд відправлено {$a} користувачам.';
$string['disallowsubscribe'] = 'Розсилання не дозволено';
$string['disallowsubscribeteacher'] = 'Розсилання не дозволено (крім викладачів)';
$string['disallowsubscription'] = 'Підписка';
$string['disallowsubscription_help'] = 'Цей форум налаштовано так, що ви не зможете підписатися до окремі дискусії.';
$string['discussion'] = 'Обговорення';
$string['discussionlistsortbycreatedasc'] = 'Сортувати за датою створення в порядку зростання';
$string['discussionlistsortbycreateddesc'] = 'Сортувати за датою створення в порядку спадання';
$string['discussionlistsortbydiscussionasc'] = 'Сортувати за назвою обговорення в порядку зростання';
$string['discussionlistsortbydiscussiondesc'] = 'Сортувати за назвою обговорення в порядку спадання';
$string['discussionlistsortbygroupasc'] = 'Сортувати за групами в порядку зростання';
$string['discussionlistsortbygroupdesc'] = 'Сортувати за групою в порядку спадання';
$string['discussionlistsortbylastpostasc'] = 'Сортувати за датою останньої публікації в порядку зростання';
$string['discussionlistsortbylastpostdesc'] = 'Сортувати за датою останньої публікації в порядку спадання';
$string['discussionlistsortbyrepliesasc'] = 'Сортувати за кількістю відповідей у порядку зростання';
$string['discussionlistsortbyrepliesdesc'] = 'Сортувати за кількістю відповідей у порядку спадання';
$string['discussionlistsortbystarterasc'] = 'Сортувати за назвою розпочатого обговорення в порядку зростання';
$string['discussionlistsortbystarterdesc'] = 'Сортувати за ім’ям початку обговорення в порядку спадання';
$string['discussionlocked'] = 'Це обговорення заблоковано, тому ви більше не можете на нього відповідати.';
$string['discussionlockingdisabled'] = 'Не блокуйте обговорення';
$string['discussionlockingheader'] = 'Обговорення заблоковано';
$string['discussionmoved'] = 'Обговорення переміщене в \'{$a}\'.';
$string['discussionmovedpost'] = 'Ця дискусія була переміщена <a href="{$a->discusshref}">сюди</a> у форум <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Тема обговорення';
$string['discussionnownotsubscribed'] = '{$a->name} НЕ буде отримувати сповіщення про нові повідомлення дискусії \'{$a->discussion}\' з форуму \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'Ви будете сповіщені про нові дописи в \'{$a->discussion}\' на форумі \'{$a->forum}\'.';
$string['discussionpin'] = 'Прикріпити';
$string['discussionpinned'] = 'Прикріплено';
$string['discussionpinned_help'] = 'Прикріплена дискусія буде завжди показуватися вгорі форума.';
$string['discussions'] = 'Обговорення';
$string['discussionsplit'] = 'Обговорення розділено';
$string['discussionsstartedby'] = 'Обговорення, які поча(в)ла {$a}';
$string['discussionsstartedbyrecent'] = 'Останні обговорення розпочаті {$a}';
$string['discussionsstartedbyuserincourse'] = 'Обговорення, які поча(в)ла {$a->fullname} в {$a->coursename}';
$string['discussionsstartedincourse'] = 'Обговорення розпочато в {$a}';
$string['discussionstartedby'] = 'Обговорення почато {$a}';
$string['discussionsubscribed'] = 'Тепер ви підписані на цю дискусію.';
$string['discussionsubscribestart'] = 'Надсилати мені сповіщення про нові повідомлення в цій дискусії';
$string['discussionsubscribestop'] = 'НЕ надсилати мені сповіщення про нові повідомлення в цій дискусії';
$string['discussionsubscription'] = 'Підписатися на дискусію';
$string['discussionsubscription_help'] = 'Підписка на дискусію означає, що ви будете отримувати сповіщення про нові повідомлення в цій дискусії.';
$string['discussionunpin'] = 'Відкріпити';
$string['discussionunsubscribed'] = 'Тепер ви скасували підписку на цю дискусію.';
$string['discussthistopic'] = 'Обговорення теми';
$string['discusstopicname'] = 'Обговоріть тему: {$a}';
$string['displayend'] = 'Закінчуючи в';
$string['displayend_help'] = 'Цей параметр визначає, чи повинні повідомлення бути прихованими після вказаної дати. Зауважте, що адміністратори завжди будуть бачити всі повідомлення.';
$string['displayenddate'] = 'Кінець відображення: {$a}.';
$string['displaymode'] = 'Тип показу';
$string['displayperiod'] = 'Показати в період';
$string['displaystart'] = 'Починаючи з';
$string['displaystart_help'] = 'Цей параметр визначає, чи повинні повідомлення бути показаними після вказаної дати. Зауважте, що адміністратори завжди будуть бачити всі повідомлення.';
$string['displaystartdate'] = 'Початок відображення: {$a}.';
$string['displaywordcount'] = 'Показати кількість слів';
$string['displaywordcount_help'] = 'Це налаштування визначає чи показувати підрахунок використаних слів для кожного повідомлення.';
$string['duedate'] = 'Кінцевий термін здачі';
$string['duedate_help'] = 'Це час, коли публікація на форумі є необхідною. Незважаючи на те, що ця дата відображається в календарі як термін для форуму, публікація буде дозволена після цієї дати. Встановіть кінцеву дату форуму, щоб запобігти публікації на форумі після певної дати.';
$string['duedatetodisplayincalendar'] = 'Термін відображення в календарі';
$string['eachuserforum'] = 'Кожен користувач може створити одну дискусію';
$string['edit'] = 'Редагувати';
$string['editdiscussion'] = 'Редагувати обговорення';
$string['editdiscussiontopic'] = 'Редагувати тему обговорення';
$string['editedby'] = 'Відредаговано {$a->name} - початкове подання {$a->date}';
$string['editedpostupdated'] = 'Повідомлень оновлено: {$a}';
$string['editing'] = 'Редагування';
$string['emaildigestcompleteshort'] = 'Повні повідомлення';
$string['emaildigestdefault'] = 'Типово ({$a})';
$string['emaildigestoffshort'] = 'Кожне повідомлення';
$string['emaildigestsubjectsshort'] = 'Тільки теми';
$string['emaildigesttype'] = 'Опції оповіщення ел.поштою';
$string['emaildigesttype_help'] = 'Тип повідомлення, яке ви будете отримувати з кожного форуму.

* Типово - за налаштуваннями у вашому профілі. Якщо ви оновите ваш профіль, то зміняться також налаштування тут;
* Кожне повідомлення - ви отримуватимете повідомлення про кожен пост у форумі;
* Зведення - повні повідомлення - ви отримуватимете в одному листі зведення повнотекстових повідомлень з форума раз на день;
* Зведення - тільки теми - ви отримуватимете в одному листі зведення тільки тем повідомлень з форума раз на день.';
$string['emptymessage'] = 'Відбулася помилка при обробці вашого повідомлення. Найімовірніше, ви залишили його порожнім або перевищили припустимий розмір долучення.<br /><b>Повідомлення не було збережено</b>';
$string['errorcannotlock'] = 'Ви не маєте дозволу блокувати обговорення.';
$string['errordiscussionnotfound'] = 'Обговорення не знайдено';
$string['erroremptymessage'] = 'Повідомлення не може бути порожнім';
$string['erroremptysubject'] = 'Тема повідомлення не може бути порожньою';
$string['errorenrolmentrequired'] = 'Вам потрібно бути зарахованим до курсу, щоб мати доступ до цього контенту';
$string['errorforumnotfound'] = 'Форум, якому належить ця дискусія, не знайдено';
$string['errorwhiledelete'] = 'Виникла помилка в процесі видалення повідомлення';
$string['eventassessableuploaded'] = 'Розміщено повідомлення';
$string['eventcoursesearched'] = 'Шукали курс';
$string['eventdiscussioncreated'] = 'Створено дискусію';
$string['eventdiscussiondeleted'] = 'Вилучено дискусію';
$string['eventdiscussionmoved'] = 'Переміщено дискусію';
$string['eventdiscussionpinned'] = 'Дискусію прикріплено';
$string['eventdiscussionsubscriptioncreated'] = 'Вас додано до адресатів';
$string['eventdiscussionsubscriptiondeleted'] = 'Вас вилучено з адресатів';
$string['eventdiscussionunpinned'] = 'Дискусію відкріплено';
$string['eventdiscussionupdated'] = 'Оновлено дискусію';
$string['eventdiscussionviewed'] = 'Переглянуто дискусію';
$string['eventpostcreated'] = 'Створено повідомлення';
$string['eventpostdeleted'] = 'Вилучено повідомлення';
$string['eventpostupdated'] = 'Оновлено повідомлення';
$string['eventreadtrackingdisabled'] = 'Відключено відстеження прочитання';
$string['eventreadtrackingenabled'] = 'Включено відстеження прочитання';
$string['eventsubscribersviewed'] = 'Переглянуто адресатів';
$string['eventsubscriptioncreated'] = 'Створено розсилання';
$string['eventsubscriptiondeleted'] = 'Вилучено розсилання';
$string['eventuserreportviewed'] = 'Переглянуто звіт користувача';
$string['everyonecanchoose'] = 'Усі можуть бути адресатами цього форуму';
$string['everyonecannowchoose'] = 'Кожен може зараз підписатися на форум';
$string['everyoneisnowsubscribed'] = 'Тепер всі є адресатами цього форуму';
$string['everyoneissubscribed'] = 'Кожен підписаний на цей форум';
$string['existingsubscribers'] = 'Поточні адресати';
$string['export'] = 'Експорт';
$string['exportattachmentname'] = 'Експортувати вкладений файл {$a} до портфоліо';
$string['exportdiscussion'] = 'Експорт всієї дискусії до портфоліо';
$string['exporthumandates'] = 'Дати, читабельні людиною';
$string['exporthumandates_help'] = 'Whether dates should be exported in a human-readable format or as a timestamp (sequence of numbers).';
$string['exportoptions'] = 'Параметри експорту';
$string['exportstriphtml'] = 'Видалити HTML';
$string['exportstriphtml_help'] = 'Чи потрібно видаляти HTML-теги, такі як p і br, із повідомлення на форумі.';
$string['favourites'] = 'Зірочкою';
$string['favouriteupdated'] = 'Ваш параметр зірочок оновлено.';
$string['firstpost'] = 'Перший пост';
$string['forcedreadtracking'] = 'Дозволити примусово відстежувати прочитане';
$string['forcedreadtracking_desc'] = 'Дозволяє форумам встановлювати примусове відстеження прочитаних повідомлень. Може призвести до зниження продуктивності для деяких користувачів, зокрема на курсах з багатьма форумами та повідомленнями. Якщо вимкнено, то для форумів, де раніше було встановлено в "примусове", буде розглядатися як додаткове.';
$string['forcesubscribed'] = 'Всі обов’язково є адресатами цього форуму';
$string['forcesubscribed_help'] = 'Цей форум налаштовано таким чином, що ви не можете не отримувати розсилання.';
$string['forum'] = 'Форум';
$string['forum:addinstance'] = 'Додати новий форум';
$string['forum:addnews'] = 'Додати оголошення';
$string['forum:addquestion'] = 'Додавати питання';
$string['forum:allowforcesubscribe'] = 'Примусово підписувати на розсилку';
$string['forum:canoverridecutoff'] = 'Публікуйте на форумах після дати їх закінчення';
$string['forum:canoverridediscussionlock'] = 'Відповідайте на заблоковані обговорення';
$string['forum:canposttomygroups'] = 'Публікуйте в усіх групах, до яких ви маєте доступ';
$string['forum:cantogglefavourite'] = 'Обрані обговорення';
$string['forum:createattachment'] = 'Вкладати файли';
$string['forum:deleteanypost'] = 'Видаляти будь-які повідомлення (за весь час)';
$string['forum:deleteownpost'] = 'Видаляти власні повідомлення (до останнього часу)';
$string['forum:editanypost'] = 'Редагувати будь-які повідомлення';
$string['forum:exportdiscussion'] = 'Експортувати всю дискусію';
$string['forum:exportforum'] = 'Експорт форуму';
$string['forum:exportownpost'] = 'Експортувати власне повідомлення';
$string['forum:exportpost'] = 'Експортувати повідомлення';
$string['forum:grade'] = 'Форум оцінок';
$string['forum:managesubscriptions'] = 'Керувати підписками';
$string['forum:movediscussions'] = 'Переміщувати дискусії';
$string['forum:pindiscussions'] = 'Прикріпляти дискусії';
$string['forum:postprivatereply'] = 'Відповідайте приватно на повідомлення';
$string['forum:postwithoutthrottling'] = 'Ігнорувати граничну кількість повідомлень';
$string['forum:rate'] = 'Оцінювати повідомлення';
$string['forum:readprivatereplies'] = 'Переглянути приватні відповіді';
$string['forum:replynews'] = 'Відповідати на новини';
$string['forum:replypost'] = 'Відповідати на повідомлення';
$string['forum:splitdiscussions'] = 'Виокремлювати дискусії';
$string['forum:startdiscussion'] = 'Починати нову дискусію';
$string['forum:viewallratings'] = 'Переглядати всі оцінення індивідуально';
$string['forum:viewanyrating'] = 'Переглядати будь-які оцінки';
$string['forum:viewdiscussion'] = 'Переглядати дискусії';
$string['forum:viewhiddentimedposts'] = 'Переглядати застарілі повідомлення';
$string['forum:viewqandawithoutposting'] = 'Завжди бачити повідомлення питань та відповідей';
$string['forum:viewrating'] = 'Переглядати оцінки';
$string['forum:viewsubscribers'] = 'Переглядати адресатів';
$string['forumauthorhidden'] = 'Автор (приховано)';
$string['forumblockingalmosttoomanyposts'] = 'Ви наближаєтеся до межі можливих повідомлень. Вами надіслано {$a->numposts} повідомлень за {$a->blockperiod} часу від обмеження в {$a->blockafter} повідомлень.';
$string['forumbodydeleted'] = 'Вміст цієї публікації на форумі видалено і більше не доступний.';
$string['forumbodyhidden'] = 'Ця публікація наразі прихована, швидше за все, тому, що вам потрібно спочатку опублікувати повідомлення в обговоренні, а також потрібно надіслати сповіщення про повідомлення на форумі. Інша можливість полягає в тому, що поточний час не входить у період відображення, встановлений для публікації.';
$string['forumgrader'] = 'Форумний грейдер';
$string['forumgradingnavigation'] = 'Навігація по оцінці форуму';
$string['forumgradingpanel'] = 'Панель оцінювання форуму';
$string['forumintro'] = 'Опис';
$string['forumname'] = 'Назва форуму';
$string['forumposts'] = 'Повідомлення форумів';
$string['forums'] = 'Форуми';
$string['forumsubjectdeleted'] = 'Це повідомлення на форумі було видалено';
$string['forumsubjecthidden'] = 'Тема (сховано)';
$string['forumtracked'] = 'Непрочитані повідомлення відслідковуються';
$string['forumtrackednot'] = 'Непрочитані повідомлення не відслідковуються';
$string['forumtype'] = 'Тип форуму';
$string['forumtype_help'] = 'Є 5 типів форумів:

* Єдине просте обговорення - одна тема обговорення, на яку кожен може відповісти (не може використовуватися в окремих групах)
* Кожна особа публікує одне обговорення. Кожен студент може опублікувати рівно одну нову тему для обговорення, на яку кожен може потім відповісти
* Форум запитань і відповідей - студент повинен спочатку опублікувати свою відповідь на запитання, опубліковане викладачем, перш ніж переглядати публікації інших студентів
* Стандартний форум, що відображається у форматі, подібному до блогу. Відкритий форум, на якому будь-хто може розпочати нове обговорення в будь-який час і на якому теми обговорень відображаються на одній сторінці з посиланнями «Обговорити цю тему».
* Стандартний форум для загального користування - відкритий форум, де кожен може почати нове обговорення в будь-який час';
$string['generalforum'] = 'Стандартний форум для загального використання';
$string['generalforums'] = 'Загальні форуми';
$string['grade_forum_header'] = 'Оцінювання всього форуму';
$string['grade_forum_name'] = 'Цілий форум';
$string['grade_forum_title'] = 'Оцінка';
$string['grade_rating_name'] = 'Рейтинг';
$string['graded'] = 'Оцінений';
$string['gradedby'] = 'Оцінено за';
$string['gradeforrating'] = 'Оцінка за оцікювання: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Оцінка за оцінку прихована';
$string['gradeforwholeforum'] = 'Оцінка для форуму: {$a->str_long_grade}';
$string['gradeforwholeforumhidden'] = 'Оцінка за форум прихована';
$string['gradeitem:forum'] = 'Форум';
$string['gradeitemnameforrating'] = 'Рейтинг {$a->name}';
$string['gradeitemnameforwholeforum'] = '{$a->name} весь форум';
$string['grades:gradesavedfor'] = 'Оцінка збережена для {$a->fullname}';
$string['grades:gradesavefailed'] = 'Не вдається зберегти оцінку за {$a->fullname}: {$a->error}';
$string['gradeusers'] = 'Оцінити користувачів';
$string['grading'] = 'Оцінювання';
$string['gradingstatus'] = 'Статус оцінки:';
$string['hiddenforumpost'] = 'Сховані повідомлення форума';
$string['hidegraderpanel'] = 'Приховати панель грейдера';
$string['hidepreviousrepliescount'] = 'Приховати попередні відповіді ({$a})';
$string['hideusersearch'] = 'Приховати пошук користувача';
$string['indexoutoftotal'] = '{$a->index} з {$a->total}';
$string['indicator:cognitivedepth'] = 'Форум: пізнавальний аспект';
$string['indicator:cognitivedepth_help'] = 'Цей показник базується на глибині пізнання, досягнутої студентом під час діяльності на Форумі.';
$string['indicator:cognitivedepthdef'] = 'Форум пізнавальний';
$string['indicator:cognitivedepthdef_help'] = 'Учасник досяг цього відсотка когнітивної активності, запропонованої діяльністю Форуму протягом цього інтервалу аналізу (Рівні = Немає перегляду, Перегляд, Надіслати, Переглянути відгук, Коментувати відгук, Повторно надіслати після перегляду відгуку)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Форум: соціальний аспект';
$string['indicator:socialbreadth_help'] = 'Цей показник базується на соціальному розширенні, досягнутому студентом у діяльності на Форумі.';
$string['indicator:socialbreadthdef'] = 'Форум соц';
$string['indicator:socialbreadthdef_help'] = 'Учасник досяг цього відсотка соціальної залученості, запропонованої заходами Форуму протягом цього інтервалу аналізу (Рівні = Без участі, Учасник сам, Учасник з іншими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['inforum'] = 'у {$a}';
$string['inreplyto'] = 'У відповідь на {$a}';
$string['introblog'] = 'Повідомлення до цього форуму були автоматично скопійовані з блогів користувачів цього курсу, оскільки ті записи більше недоступні';
$string['intronews'] = 'Новини й оголошення';
$string['introsocial'] = 'Відкритий форум для будь-яких обговорень';
$string['introteacher'] = 'Форум тільки для викладачів (нотування і обговорення)';
$string['invalidaccess'] = 'Звертання до цієї сторінки було некоректне';
$string['invaliddigestsetting'] = 'Отримано неправильні налаштування для відправки форумних зведень';
$string['invaliddiscussionid'] = 'Неправильний код обговорення або його більше не існує';
$string['invalidforcesubscribe'] = 'Неправильний тип примусового підписування';
$string['invalidforumid'] = 'Неправильний код форуму';
$string['invalidparentpostid'] = 'Неправильний код батьківського повідомлення';
$string['invalidpostid'] = 'Неправильний код повідомлення - {$a}';
$string['lastpost'] = 'Останнє повідомлення';
$string['learningforums'] = 'Навчальні форуми';
$string['lockdiscussion'] = 'Заблокувати обговорення';
$string['lockdiscussionafter'] = 'Заблокувати обговорення після періоду бездіяльності';
$string['lockdiscussionafter_help'] = 'Обговорення можуть бути автоматично заблоковані через певний час з моменту останньої відповіді.

Користувачі, які мають можливість відповідати на заблоковані обговорення, можуть розблокувати обговорення, відповівши на нього.';
$string['locked'] = 'Заблоковано';
$string['lockupdated'] = 'Опцію блокування оновлено.';
$string['longpost'] = 'Довге повідомлення';
$string['mailnow'] = 'Відправити повідомлення електронною поштою не очікуючи закінчення періоду можливості редагування';
$string['managesubscriptionsoff'] = 'Завершіть керування підписками';
$string['managesubscriptionson'] = 'Керуйте передплатниками';
$string['manydiscussions'] = 'Дискусій на сторінку';
$string['markalldread'] = 'Відмітити всі повідомлення дискусії як прочитані.';
$string['markallread'] = 'Відмітити всі повідомлення форуму як прочитані.';
$string['markasread'] = 'Позначити як прочитане';
$string['markasreadonnotification'] = 'Під час надсилання сповіщень про повідомлення на форумі';
$string['markasreadonnotification_help'] = 'Коли ви отримуєте сповіщення про повідомлення на форумі, ви можете вибрати, чи позначати це повідомлення як прочитане з метою відстеження форуму.';
$string['markasreadonnotificationno'] = 'Не позначайте допис як прочитаний';
$string['markasreadonnotificationyes'] = 'Позначити публікацію як прочитану';
$string['markread'] = 'Відмітити як прочитані.';
$string['markreadbutton'] = 'Відмітити <br />як прочитані.';
$string['markunread'] = 'Відмітити як не прочитані.';
$string['markunreadbutton'] = 'Відмітити <br />як не прочитані.';
$string['maxattachments'] = 'Макс. кількість вкладених файлів';
$string['maxattachments_help'] = 'Параметр визначає максимально можливу кількість файлів, які можуть бути вкладеними до повідомлення форуму.';
$string['maxattachmentsize'] = 'Макс. розмір вкладених файлів';
$string['maxattachmentsize_help'] = 'Параметр визначає максимально можливий розмір для файлу, який буде вкладено до повідомлення форуму.';
$string['maxtimehaspassed'] = 'Вибачте, але час редагування цього повідомлення ({$a}) закінчився!';
$string['message'] = 'Повідомлення';
$string['messageinboundattachmentdisallowed'] = 'Не можливо розмістити вашу відповідь, оскільки вона містить вкладення, а цей форум не дозволяє прикріпляти файли.';
$string['messageinboundfilecountexceeded'] = 'Неможливо розмістити вашу відповідь, оскільки вона містить більше число вкладень, ніж максимально дозволено для цього форума ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Неможливо розмістити вашу відповідь, оскільки загальний розмір вкладень ({$a->filesize}) перевищує максимально дозволений для цього форуму ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Неможливо розмістити вашу відповідь, оскільки форум наразі недоступний.';
$string['messageinboundnopostforum'] = 'Неможливо розмістити вашу відповідь, оскільки ви не маєте прав для роботи з форумом {$a->forum->name}.';
$string['messageinboundthresholdhit'] = 'Неможливо розмістити вашу відповідь. Ви перевищили ліміт повідомлень, встановлений в цьому форумі.';
$string['messageprovider:digests'] = 'Підписка на огляд форуму';
$string['messageprovider:posts'] = 'Повідомлення з підписаних форумів';
$string['missingsearchterms'] = 'Наступний пошук записів буде проводитися тільки в HTML частині цього повідомлення:';
$string['modeflatnewestfirst'] = 'Показувати відповіді простим списком, найновіші спочатку';
$string['modeflatoldestfirst'] = 'Показувати відповіді простим списком, найстаріші спочатку';
$string['modenested'] = 'Показувати відповіді у формі вкладених повідомлень';
$string['modenestedv2'] = 'Відображати відповіді в експериментальній вкладеній формі';
$string['modethreaded'] = 'Показувати відповіді у формі гілок обговорення';
$string['modulename'] = 'Форум';
$string['modulename_help'] = '<p>Модуль <b>Форум</b> – це засіб спілкування учасників курсу протягом тривалого часу. <b>Форум</b> дає можливість студентам ставити запитання та відповідати на запитання інших студентів. Це дозволяє вести дискусії у процесі вивчення курсу. Або викладач може ставити запитання, а студенти лише відповідають на нього. Викладач може дозволити прикріплювати різні файли до повідомлень на форумі. Повідомлення форуму можуть оцінюватися викладачами або студентами (незалежне оцінювання). Бали можуть бути об\'єднані, щоб сформувати підсумкову оцінку, яка записується до журналу оцінок.</p>
<p>Є кілька типів форумів на вибір: стандартний форум, на якому кожен може розпочати нове обговорення у будь-який час; форум, де кожен студент може розпочати одне обговорення; або форум «Питання-Відповідь», де студенти повинні спочатку відповісти на повідомлення, перш ніж вони зможуть побачити відповіді інших студентів. Дискусії можна переглядати в різних режимах відображення: у формі гілок обговорення, простим списком.</p>
<p>Учасники можуть підписатися на форум, щоб отримувати сповіщення про нові повідомлення форуму. Можна встановити такі режими підписки: добровільний, примусовий, автоматичний або повністю заборонити підписки. За потреби студентам може бути заборонено розміщувати більшу кількість повідомлень на форумі за певний період часу.</p>
<p><b>Форуми</b> мають безліч застосувань, таких як:</p>
<ul>
  <li>Простір для спілкування студентів, щоб вони познайомились один з одним</li>
  <li>Оголошення курсу (новинний форум із примусовою підпискою)</li>
  <li>Обговорення змісту курсу чи матеріалів для читання</li>
  <li>Простір для спілкування викладачів (за допомогою прихованого форуму)</li>
  <li>Центр допомоги, де викладачі та студенти можуть дати пораду, обмінюватись досвідом</li>
  <li>Індивідуальна підтримка учня (за допомогою форуму з окремими групами та з одним студентом у групі)</li>
  <li>Для розширеної діяльності, наприклад, "головоломки" для студентів, щоб обміркувати і запропонувати рішення</li>
</ul>';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Форуми';
$string['more'] = 'ще';
$string['movedmarker'] = '(Переміщено)';
$string['movethisdiscussionlabel'] = 'Перемістити поточне обговорення на вказаний форум';
$string['movethisdiscussionto'] = 'Перемістити цю дискусію в ...';
$string['mustprovidediscussionorpost'] = 'Для експорту необхідно вказати ідентифікатор обговорення або ідентифікатор публікації.';
$string['myprofileotherdis'] = 'Форум дискусій';
$string['myprofileowndis'] = 'Мій форум дискусій';
$string['myprofileownpost'] = 'Мій форум повідомлень';
$string['namenews'] = 'Оголошення';
$string['namenews_help'] = 'Форум оголошень про курси є спеціальним форумом для оголошень і автоматично створюється під час створення курсу. Курс може мати лише один форум оголошень. Розміщувати оголошення можуть лише викладачі та адміністратори. У блоці «Останні оголошення» відображатимуться останні оголошення.';
$string['namesocial'] = 'Соціальний форум';
$string['nameteacher'] = 'Викладацький форум';
$string['newforumposts'] = 'Нові повідомлення форумів';
$string['nextdiscussiona'] = 'Наступна дискусія: {$a}';
$string['nextuser'] = 'Збережіть зміни та перейдіть до наступного користувача';
$string['noattachments'] = 'Немає вкладень у цьому повідомленні';
$string['nodiscussions'] = 'Немає тем для обговорення';
$string['nodiscussionsstartedby'] = 'Цим користувачем не почато жодної дискусії';
$string['nodiscussionsstartedbyyou'] = 'Ви ще не починали жодної дискусії';
$string['noguestpost'] = 'Лише авторизовані користувачі можуть залишати повідомлення на цьому форумі.';
$string['noguestpost:title'] = 'Увійдіть, щоб продовжити';
$string['noguestsubscribe'] = 'Вибачте, але гості не можуть отримувати розсилання з форуму.';
$string['noguesttracking'] = 'Вибачте, Гостю не можна змінювати налаштовування форуму.';
$string['nomorepostscontaining'] = 'Повідомлень, що містять \'{$a}\', більше не знайдено';
$string['nonews'] = 'Поки що не було опубліковано жодних оголошень.';
$string['noonecansubscribenow'] = 'Наразі підписка заборонена';
$string['nopermissiontosubscribe'] = 'Ви не маєте прав для перегляду адресатів цього форуму';
$string['nopermissiontoview'] = 'Ви не маєте прав для перегляду цього повідомлення';
$string['nopostforum'] = 'На жаль, ви не можете писати в цей форум';
$string['noposts'] = 'Немає повідомлень';
$string['nopostsmadebyuser'] = '{$a} не залишав(ла) жодного повідомлення';
$string['nopostsmadebyyou'] = 'Ви не зробили жодного повідомлення';
$string['noquestions'] = 'Ще немає питань у цьому форумі';
$string['nosubscribers'] = 'Цей форум ще не має адресатів';
$string['notexists'] = 'Дискусії більше не існує';
$string['notgraded'] = 'Не оцінено';
$string['nothingnew'] = 'Нічого нового для {$a}';
$string['notingroup'] = 'Вибачте, але ви повинні бути членом групи, щоб побачити цей форум.';
$string['notinstalled'] = 'Модуль форуму не встановлено';
$string['notlocked'] = 'Заблоковано';
$string['notpartofdiscussion'] = 'Повідомлення не є частиною дискусії!';
$string['notrackforum'] = 'Немає не прочитаних повідомлень';
$string['notsubscribed'] = 'Ви не є адресатом';
$string['nousersmatch'] = 'За вказаними критеріями не знайдено користувачів';
$string['noviewdiscussionspermission'] = 'Ви не маєте прав для перегляду обговорень у цьому форумі';
$string['nowallsubscribed'] = 'Тепер ви підписані на всі форуми в {$a}.';
$string['nowallunsubscribed'] = 'Тепер ви скасували підписку на всі форуми в {$a}.';
$string['nowgradinguser'] = 'Оцінити зараз {$a}';
$string['nownotsubscribed'] = '{$a->name} більше НЕ буде одержувати копії повідомлень форуму \'{$a->forum}\' на e-mail.';
$string['nownottracking'] = 'Відслідковування нових повідомлень в \'{$a->forum}\' відключено для {$a->name}';
$string['nowsubscribed'] = 'Ви будете сповіщені про нові повідомлення на форумі \'{$a->forum}\'.';
$string['nowtracking'] = 'Відслідковування нових повідомлень в \'{$a->forum}\' включено для {$a->name}';
$string['numberofreplies'] = 'Кількість відповідей: {$a}';
$string['numposts'] = 'повідомлень - {$a}';
$string['olderdiscussions'] = 'Старі обговорення';
$string['oldertopics'] = 'Старі теми';
$string['oldpostdays'] = 'Прочитані після (днів)';
$string['page-mod-forum-discuss'] = 'Сторінка гілки дискусії модуля Форум';
$string['page-mod-forum-view'] = 'Головна сторінка модуля Форум';
$string['page-mod-forum-x'] = 'Будь-яка  сторінка модуля Форум';
$string['parent'] = 'Показати джерело';
$string['parentofthispost'] = 'Джерело цього повідомлення';
$string['permalink'] = 'Постійна адреса';
$string['permanentlinktoparentpost'] = 'Постійне посилання на батьківського допису';
$string['permanentlinktopost'] = 'Постійне посилання на цей пост';
$string['pindiscussion'] = 'Закріпити обговорення';
$string['pinupdated'] = 'Опцію PIN-коду оновлено.';
$string['pluginadministration'] = 'Адміністрування форуму';
$string['pluginname'] = 'Форум';
$string['postadded'] = '<p>Ваше повідомлення додано успішно.</p> <p>Ви маєте {$a} для його редагування, якщо хочете внести певні зміни.</p>';
$string['postaddedsuccess'] = 'Ваше повідомлення додано успішно.';
$string['postaddedtimeleft'] = 'Ви маєте {$a} для його редагування, якщо хочете внести певні зміни.';
$string['postbymailsuccess'] = 'Вашу відповідь "{$a->subject}" успішно опубліковано: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Вашу відповідь {$a->subject} успішно опубліковано.';
$string['postbyuser'] = '{$a->post} від {$a->user}';
$string['postincontext'] = 'Переглянути це повідомлення у контексті';
$string['postisprivatereply'] = 'Це приватна відповідь. (Це також можуть бачити вчителі та інші користувачі, які мають можливість переглядати приватні відповіді.)';
$string['postmailinfo'] = 'Це копія повідомлення, опублікованого в {$a}.';
$string['postmailnow'] = '<p>Це повідомлення буде відразу відправлене всім адресатам форуму.</p>';
$string['postmailreply'] = 'Щоб відповісти, натисніть це посилання: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Здебільшого не по темі';
$string['postrating2'] = 'Дещо є';
$string['postrating3'] = 'Те, що треба';
$string['posts'] = 'Повідомлення';
$string['postsfrom'] = 'Публікації від';
$string['postsmadebyuser'] = 'Повідомлення, що надісла(ла)в {$a}';
$string['postsmadebyuserincourse'] = 'Повідомлення, що надісла(ла)в {$a->fullname} в курсі {$a->coursename}';
$string['postsmadeincourse'] = 'Публікації, зроблені в {$a}';
$string['poststo'] = 'Публікації до';
$string['posttoforum'] = 'Надіслати до форуму';
$string['posttomygroups'] = 'Надіслати копію всім групам';
$string['posttomygroups_help'] = 'Надсилає копію цього повідомлення до всіх груп, до яких ви маєте доступ. Учасники груп, до яких ви ен маєте доступу, цього повідомлення не побачать.';
$string['postupdated'] = 'Ваше повідомлення оновлено';
$string['potentialsubscribers'] = 'Потенційні адресати';
$string['prevdiscussiona'] = 'Попередня дискусія: {$a}';
$string['previoususer'] = 'Збережіть зміни та перейдіть до попереднього користувача';
$string['privacy:digesttypenone'] = 'Ми не маємо жодних даних, що стосуються бажаного типу дайджесту форуму для цього форуму.';
$string['privacy:digesttypepreference'] = 'Ви вибрали отримувати такий тип дайджеста форуму: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'Ви вибрали наступне налаштування підписки на дискусію для цього форуму: "{$a->preference}"';
$string['privacy:metadata:core_rating'] = 'Форум використовує підсистему рейтингу для підтримки рейтингу публікацій.';
$string['privacy:metadata:core_tag'] = 'Форум використовує підсистему тегів для підтримки тегування дописів.';
$string['privacy:metadata:forum_digests'] = 'Інформація про налаштування дайджеста для кожного форуму.';
$string['privacy:metadata:forum_digests:forum'] = 'Форум підписаний на.';
$string['privacy:metadata:forum_digests:maildigest'] = 'Переваги дайджесту.';
$string['privacy:metadata:forum_digests:userid'] = 'Ідентифікатор користувача з налаштуванням дайджеста.';
$string['privacy:metadata:forum_discussion_subs'] = 'Інформація про підписку на окремі обговорення на форумі';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'Ідентифікатор обговорення, на яке ви підписалися.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'Час початку підписки.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'Ідентифікатор користувача з підпискою на обговорення.';
$string['privacy:metadata:forum_discussions'] = 'Інформація про окремі обговорення на форумі, створені користувачем';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - що зберігає це поле';
$string['privacy:metadata:forum_discussions:name'] = 'Назва дискусії за вибором автора.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'Час останньої зміни обговорення.';
$string['privacy:metadata:forum_discussions:userid'] = 'Ідентифікатор користувача, який створив обговорення';
$string['privacy:metadata:forum_discussions:usermodified'] = 'Ідентифікатор користувача, який останнім чином змінив обговорення.';
$string['privacy:metadata:forum_grades'] = 'Дані оцінок для форуму';
$string['privacy:metadata:forum_grades:forum'] = 'Форум, який був оцінений';
$string['privacy:metadata:forum_grades:grade'] = 'Присвоєна оцінка';
$string['privacy:metadata:forum_grades:userid'] = 'Користувач, який отримав оцінку';
$string['privacy:metadata:forum_posts'] = 'Інформація про налаштування дайджеста для кожного форуму.';
$string['privacy:metadata:forum_posts:created'] = 'Час створення публікації.';
$string['privacy:metadata:forum_posts:discussion'] = 'Обговорення, в якому знаходиться пост.';
$string['privacy:metadata:forum_posts:message'] = 'Повідомлення повідомлення на форумі.';
$string['privacy:metadata:forum_posts:modified'] = 'Час останньої зміни публікації.';
$string['privacy:metadata:forum_posts:parent'] = 'Батьківський допис, на який було отримано відповідь.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'Ідентифікатор користувача, якому було надіслано цю відповідь.';
$string['privacy:metadata:forum_posts:subject'] = 'Тема повідомлення на форумі.';
$string['privacy:metadata:forum_posts:totalscore'] = 'Повідомлення повідомлення на форумі.';
$string['privacy:metadata:forum_posts:userid'] = 'Ідентифікатор користувача, який написав повідомлення на форумі.';
$string['privacy:metadata:forum_queue'] = 'Тимчасовий журнал публікацій, який буде надіслано поштою у формі дайджеста';
$string['privacy:metadata:forum_queue:discussionid'] = 'Ідентифікатор дискусії на форумі';
$string['privacy:metadata:forum_queue:postid'] = 'Ідентифікатор публікації на форумі';
$string['privacy:metadata:forum_queue:timemodified'] = 'Змінений час вихідної публікації';
$string['privacy:metadata:forum_queue:userid'] = 'Користувач, якого потрібно сповістити про публікацію';
$string['privacy:metadata:forum_read'] = 'Інформація про те, які дописи були прочитані користувачем.';
$string['privacy:metadata:forum_read:discussionid'] = 'Обговорення, в якому знаходиться пост.';
$string['privacy:metadata:forum_read:firstread'] = 'Перший раз, коли пост прочитали.';
$string['privacy:metadata:forum_read:lastread'] = 'Останній час, коли публікація була прочитана.';
$string['privacy:metadata:forum_read:postid'] = 'Прочитаний пост.';
$string['privacy:metadata:forum_read:userid'] = 'Ідентифікатор користувача, до якого відноситься цей запис.';
$string['privacy:metadata:forum_subscriptions'] = 'Інформація про те, на які форуми підписаний користувач.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'Форум, на який був підписаний.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'Ідентифікатор користувача, якого стосується ця підписка на форум.';
$string['privacy:metadata:forum_track_prefs'] = 'Інформація про те, на яких форумах користувач вибрав для відстеження читання публікацій.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'Форум, на якому ввімкнено відстеження читання.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'Ідентифікатор користувача, до якого відноситься це налаштування відстеження на форумі.';
$string['privacy:metadata:preference:autosubscribe'] = 'Чи підписатися на обговорення, відповідаючи на дописи в них.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'Бажаний порядок сортування списку обговорень';
$string['privacy:metadata:preference:maildigest'] = 'Налаштування дайджеста для всього сайту';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Чи позначати повідомлення на форумі як прочитані, одержуючи їх як повідомлення.';
$string['privacy:metadata:preference:trackforums'] = 'Чи ввімкнути відстеження читання.';
$string['privacy:postwasread'] = 'Цю публікацію вперше прочитано на {$a->firstread} і останнє прочитано на {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'Ви вирішили не відстежувати повідомлення, які читали на цьому форумі.';
$string['privacy:request:delete:discussion:name'] = 'Видалити за бажанням автора';
$string['privacy:request:delete:post:message'] = 'Вміст цього допису видалено на вимогу його автора.';
$string['privacy:request:delete:post:subject'] = 'Видалити за бажанням автора';
$string['privacy:subscribedtoforum'] = 'Ви підписані на цей форум.';
$string['privatereply'] = 'Відповісти приватно';
$string['privatereply_help'] = 'Коли ви відповідаєте приватно, вашу публікацію також бачать користувачі, які мають можливість переглядати приватні відповіді, наприклад вчителі.';
$string['processingdigest'] = 'Створення огляду для {$a}';
$string['processingpost'] = 'Обробляється повідомлення {$a}...';
$string['prune'] = 'Відокремити';
$string['prunediscussion'] = 'Розділене обговорення';
$string['prunedpost'] = 'З повідомлення було створено нову дискусію';
$string['pruneheading'] = 'Виділити повідомлення з відповідями у нову тему';
$string['qandaforum'] = 'Форум Питання-Відповідь';
$string['qandanotify'] = 'Це форум питань і відповідей. Щоб побачити інші відповіді, ви повинні спочатку опублікувати свою відповідь.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Читати далі';
$string['removeallforumtags'] = 'Видаліть усі теги форуму';
$string['removefromfavourites'] = 'Видалити з обраних це обговорення';
$string['replies'] = 'Відповідей';
$string['repliesmany'] = 'Поки {$a} відповідей';
$string['repliesone'] = 'Поки {$a} відповідь';
$string['reply'] = 'Відповісти';
$string['reply_handler'] = 'Відповісти на повідомлення форума ел.поштою';
$string['reply_handler_name'] = 'Відповісти на повідомлення форума';
$string['replyauthorself'] = '{$a} (ви)';
$string['replyforum'] = 'Відповісти у форумі';
$string['replyingtoauthor'] = 'Відповідь на {$a}...';
$string['replyplaceholder'] = 'Напишіть свою відповідь...';
$string['replypostdiscussion'] = 'Відповідь на обговорення';
$string['replytopostbyemail'] = 'Ви можете відповісти на це через ел.пошту.';
$string['replytouser'] = 'Використовувати ел.адресу у відповіді';
$string['resetdigests'] = 'Видалити всі уподобання користувачів по розсиланню оглядів';
$string['resetforums'] = 'Видалити повідомлення з';
$string['resetforumsall'] = 'Видалити усі повідомлення';
$string['resetsubscriptions'] = 'Видалити розсилання форуму';
$string['resettrackprefs'] = 'Видалити всі уподобання у форумі';
$string['rssarticles'] = 'Кількість новин в RSS стрічці';
$string['rssarticles_help'] = 'Цей параметр вказує на кількість новинних статей (дискусій або повідомлень), які потрібно включити до RSS стрічки.  Найбільш прийнятною кількістю є від 5 до 20.';
$string['rsssubscriberssdiscussions'] = 'RSS стрічка дискусій';
$string['rsssubscriberssposts'] = 'RSS стрічка повідомлень';
$string['rsstype'] = 'RSS стрічка для цієї діяльності';
$string['rsstype_help'] = 'Щоб увімкнути RSS стрічку для цієї діяльності, потрібно вибрати дискусію або повідомлення та включити в стрічку.';
$string['rsstypedefault'] = 'Тип RSS стрічки';
$string['search'] = 'Пошук';
$string['search:activity'] = 'Форум - інформація про діяльність';
$string['search:post'] = 'Форум - дописи';
$string['searchdatefrom'] = 'Шукати у повідомленнях, створених після';
$string['searchdateto'] = 'Шукати у повідомленнях, створених до';
$string['searchforumintro'] = 'Будь ласка вкажіть, що необхідно знайти за допомогою одного або декількох полів, що знаходяться нижче:';
$string['searchforums'] = 'Пошук на форумах';
$string['searchfullwords'] = 'Ці слова повинні бути цілком';
$string['searchnotwords'] = 'Цих слів НЕ ПОВИННО БУТИ в повідомленнях';
$string['searcholderposts'] = 'Пошук старих повідомлень...';
$string['searchphrase'] = 'Має бути фраза цілком';
$string['searchresults'] = 'Результати пошуку';
$string['searchsubject'] = 'Ці слова повинні бути в назві теми (у заголовку) повідомлення';
$string['searchtags'] = 'Позначено тегами';
$string['searchuser'] = 'Це ім’я (прізвище) повинне відповідати автору повідомлення';
$string['searchuserid'] = 'ID автора';
$string['searchusers'] = 'Пошук користувачів';
$string['searchwhichforums'] = 'Виберіть форуми, в яких потрібно шукати';
$string['searchwords'] = 'Ці слова можуть бути в будь-якому місці повідомлення';
$string['seeallposts'] = 'Переглянути всі повідомлення цього користувача';
$string['sendstudentnotificationsdefault'] = 'Налаштування за замовчуванням для "Повідомити студентів"';
$string['sendstudentnotificationsdefault_help'] = 'Установіть значення за замовчуванням для прапорця «Повідомити студентів» у формі оцінювання.';
$string['sendstudentnotificationsno'] = 'Ні';
$string['sendstudentnotificationsyes'] = 'Так, надіслати сповіщення студенту';
$string['settings'] = 'Налаштування';
$string['shortpost'] = 'Коротке повідомлення';
$string['showgraderpanel'] = 'Показати панель оцінювання';
$string['showingcountoftotaldiscussions'] = 'Список обговорень. Показано {$a->count} з {$a->total} обговорень';
$string['showmoreusers'] = 'Показати більше користувачів';
$string['showpreviousrepliescount'] = 'Показати попередні відповіді ({$a})';
$string['showsubscribers'] = 'Показати/редагувати склад адресатів';
$string['showusersearch'] = 'Показати пошук користувача';
$string['singleforum'] = 'Одне просте обговорення';
$string['smallmessage'] = '{$a->user} відправи(в)ла в {$a->forumname}';
$string['smallmessagedigest'] = 'Дайджест форума містить {$a} повідомлен(ь)ня';
$string['starredonly'] = 'Шукати лише обговорення із зірочкою';
$string['startedby'] = 'Почато користувачем';
$string['subject'] = 'Тема';
$string['subscribe'] = 'Підписатися на форум';
$string['subscribeall'] = 'Залучити всіх у число адресатів цього форуму';
$string['subscribed'] = 'Адресат';
$string['subscribediscussion'] = 'Отримувати розсилання з цієї дискусії';
$string['subscribeenrolledonly'] = 'Вибачте, але ставати абонентами розсилання форуму можуть лише зареєстровані користувачі.';
$string['subscribenone'] = 'Вивести всіх із числа адресатів цього форуму';
$string['subscribers'] = 'Адресати';
$string['subscriberstowithcount'] = 'Адресати \'{$a}\' ({$a->count})';
$string['subscribestart'] = 'Надсилати мені сповіщення про нові повідомлення на цьому форумі';
$string['subscribestop'] = 'Я не хочу отримувати сповіщення про нові повідомлення на цьому форумі';
$string['subscription'] = 'Підписка';
$string['subscription_help'] = 'Якщо ви підписалися на форум, то це означає, що ви будете отримувати повідомлення про нові дописи у форумі
Зазвичай ви можети вибирати, підписуватися чи ні на форум, за винятком випадків, коли викладач зробив обов\'язкову підписку на форум.';
$string['subscriptionandtracking'] = 'Розсилання та відслідковування';
$string['subscriptionauto'] = 'Автопідписка';
$string['subscriptiondisabled'] = 'Підписку вимкнуто';
$string['subscriptionforced'] = 'Примусова підписка';
$string['subscriptionmode'] = 'Режим підписки';
$string['subscriptionmode_help'] = 'Коли учасник підписаний на форум, це означає, що він отримуватиме сповіщення про повідомлення на форумі. Є 4 варіанти режиму підписки:

* Додаткова підписка - учасники можуть вибрати, чи їм бути підписаними
* Примусова підписка - усі підписані і не можуть скасувати підписку
* Автоматична підписка. Спочатку всі підписані, але можуть скасувати підписку в будь-який час
* Підписка вимкнена - Підписки заборонені';
$string['subscriptionmodeconfirm'] = 'Ви впевнені, що хочете змінити режим підписки на {$a}?';
$string['subscriptionoptional'] = 'Необов\'язково';
$string['subscriptions'] = 'Підписки';
$string['tagarea_forum_posts'] = 'Повідомлення на форумі';
$string['tagsdeleted'] = 'Теги форуму видалено';
$string['thisforumhasduedate'] = 'Термін для публікації на цьому форумі {$a}.';
$string['thisforumisdue'] = 'Дата публікації на цьому форумі: {$a}.';
$string['thisforumisthrottled'] = 'Цей форум має ліміт на повідомлення та обмеження на час відповідання - поточні установки: {$a->blockafter} повідомлень за {$a->blockperiod}';
$string['timed'] = 'Час';
$string['timeddiscussion'] = 'Обговорення за часом';
$string['timedhidden'] = 'Тимчасовий статус: Приховано від студентів';
$string['timedposts'] = 'Вчасні повідомлення';
$string['timedvisible'] = 'Тимчасовий статус: Видимий для студентів';
$string['timestartenderror'] = 'Кінцева дата не може бути раніше за початкову';
$string['togglediscussionmenu'] = 'Перемкнути меню обговорення';
$string['togglefullscreen'] = 'Увімкнути повноекранний режим';
$string['togglesettingsdrawer'] = 'Перемкнути панель налаштувань';
$string['trackforum'] = 'Слідкувати за новими повідомленнями';
$string['tracking'] = 'Відстежити';
$string['trackingoff'] = 'Вимкнути';
$string['trackingon'] = 'Увімкнути';
$string['trackingoptional'] = 'Необов\'язково';
$string['trackingtype'] = 'Відслідковувати непрочитані дописи';
$string['trackingtype_help'] = 'Відстеження читання дає змогу учасникам перевірити, які дописи вони ще не бачили, виділяючи нові. Якщо встановлено опцію, учасники можуть вибрати, увімкнути чи вимкнути відстеження для форуму. (Користувачі також повинні ввімкнути відстеження форуму у своїх налаштуваннях форуму.)

Якщо адміністратор сайту увімкнув «Дозволити примусове відстеження читання», то доступна додаткова опція – примусове.

Це означає, що відстеження завжди ввімкнено, незалежно від налаштувань форуму користувачів.';
$string['trackreadposts_header'] = 'Відстеження форуму';
$string['unlockdiscussion'] = 'Розблокувати це обговорення';
$string['unpindiscussion'] = 'Відкріпити це обговорення';
$string['unread'] = 'Непрочитані';
$string['unreadpost'] = 'Непрочитаний пост';
$string['unreadposts'] = 'Непрочитані повідомлення';
$string['unreadpostsnumber'] = '{$a} непрочитаних повідомлень';
$string['unreadpostsone'] = '1 непрочитане повідомлення';
$string['unsubscribe'] = 'Скасуйте підписку на форумі';
$string['unsubscribeall'] = 'Вийти з числа адресатів усіх форумів';
$string['unsubscribeallconfirm'] = 'Наразі Ви є адресатом {$a->forums} форумів та {$a->discussions} дисккусій. Ви дійсно бажаєте вийти з числа адресатів усіх форумів та відключити автоотримання?';
$string['unsubscribeallconfirmdiscussions'] = 'Наразі ви є адресатом {$a->discussions} дискусій. Ви дійсно бажаєте вийти з числа адресатів усіх дискусій та відключити автоотримання?';
$string['unsubscribeallconfirmforums'] = 'Наразі ви є адресатом {$a->forums} форумів. Ви дійсно бажаєте вийти з числа адресатів усіх форумів та відключити автоотримання?';
$string['unsubscribealldone'] = 'Тепер Ви не є адресатом жодного форуму, але Ви можете отримувати повідомлення з деяких форумів, де Ви є адресатом примусово. Якщо Ви не бажаєте взагалі отримувати пошту з цього сервера, відключіть ел.пошту в своєму обліковому записі.';
$string['unsubscribeallempty'] = 'Ви не є адресатом жодного форуму. Якщо Ви не бажаєте взагалі отримувати пошту з цього сервера, відключіть ел.пошту в своєму обліковому записі.';
$string['unsubscribed'] = 'Не адресати';
$string['unsubscribediscussion'] = 'Анулювати розсилання цієї дискусії';
$string['unsubscribediscussionlink'] = 'Відписатися від цієї дискусії: {$a}';
$string['unsubscribelink'] = 'Відписатися від цього форуму: {$a}';
$string['unsubscribeshort'] = 'Анулювати розсилання';
$string['useexperimentalui'] = 'Використовуйте експериментальний вкладений режим обговорення';
$string['usermarksread'] = 'Ручне відзначення прочитання';
$string['usernavigation'] = 'Навігація користувача';
$string['usersforumposts'] = 'Повідомлення на форумі користувача';
$string['viewalldiscussions'] = 'Переглянути всі дискусії';
$string['viewconversation'] = 'Перегляд бесіди';
$string['viewgrades'] = 'Переглянути оцінки';
$string['viewparentpost'] = 'Переглянути батьківський допис';
$string['viewthediscussion'] = 'Перегляд обговорення';
$string['warnafter'] = 'Ліміт повідомлень для попередження';
$string['warnafter_help'] = 'Студенти можуть бути попереджені про наближення максимальної кількості повідомлень дозволених на цей час. Цей параметр визначає за скільки повідомлень до критичної кількості буде попередження. Користувачі з правами mod/forum:postwithoutthrottling звільняються від подібного обмеження.';
$string['warnformorepost'] = 'Увага! Існує більше одного обговорення в цьому форумі - використовується останнє';
$string['yournewquestion'] = 'Нове питання';
$string['yournewtopic'] = 'Тема нового обговорення';
$string['yourreply'] = 'Ваша відповідь';
