<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'solo', language 'af', version '4.4'.
 *
 * @package     solo
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ACC'] = 'Acc';
$string['ATL'] = 'ASL';
$string['GRM'] = 'GRM';
$string['LTL'] = 'LSL';
$string['SPL'] = 'Spelling';
$string['TW'] = 'TW';
$string['actions'] = 'Aksies';
$string['activitylink'] = 'Skakel na volgende aktiwiteit';
$string['activitylink_help'] = 'Om \'n skakel te verskaf ná die poging tot \'n ander aktiwiteit in die kursus, kies die aktiwiteit uit die aftrekkieslys.';
$string['activitylinkname'] = 'Gaan voort na volgende aktiwiteit: {$a}';
$string['addiframe'] = 'Voeg iFrame by';
$string['addmedia'] = 'Voeg Media by';
$string['addsetup'] = 'Stel Aktiwiteit Op';
$string['addttsaudio'] = 'Voeg TTS-oudio by';
$string['ag_overgradewordgoal'] = '/ Woorde doelwit ) x';
$string['ag_pointsper'] = 'punte per';
$string['aggroup'] = 'Outogradering';
$string['aggroup_help'] = 'Stel die formule wat gebruik word om die studente wat praat, te gradeer';
$string['apisecret'] = 'Poodll API-geheim';
$string['apisecret_details'] = 'Die Poodll API-geheim. Kyk <a href= "https://support.poodll.com/support/solutions/articles/19000083076-cloud-poodll-api-secret">hier</a> vir meer besonderhede';
$string['apiuser'] = 'Poodll API-gebruiker';
$string['apiuser_details'] = 'Die Poodle-rekeninggebruikernaam wat Poodll op hierdie werf magtig.';
$string['appauthorised'] = 'Poodll Poodll Solo is vir hierdie werf gemagtig.';
$string['appnotauthorised'] = 'Poodll Poodll Solo is NIE vir hierdie werf gemagtig nie.';
$string['ar-ae'] = 'Arabies (Golf)';
$string['ar-sa'] = 'Arabies (Modern Standaard)';
$string['attempt'] = 'Poging';
$string['attemptcontents'] = 'Pogingbeskrywing';
$string['attemptdetails'] = 'pogingbesonderhede: {$a}';
$string['attemptname'] = 'Poging';
$string['attempts'] = 'Pogings';
$string['attemptsheading'] = 'Pogings';
$string['attemptsperpage'] = 'Pogings om per bladsy te vertoon:';
$string['attemptsperpage_details'] = 'Dit stel die aantal rye wat in verslae of lyste van pogings vertoon moet word.';
$string['attemptsreport'] = 'Pogingsverslag';
$string['attemptsummary'] = 'pogingopsomming: {$a}';
$string['attempttitle'] = 'Pogingtitel';
$string['audiofile'] = 'Oudio';
$string['audiorecording'] = 'Oudio-opname';
$string['autoeval'] = 'Outomatiese Evaluasie';
$string['autograded'] = 'Outo';
$string['avacc'] = 'Gem. Acc';
$string['avatl'] = 'Gem. ASL';
$string['avltl'] = 'Gem. LSL';
$string['avspell'] = 'Gem. Spelling';
$string['avturns'] = 'Gem. Sinne';
$string['avtw'] = 'Gem. Teikenwoorde';
$string['avw'] = 'Gem. Woorde';
$string['awsregion'] = 'Gem. Area';
$string['backtotop'] = 'Terug na Begin';
$string['bahrain'] = 'Bahrein';
$string['basicheading'] = 'Basiese Verslag';
$string['basicreport'] = 'Basiese Verslag';
$string['bigword'] = 'groot woord';
$string['capetown'] = 'Kaapstad, Suid-Afrika';
$string['checking'] = '... kontroleer ...';
$string['classprogress'] = 'Klasvordering';
$string['classprogressheading'] = 'Klasvordering';
$string['classprogressreport'] = 'Klasvordering';
$string['completionallsteps'] = 'Voltooi wanneer alle stappe voltooi is';
$string['completionallsteps_help'] = 'Voltooi wanneer alle stappe voltooi is';
$string['confirmattemptdelete'] = 'Is jy seker jy wil hierdie poging <i>UITWIS</i>?';
$string['confirmattemptdeleteall'] = 'Is jy seker jy wil <i>ALLE</i> pogings <i>UITWIS</i>?';
$string['confirmattemptdeletealltitle'] = 'Wis regtig ALLE pogings uit?';
$string['confirmattemptdeletetitle'] = 'Wis regtig poging uit?';
$string['convlength'] = 'Teikentyd';
$string['credentialsinvalid'] = 'Die API-gebruiker en -geheim behoort nie gebruik te word om toegang te verkry nie. Kontroleer dit asseblief.';
$string['da-dk'] = 'Deens (DK) (slegs vinnige transkripsie)';
$string['de-ch'] = 'Duits (Switsers)';
$string['de-de'] = 'Duits (DE)';
$string['deletealluserdata'] = 'Wis alle gebruikerdata uit';
$string['deleteattempt'] = 'Wis poging uit';
$string['deleteattemptconfirm'] = 'Is jy seker dat jy hierdie poging wil uitwis?';
$string['deletenow'] = '';
$string['detailedattempts'] = 'Navorsersverslag';
$string['detailedattemptsheading'] = 'Navorsersverslag';
$string['detailedattemptsreport'] = 'Navorsersverslag';
$string['developer'] = 'Ontwikkelaar';
$string['displaygradewordgoal'] = '{$a} woorde';
$string['displaysubs'] = '{$a->subscriptionname}: verval {$a->expiredate}';
$string['done'] = 'Klaar';
$string['dopopupgrade'] = 'Gradeer gebruiker:';
$string['dopostattemptedit'] = 'Wysig die laaste poging';
$string['downloadaudio'] = 'Laai Oudio af';
$string['downloadaudioheading'] = 'Laai Oudio af';
$string['downloadaudioreport'] = 'Laai Oudio af';
$string['dublin'] = 'Dublin, Ierland';
$string['edit'] = 'Wysig';
$string['editingattempt'] = '\'n Poging word gewysig';
$string['en-ab'] = 'Engels (Skotland)';
$string['en-au'] = 'Engels (Aus.)';
$string['en-gb'] = 'Engels (GB)';
$string['en-ie'] = 'Engels (Ierland)';
$string['en-in'] = 'Engels (IN)';
$string['en-us'] = 'Engels (US)';
$string['en-wl'] = 'Engels (Wallis)';
$string['enableai'] = 'Ontsper AI';
$string['enableai_details'] = 'Poodll Solo kan uitslae van \'n studentpoging d.m.v. AI evalueer. Merk om te ontsper.';
$string['enableautograde'] = 'Ontsper outogradering';
$string['enableautograde_details'] = 'Outogradering sal \'n voorlopige en intermediêre punt vir jou studente bereken, wat jy later kan oorheers. Verstellings vir outogradering is beskikbaar in die graderingsafdeling van die aktiwiteitverstellings.';
$string['enablesetuptab'] = 'Ontsper opstel-oortjie';
$string['enablesetuptab_details'] = 'Vertoon \'n oortjie wat die aktiwiteiteksemplaarverstellings aan admins toon. In die meeste gevalle nie regtig nuttig nie.';
$string['enabletranscription'] = 'Transkripsie per hand';
$string['enabletranscription_details'] = 'Vereis van studente om hul eie gesprek per hand te transkribeer';
$string['enabletts'] = 'Ontsper TTS (eksperimenteel)';
$string['enabletts_details'] = 'TTS is nie tans geïmplementeer nie';
$string['errorheader'] = 'Fout';
$string['es-es'] = 'Spaans (ES)';
$string['es-us'] = 'Spaans (US)';
$string['evaluatedmessage'] = 'Jou nuutste poging is ontvang en die evaluasie word hieronder vertoon.';
$string['expiredays'] = 'Dae om dokument te hou';
$string['exportexcel'] = 'Voer uit na CSV';
$string['fa-ir'] = 'Farsi';
$string['feedbackheader'] = 'Voltooi';
$string['file'] = 'Dokument';
$string['finish'] = 'Voltooi';
$string['fonticonexplanation'] = 'Voeg \'n ikoonprent by om die onderwerp voor te stel. Gebruik FontAwesome daarvoor. Die patroon is fa-xxx waar xxx die ikoonnaam is. Soek vir ikone by: <a href="https://fontawesome.com/v4.7.0/icons">https://fontawesome.com/v4.7.0/icons</a>';
$string['forever'] = 'Verval nooit';
$string['fr-ca'] = 'Frans (Kan.)';
$string['fr-fr'] = 'Frans (FR)';
$string['frankfurt'] = 'Frankfurt, Duitsland';
$string['gotnosound'] = 'Ons kon jou nie hoor nie. Kontroleer asseblief die toestemmings en verstellings vir die mikrofoon en probeer weer.';
$string['grade'] = 'Merk';
$string['gradeitem:solo'] = 'Poodll Solo';
$string['gradelabel'] = 'Punt: {$a}';
$string['grades'] = 'Punte';
$string['gradesactions'] = 'Aksies';
$string['gradesaiscore'] = 'AI-punt';
$string['gradesavturnlength'] = 'AV Sinlengte';
$string['gradeschoose'] = 'Kies een:';
$string['gradesclarity'] = 'Duidelikheid';
$string['gradesdatapoint'] = 'Datapunt';
$string['gradesfeedback'] = 'Terugvoer:';
$string['gradesfirst'] = 'Eerste';
$string['gradesgrade'] = 'Merk';
$string['gradesgraded'] = 'Gemerk';
$string['gradesgradedno'] = 'Nie nagesien';
$string['gradesgradedyes'] = 'Gemerk';
$string['gradesgrader'] = 'Gemerk Deur';
$string['gradesid'] = 'ID';
$string['gradeslast'] = 'Laaste';
$string['gradesmethod'] = 'Gemerk deur';
$string['gradesrubric'] = 'Rubric';
$string['gradesstudent'] = 'Student';
$string['gradessubmit'] = 'Dien in';
$string['gradestargetwords'] = 'Teikenwoorde';
$string['gradestranscript'] = 'Transkripsie';
$string['gradesturns'] = 'Sinne';
$string['gradesubmissions'] = 'Gradeer indienings';
$string['gradeswords'] = 'Totale woorde';
$string['gradewordgoal'] = 'Totale Woorde Doelwit';
$string['gradewordgoal_help'] = 'Stel die aantal woorde wat die student moet praat om die maksimum punte te verkry wanneer outogradering gebruik word. Sien die graderingsafdeling van hierdie vorm vir meer besonderhede.';
$string['grammareval'] = 'Grammatikaevaluasie';
$string['grammarmistake'] = 'grammatikafout';
$string['he-il'] = 'Hebreeus';
$string['heard'] = 'Gehoor';
$string['hi-in'] = 'Hindi';
$string['humangraded'] = 'Onderwyser';
$string['id'] = 'ID';
$string['id-id'] = 'Indonesies';
$string['idnumber'] = 'ID-nommer';
$string['it-it'] = 'Italiaans (IT)';
$string['ja-jp'] = 'Japannees';
$string['ko-kr'] = 'Koreaans';
$string['languageandrecordingheader'] = 'Taal en Opname';
$string['letsaddsetup'] = 'Daar is nog geen onderwerp vir hierdie aktiwiteit gestel nie. Laat ons een byvoeg.';
$string['london'] = 'Londen, UK';
$string['manageattempts'] = 'Bestuur Pogings';
$string['managegrades'] = 'Bestuur Punte';
$string['managetopics'] = 'Bestuur Onderwerpe';
$string['maxconvlength'] = 'Tydsbeperking';
$string['maxconvlength_details'] = 'Tydsbeperking van Oudio-opnemer';
$string['mediaoptions'] = 'Mediaopsies';
$string['modulename'] = 'Poodll Solo';
$string['modulename_help'] = 'Poodll Solo is \'n aktiwiteit wat ontwerp is om aan studente gesprekoefening en terugvoer te verskaf. Studente neem hul eie gesprek op, transkribeer hul eie spraak en ontvang terugvoer oor hul werk.';
$string['modulenameplural'] = 'Poodll Solo';
$string['moreattemptdetails'] = 'Meer Pogingbesonderhede';
$string['ms-my'] = 'Maleis';
$string['multiattempts'] = 'Laat Veelvuldige Pogings toe';
$string['multiattempts_details'] = 'Indien gemerk, kan \'n student kies om \'n bestaande poging met \'n nuwe poging oorheen te skryf.';
$string['mumbai'] = 'Mumbai, Indië';
$string['myattempts'] = 'My Pogings';
$string['myattemptsheading'] = 'My Pogings: {$a}';
$string['myprogress'] = 'My Vordering';
$string['myprogressheading'] = 'My Vordering: {$a}';
$string['myprogressreport'] = 'My Vordering';
$string['myreports'] = 'My Verslae';
$string['name'] = 'Naam';
$string['next'] = 'Volgende';
$string['nl-nl'] = 'Nederlands';
$string['no'] = 'Geen';
$string['noapisecret'] = 'Geen API-geheim is ingevoer nie. Poodll Solo sal nie korrek werk nie.';
$string['noapiuser'] = 'Geen API-gebruiker is ingevoer nie. Poodll Solo sal nie korrek werk nie.';
$string['noattempts'] = 'Hierdie aktiwiteit bevat geen pogings nie';
$string['nodataavailable'] = 'Geen data is beskikbaar nie';
$string['nogrammarerrors'] = 'Geen grammatikafoute nie.';
$string['nosetup'] = 'Aktiwiteit is nie gereed nie';
$string['nospellingerrors'] = 'Geen spelfoute nie.';
$string['nosubscriptions'] = 'Daar is geen huidige subskripsie vir hierdie werf/invoegtoepassing nie.';
$string['notgradedyet'] = 'Jou indiening is ontvang, maar is nog nie nagesien nie. Dit kan \'n paar minute neem.';
$string['notimelimit'] = 'Onbeperk';
$string['notokenincache'] = 'Verfris om lisensie-inligting te besigtig. Kontak Poodll-ondersteuning as daar \'n probleem is.';
$string['novalidcredentials'] = 'API-gebruiker en -geheim is verwerp en kon nie toegang verkry nie. Kontroleer dit asseblief op <a href="{$a}">die verstellingsbladsy.</a> Jy kan dit by <a href="https://poodll.com/member">Poodll.com</a> kry.';
$string['ok'] = 'OK';
$string['onemin'] = '1 minuut';
$string['oneminxsecs'] = '1 minuut {$a} sekondes';
$string['ottawa'] = 'Ottawa, Kanada';
$string['overview'] = 'Oorsig';
$string['overview_help'] = 'Oorsig Hulp';
$string['partners'] = 'Maats';
$string['pluginadministration'] = 'Poodll Solo-administrasie';
$string['pluginname'] = 'Poodll Solo-aktiwiteit';
$string['possiblegrammarerrors'] = 'Moontlike grammatikafoute.';
$string['possiblespellingerrors'] = 'Moontlike spelfoute.';
$string['postattemptedit'] = 'Kan wysig ná voltooiing';
$string['postattemptedit_details'] = 'Laat student toe om hul indiening te wysig nadat dit ingedien is.';
$string['postattemptheader'] = 'Nápoging opsies';
$string['preview'] = 'Voorskou';
$string['privacy:metadata'] = 'Die invoegtoepassing van Poodll Poodll Solo berg persoonlike data.';
$string['privacy:metadata:attemptid'] = 'Die unieke identifiseerder van \'n gebruiker se Poodll Solo-poging.';
$string['privacy:metadata:attemptstable'] = 'Die Poodle Poodll Solo-pogingstabel.';
$string['privacy:metadata:attempttable'] = 'Berg die punte en ander gebruikerdata met \'n Poodll Solo-poging.';
$string['privacy:metadata:cloudpoodllcom'] = 'Die invoegtoepassing van Poodll Solo berg opnames in AWS S3-balies via cloud.poodll.com.';
$string['privacy:metadata:cloudpoodllcom:userid'] = 'Die invoegtoepassing van Poodll Solo sluit die moodle-gebruiker-ID in die URL\'e van opnames en transkripsies in';
$string['privacy:metadata:filename'] = 'Dokument-URL\'e van ingediende opnames.';
$string['privacy:metadata:jsontranscriptpurpose'] = 'Die volledige transkripsies van opnames.';
$string['privacy:metadata:solo'] = 'Die invoegtoepassing van Poodll Poodll Solo berg persoonlike data.';
$string['privacy:metadata:soloid'] = 'Die unieke identifiseerder van \'n Poodll Solo-aktiwiteiteksemplaar.';
$string['privacy:metadata:timemodified'] = 'Die laaste keer wat \'n poging vir die poging gewysig is.';
$string['privacy:metadata:transcriptpurpose'] = 'Die opname-korttranskripsies.';
$string['privacy:metadata:userid'] = 'Die gebruiker-id van die Poodle Solo-poging';
$string['processing'] = 'Verwerking';
$string['pt-br'] = 'Portugees (BR)';
$string['pt-pt'] = 'Portugees (PT)';
$string['rating_excellent'] = 'Uitstekend!';
$string['rating_fair'] = 'Dankie';
$string['rating_good'] = 'Welgedaan';
$string['rating_poor'] = 'Dankie';
$string['rating_verygood'] = 'Baie Goed';
$string['reattempt'] = 'Probeer weer';
$string['reattemptbody'] = 'As jy voortgaan, sal jou vorige pogings deur hierdie poging vervang word. OK?';
$string['reattempttitle'] = 'Probeer regtig weer?';
$string['recorderaudio'] = 'Oudio-opnemer';
$string['recorderskin'] = 'Opnemerstyl';
$string['recordertype'] = 'Opnemertipe';
$string['recordervideo'] = 'Video-opnemer';
$string['recordingaiheader'] = 'Opname en AI-opsies';
$string['refreshtoken'] = 'Verfris lisensie-inligting';
$string['region'] = 'AWS-area';
$string['reportmenuinstructions'] = 'Besigtig verslae deur die verslag uit die knoppies hieronder te selekteer.';
$string['reports'] = 'Verslae';
$string['returntoreports'] = 'Keer terug na Verslae';
$string['returntotop'] = 'Keer terug na Bo';
$string['ru-ru'] = 'Russies';
$string['saopaulo'] = 'Sao Paulo, Brasilië';
$string['saveandnext'] = 'Berg ... en volgende';
$string['secs_till_check'] = 'kontroleer vir uitslae in ...';
$string['selftranscribe'] = 'Transkribeer Gesprek';
$string['selftranscript'] = 'Transkribeer Self';
$string['sentence'] = 'sin';
$string['setup'] = 'Opstel';
$string['showingattempt'] = 'Poging vir {$a} word vertoon';
$string['singapore'] = 'Singapoer';
$string['skin123'] = 'Een Twee Drie';
$string['skinbmr'] = 'Verbrande Roos';
$string['skinfresh'] = 'Vars (slegs oudio)';
$string['skinonce'] = 'Een maal';
$string['skinplain'] = 'Eenvoudig';
$string['skinupload'] = 'Laai op';
$string['solo'] = 'solo';
$string['solo:addinstance'] = 'Voeg \'n nuwe Poodll Solo by';
$string['solo:attemptedit'] = 'Wysig pogings';
$string['solo:attemptview'] = 'Besigtig pogings';
$string['solo:grades'] = 'Besigtig Solo-punte';
$string['solo:manage'] = 'Kan Poodll Solo-eksemplare bestuur';
$string['solo:manageattempts'] = 'Kan Poodll Solo-eksemplare bestuur';
$string['solo:managetopics'] = 'Bestuur onderwerpe (voeg by/wysig/wis uit)';
$string['solo:selecttopics'] = 'Kies onderwerpe vir gebruik in aktiwiteit.';
$string['solo:submit'] = 'Kan Poodll Solo-pogings indien';
$string['solo:view'] = 'Besigtig Poodll Solo';
$string['solo:viewreports'] = 'Besigtig Poodll Solo-verslae';
$string['soloname'] = 'Poodll Solo';
$string['soloname_help'] = 'Dit is die inhoud van die hulp-nutswenk wat met die solonaamveld geassosieer word. Afmerksintaksis word ondersteun.';
$string['solosettings'] = 'solo-verstellings';
$string['speakingtargetsheader'] = 'Praatdoelwitte';
$string['speakingtips'] = 'Praatwenke';
$string['speakingtips_default'] = 'Praat eenvoudig, stadig en duidelik.';
$string['speakingtips_details'] = '';
$string['speakingtopic'] = 'Praatonderwerp';
$string['speakingtopic_help'] = 'Kort instruksies aan studente oor waaroor om te praat.';
$string['spellingeval'] = 'Spelevaluasie';
$string['spellingmistake'] = 'spelfout';
$string['stats'] = 'Stats';
$string['stats_aiaccuracy'] = 'Duidelikheid van spraak';
$string['stats_autogrammarscore'] = 'Grammatika';
$string['stats_autospellscore'] = 'Spelling';
$string['stats_avturn'] = 'Gem. Sinlengte';
$string['stats_clarity'] = 'Duidelikheid';
$string['stats_longestturn'] = 'Lengte van Langste Sin';
$string['stats_longwords'] = 'Lang Woorde';
$string['stats_targetwords'] = 'Teikenwoorde';
$string['stats_turns'] = 'Sinne';
$string['stats_uniquewords'] = 'Unieke Woorde';
$string['stats_words'] = 'Woorde';
$string['submitted'] = 'ingedien';
$string['summaryheaderintro'] = 'Kontroleer die besonderhede en uitslae van jou gesprek hieronder. Wat dink jy? Jy behoort elke keer beter te word.';
$string['summaryheadertitle'] = 'Jou Gesprekbesonderhede';
$string['summaryuserattemptheaderintro'] = '';
$string['summaryuserattemptheadertitle'] = '(Poging: {$a}) Gesprekbesonderhede';
$string['sydney'] = 'Sydney, Australië';
$string['ta-in'] = 'Tamil';
$string['tabular'] = 'Tabelaansig';
$string['targetwords'] = 'Teikenwoorde';
$string['targetwords_help'] = 'Teikenwoorde of -frases wat student behoort te probeer gebruik terwyl hy praat. Elkeen op \'n nuwe lyn.';
$string['targetwordsexplanation'] = 'Voeg teikenwoorde elk op \'n nuwe lyn by.';
$string['targetwordspoken'] = 'teikenwoord gesê';
$string['te-in'] = 'Telegu';
$string['teachereval'] = 'Onderwyserevaluasie';
$string['timecreated'] = 'Tyd Geskep';
$string['timemodified'] = 'Laaste Verander';
$string['tips'] = 'Wenke';
$string['tnav_clarity'] = 'Duidelikheid {$a}';
$string['tnav_grammar'] = 'Grammatika {$a}';
$string['tnav_spelling'] = 'Spelling {$a}';
$string['tokyo'] = 'Tokio, Japan';
$string['topic'] = 'Onderwerp';
$string['topicformtitle'] = 'Voeg by/wysig Onderwerp';
$string['topicicon'] = 'Ikoon';
$string['topiclevel'] = 'Vlak';
$string['topiclevelcourse'] = 'Kursus';
$string['topiclevelcustom'] = 'Doelgemaakte';
$string['topicname'] = 'Onderwerp';
$string['topics'] = 'Onderwerpe';
$string['topictargetwords'] = 'Teikenwoorde';
$string['totalattempts'] = 'Pogings';
$string['totalgradeables'] = '{$a} studente word gegradeer';
$string['totalunique'] = 'Unieke woorde-totaal';
$string['totalwords'] = 'Alle woorde-totaal';
$string['tr-tr'] = 'Turks';
$string['transcriber'] = 'Transkribeerder';
$string['transcriber_details'] = 'Die transkripsie-enjin om te gebruik.';
$string['transcriber_none'] = 'Geen transkripsie';
$string['transcript'] = 'Transkripsie';
$string['transcriptevaluation'] = 'Transkripsie-evaluasie';
$string['transcriptevaluationdetails'] = 'Onderstreepte of skuinsgedrukte woorde toon verskille tussen jou transkripsie en die outomatiese transkripsie aan.';
$string['transcriptnotready'] = '<i>Transkripsie is nog nie gereed nie</i>';
$string['transcripttitle'] = 'Transkribeer';
$string['ttslanguage'] = 'Teikentaal';
$string['turns'] = 'Sinne';
$string['uploading'] = '... laai op ...';
$string['useast1'] = 'US Oos';
$string['userattempts'] = 'Gebruikerpogings';
$string['userattemptsheading'] = '{$a} pogings';
$string['username'] = 'Gebruiker';
$string['users'] = 'Maats';
$string['userselections'] = 'Gebruikerseleksie';
$string['view'] = 'Besigtig';
$string['viewreport'] = 'besigtig verslag';
$string['viewreports'] = 'Besigtig Verslae';
$string['waitforsetup'] = 'Daar is nog geen onderwerp vir hierdie aktiwiteit gestel nie. Jy sal nie die aktiwiteit kan doen voordat jou onderwyser een byvoeg nie.';
$string['words'] = 'Woorde';
$string['xmins'] = '{$a} minute';
$string['xminsecs'] = '{$a->minutes} minute {$a->seconds} sekondes';
$string['xminutes'] = '{$a}:00 minute';
$string['xsecs'] = '{$a} sekondes';
$string['yes'] = 'Ja';
$string['zh-cn'] = 'Chinees (Mandaryns-Vasteland)';
