<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'id', version '4.4'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Akses ditolak';
$string['accountlocked'] = 'Akun Anda terkunci. Tautan buka kunci telah dikirim melalui surel.';
$string['accounts'] = 'Akun';
$string['accountunlocked'] = 'Akun Anda telah terbuka. Anda dapat log masuk.';
$string['addcategory'] = 'Tambahkan kategori';
$string['additionalhtml'] = 'HTML tambahan';
$string['additionalhtml_desc'] = 'Setelan ini memungkinkan Anda untuk menentukan HTML yang ingin Anda tambahkan ke setiap halaman. Anda dapat menyetel HTML yang akan ditambahkan dalam tag HEAD untuk halaman tersebut, segera setelah tag BODY dibuka, atau tepat sebelum tag badan ditutup. <br /> Melakukan hal ini memungkinkan Anda untuk menambahkan header atau footer kustom pada setiap halaman, atau tambahkan dukungan untuk layanan seperti Google Analytics dengan sangat mudah, terlepas dari tema yang Anda pilih.';
$string['additionalhtml_heading'] = 'HTML tambahan yang akan ditambahkan ke setiap halaman.';
$string['additionalhtmlfooter'] = 'Sebelum tag BODY ditutup';
$string['additionalhtmlfooter_desc'] = 'Konten di sini akan ditambahkan dalam setiap halaman tepat sebelum tag body ditutup.';
$string['additionalhtmlhead'] = 'Di dalam HEAD';
$string['additionalhtmlhead_desc'] = 'Konten di sini akan ditambahkan pada bagian bawah tag HEAD di setiap halaman.';
$string['additionalhtmltopofbody'] = 'Ketika tag BODY dibuka';
$string['additionalhtmltopofbody_desc'] = 'Konten di sini akan ditambahkan ke setiap halaman tepat di bawah tag pembuka BODY.';
$string['admincategory'] = 'Kategori: {$a}';
$string['adminseesall'] = 'Admin dapat melihat semuanya';
$string['adminseesallevents'] = 'Administrator melihat semua acara';
$string['adminseesownevents'] = 'Administrator sama seperti pengguna lain';
$string['advancedfeatures'] = 'Fitur lanjutan';
$string['agedigitalconsentverification'] = 'Verifikasi izin usia digital';
$string['agedigitalconsentverification_desc'] = 'Mengaktifkan verifikasi masa persetujuan digital sebelum menampilkan halaman pendaftaran untuk pengguna pendaftaran mandiri. Ini melindungi situs Anda dari anak di bawah umur yang mendaftar tanpa persetujuan orang tua/wali. Detail <a target="_blank" href="{$a}">Kontak dukungan</a> disediakan untuk bantuan lebih lanjut.';
$string['ageofdigitalconsentmap'] = 'Persetujuan usia digital';
$string['ageofdigitalconsentmap_desc'] = 'Usia digital izin bawaan, dan usia di negara mana pun yang berbeda dari bawaan, dapat ditentukan di sini. Masukkan setiap usia pada baris baru dengan format: kode negara, usia (dipisahkan oleh koma). Usia bawaan ditunjukkan oleh * sebagai pengganti kode negara. Kode negara ditetapkan dalam ISO 3166-2.';
$string['allcountrycodes'] = 'Semua kode negara';
$string['allowattachments'] = 'Izinkan lampiran';
$string['allowbeforeblock'] = 'Daftar yang diizinkan akan diutamakan';
$string['allowbeforeblockdesc'] = 'Secara bawaan, entri dalam daftar IP yang diblokir dicocokkan terlebih dahulu. Jika opsi ini diaktifkan, entri dalam daftar IP yang diperbolehkan diproses sebelum daftar yang diblokir.';
$string['allowcategorythemes'] = 'Izinkan tema kategori';
$string['allowcohortthemes'] = 'Izinkan tema kohor';
$string['allowcoursethemes'] = 'izinkan tema kursus';
$string['allowedemaildomains'] = 'Domain surel yang diizinkan';
$string['allowediplist'] = 'Daftar IP yang diizinkan';
$string['allowemailaddresses'] = 'Domain surel yang diizinkan';
$string['allowemojipicker'] = 'Pemilih emoji';
$string['allowframembedding'] = 'Izinkan semat bingkai';
$string['allowframembedding_help'] = 'Jika diaktifkan, situs ini dapat disematkan dalam bingkai di sistem jarak jauh, seperti yang disarankan saat menggunakan pengaya pendaftaran \'Publikasikan sebagai alat LTI\'. Jika tidak, disarankan untuk membiarkan penyematan bingkai dinonaktifkan demi alasan keamanan. Harap dicatat bahwa untuk aplikasi seluler, setelan ini diabaikan dan penyematan bingkai selalu diperbolehkan.';
$string['allowguestmymoodle'] = 'Tamu diizinkan akses Dasbor';
$string['allowindexing'] = 'Mengizinkan pengideksan oleh mesin pencari';
$string['allowindexing_desc'] = 'Ini menentukan apakah akan mengizinkan mesin perncari mengindeks situs Anda. "Dimana saja" akan memungkinkan mesin pencari untuk mencari di mana-mana termasuk halaman log masuk dan pendaftaran, yang berarti situs dengan pemaksaan masuk yang dihidupkan masih diindeks. Untuk menghindari risiko spam yang terlibat dengan halaman pendaftaran yang dapat dicari, gunakan "Di mana saja kecuali halaman login dan pendaftaran". "Tidak dimana pun" akan memberi tahu mesin telusur untuk tidak mengindeks halaman mana pun. Perhatikan ini hanya tagar di tajuk situs. Terserah mesin pencari untuk menghormati tagar tersebut.';
$string['allowindexingeverywhere'] = 'Di mana pun';
$string['allowindexingexceptlogin'] = 'Di mana pun kecuali halaman log masuk dan pendaftaran';
$string['allowindexingnowhere'] = 'Tidak di mana pun';
$string['allowobjectembed'] = 'Izinkan tag EMBED dan OBJECT';
$string['allowthemechangeonurl'] = 'Izinkan pengubahan tema melalui URL';
$string['allowuserblockhiding'] = 'Izinkan pengguna untuk sembunyikan blok';
$string['allowusermailcharset'] = 'Izinkan pengguna memilih set karakter';
$string['allowuserswitchrolestheycantassign'] = 'Izinkan pengguna tanpa kemampuan menetapkan peran untuk beralih peran';
$string['allowuserthemes'] = 'Izinkan tema pengguna';
$string['alternativefullnameformat'] = 'Alternatif format nama lengkap';
$string['alternativefullnameformat_desc'] = 'Ini menentukan bagaimana nama ditampilkan kepada pengguna dengan kemampuan viewfullnames (secara bawaan pengguna dengan peran manajer, pengajar atau pengajar noneditor). Placeholder yang dapat digunakan adalah untuk setelan "Format nama lengkap".';
$string['always'] = 'Selalu';
$string['appearance'] = 'Tampilan';
$string['aspellpath'] = 'Letak aspell';
$string['asyncbackupdisabled'] = 'Situs Anda saat ini dikonfigurasi untuk menggunakan cadangan sinkron. Pencadangan asinkron memberikan pengalaman pengguna yang lebih baik, memungkinkan pengguna melakukan operasi lain saat pencadangan atau pemulihan sedang berlangsung. Pencadangan asinkron diaktifkan untuk semua situs dari Moodle 4.5 LTS. Cadangan sinkron akan dihapus dari Moodle LMS versi setelah 4.5 LTS.';
$string['authentication'] = 'Autentikasi';
$string['authpreventaccountcreation'] = 'Cegah pembuatan akun ketika proses autentikasi';
$string['authpreventaccountcreation_help'] = 'Saat pengguna melakukan autentikasi, akun di situs secara otomatis dibuat jika belum ada. Jika basis data eksternal, seperti LDAP, digunakan untuk autentikasi, tetapi Anda ingin membatasi akses ke situs hanya untuk pengguna dengan akun yang ada, opsi ini harus diaktifkan. Akun baru perlu dibuat secara manual atau melalui fitur unggah pengguna. Perhatikan bahwa setelan ini tidak berlaku untuk autentikasi MNet.';
$string['authsettings'] = 'Kelola autentikasi';
$string['autolang'] = 'Bahasa dideteksi secara otomatis';
$string['autolangusercreation'] = 'Pada pembuatan akun, atur bahasa pengguna pengguna sebagai bahasa pilihan mereka';
$string['autologinguests'] = 'Log masuk tamu otomatis';
$string['availableto'] = 'Tersedia untuk';
$string['availabletoanyone'] = 'Tersedia untuk siapa saja yang mengunjungi situs';
$string['availabletoauthenticated'] = 'Terbatas untuk pengguna yang terautentikasi';
$string['backgroundcolour'] = 'Warna transparan';
$string['backup_shortname'] = 'Gunakan nama kursus pada berkas cadangan';
$string['backup_shortnamehelp'] = 'Gunakan nama kursus sebagai bagian dari nama berkas cadangan.';
$string['backups'] = 'Cadangan';
$string['badwordsconfig'] = 'Masukkan daftar kata yang tidak pantas, dipisahkan dengan koma.';
$string['badwordsdefault'] = 'Jika daftar kustom kosong, akan digunakan daftar bawaan dari paket bahasa.';
$string['badwordslist'] = 'Daftar kata buruk kustom';
$string['blockediplist'] = 'Daftar IP terblokir';
$string['blockinstances'] = 'Model';
$string['blockmultiple'] = 'Kelipatan';
$string['blockprotect'] = 'Lindungi model';
$string['blockprotect_help'] = 'Jika Anda mengunci jenis tertentu dari blok, maka tidak ada yang akan dapat menambah atau menghapus model. (Anda bisa, tentu saja, membuka lagi jika Anda perlu mengedit model). Ini dimaksudkan untuk melindungi blok seperti navigasi dan setelan yang sangat sulit untuk mendapatkan kembali jika sengaja dihapus.';
$string['blockprotectblock'] = 'Lindungi model {$a}';
$string['blockprotected'] = 'Model blok {$a} sekarang terlindungi';
$string['blocksettings'] = 'Setelan blok';
$string['blockunprotect'] = 'Tidak terlindungi';
$string['blockunprotectblock'] = 'Buka proteksi model {$a}';
$string['blockunprotected'] = 'Model blok {$a} tidak lagi terlindungi';
$string['bloglevel'] = 'Visibilitas Blog';
$string['bookmarkadded'] = 'Markah ditambahkan';
$string['bookmarkalreadyexists'] = 'Anda telah markahi halaman ini.';
$string['bookmarkdeleted'] = 'Markah dihapus.';
$string['bookmarkthispage'] = 'Markahi halaman ini';
$string['cacheapplication'] = 'Singgahan aplikasi';
$string['cacheapplicationhelp'] = 'Item yang disinggahkan dibagikan di antara semua pengguna dan kedaluwarsa dengan waktu yang ditentukan untuk ditayangkan (ttl).';
$string['cachejs'] = 'Singgahan Javascript';
$string['cachejs_help'] = 'Singgahan Javascript dan kompresi sangat meningkatkan kinerja pemuatan halaman. Sangat disarankan untuk situs tahap produksi (aktif). Pengembang mungkin akan ingin menonaktifkan fitur ini.';
$string['cacherequest'] = 'Meminta singgahan';
$string['cacherequesthelp'] = 'Singgahan pengguna tertentu yang kedaluwarsa saat permintaan selesai. Dirancang untuk menggantikan area di mana kami menggunakan penyimpanan statis.';
$string['cachesession'] = 'Singgahan sesi';
$string['cachesessionhelp'] = 'Singgahan pengguna tertentu yang kedaluwarsa saat sesi pengguna berakhir. Dirancang untuk mengurangi ketegangan sesi.';
$string['cachesettings'] = 'Setelan Singgahan';
$string['cachetemplates'] = 'Singgahan templat';
$string['cachetemplates_help'] = 'Singgahan templat akan meningkatkan kinerja pemuatan halaman dan sangat disarankan untuk situs produksi. Pengembang mungkin ingin menonaktifkan fitur ini.';
$string['caching'] = 'Singgahan';
$string['calendar_weekend'] = 'Hari libur';
$string['calendarexportsalt'] = 'Ekspor salt kalender';
$string['calendarsettings'] = 'Kalender';
$string['calendartype'] = 'Tipe kalender';
$string['calendartype_desc'] = 'Pilih tipe kalender bawaan untuk keseluruhan situs. Setelan ini dapat disampingkan dalam setelan kursus atau oleh pengguna di profil pribadi.';
$string['campaign'] = 'Kampanye';
$string['cannotdeletemodfilter'] = 'Anda tidak dapat membongkar \'{$a->filter}\' karena merupakan bagian dari modul \'{$a->module}\'';
$string['cannotuninstall'] = '{$a} tidak dapat dibongkar.';
$string['categoryemail'] = 'Surel';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot tidak didefinisikan dengan benar di berkas config.php. Ini termasuk karakter \'/\' di bagian akhir yang harus dihilangkan.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot tidak didefinisikan dengan benar di berkas config.php. Ini harus sesuai dengan URL yang Anda gunakan untuk mengakses halaman ini.';
$string['change'] = 'ubah';
$string['checkboxno'] = 'Tidak';
$string['checkboxyes'] = 'Ya';
$string['checkupgradepending'] = 'Peningkatan';
$string['choosefiletoedit'] = 'Pilih berkas untuk diedit';
$string['cleanup'] = 'Pembersihan';
$string['clianswerno'] = 't';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Keluar, silakan tunggu...';
$string['cliexitnow'] = 'Keluar SEKARANG JUGA';
$string['cliincorrectvalueerror'] = 'Galat, nilai salah "{$a->value}" untuk opsi "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nilai input salah, coba lagi';
$string['clistatusdisabled'] = 'Status: dinonaktifkan';
$string['clistatusenabled'] = 'Status: diaktifkan';
$string['clistatusenabledlater'] = 'status: mode pemeliharaan CLI akan diaktifkan pada {$a}';
$string['clitypevalue'] = 'tipe nilai';
$string['clitypevaluedefault'] = 'tipe nilai, tekan ENTER untuk menggunakan nilai bawaan ({$a})';
$string['cliunknowoption'] = 'Opsi tidak dikenali : {$a} Silakan gunakan opsi --help';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Untuk membersihkan singgahan yang tersisa setelah peralihan lalu lintas pengguna ke kode baru:

   php admin/cli/purge_caches.php --muc
   php admin/cli/purge_caches.php --js
   php admin/cli/purge_caches.php --filter
   php admin/cli/purge_caches.php --lainnya

Disarankan untuk melakukan pembersihan ini secara terpisah, dengan jeda antar perintah, untuk mengurangi lonjakan beban di server web.';
$string['cliupgradedefault'] = 'Setelan baru: {$a}';
$string['cliupgradedefaultheading'] = 'Setel nilai bawaan baru';
$string['cliupgradedefaultverbose'] = 'Setelan baru: {$a->name}, Nilai bawaan: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Peningkatan baris perintah dari {$a->oldversion} ke {$a->newversion} berhasil diselesaikan.';
$string['cliupgrademaintenancenotrequired'] = 'Pembaruan ini TIDAK AKAN menghasilkan mode pemeliharaan untuk pengguna.';
$string['cliupgrademaintenancerequired'] = 'Peningkatan ini AKAN menghasilkan mode pemeliharaan untuk pengguna.';
$string['cliupgradenoneed'] = 'Tidak perlu peningkatan untuk versi {$a} yang diinstal. Terima kasih telah berkunjung!';
$string['cliupgradepending'] = 'Peningkatan ditunda';
$string['cliupgradesetlock'] = 'Peningkatan telah dikunci hanya untuk eksekusi CLI.';
$string['cliupgradeunsetlock'] = 'Kunci pemutakhiran eksekusi CLI yang ada telah dihapus.';
$string['cliyesnoprompt'] = 'ketik y (Ya) atau t (Tidak)';
$string['close'] = 'Tutup';
$string['cohort_customfield'] = 'Kolom kustom Kohor';
$string['commentsperpage'] = 'Komentar yang ditampilkan per halaman';
$string['commonactivitysettings'] = 'Setelan aktivitas umum';
$string['commonfiltersettings'] = 'Setelan filter umum';
$string['commonsettings'] = 'Setelan umum';
$string['componentinstalled'] = 'Komponen terpasang';
$string['computedfromlogs'] = 'Dihitung dari log sejak {$a}.';
$string['condifmodeditdefaults'] = 'Nilai bawaan digunakan dalam formulir setelan saat membuat aktivitas atau sumber baru.';
$string['confeditorhidebuttons'] = 'Pilih tombol yang seharusnya tersembunyi di dalam editor HTML.';
$string['configallcountrycodes'] = 'Ini adalah daftar negara yang dapat dipilih di berbagai tempat, misalnya di profil pengguna. Jika kosong (bawaan) daftar di countries.php dalam paket bahasa Inggris standar digunakan. Itu adalah daftar dari ISO 3166-1. Jika tidak, Anda dapat menentukan daftar kode yang dipisahkan koma, misalnya \'GB, FR, ES\'. Jika Anda menambahkan kode non-standar baru di sini, Anda perlu menambahkannya ke countries.php di \'en\' dan paket bahasa Anda.';
$string['configallowassign'] = 'Anda dapat mengizinkan orang yang memiliki peran di sisi kiri untuk menetapkan beberapa peran kolom kepada orang lain';
$string['configallowattachments'] = 'Jika diaktifkan, surel yang dikirim dari situs ini dapat memiliki lampiran, seperti halnya lencana.';
$string['configallowcategorythemes'] = 'Jika Anda mengaktifkan ini, maka tema dapat disetel di tingkat kategori. Ini akan mempengaruhi semua kategori dan kursus anak kecuali mereka telah secara khusus menetapkan tema mereka sendiri. PERINGATAN: Mengaktifkan tema kategori dapat mempengaruhi kinerja.';
$string['configallowcohortthemes'] = 'Jika Anda mengaktifkan ini, maka tema dapat diatur di tingkat kohor. Ini akan memengaruhi semua pengguna dengan hanya satu kohor atau lebih dari satu tetapi dengan tema yang sama.';
$string['configallowcoursethemes'] = 'Jika diaktifkan, maka kursus akan diizinkan untuk menyetel temanya sendiri. Tema kursus akan mengesampingkan semua tema yang telah dipilih (situs, pengguna atau tema sesi)';
$string['configallowedemaildomains'] = 'Daftar domain surel yang diizinkan untuk diungkapkan di bagian "Dari" dari surel keluar. Bawaan "Kosong" akan menggunakan alamat Tanpa Balasan untuk semua surel keluar. Penggunaan wildcard diizinkan, mis. * .example.com akan memungkinkan surel dikirim dari subdomain example.com mana pun, tetapi bukan example.com itu sendiri. Ini akan membutuhkan entri terpisah.';
$string['configallowemailaddresses'] = 'Untuk membatasi alamat surel baru ke domain tertentu, cantumkan di sini dengan spasi. Semua domain lain akan ditolak. Untuk mengizinkan subdomain, tambahkan domain dengan \'.\' Sebelumnya. Untuk mengizinkan domain root bersama dengan subdomainnya, tambahkan domain tersebut dua kali - sekali dengan sebelumnya \'.\' dan sekali tanpa mis. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'Pemilih emoji memperbolehkan pengguna untuk memilih emoji seperti "smiley", untuk ditambahkan ke pesan dan bagian teks lainnya melalui tombol "pemilih emoji" di bilah alat "Atto".';
$string['configallowemojipickerincompatible'] = 'Konfigurasi basis data Anda saat ini tidak mendukung emoji dengan benar. Untuk mengaktifkan pemilih emoji, Anda perlu <a href="https://docs.moodle.org/en/MySQL_full_unicode_support"> untuk meningkatkan basis data Anda untuk dukungan unicode penuh </a>.';
$string['configallowguestmymoodle'] = 'Jika diaktifkan, tamu dapat mengakses Dasbor. Jika tidak, tamu akan diarahkan ke beranda situs.';
$string['configallowobjectembed'] = 'Demi keamanan, pengguna dengan peran pelajar tidak diperbolehkan menyematkan multimedia ke dalam teks menggunakan tag EMBED dan OBJECT dalam HTML, meskipun multimedia masih dapat ditampilkan menggunakan filter pengaya multimedia. Jika Anda ingin mengizinkan tag ini, aktifkan opsi ini.';
$string['configallowoverride'] = 'Anda dapat mengizinkan orang dengan peran di sisi kiri untuk mengesampingkan beberapa peran kolom';
$string['configallowoverride2'] = 'Pilih peran yang dapat dikesampingkan dengan peran masing-masing di kolom kiri. <br /> Perhatikan bahwa setelan ini hanya berlaku untuk pengguna yang memiliki hak akses moodle/role:override atau moodle/role:safeoverride.';
$string['configallowswitch'] = 'Pilih peran dimana pengguna dapat berganti, bergantung terhadap peran yang mereka miliki. Selain entri dalam tabel ini, pengguna juga harus kemampuan untuk berpindah peran moodle/role:switchroles. <br/>

Harap diingat bahwa penggantian peran hanya dapat dilakukan pada peran yang memiliki hak akses moodle/course:view, dan tidak memiliki hak moodle/course:doanything, sehingga beberapa kolom pada tabel ini dinonaktifkan.';
$string['configallowthemechangeonurl'] = 'Jika diaktifkan, tema dapat diubah dengan menambahkan baik:<br />?theme=themename ke setiap alamat URL Moodle (misal: mymoodlesite.com/?theme=afterburner) atau <br />&theme=themename ke setiap alamat internal URL Moodle (misal: mymoodlesite.com/course/view.php?id=2&theme=afterburner).';
$string['configallowuserblockhiding'] = 'Apakah Anda ingin untuk memungkinkan pengguna untuk menyembunyikan/menampilkan blok samping seluruh situs ini? Fitur ini menggunakan Javascript dan kuki untuk mengingat keadaan masing-masing blok yang dapat diciutkan, dan hanya mempengaruhi apa yang dilihat oleh pengguna.';
$string['configallowusermailcharset'] = 'Jika diaktifkan, pengguna dapat memilih rangkaian karakter surel di preferensi olah pesan mereka.';
$string['configallowuserswitchrolestheycantassign'] = 'Secara bawaan, moodle/role:assign diperlukan bagi pengguna untuk berganti peran. Mengaktifkan setelan ini menghapus persyaratan ini, dan mengakibatkan peran yang tersedia di menu tarik-turun "Alihkan peran ke" ditentukan oleh setelan di tabel "Izinkan penetapan peran" saja. Direkomendasikan bahwa setelan di tabel "Izinkan penetapan peran" tidak memungkinkan pengguna untuk beralih ke peran dengan kemampuan lebih dari peran mereka yang sudah ada.';
$string['configallowuserthemes'] = 'Jika Anda mengaktifkan ini, maka pengguna akan diizinkan untuk mengatur tema sendiri. Tema pengguna mengesampingkan tema situs (tapi tidak menimpa tema kursus)';
$string['configallowview'] = 'Pilih peran mana yang akan dilihat pengguna, dapat difilter sebagai contoh: Berdasarkan peran yang sudah mereka miliki.';
$string['configallusersaresitestudents'] = 'Untuk aktivitas di beranda situs, haruskah SEMUA pengguna dianggap sebagai siswa? Jika Anda menjawab "Ya", maka akun pengguna yang dikonfirmasi akan diizinkan untuk berpartisipasi sebagai siswa dalam aktivitas tersebut. Jika Anda menjawab "Tidak", maka hanya pengguna yang sudah menjadi peserta dalam setidaknya satu kursus yang dapat mengambil bagian dalam aktivitas beranda situs tersebut. Hanya admin dan pengajar yang ditugaskan khusus yang dapat bertindak sebagai pengajar untuk aktivitas beranda situs.';
$string['configauthenticationplugins'] = 'Pilih pengaya autentikasi yang ingin
Anda gunakan dan dalam urutan <em> failtrough</em>.';
$string['configautolang'] = 'Deteksi bahasa bawaan dari aturan peramban, jika dinonaktifkan akan digunakan aturan dari situs.';
$string['configautolangusercreation'] = 'Jika diaktifkan, saat akun pengguna dibuat secara otomatis saat pertama kali masuk (mis. Menggunakan autentikasi LDAP atau OAuth 2), bahasa peramban pengguna diatur sebagai bahasa pilihan mereka. Jika tidak, bahasa bawaan untuk situs ditetapkan sebagai bahasa pilihan pengguna.';
$string['configautologinguests'] = 'Apakah  pengunjung dapat masuk sebagai tamu secara otomatis saat memasuki kursus dengan akses tamu?';
$string['configbloglevel'] = 'Setelan ini memungkinkan Anda untuk membatasi tingkatan ke pengguna blog mana saja dapat ditampilkan pada situs ini. Catat bahwa mereka menentukan konteks maksimum pengunjung bukan pada poster atau tipe kiriman blog. Blog juga dapat di nonaktifkan sepenuhnya jika Anda tidak menginginkan semuanya.';
$string['configcalendarcustomexport'] = 'Aktifkan ekspor rentang tanggal kustom kalender';
$string['configcalendarexportsalt'] = 'Teks acak ini digunakan untuk meningkatkan keamanan token autentikasi yang digunakan untuk mengekspor kalender. Harap dicatat bahwa semua token saat ini tidak valid jika Anda mengubah \'salt\' \'hash\' ini.';
$string['configcookiesecure'] = 'Jika server hanya menerima koneksi https, disarankan untuk mengaktifkan pengiriman kuki aman. Jika diaktifkan, pastikan server web tidak menerima http:// atau mengatur pengalihan permanen ke https:// alamat dan mengirim header HSTS secara ideal. Ketika alamat <em> wwwroot </em> tidak dimulai dengan https:// setelan ini diabaikan.';
$string['configcountry'] = 'Jika Anda menetapkan negara di sini, maka negara ini akan dipilih secara bawaan pada akun pengguna baru. Untuk memaksa pengguna memilih negara, biarkan ini tidak disetel.';
$string['configcoursegraceperiodafter'] = 'Klasifikasikan kursus sebelumnya sebagai yang sedang berlangsung selama beberapa hari ini setelah tanggal akhir kursus.';
$string['configcoursegraceperiodbefore'] = 'Klasifikasikan kursus yang akan datang sebagai yang sedang berlangsung selama beberapa hari ini sebelum tanggal mulai kursus.';
$string['configcourseoverviewfilesext'] = 'Daftar ekstensi ringkasan kursus yang dipisahkan koma.';
$string['configcourseoverviewfileslimit'] = 'Jumlah maksimum berkas yang dapat ditampilkan di sebelah ikhtisar kursus pada daftar halaman kursus. Berkas gambar pertama yang ditambahkan digunakan sebagai gambar kursus dalam ikhtisar kursus di Dasbor pengguna; setiap berkas tambahan ditampilkan hanya pada daftar halaman kursus.';
$string['configcourserequestnotify'] = 'Ketik nama pengguna untuk diberitahu ketika kursus baru diminta.';
$string['configcourserequestnotify2'] = 'Pengguna akan diberitahu ketika kursus diminta. Hanya pengguna yang dapat menyetujui permintaan kursus tercantum di sini.';
$string['configcoursesperpage'] = 'Masukkan jumlah kursus yang akan ditampilkan per halaman pada tampilan daftar kursus.';
$string['configcourseswithsummarieslimit'] = 'Jumlah maksimum kursus akan ditampilkan dalam daftar kursus termasuk ringkasan sebelum kembali ke daftar yang lebih sederhana.';
$string['configcronclionly'] = 'Menjalankan cron dari peramban web dapat mengekspos informasi istimewa ke pengguna anonim. Jadi disarankan untuk hanya menjalankan cron dari baris perintah atau mengatur kata sandi cron untuk akses jarak jauh.';
$string['configcronremotepassword'] = 'Ini berarti skrip cron.php tidak dapat dijalankan dari peramban web tanpa memberikan kata sandi menggunakan bentuk URL:
<pre> https://site.example.com/admin/cron.php?password=opensesame </pre>
JIka ini tidak diisi, maka kata sandi tidak diperlukan.';
$string['configcurlcache'] = 'Waktu hidup untuk singgahan cURL, dalam hitungan detik.';
$string['configcustommenuitems'] = 'Menu kustom dapat dikonfigurasi di sini. Masukkan setiap item menu pada baris baru dengan format: teks menu, URL tautan (opsional, bukan untuk item menu top dengan sub-item), judul tooltip (opsional) dan kode bahasa atau daftar kode yang dipisahkan koma ( opsional, untuk menampilkan garis ke pengguna dari bahasa yang ditentukan saja), dipisahkan oleh karakter pipa. Baris yang dimulai dengan tanda hubung akan muncul sebagai item menu di menu tingkat atas sebelumnya dan ### membuat pembagi. Sebagai contoh:
<pre>
Kursus -Semua Kursus|/course/
-Pencarian Kursus|/course/search.php
-### -FAQ|https://someurl.xyz/faq
-Pertanyaan yang sering diajukan|https://someurl.xyz/pmf||es
Aplikasi seluler|https://someurl.xyz/app|Unduh aplikasi kami
</pre>';
$string['configcustomusermenuitems'] = 'Anda dapat mengonfigurasi konten menu pengguna (dengan pengecualian tautan keluar, yang ditambahkan secara otomatis). Setiap baris dipisahkan oleh karakter pipa dan terdiri dari 1) string dalam bentuk "langstringname, componentname" atau sebagai teks biasa, dan 2) URL. Pembagi dapat digunakan dengan menambahkan satu baris # karakter atau lebih jika diinginkan.';
$string['configdbsessions'] = 'Jika diaktifkan, setelan ini akan menggunakan basis data untuk menyimpan informasi tentang sesi saat ini. Perhatikan bahwa mengubah setelan ini sekarang akan mengeluarkan semua pengguna saat ini (termasuk Anda). Jika Anda menggunakan MySQL, pastikan bahwa \'max_allowed_packet\' di my.cnf (atau my.ini) minimal 4M. Pemacu sesi lainnya dapat dikonfigurasi secara langsung di config.php, lihat config-dist.php untuk informasi lebih lanjut. Opsi ini menghilang jika Anda menentukan pemacu sesi di berkas config.php.';
$string['configdebug'] = 'Jika Anda mengaktifkan ini, maka error_reporting PHP akan ditingkatkan sehingga lebih banyak peringatan dicetak. Ini hanya berguna untuk pengembang.';
$string['configdebugdisplay'] = 'Setel ke aktif, pelaporan kesalahan akan menuju ke halaman HTML. Ini praktis, tetapi merusak header XHTML, JS, kuki, dan HTTP secara umum. Jika disetel ke nonaktif, ini akan mengirim keluaran ke log server Anda, memungkinkan awakutu yang lebih baik. Setelan PHP error_log mengontrol ke mana log ini masuk.';
$string['configdebugpageinfo'] = 'Aktifkan bila Anda menghendaki informasi halaman ikut dicetak pada bagian footer.';
$string['configdebugvalidators'] = 'Aktifkan jika Anda ingin memiliki tautan ke server validator eksternal di footer halaman. Anda mungkin perlu membuat pengguna baru dengan nama pengguna <em> w3cvalidator </em>, dan mengaktifkan akses tamu. Perubahan ini memungkinkan akses tidak sah ke server, jangan aktifkan di situs produksi!';
$string['configdefaulthomepage'] = 'Halaman mana yang harus diarahkan pengguna setelah masuk ke situs? Setelan ini juga menentukan tautan pertama dalam navigasi untuk pengguna tema berbasis Klasik.';
$string['configdefaultrequestcategory'] = 'Kursus yang diminta oleh pengguna dengan kemampuan untuk meminta kursus baru dalam konteks sistem akan ditempatkan dalam kategori ini kecuali pengguna dapat memilih kategori yang berbeda.';
$string['configdefaultrequestedcategory'] = 'Kategori bawaan untuk memasukkan kursus yang diminta, jika disetujui.';
$string['configdefaultuserroleid'] = 'Semua pengguna yang masuk akan diberikan kemampuan peran yang Anda tentukan di sini, di tingkat situs, dalam ADDITION ke peran lain yang mungkin telah diberikan kepada mereka. Bawaannya adalah peran pengguna terautentikasi. Perhatikan bahwa ini tidak akan bertentangan dengan peran lain yang mereka miliki kecuali Anda melarang kemampuan, itu hanya memastikan bahwa semua pengguna memiliki kemampuan yang tidak dapat ditugaskan di tingkat kursus (misalnya mengirim entri blog, mengelola kalender sendiri, dll).';
$string['configdeleteincompleteusers'] = 'Setelah periode ini, akun apa pun tanpa nama depan, nama belakang, atau kolom surel yang diisi akan dihapus.';
$string['configdeleteunconfirmed'] = 'Untuk metode autentikasi tertentu, seperti pendaftaran mandiri berbasis surel, pengguna harus mengkonfirmasi akun mereka dalam waktu tertentu. Setelah periode ini, semua akun lama yang belum dikonfirmasi akan dihapus.';
$string['configdenyemailaddresses'] = 'Untuk menolak alamat surel dari domain tertentu daftarkan mereka di sini dengan cara yang sama. Semua domain lainnya akan diterima. Untuk menolak subdomain, tambahkan domain dengan \'.\' Sebelumnya. misal, <strong> hotmail.com yahoo.co.uk .live.com </strong>';
$string['configdisableuserimages'] = 'Nonaktifkan fitur pengubahan foto pada profil pengguna.';
$string['configdisplayloginfailures'] = 'Ini akan menampilkan informasi kepada pengguna tentang log masuk yang gagal sebelumnya.';
$string['configdndallowtextandlinks'] = 'Mengaktifkan atau menonaktifkan menyeret dan melepaskan teks dan tautan ke halaman kursus, di samping menyeret dan melepaskan berkas. Perhatikan bahwa menyeret teks ke Firefox atau di antara server yang berbeda tidak dapat diandalkan dan mungkin mengakibatkan tidak ada data yang diunggah, atau teks rusak yang diunggah.';
$string['configdoclang'] = 'Bahasa ini akan digunakan dalam tautan untuk halaman dokumentasi.';
$string['configdocroot'] = 'Mendefinisikan jalur ke Moodle Docs untuk menyediakan dokumentasi konteks spesifik melalui tautan \'Dokumentasi untuk halaman ini\' di footer setiap halaman. Jika kolom ini dibiarkan kosong, tautan tidak akan ditampilkan.';
$string['configdoctonewwindow'] = 'Jika Anda mengaktifkan ini, tautan ke Moodle Docs akan ditampilkan di jendela baru.';
$string['configduration_high'] = 'Nilai ini terlalu tinggi. Nilai maksimumnya adalah {$a}.';
$string['configduration_low'] = 'Nilai ini terlalu rendah. Nilai minimumnya adalah {$a}.';
$string['configeditordictionary'] = 'Nilai ini akan digunakan jika aspell tidak memiliki kamus untuk bahasa pengguna sendiri.';
$string['configeditorfontlist'] = 'Pilih fon yang akan muncul di daftar tarik-turun editor.';
$string['configemailchangeconfirmation'] = 'Membutuhkan langkah konfirmasi surel ketika pengguna mengubah alamat surel mereka di profil mereka.';
$string['configemaildkimselector'] = 'Pemilih DKIM bersifat arbitrer dan data DNS Anda harus cocok dengan ini.';
$string['configemailfromvia'] = 'Tambahkan melalui informasi di bagian "Dari" surel keluar. Ini menginformasikan kepada penerima dari mana surel ini berasal dan juga membantu penerima yang secara tidak sengaja membalas ke alamat surel tanpa balasan.';
$string['configemailheaders'] = 'Tajuk surel mentah akan ditambahkan kata demi kata ke semua surel keluar.';
$string['configemailsubjectprefix'] = 'Teks yang diawali dengan baris subjek semua surel keluar.';
$string['configenableanalytics'] = 'Model analitik, seperti \'Siswa berisiko putus sekolah\' atau \'Aktivitas mendatang\', dapat menghasilkan prediksi, mengirimkan pemberitahuan wawasan, dan menawarkan tindakan lebih lanjut seperti mengirim pesan kepada pengguna.';
$string['configenableblogs'] = 'Tombol ini menyediakan blog mereka sendiri bagi semua pengguna situs.';
$string['configenablecalendarexport'] = 'Aktifkan ekspor atau berlangganan ke kalender.';
$string['configenablecomments'] = 'Aktifkan komentar';
$string['configenablecourserequests'] = 'Jika diaktifkan, pengguna dengan kemampuan untuk meminta kursus baru (moodle/course:request) akan memiliki opsi untuk meminta kursus. Kemampuan ini tidak diperbolehkan untuk salah satu peran bawaan. Ini dapat diterapkan dalam konteks sistem atau kategori.';
$string['configenabledevicedetection'] = 'Memungkinkan deteksi ponsel, ponsel cerdas, tablet atau perangkat bawaan (PC desktop, laptop, dll) untuk aplikasi tema dan fitur lainnya.';
$string['configenablemobilewebservice'] = 'Aktifkan layanan seluler untuk aplikasi Moodle resmi atau aplikasi lain yang memintanya. Untuk informasi lebih lanjut, baca {$a}';
$string['configenablerssfeeds'] = 'Jika diaktifkan, umpan RSS dihasilkan oleh berbagai fitur di seluruh situs, seperti blog, forum, aktivitas basis data, dan glosarium. Perhatikan bahwa umpan RSS juga perlu diaktifkan untuk modul aktivitas tertentu.';
$string['configenablerssfeedsdisabled'] = 'Ini tidak tersedia karena umpan RSS dinonaktifkan di semua Situs. Untuk mengaktifkannya, buka setelan variabel di bawah Konfigurasi Admin.';
$string['configenablerssfeedsdisabled2'] = 'Umpan RSS saat ini dinonaktifkan di tingkat situs. Mungkin diaktifkan di fitur tingkat lanjut di administrasi situs.';
$string['configenablestats'] = 'Jika Anda memilih \'ya\' di sini, cronjob Moodle akan memproses log dan mengumpulkan beberapa statistik. Bergantung pada jumlah lalu lintas di situs Anda, ini bisa memakan waktu cukup lama. Jika Anda mengaktifkan ini, Anda akan dapat melihat beberapa grafik dan statistik yang menarik tentang masing-masing program studi Anda, atau secara keseluruhan.';
$string['configenabletrusttext'] = 'Sesuai bawaan, Moodle akan selalu membersihkan teks yang berasal dari pengguna untuk menghapus semua skrip, media, dll yang mungkin berisiko terhadap keamanan. Sistem Konten Tepercaya adalah cara untuk memberikan pengguna tertentu yang Anda percayai kemampuan untuk memasukkan fitur-fitur canggih ini dalam konten mereka tanpa gangguan. Untuk mengaktifkan sistem ini, Anda harus terlebih dahulu mengaktifkan setelan ini, dan kemudian memberikan izin Konten Tepercaya ke peran Moodle tertentu. Teks yang dibuat atau diunggah oleh pengguna tersebut akan ditandai sebagai tepercaya dan tidak akan dibersihkan sebelum ditampilkan.';
$string['configenablewebservices'] = 'Layanan web memungkinkan sistem lain, seperti aplikasi Moodle, untuk masuk ke situs dan melakukan operasi. Untuk keamanan ekstra, setelan harus dinonaktifkan jika Anda tidak menggunakan aplikasi, atau alat / layanan eksternal yang memerlukan integrasi melalui layanan web.';
$string['configenablewsdocumentation'] = 'Aktifkan dokumentasi layanan web pembuatan otomatis. Seorang pengguna dapat mengakses dokumentasinya sendiri di halaman kunci keamanannya {$a}. Ini menampilkan dokumentasi hanya untuk protokol yang diaktifkan.';
$string['configerrorlevel'] = 'Pilih jumlah peringatan PHP yang ingin Anda tampilkan. Normal biasanya merupakan pilihan terbaik.';
$string['configexportlookahead'] = 'Hari untuk melihat ke depan selama ekspor';
$string['configexportlookback'] = 'Hari untuk melihat ke belakang selama ekspor';
$string['configextendedusernamechars'] = 'Jika diaktifkan, nama pengguna dapat menyertakan karakter apa pun kecuali huruf besar. Jika tidak, hanya karakter alfanumerik dengan huruf kecil, garis bawah (_), tanda hubung (-), titik (.) Dan pada simbol (@) yang diizinkan.';
$string['configextramemorylimit'] = 'Beberapa skrip seperti pencarian, pencadangan/pemulihan atau cron membutuhkan lebih banyak memori. Setel nilai lebih tinggi untuk situs besar.';
$string['configfilterall'] = 'Filter semua string, termasuk tajuk, judul, bilah navigasi, dan sebagainya. Ini sebagian besar berguna saat menggunakan filter multilang, jika tidak maka hanya akan membuat beban ekstra di situs Anda untuk sedikit keuntungan.';
$string['configfiltermatchoneperpage'] = 'Filter penautan otomatis hanya akan menghasilkan satu tautan untuk model teks pencocokan pertama yang ditemukan di laman lengkap. Semua yang lain diabaikan.';
$string['configfiltermatchonepertext'] = 'Filter penautan otomatis hanya akan menghasilkan satu tautan untuk model teks pertama yang cocok ditemukan di setiap item teks pada halaman. Semua yang lain diabaikan. Setelan ini tidak berpengaruh jika \'Filter cocok satu kali per halaman\' diaktifkan.';
$string['configfilternavigationwithsystemcontext'] = 'Penggunaan normal pemfilteran terkait dengan konteks penggunaannya (misalnya konteks kursus), tetapi untuk navigasi situs, secara eksplisit membuat semua filter dengan konteks situs dapat menghasilkan peningkatan kinerja saat menggunakan pemfilteran "konten dan judul".';
$string['configfilteruploadedfiles'] = 'Memproses semua file HTML dan teks yang diunggah dengan filter sebelum menampilkannya, hanya mengunggah file HTML atau tidak sama sekali.';
$string['configforcelogin'] = 'Biasanya, beranda situs dan daftar kursus (tetapi bukan kursus) dapat dibaca oleh orang-orang tanpa masuk ke situs. Jika Anda ingin memaksa orang untuk masuk sebelum mereka melakukan APA PUN di situs, maka Anda harus mengaktifkan setelan ini.';
$string['configforceloginforprofiles'] = 'Setelan ini memaksa orang untuk masuk sebagai akun sebenarnya (bukan tamu) sebelum melihat profil pengguna mana pun. Jika Anda menonaktifkan setelan ini, Anda mungkin menemukan bahwa beberapa pengguna mengirim iklan (spam) atau konten yang tidak pantas lainnya di profil mereka, yang kemudian dapat dilihat oleh seluruh dunia.';
$string['configfrontpage'] = 'Item yang dipilih di atas akan ditampilkan di beranda situs.';
$string['configfrontpagecourselimit'] = 'Jumlah maksimum kursus';
$string['configfrontpagecourselimithelp'] = 'Jumlah maksimum kursus yang dapat di tampilkan di beranda situs dalam daftar kursus.';
$string['configfrontpageloggedin'] = 'Item yang dipilih di atas akan ditampilkan di beranda situs ketika pengguna masuk.';
$string['configfullnamedisplay'] = 'Ini menentukan bagaimana nama ditampilkan saat ditampilkan secara penuh. Nilai bawaan, "language", meninggalkan string "fullnamedisplay" dalam paket bahasa saat ini untuk memutuskan. Beberapa bahasa memiliki konvensi tampilan nama yang berbeda.

Untuk sebagian besar situs satu bahasa, setelan yang paling efisien adalah "firstname lastname", tetapi Anda dapat memilih untuk menyembunyikan nama belakang sama sekali. Placeholder yang dapat digunakan adalah: nama depan, nama belakang, fonetik firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename.';
$string['configgeoipfile'] = 'Lokasi berkas data biner Kota GeoLite2. File ini bukan bagian dari distribusi Moodle dan harus diperoleh secara terpisah dari <a href="https://www.maxmind.com/"> MaxMind </a>. Anda dapat membeli versi komersial atau menggunakan versi gratis. Anda harus mendaftar untuk mengunduh berkas basis data kota, yang dapat Anda lakukan di <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/"> https://dev.maxmind.com/geoip/geoip2/geolite2/ </a>. Setelah Anda mendaftar dan mengunduh berkas tersebut, ekstrak ke direktori "{$a}" di server Anda.';
$string['configgetremoteaddrconf'] = 'Jika server Anda berada di belakang proksi terbalik, Anda dapat menggunakan setelan ini untuk menentukan header HTTP mana yang dapat dipercaya berisi alamat IP jarak jauh. Header dibaca dalam urutan, menggunakan yang pertama yang tersedia.';
$string['configgradebookroles'] = 'Setelan ini memungkinkan Anda untuk mengontrol siapa yang muncul di buku nilai. Pengguna harus memiliki setidaknya satu dari peran ini dalam suatu kursus untuk ditampilkan di buku nilai untuk kursus tersebut.';
$string['configgradeexport'] = 'Pilih format ekspor buku nilai mana yang merupakan metode utama Anda untuk mengekspor nilai. Pengaya yang dipilih kemudian akan disetel dan menggunakan kolom "terakhir diekspor" untuk setiap nilai. Misalnya, ini mungkin mengakibatkan rekaman yang diekspor diidentifikasi sebagai "baru" atau "diperbarui". Jika Anda tidak yakin tentang hal ini, biarkan semuanya tidak dicentang.';
$string['configgradeexportdefault'] = 'Pilih format ekspor buku nilai yang akan dijadikan metode bawaan Anda untuk mengekspor nilai.';
$string['confighiddenuserfields'] = 'Pilih kolom informasi pengguna mana yang ingin Anda sembunyikan dari pengguna lain selain pengajar / admin kursus. Ini akan meningkatkan privasi siswa. Tahan tombol CTRL untuk memilih beberapa kolom.';
$string['configidnumber'] = 'Opsi ini menentukan apakah (a) Pengguna tidak diminta untuk nomor ID sama sekali, (b) Pengguna diminta untuk nomor ID tetapi dapat membiarkannya kosong atau (c) Pengguna diminta untuk Nomor ID dan tidak dapat membiarkannya kosong . Jika diberi nomor ID Pengguna ditampilkan di profil mereka.';
$string['configintro'] = 'Pada halaman ini anda dapat menentukan sejumlah variabel konfigurasi yang membantu membuat Moodle bekerja dengan baik pada server anda. Jangan terlalu khawatir tentang itu - nilai bawaan biasanya akan bekerja dengan baik dan anda selalu dapat kembali ke halaman ini kemudian dan mengubah setelan ini.';
$string['configintroadmin'] = 'Di halaman ini Anda harus mengkonfigurasi akun administrator utama anda yang akan memiliki kendali penuh atas situs. Pastikan Anda memberikan nama pengguna dan kata sandi yang aman serta alamat surel yang valid. Anda dapat membuat lebih banyak akun admin nantinya.';
$string['configintrosite'] = 'Halaman ini memungkinkan anda untuk mengkonfigurasi beranda situs dan nama situs baru ini. Anda dapat kembali ke sini nanti untuk mengubah setelan ini setiap saat dengan menggunakan menu Administrasi.';
$string['configiplookup'] = 'Ketika Anda mengklik alamat IP (seperti 34.12.222.93), seperti di log, Anda akan ditunjukkan peta dengan tebakan terbaik di mana IP itu berada. Ada beberapa plugin untuk ini yang dapat Anda pilih, masing-masing memiliki kelebihan dan kekurangan.';
$string['configkeeptagnamecase'] = 'Periksa ini jika anda ingin tag nama untuk menjaga casing asli sebagai dimasukkan oleh pengguna yang membuatnya';
$string['configlang'] = 'Pilih bahasa bawaan untuk keseluruhan situs. Pengguna dapat memilih bahasa sendiri melalui bahasa atau setelan pada profil.';
$string['configlanglist'] = 'Jika dibiarkan kosong, semua bahasa yang dipasang di situs akan ditampilkan di menu bahasa. Atau, menu bahasa dapat dipersingkat dengan memasukkan daftar kode bahasa yang dipisahkan oleh koma mis. en, de, fr. Jika diinginkan, nama yang berbeda untuk bahasa dari nama paket bahasa dapat ditentukan menggunakan format: kode bahasa | nama bahasa mis. en_kids | Bahasa Inggris, de_kids | Deutsch.';
$string['configlangmenu'] = 'Pilih apakah anda ingin menampilkan menu bahasa tujuan umum di halaman beranda, laman masuk, dll. Ini tidak memengaruhi kemampuan pengguna untuk menyetel bahasa pilihan di profil mereka sendiri';
$string['configlangstringcache'] = 'Singgahan semua string bahasa ke berkas yang dikompilasi di dalam direktori data. Jika Anda menerjemahkan Moodle atau mengubah string dalam kode sumber Moodle maka Anda mungkin ingin mematikannya. Kalau tidak, biarkan saja untuk melihat manfaat kinerja.';
$string['configlatinexcelexport'] = 'Pilih setelan pengodean untuk Pengeksporan Excel.';
$string['configlocale'] = 'Pilih lokal situs - ini akan menggantikan format dan bahasa tanggal untuk semua paket bahasa (meskipun nama hari dalam kalender tidak terpengaruh). Anda perlu menginstal data lokal ini di sistem operasi Anda (misalnya untuk linux en_US.UTF-8 atau es_ES.UTF-8). Dalam kebanyakan kasus, kolom ini harus dibiarkan kosong.';
$string['configlockrequestcategory'] = 'Jika diaktifkan, pengguna dengan kemampuan untuk meminta kursus baru dalam konteks sistem tidak akan dapat memilih kategori dalam permintaan bentuk kursus baru. Cara alternatif untuk membatasi pengguna untuk meminta kursus baru hanya dalam satu kategori adalah dengan menerapkan kemampuan untuk meminta kursus baru dalam konteks kategori.';
$string['configloglifetime'] = 'Ini menentukan lama waktu Anda ingin menyimpan log tentang aktivitas pengguna. Log yang lebih tua dari usia ini secara otomatis dihapus. Yang terbaik adalah menyimpan log selama mungkin, jika Anda membutuhkannya, tetapi jika Anda memiliki server yang sangat sibuk dan mengalami masalah kinerja, maka Anda mungkin ingin menurunkan masa pakai log. Nilai yang lebih rendah dari 30 tidak disarankan karena statistik mungkin tidak berfungsi dengan baik.';
$string['configlookahead'] = 'Hari mendatang untuk dilihat';
$string['configmailnewline'] = 'Karakter baris baru yang digunakan dalam pesan surel. CRLF diperlukan menurut RFC 822bis, beberapa server mail melakukan konversi otomatis dari LF ke CRLF, server mail lain melakukan konversi yang salah dari CRLF ke CRCRLF, namun yang lain menolak surel dengan LF kosong (misalnya qmail). Coba ubah setelan ini jika Anda mengalami masalah dengan surel yang tidak terkirim atau gandakan baris baru.';
$string['configmaxbytes'] = 'Ini menentukan ukuran maksimum untuk file yang diunggah ke situs. Setelan ini dibatasi oleh setelan PHP post_max_size dan upload_max_filesize, serta setelan Apache LimitRequestBody. Pada gilirannya, maxbytes membatasi rentang ukuran yang dapat dipilih pada tingkat kursus atau aktivitas. Jika \'Batas unggah situs\' dipilih, ukuran maksimum yang diizinkan oleh server akan digunakan.';
$string['configmaxconsecutiveidentchars'] = 'Kata sandi tidak boleh memiliki lebih dari jumlah karakter identik berturut-turut ini. Gunakan 0 untuk menonaktifkan pemeriksaan ini.';
$string['configmaxeditingtime'] = 'Ini menentukan jumlah waktu yang diperlukan orang untuk mengedit kembali posting forum, komentar glosarium, dll. Biasanya 30 menit adalah nilai yang bagus.';
$string['configmaxevents'] = 'Acara yang akan di lihat ke depan';
$string['configmaxusersperpage'] = 'Jumlah maksimum pengguna yang ditampilkan dalam pemilih pengguna dalam kursus, grup, kohor, layanan web, dll.';
$string['configmessaging'] = 'Jika diaktifkan, pengguna dapat mengirim pesan ke pengguna lain di situs.';
$string['configmessagingallowemailoverride'] = 'Izinkan pengguna untuk memperoleh notifikasi surel yang dikirim ke alamat surel selain alamat surel di profil mereka';
$string['configmessagingallusers'] = 'Jika diaktifkan, pengguna dapat melihat daftar semua pengguna di situs saat memilih seseorang untuk dikirimi pesan, dan preferensi pesan mereka mencakup opsi untuk menerima pesan dari siapa pun di situs tersebut. Jika dinonaktifkan, pengguna hanya dapat melihat daftar pengguna dalam kursus mereka, dan mereka hanya memiliki dua opsi dalam preferensi pesan - untuk menerima pesan dari kontak mereka saja, atau kontak mereka dan siapa saja dalam kursus mereka.';
$string['configmessagingdefaultpressenter'] = 'Apakah \'Gunakan ENTER untuk mengirim\' diaktifkan secara bawaan di setelan pesan pengguna.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Pemberitahuan baca dan belum dibaca dapat dihapus untuk menghemat ruang. Berapa lama setelah pemberitahuan dibuat dapat dihapus?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Notifikasi baca dapat dihapus untuk menghemat ruang. Berapa lama setelah pemberitahuan dibaca dapatkah dihapus?';
$string['configminpassworddigits'] = 'Kata sandi setidaknya harus memiliki banyak digit';
$string['configminpasswordlength'] = 'Kata sandi setidaknya harus memiliki banyak karakter ini.';
$string['configminpasswordlower'] = 'Kata sandi harus memiliki setidaknya banyak huruf kecil.';
$string['configminpasswordnonalphanum'] = 'Kata sandi harus memiliki karakter non-alfanumerik, contohnya: !@#$%^&*()_+<>?~ atau spasi.';
$string['configminpasswordupper'] = 'Kata sandi harus memiliki setidaknya banyak huruf besar.';
$string['configmypagelocked'] = 'Setelan ini mencegah halaman bawaan diedit oleh non-admin';
$string['confignavcourselimit'] = 'Membatasi jumlah kursus yang ditampilkan pada navigasi pengguna.';
$string['confignavshowallcourses'] = 'Setelan ini menentukan apakah pengguna yang terdaftar dalam kursus dapat melihat kursus (daftar semua kursus) di navigasi, selain kursus Saya (daftar kursus di mana mereka terdaftar).';
$string['confignavshowcategories'] = 'Tampilkan kategori kursus di bilah navigasi dan blok navigasi. Hal ini tidak terjadi dengan kursus di mana pengguna saat ini terdaftar, mereka akan tetap terdaftar di bawah kursus saya tanpa kategori.';
$string['confignoreplyaddress'] = 'Surel terkadang dikirim atas nama pengguna (mis. kiriman forum). Alamat surel yang Anda tentukan di sini akan digunakan sebagai alamat "Dari" dalam kasus-kasus tersebut ketika penerima tidak dapat membalas langsung ke pengguna (mis. Ketika pengguna memilih untuk merahasiakan alamatnya). Setelan ini juga akan digunakan sebagai pengirim amplop saat mengirim surel.';
$string['confignotifyloginfailures'] = 'Kirim pesan pemberitahuan kegagalan masuk ke pengguna yang dipilih ini. Ini membutuhkan penyimpanan log internal (mis. penimpanan log standar) harus diaktifkan.';
$string['confignotifyloginthreshold'] = 'Jika pemberitahuan tentang proses masuk gagal aktif, berapa banyak usaha masuk yang gagal oleh satu pengguna atau satu alamat IP yang perlu diberitahukan?';
$string['confignotloggedinroleid'] = 'Pengguna yang tidak masuk ke situs akan diperlakukan seolah-olah peran ini diberikan kepada mereka di konteks situs. Tamu hampir selalu seperti yang Anda inginkan di sini, tetapi Anda mungkin ingin membuat peran yang kurang atau lebih membatasi. Hal-hal seperti membuat posting masih mengharuskan pengguna untuk masuk dengan benar.';
$string['configopentowebcrawlers'] = 'Jika Anda mengaktifkan setelan ini, mesin pencari akan diizinkan masuk ke situs Anda sebagai tamu. Selain itu, orang yang masuk ke situs Anda melalui mesin pencari akan secara otomatis masuk sebagai tamu. Perhatikan bahwa ini hanya memberikan akses transparan ke kursus yang sudah mengizinkan akses tamu.';
$string['configoverride'] = 'Ditetapkan di config.php';
$string['configpasswordpolicy'] = 'Jika diaktifkan, kata sandi pengguna akan diperiksa terhadap kebijakan kata sandi seperti yang ditentukan dalam setelan di bawah ini. Pengaktifkan kebijakan kata sandi tidak akan memengaruhi pengguna yang ada sampai mereka memutuskan untuk, atau diharuskan untuk, mengubah kata sandi mereka, atau setelan \'Periksa kata sandi saat masuk\' diaktifkan.';
$string['configpasswordpolicycheckonlogin'] = 'Jika diaktifkan, kata sandi pengguna akan diperiksa terhadap kebijakan kata sandi setiap kali pengguna masuk. Jika pemeriksaan gagal, pengguna harus mengubah kata sandi mereka sebelum melanjutkan.
Ini berguna untuk mengaktifkan setelan ini setelah memperbarui kebijakan kata sandi.';
$string['configpasswordresettime'] = 'Nilai waktu dari orang yang akan melakukan permohonan penyetelan ulang kata sandi. 30 menit merupakan nilai yang bagus.';
$string['configpathtodu'] = 'Jalur menuju du. Biasanya /usr/bin/du. Jika Anda memasukkan ini, halaman yang menampilkan konten direktori akan berjalan lebih cepat untuk direktori dengan banyak berkas.';
$string['configpathtophp'] = 'Letak PHP CLI. Mungkin sesuatu seperti /usr/bin/php. Jika Anda memasukkan ini, skrip cron dapat dijalankan dari antarmuka web admin.';
$string['configperfdebug'] = 'Jika Anda menghidupkan ini, info kinerja akan dicetak di footer dari tema standar';
$string['configprofileroles'] = 'Daftar peran yang terlihat di profil pengguna dan di halaman partisipasi.';
$string['configprofilesforenrolledusersonly'] = 'Untuk mencegah penyalahgunaan oleh spammer, deskripsi profil pengguna yang belum terdaftar dalam kursus apa pun disembunyikan. Pengguna baru harus mendaftar setidaknya dalam satu kursus sebelum mereka dapat menambahkan deskripsi profil.';
$string['configprotectusernames'] = 'Jika diaktifkan, formulir kata sandi tidak akan menampilkan petunjuk apapun yang memperbolehkan nama pengguna akun atau alamat surel akun untuk ditebak.';
$string['configproxybypass'] = 'Daftar nama hos atau alamat IP (sebagian) yang harus melewati proksi. Pisahkan setiap item dengan koma, tanpa spasi. Misalnya: 192.168.0.0/16,*.mydomain.com.';
$string['configproxyfixunsafe_help'] = 'Mencoba untuk memperbaiki panggilan internal yang tidak melalui proksi dengan menambahkan Agen Pengguna MoodleBot dan menggunakan proksi.';
$string['configproxyhost'] = 'Jika <b> server </b> ini perlu menggunakan proksi komputer (mis. Firewall) untuk mengakses Internet, maka berikan nama hos proksi di sini. Kalau tidak biarkan kosong.';
$string['configproxylogunsafe_help'] = 'Mencoba untuk mencatat panggilan internal yang tidak melalui proksi dan seharusnya.';
$string['configproxypassword'] = 'Kata sandi diperlukan untuk mengakses internet melalui proxy jika diperlukan, kosongkan jika tidak ada (ekstensi PHP cURL diperlukan).';
$string['configproxyport'] = 'Jika server ini perlu menggunakan komputer proksi, berikan porta proksi di sini.';
$string['configproxytype'] = 'Jenis proksi web (ekstensi PHP5 dan cURL diperlukan untuk dukungan SOCKS5).';
$string['configproxyuser'] = 'Nama pengguna diperlukan untuk mengakses internet melalui proxy jika diperlukan, kosongkan jika tidak ada (ekstensi PHP cURL diperlukan).';
$string['configrecaptchaprivatekey'] = 'String karakter (kunci rahasia) yang digunakan untuk berkomunikasi antara server Moodle Anda dan server recaptcha. Kunci ReCAPTCHA dapat diperoleh dari <a target="_blank" href="https://www.google.com/recaptcha"> Google reCAPTCHA </a>.';
$string['configrecaptchapublickey'] = 'String karakter (kunci situs) yang digunakan untuk menampilkan elemen reCAPTCHA dalam formulir pendaftaran dan dukungan. Kunci ReCAPTCHA dapat diperoleh dari <a target="_blank" href="https://www.google.com/recaptcha"> Google reCAPTCHA </a>.';
$string['configrequestedstudentname'] = 'Kata untuk siswa yang digunakan dalam kursus yang diminta';
$string['configrequestedstudentsname'] = 'Kata untuk siswa yang digunakan dalam kursus yang diminta';
$string['configrequestedteachername'] = 'Kata-kata untuk pengajar yang digunakan dalam kursus yang diminta';
$string['configrequestedteachersname'] = 'Kata-kata untuk pengajar yang digunakan dalam kursus yang diminta';
$string['configreverseproxyignore'] = 'JIka server Anda berada di belakang beberapa pewali terbalik yang menghasilkan X-Forwarder-For header, maka tentukan alamat IP dan subnet (pisahkan dengan koma) dari pewali terbalik yang harus ditolak agar bisa menggunakan alamat IP yang benar.';
$string['configsectioninterface'] = 'Antarmuka';
$string['configsectionmail'] = 'Surat';
$string['configsectionmaintenance'] = 'Pemeliharaan / perbaikan';
$string['configsectionmisc'] = 'Lain-lain';
$string['configsectionoperatingsystem'] = 'Sistem operasi';
$string['configsectionpermissions'] = 'Izin';
$string['configsectionrequestedcourse'] = 'Permintaan kursus';
$string['configsectionsecurity'] = 'Keamanan';
$string['configsectionstats'] = 'Statistik';
$string['configsectionuser'] = 'Pengguna';
$string['configsecureforms'] = 'Moodle dapat menggunakan tingkat keamanan tambahan saat menerima data dari formulir web. Jika ini diaktifkan, variabel HTTP_REFERER perambah diperiksa terhadap alamat formulir saat ini. Dalam beberapa kasus, hal ini dapat menyebabkan masalah jika pengguna menggunakan firewall (misalnya Zonealarm) yang dikonfigurasi untuk menghapus HTTP_REFERER dari lalu lintas web mereka. Gejala \'macet\' pada formulir. Jika pengguna anda mengalami masalah dengan halaman login (misalnya), anda mungkin ingin menonaktifkan setelan ini, meskipun itu mungkin membuat situs anda lebih terbuka untuk serangan kata sandi brute force. Jika ragu, biarkan setelan ini ke \'Ya\'.';
$string['configservicespage'] = 'Masukkan URL layanan dan halaman dukungan atau kosongkan untuk menautkan ke layanan Moodle di moodle.com. Tautan hanya ditampilkan untuk administrator situs.';
$string['configsessioncookie'] = 'Setelan ini mengkustomisasi nama kuki yang digunakan untuk sesi Moodle. Ini opsional, dan hanya berguna untuk menghindari kuki menjadi bingung ketika ada lebih dari satu salinan Moodle yang berjalan di situs web yang sama.';
$string['configsessioncookiedomain'] = 'Ini memungkinkan Anda untuk mengubah domain dari mana kuki Moodle tersedia. Ini berguna untuk kustomisasi Moodle (misalnya, autentikasi atau pengaya pendaftaran) yang perlu membagikan informasi sesi Moodle dengan aplikasi web di subdomain lain. <strong> PERINGATAN: sangat disarankan untuk membiarkan setelan sesuai bawaan (kosong) - nilai yang salah akan mencegah semua log masuk ke situs. </strong>';
$string['configsessioncookiepath'] = 'Jika Anda perlu mengubah ke mana perambah mengirim cookie Moodle, Anda dapat mengubah setelan ini untuk menentukan subdirektori situs web Anda. Jika tidak, \'/\' bawaan seharusnya baik saja.';
$string['configsessiontimeout'] = 'Jika orang yang masuk ke situs ini menganggur untuk waktu yang lama (tanpa memuat halaman) maka mereka secara otomatis keluar (sesi mereka berakhir). Variabel ini menentukan berapa lama seharusnya waktu ini.';
$string['configsessiontimeoutwarning'] = 'Jika seseorang masuk ke situs ini dan diam untuk waktu yang lama (tanpa memuat ulang halaman) maka mereka akan diingatkan bahwa sesi mereka akan habis. Variabel ini menentukan berapa lama peringatan akan muncul.';
$string['configsessiontimeoutwarningcheck'] = 'Peringatan sesi akan berakhir harus sebelum waktu berakhirnya sesi.';
$string['configshowcommentscount'] = 'Tampilkan jumlah komentar, itu akan dikenakan biaya satu permintaan lagi saat menampilkan tautan komentar';
$string['configshowicalsource'] = 'Tampilan sumber informasi untuk acara iCal';
$string['configshowsiteparticipantslist'] = 'Semua siswa situs dan pengajar situs ini akan dicantumkan di daftar peserta situs. Siapa yang diizinkan untuk melihat daftar peserta situs ini?';
$string['configsitedefaultlicense'] = 'Lisensi situs bawaan';
$string['configsitedefaultlicensehelp'] = 'Lisensi bawaan pada publikasi konten di situs ini.';
$string['configsitemailcharset'] = 'Setelan ini menentukan rangkaian karakter bawaan untuk semua surel yang dikirim dari situs.';
$string['configsitemaxcategorydepth'] = 'Kedalaman kategori maksimum';
$string['configsitemaxcategorydepthhelp'] = 'Ini menentukan kedalaman maksimum kategori anak yang diperluas saat menampilkan kategori atau daftar kombo. Kategori tingkat yang lebih dalam akan muncul sebagai tautan dan pengguna dapat memperluasnya dengan permintaan AJAX.';
$string['configslasharguments'] = '\'Slash arguments\' (menggunakan <em>PATH_INFO</em>) dibutuhkan untuk paket SCORM dan berkas dari berbagai sumber agar dapat ditampilkan secara benar. Jika web server Anda tidak mendukung \'Slash arguments\' dan Anda tidak bisa mengaturnya, setelan ini bisa dimatikan, dan nanti hasilnya tidak akan muncul.
<br />Catatan: Penggunaan \'slash arguments\' akan dibutuhkan di versi Moodle yang akan datang.';
$string['configsmtpauthtype'] = 'Ini menetapkan jenis autentikasi untuk digunakan di server SMTP.';
$string['configsmtphosts'] = 'Berikan nama lengkap server SMTP lokal yang harus digunakan Moodle untuk mengirim surel (misalnya \'mail.a.com\' atau \'mail.a.com;mail.b.com\'). Untuk menentukan port tidak baku (mis. selain port 25), Anda bisa menggunakan sintaks [server]:[port] (mis. \'mail.a.com:587\'). Untuk koneksi yang aman, port 465 biasanya digunakan dengan SSL, port 587 digunakan dengan TLS. Tentukan protokol keamanan di bawah bila diperlukan. Jika Anda membiarkannya kosong, Moodle akan menggunakan cara bawaan PHP dalam mengirim surel.';
$string['configsmtpmaxbulk'] = 'Jumlah maksimum pesan yang dikirim per sesi SMTP. Pengelompokan pesan dapat mempercepat pengiriman surel. Nilai yang lebih rendah dari 2 memaksa pembuatan sesi SMTP baru untuk setiap surel.';
$string['configsmtpoauthservice'] = 'Pilih layanan OAuth 2 yang dikonfigurasi untuk berkomunikasi dengan server SMTP. Jika layanan belum ada, Anda harus membuatnya. Perhatikan bahwa Anda perlu menyetel SMTP Auth Type ke XOAUTH2.';
$string['configsmtpsecure'] = 'Jika server SMTP memerlukan koneksi aman, tentukan jenis protokol yang benar.';
$string['configsmtpuser'] = 'Jika Anda telah menentukan server SMTP di atas, dan server memerlukan autentikasi, masukkan nama pengguna dan kata sandi di sini.';
$string['configstartwday'] = 'Awal dari minggu';
$string['configstatsfirstrun'] = 'Ini menentukan seberapa jauh log harus diproses <b> pertama kali </b> cronjob ingin memproses statistik. Jika Anda memiliki banyak lalu lintas dan berbagi hosting, mungkin bukan ide yang baik untuk mundur terlalu jauh, karena ini bisa memakan waktu lama untuk dijalankan dan menjadi sumber daya yang cukup intensif. (Perhatikan bahwa untuk setelan ini, 1 bulan = 28 hari. Dalam grafik dan laporan yang dihasilkan, 1 bulan = 1 bulan kalender.)';
$string['configstatsmaxruntime'] = 'Pemrosesan statistik bisa sangat intensif, jadi gunakan kombinasi kolom ini dan bidang berikutnya untuk menentukan kapan pemrosesan akan dijalankan dan berapa lama.';
$string['configstatsmaxruntime2'] = 'Pemrosesan statistik bisa sangat intensif, tentukan waktu maksimum yang diperbolehkan untuk pengumpulan statistik satu hari. Jumlah hari maksimum yang diproses dalam satu eksekusi cron adalah 31.';
$string['configstatsmaxruntime3'] = 'Ini menentukan waktu maksimum yang diizinkan untuk menghitung statistik selama satu hari, mengingat bahwa pemrosesan statistik dapat memberikan beban besar pada server. Jumlah hari maksimum yang diproses dalam satu cron dapat ditentukan di bawah ini.';
$string['configstatsruntimedays'] = 'Ini menentukan jumlah hari maksimum yang diproses dalam setiap eksekusi statistik. Setelah statistik diperbarui, hanya satu hari yang akan diproses, jadi sesuaikan nilai ini tergantung dari beban server Anda, kurangi jika diperlukan eksekusi cron yang lebih pendek.';
$string['configstatsruntimestart'] = 'Jam berapa cronjob yang menghitung statistik dimulai? Anda disarankan untuk waktu yang berbeda jika ada beberapa situs Moodle dalam satu server.';
$string['configstatsuserthreshold'] = 'Setelan ini menentukan jumlah minimum pengguna terdaftar untuk kursus yang akan disertakan dalam perhitungan statistik.';
$string['configstrictformsrequired'] = 'Jika diaktifkan, pengguna tidak akan dapat memasukkan spasi atau jeda baris hanya pada kolom yang diperlukan dalam formulir.';
$string['configstripalltitletags'] = 'Hapus centang setelan ini untuk mengizinkan tag HTML dalam aktivitas dan nama sumber daya.';
$string['configsupportavailability'] = 'Menentukan siapa yang memiliki akses ke dukungan situs kontak dari footer.';
$string['configsupportemail'] = 'Jika SMTP dikonfigurasi di situs ini dan halaman dukungan tidak disetel, alamat surel ini akan menerima pesan yang dikirimkan melalui formulir dukungan. Jika pengiriman gagal, alamat surel akan ditampilkan kepada pengguna yang masuk.';
$string['configsupportname'] = 'Nama orang atau entitas lain yang memberikan dukungan melalui formulir dukungan atau halaman dukungan.';
$string['configsupportpage'] = 'Masukkan URL halaman dukungan atau kosongkan untuk menautkan ke formulir kontak. Tautan ditampilkan di footer situs.';
$string['configtempdatafoldercleanup'] = 'Hapus file data sementara dari folder data yang lebih lama dari waktu yang dipilih.';
$string['configthemedesignermode'] = 'Biasanya semua gambar tema dan lembar gaya disinggahkan pada peramban dan di server untuk waktu yang sangat lama, untuk kinerja. Jika Anda merancang tema atau mengembangkan kode maka Anda mungkin ingin mengaktifkan mode ini sehingga Anda tidak dilayani versi singgahan. Peringatan: ini akan membuat situs Anda lebih lambat untuk semua pengguna! Atau, Anda juga dapat mengatur ulang singgahan tema secara manual dari halaman pemilihan Tema.';
$string['configthemelist'] = 'Biarkan kosong untuk mengizinkan penggunaan tema yang valid. Jika Anda ingin mempersingkat menu tema, Anda dapat menentukan daftar nama yang dipisahkan koma di sini (Jangan gunakan spasi!).
Misalnya: standar, orangewhite.';
$string['configtimezone'] = 'Ini adalah zona waktu bawaan untuk menampilkan tanggal - setiap pengguna dapat mengabaikan setelan ini di profil mereka. Tugas cron dan setelan server lainnya ditentukan dalam zona waktu ini. Anda harus mengubah setelan jika tulisan yang muncul "Zona waktu tidak valid"';
$string['configuseblogassociations'] = 'Apakah pengguna dapat mengatur blog mereka dengan mengaitkan entri dengan kursus dan modul kursus?';
$string['configusesitenameforsitepages'] = 'Jika diaktifkan, nama singkat situs akan digunakan pada halaman situs di navigasi sehingga tulisannya tidak lagi \'Halaman situs\'';
$string['configusetags'] = 'Haruskah fungsi tag di seluruh situs diaktifkan?';
$string['configvariables'] = 'Variabel';
$string['configverifychangedemail'] = 'Mengaktifkan verifikasi alamat surel yang diubah menggunakan setelan domain surel yang diizinkan dan ditolak. Jika setelan ini dinonaktifkan, domain hanya diterapkan saat membuat pengguna baru.';
$string['configvisiblecourses'] = 'Tampilkan kursus dalam kategori tersembunyi secara normal';
$string['configwarning'] = 'Hati-hatilah saat memodifikasi setelan ini - nilai aneh dapat menyebabkan masalah.';
$string['configyuicomboloading'] = 'Pilihan ini memungkinkan optimisasi pembukaan berkas untuk pustaka YUI. Setelan ini harus diaktifkan untuk meningkatkan kinerja.';
$string['confirmation'] = 'Konfirmasi';
$string['confirmationpending'] = 'Konfirmasi tertunda';
$string['confirmcontextlock'] = '{$a->contextname} sedang aktif. Membekukannya akan membuat jadi hanya bisa dibaca dan mencegah pengguna membuat perubahan. Anda yakin ingin melanjutkan?';
$string['confirmcontextunlock'] = '{$a->contextname} sedang dibekukan. Mengaktifkannya akan membuat pengguna bisa melakukan perubahan. Anda yakin ingin melanjutkan?';
$string['confirmdeletecomments'] = 'Anda yakin ingin menghapus komentar yang dipilih?';
$string['confirmed'] = 'Dikonfirmasi';
$string['contactsitesupport'] = 'Hubungi dukungan situs';
$string['contenttypeuninstalling'] = 'Ada {$a->count} konten didukung oleh {$a->type} yang akan dihapus. Anda yakin ingin melanjutkan?';
$string['contextlockappliestoadmin'] = 'Pembekuan konteks berlaku untuk administrator';
$string['contextlockappliestoadmin_desc'] = 'Jika dinonaktifkan, administrator tetap memiliki akses tulis ke konteks yang dibekukan.';
$string['contextlocking'] = 'Pembekuan konteks';
$string['contextlocking_desc'] = 'Setelan ini memungkinkan akses hanya-baca diatur untuk kategori, kursus, aktivitas atau blok yang dipilih.';
$string['cookiesecure'] = 'Cookies aman saja';
$string['country'] = 'Negara bawaan';
$string['course_customfield'] = 'Kolom kustom kursus';
$string['coursecolor'] = 'Color {$a}';
$string['coursecolorheading_desc'] = 'Kursus apa pun tanpa gambar kursus yang diatur dalam setelan kursus ditampilkan di halaman Kursus saya dengan kartu kursus berpola. Warna yang digunakan dalam pola dapat ditentukan di bawah ini.';
$string['coursecolorsettings'] = 'Warna kartu Kursus';
$string['coursecontact'] = 'Kontak Kursus';
$string['coursecontact_desc'] = 'Setelan ini memungkinkan Anda untuk mengontrol siapa yang muncul di deskripsi kursus. Pengguna harus memiliki setidaknya satu dari peran ini dalam sebuah kursus untuk ditampilkan pada deskripsi kursus untuk kursus itu.';
$string['coursecontactduplicates'] = 'Tampilkan semua peran kontak kursus';
$string['coursecontactduplicates_desc'] = 'Jika diaktifkan, pengguna dengan lebih dari satu peran kontak kursus yang dipilih akan ditampilkan dalam deskripsi kursus dengan masing-masing peran mereka. Jika tidak, mereka hanya akan ditampilkan dengan satu peran (mana saja yang terdaftar paling tinggi di \'tentukan peran\' di administrasi situs).';
$string['coursecreationguide'] = 'URL panduan pembuatan kursus Moodle';
$string['coursecreationguide_help'] = 'Menentukan jalur ke panduan mulai cepat dengan video singkat dan tips umum untuk membuat kursus. Tautan ke panduan ditampilkan di halaman Kursus saya bila tidak ada kursus untuk ditampilkan. Hanya pengguna dengan kemampuan membuat kursus yang akan melihat tautan.';
$string['coursegraceperiodafter'] = 'Masa tenggang untuk kursus sebelumnya';
$string['coursegraceperiodbefore'] = 'Masa tenggang untuk kursus yang akan datang';
$string['courselistshortnames'] = 'Tampilkan nama panjang kursus';
$string['courselistshortnames_desc'] = 'Jika diaktifkan, nama singkat kursus akan ditampilkan juga pada daftar kursus. Jika diperlukan, nama kursus yang diperluas dapat dikustomisasi dengan menyunting string bahasa \'courseextendednamedisplay\' menggunakan fitur Kustomisasi Bahasa';
$string['coursemgmt'] = 'Kelola kursus dan kategori';
$string['courseoverview'] = 'Ikhtisar Kursus';
$string['courserequestnotify'] = 'Notifikasi permintaan kursus';
$string['courserequestnotifyemail'] = 'Pengguna {$a->user} meminta kursus baru di <a href="{$a->link}">{$a->link}</a>.';
$string['courserequests'] = 'Permintaan kursus';
$string['courserequestspending'] = 'Permintaan kursus tertunda';
$string['courses'] = 'Kursus';
$string['coursesperpage'] = 'Kursus per halaman';
$string['courseswithsummarieslimit'] = 'Kursus dengan batas ringkasan';
$string['creatornewroleid'] = 'Peran pembuat dalam kursus yang baru';
$string['creatornewroleid_help'] = 'Jika pengguna belum memiliki izin untuk mengelola program (kursus) baru, pengguna secara otomatis terdaftar menggunakan peran ini.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Aktifkan cron';
$string['cron_enabled_desc'] = 'Normalnya cron harus diaktifkan, tetapi setelan ini bisa dimatikan sementara, misalnya sebelum restart server. Jika dimatikan, sistem akan mencegah tugas di belakang layar. Harap diingat bahwa cron tidak boleh dimatikan dalam jangka waktu yang lama karena akan membuat fungsi-fungsi penting berhenti bekerja.';
$string['cron_help'] = 'Skrip cron.php menjalankan sejumlah tugas pada interval terjadwal yang berbeda, seperti mengirim surel pemberitahuan kiriman forum. Skrip harus dijalankan secara teratur - idealnya setiap menit.';
$string['cron_keepalive'] = 'Tetap menyala';
$string['cron_keepalive_desc'] = 'Lamanya waktu menyimpan jajak pendapat untuk tugas tambahan. Setelan ini untuk memastikan bahwa cron selalu berjalan. Jika Anda menggunakan proses tugas khusus, setel ke 0. Jika tidak, setel ke nilai yang mirip dengan batas konkurensi tugas adhoc. Hindari waktu yang lebih lama. Waktu maksimum adalah 15 menit.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Eksekusi cron hanya dari command line';
$string['cronerrorclionly'] = 'Maaf, akses Internet ke halaman ini telah dinonaktifkan oleh administrator.';
$string['cronerrorpassword'] = 'Maaf, Anda tidak memberikan kata sandi yang benar untuk mengakses halaman ini.';
$string['croninfrequent'] = 'Kron dijalankan {$a->actual} sekali dan sebaiknya harus dijalankan setiap {$a->expected}. Kami merekomendasikan untuk mengonfigurasinya agar berjalan lebih sering.';
$string['cronremotepassword'] = 'Cron kata sandi untuk akses remote';
$string['cronwarning'] = '<a href="{$a->url}"> admin/cron.php script </a> belum dijalankan untuk {$a->actual} dan seharusnya dijalankan setiap {$a->expected}.';
$string['cronwarningcli'] = 'Skrip <code> admin/cli/cron.php </code> belum dijalankan untuk {$a->actual} dan seharusnya dijalankan setiap {$a->expected}.';
$string['cronwarningnever'] = '<code>admin/cli/cron.php</code> kode tidak pernah dijalankan dan harus berjalan setiap {$a->expected}.';
$string['cronwarningneverweb'] = '<a href="{$a->url}">admin/cron.php script</a> tidak pernah dijalankan dan harus berjalan setiap {$a->expected}.';
$string['ctyperequired'] = 'Ekstensi ctype PHP sekarang dibutuhkan oleh Moodle, untuk meningkatkan kinerja situs dan menawarkan kompatibilitas multibahasa.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'Extensi cURL PHP dibutuhkan oleh Moodle, agar dapat berkomunikasi dengan repository Moodle.';
$string['curlsecurityallowedport'] = 'cURL daftar port yang diizinkan';
$string['curlsecurityallowedportsyntax'] = 'Daftar nomor port yang dapat disambungkan oleh cURL. Masukan yang valid hanya berupa bilangan bulat. Letakkan setiap masukan di baris baru. Jika dibiarkan kosong, semua port diizinkan. Jika disetel, di hampir semua kasus, baik 443 dan 80 harus ditentukan agar cURL dapat terhubung ke HTTPS standar dan port HTTP.';
$string['curlsecurityblockedhosts'] = 'cURL daftar host yang diblokir';
$string['curlsecurityblockedhostssyntax'] = 'Letakkan setiap entri pada baris baru. Entri yang valid adalah alamat IPv4 atau IPv6 lengkap (seperti 192.168.10.1, 0: 0: 0: 0: 0: 0: 0: 0: 1: ::, 1, fe80: :) yang cocok dengan satu host; atau notasi CIDR (seperti 231.54.211.0/20 atau fe80 :: / 64); atau rentang alamat IP (seperti 231.3.56.10-20 atau fe80 :: 1111-bbbb) di mana rentang tersebut berlaku untuk grup terakhir dari alamat; atau nama domain (seperti localhost atau example.com); atau nama domain wildcard (seperti * .example.com atau * .sub.example.com). Garis kosong tidak diizinkan.';
$string['curlsecurityurlblocked'] = 'URL diblok';
$string['curltimeoutkbitrate'] = 'Bitrate yang digunakan ketika menghitung timeouts cURL (Kbps)';
$string['curltimeoutkbitrate_help'] = 'Setelan ini digunakan untuk menghitung batas waktu yang tepat selama permintaan cURL yang besar. Sebagai bagian dari perhitungan ini permintaan HTTP HEAD digunakan untuk menentukan ukuran konten. Setelan ke angka 0 untuk menonaktifkan permintaan ini.';
$string['currenttheme'] = 'Tema sekarang';
$string['customcheck'] = 'Cek lainnya';
$string['custommenu'] = 'Menu kustom';
$string['custommenuitems'] = 'Item menu kustom';
$string['customusermenuitems'] = 'Item menu pengguna';
$string['datarootsecurityerror'] = '<p><strong>PERINGATAN KEAMANAN!</strong></p><p> Direktori dataroot Anda berada di tempat yang salah dan dapat dilihat di internet. Seluruh berkas pribadi Anda bisa dilihat oleh semua orang di seluruh dunia, dan mungkin akan digunakan untuk meretas situs Anda!</p>
<p>Anda <em>harus</em> memindah direktori dataroot  ({$a}) ke tempat lain yang tidak terlihat oleh publik, dan perbarui setelan <code>$CFG->dataroot</code> Anda di config.php.</p>';
$string['datarootsecuritywarning'] = 'Konfigurasi situs Anda nampaknya tidak aman. Pastikan direktori dataroot ({$a}) tidak bisa diakses secara langsung melalui web.';
$string['dbprefixtoolong'] = 'Awalan basis data situs Anda ($CFG->prefix) terlalu panjang ({$a->current} karakter). Jumlah maksimum karakter yang diperbolehkan adalah {$a->maximum}.';
$string['dbsessions'] = 'Gunakan basis data untuk sesi informasi';
$string['debug'] = 'Awakutu pesan';
$string['debugall'] = 'SEMUA: Menampilkan semua pesan awakutu PHP yang wajar';
$string['debugdeveloper'] = 'PENGEMBANG: pesan awakutu Moodle tambahan untuk pengembang';
$string['debugdisplay'] = 'Tampilkan awakutu pesan';
$string['debugging'] = 'Awakutu';
$string['debugminimal'] = 'PALING SEDIKIT: Hanya menampilkan kesalahan fatal';
$string['debugnone'] = 'TIDAK ADA: Jangan tampilkan kesalahan atau peringatan apa pun';
$string['debugnormal'] = 'NORMAL: Tampilkan kesalahan, peringatan dan pemberitahuan';
$string['debugpageinfo'] = 'Tampilkan informasi halaman';
$string['debugsqltrace'] = 'Tampilkan asal panggilan SQL';
$string['debugsqltrace1'] = 'Hanya menampilkan baris panggilan tunggal';
$string['debugsqltrace100'] = 'Tampilkan jejak tumpukan lengkap';
$string['debugsqltrace2'] = 'Menampilkan 2 jejak susunan';
$string['debugsqltrace_desc'] = 'Jika diaktifkan, pelacakan tumpukan PHP sebagian atau penuh ditambahkan ke SQL sebagai komentar.';
$string['debugstringids'] = 'Menampilkan tulisan dalam bahasa asli';
$string['debugstringids_desc'] = 'Jika diaktifkan, komponen tulisan bahasa dan pengidentifikasinya akan ditampilkan ketika ?strings=1 atau &strings=1 ditambahkan di halaman URL.';
$string['debugtemplateinfo'] = 'Tampilkan informasi templat';
$string['debugtemplateinfo_desc'] = 'Jika diaktifkan, templat yang digunakan untuk rendering ditampilkan sebagai komentar di halaman HTML. Setelah mengubah setelan, Anda perlu membersihkan singgahan. Gunakan hanya untuk awakutu sementara, karena menghasilkan kesalahan validasi HTML dan dapat merusak skrip halaman. Itu juga dapat merusak fungsionalitas inti!';
$string['debugvalidators'] = 'Tampilkan link validasi';
$string['defaultcity'] = 'Kota bawaan';
$string['defaultcity_help'] = 'Nama kota yang dimasukkan akan menjadi nama kota bawaan yang akan dibuat pada profil pengguna yang baru.';
$string['defaultformatnotset'] = 'Kesalahan menentukan format kursus bawaan. Silakan periksa setelan situs.';
$string['defaulthomepage'] = 'Halaman mulai untuk pengguna';
$string['defaultrequestcategory'] = 'Kategori bawaan untuk permintaan kursus';
$string['defaultsettinginfo'] = 'Bawaan: {$a}';
$string['defaultuserroleid'] = 'Peran bawaan untuk semua pengguna';
$string['deleteduserx'] = 'Pengguna yang dihapus {$a}';
$string['deleteincompleteusers'] = 'Hapus pengguna yang tidak lengkap setelahnya';
$string['deleteunconfirmed'] = 'Hapus sebagian setelan pengguna setelah ini.';
$string['deleteuser'] = 'Hapus pengguna';
$string['density'] = 'Kepadatan';
$string['denyemailaddresses'] = 'Domain surel ditolak';
$string['development'] = 'Pengembangan';
$string['devicedetectregex'] = 'Ekspresi reguler pendeteksian perangkat.';
$string['devicedetectregex_desc'] = '<p> Secara bawaan, Moodle dapat mendeteksi perangkat dari tipe standar (PC desktop, laptop, dll), ponsel (ponsel dan perangkat genggam kecil), tablet (iPad, tablet Android), dan perangkat lama (pengguna Internet Explorer 6). Pemilih tema dapat digunakan untuk menerapkan tema yang terpisah untuk semua ini. Setelan ini memungkinkan ekspresi reguler yang memungkinkan deteksi jenis perangkat tambahan (ini lebih diutamakan daripada jenis bawaan). </p>
<p> Misalnya, Anda dapat memasukkan ekspresi reguler \'/(MIDP-1.0|Maemo|Windows CE) / \'untuk mendeteksi beberapa ponsel fitur yang umum digunakan menambah nilai balik\' featurephone \'. Ini menambahkan \'featurephone\' pada pemilih tema yang memungkinkan Anda untuk menambahkan tema yang akan digunakan pada perangkat ini. Telepon lain akan tetap menggunakan tema yang dipilih untuk jenis perangkat seluler. </p>';
$string['devicedetectregexexpression'] = 'Ekspresi regular';
$string['devicedetectregexvalue'] = 'Nilai kembali';
$string['devicetype'] = 'Tipe perangkat';
$string['devlibdirpresent'] = 'Direktori dengan pustaka pengembangan, terutama <em> /vendor </em> dan <em> /node_modules </em>, tidak boleh ada di situs publik. Lihat <a href="{$a->moreinfourl} "> laporan ikhtisar keamanan </a> untuk detail lebih lanjut.';
$string['disabled'] = 'Nonaktifkan';
$string['disableplugin'] = 'Nonaktifkan {$a}';
$string['disableuserimages'] = 'Nonaktifkan gambar profil pengguna';
$string['displayerrorswarning'] = 'Mengaktifkan setelan PHP <em>display_errors</em> tidak disarankan di situs produksi karena beberapa pesan kesalahan dapat mengungkapkan informasi sensitif tentang server Anda.';
$string['displayloginfailures'] = 'Tampilkan kegagalan log masuk';
$string['divertallemails'] = 'Pengalihan surel';
$string['divertallemailsdetail'] = 'Digunakan sebagai pengaman di lingkungan pengembangan saat menguji surel dan tidak boleh digunakan dalam produksi.';
$string['divertallemailsexcept'] = 'Pengecualian pengalihan surel';
$string['divertallemailsexcept_desc'] = 'Daftar aturan pengecualian surel yang dipisahkan oleh koma atau baris baru. Setiap aturan ditafsirkan sebagai ekspresi reguler mis. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Alihkan semua surel';
$string['divertallemailsto_desc'] = 'Jika diatur maka semua surel akan dialihkan ke satu alamat surel ini.';
$string['dndallowtextandlinks'] = 'Seret dan lepas unggahan teks/tautan';
$string['doclang'] = 'Bahasa untuk dokumen';
$string['docroot'] = 'Root dokumen Moodle Docs';
$string['doctonewwindow'] = 'Buka di jendela baru';
$string['doesnotfit'] = 'Setelan tampilan surel';
$string['doesnotfitdetail'] = 'Setelan tampilan untuk surel dari Moodle.';
$string['download'] = 'Unduh';
$string['downloadcoursecontentallowed'] = 'Tersedia fitur unduh konten kursus';
$string['downloadcoursecontentallowed_desc'] = 'Apakah fitur unduh konten kursus tersedia untuk kursus. Jika tersedia, unduhan konten kursus dapat diaktifkan / dinonaktifkan menggunakan setelan "Aktifkan unduhan konten kursus" dalam menu edit kursus (setelan bawaan untuk ini dapat disetel di <a href={$a} target="_blank"> Setelan bawaan kursus </a>).';
$string['durationunits'] = 'unit durasi';
$string['edithelpdocs'] = 'Edit dokumen bantuan';
$string['editlang'] = '<b>Edit</b>';
$string['editorbackgroundcolor'] = 'Warna latar belakang';
$string['editordictionary'] = 'Kamus editor';
$string['editorfontfamily'] = 'Keluarga huruf';
$string['editorfontlist'] = 'Daftar huruf';
$string['editorfontsize'] = 'Ukuran huruf';
$string['editorhidebuttons'] = 'Tombol tersembunyi';
$string['editorkillword'] = 'Filter format kata';
$string['editorspelling'] = 'Ejaan editor';
$string['editorspellinghelp'] = 'Mengaktifkan atau menonaktifkan pemeriksaan ejaan. Saat diaktifkan, <strong>aspell</strong> harus dipasang di server.';
$string['editstrings'] = 'Edit kata atau frasa';
$string['emailchangeconfirmation'] = 'Konfirmasi perubahan surel';
$string['emaildkim'] = 'Penandatanganan surel DomainKeys Identified Mail (DKIM)';
$string['emaildkiminfo'] = 'Jika pemilih DKIM disetel dan berkas sertifikat pribadi ditemukan yang cocok dengan domain alamat "Dari" surel di $CFG->dataroot/dkim/[domain]/[selector].private, maka surel akan ditandatangani. Dalam kebanyakan kasus (misalnya jika domain surel yang diizinkan kosong) hanya diperlukan satu sertifikat di <pre>{$a->path}</pre> Untuk detail penyiapan lebih lanjut, lihat dokumentasi <a href="{$a->docs}">Konfigurasi surel</a>.';
$string['emaildkimselector'] = 'Pemilih DKIM';
$string['emailfromvia'] = 'Surel melalui informasi';
$string['emailheaders'] = 'Tajuk surel';
$string['emailsubjectprefix'] = 'Prefiks subjek surel';
$string['emoticonalt'] = 'Teks alternatif';
$string['emoticoncomponent'] = 'Komponen gambar';
$string['emoticonimagename'] = 'Nama gambar';
$string['emoticons'] = 'Emotikon';
$string['emoticons_desc'] = 'Formulir ini mendefinisikan emotikon (atau smiley) yang digunakan di situs Anda. Untuk menghapus baris dari tabel, simpan formulir dengan nilai kosong di salah satu kolom wajib. Untuk mendaftarkan emotikon baru, isi kolom di baris kosong terakhir. Untuk mengatur ulang semua kolom ke nilai bawaaan, ikuti tautan di atas.

* Teks (wajib) - Teks ini akan diganti dengan gambar emotikon. Panjangnya minimal harus dua karakter.
* Nama gambar (wajib) - Nama file gambar emotikon tanpa ekstensi, relatif terhadap folder komponen pix.
* Komponen gambar (wajib) - Komponen yang menyediakan ikon.
* Teks alternatif (opsional) - Pengidentifikasi string dan komponen teks alternatif emotikon.';
$string['emoticonsreset'] = 'Setel ulang setelan emotikon ke nilai bawaan';
$string['emoticontext'] = 'Teks';
$string['emptysettingvalue'] = 'Kosong';
$string['enableanalytics'] = 'Analisis';
$string['enableblogs'] = 'Aktifkan blog';
$string['enablecalendarexport'] = 'Aktifkan pengeksporan kalender';
$string['enablecomments'] = 'Aktifkan komentar';
$string['enablecommunicationsubsystem'] = 'Aktifkan penyedia komunikasi';
$string['enablecommunicationsubsystem_desc'] = 'Izinkan integrasi dengan penyedia komunikasi seperti Matrix sehingga pengajar dan siswa dapat berkomunikasi dengan lebih mudah. Anda dapat mengelola integrasi ini di <a href="settings.php?section=managecommunicationproviders">Pengaya</a>.';
$string['enablecourserelativedates'] = 'Aktifkan tanggal relatif kursus';
$string['enablecourserelativedates_desc'] = 'Izinkan kursus disiapkan untuk menampilkan tanggal relatif terhadap tanggal mulai pengguna dalam kursus.';
$string['enablecourserequests'] = 'Aktifkan permintaan pembuatan kursus';
$string['enabled'] = 'Aktifkan';
$string['enabledashboard'] = 'Aktifkan dasbor';
$string['enabledashboard_help'] = 'Dasbor menampilkan Lini masa, Kalender, dan item yang baru-baru ini diakses secara bawaan. Anda dapat menyetel Dasbor bawaan yang berbeda untuk semua orang dan mengizinkan pengguna untuk menyesuaikan Dasbor mereka sendiri. Jika dinonaktifkan, Anda perlu menyetel \'Halaman awal untuk pengguna\' ke nilai selain Dasbor.';
$string['enabledevicedetection'] = 'Aktifkan pendeteksian perangkat';
$string['enableglobalsearch'] = 'Aktifkan pencarian global';
$string['enableglobalsearch_desc'] = 'Jika diaktifkan, data akan di indeks dan disinkronkan dengan tugas terjadwal.';
$string['enablegravatar'] = 'Aktifkan gravatar';
$string['enablegravatar_help'] = 'Ketika diaktifkan, Moodle akan mencoba mengambil gambar profil pengguna dari Gravatar jika pengguna belum mengunggah gambar.';
$string['enablemobilewebservice'] = 'Aktifkan layanan web untuk perangkat seluler';
$string['enablepdfexportfont'] = 'Aktifkan fon PDF';
$string['enablepdfexportfont_desc'] = 'Jika situs Anda memiliki kursus dalam berbagai bahasa yang memerlukan fon lain dalam berkas PDF yang dibuat, Anda dapat memberikan opsi untuk menyetel fon di setelan kursus. Anda perlu menentukan fon yang tersedia di $CFG->pdfexportfont di config.php.';
$string['enableplugin'] = 'Aktifkan {$a}';
$string['enablerecordcache'] = 'Aktifkan singgahan rekaman';
$string['enablerssfeeds'] = 'Aktifkan umpan RSS';
$string['enablesearchareas'] = 'Aktifkan area pencarian';
$string['enablesharingtomoodlenet'] = 'Aktifkan berbagi ke MoodleNet (keluar)';
$string['enablesharingtomoodlenet_desc'] = 'Izinkan pengguna untuk berbagi konten kursus ke instans MoodleNet yang dikonfigurasi jika mereka memiliki kemampuan yang relevan.';
$string['enablestats'] = 'Aktifkan Statistik';
$string['enabletrusttext'] = 'Aktifkan konten tepercaya';
$string['enableuserfeedback'] = 'Aktifkan umpan balik tentang perangkat lunak ini';
$string['enableuserfeedback_desc'] = 'Jika diaktifkan, tautan \'Berikan umpan balik tentang perangkat lunak ini\' ditampilkan di footer bagi pengguna untuk memberikan umpan balik tentang perangkat lunak Moodle ke Moodle HQ. Jika opsi \'Pengingat umpan balik berikutnya\' diatur, pengguna juga diperlihatkan pengingat di Dasbor pada interval yang ditentukan. Menyetel \'Pengingat umpan balik berikutnya\' ke \'Tidak pernah\' menonaktifkan pengingat Dasbor, sementara meninggalkan tautan \'Berikan umpan balik tentang perangkat lunak ini\' di footer.';
$string['enablewebservices'] = 'Aktifkan layanan web';
$string['enablewsdocumentation'] = 'Dokumentasi layanan web';
$string['encryptedpassword_edit'] = 'Masukkan nilai baru';
$string['encryptedpassword_set'] = '(Atur dan dienkripsi)';
$string['enroladminnewcourse'] = 'Daftar otomatis admin di kursus baru';
$string['enroladminnewcourse_help'] = 'Saat admin menambahkan kursus baru, haruskah mereka terdaftar secara otomatis dan diberi peran kreator dalam kursus baru?';
$string['enrolinstancedefaults'] = 'Model pendaftaran bawaan';
$string['enrolinstancedefaults_desc'] = 'Setelan pendaftaran kursus di kursus baru.';
$string['enrolmultipleusers'] = 'Daftarkan pengguna';
$string['entitytasklog'] = 'Log tugas';
$string['environment'] = 'Lingkungan';
$string['environmenterrortodo'] = 'Anda harus menyelesaikan semua masalah lingkungan (kesalahan) yang ditemukan di atas sebelum melanjutkan untuk menginstal versi Moodle ini!';
$string['environmenterrorupgrade'] = 'Peringatan: Anda harus menyelesaikan semua masalah lingkungan (kesalahan) yang ditemukan di atas sebelum melanjutkan untuk meningkatkan versi Moodle ini! Meningkatkan tanpa memperbaiki persyaratan ini dapat menyebabkan masalah seperti kehilangan data. Anda yakin ingin melanjutkan peningkatan?';
$string['environmentmariadbwrongdbtype'] = 'Salah $CFG->dbtype. Anda perlu mengubahnya di file config.php Anda dari \'mysqli\' menjadi \'mariadb\'.';
$string['environmentmustfixsetting'] = 'Setelan PHP harus diubah.';
$string['environmentok'] = 'Lingkungan server Anda memenuhi semua persyaratan minimum.';
$string['environmentrecommendcustomcheck'] = 'jika tes ini gagal, ini menunjukkan potensi masalah';
$string['environmentrecommendinstall'] = 'harus dipasang dan diaktifkan untuk hasil terbaik';
$string['environmentrecommendversion'] = 'versi {$a->needed} direkomendasikan dan Anda menjalankan {$a->current}';
$string['environmentrequirecustomcheck'] = 'tes ini harus lulus';
$string['environmentrequireinstall'] = 'harus dipasang dan diaktifkan';
$string['environmentrequireversion'] = 'versi {$a->needed} diperlukan dan Anda menjalankan {$a->current}';
$string['environmentsettingok'] = 'setelan yang direkomendasikan terdeteksi';
$string['environmentshouldfixcustomcheck'] = 'harus diaktifkan untuk hasil terbaik';
$string['environmentshouldfixsetting'] = 'Setelan PHP harus diubah.';
$string['environmentxmlerror'] = 'Galat membaca data lingkungan ({$a->error_code})';
$string['errordeletingconfig'] = 'Galat saat menghapus catatan konfigurasi untuk plugin \'{$a}\'.';
$string['errorsetting'] = 'Tidak dapat menyimpan setelan:';
$string['errorwithsettings'] = 'Beberapa setelan tidak diubah karena kesalahan.';
$string['eventshandlersinuse'] = 'Pengaya berikut di sistem Anda menggunakan pengendali Events 1 API yang tidak digunakan lagi: \'{$a}\'. Harap perbarui untuk menggunakan API Events 2. Lihat https://docs.moodle.org/dev/Events_API#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Setiap orang yang memiliki akses \'{$a}\'';
$string['exceptions'] = 'pengecualian';
$string['execpathnotallowed'] = 'Menetapkan jalur yang dapat dieksekusi dan lokal dinonaktifkan di config.php';
$string['experimental'] = 'Percobaan';
$string['experimentalsettings'] = 'Setelan eksperimental';
$string['extendedusernamechars'] = 'Izinkan karakter tambahan dalam nama pengguna';
$string['extramemorylimit'] = 'Batas memori PHP ekstra';
$string['fatalsessionautostart'] = '<p> Kesalahan konfigurasi yang serius terdeteksi, harap beri tahu administrator server. </p> <p> Untuk beroperasi dengan benar, Moodle mengharuskan administrator mengubah setelan PHP. </p> <p> <code> session.auto_start </code> harus disetel ke <code>off</code>.</i> <p> Setelan ini dikontrol dengan mengedit <code> php.ini </code>, Apache / IIS <br /> konfigurasi atau file <code> .htaccess </code> di server. </p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favicon ditampilkan di sebelah judul halaman di tab peramban. Favicon Moodle ditampilkan jika favicon kustom tidak tersedia.';
$string['feedbacksettings'] = 'Setelan Umpan Balik';
$string['fileconversioncleanuptask'] = 'Pembersihan catatan sementara untuk konversi file';
$string['filecreated'] = 'File baru telah dibuat';
$string['filescleanupperiod'] = 'Bersihkan file kumpulan sampah';
$string['filescleanupperiod_help'] = 'Seberapa sering berkas kumpulan sampah dihapus. Ini adalah berkas yang terkait dengan konteks yang sudah tidak ada lagi, misalnya saat kursus dihapus. Harap diperhatikan: Setelan ini dapat mengakibatkan berkas yang hilang dalam kursus yang dicadangkan, dihapus dan kemudian dikembalikan jika setelan \'Sertakan berkas\' (backup_auto_files) di \'Setelan cadangan otomatis\' dinonaktifkan.';
$string['filesizeunits'] = 'unit ukuran file';
$string['filestoredin'] = 'Simpan file ke dalam folder:';
$string['filestoredinhelp'] = 'Dimana file tersebut akan disimpan';
$string['filterall'] = 'Filter semua string';
$string['filtermatchoneperpage'] = 'Filter cocok sekali per halaman';
$string['filtermatchonepertext'] = 'Filter cocok sekali per teks';
$string['filternavigationwithsystemcontext'] = 'Filter navigasi dengan konteks sistem';
$string['filters'] = 'Filter';
$string['filtersettings'] = 'Atur filter';
$string['filtersettingsgeneral'] = 'Setelan filter umum';
$string['filteruploadedfiles'] = 'Filter file yang telah diunggah';
$string['forceclean'] = 'Pembersihan konten di mana-mana';
$string['forceclean_desc'] = 'Konten yang ditambahkan ke situs biasanya dibersihkan sebelum ditampilkan, untuk menghapus apa pun yang mungkin merupakan ancaman keamanan. Namun, konten tidak dibersihkan di tempat-tempat tertentu seperti deskripsi aktivitas, sumber daya halaman atau blok HTML untuk memungkinkan skrip, media, bingkai sebaris, dll. Untuk ditambahkan. Jika setelan ini diaktifkan, SEMUA konten akan dibersihkan. Ini dapat mengakibatkan konten yang ada tidak lagi ditampilkan dengan benar.';
$string['forcelogin'] = 'Paksa pengguna untuk masuk';
$string['forceloginforprofileimage'] = 'Paksa pengguna untuk masuk untuk melihat gambar pengguna';
$string['forceloginforprofileimage_help'] = 'Jika diaktifkan, pengguna harus masuk untuk melihat gambar profil pengguna dan gambar pengguna bawaan akan digunakan di semua surel pemberitahuan.';
$string['forceloginforprofiles'] = 'Paksa pengguna untuk masuk untuk profil';
$string['forcetimezone'] = 'Paksakan zona waktu';
$string['formatuninstallwithcourses'] = 'Terdapat {$a->count} kursus yang menggunakan {$a->format}. Formatnya akan diubah menjadi {$a->defaultformat} (format bawaan untuk situs ini). Beberapa data khusus format mungkin hilang. Anda yakin ingin melanjutkan?';
$string['frontpage'] = 'Beranda situs';
$string['frontpagebackup'] = 'Pencadangan beranda situs';
$string['frontpagedefaultrole'] = 'Peran beranda situs bawaan';
$string['frontpagefilters'] = 'Filter beranda situs';
$string['frontpageloggedin'] = 'Item beranda situs ketika masuk';
$string['frontpageoverrides'] = 'Penyampingan izin beranda situs';
$string['frontpagequestions'] = 'Pertanyaan beranda situs';
$string['frontpagerestore'] = 'Pemulihan beranda situs';
$string['frontpageroles'] = 'Peran beranda situs';
$string['frontpagesettings'] = 'Setelan beranda situs';
$string['fullnamedisplay'] = 'Format nama lengkap';
$string['fullnamedisplayprivate'] = 'Format nama lengkap - pribadi';
$string['gdrequired'] = 'Ekstensi GD sekarang dibutuhkan oleh Moodle untuk konversi gambar.';
$string['generalsettings'] = 'Setelan umum';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Sumber alamat IP yang dicatat';
$string['globalsearch'] = 'Pencarian global';
$string['globalsearchmanage'] = 'Kelola pencarian global';
$string['googlemapkey3'] = 'Kunci Google Maps API V3';
$string['googlemapkey3_help'] = 'Anda perlu memasukkan kunci khusus untuk menggunakan Google Maps untuk visualisasi pencarian alamat IP. Anda dapat memperoleh kunci secara gratis di <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/ peta/dokumentasi/javascript/tutorial#api_key</a>https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Menuju string pertama yang hilang';
$string['gradebook'] = 'Buku Nilai';
$string['gradebookroles'] = 'Aturan penilaian';
$string['gradeexport'] = 'Metode ekspor penilaian utama';
$string['gradeexportdefault'] = 'Metode ekspor nilai bawaan';
$string['gravatardefaulturl'] = 'Alamat URL foto Gravatar';
$string['gravatardefaulturl_help'] = 'Gravatar memerlukan gambar bawaan untuk ditampilkan jika tidak dapat menemukan gambar untuk pengguna tertentu. Berikan URL lengkap untuk sebuah gambar. Jika Anda membiarkan setelan ini kosong, Moodle akan mencoba menggunakan gambar bawaan yang paling sesuai untuk halaman yang Anda lihat. Perhatikan juga bahwa Gravatar memiliki sejumlah kode yang dapat digunakan untuk <a href="https://en.gravatar.com/site/implement/images/#default-image"> menghasilkan gambar bawaan </a>.';
$string['group_customfield'] = 'Kolom kustom grup';
$string['groupenrolmentkeypolicy'] = 'Kebijakan kunci pendaftaran grup';
$string['groupenrolmentkeypolicy_desc'] = 'Jika diaktifkan, kunci pendaftaran grup akan diperiksa terhadap kebijakan kata sandi seperti yang ditentukan dalam setelan di atas.';
$string['grouping_customfield'] = 'Kolom kustom pengelompokan';
$string['guestroleid'] = 'Peran untuk tamu';
$string['guestroleid_help'] = 'Peran ini secara otomatis ditetapkan ke pengguna tamu. Ini juga untuk sementara ditugaskan kepada pengguna yang tidak terdaftar yang mengikuti kursus melalui pengaya pendaftaran tamu.';
$string['h5pgetcontenttypestask'] = 'Unduh tipe konten H5P dari h5p.org';
$string['helpadminseesall'] = 'Dalam kalender situs, apakah admin melihat dan memfilter acara dari semua kalender kursus atau hanya dari mereka yang mengikuti kursus? Terlepas dari opsi yang dipilih, admin akan selalu dapat mengelola acara untuk setiap kalender kursus dengan menavigasi ke kursus pertama, dan kemudian mengakses kalender kursus secara langsung.';
$string['helpcalendarcustomexport'] = 'Aktifkan opsi ekspor rentang tanggal kustom dalam ekspor kalender. Ekspor kalender harus diaktifkan sebelum ini efektif.';
$string['helpexportlookahead'] = 'Berapa hari lagi kalender akan mencari acara selama ekspor untuk opsi ekspor kustom?';
$string['helpexportlookback'] = 'Berapa hari sebelumnya kalender mencari acara selama ekspor untuk opsi ekspor kustom?';
$string['helpforcetimezone'] = 'Anda dapat mengizinkan pengguna untuk secara individual memilih zona waktu mereka, atau memaksa zona waktu untuk semua orang.';
$string['helpshowicalsource'] = 'Jika diaktifkan, nama dan tautan langganan akan ditampilkan untuk acara yang diimpor oleh iCal.';
$string['helpsitemaintenance'] = 'Untuk peningkatan dan pekerjaan lainnya';
$string['helpstartofweek'] = 'Hari untuk memulai minggu dalam kalender?';
$string['helpupcominglookahead'] = 'Secara bawaan, berapa hari ke depan kalender mencari acara mendatang?';
$string['helpupcomingmaxevents'] = 'Berapa banyak (maksimum) acara mendatang yang ditampilkan kepada pengguna secara bawaan?';
$string['helpweekenddays'] = 'Hari yang dianggap sebagai akhir pekan yang akan ditampilkan dengan warna yang berbeda?';
$string['hiddenuserfields'] = 'Sembunyikan kolom pengguna';
$string['hidefromall'] = 'Sembunyikan dari semua pengguna';
$string['hidefromnone'] = 'Sembunyikan dari siapa pun';
$string['hidefromstudents'] = 'Sembunyikan dari siswa';
$string['hookcallbacknotcallable'] = 'Panggilan balik ini tidak dapat dipanggil. Hal ini dapat terjadi karena kelas atau metode tersebut tidak ada, atau karena metode tersebut tidak bersifat publik.';
$string['hookcallbacks'] = 'Panggilan balik';
$string['hookcallbacks_help'] = 'Daftar panggilan balik yang akan dipanggil saat kait dikirim.

Urutan yang ditampilkan adalah panggilan balik mana yang dipanggil.

Panggilan balik dengan prioritas lebih tinggi akan dipanggil sebelum panggilan dengan prioritas lebih rendah.';
$string['hookclassmissing'] = 'Kelas Kait tidak ditemukan';
$string['hookclassmissing_desc'] = 'Agen penemuan kail telah mengembalikan kelas yang tidak ada.';
$string['hookconfigoverride'] = 'Ditimpa';
$string['hookconfigoverride_help'] = 'Definisi callback ini telah diganti dalam berkas konfigurasi situs, config.php';
$string['hookdeprecates'] = 'Panggilan balik yang tidak digunakan lagi';
$string['hookdescription'] = 'Deskripsi';
$string['hookdescriptionmissing'] = 'Kait tidak memiliki metode deskripsi';
$string['hookname'] = 'Kaitan';
$string['hooksoverview'] = 'Ikhtisar kait';
$string['hookunknown'] = 'Kait tidak ditemukan';
$string['hookunknown_desc'] = 'Objek yang didengarkan panggilan balik ini tidak tersedia. Itu mungkin telah dihapus atau diganti namanya, atau mungkin tidak tersedia di versi Moodle ini.';
$string['hostname'] = 'Nama hos';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Setelan editor HTML';
$string['htmlsettings'] = 'Setelan HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Keamanan HTTP';
$string['iconvrequired'] = 'Menginstal ekstensi ICONV diperlukan.';
$string['igbinary322buggyversion'] = 'Ekstensi php-igbinary yang diinstal di situs dapat menyebabkan masalah saat dijalankan dengan PHP 7.2. Anda disarankan untuk meningkatkan ke php-igbinary 3.2.5 atau yang lebih baru, atau sebagai alternatif untuk meningkatkan ke PHP 7.3 atau yang lebih baru.';
$string['ignore'] = 'Abaikan';
$string['includemoduleuserdata'] = 'Sertakan data pengguna modul';
$string['incompatibleblocks'] = 'Blok tidak kompatibel';
$string['incompleteunicodesupport'] = 'Setelan MySQL atau MariaDB saat ini menggunakan \'utf8\'. Set karakter ini tidak mendukung karakter empat byte yang menyertakan beberapa emoji. Mencoba menggunakan karakter ini akan menghasilkan kesalahan saat memperbarui rekaman, dan informasi apa pun yang dikirim ke basis data akan hilang. Harap pertimbangkan untuk mengubah setelan Anda ke \'utf8mb4\'. Lihat dokumentasi untuk detail lengkapnya.';
$string['indexdata'] = 'Data indeks';
$string['indexinginfo'] = 'Cara yang disarankan untuk mengindeks konten situs anda adalah dengan menggunakan tugas terjadwal \'Pengindeksan pencarian global\'.';
$string['installhijacked'] = 'Instalasi harus diselesaikan dari alamat IP asli, maaf.';
$string['installsessionerror'] = 'Tidak dapat menginisialisasi sesi PHP. Harap verifikasi bahwa peramban Anda menerima kuki.';
$string['intlrecommended'] = 'Ekstensi intl digunakan untuk meningkatkan dukungan internasionalisasi, seperti penyortiran sadar lokal.';
$string['intlrequired'] = 'Ekstensi intl diperlukan untuk meningkatkan dukungan internasionalisasi, seperti penyortiran sadar lokal dan nama domain internasional.';
$string['invalidagedigitalconsent'] = 'Usia digital persetujuan tidak valid: {$a}';
$string['invalidforgottenpasswordurl'] = 'URL kata sandi yang terlupa bukanlah URL yang valid.';
$string['invalidsection'] = 'Section salah.';
$string['invalidthemepreset'] = 'Berkas prasetel yang dipilih tidak kompatibel dengan tema ini. Kesalahan kompilasi SCSS adalah: "{$a}"';
$string['invaliduserchangeme'] = 'Nama pengguna "changeme" sudah dipesan - Anda tidak dapat membuat akun dengannya.';
$string['ipblocked'] = 'Situs ini tidak tersedia saat ini.';
$string['ipblocker'] = 'Pemblokir IP';
$string['ipblockersyntax'] = 'Letakkan setiap entri dalam satu baris. Entri yang valid dapat berupa alamat IP lengkap (seperti <b> 192.168.10.1 </b>) yang cocok dengan satu host; atau alamat parsial (seperti <b> 192.168 </b>) yang cocok dengan alamat apa pun yang dimulai dengan nomor itu; atau notasi CIDR (seperti <b> 231.54.211.0/20 </b>); atau rentang alamat IP (seperti <b> 231.3.56.10-20 </b>) di mana rentang tersebut berlaku untuk bagian terakhir alamat. Nama domain teks (seperti \'example.com\') tidak didukung. Baris kosong, dan teks setelah karakter "#" akan diabaikan.';
$string['iplookup'] = 'Pencarian alamat IP';
$string['iplookupgeoplugin'] = 'Layanan <a href="https://www.geoplugin.com"> geoPlugin </a> saat ini digunakan untuk mencari informasi geografis. Untuk hasil yang lebih akurat, kami sarankan untuk menginstal salinan lokal dari basis data MaxMind GeoLite.';
$string['iplookupinfo'] = 'Server NetGeo daring gratis digunakan untuk mencari lokasi alamat IP. Basis data tidak dipertahankan lagi, dan mungkin mengembalikan data yang salah. Menginstal salinan lokal dari basis data GeoLite2 City gratis dari MaxMind disarankan.<br />
Jika kunci Google Maps API V3 disediakan, lokasi alamat IP ditampilkan menggunakan Google Maps. Anda memerlukan akun Google dan untuk mengajukan kunci Google Maps API. Jika tidak ada kunci Google Maps API V3 yang disediakan, lokasi alamat IP ditampilkan menggunakan OpenStreetMap.';
$string['iplookupmaxmindnote'] = 'Produk ini mencakup data GeoLite2 yang dibuat oleh MaxMind, tersedia dari <a href="https://www.maxmind.com"> https://www.maxmind.com </a>.';
$string['iscustomadminwarnings'] = 'Telah terdeteksi bahwa situs Anda menggunakan direktori admin kustom. Fitur ini tidak lagi didukung dan akan dihapus setelah Moodle 4.2.';
$string['ishttpswarning'] = 'Telah terdeteksi bahwa situs Anda tidak diamankan menggunakan HTTPS. Sangat disarankan untuk memigrasi situs Anda ke HTTPS untuk meningkatkan keamanan dan meningkatkan integrasi dengan sistem lain.';
$string['keeptagnamecase'] = 'Pertahankan casing nama tag';
$string['lang'] = 'Bahasa bawaan';
$string['langcache'] = 'Singgahan menu bahasa';
$string['langcache_desc'] = 'Singgahan menu bahasa. Jika diaktifkan, daftar terjemahan yang tersedia akan disimpan dalam Singgahan. Singgahan secara otomatis disegarkan saat Anda menginstal atau menghapus paket bahasa melalui alat manajemen paket bahasa bawaan. Jika Anda menginstal paket bahasa baru secara manual, Anda harus menggunakan fitur Bersihkan semua singgahan untuk menyegarkan daftar singgahan.';
$string['langlist'] = 'Bahasa-bahasa di menu bahasa';
$string['langmenu'] = 'Tampilkan menu bahasa';
$string['langmenuinsecurelayout'] = 'Tampilkan menu bahasa di layout yang aman';
$string['langmenuinsecurelayout_desc'] = 'Jika diaktifkan, pengguna akan dapat mengubah bahasa mereka saat mencoba kuis atau aktivitas lain menggunakan tata letak aman.';
$string['langpackwillbeupdated'] = 'CATATAN: Moodle akan mencoba mengunduh pembaruan untuk paket bahasa anda selama peningkatan.';
$string['langstringcache'] = 'Singgahkan semua string bahasa';
$string['languagesettings'] = 'Setelan bahasa';
$string['latinexcelexport'] = 'Pengodean Excel';
$string['legacyfilesaddallowed'] = 'Izin tambahkan ke berkas kursus lawas';
$string['legacyfilesaddallowed_help'] = 'Jika suatu kursus memiliki berkas kursus lama, izinkan berkas dan folder baru ditambahkan ke dalamnya.';
$string['legacyfilesinnewcourses'] = 'Berkas kursus lawas pada kursus baru';
$string['legacyfilesinnewcourses_help'] = 'Secara bawaan, area berkas kursus lama hanya tersedia di kursus yang ditingkatkan. Harap dicatat bahwa beberapa fitur seperti pencadangan dan pemulihan aktivitas tidak kompatibel dengan setelan ini.';
$string['libcurlwarning'] = 'Telah terdeteksi bahwa libcurl tidak memiliki dukungan CURLOPT_PROTOCOL. Instalasi libcurl terbaru disarankan untuk alasan keamanan.';
$string['licensesettings'] = 'Setelan lisensi';
$string['linkadmincategories'] = 'Tautkan kategori admin';
$string['linkadmincategories_help'] = 'Jika diaktifkan, kategori setelan admin akan ditampilkan sebagai tautan di navigasi dan akan mengarah ke halaman kategori admin.';
$string['linkcoursesections'] = 'Selalu tautkan topik kursus';
$string['linkcoursesections_help'] = 'Usahakan selalu untuk menyediakan tautan untuk topik kursus. Topik kursus biasanya hanya ditampilkan sebagai tautan jika format kursus menampilkan satu bagian per halaman. Jika setelan ini diaktifkan, tautan akan selalu disediakan.';
$string['loading'] = 'Memuat';
$string['localetext'] = 'Lokal di seluruh situs';
$string['localstringcustomization'] = 'Kustomisasi string lokal';
$string['location'] = 'Lokasi';
$string['locationsettings'] = 'Setelan Lokasi';
$string['locked'] = 'Terkunci';
$string['lockoutduration'] = 'Durasi penguncian akun';
$string['lockoutduration_desc'] = 'Akun yang dikunci secara otomatis dibuka setelah durasi ini.';
$string['lockoutemailbody'] = 'Akun Anda dengan nama pengguna {$a->username} di server \'{$a->sitename}\' dikunci setelah beberapa upaya login tidak valid.

Untuk membuka kunci akun, segera klik tautan berikut

{$a->link}

Pada kebanyakan program surel, ini akan muncul sebagai pranala biru yang dapat Anda klik. Jika tidak berhasil, salin dan tempel alamat tersebut ke baris alamat di bagian atas jendela peramban web Anda.

Jika Anda membutuhkan bantuan, silakan hubungi administrator situs, {$a->admin}';
$string['lockoutemailsubject'] = 'Akun Anda di {$a} terkunci';
$string['lockouterrorunlock'] = 'Informasi buka kunci akun yang diberikan tidak valid.';
$string['lockoutthreshold'] = 'Ambang penguncian akun';
$string['lockoutthreshold_desc'] = 'Pilih jumlah upaya login yang gagal yang mengakibatkan penguncian akun. Fitur ini dapat disalahgunakan dalam serangan penolakan layanan.';
$string['lockoutwindow'] = 'Jendela observasi penguncian akun';
$string['lockoutwindow_desc'] = 'Waktu pengamatan untuk ambang batas penguncian, jika tidak ada upaya yang gagal, penghitung ambang batas diatur ulang setelah waktu ini.';
$string['lockrequestcategory'] = 'Cegah pemilihan kategori';
$string['log'] = 'Catatan';
$string['logguests'] = 'Catatan akses tamu';
$string['logguests_help'] = 'Setelan ini memungkinkan penebangan tindakan dengan akun tamu dan bukan pengguna yang masuk. Situs profil tinggi mungkin ingin menonaktifkan catatan log ini karena alasan kinerja. Disarankan untuk tetap setelan setelan ini di lokasi produksi.';
$string['logininfoinsecurelayout'] = 'Tampilan pengguna yang telah masuk dalam setelan aman';
$string['logininfoinsecurelayout_desc'] = 'Jika diaktifkan, nama lengkap pengguna yang masuk akan ditampilkan di bilah navigasi saat mencoba kuis atau aktivitas lain menggunakan tata letak aman.';
$string['loginpageautofocus'] = 'Halaman formulir login autofokus';
$string['loginpageautofocus_help'] = 'Mengaktifkan opsi ini meningkatkan kegunaan halaman masuk, tetapi pemfokusan kolom secara otomatis dapat dianggap sebagai masalah aksesibilitas.';
$string['loglifetime'] = 'Menyimpan catatan untuk berapa lama';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Logo lengkap untuk digunakan sebagai dekorasi oleh beberapa tema (seperti tema inti). Gambar ini dapat memiliki resolusi yang cukup tinggi karena akan diperkecil untuk digunakan (dan disinggahkan untuk kinerja). Logo yang lebih lebar daripada tinggi biasanya memberikan hasil yang lebih baik.';
$string['logocompact'] = 'Logo ringkas';
$string['logocompact_desc'] = 'Versi ringkas dari logo yang sama seperti di atas, seperti lambang, perisai atau ikon. Gambar harus jelas bahkan pada ukuran kecil.';
$string['logossettings'] = 'Logo';
$string['logstorenotrequired'] = 'Penyimpanan catatan tidak diperlukan';
$string['logstoressupported'] = 'Penyimpanan catatan yang mendukung laporan ini';
$string['longtimewarning'] = '<b>Mohon perhatikan, proses ini bisa memakan waktu lama.</b>';
$string['mailnewline'] = 'Baris karakter baru dalam surat';
$string['maintenancemode'] = 'Sedang dalam perbaikan';
$string['maintenancemodeisscheduled'] = 'Situs ini akan dialihkan ke mode pemeliharaan dalam {$a->min} menit {$a->sec} detik';
$string['maintenancemodeisscheduledlong'] = 'Situs ini akan dialihkan ke mode pemeliharaan dalam {$a->hour} jam {$a->min} menit {$a->sec} detik';
$string['maintfileopenerror'] = 'Galat saat membuka file pemeliharaan!';
$string['maintinprogress'] = 'Sedang perbaikan ...';
$string['managecontextlock'] = 'Bekukan konteks ini';
$string['managecontextlocklocked'] = '{$a->contextname} dan konteks yang lebih rendah sekarang dibekukan.';
$string['managecontextlockunlocked'] = '{$a->contextname} dan konteks yang lebih rendah sekarang tidak dibekukan.';
$string['managecontextunlock'] = 'Aktifkan kembali konteks ini';
$string['managecustomfields'] = 'Kelola jenis kolom kustom';
$string['manageformats'] = 'Kelola format kursus';
$string['manageformatsgotosettings'] = 'Format bawaan dapat diubah dalam {$a}';
$string['managelang'] = 'Kelola';
$string['manageqbanks'] = 'Atur pengaya bank soal';
$string['manageqbehaviours'] = 'Kelola perilaku soal';
$string['manageqtypes'] = 'Kelola jenis soal';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Kandidat rilis';
$string['maturity200'] = 'Versi stabil';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Petunjuk: Anda mungkin ingin menjalankan skrip ini dengan opsi --allow-unstable';
$string['maturitycoreinfo'] = 'Situs Anda sedang menjalankan kode pengembangan "{$a}" yang tidak stabil.';
$string['maturitycorewarning'] = 'Versi Moodle yang akan Anda pasang atau tingkatkan mengandung kode pengembangan "{$a}" yang tidak stabil dan tidak cocok untuk banyak situs. Jika ini bukan yang Anda inginkan, pastikan Anda memperbarui dari kode Moodle cabang STABIL. Lihat dokumen Moodle untuk detail lebih lanjut.';
$string['maxbytes'] = 'Ukuran maksimum pada pengunggahan file';
$string['maxcharacter'] = '{$a} maksimum karakter';
$string['maxconsecutiveidentchars'] = 'Karakter identik berurutan';
$string['maxeditingtime'] = 'Waktu maksimum untuk mengubah posting';
$string['maxsizeperdownloadcoursefile'] = 'Ukuran maksimal tiap berkas';
$string['maxsizeperdownloadcoursefile_desc'] = 'Ukuran maksimal tiap berkas saat mengunduh isi kursus. Berkas yang melebihi ukuran ini akan dihilangkan dari pengunduhan.';
$string['maxtimelimit'] = 'Waktu pengerjaan maksimum';
$string['maxtimelimit_desc'] = 'Untuk membatasi jumlah eksekusi maksimal PHP yang diizinkan Moodle tanpa ditampilkan, masukkan nilai dalam satuan detik di sini. 0 artinya menggunakan setelan bawaan Moodle. Jika Anda memiliki server front-end dengan batas waktu tersendiri, atur waktu di sini lebih rendah untuk menerima catatan kesalahan. Tidak dapat digunakan untuk naskah CLI.';
$string['maxusersperpage'] = 'Pengguna maksimal tiap halaman';
$string['mbstringrecommended'] = 'Sangat disarankan untuk memasang pustaka MBSTRING untuk meningkatkan kinerja situs, terutama jika situs Anda mendukung bahasa yang tidak menggunakan karakter Latin.';
$string['mbstringrequired'] = 'Pustaka MBSTRING dibutuhkan untuk meningkatkan kinerja situs, terutama jika situs Anda tidak menggunakan karakter Latin.';
$string['mediapluginavi'] = 'Aktifkan filter .avi';
$string['mediapluginflv'] = 'Aktifkan filter .flv';
$string['mediapluginimg'] = 'Mengaktifkan tanam otomatis dari gambar yang terhubung';
$string['mediapluginmov'] = 'Aktifkan filter .mov';
$string['mediapluginmp3'] = 'Aktifkan filter .mp3';
$string['mediapluginmpg'] = 'Aktifkan filter .mpg';
$string['mediapluginogg'] = 'Aktifkan filter .ogg';
$string['mediapluginogv'] = 'Aktifkan filter .ogv';
$string['mediapluginram'] = 'Aktifkan filter .ram';
$string['mediapluginrm'] = 'Aktifkan filter .rm';
$string['mediapluginrpm'] = 'Aktifkan filter .rpm';
$string['mediapluginwmv'] = 'Aktifkan filter .wmv';
$string['mediapluginyoutube'] = 'Aktifkan filter link YouTube';
$string['messaging'] = 'Mengaktifkan sistem pengolahan pesan';
$string['messagingallowemailoverride'] = 'Penyampingan notifikasi surel';
$string['messagingallusers'] = 'Mengizinkan olah pesan di dalam situs';
$string['messagingcategory'] = 'Olah pesan';
$string['messagingdefaultpressenter'] = 'Menggunakan tombol enter untuk mengirim diaktifkan secara bawaan';
$string['messagingdeleteallnotificationsdelay'] = 'Hapus semua notifikasi';
$string['messagingdeletereadnotificationsdelay'] = 'Hapus notifikasi yang sudah terbaca';
$string['messagingssettings'] = 'Setelan olah pesan';
$string['minpassworddigits'] = 'Digit';
$string['minpasswordlength'] = 'Panjang kata sandi';
$string['minpasswordlower'] = 'Huruf kecil';
$string['minpasswordnonalphanum'] = 'karakter non-alfanumerik';
$string['minpasswordupper'] = 'Huruf besar';
$string['misc'] = 'Lain-lain';
$string['mlbackendsettings'] = 'Setelan backend pembelajaran mesin';
$string['mnetrestore_extusers'] = '<strong>Catatan:</strong> Berkas cadangan ini berisi akun pengguna Jaringan Moodle tersendiri yang akan dipulihkan sebagai bagian dari proses.';
$string['mnetrestore_extusers_admin'] = '<strong>Catatan:</strong> Berkas cadangan ini nampaknya berasal dari instalasi Moodle yang berbeda dan berisi akun pengguna Jaringan Moodle tersendiri. Selama proses pemulihan, Jaringan Moodle akan mencocokkan akun yang telah dibuat. Yang tidak cocok, otomatis akan diganti ke autentikasi internal (bukan mnet). Anda bisa mengetahuinya di catatan pemulihan.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Catatan:</strong> Berkas cadangan ini nampaknya berasal dari instalasi Moodle yang berbeda dan berisi akun pengguna Jaringan Moodle yang gagal dipulihkan. Tindakan ini tidak bisa dilanjutkan. Jika Anda yakin berkas ini dibuat dalam instalasi Moodle ini, atau Anda bisa memastikan bahwa Hos Jaringan Moodle yang dibutuhkan telah terkonfigurasi, Anda mungkin bisa mencoba lagi.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Catatan:</strong> Berkas cadangan ini nampaknya berasal dari instalasi Moodle yang berbeda dan berisi akun pengguna Jaringan Moodle tersendiri. Anda tidak diizinkan untuk melakukan pemulihan jenis ini. Hubungi administrator situs atau pulihkan kursus ini tanpa informasi pengguna (modul, berkas,...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Pengguna jaringan Moodle lain {$a->username} (dari {$a->mnethosturl}) dialihkan ke pengguna lokal {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'Aplikasi Moodle tidak diaktifkan';
$string['modassignmentinuse'] = 'Situs Anda masih menggunakan pengaya Penugasan 2.2. Sebelum memutakhirkan, Anda harus 1) mencadangkan aktivitas Penugasan 2.2 yang ingin Anda simpan dan memulihkannya sebagai aktivitas Penugasan, dan 2) menghapus semua data Penugasan 2.2 dari basis data.';
$string['modassignmentsubpluginsexist'] = 'Sub-pengaya Penugasan 2.2 mungkin tersedia. Folder mod/assignment dan semua sub-pengayanya perlu dihapus sebelum memutakhirkan.';
$string['modeditdefaults'] = 'Nilai bawaan untuk setelan aktivitas';
$string['modsettings'] = 'Kelola aktivitas';
$string['modulesecurity'] = 'Modul keamanan';
$string['moodleapp'] = 'Aplikasi Moodle';
$string['moodleapp_help'] = '<p> Jika Anda memiliki akun di situs Moodle, Anda dapat mengakses semua kursus di perangkat seluler Anda dengan aplikasi seluler gratis kami untuk Moodle. </p> <a href = "https://moodle.com/mobile-app"> Dapatkan aplikasi Moodle </a>';
$string['moodlebrandedapp'] = 'Aplikasi Moodle bermerek';
$string['moodlebrandedapp_help'] = '<p> Aplikasi Moodle Bermerek memiliki semua fungsi aplikasi seluler gratis kami untuk Moodle yang dikombinasikan dengan merek kustom Anda sendiri. </p> <a href="https://moodle.com/branded-app"> Tentang Aplikasi Moodle bermerek</a>';
$string['moodlebrandedappreference'] = 'Cara lainnya, dapatkan sebuah <a href="https://moodle.com/branded-app/">Aplikasi Moodle bermerek</a> dengan merek kustom milik Anda.';
$string['moodlepartners'] = 'Mitra Moodle';
$string['moodlepartners_help'] = '<p> Mitra Moodle adalah penyedia layanan yang disertifikasi oleh Moodle HQ untuk memberikan layanan Moodle berkualitas tinggi untuk lingkungan pembelajaran online organisasi Anda. </p> <a href="https://moodle.com/about-partners/"> Tentang Mitra kami </a> <br /> <a href="https://moodle.com/partners"> Temukan Mitra </a>';
$string['moodleservices'] = 'Layanan Moodle';
$string['moodleservices_help'] = 'Pastikan Anda mendapatkan yang terbaik dari lingkungan belajar Moodle Anda dengan menggunakan layanan Moodle ini:';
$string['multilangforceold'] = 'Paksa sintaks multibahasa lama: &lt;span&gt; tanpa class="multilang" dan &lt;lang&gt;';
$string['mustenablestats'] = 'Statistik belum diaktifkan pada situs ini';
$string['mycourses'] = 'Kursus saya';
$string['mydashboard'] = 'Dasbor sistem bawaan';
$string['mymoodle'] = 'Dasbor';
$string['mypage'] = 'Halaman Dasbor bawaan';
$string['mypagelocked'] = 'Kunci halaman bawaan';
$string['myprofile'] = 'Halaman profil bawaan';
$string['navadduserpostslinks'] = 'Menambahkan tautan untuk melihat kiriman pengguna';
$string['navadduserpostslinks_help'] = 'Jika diaktifkan, dua tautan akan ditambahkan ke setiap pengguna di navigasi untuk melihat diskusi yang telah dimulai pengguna dan kiriman yang dibuat pengguna di forum di seluruh situs atau dalam kursus tertentu.';
$string['navcourselimit'] = 'Limit kursus';
$string['navigationupgrade'] = 'Peningkatan ini memperkenalkan dua blok navigasi baru yang akan menggantikan blok-blok ini: Administrasi, Kursus, Aktivitas, dan Peserta. Jika Anda telah menetapkan izin khusus pada blok tersebut, Anda harus memeriksa untuk memastikan semuanya berjalan sesuai keinginan Anda.';
$string['navshowallcourses'] = 'Tampilkan semua kursus';
$string['navshowcategories'] = 'Tampilkan kategori kursus';
$string['navshowfrontpagemods'] = 'Tampilkan aktivitas beranda situs di navigasi';
$string['navshowfrontpagemods_help'] = 'Jika diaktifkan, aktivitas beranda situs akan ditampilkan pada navigasi di bawah halaman situs.';
$string['navshowfullcoursenames'] = 'Tampilkan nama lengkap kursus';
$string['navshowfullcoursenames_help'] = 'Jika diaktifkan, nama lengkap kursus akan digunakan dalam navigasi daripada nama singkat.';
$string['navshowmycoursecategories'] = 'Tampilkan kategori kursusku';
$string['navshowmycoursecategories_help'] = 'Jika diaktifkan, kursus di cabang kursus saya milik pengguna akan ditampilkan dalam kategori di blok navigasi (hanya tema berbasis Klasik)';
$string['navsortmycourseshiddenlast'] = 'Urutkan kursus tersembunyi saya terakhir';
$string['navsortmycourseshiddenlast_help'] = 'Jika diaktifkan, kursus tersembunyi apa pun akan terdaftar setelah kursus yang terlihat (untuk pengguna yang dapat melihat kursus tersembunyi). Jika tidak, semua kursus, terlepas dari visibilitasnya, akan dicantumkan sesuai dengan setelan \'Urutkan kursus saya\'.';
$string['navsortmycoursessort'] = 'Urutan kursus di blok navigasi';
$string['navsortmycoursessort_help'] = 'Haruskah kursus dicantumkan dalam urutan yang diatur di Administrasi situs > Kursus > Kelola kursus dan kategori, atau menurut abjad menurut setelan kursus? Setelan ini hanya berlaku untuk tema Klasik.';
$string['never'] = 'Jangan';
$string['neverdeleteruns'] = 'Jangan hapus proses';
$string['newestdocindexed'] = 'Dokumen terbaru terindeks';
$string['nobookmarksforuser'] = 'Anda tidak memiliki markah apa pun.';
$string['nodatabase'] = 'Tidak ada basis data';
$string['noemaileverwarning'] = '<strong>Catatan:</strong> Semua surel keluar telah dinonaktifkan';
$string['nohttpsformobilewarning'] = 'Direkomendasikan untuk mengaktifkan HTTPS dengan sertifikat yang valid. Aplikasi Moodle akan selalu mencoba menggunakan koneksi aman terlebih dahulu.';
$string['nomissingstrings'] = 'TIdak ada string yang hilang';
$string['none'] = 'Tidak ada';
$string['nonewsettings'] = 'Tidak ada setelan baru yang ditambahkan selama peningkatan ini.';
$string['nonexistentbookmark'] = 'Markah halaman yang Anda minta tidak tersedia.';
$string['noreplyaddress'] = 'Alamat No-reply';
$string['noreplydomain'] = 'No-reply dan domain';
$string['noreplydomaindetail'] = 'Setelan untuk No-reply dan domain yang dikonfigurasi';
$string['noresults'] = 'Tidak ada hasil yang ditemukan.';
$string['noroles'] = 'Tidak ada peran';
$string['nosupportedlogstore'] = 'Tidak ditemukan penyimpanan log yang didukung';
$string['noteunneededblocks'] = 'Catatan: Blok yang diatur untuk ditampilkan tidak akan dicantumkan dalam menu \'Tambahkan blok\' dalam kursus jika ditentukan dalam setelan tema \'Blok yang tidak diperlukan\'.';
$string['notifications'] = 'Notifikasi';
$string['notifyloginfailures'] = 'Log masuk surel gagal ke';
$string['notifyloginthreshold'] = 'Ambang untuk notifikasi surel';
$string['notloggedinroleid'] = 'Aturan untuk pengunjung';
$string['numberofmissingstrings'] = 'Jumlah string yang hilang: {$a}';
$string['numberofstrings'] = 'Jumlah total string: {$a->strings}<br />Missing: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Token penyegaran untuk salah satu layanan OAuth {$a->issuer} di situs Anda {$a->siteurl} telah kedaluwarsa. Ini akan membatasi fungsionalitas pengaya apa pun yang menggunakan layanan ini. Untuk memperbaiki masalah ini, kunjungi halaman konfigurasi Layanan OAuth 2 dan klik ikon "Hubungkan akun sistem" di baris tabel untuk layanan ini. Pastikan untuk masuk menggunakan akun layanan yang sama untuk sistem OAuth setiap kali.';
$string['oauthrefreshtokenexpiredshort'] = 'Token penyegaran OAuth kedaluwarsa untuk {$a->issuer} di situs Anda {$a->siteurl}.';
$string['onlynoreply'] = 'Hanya ketika dari alamat no-reply';
$string['opcacherecommended'] = 'Menyinggahkan opcode PHP meningkatkan kinerja dan menurunkan persyaratan memori, ekstensi OPcache direkomendasikan dan didukung penuh.';
$string['opensslrecommended'] = 'Sangat disarankan untuk menginstal pustaka OpenSSL opsional - ini memungkinkan fungsionalitas Jaringan Moodle.';
$string['opensslrequired'] = 'Ekstensi PHP OpenSSL sekarang dibutuhkan oleh Moodle untuk menyediakan layanan kriptografi yang lebih kuat.';
$string['opentowebcrawlers'] = 'Terbuka untuk mesin pencari';
$string['optionalmaintenancemessage'] = 'Pesan perawatan opsional';
$string['oracledatabaseinuse'] = 'Dukungan Oracle DB harus dihapus. Moodle 4.5 akan menjadi versi terakhir dengan dukungan Oracle DB. Untuk detailnya, lihat pengumuman di moodle.org <a href="https://moodle.org/mod/forum/discuss.php?d=456122">dukungan database Oracle dalam penghentian LMS</a>.';
$string['order1'] = 'Pertama';
$string['order2'] = 'Kedua';
$string['order3'] = 'Ketiga';
$string['order4'] = 'Keempat';
$string['outgoingmailconfig'] = 'Konfigurasi surel keluar';
$string['overridetossl'] = 'HTTPS untuk log masuk sekarang sudah tidak digunakan lagi. Model ini sekarang dipaksa untuk SSL. Untuk memperbaiki peringatan ini, ubah wwwroot Anda di config.php menjadi https://';
$string['pageinfodebugsummary'] = 'Halaman ini adalah: {$a}';
$string['passwordchangelogout'] = 'Keluar setelah penggantian kata sandi';
$string['passwordchangelogout_desc'] = 'Jika diaktifkan, ketika kata sandi diubah, semua sesi peramban diakhiri, kecuali sesi yang menentukan kata sandi baru. (Setelan ini tidak memengaruhi perubahan kata sandi melalui unggahan massal pengguna.)';
$string['passwordchangetokendeletion'] = 'Hapus token akses layanan web setelah perubahan kata sandi';
$string['passwordchangetokendeletion_desc'] = 'Hapus token akses layanan web setelah kata sandi diubah';
$string['passwordpolicy'] = 'Kebijakan kata sandi';
$string['passwordpolicycheckonlogin'] = 'Cek kata sandi ketika masuk';
$string['passwordresettime'] = 'Validasi maksimum untuk permohonan penggantian kata sandi';
$string['passwordreuselimit'] = 'Batas rotasi kata sandi';
$string['passwordreuselimit_desc'] = 'Berapa kali pengguna harus mengubah sandi mereka sebelum mereka diizinkan untuk menggunakan kembali sandi. Hash dari kata sandi yang digunakan sebelumnya disimpan dalam tabel basis data lokal. Fitur ini mungkin tidak kompatibel dengan beberapa pengaya autentikasi eksternal.
';
$string['pathtodot'] = 'Letak dot';
$string['pathtodot_help'] = 'Letak dot. Di Linux itu seperti /usr/bin/dot. Pada Windows itu seperti C:\\Program Files(x86)\\Graphviz2.38\\bin\\dot.exe. Di Mac itu seperti /opt/local/bin/dot. Untuk dapat menghasilkan grafik dari berkas DOT, Anda harus menginstal dot yang dapat dieksekusi dan mengarahkannya ke sini.';
$string['pathtodu'] = 'Letak du';
$string['pathtogs'] = 'Letak ghostscript';
$string['pathtogs_help'] = 'Pada kebanyakan instalasi Linux, ini dapat dibiarkan sebagai \'/usr/bin/gs\'. Di Windows akan terlihat seperti \'c:\\gs\\bin\\gswin32c.exe\' (pastikan tidak ada spasi di jalur - jika perlu salin berkas \'gswin32c.exe\' dan \'gsdll32.dll\' ke folder baru tanpa spasi di jalur)';
$string['pathtopdftoppm'] = 'Letak pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/"> Poppler </a> adalah pustaka rendering PDF yang menyertakan alat pdftoppm untuk mengonversi berkas PDF ke PNG. Kinerja umumnya lebih baik daripada saat menggunakan Ghostscript, terutama untuk berkas besar. Jika tersedia, pdftoppm akan digunakan sebagai preferensi dari Ghostscript. Pada sebagian besar penginstalan Linux, jalurnya adalah /usr/bin/pdftoppm. Jika tidak, Anda perlu menginstal paket poppler-utils atau poppler, bergantung pada distribusi Linux Anda. Di Windows, ini disediakan oleh instalasi Cygwin.';
$string['pathtopgdump'] = 'Letak pg_dump';
$string['pathtopgdumpdesc'] = 'Ini hanya perlu dimasukkan jika Anda memiliki lebih dari satu pg_dump di sistem Anda (misalnya jika Anda memiliki lebih dari satu versi postgresql yang diinstal)';
$string['pathtopgdumpinvalid'] = 'Jalur tidak valid ke pg_dump - jalur salah atau tidak dapat dijalankan';
$string['pathtophp'] = 'Letak PHP CLI';
$string['pathtopsql'] = 'Letak psql';
$string['pathtopsqldesc'] = 'Ini hanya perlu untuk masuk jika Anda memiliki lebih dari satu psql di sistem Anda (misalnya jika Anda memiliki lebih dari satu versi postgresql yang diinstal)';
$string['pathtopsqlinvalid'] = 'Jalur tidak valid ke psql - jalur salah atau tidak dapat dieksekusi';
$string['pathtopython'] = 'Letak Python';
$string['pathtopythondesc'] = 'Letak biner Python Anda yang dapat dieksekusi (Python 2 dan Python 3 dapat diterima).';
$string['pathtosassc'] = 'Letak SassC';
$string['pathtosassc_help'] = 'Menentukan lokasi biner SassC akan mengalihkan compiler SASS dari implementasi PHP Moodle ke SassC. Lihat https://github.com/sass/sassc untuk informasi lebih lanjut.';
$string['pcreunicodewarning'] = 'Sangat disarankan untuk menggunakan ekstensi PHP PCRE yang kompatibel dengan karakter Unicode.';
$string['perfdebug'] = 'Info kinerja';
$string['perfdebugdeferred'] = 'Menunggu hingga skrip berakhir untuk menampilkan kinerja proses awakutu ...';
$string['performance'] = 'Kinerja';
$string['pgcluster'] = 'Klaster PostgreSQL';
$string['pgclusterdescription'] = 'Versi / klaster parameter PostgreSQL untuk operasi baris perintah. Jika Anda hanya memiliki satu postgresql di sistem Anda atau Anda tidak yakin apa ini, biarkan kosong.';
$string['phpfloatproblem'] = 'Mendeteksi masalah tak terduga dalam menangani angka float PHP - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Situs Anda terdaftar. Pendaftaran terakhir diperbarui {$a}.<br />Tugas terjadwal \'Pendaftaran situs\' membuat pendaftaran Anda tetap mutakhir. Anda juga dapat memperbarui pendaftaran Anda secara manual kapan saja.';
$string['pleaserefreshregistrationnewdata'] = 'Informasi pendaftaran telah diubah. Harap konfirmasikan menggunakan tombol \'Perbarui pendaftaran\'.';
$string['pleaserefreshregistrationunknown'] = 'Situs Anda telah terdaftar tetapi tanggal pendaftaran tidak diketahui. Harap perbarui pendaftaran Anda menggunakan tombol \'Perbarui pendaftaran\' atau pastikan bahwa tugas terjadwal \'Pendaftaran situs\' diaktifkan sehingga pendaftaran Anda diperbarui secara otomatis.';
$string['plugin'] = 'Pengaya';
$string['plugin_disabled'] = '{$a} telah dinonaktifkan.';
$string['plugin_enabled'] = '{$a} telah diaktifkan.';
$string['plugins'] = 'Pengaya';
$string['pluginscheck'] = 'Pemeriksaan dependensi plugin';
$string['pluginscheckfailed'] = 'Pemeriksaan dependensi gagal untuk {$a->pluginslist}';
$string['pluginschecktodo'] = 'Anda harus menyelesaikan semua persyaratan pengaya sebelum melanjutkan untuk menginstal versi Moodle ini!';
$string['pluginsoverview'] = 'Ikhtisar pengaya';
$string['pluginsoverviewsee'] = 'Lihat halaman <a href="{$a->url}">Ikhtisar pengaya</a> untuk lebih detailnya.';
$string['policysettings'] = 'Setelan kebijakan';
$string['privacy:metadata'] = 'Pengaya Administrasi tidak menyimpan data pribadi apa pun.';
$string['privacyandpolicies'] = 'Privasi dan kebijakan';
$string['privacysettings'] = 'Konfigurasi privasi';
$string['profilecategory'] = 'Kategori';
$string['profilecategoryname'] = 'Nama kategori (harus unik)';
$string['profilecategorynamenotunique'] = 'Nama kategori telah digunakan';
$string['profilecommonsettings'] = 'Setelan umum';
$string['profileconfirmcategorydeletion'] = 'Terdapat {$a} kolom dalam kategori ini yang akan dipindahkan ke kategori di atas (atau di bawah jika ada di kategori teratas). <br /> Masih ingin menghapus kategori ini?';
$string['profileconfirmfielddeletion'] = 'Terdapat {$a} catatan pengguna untuk kolom ini yang akan dihapus. <br /> Masih ingin menghapus kolom ini?';
$string['profilecreatecategory'] = 'Tambahkan kategori baru pada profil';
$string['profilecreatefield'] = 'Tambahkan ruas baru pada profil:';
$string['profilecreatenewcategory'] = 'Membuat kategori baru';
$string['profilecreatenewfield'] = 'Membuat ruas profil \'{$a}\' baru';
$string['profiledefaultcategory'] = 'Ruas lainnya';
$string['profiledefaultchecked'] = 'Cek secara bawaan';
$string['profiledefaultdata'] = 'Nilai bawaan';
$string['profiledeletecategory'] = 'Menghapus kategori';
$string['profiledeletefield'] = 'Menghapus ruas \'{$a}\'';
$string['profiledescription'] = 'Deskripsi ruas';
$string['profiledscript'] = 'Skrip ini telah diprofilkan';
$string['profiledscriptview'] = 'Lihat informasi profil untuk skrip ini';
$string['profileeditcategory'] = 'Mengedit kategori: {$a}';
$string['profileeditfield'] = 'Mengedit ruas profil: {$a}';
$string['profilefield'] = 'Ruas profil';
$string['profilefieldcolumns'] = 'Kolom';
$string['profilefieldispassword'] = 'Apakah ini ruas kata sandi?';
$string['profilefieldlink'] = 'Tautan';
$string['profilefieldlink_help'] = 'Untuk mengubah teks menjadi tautan, masukkan URL yang berisi $$, di mana $$ akan diganti dengan teks. Misalnya, untuk mengubah ID Twitter menjadi tautan, masukkan https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Target tautan';
$string['profilefieldmaxlength'] = 'Limit karakter';
$string['profilefieldmaxlength_help'] = 'Untuk menggunakan ruas ini dalam setelan \'Tampilkan identitas pengguna\', batasnya harus 255 karakter atau kurang.';
$string['profilefieldrows'] = 'Baris';
$string['profilefields'] = 'Ruas profil pengguna';
$string['profilefieldsize'] = 'Ukurang tampilan';
$string['profileforceunique'] = 'Data harus unik?';
$string['profileinvaliddata'] = 'Nilai tidak valid';
$string['profilelocked'] = 'Apakah kolom ini terkunci?';
$string['profilemenudefaultnotinoptions'] = 'Nilai bawaan bukan salah satu opsi';
$string['profilemenunooptions'] = 'Tidak ada opsi menu yang disediakan';
$string['profilemenuoptions'] = 'Opsi menu (satu per baris)';
$string['profilemenutoofewoptions'] = 'Anda harus memberikan setidaknya 2 opsi';
$string['profilename'] = 'Nama';
$string['profilenofieldsdefined'] = 'Belum ada ruas lainnya yang ditambahkan';
$string['profilerequired'] = 'Ruas ini harus diisi?';
$string['profileroles'] = 'Profil peran yang terlihat';
$string['profilesforenrolledusersonly'] = 'Profil hanya untuk pengguna terdaftar';
$string['profileshortname'] = 'Nama singkat (harus unik)';
$string['profileshortnameinvalid'] = 'Nama singkat ini hanya boleh berisi karakter alfanumerik (huruf dan angka) atau garis bawah (_).';
$string['profileshortnamenotunique'] = 'Nama singkat ini sudah digunakan';
$string['profilesignup'] = 'Tampilkan di halaman pendaftaran';
$string['profilespecificsettings'] = 'Setelan spesifik';
$string['profilevisible'] = 'Siapa saja yang dapat melihat kolom ini?';
$string['profilevisible_help'] = '* Tidak terlihat - Untuk data pribadi hanya dapat dilihat oleh administrator
* Dapat dilihat oleh pengguna - Untuk data pribadi hanya dapat dilihat oleh pengguna dan administrator
* Dapat dilihat oleh pengguna, pengajar dan admin - Untuk data pribadi hanya dapat dilihat oleh pengguna, administrator dan pengajar (di profil kursus)
* Dapat dilihat oleh semua orang';
$string['profilevisibleall'] = 'Terlihat ke semua orang';
$string['profilevisiblenone'] = 'Tidak terlihat';
$string['profilevisibleprivate'] = 'Terlihat ke pengguna';
$string['profilevisibleteachers'] = 'Terlihat oleh pengguna, pengajar, dan admin';
$string['profiling'] = 'Pembuatan profil';
$string['profilingallowall'] = 'Pembuatan profil berkelanjutan';
$string['profilingallowall_help'] = 'Jika Anda mengaktifkan setelan ini, maka, setiap saat, Anda dapat menggunakan parameter PROFILEALL di mana saja (PGC) untuk mengaktifkan pembuatan profil untuk semua skrip yang dieksekusi sepanjang masa pakai sesi Moodle. Secara analog, Anda dapat menggunakan parameter PROFILEALLSTOP untuk menghentikannya.';
$string['profilingallowme'] = 'Pembuatan profil selektif';
$string['profilingallowme_help'] = 'Jika Anda mengaktifkan setelan ini, maka, secara selektif, Anda dapat menggunakan parameter PROFILEME di mana saja (PGC) dan pembuatan profil untuk skrip itu akan terjadi. Secara analog, Anda dapat menggunakan parameter DONTPROFILEME untuk mencegah pembuatan profil terjadi';
$string['profilingautofrec'] = 'Pembuatan profil otomatis';
$string['profilingautofrec_help'] = 'Dengan mengonfigurasi setelan ini, beberapa permintaan (secara acak, berdasarkan frekuensi yang ditentukan - 1 dari N) akan dipilih dan secara otomatis diprofilkan, menyimpan hasil untuk analisis lebih lanjut. Perhatikan bahwa cara pembuatan profil ini mengamati setelan sertakan/kecualikan. Setel ke 0 untuk menonaktifkan profil otomatis.';
$string['profilingenabled'] = 'Aktifkan pembuatan profil';
$string['profilingenabled_help'] = 'Jika Anda mengaktifkan setelan ini, maka pembuatan profil akan tersedia di situs ini dan Anda akan dapat menentukan perilakunya dengan mengkonfigurasi opsi berikutnya.';
$string['profilingexcluded'] = 'Kecualikan pembuatan profil';
$string['profilingexcluded_help'] = 'Daftar URL (dipisahkan koma atau baris baru, melompati wwwroot, dapat dipanggil) yang akan dikecualikan agar tidak diprofilkan dari yang ditentukan oleh setelan \'Profil ini\'.';
$string['profilingimportprefix'] = 'Prefiks impor profil';
$string['profilingimportprefix_desc'] = 'Untuk deteksi yang lebih mudah, semua proses pembuatan profil yang diimpor akan diawali dengan nilai yang ditentukan di sini.';
$string['profilingincluded'] = 'Untuk deteksi yang lebih mudah, semua proses pembuatan profil yang diimpor akan diawali dengan nilai yang ditentukan di sini.';
$string['profilingincluded_help'] = 'Daftar URL (dipisahkan koma atau baris baru, abaikan wwwroot, dapat dipanggil) yang akan dibuat profilnya secara otomatis. Contoh: /index.php, /course/view.php. Juga menerima * wildchar di posisi mana pun. Contoh: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Tetap jalankan profil';
$string['profilinglifetime_help'] = 'Tentukan waktu yang Anda inginkan untuk menyimpan informasi tentang pembuatan profil lama. Yang lebih lama akan dipangkas secara berkala. Perhatikan bahwa ini mengecualikan proses pembuatan profil apa pun yang ditandai sebagai \'proses referensi\'.';
$string['profilingslow'] = 'Halaman profil lambat';
$string['profilingslow_help'] = 'Dengan menyetel waktu minimum dalam hitungan detik, semua halaman yang lebih lambat akan diprofilkan. Hanya profil yang lebih lambat dari profil yang ada untuk skrip yang sama yang akan disimpan. Setel ke 0 untuk menonaktifkan. Perhatikan bahwa ini mengamati setelan pengecualian.';
$string['protectusernames'] = 'Lindungi nama pengguna';
$string['proxybypass'] = 'Proksi jalan pintas hos';
$string['proxyfixunsafe'] = 'Perbaiki panggilan yang tanpa proksi';
$string['proxyhost'] = 'Hos proksi';
$string['proxylogunsafe'] = 'Log panggilan tanpa proxy';
$string['proxypassword'] = 'Kata sandi proksi';
$string['proxyport'] = 'Porta proksi';
$string['proxytype'] = 'Jenis proksi';
$string['proxyuser'] = 'Nama pengguna proksi';
$string['purgecaches'] = 'Bersihkan semua singgahan';
$string['purgecachesconfirm'] = 'Moodle dapat menyimpan tema, JavaScript, string bahasa, teks yang difilter, umpan RSS, dan data terhitung lainnya. Membersihkan singgahan akan menghapus data dari server dan memaksa peramban untuk mengambil ulang data, sehingga Anda dapat yakin bahwa Anda melihat nilai terbaru yang dihasilkan oleh kode saat ini. Tidak ada bahaya dalam membersihkan singgahan, tetapi situs Anda mungkin tampak lebih lambat untuk sementara waktu hingga server dan klien menghitung informasi baru dan menyimpannya dalam singgahan.';
$string['purgecachesfinished'] = 'Semua singgahan telah dibersihkan.';
$string['purgecachesnoneselected'] = 'Pilih satu atau lebih singgahan untuk dibersihkan';
$string['purgecachespage'] = 'Bersihkan singgahan';
$string['purgefiltercache'] = 'Filter teks';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'String bahasa';
$string['purgemuc'] = 'Semua singgahan MUC';
$string['purgeothercaches'] = 'Semua berkas dan singgahan lain-lain';
$string['purgeselectedcaches'] = 'Bersihkan singgahan yang dipilih';
$string['purgeselectedcachesfinished'] = 'Singgahan yang dipilih dihapus.';
$string['purgetemplates'] = 'Templat';
$string['purgethemecache'] = 'Tema';
$string['query'] = 'Kueri';
$string['question'] = 'Soal';
$string['questionbehaviours'] = 'Perilaku soal';
$string['questioncwqpfscheck'] = 'Satu atau lebih soal \'acak\' dalam kuis disiapkan untuk memilih soal dari campuran kategori soal bersama dan tidak dibagikan. Ada laporan yang lebih rinci <a href="{$a->reporturl}">di sini</a> dan lihat halaman Dokumen Moodle <a href="{$a->docsurl}">di sini</a>.';
$string['questioncwqpfsok'] = 'Bagus. Tidak ada soal \'acak\' dalam kuis Anda yang disiapkan untuk memilih soal dari campuran kategori soal bersama dan tidak dibagikan.';
$string['questiontype'] = 'Jenis soal';
$string['questiontypes'] = 'Jenis soal';
$string['quizattemptsupgradedmessage'] = 'Di Moodle 2.1, ada peningkatan besar pada pertanyaan. Dimungkinkan untuk menunda bagian dari pemutakhiran basis data untuk dijalankan nanti. Sebelum meningkatkan ke Moodle 2.7, peningkatan ini harus diselesaikan.';
$string['recaptchaprivatekey'] = 'Kunci rahasia ReCAPTCHA';
$string['recaptchapublickey'] = 'Kunci situs ReCHAPTCHA';
$string['referrernone'] = 'Peramban bawaan';
$string['referrerpolicy'] = 'Kebijakan perujuk';
$string['referrerpolicydesc'] = 'Setel tajuk kebijakan perujuk untuk disertakan dengan tanggapan dari situs Anda.';
$string['register'] = 'Daftarkan situs Anda';
$string['registration'] = 'Pendaftaran';
$string['registration_help'] = 'Dengan mendaftar:

* Anda akan menerima peringatan keamanan
* Anda dapat mengaktifkan pemberitahuan push aplikasi seluler dari situs Anda
* Anda berkontribusi pada statistik Moodle kami dari komunitas di seluruh dunia';
$string['registrationwarning'] = 'Situs Anda belum terdaftar.';
$string['registrationwarningcontactadmin'] = 'Situs Anda belum terdaftar. Harap beri tahu administrator Anda.';
$string['releasenoteslink'] = 'Untuk informasi tentang versi Moodle ini, silakan lihat <a target="_blank" href="{$a}">Catatan Rilis</a> daring';
$string['rememberuserlicensepref'] = 'Ingat preferensi lisensi pengguna';
$string['rememberuserlicensepref_help'] = 'Jika diaktifkan, lisensi terakhir yang dipilih oleh pengguna akan dipilih sebelumnya saat mengunggah berkas di pemilih berkas. Jika tidak, lisensi situs bawaan telah dipilih sebelumnya.';
$string['rememberusername'] = 'Ingat nama pengguna';
$string['rememberusername_desc'] = 'Aktifkan jika Anda ingin menyimpan cookie permanen dengan nama pengguna selama login pengguna. Cookie permanen dapat dianggap sebagai masalah privasi jika digunakan tanpa persetujuan.';
$string['replacefrontsearch'] = 'Digunakan untuk pencarian kursus beranda situs';
$string['reportsmanage'] = 'Kelola laporan';
$string['required'] = 'Wajib';
$string['requiredentrieschanged'] = 'Catatan: Setelah memutakhirkan, setelan \'Entri yang diperlukan sebelum melihat\' sekarang diterapkan dalam aktivitas basis data berikut: <br/> {$a->text} <br/>';
$string['requiremodintro'] = 'Memerlukan deskripsi aktivitas';
$string['requiremodintro_desc'] = 'Jika diaktifkan, pengguna akan dipaksa untuk memasukkan deskripsi untuk setiap aktivitas.';
$string['requires'] = 'Wajib';
$string['resetindentation'] = 'Setel ulang indentasi';
$string['resetindentation_help'] = 'Ini akan menghapus indentasi yang sebelumnya ditetapkan untuk kursus dalam {$a->format}.';
$string['resetindentation_title'] = 'Setel ulang indentasi pada halaman kursus?';
$string['resetindentationsuccess'] = 'Setel ulang indentasi';
$string['restorecourse'] = 'Pulihkan kursus';
$string['restorernewroleid'] = 'Peran pemulih dalam kursus';
$string['restorernewroleid_help'] = 'Jika pengguna belum memiliki izin untuk mengelola kursus yang baru dipulihkan, pengguna secara otomatis diberi peran ini dan didaftarkan jika perlu. Pilih "Tidak Ada" jika Anda tidak ingin pemulih dapat mengelola setiap kursus yang dipulihkan.';
$string['resultfilter'] = 'Filter menurut hasil';
$string['reverseproxy'] = 'Proksi terbalik';
$string['reverseproxyignore'] = 'Abaikan proksi terbalik';
$string['riskconfig'] = 'Pengguna dapat mengubah konfigurasi dan perilaku situs';
$string['riskconfigshort'] = 'Risiko konfigurasi';
$string['riskdataloss'] = 'Pengguna dapat menghancurkan sejumlah besar konten atau informasi';
$string['riskdatalossshort'] = 'Risiko kehilangan data';
$string['riskmanagetrust'] = 'Pengguna dapat mengubah setelan kepercayaan pengguna lain';
$string['riskmanagetrustshort'] = 'Kelola kepercayaan';
$string['riskpersonal'] = 'Pengguna dapat memperoleh akses ke informasi pribadi pengguna lain';
$string['riskpersonalshort'] = 'Risiko privasi';
$string['riskspam'] = 'Pengguna dapat mengirim spam ke pengguna situs atau orang lain';
$string['riskspamshort'] = 'Risiko spam';
$string['riskxss'] = 'Pengguna dapat menambahkan file dan teks yang memungkinkan pembuatan skrip lintas situs (XSS)';
$string['riskxssshort'] = 'risiko XSS';
$string['roleswithexceptions'] = '{$a->roles}, dengan {$a->exceptions}';
$string['rssglobaldisabled'] = 'Nonaktifkan pada tingkat situs';
$string['save'] = 'Simpan';
$string['savechanges'] = 'Simpan perubahan';
$string['scssinvalid'] = 'kode SCSS tidak valid, gagal dengan: {$a}';
$string['search'] = 'Pencarian';
$string['searchablecourses'] = 'Kursus yang dapat dicari';
$string['searchallavailablecourses'] = 'Kursus yang dapat dicari';
$string['searchallavailablecourses_desc'] = 'Dalam beberapa situasi, mesin pencari mungkin tidak bekerja saat mencari di banyak kursus. Atur untuk hanya mencari Dalam beberapa situasi, mesin pencari mungkin tidak bekerja saat mencari di banyak kursus. Atur untuk hanya mencari kursus yang terdaftar jika Anda perlu membatasi jumlah kursus yang dicari. yang terdaftar jika Anda perlu membatasi jumlah kursus yang dicari.';
$string['searchallavailablecourses_off'] = 'Cari dalam kursus yang terdaftar saja';
$string['searchallavailablecourses_on'] = 'Cari dalam semua kursus yang dapat diakses pengguna';
$string['searchallavailablecoursesdesc'] = 'Jika disetel untuk mencari dalam kursus yang terdaftar saja, informasi kursus (nama dan ringkasan) dan kursus kursus hanya akan dicari di kursus di mana pengguna terdaftar. Jika tidak, informasi kursus dan konten kursus akan dicari di semua kursus yang dapat diakses pengguna , seperti kursus dengan akses tamu diaktifkan.';
$string['searchalldeleted'] = 'Semua konten yang diindeks telah dihapus';
$string['searchalternatesettings'] = 'Setelan alternatif khusus kueri';
$string['searchalternatesettings_desc'] = 'Jika Anda menyelesaikan setelan ini, Anda dapat memilih \'setelan alternatif\' untuk mesin pencari ini dalam pilihan mesin pencari hanya-kueri pada halaman \'Kelola pencarian global\'. Ini hanya berguna saat berpindah di antara dua mesin pencari dengan jenis yang sama.';
$string['searchareadisabled'] = 'Area pencarian dinonaktifkan';
$string['searchareaenabled'] = 'Area pencarian diaktifkan';
$string['searchareas'] = 'Area pencarian';
$string['searchbanner'] = 'Cari informasi';
$string['searchbannerenable'] = 'Tampilkan informasi pencarian';
$string['searchbannerenable_desc'] = 'Jika diaktifkan, teks di bawah ini akan ditampilkan di bagian atas layar pencarian untuk semua pengguna. Ini dapat digunakan untuk memberi tahu pengguna saat pemeliharaan mesin telusur sedang dilakukan.';
$string['searchdefaultcategory'] = 'Kategori pencarian bawaan';
$string['searchdefaultcategory_desc'] = 'Hasil dari kategori area pencarian yang dipilih akan ditampilkan secara bawaan.';
$string['searchdeleteindex'] = 'Hapus semua konten terindeks';
$string['searchdisplay'] = 'Opsi tampilan hasil pencarian';
$string['searchenablecategories'] = 'Menampilkan hasil dalam kategori terpisah';
$string['searchenablecategories_desc'] = 'Jika diaktifkan, hasil pencarian akan ditampilkan dalam kategori terpisah.';
$string['searchengine'] = 'Mesin pencari';
$string['searchenginealternatesettings'] = '{$a} (setelan alternatif)';
$string['searchenginequeryonly'] = 'Mesin telusur khusus kueri';
$string['searchenginequeryonly_desc'] = 'Mesin pencari ini hanya akan digunakan untuk membuat kueri, bukan mengindeks. Dengan menggunakan fitur ini, Anda dapat mengindeks ulang di mesin telusur yang berbeda, sementara kueri pengguna terus bekerja dari mesin telusur ini.';
$string['searchenginequeryonly_none'] = 'Tidak ada (gunakan mesin telusur utama untuk kueri)';
$string['searchenginequeryonlysame'] = 'Mesin telusur khusus kueri dan mesin telusur utama tidak dapat disetel ke nilai yang sama.';
$string['searchhideallcategory'] = 'Sembunyikan Semua kategori hasil';
$string['searchhideallcategory_desc'] = 'Jika dicentang, kategori dengan semua hasil akan disembunyikan di layar hasil pencarian.';
$string['searchincludeallcourses'] = 'Sertakan semua kursus yang terlihat';
$string['searchincludeallcourses_desc'] = 'Jika diaktifkan, hasil pencarian akan mencakup informasi kursus (nama dan ringkasan) yang dapat dilihat pengguna, meskipun pengguna tersebut tidak memiliki akses terhadap konten kursus.';
$string['searchindexactions'] = 'Aksi indeks';
$string['searchindexdeleted'] = 'Indeks dihapus';
$string['searchindextime'] = 'Batas waktu pengindeksan';
$string['searchindextime_desc'] = 'Saat mengindeks konten baru dalam jumlah besar, tugas terjadwal akan berhenti setelah batas waktu ini tercapai. Ini akan berlanjut saat tugas berjalan berikutnya.';
$string['searchindexupdated'] = 'Konten mesin pencari telah diperbarui';
$string['searchindexwhendisabled'] = 'Indeks saat dinonaktifkan';
$string['searchindexwhendisabled_desc'] = 'Mengizinkan tugas terjadwal untuk membangun indeks pencarian bahkan ketika pencarian dinonaktifkan. Ini berguna jika Anda ingin membangun indeks sebelum fasilitas pencarian muncul kepada siswa.';
$string['searchinsettings'] = 'Cari di setelan';
$string['searchlastrun'] = 'Terakhir dijalankan (waktu, #dokumen, #rekaman, #abaikan)';
$string['searchmanagement'] = 'Manajemen pencarian';
$string['searchmanagement_desc'] = 'Opsi ini berguna saat membuat perubahan pada situs dengan indeks pencarian yang sangat besar yang membutuhkan waktu lama untuk dibangun kembali.';
$string['searchmaxtopresults'] = 'Maximum top results';
$string['searchmaxtopresults_desc'] = 'Jumlah maksimum hasil berperingkat tertinggi yang akan ditampilkan di atas hasil pencarian untuk konten kursus, kursus, dan pengguna.';
$string['searchnotavailable'] = 'Pencarian tidak tersedia';
$string['searchoptions'] = 'Opsi pencarian';
$string['searchpartial'] = '(belum diindeks sepenuhnya)';
$string['searchreindexed'] = 'Semua konten situs telah diindeks ulang.';
$string['searchreindexindex'] = 'Indeks ulang semua konten situs';
$string['searchresults'] = 'Hasil pencarian';
$string['searchsetupinfo'] = 'Setelan pencarian';
$string['searchteacherroles'] = 'Peran pengajar';
$string['searchteacherroles_desc'] = 'Pilih semua peran yang membuat pengguna dengan peringkat peran lebih tinggi di hasil pencarian.';
$string['searchtopresults'] = 'Hasil teratas';
$string['searchupdateindex'] = 'Perbarui konten yang diindeks';
$string['sectionerror'] = 'Kesalahan bagian!';
$string['secureforms'] = 'Gunakan keamanan formulir tambahan';
$string['security'] = 'Keamanan';
$string['selectdevice'] = 'Pilih perangkat';
$string['selectsearchengine'] = 'Pilih mesin pencari';
$string['selecttheme'] = 'Pilih tema untuk perangkat {$a}';
$string['server'] = 'Server';
$string['serverchecks'] = 'Cek server';
$string['serverlimit'] = 'Limit server';
$string['servicespage'] = 'Layanan dan dukungan';
$string['sessionautostartwarning'] = '<p> Kesalahan konfigurasi yang serius terdeteksi, harap beri tahu administrator server. </p> <p> Untuk beroperasi dengan benar, Moodle mengharuskan administrator mengubah setelan PHP. </p> <p> <code> session.auto_start </code> harus disetel ke <code>off</code>.</i> <p> Setelan ini dikontrol dengan mengedit <code> php.ini </code>, Apache / IIS <br /> konfigurasi atau berkas <code> .htaccess </code> di server. </p>';
$string['sessioncookie'] = 'Suffix kuki';
$string['sessioncookiedomain'] = 'Domain kuki';
$string['sessioncookiepath'] = 'Jalur kuki';
$string['sessionhandling'] = 'Penanganan sesi';
$string['sessiontimeout'] = 'Waktu habis';
$string['sessiontimeoutwarning'] = 'Peringatan Waktu habis';
$string['settingdependenton'] = 'Setelan ini mungkin disembunyikan, berdasarkan nilai <strong> {$a} </strong>.';
$string['settingfileuploads'] = 'Pengunggahan berkas diperlukan untuk operasi normal, harap aktifkan dalam konfigurasi PHP.';
$string['settingmaxinputvars'] = 'Setelan PHP max_input_vars disarankan minimal 5000.';
$string['settingmaxinputvarsrequired'] = 'Setelan PHP max_input_vars harus minimal 5000.';
$string['settingmemorylimit'] = 'Memori tidak cukup terdeteksi, harap setel batas memori yang lebih tinggi dalam setelan PHP.';
$string['settingsafemode'] = 'Moodle tidak sepenuhnya kompatibel dengan mode aman, harap minta administrator server untuk mematikannya. Menjalankan Moodle dalam mode aman tidak didukung, akan terjadi berbagai masalah jika Anda melakukannya.';
$string['settingzendexceptionignoreargs'] = 'Sangat disarankan agar pengaturan PHP zend.exception_ignore_args diaktifkan sebagai tindakan pencegahan keamanan.';
$string['setupsearchengine'] = 'Siapkan mesin perncari';
$string['showcommentscount'] = 'Tampilkan jumlah komentar';
$string['showdetails'] = 'Tampilkan detail';
$string['showuseridentity'] = 'Tampilkan identitas pengguna';
$string['showuseridentity_desc'] = 'Saat memilih atau mencari pengguna, dan saat menampilkan daftar pengguna, kolom-kolom ini dapat ditampilkan sebagai tambahan nama lengkap mereka. Kolom-kolom ini hanya ditampilkan kepada pengguna yang memiliki kapabilitas moodle/site:viewuseridentity; secara bawaan, pengajar dan manajer. (Pilihan ini paling masuk akal jika Anda memilih satu atau dua kolom yang wajib diisi di institusi Anda.)

Kolom yang ditandai * adalah kolom profil pengguna khusus. Anda dapat memilih kolom ini, tetapi saat ini ada beberapa layar yang tidak akan menampilkan kolom-kolom ini.';
$string['simplexmlrequired'] = 'Ekstensi PHP SimpleXML sekarang dibutuhkan oleh Moodle.';
$string['sitemailcharset'] = 'Set karakter';
$string['sitemaintenance'] = 'Situs ini sedang dalam pemeliharaan dan saat ini tidak dapat diakses';
$string['sitemaintenancemode'] = 'Mode pemeliharaan';
$string['sitemaintenanceoff'] = 'Mode pemeliharaan telah dinonaktifkan dan situs berjalan normal kembali';
$string['sitemaintenanceon'] = 'Situs Anda saat ini dalam mode pemeliharaan (hanya admin yang dapat masuk atau menggunakan situs).';
$string['sitemaintenanceoncli'] = 'Situs Anda saat ini dalam mode pemeliharaan CLI, tidak ada akses web yang diizinkan.';
$string['sitemaintenancetitle'] = '{$a} dalam pemeliharaan';
$string['sitemaintenancewarning'] = 'Situs Anda sedang dalam mode pemeliharaan (hanya admin yang dapat masuk). Untuk mengembalikan situs ini ke operasi normal, <a href="maintenance.php"> nonaktifkan mode pemeliharaan </a>.';
$string['sitemaintenancewarning2'] = 'Situs Anda sedang dalam mode pemeliharaan (hanya admin yang dapat masuk). Untuk mengembalikan situs ini ke operasi normal, <a href="{$a}"> nonaktifkan mode pemeliharaan </a>.';
$string['sitemenubar'] = 'Navigasi situs';
$string['sitenameintitle'] = 'Cantumkan nama situs di judul halaman';
$string['sitenameintitle_help'] = 'Setelan ini akan menambahkan nama situs di akhir judul halaman. Disarankan untuk menyertakan nama situs dalam judul halaman karena akan meningkatkan aksesibilitas situs dengan memungkinkan pengguna dengan cepat mengidentifikasi halaman yang sedang mereka kunjungi.';
$string['sitepolicies'] = 'Setelan keamanan situs';
$string['sitepolicy'] = 'URL kebijakan situs';
$string['sitepolicy_help'] = 'URL kebijakan situs yang harus dilihat dan disetujui oleh semua pengguna terdaftar sebelum mengakses situs. Perhatikan bahwa setelan ini hanya akan berpengaruh jika penangan kebijakan situs diatur ke bawaan (inti).';
$string['sitepolicyguest'] = 'URL kebijakan situs untuk pengguna tamu';
$string['sitepolicyguest_help'] = 'URL kebijakan situs yang harus dilihat dan disetujui oleh semua tamu sebelum mengakses situs. Perhatikan bahwa setelan ini hanya akan berpengaruh jika penangan kebijakan situs diatur ke bawaan (inti).';
$string['sitepolicyhandler'] = 'Penangan kebijakan situs';
$string['sitepolicyhandler_desc'] = 'Ini menentukan bagaimana kebijakan dan persetujuan pengguna dikelola. Penangan (inti) bawaan memungkinkan URL kebijakan situs dan URL kebijakan situs untuk tamu ditentukan. Penangan kebijakan memungkinkan situs, privasi, dan kebijakan lain ditetapkan. Ini juga memungkinkan persetujuan pengguna untuk dilihat dan, jika perlu, persetujuan atas nama anak di bawah umur untuk diberikan.';
$string['sitepolicyhandlercore'] = 'Bawaan (inti)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Tampilkan bagian di bagian atas halaman tempat Anda dapat menambahkan konten kustom.
Jika dipilih, bagian topik akan ditampilkan pada beranda situs.';
$string['sixtyfourbitsrequired'] = 'Telah terdeteksi bahwa situs Anda tidak menggunakan versi PHP 64-bit. Anda diminta untuk memutakhirkan sistem Anda (sistem operasi, PHP...) sebelum menginstal versi Moodle ini.';
$string['sixtyfourbitswarning'] = 'Telah terdeteksi bahwa situs Anda tidak menggunakan versi PHP 64-bit. Disarankan agar Anda meningkatkan situs Anda untuk memastikan kompatibilitas di masa mendatang.';
$string['slasharguments'] = 'Gunakan argumen garis miring';
$string['slashargumentswarning'] = 'Disarankan agar penggunaan argumen garis miring diaktifkan. Di masa depan itu akan diperlukan. Untuk detail selengkapnya, lihat dokumentasi <a href="https://docs.moodle.org/en/admin/environment/slasharguments"> Menggunakan argumen garis miring </a>.';
$string['smallscreensonly'] = 'Layar kecil saja';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Jenis Otentikasi SMTP';
$string['smtpdetail'] = 'Setelan Simple Mail Transfer Protocol (SMTP) untuk mengirim surel.';
$string['smtphosts'] = 'Hos SMTP';
$string['smtpmaxbulk'] = 'Batas sesi SMTP';
$string['smtppass'] = 'Kata sandi SMTP';
$string['smtpsecure'] = 'Keamanan SMTP';
$string['smtpuser'] = 'Nama pengguna SMTP';
$string['soaprecommended'] = 'Menginstal ekstensi SOAP opsional berguna untuk layanan web dan beberapa pengaya.';
$string['sort_fullname'] = 'Nama lengkap kursus';
$string['sort_idnumber'] = 'Nomor ID kursus';
$string['sort_shortname'] = 'Nama singkat kursus';
$string['sort_sortorder'] = 'Urutkan';
$string['spellengine'] = 'Mesin pengeja';
$string['spelllanguagelist'] = 'Daftar bahasa ejaan';
$string['splrequired'] = 'Ekstensi SPL PHP sekarang dibutuhkan oleh Moodle.';
$string['stats'] = 'Statistik';
$string['statsfirstrun'] = 'Interval pemrosesan maksimum';
$string['statsmaxruntime'] = 'Waktu kerja maksimum';
$string['statsmoodleorg'] = 'statistik';
$string['statsruntimedays'] = 'Jumlah hari pemrosesan';
$string['statsruntimestart'] = 'Berjalan pada';
$string['statsuserthreshold'] = 'Ambang pengguna';
$string['stickyblocks'] = 'Blok menempel';
$string['stickyblockscourseview'] = 'Halaman kursus';
$string['stickyblocksduplicatenotice'] = 'Jika ada blok yang Anda tambahkan di sini sudah ada di halaman tertentu, itu akan menghasilkan duplikat.<br />Hanya blok yang disematkan yang tidak dapat diedit, duplikatnya masih dapat diedit.';
$string['stickyblocksmymoodle'] = 'Moodle saya';
$string['stickyblockspagetype'] = 'Jenis halaman untuk dikonfigurasi';
$string['strictformsrequired'] = 'Validasi ketat pada kolom yang diperlukan';
$string['stripalltitletags'] = 'Hapus tag HTML dari semua nama aktivitas';
$string['supportandservices'] = 'Dukungan dan layanan';
$string['supportavailability'] = 'Ketersediaan dukungan';
$string['supportcontact'] = 'Dukungan kontak';
$string['supportemail'] = 'Surel dukungan';
$string['supportemailsubject'] = 'Permintaan dukungan situs - {$a}';
$string['supportname'] = 'Nama dukungan';
$string['supportpage'] = 'Hubungi tautan dukungan situs';
$string['suspenduser'] = 'Tangguhkan akun pengguna';
$string['switchlang'] = 'Beralih direktori bahasa';
$string['systempaths'] = 'Letak sistem';
$string['tablenosave'] = 'Perubahan pada tabel di atas disimpan secara otomatis.';
$string['tablesnosave'] = 'Perubahan tabel di atas disimpan secara otomatis.';
$string['tabselectedtofront'] = 'Pada tabel dengan tab, sebaiknya baris dengan tab yang sedang dipilih ditempatkan di depan';
$string['tabselectedtofronttext'] = 'Bawa baris tab yang dipilih ke depan';
$string['task_adhoc_concurrency_limit'] = 'Batas konkurensi tugas ad hoc';
$string['task_adhoc_concurrency_limit_desc'] = 'Jumlah pelari tugas ad hoc yang diizinkan untuk berjalan secara bersamaan. Jika batasnya tinggi maka tugas terjadwal mungkin tidak berjalan secara teratur ketika ada banyak tugas ad hoc. Setelan 0 akan menonaktifkan pemrosesan tugas ad hoc sepenuhnya.';
$string['task_adhoc_failed_retention'] = 'Periode retensi tugas ad hoc gagal';
$string['task_adhoc_failed_retention_desc'] = 'Periode maksimum tugas ad hoc yang gagal harus tetap berada dalam antrean setelah mencapai batas percobaan ulang.';
$string['task_adhoc_max_runtime'] = 'Waktu hidup proses tugas ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'Usia pelari tugas ad hoc sebelum dibebaskan. Durasi yang rendah direkomendasikan karena tidak ada batasan jumlah tugas ad hoc yang antri. Jika angka ini terlalu tinggi dan Anda memiliki antrian tugas ad hoc yang besar, maka tugas yang dijadwalkan mungkin tidak dijalankan secara teratur.';
$string['task_dbreads'] = 'Basis data dibaca';
$string['task_dbstats'] = 'Basis data';
$string['task_dbwrites'] = 'Basis data ditulis';
$string['task_duration'] = 'Durasi';
$string['task_endtime'] = 'Waktu berakhir';
$string['task_logmode'] = 'Kapan untuk log';
$string['task_logmode_all'] = 'Simpan keluaran log dari semua pekerjaan';
$string['task_logmode_desc'] = 'Anda dapat memilih kapan Anda ingin melakukan pencatatan tugas. Secara bawaan, log selalu ditangkap. Anda dapat menonaktifkan pencatatan seluruhnya, atau mengubah ke hanya tugas pencatatan yang gagal.';
$string['task_logmode_failonly'] = 'Hanya simpan log untuk pekerjaan yang gagal';
$string['task_logmode_none'] = 'Jangan catat apa pun';
$string['task_logoutput'] = 'Keluaran tugas';
$string['task_logretainruns'] = 'Pertahankan proses';
$string['task_logretainruns_desc'] = 'Jumlah proses setiap tugas yang akan dipertahankan. Setelan ini berinteraksi dengan setelan \'Periode retensi\': mana saja yang dicapai lebih dulu akan diterapkan.';
$string['task_logretention'] = 'Periode retensi';
$string['task_logretention_desc'] = 'Jangka waktu maksimum log harus disimpan. Setelan ini berinteraksi dengan setelan \'Pertahankan proses\': mana saja yang dicapai lebih dulu akan diterapkan';
$string['task_logtostdout'] = 'Tampilkan keluaran log';
$string['task_logtostdout_desc'] = 'Saat pekerjaan sedang berjalan dan keluaran ditangkap, apakah keluaran yang diambil juga harus ditampilkan saat tugas berjalan.';
$string['task_result'] = 'Hasil';
$string['task_result:failed'] = 'Gagal';
$string['task_scheduled_concurrency_limit'] = 'Batas konkurensi tugas terjadwal';
$string['task_scheduled_concurrency_limit_desc'] = 'Jumlah proses tugas terjadwal yang diizinkan untuk berjalan secara bersamaan. Jika batasnya tinggi maka server mungkin mengalami beban tinggi yang memengaruhi kinerja. Setelan 0 akan menonaktifkan pemrosesan tugas terjadwal sepenuhnya.';
$string['task_scheduled_max_runtime'] = 'Usia proses tugas terjadwal';
$string['task_scheduled_max_runtime_desc'] = 'Usia proses tugas terjadwal sebelum dibebaskan.';
$string['task_starttime'] = 'Waktu mulai';
$string['task_stats:dbreads'] = 'Baca {$a}';
$string['task_stats:dbwrites'] = 'Tulis {$a}';
$string['task_status'] = 'Status tugas';
$string['task_status_desc'] = 'Tugas \'{$a->name}\' adalah {$a->status}. Untuk detailnya, lihat {$a->class}{$a->extradescription} di <a href="{$a->gotourl}">Tugas terjadwal</a>.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Terjadwal';
$string['taskadmintitle'] = 'Tugas';
$string['taskanalyticscleanup'] = 'Pembersihan analitik';
$string['taskautomatedbackup'] = 'Pencadangan Otomatis';
$string['taskautomatedbackup_report'] = 'Laporan pencadangan otomatis';
$string['taskbackupcleanup'] = 'Bersihkan tabel cadangan, log, dan berkas';
$string['taskbadgesadhoc'] = 'Lencana penghargaan';
$string['taskbadgescron'] = 'Tambahkan tugas ad hoc lencana penghargaan';
$string['taskbadgesmessagecron'] = 'Pemrosesan latar belakang untuk mengirim pemberitahuan lencana';
$string['taskblogcron'] = 'Sinkron blog eksternal';
$string['taskcachecleanup'] = 'Hapus entri singgahan yang kedaluwarsa';
$string['taskcachecron'] = 'Pemrosesan latar belakang untuk singgahan';
$string['taskcalendarcron'] = 'Kirim notifikasi kalender';
$string['taskcheckforupdates'] = 'Cek pembaruan';
$string['taskcompletiondaily'] = 'Penyelesaian ditandai dimulai';
$string['taskcompletionregular'] = 'Hitung data penyelesaian rutin';
$string['taskcontextcleanup'] = 'Bersikhkan konteks';
$string['taskcreatecontexts'] = 'Buat konteks yang hilang';
$string['taskdeletecachetext'] = 'Hapus rekaman singgahan teks lama';
$string['taskdeleteincompleteusers'] = 'Hapus pengguna tidak lengkap';
$string['taskdeleteunconfirmedusers'] = 'Hapus pengguna tidak terkonfirmasi';
$string['taskeventscron'] = 'Pemrosesan latar belakang untuk acara';
$string['taskfiletrashcleanup'] = 'Bersihkan berkas di tempat sampah';
$string['taskglobalsearchindex'] = 'Pengindeksan pencarian global';
$string['taskglobalsearchoptimize'] = 'Optimasi indeks pencarian global';
$string['taskgradecron'] = 'Pemrosesan latar belakang untuk buku nilai';
$string['taskgradehistorycleanup'] = 'Pemrosesan latar belakang untuk membersihkan tabel riwayat penilaian';
$string['taskh5pcleanup'] = 'Pembersihan berkas H5P yang tidak digunakan';
$string['tasklegacycron'] = 'Pemrosesan cron lama untuk pengaya';
$string['tasklockcleanuptask'] = 'Bersihkan metadata tugas ad hoc';
$string['tasklogcleanup'] = 'Pembersihan log tugas';
$string['tasklogging'] = 'Konfigurasi log tugas';
$string['tasklogs'] = 'Log tugas';
$string['taskmessagingcleanup'] = 'Pemrosesan latar belakang untuk olah pesan';
$string['taskpasswordresetcleanup'] = 'Bersihkan upaya penyetelan ulang kata sandi';
$string['taskplagiarismcron'] = 'Pemrosesan latar belakang untuk cron lama dalam pengaya plagiarisme';
$string['taskportfoliocron'] = 'Pemrosesan latar belakang untuk pengaya portofolio';
$string['taskprocessing'] = 'Pemrosesan tugas';
$string['taskquestioncron'] = 'Pemrosesan latar belakang untuk membersihkan pratinjau pertanyaan';
$string['taskquestionstatscleanupcron'] = 'Pemrosesan latar belakang untuk membersihkan singgahan statistik pertanyaan';
$string['taskrefreshsystemtokens'] = 'Segarkan token OAuth untuk akun layanan';
$string['taskregistrationcron'] = 'Pendaftaran situs';
$string['tasksendfailedloginnotifications'] = 'Kirim pemberitahuan log masuk yang gagal';
$string['tasksendnewuserpasswords'] = 'Kirim kata sandi baru';
$string['tasksessioncleanup'] = 'Bersihkan sesi lama';
$string['taskstatscron'] = 'Pemrosesan latar belakang untuk statistik';
$string['tasktagcron'] = 'Pemrosesan latar belakang untuk tagar';
$string['tasktempfilecleanup'] = 'Hapus berkas sementara yang basi';
$string['tasktype'] = 'Jenis';
$string['tempdatafoldercleanup'] = 'Bersihkan berkas data sementara yang lebih lama dari';
$string['templates'] = 'Templat';
$string['testoutgoingmailconf'] = 'Uji konfigurasi surel keluar';
$string['testoutgoingmailconf_errorcommunications'] = 'Situs Anda tidak dapat berkomunikasi dengan server surel Anda. Harap periksa konfigurasi surel keluar Anda.';
$string['testoutgoingmailconf_fromemail'] = 'Dari nama pengguna atau alamat surel';
$string['testoutgoingmailconf_fromemail_help'] = 'Ruas ini mengemulasi pengiriman pesan dari pengguna tersebut, tetapi tajuk Dari yang digunakan dalam surel asli yang dikirim akan bergantung pada setelan lain seperti domain surel yang diizinkan';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Tidak Valid Dari nama pengguna atau surel. Harus berupa format surel yang valid atau nama pengguna yang ada di Moodle.';
$string['testoutgoingmailconf_message'] = 'Ini adalah pesan percobaan untuk mengonfirmasi bahwa Anda telah berhasil mengonfigurasi surel keluar situs Anda. Terkirim: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Kirim pesan percobaan';
$string['testoutgoingmailconf_sentmail'] = 'Situs ini telah berhasil mengirim pesan percobaan ke server surel.<br />Dari: {$a->fromemail}<br />Ke: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: pesan uji. {$a->additional} Dikirim: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Subjek tambahan';
$string['testoutgoingmailconf_toemail'] = 'Ke alamat surel';
$string['testoutgoingmaildetail'] = 'Catatan: Sebelum melakukan pengujian, harap simpan konfigurasi Anda. <br /> {$a}';
$string['testsiteupgradewarning'] = 'Anda saat ini menggunakan situs pengujian {$a}, untuk meningkatkannya dengan benar, gunakan alat antarmuka baris perintah';
$string['themedefinedinconfigphp'] = 'Tema tidak dapat diubah karena disetel ke {$a} di config.php.';
$string['themedesignermode'] = 'Mode desainer tema';
$string['themedesignermodewarning'] = 'Mode desainer tema diaktifkan. Ini tidak boleh diaktifkan di situs produksi karena dapat mengurangi kinerja secara signifikan.';
$string['themeeditsettingsname'] = 'Edit setelan tema \'{$a}\'';
$string['themelist'] = 'Daftar tema';
$string['themenoselected'] = 'Tidak ada tema dipilih';
$string['themeresetcaches'] = 'Bersihkan singgahan tema';
$string['themeselect'] = 'Ganti tema';
$string['themeselector'] = 'Tema';
$string['themesettings'] = 'Setelan tema';
$string['themesettingsadvanced'] = 'Setelan tema lanjutan';
$string['themesettingscustom'] = 'Setelan tema kustom';
$string['themesettingsname'] = 'Setelan tema \'{$a}\'';
$string['themeusagereportname'] = 'Laporan penggunaan tema \'{$a}\'';
$string['therewereerrors'] = 'Ada kesalahan dalam data Anda';
$string['thirdpartylibrary'] = 'Pustaka';
$string['thirdpartylibrarylocation'] = 'Lokasi';
$string['thirdpartylibs'] = 'Pustaka pihak ketiga';
$string['timezone'] = 'Zona waktu bawaan';
$string['timezoneforced'] = 'Ini dipaksakan oleh administrator situs';
$string['timezoneinvalid'] = 'Galat zona waktu "{$a}"';
$string['timezoneisforcedto'] = 'Paksa semua pengguna untuk menggunakannya';
$string['timezonenotforced'] = 'Pengguna dapat memilih zona waktunya sendiri';
$string['timezonephpdefault'] = 'Zona waktu PHP bawaan ({$a})';
$string['timezoneserver'] = 'Zona waktu server ({$a})';
$string['tlswarning'] = 'Tidak ada ekstensi PHP/cURL dengan dukungan TLSv1.2 yang terdeteksi. Beberapa layanan mungkin tidak berfungsi. Sangat disarankan untuk meningkatkan pustaka TLS Anda.';
$string['tokenduration'] = 'Durasi token yang dibuat pengguna';
$string['tokenduration_desc'] = 'Lamanya waktu yang digunakan oleh token layanan web oleh pengguna (misalnya melalui aplikasi seluler).';
$string['tokenizerrecommended'] = 'Disarankan untuk menginstal ekstensi Tokenizer PHP opsional - ini meningkatkan fungsionalitas Jaringan Moodle.';
$string['tools'] = 'Perkakas Admin';
$string['toolsmanage'] = 'Atur perkakas admin';
$string['unattendedoperation'] = 'Operasi tanpa pengawasan';
$string['unbookmarkthispage'] = 'Hapus markah halaman ini';
$string['unicoderequired'] = 'Semua data harus disimpan dalam format Unicode (UTF-8). Untuk instalasi baru, basis data harus memiliki UTF-8 sebagai set karakter default. Jika Anda melakukan pemutakhiran, Anda perlu mengikuti proses migrasi UTF-8.';
$string['uninstallplugin'] = 'Bongkar';
$string['unlockaccount'] = 'Lepaskan kunci akun';
$string['unoconvwarning'] = 'Versi unoconv yang telah Anda instal tidak didukung.';
$string['unsettheme'] = 'Tema tidak disetel';
$string['unsupported'] = 'Tidak didukung';
$string['unsupporteddbfileformat'] = 'Basis data Anda menggunakan Antelope sebagai format berkas. Dukungan penuh UTF-8 di MySQL dan MariaDB memerlukan format berkas Barracuda. Silakan beralih ke format berkas Barracuda. Lihat dokumentasi <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support"> Dukungan unicode lengkap MySQL </a> untuk detailnya.';
$string['unsupporteddbfilepertable'] = 'Untuk dukungan penuh UTF-8 baik MySQL dan MariaDB mengharuskan Anda untuk mengubah setelan MySQL Anda \'innodb_file_per_table\' menjadi \'ON\'. Lihat dokumentasi untuk detail lebih lanjut.';
$string['unsupporteddblargeprefix'] = 'Untuk dukungan penuh UTF-8 baik MySQL dan MariaDB mengharuskan Anda untuk mengubah setelan MySQL Anda \'innodb_large_prefix\' menjadi \'ON\'. Lihat dokumentasi untuk detail lebih lanjut.';
$string['unsupporteddbstorageengine'] = 'Mesin penyimpanan basis data yang digunakan tidak lagi didukung.';
$string['unsupporteddbtablerowformat'] = 'Basis data Anda memiliki tabel yang menggunakan Antelope sebagai format berkas. Anda disarankan untuk mengonversi tabel ke dalam format file Barracuda. Lihat dokumentasi <a href="https://docs.moodle.org/en/cli"> Administrasi melalui baris perintah </a> untuk detail alat untuk mengonversi tabel InnoDB ke Barracuda.';
$string['unsupportedphpversion7'] = 'PHP versi 7 dan lebih tinggi tidak didukung.';
$string['unsupportedphpversion71'] = 'PHP versi 7.1 tidak didukung.';
$string['unsupportedphpversion72'] = 'PHP versi 7.2 tidak didukung.';
$string['unsupportedphpversion73'] = 'PHP versi 7.3 tidak didukung.';
$string['unsupportedphpversion74'] = 'PHP versi 7.4 tidak didukung.';
$string['unsupportedphpversion80'] = 'PHP versi 8.0 tidak didukung.';
$string['unsupportedphpversion81'] = 'PHP versi 8.1 dan lebih tinggi tidak didukung.';
$string['unsupportedphpversion82'] = 'PHP versi 8.2 dan lebih tinggi belum didukung.';
$string['unsupportedphpversion83'] = 'PHP versi 8.3 dan lebih tinggi tidak didukung.';
$string['unsupportedphpversion84'] = 'PHP versi 8.4 dan yang lebih tinggi tidak didukung.';
$string['unsuspenduser'] = 'Aktivasi akun pengguna';
$string['updateaccounts'] = 'Perbarui akun yang ada';
$string['updateautocheck'] = 'Cek otomatis untuk pembaruan yang tersedia';
$string['updateautocheck_desc'] = 'Jika diaktifkan, situs Anda akan secara otomatis memeriksa pembaruan yang tersedia untuk kode Moodle dan semua pengaya tambahan. Jika ada pembaruan baru yang tersedia, pemberitahuan akan dikirim ke admin situs.';
$string['updateavailable'] = 'Moodle versi terbaru telah tersedia!';
$string['updateavailable_moreinfo'] = 'Info lebih lanjut...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Versi {$a}';
$string['updateavailabledetailslink'] = 'Lihat {$a->url} untuk lebih detail';
$string['updateavailableforplugin'] = 'Tersedia beberapa pembaruan pengaya!';
$string['updateavailableinstall'] = 'Pasang pembaruan ini';
$string['updateavailableinstallall'] = 'Pasang pembaruan tersedia ({$a})';
$string['updateavailableinstallallhead'] = 'Menginstal pembaruan yang tersedia';
$string['updateavailablenot'] = 'Versi Moodle anda terkini!';
$string['updateavailablerecommendation'] = 'Sangat disarankan agar Anda memperbarui situs Anda ke versi terbaru untuk mendapatkan semua perbaikan kutu dan keamanan terkini.';
$string['updatecomponent'] = 'Perbarui komponen';
$string['updateminmaturity'] = 'Kematangan kode yang diperlukan';
$string['updateminmaturity_desc'] = 'Beri tahu tentang pembaruan yang tersedia hanya jika kode yang tersedia setidaknya memiliki tingkat kematangan yang dipilih. Pembaruan untuk pengaya yang tidak mendeklarasikan tingkat kematangan kodenya selalu dilaporkan terlepas dari setelan ini.';
$string['updatenotificationfooter'] = 'Situs Moodle {$a->siteurl} Anda dikonfigurasi untuk secara otomatis memeriksa pembaruan yang tersedia. Anda menerima pesan ini sebagai administrator situs. Anda dapat menonaktifkan pemeriksaan otomatis untuk pembaruan yang tersedia di <strong> "Administrasi Situs/Server/Pemberitahuan Pembaharuan"</strong> atau menyesuaikan pengiriman pesan ini melalui halaman preferensi Anda.';
$string['updatenotifications'] = 'Notifikasi Pembaruan';
$string['updatenotificationsubject'] = 'Pembaruan Moodle tersedia di ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Beritahukan pengembangan yang baru';
$string['updatenotifybuilds_desc'] = 'Jika diaktifkan, pembaruan yang tersedia untuk kode Moodle juga dilaporkan ketika pengembangan baru untuk versi saat ini tersedia. Pengembangan adalah peningkatan berkelanjutan dari versi Moodle yang diberikan. Mereka umumnya dirilis setiap minggu. Jika dinonaktifkan, pembaruan yang tersedia hanya akan dilaporkan ketika ada versi Moodle yang lebih tinggi yang dirilis. Pemeriksaan pengaya tidak terpengaruh oleh setelan ini.';
$string['upgradeerror'] = 'Galat yang tidak diketahui saat meningkatkan {$a->plugin} ke versi {$a->version}. Tidak bisa melanjutkan.';
$string['upgradeforumread'] = 'Sebuah fitur baru telah ditambahkan di Moodle 1.5 untuk melacak kiriman forum yang telah dibaca/belum dibaca. <br /> Untuk menggunakan fungsi ini, Anda perlu <a href="{$a}"> memperbarui tabel Anda </a>.';
$string['upgradeforumreadinfo'] = 'Sebuah fitur baru telah ditambahkan di Moodle 1.5 untuk melacak kiriman forum yang telah dibaca/belum dibaca. Untuk menggunakan fungsi ini, Anda perlu memperbarui tabel Anda dengan semua informasi pelacakan untuk kiriman yang ada. Bergantung pada ukuran situs Anda, ini bisa memakan waktu lama (jam) dan bisa sangat membebani basis data, jadi yang terbaik adalah melakukannya selama periode tenang. Namun, situs Anda akan terus berfungsi selama peningkatan ini dan pengguna tidak akan terpengaruh. Setelah Anda memulai proses ini, Anda harus membiarkannya selesai (biarkan jendela peramban Anda terbuka). Namun, jika Anda menghentikan proses dengan menutup jendela: jangan khawatir, Anda dapat memulai kembali. <br /> <br /> Apakah Anda ingin memulai proses peningkatan sekarang?';
$string['upgradekeyreq'] = 'Kunci peningkatan dibutuhkan';
$string['upgradekeyset'] = 'Kunci peningkatan (biarkan kosong untuk tidak mengaturnya)';
$string['upgradelogs'] = 'Untuk fungsionalitas penuh, log lama Anda perlu ditingkatkan. <a href="{$a}"> Informasi lebih lanjut </a>';
$string['upgradelogsinfo'] = 'Beberapa perubahan baru-baru ini dilakukan pada cara penyimpanan log. Untuk dapat melihat semua log lama Anda per aktivitas, log lama Anda perlu ditingkatkan. Bergantung pada situs Anda, ini bisa memakan waktu lama (misalnya beberapa jam) dan bisa sangat membebani basis data untuk situs besar. Setelah Anda memulai proses ini, Anda harus membiarkannya selesai (dengan tetap membuka jendela peramban). Jangan khawatir - situs Anda akan berfungsi dengan baik untuk orang lain saat log ditingkatkan. <br /> <br /> Apakah Anda ingin meningkatkan log Anda sekarang?';
$string['upgradepluginsfirst'] = 'Disarankan untuk memasang seluruh pembaruan yang tersedia terlebih dahulu.';
$string['upgradepluginsinfo'] = 'Memperbarui pengaya';
$string['upgradepluginsinfo_help'] = 'Ada pembaruan yang tersedia untuk beberapa pengaya Anda. Anda harus menginstal semuanya sebelum meningkatkan basis data Moodle. Jika situs Anda tidak mendukung penyebaran pembaruan otomatis, Anda harus mengunduh dan menginstal versi server baru di server Anda secara manual.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Setelan baru';
$string['upgradesettingsintro'] = 'Setelan yang ditunjukkan di bawah ditambahkan selama peningkatan Moodle terakhir Anda. Lakukan perubahan yang diperlukan pada setelan bawaan dan kemudian klik tombol \'Simpan perubahan\' di bagian bawah halaman ini.';
$string['upgradestalefiles'] = 'Terdeteksi versi Moodle tercampur, peningkatan tidak dapat dilanjutkan';
$string['upgradestalefilesinfo'] = 'Proses pembaruan Moodle telah dihentikan sementara karena skrip PHP dari setidaknya dua versi utama Moodle telah terdeteksi di direktori Moodle.

Ini dapat menyebabkan masalah yang signifikan nantinya, jadi untuk melanjutkan Anda harus memastikan bahwa direktori Moodle hanya berisi berkas untuk satu versi Moodle.

Cara yang disarankan untuk membersihkan direktori Moodle Anda adalah sebagai berikut:

* ganti nama direktori Moodle saat ini menjadi "moodle_old"
* buat direktori Moodle baru yang hanya berisi berkas baik dari unduhan paket Moodle standar, atau dari repositori Moodle Git
* pindahkan file config.php asli dan semua pengaya non-standar dari direktori "moodle_old" ke direktori Moodle yang baru

Saat Anda memiliki direktori Moodle yang bersih, segarkan halaman ini untuk melanjutkan proses pembaruan Moodle.

Peringatan ini sering kali disebabkan oleh unzip paket Moodle standar dari versi Moodle sebelumnya. Meskipun ini tidak masalah untuk peningkatan kecil, sangat tidak disarankan untuk peningkatan Moodle besar.

Peringatan ini juga dapat disebabkan oleh pembayaran yang tidak lengkap atau operasi pembaruan dari repositori Git, dalam hal ini Anda mungkin hanya perlu menunggu hingga operasi selesai, atau mungkin menjalankan perintah pembersihan yang sesuai dan mencoba kembali operasi.

Anda dapat menemukan informasi lebih lanjut dalam dokumentasi peningkatan di <a href="{$a}"> {$a} </a>.';
$string['upgradestart'] = 'Meningkatkan basis data Moodle sekarang';
$string['upgradesure'] = '<p> Berkas Moodle Anda telah diubah, dan Anda akan secara otomatis meningkatkan server Anda ke versi ini: </p> <p><li>{$a}</i> </p> <p> Setelah Anda melakukan ini, Anda tidak bisa kembali lagi. Harap dicatat bahwa proses ini dapat memakan waktu lama. </p> <p> Apakah Anda yakin ingin meningkatkan server ini ke versi ini? </p>';
$string['upgradetimedout'] = 'Waktu peningkatan habis, harap mulai ulang peningkatan.';
$string['upgradingdata'] = 'Peningkatan data';
$string['upgradinglogs'] = 'Riwayat pemutakhiran';
$string['upgradingversion'] = 'Tingkatkan ke versi baru';
$string['upwards'] = 'ke atas';
$string['useblogassociations'] = 'Aktifkan asosiasi';
$string['user'] = 'Pengguna';
$string['userbulk'] = 'Tindakan massal pengguna';
$string['userbulkdownload'] = 'Ekspor pengguna sebagai';
$string['userdefaultpreferences'] = 'Preferensi bawaan pengguna';
$string['userfeedbackafterupgrade'] = 'Setelah setiap peningkatan besar';
$string['userfeedbackencouragement'] = '<p>Moodle menyertakan fitur yang memberi pengguna pilihan untuk memberikan umpan balik tentang perangkat lunak Moodle melalui situs survei eksternal yang diselenggarakan oleh Moodle HQ. Tidak ada informasi identitas pengguna yang diteruskan ke situs survei.</p>
<p>Moodle HQ berupaya untuk bersikap terbuka dan transparan mengenai praktik pengumpulan datanya. Oleh karena itu, kami ingin memastikan bahwa Anda mengetahui dan mengontrol fungsi ini.</p> <p>Umpan balik dari pengguna membantu Moodle HQ dalam meningkatkan perangkat lunak Moodle. Untuk mengaktifkan fitur ini, buka <a href="{$a}">Setelan masukan</a>.</p>';
$string['userfeedbacknextreminder'] = 'Pengingat umpan balik berikutnya';
$string['userfeedbacknextreminder_desc'] = 'Kapan kita harus meminta pengguna untuk memberikan umpan balik lagi?';
$string['userfeedbackperiodically'] = 'Secara berkala';
$string['userfeedbackremindafter'] = 'Tunjukkan pengingat setelah';
$string['userfeedbackremindafter_desc'] = 'Ingatkan pengguna lagi untuk memberikan umpan balik setelah jumlah hari yang ditentukan.';
$string['userfiltersdefault'] = 'Filter pengguna bawaan';
$string['userfiltersdefault_desc'] = 'Pilih filter yang ingin Anda tampilkan di halaman \'Aksi pengguna massal\'. Untuk memilih beberapa filter, tahan tombol Ctrl. Filter yang tidak dipilih akan tetap dapat diakses melalui tautan \'Tampilkan lebih banyak\'';
$string['userimagesdisabled'] = 'Gambar pengguna profil dinonaktifkan';
$string['userlist'] = 'Telusuri daftar pengguna';
$string['usermanagement'] = 'Manajemen pengguna';
$string['userpolicies'] = 'Kebijakan pengguna';
$string['userpreference'] = 'Preferensi pengguna';
$string['userquota'] = 'Ruang berkas pribadi';
$string['userquota_desc'] = 'Jumlah maksimum data yang dapat disimpan oleh setiap pengguna di area berkas pribadi mereka.';
$string['users'] = 'Pengguna';
$string['usesitenameforsitepages'] = 'Gunakan nama situs untuk halaman situs';
$string['usetags'] = 'Aktifkan fungsi tagar';
$string['validateemptylineerror'] = 'Baris kosong tidak valid';
$string['validateerror'] = 'Nilai ini tidak valid';
$string['validateerrorlist'] = 'Entri ini tidak valid: {$a}';
$string['validateiperror'] = 'Alamat IP ini tidak valid: {$a}';
$string['verifychangedemail'] = 'Batasi domain saat mengubah surel';
$string['warningcurrentsetting'] = 'Nilai saat ini tidak valid: {$a}';
$string['warningiconvbuggy'] = 'Versi pustaka iconv Anda tidak mendukung pengubah //IGNORE. Anda harus memasang ekstensi mbstring yang dapat digunakan sebagai gantinya untuk membersihkan string yang berisi karakter UTF-8 yang tidak valid.';
$string['webproxy'] = 'Proksi web';
$string['webproxyinfo'] = 'Isi opsi berikut jika server Moodle Anda tidak dapat mengakses internet secara langsung. Akses internet diperlukan untuk mengunduh data lingkungan, paket bahasa, umpan RSS, zona waktu, dll. <br /> <em> Ekstensi PHP cURL sangat disarankan. </em>';
$string['xmlrpcwebserviceenabled'] = 'Telah terdeteksi bahwa protokol Layanan Web XML-RPC diaktifkan di situs Anda. Fitur ini mengandalkan ekstensi PHP XML-RPC yang tidak lagi dikelola oleh PHP.';
$string['yuicomboloading'] = 'Pemuatan kombo YUI';
$string['ziprequired'] = 'Ekstensi Zip PHP sekarang dibutuhkan oleh Moodle, binari info-ZIP atau pustaka PclZip tidak digunakan lagi.';
