<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'bigbluebuttonbn', language 'id', version '4.4'.
 *
 * @package     bigbluebuttonbn
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['acceptdpa'] = 'Saya memahami dan menerima perjanjian pemrosesan data';
$string['activityoverview'] = 'Anda memiliki sesi BigBlueButton yang akan datang';
$string['bbbduetimeoverstartingtime'] = 'Waktu tutup harus lebih baru dari waktu buka.';
$string['bbbdurationwarning'] = 'Durasi maksimum untuk sesi ini adalah %duration% menit.';
$string['bbbrecordallfromstartwarning'] = 'Sesi ini direkam dari awal.';
$string['bbbrecordwarning'] = 'Sesi ini dapat direkam.';
$string['bigbluebuttonbn'] = 'BigBlueButton';
$string['bigbluebuttonbn:addinstance'] = 'Tambahkan ruang Bigbluebutton baru';
$string['bigbluebuttonbn:addinstancewithmeeting'] = 'Buat model dengan sesi langsung';
$string['bigbluebuttonbn:addinstancewithrecording'] = 'Buat model dengan kemampuan merekam';
$string['bigbluebuttonbn:deleterecordings'] = 'Hapus rekaman';
$string['bigbluebuttonbn:importrecordings'] = 'Impor rekaman';
$string['bigbluebuttonbn:join'] = 'Gabung dengan ruang Bigbluebutton';
$string['bigbluebuttonbn:managerecordings'] = 'Kelola rekaman';
$string['bigbluebuttonbn:protectrecordings'] = 'Lindungi rekaman';
$string['bigbluebuttonbn:publishrecordings'] = 'Publikasikan rekaman';
$string['bigbluebuttonbn:unprotectrecordings'] = 'Buka proteksi rekaman';
$string['bigbluebuttonbn:unpublishrecordings'] = 'Batalkan publikasi rekaman';
$string['bigbluebuttonbn:view'] = 'Lihat ruang Bigbluebutton';
$string['bigbluebuttonbn:viewallrecordingformats'] = 'Lihat semua format rekaman';
$string['bigbluebuttondisablednotification'] = 'Modul aktivitas BigBlueButton telah dinonaktifkan dan semua aktivitas kursus BigBlueButton yang ada saat ini tidak dapat diakses. Sebelum mengaktifkan kembali pengaya ini, pastikan Anda telah membaca dan menerima <a href="{$a}" target="_blank">perjanjian pemrosesan data</a> dengan Blindside Networks Inc.';
$string['bigbluebuttondisablednotification_subject'] = 'Modul aktivitas BigBlueButton dinonaktifkan.';
$string['cachedef_currentfetch'] = 'Data untuk mencantumkan rekaman apa pun yang diambil baru-baru ini.';
$string['cachedef_recordings'] = 'Merekam metadata';
$string['cachedef_serverinfo'] = 'Informasi server jarak jauh';
$string['cachedef_subplugins'] = 'Singgahan digunakan oleh rutinitas sub-pengaya untuk mempercepat proses penemuan pengaya saat diperlukan.';
$string['cachedef_validatedurls'] = 'Singgahan pemeriksaan URL yang divalidasi';
$string['calendarstarts'] = '{$a} dijadwalkan';
$string['cannotperformaction'] = 'Tidak dapat melakukan tindakan {$a} pada rekaman ini';
$string['completionattendance'] = 'Memerlukan kehadiran (menit)';
$string['completionattendance_desc'] = 'Masuk dan tetap berada di ruangan setidaknya selama {$a} menit.';
$string['completionattendance_event_desc'] = 'Siswa telah memasuki ruang dan tetap berada di sesi setidaknya selama {$a} menit';
$string['completionattendancegroup'] = 'Memerlukan kehadiran (menit)';
$string['completionattendancegroup_help'] = 'Menghadiri rapat selama (n) menit diperlukan untuk penyelesaian';
$string['completionengagement_desc'] = 'Terlibat dalam aktivitas selama pertemuan.';
$string['completionengagementchats'] = 'Obrolan';
$string['completionengagementchats_desc'] = 'Berpartisipasi dalam {$a} obrolan';
$string['completionengagementchats_event_desc'] = 'Telah membangkitkan {$a} obrolan';
$string['completionengagementemojis'] = 'Emoji';
$string['completionengagementemojis_desc'] = 'Ubah {$a} kali emojinya.';
$string['completionengagementemojis_event_desc'] = 'Mengubah {$a} kali emojinya';
$string['completionengagementgroup'] = 'Memerlukan partisipasi';
$string['completionengagementgroup_help'] = 'Partisipasi aktif selama sesi diperlukan untuk penyelesaian.';
$string['completionengagementpollvotes'] = 'Suara jajak pendapat';
$string['completionengagementpollvotes_desc'] = 'Beri suara dalam jajak pendapat {$a} kali.';
$string['completionengagementpollvotes_event_desc'] = 'Telah menjawab {$a} suara jajak pendapat';
$string['completionengagementraisehand'] = 'Perlu angkat tangan';
$string['completionengagementraisehand_desc'] = 'Angkat tangan {$a} kali.';
$string['completionengagementraisehand_event_desc'] = 'Telah mengangkat tangan {$a} kali';
$string['completionengagementtalks'] = 'Bicara';
$string['completionengagementtalks_desc'] = 'Bicara {$a} kali';
$string['completionengagementtalks_event_desc'] = 'Telah mengangkat pembicaraan {$a}';
$string['completionupdatestate'] = 'Status pembaruan selesai';
$string['completionvalidatestate'] = 'Validasi penyelesaian';
$string['completionvalidatestatetriggered'] = 'Validasi penyelesaian telah dipicu.';
$string['completionview'] = 'Memerlukan tampilan';
$string['completionview_desc'] = 'Lihat ruangan';
$string['completionview_event_desc'] = 'Telah melihat laman Ruang.';
$string['config_checksum_algorithm'] = 'Algoritma checksum server BigBlueButton';
$string['config_checksum_algorithm_description'] = 'SHA1 kompatibel dengan server lama. SHA256 dan SHA512 lebih aman. SHA512 sesuai dengan FIPS 140-2.';
$string['config_default_messages'] = 'Pesan bawaan';
$string['config_default_messages_description'] = 'Setel pesan bawaan untuk aktivitas';
$string['config_disablecam_default'] = 'Nonaktifkan kamera diaktifkan secara bawaan';
$string['config_disablecam_default_description'] = 'Jika diaktifkan, kamera akan dinonaktifkan.';
$string['config_disablecam_editable'] = 'Nonaktifkan kamera dapat diedit';
$string['config_disablecam_editable_description'] = 'Nonaktifkan kamera secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_disablemic_default'] = 'Nonaktifkan mikrofon diaktifkan secara bawaan';
$string['config_disablemic_default_description'] = 'Jika diaktifkan, mikrofon akan dinonaktifkan.';
$string['config_disablemic_editable'] = 'Nonaktifkan mic dapat diedit';
$string['config_disablemic_editable_description'] = 'Nonaktifkan mikrofon secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_disablenote_default'] = 'Nonaktifkan catatan bersama yang diaktifkan secara bawaan';
$string['config_disablenote_default_description'] = 'Jika diaktifkan, catatan bersama akan dinonaktifkan.';
$string['config_disablenote_editable'] = 'Nonaktifkan catatan bersama dapat diedit';
$string['config_disablenote_editable_description'] = 'Nonaktifkan catatan bersama secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_disableprivatechat_default'] = 'Nonaktifkan obrolan pribadi yang diaktifkan secara bawaan';
$string['config_disableprivatechat_default_description'] = 'Jika diaktifkan, obrolan pribadi akan dinonaktifkan.';
$string['config_disableprivatechat_editable'] = 'Nonaktifkan obrolan pribadi dapat diedit';
$string['config_disableprivatechat_editable_description'] = 'Nonaktifkan obrolan pribadi secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_disablepublicchat_default'] = 'Nonaktifkan obrolan publik yang diaktifkan secara bawaan';
$string['config_disablepublicchat_default_description'] = 'Jika diaktifkan, obrolan publik akan dinonaktifkan.';
$string['config_disablepublicchat_editable'] = 'Nonaktifkan obrolan publik dapat diedit';
$string['config_disablepublicchat_editable_description'] = 'Nonaktifkan obrolan publik secara bawaan dapat diedit saat bawaan ditambahkan atau diperbarui.';
$string['config_dpa_note'] = 'Catatan: Untuk memenuhi kewajiban perlindungan data Anda, sebelum menggunakan penyedia layanan untuk plugin ini, Anda harus memastikan bahwa Anda telah membaca dan menerima perjanjian pemrosesan data penyedia layanan. Untuk layanan BigBlueButton gratis bawaan, ini adalah <a href="{$a}" target="_blank">perjanjian pemrosesan data Blindside Networks</a>. Silakan berkonsultasi dengan profesional privasi Anda sendiri untuk mendapatkan saran.';
$string['config_experimental_features'] = 'Fitur eksperimental';
$string['config_experimental_features_description'] = 'Konfigurasi untuk fitur eksperimental.';
$string['config_extended_capabilities'] = 'Kemampuan yang diperluas';
$string['config_extended_capabilities_description'] = 'Konfigurasi untuk kemampuan yang diperluas saat server BigBlueButton menawarkannya.';
$string['config_general'] = 'Setelan umum';
$string['config_general_description'] = 'Untuk menyiapkan BigBlueButton, Anda dapat menggunakan peladen dan kredensial BigBlueButton Anda sendiri, atau mendapatkan kredensial melalui <a href="https://registration-portal.blindsidenetworks.com/" target="_blank">Portal Pendaftaran Jaringan Blindside ( terbuka di jendela baru)</a>.';
$string['config_guestaccess_enabled'] = 'Akses tamu eksternal';
$string['config_guestaccess_enabled_description'] = 'Izinkan pengguna tanpa akun di situs Anda untuk mengakses ruangan.';
$string['config_hideuserlist_default'] = 'Sembunyikan daftar pengguna diaktifkan secara bawaan';
$string['config_hideuserlist_default_description'] = 'Jika diaktifkan, daftar pengguna sesi akan disembunyikan.';
$string['config_hideuserlist_editable'] = 'Sembunyikan daftar pengguna dapat diedit';
$string['config_hideuserlist_editable_description'] = 'Sembunyikan daftar pengguna secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_importrecordings'] = 'Impor rekaman';
$string['config_importrecordings_description'] = 'Setelan ini untuk fitur khusus.';
$string['config_importrecordings_enabled'] = 'Impor rekaman diaktifkan';
$string['config_importrecordings_enabled_description'] = 'Ketika fitur ini dan fitur rekam diaktifkan, dimungkinkan untuk mengimpor rekaman dari kursus yang berbeda ke dalam suatu aktivitas.';
$string['config_importrecordings_from_deleted_enabled'] = 'Impor rekaman dari aktivitas yang dihapus diaktifkan';
$string['config_importrecordings_from_deleted_enabled_description'] = 'Ketika fitur ini dan impor rekam diaktifkan, dimungkinkan untuk mengimpor rekaman dari aktivitas yang tidak lagi ada dalam kursus.';
$string['config_locksettings'] = 'Konfigurasi untuk setelan penguncian';
$string['config_locksettings_description'] = 'Setelan ini mengaktifkan atau menonaktifkan opsi di UI untuk mengunci setelan, dan juga menentukan nilai bawaan untuk opsi ini.';
$string['config_meetingevents_enabled'] = 'Daftarkan acara langsung';
$string['config_meetingevents_enabled_description'] = 'Jika diaktifkan, sesi langsung akan diproses setelah sesi berakhir. Fitur ini diperlukan untuk penyelesaian Aktivitas dan hanya akan berfungsi jika server BigBlueButton mampu memproses skrip post_events.';
$string['config_muteonstart'] = 'Bisukan saat Mulai';
$string['config_muteonstart_default'] = 'Bisukan saat mulai diaktifkan secara bawaan';
$string['config_muteonstart_default_description'] = 'Jika diaktifkan, sesi akan dibisukan saat mulai.';
$string['config_muteonstart_description'] = 'Setelan ini mengaktifkan atau menonaktifkan opsi di UI dan juga menentukan nilai bawaan untuk opsi ini.';
$string['config_muteonstart_editable'] = 'Bisukan saat mulai dapat diedit';
$string['config_muteonstart_editable_description'] = 'Bisukan saat mulai secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_participant'] = 'Peserta';
$string['config_participant_description'] = 'Setelan ini menentukan peran bawaan untuk peserta.';
$string['config_participant_moderator_default'] = 'Moderator';
$string['config_participant_moderator_default_description'] = 'Aturan ini digunakan secara bawaan ketika ruangan baru ditambahkan.';
$string['config_poll_interval'] = 'Interval jajak pendapat (dalam detik) untuk menyegarkan status ruangan';
$string['config_poll_interval_description'] = 'Interval jejak pendapat minimal harus 2 detik. Jika perlu, Anda dapat menurunkan beban di server jarak jauh dengan menambah interval.';
$string['config_presentation_default'] = 'Berkas presentasi bawaan';
$string['config_presentation_default_description'] = 'Berkas dapat disediakan untuk digunakan di semua ruang.';
$string['config_preuploadpresentation'] = 'Berkas presentasi';
$string['config_preuploadpresentation_description'] = 'Setelan ini mengaktifkan atau menonaktifkan opsi di UI dan juga menentukan nilai bawaan untuk opsi ini. Fitur ini hanya berfungsi jika server Moodle dapat diakses oleh BigBlueButton..';
$string['config_preuploadpresentation_editable'] = 'Berkas presentasi di halaman aktivitas';
$string['config_preuploadpresentation_editable_description'] = 'Pilihan dalam setelan aktivitas untuk mengunggah berkas presentasi untuk ditampilkan di halaman aktivitas.';
$string['config_profile_picture_enabled'] = 'Tampilkan gambar profil';
$string['config_profile_picture_enabled_description'] = 'Haruskah foto profil peserta ditampilkan di sesi BigBlueButton?';
$string['config_recording'] = 'Merekam';
$string['config_recording_all_from_start_default'] = 'Rekam semua dari awal';
$string['config_recording_all_from_start_default_description'] = 'Haruskah setelan \'Mulai merekam dari awal\' diaktifkan secara bawaan saat menambahkan ruang BigBlueButton baru?';
$string['config_recording_all_from_start_editable'] = 'Mulai merekam dari awal yang dapat diedit';
$string['config_recording_all_from_start_editable_description'] = 'Haruskah \'Mulai merekam dari awal\' dapat diedit di setelan aktivitas BigBlueButton?';
$string['config_recording_default'] = 'Fitur rekam diaktifkan secara bawaan';
$string['config_recording_default_description'] = 'Haruskah setelan \'Sesi dapat direkam\' diaktifkan secara bawaan saat menambahkan ruang BigBlueButton baru?';
$string['config_recording_description'] = 'Setelan ini khusus untuk fitur';
$string['config_recording_editable'] = 'Sesi dapat direkam dapat diedit';
$string['config_recording_editable_description'] = 'Haruskah \'Sesi dapat direkam\' dapat diedit di setelan aktivitas BigBlueButton?';
$string['config_recording_hide_button_default'] = 'Sembunyikan tombol rekam';
$string['config_recording_hide_button_default_description'] = 'Jika dicentang, tombol untuk merekam akan disembunyikan';
$string['config_recording_hide_button_editable'] = 'Sembunyikan tombol rekam dapat diedit';
$string['config_recording_hide_button_editable_description'] = 'Haruskah \'Sembunyikan tombol perekaman\' dapat diedit di setelan aktivitas BigBlueButton?';
$string['config_recording_protect_editable'] = 'Status rekaman yang dilindungi dapat diedit';
$string['config_recording_protect_editable_description'] = 'Jika dicentang, antarmuka menyertakan opsi untuk melindungi/membuka proteksi rekaman.';
$string['config_recording_refresh_period'] = 'Periode penyegaran perekaman (dalam detik)';
$string['config_recording_refresh_period_description'] = 'Seberapa sering server BigBlueButton harus melakukan kueri untuk menyegarkan informasi jarak jauh untuk rekaman?';
$string['config_recording_safe_formats'] = 'Format rekaman dapat dilihat oleh semua orang';
$string['config_recording_safe_formats_description'] = 'Pilih format yang dapat dilihat oleh semua orang. Semua format lain hanya dapat dilihat oleh pengajar dan pengguna lain dengan mod/bigbluebuttonbn:viewallrecordingformats dan mod/bigbluebuttonbn: kelola kemampuan rekaman.';
$string['config_recordingready_enabled'] = 'Kirim pemberitahuan rekaman yang tersedia';
$string['config_recordingready_enabled_description'] = 'Jika diaktifkan, pemberitahuan akan dikirim saat tautan rekaman tersedia. Fitur ini mengharuskan skrip post_publish_recording_ready_callback diaktifkan di server BigBlueButton.';
$string['config_recordings'] = 'Tampilkan rekaman';
$string['config_recordings_asc_sort'] = 'Daftar rekaman dalam urutan kronologis';
$string['config_recordings_asc_sort_description'] = 'Rekaman diurutkan berdasarkan tanggal, baik urutan kronologis atau urutan kronologis terbalik (rekaman terbaru terlebih dahulu).';
$string['config_recordings_deleted_default'] = 'Sertakan rekaman dari aktivitas yang dihapus yang diaktifkan secara bawaan.';
$string['config_recordings_deleted_default_description'] = 'Jika diaktifkan, tabel perekaman akan menyertakan rekaman milik aktivitas yang dihapus jika ada.';
$string['config_recordings_deleted_editable'] = 'Sertakan rekaman dari fitur aktivitas yang dihapus dapat diedit';
$string['config_recordings_deleted_editable_description'] = 'Menyertakan rekaman dari aktivitas yang dihapus secara bawaan dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_recordings_description'] = 'Setelan ini khusus untuk fitur';
$string['config_recordings_general'] = 'Tampilkan setelan rekam';
$string['config_recordings_general_description'] = 'Setelan ini hanya digunakan saat menampilkan rekaman';
$string['config_recordings_imported_default'] = 'Tampilkan hanya tautan yang diimpor yang diaktifkan secara bawaan';
$string['config_recordings_imported_default_description'] = 'Jika diaktifkan, tabel perekaman hanya akan menyertakan tautan yang diimpor ke rekaman.';
$string['config_recordings_imported_editable'] = 'Tampilkan hanya fitur tautan yang diimpor yang dapat diedit';
$string['config_recordings_imported_editable_description'] = 'Tampilkan hanya tautan yang diimpor secara bawaan yang dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_recordings_preview_default'] = 'Pratinjau diaktifkan secara bawaan';
$string['config_recordings_preview_default_description'] = 'Jika diaktifkan, tabel menyertakan pratinjau presentasi.';
$string['config_recordings_preview_editable'] = 'Fitur pratinjau dapat diedit';
$string['config_recordings_preview_editable_description'] = 'Fitur pratinjau dapat diedit saat model ditambahkan atau diperbarui.';
$string['config_scheduled'] = 'Sesi terjadwal';
$string['config_scheduled_description'] = 'Setelan ini menentukan beberapa perilaku secara bawa untuk sesi terjadwal.';
$string['config_scheduled_pre_opening'] = 'Dapat diakses sebelum jam buka';
$string['config_scheduled_pre_opening_description'] = 'Waktu dalam menit saat ruangan dibuka sebelum waktu buka yang dijadwalkan.';
$string['config_server_url'] = 'URL Server BigBlueButton';
$string['config_server_url_description'] = 'URL server server BigBlueButton Anda';
$string['config_shared_secret'] = 'Kode rahasia bersama BigBlueButton';
$string['config_shared_secret_description'] = 'Rahasia keamanan server BigBlueButton Anda.';
$string['config_uidelegation_enabled'] = 'Delegasi UI diaktifkan';
$string['config_uidelegation_enabled_description'] = 'Setelan ini mengaktifkan atau menonaktifkan delegasi UI ke server BigBlueButton.';
$string['config_userlimit'] = 'Batas pengguna';
$string['config_userlimit_default'] = 'Batas pengguna diaktifkan secara bawaan';
$string['config_userlimit_default_description'] = 'Jumlah pengguna yang diizinkan dalam satu sesi secara bawaan saat ruang baru ditambahkan. Setel ke 0 untuk mengizinkan jumlah pengguna yang tidak terbatas.';
$string['config_userlimit_description'] = 'Setelan ini mengaktifkan atau menonaktifkan opsi di UI dan juga menentukan nilai bawaan untuk opsi ini.';
$string['config_userlimit_editable'] = 'Fitur batas pengguna dapat diedit';
$string['config_userlimit_editable_description'] = 'Nilai batas pengguna secara bawaan dapat diedit ketika ruangan atau konferensi ditambahkan atau diperbarui.';
$string['config_voicebridge'] = 'Jembatan suara';
$string['config_voicebridge_description'] = 'Setelan ini mengaktifkan atau menonaktifkan opsi di UI dan juga menentukan nilai bawaan untuk opsi ini.';
$string['config_voicebridge_editable'] = 'Jembatan suara konferensi dapat diedit';
$string['config_voicebridge_editable_description'] = 'Nomor penghubung suara konferensi dapat ditetapkan secara permanen ke sebuah ruang. Saat ditetapkan, nomor tersebut tidak dapat digunakan untuk ruang lain mana pun.';
$string['config_waitformoderator'] = 'Tunggu moderator';
$string['config_waitformoderator_cache_ttl'] = 'Singgahan tunggu  moderator TTL (detik)';
$string['config_waitformoderator_cache_ttl_description'] = 'Untuk mendukung banyak klien, pengaya ini menggunakan singgahan. Parameter ini menentukan waktu singgahan akan disimpan sebelum permintaan berikutnya dikirim ke server BigBlueButton.';
$string['config_waitformoderator_default'] = 'Tunggu moderator diaktifkan secara bawaan';
$string['config_waitformoderator_default_description'] = 'Apakah setelan \'Tunggu moderator\' diaktifkan secara bawaan ketika ruang atau konferensi baru ditambahkan.';
$string['config_waitformoderator_description'] = 'Setelan ini khusus untuk fitur';
$string['config_waitformoderator_editable'] = 'Fitur tunggu moderator dapat diedit';
$string['config_waitformoderator_editable_description'] = 'Haruskah \'Tunggu moderator\' dapat diedit di setelan aktivitas BigBlueButton?';
$string['config_waitformoderator_ping_interval'] = 'Ping tunggu moderator (detik)';
$string['config_waitformoderator_ping_interval_description'] = 'Seberapa sering server harus di-ping untuk memeriksa apakah moderator telah memasuki ruangan?';
$string['config_warning_bigbluebuttonbn_cfg_deprecated'] = 'BigBlueButton memanfaatkan config.php dengan variabel global yang sudah tidak digunakan lagi. Harap konversi berkas karena tidak akan didukung di versi mendatang.';
$string['config_warning_curl_not_installed'] = 'Fitur ini memerlukan ekstensi CURL yang diaktifkan pada php terpasang. Setelan akan dapat diakses hanya jika kondisi ini terpenuhi.';
$string['config_welcome_default'] = 'Pesan selamat datang bawaan';
$string['config_welcome_default_description'] = 'Pesan selamat datang ditampilkan saat peserta memasuki ruangan. Jika kolom dibiarkan kosong, string bahasa \'mod_form_field_welcome_default\' akan digunakan.';
$string['config_welcome_editable'] = 'Pesan selamat datang bawaan dapat diedit oleh pengajar';
$string['config_welcome_editable_description'] = 'Pesan selamat datang dapat diedit ketika model ditambahkan atau diperbarui';
$string['credentials_warning'] = 'Penggunaan kredensial server bawaan akan segera berakhir (lihat catatan di atas untuk mendapatkan kredensial baru).';
$string['dpainfonotsigned'] = 'Sebelum mengaktifkan plugin ini, Anda harus mengonfirmasi bahwa Anda telah membaca dan menerima <a href="{$a}">perjanjian pemrosesan data Blindside Networks</a>.';
$string['enablingbigbluebutton'] = 'Mengaktifkan aktivitas BigBlueButton';
$string['enablingbigbluebuttondpainfo'] = 'Untuk memenuhi kewajiban perlindungan data Anda, sebelum mengaktifkan plugin ini, Anda mungkin perlu memastikan bahwa Anda telah membaca dan menerima <a href="{$a}" target="_blank">perjanjian pemrosesan data Blindside Networks</ a>. Silakan berkonsultasi dengan profesional privasi Anda sendiri untuk saran.';
$string['end_session_confirm'] = 'Apakah Anda yakin ingin mengakhiri sesi?';
$string['end_session_confirm_title'] = 'Benar-benar mengakhiri sesi?';
$string['end_session_notification'] = 'Sesi telah berakhir.';
$string['ends_at'] = 'Berakhir';
$string['event_activity_created'] = 'Membuat aktivitas';
$string['event_activity_deleted'] = 'Menghapus aktivias';
$string['event_activity_updated'] = 'Memperbarui aktivitas';
$string['event_live_session'] = 'Acara sesi langsung';
$string['event_meeting_created'] = 'Membuat rapat';
$string['event_meeting_ended'] = 'Memaksa mengakhiri rapat';
$string['event_meeting_joined'] = 'Bergabung dengan rapat';
$string['event_meeting_left'] = 'Meninggalkan rapat';
$string['event_recording_deleted'] = 'Menghapus rekaman';
$string['event_recording_edited'] = 'Mengedit rekaman';
$string['event_recording_imported'] = 'Mengimpor rekaman';
$string['event_recording_protected'] = 'Melindungi rekaman';
$string['event_recording_published'] = 'Menerbitkan rekaman';
$string['event_recording_unprotected'] = 'Melepas perlindungan rekaman';
$string['event_recording_unpublished'] = 'Batal menerbitkan rekaman';
$string['event_recording_viewed'] = 'Melihat rekaman';
$string['event_unknown'] = 'Acara tidak diketahui';
$string['general_error_cannot_create_meeting'] = 'Tidak dapat membuat sesi.';
$string['general_error_cannot_get_recordings'] = 'Tidak bisa mendapatkan rekaman.';
$string['general_error_no_answer'] = 'Respons kosong. Silakan periksa URL server BigBlueButton DAN periksa untuk melihat apakah server BigBlueButton sedang berjalan.';
$string['general_error_not_allowed_to_create_instances'] = 'Pengguna tidak diizinkan untuk membuat semua jenis model.';
$string['general_error_not_found'] = 'Tidak dapat menemukan aktivitas BigBlueButton dengan ID {$a}.';
$string['general_error_unable_connect'] = 'Tidak dapat terhubung. Silakan periksa url server BigBlueButton DAN periksa untuk melihat apakah server BigBlueButton sedang berjalan.';
$string['guest_invitation_full_message'] = 'Hai,
<p>Anda diundang ke sesi BigBlueButton <strong>{$a->name}</strong> dalam kursus {$a->course_fullname}.</p>
<p>Tautan: {$a->guestjoinurl}<br/>
<p>Kata sandi: {$a->kata sandi tamu}</p>
<p>Jika Anda butuh bantuan, harap hubungi {$a->sender}.</p>';
$string['guest_invitation_small_message'] = 'Hai,

Anda diundang ke sesi BigBlueButton {$a->name} dalam kursus {$a->course_fullname}.

Tautan: {$a->guestjoinurl}
Kata sandi: {$a->guestpassword}

Jika Anda butuh bantuan, silakan hubungi {$a->sender}.';
$string['guest_invitation_subject'] = 'Undangan: sesi {$a->name} di {$a->course_fullname}';
$string['guestaccess_activitynotfound'] = 'Aktivitas tidak ditemukan.';
$string['guestaccess_add'] = 'Tambahkan tamu';
$string['guestaccess_add_no_id'] = 'ID model BigBlueButton tidak disediakan.';
$string['guestaccess_copy_link'] = 'Salin tautan';
$string['guestaccess_copy_password'] = 'Salin kata sandi';
$string['guestaccess_emails'] = 'Surel tamu';
$string['guestaccess_emails_help'] = 'Daftar alamat surel, dipisahkan dengan koma.';
$string['guestaccess_emails_invalidemail'] = 'Surel {$a} tidak valid';
$string['guestaccess_feature_disabled'] = 'Akses tamu fitur dinonaktifkan.';
$string['guestaccess_invite_failure'] = 'Galat {$a->errors} saat mengundang {$a->emails}.';
$string['guestaccess_invite_success'] = 'Undangan akan dikirimkan ke {$a->emails}.';
$string['guestaccess_join_meeting'] = 'Gabung rapat';
$string['guestaccess_meeting_invalid_password'] = 'Kata kunci Salah.';
$string['guestaccess_meeting_link'] = 'Tautan rapat';
$string['guestaccess_meeting_not_started'] = 'Rapat belum dimulai. Coba lagi nanti.';
$string['guestaccess_meeting_password'] = 'Kata sandi rapat';
$string['guestaccess_password'] = 'Kata sandi';
$string['guestaccess_title'] = 'Tambahkan tamu ke rapat ini';
$string['guestaccess_username'] = 'Nama pengguna tamu';
$string['index_confirm_end'] = 'Apakah Anda ingin mengakhiri sesi?';
$string['index_disabled'] = 'dinonaktifkan';
$string['index_enabled'] = 'diaktifkan';
$string['index_ending'] = 'Mengakhiri sesi ... harap tunggu';
$string['index_error_bbtn'] = 'ID BigBlueButton {$a} salah';
$string['index_error_checksum'] = 'Terjadi kesalahan checksum. Pastikan Anda memasukkan kode rahasia yang benar.';
$string['index_error_forciblyended'] = 'Tidak dapat bergabung dengan sesi ini karena telah diakhiri secara manual.';
$string['index_error_noinstances'] = 'Tidak ada model ruang BigBlueButton';
$string['index_error_unable_display'] = 'Tidak dapat menampilkan sesi. Silakan periksa URL server BigBlueButton DAN periksa untuk melihat apakah server BigBlueButton berjalan atau tidak.';
$string['index_heading'] = 'Ruang BigBlueButton';
$string['index_heading_actions'] = 'Aksi';
$string['index_heading_group'] = 'Grup';
$string['index_heading_moderator'] = 'Moderator';
$string['index_heading_name'] = 'Ruangan';
$string['index_heading_recording'] = 'Rekaman';
$string['index_heading_users'] = 'Pengguna';
$string['index_heading_viewer'] = 'Pemirsa';
$string['indicator:cognitivedepth'] = 'Kognitif BigBlueButton';
$string['indicator:cognitivedepth_help'] = 'Indikator ini didasarkan pada kedalaman kognitif yang dicapai siswa dalam aktivitas BigBlueButton.';
$string['indicator:socialbreadth'] = 'Sosial BigBlueButton';
$string['indicator:socialbreadth_help'] = 'Indikator ini didasarkan pada keluasan sosial yang dicapai siswa dalam aktivitas BigBlueButton.';
$string['instance_type_default'] = 'Ruangan dengan rekaman';
$string['instance_type_recording_only'] = 'Rekaman saja';
$string['instance_type_room_only'] = 'Hanya ruang';
$string['instanceprofilewithoutrecordings'] = 'Profil model ini tidak dapat menampilkan rekaman';
$string['managebbbextplugins'] = 'Kelola pengaya ekstensi BigBlueButton';
$string['messageprovider:instance_updated'] = 'Sesi BigBlueButton diperbarui';
$string['messageprovider:recording_ready'] = 'Rekaman BigBlueButton tersedia';
$string['minute'] = 'menit';
$string['minutes'] = 'menit';
$string['mod_form_block_general'] = 'Umum';
$string['mod_form_block_guestaccess'] = 'Akses tamu';
$string['mod_form_block_participants'] = 'Peran ditugaskan selama sesi langsung';
$string['mod_form_block_presentation'] = 'Konten presentasi';
$string['mod_form_block_presentation_default'] = 'Konten bawaan presentasi';
$string['mod_form_block_record'] = 'Setelan rekaman';
$string['mod_form_block_recordings'] = 'Lihat rekaman';
$string['mod_form_block_room'] = 'Setelan Ruang';
$string['mod_form_block_schedule'] = 'Waktu sesi';
$string['mod_form_field_closingtime'] = 'Tutup';
$string['mod_form_field_conference_name'] = 'Nama sesi';
$string['mod_form_field_disablecam'] = 'Nonaktifkan kamera';
$string['mod_form_field_disablemic'] = 'Nonaktifkan mikrofon';
$string['mod_form_field_disablenote'] = 'Nonaktifkan catatan bersama';
$string['mod_form_field_disableprivatechat'] = 'Nonaktifkan';
$string['mod_form_field_disablepublicchat'] = 'Nonaktifkan obrolan publik';
$string['mod_form_field_duration'] = 'Durasi';
$string['mod_form_field_duration_help'] = 'Menyetel durasi rapat akan menetapkan waktu maksimum agar rapat tetap hidup sebelum perekaman selesai';
$string['mod_form_field_guestallowed'] = 'Izinkan akses tamu';
$string['mod_form_field_hideuserlist'] = 'Sembunyikan daftar pengguna';
$string['mod_form_field_instanceprofiles'] = 'Jenis model';
$string['mod_form_field_instanceprofiles_help'] = 'Jika sesi akan direkam, pilih \'Ruangan dengan rekaman\', jika tidak \'Hanya ruangan\'. Setelah sesi direkam, jika tidak ada sesi lagi, pilih \'Hanya rekaman\'.';
$string['mod_form_field_intro'] = 'Keterangan';
$string['mod_form_field_intro_help'] = 'Deskripsi singkat untuk ruangan.';
$string['mod_form_field_mustapproveuser'] = 'Tamu yang bergabung harus disetujui oleh moderator';
$string['mod_form_field_muteonstart'] = 'Bisukan saat mulai';
$string['mod_form_field_name'] = 'Nama ruang';
$string['mod_form_field_nosettings'] = 'Tidak ada setelan yang dapat diedit';
$string['mod_form_field_openingtime'] = 'Buka';
$string['mod_form_field_participant_add'] = 'Tambahkan penerima tugas';
$string['mod_form_field_participant_bbb_role_moderator'] = 'Moderator';
$string['mod_form_field_participant_bbb_role_viewer'] = 'Penonton';
$string['mod_form_field_participant_list'] = 'Penerima tugas';
$string['mod_form_field_participant_list_action_add'] = 'Tambahkan';
$string['mod_form_field_participant_list_action_remove'] = 'Hapus';
$string['mod_form_field_participant_list_text_as'] = 'join sesi sebagai';
$string['mod_form_field_participant_list_type_all'] = 'Semua pengguna terdaftar';
$string['mod_form_field_participant_list_type_owner'] = 'Pemilik';
$string['mod_form_field_participant_list_type_role'] = 'Peran';
$string['mod_form_field_participant_list_type_user'] = 'Pengguna';
$string['mod_form_field_record'] = 'Sesi dapat direkam.';
$string['mod_form_field_recordallfromstart'] = 'Rekam semua dari awal';
$string['mod_form_field_recordhidebutton'] = 'Sembunyikan tombol rekam';
$string['mod_form_field_recordings_deleted'] = 'Sertakan rekaman dari aktivitas yang dihapus';
$string['mod_form_field_recordings_html'] = 'Tampilkan tabel dalam HTML';
$string['mod_form_field_recordings_imported'] = 'Tampilkan hanya tautan yang diimpor';
$string['mod_form_field_recordings_preview'] = 'Tampilkan hanya tautan yang diimpor';
$string['mod_form_field_room_name'] = 'Nama ruangan';
$string['mod_form_field_userlimit'] = 'Batas pengguna';
$string['mod_form_field_userlimit_help'] = 'Jumlah maksimum pengguna yang diizinkan dalam satu sesi. Setel ke 0 untuk mengizinkan jumlah pengguna yang tidak terbatas.';
$string['mod_form_field_voicebridge'] = 'Jembatan suara [####]';
$string['mod_form_field_voicebridge_format_error'] = 'Kesalahan format. Anda harus memasukkan angka antara 1 dan 9999.';
$string['mod_form_field_voicebridge_help'] = 'Angka antara 1 dan 9999 yang dimasukkan peserta untuk bergabung ke sesi suara saat menggunakan dial-in. Jika nilainya 0 maka nomor jembatan suara statis akan diabaikan dan nomor acak akan dihasilkan oleh BigBlueButton. Angka 7 akan mengawali empat digit yang diketik.';
$string['mod_form_field_voicebridge_notunique_error'] = 'Bukan nilai yang unik. Nomor ini sedang digunakan oleh ruang lain.';
$string['mod_form_field_wait'] = 'Tunggu moderator';
$string['mod_form_field_wait_help'] = 'Apakah peserta harus menunggu moderator sebelum dapat memasuki ruang?';
$string['mod_form_field_welcome'] = 'Pesan pembuka';
$string['mod_form_field_welcome_default'] = 'Selamat datang di %%CONFNAME%%.';
$string['mod_form_field_welcome_help'] = 'Pesan selamat datang ditampilkan saat peserta memasuki ruang. Jika bidang dibiarkan kosong, maka pesan bawaan yang diatur dalam administrasi situs akan ditampilkan.';
$string['mod_form_locksettings'] = 'Setelan kunci';
$string['modulename'] = 'BigBlueButton';
$string['modulename_help'] = 'BigBlueButton adalah sistem konferensi web sumber terbuka yang dirancang untuk pembelajaran online, yang mendukung berbagi waktu nyata audio, video, obrolan, slide, berbagi layar, papan tulis multi-pengguna, ruang kerja kelompok, polling, dan emoji.

Menggunakan BigBlueButton Anda dapat membuat ruang untuk sesi seperti kelas online langsung, jam kantor virtual, atau kolaborasi grup dengan siswa jarak jauh. Sesi dapat direkam untuk pemutaran nanti.';
$string['modulename_link'] = 'BigBlueButton/view';
$string['modulenameplural'] = 'BigBlueButton';
$string['new_bigblubuttonbn_activities'] = 'Aktivitas BigBlueButton';
$string['nosuchinstance'] = 'Tidak ada model {$a->entity} dengan id: {$a->id}';
$string['notification_instance_created_intro'] = 'Ruang BigBlueButton <a href="{$a->link}"{$a->name}</a> telah dibuat.';
$string['notification_instance_created_small'] = 'Ruang BigBlueButton baru bernama {$a->name} telah dibuat';
$string['notification_instance_created_subject'] = 'Ruang BigBlueButton baru telah dibuat';
$string['notification_instance_description'] = 'Keterangan';
$string['notification_instance_end_date'] = 'Tanggal berakhir';
$string['notification_instance_name'] = 'Judul';
$string['notification_instance_start_date'] = 'Tanggal mulai';
$string['notification_instance_updated_intro'] = 'Ruang <a href="{$a->link}"{$a->name}</a> Aktivitas BigBlueButton telah diperbarui.';
$string['notification_instance_updated_small'] = 'Sesi {$a->name} BigBlueButton telah diperbarui';
$string['notification_instance_updated_subject'] = 'Ruang BigBlueButton Anda telah diperbarui';
$string['notification_recording_ready_html'] = 'Rekaman sekarang tersedia untuk sesi di <a href="{$a->link}"{$a->name}</a> ruang BigBlueButton.';
$string['notification_recording_ready_plain'] = 'Rekaman sekarang tersedia untuk sesi di ruang BigBlueButton {$a->name}. Buka {$a->link} untuk mengakses tautan rekaman.';
$string['notification_recording_ready_small'] = 'Rekaman tersedia untuk ruang BigBlueButton {$a->name}.';
$string['notification_recording_ready_subject'] = 'Rekaman tersedia';
$string['pluginadministration'] = 'administrasi BigBlueButton';
$string['pluginname'] = 'BigBlueButton';
$string['privacy:metadata:bigbluebutton'] = 'Untuk membuat dan bergabung dengan sesi BigBlueButton, data pengguna perlu ditukar dengan server.';
$string['privacy:metadata:bigbluebutton:fullname'] = 'Nama lengkap pengguna yang mengakses server BigBlueButton.';
$string['privacy:metadata:bigbluebutton:userid'] = 'ID pengguna yang mengakses server BigBlueButton.';
$string['privacy:metadata:bigbluebuttonbn'] = 'Konfigurasi sesi BigBlueButton';
$string['privacy:metadata:bigbluebuttonbn:participants'] = 'Daftar peran yang menentukan peran yang akan dimiliki pengguna dalam sesi BigBlueButton. ID pengguna dapat disimpan karena izin dapat diberikan per peran atau per pengguna.';
$string['privacy:metadata:bigbluebuttonbn_logs'] = 'Menyimpan acara yang dipicu saat menggunakan pengaya.';
$string['privacy:metadata:bigbluebuttonbn_logs:log'] = 'Jenis acara yang dipicu oleh pengguna.';
$string['privacy:metadata:bigbluebuttonbn_logs:meetingid'] = 'ID rapat yang dapat diakses pengguna.';
$string['privacy:metadata:bigbluebuttonbn_logs:meta'] = 'Informasi tambahan terkait sesi atau rekaman.';
$string['privacy:metadata:bigbluebuttonbn_logs:timecreated'] = 'Waktu ketika log dibuat.';
$string['privacy:metadata:bigbluebuttonbn_logs:userid'] = 'ID pengguna dari pengguna yang memicu peristiwa.';
$string['privacy:metadata:bigbluebuttonbn_recordings'] = 'Menyimpan metadata tentang rekaman.';
$string['privacy:metadata:bigbluebuttonbn_recordings:userid'] = 'ID pengguna dari pengguna yang terakhir kali mengubah rekaman.';
$string['progress_createbigbluebuttonbn'] = 'Membuat aktivitas BigBlueButton ({$a})';
$string['recordingnotfound'] = 'Rekaman tidak ditemukan.';
$string['recordings_from_deleted_activities'] = 'Rekaman dari aktivitas yang dihapus';
$string['recordingurlnotfound'] = 'URL rekaman tidak valid.';
$string['removedevents'] = 'Acara yang dihapus';
$string['removedlogs'] = 'Log kustom yang dihapus';
$string['removedrecordings'] = 'Rekaman yang dihapus';
$string['removedtags'] = 'Tag yang dihapus';
$string['report_join_info'] = '{$a} rapat';
$string['report_play_recording_info'] = 'Telah diputar {$a} kali';
$string['report_room_view'] = 'dilihat';
$string['resetevents'] = 'Hapus acara';
$string['resetlogs'] = 'Hapus log kustom';
$string['resetlogs_help'] = 'Menghapus log akan mengakibatkan hilangnya referensi ke rekaman.';
$string['resetrecordings'] = 'Hapus rekaman';
$string['resetrecordings_help'] = 'Menghapus rekaman akan membuatnya tidak dapat diakses dari mana saja. Tindakan ini tidak bisa dibatalkan!';
$string['resettags'] = 'Hapus tag';
$string['search:activity'] = 'BigBlueButton - informasi aktivitas';
$string['search:tags'] = 'BigBlueButton - informasi tag';
$string['sendnotification'] = 'Kirim pemberitahuan';
$string['settings'] = 'Setelan BigBlueButton';
$string['settings_credential_warning'] = 'Kredensial server BigBlueButton akan segera kedaluwarsa. Lihat <a href="{$a->settingslink}" target="_blank">setelan umum BigBlueButton (terbuka di jendela baru)</a>.';
$string['settings_credential_warning_no_capability'] = 'Kredensial server BigBlueButton akan segera kedaluwarsa. Silakan hubungi administrator situs Anda.';
$string['started_at'] = 'Dimulai';
$string['starts_at'] = 'Mulai';
$string['subplugintype_bbbext'] = 'Ekstensi aktivitas BigBlueButton';
$string['subplugintype_bbbext_plural'] = 'Ekstensi aktivitas BigBlueButton';
$string['taskname:check_dismissed_recordings'] = 'Periksa rekaman yang belum ditemukan';
$string['taskname:check_pending_recordings'] = 'Ambil rekaman yang tertunda';
$string['userlimitreached'] = 'Jumlah pengguna yang diizinkan dalam satu sesi telah tercapai.';
$string['view_conference_action_end'] = 'Akhiri sesi';
$string['view_conference_action_join'] = 'Gabung sesi';
$string['view_error_action_not_completed'] = 'Tindakan tidak dapat diselesaikan';
$string['view_error_bigbluebutton'] = 'BigBlueButton merespons dengan kesalahan. {$a}';
$string['view_error_create'] = 'Server BigBlueButton merespons dengan pesan kesalahan, sesi tidak dapat dibuat.';
$string['view_error_current_state_not_found'] = 'Status saat ini tidak ditemukan. Rekaman mungkin telah dihapus atau server BigBlueButton tidak kompatibel dengan tindakan yang dilakukan.';
$string['view_error_import_no_courses'] = 'Tidak ada kursus untuk mencari rekaman.';
$string['view_error_import_no_recordings'] = 'Tidak ada rekaman dalam kursus ini untuk diimpor.';
$string['view_error_invalid_session'] = 'Sesi ini kedaluwarsa. Kembali ke halaman utama aktivitas.';
$string['view_error_max_concurrent'] = 'Jumlah rapat serentak yang diizinkan telah tercapai.';
$string['view_error_meeting_not_running'] = 'Ada yang tidak beres, sesi tidak berjalan.';
$string['view_error_no_group'] = 'Tidak ada grup. Anda perlu membuat beberapa grup sebelum mencoba bergabung dengan sesi.';
$string['view_error_no_group_student'] = 'Anda belum terdaftar dalam grup. Silakan hubungi pengajar Anda.';
$string['view_error_no_group_teacher'] = 'Tidak ada grup. Anda perlu membuat beberapa grup.';
$string['view_error_unable_join'] = 'Tidak dapat memasuki ruang. Silakan periksa URL server BigBlueButton DAN periksa untuk melihat apakah server BigBlueButton sedang berjalan.';
$string['view_error_unable_join_student'] = 'Tidak dapat terhubung ke server BigBlueButton.';
$string['view_error_unable_join_teacher'] = 'Tidak dapat terhubung ke server BigBlueButton. Silakan hubungi administrator.';
$string['view_error_url_missing_parameters'] = 'Ada parameter yang hilang di URL ini';
$string['view_error_userlimit_reached'] = 'Batas jumlah pengguna yang diizinkan dalam satu sesi telah tercapai.';
$string['view_groups_nogroups_warning'] = 'Ruangan dikonfigurasi untuk menggunakan grup tetapi kursus tidak memiliki grup yang ditentukan.';
$string['view_groups_notenrolled_warning'] = 'Ruang dikonfigurasi untuk menggunakan grup tetapi Anda bukan anggota grup.';
$string['view_groups_selection'] = 'Pilih grup yang ingin Anda ikuti dan konfirmasikan tindakannya';
$string['view_groups_selection_join'] = 'Gabung';
$string['view_groups_selection_warning'] = 'Ada ruang untuk setiap grup dan Anda memiliki akses ke lebih dari satu. Pastikan untuk memilih yang benar.';
$string['view_login_moderator'] = 'Masuk sebagai moderator...';
$string['view_login_viewer'] = 'Masuk sebagai penonton ...';
$string['view_message_and'] = 'dan';
$string['view_message_conference_has_ended'] = 'Sesi telah berakhir.';
$string['view_message_conference_in_progress'] = 'Sesi sedang berlangsung.';
$string['view_message_conference_not_started'] = 'Sesi belum dimulai.';
$string['view_message_conference_room_ready'] = 'Ruang ini sudah siap. Anda dapat bergabung dengan sesi sekarang.';
$string['view_message_conference_user_limit_reached'] = 'Batas jumlah pengguna yang diizinkan dalam satu sesi telah tercapai.';
$string['view_message_conference_wait_for_moderator'] = 'Menunggu moderator untuk bergabung.';
$string['view_message_cron_disabled'] = 'Daftar rekaman mungkin belum diperbarui. Silakan hubungi administrator situs dengan informasi berikut: {$a}';
$string['view_message_finished'] = 'Aktivitas ini berakhir.';
$string['view_message_has_joined'] = 'telah bergabung';
$string['view_message_have_joined'] = 'telah bergabung';
$string['view_message_hour'] = 'jam';
$string['view_message_hours'] = 'jam';
$string['view_message_importrecordings_disabled'] = 'Impor tautan rekaman dinonaktifkan di server.';
$string['view_message_minute'] = 'menit';
$string['view_message_minutes'] = 'menit';
$string['view_message_moderator'] = 'Moderator';
$string['view_message_moderators'] = 'Moderator';
$string['view_message_norecordings'] = 'Tidak ada rekaman untuk ditampilkan.';
$string['view_message_notavailableyet'] = 'Sesi ini belum tersedia.';
$string['view_message_recordings_disabled'] = 'Rekaman dinonaktifkan di server ini. Aktivitas BigBlueButton tipe \'Hanya Rekaman\' tidak dapat digunakan.';
$string['view_message_room_closed'] = 'Ruangan ini ditutup.';
$string['view_message_room_open'] = 'Ruangan ini terbuka.';
$string['view_message_room_ready'] = 'Ruangan ini sudah siap.';
$string['view_message_session_for'] = 'sesi untuk';
$string['view_message_session_has_user'] = 'Terdapat';
$string['view_message_session_has_users'] = 'Terdapat';
$string['view_message_session_no_users'] = 'Tidak ada pengguna dalam sesi ini';
$string['view_message_session_running_for'] = 'Sesi ini telah berjalan selama';
$string['view_message_session_started_at'] = 'Sesi ini dimulai pada';
$string['view_message_tab_close'] = 'Tab/jendela ini harus ditutup secara manual';
$string['view_message_times'] = 'kali';
$string['view_message_user'] = 'Pengguna';
$string['view_message_users'] = 'Pengguna';
$string['view_message_viewer'] = 'Penonton';
$string['view_message_viewers'] = 'Penonton';
$string['view_mobile_message_groups_not_supported'] = 'Model ini diaktifkan untuk bekerja dengan grup tetapi aplikasi seluler belum mendukungnya. Sila gunakan versi web.';
$string['view_mobile_message_reload_page_creation_time_meeting'] = 'Anda melebihi 45 detik di halaman ini. Harap muat ulang halaman untuk bergabung dengan sesi.';
$string['view_noguests'] = 'BigBlueButton tidak terbuka untuk tamu.';
$string['view_nojoin'] = 'Anda tidak dalam peran yang diizinkan untuk bergabung dengan sesi ini.';
$string['view_recording'] = 'merekam';
$string['view_recording_actionbar'] = 'Bilah alat';
$string['view_recording_activity'] = 'Aktivitas';
$string['view_recording_button_import'] = 'Impor tautan rekaman';
$string['view_recording_button_return'] = 'Kembali';
$string['view_recording_course'] = 'Kursus';
$string['view_recording_date'] = 'Tanggal';
$string['view_recording_delete_confirmation'] = 'Apakah Anda yakin akan menghapus {$a} ini?';
$string['view_recording_delete_confirmation_warning_p'] = 'Rekaman ini memiliki {$a} tautan terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman dihapus, tautan itu juga akan dihapus.';
$string['view_recording_delete_confirmation_warning_s'] = 'Rekaman ini memiliki {$a} tautan yang terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman dihapus, tautan itu juga akan dihapus.';
$string['view_recording_description'] = 'Deskripsi';
$string['view_recording_description_edithint'] = 'Deskripsi dapat ditambahkan untuk membantu mengidentifikasi rekaman.';
$string['view_recording_description_editlabel'] = 'Edit deskripsi';
$string['view_recording_duration'] = 'Durasi';
$string['view_recording_duration_min'] = 'menit';
$string['view_recording_format_errror_unreachable'] = 'URL untuk format rekaman ini tidak dapat dijangkau.';
$string['view_recording_format_notes'] = 'Catatan';
$string['view_recording_format_podcast'] = 'Siniar';
$string['view_recording_format_presentation'] = 'Presentasi';
$string['view_recording_format_screenshare'] = 'Berbagi layar';
$string['view_recording_format_statistics'] = 'Statistik';
$string['view_recording_format_video'] = 'Video';
$string['view_recording_import_confirmation'] = 'Apakah Anda yakin akan mengimpor rekaman ini?';
$string['view_recording_length'] = 'Panjang';
$string['view_recording_link'] = 'Tautan diimpor';
$string['view_recording_link_warning'] = 'Ini adalah tautan yang menunjuk ke rekaman yang dibuat dalam kursus atau aktivitas yang berbeda.';
$string['view_recording_list_action_delete'] = 'Menghapus';
$string['view_recording_list_action_edit'] = 'Memperbarui';
$string['view_recording_list_action_play'] = 'Mainkan';
$string['view_recording_list_action_process'] = 'Memproses';
$string['view_recording_list_action_protect'] = 'Melindungi';
$string['view_recording_list_action_publish'] = 'Penerbitan';
$string['view_recording_list_action_unprotect'] = 'Buka proteksi';
$string['view_recording_list_action_unpublish'] = 'Membatalkan penerbitan';
$string['view_recording_list_action_update'] = 'Memperbarui';
$string['view_recording_list_actionbar'] = 'Bilah alat';
$string['view_recording_list_actionbar_delete'] = 'Hapus';
$string['view_recording_list_actionbar_edit'] = 'Edit';
$string['view_recording_list_actionbar_hide'] = 'Sembunyikan';
$string['view_recording_list_actionbar_import'] = 'Impor';
$string['view_recording_list_actionbar_protect'] = 'Jadikan pribadi';
$string['view_recording_list_actionbar_publish'] = 'Terbitkan';
$string['view_recording_list_actionbar_show'] = 'Tampilkan';
$string['view_recording_list_actionbar_unprotect'] = 'Jadikan publik';
$string['view_recording_list_actionbar_unpublish'] = 'Batal terbitkan';
$string['view_recording_list_activity'] = 'Aktivitas';
$string['view_recording_list_course'] = 'Kursus';
$string['view_recording_list_date'] = 'Tanggal';
$string['view_recording_list_description'] = 'Deskripsi';
$string['view_recording_list_duration'] = 'Durasi';
$string['view_recording_list_recording'] = 'Merekam';
$string['view_recording_meeting'] = 'Rapat';
$string['view_recording_modal_button'] = 'Terapkan';
$string['view_recording_modal_title'] = 'Tetapkan nilai untuk perekaman';
$string['view_recording_name'] = 'Nama';
$string['view_recording_name_edithint'] = 'Nama dapat ditambahkan untuk membantu mengidentifikasi rekaman.';
$string['view_recording_name_editlabel'] = 'Edit nama';
$string['view_recording_playback'] = 'Pemutaran';
$string['view_recording_preview'] = 'Pratinjau';
$string['view_recording_preview_help'] = 'Arahkan kursor ke gambar untuk melihatnya dalam ukuran penuh';
$string['view_recording_protect_confirmation'] = 'Apakah Anda yakin untuk melindungi {$a} ini?';
$string['view_recording_protect_confirmation_warning_p'] = 'Rekaman ini memiliki {$a} tautan terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman dilindungi, itu juga akan memengaruhi tautan yang diimpor.';
$string['view_recording_protect_confirmation_warning_s'] = 'Rekaman ini memiliki {$a} tautan yang terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman dilindungi, itu juga akan memengaruhi tautan yang diimpor.';
$string['view_recording_publish_confirmation'] = 'Apakah Anda yakin untuk menerbitkan {$a} ini?';
$string['view_recording_publish_confirmation_warning_p'] = 'Rekaman ini memiliki {$a} tautan terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman tersebut dipublikasikan, tautan tersebut juga akan dipublikasikan.';
$string['view_recording_publish_confirmation_warning_s'] = 'Rekaman ini memiliki {$a} tautan yang terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman itu diterbitkan, tautan itu juga akan diterbitkan.';
$string['view_recording_publish_link_deleted'] = 'Tautan ini tidak dapat diterbitkan ulang karena rekaman asli tidak ada di server BigBlueButton. Tautan harus dihapus.';
$string['view_recording_publish_link_not_published'] = 'Tautan ini tidak dapat dipublikasikan ulang karena rekaman aslinya tidak dipublikasikan.';
$string['view_recording_recording'] = 'Merekam';
$string['view_recording_select_course'] = 'Pilih kursus terlebih dahulu di menu tarik-turun';
$string['view_recording_tags'] = 'Tag';
$string['view_recording_unprotect_confirmation'] = 'Apakah Anda yakin akan membuka proteksi {$a} ini?';
$string['view_recording_unprotect_confirmation_warning_p'] = 'Rekaman ini memiliki {$a} tautan terkait yang diimpor ke kursus atau aktivitas yang berbeda. Jika rekaman tidak dilindungi, itu juga akan memengaruhi tautan yang diimpor.';
$string['view_recording_unprotect_confirmation_warning_s'] = 'Rekaman ini memiliki {$a} tautan yang terkait yang diimpor ke kursus atau aktivitas yang berbeda. Jika rekaman tidak dilindungi, itu juga akan memengaruhi tautan yang diimpor.';
$string['view_recording_unprotect_link_deleted'] = 'Tautan ini tidak dapat diproteksi karena rekaman asli tidak ada di server BigBlueButton. Tautan harus dihapus.';
$string['view_recording_unprotect_link_not_unprotected'] = 'Tautan ini tidak dapat diproteksi karena rekaman asli dilindungi.';
$string['view_recording_unpublish_confirmation'] = 'Apakah Anda yakin untuk membatalkan penerbitan {$a} ini?';
$string['view_recording_unpublish_confirmation_warning_p'] = 'Rekaman ini memiliki {$a} tautan terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman tidak dipublikasikan, tautan tersebut juga tidak akan dipublikasikan';
$string['view_recording_unpublish_confirmation_warning_s'] = 'Rekaman ini memiliki {$a} tautan yang terkait yang diimpor dalam kursus atau aktivitas yang berbeda. Jika rekaman tidak dipublikasikan, tautan itu juga tidak akan dipublikasikan.';
$string['view_recording_yui_first'] = 'Pertama';
$string['view_recording_yui_go'] = 'Jalankan';
$string['view_recording_yui_last'] = 'Terakhir';
$string['view_recording_yui_next'] = 'Selanjutnya';
$string['view_recording_yui_page'] = 'Halaman';
$string['view_recording_yui_prev'] = 'Sebelumnya';
$string['view_recording_yui_rows'] = 'Baris';
$string['view_recording_yui_show_all'] = 'Tampilkan semua';
$string['view_room'] = 'Lihat ruangan';
$string['view_section_title_presentation'] = 'Berkas presentasi';
$string['view_section_title_recordings'] = 'Perekaman';
$string['view_warning_default_server'] = 'Situs ini menggunakan <a href="https://bigbluebutton.org/free-bigbluebutton-service-for-moodle/" target="_blank">layanan BigBlueButton gratis untuk Moodle (terbuka di jendela baru)
</a> disediakan oleh Blindside Networks dengan batasan sebagai berikut:
<ol>
<li>Durasi maksimum untuk setiap sesi adalah 60 menit</li>
<li>Jumlah maksimum pengguna serentak per sesi adalah 25</li>
<li>Rekaman kedaluwarsa setelah tujuh (7) hari dan tidak dapat diunduh</li> <li>Webcam siswa hanya dapat dilihat oleh moderator.</li>
</ol>';
$string['waitformoderator'] = 'Menunggu moderator untuk bergabung.';
