<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'lesson', language 'ru', version '4.4'.
 *
 * @package     lesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accesscontrol'] = 'Контроль доступа';
$string['actionaftercorrectanswer'] = 'Действие после правильного ответа';
$string['actionaftercorrectanswer_help'] = 'После правильного ответа на вопрос, существует 3 варианта действия при переходе к следующей странице:

* Обычное - согласно пути лекции
* Показать непросмотренные страницы - страницы отображаются в случайном порядке; показанные ранее страницы не отображаются.
* Показать страницы с пропущенным ответом - страницы отображаются в случайном порядке; повторно отображаются страницы, содержащие оставшиеся без ответа вопросы.';
$string['actions'] = 'Действия';
$string['activitylink'] = 'Ссылка на следующий элемент курса';
$string['activitylink_help'] = 'Чтобы по окончании лекции предложить студенту переход к другому элементу этого курса, выберите этот элемент курса в выпадающем списке.';
$string['activitylinkname'] = 'Перейти к: {$a}';
$string['activityoverview'] = 'У Вас есть непройденные лекции';
$string['addabranchtable'] = 'Добавить информационную страницу / оглавление раздела';
$string['addanendofbranch'] = 'Добавить Конец раздела';
$string['addanewpage'] = 'Добавить новую страницу';
$string['addaquestionpage'] = 'Добавить страницу с вопросом';
$string['addaquestionpagehere'] = 'Добавить сюда Страницу с вопросом';
$string['addbranchtable'] = 'Добавить информационную страницу / оглавление раздела';
$string['addcluster'] = 'Добавить кластер';
$string['addedabranchtable'] = 'Добавлена информационная страница / оглавление раздела';
$string['addedanendofbranch'] = 'Добавлен конец раздела';
$string['addedaquestionpage'] = 'Добавлена страница с вопросом';
$string['addedcluster'] = 'Добавлен кластер';
$string['addedendofcluster'] = 'Добавлен конец кластера';
$string['addendofbranch'] = 'Добавить Конец раздела';
$string['addendofcluster'] = 'Добавить конец кластера';
$string['addessay'] = 'Создать страницу с вопросом типа «Эссе»';
$string['addmatching'] = 'Создать страницу с вопросом типа «На соответствие»';
$string['addmultichoice'] = 'Создать страницу с вопросом типа «Множественный выбор»';
$string['addnewgroupoverride'] = 'Добавить переопределение для группы';
$string['addnewuseroverride'] = 'Добавить переопределение для пользователя';
$string['addnumerical'] = 'Создать страницу с вопросом типа «Числовой ответ»';
$string['addpage'] = 'Добавить страницу';
$string['addshortanswer'] = 'Создать страницу с вопросом типа «Короткий ответ»';
$string['addtruefalse'] = 'Создать страницу с вопросом типа «Верно/неверно»';
$string['allotheranswers'] = 'Все остальные ответы';
$string['allotheranswersjump'] = 'Переход для всех остальных ответов';
$string['allotheranswersscore'] = 'Балл для всех остальных ответов';
$string['allowofflineattempts'] = 'Разрешить прохождение лекции в автономном режиме с помощью мобильного приложения';
$string['allowofflineattempts_help'] = 'Если параметр включен, то пользователь мобильного приложения сможет загрузить лекцию и пройти ее даже при отсутствии соединения. При этом также окажутся загруженными все возможные (в том числе и правильные) ответы. Обратите внимание, невозможно разрешить прохождения лекции в автономном режиме, если для нее задано ограничение по времени.';
$string['anchortitle'] = 'Начало основного содержимого';
$string['and'] = 'И';
$string['answer'] = 'Ответ';
$string['answeredcorrectly'] = 'ответили правильно';
$string['answersfornumerical'] = 'Ответы для числового вопроса сравниваются с парой, состоящей из минимального и максимального значения';
$string['arrangebuttonshorizontally'] = 'Расположить кнопки горизонтально?';
$string['attempt'] = 'Попытка: {$a}';
$string['attemptheader'] = 'Попытка';
$string['attemptinfonograde'] = '{$a->timestart} ({$a->duration})';
$string['attemptinfowithgrade'] = '{$a->grade}% {$a->timestart} ({$a->duration})';
$string['attempts'] = 'Попытки';
$string['attemptsdeleted'] = 'Удаленные попытки';
$string['attemptsremaining'] = 'У вас осталось {$a} попыток';
$string['available'] = 'Лекция доступна с';
$string['averagescore'] = 'Средний балл';
$string['averagetime'] = 'Среднее время';
$string['branch'] = 'Содержимое';
$string['branchtable'] = 'Список разделов';
$string['cachedef_overrides'] = 'Информация о переопределении пользователя и группы';
$string['cancel'] = 'Отменить';
$string['cannotfindanswer'] = 'Ошибка: ответ не найден';
$string['cannotfindattempt'] = 'Ошибка: попытка не найдена';
$string['cannotfindessay'] = 'Ошибка: не удалось найти эссе';
$string['cannotfindfirstgrade'] = 'Ошибка: не удалось найти оценки';
$string['cannotfindfirstpage'] = 'Невозможно найти первую страницу';
$string['cannotfindgrade'] = 'Ошибка: не удалось найти оценки';
$string['cannotfindnewestgrade'] = 'Ошибка: не удалось найти новую оценку';
$string['cannotfindnextpage'] = 'Резервная копия лекции: следующая страница не найдена!';
$string['cannotfindpagerecord'] = 'Добавить конец раздела: запись страницы не найдена';
$string['cannotfindpages'] = 'Не удалось найти страницы лекции';
$string['cannotfindpagetitle'] = 'Подтвердить удаление: заголовок страницы не найден';
$string['cannotfindpreattempt'] = 'Запись предыдущих попыток не может быть найдена!';
$string['cannotfindrecords'] = 'Ошибка: не удалось найти записи лекции';
$string['cannotfindtimer'] = 'Ошибка: не удалось найти записи таймера лекции';
$string['cannotfinduser'] = 'Ошибка: не удалось найти пользователей';
$string['canretake'] = 'Разрешены переэкзаменовки';
$string['casesensitive'] = 'Использовать регулярные выражения';
$string['casesensitive_help'] = 'При включении этого параметра можно будет указывать регулярные выражения для проверки ответов.';
$string['checkbranchtable'] = 'Проверить информационную страницу / оглавление раздела';
$string['checkedthisone'] = 'Выбрали этот ответ.';
$string['checknavigation'] = 'Испытать навигацию';
$string['checkquestion'] = 'Испытать карточку вопроса';
$string['classstats'] = 'Статистика класса';
$string['clicktodownload'] = 'Щелкните по следующей ссылке, чтобы загрузить файл';
$string['closebeforeopen'] = 'Невозможно обновить лекцию. Вы указали дату завершения до даты начала.';
$string['cluster'] = 'Кластер';
$string['clusterjump'] = 'Непросмотренный вопрос в кластере';
$string['clustertitle'] = 'Кластер';
$string['collapsed'] = 'Свернуто';
$string['comments'] = 'Ваши комментарии';
$string['completed'] = 'Лекция завершена';
$string['completederror'] = 'Завершить лекцию';
$string['completethefollowingconditions'] = 'Вы должны выполнить следующие условия в лекции <b>{$a}</b> перед тем, как сможете продолжить.';
$string['completiondetail:reachend'] = 'Пройти лекцию до конца';
$string['completiondetail:timespent'] = 'Провести в этой лекции не менее {$a}.';
$string['completionendreached'] = 'Необходимо достичь конца';
$string['completionendreached_desc'] = 'Студент должен дойти до страницы конца лекции, чтобы завершить этот элемент';
$string['completiontimespent'] = 'Студент должен изучать этот элемент не менее';
$string['completiontimespentdesc'] = 'Студент должен работать с этим элементом курса по меньшей мере {$a}';
$string['completiontimespentgroup'] = 'Требуемое время прошло';
$string['conditionsfordependency'] = 'Условия для зависимости';
$string['configintro'] = 'Заданные здесь значения определяют значения по умолчанию, которые будут использоваться в форме настроек при создании нового элемента «Лекция». Настройки, которые указаны как расширенные, показываются только при щелчке на ссылке «Показать больше...».';
$string['configmaxanswers'] = 'По умолчанию максимальное количество ответов на страницу';
$string['configmediaclose'] = 'Отображает кнопку закрытия всплывающего окна, созданного для связанного медиа-файла';
$string['configmediaheight'] = 'Устанавливает высоту всплывающего окна, в котором отображается  связанный медиа-файл';
$string['configmediawidth'] = 'Устанавливает ширину всплывающего окна, в котором отображается  связанный медиа-файл';
$string['configpassword_desc'] = 'Нужно ли вводить пароль, чтобы получить доступ к лекции.';
$string['configslideshowbgcolor'] = 'Цвет фона для слайд-шоу, если оно включено';
$string['configslideshowheight'] = 'Устанавливает высоту слайд-шоу, если оно включено';
$string['configslideshowwidth'] = 'Устанавливает ширину слайд-шоу, если оно включено';
$string['configtimelimit_desc'] = 'Если задан лимит времени, то в начале лекции будет показано предупреждение и таймер, ведущий обратный отсчет. Если значение равно 0, то лимита времени нет.';
$string['confirmdelete'] = 'Удалить страницу';
$string['confirmdeletionofthispage'] = 'Подтвердите удаление этой страницы';
$string['congratulations'] = 'Поздравления - лекция завершена';
$string['continue'] = 'Продолжить';
$string['continuetoanswer'] = 'Продолжить изменение ответов.';
$string['continuetonextpage'] = 'Перейти к следующей странице';
$string['correctanswerjump'] = 'Переход при правильном ответе:';
$string['correctanswerscore'] = 'Баллы за правильный ответ';
$string['correctresponse'] = 'Комментарий на правильный ответ';
$string['createaquestionpage'] = 'Создать страницу с вопросом';
$string['credit'] = 'Начислять';
$string['customscoring'] = 'Баллы за каждый вариант ответа';
$string['customscoring_help'] = 'При включенном параметре для каждого ответа можно ввести целое значение оценки (положительное или отрицательное).';
$string['deadline'] = 'Крайний срок сдачи';
$string['defaultessayresponse'] = 'Ваше эссе будет оценено преподавателем курса.';
$string['deleteallattempts'] = 'Удалить все попытки пройти лекцию';
$string['deletedefaults'] = 'Удалено {$a} умолчаний урока';
$string['deletedpage'] = 'Страница удалена';
$string['deletepagenamed'] = 'Удалить страницу: {$a}';
$string['deleting'] = 'Удаление';
$string['deletingpage'] = 'Удаление страницы: {$a}';
$string['dependencyon'] = 'Эта лекция зависит от';
$string['dependencyon_help'] = 'Этот параметр позволяет ограничить доступ к этой лекции в зависимости от результата студента в другой лекции этого курса. Может быть использована любая комбинация из параметров «Затраченное время», «Лекция завершена» или «Оценка выше, чем...»';
$string['description'] = 'Описание';
$string['deselectallattempts'] = 'Отменить выбор всех попыток';
$string['detailedstats'] = 'Подробная статистика';
$string['didnotanswerquestion'] = 'Студент не ответил на этот вопрос.';
$string['didnotreceivecredit'] = 'Баллы не начислены';
$string['disabled'] = 'Отключено';
$string['displaydefaultfeedback'] = 'Использовать комментарий по умолчанию';
$string['displaydefaultfeedback_help'] = 'Если параметр включен, то при выборе конкретного ответа (в случае отсутствия комментария к нему) будет показан комментарий по умолчанию - «Это правильный ответ» или «Это неправильный ответ».';
$string['displayinleftmenu'] = 'Показывать в меню?';
$string['displayleftif'] = 'Минимальная оценка для отображения меню лекции';
$string['displayleftif_help'] = 'Этот параметр определяет, должен ли студент получить определенную оценку, чтобы увидеть меню лекции. Это можно использовать для того, чтобы при первой попытке студент обязательно прошёл всю лекцию, а затем, после получения необходимой оценки, он мог воспользоваться меню при повторном просмотре.';
$string['displayleftmenu'] = 'Показывать меню';
$string['displayleftmenu_help'] = 'При включенном параметре будет отображаться меню, с помощью которого пользователи смогут перемещаться по списку страниц.';
$string['displaymode'] = 'Режим отображения';
$string['displayofgrade'] = 'Показать оценки (только для студентов)';
$string['displayreview'] = 'Давать возможность повторно ответить на вопрос';
$string['displayreview_help'] = 'При включении этого параметра после каждого неправильного ответа студенту будет предложено либо попробовать ответить на вопрос ещё раз (уже без получения баллов) либо просто продолжить лекцию. Если студент нажмет кнопку перехода к другому вопросу, будет оставлен выбранный (неправильный) ответ. По умолчанию неправильный ответ имеет оценку 0 и переход установлен на «текущую страницу», поэтому рекомендуется изменить настройки перехода при неправильном ответе на другую страницу, чтобы не запутать студентов.';
$string['displayscorewithessays'] = '<p>Вы получили {$a->score} баллов из {$a->tempmaxgrade} за вопросы, оцененные автоматически.</p>
<p> Оценки за {$a->essayquestions} эссе будут поставлены и учтены позднее при выставлении итоговой оценки.</p>
<p>Ваша текущая оценка (без учета эссе): {$a->score} из {$a->grade}</p>.';
$string['displayscorewithoutessays'] = 'Оценка за ответы на вопросы: {$a->score} из {$a->grade}';
$string['duplicatepagenamed'] = 'Дублировать страницу: {$a}';
$string['edit'] = 'Редактировать';
$string['editbranchtable'] = 'Редактирование информационной страницы / оглавления раздела';
$string['editcluster'] = 'Редактирование кластера';
$string['editendofbranch'] = 'Редактирование страницы конца раздела';
$string['editendofcluster'] = 'Редактирование страницы конца кластера';
$string['editessay'] = 'Редактирование страницы с вопросом типа «Эссе»';
$string['editinglesson'] = 'Редактирование лекции';
$string['editingquestionpage'] = 'Редактирование страницы с вопросом {$a}';
$string['editlesson'] = 'Редактировать лекцию';
$string['editlessonsettings'] = 'Редактировать настройки лекции';
$string['editmatching'] = 'Редактирование страницы с вопросом типа «На соответствие»';
$string['editmultichoice'] = 'Редактирование страницы вопроса типа «Множественный выбор»';
$string['editnumerical'] = 'Редактирование страницы с вопросом типа «Числовой ответ»';
$string['editoverride'] = 'Редактировать переопределение';
$string['editpage'] = 'Редактировать информационную страницу / оглавление раздела';
$string['editpagecontent'] = 'Редактировать страницу';
$string['editquestion'] = 'Редактирование страницы с вопросом';
$string['editshortanswer'] = 'Редактирование страницы с вопросом типа «Короткий ответ»';
$string['edittruefalse'] = 'Редактирование страницы с вопросом типа «Верно/неверно»';
$string['email'] = 'Email';
$string['emailallgradedessays'] = 'Разослать уведомления о всех оцененных эссе';
$string['emailgradedessays'] = 'Отправить уведомление об оцененном эссе';
$string['emailsuccess'] = 'Сообщение отправлено';
$string['emptypassword'] = 'Пароль не может быть пустым';
$string['enabled'] = 'Включено';
$string['endofbranch'] = 'Конец раздела';
$string['endofcluster'] = 'Конец кластера';
$string['endofclustertitle'] = 'Конец кластера';
$string['endoflesson'] = 'Конец лекции';
$string['enteredthis'] = 'ввели это.';
$string['enterpassword'] = 'Пожалуйста, введите пароль:';
$string['eolstudentoutoftime'] = 'Внимание! Время прохождения лекции закончилось, поэтому Ваш последний ответ мог быть не учтен, если Вы ответили на вопрос за пределами отпущенного времени.';
$string['eolstudentoutoftimenoanswers'] = 'Вы не ответили ни на один вопрос. Вы получили 0 за эту лекцию.';
$string['essay'] = 'Эссе';
$string['essayemailmessage2'] = '<p> Задание на эссе: <{$a->question}</p><p> Ваш ответ: <em>{$a->response}</em></p><p> Комментарии оценщика: <em>{$a->comment}</em></p><p> Вы получили {$a->earned} из {$a->outof} за это эссе.</p><p> Ваша оценка за лекцию «{$a->lesson}» была изменена на {$a->newgrade}%. </p>';
$string['essayemailmessagesmall'] = '<p> Вы получили {$a->earned} из {$a->outof} за это эссе. </p> <p> Ваша оценка за {$a->lesson} была изменена на {$a->newgrade}%. </p>';
$string['essayemailsubject'] = 'Есть оценка за ответ на вопрос лекции';
$string['essaynotgradedyet'] = 'Это эссе еще не оценено';
$string['essayresponses'] = 'Ответы эссе';
$string['essays'] = 'Эссе';
$string['essayscore'] = 'Баллы за эссе';
$string['eventcontentpageviewed'] = 'Содержимое страницы просмотрено';
$string['eventessayassessed'] = 'Эссе оценено';
$string['eventessayattemptviewed'] = 'Ответ на задание типа «Эссе» просмотрен';
$string['eventhighscoreadded'] = 'Высшие баллы добавлены';
$string['eventhighscoresviewed'] = 'Высшие баллы просмотрены';
$string['eventlessonended'] = 'Лекция закончена';
$string['eventlessonrestarted'] = 'Лекция начата заново';
$string['eventlessonresumed'] = 'Лекция продолжена';
$string['eventlessonstarted'] = 'Лекция начата';
$string['eventoverridecreated'] = 'Переопределение лекции создано';
$string['eventoverridedeleted'] = 'Переопределение лекции удалено';
$string['eventoverrideupdated'] = 'Переопределение лекции обновлено';
$string['eventpagecreated'] = 'Страница создана';
$string['eventpagedeleted'] = 'Страница удалена';
$string['eventpagemoved'] = 'Страница перемещена';
$string['eventpageupdated'] = 'Страница обновлена';
$string['eventquestionanswered'] = 'Дан ответ на вопрос';
$string['eventquestionviewed'] = 'Вопрос просмотрен';
$string['false'] = 'Неверно';
$string['fileformat'] = 'Формат файла';
$string['finalwrong'] = 'Не полностью';
$string['finish'] = 'Завершить';
$string['firstanswershould'] = 'Первый ответ должен переводить на «правильную» страницу';
$string['firstwrong'] = 'Вы ответили неправильно. Хотите снова попробовать ответить на вопрос? (Даже в случае верного ответа его результат не будет засчитан в Вашей итоговой оценке.)';
$string['flowcontrol'] = 'Контроль прохождения';
$string['fractionsaddwrong'] = 'Положительные оценки в сумме не составляют 100%. <br />Их сумма {$a}%.<br /> Вы хотите вернуться и исправить этот вопрос?';
$string['fractionsnomax'] = 'Один из ответов должен быть оценен в 100%, чтобы за этот вопрос можно было получить оценку. Вы хотите вернуться и исправить вопрос?';
$string['full'] = 'Развернуто';
$string['general'] = 'Общие';
$string['gotoendoflesson'] = 'Перейти к концу лекции';
$string['grade'] = 'Оценка';
$string['gradebetterthan'] = 'Оценка выше, чем (%)';
$string['gradebetterthanerror'] = 'Получить оценку выше, чем {$a} процентов.';
$string['graded'] = 'Оценено';
$string['gradeessay'] = 'Оценить эссе ({$a->notgradedcount} не оценены и {$a->notsentcount} не отправлены)';
$string['gradeis'] = 'Оценка: {$a}';
$string['gradeoptions'] = 'Параметры выставления оценки';
$string['groupoverrides'] = 'Переопределения группы';
$string['groupoverridesdeleted'] = 'Переопределения группы удалены';
$string['groupsnone'] = 'Нет групп, к которым вы можете получить доступ.';
$string['handlingofretakes'] = 'Обработка результатов попыток';
$string['handlingofretakes_help'] = 'Если повторно прохождение лекции разрешено, то этот параметр определяет, будет ли оценка за лекцию средней или максимальной из оценок за все попытки.';
$string['havenotgradedyet'] = 'Пока не оценено.';
$string['here'] = 'здесь';
$string['highscore'] = 'Высший результат';
$string['hightime'] = 'Наибольшее время';
$string['importcount'] = 'Импортировано вопросов: {$a}';
$string['importquestions'] = 'Импортировать вопросы';
$string['importquestions_help'] = 'Эта функция позволяет из внешнего текстового файла импортировать вопросы в различных форматах.';
$string['inactiveoverridehelp'] = '* Это переопределение неактивно, поскольку доступ пользователя к лекции ограничен. Это может быть связано с назначением групп или ролей, другими ограничениями доступа или скрытой лекцией.';
$string['indicator:cognitivedepth'] = 'Лекция: познавательный аспект';
$string['indicator:cognitivedepth_help'] = 'Этот показатель основан на глубине познания, достигнутой студентом при работе с элементом курса «Лекция».';
$string['indicator:cognitivedepthdef'] = 'Лекция: познавательный аспект';
$string['indicator:cognitivedepthdef_help'] = 'Участник достиг этого процента познавательного взаимодействия, предлагаемого элементом курса «Лекция» в течение этого интервала анализа (Уровни = Нет просмотра, Просмотр, Отправка, Просмотр отзыва, Комментарий на отзыв, Повторная отправка после просмотра отзыва)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Лекция: социальный аспект';
$string['indicator:socialbreadth_help'] = 'Этот показатель основан на широте общения, которая может быть достигнута студентом при работе с элементом Лекция.';
$string['indicator:socialbreadthdef'] = 'Лекция: социальный аспект';
$string['indicator:socialbreadthdef_help'] = 'Участник достиг этого процента социальной активности, предлагаемой элементами Лекция в течение этого интервала анализа (Уровни = нет участия, единственный участник, участник с другими)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['insertedpage'] = 'Страница вставлена';
$string['invalidfile'] = 'Неверный файл';
$string['invalidid'] = 'Не был указан ID модуля или ID лекции';
$string['invalidlessonid'] = 'ID лекции некорректен';
$string['invalidoverrideid'] = 'Неправильный идентификатор переопределения';
$string['invalidpageid'] = 'Неверный ID страницы';
$string['jump'] = 'Переход';
$string['jumps'] = 'Переходы';
$string['jumps_help'] = 'Каждый ответ (для вопросов) или описание (для страниц содержания) имеет соответствующий переход. Переход может быть относительным, например «текущая страница» или «следующая страница», или абсолютным, указывающим на любую из страниц лекции.';
$string['jumpsto'] = 'Переход к <em>{$a}</em>';
$string['leftduringtimed'] = 'Вы просрочили время, отведенное на прохождение лекции. <br/> Щелкните по кнопке «Продолжить», чтобы начать лекцию заново.';
$string['leftduringtimednoretake'] = 'Вы просрочили время, отведенное на прохождение лекции и не можете продолжить её или пройти заново.';
$string['leftduringtimedsession'] = 'Вы просрочили время, отведенное на прохождение лекции';
$string['lesson:addinstance'] = 'Добавить новую лекцию';
$string['lesson:edit'] = 'Редактировать лекцию';
$string['lesson:grade'] = 'Оценивать  в лекции ответы на вопросы эссе';
$string['lesson:manage'] = 'Управлять лекцией';
$string['lesson:manageoverrides'] = 'Управлять переопределениями лекции';
$string['lesson:view'] = 'Видеть лекцию';
$string['lesson:viewreports'] = 'Просматривать отчеты лекции';
$string['lessonbeingpreviewed'] = 'В настоящее время лекция находится в режиме предварительного просмотра.';
$string['lessonclosed'] = 'Эта лекция закрылась {$a}.';
$string['lessoncloses'] = 'Лекция закрывается';
$string['lessoneventcloses'] = '{$a} закрывается';
$string['lessoneventopens'] = '{$a} открывается';
$string['lessonformating'] = 'Форматирование лекции';
$string['lessonmenu'] = 'Меню лекции';
$string['lessonnotready'] = 'Лекция не готова. Пожалуйста, свяжитесь с {$a}';
$string['lessonnotready2'] = 'Эта лекция ещё не готова к просмотру.';
$string['lessonopen'] = 'Эта лекция откроется {$a}';
$string['lessonopens'] = 'Лекция открывается';
$string['lessonpagelinkingbroken'] = 'Первая страница не найдена. Вероятно, связи страниц лекции нарушены. Пожалуйста, свяжитесь с администратором.';
$string['lessonstats'] = 'Статистика лекции';
$string['linkedmedia'] = 'Связанное медиа';
$string['loginfail'] = 'Логин неверный, пожалуйста, попробуйте еще раз...';
$string['lowscore'] = 'Низший балл';
$string['lowtime'] = 'Наименьшее время';
$string['manageoverrides'] = 'Управление переопределениями';
$string['manualgrading'] = 'Оценить эссе';
$string['matchesanswer'] = 'Соответствие для ответа';
$string['matching'] = 'На соответствие';
$string['matchingpair'] = 'Соответствующие пары {$a}';
$string['maxgrade'] = 'Максимальная оценка';
$string['maxgrade_help'] = 'Этот параметр определяет максимальную оценку за лекцию в диапазоне от 0 до 100%. Если значение параметра установлено в 0, то лекция не отображается на страницах, содержащих оценки.';
$string['maximumnumberofanswersbranches'] = 'Максимальное количество ответов/переходов';
$string['maximumnumberofanswersbranches_help'] = 'Этот параметр определяет максимальное число ответов, которое может быть использовано на страницах лекции. Например, если используются только вопросы типа «Верно/неверно», то можно установить значение 2. Этот параметр можно изменять в любое время, так как он влияет только на представление для преподавателя, на ранее введенные данные он не влияет.';
$string['maximumnumberofattempts'] = 'Максимальное количество попыток ответа на вопрос';
$string['maximumnumberofattempts_help'] = 'Этот параметр определяет максимальное разрешенное количество попыток ответа на каждый вопрос. При неоднократном неправильном ответе и достижении максимума, отображается следующая страница лекции.';
$string['maximumnumberofattemptsreached'] = 'Достигнуто максимальное количество попыток - переходим к следующей странице';
$string['mediaclose'] = 'Показать кнопку закрытия';
$string['mediafile'] = 'Связанные медиа';
$string['mediafile_help'] = 'Файл медиа может быть загружен для использования в лекции. Ссылка «Щелкните здесь для просмотра» будет затем показываться на каждой странице лекции в блоке «Связанные медиа».';
$string['mediafilepopup'] = 'Щелкните здесь для просмотра.';
$string['mediaheight'] = 'Высота всплывающего окна';
$string['mediawidth'] = 'Ширина всплывающего окна';
$string['messageprovider:graded_essay'] = 'Уведомление об оценке эссе в лекции';
$string['minimumnumberofquestions'] = 'Минимальное количество вопросов';
$string['minimumnumberofquestions_help'] = 'Этот параметр определяет минимальное количество вопросов, которые будут использоваться для расчета оценки.';
$string['missingname'] = 'Пожалуйста, введите имя';
$string['modattempts'] = 'Разрешить студентам повторный просмотр';
$string['modattempts_help'] = 'При включении этого параметра студенты могут снова пересмотреть лекцию с самого начала.';
$string['modattemptsnoteacher'] = 'Только студенты могут повторно проходить лекцию.';
$string['modulename'] = 'Лекция';
$string['modulename_help'] = 'Элемент курса «Лекция» позволяет преподавателю располагать контент и/или практические задания (тесты) в интересной и гибкой форме. Преподаватель может использовать линейную схему лекции, состоящую из ряда обучающих страниц или создать сложную схему, которая содержит различные пути или варианты для учащегося. В любом случае для увеличения активного взаимодействия и контроля понимания преподаватели могут использовать различные вопросы, такие как «Множественный выбор», «На соответствие» и «Короткий ответ». В зависимости от выбранного студентом ответа и стратегии, разработанной преподавателем, студенты могут перейти на другую страницу, возвратиться на предыдущую страницу или быть перенаправленными совершенно по другому пути.

Лекцию можно оценивать, оценки записываются в журнал оценок.

Лекции могут быть использованы

* Для самостоятельного изучения новой темы
* Для сценариев или упражнений по моделированию/принятию решений
* Для различающегося контроля, с разными наборами вопросов в зависимости от ответов на первые вопросы.';
$string['modulename_link'] = 'mod/lesson/view';
$string['modulenameplural'] = 'Лекции';
$string['move'] = 'Переместить страницу';
$string['movedpage'] = 'Страница';
$string['movepagehere'] = 'Переместить страницу сюда';
$string['movepagenamed'] = 'Переместить страницу: {$a}';
$string['moving'] = 'Переместить страницу: {$a}';
$string['multianswer'] = 'Множественный ответ';
$string['multianswer_help'] = 'Установите флажок, если есть более одного варианта правильного ответа.';
$string['multichoice'] = 'Множественный выбор';
$string['multipleanswer'] = 'Множественный ответ';
$string['nameapproved'] = 'Имя принято';
$string['namereject'] = 'Извините, выбранное Вами имя не может быть принято. <br/> Попробуйте ввести другое имя.';
$string['new'] = 'новый';
$string['nextpage'] = 'Следующая страница';
$string['noanswer'] = 'На один или несколько вопросов не получено ответа. Пожалуйста, вернитесь и представьте ответ.';
$string['noattemptrecordsfound'] = 'Записи о попытках не найдены: Нет полученных оценок';
$string['nobranchtablefound'] = 'Не найдены информационные страницы / оглавления разделов';
$string['noclose'] = 'Нет даты завершения';
$string['nocommentyet'] = 'Пока комментариев нет.';
$string['nocoursemods'] = 'Элементы курса не найдены';
$string['nocredit'] = 'Не начислять';
$string['nodeadline'] = 'Нет сроков';
$string['noessayquestionsfound'] = 'В этой лекции нет вопросов типа «Эссе»';
$string['nohighscores'] = 'Нет высоких результатов.';
$string['nolessonattempts'] = 'Не было попыток пройти лекцию.';
$string['nolessonattemptsgroup'] = 'В этой лекции члены группы ({$a}) не сделали ни одной попытки.';
$string['none'] = 'Нет';
$string['nooneansweredcorrectly'] = 'Никто не ответил правильно на этот вопрос.';
$string['nooneansweredthisquestion'] = 'Никто не ответил на этот вопрос.';
$string['noonecheckedthis'] = 'Никто не выбрал этот ответ.';
$string['nooneenteredthis'] = 'Никто не ввёл этот текст.';
$string['noonehasanswered'] = 'Никто еще не написал эссе.';
$string['noonehasansweredgroup'] = 'Никто из группы {$a} еще не ответил на вопрос эссе.';
$string['noopen'] = 'Нет даты открытия';
$string['nooverridecreated'] = 'Переопределения не созданы.';
$string['nooverridedata'] = 'Вы должны переопределить по крайней мере одну из настроек лекции.';
$string['noretake'] = 'Вы не можете пройти заново эту лекцию.';
$string['normal'] = 'Обычное - согласно пути лекции';
$string['notcompleted'] = 'Лекция не завершена';
$string['notcompletedwithdate'] = 'Не завершено ({$a})';
$string['notdefined'] = 'Не определено';
$string['notenoughsubquestions'] = 'Было указано недостаточное количество подвопросов!<br />Вы хотите вернуться к редактированию вопроса?';
$string['notenoughtimespent'] = 'Вы завершили эту лекцию за {$a->timespent}, что меньше требуемого времени {$a->timerequired}. Возможно, Вам нужно попытаться пройти лекцию снова.';
$string['notgraded'] = 'Не оценено';
$string['notitle'] = 'Без заголовка';
$string['notyetcompleted'] = 'Лекция была начата, но еще не завершена';
$string['numberofcorrectanswers'] = 'Количество правильных ответов: {$a}';
$string['numberofcorrectanswersheader'] = 'Количество правильных ответов';
$string['numberofcorrectmatches'] = 'Количество правильных соответствий: {$a}';
$string['numberofpagestoshow'] = 'Количество показываемых страниц';
$string['numberofpagestoshow_help'] = 'Этот параметр определяет количество страниц, отображаемых в лекции. Он применим только для лекций со страницами, отображаемыми в случайном порядке (когда параметр «Действие после правильного ответа»  установлен на «Показать непросмотренные страницы»  или «Показать страницы с пропущенным ответом»). Если параметр равен нулю, то все страницы отображаются.';
$string['numberofpagesviewed'] = 'Количество просмотренных страниц : {$a}';
$string['numberofpagesviewedheader'] = 'Количество вопросов, на которые был дан ответ';
$string['numberofpagesviewednotice'] = 'Количество вопросов, на которые дан ответ: {$a->nquestions} (Вы должны ответить минимум на {$a->minquestions})';
$string['numerical'] = 'Числовой ответ';
$string['numericanswer'] = 'Числовой ответ';
$string['numericanswer_help'] = 'Вы можете указать одно число или диапазон чисел с помощью двоеточия. Например, 2:5 означает, что любой ответ от 2 до 5 (включая 2 и 5) правильный.';
$string['offlinedatamessage'] = 'Вы использовали эту попытку с помощью мобильного устройства. Данные были сохранены на этом сайте ранее ({$a}). Убедитесь, что у Вас нет несохраненной работы.';
$string['ongoing'] = 'Отображать текущий балл';
$string['ongoing_help'] = 'При включении этого параметра студент будет видеть на каждой странице количество полученных баллов из максимума возможных на текущий момент.';
$string['ongoingcustom'] = 'К настоящему времени Вы заработали баллов: {$a->score}  из {$a->currenthigh} возможных.';
$string['ongoingnormal'] = 'Вы ответили правильно на {$a->correct} вопрос(ов) из {$a->viewed} просмотренных.';
$string['onpostperpage'] = 'Только одна проводка каждой оценки';
$string['openafterclose'] = 'Вы указали дату открытия после даты закрытия';
$string['options'] = 'Параметры';
$string['or'] = 'ИЛИ';
$string['ordered'] = 'Упорядоченно';
$string['other'] = 'Другие параметры';
$string['outof'] = 'Из {$a}';
$string['override'] = 'Переопределить';
$string['overridedeletegroupsure'] = 'Вы уверены, что хотите удалить переопределение для группы {$a}?';
$string['overridedeleteusersure'] = 'Вы уверены, что хотите удалить переопределение для пользователя {$a}?';
$string['overridegroup'] = 'Переопределить группу';
$string['overridegroupeventname'] = '{$a->lesson} - {$a->group}';
$string['overrides'] = 'Переопределения';
$string['overrideuser'] = 'Переопределить пользователя';
$string['overrideusereventname'] = '{$a->lesson}} - Переопределить';
$string['overview'] = 'Обзор';
$string['overview_help'] = 'Лекция состоит из нескольких страниц и, возможно, оглавлений разделов. Страница содержит некоторую информацию и, обычно, заканчивается вопросом. Каждый ответ на вопрос связан с переходом. Переход может быть относительным (например, «Текущая страница» или «Следующая страница») или абсолютным (с указанием любой из страниц лекции). Оглавление раздела - это страница лекции, содержащая набор ссылок (например, оглавление) на другие страницы.';
$string['page'] = 'Страница: {$a}';
$string['page-mod-lesson-edit'] = 'Редактировать страницу лекции';
$string['page-mod-lesson-view'] = 'Просмотр или предпросмотр страницы лекции';
$string['page-mod-lesson-x'] = 'Любая страница лекции';
$string['pageanswers'] = 'Страница ответов';
$string['pagecontents'] = 'Содержание страницы';
$string['pageresponses'] = 'Страница отзывов';
$string['pages'] = 'Страницы';
$string['pagetitle'] = 'Заголовок страницы';
$string['password'] = 'Пароль';
$string['passwordprotectedlesson'] = '{$a} - лекция, защищенная паролем';
$string['pleasecheckoneanswer'] = 'Пожалуйста, выберите один ответ';
$string['pleasecheckoneormoreanswers'] = 'Пожалуйста, выберите один или несколько ответов';
$string['pleaseenteryouranswerinthebox'] = 'Пожалуйста, введите свой ответ в поле';
$string['pleasematchtheabovepairs'] = 'Пожалуйста, поставьте в соответствие';
$string['pluginadministration'] = 'Управление лекцией';
$string['pluginname'] = 'Лекция';
$string['pointsearned'] = 'Полученные баллы';
$string['postprocesserror'] = 'Возникла ошибка при заключительной обработке!';
$string['postsuccess'] = 'Публикация успешна';
$string['practice'] = 'Тренировочная лекция';
$string['practice_help'] = 'Тренировочная лекция не отображается в журнале оценок.';
$string['preprocesserror'] = 'Произошла ошибка во время предварительной обработки!';
$string['prerequisiteisobsolete'] = 'Требование предварительного изучения другой лекции должно быть удалено. Используйте вместо него ограничения доступа.';
$string['prerequisitelesson'] = 'Зависимость от другой лекции';
$string['preview'] = 'Просмотр';
$string['previewlesson'] = 'Предпросмотр {$a}';
$string['previewpagenamed'] = 'Предварительный просмотр: {$a}';
$string['previouspage'] = 'Предыдущая страница';
$string['privacy:metadata:attempts'] = 'Запись о страницах с попытками.';
$string['privacy:metadata:attempts:answerid'] = 'ID ответа';
$string['privacy:metadata:attempts:correct'] = 'Была ли попытка правильной';
$string['privacy:metadata:attempts:pageid'] = 'ID страницы';
$string['privacy:metadata:attempts:retry'] = 'Номер попытки';
$string['privacy:metadata:attempts:timeseen'] = 'Время, когда была предпринята попытка';
$string['privacy:metadata:attempts:useranswer'] = 'Подробности об ответе пользователя';
$string['privacy:metadata:attempts:userid'] = 'ID пользователя';
$string['privacy:metadata:branch'] = 'Запись о просмотренных страницах.';
$string['privacy:metadata:branch:flag'] = 'Была ли следующая страница рассчитана случайным образом';
$string['privacy:metadata:branch:nextpageid'] = 'ID следующей страницы';
$string['privacy:metadata:branch:pageid'] = 'ID страницы';
$string['privacy:metadata:branch:retry'] = 'Номер попытки';
$string['privacy:metadata:branch:timeseen'] = 'Время, когда страница была просмотрена';
$string['privacy:metadata:branch:userid'] = 'ID пользователя';
$string['privacy:metadata:grades'] = 'Запись об оценках за каждую лекцию';
$string['privacy:metadata:grades:completed'] = 'Дата выставления оценки';
$string['privacy:metadata:grades:grade'] = 'Выставленная оценка';
$string['privacy:metadata:grades:userid'] = 'ID пользователя';
$string['privacy:metadata:overrides'] = 'Запись о переопределениях в лекции';
$string['privacy:metadata:overrides:available'] = 'Время, когда можно пройти лекцию';
$string['privacy:metadata:overrides:deadline'] = 'Срок окончания лекции.';
$string['privacy:metadata:overrides:maxattempts'] = 'Максимальное количество попыток';
$string['privacy:metadata:overrides:password'] = 'Пароль для доступа к лекции';
$string['privacy:metadata:overrides:retake'] = 'Разрешены ли пересдачи';
$string['privacy:metadata:overrides:review'] = 'Разрешена ли повторная попытка ответа на вопрос';
$string['privacy:metadata:overrides:timelimit'] = 'Ограничение по времени для завершения лекции, в секундах.';
$string['privacy:metadata:overrides:userid'] = 'ID пользователя';
$string['privacy:metadata:timer'] = 'Запись о попытках лекции.';
$string['privacy:metadata:timer:completed'] = 'Завершена ли попытка';
$string['privacy:metadata:timer:lessontime'] = 'Последний момент, когда была зафиксирована активность';
$string['privacy:metadata:timer:starttime'] = 'Дата начала попытки';
$string['privacy:metadata:timer:timemodifiedoffline'] = 'Последний момент, когда мы фиксировали активность из мобильного приложения';
$string['privacy:metadata:timer:userid'] = 'ID пользователя';
$string['privacy:metadata:userpref:lessonview'] = 'Предпочтительный режим отображения при редактировании лекций';
$string['privacy:path:essayanswers'] = 'Ответы Эссе';
$string['privacy:path:essayresponses'] = 'Ответы эссе';
$string['privacy:path:pages'] = 'Страницы';
$string['processerror'] = 'Возникла ошибка при обработке!';
$string['progressbar'] = 'Отображать индикатор выполнения';
$string['progressbar_help'] = 'При включении этого параметра в нижней части страниц лекции будет отображаться индикатор выполнения, показывающий примерный процент завершения лекции.';
$string['progressbarteacherwarning'] = 'Индикатор выполнения не отображается для {$a}';
$string['progressbarteacherwarning2'] = 'Вы не увидите индикатор выполнения, потому что можете редактировать эту лекцию.';
$string['progresscompleted'] = 'Вы прошли {$a}% лекции';
$string['qtype'] = 'Тип страницы';
$string['question'] = 'Вопрос';
$string['questionoption'] = 'Параметр вопроса';
$string['questiontype'] = 'Тип вопроса';
$string['randombranch'] = 'Случайное оглавление разделов';
$string['randompageinbranch'] = 'Страница случайного вопроса из раздела';
$string['rank'] = 'Ранг';
$string['rawgrade'] = 'Предварительная оценка';
$string['receivedcredit'] = 'Баллы начислены';
$string['redisplaypage'] = 'Повторно показать страницу';
$string['removeallgroupoverrides'] = 'Удалить все переопределения групп';
$string['removealluseroverrides'] = 'Удалить все переопределения пользователей';
$string['report'] = 'Отчет';
$string['reports'] = 'Отчеты';
$string['response'] = 'Отзыв';
$string['retakesallowed'] = 'Разрешить повторное прохождение';
$string['retakesallowed_help'] = 'Если параметр включен, то студенты смогут пройти лекцию более одного раза.';
$string['returnto'] = 'Вернуться к {$a}';
$string['returntocourse'] = 'Вернуться к курсу';
$string['reverttodefaults'] = 'Вернуться к настройкам лекции по умолчанию';
$string['review'] = 'Пересмотр';
$string['reviewlesson'] = 'Пересмотр лекции';
$string['reviewquestionback'] = 'Да, мне хотелось бы попробовать еще раз';
$string['reviewquestioncontinue'] = 'Нет, я просто хочу перейти к следующему вопросу';
$string['sanitycheckfailed'] = 'Ошибка при проверке: Эта попытка была удалена';
$string['save'] = 'Сохранить';
$string['savechanges'] = 'Сохранить изменения';
$string['savechangesandeol'] = 'Сохранить все изменения и перейти к концу лекции';
$string['saveoverrideandstay'] = 'Сохранить и ввести другое переопределение';
$string['savepage'] = 'Сохранить страницу';
$string['score'] = 'Баллы за ответ';
$string['score_help'] = 'Если в настройках лекции включен параметр «Баллы за каждый вариант ответа», для каждого ответа можно ввести целое числовое значение оценки (положительное или отрицательное).';
$string['scores'] = 'Баллы';
$string['search:activity'] = 'Лекция — информация об элементе';
$string['secondpluswrong'] = 'Не совсем правильно. Вы хотите попробовать еще раз?';
$string['selectallattempts'] = 'Выбрать все попытки';
$string['selectaqtype'] = 'Выберите тип вопроса';
$string['selectreport'] = 'Выбрать отчет';
$string['sent'] = 'Отправлено';
$string['shortanswer'] = 'Короткий ответ';
$string['showanunansweredpage'] = 'Показать страницы с пропущенным ответом';
$string['showanunseenpage'] = 'Показать непросмотренные страницы';
$string['singleanswer'] = 'Одиночный ответ';
$string['skip'] = 'Пропустить навигацию';
$string['slideshow'] = 'Слайд-шоу';
$string['slideshow_help'] = 'Этот параметр отвечает за отображение лекции в режиме слайд-шоу, с фиксированными шириной и высотой.';
$string['slideshowbgcolor'] = 'Цвет фона слайд-шоу';
$string['slideshowheight'] = 'Высота слайд-шоу';
$string['slideshowwidth'] = 'Ширина слайд-шоу';
$string['startlesson'] = 'Начать лекцию';
$string['studentattemptlesson'] = '{$a->lastname} {$a->firstname} Номер попытки: {$a->attempt}';
$string['studentname'] = 'Имя студента {$a}';
$string['studentoneminwarning'] = 'Внимание! У Вас осталось меньше 1 минуты на завершение лекции.';
$string['studentoutoftimeforreview'] = 'Внимание: у вас закончилось время на пересмотр этой лекции';
$string['studentresponse'] = 'Ответ студента {$a}';
$string['submit'] = 'Отправить';
$string['submitname'] = 'Отправить имя';
$string['teacherjumpwarning'] = 'В лекции используются переходы «{$a->cluster}» или «{$a->unseen}». Сейчас вместо них будет использован переход «Следующая страница». Зайдите как студент, чтобы протестировать эти переходы.';
$string['teacherongoingwarning'] = 'Текущий балл отображается только для студентов. Чтобы протестировать текущий балл, зайдите как студент.';
$string['teachertimerwarning'] = 'Таймер отображается только для студентов. Чтобы протестировать таймер, зайдите как студент.';
$string['thatsthecorrectanswer'] = 'Это правильный ответ';
$string['thatsthewronganswer'] = 'Это неправильный ответ';
$string['thefollowingpagesjumptothispage'] = 'Со следующих страниц осуществляется переход к этой странице';
$string['thispage'] = 'Текущая страница';
$string['timeisup'] = 'Время вышло';
$string['timelimit'] = 'Лимит времени';
$string['timelimit_help'] = 'При включенном параметре в начале лекции будет показано предупреждение о лимите времени и будет отображаться таймер с обратным отсчетом. Ответ, который будет дан после истечения времени, не будет оцениваться.';
$string['timelimitwarning'] = 'Вы должны завершить лекцию за {$a}.';
$string['timeremaining'] = 'Оставшееся время';
$string['timespenterror'] = 'Вы должны работать с лекцией по меньшей мере {$a} минут';
$string['timespentminutes'] = 'Затраченное время (в минутах)';
$string['timetaken'] = 'Затраченное время';
$string['totalpagesviewedheader'] = 'Число просмотренных страниц';
$string['true'] = 'Верно';
$string['truefalse'] = 'Верно/неверно';
$string['unabledtosavefile'] = 'Загруженный файл не может быть сохранен';
$string['unknownqtypesnotimported'] = 'Вопросы ({$a}) с неподдерживаемыми типами вопросов не были импортированы';
$string['unseenpageinbranch'] = 'Страница непросмотренного вопроса из раздела';
$string['unsupportedqtype'] = 'Неподдерживаемый тип вопроса ({$a})!';
$string['updatedpage'] = 'Страница обновлена';
$string['updatefailed'] = 'Обновление не произошло';
$string['updatepagenamed'] = 'Редактировать страницу: {$a}';
$string['usemaximum'] = 'Максимальная оценка';
$string['usemean'] = 'Средняя оценка';
$string['usepassword'] = 'Защитить лекцию паролем';
$string['usepassword_help'] = 'При включении этого параметра для доступа к лекции потребуется указать пароль.';
$string['useroverrides'] = 'Переопределения пользователя';
$string['useroverridesdeleted'] = 'Переопределения пользователя удалены';
$string['usersnone'] = 'Студенты не имеют доступа к этой лекции';
$string['viewessayanswers'] = 'Просмотр ответов Эссе';
$string['viewgrades'] = 'Посмотреть оценки';
$string['viewreports'] = 'Просмотреть попытки ({$a->attempts}), завершенные {$a->student}';
$string['viewreports2'] = 'Просмотр завершенных попыток ({$a})';
$string['warning'] = 'Предупреждение';
$string['welldone'] = 'Отлично!';
$string['whatdofirst'] = 'Что Вы хотите сделать в первую очередь?';
$string['withselectedattempts'] = 'С выбранными попытками...';
$string['wronganswerjump'] = 'Переход при неправильном ответе';
$string['wronganswerscore'] = 'Баллы за неправильный ответ';
$string['wrongresponse'] = 'Комментарий на неправильный ответ';
$string['youhaveseen'] = 'Вы уже работали с этой лекцией.<br /> Хотите продолжить с того места, на котором Вы остановились?';
$string['youranswer'] = 'Ваш ответ';
$string['yourcurrentgradeis'] = 'Ваша текущая оценка: {$a}';
$string['yourcurrentgradeisoutof'] = 'Ваша текущая оценка: {$a->grade} из {$a->total}';
$string['youshouldview'] = 'Вы должны ответить, по меньшей мере на: {$a}';
