<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'sk', version '4.4'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Prístup odmietnutý';
$string['accountlocked'] = 'Vaše konto je zablokované. Odkaz na odomknutie bol odoslaný e-mailom.';
$string['accounts'] = 'Účty';
$string['accountunlocked'] = 'Vaše konto je odblokované. Môžete sa prihlásiť.';
$string['addcategory'] = 'Pridať kategóriu';
$string['additionalhtml'] = 'Prídavné HTML';
$string['additionalhtml_desc'] = 'Tieto nastavenia Vám umožnia špecifikovať HTML, ktoré chcete pridať na každú stránku. Môžete nastaviť HTML, ktorý bude pridaný do tagu hlavičky - HEAD pre danú stránku, bezprostredne po otvorení značky telo- BODY, alebo bezprostredne po jeho uzavretí.  Týmto vám umožní pridať vlastné hlavičky alebo päty na každej stránke alebo pridať podporu pre služby, ako je Google Analytics veľmi ľahko a nezávisle na zvolenú tému.';
$string['additionalhtml_heading'] = 'Prídavný HTML kód pridaný ku každej stránke.';
$string['additionalhtmlfooter'] = 'Predtým, ako je ukončené BODY';
$string['additionalhtmlfooter_desc'] = 'Tento obsah bude pridaný ku každej stránke predtým, ako bude uzavrený tag BODY.';
$string['additionalhtmlhead'] = 'V rámci HEAD';
$string['additionalhtmlhead_desc'] = 'Tento obsah bude pridaný ku každej stránke predtým, ako bude uzavrený tag HEAD.';
$string['additionalhtmltopofbody'] = 'Keď je otvorený tag BODY';
$string['additionalhtmltopofbody_desc'] = 'Tento obsah bude pridaný ku každej stránke hneď potom, ako bol otvorený tag body.';
$string['admincategory'] = 'Kategória: {$a}';
$string['adminseesall'] = 'Administrátori vidia všetko';
$string['adminseesallevents'] = 'Administrátori môžu prezerať všetky udalosti';
$string['adminseesownevents'] = 'Administrátori sú ako obyčajní používatelia';
$string['advancedfeatures'] = 'Pokročilé nastavenia';
$string['agedigitalconsentverification'] = 'Digitálny vek overenia súhlasu';
$string['agedigitalconsentverification_desc'] = 'Umožniť overenie digitálneho veku súhlasu pred zobrazením stránky registrácie pre samo-registrujúcich sa používateľov. To chráni vašu stránku pred neplnoletými registráciami bez súhlasu rodičov/zákonných zástupcov. Podrobnosti o <a target="_blank" href="{$a}">kontakte podpory</a> vám poskytnú ďalšiu pomoc.';
$string['ageofdigitalconsentmap'] = 'Digitálny vek súhlasu';
$string['ageofdigitalconsentmap_desc'] = 'Predvolený digitálny vek súhlasu a vek v ktorejkoľvek krajine, kde sa líši od predvoleného nastavenia, môže byť špecifikovaný tu. Každý vek zadajte na nový riadok s formátom: kód krajiny, vek (oddelený čiarkou). Predvolený vek je označený * namiesto kódu krajiny. Kódy krajín sú uvedené v norme ISO 3166-2.';
$string['allcountrycodes'] = 'Kódy všetkých krajín';
$string['allowattachments'] = 'Povoliť prílohy';
$string['allowbeforeblock'] = 'Povolený zoznam bude spracovaný ako prvý';
$string['allowbeforeblockdesc'] = 'V predvolenom nastavení položky v zozname blokovaných IP budú uzavreté ako prvé. Ak je táto voľba povolená, položky v zozname povolených IP budú spracované pred zoznamom blokovaných IP adries.';
$string['allowcategorythemes'] = 'Povoliť zmenu tém v kategóriách';
$string['allowcohortthemes'] = 'Povoliť témy globálnych skupín';
$string['allowcoursethemes'] = 'Povoliť zmenu tém v kurzoch';
$string['allowedemaildomains'] = 'Povolené emailové domény';
$string['allowediplist'] = 'Zoznam povolených IP adries';
$string['allowemailaddresses'] = 'Povolené emailové domény';
$string['allowemojipicker'] = 'Výber emoji';
$string['allowframembedding'] = 'Povoliť vkladanie do rámca';
$string['allowframembedding_help'] = 'Ak povolené, táto stránka môže byť vložená do rámca na vzdialenom systéme, ako sa odporúča pri použití "Publikovať ako nástroj LTI" plugin. V opačnom prípade sa odporúča nechať povolené vkladanie z bezpečnostných dôvodov zakázané.  Upozorňujeme, že toto nastavenie je pre mobilné aplikácie ignorované a vkladanie rámcov je vždy povolené.';
$string['allowguestmymoodle'] = 'Povoliť hosťom prístup na Nástenku';
$string['allowindexing'] = 'Povoliť indexáciu vyhľadávačmi';
$string['allowindexing_desc'] = 'To určuje, či povolíte vyhľadávacím nástrojom indexovať vaše stránky. "Všade" umožní vyhľadávačom vyhľadávať vo všetkých podstránkach, vrátane prihlasovacích a registračných stránok, čo znamená, že stránky so zapnutým Force Login sú stále indexované. Ak chcete predísť riziku, že spam bude spojený s vyhľadávateľskou stránkou registrácie, použite "Všade okrem prihlasovacích a registračných stránok". Voľba "Nikde" nepovie vyhľadávačom, aby indexovali žiadnu stránku. Toto je len značka v hlavičke stránky. Je na vyhľadávači, aby rešpektoval značku.';
$string['allowindexingeverywhere'] = 'Všade';
$string['allowindexingexceptlogin'] = 'Všade okrem prihlasovacích a registračných stránok';
$string['allowindexingnowhere'] = 'Nikde';
$string['allowobjectembed'] = 'Povoliť tagy EMBED a OBJECT';
$string['allowthemechangeonurl'] = 'Povoliť zmenu témy v URL';
$string['allowuserblockhiding'] = 'Povoliť používateľom skrývať bloky';
$string['allowusermailcharset'] = 'Povoliť používateľom výber znakovej sady';
$string['allowuserswitchrolestheycantassign'] = 'Povoliť používateľom bez priradenej roly prepínať medzi rolami';
$string['allowuserthemes'] = 'Povoliť používateľom zmenu témy';
$string['alternativefullnameformat'] = 'Alternatívne plné meno';
$string['alternativefullnameformat_desc'] = 'Definuje, ako sú mená zobrazené pre užívateľov s možnosťou viewfullnames (v predvolenom nastavení používateľa s rolou správcu, učiteľa alebo učiteľ, ktorý neupravuje). Zástupné symboly sú rovnaké ako pri nastavení "Formát plného názvu".';
$string['always'] = 'vždy';
$string['appearance'] = 'Vzhľad';
$string['aspellpath'] = 'Cesta k programu aspell';
$string['asyncbackupdisabled'] = 'Váš portál je v súčasnosti nakonfigurovaný na používanie synchrónnych záloh. Asynchrónne zálohovanie poskytuje používateľom lepší zážitok, pretože im umožňuje vykonávať iné operácie počas prebiehajúceho zálohovania alebo obnovy. Asynchrónne zálohovanie je povolené pre všetky stránky od verzie Moodle 4.5 LTS. Synchrónne zálohovanie bude zo systému Moodle LMS odstránené vo verzii po 4.5 LTS.';
$string['authentication'] = 'Autentifikácia';
$string['authpreventaccountcreation'] = 'Zabrániť vytváraniu nových účtov pri overovaní používateľov';
$string['authpreventaccountcreation_help'] = 'Kým sa užívateľ overí, účet na webe je automaticky vytvorený, ak ešte neexistuje. Ak sa pre autentizáciu používajú externé databázy, ako je napríklad LDAP, ale chcete povoliť prístup k stránke iba užívateľom s existujúcim účtom, potom by mala byť povolená táto voľba. Nové účty budú musieť byť vytvorené ručne alebo pomocou funkcie nahrávania užívateľov. Toto nastavenie neplatí pre overovanie MNet.';
$string['authsettings'] = 'Spravovať autentifikáciu';
$string['autolang'] = 'Automatická detekcia jazyka';
$string['autolangusercreation'] = 'Pri vytváraní účtu nastaviť jazyk prehliadača používateľa ako preferovaný jazyk';
$string['autologinguests'] = 'Automaticky prihlasovať hostí';
$string['availableto'] = 'Dostupné';
$string['availabletoanyone'] = 'Dostupné pre každého, kto navštívi port';
$string['availabletoauthenticated'] = 'Obmedzené na overených používateľov';
$string['backgroundcolour'] = 'Priehľadná farba';
$string['backup_shortname'] = 'Používať názov kurzu v názve zálohy súborov';
$string['backup_shortnamehelp'] = 'Použiť názov kurzu v názve zálohy súboru';
$string['backups'] = 'Zálohy';
$string['badwordsconfig'] = 'Zadajte zoznam zakázaných slov, jednotlivé slová oddeľujte čiarkou.';
$string['badwordsdefault'] = 'Ak je zoznam prázdny, použije sa východzí zoznam uvedený v jazykovom balíčku.';
$string['badwordslist'] = 'Zoznam zakázaných slov';
$string['blockediplist'] = 'Zoznam blokovaných IP adries';
$string['blockinstances'] = 'Výskyty';
$string['blockmultiple'] = 'Viacnásobný';
$string['blockprotect'] = 'Chrániť inštancie';
$string['blockprotect_help'] = 'Ak uzamknete určitý typ bloku, nikto nebude schopný pridávať alebo odstraňovať inštancie. (Samozrejme, že ho môžete znovu odomknúť, ak potrebujete inštancie editovať.)

Zámerom tohto nastavenia je chrániť bloky ako sú navigácia a nastavenia, ktoré sa veľmi ťažko obnovujú , ak sa náhodne odstránia.';
$string['blockprotectblock'] = 'Chrániť inštancie {$a}';
$string['blockprotected'] = 'Inštancie bloku {$a} sú chránené.';
$string['blocksettings'] = 'Spravovať bloky';
$string['blockunprotect'] = 'nechránený';
$string['blockunprotectblock'] = 'Zrušenie ochrany inštancií {$a}';
$string['blockunprotected'] = 'Inštancie bloku {$a} sú nechránené.';
$string['bloglevel'] = 'Viditeľnosť Blogu';
$string['bookmarkadded'] = 'Záložka pridaná';
$string['bookmarkalreadyexists'] = 'Tato stránka už obsahuje vašu záložku';
$string['bookmarkdeleted'] = 'Záložka odstránená';
$string['bookmarkthispage'] = 'Pridať túto stránku ako záložku';
$string['cacheapplication'] = 'Aplikačná cache';
$string['cacheapplicationhelp'] = 'Položky vo vyrovnávacej pamäti sú zdieľané medzi všetkými používateľmi a skončí o stanovenom čase (TTL).';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Javascript caching a kompresie výrazne zlepšujú načítanie stránky. Dôrazne sa odporúča pre produkčné weby. Vývojári budú pravdepodobne chcieť túto funkciu deaktivovať.';
$string['cacherequest'] = 'Požiadavková medzipamäť';
$string['cacherequesthelp'] = 'Používateľsky špecifická medzipamäť, ktorá vyprší, keď je žiadosť ukončená. Nahradzuje statické úložisko.';
$string['cachesession'] = 'Relačná cache';
$string['cachesessionhelp'] = 'Používateľsky špecifická medzipamäť, ktorá vyprší, keď skončí aktivita používateľa. Navrhnuté na zmiernenie využívania relácií (session).';
$string['cachesettings'] = 'Nastavenie cache';
$string['cachetemplates'] = 'Šablóny medzipamäte';
$string['cachetemplates_help'] = 'Ukladanie do medzipamäte zlepší výkon načítania stránky a je doporučené pre produkčné weby. Vývojári budú pravdepodobne chcieť túto funkciu deaktivovať.';
$string['caching'] = 'Vyrovnávacia medzipamäť';
$string['calendar_weekend'] = 'Dni víkendu';
$string['calendarexportsalt'] = 'Salt (náhodný reťazec) pre export kalendára';
$string['calendarsettings'] = 'Kalendár';
$string['calendartype'] = 'Typ kalendára';
$string['calendartype_desc'] = 'Vyberte predvolený typ kalendára pre celú stránku. Toto nastavenie je možné prepísať v nastavení kurzu alebo používateľom v jeho osobnom profile.';
$string['campaign'] = 'Kampaň';
$string['cannotdeletemodfilter'] = '	
Nemôžete odinštalovať filter \'{$a->filter}\', pretože je časťou modulu \'{$a->module}\'.';
$string['cannotuninstall'] = 'Nie je možné odinštalovať {$a}.';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = 'V súbore config.php ste nesprávne definovali $CFG->wwwroot. Na jeho konci je znak \'/, ktorý musí byť vymazaný.';
$string['cfgwwwrootwarning'] = 'V súbore config.php ste nesprávne definovali $CFG->wwwroot. Nesúhlasí s URL, ktorú používate na prístup k tejto stránke.';
$string['change'] = 'zmeniť';
$string['checkboxno'] = 'Nie';
$string['checkboxyes'] = 'Áno';
$string['checkupgradepending'] = 'Aktualizácia';
$string['choosefiletoedit'] = 'Vyberte súbor k úprave';
$string['cleanup'] = 'Vyčistenie';
$string['clianswerno'] = 'N';
$string['cliansweryes'] = 'A';
$string['cliexitgraceful'] = 'Ukončovanie, prosím čakajte ...';
$string['cliexitnow'] = 'Ukončenie práve TERAZ';
$string['cliincorrectvalueerror'] = 'Chyba, nesprávna hodnota "{$a->value}" for "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Nesprávna hodnota, prosím skúste znova';
$string['clistatusdisabled'] = 'Stav: Nepovolený';
$string['clistatusenabled'] = 'Stav: Povolený';
$string['clistatusenabledlater'] = 'Stav: mód CLI údržby bude aktivovaný na {$a}';
$string['clitypevalue'] = 'Vložte hodnotu';
$string['clitypevaluedefault'] = 'Vložte hodnotu a stlačte klávesu Enter pre použitie nastavenej hodnoty ({$a})';
$string['cliunknowoption'] = 'Nerozoznané voľby: {$a}
Prosím, použite možnosť --help.';
$string['cliupgradecompletenomaintenanceupgrade'] = 'Vyčistenie zostávajúcich vyrovnávacích pamätí po prechode používateľov na nový kód:

  php admin/cli/purge_caches.php --muc
  php admin/cli/purge_caches.php --js
  php admin/cli/purge_caches.php --filter
  php admin/cli/purge_caches.php --other

Tieto čistenia by ste mali vykonávať izolovane, s odstupom medzi príkazmi, aby ste znížili nárasty zaťaženia webového servera.';
$string['cliupgradedefault'] = 'Nové nastavenie: {$a}';
$string['cliupgradedefaultheading'] = 'Nastavujú sa nové východzie hodnoty';
$string['cliupgradedefaultverbose'] = 'Nové nastavenie: {$a->name}, východzia hodnota: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Aktualizácia z príkazového riadku z {$a->defaultsetting} na {$a->newversion} bola úspešne ukončená.';
$string['cliupgrademaintenancenotrequired'] = 'Táto aktualizácia NEBUDE mať za následok režim údržby pre používateľov.';
$string['cliupgrademaintenancerequired'] = 'Táto aktualizácia BUDE mať za následok režim údržby pre používateľov.';
$string['cliupgradenoneed'] = 'Pre túto verziu {$a} nie je potrebná aktualizácia. Aj tak fajn, že ste sem klikli!';
$string['cliupgradepending'] = 'Je pripravená aktualizácia';
$string['cliupgradesetlock'] = 'Aktualizácia bola uzamknutá len na vykonávanie pomocou CLI.';
$string['cliupgradeunsetlock'] = 'Existujúci zámok aktualizácie vykonávania CLI bol odstránený.';
$string['cliyesnoprompt'] = 'Zvolte A (Áno) alebo N (Nie)';
$string['close'] = 'Zavrieť';
$string['cohort_customfield'] = 'Vlastné polia kohorty';
$string['commentsperpage'] = 'Počet komentárov na stranu';
$string['commonactivitysettings'] = 'Spoločné nastavenia';
$string['commonfiltersettings'] = 'Spoločné nastavenia filtrov';
$string['commonsettings'] = 'Spoločné nastavenia';
$string['componentinstalled'] = 'Nainštalovaný komponent';
$string['computedfromlogs'] = 'Vypočítané logy od {$a}.';
$string['condifmodeditdefaults'] = 'Pri vytváraní novej aktivity alebo zdroja sa v nastaveniach používajú štandardné hodnoty.';
$string['confeditorhidebuttons'] = 'Vyberte tlačidlá, ktoré majú byť v HTML editore skryté.';
$string['configallcountrycodes'] = 'Toto je zoznam krajín, ktoré je možné zvoliť na rôznych miestach, napr. v profile používateľa. Ak je prázdny (štandardné nastavenie), použije sa zoznam uložený v súbore countries.php v štandardnom anglickom jazykovom balíčku, t. j. zoznam z ISO 3166-1. V prípade potreby môžete špecifikovať čiarkami oddelený zoznam kódov,  napr. \'GB,FR,ES\'. Ak na tomto mieste pridáte nové, neštandardné kódy, bude potrebné pridať ich aj do súboru countries.php v časti  \'en\' a zároveň vo vašom jazykovom balíčku.';
$string['configallowassign'] = 'Povoliť rolám na ľavej strane priradiť roly iným ľuďom v jednotlivých stĺpcoch.';
$string['configallowattachments'] = 'Ak je povolené, e-maily odoslané zo stránky môžu obsahovať prílohy, napríklad odznaky.';
$string['configallowcategorythemes'] = 'Ak povolíte toto nastavenie, témy môžu byť nastavené na úrovni kategórie kurzov. Ovplyvní to všetky podradené kategórie a kurzy, ak tieto nemajú nastavenú vlastnú tému. UPOZORNENIE: Povolenie nastavenia môže znížiť výkonnosť na serveri.';
$string['configallowcohortthemes'] = 'Ak to povolíte, potom témy sa dajú nastaviť na úrovni globálnej skupiny. Toto bude mať vplyv na všetkých používateľov, ktorí majú len jednu globálnu skupinu alebo viac ako jednu, ale s rovnakou témou.';
$string['configallowcoursethemes'] = 'Keď zapnete túto voľbu, bude možné nastaviť pre kurz vlastnú tému. Téma kurzu má najvyššiu prioritu, zobrazí sa aj v prípade, keď bude nastavenie témy hlavnej stránky, používateľa či aktuálneho sedenia odlišné.';
$string['configallowedemaildomains'] = 'Zoznam e-mailových domén, ktoré môžu byť zverejnené v sekcii Odchádzajúcich e-mailov. Predvolená hodnota „Prázdna“ bude používať adresu bez odpovede pre všetky odchádzajúce e-maily. Použitie zástupných znakov je povolené napr. * .example.com umožní odosielanie e-mailov z ľubovoľnej subdomény example.com, ale nie zo samotného example.com - to si vyžaduje samostatný záznam.';
$string['configallowemailaddresses'] = 'Ak chcete obmedziť všetky nové emailové adresy na určité domény, uveďte ich tu, oddelené medzerami. Všetky ostatné domény budú odmietnuté. Na pridanie poddomén pridajte doménu začínajúcu bodkou. Ak chcete pridať koreňovú doménu spolu s jej poddoménami, zadajte doménu dva razy - raz začínajúc s bodkou a raz bez nej, napr. vasaskola.sk .vasaskola.sk.';
$string['configallowemojipicker'] = 'Výber emoji umožňuje používateľom vybrať emoji, ako napríklad smajlíky, a pridať ich do správ a iným textom pomocou tlačidla v Atto editore.';
$string['configallowemojipickerincompatible'] = 'Vaša aktuálna konfigurácia nepodporuje databázu emoji. Ak chcete povoliť výber emoji, musíte <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">aktualizovať vašu databázu na plnú podporu unicode</a>.';
$string['configallowguestmymoodle'] = 'Ak je táto možnosť aktivovaná, používatelia prihlásení ako hostia budú mať prístup na domovskú stránku, v opačnom prípade budú presmerovaní na titulnú stránku.';
$string['configallowobjectembed'] = 'Používatelia s rolou študenta nesmú z bezpečnostných dôvodov vkladať multimédiá do textov pomocou značiek EMBED a OBJECT v jazyku HTML, hoci multimédiá sa stále môžu zobrazovať pomocou filtra multimediálnych zásuvných modulov. Ak chcete tieto značky povoliť, povoľte túto možnosť.';
$string['configallowoverride'] = 'Povoliť rolám na ľavej strane prepísať roly v jednotlivých stĺpcoch.';
$string['configallowoverride2'] = 'Zvoľte rolu(y), ktoré môžu byť prepísané rolou v ľavom stĺpci. <br />Poznámka: tieto nastavenia sa týkajú iba používateľov, ktorí majú nastavené buď oprávnenie moodle/role:override alebo moodle/role:safeoverride.';
$string['configallowswitch'] = 'Pre každú rolu v ľavom stĺpci vyberte, na ktoré roly sa môžu prepínať.<br />Používatelia musia mať tiež schopnosť moodle/role:switchroles.';
$string['configallowthemechangeonurl'] = 'Ak je povolené, téma môže byť zmenená pridaním theme=nazovtemy k ľubovoľnému Moodle URL.

Napríklad http://nasa.skola.sk/moodle/?theme=afterburner alebo http://nasa.skola.sk/moodle/course/view.php?id=1&theme=afterburner';
$string['configallowuserblockhiding'] = 'Chcete povoliť používateľom skrytie/zobrazenie postranných blokov na všetkých týchto stránkach? Táto vlastnosť používa Javascript a Cookies pre uloženie aktuálneho stavu pre každý blok a ovplyvní iba používateľov pohľad.';
$string['configallowusermailcharset'] = 'Povoliť všetkým užívateľom nastavenie vlastnej znakovej sady pre e-maily.';
$string['configallowuserswitchrolestheycantassign'] = 'Vo východzom nastavení je schopnosť moodle/role:assign potrebná na to, aby sa mohli používatelia prepnúť medzi rolami. Ak je toto nastavenie aktívne, tlačidlo "Prepnúť rolu na..." zobrazuje všetky roly určené nastavením tabuľky "Povoliť priradenia rol" v administrátorskom menu.
Je potom doporučené, aby táto tabuľka neobsahovala možnosť prepnúť sa do roly, ktorá je nadradená súčasnej.';
$string['configallowuserthemes'] = 'Keď zapnete túto voľbu, používateľ si bude môcť nastaviť vlastné témy. Témy používateľa majú vyššiu prioritu, zobrazia sa aj v prípade, keď bude nastavenie témy hlavnej stránky iné (toto neplatí pre témy kurzu).';
$string['configallowview'] = 'Pre každú rolu v ľavom stĺpci vyberte roly, ktoré môžu zobrazovať, vyhľadávať a filtrovať podľa nich.';
$string['configallusersaresitestudents'] = 'Mali by byť všetci používatelia považovaní za študentov vzhľadom k aktivitám, ktoré sú im dostupné  na hlavnej stránke systému? Ak je Vaša odpoveď \'Áno\', potom každý autorizovaný používateľ sa môže týchto aktivít zúčastniť ako študent. Ak je Vaša odpoveď \'Nie\', potom len tí používatelia, ktorí sú už účastníkmi aspoň jedného kurzu, sa môžu zúčastniť týchto aktivít. Ako učitelia týchto aktivít môžu vystupovať len administrátori a špeciálne na to vymenovaní učitelia.';
$string['configauthenticationplugins'] = 'Zvoľte spôsoby overovania používateľov a poradia, v akom budú použité. Ak sa používatelia registrujú sami, bude použitý spôsob uvedený v poli "Registrácia používateľov" nižšie (väčšinou sa používa overenie na základe emailu).';
$string['configautolang'] = 'Detekcia východzieho jazyka z nastavenia web prehliadača. Ak nie je povolené, použije sa východzie nastavenie na portáli.';
$string['configautolangusercreation'] = 'Ak je táto možnosť povolená, pri automatickom vytvorení používateľského účtu pri prvom prihlásení (napr. pomocou LDAP alebo OAuth overovania) je ako preferovaný jazyk nastavený jazyk prehliadača používateľa. V opačnom prípade je ako východzí jazyk portálu nastavený ako preferovaný jazyk používateľa.';
$string['configautologinguests'] = 'Mali by byť návštevníci automaticky prihlasovaní ako hostia, ak vstúpia do kurzov s hosťovským prístupom?';
$string['configbloglevel'] = 'Touto voľbou nastavujete úroveň prístupu k blogom na vašich stránkach. Nastavenie sa týka ČITATEĽOV, nie autorov či typov blogov. Ak blogy nechcete používať, môžete ich vypnúť úplne.';
$string['configcalendarcustomexport'] = 'Aktivovať export kalendára s vlastným rozsahom dátumov';
$string['configcalendarexportsalt'] = 'Tento náhodný text sa používa na zvýšenie bezpečnosti autentifikácie pri exporte kalendárov. Upozorňujeme, že všetky súčasné exporty budú neplatné, ak text zmeníte.';
$string['configcookiesecure'] = 'Ak server prijíma iba https spojenia, doporučuje sa povoliť posielanie bezpečných cookie. Ak povolíte, ubezpečte sa, že server neakceptuje http:// alebo zabezpečte trvalé presmerovanie na https:// adresu a ideálne posielajte HSTS hlavičky. Ak adresa <em>wwwroot</em> nezačína na https://, je toto nastavenie automaticky vypnuté.';
$string['configcountry'] = 'Ak si tu vyberiete krajinu, tak bude táto krajina nastavená aj pre nové používateľské kontá. Ak chcete, aby si používatelia sami vybrali krajinu, nenastavujte ju tu.';
$string['configcoursegraceperiodafter'] = 'Klasifikujte predchádzajúce kurzy ako prebiehajúce počas týchto dní po dátume ukončenia kurzu.';
$string['configcoursegraceperiodbefore'] = 'Klasifikujte budúce kurzy ako prebiehajúce počas týchto dní pred začiatkom kurzu.';
$string['configcourseoverviewfilesext'] = 'Čiarkami oddelený zoznam povolených typov súborov obrázkov zhrnutia kurzov.';
$string['configcourseoverviewfileslimit'] = 'Maximálny počet súborov, ktoré je možné pripojiť k zhrnutiu kurzu. Prvý pridaný súbor s obrázkom se používa ako obrázok kurzu v prehľade kurzov na nástenke používateľov; všetky ďalšie súbory sú zobrazené iba v zozname stránok kurzov.';
$string['configcourserequestnotify'] = 'Zadajte login používateľa, ktorý bude upozornený pri žiadosti o nový kurz';
$string['configcourserequestnotify2'] = 'Používatelia, ktorí budú upozornení pri žiadosti o vytvorenie kurzu. V tomto zozname sa nachádzajú iba používatelia, ktorí môžu odsúhlasiť žiadosti o vytvorenie nového kurzu.';
$string['configcoursesperpage'] = 'Zadajte počet kurzov na stránke pri zobrazovaní zoznamu kurzov.';
$string['configcourseswithsummarieslimit'] = 'Maximálny počet kurzov, ktorý sa zobrazí vo výpise kurzov vrátane zhrnutí pred návratom k jednoduchšiemu výpisu.';
$string['configcronclionly'] = 'Spúšťanie cronu cez webové rozhranie môže odhaliť anonymným používateľom privilegované informácie. Preto sa odporúča spúšťať cron iba z príkazového riadku alebo pre vzdialený prístup nastaviť cronu heslo.';
$string['configcronremotepassword'] = 'Ak použijete toto nastavenie, bude pre volanie skriptu cron.php cez webové rozhranie nutné použiť heslo predávané ako parameter podľa vzoru: <pre>https://moodle.nasaskola.sk/admin/cron.php?password=sezamotvorsa</pre> Ak necháte pole prázdne, bude možné volať skript cron.php aj bez hesla.';
$string['configcurlcache'] = 'Životnosť cURL vyrovnávacej pamäti v sekundách.';
$string['configcustommenuitems'] = 'Na tomto mieste môžete aktivovať vlastné menu tak, aby sa zobrazovalo v témach. Každý riadok sa skladá z textu menu, odkazu na URL (voliteľné), názvu tooltipu (voliteľné) a jazykového kódu alebo čiarkami oddeleného zoznamu kódov (voliteľné, na zobrazenie riadku iba používateľom špecifického jazyka), oddelených od seba spojovacími znakmi. Štruktúru môžete špecifikovať použitím spojovníka. Napríklad:
<pre>
Kurzy
-Všetky kurzy|/course/
-Vyhľadávanie kurzov|/course/search.php
-###
-FAQ|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Mobilná appka|https://someurl.xyz/app|Stiahnuť našu appku
</pre>';
$string['configcustomusermenuitems'] = 'Môžete konfigurovať obsah menu používateľa (s výnimkou odkazu na odhlásenie sa, ktorý je pridaný automaticky). Každý riadok je oddelený znakom | a skladá sa z: 1) reťazca v tvare "langstringname, componentname" alebo v tvare jednoduchého textu, 2) URL adresy. Tam, kde treba, je možné použiť oddeľovače pridaním riadku s jedným alebo viacerými znakmi #.';
$string['configdbsessions'] = 'Ak povolíte túto voľbu, toto nastavenie bude používať databázu na uchovanie informácií o aktuálnych sedeniach (sessions). Upozornenie: zmena tohto nastavenia spôsobí odhlásenie všetkých aktuálne prihlásených používateľov (vrátane vás). Ak používate MySQL, uistite sa, že máte konfiguračnú premennú "max_allowed_packet" (v my.cnf nebo my.ini) nastavenú aspoň na hodnotu 4M. Ďalšie ovládače sedenia môžu byť konfigurované priamo v config.php,  viac informácií viď config-dist.php. Ak zadáte ovládač sedenia v súbore config.php, táto voľba zmizne.';
$string['configdebug'] = 'Ak zapnete túto voľbu, PHP zvýši oznamovanie chýb tak, že bude uvádzaných viac varovaní. Toto je užitočné len pre vývojových pracovníkov.';
$string['configdebugdisplay'] = 'Ak je zapnuté, zobrazujú sa chybové hlásenia ako súčasť HTML stránky. To je síce praktické, ale všeobecne môžu chybové hlásenia nabúravať XHTML, JavaScript, cookies a HTTP hlavičky. Pri vypnutí budú chybové hlásenia ukladané v protokole webového serveru. Nastavenie PHP premennej error_log v súbore php.ini ovplyvňuje, aké informácie sú protokolované.';
$string['configdebugpageinfo'] = 'Povoľte, ak chcete, aby informácia o stránke bola zobrazená v jej päte.';
$string['configdebugvalidators'] = 'Povoľte, ak chcete, aby sa odkazy na externé validačné servery zobrazili v zápätí stránky. Možno budete potrebovať vytvoriť nového používateľa s používateľským menom <em>w3cvalidator</em>  a aktivovať hosťovský prístup. Tieto zmeny môžu povoliť neautorizovaný prístup na server, neaktivujte ich na produkčných portáloch!';
$string['configdefaulthomepage'] = 'Na ktorú stránku by mali byť používatelia presmerovaní po prihlásení na portál? Toto určuje prvý odkaz v navigácii pre prihlásených používateľov v klasických témach.';
$string['configdefaultrequestcategory'] = 'Kurzy požadované používateľmi s oprávnením vyžiadať si nové kurzy v kontexte systému budú zaradené v tejto kategórii, ak si používatelia nebudú môcť vybrať inú kategóriu.';
$string['configdefaultrequestedcategory'] = 'Do akej kategórie zaradiť požadované kurzy, ak sú schválené?';
$string['configdefaultuserroleid'] = 'Prihlásení používatelia získajú na úrovni celého serveru všetky oprávnenia vyplývajúce z uvedenej roly. Tieto oprávnenia budú PRIDANÉ k ostatným oprávneniam získaných z ďalších rol. Pomocou tohto nastavenia zabezpečujete minimálne oprávnenia pre každého prihláseného používateľa, aby mohol robiť niečo zmysluplné (napr. čítať verejné diskusie, zobrazovať študijné materiály a pod.). Východzie nastavenie je rola Hosťa.';
$string['configdeleteincompleteusers'] = 'Kontá používateľov, ktorí nevyplnili meno, priezvisko alebo e-mail, budú po tomto čase odstránené.';
$string['configdeleteunconfirmed'] = 'Ak používate emailovú autorizáciu, toto je časové rozpätie, počas ktorého bude odpoveď akceptovaná používateľmi. Po tomto období budú nepoužívané kontá vymazané.';
$string['configdenyemailaddresses'] = 'Ak chcete zakázať emailové adresy z určitých domén, uveďte ich tu, oddelené medzerami. Všetky ostatné domény budú akceptované. Na pridanie poddomén pridajte doménu začínajúcu bodkou, napr. <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configdisableuserimages'] = 'Deaktivovať schopnosť používateľov zmeniť obrázky v profilových stránkach.';
$string['configdisplayloginfailures'] = 'Toto zobrazí používateľom informácie o predchádzajúcich neúspešných pokusoch o prihlásenie.';
$string['configdndallowtextandlinks'] = 'Aktivujte alebo deaktivujte funkciu potiahni a pusti text a odkaz na stránke kurzu, popri funkcii potiahni a pusti súbor. Poznámka: Potiahnutie textu do Firefoxu alebo medzi rôznymi prehliadačmi je nespoľahlivé a môže viesť k tomu, že sa dáta nenahrajú, alebo že sa nahrá poškodený text.';
$string['configdoclang'] = 'Tento jazyk bude použitý pri odkazoch na dokumentáciu.';
$string['configdocroot'] = 'Definuje cestu k dokumentom Moodle pre poskytovanie kontextovo špecifickej dokumentácie pomocou odkazov „Nápoveda a dokumentácia“ v päte každej stránky.  Ak je toto pole prázdne, odkaz nebude zobrazovaný.';
$string['configdoctonewwindow'] = 'Pri povolení tohto nastavenia bude Moodle otvárať stránky dokumentácie (Moodle Docs) v novom okne.';
$string['configduration_high'] = 'Táto hodnota je príliš vysoká. Maximálna hodnota je {$a}.';
$string['configduration_low'] = 'Táto hodnota je príliš nízka. Minimálna hodnota je {$a}.';
$string['configeditordictionary'] = 'Táto hodnota je použitá, ak nemá aspell k dispozícii slovník pre jazyk používateľa.';
$string['configeditorfontlist'] = 'Zoznam fontov, ktoré budú zobrazované v ponuke HTML editoru.';
$string['configemailchangeconfirmation'] = 'Vyžadovať následné emailové potvrdenie, ak si používatelia zmenia svoju mailovú adresu.';
$string['configemaildkimselector'] = 'Selektor DKIM je ľubovoľný a vaše záznamy DNS sa s ním musia zhodovať.';
$string['configemailfromvia'] = 'Pridajte informácie v sekcii Odchádzajúce e-maily. Toto informuje príjemcu o tom, odkiaľ tento e-mail prišiel, a tiež pomáha bojovať proti príjemcom, ktorí omylom odpovedali na e-mailové adresy bez odpovede.';
$string['configemailheaders'] = 'Nespracovávané záhlavia emailov budú priamo pridané ku všetkým odchádzajúcim emailom.';
$string['configemailsubjectprefix'] = 'Text, ktorý má byť predponou v predmete všetkých odchádzajúcich správ.';
$string['configenableanalytics'] = 'Analytické modely, ako napríklad „Študenti s rizikom vypadnutia" alebo „Termín ukončenia nadchádzajúcej činnosti", môžu vytvárať predpovede, posielať oznámenia a ponúkať ďalšie akcie, napríklad posielanie správ používateľom.';
$string['configenableblogs'] = 'Či majú mať používatelia k dispozícii svoj vlastný blog';
$string['configenablecalendarexport'] = 'Umožniť exportovanie alebo odoberanie kalendárov.';
$string['configenablecomments'] = 'Povoliť komentáre';
$string['configenablecourserequests'] = 'Ak je povolené, používatelia so schopnosťou žiadať o kurzy  (moodle/course:request) si budú môcť požiadať o vytvorenie kurzov. Táto funkcia nie je povolená pre žiadnu z východzích rolí. Môže byť použitá v kontexte systému alebo kategórie.';
$string['configenabledevicedetection'] = 'Aktivuje detekciu mobilov, smartfónov, tabletov alebo štandardných zariadení (stolných počítačov, laptopov, atď.) pre aplikáciu tém a ostatných vlastností.';
$string['configenablemobilewebservice'] = 'Povoliť mobilnú službu pre oficiálnu aplikáciu Moodle alebo inú aplikáciu, ktorá o ňu požiada. Viac informácií nájdete v {$a}';
$string['configenablerssfeeds'] = 'Tento prepínač umožní RSS kanály z iných stránok. Aby ste videli všetky aktuálne zmeny, musíte aktivovať RSS kanály aj v jednotlivých moduloch.';
$string['configenablerssfeedsdisabled'] = 'Voľba nie je dostupná, pretože RSS kanály sú deaktivované na celej Stránke. Ak ich chcete aktivovať, choďte do Nastavení premenných v Konfigurácii administrátora.';
$string['configenablerssfeedsdisabled2'] = 'RSS feedy sú deaktivované na serverovej úrovni. Musíte ich najprv povoliť v časti Administratíva/Pokročilé vlastnosti.';
$string['configenablestats'] = 'Pri voľbe \'Áno\' spracuje cron protokoly o činnosti užívateľov a vytvorí z nich grafy a štatistiky pre jednotlivé kurzy i pre celý server. Toto spracovanie môže trvať istý čas, v závislosti od návštevnosti/zaťaženosti vášho servera.';
$string['configenabletrusttext'] = 'Moodle štandardne filtruje akýkoľvek text zadaný používateľmi a snaží sa odstrániť potenciálne bezpečnostné riziká, medzi ktoré patria aj skripty, média, a pod. Pomocou funkcie "Dôveryhodný obsah" môžete vybraným používateľom poskytnúť privilégium používať aj tieto pokročilé prvky bez ďalších zásahov. Najprv je treba povoliť toto nastavenie a potom prideliť oprávnenie Dôveryhodný obsah (Trusted Content) vybraným roliam. Text, ktorý bol vytvorený alebo nahraný používateľom s takouto rolou, je potom označený ako dôveryhodný a nie je pred zobrazením filtrovaný.';
$string['configenablewebservices'] = 'Webové služby umožňujú ostatným systémom prihlásiť sa do tohto Moodle a vykonávať operácie. Táto funkcia by mala byť vypnutá pre zvýšenie bezpečnosti, ak ju naozaj nepoužívate.';
$string['configenablewsdocumentation'] = 'Aktivovať automatické vytváranie dokumentácie webových služieb. Používateľ môže pristupovať k svojej vlastnej dokumentácii na stránke svojich bezpečnostných kľúčov  {$a}. Zobrazí sa iba dokumentácia pre aktivované protokoly.';
$string['configerrorlevel'] = 'Vyberte si množstvo PHP varovaní, ktoré chcete mať zobrazované. Normal je zvyčajne najlepšia možnosť.';
$string['configexportlookahead'] = 'Počet nadchádzajúcích dní zobrazovaných počas exportu';
$string['configexportlookback'] = 'Počet predchádzajúcích dní zobrazovaných počas exportu';
$string['configextendedusernamechars'] = 'Ak povolíte toto nastavenie, používateľské mená budú môcť používať ľubovoľné znaky okrem veľkých písmen. Štandardné nastavenie obmedzuje používané znaky v menách len na číslice, malé písmená, podtrhovník (_), rozdeľovník (-), bodka a zavináč.';
$string['configextramemorylimit'] = 'Niektoré skripty ako vyhľadávanie, zálohovanie a obnova zo zálohy, alebo cron, vyžadujú viac pamäte. Nastavte vyššie hodnoty pre veľké portály.';
$string['configfilterall'] = 'Filtrovať všetky reťazce, vrátane hlavičiek, titulov, navigačnej lišty a podobne. Toto je najviac užitočné pri používaní viacjazyčného filtra, inak spôsobuje iba mierne zvýšenú záťaž pri generovaní stránok.';
$string['configfiltermatchoneperpage'] = 'Filtre, ktoré automaticky prepájajú obsah kurzov, vytvoria odkaz iba u prvej nájdenej zhody na celej stránke. Ostatné výskyty sú ignorované.';
$string['configfiltermatchonepertext'] = 'Filtre, ktoré automaticky prepájajú obsah kurzov, vytvoria odkaz iba u prvej nájdenej zhody v každom úseku textu (napr. študijný materiál, blok apod.). Ostatné výskyty sú ignorované. Toto nastavenie sa neuplatní, ak je premenná \'Jedna zhoda na stránku\' nastavená na \'Áno\'.';
$string['configfilternavigationwithsystemcontext'] = 'Normálne použitie filtrovania je viazané na kontext, v ktorom sa používa (napr. kontext kurzu), ale pre navigáciu na portáli môže explicitné filtrovanie všetkého podľa kontextu portálu priniesť zlepšenie výkonu pri použití filtrovania „obsah a nadpisy“.';
$string['configfilteruploadedfiles'] = 'Aktivovaním tejto voľby bude Moodle spracovávať všetky načítané HTML a textové súbory s filtrami predtým, ako sa zobrazia.';
$string['configforcelogin'] = 'Normálne môže byť hlavná stránka s uvedeným zoznamom kurzov (nie s konkrétnymi kurzmi) prezeraná používateľmi bez toho, aby sa predtým prihlásili. Ak chcete, aby sa používatelia prihlásili predtým, ako čokoľvek urobia na stránke, potom by ste mali aktivovať toto nastavenie.';
$string['configforceloginforprofiles'] = 'Aktivovaním tohto nastavenia sa každý reálny používateľ (nie hosť) bude musieť najskôr prihlásiť, ak si chce prezerať profily používateľov. Ak deaktivujete túto voľbu, niektorí používatelia (spameri) budú zneužívať profil na umiestňovanie nevhodného obsahu v svojich profiloch, ktoré sú viditeľné z celého sveta.';
$string['configfrontpage'] = 'Položky vybrané vyššie budú zobrazené na titulnej stránke serveru.';
$string['configfrontpagecourselimit'] = 'Maximálny počet kurzov';
$string['configfrontpagecourselimithelp'] = 'Maximálny počet kurzov, ktoré sa zobrazia na úvodnej stránke v zozname kurzov.';
$string['configfrontpageloggedin'] = 'Prihláseným používateľom budú na titulnej stránke serveru zobrazené položky vybrané vyššie.';
$string['configfullnamedisplay'] = 'Toto definuje spôsob zobrazenia mien, keď sú zobrazené celé. Predvolená hodnota „language“ ponecháva na rozhodnutie reťazci „fullnamedisplay“ v aktuálnom jazykovom balíku. Niektoré jazyky majú odlišné formy zobrazovania názvov.

Pre väčšinu jednojazyčných stránok je najefektívnejším nastavením „krstné meno priezvisko“, ale môžete sa rozhodnúť skryť priezviská úplne. Zástupné symboly, ktoré možno použiť, sú: meno, priezvisko, krstné meno fonetické, priezvisko fonetické, stredné meno a alternatívne meno.';
$string['configgeoipfile'] = 'Umiestnenie GeoIP City binárneho dátového súboru. Tento nie je časťou Moodle distribúcie a musí byť získaný oddelene z <a href="https://www.maxmind.com/">MaxMind</a>. Môžete si alebo kúpiť komerčnú verziu alebo použiť voľnú verziu. Stiahnite súbor <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a> a rozbaľte ho do adresára "{$a}" na vašom serveri.';
$string['configgetremoteaddrconf'] = 'Ak je Váš server za reverzným proxy, môžete použiť toto nastavenie pre určenie HTTP hlavičiek, ktoré môžu byť chápané ako obsahujúce dôveryhodné vzdialené IP adresy. Hlavičky sú čítané v danom poradí a použije sa prvá, ktorá je dostupná.';
$string['configgradebookroles'] = 'Ktorých používateľov zobrazovať v klasifikačnom výpise. Používatelia potrebujú aspoň jednu z týchto rol v danom kurze, aby boli zobrazení v jeho opise.';
$string['configgradeexport'] = 'Vyberte, ktoré exportné formáty v známkach sú vaše primárne metódy pre export. Vybrané zásuvné moduly nastavia a budú používať pole "naposledy exportované" pre každú známku. Napríklad toto môže spôsobiť, že exportované záznamy budú identifikované ako "nové" alebo "aktualizované". Ak si nie ste istí, nechajte prázdne.';
$string['configgradeexportdefault'] = 'Vyberte si, ktorý formát exportu do klasifikačného výkazu je predvoleným spôsobom exportu známok.';
$string['confighiddenuserfields'] = 'Ktoré polia v profiloch používateľov majú byť skryté pred inými používateľmi, než sú vyučujúci a administrátori. Zvyšuje to súkromie študentov. Pre označenie viac položiek podržte klávesu CTRL.';
$string['configidnumber'] = 'Špecifické nastavenia či (a)Používatelia nebudú požiadaní o zadanie ID čísla vôbec, (b)Používatelia budú požiadaní o zadanie ID čísla, ale nemusia ho vyplniť, (c)Používatelia budú požiadaní o zadanie ID čísla a musia ho vyplniť. Ak bude zadané ID číslo používateľa, bude zobrazované v profile.';
$string['configintro'] = 'Na tejto stránke môžete špecifikovať rôzne konfiguračné premenné, ktoré pomôžu Moodle správne spolupracovať s Vašim serverom. Veľmi sa tým nezaťažujte - východiskové nastavenia zvyčajne pracujú správne a vždy sa môžete k tejto stránke vrátiť a tieto nastavenia zmeniť.';
$string['configintroadmin'] = 'Na tejto stránke by ste mali konfigurovať Vaše hlavné administrátorské konto. Administrátor má plnú kontrolu nad celou stránkou. Dbajte na to, aby mal bezpečné používateľské meno, heslo a tiež platnú emailovú adresu. Neskôr môžete vytvoriť viac administrátorských účtov.';
$string['configintrosite'] = 'Táto stránka Vám umožňuje konfigurovať hlavnú stránku a meno tejto stránky. Neskôr to môžete kedykoľvek zmeniť cez menu Administratíva.';
$string['configiplookup'] = 'Keď kliknete na IP adresu (napr. 34.12.222.93) napr. v logoch, zobrazí sa Vám mapa s odhadom, kde sa tá IP adresa nachádza. K tomu sú určené rozličné zásuvné moduly, z ktorých sa dá vybrať, pričom každý z nich má určité výhody a nedostatky.';
$string['configkeeptagnamecase'] = 'Vyberte, ak chcete, aby si názvy tagov zachovali veľkosť písmen tak, ako ich vložili používatelia, ktorí ich vytvorili.';
$string['configlang'] = 'Vyberte si východzí jazyk pre celý portál. Používatelia môžu neskôr toto nastavenie zmeniť cez jazykové menu alebo v nastavení svojho používateľského profilu.';
$string['configlanglist'] = 'Nechajte túto voľbu prázdnu, ak chcete, aby si používatelia mohli vybrať ľubovoľný jazyk z tejto verzie Moodle. Tento zoznam môžete skrátiť, ak uvediete zoznam jazykov, oddelených čiarkou, napr. sk,cz,en,es_es,fr,it.
Ak potrebujete, je možné použiť iný názov jazyka ako názov jazykovej sady pomocí formátu: jazykový kód | názov jazyka, napr. en_kids | English, de_kids | Deutsch.';
$string['configlangmenu'] = 'Vyberte si, či chcete zobraziť menu pre voľbu jazyka na www stránkach Moodle (domovská stránka, autorizačná stránka a podobne). To neovplyvní používateľove možnosti nastavenia preferovaného jazyka vo svojom vlastnom profile.';
$string['configlangstringcache'] = 'Vymaže všetky jazykové reťazce do kompilovaných súborov v adresári údajov. Ak prekladáte Moodle alebo zmeníte reťazce v zdrojovom kóde Moodle, môžete ho vypnúť. V opačnom prípade si môžete pozrieť výkonové výhody.';
$string['configlatinexcelexport'] = 'Zvoľte kódovanie pre exporty Excelu';
$string['configlocale'] = 'Vyberte si miestne jazykové nastavenie portálu - toto ovplyvní formát a jazyk údajov. Tieto miestne údaje musíte mať nainštalované vo Vašom operačnom systéme (napríklad en_US alebo es_ES). Ak neviete, čo si vybrať, nechajte toto prázdne.';
$string['configlockrequestcategory'] = 'Ak je táto možnosť povolená, používatelia s oprávnením požiadať o nové kurzy v kontexte systému nebudú môcť vybrať kategóriu v žiadosti o nový formulár kurzu. Alternatívny spôsob, ako obmedziť používateľa, aby požiadali o nový kurz iba v jednej kategórii, je použiť oprávnenie požadovať nové kurzy v kontexte kategórie.';
$string['configloglifetime'] = 'Táto voľba špecifikuje dĺžku časového intervalu, počas ktorého si chcete uchovať záznamy o používateľských aktivitách. Záznamy, ktoré sú staršie, sa automaticky vymažú. Je dobré uchovávať si záznamy tak dlho, ako je to možné, ale ak máte veľmi zaneprázdnený server a máte problémy s jeho rýchlosťou, potom si vyberte kratší čas pre uchovávanie záznamov. Hodnoty nižšie ako 30 nie sú doporučené, pretože štatistiky nemusia fungovať správne.';
$string['configlookahead'] = 'Počet dní do budúcnosti';
$string['configmailnewline'] = 'Znaky pre nový riadok použité v mailoch. CRLF je vyžadované podľa RFC 822bis, ale niektoré mailové servery automaticky konvertujú z LF na CRLF, iné mailové servery nesprávne konvertujú z CRLF na CRCRLF a iné odmietnu maily s LF (napr. qmail). Skúste zmeniť toto nastavenie ak máte problémy s nedoručenými mailami alebo dvojitými prázdnymi riadkami.';
$string['configmaxbytes'] = 'Táto voľba špecifikuje maximálnu veľkosť prenášaných súborov na celom portáli. Toto nastavenie je obmedzené PHP nastavením post_max_size a upload_max_filesize a nastavením Apache LimitRequestBody. Nastavenie maxbytes ohraničuje rozsah veľkostí, z ktorých si môžete vybrať v každej úrovni kurzu alebo modulu. Ak je vybraná voľba \'Server Limit\', bude použitá maximálna hodnota daná serverom.';
$string['configmaxconsecutiveidentchars'] = 'Heslá nesmú mať mať viac ako tento počet sa sebou idúcich rovnakých znakov. Použite 0 na vypnutie tejto kontroly.';
$string['configmaxeditingtime'] = 'Toto určuje čas, ktorý majú ľudia na upravovanie príspevkov do fóra, spätnej väzby pre písomné práce, atď. Zvyčajne je to 30 minút.';
$string['configmaxevents'] = 'Počet udalostí';
$string['configmaxusersperpage'] = 'Maximálny počet používateľov, ktorý sa zobrazí v selektore používateľov v kurze, skupine, cieľovej skupine, webovej službe atď.';
$string['configmessaging'] = 'Ak je povolené, používatelia si môžu posielať správy medzi sebou.';
$string['configmessagingallowemailoverride'] = 'Povoliť používateľom dostávať e-mailové notifikácie na inú e-mailovú adresu ako je tá, ktorá je uvedená v ich profile.';
$string['configmessagingallusers'] = 'Ak je táto možnosť povolená, používatelia môžu zobraziť zoznam všetkých používateľov na stránke pri výbere osoby na správu a ich predvoľby správ zahŕňajú možnosť prijať správy od kohokoľvek na webe. Ak je táto možnosť zakázaná, používatelia môžu zobraziť iba zoznam používateľov vo svojich kurzoch a majú iba dve možnosti v preferenciách správ - prijímať iba správy od svojich kontaktov alebo ich kontakty a kohokoľvek v ich kurzoch.';
$string['configmessagingdefaultpressenter'] = 'Či je v nastavení zasielania správ používateľov vo východzom nastavení povolené "Použiť pre odoslanie".';
$string['configmessagingdeleteallnotificationsdelay'] = 'Prečítané a neprečítané oznámenia môžu byť odstránené pre uvoľnenie miesta. Ako dlho po tom, čo bolo oznámenie vytvorené, môže byť vymazané?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Upozornenia o prečítaní môžu byť vymazané, čím sa ušetrí miesto na disku. Ako dlho po prečítaní upozornenia môže byť toto vymazané?';
$string['configminpassworddigits'] = 'Heslá musia mať minimálne toľkoto číslic.';
$string['configminpasswordlength'] = 'Heslá musia byť minimálne toľkoto znakov dlhé.';
$string['configminpasswordlower'] = 'Heslá musia mať minimálne toľkoto malých písmen.';
$string['configminpasswordnonalphanum'] = 'Heslá musia mať minimálne toľkoto nealfanumerických znakov.';
$string['configminpasswordupper'] = 'Heslá musia mať minimálne toľkoto veľkých písmen.';
$string['configmypagelocked'] = 'Toto nastavenie zabraňuje upravovanie východzej stránky ne-administrátormi.';
$string['confignavcourselimit'] = 'Obmedzuje počet kurzov zobrazených používateľovi v navigácii.';
$string['confignavshowallcourses'] = 'Či sa majú používateľom v navigácii zobrazovať ich kurzy v položke Moje kurzy a Kurzy (zoznam všetkých kurzov). Ak je vypnuté, potom používatelia uvidia v navigácii iba položku Moje kurzy (zoznam kurzov, v ktorých sú zapísaní).';
$string['confignavshowcategories'] = 'Zobraziť kategórie kurzov v navigačnej lište a v navigačných blokoch. Toto nenastane pre kurzy, v ktorých je používateľ v súčasnosti zapísaný, budú aj naďalej uvedené v svojich predmetoch bez uvedenia kategórií.';
$string['confignoreplyaddress'] = 'Emaily sa niekedy posielajú v mene používateľa (napr. prispievanie do fór). Emailová adresa, ktorú tu špecifikujete, bude používaná ako adresa \'Od koho\' v prípade, ak prijímatelia nie sú schopní priamo odpovedať používateľovi (napr. keď si používateľ vyberie zachovanie súkromnej adresy).';
$string['confignotifyloginfailures'] = 'Ak sa uchovávajú záznamy o neúspešných pokusoch o prihlásenie do systému, komu majú byť posielané. To vyžaduje povoliť vnútorný logstore (napr. štandardný Logstore).';
$string['confignotifyloginthreshold'] = 'Ak sú aktívne oznámenia o neúspešných pokusoch o prihlásenie do systému, koľko takýchto prihlásení od jedného používateľa alebo jednej IP adresy sa má zobrazovať v oznámeniach?';
$string['confignotloggedinroleid'] = 'Neprihlásení návštevníci vašich stránok budú považovaní za používateľov, ktorým je na globálnej úrovni celého serveru priradená táto rola. Väčšinou je ti vhodné mať nastavenú rolu Hosť, ale možno si budete chcieť vytvoriť vlastnú rolu s väčšími či menšími právami. Veci ako pridávanie príspevkov a pod. stále vyžadujú platné prihlásenie.';
$string['configopentowebcrawlers'] = 'Ak aktivujete toto nastavenie, potom Google bude mať oprávnenie vstupu do Vašej stránky ako Hosť. Naviac, ľudia prichádzajúci na Vašu stránku z prostredia vyhľadávača Google, budú automaticky prihlasovaní ako Hostia. Berte prosím na vedomie, že takýto prístup môže byť realizovaný len u tých kurzov, ktoré povoľujú vstup hostí.';
$string['configoverride'] = 'Definované v config.php';
$string['configpasswordpolicy'] = 'Ak toto zapnete, Moodle bude kontrolovať heslá v súlade so zvolenou bezpečnostnou politikou. Nastavenia nižšie ju definujú. Povolení zásad pre heslá nebude mať vplyv na existujúcich používateľov, ak sa nerozhodnú zmeniť svoje heslo alebo ak sa od neho nebude požadovať, kým nebude povolené nastavenie „Skontrolovať heslo pri prihlásení“.';
$string['configpasswordpolicycheckonlogin'] = 'Ak je táto možnosť povolená, heslá používateľov sa pri každom prihlásení používateľa skontrolujú na základe pravidiel týkajúcich sa hesiel. Ak kontrola zlyhá, bude používateľ musieť pokračovať v zmene hesla.
Je užitočné povoliť toto nastavenie po aktualizácii politiky hesla.';
$string['configpasswordresettime'] = 'Toto nastavenie špecifikuje dĺžku času, ktorý majú ľudia na potvrdenie žiadosti o obnovenie hesla pred vypršaním jeho platnosti. Odporúčanou hodnotou je 30 minút.';
$string['configpathtodu'] = 'Cesta k programu du (disk usage). Pravdepodobne niečo ako /usr/bin/du. Zadaním tejto cesty sa urýchli generovanie stránok, ktoré zobrazujú obsah adresára s mnohými súbormi.';
$string['configpathtophp'] = 'Cesta k PHP CLI. Pravdepodobne niečo ako /usr/bin/php. Ak toto zadáte, cron skripty môžu byť spustené z administrátorského webového rozhrania.';
$string['configperfdebug'] = 'Vypisovanie údajov o výkone vášho servera v zápätí štandardnej témy stránok.';
$string['configprofileroles'] = 'Zoznam rol, ktoré sú viditeľné na používateľských profiloch a zozname účastníkov.';
$string['configprofilesforenrolledusersonly'] = 'Z dôvodu zabránenia zneužitia spamermi sú skryté profily používateľov, ktorí ešte nie sú zapísaní do žiadneho kurzu. Noví používatelia sa musia najprv zapísať do nejakého kurzu a až potom si môžu zmeniť informácie vo svojom profile.';
$string['configprotectusernames'] = 'Ak je povolené, formulár zabudnuté heslo nevypisuje žiadny tip, ktorý by dovolil uhádnuť užívateľské mená či emailové adresy.';
$string['configproxybypass'] = 'Čiarkami oddelený zoznam (čiastočných) hostiteľov, alebo IP, ktorá by maia obísť proxy (napr. 192,168.0.0/16,*.mydomain.com)';
$string['configproxyfixunsafe_help'] = 'Toto sa pokúsi opraviť interné spojenie, ktoré neprechádza cez proxy, a to pridaním MoodleBot User Agent a s použitím proxy.';
$string['configproxyhost'] = 'Ak tento <b>server</b> potrebuje používať server proxy (napríklad bránu firewall) pri prístupe na Internet, tak tu uveďte hostiteľské meno. V opačnom prípade to nechajte prázdne.';
$string['configproxylogunsafe_help'] = 'Toto sa pokúša zaznamenať interné hovory, ktoré neprechádzajú cez proxy a mali by.';
$string['configproxypassword'] = 'Heslo potrebné na prístup k internetu cez proxy (ak ho je treba). Ak nie je žiadne, nezadajte nič (je potrebné PHP rozšírenie cURL).';
$string['configproxyport'] = 'Ak sa váš server potrebuje pripájať pomocou proxy, uveďte tu proxy port.';
$string['configproxytype'] = 'Typ web proxy (PHP5 a rozšírenie cURL sú potrebné pre podporu SOCKS5).';
$string['configproxyuser'] = 'Login potrebný na prístup k internetu cez proxy (ak ho je treba). Ak nie je žiadne, nezadajte nič (je potrebné PHP rozšírenie cURL).';
$string['configrecaptchaprivatekey'] = 'Reťazec znakov (tajný kľúč) slúžiaci na komunikáciu medzi serverom Moodle a serverom recaptcha. Kľúče ReCAPTCHA je možné získať na stránke <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Reťazec znakov (kľúč lokality) používaný na zobrazenie prvku reCAPTCHA v registračnom formulári. Kľúče ReCAPTCHA je možné získať na stránke <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Slovo označujúce jedného študenta v požadovaných kurzoch';
$string['configrequestedstudentsname'] = 'Slovo označujúce viacerých študentov v požadovaných kurzoch';
$string['configrequestedteachername'] = 'Slovo označujúce jedného učiteľa v požadovaných kurzoch';
$string['configrequestedteachersname'] = 'Slovo označujúce viacerých učiteľov v požadovaných kurzoch';
$string['configreverseproxyignore'] = 'Ak je váš server za viacerými reverznými proxy servermi, ktoré sa pripájajú k hlavičke X-Forwarded-For, zadajte zoznam adries IP alebo podsietí reverzných proxy serverov, ktoré sa majú ignorovať, aby ste našli správnu adresu IP používateľa.';
$string['configsectioninterface'] = 'Rozhranie';
$string['configsectionmail'] = 'Pošta';
$string['configsectionmaintenance'] = 'Údržba';
$string['configsectionmisc'] = 'Rôzne';
$string['configsectionoperatingsystem'] = 'Operačný systém';
$string['configsectionpermissions'] = 'Práva';
$string['configsectionrequestedcourse'] = 'Žiadosti o založenie kurzov';
$string['configsectionsecurity'] = 'Bezpečnosť';
$string['configsectionstats'] = 'Štatistiky';
$string['configsectionuser'] = 'Používateľ';
$string['configsecureforms'] = 'Moodle môže použiť dodatočné bezpečnostné opatrenia pri akceptovaní vstupov z web formulárov. Ak to umožníte, potom sa bude overovať premenná HTTP_REFERER, ktorú pošle prehliadač a porovná sa s aktuálnou adresou formulára. Toto môže spôsobiť (vo veľmi zriedkavých prípadoch) problémy, napr. ak je používateľ používa firewall, ktorý je konfigurovaný tak, že odstráni premennú HTTP_REFERER. Vtedy sa môže stať, že formulár Vám \'zmrzne\'. Ak sa na to používatelia sťažujú, môžete deaktivovať toto nastavenie. V tomto prípade sa však vystavujete väčším útokom zvonku (brute force password attacks).Ak si nie ste istý, nechajte túto voľbu nastavenú na \'Áno\'.';
$string['configservicespage'] = 'Zadajte adresu URL stránky služieb a podpory alebo nechajte prázdnu, ak chcete odkazovať na služby Moodle na stránke moodle.com. Odkaz sa zobrazí len správcom stránok.';
$string['configsessioncookie'] = 'Toto nastavenie upravuje meno cookie používaného v Moodle sedeniach (sessions). Táto možnosť je voliteľná a užitočná v tom prípade, ak je spustená viac ako jedna kópia Moodle v rámci tej istej www stránky (aby ste sa vyhli popleteniu cookies).';
$string['configsessioncookiedomain'] = 'Toto nastavenie umožňuje nastaviť zmenu domény, z ktorej sú dostupné Moodle cookies. Je to výhodné pre zmeny v  Moodle (napríklad autentifikačné alebo zapisovacie zásuvné moduly), ktoré potrebujú zdieľať informáciu o Moodle session s inými web aplikáciami na inej poddoméne. <strong>UPOZORNENIE: je doporučované ponechať toto nastavenie vo východzom stave (prázdne) - nesprávne nastavenie zabráni všetkým sa prihlásiť na portál.</strong>';
$string['configsessioncookiepath'] = 'Podadresár vašich webových stránok, kam prehliadače odosielajú súbory cookie vašej inštalácie Moodle. Pravdepodobne vám bude vyhovovať východzie nastavenie \'/\' .';
$string['configsessiontimeout'] = 'Ak sú ľudia pripojení na túto stránku dlho nečinní (bez "prechádzania" stránok), sú automaticky odpojení (ich sedenie je ukončené). Táto premenná určuje, aký dlhý by mal byť ten časový interval nečinnosti.';
$string['configsessiontimeoutwarning'] = 'Ak sú ľudia prihlásení na tomto portáli dlhší čas nečinní (bez načítania stránok), sú upozornení, že ich sedenie čoskoro skončí. Táto premenná určuje, aký dlhý časový interval by to mal byť.';
$string['configsessiontimeoutwarningcheck'] = 'Upozornenie na časový limit sedenia musí byť skôr ako samotný časový limit sedenia.';
$string['configshowcommentscount'] = 'Zobraziť počet komentárov. Bude to stáť jeden SQL dotaz naviac pri zobrazení odkazu na komentáre.';
$string['configshowicalsource'] = 'Zobraziť zdrojovú informáciu pre iCal udalosti';
$string['configshowsiteparticipantslist'] = 'Všetci títo portáloví študenti a učitelia budú v zozname účastníkov portálu. Komu by malo byť povolené prezeranie tohto zoznamu?';
$string['configsitedefaultlicense'] = 'Východisková licencia portálu';
$string['configsitedefaultlicensehelp'] = 'Východisková licencia pre publikovanie obsahu na portáli.';
$string['configsitemailcharset'] = 'Východzia znaková sada pre e-maily generované vašimi stránkami. Ak povolíte nasledujúcu možnosť, každý užívateľ si môže túto znakovú sadu zmeniť.';
$string['configsitemaxcategorydepth'] = 'Maximálna hĺbka podkategórií';
$string['configsitemaxcategorydepthhelp'] = 'Toto určuje maximálnu zobraziteľnú hĺbku podriadených kategórií v hierarchiách alebo rozbaľovacom zozname. Ďalšie úrovne môžu byť zobrazené ako odkazy na základe AJAX požiadavky používateľa.';
$string['configslasharguments'] = 'Súbory (obrázky atď.) sú prenášané prostredníctvom skriptu používajúceho značku \'lomítko\' (pomocou <em>PATH_INFO</em>). Táto metóda umožňuje, aby boli súbory ľahšie zachytené na webových prehliadačoch, proxy serveroch atď. Bohužiaľ, niektoré PHP servery  túto metódu nepodporujú. Ak máte problémy pri zobrazovaní stiahnutých súborov alebo obrázkov (napr. obrázky používateľa), deaktivujte toto nastavenie. <br/> Poznámka: Používanie "URL s názvom súboru za lomítkom" bude potrebné v budúcich verziách Moodle.';
$string['configsmtpauthtype'] = 'Tým sa nastaví typ autentifikácie, ktorý sa má použiť na smtp serveri.';
$string['configsmtphosts'] = 'Zadajte plný názov jedného alebo viacerých SMTP serverov, ktoré má Moodle používať pri posielaní pošty (napríklad \'mail.a.com\' alebo \'mail.a.com;mail.b.com\'). Pre zadanie neštandardného portu (t.j. iného ako 25), môžete použiť syntax [server]:[port] (napríklad \'mail.a.com:587\'). Ak neuvediete nič, Moodle použije postup posielania pošty pomocou PHP východzej metódy.';
$string['configsmtpmaxbulk'] = 'Maximálny počet správ poslaných v jednej SMTP sekcii. Zoskupovanie správ môže zrýchliť posielanie mailov. Hodnoty nižšie ako 2 vynucujú vytvorenie novej sekcie SMTP pri každom maili.';
$string['configsmtpoauthservice'] = 'Vyberte službu OAuth 2, ktorá je nakonfigurovaná na komunikáciu so serverom SMTP. Ak služba ešte neexistuje, budete ju musieť vytvoriť. Všimnite si, že musíte nastaviť typ overenia SMTP na hodnotu XOAUTH2.';
$string['configsmtpsecure'] = 'Ak server SMTP vyžaduje zabezpečené pripojenie, zadajte správny typ protokolu.';
$string['configsmtpuser'] = 'Ak ste hore uviedli SMTP server a ten vyžaduje overovanie, uveďte tu používateľské meno a heslo.';
$string['configstartwday'] = 'Začiatok týždňa';
$string['configstatsfirstrun'] = 'Ako ďaleko do minulosti sa majú spracovať štatistiky <b>pri prvom spustení</b> tejto naplánovanej úlohy. Toto prvé spracovanie môže trvať dlho a je dosť náročné na systémové zdroje serveru. Ak je teda na vašich stránkach veľká prevádzka a máte okrem toho Moodle nainštalovaný na zdieľanom hostingovom serveri, nedoporučujeme nastavovať príliš veľkú hodnotu. Pre účely tohto nastavenia sa jedným mesiacom chápe 28 dní. V generovaných grafoch a štatistikách odpovedá jeden mesiac jednému kalendárnemu mesiacu.';
$string['configstatsmaxruntime'] = 'Spracovanie štatistík môže byť značne náročné. Využite preto toto a nasledujúce pole a nastavte, kedy bude táto úloha spustená a ako dlho pobeží.';
$string['configstatsmaxruntime2'] = 'Spracovanie štatistík môže byť značne náročné. Maximálny počet spracovaných dní na jedno spustenie úlohy cronu je 31.';
$string['configstatsmaxruntime3'] = 'Určenie maximálneho časového intervalu pre spracovanie štatistík pre jeden deň. Treba vziať do úvahy, že spracovanie štatistík výrazne zaťažuje server. Nižšie možno definovať maximálny počet dní, ktoré budú spracovávané v jednej úlohe cron.';
$string['configstatsruntimedays'] = 'Určenie maximálneho počtu dní spracovaných pri spustení štatistík. Ak sú štatistiky aktuálne, bude spracovaný iba posledný deň. Nastavenie tejto premennej závisí od vyťaženia servera. Znížte, ak treba skrátiť dĺžku trvania úlohy cron.';
$string['configstatsruntimestart'] = 'Kedy sa má spustiť úloha spracúvajúca štatistiky? Ak na tomto serveri existuje viacero inštancií Moodle, potom zvoľte rozličné časy.';
$string['configstatsuserthreshold'] = 'Pri vyhodnocovaní kurzov budú ignorované tie, v ktorých je zapísaných menej používateľov než uvedená nenulová hodnota.';
$string['configstrictformsrequired'] = 'Ak je táto možnosť aktivovaná, používateľom je zabránené vložiť medzeru alebo zlom riadku okrem polí, kde sa to požaduje vo formulároch.';
$string['configstripalltitletags'] = 'Vypnite toto nastavenie pre povolenie HTML tagov v názvoch aktivít a zdrojov.';
$string['configsupportavailability'] = 'Určuje, kto má prístup ku kontaktovaniu podpory lokality z päty stránky.';
$string['configsupportemail'] = 'Ak je na tejto lokalite nakonfigurovaný SMTP a stránka podpory nie je nakonfigurovaná, na túto e-mailovú adresu sa budú odosielať všeobecné žiadosti o pomoc odoslané prostredníctvom formulára podpory. Ak odoslanie zlyhá, táto e-mailová adresa sa zobrazí prihláseným používateľom.';
$string['configsupportname'] = 'Meno osoby alebo úradu, ktorý bude poskytovať pomoc pomocou mailovej adresy alebo webovej stránky.';
$string['configsupportpage'] = 'Zadajte adresu URL stránky podpory alebo ju nechajte prázdnu, ak chcete prepojiť na kontaktný formulár. Odkaz sa zobrazí v pätičke stránky.';
$string['configtempdatafoldercleanup'] = 'Odstrániť z dátového adresára súbory s dočasnými dátami, ktoré sú staršie ako zvolený čas.';
$string['configthemedesignermode'] = 'Za normálnych okolností sú všetky obrázky použité v témach a css súbory z dôvodu zlepšenia výkonu uložené vo vyrovnávacej pamäti prehliadačov a na serveri veľmi dlhý čas. Ak vytvárate tému alebo upravujete zdrojový kód, potom vám odporúčame zapnúť tento mód, aby sa nezobrazovali verzie  uložené vo vyrovnávacej pamäti. UPOZORNENIE: toto nastavenie spomalí vašu stránku pre všetkých používateľov! Alternatívne tiež môžete obnoviť cache pamäť tém manuálne na stránke voľby tém.';
$string['configthemelist'] = 'Pokiaľ ponecháte toto pole prázdne, povolíte použitie ktorejkoľvek platnej témy. Pokiaľ chcete skrátiť výber tém, môžete tu určiť zoznam mien tém oddelených čiarkou. Napríklad: standard,orangewhite. Nepoužívajte medzery.';
$string['configtimezone'] = 'Tu môžete nastaviť východzie časové pásmo, v ktorom sa nachádza server. Každý používateľ toto môže zmeniť vo svojom profile. \'Úlohy spúšťané pomocou cronu sú na základe tohto nastavenia. Mali by ste ho zmeniť, ak sa ukáže "Neplatné časové pásmo".';
$string['configuseblogassociations'] = 'Majú byť používatelia schopní si organizovať svoj blog priradením príspevkov s kurzmi a ich modulmi?';
$string['configusesitenameforsitepages'] = 'Ak je táto možnosť aktivovaná, namiesto názvu \'Stránky portálu\' sa bude zobrazovať skrátená verzia názvu.';
$string['configusetags'] = 'Má byť funkcionalita tagov zapnutá na portáli?';
$string['configvariables'] = 'Všeobecné premenné';
$string['configverifychangedemail'] = 'Povoliť kontrolu zmeneného mailu pomocou nastavení povolených a zakázaných domén. Ak je toto nastavenie nepovolené, kontrola domén je vykonávaná iba pri vytváraní používateľov.';
$string['configvisiblecourses'] = 'Zobrazovať kurzy v skrytých kategóriách normálne';
$string['configwarning'] = 'Postupujte veľmi opatrne pri zmenách týchto nastavení - nesprávne hodnoty môžu spôsobiť problémy.';
$string['configyuicomboloading'] = 'Táto voľba umožňuje optimalizáciu nahrávania kombinovaných súborov pre YUI knižnice. Toto nastavenie by malo byť aktivované na produkčných portáloch z dôvodu zlepšenia výkonu.';
$string['confirmation'] = 'Potvrdenie';
$string['confirmationpending'] = 'Čaká sa na potvrdenie';
$string['confirmcontextlock'] = '{$a->contextname} je v súčasnosti nezmrazený. Zmrazením sa sprístupní iba pre čítanie a používateľom zabráni, aby vykonali zmeny. Naozaj chcete pokračovať?';
$string['confirmcontextunlock'] = '{$a->contextname} je v súčasnosti zmrazený. Rozmrazenie umožní používateľom vykonávať zmeny. Naozaj chcete pokračovať?';
$string['confirmdeletecomments'] = 'Naozaj chcete odstrániť vybraté komentáre?';
$string['confirmed'] = 'Potvrdené';
$string['contactsitesupport'] = 'Kontakt na podporu na portáli';
$string['contenttypeuninstalling'] = '{$a->count} obsah podporuje {$a->type}. Budú odstránené. Naozaj chcete pokračovať?';
$string['contextlockappliestoadmin'] = 'Zmrazenie kontextu sa týka správcov';
$string['contextlockappliestoadmin_desc'] = 'Ak je zakázané, administrátori majú prístup k zápisu do ľubovoľného zmrazeného kontextu.';
$string['contextlocking'] = 'Kontext zamrazený';
$string['contextlocking_desc'] = 'Toto nastavenie umožňuje nastaviť pre vybrané kategórie, kurzy, aktivity alebo bloky prístup iba na čítanie.';
$string['cookiesecure'] = 'Iba bezpečné cookies';
$string['country'] = 'Východzia krajina';
$string['course_customfield'] = 'Vlastné polia kurzu';
$string['coursecolor'] = 'farba';
$string['coursecolorheading_desc'] = 'Všetky kurzy bez obrázka kurzu nastaveného v nastaveniach kurzu sa zobrazia na paneli Dashboard so vzorovanou kartou kurzu. Farby použité vo vzore môžu byť špecifikované nižšie.';
$string['coursecolorsettings'] = 'Farby kariet kurzu';
$string['coursecontact'] = 'Vedúci kurzov';
$string['coursecontact_desc'] = 'Ktorých používateľov zobrazovať pri opise kurzu. Používatelia potrebujú aspoň jednu z týchto rol v danom kurze, aby boli zobrazení pri jeho opise.';
$string['coursecontactduplicates'] = 'Zobraziť kontaktné role všetkých kurzov';
$string['coursecontactduplicates_desc'] = 'Ak je to povolené, používatelia s viac ako jednou z vybratých kontaktných rolí kurzu sa v popise kurzu zobrazia s každou zo svojich rolí. V opačnom prípade sa zobrazia iba s jednou rolou (podľa toho, ktorá z možností „Definovať roly“ v správe webu je uvedená najvyššie).';
$string['coursecreationguide'] = 'URL adresa stránok tvorby Moodle kurzu';
$string['coursecreationguide_help'] = 'Definuje cestu k rýchlej príručke s krátkymi videami a všeobecnými tipmi na vytváranie kurzov. Ak neexistujú žiadne kurzy na zobrazenie, na stránke Moje kurzy sa zobrazí odkaz na sprievodcu. Odkaz sa zobrazí iba používateľom so schopnosťou vytvárať kurzy.';
$string['coursegraceperiodafter'] = 'Čas odkladu pre minulé kurzy';
$string['coursegraceperiodbefore'] = 'Čas odkladu pre budúce kurzy';
$string['courselistshortnames'] = 'Zobrazovať krátke názvy kurzov';
$string['courselistshortnames_desc'] = 'Ak je povolené, budú uvedené v zozname kurzov kurzy včítane svojho krátkeho názvu. V prípade potreby môže byť celé meno kurzu prispôsobené úpravou  jazykového reťazca "courseextendednamedisplay" pomocou funkcie úprava jazyka.';
$string['coursemgmt'] = 'Spravovať kurzy a ich kategórie';
$string['courseoverview'] = 'Prehľad kurzov';
$string['courserequestnotify'] = 'Upozornenie o žiadosti o kurz';
$string['courserequestnotifyemail'] = '{$a->user} požiadal o nový kurz <a href="{$a->link}">{$a->link}</a>';
$string['courserequests'] = 'Požadované kurzy';
$string['courserequestspending'] = 'Nevybavené žiadosti o kurz';
$string['courses'] = 'Kurzy';
$string['coursesperpage'] = 'Počet kurzov na stránke';
$string['courseswithsummarieslimit'] = 'Kurzy s obmedzením zhrnutí';
$string['creatornewroleid'] = 'Rola tvorcov v nových kurzoch';
$string['creatornewroleid_help'] = 'Ak používateľ ešte nemá povolenie spravovať nový kurz, používateľ je automaticky prihlásený využitím tejto používateľskej roly.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Povoliť cron';
$string['cron_enabled_desc'] = 'Cron by mal byť normálne povolený, ale toto nastavenie umožňuje jeho dočasné vypnutie, napríklad pred reštartovaním serveru. Ak je zakázané, systému se bráni v spustení nových úloh na pozadí. Pamätajte, že cron by nemal byť dlho deaktivovaný, pretože to zabráni fungovaniu dôležitých funkcií.';
$string['cron_help'] = 'Skript cron.php spúšťa viacero úloh v rôznych naplánovaných intervaloch, ako je posielanie e-mailov s príspevkami fór. Skript by mal byť spúšťaný pravidelne - v ideálnom prípade každú minútu.';
$string['cron_keepalive'] = 'Udržiavať naživo';
$string['cron_keepalive_desc'] = 'Čas, počas ktorého sa má uskutočniť testovanie pre pre ďalšie úlohy. Toto nastavenie slúži na zabezpečenie toho, aby bol cron vždy spustený. Ak používate vyhradené spúšťače úloh, nastavte ho na 0. V opačnom prípade ho nastavte na hodnotu podobnú limitu súbežnosti adhoc úloh. Vyhnite sa dlhším časom. Maximálny čas je 15 minút.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Spustenie cronu iba z príkazového riadku';
$string['cronerrorclionly'] = 'Ľutujem. Prístup na túto stránku z webového rozhrania bol správcom zakázaný.';
$string['cronerrorpassword'] = 'Ľutujem. Pre prístup na túto stránku musíte použiť platné heslo.';
$string['croninfrequent'] = 'Medzi poslednými dvomi spusteniami skriptu pre údržbu cron bol interval {$a->actual} a mal by byť spustený každý {$a->expected}. Doporučujeme ho nakonfigurovať tak, aby bolo spúšťanie častejšie.';
$string['cronremotepassword'] = 'Heslo pre spustenia cronu';
$string['cronwarning'] = '<a href="{$a->url}">admin/cron.php script</a> nebol spustený najmenej 24 hodín.';
$string['cronwarningcli'] = 'Skript <code>admin/cli/cron.php</code> nebol spustený v {$a->actual} a mal by byť spustený každých {$a->expected}.';
$string['cronwarningnever'] = 'Skript <code>admin/cli/cron.php</code> nebol nikdy spustený a mal by byť spustený každých {$a->expected}.';
$string['cronwarningneverweb'] = 'Skript <a href="{$a->url}">admin/cron.php </a> nebol nikdy spustený a mal by byť spustený každých {$a->expected}.';
$string['ctyperequired'] = 'Voliteľná knižnica ctype je vyžadovaná v Moodle na zlepšenie výkonu na portáli a podporu kompatibility viacerých jazykov.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'PHP rozšírenie CURL je teraz vyžadované Moodle, aby bola umožnená komunikácia úložísk Moodle.';
$string['curlsecurityallowedport'] = 'cURL zoznam povolených portov';
$string['curlsecurityallowedportsyntax'] = 'Zoznam čísel portov, cez  ktoré sa cURL môže pripojiť. Platné hodnoty sú iba celé čísla. Zadajte každý záznam na nový riadok. Ak je ponechaný prázdny, potom sú povolené všetky porty. Ak je nastavené, potom väčšinou by malo byť nastavené na 443 a 80 pre pripojenie cURL k štandardným portom HTTPS a HTTP.';
$string['curlsecurityblockedhosts'] = 'cURL zoznam blokovaných hostiteľov';
$string['curlsecurityblockedhostssyntax'] = 'Vložte každý záznam na samostatný riadok. Platné hodnoty sú buď celá IPv4 alebo IPv6 adresa (napr. 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), ktoré odpovedajú jednému hostiteľskému systému; alebo CIDR notícia (napr. 231.54.211.0/20 alebo fe80::/64); alebo rozsah IP adries (napr. 231.3.56.10-20 alebo fe80::1111-bbbb), kde rozsah platí pre poslednú skupiny adresy; alebo názvy domén (napr. localhost alebo example.com); alebo zástupné doménové mená (napr. *.example.com alebo *.sub.example.com). Prázdne riadky nie sú povolené.';
$string['curlsecurityurlblocked'] = 'Adresa URL je zablokovaná.';
$string['curltimeoutkbitrate'] = 'Najnižšia predpokladaná rýchlosť stahovanie cez cURL (kb/s)';
$string['curltimeoutkbitrate_help'] = 'Toto nastavenie sa používa na výpočet vhodného časového limitu počas veľkých cURL požiadaviek. Ako súčasť tohto výpočtu sa vykoná HTTP HEAD požiadavka, aby sa zistila veľkosť obsahu. Použitím čísla 0 v tomto nastavení sa deaktivuje vykonanie tejto požiadavky.';
$string['currenttheme'] = 'Aktuálna téma';
$string['customcheck'] = 'Ostatné kontroly';
$string['custommenu'] = 'Vlastné menu';
$string['custommenuitems'] = 'Položky vlastného menu';
$string['customusermenuitems'] = 'Položky menu používateľa';
$string['datarootsecurityerror'] = '<p><strong>BEZPEČNOSTNÉ UPOZORNENIE!</strong></p><p>Váš dátový adresár je na nesprávnom mieste a dostupný z webu. To znamená, že všetky vaše súkromné súbory sú prístupné každému na svete a niektoré z nich môžu byť zneužité crackermi na získanie neoprávneného administratívneho prístupu k vášmu portálu !</p>
<p><em>Musíte</em> presunúť  dátový adresár ({$a}) na nové miesto, ktoré sa nenachádza vo verejnom web adresári a aktualizovať nastavenie <code>$CFG->dataroot</code> vo vašom súbore config.php.</p>';
$string['datarootsecuritywarning'] = 'Vaša inštalácia Moodle nemusí byť bezpečná. Prosím zabezpečte, aby váš dátový adresár ({$a}) nebol priamo dostupný z webu';
$string['dbprefixtoolong'] = 'Predpona databázy vašej stránky ($CFG->prefix) je príliš dlhá ({$a->current} znakov). Maximálny povolený počet znakov je {$a->maximum}.';
$string['dbsessions'] = 'Informácie o session ukladať v databáze';
$string['debug'] = 'Ladiace informácie';
$string['debugall'] = 'ALL: Zobrazovať všetky zmysluplné ladiace informácie z PHP';
$string['debugdeveloper'] = 'DEVELOPER: zobrazovať extra informácie pre vývojárov Moodle';
$string['debugdisplay'] = 'Zobrazenie ladiacich informácií';
$string['debugging'] = 'Ladenie';
$string['debugminimal'] = 'MINIMAL: Zobrazovať iba kritické chyby';
$string['debugnone'] = 'NONE: Nezobrazovať žiadne správy ani varovania';
$string['debugnormal'] = 'NORMAL: Zobrazovať chyby, varovania a upozornenia';
$string['debugpageinfo'] = 'Zobraziť informácie o stránke';
$string['debugsqltrace'] = 'Zobraziť pôvod volaní SQL';
$string['debugsqltrace1'] = 'Zobraziť iba jednu volaciu linku';
$string['debugsqltrace100'] = 'Zobraziť celú stopovú stopu';
$string['debugsqltrace2'] = 'Zobraziť 2 riadky sledovania stôp';
$string['debugsqltrace_desc'] = 'Ak je povolené, do SQL sa ako komentár pridá čiastočné alebo úplné trasovanie zásobníka PHP.';
$string['debugstringids'] = 'Zobraziť pôvod jazykových reťazcov';
$string['debugstringids_desc'] = 'Ak je aktivované, zobrazia sa komponenty jazykových reťazcov a identifikátory, keď k adresám URL stránky sú pripojené reťazce ?strings=1 alebo   &strings=1.';
$string['debugtemplateinfo'] = 'Zobraziť informácie o šablóne';
$string['debugtemplateinfo_desc'] = 'Ak je táto možnosť povolená, šablóny použité na vykresľovanie sa zobrazujú ako komentáre v HTML stránke. Po zmene nastavenia je potrebné vyčistiť vyrovnávaciu pamäť. Používajte len na dočasné ladenie, pretože spôsobuje chyby validácie HTML a môže narušiť skripty stránky. Môže tiež narušiť základnú funkčnosť!';
$string['debugvalidators'] = 'Zobraziť validačné odkazy';
$string['defaultcity'] = 'Predvolené mesto';
$string['defaultcity_help'] = 'Zadané mesto bude predvolené pri vytváraní nových používateľských účtov.';
$string['defaultformatnotset'] = 'Chyba pri nastavení východzieho formátu kurzu. Skontrolujte nastavenia portálu.';
$string['defaulthomepage'] = 'Domovská stránka používateľov';
$string['defaultrequestcategory'] = 'Východzia kategória pre požadované kurzy';
$string['defaultsettinginfo'] = 'Východzí: {$a}';
$string['defaultuserroleid'] = 'Východzia rola pre všetkých používateľov';
$string['deleteduserx'] = 'Odstránený používateľ {$a}';
$string['deleteincompleteusers'] = 'Odstrániť nekompletne vytvorených používateľov po';
$string['deleteunconfirmed'] = 'Odstrániť nepotvrdené a neúplne účty po';
$string['deleteuser'] = 'Odstrániť používateľov';
$string['density'] = 'Hustota';
$string['denyemailaddresses'] = 'Zakázané emailové domény';
$string['development'] = 'Vývoj';
$string['devicedetectregex'] = 'Regulárne výrazy pre detekciu zariadenia';
$string['devicedetectregex_desc'] = '<p>V predvolenom nastavení dokáže Moodle rozpoznať zariadenia typu predvolené (stolné počítače, notebooky atď.), mobilné zariadenia (telefóny a malé ručné zariadenia), tablety (iPady, tablety so systémom Android) a staršie zariadenia (používatelia prehliadača Internet Explorer 6). Výber tém možno použiť na použitie samostatných tém na všetky z nich. Toto nastavenie umožňuje regulárne výrazy, ktoré umožňujú detekciu ďalších typov zariadení (tieto majú prednosť pred predvolenými typmi).</p>
<p>Môžete napríklad zadať regulárny výraz \'/(MIDP-1.0|Maemo|Windows CE)/\', aby ste zistili, že niektoré bežne používané funkčné telefóny pridajú návratovú hodnotu \'featurephone\'. Tým sa do voliča tém pridá „featurephone“, ktorý vám umožní pridať tému, ktorá sa použije na týchto zariadeniach. Iné telefóny budú stále používať tému vybratú pre typ mobilného zariadenia.</p>';
$string['devicedetectregexexpression'] = 'Regulárny výraz';
$string['devicedetectregexvalue'] = 'Návratová hodnota';
$string['devicetype'] = 'Typ zariadenia';
$string['devlibdirpresent'] = 'Adresáre s vývojovými knižnicami, najmä <em> vendor</em> alebo <em> node_modules </em>, by sa nemali nachádzať na verejných serveroch. Ďalšie podrobnosti nájdete v prehľade zabezpečenia <a href="{$a->moreinfourl}"> Prehľad zabezpečenia </a>.';
$string['disabled'] = 'Zakázané';
$string['disableplugin'] = 'Zakázať {$a}';
$string['disableuserimages'] = 'Zrušiť profilové fotografie v používateľských profiloch';
$string['displayerrorswarning'] = 'Zapnutie PHP nastavenia <em>display_errors</em> nie je doporučované na produkčných portáloch, pretože niektoré chybové správy môžu ukázať citlivé informácie o Vašom serveri.';
$string['displayloginfailures'] = 'Zobrazovať neúspešné prihlásenia:';
$string['divertallemails'] = 'presmerovanie emailu';
$string['divertallemailsdetail'] = 'Používa sa ako ochrana vo vývojových prostrediach pri testovaní e-mailov a nemala by sa používať vo výrobe.';
$string['divertallemailsexcept'] = 'Výnimky týkajúce sa presmerovania e-mailov';
$string['divertallemailsexcept_desc'] = 'Zoznam pravidiel výnimiek e-mailu oddelených čiarkami alebo novými riadkami. Každé pravidlo je interpretované ako regulárny výraz, napr. <pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Presmerovať všetky emaily';
$string['divertallemailsto_desc'] = 'Keď nastavené, všetky emaily budú presmerované na jednu emailovú adresu';
$string['dndallowtextandlinks'] = 'Pre nahranie potiahnite myšou text/odkaz';
$string['doclang'] = 'Jazyk dokumentácie';
$string['docroot'] = 'Umiestnenie dokumentácie';
$string['doctonewwindow'] = 'Otvárať v novom okne';
$string['doesnotfit'] = 'Nastavenia zobrazenia e-mailu';
$string['doesnotfitdetail'] = 'Nastavenia zobrazenia pre e-mail odoslaný z Moodle.';
$string['download'] = 'Stiahnuť';
$string['downloadcoursecontentallowed'] = 'Sťahovanie obsahu kurzu k dispozícii';
$string['downloadcoursecontentallowed_desc'] = 'Či je v kurzoch k dispozícii funkcia ku stiahnutiu obsahu kurzu. Ak je k dispozícii, stiahnutie obsahu kurzu je možné povoliť/zakázať pomocou nastavenia „Povoliť sťahovanie obsahu kurzu“ v ponuke úprav kurzu (východzie nastavenie je možné nastaviť vo <a href={$a} target="_blank"> východzom nastavení kurzu </a>).';
$string['durationunits'] = 'jednotky časového trvania';
$string['edithelpdocs'] = 'Upraviť dokumentáciu nápovedy';
$string['editlang'] = '<b>Úpravy</b>';
$string['editorbackgroundcolor'] = 'Farba pozadia';
$string['editordictionary'] = 'Slovník editora';
$string['editorfontfamily'] = 'Rodina fontov';
$string['editorfontlist'] = 'Zoznam fontov';
$string['editorfontsize'] = 'Veľkosť fontu';
$string['editorhidebuttons'] = 'Skryté tlačidlá';
$string['editorkillword'] = 'Čistenie formátu z MS Word';
$string['editorspelling'] = 'Pravopis editora';
$string['editorspellinghelp'] = 'Povoliť alebo zakázať kontrolu pravopisu. Ak je povolené, musí byť na serveri nainštalovaný <strong>aspell</strong>.';
$string['editstrings'] = 'Upraviť textové reťazce';
$string['emailchangeconfirmation'] = 'Potvrdenie zmeny emailu';
$string['emaildkim'] = 'Podpisovanie emailov pomocou DKIM (DomainKeys Identified Mail)';
$string['emaildkiminfo'] = 'Ak je nastavený selektor DKIM a zároveň sa nájde súbor súkromného certifikátu, ktorý sa zhoduje s doménou adresy „Od“ e-mailu v $CFG->dataroot/dkim/[doména]/[selektor].private, e-mail bude podpísaný. Vo väčšine prípadov (napríklad, ak sú povolené e-mailové domény prázdne) je potrebný iba jeden certifikát v <pre>{$a->path}</pre>. Ďalšie podrobnosti o nastavení nájdete v dokumentácii <a href="{$a->docs}">Konfigurácia pošty</a>.';
$string['emaildkimselector'] = 'DKIM selektor';
$string['emailfromvia'] = 'E-mail prostredníctvom informácií';
$string['emailheaders'] = 'emailové smerovania';
$string['emailsubjectprefix'] = 'Text predpony predmetu e-mailu';
$string['emoticonalt'] = 'Alternatívny text';
$string['emoticoncomponent'] = 'Obrazový komponent';
$string['emoticonimagename'] = 'Názov obrázku';
$string['emoticons'] = 'Emotikony (smajlíky)';
$string['emoticons_desc'] = 'Tento formulár definuje emotikony (alebo smajlíky) použité na stránkach vášho systému. Na odstránenie riadku z tabuľky uložte formulár s prázdnou hodnotou v ktoromkoľvek z požadovaných polí. Na registráciu nového emotikonu vyplňte polia v poslednom prázdnom riadku. Na obnovenie všetkých polí na štandardné hodnoty postupujte podľa odkazu vyššie.

* Text (povinné) - Tento text bude nahradený obrázkom emotikonu. Musí mať dĺžku najmenej 2 znakov.
* Názov obrázku (povinné) - Názov súboru obrázku emotikonu bez prípony, vzťahujúci sa k priečinku s obrázkami.
* Obrázkový prvok (povinné) - Prvok vytvárajúci ikonu.
* Alternatívny text (voliteľné) - Identifikátor stringu a prvok alternatívneho textu emotikonu.';
$string['emoticonsreset'] = 'Reset nastavenia emotikonov na predvolené hodnoty';
$string['emoticontext'] = 'Text';
$string['emptysettingvalue'] = 'Prázdny';
$string['enableanalytics'] = 'Analýzy';
$string['enableblogs'] = 'Povoliť blogy';
$string['enablecalendarexport'] = 'Povoliť export kalendárov';
$string['enablecomments'] = 'Zobrazovať komentáre';
$string['enablecommunicationsubsystem'] = 'Povoliť komunikačných poskytovateľov';
$string['enablecommunicationsubsystem_desc'] = 'Umožniť integráciu s poskytovateľmi komunikačných služieb, ako je Matrix, aby učitelia a študenti mohli ľahšie komunikovať. Tieto integrácie môžete spravovať v <a href="settings.php?section=managecommunicationproviders">Plugins</a>.';
$string['enablecourserelativedates'] = 'Povoliť relatívny dátum kurzu';
$string['enablecourserelativedates_desc'] = 'Povoliť, aby boli kurzy nastavené tak, aby zobrazovali dátum relatívny k dátumu štartu používateľa v kurze.';
$string['enablecourserequests'] = 'Povoliť žiadanie kurzov';
$string['enabled'] = 'Povolený';
$string['enabledashboard'] = 'Povoliť nástenku';
$string['enabledashboard_help'] = 'Nástenka zobrazuje vo východzom nastavení položky Časová os, Kalendár a Naposledy použité. Pre každého môžete nastaviť inú východziu Nástenku a umožniť používateľom prispôsobiť si vlastnú Nástenku. Ak je táto možnosť zakázaná, musíte nastaviť „Úvodná stránka pre používateľov“ na inú hodnotu ako Nástenka.';
$string['enabledevicedetection'] = 'Povoliť detekciu zariadení';
$string['enableglobalsearch'] = 'Povoliť globálne vyhľadávanie';
$string['enableglobalsearch_desc'] = 'Ak je povolené, údaje budú indexované a synchronizované naplánovanou úlohou.';
$string['enablegravatar'] = 'Povoliť Gravatar';
$string['enablegravatar_help'] = 'Ak je povolené, Moodle sa pokúsi načítať profilový obrázok používateľa z Gravatar, ak používateľ nenahral svoj profilový obrázok.';
$string['enablemobilewebservice'] = 'Povoliť webové služby pre mobilné zariadenia';
$string['enablepdfexportfont'] = 'Povoliť písmo PDF';
$string['enablepdfexportfont_desc'] = 'Ak sú na vašom portáli kurzy v rôznych jazykoch, ktoré vyžadujú iné písma vo vygenerovaných súboroch PDF, môžete v nastaveniach kurzu poskytnúť možnosť nastavenia písma. Dostupné fonty musíte zadať v súbore $CFG->pdfexportfont v súbore config.php.';
$string['enableplugin'] = 'Povoliť {$a}';
$string['enablerecordcache'] = 'Povoliť Record Cache';
$string['enablerssfeeds'] = 'Povoliť RSS zdroje';
$string['enablesearchareas'] = 'Povoliť vyhľadávanie oblastí';
$string['enablesharingtomoodlenet'] = 'Povolenie zdieľania do siete MoodleNet (odchádzajúce)';
$string['enablesharingtomoodlenet_desc'] = 'Umožniť používateľom zdieľať obsah kurzu s nakonfigurovanou inštanciou MoodleNet, ak majú príslušné schopnosti.';
$string['enablestats'] = 'Povoliť štatistiky';
$string['enabletrusttext'] = 'Povoliť funkciu dôveryhodného obsahu';
$string['enableuserfeedback'] = 'Povoliť spätnú väzbu k tomuto softvéru';
$string['enableuserfeedback_desc'] = 'Ak je táto možnosť povolená, v pätičke sa zobrazí odkaz „Poskytnúť spätnú väzbu o tomto softvéri“, aby používatelia mohli poskytnúť spätnú väzbu o softvéri Moodle ústrediu Moodle. Ak je nastavená možnosť „Ďalšia pripomienka spätnej väzby“, používateľovi sa v určenom intervale zobrazí aj pripomenutie na informačnom paneli. Nastavením možnosti „Ďalšia pripomienka spätnej väzby“ na možnosť „Nikdy“ sa deaktivuje pripomenutie ovládacieho panela, pričom v pätičke ponecháte odkaz „Poskytnúť spätnú väzbu o tomto softvéri“.';
$string['enablewebservices'] = 'Povoliť webové služby';
$string['enablewsdocumentation'] = 'Dokumentácia pre web servis';
$string['encryptedpassword_edit'] = 'Zadať novú hodnotu';
$string['encryptedpassword_set'] = '(Nastaviť a zašifrovať)';
$string['enroladminnewcourse'] = 'Automaticky zapísať administrátora do nových kurzov';
$string['enroladminnewcourse_help'] = 'Ak administrátor pridá nový kurz, mal by byť automaticky zapísaný s priradenou rolou Tvorca kurzov?';
$string['enrolinstancedefaults'] = 'Predvolené nastavenia zápisov do kurzu';
$string['enrolinstancedefaults_desc'] = 'Východzie nastavenia zápisu do kurzov v nových kurzoch.';
$string['enrolmultipleusers'] = 'Prihlásiť používateľa';
$string['ensureauroraversion'] = 'Váš portál beží na databázovom stroji Amazon Aurora. Skontrolujte, či je verzia MySQL v systéme Amazon Aurora kompatibilná s verziou systému Moodle, ktorú inštalujete alebo na ktorú aktualizujete. Kompatibilitu môžete skontrolovať v <a href="https://docs.aws.amazon.com/AmazonRDS/latest/AuroraMySQLReleaseNotes/AuroraMySQL.Updates.30Updates.html" target="_blank">Aktualizácie databázového stroja pre Amazon Aurora MySQL verzia 3</a>.';
$string['entitytasklog'] = 'Protokol úloh';
$string['environment'] = 'Programové prostredie';
$string['environmenterrortodo'] = 'Pre pokračovanie v inštalácii tejto verzie Moodle je nutné najprv vyriešiť problémy v programovom prostredí (chyby) serveru uvedené vyššie!';
$string['environmenterrorupgrade'] = 'Upozornenie: predtým, kým budete pokračovať v aktualizácii na túto verziu Moodle, vyriešte prosím všetky problémy s prostredím, uvedené vyššie. Ak by ste spustili aktualizáciu pred vyriešením týchto problémov, mohlo by to viesť k problémom, prípadne až k strate údajov. Naozaj chcete pokračovať?';
$string['environmentmariadbwrongdbtype'] = 'Chybný typ $CFG->db. Musíte ho zmeniť v súbore config.php z \'mysqli\' na \'mariadb\'.';
$string['environmentmustfixsetting'] = 'PHP nastavenia musia byť upravené';
$string['environmentok'] = 'Prostredie Vášho servera spĺňa všetky minimálne požiadavky.';
$string['environmentrecommendcustomcheck'] = 'ak tento test nebude úspešne vykonaný, indikuje to prítomnosť problému';
$string['environmentrecommendinstall'] = 'malo by byť nainštalované a povolené';
$string['environmentrecommendversion'] = 'doporučená je verzia {$a->needed}, teraz používate verziu {$a->current}';
$string['environmentrequirecustomcheck'] = 'tento test musí byť úspešne splnený';
$string['environmentrequireinstall'] = 'musí by byť nainštalované a povolené';
$string['environmentrequireversion'] = 'vyžadovaná je verzia {$a->needed}, teraz používate verziu {$a->current}';
$string['environmentsettingok'] = 'Zistené boli odporúčané nastavenia';
$string['environmentshouldfixcustomcheck'] = 'by malo byť povolené, aby sa dosiahli čo najlepšie výsledky.';
$string['environmentshouldfixsetting'] = 'PHP nastavenia by mali upravené';
$string['environmentxmlerror'] = 'Chyba pri zisťovaní údajov o programovom prostredí ({$a->error_code})';
$string['errordeletingconfig'] = 'Vyskytla sa chyba pri vymazaní konfiguračných záznamov zásuvného modulu \'{$a}\'.';
$string['errorsetting'] = 'Nie je možné uložiť nastavenie:';
$string['errorwithsettings'] = 'Niektoré nastavenia neboli zmenené kvôli chybe:';
$string['eventshandlersinuse'] = 'Nasledujúce zásuvné moduly vo vašom systéme používajú zastaralé ovládače z Events 1 API: "{$a}". Aktualizujte ich prosím na použitie Events 2 API. Viac na https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Každý s oprávnením \'{$a}\'';
$string['exceptions'] = 'Výnimka';
$string['execpathnotallowed'] = 'Nastavenie spustiteľných a lokálnych ciest deaktivovaných v config.php';
$string['experimental'] = 'Experimentálne';
$string['experimentalsettings'] = 'Experimentálne nastavenia';
$string['extendedusernamechars'] = 'Povoliť neštandardné znaky v používateľských menách';
$string['extramemorylimit'] = 'Extra PHP limit pamäte';
$string['fatalsessionautostart'] = '<p>Bola nájdená vážna chyba nastavenia, prosím kontaktujte správcu serveru.</p><p>Pre správnu funkciu Moodle je potrebné zmeniť nastavenie PHP.</p><p><code>session.auto_start</code> musí byť nastavený na <code>off</code>.</p><p>Toto nastavenie sa vykoná úpravou súboru <code>php.ini</code>, zmenou nastavenia Apache/IIS <br /> alebo úpravou súboru <code>.htaccess</code> na serveru.</p>';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'Favicon sa zobrazuje vedľa názvu stránky na karte prehliadača. Favicon Moodle sa zobrazí, ak nie je poskytnutá vlastná favicon.';
$string['feedbacksettings'] = 'Nastavenia spätnej väzby';
$string['fileconversioncleanuptask'] = 'Vyčistiť dočasné záznamy pre konverzie súborov.';
$string['filecreated'] = 'Vytvorený nový súbor';
$string['filescleanupperiod'] = 'Vysypať kôš';
$string['filescleanupperiod_help'] = 'Ako často sa odstraňujú súbory z koša. Sú to súbory, ktoré sú spojené s kontextom, ktorý už neexistuje, napríklad keď je kurz odstránený. Poznámka: Toto nastavenie môže viesť k chýbajúcim súborom v kurze, ktorý je zálohovaný, odstránený a potom obnovený, ak je vypnuté nastavenie „Zahrnúť súbory“ (backup_auto_files) v časti „Nastavenia automatického zálohovania“.';
$string['filesizeunits'] = 'jednotky súborovej veľkosti';
$string['filestoredin'] = 'Ukladať súbor do adresára:';
$string['filestoredinhelp'] = 'Kde budú ukladané súbory';
$string['filterall'] = 'Filtrovať všetky reťazce';
$string['filtermatchoneperpage'] = 'Jedna zhoda na stránku';
$string['filtermatchonepertext'] = 'Jedna zhoda na úsek textu';
$string['filternavigationwithsystemcontext'] = 'Filtrovať navigáciu pomocou kontextu systému';
$string['filters'] = 'Filtre';
$string['filtersettings'] = 'Spravovať filtre';
$string['filtersettingsgeneral'] = 'Všeobecné nastavenia filtra';
$string['filteruploadedfiles'] = 'Filtrovať prenášané súbory';
$string['forceclean'] = 'Čistenie obsahu všade';
$string['forceclean_desc'] = 'Obsah pridaný na web sa pred zobrazením normálne vyčistí, aby sa odstránilo všetko, čo by mohlo predstavovať bezpečnostnú hrozbu. Obsah sa však nečistí na určitých miestach, ako sú napríklad popisy aktivít, zdroje stránok alebo bloky HTML, aby bolo možné pridať skripty, médiá, vložené rámce atď. Ak je toto nastavenie povolené, bude VŠETOK obsah vyčistený. To môže mať za následok to, že sa už existujúci obsah nebude správne zobrazovať.';
$string['forcelogin'] = 'Vynútiť prihlásenie';
$string['forceloginforprofileimage'] = 'Vynútiť prihlásenie používateľa na prezeranie používateľských obrázkov';
$string['forceloginforprofileimage_help'] = 'Ak je táto možnosť aktivovaná, používatelia sa musia prihlásiť, aby si mohli prezerať obrázky v profile a štandardný obrázok používateľa bude použitý vo všetkých notifikačných e-mailoch.';
$string['forceloginforprofiles'] = 'Vynútiť prihlásenie pre zobrazovanie profilov';
$string['forcetimezone'] = 'Vynútiť východzie časové pásmo';
$string['formatuninstallwithcourses'] = 'V systéme existuje {$a->count} kurzov využívajúcich {$a->format}. Ich formát bude zmenený na {$a->defaultformat} (štandardný formát pre túto stránku). Niektoré dáta špecifické pre pôvodný formát sa možno stratia. Ste si istý, že chcete pokračovať?';
$string['frontpage'] = 'Titulná stránka';
$string['frontpagebackup'] = 'Záloha titulnej stránky';
$string['frontpagedefaultrole'] = 'Východzia rola na titulnej stránke';
$string['frontpagefilters'] = 'Filtre titulnej stránky';
$string['frontpageloggedin'] = 'Položky na titulnej stránke po prihlásení';
$string['frontpageoverrides'] = 'Prepísanie prístupov titulnej stránky';
$string['frontpagequestions'] = 'Otázky na titulnej stránke';
$string['frontpagerestore'] = 'Obnova titulnej stránky';
$string['frontpageroles'] = 'Role na titulnej stránke';
$string['frontpagesettings'] = 'Nastavenie titulnej stránky';
$string['fullnamedisplay'] = 'Formát celého mena';
$string['fullnamedisplayprivate'] = 'Formát celého mena - privátne';
$string['gdrequired'] = 'GD rozšírenie je potrebné na konverziu obrázka.';
$string['generalsettings'] = 'Všeobecné nastavenia';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Zdroj logovanej IPadresy';
$string['globalsearch'] = 'Globálne vyhľadávanie';
$string['globalsearchmanage'] = 'Spravovať globálne vyhľadávanie';
$string['googlemapkey3'] = 'kľúč Google Maps API V3';
$string['googlemapkey3_help'] = 'Potrebujete vložiť špeciálny kľúč, aby ste moohli Google Maps použiť pre vizualizáciu vyhľadávania IP adresy. Kľúč môžete získať bezplatne na <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Prvý chýbajúci reťazec';
$string['gradebook'] = 'Klasifikácia';
$string['gradebookroles'] = 'Klasifikovaní používatelia';
$string['gradeexport'] = 'Primárne metódy exportu známok';
$string['gradeexportdefault'] = 'Predvolená metóda exportu známok';
$string['gravatardefaulturl'] = 'URL štandardného obrázku Gravataru';
$string['gravatardefaulturl_help'] = 'Gravatar vyžaduje zobrazenie štandardného obrázka, ak nie je možné nájsť obrázok pre daného používateľa. Vložte úplnu URL adresu obrázka. Ak necháte toto nastavenie prázdne, Moodle sa pokúsi použiť najvhodnejší štandardný obrázok pre stránku, ktorú si prezeráte. Poznámka: Gravatar má množstvo kódov, ktoré je možné použiť, na  <a href="https://en.gravatar.com/site/implement/images/#default-image">generovanie prednastavených obrázkov</a>.';
$string['group_customfield'] = 'Vlastné polia skupiny';
$string['groupenrolmentkeypolicy'] = 'Politika prihlasovacieho kľúča pre skupiny';
$string['groupenrolmentkeypolicy_desc'] = 'Ak je táto možnosť povolená, skupinové registračné kľúče sa skontrolujú na základe pravidiel pre heslo, ako je uvedené v nastaveniach vyššie.';
$string['grouping_customfield'] = 'Vlastné polia zoskupenia';
$string['guestroleid'] = 'Rola hosťa';
$string['guestroleid_help'] = 'Táto rola je automaticky pridelená hosťujúcemu používateľovi. Je tiež dočasne pridelená nezapísaným používateľom, ktorí vstúpia do kurzu cez plugin hosťovského zápisu.';
$string['h5pgetcontenttypestask'] = 'Stiahnite si dostupné typy obsahu H5P z webu h5p.org';
$string['helpadminseesall'] = 'V kalendári: vidia a filtrujú administrátori udalosti zo všetkých kalendárov kurzov alebo iba z kurzov, v ktorých sú zapísaní? Bez ohľadu na zvolenú možnosť budú administrátori vždy môcť spravovať udalosti pre každý kalendár kurzov tým, že budú navigovať najprv do kurzov a potom pristupovať priamo do kalendára kurzu.';
$string['helpcalendarcustomexport'] = 'Aktivovať možnosť exportu vlastného časového rozsahu v exportoch kalendára. Pred použitím tohto nastavenia je potrebné aktivovať funkciu exportu kalendára.';
$string['helpexportlookahead'] = 'Koľko dní nasledujúcich za dnešným dňom má kalendár hľadať udalosti počas exportu pre možnosť vlastného exportu?';
$string['helpexportlookback'] = 'Koľko dní pred dnešným dňom má kalendár hľadať udalosti počas exportu pre možnosť vlastného exportu?';
$string['helpforcetimezone'] = 'Môžete povoliť používateľom, aby si individuálne zvolili ich vlastné časové pásmo, alebo nastaviť jedno časové pásmo pre každého.';
$string['helpshowicalsource'] = 'Ak je táto možnosť aktivovaná, pre importované udalosti cez formát iCal sa zobrazí preddefinovaný názov a odkaz.';
$string['helpsitemaintenance'] = 'Pre aktualizácie a ďalšiu údržbu';
$string['helpstartofweek'] = 'Ktorým dňom v týždni by sa mal začínať týždeň v kalendári?';
$string['helpupcominglookahead'] = 'Koľko dní dopredu sa má štandardne zobrazovať v kalendári pri prezeraní nadchádzajúcich udalostí?';
$string['helpupcomingmaxevents'] = 'Koľko nadchádzajúcich udalostí (maximum) sa má štandardne zobrazovať používateľom?';
$string['helpweekenddays'] = 'Ktoré dni v týždni sú považované za "víkend", t.j. sú označené inou farbou?';
$string['hiddenuserfields'] = 'Skryť používateľské polia';
$string['hidefromall'] = 'Skryť všetkým používateľom';
$string['hidefromnone'] = 'Neskryť pred nikým';
$string['hidefromstudents'] = 'Skryť študentom';
$string['hookcallbacknotcallable'] = 'Toto spätné volanie nie je volateľné. Dôvodom môže byť neexistencia triedy alebo metódy alebo to, že metóda nie je verejná.';
$string['hookcallbacks'] = 'Spätné volania';
$string['hookcallbacks_help'] = 'Zoznam spätných volaní, ktoré sa zavolajú po odoslaní háčika.

Zobrazené poradie je poradie, v ktorom sa spätné volania volajú.

Spätné volanie s vyššou prioritou bude volané pred volaním s nižšou prioritou.';
$string['hookclassmissing'] = 'Trieda háčika nebola nájdená';
$string['hookclassmissing_desc'] = 'Agent zisťovania háčikov vrátil triedu, ktorá neexistuje.';
$string['hookconfigoverride'] = 'Prepísané';
$string['hookconfigoverride_help'] = 'Definícia tohto spätného volania bola prepísaná v konfiguračnom súbore stránky config.php';
$string['hookdeprecates'] = 'Zastarané spätné volania';
$string['hookdescription'] = 'Opis';
$string['hookdescriptionmissing'] = 'Háčik nemá metódu opisu';
$string['hookname'] = 'Háčik';
$string['hooksoverview'] = 'Prehľad háčikov';
$string['hookunknown'] = 'Háčik nebol nájdený';
$string['hookunknown_desc'] = 'Objekt, ktorý toto spätné volanie počúva, nie je k dispozícii. Mohol byť odstránený alebo premenovaný, alebo nemusí byť v tejto verzii Moodle dostupný.';
$string['hostname'] = 'Názov hostiteľa';
$string['htmleditor'] = 'Editor HTML';
$string['htmleditorsettings'] = 'Nastavenie HTML editora';
$string['htmlsettings'] = 'HTML nastavenia';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Zabezpečenie HTTP';
$string['iconvrequired'] = 'Je vyžadované rozšírenie ICONV.';
$string['igbinary322buggyversion'] = 'Rozšírenie php-igbinary nainštalované na portáli môže pri spustení s PHP 7.2 viesť k problémom. Odporúčame alebo upgradovať na php-igbinary 3.2.5 alebo novšie, alebo alternatívne upgradovať na PHP 7.3 alebo novšie.';
$string['ignore'] = 'Ignorovať';
$string['includemoduleuserdata'] = 'Zahrnúť používateľské údaje modulu';
$string['incompatibleblocks'] = 'Nekompatibilné bloky';
$string['incompleteunicodesupport'] = 'Aktuálne nastavenie MySQL alebo MariaDB používa príkaz „utf8“. Táto znaková sada nepodporuje štyri bajtové znaky, ktoré obsahujú niektoré emodži. Pokus o použitie týchto znakov bude mať za následok chybu pri aktualizácii záznamu a všetky informácie odosielané do databázy budú stratené. Zvážte zmenu nastavení na „utf8mb4“. Všetky podrobnosti nájdete v dokumentácii.';
$string['indexdata'] = 'indexové data';
$string['indexinginfo'] = 'Odporúčaný spôsob indexovania obsahu vašich stránok je použitie naplánovanej úlohy „Indexovanie globálneho vyhľadávania“.';
$string['installhijacked'] = 'Prepáčte, ale inštalácia musí byť dokončená z rovnakej IP adresy.';
$string['installsessionerror'] = 'Nie je možné inicializovať PHP sedenie. Skontrolujte, či Váš prehliadač akceptuje cookies.';
$string['intlrecommended'] = 'Rozšírenie intl je používané na zlepšenie podpory internacionalizácie, ako napr. triedenia na základe locale.';
$string['intlrequired'] = 'Medzinárodné rozšírenie je potrebné na zlepšenie podpory internacionalizácie, ako je triedenie podľa miestnych nastavení a medzinárodné názvy domén.';
$string['invalidagedigitalconsent'] = 'Vek pre udelenie digitálneho súhlasu nie je platný: {$a}';
$string['invalidforgottenpasswordurl'] = 'Adresa URL zabudnutého hesla nie je platná adresa URL.';
$string['invalidsection'] = 'Neplatná sekcia';
$string['invalidthemepreset'] = 'Vybraný súbor predvolieb nie je s touto témou kompatibilný. Chyba kompilácie SCSS bola: "{$a}"';
$string['invaliduserchangeme'] = 'Užívateľské meno \'changeme\' je rezervované -- nie je možné ho použiť pre vytvorenie účtu.';
$string['ipblocked'] = 'Stránka nie je momentálne dostupná.';
$string['ipblocker'] = 'IP blokovač';
$string['ipblockersyntax'] = 'Dajte každú položku na jeden riadok. Platné položky sú buď plné IP adresy (napríklad <b>192.168.10.1</b>), ktorá zodpovedá jednému hostiteľovi, alebo čiastočnú adresu (napr. <b>192.168.</b>), ktorá zodpovedá akejkoľvek adrese počnúc tými číslami, alebo CIDR zápis (napr. <b>231.54.211.0/20</b>), alebo rozsah IP adries (napríklad <b>231.3.56.10-20</b>), kde rozsah sa vzťahuje na poslednú časť adresy. Textové doménové mená (ako \'example.com\') nie sú podporované. Prázdne riadky  a text za znakom "#" sú ignorované.';
$string['iplookup'] = 'Hľadať IP adresu pomocou';
$string['iplookupgeoplugin'] = 'Na vyhľadávanie geografických informácií sa momentálne používa služba <a href="https://www.geoplugin.com">geoPlugin</a>. Pre presnejšie výsledky odporúčame nainštalovať lokálnu kópiu databázy MaxMind GeoLite';
$string['iplookupinfo'] = 'V štandardnej inštalácii Moodle využíva slobodný server NetGeo (internetová geografická databáza) pre vyhľadávanie IP adresy. Táto databáza však už nie je naďalej udržiavaná a môže vrátiť <em>úplne nesprávne</em> údaje.
Doporučuje sa inštalovať lokálnu verziu GeoLite2 City databázy od firmy MaxMind. <br />
Umiestnenie IP adresy je zobrazené na jednoduchej mape alebo pomocou aplikácie GoogleMaps. Pre interaktívne mapy je ale treba existujúce konto na Google a aplikovať pre voľný Google Maps API kľúč.';
$string['iplookupmaxmindnote'] = 'Tento produkt zahŕňa údaje GeoLite vytvorené firmou MaxMind, dostupné na <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Bolo zistené, že váš portál používa vlastný adresár pre správu. Táto funkcia už nie je podporovaná a bude odstránená po Moodle 4.2.';
$string['ishttpswarning'] = 'Zistilo sa, že váš web nie je zabezpečený pomocou protokolu HTTPS. Dôrazne sa odporúča migrovať vaše stránky na protokol HTTPS, aby sa zvýšila bezpečnosť a zlepšila integrácia s inými systémami.';
$string['keeptagnamecase'] = 'Zachovávať veľkosť písmen v tagoch';
$string['lang'] = 'Východzí jazyk';
$string['langcache'] = 'Zoznam jazykov vo vyrovnávacej pamäti';
$string['langcache_desc'] = 'Nastavenie zabezpečujúce uloženie zoznamu jazykov do vyrovnávacej pamäti. Ak je táto možnosť aktivovaná, je do vyrovnávacej pamäti uložený zoznam dostupných prekladov. Vyrovnávacia pamäť sa automaticky obnoví, keď inštalujete alebo odstraňujete jazykový balíček cez zabudovaný nástroj správy jazykových balíčkov. Ak inštalujete nový jazykový balíček manuálne, na obnovenie zoznamu  vo vyrovnávacej pamäti musíte použiť vlastnosť Vyčistiť všetky vyrovnávacie pamäte.';
$string['langlist'] = 'Ktoré jazyky zobrazovať v ponuke';
$string['langmenu'] = 'Zobrazovať ponuku jazykov';
$string['langmenuinsecurelayout'] = 'Ponuka jazykov sa zobrazí v zabezpečenom rozložení';
$string['langmenuinsecurelayout_desc'] = 'Ak je táto možnosť povolená, používateľ bude môcť zmeniť jazyk pri pokuse o test alebo inú aktivitu pomocou zabezpečeného rozloženia.';
$string['langpackwillbeupdated'] = 'POZNÁMKA: Moodle sa pokúsi počas aktualizácie nahrať aj najnovšiu verziu Vašich jazykových balíčkov.';
$string['langstringcache'] = 'Kešovať všetky jazykové reťazce';
$string['languagesettings'] = 'Jazykové nastavenia';
$string['latinexcelexport'] = 'Kódovanie Excelu';
$string['legacyfilesaddallowed'] = 'Povoliť pridávanie do zastaralých súborov kurzov';
$string['legacyfilesaddallowed_help'] = 'Ak má kurz zastaralé súbory kurzov, povoliť k nim pridávať nové súbory a priečinky.';
$string['legacyfilesinnewcourses'] = 'Zastaralé súbory kurzov v nových kurzoch';
$string['legacyfilesinnewcourses_help'] = 'Štandardne sú oblasti zastaralých súborov kurzov dostupné iba v upgradovaných kurzoch. Poznámka: niektoré vlastnosti, ako napr. záloha a obnovenie aktivít nie sú kompatibilné s týmto nastavením.';
$string['libcurlwarning'] = 'Nebol zistený libcurl s podporou CURLOPT_PROTOCOL. Z bezpečnostných dôvodov doporučujeme inštaláciu aktuálneho libcurl.';
$string['licensesettings'] = 'Nastavenia licencie';
$string['linkadmincategories'] = 'Odkaz na administrátorské kategórie';
$string['linkadmincategories_help'] = 'Ak sú aktivované administrátorské nastavenia, kategórie sa zobrazia ako odkazy v navigácii a budú viesť na stránky administrátorských kategórií.';
$string['linkcoursesections'] = 'Vždy odkazovať na sekcie kurzu';
$string['linkcoursesections_help'] = 'Vždy sa snažiť poskytovať odkaz na sekcie kurzu. Sekcie kurzu sa zvyčajne zobrazujú ako odkazy vtedy, keď formát kurzu zobrazuje jednu sekciu na stránku. Ak je toto nastavenie aktivované, odkaz sa zobrazí vždy.';
$string['loading'] = 'Nahrávanie...';
$string['localetext'] = 'Premenná locale';
$string['localstringcustomization'] = 'Úprava lokálnych reťazcov';
$string['location'] = 'Umiestnenie';
$string['locationsettings'] = 'Nastavenie umiestnenia';
$string['locked'] = 'Zamknuté';
$string['lockoutduration'] = 'Dĺžka trvania blokovania účtu';
$string['lockoutduration_desc'] = 'Po tomto čase je blokovaný účet automaticky odomknutý.';
$string['lockoutemailbody'] = 'Váš účet s používateľským menom {$a->username} na serveri \'{$a->sitename}\' bol zablokovaný po viacerých neplatných pokusoch o prihlásenie. Aby ste účet okamžite odblokovali, prejdite na nasledujúcu adresu {$a->link}. Vo väčšine emailových programov by sa mala adresa objaviť ako modrý odkaz, na ktorý jednoducho kliknete. Ak nie je možné priamo kliknúť na odkaz, je potrebné skopírovať a vložiť adresu odkazu do adresného riadku v hornej časti okna vášho webového prehliadača. Ak potrebujete pomoc, kontaktujte, prosím, administrátora portálu, {$a->admin}';
$string['lockoutemailsubject'] = 'Váš účet na {$a} bol zablokovaný';
$string['lockouterrorunlock'] = 'Doručená informácia o neplatnom odblokovaní účtu.';
$string['lockoutthreshold'] = 'Počet pokusov na zadanie správneho hesla';
$string['lockoutthreshold_desc'] = 'Zvoľte počet neúspešných pokusov o pripojenie, ktorý povedie k zablokovaniu účtu. Poznámka: Táto vlastnosť môže byť pri útokoch zneužitá na odmietnutie služby.';
$string['lockoutwindow'] = 'Okno sledovania blokovania účtov';
$string['lockoutwindow_desc'] = 'Doba počas ktorej bude účet zablokovaný. Ak sa počas tejto doby nevyskytnú žiadne neúspešné pokusy, počítadlo počtu pokusov o zadanie správneho hesla sa po tomto čase vynuluje.';
$string['lockrequestcategory'] = 'Zamknúť výber kategórií';
$string['log'] = 'Protokoly';
$string['logguests'] = 'Logovať prístup hostí';
$string['logguests_help'] = 'Toto nastavenie umožňuje logovanie akcií hosťovského účtu a neprihlásených používateľov. Vysokoprofilové portály môžu chcieť deaktiváciu tohto logovania z dôvodov výkonu. Na produkčných portáloch sa odporúča mať toto nastavenie aktivované.';
$string['logininfoinsecurelayout'] = 'V bezpečnom formáte zobraziť prihláseného používateľa';
$string['logininfoinsecurelayout_desc'] = 'Ak je táto možnosť povolená, zobrazí sa pri pokuse testu alebo inej aktivite pomocou zabezpečeného formátu na navigačnej lište celé meno prihláseného používateľa.';
$string['loginpageautofocus'] = 'Automaticky umiestniť kurzor do prihlasovacieho formulára';
$string['loginpageautofocus_help'] = '';
$string['loglifetime'] = 'Udržovať protokoly po dobu';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Úplné logo, ktoré má byť použité ako ornament niektorými témami (ako základná téma). Tento obrázok môže byť vo vysokom rozlíšení, pretože bude pri použití zmenšený (a uložený do medzipamäte). Širšie logá obvykle dávajú lepšie výsledky.';
$string['logocompact'] = 'Kompaktné logo';
$string['logocompact_desc'] = 'Kompaktná verzia rovnakého loga ako je uvedené vyššie, ako je napríklad symbol, štít alebo ikona. Obrázok by mal byť čitateľný aj v malých veľkostiach.';
$string['logossettings'] = 'Logá';
$string['logstorenotrequired'] = 'Ukladanie protokolov sa nepožaduje';
$string['logstoressupported'] = 'Ukladanie protokolov, ktoré podporuje táto štatistika';
$string['longtimewarning'] = '<b>Prosím pozor, tento proces môže trvať dlho.</b>';
$string['mailnewline'] = 'Znaky nového riadku v mailoch';
$string['maintenancemode'] = 'V režime údržby';
$string['maintenancemodeisscheduled'] = 'Tento server bude prepnutý do módu údržby o {$a->min} minút {$a->sec} sekúnd';
$string['maintenancemodeisscheduledlong'] = 'Tento server bude prepnutý do módu údržby o {$a->hour} hodin {$a->min} minút {$a->sec} sekúnd';
$string['maintfileopenerror'] = 'Chyba pri otváraní súborov údržby!';
$string['maintinprogress'] = 'Prebieha údržba serveru...';
$string['managecontextlock'] = 'Zmraziť tento kontext';
$string['managecontextlocklocked'] = '{$a->contextname} a všetky vnorené kontexty sú  teraz zmrazené';
$string['managecontextlockunlocked'] = '{$a->contextname} a všetky vnorené kontexty sú  teraz rozmrazené';
$string['managecontextunlock'] = 'Rozmraziť tento kontext';
$string['managecustomfields'] = 'Spravovať typy vlastných polí';
$string['manageformats'] = 'Administratíva formátov kurzu';
$string['manageformatsgotosettings'] = 'Štandardný formát je možné zmeniť na {$a}';
$string['managelang'] = '<b>Správa</b>';
$string['manageqbanks'] = 'Spravovať doplnky banky úloh';
$string['manageqbehaviours'] = 'Spravovať správanie otázok';
$string['manageqtypes'] = 'Správa typov otázok';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Predprodukčná verzia (RC)';
$string['maturity200'] = 'Stabilná verzia';
$string['maturity50'] = 'Alfa';
$string['maturityallowunstable'] = 'Tip: Možno chcete spustiť tento skript pomocou možnosti --allow-unstable';
$string['maturitycoreinfo'] = 'Váš portál momentálne beží na nestabilnej "{$a}" vývojovej verzii.';
$string['maturitycorewarning'] = 'Verzia Moodle, ktorú sa chystáte nainštalovať alebo inovovať, obsahuje
nestabilný vývojový kód "{$a}", ktorý nie je vhodný na použitie vo väčšine produkčných portálov. Ak to nie je to, čo ste chceli, mali by ste sa uistiť, že aktualizujete
zo STABILNEJ vetvy kódu Moodle. Viac podrobností nájdete v dokumentácii Moodle.';
$string['maxbytes'] = 'Maximálna veľkosť nahrávaných súborov';
$string['maxcharacter'] = '{$a} maximálny počet znakov';
$string['maxconsecutiveidentchars'] = 'Nasledujúce rovnaké znaky';
$string['maxeditingtime'] = 'Časový limit pre úpravu vložených príspevkov';
$string['maxsizeperdownloadcoursefile'] = 'Maximálna veľkosť súboru';
$string['maxsizeperdownloadcoursefile_desc'] = 'Maximálna veľkosť každého súboru pri sťahovaní obsahu kurzu. Súbory presahujúce túto veľkosť budú zo sťahovania vynechané.';
$string['maxtimelimit'] = 'Maximálny časový limit';
$string['maxtimelimit_desc'] = 'Aby ste obmedzili maximálnu dobu vykonávania PHP operácii, ktorú Moodle povolí bez zobrazenia nejakého výstupu, vložte na toto miesto hodnotu v skundách. 0 znamená, že sa použijú štandardné obmedzenia Moodlu. Ak máte frontendový server s jeho vlastným časovým limitom, nastavte túto hodnootu nižšie, aby ste v protokoloch dostávali PHP chyby. Nepoužívajte pre CLI skripty.';
$string['maxusersperpage'] = 'Maximálny počet používateľov pre stránku';
$string['mbstringrecommended'] = 'Inštalácia voliteľnej knižnice MBSTRING je vysoko doporučovaná, pretože zvyšuje výkon stránok, najmä ak používate mäkčeňové jazyky - napr. slovenčinu.';
$string['mbstringrequired'] = 'Inštalácia voliteľnej knižnice MBSTRING je nutná pretože zvyšuje výkon stránok, najmä ak používate mäkčeňové jazyky - napr. slovenčinu.';
$string['mediapluginavi'] = 'Aktivovať filter .avi';
$string['mediapluginflv'] = 'Aktivovať filter.flv';
$string['mediapluginimg'] = 'Podporiť auto-vkladanie odkazovaných obrázkov';
$string['mediapluginmov'] = 'Aktivovať filte .mov';
$string['mediapluginmp3'] = 'Aktivovať filter .mp3';
$string['mediapluginmpg'] = 'Aktivovať filter .mpg';
$string['mediapluginogg'] = 'Povoliť .ogg filter';
$string['mediapluginogv'] = 'Povoliť .ogv filter';
$string['mediapluginram'] = 'Aktivovať filter .ram';
$string['mediapluginrm'] = 'Aktivovať filter .rm';
$string['mediapluginrpm'] = 'Aktivovať filter .rpm';
$string['mediapluginwmv'] = 'Aktivovať filter .wmw';
$string['mediapluginyoutube'] = 'Povoliť filter odkazov na YouTube';
$string['messaging'] = 'Povoliť systém zasielania správ';
$string['messagingallowemailoverride'] = 'Prepísať notifikačný e-mail';
$string['messagingallusers'] = 'Povoliť zasielanie správ na celú inštanciu Moodle';
$string['messagingcategory'] = 'Správy';
$string['messagingdefaultpressenter'] = 'Vo východzom nastavení je pre odosielanie nastavené použitie klávesy enter';
$string['messagingdeleteallnotificationsdelay'] = 'Vymazať všetky oznámenia';
$string['messagingdeletereadnotificationsdelay'] = 'Vymazať upozornenia o prečítaní';
$string['messagingssettings'] = 'Nastavenie správ';
$string['minpassworddigits'] = 'Číslice';
$string['minpasswordlength'] = 'Dĺžka hesla';
$string['minpasswordlower'] = 'Malé písmená';
$string['minpasswordnonalphanum'] = 'Nealfanumerické znaky';
$string['minpasswordupper'] = 'Veľké písmená';
$string['misc'] = 'Rôzne';
$string['mlbackendsettings'] = 'Nastavenie strojového učenia na pozadí';
$string['mnetrestore_extusers'] = '<strong>Poznámka:</strong> Táto záloha obsahuje vzdialených používateľov siete Moodle Network. Vzdialené účty budú v priebehu tohto procesu obnovené.';
$string['mnetrestore_extusers_admin'] = '<strong>Upozornenie:</strong> Tento súbor zálohy je zrejme z iného Moodle servera a obsahuje informácie o kontách vzdialených používateľov. Proces obnovy zo zálohy sa pokúsi o ich správne priradenie. Tým, ktorí nebudú správne identifikovaní, budú vytvorené kontá s vnútornou autentifikáciou (a nie mnet autentifikáciou). Zápis z obnovy v súbore restore.log bude obsahovať podrobné informácie.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Poznámka:</strong> Táto záloha evidentne pochádza z odlišnej inštalácie Moodle a obsahuje vzdialené používateľské účty. Obnova týchto účtov sa nemusí podariť, táto operácia nie je podporovaná. Ak ste si istí, že záloha pochádza z tejto inštalácie, alebo môžete zaistiť, že sú správne nastavené všetky hostiteľské počítače v sieti Moodle Network, môžete sa aj napriek tomu pokúsiť o obnovu.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Upozornenie:</strong> Tento súbor zálohy je zrejme z iného Moodle servera a obsahuje informácie o kontách vzdialených používateľov. Na jeho obnovenie nemáte oprávnenie. Môžete alebo informovať administrátora alebo vykonať obnovu bez informácií o používateľoch (moduly, súbory,...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Vzdialený Moodle Network používateľ {$a->username} (zo servera {$a->mnethosturl}) bol prepnutý na lokálne autentifikovaného používateľa ({$a->auth}).';
$string['mobilenotconfiguredwarning'] = 'Služba Moodle Mobile nie je povolená.';
$string['modassignmentinuse'] = 'Váš portál stále používa zásuvný modul Zadanie 2.2. Pred aktualizáciou musíte 1) zálohovať všetky aktivity Zadanie 2.2, ktoré chcete zachovať, a obnoviť ich ako aktivity Zadanie a 2) odstrániť všetky údaje Zadanie 2.2 z databázy.';
$string['modassignmentsubpluginsexist'] = 'Zadanie 2.2. môže mať prítomné čiastkové zásuvné moduly. Priečinok mod/assignment a všetky jeho zásuvné moduly je potrebné pred aktualizáciou odstrániť.';
$string['modeditdefaults'] = 'Východzie hodnoty pre nastavenia aktivít';
$string['modsettings'] = 'Spravovať aktivity';
$string['modulesecurity'] = 'Zabezpečenie modulov';
$string['moodleapp'] = 'moodle aplikácia';
$string['moodleapp_help'] = '<p>Bezplatná aplikácia Moodle umožňuje používateľom prístup ku svojim kurzom na mobilných zariadeniach. Ďalšie funkcie aplikácie sú k dispozícii s plánom aplikácie Pro alebo Premium.</p>
<a href="https://moodle.com/mobile-app">Stiahnite si mobilnú aplikáciu</a><br />
<a href="https://apps.moodle.com">Moodle Apps Portál</a>';
$string['moodlebrandedapp'] = 'značková moodle aplikácia';
$string['moodlebrandedapp_help'] = '<p>Značková aplikácia Moodle má všetky funkcie našej bezplatnej mobilnej aplikácie pre Moodle v kombinácii s vašou vlastnou značkou.</p>
<a href="https://moodle.com/branded-app">O Značkovej aplikácii Moodle</a>';
$string['moodlebrandedappreference'] = 'Prípadne môžete získať <a href="https://moodle.com/branded-app/"> značkovú aplikáciu Moodle </a> s vašou vlastnou značkou.';
$string['moodlepartners'] = 'Partneri Moodle';
$string['moodlepartners_help'] = '<p>Partneri Moodle sú poskytovatelia služieb, ktorí sú certifikovaní spoločnosťou Moodle HQ, aby poskytli vysokokvalitné služby Moodle pre online vzdelávacie prostredie vašej organizácie.</p>
<a href="https://moodle.com/about-partners/">O našich Partneroch</a><br />
<a href="https://moodle.com/partners">Hľadať Partnera</a>';
$string['moodleservices'] = 'Moodle služby';
$string['moodleservices_help'] = 'Uistite sa, že využívate tieto Moodle služby z vášho vzdelávacieho prostredia Moodle:';
$string['multilangforceold'] = 'Vnútiť starú syntax viacjazyčného obsahu pomocí tagu <lang>';
$string['mustenablestats'] = 'Na týchto stránkach nie sú povolené štatistiky.';
$string['mycourses'] = 'Moje kurzy';
$string['mydashboard'] = 'Predvolená východzia Nástenka';
$string['mymoodle'] = 'Nástenka';
$string['mypage'] = 'Predvolená Nástenka';
$string['mypagelocked'] = 'Uzamknúť východziu stránku';
$string['myprofile'] = 'Východzia stránka profilu';
$string['navadduserpostslinks'] = 'Pridať odkazy na príspevky používateľa';
$string['navadduserpostslinks_help'] = 'Ak je táto možnosť aktivovaná, každému používateľovi sa do navigácie pridajú dva odkazy. Jeden odkaz bude smerovať na prezeranie diskusií, ktoré používateľ začal a druhý odkaz na príspevky, ktoré používateľ dal na fóra na portáli alebo v konkrétnych kurzoch.';
$string['navcourselimit'] = 'Limit kurzu';
$string['navigationupgrade'] = 'Toto vylepšenie uvádza dva nové navigačné bloky, ktoré nahradia tieto bloky: Administrácia, Kurzy, Aktivity a Účastníci. Ak ste v týchto blokoch nastavili akékoľvek špeciálne povolenia, mali by ste skontrolovať, či sa všetko správa tak, ako chcete.';
$string['navshowallcourses'] = 'Zobraziť všetky kurzy';
$string['navshowcategories'] = 'Zobrazoť kategórie kurzov';
$string['navshowfrontpagemods'] = 'V navigácii zobrazovať aktivity úvodnej stránky';
$string['navshowfrontpagemods_help'] = 'Ak je táto možnosť aktivovaná, v navigácii pod stránkami portálu sa zobrazia aktivity úvodnej stránky.';
$string['navshowfullcoursenames'] = 'Zobraziť celé názvy kurzov';
$string['navshowfullcoursenames_help'] = 'Ak je táto možnosť aktivovaná, v navigácii sa použijú celé názvy kurzov. Štandardne sa zobrazujú skrátené názvy kurzov.';
$string['navshowmycoursecategories'] = 'Zobraziť moje kategórie kurzov';
$string['navshowmycoursecategories_help'] = 'Ak je táto možnosť aktivovaná, kurzy v položke menu Moje kurzy sa používateľom zobrazia v kategóriach v navigačnom bloku (iba klasické témy).';
$string['navsortmycourseshiddenlast'] = 'Triediť moje skryté kurzy ako posledné';
$string['navsortmycourseshiddenlast_help'] = 'Ak je povolené, budú všetky skryté kurzy zobrazené po viditeľných kurzoch (pre používateľov, ktorí si môžu prehliadať skryté kurzy). V opačnom prípade budú všetky kurzy bez ohľadu na ich viditeľnosť radené podľa poradia uvedeného v nastavení "Triediť moje kurzy".';
$string['navsortmycoursessort'] = 'Poradie kurzov v navigačnom bloku';
$string['navsortmycoursessort_help'] = 'Majú sa kurzy uvádzať v poradí nastavenom v časti Správa stránok > Kurzy > Správa kurzov a kategórií alebo abecedne podľa nastavenia kurzu? Toto nastavenie sa vzťahuje len na témy založené na Classic.';
$string['never'] = 'Nikdy';
$string['neverdeleteruns'] = 'Nikdy neodstraňovať dokončené udalosti';
$string['newestdocindexed'] = 'Najnovšie dokumenty indexované';
$string['nobookmarksforuser'] = 'Nemáte žiadne záložky';
$string['nodatabase'] = 'Žiadna databáza';
$string['noemaileverwarning'] = '<strong>Poznámka:</strong> Všetky odchádzajúce e-maily boli vypnuté';
$string['nohttpsformobilewarning'] = 'Doporučuje sa povoliť šifrované spojenie HTTPS s platným certifikátom. Moodle app sa vždy najprv pokúsi používať zabezpečené spojenie.';
$string['nomissingstrings'] = 'Žiadne chýbajúce reťazce';
$string['none'] = 'Žiadne';
$string['nonewsettings'] = 'V priebehu upgrade nebolo pridané žiadne nové nastavenie';
$string['nonexistentbookmark'] = 'Požadovaná záložka neexistuje';
$string['noreplyaddress'] = 'Adresa odosielateľa automaticky generovaných správ';
$string['noreplydomain'] = 'Neodpovedať a doména';
$string['noreplydomaindetail'] = 'Nastavenia pre Neodpovedať a konfigurované domény';
$string['noresults'] = 'Bez výsledkov';
$string['noroles'] = 'Žiadne role';
$string['nosupportedlogstore'] = 'Nebolo nájdené žiadne podporované úložisko protokolov';
$string['noteunneededblocks'] = 'Poznámka: Bloky nastavené k zobrazeniu nebudú uvedené v ponuke "Pridať blok" v kurze, ak sú určené v nastavení témy "Nepotrebné bloky".';
$string['notifications'] = 'Upozornenie';
$string['notifyloginfailures'] = 'Posielať neúspešné prihlásenia emailom';
$string['notifyloginthreshold'] = 'Prah pre upozornenie emailom';
$string['notloggedinroleid'] = 'Rola návštevníkov';
$string['numberofmissingstrings'] = 'Počet chýbajúcich reťazcov: {$a}';
$string['numberofstrings'] = 'Celkový počet reťazcov: {$a->strings}<br />Chýbajúce: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'Platnosť tokenu jednej z OAuth služieb pre {$a->issuer} na vašom portáli {$a->siteurl} vypršala. Tým sa obmedzí funkčnosť všetkých doplnkov, ktoré používajú túto službu. Ak chcete tento problém vyriešiť, navštívte konfiguračnú stránku OAuth 2 Services a kliknite na ikonu „Pripojiť systémový účet“ v riadku tabuľky pre túto službu. Presvedčte sa, že sa vždy prihlasujute pomocou rovnakého účtu služby pre OAuth systém.';
$string['oauthrefreshtokenexpiredshort'] = 'Na vašom portáli {$a->siteurl} vypršala platnosť OAuth tokenu pre {$a->issuer}.';
$string['onlynoreply'] = 'Iba vtedy, keď je adresou Neodpovedať';
$string['opcacherecommended'] = 'PHP opcode cache zvyšuje výkon a znižuje požiadavky na pamäť. Používanie tohto typu vyrovnávacej pamäti sa odporúča a je plne podporované..';
$string['opensslrecommended'] = 'Pre beh sieťových funkcionalít ("Moodle Networking") je treba nainštalovať voliteľnú knižnicu OpenSSL.';
$string['opensslrequired'] = 'Rozšírenie OpenSSL PHP teraz vyžaduje od  Moodle poskytovanie silnejších kryptografických služieb.';
$string['opentowebcrawlers'] = 'Povoliť prehľadávanie Googlom';
$string['optionalmaintenancemessage'] = 'Voliteľná správa pre používateľa počas údržby';
$string['order1'] = 'Prvý';
$string['order2'] = 'Druhý';
$string['order3'] = 'Tretí';
$string['order4'] = 'Štvrtý';
$string['outgoingmailconfig'] = 'Konfigurácia odchádzajúcej  pošty';
$string['overridetossl'] = 'HTTPS pre prihlasovanie je teraz zastaralé. Táto inštancia je teraz prinútená k SSL. Ak chcete odstrániť toto varovanie, zmeňte svoj wwwroot v config.php na https://';
$string['pageinfodebugsummary'] = 'Táto stránka je: {$a}';
$string['passwordchangelogout'] = 'Odhlásiť po zmene hesla';
$string['passwordchangelogout_desc'] = 'Ak je táto možnosť aktivovaná, po zmene hesla sú všetky relácie prehliadača ukončené, okrem tej, v ktorej je špecifikované nové heslo. (Toto nastavenie nemá vplyv na zmeny hesiel cez hromadné nahrávanie používateľov.)';
$string['passwordchangetokendeletion'] = 'Odstrániť prístupové tokeny webovej služby po zmene hesla';
$string['passwordchangetokendeletion_desc'] = 'Ak je povolené, pri zmene hesla sú odstránené všetky prístupové tokeny používateľa webovej služby.';
$string['passwordpolicy'] = 'Zásady bezpečného hesla';
$string['passwordpolicycheckonlogin'] = 'Skontrolovať heslo pri prihlásení';
$string['passwordresettime'] = 'Maximálny čas na overenia obnovy hesla';
$string['passwordreuselimit'] = 'Limit rotácie hesiel';
$string['passwordreuselimit_desc'] = 'Počet zmien, počas ktorých musia používatelia zmeniť svoje heslá predtým, ako môžu opätovne použiť heslo, ktoré už používali.  Pozostatky predtým použitých hesiel sú uložené v tabuľke lokálnej databázy. Táto vlastnosť možno nebude kompatibilná s niektorými externými overovacími pluginmi.';
$string['pathtodot'] = 'Cesta k programu dot';
$string['pathtodot_help'] = 'Úplná cesta k programu "dot". Na Linuxu to je niečo ako /usr/bin/dot. Na Windows je to niečo ako C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. Na Macu je to niečo /opt/local/bin/dot.  Aby ste mohli generovať grafiku zo súborov DOT, musíte mať nainštalovaný dot spustiteľný súbor a tu sa odkazovať naň.';
$string['pathtodu'] = 'Cesta k du';
$string['pathtogs'] = 'Cesta ku ghostscript';
$string['pathtogs_help'] = 'Na väčšine linuxových inštalácií je tu možné nechať ako \'/usr/bin/gs\'. Vo Windowse to bude niečo ako  \'c:\\gs\\bin\\gswin32c.exe\' (presvedčte sa, že v ceste nie sú žiadne medzery - ak je potrebné, skopírujte súbory \'gswin32c.exe\' a \'gsdll32.dll\' do nového priečinku bez medzery v ceste)';
$string['pathtopdftoppm'] = 'Cesta k pdftoppm';
$string['pathtopdftoppm_help'] = '<a href="https://poppler.freedesktop.org/"> Poppler </a> je knižnica pre vykresľovanie PDF, ktorá obsahuje nástroj pdftoppm pre prevod súborov PDF na PNG. Výkon je všeobecne lepší ako pri použití Ghostscript, najmä u veľkých súborov. Ak je k dispozícii, prednostne sa použije súbor pdftoppm pred Ghostscript. U väčšiny inštalácií systému Linux možno nechať cestu ako /usr/bin/pdftoppm. V opačnom prípade musíte nainštalovať balíček poppler-utils alebo poppler, v závislosti na vašej distribúcii Linuxu. Vo Windows je poskytované inštaláciami Cygwin.';
$string['pathtopgdump'] = 'Cesta k pg_dump';
$string['pathtopgdumpdesc'] = 'Tento údaj je nutné zadať iba v prípade, že prevádzkujete viac než jednu verziu pg_dump (napr. ak je na serveri inštalovaná viac než jedna verzia postgresql).';
$string['pathtopgdumpinvalid'] = 'Neplatná cesta k pg_dump -- buď je zadaná chybná cesta, alebo nie je možné odkazovaný súbor spustiť.';
$string['pathtophp'] = 'Cesta kPHP CLI';
$string['pathtopsql'] = 'Cesta k psql';
$string['pathtopsqldesc'] = 'Tento údaj je nutné zadať iba v prípade, že prevádzkujete viac než jednu verziu psgl (napr. ak je na serveri inštalovaná viac než jedna verzia postgresql).';
$string['pathtopsqlinvalid'] = 'Neplatná cesta k psgl -- buď je zadaná chybná cesta, alebo nie je možné odkazovaný súbor spustiť.';
$string['pathtopython'] = 'Cesta k Python';
$string['pathtopythondesc'] = 'Cesta k spustiteľnému súboru Python (akceptovateľné sú Python 2 a Python 3).';
$string['pathtosassc'] = 'Cesta k SassC';
$string['pathtosassc_help'] = 'Určenie umiestnenia binárneho kódu SassC prepne prekladač SASS z implementácie PHP do aplikácie SassC. Viac informácií nájdete na stránke https://github.com/sass/sassc.';
$string['pcreunicodewarning'] = 'Dôrazne sa odporúča použiť PCRE PHP rozšírenie, ktoré je kompatibilné s kódovaním Unicode';
$string['perfdebug'] = 'Informácia o výkonnosti';
$string['perfdebugdeferred'] = 'Čakanie na ukončenie skriptu na zobrazenie ladenia výkonu ...';
$string['performance'] = 'Výkonnosť';
$string['pgcluster'] = 'Cluster PostgreSQL';
$string['pgclusterdescription'] = 'Parametre PostgreSQL version/cluster pre operácie z príkazového riadku. Ak prevádzkujete iba jednu verziu PostgreSQL, alebo ak si nie ste istý, nechajte pole prázdne.';
$string['phpfloatproblem'] = 'Bol zistený neočakávaný problém so spracovaním desatinných čísel - {$a}';
$string['pid'] = 'PID';
$string['pleaserefreshregistration'] = 'Váš portál bol registrovaný na moodle.org. Vaša registrácia bola naposledy aktualizovaná: {$a}<br />
"Registračný web" udržuje pomocou naplánovanej úlohy vašu registráciu aktuálnu. Svoju registráciu môžete tiež kedykoľvek ručne aktualizovať.';
$string['pleaserefreshregistrationnewdata'] = 'Informácie o registrácii boli zmenené. Potvrďte ich pomocou tlačidla "Aktualizácia registrácie".';
$string['pleaserefreshregistrationunknown'] = 'Váš portál bol zaregistrovaný, ale dátum registrácie nie je známy. Aktualizujte prosím svoju registráciu pomocou tlačidla "Aktualizovať registráciu" alebo sa uistite, že je v naplánovaných úlohách cronu povolené "Registrácia portálu"  tak, aby vaša registrácia bola automaticky aktualizovaná.';
$string['plugin'] = 'Modul';
$string['plugin_disabled'] = '{$a} vypnuté.';
$string['plugin_enabled'] = '{$a} zapnuté.';
$string['plugins'] = 'Zásuvné moduly';
$string['pluginscheck'] = 'Kontola závislostí pluginov';
$string['pluginscheckfailed'] = 'Kontrola závislostí pre {$a->pluginslist} bola neúspešná';
$string['pluginschecktodo'] = 'Musite vyriešiť všetky závislosti modulov pred nainštalovaním tejto verzie Moodle!';
$string['pluginsoverview'] = 'Prehľad modulov';
$string['pluginsoverviewsee'] = 'Ďalšie informácie nájdete v <a href="{$a->url}">prehľade zásuvných modulov</a>.';
$string['policysettings'] = 'Nastavenie zásad';
$string['privacy:metadata'] = 'Zásuvný modul Správa stránok neukladá osobné údaje.';
$string['privacyandpolicies'] = 'Súkromie a zásady';
$string['privacysettings'] = 'Nastavenia súkromia';
$string['profilecategory'] = 'Kategórie';
$string['profilecategoryname'] = 'Názov kategórie (musí byť jedinečný)';
$string['profilecategorynamenotunique'] = 'Tento názov kategórie je už používaný';
$string['profilecommonsettings'] = 'Spoločné nastavenia';
$string['profileconfirmcategorydeletion'] = 'Bolo nájdené {$a} polí, ktoré budú presunuté do vyššej kategórie (alebo nižšej, ak sa jedná o najvyššiu kategóriu).<br />Stále si prajete túto kategóriu odstrániť?';
$string['profileconfirmfielddeletion'] = 'Bolo nájdené {$a} záznamov, ktoré používajú toto pole. Informácia uložená v poli bude nenávratne stratená. Stále si prajete pole odstrániť?';
$string['profilecreatecategory'] = 'Vytvoriť novú kategóriu profilov';
$string['profilecreatefield'] = 'Vytvoriť nové pole profilu';
$string['profilecreatenewcategory'] = 'Vytváram novú kategóriu';
$string['profilecreatenewfield'] = 'Vytváram nové pole profilu \'{$a}\'';
$string['profiledefaultcategory'] = 'Ďalšie pole';
$string['profiledefaultchecked'] = 'Vybrané vo východzom nastavení';
$string['profiledefaultdata'] = 'Východzia hodnota';
$string['profiledeletecategory'] = 'Odstraňujem kategóriu';
$string['profiledeletefield'] = 'Odstraňujem pole \'{$a}\'';
$string['profiledescription'] = 'Opis poľa';
$string['profiledscript'] = 'Tento skript bol profilovaný';
$string['profiledscriptview'] = 'Zobraziť informácie o profilovaní tohto skriptu';
$string['profileeditcategory'] = 'Úprava kategórie: {$a}';
$string['profileeditfield'] = 'Úprava poľa profilu: {$a}';
$string['profilefield'] = 'Pole profilu';
$string['profilefieldcolumns'] = 'Stĺpce';
$string['profilefieldispassword'] = 'Je toto pole pre heslo?';
$string['profilefieldlink'] = 'Odkaz';
$string['profilefieldlink_help'] = 'Pre transformáciu testu na odkaz, vložte URL obsahujúce $$, kde $$ bude nahradené textom. Napríklad na transformáciu Twitter ID na odkaz, vložte http://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cieľ odkazu';
$string['profilefieldmaxlength'] = 'Limit počtu znakov';
$string['profilefieldmaxlength_help'] = 'Ak chcete použiť toto pole v nastavení „Zobraziť identitu používateľa“, musí byť limit 255 znakov alebo menej.';
$string['profilefieldrows'] = 'Riadky';
$string['profilefields'] = 'Používateľské pole profilu';
$string['profilefieldsize'] = 'Veľkosť zobrazenia';
$string['profileforceunique'] = 'Majú byť údaje jedinečné?';
$string['profileinvaliddata'] = 'Neplatná hodnota';
$string['profilelocked'] = 'Je pole zamknuté?';
$string['profilemenudefaultnotinoptions'] = 'Východzia hodnota nie je jedna z ponúkaných možností';
$string['profilemenunooptions'] = 'Neboli dodané žiadne možnosti';
$string['profilemenuoptions'] = 'Možnosti (každá na jeden riadek)';
$string['profilemenutoofewoptions'] = 'je treba vložiť aspoň dve možnosti';
$string['profilename'] = 'Názov';
$string['profilenofieldsdefined'] = 'Neboli definované žiadne polia';
$string['profilerequired'] = 'Je vyplnenie poľa povinné?';
$string['profileroles'] = 'Viditeľné roly profilu';
$string['profilesforenrolledusersonly'] = 'Profily iba pre učastníkov kurzu';
$string['profileshortname'] = 'Krátky názov (jedinečný)';
$string['profileshortnameinvalid'] = 'Tento krátky názov môže obsahovať iba alfanumerické znaky (písmena a čísla) alebo podtrhovník (_).';
$string['profileshortnamenotunique'] = 'Tento krátky názov je už používaný';
$string['profilesignup'] = 'Zobraziť stránku pre vytváranie konta?';
$string['profilespecificsettings'] = 'Špecifické nastavenia';
$string['profilevisible'] = 'Kto môže vidieť obsah poľa?';
$string['profilevisible_help'] = '* Skryté - iba pre súkromné údaje viditeľné administrátorovi
* Viditeľné pre používateľov - pre súkromné údaje viditeľné iba používateľom a správcom
* Viditeľné pre používateľov, učiteľov a administrátorov - pre súkromné údaje viditeľné iba používateľom, správcom a učiteľom (v profile kurzu)
* Viditeľné pre všetkých';
$string['profilevisibleall'] = 'Verejné pole - viditeľné pre všetkých';
$string['profilevisiblenone'] = 'Skryté pole - neviditeľné';
$string['profilevisibleprivate'] = 'Súkromné pole - viditeľné iba pre daného používateľa';
$string['profilevisibleteachers'] = 'Viditeľné pre používateľov, učiteľa a správcu';
$string['profiling'] = 'Profilovanie';
$string['profilingallowall'] = 'Súvislé profilovanie';
$string['profilingallowall_help'] = 'Ak povolíte toto nastavenie , môžete kedykoľvek použiť parameter PROFILEALL kdekoľvek (PGC), aby ste umožnili profilovanie všetkých vykonaných skriptov počas trvania relácie Moodle. Analogicky ho môžete použiť na zastavenie parametra PROFILEALLSTOP.';
$string['profilingallowme'] = 'Selektívne profilovanie';
$string['profilingallowme_help'] = 'Ak aktivujete toto nastavenie, potom, výberovo, môžete použiť parameter PROFILEME kdekoľvek (PGC) a nastane profilovanie pre tento skript. Analogicky môžete použiť parameter DONTPROFILEME, aby ste zabránili uskutočneniu profilovania.';
$string['profilingautofrec'] = 'Automatické profilovanie';
$string['profilingautofrec_help'] = 'Nakonfigurovaním tohto nastavenia bude niektorá požiadavka (náhodne, založené na určenej frekvencii - 1 z N) vybraná a automaticky profilovaná, uložiac výsledky na ďalšiu analýzu. Poznámka: Tento spôsob profilovania sleduje nastavenie zahrnúť/vylúčiť. Aby ste deaktivovali automatické profilovanie, nastavte ho na 0.';
$string['profilingenabled'] = 'Povoliť profilovanie';
$string['profilingenabled_help'] = 'Ak aktivujete toto nastavenie, potom na tomto portáli bude k dispozícii profilovanie a vy budete môcť definovať jeho správanie konfigurovaním nasledujúcich možností.';
$string['profilingexcluded'] = 'Výlučiť z profilovania';
$string['profilingexcluded_help'] = 'Zoznam (čiarkami oddelených, absolútne vynechávaných z wwwroot, vyvolateľných) URL adries, ktoré budú vylúčené z profilovania z tých, ktoré sú definované nastavením \'Profilovať tieto\'.';
$string['profilingimportprefix'] = 'Predpona profilujúceho importu';
$string['profilingimportprefix_desc'] = 'Pre ľahšie rozpoznanie  budú mať všetky importované profilujúce behy predponu s hodnotou určenou na tomto mieste.';
$string['profilingincluded'] = 'Profilovať tieto';
$string['profilingincluded_help'] = 'Zoznam (čiarkami oddelených, absolútne vynechávaných z wwwroot, vyvolateľných) URL adries, ktoré budú automaticky profilované. Príklady: /index.php, /course/view.php. Akceptovaný je aj zástupný znak * na ktorejkoľvek pozícii. Príklady: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Zachovať profilujúce behy';
$string['profilinglifetime_help'] = 'Špecifikujte čas, ako dlho chcete zachovať informácie o starých profilujúcich behoch. Staršie záznamy budú periodicky odstraňované. Poznámka: Z tohto procesu je vylúčený akýkoľvek profilujúci beh, ktorý je označený ako \'referenčný beh\'.';
$string['profilingslow'] = 'Profilovať pomalé stránky';
$string['profilingslow_help'] = 'Nastavením minimálnej doby v sekundách budú všetky stránky pomalšie. Zachované budú iba profily, ktoré sú pomalšie než existujúce profily pre rovnaký skript. Ak chcete túto funkciu vypnúť, nastavte hodnotu 0. Všimnite si, že toto dodržuje nastavenia vylúčenia.';
$string['protectusernames'] = 'Chrániť používateľské mená';
$string['proxybypass'] = 'Hosty obchádzajúce proxy server (Proxy bypass hosts)';
$string['proxyfixunsafe'] = 'Opraviť volania bez proxy';
$string['proxyhost'] = 'Proxy server';
$string['proxylogunsafe'] = 'Logovať volania bez proxy';
$string['proxypassword'] = 'Proxy heslo';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Typ proxy';
$string['proxyuser'] = 'Proxy používateľ';
$string['purgecaches'] = 'Vyčistiť všetky vyrovnávacie pamäte';
$string['purgecachesconfirm'] = 'Moodle dokáže ukladať témy, javascript, jazykové reťazce, filtrovaný text, RSS kanály a mnoho ďalších druhov vypočítaných údajov. Vymazanie týchto vyrovnávacích pamätí odstráni tieto údaje zo servera a vynúti prehliadače, aby obnovili údaje, takže si môžete byť istí, že vidíte najaktuálnejšie hodnoty vytvorené aktuálnym kódom. Neexistuje žiadne nebezpečenstvo v čistení vyrovnávajúcej pamäte, ale vaše stránky sa môžu zdať pomalšie, kým server a klienti vypočítajú a uložia nové informácie.';
$string['purgecachesfinished'] = 'Všetky vyrovnávacie pamäte boli vymazané.';
$string['purgecachesnoneselected'] = 'Vyberte jednu alebo viac vyrovnávacích pamätí, ktoré chcete vymazať';
$string['purgecachespage'] = 'Vymazať vyrovnávajúcu pamäť';
$string['purgefiltercache'] = 'Filtre pre text';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Textový reťazec';
$string['purgemuc'] = 'Všetky MUC vyrovnávajúce pamäte';
$string['purgeothercaches'] = 'Všetky súbory a rôzne medzipamäte';
$string['purgeselectedcaches'] = 'Vyčistiť vybrané medzipamäte';
$string['purgeselectedcachesfinished'] = 'Vybrané vyrovnávacie pamäte boli vyčistené.';
$string['purgetemplates'] = 'Šablóny';
$string['purgethemecache'] = 'Témy';
$string['query'] = 'Dotaz';
$string['question'] = 'Otázka';
$string['questionbehaviours'] = 'Správanie otázok';
$string['questioncwqpfscheck'] = 'Jedna alebo viacero \'náhodných\' otázok v teste je zostavená z otázok pochádzajúcich aj zo zdieľaných aj z nezdieľaných kategórií. Viac o <a href="{$a->reporturl}">tomto probléme</a>, prípadne aj v <a href="{$a->docsurl}">Moodle dokumentácii</a>.';
$string['questioncwqpfsok'] = 'Výborne. Vo vašich testoch neboli nájdené žiadne \'náhodné\' otázky zostavené z otázok pochádzajúcich aj zo zdieľaných aj z nezdieľaných kategórií.';
$string['questiontype'] = 'Typ otázky';
$string['questiontypes'] = 'Typy otázok';
$string['quizattemptsupgradedmessage'] = 'Vo verzii Moodle 2.1 bol uskutočnený zásadný upgrade otázok. Bolo možné zdržať časť upgradu databázy tak, aby sa uskutočnila neskôr. Pred upgradovaním na Moodle 2.7 musí byť tento upgrade dokončený.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA privátny kľúč';
$string['recaptchapublickey'] = 'ReCAPTCHA kľúč portálu';
$string['referrernone'] = 'Východzie nastavenie prehliadača';
$string['referrerpolicy'] = 'Politika referrera';
$string['referrerpolicydesc'] = 'Nastavte politiku záhlavia referrera, aby bola zahrnutá v odpovediach z vášho portálu';
$string['register'] = 'Registrujte svoj portál';
$string['registration'] = 'Registrácia';
$string['registration_help'] = 'Registráciou:

* Obdržíte bezpečnostné upozornenia
* Môžete aktivovať aplikáciu mobilných oznámení zo svojho portálu
* Prispievate do našich štatistík Moodle celosvetovej komunity';
$string['registrationwarning'] = 'Váš portál ešte nie je zaregistrovaný.';
$string['registrationwarningcontactadmin'] = 'Váš portál ešte nie je registrovaný. Informujte prosím svojho administrátora.';
$string['releasenoteslink'] = 'Informácie o tejto verzii Moodle nájdete v <a target="_blank" href="{$a}">Poznámkach k verzii</a>';
$string['rememberuserlicensepref'] = 'Zapamätať preferencie používateľskej licencie';
$string['rememberuserlicensepref_help'] = 'Ak je povolené, pri nahrávaní súboru do nástroja pre výber súboru je dopredu vybraná posledná licencia vybraná používateľom. Inak bude predvolená východzia licencia portálu.';
$string['rememberusername'] = 'Zapamätať meno používateľa';
$string['rememberusername_desc'] = 'Aktivujte túto možnosť, ak chcete uchovať trvalé cookies s používateľskými menami počas prihlasovania používateľa. Trvalé cookies je možné pokladať za súkromnú záležitosť, ak sa používajú bez súhlasu.';
$string['replacefrontsearch'] = 'Používa sa pre vyhľadávanie kurzu na titulnej stránke';
$string['reportsmanage'] = 'Spravovať štatistiky';
$string['required'] = 'Povinné';
$string['requiredentrieschanged'] = 'Poznámka: Po upgrade je teraz v nasledujúcich databázových činnostiach vynútené nastavenie „Povinné položky pred prehliadaním: <br/> {$ a-> text} <br/>';
$string['requiremodintro'] = 'Vyžadovať opis aktivity';
$string['requiremodintro_desc'] = 'Ak je táto možnosť aktivovaná, bude sa vyžadovať zadanie opisu pre každú aktivitu.';
$string['requires'] = 'Vyžaduje';
$string['resetindentation'] = 'Obnovenie odsadenia na celom portáli';
$string['resetindentation_help'] = 'Tým sa odstráni akékoľvek odsadenie predtým nastavené pre všetky kurzy na stránke v {$a->format}.';
$string['resetindentation_title'] = 'Obnovenie odsadenia na celom portáli?';
$string['resetindentationsuccess'] = 'Odsadenie obnovené.';
$string['restorecourse'] = 'Obnoviť kurz';
$string['restorernewroleid'] = 'Rola obnovovateľa v kurzoch';
$string['restorernewroleid_help'] = 'Ak používateľ ešte nemá povolenie spravovať novo obnovený kurz, používateľovi je automaticky priradená táto rola a je prihlásený, ak je to potrebné. Zvoľte  "Žiadna", ak nechcete, aby obnovovatelia mohli spravovať každý obnovený kurz.';
$string['resultfilter'] = 'Filtrujte podľa výsledkov';
$string['reverseproxy'] = 'Reverzné proxy';
$string['reverseproxyignore'] = 'Ignorovať reverzné proxy';
$string['riskconfig'] = 'Používatelia môžu meniť nastavenia a chovanie stránok (serveru)';
$string['riskconfigshort'] = 'Riziko zásahu do konfigurácie';
$string['riskdataloss'] = 'Používatelia by mohli zničiť veľké množstvá obsahu alebo informácií';
$string['riskdatalossshort'] = 'Hrozba straty informácii';
$string['riskmanagetrust'] = 'Používatelia môžu meniť úroveň dôveryhodnosti iných používateľov';
$string['riskmanagetrustshort'] = 'Správa dôveryhodnosti';
$string['riskpersonal'] = 'Používatelia môžu získať prístup k súkromným informáciám iných používateľov';
$string['riskpersonalshort'] = 'Riziko zásahu do súkromia';
$string['riskspam'] = 'Používatelia môžu zasielať nevyžiadanú poštu (spam) ďalším používateľom';
$string['riskspamshort'] = 'Riziko spamu';
$string['riskxss'] = 'Používatelia môžu pridávať súbory či texty umožňujúce Cross-Site Scripting (XSS).';
$string['riskxssshort'] = 'Riziko XSS';
$string['roleswithexceptions'] = '{$a->roles}, s {$a->exceptions}';
$string['rssglobaldisabled'] = 'Nepovolené na úrovni portálu';
$string['save'] = 'Uložiť';
$string['savechanges'] = 'Uložiť zmeny';
$string['scssinvalid'] = 'Kód SCSS nie je platný, zlyhal na : {$a}';
$string['search'] = 'Prehľadávaj';
$string['searchablecourses'] = 'Prehľadávateľné kurzy';
$string['searchallavailablecourses'] = 'Prehľadávateľné kurzy';
$string['searchallavailablecourses_desc'] = 'V niektorých situáciách nemusí vyhľadávač fungovať pri vyhľadávaní veľkého počtu kurzov. Ak chcete obmedziť počet vyhľadávaných kurzov, nastavte, aby sa vyhľadávali iba zapísané kurzy.';
$string['searchallavailablecourses_off'] = 'Hľadať iba v rámci prihlásených kurzov';
$string['searchallavailablecourses_on'] = 'Hľadať vo všetkých kurzoch, ku ktorým má používateľ prístup';
$string['searchallavailablecoursesdesc'] = 'Ak je nastavené iba pre vyhľadávanie v rámci zapísaných kurzov, budú informácie o kurzu (meno a súhrn) a obsah kurzu vyhľadávané iba v kurzoch, do ktorých je používateľ zapísaný. V opačnom prípade budú informácie o kurze a obsah kurzu prehľadávané vo všetkých kurzoch, ku ktorým má používateľ prístup, napríklad kurzy s povoleným prístupom hosťa.';
$string['searchalldeleted'] = 'Všetky indexované obsahy boli odstránené';
$string['searchalternatesettings'] = 'Alternatívne nastavenie iba pre dotazy';
$string['searchalternatesettings_desc'] = 'Ak dokončíte tieto nastavenia, môžete vybrať „alternatívne nastavenia“ pre tento vyhľadávač vo voľbe vyhľadávača iba pre vyhľadávanie na stránke „Správa globálneho vyhľadávania“. To je užitočné iba pri prechode medzi dvoma vyhľadávačmi rovnakého typu.';
$string['searchareadisabled'] = 'Oblasť vyhľadávania je zakázaná';
$string['searchareaenabled'] = 'Oblasť vyhľadávania je povolená';
$string['searchareas'] = 'Oblasti vyhľadávania';
$string['searchbanner'] = 'Hľadať informácie';
$string['searchbannerenable'] = 'Zobraziť informácie vyhľadávania';
$string['searchbannerenable_desc'] = 'Ak je táto možnosť povolená, zobrazí sa text nižšie v hornej časti vyhľadávacej obrazovky pre všetkých používateľov. Toto je možné použiť k informovaniu používateľov o vykonávaní údržby vyhľadávača.';
$string['searchdefaultcategory'] = 'Východzia kategória vyhľadávania';
$string['searchdefaultcategory_desc'] = 'Výsledky vo vybranej kategórii pre vyhľadávaciu oblasť sa zobrazujú vo východzom nastavení.';
$string['searchdeleteindex'] = 'Odstrániť všetok indexovaný obsah';
$string['searchdisplay'] = 'Možnosti zobrazenia výsledkov vyhľadávania';
$string['searchenablecategories'] = 'Zobraziť výsledky v oddelených kategóriách';
$string['searchenablecategories_desc'] = 'Ak je povolené, budú výsledky vyhľadávania zobrazené v samostatných kategóriách.';
$string['searchengine'] = 'Vyhľadávač';
$string['searchenginealternatesettings'] = '{$a} (alternatívne nastavenie';
$string['searchenginequeryonly'] = 'Vyhľadávací modul iba pre dotazy';
$string['searchenginequeryonly_desc'] = 'Tento vyhľadávač bude použitý iba pre vytváranie dotazov, ale nie pre indexovanie. Pomocou tejto funkcie môžete reindexovať v inom vyhľadávači, kým používateľské dotazy aj ďalej fungujú od tohto.';
$string['searchenginequeryonly_none'] = 'Žiadne (pre dotazy použite hlavný vyhľadávač)';
$string['searchenginequeryonlysame'] = 'Vyhľadávací stroj iba pre dotazy a hlavní vyhľadávač nie je možné nastaviť na rovnakú hodnotu.';
$string['searchhideallcategory'] = 'Skryť kategóriu Všetky výsledky';
$string['searchhideallcategory_desc'] = 'Ak je povolené, bude na obrazovke vyhľadávania u všetkých výsledkov skrytá kategória';
$string['searchincludeallcourses'] = 'Zahrnúť všetky viditeľné kurzy';
$string['searchincludeallcourses_desc'] = 'Aj je táto možnosť povolená, výsledky vyhľadávania budú obsahovať informácie o kurzu (názov a súhrn) kurzov, ktoré sú používateľovi viditeľné, aj keď nemajú prístup k obsahu kurzu.';
$string['searchindexactions'] = 'Akcia indexovania';
$string['searchindexdeleted'] = 'Index odstránený';
$string['searchindextime'] = 'Časový limit indexovania';
$string['searchindextime_desc'] = 'Pri indexovaní veľkého množstva nového obsahu sa plánovaná úloha zastaví po dosiahnutí tohto časového limitu. Bude pokračovať pri ďalšom spustení úlohy.';
$string['searchindexupdated'] = 'Obsah vyhľadávača bol aktualizovaný';
$string['searchindexwhendisabled'] = 'Interval, ak je zakázané';
$string['searchindexwhendisabled_desc'] = 'Umožňuje plánovanej úlohe zostaviť index hľadania, aj keď je vyhľadávanie zakázané. To je užitočné, ak chcete vytvoriť index predtým, než sa študentom objaví možnosť vyhľadávania.';
$string['searchinsettings'] = 'Hľadaj v nastaveniach';
$string['searchlastrun'] = 'Posledné spustenie (čas, # dokumentov, # záznamov, # ignorovaných)';
$string['searchmanagement'] = 'Správa vyhľadávania';
$string['searchmanagement_desc'] = 'Tieto možnosti sú užitočné pri vykonávaní zmien na portáloch s veľmi veľkými indexmi vyhľadávania, ktorých obnovenie trvá dlho.';
$string['searchmaxtopresults'] = 'Maximálny počet najlepších výsledkov';
$string['searchmaxtopresults_desc'] = 'Maximálny počet výsledkov s najvyšším hodnotením, ktoré sa majú zobraziť nad výsledkami vyhľadávania pre obsah kurzu, kurzy a používateľov.';
$string['searchnotavailable'] = 'Vyhľadávanie nie je povolené';
$string['searchoptions'] = 'Možnosti hľadania';
$string['searchpartial'] = '(ešte nie je úplne indexované)';
$string['searchreindexed'] = 'Celý obsah webu bol preindexovaný.';
$string['searchreindexindex'] = 'Reindexovať celý obsah portálu';
$string['searchresults'] = 'Výsledky hľadania';
$string['searchsetupinfo'] = 'Nastavenie vyhľadávania';
$string['searchteacherroles'] = 'Role učiteľov';
$string['searchteacherroles_desc'] = 'Vyberte všetky role, vďaka ktorým sú používatelia s rolou hodnotením vo výsledkoch vyhľadávania vyššie.';
$string['searchtopresults'] = 'Najvýznamnejšie výsledky vyhľadávania';
$string['searchupdateindex'] = 'Aktualizácia indexovaného obsahu';
$string['sectionerror'] = 'Chyba v sekcii!';
$string['secureforms'] = 'Použiť pridané zabezpečenie formulára';
$string['security'] = 'Zabezpečenie';
$string['selectdevice'] = 'Vybrať zariadenie';
$string['selectsearchengine'] = 'Vybrať vyhľadávač';
$string['selecttheme'] = 'Vybrať tému pre {$a} zariadenie';
$string['server'] = 'Server';
$string['serverchecks'] = 'Kontroly servera';
$string['serverlimit'] = 'Limit servera';
$string['servicespage'] = 'Odkaz na služby a podporu';
$string['sessionautostartwarning'] = '<p>Bola zistená závažná chyba v konfigurácii servera. Prosím, upozornite jeho administrátora: Moodle vyžaduje zmeny v nastavení PHP.</p><p>Konfiguračný parameter <code>session.auto_start</code> musí byť nastavený na hodnotu <code>off</code>.</p><p>Toto nastavenie je možné napríklad zmeniť v súbore <code>php.ini</code>, v konfigurácii Apache/IIS alebo pomocou súboru <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Prípona názvu cookie';
$string['sessioncookiedomain'] = 'Doména cookie';
$string['sessioncookiepath'] = 'Cesta platnosti cookie';
$string['sessionhandling'] = 'Správa sedenia (sessions)';
$string['sessiontimeout'] = 'Časový limit';
$string['sessiontimeoutwarning'] = 'Upozornenie na časový limit';
$string['settingdependenton'] = 'Toto nastavenie môže byť skryté na základe hodnoty <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Nahrávanie súborov je požadované pre normálnu prevádzku, prosím aktivujte ho v konfigurácii PHP.';
$string['settingmaxinputvars'] = 'Doporučuje sa, aby nastavenie PHP max_input_vars bolo aspoň 5 000.';
$string['settingmaxinputvarsrequired'] = 'Nastavenie PHP max_input_vars musí byť aspoň 5 000.';
$string['settingmemorylimit'] = 'Bolo zistené nedostatočné množstvo pamäte, prosím nastavte vyšší limit pamäte v nastaveniach PHP.';
$string['settingsafemode'] = 'PHP je momentálne prevádzkované v obmedzenom režime, známom ako "safe mode". Moodle nie je s týmto režimom kompatibilné. Ak budete prevádzkovať Moodle v safe mode, môžete čeliť rozličným problémom s funkcionalitou portálu. Požiadajte administrátora serveru o vypnutí tohto režimu.';
$string['settingzendexceptionignoreargs'] = 'Dôrazne sa odporúča, aby bolo z bezpečnostných dôvodov povolené nastavenie PHP zend.exception_ignore_args.';
$string['setupsearchengine'] = 'Nastaviť vyhľadávač';
$string['showcommentscount'] = 'Zobraziť počet komentárov';
$string['showdetails'] = 'Zobraziť detaily';
$string['showuseridentity'] = 'Zobraziť identitu používateľa';
$string['showuseridentity_desc'] = 'Pri výbere alebo vyhľadávaní používateľov a pri zobrazovaní zoznamov používateľov sa tieto polia môžu zobraziť spolu s ich celým menom. Polia sa zobrazujú iba používateľom, ktorí majú schopnosť moodle/site:viewuseridentity; štandardne učitelia a manažéri. (Táto možnosť má najväčší zmysel, ak si vyberiete jedno alebo dve polia, ktoré sú vo vašej inštitúcii povinné.)

Polia označené * sú polia vlastného používateľského profilu. Tieto polia môžete vybrať, ale v súčasnosti existujú obrazovky, na ktorých sa nezobrazia.';
$string['simplexmlrequired'] = 'PHP rozšírenie SimpleXML je vyžadované pre Moodle';
$string['sitemailcharset'] = 'Znaková sada';
$string['sitemaintenance'] = 'Stránka prechádza údržbou a momentálne nie je k dispozícii';
$string['sitemaintenancemode'] = 'Režim údržby';
$string['sitemaintenanceoff'] = 'Režim údržby bol deaktivovaný a táto stránka bude ďalej bežať normálne';
$string['sitemaintenanceon'] = 'Vaša stránka je momentálne v režime údržby (prihlásiť sa a používať stránku môžu iba administrátori).';
$string['sitemaintenanceoncli'] = 'Vaša stránka je momentálne v móde CLI údržby. Nie je povolený žiadny prístup na web.';
$string['sitemaintenancetitle'] = '{$a} prebieha údržba';
$string['sitemaintenancewarning'] = 'Vaša stránka je momentálne v režime údržby (prihlásiť sa a používať stránku môžu iba administrátori). Pre návrat k normálnej prevádzke stránky <a href="maintenance.php">deaktivujte režim údržby</a>.';
$string['sitemaintenancewarning2'] = 'Vaša stránka je aktuálne v móde údržby (prihlásiť sa môžu iba administrátori). Aby ste vrátili stránku do normálnej prevádzky, <a href="{$a}">deaktivujte mód údržby</a>.';
$string['sitemenubar'] = 'Navigácia portálu';
$string['sitenameintitle'] = 'Zahrnúť názov portálu do názvu stránky';
$string['sitenameintitle_help'] = 'Toto nastavenie pridá názov portálu na koniec názvu stránky. Odporúča sa zahrnúť názov portálu do názvu stránky, pretože to zlepší prístupnosť lokality tým, že umožní používateľom rýchlo identifikovať stránku, na ktorej sa práve nachádzajú.';
$string['sitepolicies'] = 'Bezpečnostné nastavenia portálu';
$string['sitepolicy'] = 'URL k pravidlám prevádzky stránok';
$string['sitepolicy_help'] = 'Ak máte definované pravidlá, ktoré všetci používatelia musia vidieť a s nimi súhlasiť pred používaním tejto stránky, potom sem vložte danú URL adresu. Všimnite si, že toto nastavenie bude mať vplyv iba v prípade, že je obslužný program zásad portálu nastavený na východzí (jadro).';
$string['sitepolicyguest'] = 'URL pre politiku portálu pre hostí';
$string['sitepolicyguest_help'] = 'Ak máte pravidlá prevádzky stránky, ktoré všetci návštevníci stránky musia vidieť a musia s nimi súhlasiť pred používaním tejto stránky, potom na tomto mieste špecifikujte URL adresu, kde sa nachádzajú tieto pravidlá. Všimnite si, že toto nastavenie bude mať vplyv iba v prípade, že je obslužný program zásad portálu nastavený na východzí (jadro).';
$string['sitepolicyhandler'] = 'Správca zásad portálu';
$string['sitepolicyhandler_desc'] = 'To určuje spôsob spravovania zásad a súhlasov používateľov Východzí (jadro) obslužný program umožňuje zadať adresu URL zásady a adresu URL stránky pre hostí. Správa zásad umožňuje nastaviť zásady, zásady ochrany osobných údajov a ďalšie zásady. Umožňuje tiež prezeranie používateľských súhlasov a prípadne súhlas menom neplnoletých.';
$string['sitepolicyhandlercore'] = 'Východzí (základný)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Zobrazenie časti v hornej časti stránky, do ktorej môžete pridať vlastný obsah.';
$string['sixtyfourbitsrequired'] = 'Zistilo sa, že vaša stránka nepoužíva 64-bitovú verziu PHP. Pred inštaláciou tejto verzie Moodle musíte aktualizovať svoj systém (operačný systém, PHP...).';
$string['sixtyfourbitswarning'] = 'Bolo zistené, že váš web nepoužíva 64bitovú verziu PHP. Doporučuje sa, aby ste svoj portál aktualizovali aby ste zaistili budúcu kompatibilitu.';
$string['slasharguments'] = 'Predávanie argumentov za lomítkom';
$string['slashargumentswarning'] = 'Odporúča sa, aby bolo používanie argumentov za lomítkom aktivované. V budúcnosti bude toto nastavenie povinné. Ďalšie podrobnosti nájdete v dokumentácii na <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smallscreensonly'] = 'Len malé obrazovky';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) nastavenie pre odoslanie emailu.';
$string['smtphosts'] = 'SMTP hostitelia';
$string['smtpmaxbulk'] = 'Limit pre SMTP sekciu';
$string['smtppass'] = 'SMTP heslo';
$string['smtpsecure'] = 'SMTP zabezpečenie';
$string['smtpuser'] = 'SMTP používateľské meno';
$string['soaprecommended'] = 'Inštalácia nepovinného rozšírenia SOAP je vhodná pre web služby a niektoré rozšírenia.';
$string['sort_fullname'] = 'Celý názov kurzu';
$string['sort_idnumber'] = 'ID číslo kurzu';
$string['sort_shortname'] = 'Krátky názov kurzu';
$string['sort_sortorder'] = 'Poradie triedenia';
$string['spellengine'] = 'Nástroj pre speller';
$string['spelllanguagelist'] = 'Zoznam jazykov pre kontrolu pravopisu';
$string['splrequired'] = 'SPL rozšírenie PHP je v Moodle vyžadované.';
$string['stats'] = 'Štatistiky';
$string['statsfirstrun'] = 'Maximálny interval spracovania';
$string['statsmaxruntime'] = 'Maximálny čas spracovania';
$string['statsmoodleorg'] = 'štatistika';
$string['statsruntimedays'] = 'Počet spracovaných dní';
$string['statsruntimestart'] = 'Spúšťať o';
$string['statsuserthreshold'] = 'Používateľský prah';
$string['stickyblocks'] = 'Povinné bloky';
$string['stickyblockscourseview'] = 'Stránka kurzu';
$string['stickyblocksduplicatenotice'] = 'Ak sa vybraný blok na zvolenej stránke už vyskytuje, bude sa na nej zobrazovať dvakrát.<br />Povinný blok nebude možné upravovať, duplicitný (nepovinný) blok áno.';
$string['stickyblocksmymoodle'] = 'Môj Moodle';
$string['stickyblockspagetype'] = 'Typ stránky';
$string['strictformsrequired'] = 'Striktné overenie platnosti požadovaných polí';
$string['stripalltitletags'] = 'Odstrániť HTML tagy zo všetkých názvov aktivít';
$string['supportandservices'] = 'Podpora a služby';
$string['supportavailability'] = 'Dostupnosť podpory';
$string['supportcontact'] = 'Kontakt na technickú podporu';
$string['supportemail'] = 'Emailová podpora';
$string['supportemailsubject'] = 'Žiadosť o podporu portálu – {$a}';
$string['supportname'] = 'Meno podpory';
$string['supportpage'] = 'Odkaz na stránku podpory';
$string['suspenduser'] = 'Pozastaviť platnosť používateľského účtu';
$string['switchlang'] = 'Prepnúť umiestnenie jazyka';
$string['systempaths'] = 'Cesty k súborom';
$string['tablenosave'] = 'Zmeny v tabuľke uvedenej vyššie sú automaticky uložené.';
$string['tablesnosave'] = 'Zmeny v tabuľkách uvedených vyššie sú automaticky uložené.';
$string['tabselectedtofront'] = 'V tabuľkách, ktoré používajú navigáciu pomocou záložiek, by sa mal riadok s práve vybranou záložkou presunúť do popredia';
$string['tabselectedtofronttext'] = 'Priniesť vybranú kartu do popredia';
$string['task_adhoc_concurrency_limit'] = 'Limit súbežnosti adhoc úloh';
$string['task_adhoc_concurrency_limit_desc'] = 'Počet bežiacich úloh adhoc povolených k súčasnému spusteniu.  Ak je limit vysoký, potom naplánované úlohy nemusia bežať pravidelne, ak je adhoc úloh veľa. Nastavenie 0 úplne zakáže spracovanie úloh adhoc.';
$string['task_adhoc_failed_retention'] = 'Neúspešné obdobie uchovávania ad hoc úloh';
$string['task_adhoc_failed_retention_desc'] = 'Maximálna doba, počas ktorej by neúspešné úlohy ad hoc mali zostať vo fronte po dosiahnutí limitu opakovania.';
$string['task_adhoc_max_runtime'] = 'Čas trvania adhok úloh';
$string['task_adhoc_max_runtime_desc'] = 'Vek spúšťača adhoc úloh pred tým, kým je uvoľnený. Doporučuje sa krátke trvanie, pretože počet úloh adhoc vo fronte nie je obmedzený. Ak je toto číslo príliš vysoké a máte dlhú frontu adhoc úloh, nemusia byť naplánované úlohy pravidelne spustené.';
$string['task_dbreads'] = 'Čítanie z databázy';
$string['task_dbstats'] = 'Databáza';
$string['task_dbwrites'] = 'Zápis so databázy';
$string['task_duration'] = 'Dĺžka trvania';
$string['task_endtime'] = 'Čas ukončenia';
$string['task_logmode'] = 'Kedy logovať';
$string['task_logmode_all'] = 'Uložiť výstup protokolov všetkých úloh';
$string['task_logmode_desc'] = 'Môžete si vybrať, kedy chcete vykonať protokolovanie úloh. Vo východzom nastavení sú protokoly zaznamenané vždy. Môžete protokolovanie úplne zakázať alebo zmeniť iba na úlohy protokolu, ktoré zlyhávajú.';
$string['task_logmode_failonly'] = 'Ukladať protokoly iba pre úlohy, ktoré zlyhali';
$string['task_logmode_none'] = 'Neprotokolovať nič';
$string['task_logoutput'] = 'Výstup úlohy';
$string['task_logretainruns'] = 'Ponechať behy';
$string['task_logretainruns_desc'] = 'Počet jednotlivých úloh, ktoré je treba nechať. Toto nastavenie spolupracuje s nastavením "Interval uchovávania": platí to, čo je dosiahnuté skôr.';
$string['task_logretention'] = 'Interval uchovávania';
$string['task_logretention_desc'] = 'Maximálny interval, počas ktorého by mali byť protokoly uchovávané. Toto nastavenie interaguje s nastavením "Zachovať behy": platí to, čo je dosiahnuté skôr.';
$string['task_logtostdout'] = 'Zobraziť výstup protokolu';
$string['task_logtostdout_desc'] = 'Ak sú úlohy spustené a výstup je zachytené, či zachytený výstup je zobrazený aj pri behu úlohy.';
$string['task_result'] = 'Výsledok';
$string['task_result:failed'] = 'Neúspešné';
$string['task_scheduled_concurrency_limit'] = 'Plánovaný limit súbežnosti úlohy';
$string['task_scheduled_concurrency_limit_desc'] = 'Počet naplánovaných súbežne bežiacich úloh, ktorý je povolený. Ak je limit vysoký, môže sa na serveri vyskytnúť vysoké zaťaženie, ktoré ovplyvňuje výkon.';
$string['task_scheduled_max_runtime'] = 'Naplánovaná životnosť bežiacej úlohy';
$string['task_scheduled_max_runtime_desc'] = 'Vek plánovanej úlohy predtým, než je uvoľnená.';
$string['task_starttime'] = 'Začína';
$string['task_stats:dbreads'] = '{$a} čítaní';
$string['task_stats:dbwrites'] = '{$a} zápisov';
$string['task_status'] = 'Stav úlohy';
$string['task_status_desc'] = 'Stav úlohy {$a->name}:  {$a->status}. Podrobnosti: {$a->class}{$a->extradescription} na stránke <a href="{$a->gotourl}">Naplánované úlohy</a>.';
$string['task_type:adhoc'] = 'Adhoc';
$string['task_type:scheduled'] = 'Naplánované';
$string['taskadmintitle'] = 'Úlohy';
$string['taskanalyticscleanup'] = 'Vyčistenie analýzy';
$string['taskautomatedbackup'] = 'Automatické zálohy';
$string['taskautomatedbackup_report'] = 'Správa o automatizovanom zálohovaní';
$string['taskbackupcleanup'] = 'Vyčistiť tabuľky, protokoly záloh a súbory';
$string['taskbadgesadhoc'] = 'Udeľovanie odznakov';
$string['taskbadgescron'] = 'Pridanie adhoc úloh na udeľovanie odznakov';
$string['taskbadgesmessagecron'] = 'Spracovanie odosielania notifikácií na pozadí';
$string['taskblogcron'] = 'Synchronizovať externé blogy';
$string['taskcachecleanup'] = 'Odstrániť exspirované položky vyrovnávacej pamäte';
$string['taskcachecron'] = 'Vyrovnávacie pamäte spracovať na pozadí';
$string['taskcalendarcron'] = 'Odoslať kalendárové upozornenia';
$string['taskcheckforupdates'] = 'Skontrolovať aktualizácie';
$string['taskcompletiondaily'] = 'Zahájenie označenie splnenia';
$string['taskcompletionregular'] = 'Vypočítať pravidelné údaje ukončenia';
$string['taskcontextcleanup'] = 'Odstrániť kontexty';
$string['taskcreatecontexts'] = 'Vytvoriť chýbajúce kontexty';
$string['taskdeletecachetext'] = 'Zmazať staré textové záznamy vyrovnávacej pamäte';
$string['taskdeleteincompleteusers'] = 'Zmazať nedokončených používateľov';
$string['taskdeleteunconfirmedusers'] = 'Zmazať nepotvrdených používateľov';
$string['taskeventscron'] = 'Udalosti spracovať na pozadí';
$string['taskfiletrashcleanup'] = 'Odstrániť súbory v odpadkovom koši';
$string['taskglobalsearchindex'] = 'Indexovanie pre globálne vyhľadávanie';
$string['taskglobalsearchoptimize'] = 'Optimalizácia indexu pre globálne vyhľadávanie';
$string['taskgradecron'] = 'Klasifikačný výpis spracovať na pozadí';
$string['taskgradehistorycleanup'] = 'Spracovanie čistenia tabuľky hist=orie známkovania na pozadí';
$string['taskh5pcleanup'] = 'Vyčistenie nepoužívaných súborov H5P';
$string['tasklegacycron'] = 'Spracovanie zastaralých cronov pre pluginy';
$string['tasklockcleanuptask'] = 'Vyčistiť metadáta úloh ad hoc';
$string['tasklogcleanup'] = 'Vyčistenie logov úloh';
$string['tasklogging'] = 'Konfigurácia logov úloh';
$string['tasklogs'] = 'Protokoly úloh';
$string['taskmessagingcleanup'] = 'Posielanie správ spracovať na pozadí';
$string['taskpasswordresetcleanup'] = 'Odstrániť pokusy o obnovenie hesiel';
$string['taskplagiarismcron'] = 'Spracovanie zastaralého cronu modulov plagiátorstva na pozadí';
$string['taskportfoliocron'] = 'Pluginy portfólia spracovať na pozadí';
$string['taskprocessing'] = 'Spracovanie úloh';
$string['taskquestioncron'] = 'Spracovanie čistenia prehľadov úloh na pozadí';
$string['taskquestionstatscleanupcron'] = 'Spracovanie na pozadí na čistenie vyrovnávacej pamäte štatistík otázok';
$string['taskrefreshsystemtokens'] = 'Obnoviť OAuth tokeny pre účty služieb';
$string['taskregistrationcron'] = 'Registrácia stránky';
$string['tasksendfailedloginnotifications'] = 'Poslať notifikácie o neúspešnom prihlásení sa';
$string['tasksendnewuserpasswords'] = 'Poslať nové používateľské heslá';
$string['tasksessioncleanup'] = 'Odstrániť staré relácie';
$string['taskstatscron'] = 'Štatistiky spracovať na pozadí';
$string['tasktagcron'] = 'Tagy spracovať na pozadí';
$string['tasktempfilecleanup'] = 'Zmazať staré dočasné súbory';
$string['tasktype'] = 'Typ';
$string['tempdatafoldercleanup'] = 'Odstrániť dočasné súbory staršie ako';
$string['templates'] = 'Šablóny';
$string['testoutgoingmailconf'] = 'Test konfigurácie odchádzajúcej  pošty';
$string['testoutgoingmailconf_errorcommunications'] = 'Váš portál nemohol komunikovať s poštovným serverom. Skontrolujte konfiguráciu odchádzajúcej pošty.';
$string['testoutgoingmailconf_fromemail'] = 'Z používateľského mena alebo e-mailovej adresy';
$string['testoutgoingmailconf_fromemail_help'] = 'Toto pole emuluje odosielanie správy od tohto používateľa, ale záhlavie Odosielateľ použité v skutočnom odoslanom e -maili bude závisieť na iných nastaveniach, ako sú povolené emailové domény.';
$string['testoutgoingmailconf_fromemail_invalid'] = 'Neplatný Odosielateľ používateľské meno alebo e -mail. Musí to byť platný formát e -mailu alebo existujúce používateľské meno v Moodle.';
$string['testoutgoingmailconf_message'] = 'Toto je testovacia správa, ktorá potvrdzuje, že ste úspešne nakonfigurovali odchádzajúcu poštu na tomto portáli.

Odoslané: {$a}';
$string['testoutgoingmailconf_sendtest'] = 'Odoslať testovaciu správu';
$string['testoutgoingmailconf_sentmail'] = 'Tento portál úspešne doručil testovaciu správu na poštovný server.<br />Od: {$a->fromemail}<br />Komu: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a->site}: testovacia správa. {$a->additional} Odoslané: {$a->time}';
$string['testoutgoingmailconf_subjectadditional'] = 'Doplnkový predmet';
$string['testoutgoingmailconf_toemail'] = 'Na emailovú adresu';
$string['testoutgoingmaildetail'] = 'Poznámka: pred testovaním musíte uložiť konfiguráciu. <br/>{$a}';
$string['testsiteupgradewarning'] = 'Momentálne používate {$a} testovaciu stránku, aby ste ju správnym spôsobom upgradovali, použite interfejsový nástroj príkazového riadku';
$string['themedefinedinconfigphp'] = 'Tému nie je možné zmeniť, pretože je nastavená na {$a} v súbore config.php.';
$string['themedesignermode'] = 'Mód navrhovateľov tém';
$string['themedesignermodewarning'] = 'Je povolený režim úprav grafickej témy. To by nemalo byť povolené na produkčných weboch, to môže výrazne znížiť výkon.';
$string['themeeditsettingsname'] = 'Upraviť nastavenia témy \'{$a}\'';
$string['themelist'] = 'Zoznam tém';
$string['themenoselected'] = 'Nie je zvolená žiadna téma';
$string['themeresetcaches'] = 'Vyčistiť vyrovnávaciu pamäť témy';
$string['themeselect'] = 'Zmeniť tému';
$string['themeselector'] = 'Témy';
$string['themesettings'] = 'Nastavenie témy';
$string['themesettingsadvanced'] = 'Pokročilé nastavenia tém';
$string['themesettingscustom'] = 'Voliteľné nastavenia tém';
$string['themesettingsname'] = 'Nastavenia témy \'{$a}\'';
$string['themeusagereportname'] = 'Správa o používaní témy \'{$a}\'';
$string['therewereerrors'] = 'Vo Vašich údajoch boli nájdené chyby';
$string['thirdpartylibrary'] = 'Knižnica';
$string['thirdpartylibrarylocation'] = 'Umiestnenie';
$string['thirdpartylibs'] = 'Knižnice tretích strán';
$string['timezone'] = 'Východzie časové pásmo';
$string['timezoneforced'] = 'Toto je nastavené administrátorom stránky';
$string['timezoneinvalid'] = 'Neplatná časová zóna "{$a}"';
$string['timezoneisforcedto'] = 'Nastaviť rovnaké použitie pre všetkých používateľov';
$string['timezonenotforced'] = 'Používateľ si môže vybrať vlastnú časovú zónu';
$string['timezonephpdefault'] = 'Štandardná PHP časová zóna ({$a})';
$string['timezoneserver'] = 'Časová zóna serveru ({$a})';
$string['tlswarning'] = 'Bola zistená neexistencia rozšírenia PHP/cURL s podporou TLSv1.2. Niektoré služby nemusia fungovať. Dôrazne sa odporúča vykonať aktualizáciu vašej knižnice TLS.';
$string['tokenduration'] = 'Používateľ vytvoril token trvania';
$string['tokenduration_desc'] = 'Čas, po ktorom je token  webových služieb vytvorený používateľom platný (napríklad prostredníctvom mobilnej aplikácie).';
$string['tokenizerrecommended'] = 'Inštalácia voliteľného rozšírenia PHP Tokenizer je doporučovaná - zlepšuje možnosti Moodle Networking.';
$string['tools'] = 'Administrátorské nástroje';
$string['toolsmanage'] = 'Spravovať administrátorské nástroje';
$string['unattendedoperation'] = 'Bez obsluhy';
$string['unbookmarkthispage'] = 'Odstrániť záložku k tejto stránke';
$string['unicoderequired'] = 'Všetky údaje musia byť uložené vo formáte Unicode (UTF-8). Pri nových inštaláciách musí mať databáza ako predvolenú znakovú sadu UTF-8. Ak vykonávate aktualizáciu, musíte postupovať podľa postupu migrácie na UTF-8.';
$string['uninstallplugin'] = 'Odinštalovať';
$string['unlockaccount'] = 'Odomknúť účet';
$string['unoconvwarning'] = 'Verzia unoconv, ktorú ste nainštalovali, nie je podporovaná.';
$string['unsettheme'] = 'Zrušiť nastavenie témy';
$string['unsupported'] = 'Nepodporované';
$string['unsupporteddbfileformat'] = 'Databáza obsahuje tabuľky používajúce ako formát súboru Antelope. Plná podpora UTF-8 v MySQL a MariaDB vyžaduje formát súborov Barracuda. Prepnite tabuľky do formátu Barracuda. Podrobné informácie nájdete v dokumentácii <a href="https://docs.moodle.org/en/cli">MySQL plná podpora unicode </a>.';
$string['unsupporteddbfilepertable'] = 'Pre plnú podporou UTF-8 i MySQL a MariaDB je vyžadované, aby ste zmenili vaše nastavenie MySQL "innodb_file_per_table" na "ON". V dokumentácii nájdete ďalšie podrobnosti.';
$string['unsupporteddblargeprefix'] = 'Pre plnú podporou UTF-8 i MySQL a MariaDB je vyžadované, aby ste zmenili vaše nastavenie MySQL "innodb_large_prefix" na "ON". V dokumentácii nájdete ďalšie podrobnosti.';
$string['unsupporteddbstorageengine'] = 'Použitý nástroj ukladania databázy už nie je podporovaný.';
$string['unsupporteddbtablerowformat'] = 'Vaša databáza má tabuľky, ktoré používajú formát súborov Antelope. Odporúča sa skonvertovať tabuľky na formát súborov Barracuda. Podrobnosti nástroja pre konvertovanie InnoDB tabuliek na Barracudu nájdete v dokumentácii  <a href="https://docs.moodle.org/en/cli">Administration via command line</a> .';
$string['unsupportedphpversion7'] = 'PHP verzia 7 a vyššie nie sú podporované.';
$string['unsupportedphpversion71'] = 'PHP verzia 7.1  a vyššie nie sú podporované.';
$string['unsupportedphpversion72'] = 'PHP verzia 7.2  a vyššie nie sú podporované.';
$string['unsupportedphpversion73'] = 'PHP verzia 7.3  a vyššie nie sú podporované.';
$string['unsupportedphpversion74'] = 'PHP verzia 7.4  a vyššie nie sú podporované.';
$string['unsupportedphpversion80'] = 'PHP verzia 8.0 a vyššie nie sú podporované.';
$string['unsupportedphpversion81'] = 'PHP verzia 8.1 a vyššie nie sú podporované.';
$string['unsupportedphpversion82'] = 'PHP verzie 8.2 a vyššie nie sú podporované.';
$string['unsupportedphpversion83'] = 'PHP verzie 8.3 a vyššie nie sú podporované.';
$string['unsupportedphpversion84'] = 'PHP verzia 8.4 a vyššie nie sú podporované.';
$string['unsuspenduser'] = 'Aktivovať používateľský účet';
$string['updateaccounts'] = 'Aktualizovať existujúce účty';
$string['updateautocheck'] = 'Automaticky kontrolovať dostupné aktualizácie';
$string['updateautocheck_desc'] = 'Ak je povolené, budú sa automaticky kontrolovať dostupné aktualizácie kódu Moodle a všetkých ďalších zástupných modulov. Administrátori portálu sú upozorňovaní na nové aktualizácie.';
$string['updateavailable'] = 'Je dostupná novšia verzia Moodle!';
$string['updateavailable_moreinfo'] = 'Viac informácií...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Verzia {$a}';
$string['updateavailabledetailslink'] = 'Viac informácií na {$a->url}';
$string['updateavailableforplugin'] = 'Pre niektoré z Vašich zásuvných modulov sú dostupné novšie verzie.';
$string['updateavailableinstall'] = 'Nainštalovať túto aktualizáciu';
$string['updateavailableinstallall'] = 'Inštalovať dostupné aktualizácie ({$a})';
$string['updateavailableinstallallhead'] = 'Inštalovať dostupné aktualizácie';
$string['updateavailablenot'] = 'Váš Moodle je aktuálny';
$string['updateavailablerecommendation'] = 'Dôrazne sa odporúča, aby ste svoj portál aktualizovali na najnovšiu verziu, aby ste získali všetky najnovšie bezpečnostné záplaty a opravy chýb.';
$string['updatecomponent'] = 'Aktualizovať komponent';
$string['updateminmaturity'] = 'Požadovaný kód splatnosti';
$string['updateminmaturity_desc'] = 'Informovať o dostupných aktualizáciach iba ak má dostupný kód najmenej zvolenú úroveň splatnosti. Aktualizácie pre pluginy, ktoré nedeklarujú svoju úroveň kódu splatnosti sa hlásia vždy bez ohľadu na toto nastavenie.';
$string['updatenotificationfooter'] = 'Na vašom Moodle portáli {$a->siteurl} je nastavená automatická kontrola dostupných aktualizácií. Túto správu dostávate ako správca uvedeného portálu. Automatickú kontrolu dostupných aktualizácií môžete vypnúť v časti "Administratíva portálu/Server/Dostupné aktualizácie" alebo upraviť zobrazenie tejto správy na stránke predvolieb.';
$string['updatenotifications'] = 'Dostupné aktualizácie';
$string['updatenotificationsubject'] = '[{$a->siteurl}] Dostupné aktualizácie pre Moodle';
$string['updatenotifybuilds'] = 'Informovať o nových buildoch';
$string['updatenotifybuilds_desc'] = 'Ak je táto možnosť aktivovaná, dostupná aktualizácia  kódu Moodle sa hlási aj vtedy, keď je k dispozícii nový build pre aktuálnu verziu. Buildy sú kontinuálne vylepšenia danej Moodle verzie.  Spravidla sa zverejňujú každý týždeň. Ak je táto možnosť deaktivovaná, dostupná aktualizácia sa hlási iba vtedy, keď sa zverejní vyššia verzia Moodle. Kontroly pluginov nie sú týmto nastavením ovplyvnené.';
$string['upgradeerror'] = 'Neznáma chyba pri aktualizácii zásuvného modulu {$a->plugin} na verziu {$a->version}. Nie je možné pokračovať.';
$string['upgradeforumread'] = 'Novou vlastnosťou pridanou do Moodle 1.5 je sledovanie čítaných/nečítaných príspevkov do fór.<br />Pre použitie tejto funkcie je potrebné <a href="{$a}">aktualizovať tabuľky</a>.';
$string['upgradeforumreadinfo'] = 'Novou vlastnosťou pridanou do Moodle 1.5 je sledovanie čítaných/nečítaných príspevkov do fór. Pre použitie tejto funkcie je potrebné aktualizovať tabuľky všetkými informáciami pre sledovanie existujúcich príspevkov. Toto môže trvať podľa veľkosti Vašej stránky až niekoľko hodín a môže to veľmi zaťažiť Váš databázový server. Napriek tomu bude Vaša stránka stále funkčná a používatelia nebudú zasiahnutí. Ak tento proces raz začnete, musíte ho aj dokončiť  (nechajte otvorené okno v prehliadači). Napriek tomu, pokiaľ tento proces zastavíte zatvorením okna, nemusíte sa báť, môžete ho naštartovať znovu.<br /><br />Chcete naštartovať aktualizáciu teraz?';
$string['upgradekeyreq'] = 'Vyžadovať kľúč pre aktualizáciu';
$string['upgradekeyset'] = 'Kľúč pre aktualizáciu (nechajte prázdne, ak nechcete nastaviť)';
$string['upgradelogs'] = 'Vaše staré záznamy musia byť aktualizované, aby bol systém plne funkčný.<a href="{$a}">Viac informácií</a>';
$string['upgradelogsinfo'] = 'Nedávno boli prevedené nejaké zmeny týkajúce sa spôsobu, akým sú záznamy uchovávané. Aby ste si mohli prezerať všetky Vaše staré záznamy, musíte ich aktualizovať. Toto môže trvať dosť dlho (napr. niekoľko hodín - to záleží od Vašej stránky) a môže to dosť zaťažiť samotný databázový server u obsiahlejších stránok. Ak tento proces raz začnete, musíte ho aj dokončiť (nechajte otvorené okno v prehliadači). Neobávajte sa, Vaša stránka bude pre ostatných používateľov fungovať bez problémov, pokým Vy budete aktualizovať záznamy. <br /><br />Chcete aktualizovať Vaše záznamy teraz?';
$string['upgradepluginsfirst'] = 'Odporúča sa najprv nainštalovať všetky dostupné aktualizácie';
$string['upgradepluginsinfo'] = 'Aktualizácia pluginov';
$string['upgradepluginsinfo_help'] = 'Sú k dispozícii aktualizácie pre niektoré z vašich pluginov. Mali by ste ich nainštalovať pred upgradovaním Moodle databázy. Ak vaša stránka nepodporuje rozmiestnenie automatických aktualizácií, musíte stiahnuť a nainštalovať nové verzie pluginov na vašom serveri manuálne.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradesettings'] = 'Nové nastavenia';
$string['upgradesettingsintro'] = 'V priebehu posledného upgrade pribudli nasledujúce nové nastavenia. Vykonajte nutné úpravy oproti východzím hodnotám a stlačte tlačidlo "Uložiť zmeny" na konci tejto stránky.';
$string['upgradestalefiles'] = 'Boli nájdené rôzne verzie Moodle, upgrade nemôže pokračovať';
$string['upgradestalefilesinfo'] = 'Proces aktualizácie Moodle bol prerušený, pretože v adresári Moodle boli objavené PHP skripty z minimálne dvoch hlavných verzií Moodle.

Toto môže neskôr spôsobiť závažné problémy. Ak chcete pokračovať, musíte zaistiť, aby adresár Moodle obsahoval iba súbory z jednej verzie Moodle.

Odporúčaný spôsob vyčistenia vašej Moodle je nasledujúci:

* premenujte aktuálny adresár Moodle na "Moodle_old"
* vytvorte nový adresár Moodle, ktorý obsahuje iba súbory zo štandardného stiahnutého balíka Moodle
* presuňte pôvodný súbor config.php a akékoľvek neštandardné pluginy z adresára "Moodle_old" do nového adresára Moodle.

Keď máte čistý adresár Moodle, obnovte túto stránku, aby ste pokračovali v procese aktualizácie Moodle.

Toto upozornenie je často spôsobené rozbalením štandardného balíčka Moodle do adresára obsahujúceho predchádzajúcu verziu Moodle. Kým pri malých upgradoch to nevadí, problematické to je pri väčších upgradoch Moodle.

Toto upozornenie môže byť tiež zapríčinené nedokončenou kontrolou alebo operáciou aktualizácie z GIT úložiska. V tomto prípade musíte jednoducho počkať na dokončenie operácie, alebo prípadne spustiť príslušný príkaz odstránenia a znovu spustiť operáciu.

Viac informácii môžete nájsť v dokumentácii o upgradoch na <a href="{$a}">{$a}</a>.';
$string['upgradestart'] = 'Aktualizovať databázu Moodle teraz';
$string['upgradesure'] = '<p>Vaše súbory v Moodle boli zmenené a Vy sa práve chystáte aktualizovať Váš server na túto verziu:</p>
<p><strong>{$a}</strong></p>
<p>Ak to teraz začnete, už sa nemôžete vrátiť späť.</p>
<p>Naozaj chcete aktualizovať tento server na túto verziu?</p>';
$string['upgradetimedout'] = 'Aktualizácia trvala príliš dlho a bola zastavená. Reštartujte ju.';
$string['upgradingdata'] = 'Údaje sa aktualizujú';
$string['upgradinglogs'] = 'Záznamy sa aktualizujú';
$string['upgradingversion'] = 'Aktualizácia na novú verziu';
$string['upwards'] = 'a vyššie';
$string['useblogassociations'] = 'Povoliť prepojenia';
$string['user'] = 'Používateľ';
$string['userbulk'] = 'Hromadné operácie s používateľmi';
$string['userbulkdownload'] = 'Export používateľov ako';
$string['userdefaultpreferences'] = 'Štandardné používateľské preferencie';
$string['userfeedbackafterupgrade'] = 'Po každej väčšej aktualizácii';
$string['userfeedbackencouragement'] = '<p>Moodle obsahuje funkciu, ktorá používateľom umožňuje poskytnúť spätnú väzbu o softvéri Moodle prostredníctvom externej stránky s prieskumom, ktorú hostí ústredie Moodle. Na stránku s prieskumom sa neposielajú žiadne informácie identifikujúce používateľa.</p>
<p>Moodle HQ sa snaží byť otvorený a transparentný, pokiaľ ide o postupy zhromažďovania údajov. Preto sa chceme uistiť, že ste si tejto funkcie vedomí a máte nad ňou kontrolu.</p>
<p>Odpovede používateľov pomáhajú spoločnosti Moodle HQ pri zlepšovaní softvéru Moodle. Ak chcete túto funkciu zapnúť, prejdite na stránku <a href="{$a}">Nastavenia spätnej väzby</a>.</p>';
$string['userfeedbacknextreminder'] = 'Ďalšia pripomienka spätnej väzby';
$string['userfeedbacknextreminder_desc'] = 'Kedy by sme mali používateľa požiadať o spätnú väzbu?';
$string['userfeedbackperiodically'] = 'Pravidelne';
$string['userfeedbackremindafter'] = 'Zobraziť pripomienku po';
$string['userfeedbackremindafter_desc'] = 'Pripomenúť používateľom, aby po danom počte dní poskytli spätnú väzbu,';
$string['userfiltersdefault'] = 'Východzie používateľské filtre';
$string['userfiltersdefault_desc'] = 'Vyberte filtre, ktoré chcete zobraziť na stránke "Hromadné akcie používateľa". Ak chcete vybrať viacero filtrov, podržte stlačené tlačidlo Ctrl. Filtre, ktoré nie sú vybrané, budú stále k dispozícii prostredníctvom odkazu "Zobraziť viac".';
$string['userimagesdisabled'] = 'Profilové obrázky používateľov sú zakázané';
$string['userlist'] = 'Prechádzať zoznam používateľov';
$string['usermanagement'] = 'Správa používateľov';
$string['userpolicies'] = 'Zásady správy používateľov';
$string['userpreference'] = 'Preferencie používateľa';
$string['userquota'] = 'Priestor pre súkromné súbory';
$string['userquota_desc'] = 'Maximálne množstvo údajov, ktoré môže každý používateľ uložiť v priestore svojich súkromných súborov.';
$string['users'] = 'Používatelia';
$string['usesitenameforsitepages'] = 'Použiť názov portálu pre stránky portálu';
$string['usetags'] = 'Zapnúť funkcionalitu tagov';
$string['validateemptylineerror'] = 'Prázdne riadky sú neplatné';
$string['validateerror'] = 'Táto hodnota nie je validná';
$string['validateerrorlist'] = 'Tieto položky sú neplatné: {$a}';
$string['validateiperror'] = 'Tieto IP adresy sú neplatné: {$a}';
$string['verifychangedemail'] = 'Obmedziť domény pri zmene mailu';
$string['warningcurrentsetting'] = 'Nesprávna súčasná hodnota: {$a}';
$string['warningiconvbuggy'] = 'Vaša verzia iconv knižnice nepodporuje //IGNORE modifier. Mali by ste nainštalovať  rozšírenie mbstring, ktoré je možné použiť namiesto toho na vyčistenie stringov, ktoré obsahujú neplatné UTF-8 znaky.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Vyplňte nasledujúce nastavenia, ak váš Moodle server nemôže priamo pristupovať na Internet. Internetový prístup je potrebný pre sťahovanie informácií o prostredí, jazykové balíčky, RSS údaje, časové pásma a podobne. <br /><em>Doporučuje sa PHP rozšírenie cURL.</em>';
$string['xmlrpcwebserviceenabled'] = 'Bolo zistené, že na vašom portáli je povolený protokol XML-RPC Web service. Táto funkcia závisí od rozšírenia PHP XML-RPC, ktoré už PHP nespravuje.';
$string['yuicomboloading'] = 'Nahráva sa Yui combo';
$string['ziprequired'] = 'Moodle v súčasnosti vyžaduje PHP zásuvný modul ZIP. Knižnice info-ZIP alebo PclZip už nie sú používané.';
