<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grades', language 'eu', version '4.4'.
 *
 * @package     grades
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activities'] = 'Jarduerak';
$string['addcategory'] = 'Gehitu kategoria';
$string['addcategoryerror'] = 'Ezin izan da kategoria gehitu.';
$string['addexceptionerror'] = 'Errore bat gertatu da userid:gradeitem-i salbuespena gehitzean';
$string['addfeedback'] = 'Gehitu feedbacka';
$string['addgradeletter'] = 'Gehitu kalifikazio-letra';
$string['addidnumbers'] = 'Gehitu ID zenbakiak';
$string['additem'] = 'Gehitu kalifikazio-elementua';
$string['additionalfeedback'] = 'Feedback gehigarria';
$string['addoutcome'] = 'Gehitu ikaste-emaitza';
$string['addoutcomeitem'] = 'Gehitu ikaste-emaitza elementua';
$string['addscale'] = 'Gehitu eskala';
$string['adjustedweight'] = 'Pisua doitu da';
$string['aggregateextracreditmean'] = 'Kalifikazioen batez bestekoa (aparteko kredituekin)';
$string['aggregatemax'] = 'Kalifikazio altuena';
$string['aggregatemean'] = 'Kalifikazioen batez bestekoa';
$string['aggregatemedian'] = 'Kalifikazioen mediana';
$string['aggregatemin'] = 'Kalifikazio baxuena';
$string['aggregatemode'] = 'Kalifikazioen moda';
$string['aggregatenotonlygraded'] = 'Sartu hutsik dauden kalifikazioak';
$string['aggregateonlygraded'] = 'Baztertu hutsik dauden kalifikazioak';
$string['aggregateonlygraded_help'] = 'Hutsik dagoen kalifikazioa kalifikazio-liburuan ez dagoen kalifikazioa da. Oraindik kalifikatu ez den zeregina izan daiteke edo saiakerarik izan ez duen galdetegia, adibidez.

Ezarpen honek adierazten du hutsik dauden kalifikazioak agregazioan sartzen ez diren ala gutxieneko kalifikaziotzat hartzen diren, adibidez 0 0tik 100era kalifikatzen den zeregin batean.';
$string['aggregateoutcomes'] = 'Sartu ikaste-emaitzak agregazioan';
$string['aggregateoutcomes_help'] = 'Gaituz gero, ikaste-emaitzak agregazioan sartzen dira. Honen ondorioz, kategoriako guztirakoa espero ez zena izan daiteke.';
$string['aggregatesonly'] = 'Erakutsi guztirakoak soilik';
$string['aggregatesubcatsupgradedgrades'] = 'Oharra: "Agregazioan azpikategoriak sartu" agregazio-metodoaren ezarpena ezabatu da eguneraketa egitearekin batera. Aurretik "Agregazioan azpikategoriak sartu" ikastaro honetan erabiltzen zenez, gomendagarria da aldaketa honek kalifikazio-liburuan izandako eragina aztertzea.';
$string['aggregatesum'] = 'Naturala';
$string['aggregateweightedmean'] = 'Kalifikazioen batez besteko ponderatua';
$string['aggregateweightedmean2'] = 'Kalifikazioen batez besteko ponderatu sinplea';
$string['aggregation'] = 'Agregazioa';
$string['aggregation_help'] = 'Agregazioak zehazten du kategoria bateko kalifikazioak nola lotzen diren, adibidez

* Kalifikazioen batez bestekoa - Kalifikazio guztien batuketa zati kalifikazio-kopurua.
* Kalifikazioen mediana - Tarteko kalifikazioa kalifikazioak tamainaren arabera sailkatzen direnean
* Kalifikazio baxuena
* Kalifikazio altuena
* Kalifikazioen moda - Sarrien agertzen den kalifikazioa
* Naturala - Kalifikazio balio guztien batuketa pisuaren arabera ponderatuta';
$string['aggregation_link'] = 'kalifikazioa/agregazioa';
$string['aggregationcoef'] = 'Agregazio-koefizientea';
$string['aggregationcoefextra'] = 'Aparteko kreditua';
$string['aggregationcoefextra_help'] = 'Agregazioa \'naturala\' edo \'batez besteko ponderatu sinplea\' bada eta aparteko kredituen laukitxoa markatuta badago, kalifikazio-elementuaren gehieneko kalifikazioa ez zaio batuko kategoriaren  gehieneko kalifikazioari. Ondorioz, posiblea izango da kategorian gehieneko kalifikazioa lortzea kalifikazio-elementu guztietan gehieneko kalifikazioa lortu gabe. Guneko kudeatzaileak gehieneko kalifikaziotik gorako kalifikazioak gaitu baditu gehieneko kalifikaziotik gorako kalifikazioak ere egon daitezke.

Agregazioa kalifikazioen \'batez bestekoa (aparteko kredituekin)\' bada eta aparteko kredituak zerotik gorako balioa ezarrita badu, aparteko kreditu horrekin biderkatuko da kalifikazioa, media kalkulatu ondorengo guztirakoari gehitu aurretik.';
$string['aggregationcoefextra_link'] = 'kalifikazioa/agregazioa';
$string['aggregationcoefextrasum'] = 'Aparteko kreditua';
$string['aggregationcoefextrasum_help'] = 'Aparteko kredituen laukitxoa markatuta badago, kalifikazio-elementuaren gehieneko kalifikazioa ez zaio batuko kategoriaren  gehieneko kalifikazioari, eta beraz ezin izango da lortu gehieneko kalifikazioa (edo gehieneko kalifikaziotik gora, guneko kudeatzaileak gaitu badu) kategorian ez badu gehieneko kalifikazioa elementu guztietan.';
$string['aggregationcoefextrasum_link'] = 'grade/aggregation';
$string['aggregationcoefextrasumabbr'] = '+';
$string['aggregationcoefextraweight'] = 'Aparteko kredituen pisua';
$string['aggregationcoefextraweight_help'] = 'Aparteko kredituen pisuan 0tik gorako balio bat zehaztuz gero, kalifikazioak aparteko kredituen moduan erabiltzen da agregazioa egitean. Zenbaki horrekin biderkatuko da kalifikazioaren balioa kalifikazio guztien batuketari gaineratu aurretik.';
$string['aggregationcoefextraweight_link'] = 'grade/aggregation';
$string['aggregationcoefweight'] = 'Elementuaren pisua';
$string['aggregationcoefweight_help'] = 'Elementuaren pisua kategoriaren agregazioan erabiltzen da kategoria bereko beste kalifikazio-elementuekin alderatuta elementu horrek duen garrantzia nabarmentzeko.';
$string['aggregationcoefweight_link'] = 'kalifikazioa/agregazioa';
$string['aggregationhintdropped'] = '(Kokatua)';
$string['aggregationhintexcluded'] = '(Baztertua)';
$string['aggregationhintextra'] = '(Aparteko kreditua)';
$string['aggregationhintnovalue'] = '(Hutsik)';
$string['aggregationofa'] = '{$a}(r)en agregazioa';
$string['aggregationposition'] = 'Agregazioaren kokalekua';
$string['aggregationposition_help'] = 'Ezarpen honek adierazten du kategoria eta ikastaroan guztirako zutabeak kalifikazio-liburuaren txostenaren hasieran edo amaieran agertuko diren.';
$string['aggregationsvisible'] = 'Eskura dauden agregazio motak';
$string['aggregationsvisiblehelp'] = 'Aukeratu erabilgarri egongo diren agregazio-motak. Mantendu Ctrl tekla sakatuta hainbat elementu aukeratzeko.';
$string['allgrades'] = 'Kalifikazio guztiak kategoriaka';
$string['allstudents'] = 'Ikasle guztiak';
$string['allusers'] = 'Erabiltzaile guztiak';
$string['aria-toggledropdown'] = 'Aldatu hurrengo aukera-menua';
$string['aria:dropdowngrades'] = 'Kalifikazio-elementuak aurkitu dira';
$string['autosort'] = 'Automatikoki ordenatu';
$string['availableidnumbers'] = 'Eskuragarri dauden ID zenbakiak';
$string['average'] = 'Batez bestekoa';
$string['averagesdecimalpoints'] = 'Hamartarrak batez bestekoetan';
$string['averagesdecimalpoints_help'] = 'Ezarpen honek bataz bestekoen zutabe bakoitzean erakutsiko diren hamartar-kopurua edo kategoria edo kalifikazio-elementu bakoitzean zehaztutakoa erabiliko den (zaharkituta).';
$string['averagesdisplaytype'] = 'Batez bestekoak erakusteko modua';
$string['averagesdisplaytype_help'] = 'Ezarpen honek zehazten du batez bestekoa (media) kalifikazio errealetan, ehunekotan edo letretan erakutsiko den ala kategoria edo kalifikazio-elementua erakusteko era erabiliko den (heredatua).';
$string['backupwithoutgradebook'] = 'Segurtasun-kopiak ez ditu kalifikazio-liburuaren ezarpenak';
$string['badgrade'] = 'Emandako kalifikazioak ez du balio';
$string['badlyformattedscale'] = 'Mesedez, idatzi komaz banatutako balio-zerrenda (gutxienez bi balio behar dira).';
$string['baduser'] = 'Emandako erabiltzaileak ez du balio';
$string['bonuspoints'] = 'Bonifikazio-puntuak';
$string['bulkcheckboxes'] = 'Egiaztapen masiboetarako laukitxoak';
$string['calculatedgrade'] = 'Kalkulatutako kalifikazioa';
$string['calculation'] = 'Kalkulua';
$string['calculation_help'] = 'Kalifikazioen kalkulua kalifikazioak ezartzeko erabiltzen den formula bat da. Formulak berdin (=) sinboloarekin hasi behar du eta ohiko eragiketa matematikoak erabiltzen ditu, besteak beste max, min and sum. Nahi izanez gero, beste kalifikazio-elementu batzuk sar daitezke kalkuluan horien ID zenbakiak bi kortxeteren artean idatzita.';
$string['calculation_link'] = 'kalifikazioa/kalkulua';
$string['calculationadd'] = 'Gehitu kalkulua';
$string['calculationedit'] = 'Editatu kalkulua';
$string['calculationsaved'] = 'Kalkulua gordeta';
$string['calculationview'] = 'Ikusi kalkulua';
$string['calculationwarning'] = 'Kategoria honek agregazioa ez den kalifikazio kalkulu bat erabiltzen du kategoriaren guztirakoan.';
$string['cannotaccessgroup'] = 'Ezin dira eskuratu aukeratutako taldearen kalifikazioa, sentitzen dugu.';
$string['categories'] = 'Kategoriak';
$string['category'] = 'Kategoria';
$string['categoryedit'] = 'Editatu kategoria';
$string['categoryname'] = 'Kategoriaren izena';
$string['categorytotal'] = 'Kategorian guztira';
$string['categorytotalfull'] = '{$a->category} guztira';
$string['categorytotalname'] = 'Kategorian guztira-rako izena';
$string['changedefaults'] = 'Aldatu balio lehenetsiak';
$string['changereportdefaults'] = 'Aldatu txostenaren balio lehenetsiak';
$string['chooseaction'] = 'Aukeratu ekintza bat...';
$string['choosecategory'] = 'Aukeratu kategoria';
$string['collapsecriterion'] = 'Tolestu irizpidea';
$string['compact'] = 'Konpaktatu';
$string['componentcontrolsvisibility'] = 'Kalifikazio-elementu hau ezkutuan dagoen jardueraren ezarpenetatik kontrolatzen da.';
$string['contract'] = 'Tolestu kategoria';
$string['contributiontocoursetotal'] = 'Ikastaroaren denerako ekarpena';
$string['controls'] = 'Kontrolak';
$string['courseavg'] = 'Ikastaroaren batez bestekoa';
$string['coursegradecategory'] = 'Ikastaroaren kalifikazio-kategoria';
$string['coursegradedisplaytype'] = 'Ikastaroaren kalifikazioak erakusteko modua';
$string['coursegradedisplayupdated'] = 'Ikastaroaren kalifikazioak erakusteko modua eguneratu da.';
$string['coursegradesettings'] = 'Ikastaroaren kalifikazioen ezarpenak';
$string['coursename'] = 'Ikastaroaren izena';
$string['coursescales'] = 'Ikastaroaren eskalak';
$string['coursesettings'] = 'Ikastaroaren ezarpenak';
$string['coursesettingsexplanation'] = 'Ikastaro-kalifikazioen ezarpenetan zehazten da kalifikazio-liburua nola agertuko zaien partaide guztiei ikastaroan.';
$string['coursesiamtaking'] = 'Ikasle naizen ikastaroak';
$string['coursesiamteaching'] = 'Irakasle naizen ikastaroak';
$string['coursetotal'] = 'Ikastaroan guztira';
$string['createcategory'] = 'Sortu kategoria';
$string['createcategoryerror'] = 'Ezin da kategoria berririk sortu';
$string['creatinggradebooksettings'] = 'Kalifikazio-liburuaren ezarpenak sortzen';
$string['csv'] = 'CSV';
$string['currentparentaggregation'] = 'Oraingo goragoko agregazioa';
$string['curveto'] = 'Hona borobildu';
$string['decimalpoints'] = 'Hamartar-kopuru orokorra';
$string['decimalpoints_help'] = 'Honek kalifikazio bakoitzean erakutsiko den hamartar-kopurua zehazten du. Ez du eraginik kalifikazioen kalkuluetan 5 hamartarreko zehaztasunez egina baitago.';
$string['default'] = 'Lehenetsitakoa';
$string['defaultprev'] = 'Balio lehenetsia ({$a})';
$string['deletecategory'] = 'Ezabatu kategoria';
$string['deletescale'] = 'Ezabatu eskala';
$string['disablegradehistory'] = 'Desgaitu kalifikazio-historia';
$string['disablegradehistory_help'] = 'Desgaitu kalifikazioekin lotutako tauletako aldaketen jarraipena. Honek zertxobait arindu dezake zerbitzariaren funtzionamendua eta datu-basearen lekua mantendu';
$string['displaylettergrade'] = 'Erakutsi notak letren bidez';
$string['displaypercent'] = 'Erakutsi portzentajeak';
$string['displaypoints'] = 'Erakutsi puntuak';
$string['displayweighted'] = 'Erakutsi kalifikazio ponderatuak';
$string['droplow'] = 'Baztertu baxuena';
$string['droplow_help'] = 'Ezarpen honek X kalifikaziotik beherakoak agregaziotik baztertzea ahalbidetzen du.';
$string['droplowestvalue'] = 'Ezarri kalifikazio-balio txikiena baztertzeko aukera';
$string['droplowestvalues'] = 'Baztertu balio txikienak {$a}';
$string['dropped'] = 'Baztertuta';
$string['dropxlowest'] = 'Baztertu X baino baxuagoak';
$string['dropxlowestwarning'] = 'Oharra: \'X baino baxuagorik kontuan ez hartu\' erabiltzen baduzu, kalifikazioak kategoriako item guztiak gehieneko zenbakizko kalifikazio bera dutela suposatzen du. Zenbakizko kalifikazio horiek ezberdinak badira, emaitzak edonolakoak izango dira.';
$string['duplicatedgradeitem'] = '{$a} (kopia)';
$string['duplicatescale'] = 'Bikoiztu eskala';
$string['edit'] = 'Editatu';
$string['editcalculation'] = 'Editatu kalkulua';
$string['editcalculationverbose'] = 'Editatu kalkulua honentzat: {$a->category} {$a->itemmodule} {$a->itemname}';
$string['editfeedback'] = 'Editatu feedbacka';
$string['editgrade'] = 'Editatu kalifikazioa';
$string['editgradeletters'] = 'Editatu kalifikazio-letrak';
$string['editoutcome'] = 'Editatu ikaste-emaitza';
$string['editoutcomes'] = 'Editatu ikaste-emaitzak';
$string['editscale'] = 'Editatu eskala';
$string['edittree'] = 'Ezarpenak';
$string['editverbose'] = 'Editatu: {$a->category} {$a->itemmodule} {$a->itemname}';
$string['enableajax'] = 'Gaitu AJAX';
$string['enableajax_help'] = 'Kalifikatzaile-txostenari AJAX funtzionalitate geruza bat gehitzen dio, ohiko eragiketak erraztu eta arinduz. Erabiltzailearen nabigatzaileak Javascript-a aktibatuta izan behar du.';
$string['enableoutcomes'] = 'Gaitu ikaste-emaitzak';
$string['enableoutcomes_help'] = 'Gaituz gero, kalifikazio-elementuak ikaste-emaitzei lotutako eskala bat edo gehiago erabilita kalifikatu ahal izango dira.';
$string['encoding'] = 'Kodifikazioa';
$string['encoding_help'] = 'Aukeratu datuetarako karaktere-kodifikazioa. (Kodifikazio estandarra UTF-8 da.) Nahastu eta kodifikazio okerra aukeratzen bada, datuen inportazioa aurreikustean ohartuko zara.';
$string['errorcalculationbroken'] = 'Errorea gertatu da {$a} kalifikazio-elementua kalkulatzerakoan.';
$string['errorcalculationnoequal'] = 'Formulak berdin sinboloarekin hasi behar du (=1+2)';
$string['errorcalculationunknown'] = 'Formula baliogabea';
$string['errorgradevaluenonnumeric'] = 'Kalifikazio altu edo baxurako balio ez zenbakiduna jaso da';
$string['errornocalculationallowed'] = 'Kalkuluak ez daude baimenduta elementu honetarako';
$string['errornocategorisedid'] = 'Ez da kategorizatu gabeko id-rik lortu.';
$string['errornocourse'] = 'Ez da ikastaroaren informaziorik lortu';
$string['erroroverweight'] = 'Pisuek guztira %100 gainditzen dute.';
$string['errorreprintheadersnonnumeric'] = 'Berrinprimaketa-goialdeetarako balioez zenbakiduna jaso da';
$string['errorsavegrade'] = 'Ezin da kalifikazioa gorde, sentitzen dugu.';
$string['errorsettinggrade'] = 'Errorea "{$a->itemname}"(r)en kalifikazioa gordetzean {$a->userid} erabiltzailearentzat';
$string['errorunderweight'] = 'Pisuak guztira ez dira %100era heltzen.';
$string['errorupdatinggradecategoryaggregateonlygraded'] = 'Errorea {$a->id} ID kategoria-kalifikazioaren "Hutsik dauden kalifikazioak baino ez agregatu" ezarpena eguneratzean.';
$string['errorupdatinggradecategoryaggregateoutcomes'] = 'Errorea {$a->id} ID kategoria-kalifikazioaren "Sartu ikaste-emaitzak agregazioan" ezarpena eguneratzean.';
$string['errorupdatinggradecategoryaggregation'] = 'Errorea {$a->id} IDdun kalifikazio-kategoriaren agregazio mota eguneratzean';
$string['errorupdatinggradeitemaggregationcoef'] = 'Errorea {$a->id} IDdun kalifikazio-elementuaren agregazio-koefizientea eguneratzean (pisua edo aparteko kreditua)';
$string['eventgradedeleted'] = 'Kalifikazioa ezabatu da';
$string['eventgradeexported'] = 'Kalifikazioa esportatuta';
$string['eventgradeitemcreated'] = 'Kalifikazio-elementua sortu da';
$string['eventgradeitemdeleted'] = 'Kalifikazio-elementua ezabatu da';
$string['eventgradeitemupdated'] = 'Kalifikazio-elementua eguneratu da';
$string['eventgradelettercreated'] = 'Kalifikazio-letra sortu da';
$string['eventgradeletterdeleted'] = 'Kalifikazio-letra ezabatu da';
$string['eventgradeletterupdated'] = 'Kalifikazio-letra eguneratu da';
$string['eventgradeviewed'] = 'Kalifikazioak kalifikazio-liburuan ikusi dira';
$string['eventscalecreated'] = 'Eskala sortu da';
$string['eventscaledeleted'] = 'Eskala ezabatu da';
$string['eventscaleupdated'] = 'Eskala eguneratu da';
$string['eventusergraded'] = 'Erabiltzailea kalifikatu da';
$string['excluded'] = 'Baztertutakoak';
$string['excluded_help'] = 'Markatuta, kalifikazioa ez da inongo agregaziotan sartuko.';
$string['expand'] = 'Zabaldu kategoria';
$string['expandcriterion'] = 'Zabaldu irizpidea';
$string['export'] = 'Esportatu';
$string['exportalloutcomes'] = 'Esportatu ikaste-emaitza guztiak';
$string['exportas'] = 'Esportatu honela:';
$string['exportfeedback'] = 'Sartu feedbacka esportatzean';
$string['exportfeedback_desc'] = 'Esportatzerakoan hau baliogabetu daiteke.';
$string['exportformatoptions'] = 'Esportatzeko formatuaren aukerak';
$string['exportonlyactive'] = 'Utzi kanpoan kontua etenda duten erabiltzaileak';
$string['exportonlyactive_help'] = 'Soilik sartu inportazioan matrikula aktiboa eta etenda ez duten ikasleak';
$string['exportplugins'] = 'Esportatu pluginak';
$string['exportsettings'] = 'Esportatu ezarpenak';
$string['exportto'] = 'Esportatu hona:';
$string['externalurl'] = 'Kanpoko URLa';
$string['externalurl_desc'] = 'Kanpoko kalifikazio-liburua erabiliz gero, hemen zehaztu behar da URLa.';
$string['extracreditvalue'] = 'Aparteko kreditu-balioa {$a}rako';
$string['extracreditwarning'] = 'Oharra: Kategoriko elementu guztiak krediturik gabe uzten badira, notaren kalkuluan ez dira kontuan hartuko eta, ondorioz, puntuazio orokorrik ez da izango';
$string['fail'] = 'Gainditu gabe';
$string['feedback'] = 'Feedbacka';
$string['feedback_help'] = 'Laukitxo honek aukera ematen du gahitutako kalifikazioari buruzko oharrak idazteko.';
$string['feedbackadd'] = 'Gehitu feedbacka';
$string['feedbackedit'] = 'Editatu feedbacka';
$string['feedbackfiles'] = 'Feedback fitxategiak';
$string['feedbackforgradeitems'] = '{$a}(r)entzako feedbacka';
$string['feedbackhistoryfiles'] = 'Feedbackaren historia-fitxategiak';
$string['feedbackprovided'] = 'Feedbacka emanda';
$string['feedbacks'] = 'Feedbackak';
$string['feedbacksaved'] = 'Feedbacka gordeta';
$string['feedbackview'] = 'Ikusi feedbacka';
$string['filterbothactive'] = 'Izena ({$a->first}) Abizena ({$a->last})';
$string['filterbyname'] = 'Iragazi izenaren arabera';
$string['filterfirstactive'] = 'Izena ({$a->first})';
$string['filterlastactive'] = 'Abizena ({$a->last})';
$string['finalgrade'] = 'Amaierako kalifikazioa';
$string['finalgrade_help'] = '<p>Kalkulu guztiak egin ondoren lortutako amaierako kalifikazioa (cache-an).</p>';
$string['fixedstudents'] = 'Ikasleen zutabe finkoa';
$string['fixedstudents_help'] = 'Ikasleen zutabea kalifikatzailearen txostenean finkatzen du, kalifikazioak horizontalean lerratuz.';
$string['forceimport'] = 'Behartu inportatzea';
$string['forceimport_help'] = 'Behartu kalifikazioak inportatzea, fitxategia esportatu ondoren kalifikazioak eguneratuak izan badira ere.';
$string['forceoff'] = 'Behartu: Off';
$string['forceon'] = 'Behartu: On';
$string['forelementtypes'] = 'aukeratutako {$a}(r)entzat';
$string['forstudents'] = 'Ikasleentzat';
$string['full'] = 'Osoa';
$string['fullmode'] = 'Erakutsi kalifikazioak eta guztirakoak';
$string['generalsettings'] = 'Ezarpen orokorrak';
$string['grade'] = 'Kalifikazioa';
$string['grade_help'] = 'Ikasle honek bere lanagatik jaso behar duen kalifikazioa.';
$string['gradeadministration'] = 'Kalifikazioen kudeaketa';
$string['gradealreadyupdated'] = '{$a} kalifikazio ez dira inportatu fitxategiko kalifikazioak kalifikatzaile-txostenean daudenak baino zaharragoak direlako. Hala ere inportazioarekin aurrera egiteko, erabili behartu kalifikazioak inportatzea aukera.';
$string['gradeanalysis'] = 'Kalifikazio-analisia';
$string['gradebook'] = 'Kalifikazio-liburua';
$string['gradebookcalculationsfixbutton'] = 'Onartu kalifikazioen aldaketak eta konpondu kalkulu-erroreak';
$string['gradebookcalculationsuptodate'] = 'Kalifikazio-liburuko kalkuluak eguneratuta daude. Agian orria eguneratu beharko duzu aldaketak ikusi ahal izateko.';
$string['gradebookcalculationswarning'] = 'Oharra: Errore batzuk atzeman dira kalifikazio-liburuko kalifikazioak kalkulatzean. Zure ikastaroa oraindik ez bada hasi edo abian badago, gomendagarria da erroreak beheko botoian klik eginda konpontzea, nahiz eta horrek kalifikazio batzuk aldatzea suposa dezakeen. Zure ikastaroa dagoeneko amaitu bada eta kalifikazioak bidali badira, ziur aski ez duzu arazo hau konpondu nahiko.

Bertsio berria {$a->currentversion} da; zuk kalifikazio-liburuaren {$a->gradebookversion} bertsioa erabiltzen ari zara. Aldaketen zerrenda bat ikusi dezakezu <a href="{$a->url}">Kalifikazio-liburuaren kalkuluen aldaketetan</a>.';
$string['gradebookhiddenerror'] = 'Kalifikazio-liburua konfiguratuta dago ikasleei ezer ez erakusteko.';
$string['gradebookhistories'] = 'Kalifikazio-historiak';
$string['gradebooknavigationmenu'] = 'Kalifikazio-liburuaren nabigazio-menua';
$string['gradebooksetup'] = 'Kalifikazio-liburuaren ezarpenak';
$string['gradeboundary'] = 'Kalifikazio-letren muga';
$string['gradeboundary_help'] = 'Ezarpen honek adierazten du zein ehunekotik aurrera emango den kalifikazioa letra bidez.';
$string['gradecategories'] = 'Kalifikazio-kategoriak';
$string['gradecategory'] = 'Kalifikazio-kategoria';
$string['gradecategoryonmodform'] = 'Kalifikazio-kategoria';
$string['gradecategoryonmodform_help'] = 'Ezarpen honek zehazten du jarduera honen kalifikazioa zein kategoriatan ezarriko den kalifikazio-liburuan.';
$string['gradecategorysettings'] = 'Kalifikazio-kategorien ezarpenak';
$string['gradedisplay'] = 'Kalifikazioa erakutsi';
$string['gradedisplaytype'] = 'Kalifikazioa erakusteko modua';
$string['gradedisplaytype_help'] = 'Ezarpen honek adierazten du nola erakusten diren kalifikazioak kalifikazio-liburuan eta erabiltzaile-txostenetan.

* Benetakoa - Oraingo kalifikazio balore-eskalak
* Ehunekoa - Gehieneko eta gutxieneko kalifikazioekiko
* Letrak - Letrak edo hitzak erabiltzen dira kalifikazio-tarteak adierazteko, kalifikazio-liburuko \'Letrak\' atalean azaldutakoaren arabera';
$string['gradedon'] = 'Kalifikatuta: {$a}';
$string['gradeexport'] = 'Kalifikazioak esportatu';
$string['gradeexportcolumntype'] = '{$a->name} ({$a->extra})';
$string['gradeexportcustomprofilefields'] = 'Profilaren eremu pertsonalizatuak kalifikazioen esportazioan';
$string['gradeexportcustomprofilefields_desc'] = 'Sartu profilaren eremu pertsonalizatu hauek kalifikazioen esportazioan, komaz banatuta.';
$string['gradeexportdecimalpoints'] = 'Kalifikazio-esportazioan erabili beharreko hamartar-kopurua';
$string['gradeexportdecimalpoints_desc'] = 'Esportaziorako erakutsi beharreko hamartar-kopurua. Balio hau esportazioa egitean baliogabetu daiteke.';
$string['gradeexportdisplaytype'] = 'Kalifikazio-esportazioa erakusteko modua';
$string['gradeexportdisplaytype_desc'] = 'Kalifikazioak kalifikazio erreal gisa, ehunekotan (gehieneko eta gutxienekoen arabera) edo letratan (A,B,C...) eman daitezke esportaziorako. Esportazioan zehar alde batera utzi daiteke hau.';
$string['gradeexportdisplaytypes'] = 'Kalifikazioen esportazioa erakusteko motak';
$string['gradeexportuserprofilefields'] = 'Erabiltzailearen profilaren eremuak kalifikazioen esportazioan';
$string['gradeexportuserprofilefields_desc'] = 'Sartu erabiltzailearen profilaren eremuak kalifikazioen esportazioan, komaz banatuta.';
$string['gradeforstudent'] = '{$a->student}<br />{$a->item}{$a->feedback}';
$string['gradegrademinmax'] = 'Hasierako gutxieneko eta gehieneko kalifikazioak';
$string['gradehelp'] = 'Kalifikazioei buruzko laguntza';
$string['gradehistorylifetime'] = 'Kalifikazio-historiaren iraupena';
$string['gradehistorylifetime_help'] = 'Lotutako kalifikazio-tauletan izandako aldaketen historiala zenbat denboraz mantendu nahi duzun zehazten du. Ahal beste mantentzea gomendatzen da. Funtzionamendu-arazoak edo datu-basean espazio txikia baduzu, saiatu balio txikiagoa ipintzen.';
$string['gradeimport'] = 'Kalifikazioa inportatu';
$string['gradeimportfailed'] = 'Errorea gertatu da kalifikazioen inportazioan. Xehetasun gehiago:';
$string['gradeitem'] = 'Kalifikazio-elementua';
$string['gradeitemaddusers'] = 'Kalifikaziotik kanpo utzi';
$string['gradeitemadvanced'] = 'Kalifikazio-elementuen aukera aurreratuak';
$string['gradeitemadvanced_help'] = 'Aukera itzazu kalifikazio-elementuak editatzean aurreratu gisa erakutsi behar diren elementuak.';
$string['gradeitemislocked'] = 'Kalifikazio hau blokeatuta dago kalifikazio-liburuan. Jarduera honen kalifikazioetan egindako aldaketak ez dira kopiatuko kalifikazio-liburuan desblokeatu arte.';
$string['gradeitemlocked'] = 'Kalifikazioa blokeatu da';
$string['gradeitemmembersselected'] = 'Kalifikaziotik kanpo daudenak';
$string['gradeitemminmax'] = 'Gutxieneko eta gehieneko kalifikazioak kalifikazio-elementuaren ezarpenetan zehaztuta dagoen eran.';
$string['gradeitemnonmembers'] = 'Kalifikazio-prozesuan daudenak';
$string['gradeitemremovemembers'] = 'Sartu kalifikazio-prozesuan';
$string['gradeitems'] = 'Kalifikazio-elementuak';
$string['gradeitemsettings'] = 'Kalifikazio-elementuen ezarpenak';
$string['gradeitemsinc'] = 'Sartu beharreko kalifikazio-elementuak';
$string['gradeletter'] = 'Kalifikazio-letra';
$string['gradeletter_help'] = 'Kalifikazio-letrak kalifikazio-tarteak adierazteko erabiltzen diren letrak, A, B, C,... edo hitzak dira, adibidez, Ezin hobea, Ikaragarria, Nahikoa,...';
$string['gradeletternote'] = 'Kalifikazio-letra bat ezabatzeko, letra horren<br /> hiru testu-eremuetako bat hustu eta aldaketa gorde ezazu.';
$string['gradeletteroverridden'] = 'Lehenetsitako kalifikazio-letrak salbuespena dago une honetan.';
$string['gradeletters'] = 'Kalifikazio-letrak';
$string['gradelocked'] = 'Kalifikazioa blokeatuta dago';
$string['gradelong'] = '{$a->grade} / {$a->max}';
$string['grademax'] = 'Gehieneko kalifikazioa';
$string['grademax_help'] = 'Ezarpen honek zehazten du gehieneko kalifikazioa balioa denean kalifikazio-mota. Jarduera batean oinarritutako kalifikazio-elementu baterako gehieneko kalifikazioa jardueraren orriaren ezarpenetan adierazten da.';
$string['grademin'] = 'Gutxieneko kalifikazioa';
$string['grademin_help'] = 'Ezarpen honek zehazten du gutxieneko kalifikazioa balioa denean kalifikazio-mota.';
$string['gradenotificationmessage'] = '"{$a}" zereginean egindako lanaren feedback berria jaso duzu';
$string['gradenotificationsubject'] = 'Kalifikazioa jaso duzu';
$string['gradeoutcomeitem'] = 'Kalifikaziorako ikaste-emaitza elementuak';
$string['gradeoutcomes'] = 'Ikaste-emaitzak';
$string['gradeoutcomescourses'] = 'Ikastaroaren ikaste-emaitzak';
$string['gradepass'] = 'Gainditzeko kalifikazioa';
$string['gradepass_help'] = 'Ezarpen honek gainditzeko lortu beharreko gutxieneko kalifikazioa zehazten du. Balioa jarduera eta ikastaro-osaketan erabiltzen da, baita kalifikazio-liburuan ere, zeinetan gainditutako kalifikazioak berdez markatzen diren eta gainditu gabekoak gorriz.';
$string['gradepassgreaterthangrade'] = 'Gainditzeko kalifikazioa ezin da izan gehieneko kalifikazio posiblea baino handiagoa {$a}';
$string['gradepointdefault'] = 'Lehenetsitako kalifikazioa';
$string['gradepointdefault_help'] = 'Ezarpen honek jarduera baterako gehieneko zenbakizko kalifikazio eskuragarrirako lehenetsitako balioa zehazten du.';
$string['gradepointdefault_validateerror'] = 'Balio honek 1 eta gehieneko puntuazioaren arteko zenbaki osoa izan behar du.';
$string['gradepointmax'] = 'Kalifikazioaren gehieneko puntuazioa';
$string['gradepointmax_help'] = 'Ezarpen honek jarduera baterako gehieneko zenbakizko kalifikazio eskuragarria zehazten du.';
$string['gradepointmax_validateerror'] = 'Balio honek 1 eta 10000 zenbakien artekoa izan behar du.';
$string['gradepreferences'] = 'Kalifikazioen hobespenak';
$string['gradepreferenceshelp'] = 'Kalifikazio-hobespenei buruzko laguntza';
$string['gradepublishing'] = 'Gaitu argitaratzea';
$string['gradepublishing_help'] = 'Kalifikazioak argitaratzea Moodlen sartu gabe kalifikazioak URL bitartez inportatu eta esportatzeko modu bat da. Gaituz gero, kudeatzaileek eta kalifikazioak argitaratzeko baimenak dituzten erabiltzaileek (modu lehenetsian soilik kudeatzaile rola duten erabiltzaileek) kalifikazio-liburuan kalifikazioen esportazioaren ezarpenetan argitaratzeko aukera izango dute.';
$string['gradepublishinglink'] = 'Jaitsi: {$a}';
$string['gradereport'] = 'Kalifikazio-txostena';
$string['graderreport'] = 'Kalifikatzaile-txostena';
$string['grades'] = 'Kalifikazioak';
$string['gradesforuser'] = '{$a->user} erabiltzailearen kalifikazioak';
$string['gradesmoduledeletionpendingwarning'] = 'Oharra: Jarduerak ezabatzen ari dira! Kalifikazio batzuk ezabatuak izango dira.';
$string['gradesmoduledeletionprefix'] = '[Ezabaketa martxan da]';
$string['gradesonly'] = 'Erakutsi kalifikazioak soilik';
$string['gradessettings'] = 'kalifikazioen ezarpenak';
$string['gradetype'] = 'Kalifikazio mota';
$string['gradetype_help'] = '4 kalifikazio mota daude:

* Bat ere ez - Ezin da kalifikatu
* Balioa - Zenbakizko balio bat, gehieneko eta gutxienekoarekin
* Eskala - Zerrenda bateko elementu bat
* Testua - Feedback-a soilik

Soilik balioa eta eskala motako kalifikazioak batu daitezke. Jarduera baten kalifikaziorako kalifikazio-mota jardueraren ezarpenek orrian aukeratzen da.';
$string['gradevaluetoobig'] = 'Kalifikazioren batek gehienez baimendutako {$a} balioa baino balio handiagoa du.';
$string['gradevaluetoosmall'] = 'Balioetako bat baimendutako gutxienezko kalifikazioa ({$a}) baino txikiagoa da';
$string['gradeview'] = 'Ikusi kalifikazioa';
$string['gradewasmodifiedduringediting'] = '{$a->username}(r)en {$a->itemname}(r)entzat sartutako kalifikazioa alde batera utzi da beste norbaitek orain dela gutxiago eguneratu duelako.';
$string['gradeweighthelp'] = 'Kalifikazioen pisuari buruzko laguntza';
$string['gradingmodulename'] = 'Kalifikatzen ({$a})';
$string['groupavg'] = 'Taldearen batez bestekoa';
$string['hidden'] = 'Ezkutuan';
$string['hidden_help'] = 'Markatuta, ezkutatu egingo zaizkie kalifikazioak ikasleei. Nahi izanez gero noiz arte ezkutatu ezar daiteke, kalifikazioa osatuta dagoenean kalifikazioak erakusteko.';
$string['hiddenasdate'] = 'Erakutsi ezkutuko kalifikazioetan bidalketa-data';
$string['hiddenasdate_help'] = 'Erabiltzaileak ezin baditu ezkutuko kalifikazioak erakutsi bidalketa data \'-\'-en ordez.';
$string['hiddenuntil'] = 'Noiz arte ezkutuan';
$string['hiddenuntildate'] = 'Noiz arte ezkutuan: {$a}';
$string['hideadvanced'] = 'Ezkutatu ezaugarri aurreratuak';
$string['hideaverages'] = 'Ezkutatu batez bestekoak';
$string['hidecalculations'] = 'Ezkutatu kalkuluak';
$string['hidecategory'] = 'Ezkutuan';
$string['hideeyecons'] = 'Ezkutatu erakutsi/ezkutatu ikonoak';
$string['hidefeedback'] = 'Ezkutatu feedbacka';
$string['hideforcedsettings'] = 'Ezkutatu behartutako ezarpenak';
$string['hideforcedsettings_help'] = 'Ez erakutsi behartutako ezarpenak kalifikatze-interfazean.';
$string['hidegroups'] = 'Ezkutatu taldeak';
$string['hidelocks'] = 'Ezkutatu blokeoak';
$string['hidenooutcomes'] = 'Erakutsi ikaste-emaitzak';
$string['hidequickfeedback'] = 'Ezkutatu feedback azkarra';
$string['hideranges'] = 'Ezkutatu ibiltartea';
$string['hidetotalifhiddenitems'] = 'Ezkutatu guztirakoak ezkutuko elementuak baldin badituzte.';
$string['hidetotalifhiddenitems_help'] = 'Ezarpen honek zehazten du ezkutuan dauden kalifikazio-elementuen denerakoak ikasleei erakutsiko zaizkien edo gidoiarekin (-) ordezkatuko diren. Erakutsiz gero, denerakoa ezkutuan dauden elementuak kontuan izanda edo kontuan hartu gabe kalkulatuko den zehaztu daiteke.

Ezkutuko elementuak baztertzen badira, ikasleak ikusten duen guztirako kalifikazioa eta kalifikatzaile-txostenean erakutsiko dena ezberdinak izango dira, irakasleak elementu guztiak kontuan hartutakoa ikusten duelako. Ezkutuko elementuan kontuan hartuz gero, ikasleek ezkutuko elementuen kalifikazioak iragarri ahalko dituzte.';
$string['hidetotalshowexhiddenitems'] = 'Erakutsi guztirakoak ezkutuko elementuak baztertuta';
$string['hidetotalshowinchiddenitems'] = 'Erakutsi guztirakoak ezkutuko elementuak barne';
$string['hideverbose'] = 'Ezkutatu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['highgradeascending'] = 'Ordenatu kalifikazioak gorantz';
$string['highgradedescending'] = 'Ordenatu kalifikazioak beherantz';
$string['highgradeletter'] = 'Altuak';
$string['identifier'] = 'Identifikatu erabiltzaileak';
$string['idnumbers'] = 'ID zenbakiak';
$string['ignore'] = 'Baztertu';
$string['import'] = 'Inportatu';
$string['importas'] = 'Inportatu honela:';
$string['importcsv'] = 'Inportatu CSV';
$string['importcsv_help'] = 'Kalifikazioak CSV fitxategiak erabiliz inporta daitezke hurrengo formatua erabilita:

* Fitxategiko errenkada bakoitzak erregistro bana du
* Erregistro bakoitza aukeratutako banatzaileaz banatutako datu-multzo bat da
* Lehen erregistroak eremuen izenen zerrenda izango du, fitxategiko beste erregistroen formatua zehaztuko duena
* Erabiltzailea identifikatuko duen eremu bat beharrezkoa da - erabiltzaile-izena, ID zenbakia edo helbide elektronikoa

Formatu egokia duen fitxategi bat lortu daiteke aurretik kalifikazio batzuk esportatuta. Fitxategi hori gero editatu eta CSV formatuarekin gorde daiteke.';
$string['importcsv_link'] = 'grade/import/csv/index';
$string['importcustom'] = 'Inportatu pertsonalizatutako ikaste-emaitza bezala (ikastaro honetan baino ez)';
$string['importdata'] = 'Datuak';
$string['importdata_help'] = 'Kalifikazioak OpenDocument edo Excel kalkulu-orrietatik zuzenean itsatsi daitezke hurrengo formatua jarraituta:

* Gutxienez erabiltzailearen identitate-datuak dituen zutabe bat egon behar da - erabiltzaile-izena, helbide elektronikoa edo ID zenbakia.
* Beste zutabeek goiburuak izan behar dituzte, bai existitzen diren jarduerenak baita kalifikazio-elementuenak ere.

Formatu egokia duen kalkulu-orri bat lortu daiteke kalifikazio batzuk esportatuta. Ondoren kalkulu-orria editatu dezakezu kalifikazio gehiago gehitu eta gordeta.

Aukeratu eta kopiatu itzazu kalkulu-orritik inportatu nahi dituzun zutabeak eta ondoren itsatsi itzazu eremu honetan.';
$string['importerror'] = 'Errorea gertatu da, script honi ez zaio deitu parametro egokiekin.';
$string['importfailed'] = 'Inportatzeak huts egin du. Ez da daturik inportatu.';
$string['importfeedback'] = 'Inportatu feedbacka';
$string['importfile'] = 'Inportatu fitxategia';
$string['importfilemissing'] = 'Ez da fitxategirik jaso; jo atzera formulariora eta ziurtatu balio duen fitxategia igo duzula.';
$string['importfrom'] = 'Inportatu hemendik:';
$string['importoutcomenofile'] = 'Igotako fitxategia hutsik dago edo kaltetuta dago. Mesedez egiaztatu fitxategi onargarria dela. Errorea {$a} lerroan aurkitu da; hau gerta daiteke datuen errenkadak lehen errenkadaren (goiburua) zutabe-kopuruarekin bat ez etortzeagatik edo inportatutako fitxategiak espero ziren goiburuak faltan dituelako. Begiratu esportatutako fitxategi bat goiburu egoki baten adibidea ikusteko.';
$string['importoutcomes'] = 'Inportatu ikaste-emaitzak';
$string['importoutcomes_help'] = 'Ikaste-emaitzak CSV fitxategi bat erabiliz inporta daitezke, esportatutako ikaste-emaitzen CSV fitxategi baten formatua erabilita.';
$string['importoutcomes_link'] = 'grade/outcome';
$string['importoutcomesuccess'] = 'Inportatutako ikaste-emaitza ({$a->name}) #{$a->id} ID-arekin';
$string['importplugins'] = 'Inportatu pluginak';
$string['importpreview'] = 'Inportazioaren aurrebista';
$string['importsettings'] = 'Inportazioaren ezarpenak';
$string['importskippednomanagescale'] = 'Ez duzu eskala berria gehitzeko baimenik, beraz {$a} ikaste-emaitza alde batera utziko da eskala berria sortzea eskatzen baitu.';
$string['importskippedoutcome'] = '{$a} izen laburreko ikaste-emaitza badago dagoeneko testuinguru honetan, inportatutako fitxategiko bat alde batera utziko da, beraz.';
$string['importstandard'] = 'Inportatu ikaste-emaitza estandar bezala';
$string['importsuccess'] = 'Kalifikazioak ondo inportatu dira';
$string['importxml'] = 'Inportatu XML';
$string['includescalesinaggregation'] = 'Sartu eskalak agregazioan';
$string['includescalesinaggregation_help'] = 'Ikastaro guztietan kalifikazio-liburu guztietan batutako kalifikazio guztietan eskalak zenbaki gisa sartuko diren erabaki ahal duzu. KONTUZ: ezarpen hau aldatzen baduzu kalifikazio guztiak berriz kalkulatuko dira.';
$string['incorrectcourseid'] = 'Ikastaroaren IDa ez da egokia';
$string['incorrectcustomscale'] = '(Eskala pertsonalizatu ezegokia, mesedez aldatu.)';
$string['incorrectminmax'] = 'Gutxienenekoak gehienekoak baino txikiagoa izan behar du.';
$string['inherit'] = 'Heredatu';
$string['intersectioninfo'] = 'Ikaslea/Kalifikazioaren informazioa';
$string['invalidgradeexporteddate'] = 'Esportazio-datak ez du balio duela urtebete baino gehiagokoa delako, etorkizunekoa delako, edo formatu baliogabea duelako.';
$string['item'] = 'Elementua';
$string['iteminfo'] = 'Elementuaren informazioa';
$string['iteminfo_help'] = 'Elementuari buruzko informazioa sartzeko eremua. Bertan sartutako testua ez da beste inon agertuko.';
$string['itemname'] = 'Elementuaren izena';
$string['itemnamehelp'] = 'Elementu honen izena, moduluak emandakoa';
$string['items'] = 'Elementuak';
$string['itemsedit'] = 'Editatu kalifikazio-elementua';
$string['keephigh'] = 'Mantendu altuena';
$string['keephigh_help'] = '<p>Ezarriz gero, soilik X kalifikazio altuenak gordeko dira, eta X izango da aukera honetarako ezarritako balioa.</p>';
$string['keephighestvalues'] = 'Mantendu baliorik altuenak: {$a}';
$string['keymanager'] = 'Giltzen kudeatzailea';
$string['lessthanmin'] = '{$a->itemname}-n {$a->username}-ri emandako kalifikazioa baimendutako txikiena baino baxuagoa da';
$string['letter'] = 'Letra';
$string['lettergrade'] = 'Letren bidezko kalifikazioa';
$string['lettergradenonnumber'] = 'Kalifikazio baxu edo/eta altu ez zenbakidunak';
$string['letterpercentage'] = 'Letra (ehunekoa)';
$string['letterreal'] = 'Letra (erreala)';
$string['letters'] = 'Letrak';
$string['linkedactivity'] = 'Estekatutako jarduera';
$string['linkedactivity_help'] = 'Ezarpen honek ikaste-emaitzari estekatutako jarduera bat zehazten du. Ikasleen errendimendua neurtzeko erabil daiteke, jardueraren ebaluazioa kontuan hartu gabeko irizpideak erabilita.';
$string['linktoactivity'] = '{$a->name} jarduera {$a->title}';
$string['lock'] = 'Blokeatu';
$string['locked'] = 'Blokeatuta';
$string['locked_help'] = 'Markatuz gero, kalifikazioak ezingo dira automatikoki eguneratu lotutako jardueratik.';
$string['locktime'] = 'Blokeatu honen ondoren';
$string['locktimedate'] = 'Blokeatu honen ondoren: {$a}';
$string['lockverbose'] = 'Blokeatu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['lowest'] = 'Baxuena';
$string['lowgradeletter'] = 'Baxua';
$string['manageoutcomes'] = 'Kudeatu ikaste-emaitzak';
$string['manualitem'] = 'Eskuzko elementua';
$string['mapfrom'] = 'Lotu fitxategiko eremu hau';
$string['mapfrom_help'] = 'Aukeratu erabiltzailea identifikatzen duen datua duen kalkulu-orriko zutabea, hala nola erabiltzaile-izena, erabiltzailearen IDa edo helbide elektronikoa.';
$string['mappings'] = 'Kalifikazio-elementuen lotura';
$string['mappings_help'] = 'Kalkulu-orriko kalifikazio-zutabe bakoitzeko, aukeratu dagokion kalifikazio-elementua kalifikazioak bertara inportatzeko.';
$string['mapto'] = 'Lotu Moodleko eremu honekin';
$string['mapto_help'] = 'Aukeratu \'Lotu hemendik\' aukeran hautatutako datu identifikatzaile berdina.';
$string['max'] = 'Altuena';
$string['maxgrade'] = 'Gehieneko kalifikazioa';
$string['meanall'] = 'Kalifikazio guztiak';
$string['meangraded'] = 'Hutsik ez dauden kalifikazioak';
$string['meanselection'] = 'Batez bestekoen zutaberako aukeratutako kalifikazioak';
$string['meanselection_help'] = 'Aukeratu kalifikaziorik gabeko gelaxkak zutabe bakoitzaren batez bestekoa kalkulatzeko erabiliko diren ala ez.';
$string['median'] = 'Ertaina';
$string['min'] = 'Baxuena';
$string['minimum_show'] = 'Erakutsi gutxieneko kalifikazioa';
$string['minimum_show_help'] = 'Gutxieneko kalifikazioa kalifikazioak eta pisuak kalkulatzeko erabiltzen da. Ez bada erakusten, gutxieneko kalifikazioa zero izango da modu lehenetsian eta ezingo da editatu.';
$string['minmaxtouse'] = 'Kalkuluetan erabilitako gutxieneko eta gehieneko kalifikazioak';
$string['minmaxtouse_desc'] = 'Ezarpen honek zehazten du hasierako gutxieneko eta gehieneko kalifikazioak erabiliko diren edo kalifikazio-elementu bakoitzean zehaztuko diren kalifikazio-liburuan erakutsiko diren kalifikazioak kalkulatzean. Aukera hau erabilera gutxiko uneetan aldatzea gomendatzen da, hori egitean kalifikazio guztiak berriz kalkulatuko direlako eta horrek zerbitzariaren karga igo dezakeelako.';
$string['minmaxtouse_help'] = 'Ezarpen honek zehazten du hasierako gutxieneko eta gehieneko kalifikazioak erabiliko diren edo kalifikazio-elementu bakoitzean zehaztuko diren kalifikazio-liburuan erakutsiko diren kalifikazioak kalkulatzean.';
$string['minmaxtouse_link'] = 'Grades_min_max';
$string['minmaxupgradedgrades'] = 'Oharra: Kalifikazio batzuk aldatu dira erakutsitako kalifikazioak kalkulatzean erabiltzen diren gutxieneko eta gehieneko kalifikazioak aldatzean sortutako kalifikazio-liburuaren ahultasun bat konpontzeko.';
$string['minmaxupgradefixbutton'] = 'Konpondu ahultasunak';
$string['minmaxupgradewarning'] = 'Oharra: Ahultasun bat aurkitu da kalifikazio batzuetan kalifikazioak kalkulatzean erabiltzen diren gutxieneko eta gehieneko kalifikazioak aldatzearen ondorioz. Ahultasun hori konpontzeko beheko botoian klik egitea gomendatzen da, nahiz eta honek kalifikazio batzuk aldatuko dituen arren.';
$string['missingitemtypeoreid'] = 'Array gakoa (itemtype edo eid) falta da';
$string['missingscale'] = 'Eskala aukeratu beha da';
$string['mode'] = 'Modua';
$string['modgrade'] = 'Kalifikazioa';
$string['modgrade_help'] = 'Aukeratu jarduera honetan erabiliko den kalifikazio-mota. "Eskala" aukeratuz gero, ondoren zabaltzen den "eskala" menuan bat aukeratu beharko duzu. Zenbakizko kalifikazioa erabiliz gero, jarduera honetarako gehieneko kalifikazioa sar dezakezu.';
$string['modgradecantchangegradetype'] = 'Ezin duzu mota aldatu, dagoeneko elementu honentzako kalifikazioak daudelako.';
$string['modgradecantchangegradetypemsg'] = 'Kalifikazio batzuk dagoeneko esleitu dira, eta ondorioz ezin da kalifikazio mota aldatu. Gehieneko kalifikazioa aldatu nahi baduzu, aurretik existitzen diren kalifikazioak berriz eskalatu nahi dituzun aukeratu behar duzu.';
$string['modgradecantchangegradetyporscalemsg'] = 'Kalifikazio batzuk dagoeneko esleitu dira, eta ondorioz ezin dira mota eta eskala aldatu.';
$string['modgradecantchangeratingmaxgrade'] = 'Ezin duzu gehieneko kalifikazioa aldatu puntuazioak dituen jarduerarentzat dagoeneko kalifikazioak daudenean.';
$string['modgradecantchangescale'] = 'Ezin duzu eskala aldatu, elementu honentzat dagoeneko kalifikazioak daudelako.';
$string['modgradecategorycantchangegradetypemsg'] = 'Kategoria honek baliogabetuak izan diren kalifikazio-elementu batzuk ditu. Dagoeneko kalifikazio batzuk esleitu direnez, kalifikazio-mota ezin da aldatu. Gehieneko kalifikazioa aldatu nahi baduzu, aurretik existitzen diren kalifikazioak berriz eskalatu nahi dituzun aukeratu behar duzu.';
$string['modgradecategorycantchangegradetyporscalemsg'] = 'Kategoria honekin lotuta dauden kalifikazioak baliogabetuak izan dira. Dagoeneko kalifikazio batzuk esleitu direnez, kalifikazio mota ezin da aldatu.';
$string['modgradecategoryrescalegrades'] = 'Berriz eskalatu baliogabetutako kalifikazioak';
$string['modgradecategoryrescalegrades_help'] = 'Kalifikazio-liburuko elementu baten gehieneko kalifikazioa aldatzean zehaztu behar duzu dagoeneko existitzen diren ehunekoak ere aldatu beharko diren edo ez.

\'Bai\' aukeratuz gero, existitzen diren baliogabetutako kalifikazio guztiak berriz eskalatuak izango dira kalifikazio-ehunekoak mantendu ahal izateko.

Adibidez, \'Bai\' aukeratuz gero, elementu baten gehieneko kalifikazio 10etik 20ra aldatzeak 10/6 (%60) kalifikazio bat berriz eskalatzea eta 20/12 (%60) izatea suposatuko du. \'Ez\' aukeratuz gero, kalifikazioa ez da aldatuko, eta beraz eskuz aldatu beharko dira puntuazioak egokiak direla bermatzeko.';
$string['modgradedonotmodify'] = 'Ez aldatu ezarrita dauden kalifikazioak';
$string['modgradeerrorbadpoint'] = 'Kalifikazio balio baliogabea. 1 eta {$a} arteko zenbaki oso bat izan behar da.';
$string['modgradeerrorbadscale'] = 'Eskala baliogabea aukeratu da. Mesedez ziurtatu beheko aukeretatik hautatzen duzula.';
$string['modgrademaxgrade'] = 'Gehieneko puntuazioa';
$string['modgraderescalegrades'] = 'Berriz eskalatu existitzen diren kalifikazioak';
$string['modgraderescalegrades_help'] = 'Kalifikazio-elementu baten gehieneko kalifikazioa aldatzen duzunean zehaztu behar duzu existitzen diren kalifikazioen ehunekoak ere aldatuko diren edo ez.

\'Bai\' aukeratuz gero existitzen diren kalifikazioak berriz eskalatuko dira ehunekoa aldatu ez dadin.

Adibidez, \'Bai\' aukeratuz gero, elementu baten gehieneko kalifikazio 10etik 20ra aldatzeak 10/6 (%60) kalifikazio bat berriz eskalatzea eta 20/12 (%60) izatea suposatuko du. \'Ez\' aukeratuz gero, kalifikazioa 10/6 (%60) izatetik 20/6 (%30) izatera pasako da, eta beraz eskuz aldatu beharko dira puntuazioak egokiak direla bermatzeko.';
$string['modgradetype'] = 'Mota';
$string['modgradetypenone'] = 'Bat ere ez';
$string['modgradetypepoint'] = 'Puntuazioa';
$string['modgradetypescale'] = 'Eskala';
$string['morethanmax'] = '{$a->itemname}-n {$a->username}-ri emandako kalifikazioa baimendutako gehienekoa baino handiagoa da';
$string['moveselectedto'] = 'Mugitu aukeratutako elementuak hona:';
$string['movesitems'] = 'Mugitu elementuak';
$string['movingelement'] = '{$a} mugitzen';
$string['multfactor'] = 'Biderkatzailea';
$string['multfactor_help'] = 'Kalifikazio-elementu honen kalifikazio guztiak zein faktorerekin biderkatuko diren, beti ere kalifikazio maximoa gainditu gabe. Adibidez, biderkatzailea 2 bada eta kalifikazio maximoa 100, 50etik beherako balioak bikoiztuko dira eta hortik gorakoak 100 baliora aldatuko dira.';
$string['multfactorvalue'] = 'Biderkatzailearen balioa {$a}rako';
$string['mustchooserescaleyesorno'] = 'Existitzen diren kalifikazioak berriz eskalatu edo ez aukeratu behar duzu.';
$string['mygrades'] = 'Erabiltzailearen menuko kalifikazioen esteka';
$string['mygrades_desc'] = 'Ezarpen honek erabiltzailearen menutik kanpoko kalifikazio-liburu bat estekatzea baimentzen du.';
$string['mypreferences'] = 'Nire hobespenak';
$string['myreportpreferences'] = 'Nire txostenaren hobespenak';
$string['myself'] = 'Ni neu';
$string['neverdeletehistory'] = 'Ez ezabatu historia inoiz';
$string['newcategory'] = 'Kategoria berria';
$string['newitem'] = 'Kalifikazio-elementu berria';
$string['newoutcomeitem'] = 'Ikaste-emaitza elementu berria';
$string['no'] = 'Ez';
$string['nocategories'] = 'Ikasgai honetako kalifikazio-kategoriak ez dira erantsi edo aurkitu';
$string['nocategoryname'] = 'Kategoriak ez du izenik';
$string['nocategoryview'] = 'Ikusteko kategoriarik ez';
$string['nocourses'] = 'Oraindik ez dago ikastarorik';
$string['noexistingoutcomes'] = 'Ez dago ikaste-emaitzarik.';
$string['noexistingscales'] = 'Ez dago eskalarik.';
$string['noforce'] = 'Ez behartu';
$string['nogradeletters'] = 'Kalifikazio-letrak ez dira ezarri';
$string['nogradesreturned'] = 'Ez da kalifikaziorik itzuli';
$string['noidnumber'] = 'ID zenbakirik ez';
$string['nolettergrade'] = 'Ikusteko kalifikaziorik ez';
$string['nomode'] = 'NA';
$string['nonnumericweight'] = 'Zenbakidun balioa jaso da';
$string['nonunhideableverbose'] = 'Kalifikazio hau erakusteko aurretik {$a->itemname} erakutsi behar duzu.';
$string['nonunlockableverbose'] = 'Kalifikazio hau desblokeatzeko aurretik {$a->itemname} desblokeatu behar duzu.';
$string['nonweightedpct'] = 'ponderatu gabeko %a';
$string['nooutcome'] = 'Ez dago ikaste-emaitzarik';
$string['nooutcomes'] = 'Ikaste-emaitzak ikastaroko ikaste-emaitza batekin lotuta egon behar du, baina ikastaro honetan ez dago ikaste-emaitzarik. Gehitu nahi al duzu bat?';
$string['nopermissiontoresetweights'] = 'Ez duzu pisuak berrabiarazteko baimenik.';
$string['nopublish'] = 'Ez argitaratu';
$string['noreports'] = 'Ez zaude matrikulatuta hemen, ez zara irakaslea gune honetako ikastaroetan.';
$string['norolesdefined'] = 'Definitu gabeko rolak hemen: Kudeaketa > Kalifikazioak > Ezarpen orokorrak > Kalifikatutako rolak';
$string['noscales'] = 'Ikaste-emaitzak ikastaroko eskala edo eskala global batekin egon behar du lotuta, baina ez dago bat ere. Gehitu nahi al duzu bat?';
$string['noselectedcategories'] = 'ez da kategoriarik aukeratu.';
$string['noselecteditems'] = 'ez da elementurik aukeratu.';
$string['notenrolled'] = 'Une honetan ez zaude matrikulatuta ezein ikastarotan.';
$string['notteachererror'] = 'Irakasleek soilik erabil dezakete aukera hau.';
$string['nousersloaded'] = 'Ez da erabiltzailerik aurkitu';
$string['nouserstograde'] = 'Ez dago erabiltzailerik kalifikatzeko';
$string['numberofgrades'] = 'Kalifikazio-kopurua';
$string['onascaleof'] = '{$a->grademin} -tik {$a->grademax} -ra bitarteko eskalan';
$string['operations'] = 'Eragiketak';
$string['options'] = 'Aukerak';
$string['others'] = 'Beste batzuk';
$string['otheruser'] = 'Erabiltzailea';
$string['outcome'] = 'Ikaste-emaitza';
$string['outcome_help'] = 'Ezarpen honek zehazten du kalifikazio-elementua zein ikaste-emaitzarekin lotuta agertuko den kalifikazio-liburuan.';
$string['outcomeassigntocourse'] = 'Esleitu beste ikaste-emaitza bat ikastaro honetan';
$string['outcomecategory'] = 'Sortu ikaste-emaitzak kategorian';
$string['outcomecategorynew'] = 'Kategoria berria';
$string['outcomeconfirmdelete'] = 'Ziur zaude "{$a}" ikaste-emaitza ezabatu nahi duzula?';
$string['outcomecreate'] = 'Gehitu ikaste-emaitza berria';
$string['outcomedelete'] = 'Ezabatu ikaste-emaitza';
$string['outcomefullname'] = 'Izen osoa';
$string['outcomeitem'] = 'Ikaste-emaitza elementua';
$string['outcomeitemsedit'] = 'Editatu ikaste-emaitza elementua';
$string['outcomereport'] = 'Ikaste-emaitzen txostena';
$string['outcomes'] = 'Ikaste-emaitzak';
$string['outcomescourse'] = 'Ikastaroan erabilitako ikaste-emaitzak';
$string['outcomescoursecustom'] = 'Erabilitako pertsonalizatua (ez kendu)';
$string['outcomescoursenotused'] = 'Erabili gabeko estandarra';
$string['outcomescourseused'] = 'Erabilitako estandarra (ez kendu)';
$string['outcomescustom'] = 'Pertsonalizatu ikaste-emaitzak';
$string['outcomesdisabled'] = 'Ikaste-emaitzak ez daude gaituta';
$string['outcomeshortname'] = 'Izen laburra';
$string['outcomesstandard'] = 'Ikaste-emaitza estandarrak';
$string['outcomesstandardavailable'] = 'Eskura dauden ikaste-emaitza estandarrak';
$string['outcomestandard'] = 'Ikaste-emaitza estandarra';
$string['outcomestandard_help'] = 'Gune mailan, ikastaro guztietan, edozein ikaste-emaitza estandar dago eskuragarri.';
$string['overallaverage'] = 'Batez besteko orokorra';
$string['overridden'] = 'Baliogabetuak';
$string['overridden_help'] = 'Markatuz gero, aurrerantzean kalifikazioa ezingo da lotutako jardueratik aldatu ahalko.

Kalifikazio bat kalifikatzaile-txostenean editatzen denean, baliogabetutako laukitxoa automatikoki markatzen da. Halere, desmarkatu ahal da lotutako jardueratik kalifikazioa aldatzeko aukera izateko.';
$string['overriddennotice'] = 'Jarduera honetako zure azken kalifikazioa eskuz egokitu da.';
$string['overridecat'] = 'Baimendu kategoria-kalifikazioak eskuz baliogabetzea.';
$string['overridecat_help'] = 'Ezarpen hau desgaituz gero erabiltzaileek ezingo dituzte kategoria-kalifikazioak baliogabetu.';
$string['overridesitedefaultgradedisplaytype'] = 'Baliogabetu gunearen lehentsitako balioak';
$string['overridesitedefaultgradedisplaytype_help'] = 'Markatuz gero, ikastaroko kalifikazio-letrak eta mugak ezarri daitezke, gunean lehenetsitakoak erabili beharrean.';
$string['overrideweightofa'] = 'Baliogabetu {$a}(r)en pisua';
$string['parentcategory'] = 'Goragoko kategoria';
$string['pass'] = 'Gaindituta';
$string['pctoftotalgrade'] = '% kalifikazio orokorretik';
$string['percent'] = 'Portzentajea';
$string['percentage'] = 'Ehunekoa';
$string['percentageletter'] = 'Ehunekoa (letra)';
$string['percentagereal'] = 'Ehunekoa (erreala)';
$string['percentascending'] = 'Ordenatu ehunekoak gorantz';
$string['percentdescending'] = 'Ordenatu ehunekoak beherantz';
$string['percentshort'] = '%';
$string['plusfactor'] = 'Konpentsatu';
$string['plusfactor_help'] = 'Konpentsazioa kalifikazio-elementu honen kalifikazio guztiei gehituko zaien zenbakia da, biderkatzailea aplikatu ondoren.';
$string['plusfactorvalue'] = 'Konpentsatu {$a}(r)en balioa';
$string['points'] = 'puntuak';
$string['pointsascending'] = 'Ordenatu puntuak gorantz';
$string['pointsdescending'] = 'Ordenatu puntuak beherantz';
$string['positionfirst'] = 'Lehena';
$string['positionlast'] = 'Azkena';
$string['preferences'] = 'Hobespenak';
$string['prefgeneral'] = 'Orokorra';
$string['prefletters'] = 'Kalifikazio-letrak eta mugak';
$string['prefrows'] = 'Zutabe bereziak';
$string['prefshow'] = 'Erakutsi/ezkutatu kontrolak';
$string['previewrows'] = 'Aurreikusi zutabeak';
$string['privacy:metadata:categorieshistory'] = 'Kalifikazio-kategorien aurretiko bertsioen erregistroa';
$string['privacy:metadata:filepurpose'] = 'Erabiltzailearentzat kalifikazio-liburuan gordetako iruzkin-fitxategiak.';
$string['privacy:metadata:grade_import_newitem'] = 'Kalifikazioak inportatzean kalifikazio-elementu berriak behin behinean gordetzeko taula.';
$string['privacy:metadata:grade_import_newitem:importcode'] = 'Inportatze-sorta bakoitza identifikatzeko sorta-bakar bakoitzarentzako kodea';
$string['privacy:metadata:grade_import_newitem:importer'] = 'Datuak inportatzen dituen erabiltzailea';
$string['privacy:metadata:grade_import_newitem:itemname'] = 'Kalifikazio-elementu berriaren izena';
$string['privacy:metadata:grade_import_values'] = 'Kalifikazioak inportatzeko behin behineko taula';
$string['privacy:metadata:grade_import_values:feedback'] = 'Kalifikazioaren feedbacka';
$string['privacy:metadata:grade_import_values:finalgrade'] = 'Puntuazio gordinaren balioa';
$string['privacy:metadata:grade_import_values:importcode'] = 'Inportatze-sorta bakoitza identifikatzeko sorta-bakar bakoitzarentzako kodea';
$string['privacy:metadata:grade_import_values:importer'] = 'Datuak inportatzen dituen erabiltzailea';
$string['privacy:metadata:grade_import_values:importonlyfeedback'] = 'Feedbacka inportatu den adierazteko marka';
$string['privacy:metadata:grade_import_values:userid'] = 'Inportatu den kalifikazioaren zein erabiltzailearena den';
$string['privacy:metadata:grades'] = 'Kalifikazioen erregistroa';
$string['privacy:metadata:grades:aggregationstatus'] = 'Agregazioaren egoera';
$string['privacy:metadata:grades:aggregationweight'] = 'Pisua agregazioan';
$string['privacy:metadata:grades:feedback'] = 'Feedbacka';
$string['privacy:metadata:grades:finalgrade'] = 'Kalifikazioa';
$string['privacy:metadata:grades:information'] = 'Kalifikazioaren inguruko informazio gehigarria';
$string['privacy:metadata:grades:timemodified'] = 'Kalifikazioa azkenengoz aldatu zeneko unea';
$string['privacy:metadata:grades:userid'] = 'Kalifikazioaren erabiltzailea denaren IDa';
$string['privacy:metadata:grades:usermodified'] = 'Erregistroa azkenengoz aldatu zuen erabiltzailearen IDa';
$string['privacy:metadata:gradeshistory'] = 'Aurretiko kalifikazioen erregistroa';
$string['privacy:metadata:history:loggeduser'] = 'Aldaketa egin zenean saioa hasita zegoen erabiltzailea';
$string['privacy:metadata:history:timemodified'] = 'Kalifikazio-aldaketa egin zeneko unea';
$string['privacy:metadata:itemshistory'] = 'Kalifikazio-elementuen aurretiko bertsioen erregistroa';
$string['privacy:metadata:outcomes'] = 'Ikaste-emaitzen erregistroa';
$string['privacy:metadata:outcomes:timemodified'] = 'Erregistroa aldatu zeneko unea';
$string['privacy:metadata:outcomes:usermodified'] = 'Erregistroa aldatu zuen erabiltzailea';
$string['privacy:metadata:outcomeshistory'] = 'Ikaste-emaitzen aurretirko bertsioen erregistroa';
$string['privacy:metadata:scale'] = 'Eskalen erregistroa';
$string['privacy:metadata:scale:timemodified'] = 'Erregistroa azkenengoz aldatu zen unea';
$string['privacy:metadata:scale:userid'] = 'Erregistroa azkenengoz aldatu zuen erabiltzailea';
$string['privacy:metadata:scalehistory'] = 'Eskalen aurretiko bertsioen erregistroa';
$string['privacy:path:relatedtome'] = 'Nirekin lotutakoak';
$string['privacy:request:historyactiondelete'] = 'Ezabatu';
$string['privacy:request:historyactioninsert'] = 'Sartu';
$string['privacy:request:historyactionupdate'] = 'Eguneratu';
$string['privacy:request:unknowndeletedgradeitem'] = 'Ezezaguna (kalifikazio-elementua ezabatua izan da)';
$string['profilereport'] = 'Erabiltzaile-profilaren txostena';
$string['profilereport_help'] = 'Erabiltzailearen profil-orrian erabilitako kalifikazio-txostena.';
$string['publishing'] = 'Argitaratzen';
$string['publishingoptions'] = 'Kalifikazioak argitaratzeko aukerak';
$string['quickfeedback'] = 'Feedback azkarra';
$string['quickgrading'] = 'Kalifikazio azkarra';
$string['quickgrading_help'] = 'Gaituz gero, eta edizioa aktibatuta dagoenean, testua sartzeko eremu bat agertzen da kalifikazio bakoitzarentzat, eta horrela aldi berean kalifikazio bat baino gehiago editatu daitezke. Aldaketak gorde eta nabarmentzen dira \'Gorde aldaketak azkar guztietako aldaketak\' botoian klik egitean.

Kontuan izan kalifikatzaile-txostenean kalifikazio bat editatzen denean baliogabetua izan denaren marka jartzen zaiola, eta horrek esan nahi du kalifikazioa ezingo dela lotutako jardueratik aldatu ahalko.';
$string['range'] = 'Ibiltartea';
$string['rangedecimals'] = 'Ibiltarteen hamartar-kopurua';
$string['rangedecimals_help'] = 'Ibiltartean erakutsiko diren hamartar-kopurua.';
$string['rangesdecimalpoints'] = 'Hamartarrak erakutsi ibiltarteetan';
$string['rangesdecimalpoints_help'] = 'Ezarpen honek kalifikazio-tarte bakoitzarentzako erakutsi beharreko hamartar-kopurua edo kategoria ala kategoria edo kalifikazio-elementua erakusteko hamartar-kopurua ezarpena erabiliko den (zaharkitua) zehazten du.';
$string['rangesdisplaytype'] = 'Ibiltartea erakusteko modua';
$string['rangesdisplaytype_help'] = 'Ezarpen honek ibiltartea nola erakutsiko diren zehazten du: benetako kalifikazioak, ehunekoak edo letrak, edo kategoriaren edo kalifikazio-elemetuarena (heredatutakoa).';
$string['rank'] = 'Sailkapena';
$string['rawpct'] = '% gordina';
$string['real'] = 'Erreala';
$string['realletter'] = 'Erreala (letra)';
$string['realpercentage'] = 'Erreala (ehunekoa)';
$string['recalculatinggrades'] = 'Kalifikazioak berriz kalkulatzen';
$string['recovergradesdefault'] = 'Berreskuratu kalifikazioetako balio lehenetsiak';
$string['recovergradesdefault_help'] = 'Modu lehenetsian kalifikazio zaharrak berreskuratu ikasle bat ikastaro batean berriz matrikulatzean.';
$string['refreshpreview'] = 'Freskatu aurreikuspena';
$string['regradeanyway'] = 'Berriro kalifikatu hala ere';
$string['removeallcoursegrades'] = 'Ezabatu kalifikazio guztiak';
$string['removeallcoursegrades_help'] = 'Markatuz gero, kalifikazio-liburura eskuz gehitutako kalifikazio-elementu eta kalifikazio guztiak ezabatuko dira, baita baliogabetutako, kanpoan utzitako, ezkutatutako eta blokeatutako kalifikazioen datuekin batera. Soilik jarduerekin lotutako kalifikazio-elementuak mantenduko dira.';
$string['removeallcourseitems'] = 'Ezabatu elementu eta kategoria guztiak';
$string['removeallcourseitems_help'] = 'Markatuz gero, kalifikazio-liburura eskuz gehitutako kategoriak eta kalifikazio-elementu guztiak ezabatuko dira, baliogabetutakoak, kanpoan utzitako, ezkutatutako eta blokeatutako kalifikazioak euren kalifikazio eta datuekin batera. Soilik jarduerekin lotutako kalifikazio-elementuak mantenduko dira.';
$string['report'] = 'Txostena';
$string['reportdefault'] = 'Lehenetsitako ezarpena ({$a})';
$string['reportplugins'] = 'Txostenetarako plugin-ak';
$string['reportsettings'] = 'Txostenaren ezarpenak';
$string['reprintheaders'] = 'Berriz inprimatu goiburuak';
$string['resetweights'] = 'Berrabiarazi {$a->itemname}-ren pisuak';
$string['resetweightsshort'] = 'Berrabiarazi pisuak';
$string['respectingcurrentdata'] = 'Egungo ezarpenak ez dira aldatu';
$string['rowpreviewnum'] = 'Aurreikusi zutabeak';
$string['rowpreviewnum_help'] = 'Inportatzera doazen datuak aurreikusi daitezke inportazioa berretsi aurretik. Ezarpen honek zenbat errenkada aurreikusiko diren zehazten du.';
$string['savechanges'] = 'Gorde aldaketak';
$string['savepreferences'] = 'Gorde hobespenak';
$string['scaleconfirmdelete'] = 'Ziur zaude "{$a}" eskala ezabatu nahi duzula?';
$string['scaledpct'] = 'Eskalatua %';
$string['searchcollapsedcolumns'] = 'Bilatu tolestutako zutabeak';
$string['seeallcoursegrades'] = 'Ikusi ikastaroaren kalifikazio guztiak';
$string['select'] = 'Aukeratu {$a}';
$string['selectalloroneuser'] = 'Aukeratu erabiltzaile bat edo guztiak';
$string['selectauser'] = 'Aukeratu erabiltzaile bat';
$string['selectdestination'] = 'Aukeratu helmuga honentzat: {$a}';
$string['selectgrouplink'] = 'Aukeratu talde bat';
$string['selectuserlink'] = 'Aukeratu erabiltzaile bat';
$string['separator'] = 'Bereizlea';
$string['separator_help'] = 'Aukeratu CSV fitxategian erabiliko den bereizlea. (Normalean koma bat izaten da.)';
$string['sepcolon'] = 'Bi puntu';
$string['sepcomma'] = 'Koma';
$string['sepsemicolon'] = 'Puntu eta koma';
$string['septab'] = 'Fitxa';
$string['setcategories'] = 'Ezarri kategoriak';
$string['setcategorieserror'] = 'Pisuak esleitu aurretik ikastaroko kategoriak ezarri behar dituzu.';
$string['setgradeletters'] = 'Letraz kalifikatu';
$string['setpreferences'] = 'Ezarri hobespenak';
$string['setting'] = 'Ezarpena';
$string['settings'] = 'Ezarpenak';
$string['setup'] = 'Ezarpenak';
$string['setweights'] = 'Ezarri pisuak';
$string['showactivityicons'] = 'Erakutsi jarduera-ikonoak';
$string['showactivityicons_help'] = 'Gaituz gero, jardueren izenaren ondoan jardueren ikonoak erakutsiko dira.';
$string['showallgrades'] = 'Erakutsi kalifikazio guztiak';
$string['showallhidden'] = 'Erakutsi ezkutukoak';
$string['showallstudents'] = 'Erakutsi ikasle guztiak';
$string['showanalysisicon'] = 'Erakutsi kalifikazio-analisiaren ikonoa';
$string['showanalysisicon_desc'] = 'Modu lehenetsian kalifikazio-analisiaren ikonoa erakutsiko den edo ez. Jarduera-moduluak baimentzen badu, kalifikazio-analisiaren ikonoak kalifikazioaren eta nola lortu duenaren azalpen zehatzagoa erakusten duen orri bat estekatuko du';
$string['showanalysisicon_help'] = 'Jarduera-moduluak baimentzen badu, kalifikazio-analisiaren ikonoak kalifikazioaren eta nola lortu duenaren azalpen zehatzagoa erakusten duen orri bat estekatuko du';
$string['showaverage'] = 'Erakutsi batez bestekoa';
$string['showaverage_help'] = 'Batez bestearen zutabea erakutsiko den edo ez. Kontuan izan parte hartzaileek besteen kalifikazioak kalkulatu ahalko dituztela batez bestekoa kalifikazio kopuru txikiekin kalkulatuak badira. Errendimendu arrazoiengatik, batez bestekoa gutxi gorabeherakoa izango da ezkutuko elementuen menpe badago.';
$string['showaverages'] = 'Erakutsi batez bestekoak';
$string['showaverages_help'] = 'Gaituz gero, kalifikatzaile-txostenean kategoria eta elementu bakoitzerako batez bestekoa erakusten dituen beste lerro bat erakusten du.';
$string['showcalculations'] = 'Erakutsi kalkuluak';
$string['showcalculations_help'] = 'Gaituz gero, editatzean kalkulagailuaren ikonoa erakusten da kalkulatutako elementuen gainean kalkulatua dela adierazteko.';
$string['showcontributiontocoursetotal'] = 'Erakutsi ikastaroaren denerako ekarpena';
$string['showcontributiontocoursetotal_help'] = 'Kalifikazio-elementu bakoitzak ikastaroaren denera egiten dion ekarpenaren ehunekoa (ponderazioak aplikatu ondoren) duen zutabea erakutsiko den edo ez.';
$string['showeyecons'] = 'Erakutsi erakutsi/ezkutatu ikonoak';
$string['showeyecons_help'] = 'Gaituz gero, eta edizioa aktibatuta badago, kalifikazio bakoitzaren ondoan ikasleentzako elementuaren ikusgarritasuna kontrolatzeko erakutsi/ezkutatu ikonoa erakutsiko da.';
$string['showfeedback'] = 'Erakutsi feedbacka';
$string['showfeedback_help'] = 'Feedbackaren zutabea erakutsiko den edo ez';
$string['showgrade'] = 'Erakutsi kalifikazioak';
$string['showgrade_help'] = 'Kalifikazioen zutabea erakutsiko den edo ez';
$string['showgroups'] = 'Erakutsi taldeak';
$string['showhiddenitems'] = 'Erakutsi ezkutuko elementuak';
$string['showhiddenitems_help'] = 'Ezkutuan dauden kalifikazio-elementuak guztiz ezkutuan edo izenak ikusgai eta kalifikazioak ezkutuan egongo diren.

* Erakutsi ezkutuko elementuak - Ezkutuan dauden kalifikazioen izenak ikusgai daude baina ikasleen kalifikazioak ezkutuan.
* Ezkutuan data heldu arte - "ezkutuan data heldu arte" zehaztuta duten kalifikazio-elementua guztiz ezkutuan dago data heldu arte, eta ondoren elementua guztiz erakutsiko da.
* Ez erakutsi - Ezkutuan dauden elementuak guztiz ezkutuan daude.';
$string['showhiddenuntilonly'] = 'Ezkutuan data heldu arte';
$string['showingaggregatesonly'] = 'Guztirakoak soilik erakusten';
$string['showingfullmode'] = 'Kalifikazioak eta guztirakoak erakusten';
$string['showinggradesonly'] = 'Soilik kalifikazioak erakusten';
$string['showlettergrade'] = 'Erakutsi kalifikazio-letrak';
$string['showlettergrade_help'] = 'Kalifikazio-letren zutabea erakutsiko den edo ez';
$string['showlocks'] = 'Erakutsi blokeoak';
$string['showlocks_help'] = 'Gaituz gero, edizioa aktibatuta dagoenean, kalifikazio bakoitzarentzako blokeatu/desblokeatu ikono bat erakusten da lotutako jarduera eguneratzean kalifikazioa automatikoki eguneratu daitekeen edo ez kontrolatzeko.';
$string['shownohidden'] = 'Ez erakutsi';
$string['shownooutcomes'] = 'Ezkutatu ikaste-emaitzak';
$string['shownumberofgrades'] = 'Erakutsi kalifikazio-kopurua batez bestekoetan';
$string['shownumberofgrades_help'] = 'Gaituz gero, batez bestekoa kalkulatzean erabilitako kalifikazioa kopurua parentesi artean erakusten da batez besteko  bakoitzaren ondoan.';
$string['showonlyactiveenrol'] = 'Erakutsi soilik matrikula aktiboak';
$string['showonlyactiveenrol_help'] = 'Ezarpen honek zehazten du kalifikazio-txostenean matrikulatutako erabiltzaile aktiboak soilik erakutsiko diren edo ez. Gaituz gero, kontua etenda duten erabiltzaileak ez dira kalifikazio-liburuan erakutsiko.';
$string['showpercentage'] = 'Erakutsi ehunekoa';
$string['showpercentage_help'] = 'Kalifikazio-elementu bakoitzerako ehunekoaren balioa erakutsiko den edo ez.';
$string['showquickfeedback'] = 'Erakutsi feedback azkarra';
$string['showquickfeedback_help'] = 'Gaituz gero, edizioa aktibatuta dagoenean kalifikazio bakoitzarekin batera feedbackaren testurako puntutxoak dituen testu-eremu kutxa bat agertuko da, eta horrela hainbat kalifikazioren feedbackak batera editatzea ahalbidetzen da. Egindako aldaketak gorde eta nabarmentzen dira gorde botoian klik egitean.

Kontuan izan feedbacka kalifikatzaile-txostenean editatzen denean baliogabetu marka jartzen zaiola, eta horrek esan nahi du ondoren ezingo dela feedback hori dagokion jardueratik aldatu.';
$string['showrange'] = 'Erakutsi ibiltarteak';
$string['showrange_help'] = 'Ibiltarteen zutabea erakutsiko den edo ez';
$string['showranges'] = 'Erakutsi ibiltarteak';
$string['showranges_help'] = 'Gaituz gero, kalifikatzaile-txostenean kategoria eta elementu bakoitzerako kalifikazio-mailak erakusten dituen beste lerro bat erakusten du.';
$string['showrank'] = 'Erakutsi sailkapena';
$string['showrank_help'] = 'Kalifikazio-elementu bakoitzean ikaslearen kokalekua klaseko gainontzekoen aldean erakutsiko den edo ez';
$string['showuserimage'] = 'Erakutsi erabiltzaile-profilaren irudiak';
$string['showuserimage_help'] = 'Kalifikatzaile-txostenean erabiltzailearen izenaren ondoan profilaren irudia erakutsiko den edo ez.';
$string['showverbose'] = 'Erakutsi {$a->category} {$a->itemmodule} {$a->itemname}';
$string['showweight'] = 'Erakutsi ponderazioak';
$string['showweight_help'] = 'Kalifikazio-pisuaren zutabea erakutsiko den edo ez';
$string['simpleview'] = 'Banakako ikuspegia';
$string['sitewide'] = 'Gune mailan';
$string['sort'] = 'ordenatu';
$string['sortasc'] = 'Ordenatu behetik gora';
$string['sortbyfirstname'] = 'Ordenatu izenaren arabera';
$string['sortbylastname'] = 'Ordenatu abizenaren arabera';
$string['sortdesc'] = 'Ordenatu goitik behera';
$string['standarddeviation'] = 'Desbiderapen estandarra';
$string['stats'] = 'Estatistikak';
$string['statslink'] = 'Estatistikak';
$string['student'] = 'Ikaslea';
$string['studentsperpage'] = 'Ikasleak orriko';
$string['studentsperpage_help'] = 'Ezarpen honek kalifikatzaile-txosteneko orri bakoitzean erakutsi beharreko ikasle-kopurua zehazten du.';
$string['studentsperpagereduced'] = 'Orri bakoitzeko ikasle kopurua {$a->originalstudentsperpage}-tik {$a->studentsperpage}-ra murriztu da. Pentsatu ezazu PHP-ren max_input_vars ezarpena {$a->maxinputvars}-tik gora ezartzea.';
$string['subcategory'] = 'Ohiko kategoria';
$string['submissions'] = 'Bidalketak';
$string['submittedon'] = 'Bidalita: {$a}';
$string['sumofgradesupgradedgrades'] = 'Oharra: "Kalifikazioen batura" agregazio-metodoa "Naturala" izatera pasa da eguneraketa egitearekin batera. Aurretik ikastaro honetan "Kalifikazioen batura" erabiltzen zenez, kalifikazio-liburuan aldaketa honen eragina berrikustea gomendatzen da.';
$string['switchtofullview'] = 'Aldatu ikuspegi osora';
$string['switchtosimpleview'] = 'Aldatu ikuspegi sinplera';
$string['topcategory'] = 'Kategoria gorena';
$string['total'] = 'Guztira';
$string['totalweight100'] = 'Pisu osoa 100ekoa da';
$string['totalweightnot100'] = 'Pisu osoa ez da 100ekoa';
$string['turnfeedbackoff'] = 'Feedbacka desgaitu';
$string['turnfeedbackon'] = 'Feedbacka gaitu';
$string['typenone'] = 'Bat ere ez';
$string['typescale'] = 'Eskala';
$string['typescale_help'] = '<p>Eskala bidezko kalifikazioa erabiltzen denean, eskala bat aukera daiteke. Jarduera batean oinarritutako kalifikazio-elementu baterako eskala jarduera eguneratzeko orrian aukeratzen da.</p>';
$string['typetext'] = 'Testua';
$string['typevalue'] = 'Balioa';
$string['uncategorised'] = 'Kategorizatu gabea';
$string['unchangedgrade'] = 'Kalifikazioa ez da aldatu';
$string['unenrolledusersinimport'] = 'Inportazio honek une honetan ikastaroan matrikulatua ez dauden hurrengo ikasle hauen kalifikazioak barne zituen: {$a}';
$string['unlimitedgrades'] = 'Mugarik gabeko kalifikazioak';
$string['unlimitedgrades_help'] = 'Modu lehenetsian, kalifikazioak kalifikazio-elementuaren gutxieneko eta gehieneko balioek mugatzen dituzte. Ezarpen hau gaituz gero, muga hori kentzen da, eta kalifikazio-liburuan %100etik gorako kalifikazioak sartzea ahalbidetzen du.';
$string['unlock'] = 'Desblokeatu';
$string['unlockverbose'] = 'Desblokeatu {$a->category} {$a->itemmodule} {$a->itemname}';
$string['unused'] = 'Erabili gabea';
$string['updatedgradesonly'] = 'Esportatu soilik kalifikazio berriak edo eguneratutakoak';
$string['upgradedgradeshidemessage'] = 'Baztertu jakinarazpena';
$string['upgradedminmaxrevertmessage'] = 'Desegin aldaketak';
$string['uploadgrades'] = 'Igo kalifikazioak';
$string['useadvanced'] = 'Erabili funtzio aurreratuak';
$string['usedcourses'] = 'Erabilitako ikastaroak';
$string['usedgradeitem'] = 'Erabilitako kalifikazio-elementua';
$string['usenooutcome'] = 'Ez erabili ikaste-emaitza';
$string['usenoscale'] = 'Ez erabili eskala';
$string['usepercent'] = 'Erabili portzentajea';
$string['user'] = 'Erabiltzailea';
$string['userenrolmentsuspended'] = 'Erabiltzaile-matrikulazioa eten da.';
$string['userfields_show'] = 'Erakutsi erabiltzailearen eremuak';
$string['userfields_show_help'] = 'Erakutsi helbide elektronikoaren moduko erabiltzaile eremu gehigarriak kalifikatzaile-txostenean. Erakutsiko diren eremu zehatzak gune mailako \'Erakutsi erabiltzailearen identitatea\' ezarpenak kontrolatzen du.';
$string['usergrade'] = 'Erabiltzailea {$a->fullname} ({$a->useridnumber}) elementu honetan {$a->gradeidnumber}';
$string['userid'] = 'Erabiltzailearen IDa';
$string['useridnumberwarning'] = 'ID zenbakia ez duten erabiltzaileak baztertuta daude esportaziotik. Era beran, ezin dira inportatu';
$string['usermappingerror'] = 'Errorea erabiltzailea lotzean: Ez da aurkitu {$a->field} eremuan "{$a->value}" balioa duen erabiltzailerik.';
$string['usermappingerrorcurrentgroup'] = 'Erabiltzailea ez da talde honetako partaidea.';
$string['usermappingerrormultipleusersfound'] = 'Errorea erabiltzailea lotzean: {$a->field} eremuan "{$a->value}" daukaten hainbat erabiltzaile aurkitu dira. Mesedez erabili ezazu bakarra izango den eremu-lotura bat.';
$string['usermappingerrorusernotfound'] = 'Errorea erabiltzailea lotzean: Ez da erabiltzailea aurkitu.';
$string['userpreferences'] = 'Erabiltzailearen hobespenak';
$string['useweighted'] = 'Erabili ponderatua';
$string['verbosescales'] = 'Hitzen bidezko eskalak';
$string['verbosescales_help'] = 'Hitzen bidezko eskalek zenbakien ordez hitzak erabiltzen dituzte. \'Bai\' aukeratu zenbakizko eta hitzen bidezko inportatzera bazoaz. \'Ez\' aukeratu zenbakizko eskalak soilik inportatzera bazoaz.';
$string['viewas'] = 'Ikusi txostena honela';
$string['viewbygroup'] = 'Taldea';
$string['viewfeedback'] = 'Ikusi feedbacka';
$string['viewgrades'] = 'Ikusi kalifikazioak';
$string['weight'] = 'Pisua';
$string['weight_help'] = 'Ikastaroko kategoria batean elementuen balio erlatiboa zehazteko erabiltzen den balioa.';
$string['weightcourse'] = 'Erabili ponderatutako kalifikazioak ikastarorako';
$string['weightedascending'] = 'Ordenatu ponderatutako ehunekoaren arabera gorantz';
$string['weighteddescending'] = 'Ordenatu ponderatutako ehunekoaren arabera beherantz';
$string['weightedpct'] = '% ponderatua';
$string['weightedpctcontribution'] = 'ekarpenaren pisu ponderatuaren %a';
$string['weightofa'] = '{$a}-ren pisua';
$string['weightorextracredit'] = 'Pisua edo aparteko kreditua';
$string['weightoverride'] = 'pisua doitzea';
$string['weightoverride_help'] = 'Desmarkatu aukera hau kalifikazio-elementu baten pisua automatikoki kalkulatutako baliora berrabiarazteko. Aukera hau markatuta pisua automatiko doitzea saihestuko duzu.';
$string['weights'] = 'Pisuak';
$string['weightsadjusted'] = 'Zure pisuak guztira 100 izateko egokitu dira.';
$string['weightsedit'] = 'Editatu pisuak eta aparteko kredituak';
$string['weightuc'] = 'Kalkulatutako pisua';
$string['writinggradebookinfo'] = 'Kalifikazio-liburuaren ezarpenak idazten';
$string['xml'] = 'XML';
$string['yes'] = 'Bai';
$string['yourgrade'] = 'Zure kalifikazioa';
