<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_amos', language 'eu', version '4.4'.
 *
 * @package     local_amos
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['about'] = '<p>AMOS Moodleko kateen eta euren aldaketen bilgune nagusia da. Moodleko kodean gehitzen diren ingelesezko kateen jarraipena egiten du, itzulpenak biltzen ditu, ohiko itzulpen-lanak kudeatzen ditu eta Moodle zerbitzarietan erabiliko den hizkuntza-paketea sortzen du.</p>
<p>Ikusi ezazu <a href="https://docs.moodle.org/dev/AMOS_manual">AMOS dokumentazioa</a> informazio gehiago izan nahi baduzu.</p>';
$string['amos'] = 'AMOS - Moodle itzultzeko tresna';
$string['amos:changecontriblang'] = 'Aldatu ekarpeneko kateen hizkuntza';
$string['amos:commit'] = 'Onartu lan-eremuko kateak biltegi nagusian';
$string['amos:editlangconfig'] = 'Editatu hizkuntza-paketearen konfigurazio-kateak';
$string['amos:execute'] = 'Exekutatu emandako AMOScript-a';
$string['amos:importfile'] = 'Inportatu itzulpenak igotako fitxategi batetik eta utzi lan-eremuan';
$string['amos:importstrings'] = 'Inportatu kateak (ingelesezkoak barne) zuzenean biltegi nagusian';
$string['amos:manage'] = 'Kudeatu AMOS ataria';
$string['amos:stage'] = 'Erabili AMOS itzulpen tresna eta utzi kateak lan-eremuan';
$string['amos:stash'] = 'Gorde orain lan-eremuan dauden kateak bilduma pribatu iraunkorrean';
$string['amos:usegoogle'] = 'Erabili Google Translate-ko zerbitzuak';
$string['applangindexfile'] = 'Moodle Aplikazioaren langIndex fitxategiaren kokapena';
$string['applangindexfile_desc'] = 'Fitxategia jaisteko URL osoa. Cron zereginak egingo du.';
$string['branchesall'] = 'Moodleko bertsio guztiak';
$string['branchesall_desc'] = 'AMOSek onartzen dituen Moodleko bertsioen zerrenda, komaz banatuta. Hau itzultzailearen iragazkia eta beste leku batzuk elikatzeko erabiltzen da.';
$string['branchsupported'] = 'Onartutako Moodleko bertsio zaharrena';
$string['branchsupported_desc'] = 'Ingelesezko kateen aldaketen jarraipena egin behar deneko eta instalatzailearen hizkuntza-paketeak sortuko diren Moodleko bertsio zaharreneko kodea. Erreferentzia gisa <https://docs.moodle.org/dev/Releases#Version_support> erabili ezazu.';
$string['cachedef_lists'] = 'AMOSen dauden hizkuntza eta osagaien zerrendak';
$string['cachedef_stats'] = 'AMOSek osatutako datu estatistikoak';
$string['commitbutton'] = 'Onartu';
$string['commitkeepstaged'] = 'Mantendu kateak lan-eremuan';
$string['commitmessage'] = 'Onarpen-mezua';
$string['commitmessageempty'] = 'Mesedez, bete ezazu onarpen-mezua';
$string['commitstage'] = 'Onartu lan-eremuan dauden kateak';
$string['commitstage_help'] = 'Behin betiko gorde lan-eremuko itzulpen guztiak AMOS biltegian. Onartu aurretik lan-eremua automatikoki kimatu eta eguneratu egiten da. Soilik onartu daitezkeen kateak gordetzen dira. Horrek esan nahi du soilik behean berde kolorez nabarmendutako kateak onartuko direla. Onartu ondoren lan-eremua hustu egiten da.';
$string['committable'] = 'Hizkuntza-pakete honetan aldaketak egiteko baimena duzu.';
$string['committableall'] = 'hizkuntza guztiak';
$string['committablenone'] = 'Ez dago baimendutako hizkuntzarik - mesedez, jarri harremanetan AMOS-eko kudeatzailearekin';
$string['componentsall'] = 'Guztiak';
$string['componentsapp'] = 'Moodle Aplikazioa';
$string['componentsnone'] = 'Bat ere ez';
$string['componentsstandard'] = 'Estandarra';
$string['componentsworkplace'] = 'Moodle Workplace';
$string['confirmaction'] = 'Ekintza hau ezin da desegin. Ziur zaude?';
$string['contribaccept'] = 'Onartu';
$string['contribactions'] = 'Laguntzaileen ekarpenetako ekintzak';
$string['contribactions_help'] = 'Zure baimenen eta ekarpenen lan-fluxuaren arabera,  hurrengo ekintzetako batzuk eskuragarri izan ditzakezu:

* Aplikatu - kopiatu ekarpena zuren lan-eremuan, ekarpenaren erregistroa aldatu gabe
* Esleitu niri - zure burua jarri ekarpenaren arduradun gisa; ekarpen baten arduraduna berau berrikusi eta integratzeko ardura hartzen du.
* Kendu esleipena - zure ardurapean duzun ekarpen bat arduradun gabe utzi
* Hasi berrikusketa - zure burua jarri ekarpenaren arduradun gisa, ekarpenari \'Berrikusten\' egoera ezarri eta ekarpenaren itzulpenak zure lan-eremura kopiatu
* Onartu - ekarpenari \'Onartua\' egoera ezarri
* Errefusatu - ekarpenari \'Errefusatua\' egoera ezarri, mesedez adierazi arrazoiak iruzkin batean.

Ekarpenaren egileari posta elektroniko bidez jakinarazten zaio bere ekarpenaren egoera aldatzen den bakoitzean.';
$string['contribactions_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribapply'] = 'Aplikatu';
$string['contribassignee'] = 'Arduraduna';
$string['contribassigneenone'] = '-';
$string['contribassigntome'] = 'Esleitu niri';
$string['contribauthor'] = 'Egilea';
$string['contribclosedno'] = 'Ezkutatu ebatzitako ekarpenak';
$string['contribclosedyes'] = 'Erakutsi ebatzitako ekarpenak';
$string['contribcomponents'] = 'Osagaiak';
$string['contribid'] = 'IDa';
$string['contribincomingnone'] = 'Ez dago jasotako ekarpenik';
$string['contribincomingsome'] = 'Jasotako ekarpenak ({$a})';
$string['contriblanguage'] = 'Hizkuntza';
$string['contriblanguagebutton'] = 'Bihurtu';
$string['contriblanguagechange'] = 'Hizkuntza okerreko ekarpenak konpontzen';
$string['contriblanguagechange_help'] = 'Ekarpena nahi gabe hizkuntza-pakete okerrera bidali bada, aukeratu dagokion hizkuntza zabaltzen den menuan eta ondoren Bihurtu botoia sakatu.';
$string['contriblanguagereport'] = 'Hizkuntza okerreko ekarpena jakinarazten';
$string['contriblanguagereport_help'] = 'Ekarpena nahi gabe hizkuntza-pakete okerrera bidali bada, mesedez ekarpenaren URLa kopiatu eta itsatsi `translation@moodle.org` helbidera zuzendutako e-mail batean. Ekarpena ondoren dagokion hizkuntzara mugituko da.';
$string['contriblanguagewrong'] = 'Okerreko hizkuntza?';
$string['contribnotif'] = '[AMOS] Ekarpenaren jakinarazpena (#{$a->id})';
$string['contribnotifaccepted'] = '{$a->fullname}(e)k zure ekarpena onartu du
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Ekarpenaren orria: {$a->contriburl}';
$string['contribnotifcommented'] = '{$a->fullname}(e)k zure ekarpenari iruzkina egin dio
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

---------------------------------------------------------------------
Ekarpenaren orria: {$a->contriburl}';
$string['contribnotifconverted'] = '{$a->fullname}(e)k zure ekarpenari aldaketa bat egin dio
#{$a->id} {$a->subject}

Eskerrik asko zure ekarpenagatik. Halere, errore bat dela eta, hizkuntza-pakete
okerrera bidali dela dirudi. Ondorioz, zure ekarpena hizkuntza-pakete okerrean
errefusatu eta dagokion hizkuntza-paketera mugitu da bertako arduradunek
berrikusi dezaten. Zuk ez duzu ezer egin behar.

Etorkizunean, mesedez itzultzen hasi aurretik egiaztatu ezazu nahi duzun
hizkuntza aukeratu duzula.

---------------------------------------------------------------------
Ekarpenaren hasierako orria: {$a->contriborigurl}
Ekarpenaren orri berria: {$a->contribnewurl}';
$string['contribnotifpending'] = 'Zain dagoen ekarpen batek zure ekintza behar du
#{$a->id} {$a->subject}

Hizkuntza-paketearen arduraduna zarenez, egindako ekarpen guztiak berrikusi
eta behar denean onartu beharko zenituzke. Hori egitean, mesedez
onartu edo errefusatu gisa markatu itzazu.

Xehetasunetarako ikusi {$a->docsurl}.
---------------------------------------------------------------------
Ekarpenaren orria: {$a->contriburl}';
$string['contribnotifrejected'] = '{$a->fullname}(e)k zure ekarpena errefusatu du
#{$a->id} {$a->subject}

---------------------------------------------------------------------
Ekarpenaren orria: {$a->contriburl}';
$string['contribnotifsubmitted'] = '{$a->fullname}(e)k ekarpen berria bidali du
#{$a->id} {$a->subject}
---------------------------------------------------------------------

{$a->message}

* Hizkuntza: {$a->language}
* Osagaiak: {$a->components}
* Kateak: {$a->strings}

---------------------------------------------------------------------
Ekarpenaren orria: {$a->contriburl}';
$string['contribreject'] = 'Errefusatu';
$string['contribresign'] = 'Kendu esleipena';
$string['contribstaged'] = 'Lan-eremuan {$a->author} laguntzailearen <a href="contrib.php?id={$a->id}">#{$a->id}</a> ekarpena dago';
$string['contribstagedinfo'] = 'Lan-eremuko ekarpena';
$string['contribstagedinfo_help'] = 'Lan-eremuan dauden kateak komunitateko kide batek egindako ekarpen batekoak dira. Hizkuntza-paketeko arduradun batek hauek berrikusi beharko lituzke eta Onartua (onartuak badira) edo Errefusatua (arrazoiren bat dela eta hizkuntza-paketea ofizialean gehitu ezin badira) egoera ezarri.';
$string['contribstagedinfo_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstartreview'] = 'Hasi berrikusketa';
$string['contribstatus'] = 'Egoera';
$string['contribstatus0'] = 'Berria';
$string['contribstatus10'] = 'Berrikusten';
$string['contribstatus20'] = 'Errefusatua';
$string['contribstatus30'] = 'Onartua';
$string['contribstatus_help'] = 'Ekarpen baten lan-fluxuak hurrengo egoerak ditu:

* Berria - ekarpena bidali da baina oraindik ez da berrikusi
* Berrikusten - ekarpenari hizkuntza-paketeko arduraduna esleitu zaio eta hau ekarpena berrikusten ari da.
* Errefusatua - hizkuntza-paketeko arduradun batek ekarpena errefusatu du, eta ziur aski arrazoia azaltzen duen iruzkin bat utzi du
* Onartua - hizkuntza-paketeko arduradun batek ekarpena onartu du';
$string['contribstatus_link'] = 'AMOS#Contributing_to_a_language_pack';
$string['contribstrings'] = 'Kateak';
$string['contribstringseq'] = '{$a->orig} berri';
$string['contribstringsnone'] = '{$a->orig} (dagoeneko kate horiek guztiak hizkuntza-paketean daude)';
$string['contribstringssome'] = '{$a->orig} (Horietatik {$a->same} katek itzulpen berriago bat daukate jada)';
$string['contribsubject'] = 'Gaia';
$string['contribsubmittednone'] = 'Ez dago bidalitako ekarpenik';
$string['contribsubmittedsome'] = 'Zure ekarpenak: ({$a})';
$string['contribtimemodified'] = 'Aldatuta';
$string['contribute'] = 'Lagundu';
$string['contributenow'] = 'Lagundu orain!';
$string['contributestats'] = 'Denera <strong>{$a->count}</strong> kate itzuli eta bidali dituzte komunitateko kideek AMOS atarira orain arte';
$string['contributethanks'] = 'Eskerrik asko {$a->listcontributors} kideei egindako azken ekarpenengatik!';
$string['contributethankslist'] = '{$a->contributor1}, {$a->contributor2}, {$a->contributor3} eta {$a->contributor4}';
$string['contributions'] = 'Ekarpenak';
$string['creditsaddcontributor'] = 'Gehitu laguntzailea';
$string['creditsaddmaintainer'] = 'Gehitu arduraduna';
$string['creditscontact'] = 'Bidali mezua';
$string['creditscontributors'] = 'Beste laguntzaile batzuk';
$string['creditsdelcontributor'] = 'Kendu laguntzailea';
$string['creditsdelmaintainer'] = 'Kendu arduraduna';
$string['creditsmaintainedby'] = 'Arduraduna:';
$string['creditsnomaintainer'] = 'Une honetan ez dago arduradunik. <a href="{$a->url}">Izan izaitez zu!</a>';
$string['creditsthanks'] = 'Orri honetan Moodleko itzulpenari ekarpenak egin dituzten kide guztiei eskerrak eman nahi dizkiegu. Euren lanak Moodle munduan zehar hedatzea posible egin dute.';
$string['creditstitlelong'] = 'Hizkuntza-paketearen arduradunak eta laguntzaileak';
$string['creditstitleshort'] = 'Kredituak';
$string['diff'] = 'Alderatu';
$string['diffstringmode'] = 'Aldatu ezberdintasunak erakusteko modua';
$string['err_exception'] = 'Errorea: {$a}';
$string['err_invalidlangcode'] = 'Hizkuntza-kode baliogabea';
$string['err_parser'] = 'Aztertze-errorea: {$a}';
$string['filtercmp'] = 'Osagaiak';
$string['filtercmp_desc'] = 'Erakutsi osagai hauetako kateak';
$string['filtercmpnothingselected'] = 'Aukeratu osagairen bat, mesedez';
$string['filterlng'] = 'Hizkuntzak';
$string['filterlng_desc'] = 'Erakutsi itzulpenak hizkuntza hauetan';
$string['filterlngnothingselected'] = 'Aukeratu hizkuntzaren bat, mesedez';
$string['filtermis'] = 'Denetarik';
$string['filtermis_desc'] = 'Erakutsi beharreko kateentzako baldintza gehigarriak';
$string['filtermisfapp'] = 'Moodle Aplikazioak erabiltzen dituen kateak soilik';
$string['filtermisfapp_help'] = 'Kate hau Moodle Aplikazioan {$a} gisa erabiltzen da';
$string['filtermisfhas'] = 'itzulitako kateak soilik';
$string['filtermisfhlp'] = 'laguntza-kateak soilik';
$string['filtermisfmis'] = 'falta diren edo zaharkitutako kateak soilik';
$string['filtermisfout'] = 'zaharkitutako kateak soilik';
$string['filtermisfstg'] = 'lan-eremuan dauden kateak soilik';
$string['filtermisfworkplace'] = 'soilik Moodle Workplace-n erabilitako kateak';
$string['filtermisfworkplace_help'] = 'Kate hau Moodle Workplace-n {$a} gisa erabiltzen da';
$string['filtersid'] = 'Kate-identifikatzailea';
$string['filtersid_desc'] = 'Kateen kateko giltza';
$string['filtersidpartial'] = 'bat-etortze partziala';
$string['filtertxt'] = 'Azpikatea';
$string['filtertxt_desc'] = 'Kateak emandako testua izan behar du';
$string['filtertxtcasesensitive'] = 'ezberdindu maiuskula eta minuskulak';
$string['filtertxteng'] = 'ingelesezko kateetan';
$string['filtertxtregex'] = 'adierazpen erregularra';
$string['filtertxttra'] = 'itzulitako kateetan';
$string['filterver'] = 'Bertsioa';
$string['filterver_desc'] = 'Erakutsi Moodleren bertsio honetako kateak';
$string['filtervernothingselected'] = 'Aukeratu ezazu bertsioren bat';
$string['foundmissing'] = '{$a} falta dira';
$string['foundmissingonthispage'] = '{$a} orri honetan';
$string['foundtotal'] = '{$a} aurkitu dira';
$string['googletranslate'] = 'galdetu Google-ri';
$string['importfile'] = 'Inportatu itzulitako kateak fitxategi batetik';
$string['importfile_help'] = 'Zure kateak lineaz kanpo itzuli badituzu, formulario honen bitartez lan-eremura kopiatu ditzakezu.

* Fitxategia Moodleko kateen definiziorako PHP fitxategi baliagarria izan behar da. Ikusi zure Moodle instalazioko `/lang/en/`direktorioa adibideak aurkitzeko.
* Fitxategiaren izena osagaiaren ingelesezko kateen definiziorako izenarekin bat etorri zehar da (esaterako`moodle.php`, `assignment.php` edo `enrol_manual.php`).

Fitxategian aurkitzen diren kate guztiak lan-eremuan aukeratutako bertsio eta hizkuntzan kopiatuko dira.

PHP fitxategi anitz batera prozesatu daitezke horiek ZIP fitxategi batean sartuz gero.';
$string['importfile_link'] = 'local/amos/importfile';
$string['language'] = 'Hizkuntza';
$string['languagepacks'] = 'Zure Moodle gunean hizkuntza-pakete gehigarriak instalatu daitezke <em>Gunearen Kudeaketa > Hizkuntza > Hizkuntza-paketeak</em> bidez edo eskuz. Xehetasun gehiagorako, ikusi <a href="https://docs.moodle.org/en/Language_packs">Hizkuntza-paketeen dokumentazioa (ingelesez)</a>.';
$string['languages'] = 'Hizkuntzak';
$string['languagesall'] = 'Guztiak';
$string['languagesnone'] = 'Bat ere ez';
$string['lastavailable'] = 'Eskuragarri dagoen azken bertsioa';
$string['lessfilteringoptions'] = 'Aukera gutxiago';
$string['log'] = 'Erregistroa';
$string['logfilterbranch'] = 'Bertsioak';
$string['logfiltercommithash'] = 'git hash-a';
$string['logfiltercommitmsg'] = 'Onarpen-mezuaren edukia';
$string['logfiltercommits'] = 'Onarpen-iragazkia';
$string['logfiltercommittedafter'] = 'Honen ondoren onartutakoak';
$string['logfiltercommittedbefore'] = 'Honen aurretik onartutakoak';
$string['logfiltercomponent'] = 'Osagaiak';
$string['logfilterlang'] = 'Hizkuntzak';
$string['logfiltershow'] = 'Erakutsi iragazitako onarpenak eta kateak';
$string['logfiltersource'] = 'Jatorria';
$string['logfiltersourceamos'] = 'amos (web bidezko itzultzailea)';
$string['logfiltersourceautomerge'] = 'automatikoki batua (itzulpena beste adar batetik kopiatuta)';
$string['logfiltersourcebot'] = 'bot (script batek exekutatutako eragiketa masiboak)';
$string['logfiltersourcecommitscript'] = 'commitscript (onarpen-mezuan AMOScript agertzen da)';
$string['logfiltersourcefixdrift'] = 'fixdrift (konpondutako AMOS-git multzoa)';
$string['logfiltersourcegit'] = 'git (Moodleko iturburu-kodearen eta 1.x paketeen git mirror-a)';
$string['logfiltersourceimport'] = 'inportatua (plugin ezestandar baterako inportatutako kateak)';
$string['logfiltersourcerevclean'] = 'revclean (atzeranzko garbiketa prozesua)';
$string['logfilterstringid'] = 'Kate-identifikatzailea';
$string['logfilterstrings'] = 'Kateen iragazkia';
$string['logfilterusergrp'] = 'Onartzailea';
$string['logfilterusergrpor'] = 'edo';
$string['maintainers'] = 'Arduradunak';
$string['manageamos'] = 'Kudeatu AMOS';
$string['markuptodate'] = 'Itzulpena eguneratutzat markatzen';
$string['markuptodatelabel'] = 'markatu eguneratutzat';
$string['messageprovider:checker'] = 'Hizkuntza-paketearen egiaztatzearen emaitzak';
$string['messageprovider:contribution'] = 'Laguntzaileen ekarpenak';
$string['morefilteringoptions'] = 'Aukera gehiago';
$string['newlanguage'] = 'Hizkuntza berria';
$string['nodiffs'] = 'Ez da ezberdintasunik aurkitu';
$string['nofiletoimport'] = 'Mesedez, eman inportatzeko fitxategia';
$string['nologsfound'] = 'Ez da katerik aurkitu, mesedez aldatu itzazu iragazkiak';
$string['nostringsfound'] = 'Ez da katerik aurkitu';
$string['nostringtoimport'] = 'Fitxategian ez da kate baliagarririk aurkitu. Egiaztatu ezazu fitxategiak izen egokia eta behar den formatua dituela.';
$string['nothingtostage'] = 'Eragiketak ez du itzuli lan-eremuan sartu daitekeen katerik.';
$string['novalidzip'] = 'Ezin izan da ZIP fitxategia erauzi.';
$string['numofcommitsabovelimit'] = 'Onarpen-iragazkiarekin bat datozen {$a->found} onarpen aurkitu dira, {$a->limit} berrienak erabiliko dira';
$string['numofcommitsunderlimit'] = 'Onarpen-iragazkiarekin bat datozen {$a->found} onarpen aurkitu dira';
$string['numofmatchingstrings'] = 'Horietatik, {$a->commits} onarpenetako {$a->strings} aldaketa kateen iragazkiarekin bat datoz.';
$string['outdatednotcommitted'] = 'Zaharkitutako katea';
$string['outdatednotcommitted_help'] = 'AMOSek katea zaharkituta egon daitekeela antzeman du ingelesezko bertsioa itzulpenaren ondoren aldatu delako. Itzulpena berrikusi ezazu, mesedez.';
$string['outdatednotcommittedwarning'] = 'Zaharkituta';
$string['ownstashactions'] = 'Bilduma pribatuetako ekintzak';
$string['ownstashactions_help'] = '* Aplikatu - kopiatu bilduma pribatuko kateak lan-eremura eta utzi bilduma pribatua dagoen moduan. Lan-eremuan dagoeneko kateren bat bazegoen, bilduma pribatukoarekin gainidatziko da.
* Ekarri - mugitu bilduma pribatuko kateak lan-eremura eta ezabatu bilduma pribatua (Aplikatu eta Ezabatu egitea da)
* Ezabatu - bilduma pribatu bat eta bertako kateak ezabatzen dira
* Bidali - formulario bat irekitzen du bilduma pribatua hizkuntza-paketearen arduradun ofizialari zure ekarpena hizkuntza-paketean sartzeko eskaera egiteko.';
$string['ownstashes'] = 'Zure bilduma pribatuak';
$string['ownstashes_help'] = 'Hau zure bilduma pribatuen zerrenda bat da';
$string['ownstashesnone'] = 'Ez da bilduma pribaturik aurkitu';
$string['permalink'] = 'Lotura iraunkorra';
$string['placeholder'] = 'Gakoak';
$string['placeholder_help'] = 'Gakoak kate barruko adierazpen bereziak dira, `{$a}` edo `{$a->zerbait}` bezalakoak. Katea inprimatzen denean balio batekin ordezkatzen dira.

Garrantzitsua da jatorrizko katean dauden moduan kopiatzea. Ez itzazu itzuli edo aldatu.';
$string['placeholderwarning'] = 'Kateak gakoren bat dauka';
$string['pluginclasscore'] = 'Sistemako azpisistemak';
$string['pluginclassnonstandard'] = 'Plugin ez-estandarrak';
$string['pluginclassstandard'] = 'Plugin estandarrak';
$string['pluginname'] = 'AMOS';
$string['plugintypelocations'] = 'Plugin-mota kokapenak';
$string['plugintypelocations_desc'] = 'Plugin-mota estandar gehigarrien kokapenak zehazteko aukera ematen du, hala nola plugin estandarren azpi-plugin motak edo zaharkitutako motak.';
$string['presetcommitmessage'] = '{$a->author} laguntzailearen #{$a->id} ekarpena';
$string['presetcommitmessage2'] = 'Falta ziren kateak {$a->source} adarretik {$a->target} adarrera batu dira';
$string['presetcommitmessage3'] = '{$a->versiona} eta {$a->versionb} arteko ezberdintasunak konpontzen';
$string['privacy:commitnumber'] = '{$a}. onarpena';
$string['privacy:contribnumber'] = '{$a} Ekarpena';
$string['privacy:filterusage'] = 'Iragazkiaren erabilera';
$string['privacy:metadata:db:amoscommits'] = 'Onarpenarekin lotutako metadatu guztiak gordetzen ditu.';
$string['privacy:metadata:db:amoscommits:commitmsg'] = 'Erabiltzaileak emandako onarpen mezua';
$string['privacy:metadata:db:amoscommits:timecommitted'] = 'Onarpenaren unea.';
$string['privacy:metadata:db:amoscommits:userinfo'] = 'Erabiltzailearen identifikazioa onarpenaren iturrian (Git-en adibidez) eman zuen moduan.';
$string['privacy:metadata:db:amoscontributions'] = 'Komunitateko kideek egindako itzulpen-ekarpenak';
$string['privacy:metadata:db:amoscontributions:lang'] = 'Ekarpen honi dagokion hizkuntzaren kodea.';
$string['privacy:metadata:db:amoscontributions:message'] = 'Bidalketa deskribatzeko hasierako mezua.';
$string['privacy:metadata:db:amoscontributions:stashid'] = 'Lotutako bilduma pribatuaren barne-identifikatzailea.';
$string['privacy:metadata:db:amoscontributions:status'] = 'Ekarpenaren lan-fluxuaren egoera.';
$string['privacy:metadata:db:amoscontributions:subject'] = 'Ekarpenaren bidalketaren gaia.';
$string['privacy:metadata:db:amoscontributions:timecreated'] = 'Ekarpen-erregistroa sortu zeneko unea.';
$string['privacy:metadata:db:amoscontributions:timemodified'] = 'Ekarpen-erregistroa azkenengoz aldatu zeneko unea.';
$string['privacy:metadata:db:amosfilterusage'] = 'AMOS itzultzailearen iragazkiaren erregistroa.';
$string['privacy:metadata:db:amosfilterusage:currentlang'] = 'Unean uneko saioaren hizkuntza.';
$string['privacy:metadata:db:amosfilterusage:ismaintainer'] = 'Erabiltzaileak baimena dauka AMOS biltegian onarpenak egiteko?';
$string['privacy:metadata:db:amosfilterusage:numofcomponents'] = 'Aukeratutako osagai kopurua';
$string['privacy:metadata:db:amosfilterusage:numoflanguages'] = 'Aukeratutako hizkuntza kopurua';
$string['privacy:metadata:db:amosfilterusage:numofversions'] = 'Aukeratutako bertsio kopurua';
$string['privacy:metadata:db:amosfilterusage:showexistingonly'] = 'Itzulitako kateak baino ez dira erakutsi behar?';
$string['privacy:metadata:db:amosfilterusage:showgreylistedonly'] = 'Zerrenda grisean dauden kateak baino ez dira erakutsi behar?';
$string['privacy:metadata:db:amosfilterusage:showhelpsonly'] = 'Laguntza-kateak baino ez dira erakutsi behar?';
$string['privacy:metadata:db:amosfilterusage:showmissingonly'] = 'Falta diren edo zaharkituta dauden kateak baino ez dira erakutsi behar?';
$string['privacy:metadata:db:amosfilterusage:showoutdatedonly'] = 'Zaharkituta dauden kateak baino ez dira erakutsi behar?';
$string['privacy:metadata:db:amosfilterusage:showstagedonly'] = 'Lan-eremuan dauden kateak baino ez dira erakutsi behar?';
$string['privacy:metadata:db:amosfilterusage:showwithoutgreylisted'] = 'Zerrenda grisean dauden kateak emaitzetatik kendu behar dira?';
$string['privacy:metadata:db:amosfilterusage:stringidpartial'] = 'Kate-identifikatzaileen bat-etortze partzialak onartzen dira?';
$string['privacy:metadata:db:amosfilterusage:substringcasesensitive'] = 'Azpikatean maiuskulak eta minuskulak ezberdindu behar dira?';
$string['privacy:metadata:db:amosfilterusage:substringregex'] = 'Azpikatea adierazpen erregulartzat hartu behar da?';
$string['privacy:metadata:db:amosfilterusage:timesubmitted'] = 'Iragazki-formularioa bidali zeneko unea';
$string['privacy:metadata:db:amosfilterusage:usercountry'] = 'Erabiltzailearen herrialde-kodea, bere profilean aukeratutakoaren arabera.';
$string['privacy:metadata:db:amosfilterusage:userlang'] = 'Erabiltzailearen hizkuntza lehenetsia, bere profiletik.';
$string['privacy:metadata:db:amosfilterusage:usesdefaultlang'] = 'Erabiltzaileak aurre-aukeratutako hizkuntza erabili du?';
$string['privacy:metadata:db:amosfilterusage:usesdefaultversion'] = 'Erabiltzaileak aurre-aukeratutako bertsioa erabili du?';
$string['privacy:metadata:db:amosfilterusage:withstringid'] = 'Kate-identifikatzailea zehaztu da?';
$string['privacy:metadata:db:amosfilterusage:withsubstring'] = 'Bilaketan azpikatea zehaztu da?';
$string['privacy:metadata:db:amospreferences'] = 'Erabiltzailearen AMOSeko hobespenak.';
$string['privacy:metadata:db:amospreferences:name'] = 'Hobetsitako izena';
$string['privacy:metadata:db:amospreferences:value'] = 'Hobetsitako balioa';
$string['privacy:metadata:db:amosstashes'] = 'Bilduma pribatuaren informazioa gordetzen du bilduma pribatuaren gordailuan';
$string['privacy:metadata:db:amosstashes:components'] = 'Bilduma pribatuan gordetzen diren osagaien zerrenda';
$string['privacy:metadata:db:amosstashes:id'] = 'Bilduma pribatuaren barne-identifikatzailea.';
$string['privacy:metadata:db:amosstashes:languages'] = 'Bilduma pribatuaren lan-eremuan dauden hizkuntzen zerrenda';
$string['privacy:metadata:db:amosstashes:message'] = 'Bilduma pribatua deskribatzen duen mezu osoa, onarpen-mezu lehenetsi gisa erabiltzen dena bilduma pribatua ekarpen gisa bidaltzen denean.';
$string['privacy:metadata:db:amosstashes:name'] = 'Bildumaren izena edo izenburua';
$string['privacy:metadata:db:amosstashes:strings'] = 'Bilduma pribatuaren izenburua';
$string['privacy:metadata:db:amosstashes:timecreated'] = 'Bilduma pribatua sortu zeneko unea';
$string['privacy:metadata:db:amosstashes:timemodified'] = 'Erregistroa azkenengo aldiz  aldatu zeneko unea';
$string['privacy:metadata:db:amostranslators'] = 'Hizkuntza-paketearen eta erabiltzailearen arteko erlazioa zehazten du. Hau arduradun bat izan daiteke (hizkuntza-paketean onarpenak egiteko baimenak ditu) edo laguntzailea (kredituetan erakusten da bidalitako ekarpenak ez baditu ere).';
$string['privacy:metadata:db:amostranslators:lang'] = 'Itzultzaileak itzultzeko baimenak dituen hizkuntzaren kodea, edo izartxoa hizkuntza guztietarako.';
$string['privacy:metadata:db:amostranslators:status'] = 'Erabiltzailea hizkuntza-paketearen arduraduna (0) edo laguntzailea (1) den zehazten du.';
$string['privacy:metadata:external:languagepacks'] = 'Ekarpenetan egindako itzulpenak ZIP fitxategietara esportatzen dira eta mundu mailan banatu eta Moodle guneetan instalatzen dira.';
$string['privacy:metadata:external:languagepacks:email'] = 'Laguntzaileen helbide elektronikoa hizkuntza-paketearen fitxategietan gehitu daiteke.';
$string['privacy:metadata:external:languagepacks:firstname'] = 'Laguntzaileen izena hizkuntza-paketearen fitxategietan gehitu daiteke.';
$string['privacy:metadata:external:languagepacks:lastname'] = 'Laguntzaileen abizena hizkuntza-paketearen fitxategietan gehitu daiteke.';
$string['privacy:metadata:subsystem:comment'] = 'Pluginak iruzkinen azpisistema nola erabiltzen duen deskribatzen du.';
$string['privacy:stashnumber'] = '{$a} bilduma pribatua';
$string['privileges'] = 'Zure baimenak';
$string['privilegesnone'] = 'Informazio publikora soilik-irakurtzeko (read-only) sarbidea duzu.';
$string['processing'] = 'Prozesatzen...';
$string['quicklinks'] = 'Esteka azkarrak';
$string['quicklinks_amos'] = 'AMOS itzultzailea';
$string['quicklinks_forum'] = 'Itzulpenaren foroa';
$string['quicklinks_manual'] = 'Erabiltzailearen gidaliburua';
$string['quicklinks_newcomers'] = 'Partaide berrientzako laguntza';
$string['requestactions'] = 'Ekintza';
$string['requestactions_help'] = '* Aplikatu - kopiatu ekarpen-proposameneko kateak lan-eremura. Lan-eremuan dagoeneko kateren bat bazegoen, ekarpenean dagoenarekin gainidatziko da.
* Ezkutatu - ekarpen-eskaera blokeatzen du zuk berriz ere ez ikusteko.';
$string['savefilter'] = 'Erakutsi kateak';
$string['script'] = 'AMOScript';
$string['script_help'] = 'AMOScript kateen biltegian exekutatzeko eragiketa-multzo bat da.';
$string['scriptexecute'] = 'Exekutatu eta emaitza lan-eremura eraman';
$string['sourceversion'] = 'Jatorrizko bertsioa';
$string['stage'] = 'Lan-eremua';
$string['stageactions'] = 'Lan-eremuko ekintzak';
$string['stageactions_help'] = '* Editatu lan-eremuan dauden kateak - itzultzaileko iragazki-ezarpena aldatzen ditu soilik lan-eremuko itzulpenak erakusteko.
* Kimatu onartu ezin diren kateak - ezabatu lan-eremutik onartu ezin diren itzulpen guztiak. Onartu aurretik lan-eremua automatikoki kimatzen da.
* Eguneratu - ezabatu lan-eremutik oraingo itzulpena aldatzen ez duten itzulpenak edota biltegiko oraingo itzulpena baino zaharragoak direnak. Onartu aurretik lan-eremua automatikoki eguneratzen da.
* Baztertu guztiak - hustu lan-eremua, bertako itzulpen guztiak galtzen direlarik.';
$string['stagedownload'] = 'Jaitsi';
$string['stageedit'] = 'Editatu lan-eremuan dauden kateak';
$string['stageprune'] = 'Kimatu onartu ezin direnak';
$string['stagerebase'] = 'Eguneratu';
$string['stagestringsnocommit'] = 'Lan-eremuan {$a->staged} kate dago';
$string['stagestringsnone'] = 'Lan-eremuan ez dago katerik';
$string['stagestringssome'] = 'Lan-eremuan {$a->staged} kate dago, horietatik {$a->committable} onar daitezke';
$string['stagesubmit'] = 'Bidali kateak hizkuntza-paketearen arduradunei';
$string['stagetoolopen'] = 'Joan lan-eremura';
$string['stagetranslation'] = 'Itzulpena';
$string['stagetranslation_help'] = 'Onartuko den lan-eremuko itzulpena erakusten du. Gelaxkaren atzeko planoaren kolorearen esanahia hurrengoa da:

* Berdea - falta zen itzulpen bat gehitu duzu eta onartzeko baimenak dituzu
* Horia - itzulpen bat aldatu duzu eta aldaketa onartzeko baimenak dituzu.
* Urdina - itzulpena aldatu edo gehitu duzu baina ez duzu hizkuntza horretan aldaketa onartzeko baimenik.
* Kolorerik ez - lan-eremuko itzulpena oraingoaren berdina da eta beraz ez da onartuko.';
$string['stageunstageall'] = 'Baztertu guztiak';
$string['standardcomponents'] = 'Osagai estandarren zerrenda';
$string['standardcomponents_desc'] = 'Moodleko osagai estandarren zerrenda. Hautazko zenbakiak osagai hau estandarra deneko lehen bertsioaren kodea adierazten du. Zenbakia negatiboa bada, osagaia estandarra izan zeneko azken bertsioaren kodea adierazten du. Bi zenbakiak batera agertu daitezke. Adibidez:

* `mod_workshop` - bertsiorik gabe, osagai hau bertsio guztietan estandarra dela adierazten du
* `report_infectedfiles 310` - osagaia Moodle 3.10 bertsiotik aurrera estandarra dela adierazten du
* `theme_clean 25 -36` - osagaia Moodle 2.5 bertsiotik 3.6 bertsiora arte estandarra izan zen, biak barne';
$string['stashactions'] = 'Gorde egiten ari zaren lana';
$string['stashactions_help'] = 'Bilduma pribatu bat lan-eremuko kateen egoeraren "argazki" bat da. Bilduma pribatu bat hizkuntza-paketearen arduradun ofizialari bidali ahal zaio hizkuntza-paketean sartu dezan.';
$string['stashapply'] = 'Aplikatu';
$string['stashautosave'] = 'Automatikoki gordetako bilduma pribatua (segurtasun-kopia)';
$string['stashautosave_help'] = 'Bilduma pribatu honek zure lan-eremuko kateen azken "argazkia" dauka. Segurtasun-kopia gisa erabili dezakezu istripuz lan-eremuko kate guztiak ezabatzen badira, adibidez. Erabili \'Aplikatu\' ekintza bildumako kate guztiak lan-eremura pasatzeko (lan-eremuan dagoeneko kateren bat bazegoen gainidatziko da).';
$string['stashcomponents'] = '<span>Osagaiak:</span> {$a}';
$string['stashdownload'] = 'Jaitsi';
$string['stashdrop'] = 'Ezabatu';
$string['stashdropconfirm'] = 'Ziur zaude gordetako <em>\'{$a}\'</em> bilduma behin betiko ezabatu nahi duzula?';
$string['stashes'] = 'Bilduma pribatuak';
$string['stashlanguages'] = '<span>Hizkuntzak:</span> {$a}';
$string['stashpop'] = 'Ekarri';
$string['stashpush'] = 'Sortu bilduma pribatu berria lan-eremuan dauden kate guztiekin';
$string['stashstrings'] = '<span>Kate kopurua:</span> {$a}';
$string['stashsubmit'] = 'Bidali arduradunei';
$string['stashsubmitdetails'] = 'Bidalketaren xehetasunak';
$string['stashsubmitmessage'] = 'Mezua';
$string['stashsubmitsubject'] = 'Gaia';
$string['stashtitle'] = 'Bilduma pribatuaren izenburua';
$string['stashtitledefault'] = 'Lanean - {$a->time}';
$string['stdvernotebetween'] = 'Estandarra {$a->from} bertsiotik {$a->to} bertsiora arte (biak barne)';
$string['stdvernotefrom'] = 'Estandarra {$a->from} bertsiotik';
$string['stdvernoteto'] = 'Estandarra {$a->to} bertsiora arte';
$string['stringhistory'] = 'historia';
$string['strings'] = 'Kateak';
$string['stringversionnotlatest'] = 'bertsio berriago bat existitzen da';
$string['submitting'] = 'Ekarpena bidaltzen';
$string['submitting_help'] = 'Honek itzulitako kateak hizkuntzaren arduradun ofizialei bidaliko die. Eurek zure lana euren lan-eremura eraman, berrikusi eta azkenik onartuko dute. Mesedez mezu bat idatzi ezazu zure lana deskribatuz eta zure ekarpena zergatik onartu beharko litzatekeen azalduz.';
$string['targetversion'] = 'Helburuko bertsioa';
$string['timeline'] = 'Katearen denbora-lerroa';
$string['timelineheading'] = 'Katearen denbora-lerroa: {$a->component} | {$a->strname}';
$string['translatortool'] = 'Itzultzailea';
$string['translatortoolopen'] = 'Ireki AMOS itzultzailea';
$string['translatortranslation'] = 'Itzulpena';
$string['translatortranslation_help'] = 'Gelaxkan klik egin ezazu testua idazteko editorea gaitzeko. Itzulpena idatzi ezazu eta ondoren gelaxkatik kanpo klik egin ezazu itzulpena zure lan-eremuan gordetzeko. Gelaxkaren atzeko planoaren kolorearen esanahia hurrengoa da:

* Berdea - katea dagoeneko itzulita, itzulpena aldatu dezakezu.
* Horia - katea zaharkituta egon daiteke. Ziurrenik ingelesezko katea itzulpena egin ondoren aldatu egin da.
* Gorria - katea oraindik itzuli gabe dago.
* Urdina - katea aldatu duzu eta orain lan-eremuan dago.
* Grisa - kate hau itzultzeko ezin da AMOS erabili. Moodle 1.9-ko kateak adibidez zaharkitutako CVS sistemaren bidez baino ezin dira editatu.

Hizkuntza-paketeko arduradunek ikur gorri txiki bat ikusi dezakete onartu ditzaketen gelaxken ertzean.';
$string['typecontrib'] = 'Plugin gehigarriak';
$string['typecontribbadge'] = 'Gehigarria';
$string['typecore'] = 'Sistemako azpisistemak';
$string['typecorebadge'] = 'Sistema';
$string['typestandard'] = 'Plugin estandarrak';
$string['typestandardbadge'] = 'Estandarra';
$string['unableenfixaddon'] = 'Ingelesezko konponketak plugin estandarretan baino ez dira onartzen.';
$string['unableenfixcountries'] = 'Herrialde-izenak ISO 3166-1-etik kopiatu dira';
$string['unablelangconfig'] = 'Ez duzu hizkuntza-paketearen konfigurazioa editatzeko baimenik';
$string['unableunmaintained'] = 'Une honetan \'{$a}\' hizkuntza-paketeak ez dauka arduradunik, eta ondorioz egindako ekarpenak ezin dira onartu. Mesedez hausnartu ezazu \'{$a}\' hizkuntzako paketearen arduraduna izateko zure burua eskaini nahi duzun.';
$string['unstage'] = 'baztertu';
$string['unstageconfirm'] = 'Baieztatu baztertzea';
$string['unstageconfirmlong'] = '<p><code>{$a->language}</code> hizkuntza-paketeko <code>{$a->component}</code> osagaiaren <code>{$a->stringid}</code> katearen itzulpena baztertzera zoaz.</p><p>Ziur zaude?</p>';
$string['unstaging'] = 'Baztertzen';
$string['untranslate'] = 'ezabatu itzulpena';
$string['untranslateconfirm'] = '<p><code>{$a->component}</code> osagaiaren <code>{$a->stringid}</code> katearen itzulpena ezabatzera zoaz <code>{$a->language}</code> hizkuntza-paketeko <code>{$a->since}</code> bertsiotik goragoko guztietatik.</p><p>Ziur zaude?</p>';
$string['untranslatetitle'] = 'Itzulpena hizkuntza-paketetik kentzen';
$string['untranslating'] = 'Itzulpena ezabatzen';
$string['userdefaultreset'] = 'Berrabiarazi nire lehenetsitakora';
$string['userdefaultsave'] = 'Gorde nire lehenetsitako gisa';
$string['version'] = 'Bertsioa';
