<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'minilesson', language 'eu', version '4.4'.
 *
 * @package     minilesson
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['achievedhighscoreof'] = '{$a}k puntuazio altua lortu du';
$string['action'] = 'Ekintza';
$string['actions'] = 'Ekintzak';
$string['activitydate:submissionsdue'] = 'Epea:';
$string['activitydate:submissionsopen'] = 'Ireki:';
$string['activitydate:submissionsopened'] = 'Irekiak:';
$string['activityisclosed'] = 'Jarduera hau itxita dago.';
$string['activityisnotopenyet'] = 'Jarduera hau ez dago, jada, zabalik.';
$string['activitylink'] = 'Esteka hurrengo jarduerara';
$string['activitylink_help'] = 'Ikastaroan beste jarduera bat egiten saiatu ondoren  esteka bat eskaintzeko, aukeratu jarduera zerrenda zbalgarrian.';
$string['activitylinkname'] = 'Jarraitu hurrengo jarduerara {$a}';
$string['activityname'] = 'Ikasgaiaren Izena.';
$string['activityopenscloses'] = 'Jarduera ixteko/irekitzeko datak';
$string['addaudiostory'] = 'Audio Istorioa';
$string['addaudiostory_instructions'] = 'Audio-istorio bat sortzeko, gehitu audio-fitxategi bat, izen numerikoak dituzten irudi-fitxategiak (adibidez, 1.png, 2.jpg) eta aukerako azpititulu-pista bat (.vtt fitxategia). Ezarri irudien sarrera-ordua (HH:MM:SS formatua) testu-eremuan.';
$string['addcomprehensionquizitem'] = 'Ulermen-galdetegia';
$string['addconversationitem'] = 'Elkarrizketa';
$string['adddictationchatitem'] = 'Diktaketa-txata';
$string['adddictationitem'] = 'Diktaketa';
$string['addfluencyitem'] = 'Jariotasuna';
$string['addfreespeakingitem'] = 'Mintzamen Askea';
$string['addfreewritingitem'] = 'Idazmen Askea';
$string['addiframe'] = 'Gehitu iFramea';
$string['addiframe_instructions'] = 'Itsatsi ikasgai-elementuan erakutsi nahi duzun iframearen txertatze-kodea.';
$string['addingitem'] = 'Gehitu ikasgai-elementu berria';
$string['additems'] = 'Gehitu elementuak';
$string['addlisteninggapfillitem'] = 'Entzuteko Hutsuneak bete';
$string['addlistenrepeatitem'] = 'Entzun eta Hitz egin';
$string['addmedia'] = 'Gehitu media';
$string['addmedia_instructions'] = 'Aukeratu ikasgaiaren elementuan erakutsi nahi duzun multimedia mota.';
$string['addmultiaudioitem'] = 'MC Audio';
$string['addmultichoiceitem'] = 'Aukera Anitzekoa';
$string['addnewitem'] = 'Gehitu Ikasgai-elementu berria';
$string['addpageitem'] = 'Eduki-orria';
$string['addpassagegapfillitem'] = 'Hutsuneak Betetzeko Pasartea';
$string['addpassagereadingitem'] = 'Pasartearen Irakurketa';
$string['addshortansweritem'] = 'Erantzun laburra';
$string['addspeakinggapfillitem'] = 'Hitz egiteko Hutsuneak bete';
$string['addspeechcardsitem'] = 'Hitz egiteko Txartelak';
$string['addtextarea'] = 'Gehitu Testu Blokea';
$string['addtextarea_instructions'] = 'Sartu ikasgaiaren elementuan erakutsi nahi duzun testua.';
$string['addtomywords'] = 'Egin klik Nire Hitzetan gehitzeko';
$string['addttsaudio'] = 'Gehitu TTS Audioa';
$string['addttsaudio_instructions'] = 'Sartu TTS motorrak esango duen testua.';
$string['addttsdialog'] = 'Gehitu TTS Elkarrizketa';
$string['addttsdialog_instructions'] = 'Gehitu TTS elkarrizketa';
$string['addttspassage'] = 'Gehitu TTS Pasartea';
$string['addttspassage_instructions'] = 'Aukeratu hizlariaren ahotsa eta abiadura, eta idatzi irakurri beharreko pasartea.';
$string['addtypinggapfillitem'] = 'Hutsuneak bete Idazten';
$string['addyoutubeclip'] = 'Gehitu YouTube Klipa';
$string['addyoutubeclip_instructions'] = 'Sartu ikasgai-elementuan erakutsi nahi duzun kliparen Youtube/Vimeo bideoaren IDa eta hasiera eta amaiera orduak.';
$string['adjustedgrade_p'] = 'Adj. Kalifikazioa(%)';
$string['advanced'] = 'Aurreratua';
$string['aigrade_feedback'] = 'Feedback-argibideak AArentzat';
$string['aigrade_feedback_language'] = 'AAren feedback hizkuntza';
$string['aigrade_instructions'] = 'Kalifikazio Argibideak AArentzat';
$string['aigrade_modelanswer'] = 'Erantzun-eredua';
$string['aliencount_match'] = 'Alien Bikoteen Kopurua (Tiro egin Bikoteei)';
$string['aliencount_mc'] = 'Alien Kopurua (Aukera Anitzak)';
$string['allowmicaccess'] = 'Mesedez, baimendu zure mikrofonorako sarbidea.';
$string['allowretry'] = 'Baimendu berriro saiatzea';
$string['allowretry_desc'] = 'Hautatuta badago, ikasleek saiakera berriak bidali ditzakete aurreko erantzuna zuzena ez bada.';
$string['alternates'] = 'Ordezkoak';
$string['alternatestreaming'] = 'Gaitu ordezko erreprodukzioa';
$string['alternatestreaming_details'] = 'Grabatutako audioa erreproduzitzen du transkripzio irekirako. Arakatzailearen transkripzio lehenetsia baino zertxobait motelagoa da eta ingelesez bakarrik funtzionatzen du. iOS-eko mugikorretarako aplikazioan lehenespenez aktibatuta.';
$string['alternatives'] = 'Alternatibak';
$string['alternatives_descr'] = 'Zehaztu pasarte-hitz zehatzetarako bat datozen aukerak. Hitz multzo 1 lerro bakoitzeko. Ikusi <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">dokumentua</a> xehetasun gehiago lortzeko.';
$string['anim_fancy'] = 'Animazio dotorea';
$string['anim_plain'] = 'Animazio argia';
$string['animations'] = 'Animazioak';
$string['animations_details'] = 'Elementu-azpimoten arteko trantsizioak animatzen dira. Animazio dotoreak arazoak sortzen baditu, aukeratu argia.';
$string['anotherhint'] = 'Beste iradokizun bat';
$string['answer'] = 'Erantzuna';
$string['answerdetails'] = 'Erantzunaren Xehetasunak';
$string['attemptresultsheading'] = '{$a->username}: Saiakera({$a->attemptid}): Puntuazioa: {$a->sessionscore}% : - {$a->date}';
$string['attemptsheading'] = 'Saiakeren txostena';
$string['attemptsperpage'] = 'Orrialdeko erakutsi beharreko saiakerak:';
$string['attemptsreport'] = 'Saikeren txostena';
$string['attemptsreport_explanation'] = 'Saiakeren zerrenda bat';
$string['audioitemfile'] = 'Audio-elementua(MP3)';
$string['audiostoryfiles'] = 'Audio Istorioetako Fitxategiak';
$string['audiostorytimes'] = 'Irudiak Sartzeko Uneak';
$string['autoplay'] = 'Erreprodukzio automatikoa';
$string['avgcorrect'] = 'Batez beste Zuzen';
$string['avgtotaltime'] = 'Batez besteko Iraupena';
$string['awsregion'] = 'AWS Eskualdea';
$string['backtoimport'] = 'Itzuli Inportatu Gora aukerara';
$string['backtotop'] = 'Itzuli ikastaroaren orrira';
$string['basicheading'] = 'OInarrizko Txostena';
$string['basicreport'] = 'Oinarrizko Txostena';
$string['basicreport_explanation'] = 'Oinarrizko Txosten bat';
$string['bulkdelete'] = 'Ezabatu aukeratutakoa';
$string['bulkdeletequestion'] = 'Ziur zaude aukeratutako galdera ezabatu nahi duzula?';
$string['cannotsavecsv'] = 'Ezin da csv fitxategia gorde';
$string['check'] = 'Egiaztatu';
$string['chooselayout'] = 'Aukeratu diseinua';
$string['choosemediaprompt'] = 'Aukeratu euskarri mota...';
$string['choosemultiaudiovoice'] = 'Aukeratu erantzunaren irakurlearen ahotsa';
$string['choosevoice'] = 'Aukeratu prompt-hizlariaren ahotsa';
$string['choosevoiceoption'] = 'TTS prompt-aukerak';
$string['cleartextfirst'] = 'Garbitu eskuz gehitu duzun edukia. Ez da automatikoki ezabatuko.';
$string['compquiz_instructions1'] = 'Ulermen-galdetegiaren instrukzioak';
$string['compquiz_results'] = 'Emaitzak';
$string['comprehensionquiz'] = 'Ulermen-galdetegia';
$string['confirmattemptdelete'] = 'Ziur zaude<i>DELETE</i> nahi duzula saiakera hau?';
$string['confirmattemptdeleteall'] = 'Ziur zaude <i>DELETE ALL</i> nahi dituzula saiakera guztiak?';
$string['confirmattemptdeletealltitle'] = 'Ziur zaude Saiakera GUZTIAK ezabatu nahi dituzula?';
$string['confirmattemptdeletetitle'] = 'Ziur zaude Saiakera ezabatu nahi duzula?';
$string['confirmchoice'] = 'Egiaztatu';
$string['confirmchoice_formlabel'] = 'Saiatu behar duzu (ezin duzu saltatu)';
$string['confirmitemdelete'] = 'Ziur zaude elementu hau <i>DELETE</i>nahi duzula?: {$a}';
$string['confirmitemdeletetitle'] = 'Ziur zaude elementua ezabatu nahi duzula?';
$string['containerwidth'] = 'Ontziaren zabalera';
$string['containerwidth_details'] = 'Minikasgaia jardueraren ontziaren zabalera maximoa ezartzen du.';
$string['containerwidth_help'] = 'Minikasgaia jardueraren ontziaren zabalera maximoa ezartzen du.';
$string['continue'] = 'Jarraitu <i class=\'fa fa-arrow-right\'></i>';
$string['contwidth-compact'] = 'Trinkoa';
$string['contwidth-full'] = 'Betea';
$string['contwidth-wide'] = 'Zabala';
$string['conversation'] = 'Elkarrizketa';
$string['conversation_instructions1'] = 'ordeztu argibide hauek.';
$string['conversationdesc'] = '[elkarrizketaren desc. hemen]';
$string['correct'] = 'Zuzena';
$string['correctanswer'] = 'Erantzun zuzena';
$string['correctcount'] = 'Zenbat elementu zuzen';
$string['corrected'] = 'Zuzendua';
$string['correctresponses'] = 'Erantzun zuzenak';
$string['correctthreshold'] = 'Atalase zuzena (%)';
$string['correctthreshold_desc'] = 'Elementua gainditzeko behar den zehaztasunaren ehunekoa.';
$string['courseattempts'] = 'Ikastaro Saiakerak';
$string['courseattemptsheading'] = 'Ikastaro Saiakeren Txostena';
$string['courseattemptsreport'] = 'Ikastaro Saiakeren Txostena';
$string['courseattemptsreport_explanation'] = 'Ikastaro honetako Minikasgaia saiakera guztiak';
$string['createaitem'] = 'Sortu ikasgai-elementua';
$string['csskey'] = 'CSS Gakoa';
$string['csskey_details'] = 'CSS gakoa galdera-ontzira erantsiko den CSS klase pertsonalizatu bat besterik ez da, diseinatzaileek itxura eta funtzionamendua erraz pertsonaliza dezaten (?). Ondo dago hutsik uztea.';
$string['csskey_help'] = 'CSS gakoa galdera-ontzira erantsiko den CSS klase pertsonalizatu bat besterik ez da, diseinatzaileek itxura eta funtzionamendua erraz pertsonaliza dezaten (?).';
$string['csvdelimiter'] = 'Mugatzailea';
$string['currentwordcount'] = 'Hitz Kopurua:';
$string['d_question'] = 'Elementua';
$string['dc_instructions1'] = 'Entzun eta idatzi entzuten dituzun esaldiak.';
$string['dc_results'] = 'Emaitzak';
$string['deletealluserdata'] = 'Ezabatu erabiltzaile guztien datuak';
$string['deleteattemptconfirm'] = 'Ziur zaude saio hau ezabatu nahi duzula?';
$string['deletebuttonlabel'] = 'EZABATU';
$string['deletefilesfirst'] = 'Ezabatu eskuz gehitu dituzun fitxategiak. Ez dira automatikoki ezabatuko.';
$string['deleteitem'] = 'Ezabatu elementua';
$string['deleteitem_message'] = 'Ziur nago hurrengo elementua ezabatu nahi dudala:&nbsp;';
$string['deletemediaprompt'] = 'Ezabatu media?';
$string['dictation'] = 'Diktaketa';
$string['dictation_instructions1'] = 'Entzun eta idatzi entzuten duzun esaldi bakoitza.';
$string['dictationchat'] = 'Diktaketa Txata';
$string['displaysubs'] = '{$a->subscriptionname} : amaitzen da {$a->expiredate}';
$string['done'] = 'Eginda';
$string['duplicateitem'] = 'Bikoiztutako elementua';
$string['edit'] = 'Editatu';
$string['editingitem'] = 'Editatu ikasgai-elementua';
$string['edititem'] = 'Editatu elementua';
$string['emptyquiz'] = 'Ez dago aukera anitzeko galderarik hautatutako kategorian.';
$string['enablenativelanguage'] = 'Gaitu jatorrizko hizkuntza';
$string['enablenativelanguage_details'] = 'Ezarrita badago, ikasleak bere ama hizkuntza aukeratu dezake, eta horrek AAk emaitzekin batera itzultzen duen feedbackaren lehenetsitako hizkuntza ordezkatuko du. Hizkuntza une honetan <a href="https://support.poodll.com/en/support/solutions/articles/19000163890-definitions-in-user-s-native-language">Poodll WordCards-en ezarrita</a> egon behar du, eta hemen hartzen da.';
$string['enablepushtab'] = 'Gaitu Push aukera';
$string['enablepushtab_details'] = 'Push aukerak jarduera honetako ezarpenak guneko beste jarduera batzuetara bultzatzeko aukera ematen dio Minilesson-ak zabaltzeko gaitasuna duen norbaiti (lehenespenez... kudeatzaileei).';
$string['enablesetuptab'] = 'Gaitu konfigurazio fitxa';
$string['enablesetuptab_details'] = 'Seguruenik, ez duzu hau egiaztatuko. Jarduera-instantziaren ezarpenak dituen fitxa bat erakutsiko die administratzaileei. Hau erabilera-kasu berezi baterako da eta Minikasgaiaren orriak goibururik, orri-orririk edo blokerik gabe agertuko dira.';
$string['endofgame'] = 'Zure puntuazioa hau izan da: {$a}. Sakatu espazio-tekla edo egin klik berrabiarazteko.';
$string['enterresponses'] = 'Sartu erantzun zuzenen zerrenda beheko testu-eremuan. Jarri erantzun bakoitza lerro berri batean.';
$string['enterspacegameitems'] = 'Idatzi elementuen zerrenda beheko testu-eremuan. Elementu bakoitzak lerro berri batean egon behar du. Formatua hau da:<br>Galdera | Erantzuna<br>adibidez: Zein da Frantziako hiriburua?|Paris';
$string['error:correctanswer'] = 'BALIOGABEKO ERANTZUNA';
$string['error:csvloaderror'] = 'ERROREA CSVa KARGATZERAKOAN';
$string['error:emptyfield'] = 'EZIN DUZU HUTSIK UTZI';
$string['error:failed'] = 'HUTS EGIN DU';
$string['error:invaliditemtype'] = 'ELEMENTU-MOTA EZ BALIAGARRIA';
$string['error:invalidjson'] = 'JSON EZ BALIAGARRIA';
$string['error:noitemsinjson'] = 'EZ DAGO ELEMENTURIK JSONen';
$string['errorheader'] = 'Akatsa';
$string['eu-es'] = 'Euskara';
$string['eventminilessonattemptsubmitted'] = 'Minikasgaia saiakera bidali da';
$string['eventminilessonstepsubmitted'] = 'Minikasgaia urratsa bidali da';
$string['examplecsv'] = 'csv/textu fitxategiaren adibidea';
$string['examplecsv_help'] = 'CSV fitxategia erabiltzeko, deskargatu testu batekin edo kalkulu-orrien editore batekin. Utzi lehenengo lerroa aldatu gabe. Ondoren, editatu hurrengo lerroak (erregistroak) eta gehitu zure Minikasgaia elementuaren datuak, beharrezkoa bada, gehitu lerro gehiago. Gorde artxiboa CSV gisa eta igo.';
$string['examplejson'] = 'Adibidezko json fitxategia';
$string['examplejson_help'] = 'Json fitxategia erabiltzeko, deskargatu eta ireki testu edo kalkulu-orrien editore batekin. Elementuak editatu eta berrerabili, behar duzun elementu-motarekin bat datozen elementuetan, eta kendu behar ez dituzun elementuak. Gorde artxiboa JSON bezala eta igo.';
$string['exceededattempts'] = 'Bete duzu gehienezko  {$a} saiakera kopurua.';
$string['exportexcel'] = 'Esportatu CSVra';
$string['exportheading'] = 'Esportatu elementuak JSON gisa';
$string['exportinstructions'] = 'Minikasgaia jarduera honetako artikuluak JSON fitxategi batera esportatu. Hau erabil daiteke babeskopiak egiteko edo elementuak beste Minikasgaia jarduera batera transferitzeko. Gainera, esportatutako gauzak editatu eta berriz inporta ditzakezu.';
$string['exportitems'] = 'Esportatu elementuak';
$string['finishscreen_custom'] = 'Pertsonalizatua';
$string['finishscreen_details'] = 'Jarduera amaitzen duzunean, pantaila soil bat, pantaila osoa edo pantaila pertsonalizatu bat ikus dezakezu. Pantaila pertsonalizatua zuk zeuk diseinatu dezakezun orrialde bat da.';
$string['finishscreen_full'] = 'Osoa';
$string['finishscreen_help'] = 'Jarduera amaitzen duzunean, pantaila soil bat, pantaila osoa edo pantaila pertsonalizatu bat ikus dezakezu. Pantaila pertsonalizatua zuk zeuk diseinatu dezakezun orrialde bat da.';
$string['finishscreen_simple'] = 'Sinplea';
$string['finishscreencustom'] = 'Amaierako pantaila pertsonalizatua';
$string['finishscreencustom_details'] = 'Jardueraren amaierako pantailaren aukerak \'pertsonalizatua\' gisa ezarrita badaude, hau izango da amaierako pantaila sortzen duen bibote-txantiloi lehenetsia. Jarduera-mailan gainidatzi daiteke.';
$string['finishscreencustom_help'] = 'Pantaila pertsonalizatua funtzio aurreratu bat da, bibote-notazioa eta aldagaiak erabiliz amaiera-pantaila pertsonalizatu bat sortzeko aukera ematen duena. Aldagai batzuk hauek dira: {total} {courseurl} {coursename} {yellowstars} {graystars} {reattempturl} eta {results} array bat, bakoitza {title}, {grade}, {yellowstars} eta {graystars} aldagaiekin.';
$string['fluency'] = 'Jariotasuna';
$string['fluency_instructions1'] = 'Irakurri ozen esaldiak. Egin klik mikrofonoaren ikonoan grabatzen hasteko.';
$string['fluencyresponses'] = 'Idatzi esaldi/perpausen zerrenda bat beheko testu-eremuan. Elementu bakoitzak lerro berri batean egon behar du.';
$string['fluencyresults'] = 'Jariotasunaren Emaitzak';
$string['freespeaking'] = 'Hizketa Librea';
$string['freespeaking_default_aigrade'] = 'Gramatika akats bakoitzeko puntu 1 kendu, baina ortografia edo puntuazio akatsengatik ez penalizatu.';
$string['freespeaking_default_aigradefeedback'] = 'Azaldu gramatika akats bakoitza modu sinplean. Ez egin iruzkinik ortografiari edo puntuazioari buruz.';
$string['freespeaking_instructions1'] = 'Erabili mikrofonoa galderari emandako erantzuna grabatzeko.';
$string['freespeakingdesc'] = '<b>Hitzaldi Librea BETA moduan dago.</b> Nabigatzaile eta gailu mugikor ezberdinek modu ezberdinean joka dezakete.<br/><br/> Ezarri hitz kopurua zein kalifikazio eta feedback jarraibideak AAren ebaluaziorako. Ikasleek gaiari buruzko hizketa grabatu beharko dute, eta AA bidezko kalifikazio eta feedback bat jasoko dute.';
$string['freewriting'] = 'Idazketa Librea';
$string['freewriting_default_aigrade'] = 'Gramatika, ortografia edo puntuazio akats bakoitzeko puntu 1 kendu.';
$string['freewriting_default_aigradefeedback'] = 'Azaldu akats bakoitza modu sinplean.';
$string['freewriting_instructions1'] = 'Idatzi galderaren erantzuna beheko testu-eremuan.';
$string['freewritingdesc'] = 'Ezarri hitz kopurua eta kalifikazio eta feedback jarraibideak AA bidezko ebaluaziorako. Ikasleek gaiari emandako erantzuna idatzi beharko dute, eta AA bidezko kalifikazio eta feedbacka jasoko dute.';
$string['fs_totalmarks_instructions'] = 'Hizketa libreko item honen puntuazio osoak eragina du MiniIkasgai jardueraren puntuazioan.';
$string['fullscreen'] = 'Pantailla Osoa';
$string['fw_totalmarks_instructions'] = 'Idazketa libreko item honen puntuazio osoak eragina du MiniIkasgai jardueraren puntuazioan.';
$string['gapfillitemsdesc'] = 'Sartu elementuen zerrenda beheko testu-eremuan. Elementu bakoitzak lerro berri bat izan beharko luke. Letra-hutsuneak euskarri karratuetan sartu behar dira: [ ]. Formatua hauxe da: <br>Text prompt | hint<br>.adibidea  This is my d[og]| a common pet';
$string['gethints'] = 'Lortu Aholkuak';
$string['grade'] = 'Kalifikazioa';
$string['grade_p'] = 'Kalifikazioa(%)';
$string['gradeaverage'] = 'saio guztien batez besteko puntuazioa';
$string['gradehighest'] = 'puntuazioa altueneko saiakera';
$string['gradelatest'] = 'azken saiakeraren puntuazioa';
$string['gradelowest'] = 'puntuaziorik baxueneko saiakera';
$string['gradenone'] = 'Kalifikaziorik ez';
$string['gradeoptions'] = 'Kalifikazio-aukerak';
$string['gradereport'] = 'Kalifikazio-txostena';
$string['gradereport_explanation'] = 'Kalifikazio-zerrenda';
$string['gradereportheading'] = 'Kalifikazio-txostena';
$string['grading'] = 'Kalifikazioak';
$string['gradingbyuserheading'] = 'Kalifikazioa honen: {$a} saikera guztientzat';
$string['gradingheading'] = 'Erabiltzaile bakoitzaren azken saiakeraren kalifikazioak.';
$string['hidecorrections'] = 'Ezkutatu lerroarteko zuzenketak';
$string['hidestartpage'] = 'Ezkutatu hasierako orria';
$string['hidestartpage_desc'] = 'Markatuta badago, kargatu bezain laster hasiko da jarduera-elementua.';
$string['hints'] = 'Aholkuak';
$string['howtoplay'] = 'Nola jokatu';
$string['howtoplay_help'] = 'Itsasontzia mugi dezakezu geziak erabiliz edo saguarekin arrastatuz.
Sakatu espazio-barra edo egin klik saguaren botoian tiro egiteko, edo sakatu bi hatzekin jokoaren edozein lekutan.
Erantzun zuzena jaurtiz ahalik eta galdera gehien erantzun ditzakezu. Zorte on!';
$string['ideacount'] = 'Kontzeptuak';
$string['ignorepunctuation'] = 'Ez egin jaramonik Puntuazioari';
$string['import'] = 'Inportatu';
$string['importformat'] = 'Inportatu formatua';
$string['importheading'] = 'Inportatu JSON edo CSV elementuak';
$string['importing'] = 'Inportatzen';
$string['importinstructions'] = 'Minikasgaien elementuak inporta ditzakezu beheko inprimakia erabiliz. Inportazio-fitxategia CSV edo JSON motakoa izan behar du. Informazio gehiago <a href="https://support.poodll.com/en/support/solutions/articles/19000153051-importing-items-into-minilesson" target="_blank">import documentation</a> elementu-mota bakoitzeko datuak eta datuen formatua sartzeko. Laginak inportatzeko fitxategi bat dago behean. Edo orritik behera esportatzeko botoia erabili jarduera honetako elementuak JSON fitxategi batera esportatzeko.';
$string['importitemsresult'] = 'Inportatu Elementuen Emaitzak';
$string['importresults'] = 'Inportatu Emaitzak';
$string['includematching'] = 'Bikoteka tiro egiteko aukera barne';
$string['includematching_desc'] = 'Sartu \'Bikoteka Tiro Egiteko Aukera\' jokoarekin bat egiten dutenak Espazio Jokoan';
$string['incompleteattemptsheading'] = 'Osatugabeko Saiakeren Txostena';
$string['incompleteattemptsreport'] = 'Osatugabeko Saiakeren Txostena';
$string['incompleteattemptsreport_explanation'] = 'Osatugabeko saiakeren zerrenda';
$string['incorrectanswer'] = 'Erantzun okerra';
$string['item'] = 'Elementua';
$string['itemcontents'] = 'Elementu-testua';
$string['itemcount'] = 'Elementu-kopurua';
$string['itemiframe'] = 'iFramea txertatzeko kodea';
$string['iteminstructions'] = 'Elementuaren instrukzioak';
$string['itemmedia'] = 'Irudia, audioa edo bideoa erakusteko';
$string['itemname'] = 'Elementuaren Izena';
$string['itemorder'] = 'Elementuaren Ordena';
$string['itemscomplete'] = 'Osatutako Elementuak';
$string['itemsettingsheadings'] = 'Elementuaren Ezarpenak';
$string['itemsperpage'] = 'Elementuak orrialdeko';
$string['itemsperpage_details'] = 'Honek ezartzen du zenbat ilara erakutsi behar diren txostenetan edo saiakera-zerrendetan.';
$string['itemtextarea'] = 'Testu-blokea';
$string['itemtitle'] = 'Elementuaren izena';
$string['itemttsquestion'] = 'TTS prompt-testua';
$string['itemttsquestionvoice'] = 'TTS prompt-esataria';
$string['itemtype'] = 'Elementu-mota';
$string['itemytend'] = 'Amaiera-segundoak';
$string['itemytid'] = 'Youtube Bideoaren IDa';
$string['itemytstart'] = 'Hasiera-segundoak';
$string['language'] = 'Hizkuntza';
$string['layoutauto'] = 'Auto';
$string['layouthorizontal'] = 'Horizontala';
$string['layoutmagazine'] = 'Aldizkaria';
$string['layoutvertical'] = 'Bertikala';
$string['lessonfont'] = 'Letra pertsonalizatua';
$string['lessonfont_details'] = 'Minikasgai honetarako gunearen lehenetsitako balioa gainidatziko duen letra-tipoaren izena bistaratzean. Ortografia eta maiuskula/minuskula zehatzak izan behar dira. Adibidez, Andika edo Comic Sans MS';
$string['lessonfont_help'] = 'Minikasgai honen bistaratzeko lehenespenak berridatziko dituen letra-izen bat. Zehatza izan behar du ortografian eta kasuan. eg Andika edo Comic Sans MS';
$string['lessonkey'] = 'Ikasgaiaren Gakoa';
$string['lessonkey_details'] = 'Ikasgaiaren gakoa etiketa bat besterik ez da, txosten batzuekin CSVra esportatuko dena txosten horiek errazago prozesatzeko kalkulu-orri batean. Ondo dago hutsik uztea.';
$string['lessonkey_help'] = 'Ikasgaiaren gakoa etiketa bat besterik ez da, txosten batzuekin CSVra esportatuko dena txosten horiek errazago prozesatzeko kalkulu-orri batean.';
$string['letsadditems'] = 'Gehi ditzagun ikasgai-elementu batzuk!';
$string['lg_instructions1'] = 'Entzun eta bete hutsuneak';
$string['lg_results'] = 'Emaitzak';
$string['lgapfill'] = 'Entzun Hutsuneak bete';
$string['listen'] = 'Entzun';
$string['listenandrepeat'] = 'Entzun eta Esan';
$string['listenandtype'] = 'Entzun eta Idatzi';
$string['listeninggapfill'] = 'Hutsuneak bete entzuten';
$string['listeninggapfillitemsdesc'] = 'Sartu elementu-zerrenda beheko testu-eremuan. Elementu bakoitzak lerro berri batean egon behar du. Letra hutsuneak kortxete artean sartu behar dira: [ ]. Hauxe da formatua: <br>Text prompt<br>.e.g  This is my d[og]';
$string['listenorread'] = 'Bistaratu aukerak honela';
$string['listenorread_image'] = 'irudiak + testu arrunta';
$string['listenorread_listen'] = 'audio-erreproduzitzaileak + puntuak';
$string['listenorread_listenandread'] = 'audio-erreproduzitzaileak + testu laua';
$string['listenorread_read'] = 'testu laua';
$string['listenrepeat'] = 'Entzun eta Esan';
$string['lives'] = 'Bizitzak:';
$string['loading'] = 'Igotzen...';
$string['lr_instructions1'] = 'Entzun eta erantzun entzuten dituzun esaldiei.';
$string['managersquestions'] = 'Kudeatu Ikasgaietako Elementuak';
$string['maxattempts'] = 'Gehieneko Saiakerak';
$string['maxattempts_details'] = 'Jarduera honetan baimendutako gehieneko saiakera kopurua.';
$string['mediaprompts'] = 'Media Prompt-ak';
$string['mingrade'] = 'Gutxieneko Kalifikazioa';
$string['mingradedetails'] = 'Jarduera hau osatzeko gutxieneko kalifikazioa.';
$string['minilesson'] = 'Poodll Minikasgaia';
$string['minilesson:addinstance'] = 'Gehitu Minikasgai berria';
$string['minilesson:canmanageattempts'] = 'Minikasgai saikerak kudeatu ditzake';
$string['minilesson:canpreview'] = 'Minikasgai jarduerak aurreikusi ditzake';
$string['minilesson:evaluate'] = 'Ikasleen Minikasgai saiakerak ebaluatu ditzake';
$string['minilesson:export'] = 'Ikasgai-elementuak esportatu ditzake';
$string['minilesson:itemedit'] = 'Editatu elementuak';
$string['minilesson:itemview'] = 'Ikusi elementuak';
$string['minilesson:manage'] = 'Minikasgai instantziak kudeatu ditzake';
$string['minilesson:managequestions'] = 'Minikasgaia elementuak kudeatu ditzake';
$string['minilesson:push'] = 'Bultzatu ezarpenak instantzia batetik bestera';
$string['minilesson:submit'] = 'Minikasgaia saiakerak bidali ditzake';
$string['minilesson:tts'] = 'Testutik Ahozkora (TTS, Text To Speech) erabili dezake';
$string['minilesson:view'] = 'Aurreikusi Minikasgaia';
$string['minilessonname'] = 'Poodll Minikasgaia';
$string['minilessonname_help'] = 'Hau da Minikasgaia izenari lotutako laguntza tresnaren edukia. Markdown sintaxia bermatuta dago.';
$string['mistakes'] = 'Akatsak';
$string['modaleditform'] = 'Elementua Editatzeko Formularioa';
$string['modaleditform_details'] = 'Minikasgaia elementuak gehitzeko edo editatzeko, formulario modal bat erabil daiteke (popup) edo orri berri bat.';
$string['modaleditform_modalform'] = 'Formulario modala (popup)';
$string['modaleditform_newpage'] = 'Orri berria';
$string['modelaudio_playerinstructions'] = 'Uneko audioa beheko erreproduzitzailearekin erreproduzitu daiteke.';
$string['modulename'] = 'Poodll Minikasgaia';
$string['modulename_help'] = 'Minikasgaiek kalifikatutako hizkuntzak ikasteko hainbat jarduera konbinatzen ditu lineako ikasgai autogidatu sinple batean.';
$string['modulenameplural'] = 'Poodll Minikasgaiak';
$string['multiaudio_instructions1'] = 'Aukeratu erantzun zuzena. Erabili mikroa ozen irakurtzeko';
$string['multichoice'] = 'Aukera anitzekoa';
$string['multichoice_instructions1'] = 'Aukeratu erantzun zuzena';
$string['name'] = 'Izena';
$string['newitem'] = 'Elementua: {$a}';
$string['nextlessonitem'] = 'Hurrengo orria';
$string['nodataavailable'] = 'Ez dago daturik eskuragarri';
$string['noitems'] = 'Oraindik ez dago ikasgai-elementurik jarduera honetan.';
$string['nomicdetected'] = 'Ez da mikrofonorik hauteman.';
$string['nominilessons'] = 'Ez dago Minikasgairik';
$string['nopasting'] = 'Desgaitu kopiatu/itsatsi';
$string['nopasting_desc'] = 'Desgaitu kopiatu/itsatsi testu-eremuan. Horrela, ikasleek ezingo dituzte itsatsi beste nonbaiteko erantzunak.';
$string['notimelimit'] = 'Denbora-mugarik ez';
$string['notsubmit'] = 'Ez da bidali';
$string['notsubmitted'] = 'Ez duzu erantzuna bidali. Orain bidali nahi duzu?';
$string['notyetplayed'] = 'Oraindik jokatu gabe';
$string['numberonly'] = 'Zenbakiak bakarrik';
$string['onemin'] = 'Minutu 1';
$string['oneminxsecs'] = 'Minutu 1 {$a} segundo';
$string['open'] = 'Ireki:';
$string['order'] = 'Ordena';
$string['original'] = 'Jatorrizkoa';
$string['overview'] = 'Ikuspegi orokorra';
$string['overview_help'] = 'Ikuspegi Orokorraren Laguntza';
$string['page'] = 'Eduki-orria';
$string['pagelayout'] = 'Orriaren diseinua';
$string['passagegapfill'] = 'GapFill Pasartea';
$string['passagegapfilldesc'] = 'Idatzi testu pasarte bat beheko testu eremuan. Hitz hutsuneak kortxete artean sartu behar dira: [ ]. Pasarte labur bat honelakoa izan liteke: Hau da nire [txakurra] eta nire [katua].';
$string['passagereading'] = 'Pasartearen Irakurketa';
$string['passagereading_instructions1'] = 'Erabili mikrofonoa pasartea irakurtzen ari zaren bitartean zeure burua grabatzeko.';
$string['passagereadingdesc'] = '<b>Pasarteen irakurketa BETA elementu mota bat da.</b> Nabigatzaile eta gailu mugikor ezberdinek modu ezberdinean joka dezakete.<br/><br/> Idatzi irakurtzeko pasarte bat beheko testu-eremuan. Ikasleak pasartea ozen irakurri beharko luke.';
$string['passagetoread'] = 'Irakurtzeko pasartea';
$string['passagewithgaps'] = 'Hutsunedun pasartea';
$string['penalizehints'] = 'Zigortu pistak erabiltzea';
$string['penalizehints_desc'] = 'Markatuta badago, ikasleak zigorra jasoko du pistak erabiltzeagatik.';
$string['pg_instructions1'] = 'Bete hutsuneak dituen hitz bakoitza.';
$string['pgapfill'] = 'Hutsuneak betetako Pasartea';
$string['phraseresponses'] = 'Sartu elementu-zerrenda bat beheko testu-eremuan. Elementu bakoitzak lerro berri bat izan beharko luke. Formatua da: <br>audioa  | erantzun zuzena (aukerakoa) | testua (aukerakoa) <br>e.g Zer moduz? | Ondo nago.';
$string['pl-pl'] = 'Findu';
$string['playedxtimeswithhighscore'] = '{$a->times} aldiz jokatu da. Azken partida {$a->score} puntuazio altuarekin amaitu da.';
$string['playerscores'] = 'Jokalariak puntuatzen ditu';
$string['pluginadministration'] = 'Minikasgaiaren Administrazioa';
$string['pluginname'] = 'Poodll MinIkasgaia';
$string['points'] = 'Puntuak';
$string['postattemptheader'] = 'Saikeraren ondorengo aukerak';
$string['pr_alternates_instructions'] = 'Alternatibek jardueraren egileari pasarte-hitz espezifikoetarako transkripzio oker onargarriak zehazteko aukera ematen diote. Lerro bakoitzeko hitz multzo 1. adibidez, haien|hor|daude Ikusi <a href="https://support.poodll.com/support/solutions/articles/19000096937-tuning-your-read-aloud-activity">dokumentuak</a> xehetasun gehiago lortzeko.';
$string['pr_totalmarks_instructions'] = 'Pasarte honen irakurketa osoak MinIkasgaia jardueraren puntuazioan laguntzen du. Utzi 0 gisa eta puntuazio osoa pasarteko hitz kopuruaren berdina izango da. Bestela, puntuazioa kalkulatuko da ondo irakurritako ehunekotik.';
$string['preview'] = 'Aurreikusi';
$string['previewitem'] = 'Aurreikusi elementua';
$string['privacy:metadata'] = 'Poodll Minikasgaia pluginak datu pertsonalak gordetzen ditu.';
$string['privacy:metadata:attemptid'] = 'Identifikatzaile bakarra Minikasgai saio baten erabiltzaileentzat.';
$string['privacy:metadata:attempttable'] = 'Minikasgai saio bati lotutako puntuazioak eta erabiltzaileen beste datu batzuk gordetzen ditu.';
$string['privacy:metadata:cloudpoodllcom'] = 'Minikasgaia pluginak grabazioak AWS S3 buckets-en gordetzen ditu via cloud.poodll.com.';
$string['privacy:metadata:cloudpoodllcom:userid'] = 'Minikasgaia pluginak moodle erabiltzaile IDa dakar grabazio eta transkripzioen URLetan';
$string['privacy:metadata:errorcount'] = 'Erabiltzaileen Minikasgai saiakera baten errore kopurua.';
$string['privacy:metadata:fulltranscriptpurpose'] = 'Grabazioen transkripzio osoak.';
$string['privacy:metadata:minilessonid'] = 'Identifikatzaile bakarra Minikasgai jarduera-instantzia batentzat.';
$string['privacy:metadata:moduleid'] = 'Identifikatzaile bakarra Minikasgai jarduera-instantzia batentzat.';
$string['privacy:metadata:sessiondata'] = 'Saiakeraren saio-datak';
$string['privacy:metadata:sessionend'] = 'Saiakeraren saioen amaiera';
$string['privacy:metadata:sessionscore'] = 'Saiakeraren saioen puntuazioa';
$string['privacy:metadata:sessiontime'] = 'Saiakeraren saioen denbora (grabazio denbora)';
$string['privacy:metadata:timemodified'] = 'Saiakera honek azken saiakera moldatuko du';
$string['privacy:metadata:transcriptpurpose'] = 'Grabazioaren transkripzio laburrak.';
$string['privacy:metadata:userid'] = 'Minikasgai saiakeraren erabiltzailaren id-a';
$string['processing'] = 'Prozesatzen';
$string['prompt-richtext'] = 'Testu Aberastua';
$string['prompt-separate'] = 'Bereizi testuak eta multimedia (gomendatua)';
$string['prompttype'] = 'Testua eta Media';
$string['prompttype_help'] = 'Erabili testu arrunta eta hautatzaile bereiziak multimedia fitxategiak, edo testu aberatsaren editore bat gehitzeko';
$string['push'] = 'Bultzatu';
$string['pushconfirm'] = '<b>{$a->pushthing</b> ezarpena beste {$a->clonecount} jardueratara bultzatzear zaude. Ziur zaude?';
$string['pushpage'] = 'Bultzatu Orria';
$string['pushpage_clonecount'] = 'Jarduera honetako ezarpenak bultzatzeak beste <b>{$a}</b> jarduera batzuetan eragina izango du.';
$string['pushpage_done'] = 'Ezarpenak {$a} MiniLesson jardueretara eraman dira';
$string['pushpage_explanation'] = 'Erabili orrialde honetako botoiak MinIkasgai instantzia HONEtako ezarpen bat beste MiniIkasgai jarduera batzuetara eramateko. Kontuz. Ez dago atzera bueltarik.';
$string['pushpage_noclones'] = 'Ez dago beste jarduerarik eraginpeko esparruan. Beraz, ez dago ezarpenak nora bultzatu.<br><br>';
$string['pushpage_scopecourse'] = 'Ikastaro honetako MinIkasgaien jarduerak: <b>{$a}</b>';
$string['pushpage_scopemodule'] = 'Jarduera-izen hau duten MiniLesson jarduerak (webgune osokoak): <b>{$a}</b>';
$string['pushpage_scopenone'] = 'EZ dago MiniIkasgai jarduerarik';
$string['pushpage_scopesite'] = 'Gune honetako MiniIkasgai jarduera guztiak';
$string['qnumber'] = 'Zb.';
$string['questiontext'] = 'Galdera';
$string['quiz_p'] = 'Galdetegia(%)';
$string['quizanswers'] = 'Saiakerak';
$string['rawgrade_p'] = 'Kalifikazioa(%)';
$string['readsentences'] = 'Irakurri Esaldiak (TTS)';
$string['readsentences_desc'] = 'Aukeratuz gero, esaldi bakoitza ozenki irakurriko da. Diktatzeko modu bat izango da.';
$string['reallydeletemediaprompt'] = 'Benetan ezabatu multimedia:';
$string['reallyreattempt'] = 'Aurreko saiakera gainidatziko da. Ziur zaude berriro saiatu nahi duzula?';
$string['reattempt'] = 'Saiatu Berriro';
$string['reattemptbody'] = 'Saiakerarekin jarraitzen baduzu, honek aurreko saiakera ordezkatuko du. Ados?';
$string['reattempttitle'] = 'Ziur zaude Berriro Saiatu nahi duzula?';
$string['recordingaiheader'] = 'Grabazio eta AA aukerak';
$string['refreshtoken'] = 'Berritu Lizentziaren informazioa';
$string['region'] = 'AWS Eskualdea';
$string['region_details'] = 'AWS eskualdeak datuak non gordetzen eta prozesatzen diren ezartzen du.';
$string['regrade'] = 'Berriz kalifikatu';
$string['relevance'] = 'Adierazgarritasuna';
$string['relevancetype'] = 'Adierazgarritasun-mota';
$string['relevancetype_desc'] = 'AA-k garrantzi txikiko erantzunak zigortuko ditu. Aukeratu erabiliko duzun adierazgarritasun-mota.';
$string['relevancetype_modelanswer'] = 'Erantzun Ereduarekiko Adierazgarritasuna';
$string['relevancetype_none'] = 'Ez da kontuan hartu adierazgarritasuna';
$string['relevancetype_question'] = 'Galderarekiko adierazgarritasuna (testu-elementua)';
$string['removefrommywords'] = 'Egin klik Nire Hitzetatik kentzeko';
$string['removescores'] = 'Ezabatu erabiltzaileen puntuazio guztiak';
$string['reports'] = 'Txostenak';
$string['reportsmenutoptext'] = 'Berrikusi kalifikazioaren eta saiakeraren xehetasunak beheko txosten-botoiak erabiliz.';
$string['reportstable'] = 'Txosten-estiloa';
$string['reportstable_details'] = 'Ajax taulak azkarragoak dira eta datuak ordenatu ditzakete. Orri-taulak azkarrago kargatzen dira, baina zailagoa da nabigatzea.';
$string['reporttableajax'] = 'Ajax Taulak';
$string['reporttablepaged'] = 'Orrikatutako Taulak';
$string['result'] = 'Emaitzak';
$string['returntogradinghome'] = 'Itzuli Kalifikazioen Goiko aldera';
$string['returntoreports'] = 'Itzuli Txostenetara';
$string['review'] = 'Berrikusi';
$string['rp_result_accuracy'] = 'Zehaztasuna';
$string['rp_result_correct'] = 'Zuzena';
$string['rp_result_incorrect'] = 'Okerra';
$string['rp_result_read'] = 'Irakurritako Hitzak';
$string['rp_result_score'] = 'Puntuazioa';
$string['rp_result_unreached'] = 'Irakurri Gabea';
$string['rsquestions'] = 'Ikasgaiaren Elementuak';
$string['saveandnext'] = 'Gorde ... eta hurrengoa';
$string['saveitem'] = 'Gorde elementua';
$string['savestaudio'] = 'Grabatu Audioa';
$string['sc_instructions1'] = 'Irakurri ozenki txartel bakoitzeko esaldia.';
$string['scopeselector'] = 'Eremua:';
$string['score'] = 'Puntuazioa';
$string['scoreheader'] = 'Puntuazioa';
$string['scoreslink'] = 'Ikusi saiakera guztiak';
$string['scoreslink_help'] = 'Ikusi jokalari guztien saiakerak eta puntuazioak';
$string['seeanswerdetails'] = 'ikusi xehetasunak';
$string['sentenceaudio'] = 'Esaldien Audioak';
$string['sentenceaudio_help'] = '(aukerakoa) Igo esaldiaren gonbidapenarekin bat datozen audio fitxategiak. Audio fitxategiaren izenak esaldiaren gonbidapenaren zenbakiarekin bat etorri behar du, adibidez, 1.mp3 edo 2.mp3';
$string['sentenceimage'] = 'Esaldien Irudiak';
$string['sentenceimage_help'] = '(aukerakoa) Igo irudi fitxategiak esaldi-promptarekin batera bistaratzeko. Irudi fitxategiaren izenak esaldi-galderaren zenbakiarekin bat etorri behar du, adibidez, 1.png edo 2.jpg';
$string['sentenceprompts'] = 'Esaldiak (promptak)';
$string['sentences'] = 'Esaldiak';
$string['setup'] = 'Konfigurazioa';
$string['sg_instructions1'] = 'Argibideak Hutsuneak bete hizketaldirako';
$string['sg_results'] = 'Emaitzak';
$string['sgapfill'] = 'Hutsuneak bete Hizketaldia egiten';
$string['shootthepairs'] = 'Tiro egiteko Pareak';
$string['shortanswer'] = 'Erantzun Laburra';
$string['shortanswer_instructions1'] = 'Erantzun galderari mikroa erabiliz';
$string['showcorrections'] = 'Erakutsi lerro arteko zuzenketak';
$string['showdetailedresults'] = 'Erakutsi emaitza zehatzak';
$string['showingattempt'] = 'Erakutsi saiakerak honetarako: {$a}';
$string['showingmachinegradedattempt'] = 'Makinak ebaluatutako saiakera honentzat: {$a}';
$string['showitemreview'] = 'Erakutsi elementuaren berrikuspena';
$string['showitemreview_details'] = 'Ikasleak elementua probatu bezain laster, erakutsi iezaiozu erantzun zuzena eta, elementuak onartzen badu, edozein feedbacka.';
$string['showitemreview_help'] = 'Ikasleak elementua probatu bezain laster, erakutsi iezaiozu erantzun zuzena eta, elementuak onartzen badu, edozein feedbacka.';
$string['showitemscores'] = 'Erakutsi Emaitza Guztiak';
$string['showoptionsastext'] = 'Erakutsi erantzunak testu gisa';
$string['showqtitles'] = 'Erakutsi elementuen izenburua ikasgaian';
$string['showtextprompt'] = 'Erakutsi testu-promptak';
$string['skip'] = 'Saltatu';
$string['skip-fluency'] = 'Jarraitu';
$string['smartframe_instructions1'] = 'Orriaren edukia behean kargatuko da.';
$string['sound'] = 'Soinua';
$string['spacegame'] = 'Space-Jokoa';
$string['spacegame_instructions1'] = 'Tiro egin alienei erantzun zuzena hautatuz.';
$string['spacegameclickclick'] = 'Egin klik botoian jokoa hasteko';
$string['spacegamedesc'] = '[espace-jokoaren deskribapena hemen]';
$string['spacegameitems'] = 'Space-jokoaren elementuak';
$string['spacetostart'] = 'Sakatu space edo egin klik hasteko';
$string['speakinggapfill'] = 'Hutsuneak bete hizketaldia egiten';
$string['speechcards'] = 'Hizketarako Kartak';
$string['speechnotrecognized'] = 'Ezin izan dugu zure hizketaldia antzeman.';
$string['speechtester'] = 'Hizketa-Egiaztatzailea';
$string['speechtester_playertitle'] = 'Erreproduzitu Audioa';
$string['speechtester_recordinstructions'] = 'Grabatu hemen probetan erabiltzeko audioa. Aukeran audioa igotzea hautatu dezakezu kargatu audioa sakatuz.';
$string['speechtester_recordtitle'] = 'Grabatu audioa';
$string['start'] = 'Hasi';
$string['starttest'] = 'Aurrera';
$string['sttstaudio'] = 'STT Audioa';
$string['studentname'] = 'Ikaslearen Izena';
$string['submit'] = 'Bidali';
$string['submitnow'] = 'Bidali';
$string['targetwordcount'] = 'Helburuko Hitz Kopurua: {$a}';
$string['targetwordcount_title'] = 'Helburuko Hitz Kopurua';
$string['textprompt_dots'] = 'Erakutsi puntuak letren ordez';
$string['textprompt_words'] = 'Erakutsi testu-osoa';
$string['tg_instructions1'] = 'Hutsuneak bete argibideak idazten';
$string['tgapfill'] = 'Hutsuneak bete dazten';
$string['thatsnotright'] = 'Zerbait gaizki dago';
$string['timecreated'] = 'Duela zenbat Denbora Sortuta';
$string['timelimit'] = 'Denbora muga';
$string['title'] = 'Izenburua';
$string['totalattempts'] = 'Saiakerak';
$string['totalmarks'] = 'Markak Guztira';
$string['totalscore'] = 'Puntuazioa Guztira:';
$string['totalwords'] = 'Hitzak Guztira';
$string['transcriber'] = 'Transkribitzailea';
$string['transcriber_auto'] = 'STT irekia (Zorrotza)';
$string['transcriber_details'] = 'Erabili beharreko transkripzio-motorra';
$string['transcriber_poodll'] = 'STT gidatua (Poodll)';
$string['tryagain'] = 'Saiatu Berriro';
$string['ttsdialog'] = 'TTS Elkarrizketa';
$string['ttsdialoginstructions'] = 'Aukeratu hizlariak A, B eta C roletarako eta sartu elkarrizketan. Hasi elkarrizketa-lerro bakoitza hizlariaren rolarekin + \')\'. e.g A) Kaixo. Soinu-efektuko lerroak honekin hasiko dira >> e.g. >>kaioak';
$string['ttsdialogvisible'] = 'Elkarrizketak Ikusgai';
$string['ttsdialogvisible_desc'] = 'Ez aukeratu ikasleek ez badute elkarrizketa-testua ikusi behar.';
$string['ttsdialogvoicea'] = 'A ahotsa';
$string['ttsdialogvoiceb'] = 'B ahotsa';
$string['ttsdialogvoicec'] = 'C ahotsa';
$string['ttslanguage'] = 'Xede/Ahots Hizkuntza';
$string['ttsnormal'] = 'Ohikoa';
$string['ttspassage'] = 'TTS Pasartea';
$string['ttspassageinstructions'] = 'Aukeratu bozgorailua eta abiadura, eta sartu irakurri beharreko pasartean.';
$string['ttspassagespeed'] = 'Abiadura';
$string['ttspassagevoice'] = 'Ahotsa';
$string['ttsslow'] = 'Geldo';
$string['ttsveryslow'] = 'Oso Geldo';
$string['type'] = 'Idatzi';
$string['typinggapfill'] = 'Hutsuneak bete idazten';
$string['uniquewords'] = 'HItz Bereziak';
$string['unlimited'] = 'Mugarik gabe';
$string['until'] = 'Noiz arte:';
$string['uploadstaudio'] = 'Igo Audioa';
$string['username'] = 'Erabiltzailea';
$string['view'] = 'Ikuspegia';
$string['viewend'] = 'Itxi jarduera';
$string['viewend_help'] = 'Ezarrita baldin badago, ikasle batek ezin du jarduerara sartu itxiera-data/ordua igaro ondoren.';
$string['viewgrading'] = 'Ikusi Kalifikazioak';
$string['viewreports'] = 'Ikusi Txostenak';
$string['viewstart'] = 'Ireki jarduera';
$string['viewstart_help'] = 'Ezarrita badago, ikasleek ezingo dute jardueran sartu hasiera data/ordua baino lehen.';
$string['voice'] = 'Ahotsa';
$string['welcomelabel'] = 'Ongi Etorri Mezua';
$string['welcomelabel_details'] = 'MiniIkasgaia jarduera berri bat sortzean ongietorriaren eremuan erakutsiko den testu lehenetsia';
$string['whatdonow'] = 'Gehitu ikasgai-elementuak jardueran:';
$string['writehere'] = 'Idatzi hemen ...';
$string['xmins'] = '{$a} minutu';
$string['xminsecs'] = '{$a->minutes} minutu eta {$a->seconds} segundo';
$string['xsecs'] = '{$a} segundoak';
$string['ytclipdetails'] = 'Youtube Klipa';
