<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'format_designer', language 'de', version '4.4'.
 *
 * @package     format_designer
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['abovecoursecontents'] = 'Oberhalb der Kursinhalte';
$string['accordion'] = 'Akkordeon';
$string['activity:calltoaction'] = 'Call to action der Aktivität';
$string['activity:completionbadge'] = 'Aktivitätsabschluss-Badge';
$string['activity:description'] = 'Aktivitätsbeschreibung';
$string['activity:icon'] = 'Aktivitätsicon';
$string['activity:modname'] = 'Modulname der Aktivität';
$string['activity:title'] = 'Aktivitätstitel';
$string['activity:visits'] = 'Aktivitätsaufrufe';
$string['activitydesclength'] = 'Beschreibung der Aktivität kürzen';
$string['activitydesclength_desc'] = 'Diese globale Einstellung bestimmt, ob die Beschreibung von Aktivitäten gekürzt wird.<br><b>Kürzen (Standard)</b>: Diese Option kürzt die Beschreibung und zeigt sie in komprimierter Form an, ähnlich dem aktuellen Verhalten.<br>
<b>Nicht kürzen</b>: Wählen Sie diese Option, um die Beschreibung genau so anzuzeigen, wie sie eingegeben wurde, ohne sie zu kürzen.';
$string['activitydesign'] = 'Design';
$string['activitydisplaymode'] = 'Modus der Aktivitätsanzeige';
$string['activitydisplaymode_help'] = 'Wie die Aktivitäten angezeigt werden sollen';
$string['activityprogress'] = 'Erweiterter Fortschrittsbalken';
$string['activityprogress_help'] = 'Der erweiterte Fortschrittsbalken zeigt den Fortschritt der/des Studierenden basierend auf der gewählten Kursfortschrittsberechnung an. Unterhalb des erweiterten Fortschrittsbalkens wird der aktuelle Fortschritt in Textform angezeigt (mit Unterstützung für Fälligkeitsdaten des Zeitmanagements). Ein Tooltip bietet Links zu Aktivitäten, Voraussetzungen oder Abschnitten.';
$string['additionalcontent'] = 'Zusätzlicher Inhalt';
$string['additionalcontent_help'] = 'Fügen Sie alle zusätzlichen Inhalte hinzu, die im Kurs-Header angezeigt werden sollen.';
$string['addnavigation'] = 'Aktivitätsnavigation hinzufügen';
$string['addnewgroup'] = 'Neue Gruppe hinzufügen';
$string['addsections'] = 'Designer-Abschnitt hinzufügen';
$string['addtocontacts'] = 'Zu Kontakten hinzufügen';
$string['allactivities'] = 'Alle Aktivitäten';
$string['allcourses'] = 'Alle Kurse';
$string['applyto'] = 'Hintergrund anwenden auf';
$string['assignprecourses'] = 'Vorbedingte Kurse zuordnen';
$string['autoenrolalready'] = 'Nur falls nicht eingeschrieben';
$string['autoenrolalways'] = 'Immer';
$string['backgroundcolor'] = 'Hintergrundfarbe';
$string['backgroundgradient'] = 'Hintergrundfarbverlauf';
$string['backgroundgradient_help'] = 'Erstellen Sie einen Farbverlauf: <a href=\' https://cssgradient.io/\'>https://cssgradient.io/</a>. Fügen Sie die Hintergrund-Eigenschaft ein (linear-gradient).';
$string['backgroundimage'] = 'Hintergrundbild';
$string['backgroundmasksection'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > MASK Stil des Modulhintergrunds </h5>';
$string['backgroundposition'] = 'Hintergrundposition';
$string['backgroundposition_help'] = 'Das Hintergrundbild wird auf die angegebene Position fokussiert';
$string['backgroundrepeat'] = 'Hintergrundwiederholung';
$string['backgroundrepeat_help'] = 'Das Hintergrundbild wird wiederholt angezeigt, wenn es nicht in den Abschnittsblock passt';
$string['backgroundsection'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2"  > Modulhintergrunds-Stile </h5>';
$string['backgroundsize'] = 'Hintergrundgröße';
$string['backgroundsize_help'] = 'Das Hintergrundbild wird in dieser Größe angezeigt';
$string['backtomaincourse'] = 'Zurück zum Hauptkurs';
$string['belowcourseprogress'] = 'Unter dem Kursfortschritt';
$string['boxed'] = 'Box';
$string['bypurpose'] = 'Nach Zweck';
$string['bytype'] = 'Nach Typ';
$string['calcourseprogress'] = 'Berechnung des Kursfortschritts';
$string['calcourseprogress_help'] = '<b> Abschlusskriterien:</b> Der Fortschritt soll alle Kriterien umfassen, die Voraussetzungen für den Kursabschluss sind.<br>
<b> Relevante Aktivitäten:</b> Der Fortschritt soll nur Aktivitäten umfassen, die Voraussetzungen für den Kursabschluss sind.<br>
<b> Alle Aktivitäten:</b> Der Fortschritt soll alle Aktivitäten umfassen, für die eine Abschlussverfolgung konfiguriert ist.<br>
<b> Abschnitte:</b> Der Fortschritt basiert auf Abschnitten, nicht auf Aktivitäten.<br>';
$string['calltoactioncontinue'] = 'Überprüfen {$a} <i class="fa fa-angle-double-right"></i>';
$string['calltoactionrestricted'] = '<i class="fa fa-lock"></i>';
$string['calltoactionstart'] = 'Öffnen {$a} <i class="fa fa-angle-double-right"></i>';
$string['calltoactionview'] = 'Überprüfen {$a} <i class="fa fa-angle-double-right"></i>';
$string['calsectionprogress'] = 'Berechnung des Abschnittsfortschritts';
$string['calsectionprogress_help'] = '<b> Relevante Aktivitäten:</b> Der Fortschritt soll nur Aktivitäten umfassen, die Voraussetzungen für den Kursabschluss sind.<br>
<b> Alle Aktivitäten:</b> Der Fortschritt soll alle Aktivitäten umfassen, für die eine Abschlussverfolgung konfiguriert ist.<br>';
$string['cards'] = 'Karten';
$string['categoriseheader'] = 'Abschnittsart';
$string['centerbottom'] = 'Mittig unten';
$string['centercenter'] = 'Mittig halbe Höhe';
$string['centertop'] = 'Mittig oben';
$string['circles'] = 'Kreise';
$string['circlesize'] = 'Größe des Kreis';
$string['collapse'] = 'Aufgeklappt';
$string['collapsiblesections'] = 'Aufklappbare Abschnitte';
$string['completeby'] = 'Abgeschlossen durch';
$string['completed'] = 'Abgeschlossen am';
$string['completion-alt-auto-enabled'] = 'Das System kennzeichnet dieses Element je nach den Bedingungen als vollständig';
$string['completion-alt-auto-fail'] = 'Abgeschlossen (nicht bestanden)';
$string['completion-alt-auto-n'] = 'Nicht abgeschlossen';
$string['completion-alt-auto-n-override'] = 'Nicht abgeschlossen (festgelegt von {$a->overrideuser})';
$string['completion-alt-auto-pass'] = 'Abgeschlossen (bestanden)';
$string['completion-alt-auto-y'] = 'Abgeschlossen';
$string['completion-alt-auto-y-override'] = 'Abgeschlossen (festgelegt von {$a->overrideuser})';
$string['completion-alt-manual-enabled'] = 'Teilnehmer/innen können dieses Element als abgeschlossen markieren.';
$string['completion-alt-manual-n'] = 'Nicht abgeschlossen. Auswählen, um als abgeschlossen zu markieren.';
$string['completion-alt-manual-n-override'] = 'Nicht abgeschlossen (festgelegt von {$a->overrideuser}). Auswählen, um als abgeschlossen zu markieren.';
$string['completion-alt-manual-y'] = 'Abgeschlossen. Auswählen, um als nicht abgeschlossen zu markieren.';
$string['completion-alt-manual-y-override'] = 'Abgeschlossen (festgelegt von {$a->overrideuser}). Auswählen, um als nicht abgeschlossen zu markieren.';
$string['completion-fail'] = 'Abgeschlossen (nicht bestanden)';
$string['completion-n'] = 'Nicht abgeschlossen';
$string['completion-n-override'] = 'Nicht abgeschlossen (festgelegt von {$a->overrideuser})';
$string['completion-pass'] = 'Abgeschlossen (bestanden)';
$string['completion-shorthand-alt-auto-enabled'] = 'Das System kennzeichnet dieses Element je nach den Bedingungen als vollständig';
$string['completion-shorthand-alt-auto-fail'] = 'Fehlgeschlagen <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-alt-auto-n'] = 'Nicht abgeschlossen';
$string['completion-shorthand-alt-auto-n-override'] = 'Nicht abgeschlossen <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-alt-auto-pass'] = 'Abgeschlossen (bestanden)';
$string['completion-shorthand-alt-auto-y'] = 'Abgeschlossen';
$string['completion-shorthand-alt-auto-y-override'] = 'Abgeschlossen  <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-alt-manual-enabled'] = 'Teilnehmer/innen können dieses Element als abgeschlossen markieren.';
$string['completion-shorthand-alt-manual-n'] = 'Nicht abgeschlossen';
$string['completion-shorthand-alt-manual-n-override'] = 'Nicht abgeschlossen';
$string['completion-shorthand-alt-manual-y'] = 'Abgeschlossen';
$string['completion-shorthand-alt-manual-y-override'] = 'Abgeschlossen <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-fail'] = 'Abgeschlossen <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-n'] = 'Nicht abgeschlossen';
$string['completion-shorthand-n-override'] = 'Nicht abgeschlossen <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-shorthand-pass'] = 'Abgeschlossen (bestanden)';
$string['completion-shorthand-y'] = 'Abgeschlossen';
$string['completion-shorthand-y-override'] = 'Abgeschlossen <i class="fa fa-exclamation-triangle text-white"></i>';
$string['completion-y'] = 'Abgeschlossen';
$string['completion-y-override'] = 'Abgeschlossen (festgelegt von {$a->overrideuser})(';
$string['completion_manual:aria:done'] = '{$a} ist als erledigt markiert. Zum Rückgängigmachen drücken.';
$string['completion_manual:aria:markdone'] = 'Als erledigt {$a} markiert';
$string['completion_manual:done'] = 'Erledigt am';
$string['completion_manual:markdone'] = 'Als erledigt markieren';
$string['completion_manual:markdone:completeby'] = 'Als erledigt markiert von';
$string['completion_manual:markdone:duetoday'] = 'Heute als erledigt markiert';
$string['completion_manual:markdone:overdue'] = 'Als erledigt markiert ist überfällig';
$string['completionbackgroundimage'] = 'Hintergrundbild (abgeschlossen)';
$string['completioncheckmark'] = 'Häkchen bei Abschluss des Kurses anzeigen';
$string['completioncheckmark_help'] = 'In den Ringdiagrammen wird ein Häkchen anstelle von 100 % angezeigt.';
$string['completioncriteria'] = 'Abschlusskriterium';
$string['completionindicator'] = 'Abschlussanzeige';
$string['completionindicator_help'] = '<b> Deaktiviert: </b> Anzeige nicht anzeigen. <br>
<b> Unter dem Kursfortschritt: </b> Anzeige unterhalb des Kursfortschritts (je nach Konfiguration kann dies entweder der Kreis oder der Balken sein). <br>
<b> Mit Kursmetadaten: </b> Anzeige neben dem "Kursabschlussdatum". <br>';
$string['completionstatusindicator'] = 'Abschlussstatusanzeige';
$string['completiontrackingautomatic'] = 'Automatischer Abschluss';
$string['completiontrackingmanual'] = 'Manueller Abschluss';
$string['completiontrackingmissing'] = 'Schalten Sie die Abschlussverfolgung ein, um das Kursabschlussdatum anzuzeigen';
$string['configcoursefield'] = 'Icon für {$a->name}';
$string['configcoursefields'] = 'Anzuzeigende Kursfelder';
$string['configcoursefields_help'] = 'Die ausgewählten Kursfelder werden in der Kurs-Header angezeigt';
$string['configcourseicons'] = 'Icons der Kursfelder';
$string['configtitle'] = 'Standardoptionen von Designer';
$string['content'] = 'Inhalt';
$string['coursebackground'] = 'Kurshintergrund';
$string['coursebackgroundcolor'] = 'Hintergrundfarbe des Kurses';
$string['coursebackgroundcolor_help'] = 'Mit dieser Option wird eine ausgewählte Hintergrundfarbe für den gesamten Kurs verwendet. Diese Einstellung ist optional, und Sie können das Feld leer lassen, wenn Sie keine bestimmte Hintergrundfarbe festlegen möchten.';
$string['coursebackgroundimage'] = 'Hintergrundbild des Kurses';
$string['coursebackgroundimage_help'] = 'Wenn Sie ein Bild als Hintergrund für den gesamten Kurs wünschen, können Sie es hier hochladen. Nach dem Hochladen wird dieses Bild als Hintergrund für den gesamten Kurs angezeigt. Diese Einstellung ist optional. Sie können das Feld leer lassen, wenn Sie kein Hintergrundbild wünschen.';
$string['coursebackgroundtransparent'] = 'Transparenter Kurs';
$string['coursebackgroundtransparent_help'] = 'Wenn Sie diese Option aktiviert ist, wird die Hintergrundfarbe von Containerelementen innerhalb des Kurses, die derzeit eine Hintergrundfarbe haben, auf transparent gesetzt. Dies kann einen visuell ansprechenden Effekt erzeugen, bei dem die Elemente über dem Hintergrund zu schweben scheinen.';
$string['coursecompleted'] = 'Kurs abgeschlossen';
$string['coursecompletiondate'] = 'Kursabschlussdatum';
$string['coursecompletiondate_help'] = 'Das Kursabschlussdatum einer Person wird im Abschnitt "Zeit" angezeigt.';
$string['coursecustomfields'] = 'Kursfelder';
$string['courseduedate'] = 'Kursfälligkeitsdatum';
$string['courseduedate_help'] = 'Das Kursfälligkeitsdatum wird im Abschnitt "Kurszeit" angezeigt. Dies funktioniert nur, wenn Lerntools und Zeitmanagement-Tool installiert und aktiviert sind.';
$string['courseheader'] = 'Kurs-Header';
$string['courseheaderbgcolor'] = 'Hintergrundfarbe';
$string['courseheaderbgcolor_help'] = 'Die Hintergrundfarbe wird sowohl auf den Header als auch auf die sekundäre Navigation angewendet.';
$string['courseheaderbgimage'] = 'Hintergrundbild';
$string['courseheaderbgimage_help'] = 'Das Hintergrundbild dient dem Kurs-Header, nicht der sekundären Navigation. Um eine gute Lesbarkeit zu gewährleisten, insbesondere bei hellen Textfarben, verwenden Sie bitte eine passende Hintergrundfarbe.';
$string['courseheaderheight'] = 'Mindesthöhe';
$string['courseheaderheight_help'] = 'Geben Sie die Mindesthöhe (in Zahlen) für den Kurs-Header an.';
$string['courseheadersize'] = 'Vollbild';
$string['courseheadersize_help'] = 'Wenn diese Option aktiviert ist, nimmt der Kurs-Header die gesamte Bildschirmhöhe ein.';
$string['courseheadersummary'] = 'Zusammenfassung';
$string['courseheadersummary_help'] = '<b>Deaktiviert</b>: Diese Option zeigt keine Zusammenfassung im Kurs-Header an.<br>
<b>Gekürzt</b>: Wenn Sie diese Option wählen, wird die Kurszusammenfassung basierend auf der globalen Einstellung "Länge kürzen" gekürzt.<br>
<b>Komplett</b>: Wenn Sie diese Option wählen, wird die vollständige Kurszusammenfassung angezeigt.<br>';
$string['courseheadertextcolor'] = 'Textfarbe';
$string['courseheadertextcolor_help'] = 'Um eine gute Lesbarkeit zu gewährleisten, verwenden Sie bitte für den Kurs-Header und die Sekundärnavigation eine passende Hintergrundfarbe unter Berücksichtigung der verwendeten Textfarbe.';
$string['courseheadertimemanagement'] = 'Zeitmanagement';
$string['courseheadertimemanagement_help'] = 'Wählen Sie die zeitbezogenen Elemente aus, die im Kurs-Header angezeigt werden sollen. Sie können zwischen Einschreibedatum, Einschreibeende, Fälligkeitsdatum und Abschlussdatum wählen.';
$string['courseheadertype'] = 'Typ';
$string['courseheadertype_help'] = '<b>Keine</b>: Mit dieser Option wird der Kursseite kein Header hinzugefügt.<br>
<b>Hero</b>: Bei Auswahl dieser Option erstreckt sich die der Header über die gesamte Seitenbreite und bietet so eine optisch ansprechende Kurseinführung.<br>
<b>Inhalt</b>: Bei Auswahl dieser Option wird die Breite des Headers an den Kursinhalt angepasst, wodurch ein kompakteres Design gewährleistet wird.';
$string['courseindex'] = 'Sichtbarkeit des Kursindex';
$string['courseindex_help'] = 'Die Sichtbarkeit des Kursindexmenüs verwalten';
$string['courseindicator'] = 'Kursstatus:';
$string['courseprerequisitepos_help'] = 'Mit dieser Einstellung können Sie die Reihenfolge der Menüpunkte im sekundären Navigationsmenü festlegen. Menüpunkte mit negativen Werten werden vor dem Kursmenüpunkt eingefügt, Menüpunkte mit positiven Werten werden danach eingefügt. In der Regel ist es sinnvoller, positive Zahlen zu verwenden.';
$string['courseprerequisites'] = 'Kursvorbedingungen';
$string['courseprerequisitestabhead'] = 'Titel des Voraussetzungen-Tabs anzeigen.';
$string['courseprerequisitestabhead_help'] = 'Titel des vorausgesetzten Kurses';
$string['courseprerequisitestitle'] = 'Vorbedingungen-Titel';
$string['courseprerequisitestitle_help'] = 'Titel des Voraussetzungen-Tabs';
$string['courseprogresstype'] = 'Kursfortschritt';
$string['courseprogresstype_help'] = '<b>Deaktiviert</b>: Wenn diese Option aktiviert ist, werden im Header keine Informationen zum Kursfortschritt angezeigt.<br>
<b>Fortschrittsbalken</b>: Wenn diese Option aktiviert ist, wird der Kursfortschritt als Balken angezeigt, der den des Kurses anzeigt.<br>
<b>Ringdiagramm</b>: Wenn diese Option aktiviert ist, wird der Kursfortschritt als Ringdiagramm angezeigt und bietet so eine alternative visuelle Darstellung.<br>';
$string['coursesettings'] = 'Kurs';
$string['coursestartdate'] = 'Kursbeginn';
$string['coursetype'] = 'Kurstyp';
$string['coursetype_help'] = 'Wenn Kanban-Board als Kurstyp festgelegt ist, werden Kursabschnitte horizontal angezeigt.
Zusammenklappbare Abschnitte funktionieren im Kanban-Modus nicht.';
$string['create_purpose'] = 'Zweck erstellen';
$string['createprereqgroup'] = 'Vorbedingungsgruppe erstellen';
$string['criteriacompleted'] = '{$a->completed} von {$a->count} Kriterien abgeschlossen';
$string['criteriaprogressinfo'] = 'Informationen im Kriterien-Fortschrittsbalken';
$string['criteriaprogressinfo_help'] = 'Tipp: Klicken Sie oben auf den Fortschrittsbalken, um zu sehen, welche Aktivitäten/Vorbedingungen Sie bereits abgeschlossen haben und welche noch nicht abgeschlossen sind.';
$string['currentsection'] = 'Dieser Designer Abschnitt';
$string['customnameinactivityitem'] = 'Nutzerdefinierten Namen auf Kurs-/Abschnittsseiten verwenden';
$string['customnameincourseindex'] = 'Nutzerdefinierten Namen im Kursindex verwenden';
$string['dateformat'] = 'Datumsformat';
$string['dateformat_help'] = 'Datumsformat für Abschlussinformationen (z.B. Abschluss bis Datum x)';
$string['delete_purpose'] = 'Zweck löschen';
$string['deletegroup'] = 'Gruppe löschen';
$string['deletesection'] = 'Designer-Abschnitt löschen';
$string['deletesuccess'] = 'Erfolgreich gelöscht';
$string['designer:changesectionoptions'] = 'Abschnittsoption ändern, wie z.B. Typ';
$string['designercustombgposition'] = 'Nutzerdefinierte Hintergrundsposition';
$string['designercustombgsize'] = 'Nutzerdefinierte Hintergrundgröße';
$string['desktopcolumn'] = 'Layout-Spalten - Desktop';
$string['desktopwidth'] = 'Abschnittsbreite in Desktopgröße';
$string['desktopwidth_help'] = 'Der Abschnitt wird in der gewählten Breite in Desktopgröße angezeigt.
Dies funktioniert nur bei einem Abschnitt pro Seite.';
$string['disabled'] = 'Deaktiviert';
$string['displaycourseprerequisites'] = 'Kursvorbedingungen anzeigen';
$string['displaycourseprerequisites_help'] = 'Definieren wo die vorbedingten Kurse dargestellt werden sollen';
$string['displayheaderroleusers'] = 'Wählen Sie die Rolle des Lehrpersonals';
$string['displayheaderroleusers_help'] = 'Nutzer/innen mit diesen ausgewählten Rollen werden im Kurs-Header angezeigt.';
$string['displayoncourseandsectionpage'] = 'Auf der Kurs- und Abschnittsseite anzeigen';
$string['displayoncoursepage'] = 'Auf der Kursseite anzeigen';
$string['displayonsectionpageonly'] = 'Nur auf der Abschnittsseite anzeigen';
$string['displayprogress'] = 'Fortschritt anzeigen';
$string['displayunavailableactivities'] = 'Nicht verfügbare Aktivitäten anzeigen';
$string['displayunavailableactivities_help'] = '<b>Verbergen</b> – Aktivitäten werden nicht angezeigt, wenn die aktuelle Person keinen Zugriff auf den Abschnitt hat.<br>
<b>Anzeigen</b> – Aktivitäten werden angezeigt, auch wenn die aktuelle Person keinen Zugriff darauf hat, solange sie sichtbar sind.';
$string['done'] = 'Erledigt';
$string['donottrim'] = 'Nicht kürzen';
$string['donut'] = 'Ringdiagramm';
$string['duetoday'] = 'Heute fällig';
$string['edit_purpose'] = 'Zwecke bearbeiten';
$string['editsection'] = 'Designer-Abschnitt bearbeiten';
$string['editsectionname'] = 'Name des Designer-Abschnitts beabeiten';
$string['enabled'] = 'Aktiviert';
$string['enrolmentenddate'] = 'Einschreibeende';
$string['enrolmentenddate_help'] = 'Das jeweilige Einschreibeende der/s Nutzer/in in den aktuellen Kurs wird im Kurs-Header angezeigt.';
$string['enrolmentstartdate'] = 'Einschreibedatum';
$string['enrolmentstartdate_help'] = 'Das Einschreibedatum der/s Nutzer/in in den aktuellen Kurs wird im Kurs-Header angezeigt.';
$string['everywhere'] = 'Überall';
$string['expand'] = 'Ausgeklappt';
$string['failed'] = 'Fehlgeschlagen am';
$string['firstexpand'] = 'Erster ausgeklappt';
$string['fivecolumn'] = 'Fünf Spalten';
$string['flowanimationduration'] = 'Dauer der Flow-Animation';
$string['flowanimationduration_help'] = 'Ändern Sie die Animationsdauer für die Flow-Animation';
$string['flowsize'] = 'Flow-Größe';
$string['flowsize_help'] = 'Die Flow-Größe ist eine Einstellung, mit der Sie die Breite und Höhe von Abschnitten und Aktivitäten in Ihrem Kurs anpassen können.<br><b>Klein</b>: Diese Option legt die Breite und Höhe von Abschnitten und Aktivitäten auf 320 x 320 Pixel fest.<br><b>Mittel</b>: Wählen Sie diese Option, um die Breite und Höhe auf 360 x 360 Pixel zu erhöhen.<br><b>Groß</b>: Wenn Sie ein geräumiges Layout bevorzugen, wählen Sie diese Option, um die Breite und Höhe von Abschnitten und Aktivitäten auf 400 x 400 Pixel festzulegen.';
$string['fourcolumn'] = 'Vier Spalten';
$string['full'] = 'Komplett';
$string['general'] = 'Allgemein';
$string['general_settings'] = 'Allgemeine Einstellungen';
$string['generalsectionconfig'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" >Allgemeine Stile der Module</h5>';
$string['generalsettings'] = 'Allgemeine Einstellungen von Designer';
$string['gotosection'] = 'Zum Abschnitt';
$string['groupnotfound'] = 'Gruppe nicht gefunden';
$string['hero'] = 'Hero';
$string['heroactivity'] = 'Hero-Aktivität';
$string['heroactivity_help'] = 'Mit Designer haben Trainer/innen die Möglichkeit, bestimmte Aktivitäten zu "Hero-Aktivitäten" zu machen. Diese werden der sekundären Navigation hinzugefügt, um den Teilnehmer/innen den Zugriff zu erleichtern.';
$string['heroactivitypos_help'] = 'Mit dieser Einstellung können Sie die Reihenfolge der Menüpunkte im sekundären Navigationsmenü festlegen. Menüpunkte mit negativen Werten werden vor dem Kursmenüpunkt eingefügt, Menüpunkte mit positiven Werten werden danach eingefügt. In der Regel ist es sinnvoller, positive Zahlen zu verwenden.
    Diese Einstellung funktioniert als Standard und kann in den Aktivitätseinstellungen überschrieben werden.';
$string['hideeverywhere'] = 'Überall verbergen';
$string['hidefromothers'] = 'Verbergen';
$string['hideoncourses'] = 'Auf Kursseiten verbergen';
$string['hideonhover'] = 'Beim Hovern verbergen';
$string['hidesectiontitle'] = 'Abschnittstitel verbergen';
$string['horizontal_circles'] = 'Horizontale Kreise';
$string['initialstate'] = 'Ausgangszustand';
$string['kanbanboard'] = 'Kanban Board';
$string['large'] = 'Groß';
$string['leftbottom'] = 'Links unten';
$string['leftcenter'] = 'Links halbe Höhe';
$string['lefttop'] = 'Links oben';
$string['less'] = 'Weniger';
$string['link'] = 'Textlinks (Standard)';
$string['list'] = 'Liste';
$string['listprereqgroup'] = 'Vorbedingungsgruppen';
$string['listwidth'] = 'Breite der Liste';
$string['mail'] = 'Mail';
$string['makeherohide'] = 'Hero-Aktivität erstellen und Kursabschnitt 0 verbergen';
$string['makeherovisible'] = 'Hero-Aktivität erstellen und Kursabschnitt 0 sichtbar behalten';
$string['managepurposes'] = 'Zwecke verwalten';
$string['markasdone'] = 'Als erledigt markieren';
$string['maskimage_help'] = 'Das ausgewählte Maskenbild wird im Abschnittsblock angezeigt.';
$string['medium'] = 'Mittel';
$string['message'] = 'Nachricht';
$string['minheight'] = 'Mindesthöhe';
$string['minheight_help'] = 'Aktivitätsblöcke werden in der angegebenen Höhe angezeigt. Verwenden Sie Werte wie 200px, auto, 4rem ...';
$string['mobilecolumn'] = 'Layout-Spalten - Mobile';
$string['mobilewidth'] = 'Abschnittsbreite in Mobilgröße';
$string['mobilewidth_help'] = 'Der Abschnitt wird in der gewählten Breite in Mobilgröße angezeigt.
Dies funktioniert nur bei einem Abschnitt pro Seite.';
$string['modtrimlength'] = 'Länge kürzen';
$string['modtrimlength_desc'] = 'In diesem numerischen Eingabefeld können Sie festlegen, wie viel Text im reduzierten Zustand angezeigt werden soll. Geben Sie die gewünschte Zeichenanzahl ein, um die Länge der gekürzten Beschreibung zu steuern.';
$string['modulepurposes'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2">Modulzwecke</h5>';
$string['modvisit'] = '{$a} Aufrufe';
$string['monthandday'] = '%b %e';
$string['more'] = 'Mehr';
$string['move_item'] = 'Diesen Kurs verschieben';
$string['never'] = 'Nie';
$string['newsectionname'] = 'Neuer Name für Designer-Abschnitt {$a}';
$string['nocourses'] = 'Keine Kurse';
$string['nogroupsfound'] = 'Keine Gruppe gefunden';
$string['normal'] = 'Normal';
$string['notvisit'] = 'Noch keine Aufrufe';
$string['notyetcompleted'] = 'Noch nicht abgeschlossen';
$string['onecolumn'] = 'Einzelne Spalte';
$string['onlycoursepage'] = 'Nur auf der Kurshauptseite';
$string['onseparatetab'] = 'In einem separaten Tab';
$string['overdue'] = 'Überfällig';
$string['overdues'] = '{$a->overdues} überfällige';
$string['page-course-view-designer'] = 'Jede Kurshauptseite im Designer-Format';
$string['page-course-view-designer-x'] = 'Jede Kursseite im Designer-Format';
$string['passed'] = 'Weitergegeben';
$string['plugin_description'] = 'Layouts kombinieren, um einzigartige und optisch ansprechende Kursdesigns zu erstellen.';
$string['pluginname'] = 'Designer-Format';
$string['popupactivities'] = 'Aktivitäten in Popups darstellen';
$string['popupactivities_help'] = 'Wenn diese Option aktiviert ist, werden bestimmte Typen von Ressourcen in Popups angezeigt.';
$string['popupactivitiesnotinstalled'] = 'Um die Aktivitäten in Popups anzuzeigen, muss das Popup-Format installiert werden.';
$string['pregroups'] = 'Voraussetzungen-Gruppen';
$string['prerequisitesautostudents'] = 'Teilnehmer/innen automatisch einschreiben';
$string['prerequisitesautostudents_help'] = 'Teilnehmer/innen automatisch in vorbedingte Kurse einschreiben';
$string['prerequisitesbackmain'] = 'Zurück zum Hauptkurs';
$string['prerequisitesbackmain_help'] = 'Zur Hauptseite des vorausgesetzten Kurses zurückkehren';
$string['prerequisitesdesc'] = 'Schließen Sie bitte alle folgenden Kurse ab:';
$string['prerequisitesnewtab'] = 'Voraussetzungen in neuem Tab öffnen';
$string['privacy:metadata'] = 'Das Designer-Format speichert keine personenbezogenen Daten.';
$string['profilefieditem_help'] = 'Das Benutzerprofilfeld im Kurspersonalblock anzeigen.';
$string['progressbar'] = 'Fortschrittsbalken';
$string['purpose'] = 'Zweck';
$string['purpose_created'] = 'Zweck erfolgreich angelegt';
$string['purpose_deleted'] = 'Zweck erfolgreich gelöscht';
$string['purpose_edited'] = 'Zweck erfolgreich bearbeitet';
$string['purposeadministration'] = 'Adminstration';
$string['purposeassessment'] = 'Beurteilung';
$string['purposeclass'] = 'Nutzerdefinierte Klasse für das Styling';
$string['purposecollaboration'] = 'Kollaboration';
$string['purposecommunication'] = 'Kommunikation';
$string['purposecontent'] = 'Inhalt';
$string['purposeicon'] = 'Zweck-Icon';
$string['purposeinteractivecontent'] = 'Interaktiver Inhalt';
$string['purposeinterface'] = 'Interface';
$string['purposeother'] = 'Andere';
$string['purposesetting'] = 'Zweck';
$string['relevantactivities'] = 'Relevante Aktivitäten';
$string['rightbottom'] = 'Rechts unten';
$string['rightcenter'] = 'Rechts halbe Höhe';
$string['righttop'] = 'Rechts oben';
$string['secondarymenu'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > sekundäre Navigation </h5>';
$string['secondarymeu_title'] = 'Titel in der sekundären Navigation';
$string['section0name'] = 'Allgemein';
$string['section_layout'] = 'Abschnittslayout';
$string['sectionbackdesignheader'] = 'Design';
$string['sectionbackgroundheader'] = '<h5 class="font-weight-normal font-italic pt-2 pb-2" > Abschnittshintergrundstile </h5>';
$string['sectionbackgroundtype'] = '<b> Abschnittsüberschrift ausgewählt </b>, die Hintergrund- und Textfarbe wird nur auf den Inhalt der Kopfzeile angewendet.
<b>Kompletten Abschnitt ausgewählt </b>, der Hintergrund wird auf den gesamten Abschnitt angewendet.';
$string['sectionbackgroundtype_help'] = '<b> Abschnittsüberschrift ausgewählt </b>, die Hintergrund- und Textfarbe wird nur auf den Inhalt der Kopfzeile angewendet.
<b>Kompletten Abschnitt ausgewählt </b>, der Hintergrund wird auf den gesamten Abschnitt angewendet.';
$string['sectioncardheader'] = 'Inhalt der Abschnittskarten';
$string['sectioncardredirect'] = 'An externe URL weiterleiten';
$string['sectioncardsummary'] = 'Abschnittszusammenfassung';
$string['sectioncardtab'] = 'Weiterleitung in neuem Tab öffnen';
$string['sectioncardtitle'] = 'Titel des Abschnitt';
$string['sectioncompleted'] = 'Abschnitt abgeschlossen';
$string['sectioncontainer'] = 'Abschnittscontainer';
$string['sectioncontainerwidth'] = 'Breite des Abschnittscontainers';
$string['sectioncontent'] = 'Abschnittsinhalt';
$string['sectioncontentwidth'] = 'Breite des Abschnittsinhalts';
$string['sectiondesignertextcolor'] = 'Die Textfarbe wird nur für den Titel und die Zusammenfassung des Abschnitts verwendet.';
$string['sectiondesignertextcolor_help'] = 'Die Textfarbe wird nur für den Titel und die Zusammenfassung des Abschnitts verwendet.';
$string['sectiondesignheader'] = 'Design';
$string['sectionestimatetime'] = 'Geschätzte Zeit';
$string['sectionestimatetime_help'] = 'Geben Sie die geschätzte Zeit für den Abschnitt ein.';
$string['sectionheader'] = 'Abschnittsüberschrift';
$string['sectionlayouts'] = 'Layouts';
$string['sectionlink'] = 'Permalink';
$string['sectionname'] = 'Designer-Abschnitt';
$string['sectionprogresstype'] = 'Abschnittsfortschritt';
$string['sectionprogresstype_help'] = '<b>Deaktiviert</b>: Wenn diese Option aktiviert ist, werden im Header keine Informationen zum Abschnittsfortschritt angezeigt.<br>
<b>Fortschrittsbalken</b>: Wenn diese Option aktiviert ist, wird der Abschnittsfortschritt als Balken angezeigt, der den Abschlussstatus einzelner Kursabschnitte anzeigt.<br>
<b>Ringdiagramm</b>: Wenn diese Option aktiviert ist, wird der Abschnittsfortschritt als Ringdiagramm angezeigt und bietet so eine alternative visuelle Darstellung.<br>';
$string['sections'] = 'Abschnitte';
$string['sectionsettings'] = 'Abschnitt';
$string['sectiontype'] = 'Abschnittstyp';
$string['sectionzeroactivities'] = 'Aktivitäten Kursabschnitt 0';
$string['sectionzeroactivities_help'] = 'Diese Einstellung legt fest, ob Aktivitäten im allgemeinen Abschnitt automatisch zu Hero-Aktivitäten werden sollen.
    Designer kann den allgemeinen Abschnitt automatisch ausblenden, wenn die Bearbeitung ausgeschaltet ist. Dies ist nützlich, wenn Sie möchten, dass die Teilnehmer/innen nur über die Sekundärnavigation auf die Aktivitäten im allgemeinen Bereich zugreifen können. Diese Einstellung funktioniert als Standard und kann in den Aktivitätseinstellungen überschrieben werden.';
$string['showanimation'] = 'Flow-Animation';
$string['showanimation_help'] = 'Aktivieren Sie diese Option, um die Module mit einem Animationseffekt anzuzeigen.';
$string['showastab'] = 'Als Tab anzeigen';
$string['showastab_help'] = 'Mit dieser Einstellung können Sie festlegen, auf welchen Seiten die Menüpunkte für die Hero-Aktivitäten zum sekundären Navigationsmenü hinzugefügt werden sollen. Sie können sie entweder im gesamten Kurs oder auf der Kurshauptseite anzeigen lassen.
Diese Einstellung ist standardmäßig aktiviert und kann in den Aktivitätseinstellungen überschrieben werden.';
$string['showfromothers'] = 'Sichtbar machen';
$string['showonhover'] = 'Beim Hovern anzeigen';
$string['small'] = 'Klein';
$string['start'] = 'Start';
$string['stractivity'] = 'Aktivität';
$string['stractivitytitle'] = 'Aktivitätstitel';
$string['stractivitytype'] = 'Aktivitätstyp';
$string['stravoidduplicateentry'] = 'Doppelte Einträge vermeiden';
$string['strcompleted'] = 'Abgeschlossen';
$string['strcourse'] = 'Kurs';
$string['strcustom'] = 'Nutzerdefiniert';
$string['strcustomtitle'] = 'Nutzerdefinierter Titel';
$string['strenrolled'] = 'Eingeschrieben';
$string['strprerequisiteinfo'] = 'Vorbedingungen-Info';
$string['strprerequisiteinfo_help'] = 'Den Text über den Vorbedingungen anzeigen.';
$string['strprerequisites'] = 'Vorbedingungen';
$string['strprerequisites_role'] = 'Rolle für automatisch eingeschriebene Teilnehmer/innen';
$string['strsecondarymenucourse'] = 'Kurs';
$string['strsecondarymenutocourse'] = 'Auf allen Kursseiten den Kurs zu der sekundären Navigation hinzufügen';
$string['strsecondarymenutocourse_help'] = 'Wenn diese Option aktiviert ist, wird auf allen Seiten des Kurses ein Link zum Kurs in der sekundären Navigation hinzugefügt';
$string['strsection'] = 'Abschnitt';
$string['strsectionlayout'] = 'Abschnittslayout';
$string['strtodo'] = 'TODO';
$string['struppercompleted'] = 'ABGESCHLOSSEN';
$string['subcoursedisplayprogress'] = 'Den Kursfortschritt der Unterkurse als Aktivitätsfortschritt verwenden';
$string['summarylength'] = 'Länge der Zusammenfassung';
$string['summarylengthdesc'] = 'Geben Sie die Länge an, auf welche die Zusammenfassung gekürzt welchen soll.';
$string['tabletcolumn'] = 'Layout-Spalten - Tablet';
$string['tabletwidth'] = 'Abschnittsbreite in Tabletgröße';
$string['tabletwidth_help'] = 'Der Abschnitt wird in der gewählten Breite in Tabletgröße angezeigt.
Dies funktioniert nur bei einem Abschnitt pro Seite.';
$string['textcolor'] = 'Textfarbe';
$string['threecolumn'] = 'Drei Spalten';
$string['timeago'] = 'vor';
$string['timeagoday'] = 'Tag';
$string['timeagohour'] = 'Stunde';
$string['timeagojustnow'] = 'jetzt';
$string['timeagominute'] = 'Minute';
$string['timeagomonth'] = 'Monat';
$string['timeagosecond'] = 'Sekunde';
$string['timeagoweek'] = 'Woche';
$string['timeagoyear'] = 'Jahr';
$string['timemanagementmissing'] = 'Für diese Funktion ist Learning Tools Pro erforderlich. <a href="https://bdecent.de/product/learning-tools-pro/">Weitere Informationen</a>.';
$string['title'] = 'Titel';
$string['todaydue'] = '{$a->due} heute fällig';
$string['trimmed'] = 'Gekürzt';
$string['twocolumn'] = 'Zwei Spalten';
$string['type_flow'] = 'Flow';
$string['useactivityimage'] = 'Aktivitätsbild verwenden';
$string['usecompletionbg'] = 'Für den Abschluss einen anderen Hintergrund verwenden';
$string['userfields'] = 'Felder des Nutzerprofils';
$string['userfields_help'] = 'Wählen Sie Profilfelder aus, die im Kurs-Header angezeigt werden sollen.';
$string['usstandarddate'] = '%d.%m.%Y %I:%M %p';
$string['verticalcircles'] = 'Vertikale Kreise';
$string['wholesection'] = 'Ganzer Abschnitt';
$string['withcoursemetadata'] = 'Mit Kursmetadaten';
