<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_boost_union', language 'de', version '4.4'.
 *
 * @package     theme_boost_union
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutuscontentsetting'] = 'Inhalt \'Über uns\'';
$string['aboutuscontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf der Seite \'Über uns\' angezeigt werden.';
$string['aboutusdisabled'] = 'Die Seite \'Über uns\' ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['aboutusheading'] = 'Über uns';
$string['aboutuslinkpositionboth'] = 'Link zur Seite \'Über uns\' in der Fußnote und zum Footer-Icon (Fragezeichen) hinzufügen';
$string['aboutuslinkpositionfooter'] = 'Link zur Seite \'Über uns\' zum Footer-Icon (Fragezeichen) hinzufügen';
$string['aboutuslinkpositionfootnote'] = 'Link zur Seite \'Über uns\' in der Fußnote hinzufügen';
$string['aboutuslinkpositionnone'] = 'Link zur Seite \'Über uns\' nicht automatisch anzeigen';
$string['aboutuslinkpositionsetting'] = 'Linkposition für Seite \'Über uns\'';
$string['aboutuslinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link zur Seite \'Über uns\' hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['aboutuspagetitledefault'] = 'Über uns';
$string['aboutuspagetitlesetting'] = 'Titel für Seite \'Über uns\'';
$string['aboutuspagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Seite \'Über uns\' festlegen. Dieser Text wird auch als Linktext zur Seite \'Über uns\' verwendet, wenn Sie die "Linkposition für Seite \'Über uns\' " entsprechend konfigurieren.';
$string['accessibilitydeclarationcontentsetting'] = 'Erklärung zur Barrierefreiheit von Seiteninhalten';
$string['accessibilitydeclarationcontentsetting_desc'] = 'In dieser Einstellung können Sie Textinhalte hinzufügen, die auf einer Seite mit einer Erklärung zur Barrierefreiheit angezeigt werden.';
$string['accessibilitydeclarationdisabled'] = 'Die Seite mit der Erklärung zur Barrierefreiheit ist für diese Website deaktiviert. Hier gibt es nichts zu sehen.';
$string['accessibilitydeclarationheading'] = 'Erklärung zur Barrierefreiheit';
$string['accessibilitydeclarationlinkpositionboth'] = 'Fügen Sie der Fußnote und dem Fußzeilensymbol (Fragezeichen) einen Link für die Erklärung zur Barrierefreiheit hinzu';
$string['accessibilitydeclarationlinkpositionfooter'] = 'Fügen Sie dem Fußzeilensymbol (Fragezeichen) einen Link für die Erklärung zur Barrierefreiheit hinzu';
$string['accessibilitydeclarationlinkpositionfootnote'] = 'Fügen Sie der Fußnote einen Link für die Erklärung zur Barrierefreiheit hinzu';
$string['accessibilitydeclarationlinkpositionnone'] = 'Link für die Erklärung zur Barrierefreiheit nicht automatisch anzeigen';
$string['accessibilitydeclarationlinkpositionsetting'] = 'Linkposition für Erklärung zur Barrierefreiheit';
$string['accessibilitydeclarationlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob automatisch ein Link zur Erklärung zur Barrierefreiheit hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall einen Link {$a->url} manuell hinzufügen.';
$string['accessibilitydeclarationpagetitledefault'] = 'Erklärung zur Barrierefreiheit';
$string['accessibilitydeclarationpagetitlesetting'] = 'Seitentitel für Erklärung zur Barrierefreiheit';
$string['accessibilitydeclarationpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Seite mit der Erklärung zur Barrierefreiheit festlegen. Dieser Text wird auch als Linktext zur Seite mit der Erklärung zur Barrierefreiheit verwendet, wenn Sie die "Linkposition für die Erklärung zur Barrierefreiheit" entsprechend konfigurieren.';
$string['accessibilitydeclarationtab'] = 'Erklärung';
$string['accessibilitysupportanonymouscheckbox'] = 'Ich möchte meine Supportanfrage zur Barrierefreiheit lieber anonym senden';
$string['accessibilitysupportanonymousemail'] = 'anonymous@email.invalid';
$string['accessibilitysupportanonymoususer'] = 'Anonymer Nutzer';
$string['accessibilitysupportcontentdefault'] = '<p>Wenn Sie Feedback zur Barrierefreiheit haben oder eine Barriere melden möchten, verwenden Sie bitte das untenstehende Formular.</p><p>Arbeiten Sie mit unterstützenden Technologien wie Bildschirmlesegeräten, Vergrößerungsprogrammen, Sprachsteuerung oder Spracherkennungssoftware? Wenn ja, geben Sie bitte an, welche. Um uns bei der Bearbeitung Ihrer Anfrage zu helfen, können Sie dem Formular erlauben, die folgenden Informationen automatisch zusammen mit Ihrer Nachricht zu senden: Die URL, auf der Sie sich befanden, als Sie dieses Support-Formular geöffnet haben (dies wird als "Referrer" bezeichnet) und einige Informationen über Ihren Browser.</p>';
$string['accessibilitysupportcontentsetting'] = 'Inhalt der Supportseite zur Barrierefreiheit';
$string['accessibilitysupportcontentsetting_desc'] = 'In dieser Einstellung können Sie Textinhalte hinzufügen, die auf der Supportseite zur Barrierefreiheit angezeigt werden, zusammen mit einem Formular zum Senden von Feedback oder zum Melden einer Barriere.';
$string['accessibilitysupportdefaultsubject'] = 'Feedback zur Barrierefreiheit';
$string['accessibilitysupportdisabled'] = 'Die Supportseite zur Barrierefreiheit ist für diese Website deaktiviert. Hier gibt es nichts zu sehen.';
$string['accessibilitysupportheading'] = 'Supportseite zur Barrierefreiheit';
$string['accessibilitysupportlinkpositionboth'] = 'Fügen Sie der Fußnote und dem Fußzeilensymbol (Fragezeichen) einen Link für die Supportseite zur Barrierefreiheit hinzu';
$string['accessibilitysupportlinkpositionfooter'] = 'Fügen Sie dem Fußzeilensymbol (Fragezeichen) einen Link für die Supportseite zur Barrierefreiheit hinzu';
$string['accessibilitysupportlinkpositionfootnote'] = 'Fügen Sie der Fußnote einen Link für die Supportseite zur Barrierefreiheit hinzu';
$string['accessibilitysupportlinkpositionnone'] = 'Link für die Supportseite zur Barrierefreiheit nicht automatisch anzeigen';
$string['accessibilitysupportlinkpositionsetting'] = 'Linkpostition für Supportseite';
$string['accessibilitysupportlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob automatisch ein Link für die Supportseite zur Barrierefreiheit hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall einen Link {$a->url} manuell hinzufügen.';
$string['accessibilitysupportmessagenotsent'] = 'Leider konnte Ihre Supportanfrage zur Barrierefreiheit nicht gesendet werden.';
$string['accessibilitysupportmessagesent'] = 'Ihre Supportanfrage zur Barrierefreiheit wurde gesendet.';
$string['accessibilitysupportmessagetryagain'] = 'Bitte versuchen Sie es später noch einmal.';
$string['accessibilitysupportmessagetryalternative'] = 'Bitte versuchen Sie es später noch einmal oder senden Sie eine E-Mail direkt an <a href="mailto:{$a}">{$a}</a>.';
$string['accessibilitysupportpagesrlinktitledefault'] = 'Support zur Barrierefreiheit';
$string['accessibilitysupportpagesrlinktitlesetting'] = 'Linktitel des Screenreaders für Supportseite zur Barrierefreiheit';
$string['accessibilitysupportpagesrlinktitlesetting_desc'] = 'In dieser Einstellung können Sie den Titeltitel des Screenreader für die Supportseite zurr Barrierefreiheit definieren. Dieser Text wird als Linktext verwendet, der nur Screenreadern angezeigt wird.';
$string['accessibilitysupportpagetitledefault'] = 'Support zur Barrierefreiheit';
$string['accessibilitysupportpagetitlesetting'] = 'Seitentitel für Support zur Barrierefreiheit';
$string['accessibilitysupportpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Supportseite zur Barrierefreiheit definieren. Dieser Text wird auch als Linktext verwendet, wenn Sie die "Linkposition der Supportseite zur Barrierefreiheit“ entsprechend konfigurieren.';
$string['accessibilitysupportrecaptcha'] = 'ReCaptcha für Supportseite zur Barrierefreiheit hinzufügen';
$string['accessibilitysupportrecaptcha_desc'] = 'Mit dieser Einstellung steuern Sie, ob ein ReCaptcha für die Supportseite zur Barrierefreiheit hinzugefügt wird. Dies dient dazu, Spam und Missbrauch des Supportformulars zu verhindern, genau wie dies im <a href="{$a->support}">Supportformular des Moodle-Core</a> geschieht. Das Hinzufügen von ReCaptchas stellt jedoch eine zusätzliche Barriere für Screenreader oder andere unterstützende Technologien bedeutet, was in diesem Fall kontraproduktiv sein kann. Wählen Sie daher mit Bedacht aus, ob Sie diese Einstellung aktivieren möchten. Bitte beachten Sie außerdem, dass das ReCaptcha nur angezeigt wird, wenn Sie die erforderlichen <a href="{$a->settings}">API-Schlüssel in den Authentifizierungseinstellungen</a> festgelegt haben.';
$string['accessibilitysupportsentforanonymoususer'] = 'Nutzer/in möchte dieses Feedback zur Barrierefreiheit anonym zu senden.';
$string['accessibilitysupportsubmit'] = 'Absenden';
$string['accessibilitysupporttab'] = 'Supportseite';
$string['accessibilitysupporttechinfo'] = 'Technische Informationen';
$string['accessibilitysupporttechinfocheckbox'] = 'Ich bin damit einverstanden, die folgenden technischen Informationen zusammen mit meiner Nachricht zu senden.';
$string['accessibilitysupporttechinfolabel'] = 'Technische Informationen zum Mitsenden';
$string['accessibilitysupporttechinforeferrer'] = 'Referrer-Seite';
$string['accessibilitysupporttechinfosysinfo'] = 'Systeminformation';
$string['accessibilitysupportuserfirstname'] = 'Barrierefreiheit';
$string['accessibilitysupportuserlastname'] = 'Support';
$string['accessibilitysupportusermail'] = 'E-Mail für Support zur Barrierefreiheit';
$string['accessibilitysupportusermail_desc'] = 'Hier geben Sie die E-Mail-Adresse an, an die Supportanfragen zur Barrierefreiheit gesendet werden sollen. Wenn Sie dieses Feld leer lassen, werden die Anfragen an den <a href="{$a->url}">konfigurierten Site-Supportkontakt</a> gesendet.';
$string['accessibilitysupportusermailsubject'] = 'Supportanfrage zur Barrierefreiheit';
$string['activitiesheading'] = 'Aktivitätenblock';
$string['activitiestintenabled'] = 'Aktivitätssymbole einfärben';
$string['activitiestintenabled_desc'] = 'Mit dieser Einstellung können Sie die Aktivitätsymbole im Aktivitätenblock bezüglich ihres Zwecks einfärben. Standardmäßig zeigt Moodle Core schwarze Symbole an.';
$string['activitybrandingtab'] = 'Aktivitäten';
$string['activityiconcoloradministrationsetting'] = 'Icon-Farbe für Administration';
$string['activityiconcoloradministrationsetting_desc'] = 'Die Icon-Hintergrundsfarbe für Aktivitäten vom Typ Administration';
$string['activityiconcolorassessmentsetting'] = 'Icon-Farbe für Beurteilung';
$string['activityiconcolorassessmentsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Beurteilung';
$string['activityiconcolorcollaborationsetting'] = 'Icon-Farbe für Kollaboration';
$string['activityiconcolorcollaborationsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Kollaboration';
$string['activityiconcolorcommunicationsetting'] = 'Icon-Farbe für Kommunikation';
$string['activityiconcolorcommunicationsetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Kommunikation';
$string['activityiconcolorcontentsetting'] = 'Icon-Farbe für Inhalt';
$string['activityiconcolorcontentsetting_desc'] = 'Icon-Hintergrundsfarbe für Materialien vom Typ Inhalt';
$string['activityiconcolorfidelity_detailled'] = 'Detaillierte Forschung (bis zu 100 Iterationen)';
$string['activityiconcolorfidelity_insane'] = 'Wahnsinniger Quest (bis zu 500 Iterationen)';
$string['activityiconcolorfidelity_oneshot'] = 'Ein Schuss (1 Iteration)';
$string['activityiconcolorfidelity_sometries'] = 'Einige Versuche (bis zu 10 Iterationen)';
$string['activityiconcolorfidelitysetting'] = 'Aktivitätssymbol Farbtreue';
$string['activityiconcolorfidelitysetting_desc'] = 'Mit den obigen Einstellungen legen Sie eine Hex-Farbe fest, mit der das jeweilige Aktivitätsymbol eingefärbt wird. Technisch gesehen wird das Aktivitätsymbol jedoch mit einem CSS-Filter eingefärbt. Boost Union verwendet einen ausgefeilten Algoritmus, um einen CSS-Filter zu bestimmen, der der angegebenen Hex-Farbe visuell entspricht. Dieser Algorithmus basiert jedoch auf einer randomisierten Suche und kann suboptimale Ergebnisse erzielen, wenn er nur einmal ausgeführt wird. Mit dieser Einstellung können Sie Boost Union den Algorithmus mehrmals ausführen und den Filter auswählen, der am Ende am wenigsten von der Hex-Farbe abweicht. Bitte beachten Sie, dass diese Einstellung einen Einfluss auf das Cache-Löschen hat (je mehr Iterationen Sie zulassen, desto länger braucht Moodle zum Löschen des Design-Cache).';
$string['activityiconcolorinteractivecontentsetting'] = 'Aktivitätsymbolfarbe für "interaktiver Inhalt"';
$string['activityiconcolorinteractivecontentsetting_desc'] = 'Aktivitätsymbolfarbe für "interaktiver Inhalt"';
$string['activityiconcolorinterfacesetting'] = 'Icon-Farbe für Interface';
$string['activityiconcolorinterfacesetting_desc'] = 'Icon-Hintergrundsfarbe für Aktivitäten vom Typ Interface';
$string['activityiconcolorsheading'] = 'Icon-Farben für Aktivitäten';
$string['activitynavigationsetting'] = 'Elemente zur Aktivitäts- und Abschnittsnavigation';
$string['activitynavigationsetting_desc'] = 'Mit dieser Option werden die Elemente zum Springen zur vorherigen und nächsten Aktivität oder Ressource angezeigt, außerdem das Pulldown-Menü zum Springen zu einer bestimmten Aktivität oder Ressource im Kurs. Darüber hinaus werden in Kursen im Modus "Ein Abschnitt pro Seite" ähnliche Elemente fauch ür den vorherigen und nächsten Abschnitt angezeigt. Solche UI-Elemente gab es bei Boost im Moodle-Core bis 3.11, aber sie wurden in 4.0 entfernt. Mit Boost Union können Sie sie zurückholen.';
$string['activitypurposeadministration'] = 'Administration';
$string['activitypurposeassessment'] = 'Bewertung';
$string['activitypurposecollaboration'] = 'Kollaboration';
$string['activitypurposecommunication'] = 'Kommunikation';
$string['activitypurposecontent'] = 'Inhalt';
$string['activitypurposeheading'] = 'Zweck des Aktivitätssymbols';
$string['activitypurposeheading_desc'] = 'Mit diesen Einstellungen können Sie die Hintergrundfarbe des Aktivitätssymbols überschreiben, die durch den Zweck der Aktivität definiert wird (was eine fest codierte Eigenschaft in jeder Aktivität ist).';
$string['activitypurposeheadingtechnote'] = 'Technischer Hinweis: Aufgrund der Art und Weise, wie Moodle Core die Aktivitätszwecke und ihre Farben implementiert, werden die Aktivitätszwecke nur mit CSS von Boost Union überschrieben. Derzeit sollten alle Bereiche im Moodle-Kern abgedeckt sein, in denen farbige Aktivitätssymbole angezeigt werden. Wenn Sie einen Bereich oder ein Drittanbieter-Plugin entdecken, das weiterhin die unveränderten Aktivitätszweckfarben anzeigt, melden Sie es bitte auf {$a}.';
$string['activitypurposeinteractivecontent'] = 'Interaktiver Inhalt';
$string['activitypurposeinterface'] = 'Interface';
$string['activitypurposeother'] = 'Andere';
$string['additionalresourcesfileurlpersistent'] = 'URL (gleichbleibend)';
$string['additionalresourcesfileurlrevisioned'] = 'URL (revisioniert)';
$string['additionalresourcesheading'] = 'Zusätzliche Ressourcen';
$string['additionalresourceslistsetting'] = 'Liste von zusätzlichen Ressourcen';
$string['additionalresourceslistsetting_desc'] = 'Liste der Dateien, die in den Dateibereich "Zusätzliche Ressourcen" hochgeladen wurden. Sie können die angegebenen URLs verwenden, um die Dateien in zusätzlichem HTML, in nutzerdefiniertem CSS, in der Fußnote oder wo auch immer zu verlinken. Dies ist überall dort hilfreich, wo Sie keine Dateien hochladen können.';
$string['additionalresourcessetting'] = 'Zusätzliche Ressourcen';
$string['additionalresourcessetting_desc'] = 'Mit dieser Einstellung können Sie zusätzliche Ressourcen zum Design hochladen. Der Vorteil dieses Dateibereichs besteht darin, dass die Dateien ausgeliefert werden, ohne dass jemand angemeldet sein muss. An dieser Stelle sollten Sie nur unkritische Dateien hinzufügen, auf die jeder ohne Anmeldung zugreifen darf. Sobald Sie mindestens eine Datei in diesen Dateibereich hochgeladen und die Einstellungen gespeichert haben, sehen Sie eine Liste mit URLs, die auf die jeweiligen Dateien verweisen.';
$string['addpreferredlangsetting'] = 'Link zur bevorzugten Sprache im Sprachmenü hinzufügen';
$string['addpreferredlangsetting_desc'] = 'Mit dieser Einstellung können Sie dem Sprachmenü die Einstellung "Bevorzugte Sprache festlegen" hinzufügen. Verständlicherweise wird diese Einstellung nur verarbeitet, wenn die Einstellung <a href="{$a->url1}">Sprachmenü anzeigen</a> aktiviert ist, mindestens <a href="{$a->url2} ">ein zweites Sprachpaket</a> installiert ist und <a href="{$a->url3}">zur Auswahl</a> angeboten wird.';
$string['administrationtab'] = 'Administration';
$string['allowaccessibilitysupportwithoutlogin'] = 'Supportseite zur Barrierefreiheit ohne Anmeldung zulassen';
$string['allowaccessibilitysupportwithoutlogin_desc'] = 'Wenn diese Einstellung aktiviert ist, wird die Supportseite zur Barrierefreiheit auch nicht angemeldeten Personen angezeigt. Wenn diese Einstellung deaktiviert ist, können nur angemeldete Nutzer/innen auf die Supportseite zugreifen.';
$string['allowanonymoussubmitssetting'] = 'Anonyme Supportanfragen zulassen';
$string['allowanonymoussubmitssetting_desc'] = 'Mit dieser Einstellung können Sie erlauben, Feedback anonym über die Supportseite zur Barrierefreiheit zu senden. Nutzer/innen können dann entscheiden, ob sie Feedback anonym senden möchten (ohne ihren Anmeldenamen und ihre E-Mail-Adresse zu senden) oder nicht.';
$string['allowsendtechinfoalongsetting'] = 'Technische Informationen zum Mitsenden Zulassen';
$string['allowsendtechinfoalongsetting_desc'] = 'Mit dieser Einstellung können Sie erlauben, auf der Supportseite zur Barrierefreiheit technische Informationen mitzusenden. Nutzer/innen können dann entscheiden, ob sie technische Informationen mitsenden möchten oder nicht.';
$string['alternativelogolinkurlsetting'] = 'Alternative Logo-Link-URL';
$string['alternativelogolinkurlsetting_desc'] = 'Mit dieser Einstellung können Sie eine alternative Link-URL festlegen, die als Link auf das Logo in der Navigationsleiste verwendet wird. Mit dieser Einstellung können Sie beispielsweise einen Link zur Website Ihrer Organisation anstelle der Moodle-Startseite erstellen und so eine einheitliche Navigationsleiste in allen Systemen Ihrer Organisation beibehalten.';
$string['always'] = 'Immer';
$string['auto'] = 'Automatisch';
$string['backgroundimagepositionsetting'] = 'Position des Hintergrundbildes';
$string['backgroundimagepositionsetting_desc'] = 'Mit dieser Einstellung steuern Sie die Position des Hintergrundbildes innerhalb des Browserfensters. Der erste Wert ist die horizontale Position, der zweite Wert ist die vertikale Position.';
$string['backgroundimagesetting'] = 'Hintergrundbild';
$string['backgroundimagesetting_desc'] = 'Hier können Sie ein nutzerdefiniertes Bild hochladen, das als Hintergrund der Website angezeigt wird. Das Hintergrundbild, das Sie hier hochladen, überschreibt das Hintergrundbild in Ihren voreingestellten Designdateien.';
$string['backgroundimagesheading'] = 'Hintergrundbilder';
$string['backtotop'] = 'Nach oben';
$string['backtotopbuttonsetting'] = 'Taste "Nach oben"';
$string['backtotopbuttonsetting_desc'] = 'Mit dieser Einstellung erscheint eine Taste "Nach oben" in der unteren rechten Ecke der Seite, sobald Nutzer/innen die Seite nach unten scrollen. Eine solche Taste gab es bereits für das Design Boost im Moodle-Core bis Moodle 3.11, sie wurde aber in 4.0 entfernt. Im Design Boost Union können Sie diese Taste zurückholen.';
$string['blockdrawerwidthsetting'] = 'Breite der Blockleiste';
$string['blockdrawerwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockleiste ohne SCSS-Modifikation überschreiben. Standardmäßig verwendet Moodle eine Inhaltsbreite von 315px. Sie können andere pixelbasierte Werte wie 400px verwenden, aber Werte wie eine prozentuale Breite oder eine Viewport-Breite funktionieren nicht.';
$string['blockregionfooterwidth'] = 'Breite der Blockregion im Fußbereich';
$string['blockregionfooterwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion im Fußbereich festlegen. Sie können zwischen voller Breite, Kursinhaltsbreite und Heldenbreite wählen.';
$string['blockregionoutsidebottomwidth'] = 'Breite der Blockregion \'Außen (unten)\'';
$string['blockregionoutsidebottomwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (unten)\' festlegen, die unterhalb des Hauptinhalts angezeigt wird. Sie können die volle Breite auswählen, aber auch die Breite des Kursinhalts oder eine ideale Breite.';
$string['blockregionoutsideleftwidth'] = 'Breite der Blockregion \'Außen (links)\'';
$string['blockregionoutsideleftwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (links)\' festlegen, die links neben dem Hauptinhalt angezeigt wird. Boost Union verwendet standardmäßig eine Breite von 300px. Sie können aber auch andere Werte einstellen, wie z.B. 200px, 10% oder 10vw.';
$string['blockregionoutsiderightwidth'] = 'Breite der Blockregion \'Außen (rechts)\'';
$string['blockregionoutsiderightwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (rechts)\' festlegen, die rechts neben dem Hauptinhalt angezeigt wird. Boost Union verwendet standardmäßig eine Breite von 300px. Sie können aber auch andere Werte einstellen, wie z.B. 200px, 10% oder 10vw.';
$string['blockregionoutsidetopwidth'] = 'Breite der Blockregion \'Außen (oben)\'';
$string['blockregionoutsidetopwidth_desc'] = 'Mit dieser Einstellung können Sie die Breite der Blockregion \'Außen (oben)\' festlegen, der ganz oben auf der Seite angezeigt wird. Sie können die volle Breite auswählen, aber auch die Breite des Kursinhalts oder eine ideale Breite.';
$string['blockregionsforlayout'] = 'Zusätzliche Blockregionen für das Layout \'{$a}\'';
$string['blockregionsforlayout_desc'] = 'Mit dieser Einstellung können Sie zusätzliche Blockregionen für das Layout \'{$a}\' aktivieren.';
$string['blockregionsheading'] = 'Zusätzliche Blockregionen';
$string['blockregionsheading_desc'] = '<p>Boost Union bietet eine große Anzahl zusätzlicher Blockregionen, in denen Blöcke über die gesamte Moodle-Seite hinzugefügt und angezeigt werden können: </p>
<ul><li>Die Blockregionen <em>Außen</em> werden auf allen vier Seiten der Moodle-Seite platziert. Sie können verwendet werden, um Blöcke anzuzeigen, die die gezeigte Moodle-Seite begleiten, aber nicht direkt zum Hauptinhalt gehören.</li>
<li>Die Blockregion <em>Kopfbereich</em> wird zwischen der Region Außen (oben) und dem Hauptinhalt platziert. Dies kann verwendet werden, um einen Block als Kurskopfinformationen anzuzeigen.</li>
<li>Die Blockbereiche <em>Inhaltsbereich</em> werden direkt über und unter dem Hauptinhalt im Hauptinhaltsbereich platziert. Sie können verwendet werden, um dem Kursinhaltsfluss zusätzliche Blöcke hinzuzufügen.</li>
<li>Die Blockregionen <em>Fußbereich</em> befinden sich am unteren Rand der Seite zwischen der Region Außen (unten) und der Fußzeile. Sie haben drei Fußbereiche zur Verfügung, um bei Bedarf Spalten zu erstellen. </li>
<li> Die Blockregionen <em>Off-Canvas</em> sind irgendwie etwas Besonderes, da sie als Overlay über der Moodle-Seite schweben. Die Region wird mit dem 9-Punkte-Symbol auf der rechten Seite der Navigationsleiste geöffnet. Sie haben drei Regionen für Off-Canvas, um bei Bedarf Spalten zu erstellen. </li></ul>
<p>Beachten Sie bitte: </p>
<ul><li>Standardmäßig sind alle zusätzlichen Blockregionen deaktiviert. Aktivieren Sie entsprechend Ihren Anforderungen die jeweiligen Blockregionen auf den jeweiligen Seitenlayouts . Versuchen Sie, dabei so fokussiert wie möglich zu sein - zu viele Blockregionen könnten Nutzer/innen erschlagen.</li>
<li>Sobald eine zusätzliche Blockregion aktiviert ist, wird sie für alle authentifizierten Nutzer/innen sichtbar und kann von Trainer/innen und Manager/innen bearbeitet werden (abhängig davon, ob die jeweilige Person die Moodle-Seite bearbeiten darf). Aber es gibt aber auch die Rechte theme/boost_union:viewregion* und theme/boost_union:editregion*, mit denen Sie die Verwendung jeder Blockregion optimieren können. </li>
<li>Die Blockregionen Außen (links), Außen (rechts), Inhalt (oben), Inhalt (unten) und Kopfbereich sind nicht für alle Seitenlayouts verfügbar. </li></ul>';
$string['blockregionsheading_experimental'] = 'Beachten Sie bitte: Die Blockregionen \'Außen (links)\' und \'Außen (rechts)\' funktionieren mit dem aktuellen Implementationsstand zwar vollständig, müssen aber für mittelbreite Bildschirme als experimentell gelten. Vor diesem Hintergrund sollten Sie die Blockregionen mit Vorsicht verwenden. Das Problem wird mit einem zukünftigen Release behoben.';
$string['blocksgeneralheading'] = 'Allgemeine Blöcke';
$string['blockstab'] = 'Blöcke';
$string['boost_union:configure'] = 'Nicht-Administrator/innen können das Design konfigurieren.';
$string['boost_union:editregioncontentlower'] = 'Um die Blockregion \'Inhalt (unten)\' bearbeiten zu können';
$string['boost_union:editregioncontentupper'] = 'Um die Blockregion \'Inhalt (oben)\' bearbeiten zu können';
$string['boost_union:editregionfootercenter'] = 'Um die Blockregion \'Fußbereich (mittig)\' bearbeiten zu können';
$string['boost_union:editregionfooterleft'] = 'Um die Blockregion \'Fußbereich (links)\' bearbeiten zu können';
$string['boost_union:editregionfooterright'] = 'Um die Blockregion \'Fußbereich (rechts)\' bearbeiten zu können';
$string['boost_union:editregionheader'] = 'Um die Blockregion \'Kopfbereich\' bearbeiten zu können';
$string['boost_union:editregionoffcanvascenter'] = 'Um die Blockregion \'Off-Canvas (mittig)\' bearbeiten zu können';
$string['boost_union:editregionoffcanvasleft'] = 'Um die Blockregion \'Off-Canvas (links)\' bearbeiten zu können';
$string['boost_union:editregionoffcanvasright'] = 'Um die Blockregion \'Off-Canvas (rechts)\' bearbeiten zu können';
$string['boost_union:editregionoutsidebottom'] = 'Um den Blockbereich \'Außen (unten)\' bearbeiten zu können';
$string['boost_union:editregionoutsideleft'] = 'Um den Blockbereich \'Außen (links)\' bearbeiten zu können';
$string['boost_union:editregionoutsideright'] = 'Um den Blockbereich \'Außen (rechts)\' bearbeiten zu können';
$string['boost_union:editregionoutsidetop'] = 'Um den Blockbereich \'Außen (oben)\' bearbeiten zu können';
$string['boost_union:viewhintcourseselfenrol'] = 'Hinweis zur uneingeschränkten Selbsteinschreibung in einem sichtbaren Kurs anzeigen';
$string['boost_union:viewhintinhiddencourse'] = 'Hinweis in einem verborgenen Kurs anzeigen';
$string['boost_union:viewregioncontentlower'] = 'Um den Blockbereich \'Inhalt (unten)\' sehen zu können';
$string['boost_union:viewregioncontentupper'] = 'Um den Blockbereich \'Inhalt (oben)\' sehen zu können';
$string['boost_union:viewregionfootercenter'] = 'Um den Blockbereich \'Fußbereich (mittig)\' sehen zu können';
$string['boost_union:viewregionfooterleft'] = 'Um den Blockbereich \'Fußbereich (links)\' sehen zu können';
$string['boost_union:viewregionfooterright'] = 'Um den Blockbereich \'Fußbereich (rechts)\' sehen zu können';
$string['boost_union:viewregionheader'] = 'Um den Blockbereich \'Kopfbereich\' sehen zu können';
$string['boost_union:viewregionoffcanvascenter'] = 'Um die Blockregion \'Off-Canvas (mittig)\' sehen zu können';
$string['boost_union:viewregionoffcanvasleft'] = 'Um die Blockregion \'Off-Canvas (links)\' sehen zu können';
$string['boost_union:viewregionoffcanvasright'] = 'Um die Blockregion \'Off-Canvas (rechts)\' sehen zu können';
$string['boost_union:viewregionoutsidebottom'] = 'Um den Blockbereich \'Außen (unten)\' sehen zu können';
$string['boost_union:viewregionoutsideleft'] = 'Um den Blockbereich \'Außen (links)\' sehen zu können';
$string['boost_union:viewregionoutsideright'] = 'Um den Blockbereich \'Außen (rechts)\' sehen zu können';
$string['boost_union:viewregionoutsidetop'] = 'Um den Blockbereich \'Außen (oben)\' sehen zu können';
$string['bootstrapcolordangersetting'] = 'Bootstrap-Farbe für Gefahr';
$string['bootstrapcolordangersetting_desc'] = 'Bootstrap-Farbe für Gefahr';
$string['bootstrapcolorinfosetting'] = 'Bootstrap-Farbe für Info';
$string['bootstrapcolorinfosetting_desc'] = 'Bootstrap-Farbe für Info';
$string['bootstrapcolorsheading'] = 'Bootstrap-Farben';
$string['bootstrapcolorsuccesssetting'] = 'Bootstrap-Farbe für Erfolg';
$string['bootstrapcolorsuccesssetting_desc'] = 'Bootstrap-Farbe für Erfolg';
$string['bootstrapcolorwarningsetting'] = 'Bootstrap-Farbe für Warnung';
$string['bootstrapcolorwarningsetting_desc'] = 'Bootstrap-Farbe für Warnung';
$string['bootstrapdangercolor'] = 'Farbe Gefahr';
$string['bootstrapdarkcolor'] = 'Farbe dunkel';
$string['bootstrapinfocolor'] = 'Farbe Info';
$string['bootstraplightcolor'] = 'Farbe hell';
$string['bootstrapnone'] = 'Keine Bootstrap-Farbe';
$string['bootstrapprimarycolor'] = 'Farbe Primär';
$string['bootstrapsecondarycolor'] = 'Sekundärfarbe';
$string['bootstrapsuccesscolor'] = 'Farbe Erfolg';
$string['bootstrapwarningcolor'] = 'Farbe Warnung';
$string['brandcolorsheading'] = 'Markenfarben';
$string['breadcrumbsheading'] = 'Breadcrumb-Navigation';
$string['cachedef_flavours'] = 'Variationen, die für eine bestimmte Seitenkategorie-ID der aktuellen Person gelten';
$string['cachedef_hookoverrides'] = 'Hook Überschreibungen';
$string['cachedef_smartmenu_items'] = 'Smartmenü-Element';
$string['cachedef_smartmenus'] = 'Smartmenüs';
$string['cachedef_touchiconsios'] = 'Dateien mit TouchIcons für iOS';
$string['categorybreadcrumbs'] = 'Kursbereich-Breadcrumbs in Kurskopfzeile';
$string['categorybreadcrumbs_desc'] = 'Standardmäßig werden die Kursbereich-Breadcrumbs nicht auf Kursseiten in der Kurskopfzeile angezeigt. Mit dieser Einstellung können Sie die Kursbereich-Breadcrumbs in der Kurskopfzeile über dem Kursnamen anzeigen.';
$string['categoryindextab'] = 'Kategorieindex / Website-Startseite';
$string['categorylistingheading'] = 'Kategorieliste';
$string['categorylistingpresentation'] = 'Kategorielistenpräsentation';
$string['categorylistingpresentation_boxlist'] = 'Liste von Boxen';
$string['categorylistingpresentation_desc'] = 'Mit dieser Einstellung können Sie das Erscheinungsbild der Kategorieliste auf den Kategorie-Indexseiten und auf der Startseite anpassen. Alternativ zur Darstellung im Moodle Core können Sie die Kategorieliste als aktualisierte Liste von Boxen anzeigen.';
$string['categorylistingpresentation_nochange'] = 'Albtraum des Designers (unverändert dargestellt wie vom Moodle Core )';
$string['categorylistingpresentation_note'] = 'Hinweis: Wenn Sie oben die Einstellung "Kurslistenpräsentation" aktiviert haben, empfehlen wir Ihnen, auch diese Einstellung zu aktivieren. Beide sind für die Zusammenarbeit konzipiert.';
$string['choosereadme'] = 'Das Design "Boost Union" ist eine Erweiterung für das Design "Boost". "Boost Union" soll das Design einfach konfigurierbar machen, andererseits aber auch hilfreiche Zusatzfunktionen für den täglichen Moodle-Betrieb von Administrator/innen, Trainer/innen und Teilnehmer/innen bieten.
Boost Union wird von Moodle an Hochschulen e.V. entwickelt und in Kooperation mit ssystems GmbH, bdecent GmbH und lern.link GmbH bereitgestellt.</p>';
$string['closeoffcanvas'] = 'Off-Canvas schließen';
$string['configtitle'] = 'Boost Union';
$string['configtitleaccessibility'] = 'Barrierefreiheit';
$string['configtitlecontent'] = 'Inhalt';
$string['configtitlefeel'] = 'Bedienelemente';
$string['configtitleflavours'] = 'Variationen';
$string['configtitlefunctionality'] = 'Funktionalität';
$string['configtitlelook'] = 'Erscheinungsbild';
$string['contactcontentsetting'] = 'Inhalt der Kontaktseite';
$string['contactcontentsetting_desc'] = 'In dieser Einstellung können Sie Textinhalte hinzufügen, die auf einer Kontaktseite angezeigt werden. Diese Kontaktseite ist nicht mit dem "Kontakt zum Website-Support" von Moodle identisch.';
$string['contactdisabled'] = 'Die Kontaktseite ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['contactheading'] = 'Kontakt';
$string['contactlinkpositionboth'] = 'Link zur Kontaktseite in der Fußzeile und dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['contactlinkpositionfooter'] = 'Link zur Kontaktseite dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['contactlinkpositionfootnote'] = 'Link zur Kontaktseite in der Fußzeile hinzufügen';
$string['contactlinkpositionnone'] = 'Link zur Kontaktseite nicht automatisch hinzufügen';
$string['contactlinkpositionsetting'] = 'Linkposition für Kontaktseite';
$string['contactlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link zur Kontaktseite hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['contactpagetitledefault'] = 'Kontakt';
$string['contactpagetitlesetting'] = 'Titel der Kontaktseite';
$string['contactpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Kontaktseite festlegen. Dieser Text wird auch als Linktext zur Kontaktseite verwendet, wenn Sie die \'Linkposition für Kontaktseite\' entsprechend konfigurieren.';
$string['contentwidthheading'] = 'Inhaltsbreite';
$string['coursecardscolumncount'] = 'Spaltenanzahl der Kurskarten';
$string['coursecardscolumncount_desc'] = 'Das Kurskartenraster wird responsive dargestellt, und die Spalten werden auf kleineren Bildschirmen umgebrochen. Mit dieser Einstellung steuern Sie lediglich die maximale Spaltenanzahl im Kurskartenraster auf größeren Bildschirmen. Wenn Sie die maximale Spaltenanzahl auf 2 statt 3 setzen, wirken die Kurskarten möglicherweise geräumiger und übersichtlicher. Sie können die maximale Spaltenanzahl auch auf 1 setzen und so die Kursliste effektiv in eine vertikale Kartenliste umwandeln.';
$string['coursecontentmaxwidthsetting'] = 'Maximale Breite von Kursinhalten';
$string['coursecontentmaxwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Inhaltsbreite von Moodle ohne manuelle SCSS-Änderungen überschreiben. Diese Breite wird als Seitenbreite von Kursseiten und in mehreren Aktivitäten verwendet. Standardmäßig verwendet Moodle bei Kursinhalten eine maximale Breite von 830px. Sie können andere pixelbasierte Breite wie 1200px eingeben, aber auch einen prozentualen Wert wie 100% oder eine Breite des Darstellungsbereichs wie 90vw.';
$string['courseheaderheading'] = 'Kursüberschrift';
$string['courseheaderimageenabled'] = 'Kursbild in der Kopfzeile';
$string['courseheaderimageenabled_desc'] = 'Wenn die Einstellung aktiviert ist, wird das Kursbild (das in den Kurseinstellungen eines Kurses hochgeladen werden kann) in der Kopfzeile eines Kurses angezeigt. Die Kursbilder werden dort zusätzlich zur Seite "Meine Kurse" angezeigt, wo sie immer angezeigt werden.';
$string['courseheaderimagefallback'] = 'Kursbild in der Kopfzeile als Fallback';
$string['courseheaderimagefallback_desc'] = 'Wenn Sie in dieser Einstellung ein Bild hochladen, wird es als Fallback verwendet und in der Kurskopfzeile angezeigt, wenn in den Einstellungen eines Kurses kein Kursbild hochgeladen wurde. Wenn Sie hier kein Bild hochladen, wird ein Kurskopfbild nur dann in einem bestimmten Kurs angezeigt, wenn in den Kurseinstellungen dieses Kurses ein Kursbild hochgeladen wurde.';
$string['courseheaderimageheight'] = 'Höhe des Kursbildes in der Kopfzeile';
$string['courseheaderimageheight_desc'] = 'Mit dieser Einstellung legen Sie die Höhe des angezeigten Kopfbildes fest.';
$string['courseheaderimagelayout'] = 'Layout des Kursbildes in der Kopfzeile';
$string['courseheaderimagelayout_desc'] = 'Mit dieser Einstellung legen Sie das Layout des angezeigten Kopfbildes und des Kurstitels fest.';
$string['courseheaderimagelayoutheadingabove'] = 'Kurstitel über dem Kursbild';
$string['courseheaderimagelayoutstackeddark'] = 'Kurstitel überdeckend auf den Kursbild (weiße Schrift für dunkle Hintergrundbilder)';
$string['courseheaderimagelayoutstackedlight'] = 'Kurstitel überdeckend auf den Kursbild (schwarze Schrift für dunkle Hintergrundbilder)';
$string['courseheaderimageposition'] = 'Bildposition für Kursüberschrift';
$string['courseheaderimageposition_desc'] = 'Mit dieser Einstellung steuern Sie die Position des Kursbildes innerhalb des Kursheader-Containers. Der erste Wert ist die horizontale Position, der zweite Wert ist die vertikale Position.';
$string['courseindexcompletioninfoposition'] = 'Position der Aktivitätsabschlussanzeige';
$string['courseindexcompletioninfoposition_desc'] = 'Wählen Sie die Position, an der die Abschlussanzeige angezeigt wird. <em>Zeilenende</em> zeigt den standardmäßigen Abschlussindikator am Ende der Zeile der Kursindexzeile an. <em>Zeilenanfang</em> zeigt den standardmäßigen Abschlussindikator am Anfang der Zeile der Kursindexzeile an. <em>Symbolfarbe</em> zeigt nicht den standardmäßigen Abschlussindikator an, sondern kodiert die Abschlussinformationen als Hintergrund des Kursmodulsymbols.';
$string['courseindexcompletioninfopositionendofline'] = 'Zeilenende';
$string['courseindexcompletioninfopositioniconcolor'] = 'Symbolfarbe';
$string['courseindexcompletioninfopositionstartofline'] = 'Zeilenanfang';
$string['courseindexdrawerwidthsetting'] = 'Breite der Kursindex-Leiste';
$string['courseindexdrawerwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Breite der Kursindex-Leiste ohne SCSS-Modifikation überschreiben. Standardmäßig verwendet Moodle eine Inhaltsbreite von 285px. Sie können andere pixelbasierte Werte wie 320px verwenden, aber Werte wie eine prozentuale Breite oder eine Viewport-Breite funktionieren nicht.';
$string['courseindexheading'] = 'Kursindex';
$string['courseindexmodiconenabled'] = 'Aktivitätssymbole im Kursindex';
$string['courseindexmodiconenabled_desc'] = 'Wenn diese Option aktiviert ist, wird das entsprechende Aktivitätstypsymbol vor der Indexzeile mit dem Titel der Aktivität angezeigt. Dabei ersetzt der Kursaktivitätstyp entweder den Kursabschlussindikator, der vom Anfang an das Ende der Kursindexzeilenzeile verschoben wird, oder wird durch die Farbe des Abschlussstatus eingefärbt.';
$string['courselistingcontacts'] = 'Kurskontakt';
$string['courselistingfields'] = 'Kursklassifizierung';
$string['courselistinggoto'] = 'Zum Kurs';
$string['courselistingheading'] = 'Kursliste';
$string['courselistinghowcategory'] = 'Kursbereich in der Kursliste anzeigen';
$string['courselistinghowcategory_desc'] = 'Mit dieser Einstellung können Sie steuern, ob der Kursbereich in der Kursliste angezeigt wird oder nicht.';
$string['courselistinghowenrolicons'] = 'Einschreibe-Icons in der Kursliste anzeigen';
$string['courselistinghowenrolicons_desc'] = 'Mit dieser Einstellung können Sie steuern, ob Einschreibe-Icons für Kurse in der Kursliste angezeigt werden oder nicht.';
$string['courselistinghowfields'] = 'Kursfelder in der Lursliste anzeigen';
$string['courselistinghowfields_desc'] = 'Mit dieser Einstellung können Sie steuern, ob Kursfelder in der Kursliste angezeigt werden oder nicht.';
$string['courselistinghowgoto'] = 'Taste "Zum Kurs" in der Kursliste anzeigen';
$string['courselistinghowgoto_desc'] = 'Mit dieser Einstellung können Sie steuern, ob eine Taste "Zum Kurs" in der Kursliste angezeigt wird oder nicht. Wenn die Einstellung deaktiviert ist, können Nutzer/innen den Kurs trotzdem aufrufen, indem sie auf den Kurstitel oder das Kursbild klicken.';
$string['courselistinghowimage'] = 'Kursbild in der Kursliste anzeigen';
$string['courselistinghowimage_desc'] = 'Mit dieser Einstellung können Sie steuern, ob das Kursbild in der Kursliste angezeigt wird oder nicht.';
$string['courselistinghowpopup'] = 'Details-Popup in der Kursliste anzeigen';
$string['courselistinghowpopup_desc'] = 'Mit dieser Einstellung können Sie steuern, ob eine Taste "Kursdetails" in der Kursliste angezeigt wird oder nicht. Mit dieser Taste öffnet sich ein Detail-Popup mit der Kurszusammenfassung, den Kurskontakten und den Kursfeldern. Das Popup enthält diese Informationen unabhängig davon, ob Sie sie auf der Kurskarte/-zeile selbst aktiviert haben oder nicht.';
$string['courselistinghowprogress'] = 'Kursabschluss-Fortschritt in der Kursliste anzeigen';
$string['courselistinghowprogress_desc'] = 'Mit dieser Einstellung können Sie steuern, ob dder Kursabschluss-Fortschritt in der Kursliste angezeigt wird oder nicht.';
$string['courselistinghowshortname'] = 'Kurznamen des Kurses in der Kursliste anzeigen';
$string['courselistinghowshortname_desc'] = 'Mit dieser Einstellung können Sie steuern, ob der Kurzname des Kurses in der Kursliste angezeigt wird oder nicht.';
$string['courselistingnosummary'] = 'Dieser Kurs hat keine Kurszusammenfassung.';
$string['courselistingpopup'] = 'Details';
$string['courselistingpresentation'] = 'Kurslistenpräsentation';
$string['courselistingpresentation_cards'] = 'Kurskarten';
$string['courselistingpresentation_desc'] = 'Mit dieser Einstellung können Sie das Erscheinungsbild der Kursliste auf den Kategorie-Indexseiten und auf der Startseite anpassen. Alternativ zur Darstellung im Moodle Core können Sie die Kursliste als Kurskarten (ähnlich den Kurskarten auf der Seite „Meine Kurse“) oder als Kursliste (ähnlich der Kursliste auf der Seite „Meine Kurse“) darstellen.';
$string['courselistingpresentation_list'] = 'Kursliste';
$string['courselistingpresentation_nochange'] = 'Albtraum des Designers (unverändert dargestellt wie vom Moodle Core)';
$string['courselistingpresentation_note'] = 'Bitte beachten: Wenn Sie Kurskarten oder Kurslisten aktivieren, wird die Einstellung <a href="{$a->url1}">coursesperpage</a> weiterhin berücksichtigt und steuert, wie viele Karten/Zeilen angezeigt werden. Die Einstellung <a href="{$a->url2}">courseswithsummarieslimit</a> hat jedoch keine Auswirkung mehr – alle Kurse werden mit allen Details angezeigt. Achten Sie darauf, <a href="{$a->url1}">coursesperpage</a> nicht zu hoch einzustellen, um lange Ladezeiten auf Seiten mit vielen Kursen zu vermeiden.';
$string['courselistingshowcontacts'] = 'Kurskontakte in der Kursliste anzeigen';
$string['courselistingshowcontacts_desc'] = 'Mit dieser Einstellung können Sie steuern, ob Bilder der Kurskontakte in der Kursliste angezeigt wird oder nicht. Bitte beachten Sie: Die Kontaktbilder werden zusammen mit dem Kursbild angezeigt, daher ist die Anzeige von Kurskontakten ohne Anzeige des Kursbildes nicht möglich.';
$string['courselistingummary'] = 'Kurszusammenfassung';
$string['courselistingviewprofile'] = 'Profil anzeigen';
$string['coursemanagementheading'] = 'Kursverwaltung';
$string['courseoverviewheading'] = 'Block Kursüberblick';
$string['courseoverviewshowcourseimagessetting'] = 'Kursbilder anzeigen';
$string['courseoverviewshowcourseimagessetting_desc'] = 'Mit dieser Einstellung können Sie steuern, ob das Kursbild im Block Kursüberblick angezeigt wird oder nicht. Es ist möglich, eine andere Einstellung für Kartenansicht, Listenansicht und Zusammenfassung zu wählen.';
$string['courseoverviewshowprogresssetting'] = 'Kursabschlussfortschritt anzeigen';
$string['courseoverviewshowprogresssetting_desc'] = 'Mit dieser Einstellung können Sie steuern, ob der Kursabschlussfortschritt innerhalb des Blocks Kursübersicht angezeigt wird oder nicht.';
$string['courserelatedhintsheading'] = 'Kursbezogene Hinweise';
$string['coursestab'] = 'Kurse';
$string['coursetab'] = 'Kurs';
$string['cssh5pheading'] = 'Raw CSS für H5P';
$string['cssh5psetting'] = 'Raw CSS für H5P';
$string['cssh5psetting_desc'] = 'Verwenden Sie dieses Feld, um CSS-Code bereitzustellen, der auf die Präsentation von H5P-Inhalten durch mod_h5p und mod_hvp angewendet wird. Überprüfen Sie bitte die H5P-Inhaltstypen, um die erforderlichen CSS-Selektoren zu finden.';
$string['customfontsfileurlpersistent'] = 'URL (gleichbleibend)';
$string['customfontsfileurlrevisioned'] = 'URL (revisioniert)';
$string['customfontsheading'] = 'Nutzerdefinierte Schriftarten';
$string['customfontslistsetting'] = 'Liste von nutzerdefinierten Schriftarten';
$string['customfontslistsetting_desc'] = 'Liste der Schriftarten, die Sie in den Dateibereich "Nutzerdefinierte Schriftarten" hochgeladen haben. Die anzeigten CSS-Snippets können verwendet werden, um die Schriftarten zum nutzerdefinierten SCSS hinzuzufügen. Beachten Sie bitte, dass Sie sich um alle Parameter (font-format, font-family, font-style, font-weight) selber kümmern müssen. Boost Union ist noch nicht in der Lage ist, die Schriftdateien zu analysieren.';
$string['customfontssetting'] = 'Nutzerdefinierte Schriftarten';
$string['customfontssetting_desc'] = 'Mit dieser Einstellung können Sie nutzerdefinierte Schriftarten zum Design hochladen. Der Vorteil von Schriftarten in diesem Dateibereich besteht darin, dass diese Schriftarten überall auf der Website verwendet werden können, ohne dass jemand angemeldet ist. Sobald Sie mindestens eine Schriftart in diesen Dateibereich hochgeladen und die Einstellungen gespeichert haben, wird eine Liste mit CSS-Snippets gezeigt, um die jeweilige Schriftart im nutzerdefinierten SCSS einzubinden.';
$string['dashboardtab'] = 'Dashboard / Meine Kurse';
$string['dontchange'] = 'Nichts ändern';
$string['drawerwidthheading'] = 'Leistenbreite';
$string['emailbrandinghtmldemobody'] = '<p>E-Mail-Text beginnt hier.</p><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p><p>Id donec ultrices tincidunt arcu nicht sodales. Id volutpat lacus laoreet non curabitur gravida arcu.</p><p>Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.</p><p>E-Mail-Text endet hier.</p>';
$string['emailbrandinghtmlheading'] = 'HTML-E-Mail-Vorschau';
$string['emailbrandinghtmlintro'] = 'Dies ist eine Vorschau einer HTML-E-Mail, basierend auf Präfixen und Suffixen für das Erscheinungsbild, die derzeit im Sprachpaket festgelegt sind.';
$string['emailbrandinghtmlnopreview'] = 'Bisher wurden die HTML-E-Mails innerhalb dieser Funktion nicht angepasst. E-Mails werden normal erstellt und versendet.';
$string['emailbrandinginstruction'] = 'Wie geht das?';
$string['emailbrandinginstruction0'] = 'Mit dieser Boost Union-Funktion können Sie das Erscheinungsbild auf alle E-Mails anwenden, die Moodle versendet.';
$string['emailbrandinginstructionli1'] = 'Gehen Sie zur <a href="{$a->url}" target="_blank">Seite mit den Sprachanpassungen</a>, um das Sprachpaket <em>{$a->lang}</em> zur Bearbeitung zu öffnen.';
$string['emailbrandinginstructionli2'] = 'Suchen und ändern Sie diese Texte im lokalen Sprachpaket <code>theme_boost_union</code>:';
$string['emailbrandinginstructionli2li1'] = '<code>templateemailhtmlprefix</code>: Dieses Snippet wird <em>am Anfang / vor dem Text</em> aller <em>HTML-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li2'] = '<code>templateemailhtmlsuffix</code>: Dieses Snippet wird <em>am Ende / nach dem Body</em> aller <em>HTML-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li3'] = '<code>templateemailtextprefix</code>: Dieses Snippet wird <em>am Anfang / vor dem Hauptteil</em> aller <em>Klartext-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli2li4'] = '<code>templateemailtextsuffix</code>: Dieses Snippet wird <em>am Ende / nach dem Hauptteil</em> aller <em>Klartext-E-Mails</em> eingefügt, die Moodle versendet.';
$string['emailbrandinginstructionli3'] = 'Speichern Sie die Änderungen am Sprachpaket.';
$string['emailbrandinginstructionli4'] = 'Kommen Sie auf diese Seite zurück und sehen Sie sich die E-Mail-Vorschau unten an.';
$string['emailbrandingintroheading'] = 'Einführung';
$string['emailbrandingintronote'] = 'Beachten Sie, dass diese erweiterte Funktion einige Workarounds verwendet, um das E-Mail-Erscheinungsbild zu beeinflussen. Befolgen Sie bitte die Anweisungen genau.';
$string['emailbrandingpitfalls'] = 'Tücken';
$string['emailbrandingpitfalls0'] = 'Bei der Verwendung dieser Funktion gibt es einige Tücken, die Sie beachten sollten:';
$string['emailbrandingpitfallsli1'] = 'Es ist zwingend erforderlich, dass Sie die Sprachpaketzeichenfolgen der <em>aktuellen Standardsprache</em> dieser Website ändern. Auch wenn Sie mehrere Sprachpakete installiert haben, wirken sich nur Änderungen in der Standardsprache aus.';
$string['emailbrandingpitfallsli2'] = 'Es ist nicht möglich, die Sprache des Empfängers zu respektieren. Daher sollten Sie in Ihren Textelementen für das E-Mail-Erscheinungsbild sprachunabhängige Begriffe verwenden.';
$string['emailbrandingpitfallsli3'] = 'Wenn Sie in Zukunft jemals die Standardsprache der Website ändern, müssen Sie die geänderten Sprachpaketzeichenfolgen in das neue Standardsprachpaket migrieren.';
$string['emailbrandingpitfallsli4'] = 'In Klartext-E-Mails wird nach dem Präfix automatisch ein Zeilenumbruch und eine Leerzeile und vor dem Suffix-Snippet automatisch eine Leerzeile eingefügt. Damit soll sichergestellt werden, dass Suffix und Präfix nicht direkt am E-Mail-Text hängen.';
$string['emailbrandingpitfallsli5'] = 'In HTML-E-Mails werden das Präfix und das Suffix direkt vor und über dem E-Mail-Body hinzugefügt. Dies soll sicherstellen, dass Sie problemlos mit HTML-Tags arbeiten können, Sie müssen jedoch alle Abstände um den Text herum selbst handhaben.';
$string['emailbrandingpitfallsli6'] = 'In HTML-E-Mails können Sie problemlos ein HTML-Tag im Präfix-Snippet öffnen und das Tag im Suffix-Snippet schließen. Denken Sie nur daran, gültiges HTML in der resultierenden E-Mail zu erstellen.';
$string['emailbrandingtab'] = 'E-Mails';
$string['emailbrandingtextdemobody'] = 'Der E-Mail-Text beginnt hier.

Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.

Id donec ultrices tincidunt arcu non sodales. Id volutpat lacus laoreet non curabitur gravida arcu.

Cursus turpis massa tincidunt dui. Pellentesque nec nam aliquam sem et tortor consequat id. In ornare quam viverra orci sagittis eu volutpat. Sem nulla pharetra diam sit amet nisl suscipit. Justo donec enim diam vulputate ut pharetra.

Der E-Mail-Text endet hier.';
$string['emailbrandingtextheading'] = 'Klartext-E-Mail-Vorschau';
$string['emailbrandingtextintro'] = 'Dies ist eine Vorschau auf eine Klartext-E-Mail,  basierend auf Präfixen und Suffixen für das Erscheinungsbild, die derzeit im Sprachpaket festgelegt sind.';
$string['emailbrandingtextnopreview'] = 'Bisher wurden die Klartext-E-Mails in diesem Feature nicht angepasst. E-Mails werden normal erstellt und versendet.';
$string['enableaboutussetting'] = 'Seite \'Über uns\' aktivieren';
$string['enableaccessibilitydeclarationsetting'] = '"Erklärung zur Barrierefreiheit" aktivieren';
$string['enableaccessibilitydeclarationsetting_desc'] = 'Mit dieser Einstellung können Sie eine "Erklärung zur Barrierefreiheit" aktivieren. Sie verhält sich genau wie <a href="{$a->url}">andere statischen Seiten</a> in Boost Union.';
$string['enableaccessibilitysupportfooterbuttonsetting'] = 'Fußzeilentaste "Support zur Barrierefreiheit" aktivieren';
$string['enableaccessibilitysupportfooterbuttonsetting_desc'] = 'Mit dieser Einstellung können Sie einen Link für die Supportseite zur Barrierefreiheit als ein schwebendes Barrierefreiheit-Icon über dem Footer (Fragezeichen) Icon hinzufügen.';
$string['enableaccessibilitysupportsetting'] = 'Supportseite zur Barrierefreiheit aktivieren';
$string['enableaccessibilitysupportsetting_desc'] = 'MIt dieser Einstellung können sie eine Supportseite zur Barrierefreiheit aktivieren. Die Seite verhält sich ählich wie die <a href="{$a->url}">Supportseite von Moodle Core</a>.';
$string['enablecontactsetting'] = 'Kontaktseite aktivieren';
$string['enablefooterbutton'] = 'Fußbereich aktivieren';
$string['enablefooterbutton_desc'] = 'Mit "Fußzeile" ist der Kreis mit dem Fragezeichen am Ende der Seite gemeint.<br />Beim Klicken wird ein Overlay angezeigt. Abhängig von der Website-Konfiguration zeigt Moodle mehrere Links (wie "Dokumentation für diese Seite" oder "Zusammenfassung der Datenaufbewahrung") in diesem Overlay an.<br />Mit dieser Einstellung können Sie steuern, ob die Taste "Fußzeile" am Ende der Seite angezeigt oder unterdrückt werden soll.';
$string['enablefooterbuttonboth'] = 'Für Desktop, Tablet und Smartphone aktivieren';
$string['enablefooterbuttondesktop'] = 'Für Desktop und Tablet aktivieren, für Smartphone verbergen (unverändert, wie von Moodle Core dargestellt)';
$string['enablefooterbuttonhidden'] = 'Auf allen Endgeräten verbergen';
$string['enablefooterbuttonmobile'] = 'Nur für Smartphone aktivieren, für Desktop und Tablet verbergen';
$string['enablehelpsetting'] = 'Hilfeseite aktivieren';
$string['enableimprintsetting'] = 'Impressum aktivieren';
$string['enablemaintenancesetting'] = 'Wartungsinfos aktivieren';
$string['enableofferssetting'] = 'Angebotsseite aktivieren';
$string['enablepage1setting'] = 'Allgemeine Seite 1 aktivieren';
$string['enablepage2setting'] = 'Allgemeine Seite 2 aktivieren';
$string['enablepage3setting'] = 'Allgemeine Seite 3 aktivieren';
$string['error:infobannerdismissnonotdismissible'] = 'Das angegebene Infobanner ist nicht ausblendbar.';
$string['error:infobannerdismissnonotvalid'] = 'Die angegebene Infobanner-Nummer ist ungültig.';
$string['error:smartmenusmenuitemnotfound'] = 'Smartmenü-Element nicht gefunden';
$string['error:smartmenusmenunotfound'] = 'Smartmenü nicht gefunden';
$string['extscssgithubfilepath_example'] = 'Beispiel: Wenn Sie die Datei in Ihrem Github-Konto unter https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss sehen können, lautet der Dateipfad <em>/extscss.scss</em>.';
$string['extscssgithubpostfilepath'] = 'Pfad zu externem Post-SCSS im Github';
$string['extscssgithubpostfilepath_desc'] = 'Der Pfad im privaten Github-Repository, in dem sich die Post-SCSS-Datei befindet.';
$string['extscssgithubprefilepath'] = 'Pfad zu externem Pre-SCSS im Github';
$string['extscssgithubprefilepath_desc'] = 'Der Pfad im privaten Github-Repository, in dem sich die Pre-SCSS-Datei befindet.';
$string['extscssgithubrepo'] = 'Externes SCSS-Github-API-Repository';
$string['extscssgithubrepo_desc'] = 'Das private Github-Repository, in dem sich die SCSS-Dateien befinden.';
$string['extscssgithubrepo_example'] = 'Beispiel: Wenn Sie die Datei in Ihrem Github-Konto unter https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss sehen können, lautet das Repository <em>moodle-theme_boost_union-extscsstest</em>.';
$string['extscssgithubtoken'] = 'Externes SCSS-Github-API-Token';
$string['extscssgithubtoken_desc'] = 'Das Github-API-Token, das zum Abrufen des SCSS-Codes aus dem angegebenen privaten Github-Repository verwendet wird.';
$string['extscssgithubtoken_docs'] = 'Gehen Sie zu <a href="https://github.com/settings/tokens">Ihren Github-Token-Einstellungen</a>, um ein API-Token zu generieren und die offizielle Dokumentation anzuzeigen.';
$string['extscssgithubuser'] = 'Nutzer/in für Externes SCSS-Github-API-Repository';
$string['extscssgithubuser_desc'] = 'Nutzer/in oder Institution, der das private Github-API-Repository gehört';
$string['extscssgithubuser_example'] = 'Beispiel: Wenn Sie die Datei in Ihrem Github-Konto unter https://github.com/moodle-an-hochschulen/moodle-theme_boost_union-extscsstest/blob/main/extscss.scss sehen können, ist die Institution <em>moodle-an-hochschulen</em>.';
$string['extscssheading'] = 'Externes SCSS';
$string['extscssheading_desc'] = 'Zusätzlich zu den oben genannten Raw-SCSS-Einstellungen kann Boost Union SCSS aus einer externen Quelle laden. Es wird vor dem oben definierten SCSS-Code eingefügt, was bedeutet, dass Sie eine externe SCSS-Codebasis zentral verwalten und diese dennoch mit SCSS-Einstellungen lokal ergänzen können.';
$string['extscssheading_drop'] = 'Wenn Boost Union die externe SCSS-Datei aus irgendeinem Grund nicht abrufen kann, wird die externe SCSS-Datei ignoriert, um Probleme beim Kompilieren von SCSS und beschädigte Frontends zu vermeiden.';
$string['extscssheading_instr'] = 'Anleitung';
$string['extscssheading_prepost'] = 'Genau wie die obigen Raw -SCSS-Einstellungen ist das externe SCSS in zwei Teile aufgeteilt: Pre- und Post-SCSS. Pre-SCSS kann SCSS-Variablen initialisieren, Post-SCSS wird für Ihren eigentlichen SCSS-Code verwendet.';
$string['extscssheading_sources'] = 'Sie können Boost Union konfigurieren, wie die externe SCSS-Datei abgerufen wird, entweder von einer öffentlichen URL (auf die mit einer nicht authentifizierten cURL-Anfrage zugegriffen und die Datei abgerufen wird) oder von einem privaten Github-Repository (auf das mit einem Github-API-Token zugegriffen und die Datei abgerufen wird).';
$string['extscssheading_structure'] = 'Das externe SCSS muss als Nur-Text-Datei ohne Kopf- oder Fußzeilen bereitgestellt werden und ausschließlich den SCSS-Code enthalten.';
$string['extscssheading_task'] = 'Es gibt eine <a href="{$a}">geplante Task theme_boost_union\\task\\purge_cache</a>, die standardmäßig deaktiviert ist. Sie können die Task aktivieren, wenn Boost Union den externen SCSS-Code regelmäßig abrufen und kompilieren soll.';
$string['extscsssource'] = 'Externe SCSS-Quelle';
$string['extscsssource_desc'] = 'Wählen Sie den Quellentyp aus, von dem Sie das externe SCSS abrufen möchten.';
$string['extscsssourcedownload'] = 'Öffentliche URL';
$string['extscsssourcegithub'] = 'Privates Github-Repository';
$string['extscsssourcenone'] = 'Kein';
$string['extscssurlpost'] = 'URL für externes Post-SCSS';
$string['extscssurlpost_desc'] = 'Die öffentliche URL, über die die externe Post-SCSS-Datei heruntergeladen werden soll.';
$string['extscssurlpre'] = 'URL für externes Pre-SCSS';
$string['extscssurlpre_desc'] = 'Die öffentliche URL, über die die externe Pre-SCSS-Datei heruntergeladen werden soll.';
$string['extscssvalidationsetting'] = 'Externe SCSS-Validierung';
$string['extscssvalidationsetting_desc'] = 'Wenn diese Einstellung aktiviert ist, wird das externe SCSS validiert, falls es  vor dem Hinzugefügten zum SCSS-Stack kompiliert werden kann. Das externe SCSS, das nicht kompiliert werden kann, wird ignoriert und nicht verwendet. Diese Validierung wird ausschließlich für externes SCSS ausgeführt, aber nicht für den kombinierten SCSS-Stack. Dies bedeutet, dass Sie die Validierung deaktivieren müssen, sobald Sie SCSS-Variablen von Moodle Core oder Bootstrap in Ihrem externen SCSS verwenden. Hier müssen Sie selber prüfen, dass das SCSS gültig ist, um kaputte Frontends zu vermeiden.';
$string['faviconheading'] = 'Favicon';
$string['faviconheading_desc'] = 'Beachten Sie: Boost Union hat einen eigenen Favicon-Upload und verwendet nicht das Favicon aus der <a href="{$a}">Favicon-Einstellung des Moodle-Kerns</a>.<br />Boost Union ermöglicht Ihnen insbesondere, das hochgeladene Favicon in seinen Variationen zu überschreiben.';
$string['faviconsetting'] = 'Favicon';
$string['faviconsetting_desc'] = 'Hier können Sie ein nutzerdefiniertes Bild (im Format .ico- oder .png) hochladen, welches im Browser als Favicon Ihrer Moodle-Website angezeigt wird. Wenn kein nutzerdefiniertes Favicon hochgeladen ist, wird das standardmäßige Moodle-Favicon angezeigt.';
$string['flavoursactivityiconcoloradministration'] = 'Symbolfarbe für Aktivitäten "Administration"';
$string['flavoursactivityiconcoloradministration_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Administration", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursactivityiconcolorassessment'] = 'Symbolfarbe für Aktivitäten "Bewertung"';
$string['flavoursactivityiconcolorassessment_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Bewertung", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursactivityiconcolorcollaboration'] = 'Symbolfarbe für Aktivitäten "Zusammenarbeit"';
$string['flavoursactivityiconcolorcollaboration_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Zusammenarbeit", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursactivityiconcolorcommunication'] = 'Symbolfarbe für Aktivitäten "Kommunikation"';
$string['flavoursactivityiconcolorcommunication_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Kommunikation", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursactivityiconcolorcontent'] = 'Symbolfarbe für Aktivitäten "Inhalt"';
$string['flavoursactivityiconcolorcontent_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Inhalt", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursactivityiconcolorinteractivecontent'] = 'Symbolfarbe für Aktivitäten "Interaktive Inhalte"';
$string['flavoursactivityiconcolorinteractivecontent_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Interaktive Inhalte", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursactivityiconcolorinterface'] = 'Symbolfarbe für Aktivitäten "Schnittstelle"';
$string['flavoursactivityiconcolorinterface_help'] = 'Mit dieser Einstellung überschreibt der Stil die Symbolfarbe für Aktivitäten "Schnittstelle", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursappliesto'] = 'Verwendung';
$string['flavoursapplytocategories'] = 'Für Kursbereiche verwenden';
$string['flavoursapplytocategories_help'] = 'Hier legen Sie fest, ob diese Variation auf Kursbereiche angewendet werden soll.';
$string['flavoursapplytocategories_ids'] = 'Kursbereiche';
$string['flavoursapplytocategories_ids_help'] = 'Hier legen Sie bestimmte Kursbereiche fest, für die diese Variation verwendet werden soll. Sobald sich eine Moodle-Seite innerhalb eines der konfigurierten Kursbereiche befindet, wird die Variation verwendet.';
$string['flavoursapplytocohorts'] = 'Für globale Gruppen verwenden';
$string['flavoursapplytocohorts_help'] = 'Hier legen Sie fest, ob diese Variation für globale Gruppen verwendet werden soll.';
$string['flavoursapplytocohorts_ids'] = 'Globale Gruppen';
$string['flavoursapplytocohorts_ids_help'] = 'Hier legen Sie bestimmte globale Gruppen fest, für die diese Variation verwendet werden soll. Wenn eine Person Mitglied einer der konfigurierten globalen Gruppen ist, wird die Variation verwendet.<br /><br />Beachten Sie bitte, dass eine Person nicht mehreren globalen Gruppen gleichzeitig angehören muss.<br /><br />Beachten Sie bitte auch, dass beim derzeitigen Stand der Umsetzung die globalen Gruppen für die Kursbereiche so behandelt werden, als wären sie globalen Gruppen für das gesamte System.';
$string['flavoursbackgroundimage'] = 'Hintergrundbild';
$string['flavoursbackgroundimage_help'] = 'Mit dieser Einstellung überschreibt die Variation das Hintergrundbild, das in den Einstellungen von Boost Union konfiguriert ist.';
$string['flavoursbackgroundimageposition'] = 'Position Hintergrundbild';
$string['flavoursbackgroundimageposition_help'] = 'Mit dieser Einstellung überschreibt der Stil die Position des Hintergrundbildes, die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursbacktooverview'] = 'Zurück zur Variationsübersicht';
$string['flavoursbootstrapcolordanger'] = 'Bootstrap-Farbe für "Gefahr"';
$string['flavoursbootstrapcolordanger_help'] = 'Mit dieser Einstellung überschreibt der Stil die Bootstrap-Farbe für "Gefahr", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursbootstrapcolorinfo'] = 'Bootstrap-Farbe für "Info"';
$string['flavoursbootstrapcolorinfo_help'] = 'Mit dieser Einstellung überschreibt der Stil die Bootstrap-Farbe für "Info", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursbootstrapcolorsuccess'] = 'Bootstrap-Farbe für "Erfolg"';
$string['flavoursbootstrapcolorsuccess_help'] = 'Mit dieser Einstellung überschreibt der Stil die Bootstrap-Farbe für "Erfolg", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursbootstrapcolorwarning'] = 'Bootstrap-Farbe für "Warnung"';
$string['flavoursbootstrapcolorwarning_help'] = 'Mit dieser Einstellung überschreibt der Stil die Bootstrap-Farbe für "Warnung", die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursbrandcolor'] = 'Markenfarbe';
$string['flavoursbrandcolor_help'] = 'Mit dieser Einstellung überschreibt der Stil die Markenfarbe, die in den Boost Union Einstellungen definiert wurde.';
$string['flavourscreateflavour'] = 'Variation anlegen';
$string['flavourscustomscss'] = 'Raw SCSS';
$string['flavourscustomscss_help'] = 'Mit dieser Einstellung können Sie nutzerdefiniertes SCSS für den Stil festlegen. Sie wird am CSS Code Stack angehängt, der dem Browser beim Laden des Stils übermittelt wird.';
$string['flavourscustomscsspre'] = 'Raw initial SCSS';
$string['flavourscustomscsspre_help'] = 'Mit dieser Einstellung können Sie benutzerdefiniertes initiales SCSS für den Stil festlegen. Sie wird verwendet, wenn der CSS Code, der dem Browser beim Laden des Stils übermittelt wird, generiert wird.';
$string['flavoursdelete'] = 'Löschen';
$string['flavoursdeleteconfirmation'] = 'Möchten Sie die Variation <em>{$a}</em> wirklich löschen?';
$string['flavoursdeleteflavour'] = 'Variation löschen';
$string['flavoursdescription'] = 'Beschreibung';
$string['flavoursdescription_help'] = 'Die Beschreibung der Variation wird nur intern verwendet, damit Sie ein bestimmtes Erscheinungsbild in der Liste identifizieren können.';
$string['flavoursedit'] = 'Bearbeiten';
$string['flavourseditflavour'] = 'Variation bearbeiten';
$string['flavoursfavicon'] = 'Favicon';
$string['flavoursfavicon_help'] = 'Mit dieser Einstellung überschreibt die Variation das Favicon, das in den Einstellungen von Boost Union konfiguriert ist.';
$string['flavoursflavours'] = 'Variationen';
$string['flavoursgeneralsettings'] = 'Allgemeine Einstellungen';
$string['flavoursincludesubcategories'] = 'Unterbereiche einbeziehen';
$string['flavoursincludesubcategories_help'] = 'Wenn diese Option aktiviert ist, wird die Variation auch auf die Unterbereiche der ausgewählten Kursbereiche angewendet.';
$string['flavourslogo'] = 'Logo';
$string['flavourslogo_help'] = 'Mit dieser Einstellung wird das Logo aus dem Bereich "Erscheinungsbild" von Boost Union durch die Variation überschrieben.';
$string['flavourslogocompact'] = 'Kompaktes Logo';
$string['flavourslogocompact_help'] = 'Mit dieser Einstellung wird das kompakte Logo aus dem Bereich "Erscheinungsbild" von Boost Union durch die Variation überschrieben.';
$string['flavoursnavbarcolor'] = 'Farbe der Navigationsleiste';
$string['flavoursnavbarcolor_help'] = 'Mit dieser Einstellung überschreibt der Stil die Farbe der Navigationsleiste, die in den Boost Union Einstellungen definiert wurde.';
$string['flavoursnothingtodisplay'] = 'Es wurden noch keine Variationen erstellt. Erstellen Sie bitte Ihre erste Variation, um die Dinge in Gang zu bringen.';
$string['flavoursnotificationcreated'] = 'Die Variation wurde erfolgreich angelegt.';
$string['flavoursnotificationdeleted'] = 'Die Variation wurde erfolgreich gelöscht.';
$string['flavoursnotificationedited'] = 'Die Variation wurde erfolgreich bearbeitet.';
$string['flavoursoverview_desc'] = '<p>Die Variationen von Boost Union bieten die Möglichkeit, bestimmte Look&Feel-Einstellungen in bestimmten Kontexten zu überschreiben. Auf dieser Seite können Sie Variationen erstellen und verwalten.</p><p>Innerhalb einer Variation legen Sie fest, ob sie auf bestimmte Kurskategorien oder bestimmte globale Gruppen angewendet werden soll. Anschließend prüft Boost Union beim Rendern, ob eine Variation zutrifft. Beachten Sie bitte, dass für jedes Rendering nur die erste passende Variation aus der Liste angewendet wird und alle übrigen Variationen ignoriert werden. Daher ist die Reihenfolge der Variationen auf dieser Seite entscheidend.</p><p>Beachten Sie bitte auch, dass nach jeder Änderung, die Sie an einer Variation vornehmen, der Design-Cache gelöscht wird. Dies ist notwendig, um sicherzustellen, dass alle Assets ordnungsgemäß und aktuell an den Browser gesendet werden.</p>';
$string['flavourspreview'] = 'Vorschau';
$string['flavourspreviewblindtext'] = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Nunc id cursus metus aliquam eleifend mi in nulla. Felis imperdiet proin fermentum leo vel orci porta. Sed nisi lacus sed viverra tellus in hac habitasse. Vivamus arcu felis bibendum ut. Nisi porta lorem mollis aliquam ut porttitor. Odio euismod lacinia at quis risus sed vulputate odio. Sed felis eget velit aliquet sagittis id consectetur purus. Nec ullamcorper sit amet risus nullam eget. Pellentesque sit amet porttitor eget dolor. Cursus mattis molestie a iaculis at erat pellentesque.';
$string['flavourspreviewflavour'] = 'Variationsvorschau';
$string['flavourstitle'] = 'Titel';
$string['flavourstitle_help'] = 'Der Titel der Variation wird nur intern verwendet, damit Sie eine bestimmte Variation in der Liste dokumentieren können.';
$string['footerheading'] = 'Fußbereich';
$string['footersuppresschatsetting'] = 'Link "Mit Teilnehmer/innen chatten" unterdrücken';
$string['footersuppresschatsetting_desc'] = 'Mit dieser Einstellung können Sie den Link "Mit Teilnehmer/innen chatten" in der Fußzeile unterdrücken. Dieser Link würde andernfalls innerhalb von Kursen erscheinen, sobald in den Einstellungen eines Kurses ein Kommunikationsraum hinzugefügt wird.';
$string['footersuppresscontactsetting'] = 'Link "Website-Support kontaktieren" unterdrücken';
$string['footersuppresscontactsetting_desc'] = 'Mit dieser Einstellung können Sie den Link "Website-Support kontaktieren" in der Fußzeile unterdrücken. Dieser Link würde andernfalls erscheinen, wenn der Link <a href="{$a->url}">Website-Support kontaktieren</a> gesetzt ist.';
$string['footersuppresshelpsetting'] = 'Link "Dokumentation zu dieser Seite" unterdrücken';
$string['footersuppresshelpsetting_desc'] = 'Mit dieser Einstellung können Sie den Link "Dokumentation zu dieser Seite" in der Fußzeile unterdrücken. Dieser Link würde andernfalls erscheinen, wenn eine <a href="{$a->url}">Moodle Docs-Verlinkung</a> festgelegt ist.';
$string['footersuppressiconssetting'] = 'Icons vor den Fußbereich-Links unterdrücken';
$string['footersuppressiconssetting_desc'] = 'Mit dieser Einstellung können Sie die Icons vor den Links in Fußbereich unterdrücken. z.B.  wird der Link "Dokumentation zu dieser Seite" mit einem Buch gezeigt, "Dienste und Support" mit einem Rettungsring usw.';
$string['footersuppresslogininfosetting'] = 'Link "Login-Info" unterdrücken';
$string['footersuppresslogininfosetting_desc'] = 'Mit dieser Einstellung können Sie die Anmeldeinformationen in der Fußzeile vollständig unterdrücken. Diese Informationen würden andernfalls Links zum Profil der Nutzer/innen und zur Abmeldeseite anzeigen.';
$string['footersuppresspoweredsetting'] = 'Link "Powered by Moodle" unterdrücken';
$string['footersuppresspoweredsetting_desc'] = 'Mit dieser Einstellung können Sie den Link "Powered by Moodle" in der Fußzeile unterdrücken. Andernfalls würde dieser Link eine Information darüber anzeigen, dass auf dieser Website Moodle ausgeführt wird, und einen Link zum Moodle HQ bereitstellen.';
$string['footersuppressservicessetting'] = 'Link "Dienste und Support" unterdrücken';
$string['footersuppressservicessetting_desc'] = 'Mit dieser Einstellung können Sie den Link "Dienste und Support" in der Fußzeile unterdrücken. Andernfalls würde dieser Link Administratoren den <a href="{$a->url}">"Dienste und Support"-Link</a> anzeigen.';
$string['footersuppressstandardfooter'] = 'Fußzeilenausgabe des Plugins \'{$a}\' unterdrücken';
$string['footersuppressstandardfooter_desc'] = 'Mit dieser Einstellung können Sie die Fußzeilenausgabe durch das Plugin \'{$a}\' vollständig unterdrücken. Plugins (auch wenn sie mit Moodle Core ausgeliefert werden, aber technisch gesehen Plugins sind) können der Fußzeile zusätzlichen Inhalt hinzufügen, indem sie eine bestimmte Funktion implementieren. Dieses Plugin hat diese Funktion implementiert und kann unter bestimmten Umständen Inhalte zur Fußzeile hinzufügen. <br />Hinweis: Aufgrund der Implementierung des Features zur Unterdrückung der Fußzeilenausgabe könnten die Einstellungen nach dem Speichern erst nach einem zweiten Neuladen der Seite angezeigt werden.';
$string['footersuppressstandardfootercore'] = 'Fußzeilenausgabe durch die Core-Komponente \'{$a}\' unterdrücken';
$string['footersuppressstandardfootercore_desc'] = 'Mit dieser Einstellung können Sie die Fußzeilenausgabe durch die Core-Komponente \'{$a}\' vollständig unterdrücken. Core-Komponenten können der Fußzeile zusätzliche Inhalte hinzufügen, indem ein bestimmter Haken oder eine bestimmte Funktion implementiert wird. Diese Core-Komponente hat diese Funktion implementiert und kann unter bestimmten Umständen Inhalte zur Fußzeile hinzufügen.';
$string['footersuppressthemeswitchsetting'] = 'Links zum Designwechsel unterdrücken';
$string['footersuppressthemeswitchsetting_desc'] = 'Mit dieser Einstellung können Sie die Links zum Designwechsel in der Fußzeile unterdrücken. Das zugrunde liegende System für gerätespezifische Designs wurde in Moodle 4.3 entfernt, aber die Ausgaberoutinen sind immer noch vorhanden, also ist Vorsicht besser als Nachsicht.';
$string['footersuppressusertoursetting'] = 'Link "Nutzertour auf dieser Seite zurücksetzen" unterdrücken';
$string['footersuppressusertoursetting_desc'] = 'Mit dieser Einstellung können Sie den Link "Nutzertour auf dieser Seite zurücksetzen" in der Fußzeile unterdrücken. Dieser Link würde andernfalls die Möglichkeit bieten, eine Nutzertour auf einer bestimmten Seite zurückzusetzen.';
$string['footertab'] = 'Fußbereich';
$string['footnoteheading'] = 'Fußbereich';
$string['footnotesetting'] = 'Fußzeile';
$string['footnotesetting_desc'] = 'Alles, was Sie in diesem Textbereich hinzufügen, wird in der Fußzeile am Ende einer Seite angezeigt. Dieser Text steht in der Fußzeile (nicht in der schwebenden Fußzeile) auf jeder Seite, die die Layouts "drawers", "columns2" oder "login" verwendet. Inhalte können das Urheberrecht, die Nutzungsbedingungen oder der Name Ihrer Organisation sein. <br/>Um die Fußnote wieder zu entfernen, leeren Sie einfach diesen Textbereich.';
$string['forguestsonly'] = 'Nur für Gäste und nicht angemeldete Nutzer/innen';
$string['githubissueslink'] = '<a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github Issues</a>';
$string['h5pcontentmaxwidthsetting'] = 'Maximale Breite von H5P-Inhalten';
$string['h5pcontentmaxwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Breite von H5P-Inhalten ohne manuelle SCSS-Änderungen überschreiben. Diese Breite wird für den H5P-Editor im Inhaltsspeicher verwendet. Der Wert wird <em>nicht</em> für die Breite der H5P-Aktivität verwendet. Standardmäßig verwendet Moodle eine maximale Breite des H5P-Inhaltsspeichers von 960px. Sie können andere pixelbasierte Breite wie 1200px eingeben, aber auch einen prozentualen Wert wie 100% oder eine Breite des Darstellungsbereichs wie 90vw.';
$string['h5ptab'] = 'H5P';
$string['helpcontentsetting'] = 'Inhalt der Hilfeseite';
$string['helpcontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf einer Hilfeseite angezeigt werden.';
$string['helpdisabled'] = 'Die Hilfeseite ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['helpheading'] = 'Hilfe';
$string['helplinkpositionboth'] = 'Link zur Hilfeseite in der Fußzeile und dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['helplinkpositionfooter'] = 'Link zur Hilfeseite dem Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['helplinkpositionfootnote'] = 'Link zur Hilfeseite in der Fußzeile hinzufügen';
$string['helplinkpositionnone'] = 'Link zur Hilfeseite nicht automatisch anzeigen';
$string['helplinkpositionsetting'] = 'Linkposition zur Hilfeseite';
$string['helplinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob automatisch ein Link zur Hilfeseite hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie von überall manuell einen Link zu {$a->url} hinzufügen.';
$string['helppagetitledefault'] = 'Hilfe';
$string['helppagetitlesetting'] = 'Titel der Hilfeseite';
$string['helppagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Hilfeseite festlegen. Dieser Text wird auch als Linktext zur Hilfeseite verwendet, wenn Sie die \'Linkposition Hilfeseite\' entsprechend konfigurieren.';
$string['hidenodesprimarynavigationsetting'] = 'Knoten in der Primärnavigation verbergen';
$string['hidenodesprimarynavigationsetting_desc'] = 'Mit dieser Einstellung können Sie einen oder mehrere Knoten aus der Primärnavigation ausblenden.
Beachten Sie bitte: Hier können Sie Navigationsknoten einfach entfernen. Wenn Sie jedoch neue nutzerdefinierte Navigationsknoten hinzufügen möchten, sollten Sie die Verwendung der <a href="{$a->url}">Smartmenü-Funktionalität von Boost Union</a> in Betracht ziehen.';
$string['imprintcontentsetting'] = 'Impressum Inhalt';
$string['imprintcontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die im Impressum angezeigt werden.';
$string['imprintdisabled'] = 'Das Impressum ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['imprintheading'] = 'Impressum';
$string['imprintlinkpositionboth'] = 'Link zum Impressum in der Fußnote und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['imprintlinkpositionfooter'] = 'Link zum Impressum zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['imprintlinkpositionfootnote'] = 'Link zum Impressum in der Fußnote hinzufügen';
$string['imprintlinkpositionnone'] = 'Link zum Impressum nicht automatisch anzeigen';
$string['imprintlinkpositionsetting'] = 'Linkposition für Impressum';
$string['imprintlinkpositionsetting_desc'] = 'In dieser Einstellung können Sie festlegen, ob der Moodle-Seite automatisch ein Link zum Impressum hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie von überall in Moodle manuell einen Link zu {$a->url} hinzufügen.';
$string['imprintpagetitledefault'] = 'Impressum';
$string['imprintpagetitlesetting'] = 'Impressum Überschrift';
$string['imprintpagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel des Impressums festlegen. Dieser Text wird auch als Linktext zum Impressum verwendet, wenn Sie die \'Linkposition für Impressum\' entsprechend konfigurieren.';
$string['infobannerbsclasssetting'] = 'Infobanner {$a->no} Bootstrap Class';
$string['infobannerbsclasssetting_desc'] = 'Mit dieser Einstellung können Sie den Bootstrap-Stil auswählen, mit dem Infobanner {$a->no} angezeigt werden soll. Wenn Sie die Option "Keine Bootstrap-Farbe" wählen, wird das Infobanner ohne eine bestimmte Bootstrap-Farbe ausgegeben, was Ihnen die Freiheit gibt, das Banner im Texteditor selbst zu gestalten.';
$string['infobannerclose'] = 'Schließen';
$string['infobannercontentsetting'] = 'Infobanner {$a->no} Inhalt';
$string['infobannercontentsetting_desc'] = 'Tragen Sie hier die Informationen ein, die innerhalb des Infobanners {$a->no} angezeigt werden sollen.';
$string['infobannerdismissconfirm'] = 'Möchten Sie wirklich die Sichtbarkeit des Infobanners {$a->no} zurücksetzen und möchten Sie es allen Personen erneut anzeigen?';
$string['infobannerdismissfail'] = 'Das Zurücksetzen der Sichtbarkeit des Infobanners {$a->no} ist für mindestens eine Person fehlgeschlagen.';
$string['infobannerdismissiblesetting'] = 'Infobanner {$a->no} ausblendbar';
$string['infobannerdismissiblesetting_desc'] = 'Mit dieser Einstellung können Sie das Infobanner {$a->no} ausblendbar machen. Klickt eine Person auf die Taste X im Infobanner, wird das Banner für diese Person dauerhaft ausgeblendet. Die Sichtbarkeit wird nicht automatisch zurückgesetzt, auch wenn Sie den Inhalt des Infobanners ändern. Wenn Sie die Sichtbarkeit des Infobanners zurücksetzen möchten, klicken Sie unten auf die Taste "Sichtbarkeit zurücksetzen".';
$string['infobannerdismissreset'] = 'Sichtbarkeit für ausgeblendetes Infobanners zurücksetzen';
$string['infobannerdismissresetbutton'] = 'Sichtbarkeit für Infobanner {$a->no} zurücksetzen';
$string['infobannerdismisssuccess'] = 'Die Sichtbarkeit für Infobanner {$a->no} wurde zurückgesetzt.';
$string['infobannerenabledsetting'] = 'Infobanner {$a->no} aktivieren';
$string['infobannerenabledsetting_desc'] = 'Mit dieser Einstellung können Sie das Infobanner {$a->no} aktivieren.';
$string['infobannerendsetting'] = 'Infobanner {$a->no} Endzeit';
$string['infobannerendsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, bis wann Infobanner {$a->no} angezeigt werden soll. Die konfigurierte Zeit wird als Serverzeit interpretiert, nicht als Nutzerzeit.';
$string['infobannerheading'] = 'Infobanner {$a->no}';
$string['infobannermodeperpetual'] = 'Dauerhaft';
$string['infobannermodesetting'] = 'Infobanner {$a->no} Anzeigemodus';
$string['infobannermodesetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, ob Infobanner {$a->no} ein dauerhaft angezeigtes Banner oder ein zeitgesteuertes Banner soll. Für die Zeitsteuerung muss das Zeitintervall konfiguriert werden.';
$string['infobannermodetimebased'] = 'Zeitgesteuert';
$string['infobannerordersetting'] = 'Infobanner {$a->no} Reihenfolge';
$string['infobannerordersetting_desc'] = 'Mit dieser Einstellung legen Sie die Position für das Infobanner {$a->no} fest. Standardmäßig sind die Infobanner von oben nach unten angeordnet, wie Sie sie auf dieser Einstellungsseite hier sehen. Mit dieser Einstellung können Sie die Reihenfolge ändern. Wenn Sie mehreren Infobannern dieselbe Position zuweisen, werden diese erneut gemäß der Reihenfolge auf dieser Einstellungsseite geordnet.';
$string['infobannerpageloginpage'] = 'Anmeldeseite';
$string['infobannerpagessetting'] = 'Seitenlayouts zur Anzeige von Infobanner {$a->no} auf';
$string['infobannerpagessetting_desc'] = 'Mit dieser Einstellung können Sie die Seitenlayouts auswählen, auf denen Infobanner {$a->no} angezeigt werden soll.';
$string['infobannerstartsetting'] = 'Infobanner {$a->no} Startzeit';
$string['infobannerstartsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, ab wann Infobanner {$a->no} angezeigt werden soll. Die konfigurierte Zeit wird als Serverzeit interpretiert, nicht als Nutzerzeit.';
$string['infobannertab'] = 'Infobanner';
$string['invalidurl'] = 'Die angegebene URL ist ungültig.';
$string['javascriptdisabledhint'] = 'Hinweis zu JavaScript';
$string['javascriptdisabledhint_desc'] = 'Mit dieser Einstellung erscheint oben in Moodle ein Hinweis, wenn JavaScript nicht aktiviert ist. Dies ist besonders hilfreich, da einige Moodle-Funktionen ohne JavaScript nicht funktionieren.';
$string['javascriptdisabledhinttext'] = 'JavaScript ist in Ihrem Browser deaktiviert.<br />Viele Funktionen in Moodle können nicht verwendet werden oder scheinen fehlerhaft zu sein.<br />Aktivieren Sie bitte JavaScript, um Moodle in vollem Umfang nutzen zu können.';
$string['javascriptheading'] = 'JavaScript';
$string['linkstab'] = 'Links';
$string['loginbackgroundimage'] = 'Hintergrundbilder für die Anmeldeseite';
$string['loginbackgroundimage_desc'] = 'Bilder, die als Hintergrund auf der Anmeldeseite gezeigt werden. Jeweils eins der Bilder wird zufällig ausgewählt und als Hintergrund angezeigt, wenn Nutzer/innen die Anmeldeseite besuchen. Stellen Sie bitte sicher, dass Sie ausschließlich Ascii-Zeichen im Dateinamen verwenden, wenn Sie Text für Anmeldehintergrundbilder anzeigen möchten.';
$string['loginbackgroundimagepositionsetting'] = 'Position des Hintergrundbildes auf der Anmeldeseite';
$string['loginbackgroundimagepositionsetting_desc'] = 'Mit dieser Einstellung steuern Sie die Position des Hintergrundbildes der Anmeldeseite innerhalb des Browserfensters. Der erste Wert ist die horizontale Position, der zweite Wert ist die vertikale Position.';
$string['loginbackgroundimagesheading'] = 'Hintergrundbilder für die Anmeldeseite';
$string['loginbackgroundimagetextsetting'] = 'Text für Hintergrundbilder anzeigen';
$string['loginbackgroundimagetextsetting_desc'] = 'Mit dieser optionalen Einstellung können Sie Text hinzufügen, z.B. einen Urheberrechtshinweis zum jeweils hochgeladenen Hintergrundbild. Dieser Text erscheint oben in der Fußzeile der Anmeldeseite. Aus Platzgründen wird der Text jedoch nur auf größeren Bildschirmen angezeigt.<br />
Jede Zeile besteht aus der Dateikennung (das ist der Dateiname), dem anzuzeigenden Text und der Textfarbe, getrennt durch Pipe-Zeichen |. Jede Deklaration muss in eine neue Zeile geschrieben werden. <br />
Beispiel:<br />
background-image-1.jpg|Copyright: CC0|dark<br />
Als Textfarbe können Sie die Werte "dark" oder "light" verwenden.<br />
Sie können Texte für beliebig viele hochgeladene Hintergrundbilder einfügen. Die Texte werden nur mit dem jeweiligen Bild gezeigt, dessen Dateiname mit der angegebenen Dateikennung übereinstimmt.';
$string['loginformheading'] = 'Anmeldeformular';
$string['loginformpositionsetting'] = 'Position des Anmeldeformulars';
$string['loginformpositionsetting_center'] = 'Zentriert';
$string['loginformpositionsetting_desc'] = 'Mit dieser Einstellung können Sie das Anmeldeformular so optimieren, dass es zu einer großen Vielfalt von Hintergrundbildern passt. Standardmäßig ist das Anmeldeformular zentriert auf der Anmeldeseite. Alternativ können Sie es nach links oder rechts auf der Anmeldeseite bewegen, um andere Teile des Hintergrundbildes durchscheinen zu lassen. Sie können diese Einstellung auch ändern, wenn keine Hintergrundbilder hochgeladen sind.';
$string['loginformpositionsetting_left'] = 'Linksbündig';
$string['loginformpositionsetting_right'] = 'Rechtsbündig';
$string['loginformtransparencysetting'] = 'Transparenz des Anmeldeformulars';
$string['loginformtransparencysetting_desc'] = 'Mit dieser Einstellung können Sie das Anmeldeformular transparent machen, damit das Hintergrundbild besser durchscheint.';
$string['loginidpshowintrosetting'] = 'Einführung in die IDP-Anmeldung';
$string['loginidpshowintrosetting_desc'] = 'Mit dieser Einstellung steuern Sie, ob das Intro <em>\'{$a}\'</em> über den IDP-Anmeldeschaltflächen angezeigt wird oder nicht. Standardmäßig wird die Einführung angezeigt und Nutzer/innen werden schnell darüber informiert, worum es bei den IDP-Schaltflächen geht. Wenn Sie diese Einstellung deaktivieren, wird die IDP-Einführung ausgeblendet. Dadurch können Sie eine saubere Anmeldeschnittstelle bereitstellen, wenn Sie nur externe Identitätsanbieter wie OAuth2 oder OIDC verwenden.';
$string['loginlocalintro'] = 'Anmelden mit Ihrem Moodle-Konto';
$string['loginlocalloginenablesetting'] = 'Lokale Anmeldung';
$string['loginlocalloginenablesetting_desc'] = 'Mit dieser Einstellung steuern Sie, ob das lokale Anmeldeformular auf der Anmeldeseite angezeigt wird oder nicht. Standardmäßig wird das lokale Anmeldeformular angezeigt und Nutzer/innen melden sich wie gewohnt bei der Website an. Wenn Sie diese Einstellung deaktivieren, wird das lokale Anmeldeformular ausgeblendet. Dadurch können Sie alleine die Anmeldeschaltflächen für externe Identitätsanbieter wie OAuth2 oder OIDC bereitstellen.';
$string['loginlocalloginenablesetting_note'] = 'Beachten Sie: Sobald Sie das lokale Anmeldeformular ausblenden, besteht die Gefahr, dass sich Administrator/innen nicht mehr mit einem lokalen Konto anmelden können, sobald ein Problem mit dem externen Identitätsanbieter vorliegt. Um in solchen Fällen trotzdem lokale Anmeldungen zu ermöglichen, wird eine <a href="{$a->url}">lokale Anmeldeseite mit Seiteneingang</a> bereitgestellt. Bitte speichern Sie sich diese URL als Lesezeichen, damit Sie den Administrator-Zugriff nicht verlieren.';
$string['loginlocalloginformhead'] = 'Lokale Anmeldung';
$string['loginlocalloginlocalnotdisabled'] = 'Eine Anmeldung über dieses lokale Anmeldeformular ist nicht erforderlich. Verwenden Sie bitte zum Anmelden die <a href="{$a->url}">Standard-Anmeldeseite</a>.';
$string['loginlocalshowintrosetting'] = 'Einführung in die lokale Anmeldung';
$string['loginlocalshowintrosetting_desc'] = 'Mit dieser Einstellung steuern Sie, ob über dem lokalen Anmeldeformular ein <em>\'{$a}\'</em>-Intro angezeigt wird oder nicht. Standardmäßig wird das Intro nicht angezeigt. Wenn Sie das Intro  aktivieren, kann dies als Einführung helfen, welche Anmeldeinformationen im lokalen Anmeldeformular verwendet werden. Das ist insbesondere sinnvoll, wenn Sie mehr als eine Anmeldemethode angeben oder die Reihenfolge der Anmeldemethoden geändert haben.';
$string['loginorderfirsttimesignupsetting'] = 'Informationen für Erstbesucher und Selbstregistrierung';
$string['loginorderguestsetting'] = 'Gast-Anmeldung';
$string['loginorderheading'] = 'Anmeldereihenfolge';
$string['loginorderheading_desc'] = 'Mit diesen Einstellungen steuern Sie die Reihenfolge der Anmeldemethoden im Anmeldeformular. Die angezeigte Reihenfolge wird von der niedrigsten zur höchsten Ordnungszahl definiert, wobei alle Anmeldemethoden und Anmeldeformularelemente übersprungen werden, die in Moodle deaktiviert sind.';
$string['loginorderheading_note'] = 'Technischer Hinweis: Die dargestellte Reihenfolge wird mit CSS-Flexbox-Sortierung realisiert, nicht durch Neuanordnung der Anmelde-Widgets im HTML-DOM. Dies sollte in allen modernen Browsern in Ordnung sein, funktioniert jedoch möglicherweise nicht mit wirklich alten Browsern.';
$string['loginorderidpsetting'] = 'IDP-Anmeldung';
$string['loginorderlocalsetting'] = 'Lokale Anmeldung';
$string['loginpagetab'] = 'Anmeldeseite';
$string['loginprovidersheading'] = 'Anmelde-Provider';
$string['logocompactsetting'] = 'Kompaktes Logo';
$string['logocompactsetting_desc'] = 'Hier können Sie eine kompakte Version desselben Logos wie oben hochladen, z.B. ein Emblem, Schild oder Symbol. Dieses Bild wird insbesondere in der Navigationsleiste oben auf jeder Moodle-Seite verwendet. Das Bild sollte auch bei kleinen Größen klar erkennbar sein.';
$string['logosetting'] = 'Logo';
$string['logosetting_desc'] = 'Hier können Sie ein großformatiges Logo hochladen, das als Dekoration verwendet werden soll. Dieses Bild wird insbesondere auf der Anmeldeseite verwendet. Dieses Bild kann eine hohe Auflösung haben, da es für die Verwendung angepasst wird.';
$string['logosheading'] = 'Logos';
$string['logosheading_desc'] = 'Beachten Sie: Das Design "Boost Union" hat einen eigenen Logo-Upload und verwendet nicht das <a href="{$a}">Logo des Moodle-Core</a>.<br />Boost Union ermöglicht insbesondere, mehr Bilderformate hochzuladen als im Moodle-Core zugelassen.  Zusätzlich ermöglicht der Upload hier, die hochgeladenen Logos innerhalb der Varianten von Boost Union zu überschreiben.';
$string['maintenancecontentsetting'] = 'Inhalt der Wartungsinfo';
$string['maintenancecontentsetting_desc'] = 'In dieser Einstellung können Sie Textinhalte hinzufügen, die in einer Wartungsinfo angezeigt werden (die nicht mit dem integrierten "Wartungsseiten-Support" von Moodle identisch ist).';
$string['maintenancedisabled'] = 'Die Wartungsinfos sind für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['maintenanceheading'] = 'Wartung';
$string['maintenancelinkpositionboth'] = 'Link für Wartungsinfo in der Fußzeile und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['maintenancelinkpositionfooter'] = 'Link für Wartungsinfo zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['maintenancelinkpositionfootnote'] = 'Link für Wartungsinfo in der Fußzeile hinzufügen';
$string['maintenancelinkpositionnone'] = 'Link für Wartungsinfo nicht automatisch anzeigen';
$string['maintenancelinkpositionsetting'] = 'Linkposition für Wartungsinfo';
$string['maintenancelinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob automatisch ein Link für Wartungsinfo hinzugefügt werden soll. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie überall manuell einen Link zu {$a->url} hinzufügen.';
$string['maintenancepagetitledefault'] = 'Wartung';
$string['maintenancepagetitlesetting'] = 'Titel der Wartungsinfo';
$string['maintenancepagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Wartungsinfo festlegen. Dieser Text wird auch als Linktext zur Wartungsinfo verwendet, wenn Sie die \'Linkposition für Wartungsinfo\' entsprechend konfigurieren.';
$string['markbrokenlinkssetting'] = 'Defekte Links markieren';
$string['markbrokenlinkssetting_desc'] = 'Diese Option fügt ein Symbol "kaputte Kette" vor defekten Links hinzu (die zu hochgeladenen Entwurfsdateien führen, aber nicht ordnungsgemäß verarbeitet wurden) und markiert den Link in der Bootstrap-Farbe als "Gefahr". Im Gegensatz zu den Einstellungen "Externe Links markieren" und "Mailto-Links markieren" gibt es bei dieser Einstellung keine Möglichkeit, den Umfang einzuschränken, da das Markieren defekter Links ein Indikator dafür ist, dass etwas kaputt ist und manuell behoben werden muss.';
$string['markexternallinksscopesetting'] = 'Umfang von externen Links markieren';
$string['markexternallinksscopesetting_desc'] = 'Mit dieser Einstellung steuern Sie den Bereich, in dem Boost Union externe Links markieren soll. Standardmäßig markiert Boost Union externe Links auf der gesamten Website und versucht sein Bestes, einige Randfälle abzudecken, in denen das Hinzufügen des externen Link-Symbols wenig Sinn macht. Sie können den Umfang jedoch auch einschränken, um Randfälle besser zu vermeiden.';
$string['markexternallinkssetting'] = 'Externe Links markieren';
$string['markexternallinkssetting_desc'] = 'Diese Einstellung fügt ein Symbol "Externer Link" zu denjenigen Links hinzu, die zu Zielen außerhalb von Moodle führen.';
$string['marklinksscopesetting_coursemain'] = 'Nur im Hauptinhaltsbereich von Kurshauptseiten';
$string['marklinksscopesetting_wholepage'] = 'Auf der gesamten Seite';
$string['markmailtolinksscopesetting'] = 'Umfang von Mailto-Links markieren';
$string['markmailtolinksscopesetting_desc'] = 'Mit dieser Einstellung steuern Sie den Bereich, in dem Boost Union Mailto-Links markieren soll. Standardmäßig markiert Boost Union Mailto-Links auf der gesamten Website. Sie können den Umfang jedoch auch einschränken, um Randfälle zu vermeiden.';
$string['markmailtolinkssetting'] = 'Mailto-Links markieren';
$string['markmailtolinkssetting_desc'] = '"Umschlag"-Symbol vor Mailto-Links hinzufügen';
$string['maxlogowidth'] = 'Maximale Breite des Logos in der Navigationsleiste';
$string['maxlogowidth_desc'] = 'In der Navigationsleiste wird das hochgeladene kompakte Logo standardmäßig mit 100% Höhe und proportionaler Breite angezeigt. Sollte das Logo jedoch zu breit sein oder ein anderes spezielles Seitenverhältnis aufweisen, können Sie hier die maximale Breite des Logos in der Navigationsleiste festlegen. Sie können pixelbasierte Werte wie 120px, aber auch einen prozentualen Wert wie 10% oder eine Viewport-Breite wie 5vw eingeben. Wenn Sie keinen Wert eingeben, wird das Logo in der Standarddarstellung angezeigt.';
$string['mediumcontentmaxwidthsetting'] = 'Maximale Breite von mittleren Inhalten';
$string['mediumcontentmaxwidthsetting_desc'] = 'Mit dieser Einstellung können Sie die Breite von mittleren Inhalten ohne manuelle SCSS-Änderungen überschreiben. Diese Seitenbreite wird bei bestimmten Aktivitäten wie der Datenbankaktivität verwendet. Standardmäßig verwendet Moodle für mittlere Inhalte eine maximale Breite von 1120px. Sie können andere pixelbasierte Breite wie 1200px eingeben, aber auch einen prozentualen Wert wie 100% oder eine Breite des Darstellungsbereichs wie 90vw.';
$string['misctab'] = 'Verschiedenes';
$string['mobileappearanceheading'] = 'Mobile Darstellung';
$string['mobileappheading'] = 'Mobile App';
$string['mobilecss'] = 'Zusätzliches CSS für mobile App';
$string['mobilecss_desc'] = 'Mit dieser Einstellung können Sie nutzerdefinierten CSS-Code schreiben, um die Nutzeroberfläche der mobilen App anzupassen. Der CSS-Code wird nur zur Darstellung in der mobilen App hinzugefügt und nicht in der Webbrowser verwendet. Lesen Sie mehr über diese Funktion in der <a href="https://moodledev.io/general/app/customisation/remote-themes#how-do-remote-themes-work">Moodle-Entwicklerdokumentation</a>.';
$string['mobilecss_donotchange'] = 'Dieser Schritt ist erforderlich, um den CSS-Code an die mobile App zu senden. Ändern Sie die URL nicht, es sei denn, Sie möchten den CSS-Code wirklich wieder aus der Mobile-App entfernen.';
$string['mobilecss_overwrite'] = 'Sobald Sie CSS-Code hinzufügen und diese Einstellung speichern, wird die <a href="{$a->url}">Einstellung <em>mobilecssurl</em> im Moodle-Core</a> automatisch mit einer URL des Designs "Boost Union" überschrieben. Momentan ist die Einstellung auf <a href="{$a->value}">{$a->value}</a> gesetzt.';
$string['mobilecss_set'] = 'Sobald Sie CSS-Code hinzufügen und diese Einstellung speichern, wird die <a href="{$a->url}">Einstellung <em>mobilecssurl</em> im Moodle-Core</a> automatisch mit einer URL des Designs "Boost Union" überschrieben.';
$string['mobiletab'] = 'Mobile';
$string['modiconactivity'] = 'Aktivität';
$string['modiconactivityunknown'] = 'Unbekannt';
$string['modicongtmoodle4'] = 'Icon für Moodle 4';
$string['modiconlistsetting'] = 'Liste von nutzerdefinierten Symboldateien';
$string['modiconlistsetting_desc'] = 'Dies ist die Liste der nutzerdefinierten Symboldateien, die Sie oben in den entsprechenden Dateibereich hochgeladen haben. Hier werden alle gültigen Symboldateien aufgelistet. Andere Dateien, die Sie möglicherweise ebenfalls hochgeladen haben, die aber keine gültigen Symboldateien sind, werden als beschädigte Dateien angezeigt.';
$string['modiconltmoodle311'] = 'Icon für Moodle 3';
$string['modiconnamefail'] = 'Diese Datei wurde im richtigen Verzeichnis für die Aktivität <em>{$a}</em> hochgeladen, aber der Dateiname ist ungültig. Ändern Sie bitte den Dateinamen entweder in <em>monologo.svg</em> / <em>monologo.png</em> (für Moodle 4-Symbole) oder in <em>icon.svg</em> / <em>icon .png</em> (für ältere Moodle 3-Symbole).';
$string['modiconnotexist'] = 'Diese Datei wurde an einem ungeeigneten Ort hochgeladen, da es nicht möglich ist, aus dem Dateipfad <em>{$a}</em> eine bestimmte Aktivität abzuleiten.';
$string['modiconsenablesetting'] = 'Nutzerdefinierte Symbole für Aktivitäten und Ressourcen aktivieren';
$string['modiconsenablesetting_desc'] = 'Mit dieser Einstellung können Sie die Symbole für Aktivitäten und Ressourcen ändern, die von Moodle auf den Kursseiten und in der Aktivitätsauswahl verwendet werden.';
$string['modiconserrorcreatingpath'] = 'Das Verzeichnis pix_plugins/mod konnte  im Verzeichnis moodledata nicht erstellt werden.<br />Die Fehlermeldung lautet: {$a}.';
$string['modiconsfiles'] = 'Nutzerdefinierte Symboldateien';
$string['modiconsfiles_desc'] = 'Hier können Sie nutzerdefinierte Symbole für alle oder auch nur bestimmte Aktivitäten hochladen, die in diesem Moodle installiert sind.';
$string['modiconsfileshowto'] = 'Um ein bestimmtes nutzerdefiniertes Aktivitätssymbol hochzuladen, erstellen Sie zunächst ein Verzeichnis mit dem internen Namen der Aktivität, z.B. <em>assign</em> für die Aktivität Aufgabe. In dieses Verzeichnis laden Sie das Symbol als SVG-Datei mit dem Namen monologo.svg und, wenn möglich, als Fallback-PNG-Datei mit dem Namen monologo.png hoch. Wenn Sie die farbigen Symbole für Moodle 3, die möglicherweise noch von älteren Plugins verwendet werden, anpassen möchten, können Sie diese auch als icon.svg- und icon.png-Dateien hochladen. Um optimale Ergebnisse zu erzielen, sollten Sie möglichst monochrome SVG-Symbole verwenden. Sobald Sie die Einstellung mit mindestens einer Symboldatei gespeichert haben, erscheint unten eine Dateiliste. Sie  können hiermit überprüfen, ob die nutzerdefinierten Symbole korrekt hochgeladen wurden.';
$string['modiconsfilestech'] = 'Technischer Hinweis: Nach dem Speichern der Einstellung wird die Verzeichnisstruktur mit den Symboldateien ins Verzeichnis moodledata/pix_plugins/mod kopiert. Hier sucht Moodle Core nach nutzerdefinierten Aktivitätssymbolen. Alle möglicherweise bereits an dieser Stelle  vorhandenen Symboldateien werden beim Speichern dieser Einstellung überschrieben.';
$string['modiconsheading'] = 'Aktivitätssymbole';
$string['modiconsuccess3x'] = 'Dieses Symbol wird für die Aktivität <em>{$a}</em> als Symbol für Moodle 3 verwendet.';
$string['modiconsuccess4x'] = 'Dieses Symbol wird für die Aktivität <em>{$a}</em> als Symbol für Moodle 4 verwendet.';
$string['modiconversion'] = 'Symbolversion';
$string['navbarcolorsetting'] = 'Farbe Navigationsleiste';
$string['navbarcolorsetting_dark'] = 'Dunkle Navigationsleiste mit heller Schrift';
$string['navbarcolorsetting_desc'] = 'Mit dieser Einstellung können Sie die Navigationsleiste von hell (Standard) auf dunkel oder farbig ändern.';
$string['navbarcolorsetting_light'] = 'Helle Navigationsleiste mit dunkler Schrift (wie Moodle-Standard)';
$string['navbarcolorsetting_primarydark'] = 'Navigationsleiste in Farbe Primär mit heller Schrift';
$string['navbarcolorsetting_primarylight'] = 'Navigationsleiste in Farbe Primär mit dunkler Schrift';
$string['navbarheading'] = 'Navigationsleiste';
$string['navigationheading'] = 'Navigation';
$string['navigationtab'] = 'Navigation';
$string['never'] = 'Nie';
$string['nochange'] = 'Keine Änderung';
$string['offerscontentsetting'] = 'Angebotsinhalte';
$string['offerscontentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf der Angebotsseite angezeigt werden.';
$string['offersdisabled'] = 'Die Angebotsseite ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['offersheading'] = 'Angebote';
$string['offerslinkpositionboth'] = 'Link für Angebotsseite in der Fußzeile und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['offerslinkpositionfooter'] = 'Link für Angebotsseite zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['offerslinkpositionfootnote'] = 'Link für Angebotsseite in der Fußzeile hinzufügen';
$string['offerslinkpositionnone'] = 'Link für Angebotsseite nicht automatisch anzeigen';
$string['offerslinkpositionsetting'] = 'Linkposition für Angebotsseite';
$string['offerslinkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link für eine Angebotsseite hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['offerspagetitledefault'] = 'Angebote';
$string['offerspagetitlesetting'] = 'Titel der Angebotsseite';
$string['offerspagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der Angebotssteite festlegen. Dieser Text wird auch als Linktext zur Angebotsseite verwendet, wenn Sie die \'Linkposition für Angebotsseite\' entsprechend konfigurieren.';
$string['openoffcanvas'] = 'Off-Canvas öffnen';
$string['outsideregionsheading'] = 'Regionen außerhalb';
$string['outsideregionsheading_desc'] = 'Die Regionen außerhalb können nicht nur mit den genannten Layouteinstellungen aktiviert werden, sondern auch im Erscheinungsbild angepasst werden.';
$string['outsideregionsplacement'] = 'Horizontale Platzierung der Regionen außerhalb';
$string['outsideregionsplacement_desc'] = 'Mit dieser Einstellung können Sie steuern, ob die Blockregionen \'Außen (links)\' und \'Außen (rechts)\' auf größeren Bildschirmen nah am Hauptinhalt oder eher nah an den Fensterrändern platziert werden sollen.';
$string['outsideregionsplacementnearwindowedges'] = 'Blockregionen \'Außen (links)\' und \'Außen (rechts)\' nah am Fensterrand anzeigen';
$string['outsideregionsplacementnextmaincontent'] = 'Blockregionen \'Außen (links)\' und \'Außen (rechts)\' nah am Hauptinhalt anzeigen';
$string['outsideregionswidthcoursecontentwidth'] = 'Breite des Kursinhalts';
$string['outsideregionswidthfullwidth'] = 'Volle Breite';
$string['outsideregionswidthherowidth'] = 'Ideale Breite';
$string['page1contentsetting'] = 'Inhalt für allgemeine Seite 1';
$string['page1contentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf der allgemeinen Seite 1 angezeigt werden.';
$string['page1disabled'] = 'Die allgemeine Seite 1 ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['page1heading'] = 'Allgemeine Seite 1';
$string['page1linkpositionboth'] = 'Link für allgemeine Seite 1 in der Fußzeile und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page1linkpositionfooter'] = 'Link für allgemeine Seite 1 zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page1linkpositionfootnote'] = 'Link für allgemeine Seite 1 in der Fußzeile hinzufügen';
$string['page1linkpositionnone'] = 'Link für allgemeine Seite 1 nicht automatisch anzeigen';
$string['page1linkpositionsetting'] = 'Linkposition für allgemeine Seite 1';
$string['page1linkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link für eine allgemeine Seite 1 hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['page1pagetitledefault'] = 'Allgemeine Seite 1';
$string['page1pagetitlesetting'] = 'Titel für allgemeine Seite 1';
$string['page1pagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der allgemeinen Seite 1 festlegen. Dieser Text wird auch als Linktext zur allgemeinen Seite 1 verwendet, wenn Sie die \'Linkposition für allgemeine Seite 1\' entsprechend konfigurieren.';
$string['page2contentsetting'] = 'Inhalt für allgemeine Seite 2';
$string['page2contentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf der allgemeinen Seite 2 angezeigt werden.';
$string['page2disabled'] = 'Die allgemeine Seite 2 ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['page2heading'] = 'Allgemeine Seite 2';
$string['page2linkpositionboth'] = 'Link für allgemeine Seite 2 in der Fußzeile und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page2linkpositionfooter'] = 'Link für allgemeine Seite 2 zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page2linkpositionfootnote'] = 'Link für allgemeine Seite 2 in der Fußzeile hinzufügen';
$string['page2linkpositionnone'] = 'Link für allgemeine Seite 2 nicht automatisch anzeigen';
$string['page2linkpositionsetting'] = 'Linkposition für allgemeine Seite 2';
$string['page2linkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link für eine allgemeine Seite 2 hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['page2pagetitledefault'] = 'Allgemeine Seite 2';
$string['page2pagetitlesetting'] = 'Titel für allgemeine Seite 2';
$string['page2pagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der allgemeinen Seite 2 festlegen. Dieser Text wird auch als Linktext zur allgemeinen Seite 2 verwendet, wenn Sie die \'Linkposition für allgemeine Seite 2\' entsprechend konfigurieren.';
$string['page3contentsetting'] = 'Inhalt für allgemeine Seite 3';
$string['page3contentsetting_desc'] = 'In dieser Einstellung können Sie formatierte Textinhalte hinzufügen, die auf der allgemeinen Seite 3 angezeigt werden.';
$string['page3disabled'] = 'Die allgemeine Seite 3 ist für diese Website deaktiviert. Hier wird nichts angezeigt.';
$string['page3heading'] = 'Allgemeine Seite 3';
$string['page3linkpositionboth'] = 'Link für allgemeine Seite 3 in der Fußzeile und zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page3linkpositionfooter'] = 'Link für allgemeine Seite 3 zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page3linkpositionfootnote'] = 'Link für allgemeine Seite 3 zum Fußzeilensymbol (Fragezeichen) hinzufügen';
$string['page3linkpositionnone'] = 'Link für allgemeine Seite 3 nicht automatisch anzeigen';
$string['page3linkpositionsetting'] = 'Linkposition für allgemeine Seite 3';
$string['page3linkpositionsetting_desc'] = 'In dieser Einstellung können Sie konfigurieren, ob in Moodle automatisch ein Link für eine allgemeine Seite 3 hinzugefügt wird. Wenn Sie nicht automatisch einen Link anzeigen möchten, können Sie auch überall manuell einen Link zu {$a->url} hinzufügen.';
$string['page3pagetitledefault'] = 'Allgemeine Seite 3';
$string['page3pagetitlesetting'] = 'Titel für allgemeine Seite 3';
$string['page3pagetitlesetting_desc'] = 'In dieser Einstellung können Sie den Titel der allgemeinen Seite 3 festlegen. Dieser Text wird auch als Linktext zur allgemeinen Seite 3 verwendet, wenn Sie die \'Linkposition für allgemeine Seite 3\' entsprechend konfigurieren.';
$string['pagelayoutstab'] = 'Seitenlayouts';
$string['pagetab'] = 'Seitenbreite';
$string['pagewidthheading'] = 'Seitenbreite';
$string['pluginname'] = 'Boost Union';
$string['policyheading'] = 'Richtlinien';
$string['policyoverviewnavigationsetting'] = 'Navigation in Richtlinienübersicht anzeigen';
$string['policyoverviewnavigationsetting_desc'] = 'Standardmäßig zeigt die <a href="{$a->url}">Richtlinienübersichtsseite (von tool_policy)</a> kein Navigationsmenü und keine Fußzeile an. Mit dieser Einstellung können Sie die primäre Navigation und die Fußzeile auf dieser Seite anzeigen.';
$string['presetbutton'] = 'Designvorlage in Boost setzen';
$string['presetheading'] = 'Designvorlagen';
$string['presetheading_desc'] = 'Mit den Designvorlagen können Sie das Erscheinungsbild des Designs umfassend ändern. Boost Union implementiert die Designvorlagen nicht erneut. Wenn Sie Designvorlagen verwenden möchten, legen Sie diese bitte direkt in Boost fest. Boost Union erbt und verwendet die konfigurierte Voreinstellung.';
$string['primarynavigationheading'] = 'Primäre Navigation';
$string['privacy:metadata'] = 'Das Design "Boost Union" speichert keine personenbezogenen Daten.';
$string['recentlyaccesseditemsheading'] = 'Block "Kürzlich aufgerufene Elemente"';
$string['recentlyaccesseditemstintenabled'] = 'Aktivitätssymbole "Kürzlich aufgerufene Elemente"';
$string['recentlyaccesseditemstintenabled_desc'] = 'Mit dieser Einstellung können Sie die Aktivitätsymbole im Block "Kürzlich aufgerufene Elemente" basierend auf den Aktivitätszwecken einfärben. Standardmäßig zeigt der Moodle Core schwarze Symbole an.';
$string['region-content-lower'] = 'Inhalt (unten)';
$string['region-content-upper'] = 'Inhalt (oben)';
$string['region-footer-center'] = 'Fußbereich (mittig)';
$string['region-footer-left'] = 'Fußbereich (links)';
$string['region-footer-right'] = 'Fußbereich (rechts)';
$string['region-header'] = 'Kopfbereich';
$string['region-none'] = 'Keine';
$string['region-offcanvas-center'] = 'Off-Canvas (mittig)';
$string['region-offcanvas-left'] = 'Off-Canvas (links)';
$string['region-offcanvas-right'] = 'Off-Canvas (rechts)';
$string['region-outside-bottom'] = 'Außen (unten)';
$string['region-outside-left'] = 'Außen (links)';
$string['region-outside-right'] = 'Außen (rechts)';
$string['region-outside-top'] = 'Außen (oben)';
$string['resourcescachecontrolnote'] = 'Beachten Sie bitte, dass die Dateien mit dem "Cache-Control-Header" an den Browser geliefert und dort im Cache gespeichert werden. Wenn Sie sicher sind, dass sich die Dateien nicht ändern, können Sie die gleichbleibenden URLs verwenden. Wenn Sie jedoch eine oder mehrere Dateien ändern und die Dateinamen beibehalten, sollten Sie lieber die revisionierten URLs verwenden. Zwar wird so jede Datei immer neu ausgeliefert, aber Sie verhindern veraltete Versionen im Browsercache.';
$string['resourcestab'] = 'Ressourcen';
$string['scrollspysetting'] = 'Scroll-Spion';
$string['scrollspysetting_desc'] = 'Mit dieser Einstellung wird beim Ein- und Ausschalten des Bearbeitungsmodus die Bildlaufposition beibehalten, an der sich die Person beim Ausführen des Umschaltens befand.';
$string['scssheading'] = 'Raw SCSS';
$string['scsstab'] = 'SCSS';
$string['setpreferredlanglink'] = 'Bevorzugte Sprache wählen';
$string['settingsoverview'] = 'Einstellungsübersicht';
$string['settingsoverview_accessibility_desc'] = 'Einstellungen für Funktionalität in Bezug auf Barrierefreiheit Ihrer Moodle-Website befinden sich hier.';
$string['settingsoverview_all'] = 'Alle Einstellungen auf einer Seite';
$string['settingsoverview_all_desc'] = 'Hier können Sie die standardmäßige Moodle-Kategorieeinstellungsseite für Boost Union öffnen, die alle Einstellungen auf einer Seite anzeigt. Aber Vorsicht, die Seite ist wirklich sehr voll.';
$string['settingsoverview_content_desc'] = 'Hier finden Sie Einstellungen für globale Inhalte Ihrer Moodle-Website: Fußzeile, statische Seiten, Infobanner, Werbekacheln und Schieberegler.';
$string['settingsoverview_feel_desc'] = 'Einstellungen für das Gesamtverhalten Ihrer Moodle-Website finden Sie hier: Navigationselemente, Navigationshilfen, Blöcke und Links.';
$string['settingsoverview_flavours_desc'] = 'Mit Flavours können Sie das Erscheinungsbild Ihrer Moodle-Website nach globalen Gruppen und / oder Kurskategorien variieren.';
$string['settingsoverview_functionality_desc'] = 'Hier finden Sie Einstellungen für zusätzliche nützliche globale oder kursbezogene Funktionen auf Ihrer Moodle-Website.';
$string['settingsoverview_look_desc'] = 'Hier finden Sie Einstellungen für das Branding Ihrer Moodle-Website: Farben, Symbole, Bilder, Größen und natürlich benutzerdefiniertes SCSS.';
$string['settingsoverview_smartmenus_desc'] = 'Mit intelligenten Menüs können Sie die Navigationselemente Ihrer Moodle-Website im Hauptmenü und in den Benutzermenüs erweitern sowie ein unteres Menü oder ein oberes Menü einführen.';
$string['settingsoverview_title'] = 'Einstellungsübersicht für Boost Union';
$string['showfullnameinusermenussetting'] = 'Vollständiger Name im Nutzermenü';
$string['showfullnameinusermenussetting_desc'] = 'Mit dieser Einstellung können Sie den vollständigen Namen der angemeldeten Person oben im Nutzermenü anzeigen. Dies kann insbesondere in Prüfungssituationen hilfreich sein, wo Nutzer/innen unbedingt mit dem eigenen Konto angemeldet sein müssen. Es kann aber auch für die Nutzer/innen selbst hilfreich sein. Im Gegensatz zum Design Classic, bei dem der vollständige Name neben dem Avatar angezeigt wird, beansprucht das Desin Boost hier keinen zusätzlichen Platz in der Navigationsleiste.';
$string['showfullnameinusermenussetting_loggedinas'] = 'Sie sind angemeldet als:';
$string['showhintcourseguestaccessgeneral'] = 'Sie betrachten diesen Kurs gerade als <strong>{$a->role}</strong>.';
$string['showhintcourseguestaccesslink'] = 'Um vollen Zugriff auf diesen Kurs zu erhalten, können Sie sich <a href="{$a->url}">selbst in diesen Kurs einschreiben</a>.';
$string['showhintcourseguestaccesssetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis im Kopfbereich aktiviert, wenn Nutzer/innen einen Kurs über den Gastzugang betreten. Wenn der Kurs eine aktive Selbsteinschreibung anbietet, wird dem Gast außerdem ein Link zu dieser Einschreibemöglichkeit angezeigt.';
$string['showhintcoursehiddengeneral'] = 'Dieser Kurs ist zurzeit <strong>verborgen</strong>. Solange der Kurs verborgen ist, können ausschließlich eingeschriebene Trainer/innen darauf zugreifen.';
$string['showhintcoursehiddensetting'] = 'Hinweis in verborgenen Kursen anzeigen';
$string['showhintcoursehiddensetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis im Kursheader angezeigt, solange der Kurs verborgen ist. Dies erlaubt die Erkennung des Sichtbarkeitsstatuses eines Kurses auf einen Blick, ohne die Kurseinstellungen öffnen zu müssen.';
$string['showhintcoursehiddensettingslink'] = 'Sie können die Sichtbarkeit in den <a href="{$a->url}">Kurseinstellungen</a> ändern.';
$string['showhintcourseselfenrolfrom'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung ab {$a->from}.';
$string['showhintcourseselfenrolfromuntil'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung ab {$a->from} bis {$a->until}.';
$string['showhintcourseselfenrolinstancecallforaction'] = 'Wenn Sie verhindern möchten, dass sich Nutzer/innen ungehindert in diesen Kurs einschreiben können, beschränken Sie dies bitte in den Einstellungen zur Selbsteinschreibung.';
$string['showhintcourseselfenrolsetting'] = 'Hinweis wegen Selbsteinschreibung ohne Einschreibeschlüssel anzeigen';
$string['showhintcourseselfenrolsetting_desc'] = 'Mit dieser Einstellung können Sie festlegen, dass ein Hinweis im Kurskopf erscheint, wenn ein Kurs sichtbar ist und eine Selbsteinschreibung ohne Einschreibeschlüssel aktuell möglich ist.';
$string['showhintcourseselfenrolsince'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt aktuell eine unbeschränkte Selbsteinschreibung.';
$string['showhintcourseselfenrolsinceuntil'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung bis {$a->until}.';
$string['showhintcourseselfenrolstartcurrently'] = 'Dieser Kurs ist momentan für alle sichtbar und eine <strong>Selbsteinschreibung ohne Einschreibeschlüssel</strong> ist möglich.';
$string['showhintcourseselfenrolstartfuture'] = 'Dieser Kurs ist momentan für alle sichtbar und eine <strong>Selbsteinschreibung ohne Einschreibeschlüssel</strong> ist mit Startdatum konfiguriert.';
$string['showhintcourseselfenrolunlimited'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung auf unbestimmte Zeit.';
$string['showhintcourseselfenroluntil'] = 'Die Einschreibung <strong>{$a->name}</strong> erlaubt eine unbeschränkte Selbsteinschreibung bis {$a->until}.';
$string['showhintcoursguestaccesssetting'] = 'Hinweis bei Gastzugang anzeigen';
$string['showhintforumnotifications'] = 'Dieser Kurs ist zur Zeit <strong>verborgen</strong>. <strong>Teilnehmer/innen werden nicht über Beiträge benachrichtigt</strong>, wenn Sie in diesem Forum schreiben, weder online noch per E-Mail.';
$string['showhintforumnotificationssetting'] = 'Hinweis für Forenbenachrichtigungen in verborgenen Kursen anzeigen';
$string['showhintforumnotificationssetting_desc'] = 'Mit dieser Einstellung wird nicht nur im Kursheader, sondern auch in Foren ein Hinweis angezeigt, wenn die Sichtbarkeit des Kurses ausgeblendet ist. Dies soll verdeutlichen, dass Benachrichtigungen innerhalb eines Forums nicht an Studierende gesendet werden und den Lehrenden helfen, diesen Umstand verständlicher zu machen.';
$string['shownavbarstarredcourses_config'] = 'Legen Sie markierte Kurse auf der Seite \'{$a}\' fest';
$string['shownavbarstarredcourses_label'] = 'Kursfavoriten';
$string['shownavbarstarredcoursessetting'] = 'Popover mit Kursfavoriten in der Navbar anzeigen';
$string['shownavbarstarredcoursessetting_desc'] = 'Mit dieser Einstellung können Sie neben den Nachrichten- und Benachrichtigungsmenüs ein Popover-Menü mit Links zu markierten Kursen anzeigen.';
$string['showsitehomerighthandblockdraweronfirstloginsetting'] = 'Rechtsseitige Blockleiste beim ersten Login auf der Startseite anzeigen';
$string['showsitehomerighthandblockdraweronfirstloginsetting_desc'] = 'Mit dieser Einstellung wird die rechtsseitige Blockleiste auf der Startseite standardmäßig im ausgeklappten Zustand angezeigt. Dies gilt nur für Nutzer/innen, die sich zum ersten Mal anmelden, und überschreibt nicht den Toggle-Status von einzelnen Nutzer/innen.';
$string['showsitehomerighthandblockdraweronguestloginsetting'] = 'Rechtsseitige Blockleiste beim Gast-Login auf der Startseite anzeigen';
$string['showsitehomerighthandblockdraweronguestloginsetting_desc'] = 'Mit dieser Einstellung wird die rechtsseitige Blockleiste auf der Startseite standardmäßig im ausgeklappten Zustand angezeigt. Dies gilt nur für Nutzer/innen, die als Gast angemeldet sind.';
$string['showsitehomerighthandblockdraweronvisitsetting'] = 'Rechtsseitige Blockleiste auf der Startseite beim Besuch anzeigen';
$string['showsitehomerighthandblockdraweronvisitsetting_desc'] = 'Mit dieser Einstellung wird die rechtsseitige Blockleiste auf der Startseite standardmäßig im ausgeklappten Zustand angezeigt. Dies gilt nur für Nutzer/innen, die nicht angemeldet sind, und überschreibt nicht den Toggle-Status von einzelnen Nutzer/innen.';
$string['showswitchedroleincoursesetting'] = 'Hinweis bei Rollenwechsel anzeigen';
$string['showswitchedroleincoursesetting_desc'] = 'Mit dieser Einstellung wird ein Hinweis in der Kurskopfzeile angezeigt, wenn die Person die Rolle im Kurs gewechselt hat. Standardmäßig werden diese Informationen nur direkt neben dem Avatar im Nutzermenü angezeigt. Wenn Sie diese Option aktivieren, können Sie diese Information - zusammen mit einem Link zum Zurückschalten - auch innerhalb der Kursseite anzeigen.';
$string['showviewcourseiconincoursemgntsesetting_desc'] = 'Standardmäßig fordert Moodle auf der <a href="{$a}">Kursverwaltungsseite</a>, dass Sie entweder die Kursdetails öffnen oder die Kurseinstellungen durchlaufen, bevor Sie auf ein zusätzliches UI-Element klicken können. Durch Aktivieren dieser Einstellung können Sie ein Icon "Kurs anzeigen" direkt zur Kategorieliste auf der Kursverwaltungsseite hinzufügen.';
$string['showviewcourseiconincoursemgntsetting'] = 'Icon "Kurs anzeigen“ hinzufügen';
$string['sideentranceloginenablesetting'] = 'Anmeldung am Seiteneingang aktivieren';
$string['sideentranceloginenablesetting_desc'] = 'Mit dieser Einstellung können Sie eine <a href="{$a->url}">lokale Anmeldeseite</a> aktivieren. Diese wird automatisch aktiviert, wenn Sie das lokale Anmeldeformular deaktivieren (siehe oben). Sie können sie aber auch dauerhaft aktivieren, um lokalen Nutzer/innen das Umgehen der Hauptanmeldeseite und des Anmeldevorgangs zu ermöglichen, was insbesondere bei SSO-Konfigurationen hilfreich ist. Selbstverständlich gelten auch auf der lokalen Anmeldeseite alle Sicherheitsmaßnahmen von Moodle.';
$string['sideentranceloginheading'] = 'Anmeldung am Seiteneingang';
$string['sitebrandingtab'] = 'Website';
$string['sitehomerighthandblockdrawerbehaviour'] = 'Rechtsseitige Blockleiste auf der Startseite';
$string['slidebackgroundimagealtsetting'] = 'Slide {$a->no} Alt-Attribute für Hintergrundbild';
$string['slidebackgroundimagealtsetting_desc'] = 'Hier können Sie ein Alt-Attribut für das Bild der Folie {$a->no} festlegen. Dies ist eine optionale Einstellung. Die Folie wird auch dann angezeigt, wenn Sie kein Alt-Attribut festlegen. Bitte beachten Sie, dass das Fehlen eines Alt-Attributs die Zugänglichkeit beeinträchtigt.';
$string['slidebackgroundimagesetting'] = 'Slide {$a->no} Hintergrundbild';
$string['slidebackgroundimagesetting_desc'] = 'Hier können Sie eine Bilddatei hochladen, die als Hintergrundbild hinter dem Inhalt der Folie {$a->no} angezeigt wird. Bitte stellen Sie sicher bzw. prüfen Sie, dass der Inhalt auf dem Hintergrundbild noch lesbar ist. Bitte stellen Sie außerdem sicher, dass das Seitenverhältnis aller Hintergrundbilder der Folien gleich ist (da das Seitenverhältnis der Hintergrundbilder die Höhe der Folie steuert und Sie möglicherweise ein Flackern beim Wechseln der Folien vermeiden möchten). Dies ist eine zwingende Einstellung, die Folie wird nicht angezeigt, wenn Sie kein Hintergrundbild hochladen.';
$string['slidecaptionsetting'] = 'Slide {$a->no} Überschrift';
$string['slidecaptionsetting_desc'] = 'Hier geben Sie die Beschriftung ein, die in der Folie {$a->no} angezeigt werden soll. Die Beschriftung wird unten in der Mitte der Folie angezeigt. Dies ist eine optionale Einstellung. Die Folie wird auch dann angezeigt, wenn Sie keine Beschriftung festlegen.';
$string['slidecontentsetting'] = 'Slide {$a->no} Inhalt';
$string['slidecontentsetting_desc'] = 'Hier geben Sie den Inhalt ein, der in der Folie {$a->no} angezeigt werden soll. Der Inhalt wird unten in der Mitte der Folie angezeigt. Wenn eine Beschriftung festgelegt ist, wird der Inhalt unterhalb der Beschriftung angezeigt. Bitte beachten Sie, dass der Rich-Text-Editor standardmäßig linksbündigen Text erzeugt. Für ein ansprechenderes Erscheinungsbild möchten Sie dies jedoch möglicherweise in zentrierten Text ändern. Bitte sehen Sie auch davon ab, der Folie zu viel Inhalt hinzuzufügen und testen Sie Ihre Inhalte bitte auf kleinen Geräten, da Inhalte, die über die Folie hinausgehen, einfach ausgeblendet werden. Dies ist eine optionale Einstellung, die Folie wird auch dann angezeigt, wenn Sie keinen Inhalt festlegen.';
$string['slidecontentstylesetting'] = 'Slide {$a->no} Inhaltstyp';
$string['slidecontentstylesetting_dark'] = 'Dunkel (Schware Schrift für helle Hintergrundbilder)';
$string['slidecontentstylesetting_darkshadow'] = 'Dunkel & Schatten (Schware Schrift und helle Schatten für helle Hintergrundbilder)';
$string['slidecontentstylesetting_desc'] = 'Hier können Sie den Inhaltsstil der Folie {$a->no} ändern. Standardmäßig ist der Inhaltsstil eine weiße Schriftfarbe für dunkle Hintergrundbilder. Um jedoch ein einheitliches und einfaches Styling für alle Arten von Hintergrundbildern zu ermöglichen, können Sie den Stil hier überschreiben. Bitte beachten Sie, dass diese Einstellung in jedem Fall Vorrang vor der Schriftfarbe hat, die Sie oben im Rich-Text-Editor festgelegt haben.';
$string['slidecontentstylesetting_light'] = 'Hell (Weiße Schrift für dunkle Hintergrundbilder)';
$string['slidecontentstylesetting_lightshadow'] = 'Hell & Schatten (Weiße Schrift und dunkle Schatten für dunkle Hintergrundbilder)';
$string['slideenabledsetting'] = 'Slide {$a->no} aktivieren';
$string['slideenabledsetting_desc'] = 'Mit dieser Einstellung können Sie den Slide {$a->no} aktivieren';
$string['slideheading'] = 'Slide {$a->no}';
$string['slidelinksetting'] = 'Slide {$a->no} Link-URL';
$string['slidelinksetting_desc'] = 'Hier können Sie eine (Moodle-interne oder externe) URL festlegen, auf die der Folieninhalt der Folie {$a->no} verlinkt. Dies ist eine optionale Einstellung. Die Folie wird auch dann angezeigt, wenn Sie keine Link-URL festlegen.';
$string['slidelinksourcesetting'] = 'Slide {$a->no} Link-Quelle';
$string['slidelinksourcesetting_both'] = 'Hintergrundbild und Textelemente';
$string['slidelinksourcesetting_desc'] = 'Hier können Sie steuern, welche Elemente des Sliders auf die angegebene Link-URL verweisen. Sie können wählen, ob Sie nur das Hintergrundbild, nur die Textelemente der Folie (Beschriftung und Inhalt) oder beides verlinken möchten.';
$string['slidelinksourcesetting_image'] = 'Nur Hintergrundbild';
$string['slidelinksourcesetting_text'] = 'Nur Textelemente';
$string['slidelinktargetsetting'] = 'Slide {$a->no} Link-Ziel';
$string['slidelinktargetsetting_desc'] = 'Hier können Sie das Linkziel festlegen, das für den Folienlink gesetzt wird, sobald Sie in der Folie {$a->no} eine Link-URL festlegen.';
$string['slidelinktargetsetting_newtab'] = 'Neuer Tab';
$string['slidelinktargetsetting_samewindow'] = 'Gleiches Fenster';
$string['slidelinktitlesetting'] = 'Linktitel für Slide {$a->no}';
$string['slidelinktitlesetting_desc'] = 'Hier können Sie einen Linktitel festlegen, der als Tooltip angezeigt wird, sobald eine Person mit der Maus über die Folie {$a->no} fährt. Dies ist eine optionale Einstellung. Die Folie wird auch dann verlinkt, wenn Sie keinen Linktitel festlegen. Bitte beachten Sie, dass die Nichtangabe eines Linktitels die Zugänglichkeit beeinträchtigt.';
$string['slideordersetting'] = 'Position für Slide {$a->no}';
$string['slideordersetting_desc'] = 'Mit dieser Einstellung legen Sie die Position der Folie {$a->no} in der Reihenfolge fest. Standardmäßig sind die Folien so angeordnet, wie Sie sie auf dieser Einstellungsseite hier sehen. Sie können mit dieser Einstellung jedoch entscheiden, eine andere Position zuzuweisen. Wenn Sie zwei oder mehr Folien die gleiche Position zuweisen, werden diese erneut entsprechend der Reihenfolge auf dieser Einstellungsseite geordnet.';
$string['slideranimationsetting'] = 'Animationstyp für Slider';
$string['slideranimationsetting_desc'] = 'Mit dieser Einstellung steuern Sie die Slider-Animation. \'Slide\' wendet eine gleitende Animation an, \'Fade\' wendet eine verblassende Animation an und \'Keine\' entfernt alle Animationen.';
$string['slideranimationsetting_fade'] = 'Ausblenden';
$string['slideranimationsetting_none'] = 'Keine';
$string['slideranimationsetting_slide'] = 'Slide';
$string['sliderarrownavsetting'] = 'Pfeilnavigation aktivieren';
$string['sliderarrownavsetting_desc'] = 'Mit dieser Einstellung können Sie Navigationspfeile auf beiden Seiten des Sliders hinzufügen.';
$string['sliderfrontpagepositionsetting'] = 'Position des Slider auf der Startseite';
$string['sliderfrontpagepositionsetting_afterafter'] = 'Nach dem Inhalt der Startseite (und nach den Werbekacheln)';
$string['sliderfrontpagepositionsetting_afterbefore'] = 'Nach dem Inhalt der Startseite (aber vor den Werbekacheln)';
$string['sliderfrontpagepositionsetting_beforeafter'] = 'Vor dem Inhalt der Startseite (aber nach den Werbekacheln)';
$string['sliderfrontpagepositionsetting_beforebefore'] = 'Vor dem Inhalt der Startseite (und vor den Werbekacheln)';
$string['sliderfrontpagepositionsetting_desc'] = 'Der Slider wird nur auf der Startseite der Website angezeigt. Mit dieser Einstellung steuern Sie, ob der Slider vor dem oder nach dem Inhalt der Startseite angezeigt wird. Wenn Sie auf der Startseite der Website nur den Slider und nichts anderes anzeigen möchten, können alle anderen Inhalte der Startseite durch Ändern der <a href="{$a->url}">Einstellungen für die Website-Startseite</a> entfernt werden.';
$string['slidergeneralheading'] = 'Slider allgemein';
$string['sliderindicatornavsetting'] = 'Slider Indikatornavigation aktivieren';
$string['sliderindicatornavsetting_desc'] = 'Mit dieser Einstellung können Sie Indikatoren unten im Slider hinzufügen.';
$string['sliderintervalsetting'] = 'Slider Anzeigedauer';
$string['sliderintervalsetting_desc'] = 'Mit dieser Einstellung steuern Sie, wie lange eine Folie in Millisekunden angezeigt wird. Der Mindestwert beträgt 1000 (eine Sekunde) und der Höchstwert 10000 (10 Sekunden).';
$string['sliderkeyboardsetting'] = 'Slider Tastaturinteraktion';
$string['sliderkeyboardsetting_desc'] = 'Mit dieser Einstellung ermöglichen Sie Tastatureingaben (Pfeiltasten) zur Steuerung des Sliders. Bitte beachten Sie, dass die Deaktivierung die Zugänglichkeit beeinträchtigt.';
$string['sliderpausesetting'] = 'Slider bei Mausberührung pausieren';
$string['sliderpausesetting_desc'] = 'Mit dieser Einstellung verhindern Sie, dass der Slider die Folien wechselt, wenn eine Person mit der Maus über eine Folie fährt. Bitte beachten Sie, dass die Deaktivierung die Zugänglichkeit beeinträchtigt.';
$string['sliderridesetting'] = 'Durch die Slides blättern';
$string['sliderridesetting_afterinteraction'] = 'Nach der Interaktion';
$string['sliderridesetting_desc'] = 'Mit dieser Einstellung steuern Sie das Laufverhalten des Sliders. "Beim Laden der Seite" beginnt mit dem Folienwechsel, nachdem die Seite vollständig geladen wurde. "Nach der Interaktion" beginnt mit dem Folienwechsel, nachdem eine Person mit dem Slider interagiert hat. "Nie" deaktiviert den automatischen Folienwechsel vollständig und erfordert eine Nutzereingabe, um durch die Folien zu blättern.';
$string['sliderridesetting_never'] = 'Nie';
$string['sliderridesetting_onpageload'] = 'Beim Laden';
$string['slidertab'] = 'Slider';
$string['sliderwrapsetting'] = 'Kontinuierlich durch die Slides blättern';
$string['sliderwrapsetting_desc'] = 'Mit dieser Einstellung aktivieren Sie einen sich kontinuierlich wiederholenden Slider mit allen Folien. Wenn Sie dies deaktivieren, stoppt der Slider bei der letzten Folie.';
$string['smartmenus'] = 'Smartmenüs';
$string['smartmenus_desc'] = '<p>Mit Smartmenüs können Administrator/innen anpassbare Menüs erstellen und an verschiedenen Stellen auf der Website platziert werden können, z.B. im Hauptmenü der Website, im unteren mobilen Menü und im Nutzermenü. Die Menüs können so konfiguriert werden, dass sie verschiedene Arten von Inhalten anzeigen, einschließlich Links zu anderen Seiten oder Ressourcen, Kategorielinks oder Benutzerprofillinks.</p><p>Administrator/innen können ein neues Menü erstellen, die Menüelemente auswählen und Einstellungen anzeigen. Die Administrator/innen können außerdem auswählen, wo das Menü auf der Website angezeigt wird und ob es für alle Nutzer/innen oder nur für bestimmte Rollen sichtbar sein soll.</p>';
$string['smartmenusbyadmin'] = 'Anzeigen für';
$string['smartmenusbyadmin_admins'] = 'Nur Administrator/innen';
$string['smartmenusbyadmin_all'] = 'Alle Nutzer/innen';
$string['smartmenusbyadmin_help'] = 'Ansicht basierend auf der Administrator-Rolle einschränken';
$string['smartmenusbyadmin_nonadmins'] = 'Nur Nicht-Administrator/innen';
$string['smartmenusbycohort'] = 'Nach globaler Gruppe';
$string['smartmenusbycohort_help'] = 'Sichtbarkeit basierend auf globale Gruppen beschränken';
$string['smartmenusbydate'] = 'Nach Datum';
$string['smartmenusbydate_help'] = 'Sichtbarkeit basierend auf Datum beschränken';
$string['smartmenusbydatefrom'] = 'Von';
$string['smartmenusbydatefrom_help'] = 'Sichtbarkeit vor dem angegebenen Datum beschränken';
$string['smartmenusbydateuntil'] = 'Bis';
$string['smartmenusbydateuntil_help'] = 'Sichtbarkeit ab dem angegebenen Datum beschränken';
$string['smartmenusbylanguage'] = 'Nach Sprache';
$string['smartmenusbylanguage_help'] = 'Sichtbarkeit basierend auf der Sprache beschränken';
$string['smartmenusbyrole'] = 'Nach Rolle';
$string['smartmenusbyrole_help'] = 'Sichtbarkeit basierend auf der Rolle beschränken';
$string['smartmenusdynamiccoursescompletionstatus'] = 'Abschlussstatus';
$string['smartmenusdynamiccoursescompletionstatus_help'] = 'Der Menüpunkt \'dynamischen Kursliste\' zeigt alle Kurse einer Person, die dem ausgewählten Abschlussstatus entsprechen. Wenn Sie beispielsweise \'In Bearbeitung\' als Abschlussstatus auswählen, enthält die Liste der dynamischen Kurse im Menüpunkt nur Kurse, an denen die Person gerade arbeitet.';
$string['smartmenusdynamiccoursescompletionstatuscompleted'] = 'Abgeschlossen';
$string['smartmenusdynamiccoursescompletionstatusenrolled'] = 'Eingeschrieben';
$string['smartmenusdynamiccoursescompletionstatusinprogress'] = 'In Arbeit';
$string['smartmenusdynamiccoursescoursecategory'] = 'Kursbereich';
$string['smartmenusdynamiccoursescoursecategory_help'] = 'Der Menüpunkt \'dynamischen Kursliste\' zeigt alle Kurse im ausgewählten Kursbereich an.';
$string['smartmenusdynamiccoursescoursecategorysubcats'] = 'Kursunterbereiche einbeziehen';
$string['smartmenusdynamiccoursescoursecategorysubcats_help'] = 'Wenn diese Option aktiviert ist, enthält das dynamische Kursmenü auch alle Kurse aus den Unterbereichen der ausgewählten Kursbereiche..';
$string['smartmenusdynamiccoursesdaterange'] = 'Datumsbereich';
$string['smartmenusdynamiccoursesdaterange_help'] = 'Der Menüpunkt \'dynamischen Kursliste\' zeigt alle Kurse, die in den ausgewählten Datumsbereich fallen.';
$string['smartmenusdynamiccoursesdaterangefuture'] = 'Zukunft';
$string['smartmenusdynamiccoursesdaterangepast'] = 'Vergangenheit';
$string['smartmenusdynamiccoursesdaterangepresent'] = 'Gegenwart';
$string['smartmenusdynamiccoursesenrolmentrole'] = 'Einschreiberolle';
$string['smartmenusdynamiccoursesenrolmentrole_help'] = 'Der Menüpunkt \'dynamischen Kursliste\' zeigt alle Kurse, in den die Person mit der ausgewählten Rolle eingeschrieben ist.';
$string['smartmenusexperimental'] = 'Beachten Sie bitte: Die Smartmenü-Funktionalität ist im aktuellen Stand der Implementierung vollständig nutzbar, muss aber aufgrund der großen Anzahl an Einstellungskombinationen, die immer noch unerwartete Probleme auslösen können, als <em>experimentell</em> betrachtet werden. Bitte testen Sie vor diesem Hintergrund Ihre Smartmenüs ausführlich mit Ihren individuellen Menüeinstellungen. Wenn Sie auf Probleme mit den Smartmenüs stoßen, melden Sie diese bitte auf <a href="https://github.com/moodle-an-hochschulen/moodle-theme_boost_union/issues">Github</a> mit klaren Schritten zur Reproduktion.';
$string['smartmenusgeneralsectionheader'] = 'Allgemeine Einstellungen';
$string['smartmenusmenuaddnewitem'] = 'Menüelement hinzufügen';
$string['smartmenusmenucardform'] = 'Kartenformat';
$string['smartmenusmenucardform_help'] = 'Wählen Sie die Form der Karte für Menüs im Kartenstil. Entscheiden Sie sich zwischen Quadrat, Hochformat, Querformat oder voller Breite.';
$string['smartmenusmenucardformfullwidth'] = 'Volle Breite';
$string['smartmenusmenucardformlandscape'] = 'Querformat';
$string['smartmenusmenucardformportrait'] = 'Hochformat';
$string['smartmenusmenucardformsquare'] = 'Quadrat';
$string['smartmenusmenucardoverflowbehavior'] = 'Verhalten beim Kartenüberlauf';
$string['smartmenusmenucardoverflowbehavior_help'] = 'Wählen Sie aus, wie sich das Menü verhalten soll, wenn der Container überläuft. Entscheiden Sie sich zwischen der Anzeige einer Bildlaufleiste oder dem Umbrechen der überlaufenden Elemente.';
$string['smartmenusmenucardoverflowbehaviornowrap'] = 'Nicht umbrechen';
$string['smartmenusmenucardoverflowbehaviorwrap'] = 'Umbrechen';
$string['smartmenusmenucardsize'] = 'Kartengröße';
$string['smartmenusmenucardsize_help'] = 'Wählen Sie die Größe der Karte für Menüs im Kartenstil aus. Enscheiden Sie sich zwischen sehr klein, klein, mittel oder groß.';
$string['smartmenusmenucardsizelarge'] = 'Groß';
$string['smartmenusmenucardsizemedium'] = 'Mittel';
$string['smartmenusmenucardsizesmall'] = 'Klein';
$string['smartmenusmenucardsizetiny'] = 'Sehr klein';
$string['smartmenusmenucreate'] = 'Menü anlegen';
$string['smartmenusmenucreatesuccess'] = 'Smartmenü erfolgreich angelegt';
$string['smartmenusmenucssclass'] = 'CSS Class';
$string['smartmenusmenucssclass_help'] = 'Geben Sie eine CSS Class für das Menü an. Dies kann verwendet werden, um dem Menü einen nutzerdefinierten Stil zu verleihen.';
$string['smartmenusmenudeleteconfirm'] = 'Möchten Sie wirklich dieses Menü aus den Smartmenüs löschen?';
$string['smartmenusmenudeletesuccess'] = 'Smartmenü erfolgreich gelöscht';
$string['smartmenusmenudescription'] = 'Beschreibung';
$string['smartmenusmenudescription_help'] = 'Beschreibung des Menüs. Dies wird primär zur internen Dokumentation verwendet, aber Sie können die Beschreibung auch im Menü anzeigen lassen.';
$string['smartmenusmenuduplicate'] = 'Menü und seine Elemente duplizieren';
$string['smartmenusmenuduplicatesuccess'] = 'Menü und seine Elemente erfolgreich dupliziert';
$string['smartmenusmenuedit'] = 'Menü bearbeiten';
$string['smartmenusmenueditsuccess'] = 'Smartmenü erfolgreich aktualisiert';
$string['smartmenusmenuitemcardappearanceheader'] = 'Aussehen der Karte';
$string['smartmenusmenuitemcardbackgroundcolor'] = 'Hintergrundfarbe der Karte';
$string['smartmenusmenuitemcardbackgroundcolor_help'] = 'Wählen Sie die Hintergrundfarbe der Karte für das Menüelement';
$string['smartmenusmenuitemcardimage'] = 'Kartenbild';
$string['smartmenusmenuitemcardimage_help'] = 'Wählen Sie ein Bild, das neben dem Titel des Menüelements auf der Karte angezeigt wird';
$string['smartmenusmenuitemcardimagealt'] = 'Alternativtext für Kartenbild';
$string['smartmenusmenuitemcardimagealt_help'] = 'Der Alternativtext für das Kartenbild dieses Menüpunkts. Über den Platzhalter {menutitle} können Sie den konfigurierten Menüpunkttitel in Ihren eigenen Alternativtext einfügen. Wenn Sie dieses Feld komplett leer lassen, wird der Menüpunkttext automatisch als Alternativtext verwendet.';
$string['smartmenusmenuitemcardtextcolor'] = 'Textfarbe der Karte';
$string['smartmenusmenuitemcardtextcolor_help'] = 'Wählen Sie die Textfarbe der Karte für das Menüelement';
$string['smartmenusmenuitemcreate'] = 'Menüelement anlegen';
$string['smartmenusmenuitemcreatesuccess'] = 'Smartmenü-Element erfolgreich angelegt';
$string['smartmenusmenuitemcssclass'] = 'CCS Class';
$string['smartmenusmenuitemcssclass_help'] = 'Geben Sie eine CSS Class für das Menüelement an. Die kann verwendet werden, um dem Menüelement einen nutzerdefinierten Stil zu verleihen.';
$string['smartmenusmenuitemdeleteconfirm'] = 'Möchten Sie wirklich dieses Menüelement aus dem Smartmenü löschen?';
$string['smartmenusmenuitemdeletesuccess'] = 'Smartmenü-Element erfolgreich gelöscht';
$string['smartmenusmenuitemdisplayfield'] = 'Präsentation des Kursnamens';
$string['smartmenusmenuitemdisplayfield_help'] = 'Kursname, der als als Titel in den Menüpunkten der dynamischen Kurse angezeigt werden soll. Wählen Sie zwischen dem vollständigen Namen des Kurses und dem Kurznamen des Kurses.';
$string['smartmenusmenuitemdisplayfieldcoursefullname'] = 'Vollständiger Kursname';
$string['smartmenusmenuitemdisplayfieldcourseshortname'] = 'Kurzer Kursname';
$string['smartmenusmenuitemdisplayoptions'] = 'Präsentation des Titels';
$string['smartmenusmenuitemdisplayoptions_help'] = 'Wählen Sie aus, wie der Titel des Menüelements angezeigt werden soll.';
$string['smartmenusmenuitemdisplayoptionshidetitle'] = 'Titeltext ausblenden und nur Symbol anzeigen (auf allen Endgeräten)';
$string['smartmenusmenuitemdisplayoptionshidetitlemobile'] = 'Titeltext ausblenden und nur Symbol anzeigen (auf mobilen Endgeräten)';
$string['smartmenusmenuitemdisplayoptionsshowtitleicon'] = 'Text und Symbol als Titel anzeigen';
$string['smartmenusmenuitemduplicate'] = 'Menüelement duplizieren';
$string['smartmenusmenuitemduplicatesuccess'] = 'Menüelement erfolgreich dupliziert';
$string['smartmenusmenuitemedit'] = 'Menüelement bearbeiten';
$string['smartmenusmenuitemeditsuccess'] = 'Smartmenü-Element erfogreich bearbeitet';
$string['smartmenusmenuitemicon'] = 'Symbol';
$string['smartmenusmenuitemicon_help'] = 'Symbol, das neben dem Titel des Menüelements angezeigt werden soll';
$string['smartmenusmenuitemlinktarget'] = 'Linkziel';
$string['smartmenusmenuitemlinktarget_help'] = 'Linkziel des Menüelements. Der Link des Menüelements wird beim Klicken in diesem Ziel geöffnet (d.h. im selben Fenster oder in einem neuen Tab).';
$string['smartmenusmenuitemlinktargetnewtab'] = 'Neuer Tab';
$string['smartmenusmenuitemlinktargetsamewindow'] = 'Gleiches Fenster';
$string['smartmenusmenuitemlistsort'] = 'Sortierung der Kursliste';
$string['smartmenusmenuitemlistsort_help'] = 'Die Kursliste wird nach den ausgewählten Kriterien und in der Sortierreihenfolge sortiert. Wählen Sie zwischen Vollname, Kurzname, Kurs-ID und Kurs-ID-Nummer als Kriterien in Kombination mit aufsteigender und absteigender Sortierreihenfolge.';
$string['smartmenusmenuitemlistsortcourseidasc'] = 'Kurs-ID aufsteigend';
$string['smartmenusmenuitemlistsortcourseiddesc'] = 'Kurs-ID absteigend';
$string['smartmenusmenuitemlistsortcourseidnumberasc'] = 'Kurs-ID aufsteigend';
$string['smartmenusmenuitemlistsortcourseidnumberdesc'] = 'Kurs-ID absteigend';
$string['smartmenusmenuitemlistsortfullnameasc'] = 'Vollständiger Kursname aufsteigend';
$string['smartmenusmenuitemlistsortfullnamedesc'] = 'Vollständiger Kursname absteigend';
$string['smartmenusmenuitemlistsortshortnameasc'] = 'Kurzer Kursname aufsteigend';
$string['smartmenusmenuitemlistsortshortnamedesc'] = 'Kurzer Kursname absteigend';
$string['smartmenusmenuitemmode'] = 'Modus des Menüelements';
$string['smartmenusmenuitemmode_help'] = '<p>Wählen Sie den Modus aus, in dem der Menüpunkt im Menü angezeigt werden soll.</p><ul><li>Inline: Der Menüpunkt wird als normaler Menüpunkt im Menü angezeigt. Dies ist die Standardoption.</li><li>Untermenü: Das Menüelement wird als Untermenüelement angezeigt, das durch Klicken auf das übergeordnete Element erweitert oder reduziert werden kann. Dieser Modus eignet sich zum Aufbau einer dritten Navigationsebene sowie für Menüpunkten \'dynamische Kurse\', bei denen Kurslisten als Untermenüpunkte dieses Menüpunkts angezeigt werden können. Der Titel dieses Menüpunkts wird als Text für den Untermenüpunkt verwendet.</li></ul>';
$string['smartmenusmenuitemnothingtodisplay'] = 'Es wurden noch keine Elemente zu diesem Smartmenü hinzugefügt. Fügen Sie bitte diesem Menü einen Eintrag hinzu.';
$string['smartmenusmenuitemorder'] = 'Reihenfolge';
$string['smartmenusmenuitemorder_help'] = 'Ordnen Sie die Position des Elements bei Bedarf neu an. Alle Menüpunkte im Menü werden in dieser Reihenfolge sortiert.';
$string['smartmenusmenuitempresentationheader'] = 'Präsentation des Menüelements';
$string['smartmenusmenuitemresponsive'] = 'Responsives Verbergen';
$string['smartmenusmenuitemresponsive_help'] = 'Durch Aktivieren einer dieser Optionen wird der Menüpunkt auf Endgeräten mit der angegebenen Anzeigegröße ausgeblendet.';
$string['smartmenusmenuitemresponsivedesktop'] = 'Desktop';
$string['smartmenusmenuitemresponsivemobile'] = 'Smartphone';
$string['smartmenusmenuitemresponsivetablet'] = 'Tablet';
$string['smartmenusmenuitemrestriction'] = 'Zugriffsregeln';
$string['smartmenusmenuitems'] = 'Menüelemente';
$string['smartmenusmenuitemstructureheader'] = 'Struktur der Menüelemente';
$string['smartmenusmenuitemtextcount'] = 'Anzahl der Wörter';
$string['smartmenusmenuitemtextcount_help'] = 'Geben Sie die maximale Anzahl an Wörtern an, die als Titel in den Menüpunkten der dynamischen Kurse angezeigt werden sollen. Wenn Sie dieses Feld leer lassen, wird der Titel in voller Länge angezeigt.';
$string['smartmenusmenuitemtextposition'] = 'Position des Kartentextes';
$string['smartmenusmenuitemtextposition_help'] = '<p>Wählen Sie die Position des Menüelementtexts im Verhältnis zum Kartenbild aus . Entscheiden Sie zwischen unter dem Bild, dem oberen Overlay und dem unteren Overlay.</p><ul><li>Oberes Overlay: Zeigt den Titel des Menüelements über dem Overlay an und oben auf der Karte.</li><li>Unteres Overlay: Zeigt den Titel des Menüelements über dem Overlay und unten auf der Karte an.</li><li>Unter dem Bild: Zeigt den Titel des Menüelements unter dem Kartenbild.</li></ul>';
$string['smartmenusmenuitemtextpositionbelowimage'] = 'Unter dem Bild';
$string['smartmenusmenuitemtextpositionoverlaybottom'] = 'Unteres Overlay';
$string['smartmenusmenuitemtextpositionoverlaytop'] = 'Oberes Overlay';
$string['smartmenusmenuitemtitle'] = 'Titel';
$string['smartmenusmenuitemtitle_help'] = 'Menütitel. Dies wird als Beschriftung dieses Menüelements verwendet. Wenn Sie im Menü ein Trennzeichen anzeigen möchten, wählen Sie als Typ Überschrift und verwenden Sie als Titel Rautenzeichen (###).';
$string['smartmenusmenuitemtooltip'] = 'Tooltip';
$string['smartmenusmenuitemtooltip_help'] = 'Der Tooltip wird angezeigt, wenn eine Person mit der Maus über ddas Menüelement fährt.';
$string['smartmenusmenuitemtype'] = 'Typ des Menüelements';
$string['smartmenusmenuitemtype_help'] = '<p>Wählen Sie den Typ des Menüelements aus, das Sie erstellen möchten. Entscheiden Sie sich zwischen Statisch, Überschrift, Moodle Dokumentation und dynamischen Kursen.</p>
<ul><li>Statisch: Ein statisches Menüelement ist einfach ein Link zu einer festen URL, die sich nicht ändert.</li><li>Überschrift: Eine Überschrift wird verwendet, um zusammengehörige Menüelemente unter einer gemeinsamen Überschrift zu gruppieren. Das Menüelement verfügt über keinen Link und ist nicht anklickbar.</li><li>Moodle documentation: Ein Moodle Dokumentations-Menü verlinkt zugehörige MoodleDocs Einträge. Dies ist ähnlich wie der Moodle Docs Link im Footer abgebildet.</li><li>Dynamische Kurse: Ein Menüelement für dynamische Kurse wird verwendet, um eine Liste von Kursen basierend auf bestimmten Kriterien anzuzeigen, wie z.B. Kurskategorie, Kursrolle, Kursabschlussstatus oder Datumsbereich. Der in einem Menüelement für dynamische Kurse angezeigte Inhalt wird automatisch aktualisiert, wenn sich die Kriterien ändern.</li></ul>';
$string['smartmenusmenuitemtypedocs'] = 'Moodle-Dokumentation';
$string['smartmenusmenuitemtypedynamiccourses'] = 'Dynamische Kurse';
$string['smartmenusmenuitemtypeheading'] = 'Überschrift';
$string['smartmenusmenuitemtypestatic'] = 'Statisch';
$string['smartmenusmenuitemurl'] = 'URL des Menüelements';
$string['smartmenusmenuitemurl_help'] = 'Statische URL für das Menüelement. Dies ist ein Link, der aufgerufen wird, wenn das Menüelement angeklickt wird.';
$string['smartmenusmenulocation'] = 'Menüorte';
$string['smartmenusmenulocation_help'] = '<p>Wählen Sie die Stellen aus, an denen das Menü auf der Seite angezeigt werden soll:</p><ul><li>Die Hauptnavigation befindet sich oben auf der Seite, wo Moodle-Core die Bereiche "Startseite", "Dashboard", "Meine Kurse" und Website-Navigation anzeigt.</li><li>Die Menüleiste befindet sich über der Hauptnavigation oben auf der Seite.</li><li>Das Nutzermenü kann durch Klicken auf das persönliche Nutzerbild in der Navigationsleiste aufgerufen werden.</li><li>Die untere Leiste befindet sich am unteren Bildschirmrand und kann zur Implementierung einer Daumennavigation für den einfachen Zugriff auf wichtige Bereiche wie das Dashboard, "Meine Kurse" oder Startseite verwendet werden.</li></ul><p>Beachten Sie bitte, dass beim Aktivieren der unteren Leiste das Hamburger-Symbol durch das Logo Ihrer Website ersetzt wird, da Nutzer/innen dann über die untere Leiste zur Hauptnavigation gelangen können.</p>';
$string['smartmenusmenulocationbottom'] = 'Untere Leiste';
$string['smartmenusmenulocationmain'] = 'Hauptnavigation';
$string['smartmenusmenulocationmenu'] = 'Menüleiste';
$string['smartmenusmenulocationuser'] = 'Nutzermenü';
$string['smartmenusmenumode'] = 'Menümodus';
$string['smartmenusmenumode_help'] = '<p>Wählen Sie den Modus aus, in dem die Menüelemente angezeigt werden sollen.</p><ul><li>Untermenü: Die Menüelemente werden als Untermenü mit dem Titel des Menüs als übergeordnetem Knoten angezeigt. Dies ist die Standardoption.</li><li>Inline: Die Elemente des Menüs werden nacheinander direkt in der Navigation angezeigt. Beachten Sie bitte, dass diese Option für Kartenmenüs nicht unterstützt wird.</li></ul>';
$string['smartmenusmenumoremenubehavior'] = 'Verhalten das Mehr-Menüs';
$string['smartmenusmenumoremenubehavior_help'] = '<p>Was soll passieren, wenn zu viele Menüs vorhanden sind, um in den Menüspeicherort zu passen?</p><ul><li>Nichts ändern: Es wird kein bestimmtes Verhalten erzwungen, überzählige Menüs werden automatisch in das Menü "Mehr" verschoben.</li><li>Ins Menü "Mehr" zwingen: Dieser Modus verschiebt das Menü direkt ins Menü "Mehr", auch wenn noch Platz vorhanden wäre.</li><li>Außerhalb des Menüs "Mehr" halten: Dieser Modus hält das Menü so lange wie möglich außerhalb des Menüs "Mehr" und verschiebt stattdessen bei Bedarf andere nachfolgende Menüs in das Menü "Mehr".</li></ul><p>Beachten Sie bitte, dass diese Einstellung nur Menüs betrifft, die sich in der Hauptnavigation oder im Menüleistenbereich befinden.</p>';
$string['smartmenusmenumoremenubehaviorforceinto'] = 'In das Mehr-Menü zwingen';
$string['smartmenusmenumoremenubehaviorkeepoutside'] = 'Außerhalb des Mehr-Menüs behalten';
$string['smartmenusmenunothingtodisplay'] = 'Es wurden noch keine Smartmenüs erstellt. Erstellen Sie bitte Ihr erstes Smartmenü, um loszulegen.';
$string['smartmenusmenupresentationheader'] = 'Präsentation des Menüs';
$string['smartmenusmenushowdescription'] = 'Beschreibung anzeigen';
$string['smartmenusmenushowdescription_help'] = '<p>Wählen Sie aus, wie die Beschreibung im Menü angezeigt werden soll. Entscheiden Sie sich zwischen Nie, Oben, Unten und Hilfe.</p><ul><li>Nie: Die Beschreibung nicht im Menü anzeigen und nur  für interne Zwecke verwenden. Dies ist die Standardoption.</li><li>Oben: Zeigt die Beschreibung oben in der Menüliste an.</li><li>Unten: Zeigt die Beschreibung am Ende der Menüliste an.</li><li>Hilfe: Zeigt die Beschreibung als Hilfesymbol neben den Menüelementen an.</li></ul>';
$string['smartmenusmenushowdescriptionabove'] = 'Über';
$string['smartmenusmenushowdescriptionbelow'] = 'Unter';
$string['smartmenusmenushowdescriptionhelp'] = 'Hilfe';
$string['smartmenusmenushowdescriptionnever'] = 'Nie';
$string['smartmenusmenustructureheader'] = 'Menüstruktur';
$string['smartmenusmenutitle'] = 'Titel';
$string['smartmenusmenutitle_help'] = 'Titel des Menüs. Dies wird als Beschriftung des übergeordneten Knotens dieses Menüs verwendet.';
$string['smartmenusmenutype'] = 'Präsentationsart';
$string['smartmenusmenutype_help'] = '<p>Wählen Sie die Präsentationart für das Menü aus. Entscheiden Sie zwischen Liste und Karte.</p><ul><li>Liste: Ein Listenmenü besteht aus einfachen Textlinks. Dies ist die Standardoption.</li><li>Karte: Ein Kartenmenü besteht aus Karten.</li></ul>';
$string['smartmenusmenutypecard'] = 'Karte';
$string['smartmenusmenutypelist'] = 'Liste';
$string['smartmenusmodeinline'] = 'Inline';
$string['smartmenusmodesubmenu'] = 'Untermenü';
$string['smartmenusnorestrict'] = 'Nicht beschränkt';
$string['smartmenusoperator'] = 'Operator';
$string['smartmenusoperator_help'] = 'Wählen Sie den Operator für Bedingung \'globale Gruppe\' aus (beliebig oder alle).';
$string['smartmenusrestrictbyadminheader'] = 'Ansicht basierend auf Administrator-Status einschränken';
$string['smartmenusrestrictbycohortsheader'] = 'Sichtbarkeit beschränkt durch globale Gruppen';
$string['smartmenusrestrictbydateheader'] = 'Sichtbarkeit beschränkt durch Datum';
$string['smartmenusrestrictbylanguageheader'] = 'Sichtbarkeit beschränkt durch Sprache';
$string['smartmenusrestrictbyrolesheader'] = 'Sichtbarkeit beschränkt durch Rollen';
$string['smartmenusrolecontext'] = 'Kontext';
$string['smartmenusrolecontext_help'] = 'Wählen Sie den Kontext aus, für den die Nutzerrolle überprüft werden soll (nur jeder Kontext oder Systemkontext).';
$string['smartmenussavechangesandconfigure'] = 'Speichern und Elemente konfigurieren';
$string['smartmenussettings'] = 'Einstellungen für Smartmenü';
$string['speciallinksmarkupheading'] = 'Markierung von Links';
$string['starredcourseslinktargetsetting'] = 'Ziel-Link für das Zahnrad-Symbol im Favoriten Popover';
$string['starredcourseslinktargetsetting_desc'] = 'Mit dieser Einstellung können Sie den Ziel-Link des Zahnradsymbols im Favoriten Popover setzen. Standardmäßig verlinkt das Zahnradsymbol auf die Seite "Meine Kurse". Sie können aber auch auf das Dashboard verlinken, insbesondere dann, wenn die Seite "Meine Kurse" in der Hauptnavigation deaktivert wurde.';
$string['staticpagestab'] = 'Statische Seiten';
$string['switchedroleto'] = 'Sie sehen den Kurs momentan in der Rolle: <strong>{$a->role}</strong>.';
$string['task_purgecache'] = 'Design-Cache löschen';
$string['templateemailhtmlprefix'] = '';
$string['templateemailhtmlsuffix'] = '';
$string['templateemailtextprefix'] = '';
$string['templateemailtextsuffix'] = '';
$string['tertiarysettings'] = 'Liste der Einstellungsseiten von Boost Union';
$string['tilebackgroundimagepositionsetting'] = 'Hintergrundbildposition für Werbefeld {$a->no}';
$string['tilebackgroundimagepositionsetting_desc'] = 'Mit dieser Einstellung legen Sie die Position des Hintergrundbildes im Werbefeld {$a->no} fest. Der erste Wert ist die horizontale Position, der zweite Wert ist die vertikale Position.';
$string['tilebackgroundimagesetting'] = 'Hintergrundbild für Werbefeld {$a->no}';
$string['tilebackgroundimagesetting_desc'] = 'Hier können Sie ein Bild hochladen, das als Hintergrundbild hinter dem Inhalt im Werbefeld {$a->no} angezeigt wird. Stellen Sie bitte sicher, dass der Inhalt auf dem Hintergrundbild lesbar ist. Dies ist eine optionale Einstellung und das Werbefeld wird auch dann angezeigt, wenn Sie kein Hintergrundbild hochladen.';
$string['tilecolumnssetting'] = 'Anzahl von Werbefelder pro Zeile';
$string['tilecolumnssetting_desc'] = 'Hier legen Sie die Anzahl der Spalten pro Zeile für das Raster der Werbefelder fest. Beachten Sie, dass diese Spaltenanzahl nur für größere Bildschirme gilt. Auf kleineren Bildschirmen und mobilen Endgeräten werden die Spalten automatisch angepasst.';
$string['tilecontentsetting'] = 'Inhalt für Werbefeld {$a->no}';
$string['tilecontentsetting_desc'] = 'Hier geben Sie den Inhalt ein, der im Werbefeld {$a->no} angezeigt werden soll. Der Inhalt wird mittig im Bereich angezeigt. Dies ist eine optionale Einstellung und das Werbefeld wird auch dann angezeigt, wenn Sie keinen Inhalt eingeben.';
$string['tilecontentstylesetting'] = 'Inhaltsstil für Werbekachel {$a->no}';
$string['tilecontentstylesetting_dark'] = 'Dunkel (schwarze Schriftfarbe für helle Hintergrundbilder)';
$string['tilecontentstylesetting_darkshadow'] = 'Dunkel & Schatten (schwarze Schriftfarbe mit hellem Schatten für helle Hintergrundbilder)';
$string['tilecontentstylesetting_desc'] = 'Hier können Sie den Inhaltsstil der Werbekachel {$a->no} ändern. Standardmäßig wird der Inhaltsstil durch den Stil gesteuert, den Sie oben im Rich-Text-Editor festgelegt haben. Um jedoch ein konsistentes und einfaches Styling zu ermöglichen, insbesondere bei der Verwendung von Text auf Hintergrundbildern, können Sie den Stil hier überschreiben.';
$string['tilecontentstylesetting_light'] = 'Hell (weiße Schriftfarbe für dunkle Hintergrundbilder)';
$string['tilecontentstylesetting_lightshadow'] = 'Hell & Schatten (weiße Schriftfarbe mit dunklem Schatten für dunkle Hintergrundbilder)';
$string['tilecontentstylesetting_nochange'] = 'Keine Änderung (alle Stile im Rich-Text-Editor steuern)';
$string['tileenabledsetting'] = 'Werbefeld {$a->no} aktivieren';
$string['tileenabledsetting_desc'] = 'Mit dieser Einstellung können Sie das Werbefeld {$a->no} aktivieren.';
$string['tilefrontpagepositionsetting'] = 'Position der Werbefelder auf der Startseite';
$string['tilefrontpagepositionsetting_after'] = 'Nach dem Inhalt der Startseite';
$string['tilefrontpagepositionsetting_before'] = 'Vor dem Inhalt der Startseite';
$string['tilefrontpagepositionsetting_desc'] = 'Werbefelder werden nur auf der Startseite angezeigt. Sie können festlegen, ob die Werbefelder vor oder nach dem eigentlichen Inhalt der Startseite angezeigt werden sollen. Wenn Sie nur die Werbefelder anzeigen wollen und sonst nichts, können Sie alle anderen Inhalte der Startseite entfernen, indem Sie die <a href="{$a->url}">Einstellungen für die Startseite</a> ändern.';
$string['tileheading'] = 'Werbefeld {$a->no}';
$string['tileheightsetting'] = 'Höhe der Werbefelder';
$string['tileheightsetting_desc'] = 'Mit dieser Einstellung legen Sie die Höhe der Werbefelder fest. Die festgelegte Höhe ist die minimale Höhe. Wenn der Inhalt eines Feldes höher ist als die hier festgelegte Höhe, wird die gesamte Zeile der Werbefelder automatisch höher angezeigt.';
$string['tilelinksetting'] = 'URL für Werbefeld {$a->no}';
$string['tilelinksetting_desc'] = 'Hier können Sie eine URL festlegen, die Moodle intern oder extern ist und am Ende des Werbefeldes {$a->no} angezeigt wird. Dies ist eine optionale Einstellung und das Werbefeld wird auch dann angezeigt, wenn Sie keine URL festlegen.';
$string['tilelinktargetsetting'] = 'Linkziel für Werbefeld {$a->no}';
$string['tilelinktargetsetting_desc'] = 'Hier können Sie das Linkziel für die Linktaste festlegen, wenn eine URL im Werbefeld {$a->no} angegeben ist.';
$string['tilelinktargetsetting_newtab'] = 'Neuer Tab';
$string['tilelinktargetsetting_samewindow'] = 'Gleiches Fenster';
$string['tilelinktitlefallback'] = 'Link';
$string['tilelinktitlesetting'] = 'Linktitel für Werbefeld {$a->no}';
$string['tilelinktitlesetting_desc'] = 'Hier können Sie einen Linktitel festlegen, der auf der Linktaste gezeigt wird, wenn eine URL im Werbefeld {$a->no} angegeben ist. Beachten Sie, dass die Linktaste mit dem Wort "Link" beschriftet wird, falls Sie eine URL und keinen Linktitel festlegen.';
$string['tileordersetting'] = 'Rangfolge für Werbefeld {$a->no}';
$string['tileordersetting_desc'] = 'Mit dieser Einstellung legen Sie die Rangfolge für das Werbefeld {$a->no} fest. Standardmäßig werden die Werbefelder von oben nach unten und von links nach rechts angeordnet, wie Sie dies auf dieser Einstellungsseite hier sehen. Sie können aber auch eine andere Rangfolge zuzuweisen. Wenn Sie zwei oder mehr Werbebereichen dieselbe Rangfolge zuweisen, werden diese gemäß der Rangfolge auf dieser Einstellungsseite abgeordnet.';
$string['tilesgeneralheading'] = 'Werbefelder allgemein';
$string['tilestab'] = 'Werbefelder';
$string['tiletitlesetting'] = 'Titel für Werbefeld {$a->no}';
$string['tiletitlesetting_desc'] = 'Hier geben Sie den Titel ein, der im Werbefeld {$a->no} angezeigt wird. Dies ist eine optionale Einstellung und der Werbebereich wird auch dann angezeigt, wenn Sie keinen Titel festlegen.';
$string['timelineheading'] = 'Block "Zeitleiste"';
$string['timelinetintenabled'] = 'Aktivitätssymbole "Zeitleiste"';
$string['timelinetintenabled_desc'] = 'Mit dieser Einstellung können Sie die Aktivitätsymbole im Block "Zeitleiste" basierend auf den Aktivitätszwecken einfärben. Standardmäßig zeigt der Moodle Core schwarze Symbole an.';
$string['touchiconfilesios'] = 'Touch-Icon-Dateien für iOS Liste';
$string['touchiconfilesios_desc'] = 'Mit dieser Einstellung können Sie Dateien hochladen, die als Icon verwendet werden, sobald die Moodle-Website als Lesezeichen zum iOS-Homescreen hinzugefügt wird.';
$string['touchiconfilesios_example'] = 'Beispiel: apple-icon-152x152.png';
$string['touchiconfilesios_note'] = 'Empfohlene Dateien haben eine gute Größe, um auf aktuellen iOS-Geräten richtig angezeigt zu werden. Optionale Dateien werden (oder wurden früher) auch von iOS-Geräten unterstützt, sind aber jetzt nur noch optional, z.B. für ein bestimmtes älteres Gerät.';
$string['touchiconfilesios_optional'] = 'Optionale Dateien für iOS:';
$string['touchiconfilesios_recommended'] = 'Empfohlene Dateien für iOS:';
$string['touchiconfilesioslist'] = 'Touch-Icon-Dateien für iOS Liste';
$string['touchiconfilesioslist_desc'] = 'Dies ist die Liste der Dateien, die Sie in den Dateibereich "Touch-Icon-Dateien für iOS" hochgeladen haben.';
$string['touchiconlistiosoptionalmissing'] = 'Dies ist eine optionale Datei zur Verwendung als Touch-Icon auf iOS-Geräten und wurde nicht hochgeladen.';
$string['touchiconlistiosoptionaluploaded'] = 'Dies ist eine optionale Datei zur Verwendung als Touch-Icon auf iOS-Geräten und wurde hochgeladen.';
$string['touchiconlistiosrecommendedmissing'] = 'Dies ist eine empfohlene Datei zur Verwendung als Touch-Icon auf iOS-Geräten, aber sie wurde nicht ordnungsgemäß hochgeladen.';
$string['touchiconlistiosrecommendeduploaded'] = 'Dies ist eine empfohlene Datei zur Verwendung als Touch-Symbol auf iOS-Geräten und sie wurde hochgeladen.';
$string['upcomingeventsheading'] = 'Block "Kommende Termine"';
$string['upcomingeventstintenabled'] = 'Aktivitätssymbole "Kommende Termine"';
$string['upcomingeventstintenabled_desc'] = 'Mit dieser Einstellung können Sie die Aktivitätsymbole im Block "Kommende Termine" basierend auf den Aktivitätszwecken einfärben. Standardmäßig zeigt der Moodle Core schwarze Symbole an.';
$string['upgradenotice_2022080922'] = 'Ab dieser Version verwendet das Design "Boost Union" ein eigenes Logo und eigene Einstellungen für das kompakte Logo. Diese Dateien aus dem Moodle-Kern werden nicht mehr benutzt.';
$string['upgradenotice_2022080922_copied'] = 'Ein vorhandenes <strong>{$a}</strong> aus dem Moodle-Core wurde während des Upgrades in die Einstellung "{$a}" von Boost Union kopiert. Überprüfen Sie bitte das Ergebnis sorgfältig.';
$string['upgradenotice_2022080922_logo'] = 'Logo';
$string['upgradenotice_2022080922_logocompact'] = 'kompaktes Logo';
$string['upgradenotice_2022080922_notcopied'] = 'Die Einstellung <strong>{$a}</strong> in Boost Union ist jetzt leer. Wenn Sie von nun an ein {$a} innerhalb von Boost Union verwenden möchten, laden Sie es einfach später in die Einstellung {$a} von Boost Union hoch.';
$string['usermenuheading'] = 'Nutzermenü';
$string['warningslashargumentsdisabled'] = 'Achtung: Die <a href="{$a->url}">Slash-Parameter Einstellung</a> ist derzeit in Ihrer Moodle-Konfiguration deaktiviert, wird aber von Boost Union benötigt. Aktivieren Sie bitte die Slash-Parameter, ansonsten werden die folgenden Boost Union Einstellungen ignoriert.';
