<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'tool_pluginskel', language 'zh_cn', version '4.4'.
 *
 * @package     tool_pluginskel
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addmore_applicable_formats'] = '添加更多可用格式';
$string['addmore_archetypes'] = '添加更多原型';
$string['addmore_backup_elements'] = '添加更多备份项';
$string['addmore_capabilities'] = '添加更多功能';
$string['addmore_cli_scripts'] = '添加更多文件名';
$string['addmore_custom_layouts'] = '添加更多自定义布局';
$string['addmore_dependencies'] = '添加更多依赖项';
$string['addmore_events'] = '添加更多事件';
$string['addmore_lang_strings'] = '添加更多语言字符';
$string['addmore_message_providers'] = '添加更多消息提供程序';
$string['addmore_mobile_addons'] = '添加更多移动插件';
$string['addmore_observers'] = '添加更多观察者';
$string['addmore_params_for_js'] = '添加更多JS参数';
$string['addmore_parents'] = '添加更多父级';
$string['addmore_phpunit_tests'] = '添加更多测试类';
$string['addmore_restore_elements'] = '添加更多还原项';
$string['addmore_strings_for_js'] = '添加更多JS字符';
$string['addmore_stylesheets'] = '添加更多样式表';
$string['atto_features_params_for_js'] = 'JS 参数';
$string['atto_features_params_for_js_default'] = '默认';
$string['atto_features_params_for_js_default_help'] = '参数的默认值，在 JavaScript 源文件中定义。';
$string['atto_features_params_for_js_default_link'] = 'https://docs.moodle.org/dev/Atto#Atto_subplugin_Php_API';
$string['atto_features_params_for_js_name'] = '名称';
$string['atto_features_params_for_js_name_help'] = '参数名称。';
$string['atto_features_params_for_js_name_link'] = 'https://docs.moodle.org/dev/Atto#Atto_subplugin_Php_API';
$string['atto_features_params_for_js_value'] = '值';
$string['atto_features_params_for_js_value_help'] = '参数值。';
$string['atto_features_params_for_js_value_link'] = 'https://docs.moodle.org/dev/Atto#Atto_subplugin_Php_API';
$string['atto_features_strings_for_js'] = 'JS字符';
$string['atto_features_strings_for_js_id'] = 'ID';
$string['atto_features_strings_for_js_id_help'] = '字符ID';
$string['atto_features_strings_for_js_id_link'] = 'https://docs.moodle.org/dev/Atto#Atto_subplugin_Php_API';
$string['atto_features_strings_for_js_text'] = '文本';
$string['atto_features_strings_for_js_text_help'] = '字符ID的值';
$string['atto_features_strings_for_js_text_link'] = 'https://docs.moodle.org/dev/Atto#Atto_subplugin_Php_API';
$string['auth_features_can_be_manually_set'] = '允许手动设置';
$string['auth_features_can_be_manually_set_help'] = '如果可以为用户手动设置身份验证插件，则为true。';
$string['auth_features_can_be_manually_set_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_can_change_password'] = '允许修改密码';
$string['auth_features_can_change_password_help'] = '如果身份验证插件可以更改用户密码，则为true。';
$string['auth_features_can_change_password_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_can_confirm'] = '允许确认';
$string['auth_features_can_confirm_help'] = '如果验证插件允许确认新用户，则为true。';
$string['auth_features_can_confirm_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_can_edit_profile'] = '允许编辑配置';
$string['auth_features_can_edit_profile_help'] = '如果身份验证插件可以编辑用户的配置文件，则为true。';
$string['auth_features_can_edit_profile_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_can_reset_password'] = '允许重置密码';
$string['auth_features_can_reset_password_help'] = '如果插件允许重置内部密码，则为true。';
$string['auth_features_can_reset_password_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_can_signup'] = '允许注册';
$string['auth_features_can_signup_help'] = '如果验证插件允许注册和创建用户，则为true。';
$string['auth_features_can_signup_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_config_ui'] = '配置界面';
$string['auth_features_config_ui_help'] = '启用生成配置接口。web表单必须在auth.php的config_form()函数中定义。';
$string['auth_features_config_ui_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_description'] = '描述';
$string['auth_features_description_help'] = '验证插件的简短的一行描述。它表示语言字符串 "auth_description"的文本值。';
$string['auth_features_description_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_is_internal'] = '内部插件';
$string['auth_features_is_internal_help'] = '如果验证插件为“内部”，则为true。内部插件使用来自moodle用户表的密码哈希进行身份验证。';
$string['auth_features_is_internal_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_is_synchronised_with_external'] = '与外部同步';
$string['auth_features_is_synchronised_with_external_help'] = '如果moodle应使用来自外部源的数据自动更新内部用户记录，请使用
get_userinfo()方法。';
$string['auth_features_is_synchronised_with_external_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['auth_features_prevent_local_passwords'] = '本地存储密码';
$string['auth_features_prevent_local_passwords_help'] = '如果将密码存储在本地moodle数据库中，则为true。';
$string['auth_features_prevent_local_passwords_link'] = 'https://docs.moodle.org/dev/Authentication_plugins';
$string['back'] = '返回';
$string['block_features_applicable_formats'] = '适用格式';
$string['block_features_applicable_formats_allowed'] = '允许';
$string['block_features_applicable_formats_allowed_help'] = '如果页面上允许块插件，则为true。';
$string['block_features_applicable_formats_allowed_link'] = 'https://docs.moodle.org/dev/Blocks';
$string['block_features_applicable_formats_page'] = '页面';
$string['block_features_applicable_formats_page_help'] = '声明插件在哪个页面可用。';
$string['block_features_applicable_formats_page_link'] = 'https://docs.moodle.org/dev/Blocks';
$string['block_features_backup_moodle2'] = '备份 moodle2';
$string['block_features_backup_moodle2_backup_elements'] = '备份项';
$string['block_features_backup_moodle2_backup_elements_name'] = '备份项名称';
$string['block_features_backup_moodle2_backup_elements_name_help'] = '备份项的名称';
$string['block_features_backup_moodle2_backup_elements_name_link'] = 'https://docs.moodle.org/dev/Backup_API#API_for_blocks';
$string['block_features_backup_moodle2_backup_stepslib'] = '备份步骤';
$string['block_features_backup_moodle2_backup_stepslib_help'] = '创建备份步骤文件。';
$string['block_features_backup_moodle2_backup_stepslib_link'] = 'https://docs.moodle.org/dev/Backup_API#API_for_blocks';
$string['block_features_backup_moodle2_restore_elements'] = '恢复项';
$string['block_features_backup_moodle2_restore_elements_name'] = '恢复项名称';
$string['block_features_backup_moodle2_restore_elements_name_help'] = '恢复项的名称';
$string['block_features_backup_moodle2_restore_elements_name_link'] = 'https://docs.moodle.org/dev/Restore_2.0_for_developers';
$string['block_features_backup_moodle2_restore_elements_path'] = '恢复项路径';
$string['block_features_backup_moodle2_restore_elements_path_help'] = '恢复项的路径';
$string['block_features_backup_moodle2_restore_elements_path_link'] = 'https://docs.moodle.org/dev/Restore_2.0_for_developers';
$string['block_features_backup_moodle2_restore_stepslib'] = '恢复步骤结构';
$string['block_features_backup_moodle2_restore_stepslib_help'] = '创建一个步骤结构文件。';
$string['block_features_backup_moodle2_restore_stepslib_link'] = 'https://docs.moodle.org/dev/Restore_2.0_for_developers';
$string['block_features_backup_moodle2_restore_task'] = '恢复任务';
$string['block_features_backup_moodle2_restore_task_help'] = '创建还原任务文件。';
$string['block_features_backup_moodle2_restore_task_link'] = 'https://docs.moodle.org/dev/Restore_2.0_for_developers';
$string['block_features_backup_moodle2_settingslib'] = '设置库';
$string['block_features_backup_moodle2_settingslib_help'] = '创建备份设置库文件';
$string['block_features_backup_moodle2_settingslib_link'] = 'https://docs.moodle.org/dev/Backup_API#API_for_blocks';
$string['block_features_edit_form'] = '编辑表单';
$string['block_features_edit_form_help'] = '创建将用于实例配置的文件edit_form.php。';
$string['block_features_edit_form_link'] = 'https://docs.moodle.org/dev/Blocks';
$string['block_features_instance_allow_multiple'] = '允许多个实例';
$string['block_features_instance_allow_multiple_help'] = '在同一课程中允许多个块插件实例。';
$string['block_features_instance_allow_multiple_link'] = 'https://docs.moodle.org/dev/Blocks';
$string['capabilities'] = '功能';
$string['capabilities_archetypes'] = '原型';
$string['capabilities_archetypes_permission'] = '权限';
$string['capabilities_archetypes_permission_help'] = '与角色关联的权限。';
$string['capabilities_archetypes_permission_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['capabilities_archetypes_role'] = '角色';
$string['capabilities_archetypes_role_help'] = '标准原型。';
$string['capabilities_archetypes_role_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['capabilities_captype'] = '读写';
$string['capabilities_captype_help'] = '所有功能都是“读”或“写”，出于安全原因，所有来宾和未登录用户的写功能都被阻止。';
$string['capabilities_captype_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['capabilities_clonepermissionsfrom'] = '克隆权限';
$string['capabilities_clonepermissionsfrom_help'] = '从其他功能的当前设置中复制每个角色的权限。';
$string['capabilities_clonepermissionsfrom_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['capabilities_contextlevel'] = '上下文等级';
$string['capabilities_contextlevel_help'] = '检查功能的上下文级别。它是权限用户界面可以覆盖此功能的最低级别。';
$string['capabilities_contextlevel_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['capabilities_name'] = '名称';
$string['capabilities_name_help'] = '功能的名称。
将生成"componenttype/componentname:name"功能。';
$string['capabilities_name_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['capabilities_riskbitmask'] = '风险功能';
$string['capabilities_riskbitmask_help'] = '与功能相关的风险。可以使用“”分隔符指定多种风险类型。';
$string['capabilities_riskbitmask_link'] = 'https://docs.moodle.org/dev/Hardening_new_Roles_system';
$string['capabilities_title'] = '标题';
$string['capabilities_title_help'] = '对功能的简短描述。它表示语言字符串"componentname:name"的文本值。';
$string['capabilities_title_link'] = 'https://docs.moodle.org/dev/Access_API';
$string['cli_scripts'] = 'CLI 脚本';
$string['cli_scripts_filename'] = '文件名';
$string['cli_scripts_filename_help'] = 'CLI脚本文件的名称。所有文件都将在插件的“cli”目录中生成。';
$string['component'] = '插件标识';
$string['component_help'] = '完整的"frankenstyle"组件名称，为componenttype_component name。
如果要更改插件类型，请重新启动插件生成过程。';
$string['component_link'] = 'https://docs.moodle.org/dev/version.php';
$string['componenthdr'] = '插件';
$string['componentname'] = '插件名称';
$string['componentname_help'] = '插件的名称。这将成为插件根文件夹的名称。

名称必须以字母开头，最好只包含字母。允许使用数字和下划线，但不鼓励使用。活动模块的名称中不能有下划线。';
$string['componentnameinvalid'] = '无效的插件名称';
$string['componenttype'] = '插件类型';
$string['componenttype_help'] = '插件的类型。通过单击“更多帮助”按钮，可以在官方Moodle文档中找到有关不同插件类型的更多信息。';
$string['componenttype_link'] = 'https://docs.moodle.org/dev/Plugin_types';
$string['copyright'] = '版权信息';
$string['copyright_desc'] = '手动生成插件框架时版权字段的默认值。';
$string['copyright_help'] = '此字段应包含插件创建的年份、版权所有者的名称以及电子邮件地址。
作为标准Moodle样板文件的一部分，该插件的每个文件中都会出现版权标记。
有关标准Moodle样板文件的更多信息，请单击“更多帮助”按钮。';
$string['copyright_link'] = 'https://docs.moodle.org/dev/Coding_style#Files';
$string['delete_applicable_formats'] = '删除适用格式';
$string['delete_capabilities'] = '删除功能';
$string['delete_cli_scripts'] = '删除文件名';
$string['delete_custom_layouts'] = '删除自定义布局';
$string['delete_dependencies'] = '删除依赖';
$string['delete_events'] = '删除事件';
$string['delete_lang_strings'] = '删除语言字符';
$string['delete_message_providers'] = '删除消息提供者';
$string['delete_mobile_addons'] = '删除移动插件';
$string['delete_observers'] = '删除观察者';
$string['delete_params_for_js'] = '删除JS参数';
$string['delete_parents'] = '删除上级';
$string['delete_phpunit_tests'] = '删除测试类';
$string['delete_restore_elements'] = '恢复删除项';
$string['delete_strings_for_js'] = '删除JS字符';
$string['delete_stylesheets'] = '删除样式表';
$string['dependencies'] = '依赖关系';
$string['dependencies_plugin'] = '插件';
$string['dependencies_plugin_help'] = '插件依赖项的完整组件名称。';
$string['dependencies_version'] = '插件版本';
$string['dependencies_version_help'] = '插件依赖项的版本号。
值ANY_VERSION意味着插件的任何版本都将满足依赖项。';
$string['downloadrecipe'] = '下载构造脚本';
$string['downloadskel'] = '下载插件框架';
$string['emptypluginname'] = '没指定插件名称';
$string['emptyrecipecontent'] = '没有构造脚本';
$string['enrol_features_allow_enrol'] = '允许注册';
$string['enrol_features_allow_enrol_help'] = '通过调用函数enrol_user()，允许用户从其他插件注册。
必须定义相应的“登记[enrol]”功能。';
$string['enrol_features_allow_enrol_link'] = 'https://docs.moodle.org/dev/Enrolment_plugins';
$string['enrol_features_allow_manage'] = '允许管理';
$string['enrol_features_allow_manage_help'] = '允许其他插件手动修改用户注册。';
$string['enrol_features_allow_manage_link'] = 'https://docs.moodle.org/dev/Enrolment_plugins';
$string['enrol_features_allow_unenrol'] = '允许取消';
$string['enrol_features_allow_unenrol_help'] = '允许其他插件取消对所有人的注册。
必须定义相应的“取消登记[unenrol]”功能。';
$string['enrol_features_allow_unenrol_link'] = 'https://docs.moodle.org/dev/Enrolment_plugins';
$string['enrol_features_allow_unenrol_user'] = '允许注销用户';
$string['enrol_features_allow_unenrol_user_help'] = '允许其他插件注销指定用户。
必须定义相应的“取消登记”功能。';
$string['enrol_features_allow_unenrol_user_link'] = 'https://docs.moodle.org/dev/Enrolment_plugins';
$string['events'] = '事件';
$string['events_eventname'] = '事件名称';
$string['events_eventname_help'] = '事件的名称。';
$string['events_eventname_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['events_extends'] = '扩展';
$string['events_extends_help'] = '扩展事件的名称。';
$string['events_extends_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['features_install'] = '添加安装文件';
$string['features_install_help'] = '生成 db/install.php';
$string['features_license'] = '添加许可文件';
$string['features_license_help'] = '生成 LICENSE.md';
$string['features_readme'] = '添加自述文件';
$string['features_readme_help'] = '生成 README.md';
$string['features_settings'] = '添加配置文件';
$string['features_settings_help'] = '生成 settings.php';
$string['features_uninstall'] = '添加卸载文件';
$string['features_uninstall_help'] = '生成  db/uninstall.php.';
$string['features_upgrade'] = '添加升级文件';
$string['features_upgrade_help'] = '生成  db/upgrade.php';
$string['features_upgrade_link'] = 'https://docs.moodle.org/dev/Upgrade_API';
$string['features_upgradelib'] = '添加升级包';
$string['features_upgradelib_help'] = '生成  db/upgradelib.php';
$string['features_upgradelib_link'] = 'https://docs.moodle.org/dev/Upgrade_API';
$string['generalhdr'] = '基础';
$string['generateskel'] = '生成插件框架';
$string['lang_strings'] = '语言字符';
$string['lang_strings_id'] = 'ID';
$string['lang_strings_id_help'] = '语言字符的ID。';
$string['lang_strings_id_link'] = 'https://docs.moodle.org/dev/String_API';
$string['lang_strings_text'] = '文本';
$string['lang_strings_text_help'] = '语言字符的值。';
$string['lang_strings_text_link'] = 'https://docs.moodle.org/dev/String_API';
$string['manualhdr'] = '手动生成插件';
$string['maturity'] = '完成度';
$string['maturity_help'] = '插件完成度';
$string['maturity_link'] = 'https://docs.moodle.org/dev/version.php';
$string['message_providers'] = '消息提供者';
$string['message_providers_capability'] = '所需功能';
$string['message_providers_capability_help'] = '用户接收提供程序生成的消息所需的功能。';
$string['message_providers_capability_link'] = 'https://docs.moodle.org/dev/Messaging_2.0';
$string['message_providers_name'] = '名称';
$string['message_providers_name_help'] = '消息提供程序的名称。消息提供程序在文件db/messages.php中定义。';
$string['message_providers_name_link'] = 'https://docs.moodle.org/dev/Messaging_2.0';
$string['message_providers_title'] = '标题';
$string['message_providers_title_help'] = '消息提供程序的简短的一行描述。
它表示语言字符串“messageprovider:name”的文本值。';
$string['message_providers_title_link'] = 'https://docs.moodle.org/dev/Messaging_2.0';
$string['mobile_addons'] = '移动插件';
$string['mobile_addons_dependencies'] = '依赖关系';
$string['mobile_addons_dependencies_name'] = '名称';
$string['mobile_addons_dependencies_name_help'] = '依赖项的名称。';
$string['mobile_addons_dependencies_name_link'] = 'https://docs.moodle.org/dev/Moodle_Mobile_Remote_add-ons';
$string['mobile_addons_name'] = '名称';
$string['mobile_addons_name_help'] = '当用户访问移动应用程序上的插件时将加载的移动远程插件的名称。';
$string['mobile_addons_name_link'] = 'https://docs.moodle.org/dev/Moodle_Mobile_Remote_add-ons';
$string['mod_features_backup_moodle2'] = '备份moodle2';
$string['mod_features_backup_moodle2_backup_elements'] = '备份项';
$string['mod_features_backup_moodle2_backup_elements_name'] = '备份项名称';
$string['mod_features_backup_moodle2_backup_elements_name_help'] = '备份项的名称';
$string['mod_features_backup_moodle2_backup_elements_name_link'] = 'https://docs.moodle.org/dev/Backup_2.0_for_developers';
$string['mod_features_backup_moodle2_restore_elements'] = '恢复项';
$string['mod_features_backup_moodle2_restore_elements_name'] = '恢复项名称';
$string['mod_features_backup_moodle2_restore_elements_name_help'] = '恢复项的名称';
$string['mod_features_backup_moodle2_restore_elements_name_link'] = 'https://docs.moodle.org/dev/Restore_2.0_for_developers';
$string['mod_features_backup_moodle2_restore_elements_path'] = '恢复项路径';
$string['mod_features_backup_moodle2_restore_elements_path_help'] = '恢复项的路径';
$string['mod_features_backup_moodle2_restore_elements_path_link'] = 'https://docs.moodle.org/dev/Restore_2.0_for_developers';
$string['mod_features_backup_moodle2_settingslib'] = '设置库';
$string['mod_features_backup_moodle2_settingslib_help'] = '创建一个备份设置库';
$string['mod_features_backup_moodle2_settingslib_link'] = 'https://docs.moodle.org/dev/Backup_2.0_for_developers';
$string['mod_features_file_area'] = '文件区域';
$string['mod_features_file_area_help'] = '生成与API相关的文件函数。';
$string['mod_features_file_area_link'] = 'https://docs.moodle.org/dev/Activity_modules';
$string['mod_features_gradebook'] = '成绩单';
$string['mod_features_gradebook_help'] = '如果插件需要成绩册，则为true。';
$string['mod_features_gradebook_link'] = 'https://docs.moodle.org/dev/Activity_modules';
$string['mod_features_navigation'] = '导航';
$string['mod_features_navigation_help'] = '在lib.php中创建函数extend_navigation()和extend_settings_navigation()';
$string['mod_features_navigation_link'] = 'https://docs.moodle.org/dev/Activity_modules';
$string['name'] = '插件名称';
$string['name_help'] = '插件的可读名称。这表示语言字符串“pluginname”的文本值。';
$string['observers'] = '观察者';
$string['observers_callback'] = '回调';
$string['observers_callback_help'] = '回调方法名称';
$string['observers_callback_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['observers_eventname'] = '事件名称';
$string['observers_eventname_help'] = '完全限定的事件类名称。';
$string['observers_eventname_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['observers_includefile'] = '包含文件';
$string['observers_includefile_help'] = '在调用观察者之前要包含的文件。文件的路径应该相对于moodle根目录。';
$string['observers_includefile_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['observers_internal'] = '内部';
$string['observers_internal_help'] = '在数据库事务期间不调用非内部观察器，而是在成功提交事务之后调用。';
$string['observers_internal_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['observers_priority'] = '优先级';
$string['observers_priority_help'] = '观察者的优先权。如果未指定，则默认为0。';
$string['observers_priority_link'] = 'https://docs.moodle.org/dev/Event_2';
$string['phpunit_tests'] = 'PHPUnit测试';
$string['phpunit_tests_classname'] = '类名';
$string['phpunit_tests_classname_help'] = '测试类名。它可以是完整的 frankenstyle 名称，也可以是测试类的名称。所有phpunit测试文件将在“tests”目录中生成。';
$string['phpunit_tests_classname_link'] = 'https://docs.moodle.org/dev/PHPUnit';
$string['pluginname'] = '生成插件框架';
$string['privacy:metadata'] = '生成器不存储任何个人数据';
$string['proceedmanually'] = '手动生成';
$string['proceedrecipe'] = '使用脚本生成';
$string['proceedrecipefile'] = '使用脚本文件生成';
$string['qtype_features_base_class'] = '基础类';
$string['qtype_features_base_class_help'] = '位于question.php中的question类的基类。';
$string['qtype_features_base_class_link'] = 'https://docs.moodle.org/dev/Question_types';
$string['recipe'] = '脚本';
$string['recipe_help'] = '脚本应使用yaml序列化格式编写。配方模板位于cli/example.yaml的plugin安装目录中。

有关yaml语法的更多信息可以通过单击“更多帮助”按钮找到，该按钮将带您进入正式的yaml网页。';
$string['recipe_link'] = 'http://yaml.org/';
$string['recipefile'] = '脚本文件';
$string['recipefile_help'] = '脚本应使用yaml序列化格式编写。配方模板位于cli/example.yaml的plugin安装目录中。

有关yaml语法的更多信息可以通过单击“更多帮助”按钮找到，该按钮将带您进入正式的yaml网页。';
$string['recipefile_link'] = 'http://yaml.org/';
$string['recipefilehdr'] = '使用脚本文件生成插件';
$string['recipehdr'] = '脚本生成插件';
$string['release'] = '发布版本';
$string['release_help'] = '可读的版本名，应该有助于识别插件的每个版本。';
$string['release_link'] = 'https://docs.moodle.org/dev/version.php';
$string['requires'] = '系统版本';
$string['requires_help'] = '插件安装和正常运行所需的最低moodle版本。';
$string['showrecipe'] = '显示脚本';
$string['showrecipehdr'] = '脚本';
$string['theme_features_all_layouts'] = '所有布局';
$string['theme_features_all_layouts_help'] = '将主题应用于所有布局。';
$string['theme_features_all_layouts_link'] = 'https://docs.moodle.org/dev/Themes';
$string['theme_features_custom_layouts'] = '自定义布局';
$string['theme_features_custom_layouts_name'] = '自定义布局名称';
$string['theme_features_custom_layouts_name_help'] = '插件将创建的自定义布局的名称。布局将位于“layouts”目录中。';
$string['theme_features_custom_layouts_name_link'] = 'https://docs.moodle.org/dev/Themes';
$string['theme_features_doctype'] = '文档类型';
$string['theme_features_doctype_help'] = '网页的文档类型。通常是“HTML5”。';
$string['theme_features_doctype_link'] = 'https://docs.moodle.org/dev/Themes';
$string['theme_features_parents'] = '父主题';
$string['theme_features_parents_base_theme'] = '基本主题';
$string['theme_features_parents_base_theme_help'] = '此主题将扩展的基本主题。';
$string['theme_features_parents_base_theme_link'] = 'https://docs.moodle.org/dev/Themes';
$string['theme_features_stylesheets'] = '样式表';
$string['theme_features_stylesheets_name'] = '样式表名称';
$string['theme_features_stylesheets_name_help'] = '插件定义的样式表的名称。样式表将在"styles"目录中创建。';
$string['theme_features_stylesheets_name_link'] = 'https://docs.moodle.org/dev/Themes';
$string['undefined'] = '未定义';
$string['upgradelib'] = '升级包';
$string['upgradelib_help'] = '创建文件db/upgradelib.php，在该文件中，可以将升级代码分组到upgrade.php文件中要使用的一些助手函数下。';
$string['upgradelib_link'] = 'https://docs.moodle.org/dev/Upgrade_API';
$string['version'] = '插件版本';
$string['version_help'] = '插件的版本号。格式部分基于日期，格式为YYYYMMDDXX，其中XX是插件版本发布的给定年份（YYYY）、月份（mm）和日期（dd）的增量。';
$string['version_link'] = 'https://docs.moodle.org/dev/version.php';
