<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodleorg', language 'ar', version '4.4'.
 *
 * @package     local_moodleorg
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutstatistics'] = 'يمكنك تحميل مودل مجاناً والتسجيل اختياري، لذا لا نملك معلومات كاملة عن كل من يستخدمه، لكننا نقوم بتوليد رسوم بيانية وأرقام مثيرة بالاعتماد على ما نملك من معلومات في صفحة الإحصاءات.';
$string['aboutstatisticsheading'] = 'إحصائيات مودل';
$string['aboutstatisticstitle'] = 'Moodle.org: إحصائيات مودل';
$string['activeusers24hours'] = 'المستخدمون المسجلون المتواجدون خلال 24 ساعة الماضية:';
$string['activeuserspastmonth'] = 'المستخدمون المتواجدون خلال الشهر الماضي:';
$string['browsegittitle'] = 'استعرض النص البرمجي المصدري الخاص بنا';
$string['cachedef_frontpagecolumn'] = 'أعمدة صفحة الواجهة';
$string['cachedef_usefulposts'] = 'منشورات نافعة';
$string['communities'] = 'المجتمعات';
$string['communitiesmy'] = 'مجتمعاتي';
$string['community'] = 'المجتمع';
$string['communityadministration'] = 'إدارة المجتمع';
$string['communitycurrent'] = 'المجتمع الحالي';
$string['communityenrolme'] = 'كن عضوًا في هذا المجتمع';
$string['communityenrolmentoptions'] = 'الانضمام إلى المجتمع';
$string['communityintro'] = 'يتمتع مودل بمجتمع مستخدمين متنوع فيه أكثر من <a href="https://moodle.org/userpics">{$a->usercount} مستخدم مسجل</a> في هذا الموقع لوحده، يتكلمون أكثر من <a href="https://download.moodle.org/langpack/">{$a->langcount} لغة</a> في <a href="https://moodle.org/sites">{$a->countrycount} بلداً</a> (لدينا <a href="https://moodle.org/stats"> المزيد من الإحصاءات</a>).';
$string['communityjoinbyyourself'] = 'الانضمام بنفسك';
$string['communityjoinbyyourselfas'] = 'الانضمام بنفسك بصفة {$a->rolename}';
$string['communitynoguestaccess'] = 'لا يمكن للضيوف الوصول إلى منطقة المجتمع هذه. رجاءً حاول تسجيل الدخول.';
$string['communitynotenrollable'] = 'لا يمكنك أن تصير عضوًا في هذا المجتمع بنفسك. يرجى التواصل مع منتدب المجتمع.';
$string['communitysomeallowguest'] = 'بعض المجتمعات قد تسمح بوصول الضيوف';
$string['communityunenrolme'] = 'أترك المجتمع {$a}';
$string['conferencecenter'] = 'مركز مؤتمرات مودل';
$string['connectedsites'] = 'تم وصل بعض مواقع مودل بـ moodle.org عن طريق تشبيك مودل، لذا يمكنك تسجيل الدخول هناك مباشرة عندما تكون مسجلاً دخول هنا.';
$string['donations10over'] = 'التبرعات الأخرى بقيمة $10 أو أعلى';
$string['donationsassociation'] = 'إنضم إلى <a href="https://moodleassociation.org/">رابطة مودل</a> - ساعد في تقرير كيفية صرف رسوم مودل على عناصر خارطة طريق مودل';
$string['donationsdevelopment'] = 'مع ذلك، فإن تطوير مودل وإدامة كل مواقعنا المجتمعية يكلفنا أموالاً كبيرة، ويمكننا دائماً الاستعانة بدعم إضافي. إذا كنت تحب مودل أو تجده مفيداً لأعمالك، مدرستك، أو مؤسستك، تلطف بتقديم أي هبة من أجله. كل قليل هو عون لنا.';
$string['donationsdonatenow'] = 'تبرع الآن';
$string['donationsensure'] = 'التبرعات تضمن استمرارية عجلة العمل في محرك مودل (مطورينا) لإنشاء ميزات جديدة وإصلاح المشاكل، مما يجعل مودل أفضل لنا جميعًا.';
$string['donationsmoodle'] = 'التبرع لمودل';
$string['donationsopensource'] = 'إن مودل هو برنامج مفتوح المصدر حقًا ومجاني بالكامل وبدون أي إلتزامات مالية لمستخدمينا - هكذا ينبغي أن تكون البرامج!';
$string['donationsover1000'] = 'التبرعات السابقة الأعلى من $1000';
$string['donationsover200'] = 'التبرعات الأخرى الأعلى من $200';
$string['donationsover500'] = 'التبرعات الأخرى الأعلى من $500';
$string['donationspartner'] = 'استعمل <a href="https://moodle.com/partners/">شريك مودل المخول</a> للحصول على خدمات -10% من عائداته مساهم بها في مشروع مودل.';
$string['donationsshop'] = 'إشترِ شيئًا من <a href="http://www.zazzle.com/moodle_hq/">مخزن مودل</a> واستعمله بفخر!';
$string['donationsthankeveryone'] = 'شكرًا لكل من ساهم في مشروع مودل.';
$string['donationsthankyou'] = 'شكرًا لك';
$string['donationstitle'] = 'التبرعات';
$string['donationsways'] = 'طرق أخرى للمساهمة المالية في مودل:';
$string['download_activities'] = 'النشاطات';
$string['download_admintools'] = 'أدوات المشرف';
$string['download_appdocumentation'] = 'توثيقات التطبيق';
$string['download_appreleasenotes'] = 'ملاحظات الإطلاق';
$string['download_browseall'] = 'استعراض الكل';
$string['download_downloadosx'] = 'تنزيل مودل لنظام OS X (يحتوي على Apache، MySQL و PHP لتشغيله في بيئة Mac OS)';
$string['download_downloadwindows'] = 'تنزيل مودل لوندوز (يحتوي على مودل، Apache، MySQL و PHP لتشغيله في بيئة وندوز)';
$string['download_forandroid'] = 'لأندرويد';
$string['download_forios'] = 'لـ iOS';
$string['download_helpbox_description'] = 'إقرأ التوثيقات للبدء وقم بزيارة منتديات مجتمعنا، أو ببساطة، تواصل مع أحد شركاء مودل للحصول على خدمات الاستضافة، التنصيب وغيرهما من الخدمات.';
$string['download_helpbox_installing'] = 'تنصيب مودل';
$string['download_helpbox_partners'] = 'شركاء مودل';
$string['download_helpbox_support'] = 'منتديات الدعم';
$string['download_helpbox_title'] = 'أتحتاج إلى مساعدة؟';
$string['download_helpbox_upgrading'] = 'ترقية مودل';
$string['download_hero_description'] = 'إنه يخضع <a class="link" href="http://docs.moodle.org/dev/License">لرخصة GPL</a>، التي تعني بأن أي أحد مرخص له باستعمال برنامجنا والتمتع بخدماته.<br><br>خذ نظرة على الإصدار الأخير من مودل.';
$string['download_hero_headline'] = 'مودل هو برنامج مفتوح المصدر.';
$string['download_langpackinfo'] = 'يتم توليد حزم اللغات تلقائيًا من أعمال المترجمين التي تجري في <a href="http://lang.moodle.org/">موقع الترجمة</a>. لمزيد من التفاصيل، أنظر <a href="https://docs.moodle.org/dev/Translation">توثيقات الترجمة</a>.';
$string['download_langpackinstallinfo'] = 'يمكن تنصيب المزيد من حزم اللغات في موقع مودل العائد لك عبر <em>الإدارة > إدارة الموقع > اللغة > حزم اللغات</em>، أو يدويًا. لمزيد من التفاصيل، أنظر <a href="https://docs.moodle.org/en/Language_packs">توثيقات حزم اللغات</a>.';
$string['download_langpackinstalltitle'] = 'تنصيب حزمة اللغة';
$string['download_langpacktitle'] = 'حزم اللغات لمودل {$a}';
$string['download_mobileapp'] = 'تطبيق الجوال';
$string['download_themes'] = 'القوالب';
$string['download_viewallbuilds'] = 'معاينة كل البنى (يتطلب مخدم ويب، PHP وقاعدة بيانات ليعمل)';
$string['downloadcore'] = 'طريقتنا الأساسية في توزيع مودل هي عن طريق هذه الحزم الأساسية القياسية. وهي تتضمن عدداً من الوحدات التي يتم صيانتها من قبل المطورين الأساسيين، وهي ملائمة للتنصيب على أي منصة تقريباً فيها PHP وقاعدة بيانات منصبة مسبقًا.';
$string['downloadcoretitle'] = 'حزم مودل القياسية';
$string['downloadintro'] = 'مودل هو برنامج مفتوح المصدر تحت <a href="https://docs.moodle.org/dev/License">GPL رخصة</a>. كل ما ننتجه متوافر لك لتحمله وتستعمله بحرية.';
$string['downloadlang'] = 'في الإصدارات الحالية من مودل، إضافة الدعم للغات الجديدت صارت مؤتمتة عبر قائمة الإدارة ضمن موقعك. مع ذلك، لبعض إصدارات مودل القديمة، لا تزال هناك حاجة لتنزيل حزم اللغات الجديدة يدويًا.';
$string['downloadlangtitle'] = 'حزم اللغات';
$string['downloadmac'] = 'إن لم يكن لديك مخدم ويب مهيأ مسبقًا، فهذه الحزم الشاملة تجعل عملية تنصيب مودل في غاية السهولة عند أي حاسبة من نوع Apple تعمل بنظام التشغيل Mac OS X.';
$string['downloadmactitle'] = 'مودل لنظام ماك (Mac OS X)';
$string['downloadmodules'] = 'استعرض قاعدة بياناتنا الشاملة التي تضم المزيد من الوحدات والملاحق التي بالإمكان إضافتها إلى موقعك الذي يستضيف مودل لتعطيه المزيد من الوظائف التي تفوق ما تقدمه الحزم الأساسية.';
$string['downloadmodulestitle'] = 'الملاحق';
$string['downloadthemes'] = 'يمكن تغيير هيئة موقع مودل بشكل كبير عند استعمال مظهر مختلف. نحن نحتفظ بقاعدة بيانات لمظاهر مودل التي أنشأها مستخدموه وشاركوها معنا.';
$string['downloadthemestitle'] = 'القوالب';
$string['downloadviagitcvs'] = 'الطرق الأخرى للحصول على مودل تشمل <a href="http://docs.moodle.org/en/Git_for_Administrators">التنزيل عبر Git</a> or <a href="http://docs.moodle.org/22/en/CVS_for_Administrators">التنزيل عبر CVS</a>.';
$string['downloadwin'] = 'إذا لم يكن لديك مخدم ويب مهيأ مسبقًا، فحزم الكل في واحد هذه تُسهل تنصيب مودل في أي حاسبة تعمل بنظام التشغيل مايكروسوفت وندوز.';
$string['downloadwintitle'] = 'مودل لويندوز';
$string['erroradminonly'] = 'المشرفون وحدهم يمكنهم الوصول إلى هذه العيِّنة.';
$string['erroralreadyvoted'] = 'لقد صوتَّ مسبقاً لـ {$a}';
$string['errormaxmessages'] = 'عذراً، لا يمكنك إرسال أكثر من 3 رسائل.';
$string['errornomainnews'] = 'تعذر العثور على منتدى الأخبار الرئيسي للموقع أو تعذر إنشاؤه';
$string['errorsendingmail'] = 'وقع خطأ ما عند إرسال الرسالة. ترجى المحاولة لاحقًا، أو تواصل مع مشرف الموقع.';
$string['eventdonation_created'] = 'قائمة هبات تم إنشاؤها';
$string['eventdonation_submitted'] = 'هبة تم تقديمها';
$string['events'] = 'بالرغم من أننا متخصصون في التعليم عبر الإنترنت، من اللطيف أيضاً أن نجتمع في غرفة! أنظر هذه الروابط لمزيد من المعلومات عن مؤتمراتنا (والتي ندعوها مودل موتس MoodleMoots) وغيرها من الأحداث.';
$string['eventstitle'] = 'الأحداث';
$string['feed_events'] = 'الأحداث';
$string['feed_events_more'] = 'المزيد من إدخالات التقويم';
$string['feed_news'] = 'الإعلانات';
$string['feed_news_more'] = 'مشاهدة كل الإعلانات';
$string['feed_resources'] = 'الموارد';
$string['feed_useful'] = 'المنشورات النافعة';
$string['feed_useful_more'] = 'المزيد من المنشورات';
$string['focusbox_community'] = 'منتديات الدعم والمنتديات المجتمعية';
$string['focusbox_community_text'] = 'إحصل على الدعم وشاركنا أفكارك بلغتك الخاصة.';
$string['focusbox_community_viewall'] = 'كل المجتمعات';
$string['focusbox_future'] = 'ساعد في رسم مستقبل مودل';
$string['focusbox_future_crowdfund'] = 'مشاريع التمويل الجماعي';
$string['focusbox_future_gdf'] = 'مناقشات المطورين';
$string['focusbox_future_research'] = 'بحوث مودل';
$string['focusbox_future_roadmap'] = 'خارطة الطريق';
$string['focusbox_future_text'] = 'إكتشف ما سيأتي وساهم في إحداث الفرق.';
$string['focusbox_future_ux'] = 'مناقشات تجارب المستخدمين';
$string['focusbox_settingup'] = 'التحضيرات';
$string['focusbox_settingup_community'] = 'دعم المجتمع';
$string['focusbox_settingup_download'] = 'التنزيل المجاني';
$string['focusbox_settingup_hosting'] = 'الاستضافة';
$string['focusbox_settingup_install'] = 'التنصيب';
$string['focusbox_settingup_own'] = 'على عاتقنا';
$string['focusbox_settingup_partner'] = 'عبر أحد شركاء مودل';
$string['focusbox_settingup_plugins'] = 'الملاحق';
$string['focusbox_settingup_support'] = 'الدعم التجاري';
$string['focusbox_teaching'] = 'التعليم بمودل';
$string['focusbox_teaching_books'] = 'الكتب';
$string['focusbox_teaching_courses'] = 'المقررات ومحتوياتها';
$string['focusbox_teaching_docs'] = 'التوثيقات';
$string['focusbox_teaching_text'] = 'استكشف الميزات الواسعة لمودل وموارده المتاحة.';
$string['focusbox_theproject'] = 'مشروع مودل';
$string['focusbox_theproject_about'] = 'عن مودل';
$string['focusbox_theproject_devs'] = 'المطورون';
$string['focusbox_theproject_hq'] = 'مقر مودل';
$string['focusbox_theproject_mua'] = 'رابطة مستخدمي مودل';
$string['focusbox_theproject_partners'] = 'شركاء مودل';
$string['focusbox_theproject_stats'] = 'الإحصائيات';
$string['focusbox_theproject_text'] = 'تعرف على المزيد عن مشروع مودل وشراكاتنا المفتوحة المتعاونة.';
$string['focusbox_uptodate'] = 'إبق بأحدث حال';
$string['focusbox_uptodate_news'] = 'الإعلانات';
$string['focusbox_uptodate_planet'] = 'كوكب مودل';
$string['focusbox_uptodate_security'] = 'إعلانات الأمان';
$string['focusbox_uptodate_social'] = 'وسائل التواصل الاجتماعي';
$string['focusbox_uptodate_text'] = 'آخر أخبار مودل، تحديثاته ورؤاه عبر العالم.';
$string['generaldeveloperforum'] = 'منتدى المطورين العام';
$string['graphpopulation'] = 'مخطط جمهور مودل';
$string['graphregistrationmap'] = 'خريطة مسجلي مودل';
$string['graphregistrationmapdesc'] = 'أفضل 10 من المواقع المسجلة في {$a} بلد';
$string['graphusersites'] = 'مقارنة مستخدمي مودل حسب الموقع';
$string['heroslide_community_description'] = 'مرحبًا بك في مجتمع مودل. استكشف قيمة الجهد التعاوني المفتوح عند واحد من أكبر فرق البرامج مفتوحة المصدر في العالم.';
$string['heroslide_community_headline'] = 'مدفوع مجتمعيًا، مدعوم عالميًا.';
$string['heroslide_community_slidecontrol'] = 'مدعوم من قبل مجتمع عالمي';
$string['heroslide_donate_headline'] = 'ساعدنا في إحداث الفرق مع تعليم مفتوح عالي المستوى للجميع';
$string['heroslide_getstarted40_description'] = 'نظام إدارة المحتوى مودل صار بحلة جديدة مع تجربة مستخدم مصاغة بشكل أفضل لتحسين التعليم والتَّعلُّم عبر الإنترنت لكل من المعلمين، المتعلمين والمشرفين.';
$string['heroslide_getstarted40_headline'] = 'مودل 4.0  - شكل جديد، تجربة مستخدم أفضل!';
$string['heroslide_getstarted40_slidecontrol'] = 'هنا مودل 4.0!';
$string['heroslide_getstarted_description'] = 'مودل هو نظام إدارة التعلم الأكثر شعبية في العالم. ابدأ في إنشاء موقعك للتعلم عبر الإنترنت في دقائق !';
$string['heroslide_getstarted_headline'] = 'ابدأ بسهولة';
$string['heroslide_getstarted_slidecontrol'] = 'إبدأ اليوم';
$string['heroslide_global_description'] = 'متاح بأكثر من 100 لغة، مودل حاز على ثقة المنظمات والمؤسسات، صغيرها وكبيرها ذات الملايين من المستخدمين في كل أنحاء العالم.';
$string['heroslide_global_headline'] = 'دعم بيئات التعلم في كل أنحاء العالم';
$string['heroslide_global_slidecontrol'] = 'دعم بيئات التعلم في كل أنحاء العالم';
$string['heroslide_link_demo'] = 'تجريبي';
$string['heroslide_link_donate'] = 'تبرع';
$string['heroslide_link_features'] = 'المزايا';
$string['heroslide_link_forums'] = 'المنتديات المجتمعية';
$string['heroslide_link_getstarted'] = 'إبدأ اليوم';
$string['heroslide_link_getstarted40'] = 'تعرَّف على مودل 4.0';
$string['heroslide_link_sites'] = 'المواقع المسجلة';
$string['heroslide_link_stats'] = 'الإحصائيات';
$string['heroslide_link_stories'] = 'قراءة المزيد';
$string['heroslide_power40_description'] = 'سهل، سريع وبديهي! استكشف تجربة المستخدم المحسنة والمزايا الجديدة للإصدار 4.0 من مودل.';
$string['heroslide_power40_headline'] = 'جرب مودل 4.0';
$string['heroslide_power40_slidecontrol'] = 'جرب مودل 4.0';
$string['heroslide_power_description'] = 'منصة التعليم العالمية المجانية التي تساعدك في بناء تجربة تعليم فعالة عبر الإنترنت في بيئة تفاعلية خاصة.';
$string['heroslide_power_headline'] = 'قوي. آمن. مفتوح المصدر.';
$string['heroslide_power_slidecontrol'] = 'منصة تعليم متينة، مفتوحة المصدر';
$string['heroslide_story1_description'] = '“الريادة في التعليم المستند إلى التقنية تمكننا من تسهيل إكتشاف الطلاب إبداعيًا بحيث لا تفوتنا أي فرص معهم.” - البروفيسور داريل إيفانز، نائب المستشار الأسبق (التعلم والتعليم)، جامعة موناش';
$string['heroslide_story1_headline'] = 'تُطور التعليم والتعلم في كل مكان';
$string['heroslide_story2_headline'] = 'تُحقق تعليم مؤسساتي متميز';
$string['heroslide_story3_description'] = 'كلية الوادي الرابع هي واحدة من أكبر الكليات في اسكتلندا، والتي تقدم أكثر من 750 مساق لما يزيد على 20,000 مستخدم فعال في مواقعها.';
$string['heroslide_story3_headline'] = 'تعطي تعليمًا مرنًا من كل النواحي';
$string['heroslide_story4_description'] = 'الخدمات الطوعية ما وراء البحار (VSO) يعطي تعليمًا تفاعليًا مع الدعم للمتطوعين عالميًا لتمكين مقاربات التدريب في أنحاء العالم.';
$string['heroslide_story4_headline'] = 'تساعد المتطوعين في إعطاء برامج محاربة الفقر';
$string['heroslide_story5_description'] = '';
$string['heroslide_story5_headline'] = '';
$string['heroslide_story_slidecontrol'] = 'قصص مودل من أنحاء العالم';
$string['jobs'] = 'لمزيد من المعلومات حول وظائف لها علاقة بمودل حول العالم، قم بزيارة قاعدة بياناتنا للوظائف.';
$string['logoinfo'] = 'يعد اسم مودل™ علامة تجارية مسجلة لمؤسسة Moodle Trust.

إذا كنت تنوي استعمال الاسم و/أو الشعار للإعلان عن خدمات مودل العامة (مثل استضافة مودل، دعم مودل، شهادة مودل، تدريب مودل، استشارات مودل، تخصيص مودل، تطوير مناهج مودل، تصميم مظاهر مودل، تكاملات مودل، تنصيبات مودل، وما إلى ذلك) أو كاسم لحزمة برامج، فيجب عليك طلب إذن كتابي مباشر والحصول عليه من مؤسسة Moodle Trust عبر [مكتب المساعدة moodle.com](http://moodle.com/helpdesk/)، بالتوافق مع قيود العلامات التجارية العادية.

لا توجد قيود على كيفية استعمال الاسم في سياقات أخرى (على سبيل المثال، إذا كنت تستعمل مودل فقط لتقديم الدورات التدريبية أو المساقات، فيمكنك استعمال الاسم بحرية للإشارة إليه). إذا لم تكن متأكدًا من حالة معينة، فيرجى سؤالنا عبر [مكتب المساعدة moodle.com](http://moodle.com/helpdesk/). سيكون من دواعي سرورنا أن نقدم لك إذنًا رسميًا كتابيًا أو نساعدك في تصحيح صياغتك.';
$string['logotitle'] = 'شعار مودل';
$string['manageads'] = 'إدارة إعلانات الشركاء';
$string['managedonations'] = 'إدارة التبرعات';
$string['moodleorg:manageads'] = 'إدارة إعلانات الشركاء';
$string['moodleorg:managedonations'] = 'إدارة تسجيل التبرعات';
$string['moodlepartner_corporate'] = 'التدريب المؤسسي';
$string['moodlepartner_other'] = 'القطاعات الأخرى';
$string['moodlepartner_school'] = 'المدرسة';
$string['moodlepartner_university'] = 'الجامعة';
$string['networkinfo'] = 'إن مواقع مودل الآتية قد ارتبطت مع moodle.org باستعمال شبكة مودل، لذلك يمكنك تسجيل دخولك إليها مباشرة من هنا.';
$string['networktitle'] = 'المواقع المتصلة';
$string['newregistrations'] = 'تسجيلات جديدة';
$string['newstitle'] = 'الإعلانات';
$string['noenrolledcoursesyet'] = 'لست مسجلاً بأي مساق في هذا الموقع حتى الآن';
$string['partnerslogan'] = 'إن مشروع مودل مدعوم من قبل ما يزيد عن 90 <a href="https://moodle.com/partners/">شريك مودل</a> عالميًا.';
$string['permalink'] = 'الرابط الدائم';
$string['pluginname'] = 'موقع Moodle.org';
$string['popularissues'] = 'أكثر القضايا شعبية';
$string['privacy:metadata:db:registerdonations'] = 'يحتفظ بسجلات تبرعات مودل';
$string['privacy:metadata:db:registerdonations:amount'] = 'مبلغ التبرع';
$string['privacy:metadata:db:registerdonations:name'] = 'اسم المتبرع';
$string['privacy:metadata:db:registerdonations:org'] = 'منظمة المتبرع';
$string['privacy:metadata:db:registerdonations:timedonated'] = 'البصمة الزمنية للتبرع';
$string['privacy:metadata:db:registerdonations:url'] = 'رابط المتبرع';
$string['recentlyratedposts'] = 'المنشورات المقيَّمة مؤخرًا';
$string['recentpart'] = 'هذه الصفحة تعرض بعض الناس الذين استخدموا moodle.org اليوم.';
$string['registeredsites'] = 'ليس مطلوباً من المؤسسات إبلاغ أي شخص عند استخدامهم لمودل، لأن مودل مفتوح المصدر. ومع ذلك اختارت بعض مواقع مودل التسجيل معنا ولدينا قائمة بهم.';
$string['registeredsitestitle'] = 'المواقع المسجلة';
$string['registereduserslastday'] = 'المستخدمون الجدد خلال 24 ساعة الماضية:';
$string['registereduserstotal'] = 'المجموع الكلي للمستخدمين المسجلين:';
$string['registrationgraphalt'] = 'كل تسجيلات مودل عبر الزمن';
$string['registrationgraphdesc'] = 'نحن نجري <a href="http://docs.moodle.org/en/Usage">فحصًا دوريًا عامًا للمواقع</a> للتأكد من استمرارها، لذلك أحيانًا قد ترى تناقصًا في العدد';
$string['registrationslast6months'] = 'المسجلون في الأشهر الست الماضية';
$string['registrationslastmonths'] = 'التسجيلات في غضون الأشهر {$a} الماضية';
$string['registrationstotal'] = 'جميع المسجلون الحاليون';
$string['resources_buzz'] = 'طنين';
$string['resources_courses'] = 'المقررات';
$string['resources_jobs'] = 'الوظائف';
$string['resources_plugins'] = 'الملاحق';
$string['roadmap'] = 'خارطة طريق مودل';
$string['rssdescription'] = 'آخر منشورات منتديات moodle.org النافعة أو ذات الصلة بها';
$string['rssmoodlecommore'] = 'أنظر كل الأخبار الأخيرة';
$string['rssmoodlecomtitle'] = 'آخر الأخبار';
$string['rsstitle'] = 'منشورات منتدى Moodle.org';
$string['searchmoodleorg'] = 'إبحث في moodle.org';
$string['securitytitle'] = 'إعلانات الأمان';
$string['shop'] = 'هل تبحث عن طريقة لتظهر بأنك جزء من مجتمعنا؟ أنظر متجرنا لتجد القمصان والأكواب وجميع الأشياء الأخرى.';
$string['social-facebook-moodle'] = 'الصفحة الرسمية لمودل في فيسبوك';
$string['social-googleplus-community'] = 'صفحة مجتمع مودل الرسمية في Google+';
$string['social-googleplus-moodle'] = 'صفحة مودل الرسمية في Google+';
$string['social-linkedin-moodle'] = 'صفحة مودل الرسمية في LinkedIn';
$string['social-twitter-moodle'] = 'إعلانات مودل الرسمية، أخبار مودل المجمعة من Planet Moodle وطنين مودل، ومنشورات المنتدى المفيدة';
$string['social-twitter-moodledev'] = 'أخبار تطوير مودل ومستجداته';
$string['social-twitter-moodlehq'] = 'التغريدات من مقر مودل';
$string['social-twitter-moodlejobs'] = 'الوظائف المعروضة ذات الصلة بمودل';
$string['social-twitter-moodlenet'] = 'المقررات والمحتوى المشاركة من مودل';
$string['social-twitter-moodleplugins'] = 'ملاحق مودل المطلقة مؤخرًا';
$string['social-twitter-moodleresearch'] = 'أخبار ومستجداته مؤتمر أبحاث مودل السنوي والأبحاث ذات الصلة بمودل';
$string['social-twitter-moodlesecurity'] = 'إعلانات الأمان لمودل';
$string['social-twitter-moodlesites'] = 'تحديثات المحتوى لشبكة مقر مودل عن المواقع والخدمات';
$string['social-twitter-moodlethemes'] = 'مظاهر مودل المطلقة مؤخرًا';
$string['social-youtube-moodle'] = 'قناة مودل الرسمية في يوتيوب';
$string['socialinfo'] = 'إننا ومن خلال مواقع تواصل اجتماعي متعددة نعمل لرفع الوعي العالمي نحو مشروع مودل ونشارك معكم آخر أخبار عالمه ومسراته. تابعنا لتبقى مطلعًا على المستجدات وتلتقي بآخرين في المجتمع.';
$string['socialtitle'] = 'وسائل التواصل الاجتماعي';
$string['statscountries'] = 'البلدان';
$string['statscourses'] = 'المقررات الدراسية';
$string['statsenrolments'] = 'التسجيلات في المساق';
$string['statsposts'] = 'مشاركات المنتدى';
$string['statsquestions'] = 'أسئلة الاختبار';
$string['statsresources'] = 'مصادر';
$string['statsteachers'] = 'المعلمون';
$string['statsusers'] = 'مستخدمون';
$string['supportbooks'] = 'نحتفظ بقائمة بالكثير من كتب مودل المتاحة للشراء.';
$string['supportcommercial'] = 'شركاء مودل هم مزودو خدمات مرخصين في أنحاء العالم يمكنهم مساعدتك في العمل مع مودل.';
$string['supportdocs1'] = 'وثائق مودل هي مكان رائع لتبدأ به، وخاصة صفحة أسئلة وأجوبة.';
$string['supportdocs2'] = 'من الطرق اللطيفة للوصول إلى التوثيق ذو الصلة هو استخدام رابط "توثيق مودل لهذه الصفحة" في أسفل أي صفحة تملكها في مودل.';
$string['supportdocsfaq'] = 'أسئلة وأجوبة';
$string['supportdocslang'] = 'وثائق مودل بلغات أخرى';
$string['supportforums'] = 'معظم مجتمع المستخدمين يتواصل عبر منتديات داخل "مساقات" في هذا الموقع المبني على مودل. يجب أن "تسجل" في المساق لتتمكن من المشاركة في المنتديات (التسجيل مجاني بالكامل)';
$string['supportforumsenglish'] = 'نقاشات التطوير والدعم بين المستخدمين والمطورين هنا هي بالإنجليزية بشكل رئيسي:';
$string['supportforumsenglishname'] = 'استخدام مودل';
$string['supportforumslang'] = 'المنتدى الرئيسي لمستخدمي مودل للاختلاط باللغة الإنجليزية هو هنا:';
$string['supportforumslangname'] = 'صالة مودل';
$string['supportforumslangurl'] = 'http://moodle.org/course/view.php?id=55';
$string['supportforumslist'] = 'لدينا العديد من المنتديات الأخرى أيضاً، بالعديد من اللغات:';
$string['supportforumslistname'] = 'قائمة بكل المقررات';
$string['supportintro'] = 'أنت لست وحيداً ! هناك العديد من الطرق للحصول على المساعدة في مودل إن احتجتها.';
$string['syncregistrationstask'] = 'مزامنة تحديثات تسجيلات المواقع العاملة بالإصدار 1.9 مع moodle.net';
$string['top10countriesbyregistration'] = 'أعلى 10 بلدان حسب التسجيل';
$string['top10sitesbycourses'] = 'أفضل 10 مواقع من حيث المقررات الدراسية';
$string['top10sitesbyusers'] = 'أفضل 10 مواقع من حيث المستخدمين';
$string['url-about'] = 'http://docs.moodle.org/en/About_Moodle';
$string['url-features'] = 'http://docs.moodle.org/en/Features';
$string['url-install'] = 'http://docs.moodle.org/en/Installation';
$string['url-standards'] = 'ttp://docs.moodle.org/en/Standards';
$string['url-userdocs'] = 'http://docs.moodle.org/en/';
$string['versionsused'] = 'الإصدارات المستعملة';
