<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'questionnaire', language 'sr_cr', version '4.4'.
 *
 * @package     questionnaire
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessibility:rate:choice'] = 'Ред {$a->rowposition}, {$a->choicetitle}: Колона {$a->colposition}, {$a->choiceanswer}.';
$string['action'] = 'Акција';
$string['activityoverview'] = 'Приближава се рок за попуњавање упитника';
$string['additionalinfo'] = 'Додатне информације';
$string['additionalinfo_help'] = 'Текст који ће бити приказан на врху прве странице упитника (тј. упутство, додатне информације итд.)';
$string['addnewquestion'] = 'Додавање питања типа: {$a}';
$string['addnewsection'] = 'Додај нову секцију';
$string['addquestion'] = 'Додај питање...';
$string['addquestions'] = 'Додај питања';
$string['addquestiontosection'] = 'Додај питање у секцију';
$string['addselqtype'] = 'Додај изабрани тип питања';
$string['alignment'] = 'Поравнање радио дугмади';
$string['alignment_help'] = 'Изаберите поравнање дугмади: вертикално (подразумевано) или хоризонтално.';
$string['alignment_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['all'] = 'Све';
$string['allnameddegrees'] = 'Именовани степени';
$string['allnameddegrees_help'] = 'Наведите текст који ће се приказати за вредности стопе уместо броја. Ако не желите ово да користите оставите поље празно.';
$string['alreadyfilled'] = 'Већ сте попунили овај упитник {$a}. Хвала.';
$string['andaveragevalues'] = 'и просечне вредности';
$string['anonymous'] = 'Анонимно';
$string['answer'] = 'Одговор';
$string['answergiven'] = 'Овај одговор је дат';
$string['answernotgiven'] = 'Овај одговор није дат';
$string['answerquestions'] = 'Одговорите на питања...';
$string['answers'] = 'Одговори';
$string['attempted'] = 'Овај упитник је предат.';
$string['attemptstillinprogress'] = 'У току. Сачувано дана:';
$string['autonumbering'] = 'Аутоматско нумерисање';
$string['autonumbering_help'] = 'Аутоматско нумерисање питања и страница. Можда ћете желети да искључите аутоматско нумерисање за упитнике са условним гранањем.';
$string['autonumberno'] = 'Не нумерисати питања или странице';
$string['autonumberpages'] = 'Аутоматско нумерисање страница';
$string['autonumberpagesandquestions'] = 'Аутоматско нумерисање страница и питања';
$string['autonumberquestions'] = 'Аутоматско нумерисање питања';
$string['average'] = 'Просек';
$string['averageposition'] = 'Просечна позиција';
$string['averagerank'] = 'Просечан ранг';
$string['averagesrow'] = 'Просеци (где је применљиво):';
$string['bodytext'] = 'Текст';
$string['boxesnbexact'] = 'тачно {$a} поље/а.';
$string['boxesnbmax'] = 'највише {$a} поље/а.';
$string['boxesnbmin'] = 'најмање {$a} поље/а.';
$string['boxesnbreq'] = 'За ово питање морате да обележите';
$string['by'] = 'од';
$string['cannotviewpublicresponses'] = 'Не можете да видите одговоре на овај јавни упитник.';
$string['centerlabel'] = 'Натпис у средини';
$string['chart:bipolar'] = 'Двостране линије';
$string['chart:hbar'] = 'Хоризонталне линије';
$string['chart:radar'] = 'Радар';
$string['chart:rose'] = 'Розета';
$string['chart:type'] = 'Тип графикона';
$string['chart:type_help'] = 'Изаберите тип графикона који желите да користите за ове повратне информације';
$string['chart:vprogress'] = 'Вертикална трака напредовања';
$string['checkallradiobuttons'] = 'Молимо потврдите <strong>{$a}</strong> радио дугме/та';
$string['checkboxes'] = 'Поља за потврду';
$string['checkboxes_help'] = 'Унесите у сваки ред по једну опцију како би корисник изабрао један или више одговора.';
$string['checkboxes_link'] = 'mod/questionnaire/questions#Check_Boxes';
$string['checkbreaksadded'] = 'Нови прелом/и странице уметнут/и на позицији/ама:';
$string['checkbreaksok'] = 'Сви захтевани преломи страница су присутни!';
$string['checkbreaksremoved'] = 'Уклоњено додатних прелома страница: {$a}';
$string['checknotstarted'] = 'Избор није почео';
$string['checkstarted'] = 'Избор почео';
$string['clicktoswitch'] = '(притисни за промену)';
$string['closebeforeopen'] = 'Навели сте датум затварања пре датума отварања.';
$string['closed'] = 'Упитник је затворен дана {$a}. Хвала.';
$string['closedate'] = 'Дозволите одговоре до';
$string['closeson'] = 'Упитник се затвара {$a}';
$string['completionsubmit'] = 'Полазник мора да преда овај упитник како би га завршио';
$string['condition'] = 'Услов';
$string['confalts'] = '- ИЛИ - <br />Страница за потврду';
$string['configemailreporting'] = 'Дозволите слање извештаје путем е-поште';
$string['configemailreportinglong'] = 'Омогућава опције за слање неких извештаја директно на одређене адресе е-поште.';
$string['configmaxsections'] = 'Максималан број секција са повратним информацијама';
$string['configusergraph'] = 'Прикажи графиконе за "Тест личности"';
$string['configusergraphlong'] = 'Употребите <a href="http://www.rgraph.net/">Rgraph</a> библиотеку за приказ графикона "Тест личности"';
$string['confirmdelallresp'] = 'Да ли сте сигурни да желите да обришете СВЕ одговоре у овом упитнику?';
$string['confirmdelchildren'] = 'Ако избришете ово питање, његово/а подређена питање/а биће такође обрисана:';
$string['confirmdeletesection'] = 'Да ли сте сигурни да желите да обришете секцију са повртним информацијама "{$a}"?';
$string['confirmdelgroupresp'] = 'Да ли сте сигурни да желите да обришете СВЕ одговоре групе {$a}?';
$string['confirmdelquestion'] = 'Да ли сте сигурни да желите да обришете питање на позицији {$а}?';
$string['confirmdelquestionresps'] = 'Ово ће такође oбрисати {$а} одговор/а  који су већ дати на то питање.';
$string['confirmdelresp'] = 'Да ли сте сигурни да желите да обришете одговоре које је послао/ла &nbsp;{$a}&nbsp;?';
$string['confirmremovequestion'] = 'Да ли сте сигурни да желите уклонити питање "{$a->qname}" из секције "{$a->sname}"?';
$string['confpage'] = 'Текст наслова';
$string['confpage_help'] = 'Наслов (написан подебљаним словима) и текст странице за "Потврду" се приказује након што корисник попуни овај упитник. (URL адреса, ако постоји, има предност у односу на текст потврде.) Ако оставите ово поље празно, по завршетку упитника, биће приказана стандардна порука (Хвала вам што сте попунили овај упитник).';
$string['confpagedesc'] = 'Наслов (написан подебљаним словима) и текст странице за &quot;Потврду&quot; се приказује након што корисник попуни овај упитник. (URL адреса, ако постоји, има предност у односу на текст потврде.)';
$string['contentoptions'] = 'Опције за садржај';
$string['couldnotcreatenewsurvey'] = 'Није могуће направити нови упитник!';
$string['couldnotdelresp'] = 'Није могуће обрисати одговор';
$string['createcontent'] = 'Дефиниши нови садржај';
$string['createcontent_help'] = 'Изаберите једну од опција. \'Креирај нови\' \'је подразумевана опција.';
$string['createcontent_link'] = 'mod/questionnaire/mod#Content_Options';
$string['createnew'] = 'Креирај нови';
$string['crontask'] = 'Чишћење упитника';
$string['date'] = 'Датум';
$string['date_help'] = 'Користите овај тип питање ако очекујете да одговор буде исправно форматиран датум.';
$string['date_link'] = 'mod/questionnaire/questions#Date';
$string['dateformatting'] = 'Користите формат дан/месец/година, нпр. за 4. март, 1945:&nbsp; <strong>1945-03-04</strong>';
$string['deleteallresponses'] = 'Обриши СВЕ одговоре';
$string['deletecurrentquestion'] = 'Обриши питање {$a}';
$string['deletedallgroupresp'] = 'Обрисани СВИ одговори у групи {$a}';
$string['deletedallresp'] = 'Одговори на упитник су обрисани';
$string['deletedisabled'] = 'Ова ставка не може бити обрисана';
$string['deletedresp'] = 'Обрисани одговор';
$string['deleteresp'] = 'Обриши овај одговор';
$string['deletesection'] = 'Обриши ову секцију';
$string['deletingresp'] = 'Брисање одговора';
$string['dependencies'] = 'Зависности';
$string['dependquestion'] = 'Надређено питање';
$string['dependquestion_help'] = 'Можете да изаберете надређено питање и одговор за ово питање. Подређено питање биће приказано полазнику само ако су претходно изабрани надређено питање и надређени одговор.';
$string['dependquestion_link'] = 'mod/questionnaire/questions#Parent_Question';
$string['didnotrespondtoquestion'] = 'Без одговора на питање';
$string['directwarnings'] = 'Директне зависности од овог питања ће бити уклоњене. Ово ће утицати на:';
$string['displaymethod'] = 'Метод приказа није дефинисан за питање.';
$string['download'] = 'Преузми';
$string['downloadpdf'] = 'Преузми PDF';
$string['downloadtextformat'] = 'Преузми';
$string['downloadtextformat_help'] = 'Ова функција вам омогућава да преузмете одговоре на упитник у формату датотеке по сопственом избору.
Датотека се затим може отворити у програму за прорачунске табеле (нпр. MS Excel или Open Office Calc) или у одговарајућем статистичком пакету за даљу обраду.';
$string['downloadtextformat_link'] = 'mod/questionnaire/report#Download_in_text_format';
$string['downloadtypes'] = 'Тип извештаја';
$string['dropdown'] = 'Падајући мени';
$string['dropdown_help'] = 'Не постоји стварна предност у коришћењу падајућег менија у односу на радио дугмад, осим што падајући мени штеди простор на екрану.';
$string['dropdown_link'] = 'mod/questionnaire/questions#Dropdown_Box';
$string['edit'] = 'Уреди';
$string['editingfeedback'] = 'Уређивање подешавања за повратне информације';
$string['editingquestionnaire'] = 'Уређивање подешавања упитника';
$string['editquestion'] = 'Уређивање {$a} питања';
$string['email'] = 'Е-пошта';
$string['emailextra'] = 'Пошаљите датотеку за преузимање на е-адресе';
$string['emailextra_help'] = 'Послаће датотеку за преузимање на наведене адресе е-поште, одвојене зарезима. Имајте на уму да се НЕ врши НИКАКВА провера безбедности или приватности.
Опција \'allowemailreporting\' мора бити омогућена у подешавањима модула како бисте овоме приступили.';
$string['emailroles'] = 'Пошаљите датотеку за преузимање улогама';
$string['emailroles_help'] = 'Послаће датотеку за преузимање свим улогама које имају способност "mod/questionnaire:submissionnotification" путем е-поште.
Опција \'allowemailreporting\' мора бити омогућена у подешавањима модула како бисте овоме приступили.';
$string['emailsend'] = 'Пошаљите извештаје';
$string['emailsnotspecified'] = 'Није наведена ниједна адреса е-поште.';
$string['emailssent'] = 'Датотеке за преузимања су послата на наведене адресе е-поште.';
$string['errnewname'] = 'Нажалост, назив је већ у употреби. Изаберите нови назив.';
$string['erroropening'] = 'Грешка приликом отварања упитника';
$string['errortable'] = 'Грешка. Системска табела је оштећена.';
$string['essaybox'] = 'Поље за есеј';
$string['essaybox_help'] = 'Овај тип питања приказује обично поље за унос текста са **x**  стубаца (ширина поља за унос) и **y** редова (број линија текста).

Уколико оставите оба подешавања на подразумеваних **0** (или их сами подесите на ту вредност), онда ће бити приказан HTML едитор стандардне висине и ширине (ако је доступан у контексту курса/корисника и у корисничком профилу).';
$string['event_all_responses_deleted'] = 'Сви одговори обрисани';
$string['event_all_responses_saved_as_text'] = 'Сви одговори сачувани као текст';
$string['event_all_responses_viewed'] = 'Извештај са свим одговорима приказан';
$string['event_individual_responses_viewed'] = 'Извештај са појединачним одговорима приказан';
$string['event_non_respondents_viewed'] = 'Приказани испитаници који нису одговорили';
$string['event_previewed'] = 'Упитник приказан';
$string['event_question_created'] = 'Питање креирано';
$string['event_question_deleted'] = 'Питање обрисано';
$string['event_response_deleted'] = 'Појединачни одговор обрисан';
$string['event_resumed'] = 'Покушај настављен';
$string['event_saved'] = 'Одговори сачувани';
$string['event_submitted'] = 'Одговори предати';
$string['feedback'] = 'Повратне информације';
$string['feedback_help'] = 'Повратне информације - Помоћ';
$string['feedback_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Messages';
$string['feedbackaddmorefeedbacks'] = 'Додај {no} поља за повратне информације';
$string['feedbackbysection'] = 'Секције са повратним информацијама';
$string['feedbackdefaultlabel'] = '[Нова секција]';
$string['feedbackeditingglobal'] = 'Уређивање општих повратних информација упитника';
$string['feedbackeditingmessages'] = 'Уређивање порука са повратним информацијама упитника';
$string['feedbackeditingsections'] = 'Уређивање секција са повратним информацијама упитника';
$string['feedbackeditmessages'] = 'Сачувајте подешавања секција и уредите поруке са повратним информацијама';
$string['feedbackeditsections'] = 'Сачувајте подешавања и уредите секције повратних информација';
$string['feedbackerrorboundaryformat'] = 'Границе резултата повратних информација морају бити или проценат или број. Вредност коју сте унели за границу {$a} није препозната.';
$string['feedbackerrorboundaryoutofrange'] = 'Границе резултата повратних информација морају бити између 0% и 100%. Вредност коју сте унели за границу {$a} је ван опсега.';
$string['feedbackerrorjunkinboundary'] = 'Морате да попуните поља за границе резултата повратних информација без икаквих празнина.';
$string['feedbackerrorjunkinfeedback'] = 'Морате да попуните поља повратних информација без икаквих празнина.';
$string['feedbackerrororder'] = 'Границе резултата повратних информација морају бити поређане, од највећег. Вредност коју сте унели за границу {$a} је ван низа.';
$string['feedbackglobal'] = 'Опште повратне информације';
$string['feedbackglobalheading'] = 'Наслов општих повратних информација';
$string['feedbackglobalmessages'] = 'Поруке са општим повратним информацијама';
$string['feedbackhdr'] = 'Повратне информације';
$string['feedbackheading'] = 'Наслов повратних информација';
$string['feedbackheading_help'] = 'У пољу наслова повратних информација можете да користите две променљиве: $scorepercent и $oppositescorepercent.';
$string['feedbackmessages'] = 'Поруке са повратним информацијама за секцију {$a}';
$string['feedbacknextsection'] = 'Следећа секција {$a}';
$string['feedbacknone'] = 'Нема порука повратних информација';
$string['feedbacknotes'] = 'Белешке повратних информација';
$string['feedbacknotes_help'] = 'Текст који је овде унет биће приказан испитаницима на крају њиховог извештаја са повратним информацијама.';
$string['feedbackoptions'] = 'Опције повратних информација';
$string['feedbackoptions_help'] = 'Опције за повратне информације су доступне ако ваш упитник садржи следеће типове питање и подешавања питања:
Радио дугмад, Падајуће мени, Да/Не или Скала процене (нормална или Озгудова скала) или Клизна скала. Та питања морају бити подешена као обавезна, њихово поље \'Назив питања\' НЕ сме бити празно, а поља \'Могући одговори\' морају да садрже одговарајућу вредност. Клизне скале НЕ смеју да користе негативну вредност за \'Минимални опсег клизне скале\'.';
$string['feedbackoptions_link'] = 'mod/questionnaire/personality_test';
$string['feedbackremovequestionfromsection'] = 'Ово питање је део секције са повратним информацијама [{$a}]';
$string['feedbackremovesection'] = 'Уклањање овог питања потпуно ће уклонити секцију повратних информација [{$a}]';
$string['feedbackreport'] = 'Извештај са повратним информацијама';
$string['feedbackscore'] = 'Резултат повратних информација';
$string['feedbackscoreboundary'] = 'Граница резултата повратни информација';
$string['feedbackscores'] = 'Приказ резултата';
$string['feedbackscores_help'] = 'Приказ табеле резултата повратних информација';
$string['feedbacksection'] = 'Секција';
$string['feedbacksectionheading'] = 'Наслов секције са повратним информацијама {$a}';
$string['feedbacksectionheadingmissing'] = 'Морате да унесете наслов секције са повратним информацијама!';
$string['feedbacksectionheadingtext'] = 'Наслов';
$string['feedbacksectionlabel'] = 'Натпис';
$string['feedbacksectionlabel_help'] = 'Овај натпис ће бити коришћен у графиконима/дијаграмима. Треба да буде што краћи!';
$string['feedbacksectionquestions'] = 'Питања секције са повратним информацијама {$a}';
$string['feedbacksections'] = 'Секције повратних информација';
$string['feedbacksectionsselect'] = 'Секције';
$string['feedbacksectionsselect_help'] = 'Поставите ваша питања унутар ових секција';
$string['feedbacksectionsselect_link'] = 'mod/questionnaire/personality_test#Editing_Questionnaire_Feedback_Sections_2';
$string['feedbacksettingssaved'] = 'Подешавања повратних информација су сачувана';
$string['feedbacktype'] = 'Тип повратне информације';
$string['field'] = 'Питање {$a}';
$string['fieldlength'] = 'Дужина поља за унос';
$string['fieldlength_help'] = 'За питање типа **Поље за унос текста**, унесите вредности за **Дужина поља за унос** и **Максимална дужина текста** за текст који треба да унесе испитаник.

Подразумеване вредности су 20 знакова за дужину поља за унос и 25 знакова за максималну дужину унетог текста.';
$string['finished'] = 'Одговорили сте на сва питања у овом упитнику!';
$string['firstrespondent'] = 'Први испитаник';
$string['formateditor'] = 'HTML едитор текста';
$string['formatplain'] = 'Обичан текст';
$string['grade'] = 'Оцена за попуњени упитник';
$string['gradesdeleted'] = 'Оцене упитника обрисане';
$string['headingtext'] = 'Текст наслова';
$string['horizontal'] = 'Хоризонтално';
$string['id'] = 'ID';
$string['includechoicecodes'] = 'Укључи кôдове одговора';
$string['includechoicetext'] = 'Укључи текст одговора';
$string['includeincomplete'] = 'Укључите непотпуне одговоре';
$string['includerankaverages'] = 'Укључите просеке за питања типа "Скала процене"';
$string['incorrectcourseid'] = 'ID ознака курса је неисправна';
$string['incorrectmodule'] = 'ID ознака модула курса је неисправна';
$string['incorrectquestionnaire'] = 'Упитник је неисправан';
$string['indirectwarnings'] = 'Овај списак приказује индиректна зависна питања и преостале зависности за директна зависна питања:';
$string['invalidincrement'] = 'Имајте на уму да инкрементна вредност мора бити мања од максималне вредности. На пример, ако је скала од 1-10, инкрементна вредност ће вероватно бити 1.';
$string['invalidminmaxrange'] = 'Овај тип питања подржава апсолутни максимални опсег од -100 до +100. Очекујемо да ће велика већина питања у упитнику користити опсег од 1-10 или -10 до +10.';
$string['invalidrange'] = 'Максимална вредност клизача мора бити већа од његове минималне вредности.';
$string['invalidresponse'] = 'Наведен је неисправан одговор';
$string['invalidresponserecord'] = 'Наведен је неисправан запис одговора';
$string['invalidsectionid'] = 'Наведена је неисправна секција са повратним информацијама.';
$string['invalidstartingvalue'] = 'Почетна вредност мора бити једнака или између минималне и максималне вредности. На пример, ако користите скалу од 1-10, почетна вредност може бити 5.';
$string['invalidsurveyid'] = 'Неисправна ID ознака упитника';
$string['kindofratescale'] = 'Тип скале процене';
$string['kindofratescale_help'] = 'Кликните десним тастером миша на доњи линк \'Више помоћи\'.';
$string['kindofratescale_link'] = 'mod/questionnaire/questions#Type_of_rate_scale';
$string['lastrespondent'] = 'Последњи испитаник';
$string['leftlabel'] = 'Натпис на левој страни';
$string['leftpart'] = '{$a->min} је {$a->leftlabel}';
$string['leftpartdefault'] = '{$a->min} је минимални опсег клизне скале';
$string['length'] = 'Дужина';
$string['managequestions'] = 'Управљање питањима';
$string['managequestions_help'] = 'У секцији \'Управљање питањима\' на страници \'Уређивање питања\', можете спровести низ операција са питањима упитника.';
$string['managequestions_link'] = 'mod/questionnaire/questions#Manage_questions';
$string['mandatory'] = 'Обавезно - све ове зависности морају бити испуњене.';
$string['maxdigitsallowed'] = 'Максималан број дозвољених цифара';
$string['maxdigitsallowed_help'] = 'Користите подешавање \'Максимално дозвољених цифара\' како бисте ограничили број знакова који се може унети у одговору на \'Бројчано питање\'. Имајте у виду да се децимална тачка такође рачуна као један знак.';
$string['maxdigitsallowed_link'] = 'mod/questionnaire/questions#Numeric';
$string['maxforcedresponses'] = 'Максималан број обавезних одговора';
$string['maxforcedresponses_help'] = 'Користите ове параметре како бисте приморали испитанике да означе најмање **Min.** односно највише **Max.** поља за потврду . Да бисте их приморали да означе тачан број поља за потврду, подесите **Min.** и **Max.** на исту вредност. Ако је пожељна само најмања или највећа вредност, онда оставите ону другу вредност на подразумеваних **0**. Ако подесите **Min.** или **Max.** на вредности различите од подразумеваних **0**,  онда ће испитаницима, уколико не испуне ваш захтев, бити приказана порука са упозорењем. Очигледно, неопходно је да сваки захтев јасно ставите до знања испитаницима било у општим упутствима на почетку вашег упитника, било у тексту одговарајућег питања.';
$string['maxrange'] = 'Максимални опсег клизача (десно)';
$string['maxrange_help'] = 'Подесите максималну вредност опсега на десној страни. Подразумевано је 100, али може бити било који број између 1-100. Ако је минимална вредност на левој страни негативна вредност, максимум опсега ће бити изражен позитивним (+) знаком.';
$string['maxtextlength'] = 'Максимална дужина текста';
$string['maxtextlength_help'] = 'За питање типа "Поље за унос текста", унесите вредности за \'Дужина поља за унос\' и \'Максимална дужина текста\' за текст који треба да унесе испитаник. Подразумеване вредности су 20 знакова за дужину поља за унос и 25 знакова за максималну дужину унетог текста.';
$string['messageprovider:message'] = 'Подсетник за упитник';
$string['messageprovider:notification'] = 'Предаја упитника';
$string['middlepart'] = ', {$a->centreval} је {$a->middlelabel}';
$string['middlepartdefault'] = ', {$a->centreval} је просек';
$string['middlepartwithtwovalues'] = ', {$a->centreval1} и {$a->centreval2} су {$a->middlelabel}';
$string['middlepartwithtwovaluesdefault'] = ', {$a->centreval1} и {$a->centreval2} су просек';
$string['minforcedresponses'] = 'Минималан број обавезних одговора';
$string['minforcedresponses_help'] = 'Користите ове параметре како бисте приморали испитаника да означи најмање **Min.** односно највише **Max.** поља за потврду . Да бисте их приморали да означе тачан број поља за потврду, подесите **Min.** и **Max.** на исту вредност. Ако је пожељна само најмања или највећа вредност, онда оставите ону другу вредност на подразумеваних **0**. Ако подесите **Min.** или **Max.** на вредности различите од подразумеваних **0**, онда ће испитанику, уколико не испуни ваш захтев, бити приказана порука са упозорењем. Очигледно, неопходно је да сваки захтев јасно ставите до знања испитаницима било у општим упутствима на почетку вашег упитника, било у тексту одговарајућег питања.';
$string['minrange'] = 'Максимални опсег клизача (лево)';
$string['minrange_help'] = 'Подесите минималну вредност опсега на левој страни. Подразумевано је 1, али се може поставити и на -100. Ако користите негативан број (-100 до -1), максимум опсега на десној страни ће бити изражен позитивним (+) знаком.';
$string['misconfigured'] = 'Курс је погрешно конфигурисан';
$string['missingname'] = 'Питање {$a} не може бити употребљено у овој секцији зато што нема назив.';
$string['missingnameandrequired'] = 'Питање {$a} не може бити употребљено у овој секцији зато што нема назив и није потребно.';
$string['missingquestion'] = 'Молимо вас да одговорите на обавезно питање';
$string['missingquestions'] = 'Mолимо вас да одговорите на обавезна питања:';
$string['missingrequired'] = 'Питање {$a} се не може користити у овој секцији са повратним информацијама зато што није обавезно.';
$string['modulename'] = 'Упитник (Questionnaire)';
$string['modulename_help'] = 'Модул Упитник (Questionnaire) вам омогућава да направите упитник коришћењем различитих типова питање, ради прикупљања података од стране корисника.';
$string['modulename_link'] = 'mod/questionnaire/view';
$string['modulenameplural'] = 'Упитници (Questionnaires)';
$string['movedisabled'] = 'Ова ставка не може да се помера';
$string['myresponses'] = 'Сви ваши одговори';
$string['myresponsetitle'] = 'Ваши одговори: {$a}';
$string['myresults'] = 'Ваши резултати';
$string['name'] = 'Назив';
$string['navigate'] = 'Дозволи питања са гранањем';
$string['navigate_help'] = 'Омогућите да питања типа "Да/Не" и "Радио дугмад" имају подређена питања у зависности од изабраног одговора у вашем упитнику.';
$string['navigate_link'] = 'mod/questionnaire/conditional_branching';
$string['navigatetosection'] = 'Иди на секцију са повратним информацијама';
$string['next'] = 'Следеће';
$string['nextpage'] = 'Следећа страница';
$string['nlines'] = 'Број редова: {$a}';
$string['noanswer'] = 'Нема одговора';
$string['noattempts'] = 'Није било покушаја попуњавања ова упитника.';
$string['nodata'] = 'Подаци нису послати';
$string['noduplicates'] = 'Нема дуплих одговора';
$string['noduplicateschoiceserror'] = 'Морате унети најмање два могућа одговора за опцију "Нема дуплих одговора"!';
$string['non_respondents'] = 'Корисници који још увек нису предали своје одговоре на овај упитник';
$string['noneinuse'] = 'Овај упитник не садржи ниједно питање.';
$string['nopermissions'] = 'Жао нам је, али тренутно немате овлашћења да видите ову страницу или извршите ову радњу.';
$string['nopublicsurveys'] = 'Нема јавних упитника';
$string['noresponsedata'] = 'Нема одговора на ово питање.';
$string['noresponses'] = 'Нема одговора';
$string['normal'] = 'Нормално';
$string['not_started'] = 'није започето';
$string['notanumber'] = '<strong>{$a}</strong> није прихватљив формат броја.';
$string['notapplicable'] = 'N/A';
$string['notapplicablecolumn'] = 'N/A колона';
$string['notavail'] = 'Овај упитник није доступан. Питајте свог предавача да га обрише.';
$string['noteligible'] = 'Немате право да одговарате на овај упитник.';
$string['notemplatesurveys'] = 'Нема шаблона упитника.';
$string['notenoughscaleitems'] = 'Морате унети најмање 2 ставке скале!';
$string['notificationfull'] = 'Комплетно попуњен упитник';
$string['notifications'] = 'Пошаљи обавештења о предатим упитницима';
$string['notifications_help'] = 'Обавестите кориснике са улогама које имају способност "mod/questionnaire:submissionnotification" када је упитник предат.';
$string['notifications_link'] = 'mod/questionnaire/mod#Submission_Notifications';
$string['notificationsimple'] = 'Само обавештење';
$string['notopen'] = 'Овај упитник неће бити доступан до {$a}.';
$string['notrequired'] = 'Одговор није обавезан';
$string['notset'] = 'није подешено';
$string['nousersselected'] = 'Корисник није изабран';
$string['num'] = '#';
$string['numattemptsmade'] = '{$a} покушај/а попуњавања овог упитника';
$string['numberfloat'] = 'Број који сте унели <strong>{$a->number}</strong> је заокружен на<strong>{$a->precision}</strong> децимално/а место/а.';
$string['numberofdecimaldigits'] = 'Број децималних цифара';
$string['numberofdecimaldigits_help'] = 'Користите **Број децималних цифара** како бисте одредили формат Просечне вредности који се израчунава и приказује на страници "Извештај о упитнику"';
$string['numberofdecimaldigits_link'] = 'mod/questionnaire/questions#Numeric';
$string['numberscaleitems'] = 'Број ставки скале';
$string['numberscaleitems_help'] = 'Број ставки скале је *број ставки* који ће се користити у вашој скали процене. Нормално, можете да користите вредност од 3 до 5. Подразумевана вредност: **5**.';
$string['numeric'] = 'Нумеричка вредност';
$string['numeric_help'] = 'Користите овај тип питање ако очекујете да одговор буде исправно форматиран број.';
$string['of'] = 'од';
$string['openafterclose'] = 'Навели сте датум отварања након датума затварања';
$string['opendate'] = 'Дозволите одговоре од';
$string['option'] = 'опција {$a}';
$string['optional'] = 'Опционо - мора се испунити барем једна од ових зависности.';
$string['optionalname'] = 'Назив питања';
$string['optionalname_help'] = 'Назив питања се користи само када извозите одговоре у CSV/Excel формат.
Ако не планирате да извозите одговоре у CSV, онда уопште не морате да бринете о називу питања. Ако планирате редован извоз података из упитника у CSV, онда су вам на располагању две опције за давање назива питања.';
$string['optionalname_link'] = 'mod/questionnaire/questions#Question_Name';
$string['or'] = '- ИЛИ -';
$string['order_ascending'] = 'Растући редослед';
$string['order_default'] = 'Погледај подразумевани редослед';
$string['order_descending'] = 'Опадајући редослед';
$string['orderresponses'] = 'Редослед одговора';
$string['orderresponses_help'] = 'Приликом приказивања свих одговора, они се могу поређати према учесталости којом се јављају (колона са просецима), за следећа 4 типа питања,:

* један одговор - радио дугме
* један одговор - падајући мени
* вишеструки одговор - поља за потврду
* скала процене (укључујући Ликертову скалу)

Када дођете на страницу са свим одговорима, они су стандардно поређани оним редоследом како их је унео креатор упитника. Ви их можете поређати растућим или опадајућим редоследом.';
$string['orderresponses_link'] = 'mod/questionnaire/report#Order_Responses';
$string['osgood'] = 'Озгудова (Osgood) семантичка скала';
$string['other'] = 'Остало:';
$string['otherempty'] = 'Ако означите ову опцију онда морате да унесете текст одговора у поље за текст!';
$string['overviewnumresplog'] = 'одговори';
$string['overviewnumresplog1'] = 'одговор';
$string['overviewnumrespvw'] = 'одговори';
$string['overviewnumrespvw1'] = 'одговор';
$string['owner'] = 'Власник';
$string['page'] = 'Страница';
$string['pageof'] = 'Страница {$a->page} од {$a->totpages}';
$string['parent'] = 'Надређено';
$string['participant'] = 'Учесник';
$string['pleasecomplete'] = 'Молим вас попуните овај избор.';
$string['pluginadministration'] = 'Администрација упитника';
$string['pluginname'] = 'Упитник (Questionnaire)';
$string['position'] = 'позиција';
$string['possibleanswers'] = 'Могући одговори';
$string['posteddata'] = 'Добијена је страница са следећим подацима:';
$string['preview_label'] = 'Преглед';
$string['preview_questionnaire'] = 'Преглед упитника';
$string['previewing'] = 'Преглед упитника';
$string['previous'] = 'Претходно';
$string['previouspage'] = 'Претходна страница';
$string['print'] = 'Штампај овај одговор';
$string['printblank'] = 'Штампај непопуњен упитник';
$string['printblanktooltip'] = 'Отвора прозор прилагођен за штампања са непопуњеним упитником';
$string['printtooltip'] = 'Отвора прозор прилагођен за штампања са тренутним одговором';
$string['privacy:metadata:questionnaire_resp_multiple'] = 'Одговор на питање типа "Вишеструки одговор".';
$string['privacy:metadata:questionnaire_resp_multiple:choice_id'] = 'ID ознака записа избора за овај одговор.';
$string['privacy:metadata:questionnaire_resp_multiple:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_resp_multiple:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['privacy:metadata:questionnaire_resp_single'] = 'Одговор на питање типа "Један одговор".';
$string['privacy:metadata:questionnaire_resp_single:choice_id'] = 'ID ознака записа избора за овај одговор.';
$string['privacy:metadata:questionnaire_resp_single:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_resp_single:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['privacy:metadata:questionnaire_response'] = 'Одговор који је у току или је предат';
$string['privacy:metadata:questionnaire_response:complete'] = 'Статус завршетка одговора.';
$string['privacy:metadata:questionnaire_response:grade'] = 'Оцена за овај одговор.';
$string['privacy:metadata:questionnaire_response:questionnaireid'] = 'ID ознака записа упитника за овај одговор.';
$string['privacy:metadata:questionnaire_response:submitted'] = 'Временска ознака када је последњи пут сачуван овај одговор .';
$string['privacy:metadata:questionnaire_response:userid'] = 'ID ознака корисника за овај одговор.';
$string['privacy:metadata:questionnaire_response_bool'] = 'Одговор на питање типа "Да/Не"';
$string['privacy:metadata:questionnaire_response_bool:choice_id'] = 'Конкретан одговор на питање типа "Да/Не"';
$string['privacy:metadata:questionnaire_response_bool:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_response_bool:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['privacy:metadata:questionnaire_response_date'] = 'Одговор на питање типа "Датум"';
$string['privacy:metadata:questionnaire_response_date:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_response_date:response'] = 'Конкретан одговор на питање типа "Датум"';
$string['privacy:metadata:questionnaire_response_date:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['privacy:metadata:questionnaire_response_other'] = 'Текст одговора када је изабрана опција \'друго\'.';
$string['privacy:metadata:questionnaire_response_other:choice_id'] = 'ID ознака записа избора за овај одговор.';
$string['privacy:metadata:questionnaire_response_other:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_response_other:response'] = 'Конкретан текстуалан одговор када је изабрана опција \'друго\'.';
$string['privacy:metadata:questionnaire_response_other:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['privacy:metadata:questionnaire_response_rank'] = 'Одговор на питање типа "Скала процене"';
$string['privacy:metadata:questionnaire_response_rank:choice_id'] = 'ID ознака записа избора за овај одговор.';
$string['privacy:metadata:questionnaire_response_rank:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_response_rank:rankvalue'] = 'Конкретан одговор на питање типа "Скала процене"';
$string['privacy:metadata:questionnaire_response_rank:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['privacy:metadata:questionnaire_response_text'] = 'Одговор на питање типа "Поље за унос текста"';
$string['privacy:metadata:questionnaire_response_text:question_id'] = 'ID ознака записа питања за овај одговор.';
$string['privacy:metadata:questionnaire_response_text:response'] = 'Конкретан одговор на питање типа "Поље за унос текста"';
$string['privacy:metadata:questionnaire_response_text:response_id'] = 'ID ознака записа одговора за овај одговор.';
$string['private'] = 'Приватни';
$string['progressbar'] = 'Прикажи траку напредовања';
$string['progressbar_info'] = 'Упитник {$a} је завршен.';
$string['progresshelp'] = 'Трака напредовања';
$string['progresshelp_help'] = 'Пређите на следећу страницу како бисте попуните траку напредовања';
$string['public'] = 'Јавни';
$string['publiccopy'] = 'Копија:';
$string['publicoriginal'] = 'Оригинал:';
$string['qtype'] = 'Тип';
$string['qtype_help'] = 'Изаберите да ли ће корисницима бити дозвољено да одговарају само једанпут, дневно, недељно, месечно или неограничени број пута.';
$string['qtypedaily'] = 'одговори дневно';
$string['qtypemonthly'] = 'одговори месечно';
$string['qtypeonce'] = 'одговори једанпут';
$string['qtypeunlimited'] = 'одговори више пута';
$string['qtypeweekly'] = 'одговори недељно';
$string['questionnaire:addinstance'] = 'Додавање новог упитника';
$string['questionnaire:copysurveys'] = 'Копирање шаблона и приватних упитника';
$string['questionnaire:createpublic'] = 'Креирање јавних упитника';
$string['questionnaire:createtemplates'] = 'Креирање шаблона упитника';
$string['questionnaire:deleteresponses'] = 'Брисање било ког одговора';
$string['questionnaire:downloadresponses'] = 'Преузимање одговоре као CSV датотеке';
$string['questionnaire:editquestions'] = 'Креирање и уређивање питања упитника';
$string['questionnaire:manage'] = 'Креирање и уређивање упитника';
$string['questionnaire:message'] = 'Пошаљи поруку корисницима који нису попунили упитник';
$string['questionnaire:preview'] = 'Преглед упитника';
$string['questionnaire:printblank'] = 'Штампање непопуњеног упитника';
$string['questionnaire:readallresponseanytime'] = 'Читање свих одговора у било ком тренутку';
$string['questionnaire:readallresponses'] = 'Читање резимеа одговора';
$string['questionnaire:readownresponses'] = 'Читање својих одговора';
$string['questionnaire:submissionnotification'] = 'Пријем обавештења за сваки предати упитник';
$string['questionnaire:submit'] = 'Завршетак и предаја упитника';
$string['questionnaire:view'] = 'Преглед упитник';
$string['questionnaire:viewsingleresponse'] = 'Преглед завршених појединачних одговора';
$string['questionnaireadministration'] = 'Администрација упитника';
$string['questionnairecloses'] = 'Упитник се затвара';
$string['questionnaireopens'] = 'Упитник се отвара';
$string['questionnairereport'] = 'Извештај о упитнику';
$string['questionnum'] = 'Питање #';
$string['questions'] = 'Питања';
$string['questionsinsection'] = 'Питања у овој секцији:';
$string['questiontypes'] = 'Типови питања';
$string['questiontypes_help'] = 'Погледајте Moodle документацију испод';
$string['questiontypes_link'] = 'mod/questionnaire/questions#Question_Types';
$string['radiobuttons'] = 'Радио дугмад';
$string['radiobuttons_help'] = 'Код овог типа питања испитаник мора да изабере један од понуђених одовора.';
$string['radiobuttons_link'] = 'mod/questionnaire/questions#Radio_Buttons';
$string['rank'] = 'Ранг';
$string['ratescale'] = 'Скала процене (скала 1 ..5)';
$string['ratescale_help'] = 'Погледајте Moodle документацију испод';
$string['ratescale_link'] = 'mod/questionnaire/questions#Rate_.28scale_1..5.29';
$string['realm'] = 'Тип упитника';
$string['realm_help'] = '* **Постоје три типа упитника:**
* Приватни - припада само курсу у оквиру којег је креиран.
* Шаблон - могуће је копирати га и уређивати.
* Јавни - могуће је делити га између курсева.';
$string['realm_link'] = 'mod/questionnaire/qsettings#Questionnaire_Type';
$string['redirecturl'] = 'URL  адреса на коју се корисници преусмеравају након што заврше овај упитник.';
$string['remove'] = 'Обриши';
$string['removeallquestionnaireattempts'] = 'Обриши све одговоре у упитнику';
$string['removenotinuse'] = 'Овај упитник зависи од јавног упитника који је обрисан. Такав упитник не може више да се користи и треба га обрисати.';
$string['required'] = 'Обавезно је одговорити';
$string['required_help'] = 'Ако изаберете **Да** одговор на ово питање биће обавезан тј. испитаник неће моћи да преда упитник све док не одговори на ово питање.';
$string['required_link'] = 'mod/questionnaire/questions#Response_Required';
$string['requiredparameter'] = 'Недостаје неопходан параметар';
$string['reset'] = 'Ресетуј';
$string['respeligiblerepl'] = '(замењено изменом улога)';
$string['respondent'] = 'Испитаник';
$string['respondenteligibleall'] = 'сви';
$string['respondenteligiblestudents'] = 'само полазници';
$string['respondenteligibleteachers'] = 'само предавачи';
$string['respondents'] = 'Испитаници';
$string['respondenttype'] = 'Тип испитаника';
$string['respondenttype_help'] = 'Можете да прикажете пуна имена ваших корисника, заједно са њиховим одговором, тако што ће те ово подесити на "пуно име".
Можете, такође, да сакријете идентитет корисника, тако што ће те ово подесити на "анонимно".';
$string['respondenttype_link'] = 'mod/questionnaire/mod#Respondent_Type';
$string['respondenttypeanonymous'] = 'анонимно';
$string['respondenttypefullname'] = 'пуно име';
$string['response'] = 'Одговор';
$string['responsefieldlines'] = 'Величина поља за унос';
$string['responseformat'] = 'Формат одговора';
$string['responseoptions'] = 'Опције одговора';
$string['responses'] = 'Одговори';
$string['responseview'] = 'Студенти могу да виде СВЕ одговоре';
$string['responseview_help'] = 'Можете да одредите ко може да виде одговоре свих испитаника (опште статистичке табеле)';
$string['responseview_link'] = 'mod/questionnaire/mod#Response_viewing';
$string['responseviewstudentsalways'] = 'Увек';
$string['responseviewstudentsnever'] = 'Никад';
$string['responseviewstudentswhenanswered'] = 'Након предаје попуњеног упитника';
$string['responseviewstudentswhenclosed'] = 'Након што је упитник затворен';
$string['restrictedtoteacher'] = 'Ове функције су ограничене само на предаваче са уређивачким правима!';
$string['resume'] = 'Сачувај/Настави одговоре';
$string['resume_help'] = 'Подешавање ове опције дозвољава корисницима да сачувају своје одговоре на упитника пре него што га предају.
Корисници могу да оставе упитник незавршен, и да касније наставе са одговарањем на преостали део упитника.';
$string['resume_link'] = 'mod/questionnaire/mod#Save/Resume_answers';
$string['resumesurvey'] = 'Настави попуњавање упитника';
$string['return'] = 'Повратак';
$string['rightlabel'] = 'Натпис на десној страни';
$string['rightpart'] = 'и {$a->max} је {$a->rightlabel}';
$string['rightpartdefault'] = 'a {$a->max} је максималан опсег клизне скале';
$string['save'] = 'Сачувај';
$string['save_and_exit'] = 'Сачувајте и изађите';
$string['saveasnew'] = 'Сачувај као ново питање';
$string['savedbutnotsubmitted'] = 'Овај упитник ће бити сачуван али не и предат.';
$string['savedprogress'] = 'Одговори које сте до сада дали су сачувана. Можете се вратити у било ком тренутку да завршите овај упитник.';
$string['saveeditedquestion'] = 'Сачувај питање {$a}';
$string['savesettings'] = 'Сачувај подешавања';
$string['search:activity'] = 'Упитник (Questionnaire) - информације о активности';
$string['search:question'] = 'Упитник (Questionnaire) - питања';
$string['section'] = 'Опис';
$string['sectionbreak'] = '----- Прелом странице -----';
$string['sectionbreak_help'] = '----- Прелом странице -----';
$string['sectionsnotset'] = 'Морате одабрато најмење ЈЕДНО питење по секцији! <br />Секција(е) које нису изабране: {$a}';
$string['sectiontext'] = 'Натпис';
$string['sectiontext_help'] = 'Ово није питање већ (кратак) текст који ће бити приказан као увод у серију питања.';
$string['selecttheme'] = 'Изаберите тему (css) која ће се користити са овим упитником.';
$string['send'] = 'Пошаљи';
$string['send_message'] = 'Пошаљи поруку изабраним корисницима';
$string['send_message_to'] = 'Пошаљи поруку:';
$string['sendemail'] = 'Пошаљи е-поруку';
$string['sendemail_help'] = 'Шаље копију сваког испуњеног упитника на наведену адресу или адресе. Можете навести више од једне адресе, тако што ћете их раздвојити зарезима.
Оставите празно ако нема резервне копије е-поште. Опција \'allowemailreporting\' мора бити омогућена у подешавањима модула како бисте овоме приступили.';
$string['set'] = 'подеси';
$string['settings'] = 'Подешавања';
$string['settingssaved'] = 'Подешавања су сачувана';
$string['show_nonrespondents'] = 'Испитаници који нису одговорили.';
$string['slider'] = 'Клизач';
$string['slider_help'] = 'Питање са клизачем омогућава испитаницима да изаберу вредност из непрекидног опсега превлачењем клизача између две екстремне вредности. Централна вредност се такође може подесити.';
$string['started'] = 'започето';
$string['startingvalue'] = 'Почетна вредност клизача';
$string['startingvalue_help'] = 'Почетна вредност клизача одређује где би се клизач прво требао појавити за испитанике. Подразумевано је да почетна вредност буде 1 јер је опсег непознат. Можда ћете желети да га клизач поставите у центар скале тако што ћете му дати средњу вредност (опсег од 1-100 има средњу вредност од 50).';
$string['stepvalue'] = 'Инкрементна вредност клизача';
$string['stepvalue_help'] = 'Инкрементна вредност клизача одређује колико прецизно желите да испитаници назначе свој одговор на скали. Питање је подразумевано подешено на опсег од 1-100 са инкрементном вредношћу један, што омогућава испитаницима да у својим одговорима дају вредности од 70, 71, 72, 73, 74 итд. Али, уместо тога можете да подесите ову вредност на пет, што ће испитаницима омогућити да дају вредности од 60, 65, 70, 75, 80 итд., или чак само опсег од 1-10 са инкрементном вредношћу 1.';
$string['strfdate'] = '%d/%m/%Y';
$string['strfdateformatcsv'] = 'd/m/Y H:i:s';
$string['strictdateformatting'] = 'Унесите датум користећи доњи бирач датума.';
$string['subject'] = 'Предмет';
$string['submissionnotificationhtmlanon'] = 'Постоји нови <a href="{$a->submissionurl}">одговор</a> на упитник "{$a->name}".';
$string['submissionnotificationhtmluser'] = '<a href="{$a->profileurl}">{$a->username}</a> предао/ла је <a href="{$a->submissionurl}">одговоре</a> на упитник  "{$a->name}" на курсу "{$a->coursename}".';
$string['submissionnotificationsubject'] = 'Предаја новопопуњеног упитника';
$string['submissionnotificationtextanon'] = 'Постоји нови одговор ({$a->submissionurl}) на упитник "{$a->name}".';
$string['submissionnotificationtextuser'] = '{$a->username} ({$a->profileurl}) предао/ла је одговоре ({$a->submissionurl}) на упитник "{$a->name}" на курсу "{$a->coursename}".';
$string['submitoptions'] = 'Опције за предају';
$string['submitpreview'] = 'Преглед предатог упитника';
$string['submitpreviewcorrect'] = 'Овај предати упитник биће прихваћен као исправно попуњен.';
$string['submitsurvey'] = 'Предај упитник';
$string['submitted'] = 'Предато дана:';
$string['subtitle'] = 'Поднаслов';
$string['subtitle_help'] = 'Поднаслов овог упитника. Појављује се испод наслова само на првој страни.';
$string['summary'] = 'Резиме';
$string['summaryreportattached'] = 'Извештај о резимеу упитника у прилогу';
$string['surveynotexists'] = 'упитник не постоји.';
$string['surveyowner'] = 'Морате да будете власник упитника како бисте извели ову операцију.';
$string['surveyresponse'] = 'Одговор из упитника';
$string['template'] = 'Шаблон';
$string['templatenotviewable'] = 'Шаблони упитника нису видљиви.';
$string['text'] = 'Текст питања';
$string['textareacolumns'] = 'Колоне поља за унос текста';
$string['textareacolumns_help'] = 'Овај тип питања приказује обично поље за унос текста са **x**  *колона* (*ширина* поља за унос) и **y** *редова* (број *линија* текста).
Уколико оставите оба подешавања на подразумеваних **0** (или их сами подесите на ту вредност), онда ће бити приказан HTML едитор стандардне висине и ширине (ако је доступан у контексту курса/корисника и у корисничком профилу).';
$string['textarearows'] = 'Редови поља за унос текста';
$string['textbox'] = 'Поље за унос текста';
$string['textbox_help'] = 'За питање типа "Поље за унос текста", упишите дужину поља за унос и максималну дужину текста који испитаник треба да унесе.
Подразумеване вредности су 20 знакова за ширину поља за унос и 25 знакова за максималну дужину унетог текста.';
$string['textdownloadoptions'] = 'Опције за преузимање CSV датотеке';
$string['thank_head'] = 'Хвала што сте попунили овај упитник.';
$string['theme'] = 'Тема';
$string['thismonth'] = 'овог месеца';
$string['thisresponse'] = 'Овај одговор';
$string['thisweek'] = 'ове седмице';
$string['thousands'] = 'Немојте користити знак за раздвајање хиљада.';
$string['title'] = 'Наслов';
$string['title_help'] = 'Наслов упитника који ће се појавити на врху сваке странице. Стандардно, наслов одговара називу упитника, али можете да га променити према сопственом нахођењу.';
$string['today'] = 'данас';
$string['total'] = 'Укупно';
$string['totalofnumbers'] = 'Укупан број унетих бројева';
$string['totalresponses'] = 'Укупан број одговора на питање';
$string['type'] = 'Тип питања';
$string['unanswered'] = 'Без одговора';
$string['undefinedquestiontype'] = 'Недефинисан тип питања!';
$string['unknown'] = 'Непознато';
$string['unknownaction'] = 'Наведена је непозната акција упитника...';
$string['url'] = 'URL адреса за потврду';
$string['url_help'] = 'URL адреса на коју ће корисник бити преусмерен након што заврши упитник';
$string['useprivate'] = 'Копирај постојећи';
$string['usepublic'] = 'Користи јавни';
$string['usetemplate'] = 'Користи шаблон';
$string['vertical'] = 'Вертикално';
$string['view'] = 'Преглед';
$string['viewallresponses'] = 'Преглед свих одговора';
$string['viewallresponses_help'] = 'Ако је упитник подешен на **Групни режим**:*Видљиве групе*, или на *Одвојене групе*, и ако тренутни корисник има могућност *moodle/site:accessallgroups* (у текућем контексту), као и ако су групе дефинисане у текућем курсу, онда ће корисник имати приступ падајућем менију са групама. Овај мени омогућава корисницима да "филтрирају" одговоре на упитник према групама.
Ако је **Групни режим** подешен на *Одвојене групе*, онда ће корисници који имају могућност *moodle/site:accessallgroups* (обично полазници, предавачи без уређивачких права итд.) моћи да виде само одговоре групе(а) којима припадају.';
$string['viewallresponses_link'] = 'Viewing_Questionnaire_responses#Group_filtering';
$string['viewbyresponse'] = 'Списак одговора';
$string['viewindividualresponse'] = 'Појединачни одговори';
$string['viewindividualresponse_help'] = 'Кликни на имена испитаника са доње листе за преглед њихових појединачних одговора.';
$string['viewresponses'] = 'Сви одговори ({$a})';
$string['viewyourresponses'] = 'Погледајте свој(е) одговор(е)';
$string['warning'] = 'Упозорење, дошло је до грешке.';
$string['where'] = 'где';
$string['wronganswers'] = 'Нешто није у реду са вашим одговорима (види испод)';
$string['wrongdateformat'] = 'Унети датум: <strong>{$a}</strong> не одговара формату који је приказан у примеру.';
$string['wrongdaterange'] = 'ГРЕШКА! Година мора да буде подешена у распону између 1902. и 2037.';
$string['wrongformat'] = 'Нешто није у реду са вашим одговором на питање:&nbsp;';
$string['wrongformats'] = 'Нешто није у реду са вашим одговорима на питања:&nbsp;';
$string['yesno'] = 'Да/Не';
$string['yesno_help'] = 'Једноставно Да/Не питање';
$string['yourresponse'] = 'Погледајте свој(е) одговор(е)';
$string['yourresponses'] = 'Погледајте свој(е) одговор(е)';
