<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'cachestore_redis', language 'sr_lt', version '4.4'.
 *
 * @package     cachestore_redis
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['ca_file'] = 'Putanja CA datoteke';
$string['ca_file_help'] = 'Lokacija CA datoteke na lokalnom sistemu datoteka';
$string['clustermode'] = 'Cluster režim';
$string['clustermode_help'] = 'Ako uključite ovu opciju, biće pokrenuta Redis Cluster funkcija, koja omogućava vašem serveru da opslužuje više servera za simultano upravaljanje istovremenim zahtevima.';
$string['clustermodeunavailable'] = 'Redis Cluster trenutno nije dostupan. Proverite da li PHP Redis ekstenzija podržava Redis Cluster funkcionalnost.';
$string['compressor_none'] = 'Nema kompresije.';
$string['compressor_php_gzip'] = 'Upotrebi gzip kompresiju';
$string['compressor_php_zstd'] = 'Upotrebi Zstandard kompresiju';
$string['connectiontimeout'] = 'Vreme isteka veze';
$string['connectiontimeout_help'] = 'Ovo podešava vremensko ograničenje kada pokušavate da se povežete sa Redis serverom.';
$string['encrypt_connection'] = 'Koristite TLS enkripciju.';
$string['encrypt_connection_help'] = 'Koristite TLS da biste se povezali sa Redis-om. Nemojte koristiti \'tls://\' u nazivu hosta za Redis. Umesto toga koristite ovu opciju.';
$string['password'] = 'Lozinka';
$string['password_help'] = 'Ovo podešava lozinku za Redis server';
$string['pluginname'] = 'Redis (REmote DIctionary Server)';
$string['prefix'] = 'Prefiks ključeva';
$string['prefix_help'] = 'Ovaj prefiks se koristi za sve nazive ključeva na Redis serveru.
* Ako imate samo jednu instancu Moodlea koja koristi ovaj server, možete ostaviti ovu vrednost kao podrazumevanu.
* Zbog ograničenja dužine ključeva, dozvoljeno je najviše 5 znakova.';
$string['prefixinvalid'] = 'Prefiks nije validan. Možete da koristite samo a-z A-Z 0-9-_.';
$string['privacy:metadata:redis'] = 'Dodatak za keširanje Redis kratko čuva podatke, kao deo svoje funkcionalnosti. Ovi podaci se čuvaju na Redis serveru odakle se redovno uklanjaju.';
$string['privacy:metadata:redis:data'] = 'Različiti podaci koji se čuvaju u kešu';
$string['serializer_igbinary'] = 'Igbinary serijalizator';
$string['serializer_php'] = 'Podrazumevani PHP serijalizator';
$string['server'] = 'Server(i)';
$string['server_help'] = 'Ovo podešava naziv domena, IP adresu ili putanju Unix priključka Redis servera koji se koristi.

Neki primeri vrednosti:

* testredis.abc.com - za povezivanje sa Redis serverom pomoću naziva domena (standardni port: 6379).
* testredis.abc.com:1234 - za povezivanje sa Redis serverom pomoću naziva domena sa određenim portom.
* 1.2.3.4 - za povezivanje sa Redis serverom pomoću IP adrese (standardni port: 6379).
* 1.2.3.4:1234 - za povezivanje sa Redis serverom pomoću IP adrese sa određenim portom.
* unix:///var/redis.sock - za povezivanje sa Redis serverom pomoću Unix priključka.
* /var/redis.sock - za povezivanje sa Redis serverom pomoću Unix priključka (alternativni format).
* ako je režim klastera omogućen, navedite servere odvojene novim redom:<br>
  172.23.0.11<br>
  172.23.0.12<br>
  172.23.0.13<br>

Za više informacija pogledajte <a href="https://redis.io/docs/reference/clients/#accepting-client-connections">Accepting Client Connections</a> i <a href="https://redis.io/resources/clients/#php" target="_new">Redis PHP clients</a>.';
$string['task_ttl'] = 'Čišćenje memorije koju koriste istekli unosi u Redis keš memoriji';
$string['test_clustermode'] = 'Cluster režim';
$string['test_clustermode_desc'] = 'Omogućite Test u Redis Cluster režimu.';
$string['test_password'] = 'Lozinka za test server';
$string['test_password_desc'] = 'Lozinka za Redis test server';
$string['test_serializer'] = 'Serijalizator';
$string['test_serializer_desc'] = 'Serijalizator koji će se koristiti za testiranje.';
$string['test_server'] = 'Test server';
$string['test_server_desc'] = 'Redis server za testiranje.

Neki primeri vrednosti:

* testredis.abc.com - za povezivanje sa Redis serverom pomoću naziva domena (standardni port: 6379).
* testredis.abc.com:1234 - za povezivanje sa Redis serverom pomoću naziva domena sa određenim portom.
* 1.2.3.4 - za povezivanje sa Redis serverom pomoću IP adrese (standardni port: 6379).
* 1.2.3.4:1234 - za povezivanje sa Redis serverom pomoću IP adrese sa određenim portom.
* unix:///var/redis.sock - za povezivanje sa Redis serverom pomoću Unix priključka.
* /var/redis.sock - za povezivanje sa Redis serverom pomoću Unix priključka (alternativni format).

Ako je režim klastera omogućen, navedite servere odvojene novim redom, na primer:<br>
  172.23.0.11<br>
  172.23.0.12<br>
  172.23.0.13<br>

Za više informacija pogledajte <a href="https://redis.io/docs/reference/clients/#accepting-client-connections">>Cepting Client Connections</a> i <a href="https://redis.io/resources/clients/#php">>Redis PHP clients</a>.';
$string['test_ttl'] = 'Testiranje TTL';
$string['test_ttl_desc'] = 'Pokreće testiranje performansi koristeći keš koji zahteva TTL';
$string['usecompressor'] = 'Koristi kompresor';
$string['usecompressor_help'] = 'Određuje kompresor koji će se koristiti nakon serijalizacije. To se radi na Moodle Cache API nivou, a ne na nivou php-redisa.';
$string['useserializer'] = 'Koristi serijalizator';
$string['useserializer_help'] = 'Određuje serijalizator koji će se koristiti za serijalizaciju. Važeći serijalizatori su Redis::SERIALIZER_PHP ili Redis::SERIALIZER_IGBINARY. Ovaj drugi je podržan samo kada je phpredis konfigurisan sa opcijom --enable-redis-igbinary i kada je ekstenzija igbinary učitana.';
