<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_essential', language 'sr_lt', version '4.4'.
 *
 * @package     theme_essential
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['above'] = 'Iznad';
$string['activitynavigationposition'] = 'Pozicija navigacije za aktivnosti';
$string['activitynavigationpositiondesc'] = 'Izaberite između opcija \'Iznad\' i \'Ispod\', gde \'Iznad\' znači da se navigacija nalazi iznad aktivnosti, dok \'Ispod\' podrazumeva da se navigacija nalazi ispod aktivnosti. Ako želite da koristite prilagođeni CSS onda upotrebite selektor \'#activitynavigation\'.';
$string['advert_alttext'] = 'Theme Design Level 1 reklamni baner';
$string['advert_heading'] = 'Theme Design Level 1';
$string['advert_tagline'] = 'Ako želite da naučite kako da prilagodite temu, ali nemate iskustvo sa PHP-om ili razvojem Moodle tema, onda je \'MoodleBites Theme Design Level 1\' za vas! On će vam dati jednostavan uvod u razvoj Moodle tema i pružiti dobru osnovu ako budete hteli da nastavite dalje. Kliknite ovde za više informacija.';
$string['aftercontent'] = 'Nakon sadržaja';
$string['alert1'] = 'Prvo važno obaveštenje';
$string['alert2'] = 'Drugo važno obaveštenje';
$string['alert3'] = 'Treće važno obaveštenje';
$string['alert_edit'] = 'Uredi važna obaveštenja';
$string['alert_general'] = 'Najava';
$string['alert_info'] = 'Informacije';
$string['alert_warning'] = 'Upozorenje';
$string['alertinfodesc'] = 'Unesite podešavanja za vaše važno obaveštenje.';
$string['alertsdesc'] = 'Ovo će vašim korisnicima prikazati važno obaveštenje/a na naslovnoj stranici Moodlea. Nemojte zaboravite da ih isključite kada vam više nisu potrebna.';
$string['alertsheading'] = 'Važno obaveštenje korisnicima';
$string['alertsheadingsub'] = 'Prikažite važne poruke vašim korisnicima na naslovnoj stranici';
$string['alerttext'] = 'Tekst važnog obaveštenja';
$string['alerttextdesc'] = 'Kako glasi tekst koji želite da prikažete u važnom obaveštenju.';
$string['alerttitle'] = 'Naslov';
$string['alerttitledesc'] = 'Glavni naslov vašeg važnog obaveštenja.';
$string['alerttype'] = 'Nivo';
$string['alerttypedesc'] = 'Podesite odgovarajući nivo/tip važnog obaveštenja kako biste najbolje informisali svoje korisnike.';
$string['allclasses'] = 'Svi časovi';
$string['allcourses'] = 'Svi kursevi';
$string['allmodules'] = 'Svi moduli';
$string['allunits'] = 'Sve jedinice';
$string['alternativecolors'] = 'Alternativne boje {$a}';
$string['alternativethemecolor'] = 'Alternativna boja teme {$a}';
$string['alternativethemecolordesc'] = 'Koje boje treba da bude vaša tema za alternativne boje teme {$a}.';
$string['alternativethemecolorname'] = 'Naziv alternativnog skupa boja {$a}';
$string['alternativethemecolornamedesc'] = 'Unesite prepoznatljiv naziv za ovaj skup alternativnih boja teme';
$string['alternativethemecolors'] = 'Alternativne boje teme';
$string['alternativethemecolorsdesc'] = 'Definiše alternativne boje teme koje korisnik može da izabere.';
$string['alternativethemedefaultbuttonbackgroundcolour'] = 'Boja pozadine standardnog dugmeta {$a}';
$string['alternativethemedefaultbuttonbackgroundcolourdesc'] = 'Podesite boju pozadine za svu standardnu dugmad {$a}.';
$string['alternativethemedefaultbuttonbackgroundhovercolour'] = 'Lebdeća boja pozadine standardnog dugmeta {$a}';
$string['alternativethemedefaultbuttonbackgroundhovercolourdesc'] = 'Podesite lebdeću boju pozadine za svu standardnu dugmad {$a}.';
$string['alternativethemedefaultbuttontextcolour'] = 'Boja teksta standardnog dugmeta {$a}';
$string['alternativethemedefaultbuttontextcolourdesc'] = 'Podesite boju teksta za svu standardnu dugmad {$a}.';
$string['alternativethemedefaultbuttontexthovercolour'] = 'Lebdeća boja teksta standardnog dugmeta {$a}';
$string['alternativethemedefaultbuttontexthovercolourdesc'] = 'Podesite lebdeću boju teksta za svu standardnu dugmad {$a}.';
$string['alternativethemefooterblockbackgroundcolour'] = 'Boja pozadine bloka podnožja za alternativne boje teme {$a}';
$string['alternativethemefooterblockbackgroundcolourdesc'] = 'Podesite boju za pozadinu bloka u podnožju stranice za alternativne boje teme {$a}.';
$string['alternativethemefooterblockhovercolour'] = 'Lebdeća boja linka bloka podnožja za alternativne boje teme {$a}';
$string['alternativethemefooterblockhovercolourdesc'] = 'Podesite boju za tekst linkova bloka u podnožju stranice kada se mišem pređe preko njih za alternativne boje teme {$a}.';
$string['alternativethemefooterblocktextcolour'] = 'Boja teksta bloka podnožja za alternativne boje teme {$a}';
$string['alternativethemefooterblocktextcolourdesc'] = 'Podesite boju teksta bloka u podnožju stranice za alternativne boje teme {$a}.';
$string['alternativethemefooterblockurlcolour'] = 'Boja linka bloka podnožja za alternativne boje teme {$a}';
$string['alternativethemefooterblockurlcolourdesc'] = 'Podesite boju za tekst linkova bloka u podnožju stranice za alternativne boje teme {$a}.';
$string['alternativethemefootercolor'] = 'Boja pozadine podnožja stranice za alternativne boje teme {$a}';
$string['alternativethemefootercolordesc'] = 'Podesite koje boje treba da bude podnožje stranice za alternativne boje teme {$a}.';
$string['alternativethemefooterheadingcolor'] = 'Boja zaglavlja podnožja stranice za alternativne boje teme {$a}';
$string['alternativethemefooterheadingcolordesc'] = 'Podesite boju za zaglavlje podnožja stranice za alternativne boje teme {$a}.';
$string['alternativethemefooterhovercolor'] = 'Lebdeća boja linka podnožja za alternativne boje teme {$a}';
$string['alternativethemefooterhovercolordesc'] = 'Podesite boju za tekst linkova u podnožju stranice kada se mišem pređe preko njih za alternativne boje teme {$a}.';
$string['alternativethemefootersepcolor'] = 'Boja graničnika podnožja za alternativne boje teme {$a}.';
$string['alternativethemefootersepcolordesc'] = 'Graničnici su linije koje se koriste za razdvajanje sadržaja. Podesite ovde njihovu boju za alternativne boje teme {$a}.';
$string['alternativethemefootertextcolor'] = 'Boja teksta podnožja za alternativne boje teme {$a}.';
$string['alternativethemefootertextcolordesc'] = 'Podesite boju teksta u podnožju stranice za alternativne boje teme {$a}.';
$string['alternativethemefooterurlcolor'] = 'Boja linka podnožja za alternativne boje teme {$a}.';
$string['alternativethemefooterurlcolordesc'] = 'Podesite boju za tekst linkova u podnožju stranice za alternativne boje teme {$a}.';
$string['alternativethemehovercolor'] = 'Alternativna lebdeća boja teme {$a}';
$string['alternativethemehovercolordesc'] = 'Koja boje treba da bude lebdeća boja u vašoj temi za alternativne boje teme {$a}.';
$string['alternativethemeiconcolor'] = 'Alternativna boja ikonice {$a}';
$string['alternativethemeiconcolordesc'] = 'Podesite alternativnu boju {$a} za sve ikonice.';
$string['alternativethememycoursesorderenrolbackcolour'] = 'Alternativna boja pozadine {$a} za upisane kurseve kojima korisnik još nije pristupio';
$string['alternativethememycoursesorderenrolbackcolourdesc'] = 'Podesite alternativnu boju pozadine {$a} za upisane kurseve kojima korisnik još nije pristupio, kada je \'Redosled sortiranja kurseva\' podešen na \'Vreme poslednjeg pristupa…\'';
$string['alternativethemename'] = 'Naziv šeme boja';
$string['alternativethemenamedesc'] = 'Unesite naziv za vaše alternativne boje teme';
$string['alternativethemenavcolor'] = 'Boja teksta u traci za navigaciju {$a}';
$string['alternativethemenavcolordesc'] = 'Podesite alternativnu boju  {$a} za tekst u traci za navigaciju.';
$string['alternativethemequizsubmitbackgroundcolour'] = 'Boja pozadine dugmeta \'Predaj sve odgovore i završi test\' {$a}';
$string['alternativethemequizsubmitbackgroundcolourdesc'] = 'Podesite alternativnu boju {$a} pozadine za dugme \'Predaj sve odgovore i završi test\'.';
$string['alternativethemequizsubmitbackgroundhovercolour'] = 'Lebdeća boja pozadine dugmeta \'Predaj sve odgovore i završi test\' {$a}';
$string['alternativethemequizsubmitbackgroundhovercolourdesc'] = 'Podesite alternativnu lebdeću boju {$a} pozadine za dugme \'Predaj sve odgovore i završi test\'.';
$string['alternativethemequizsubmittextcolour'] = 'Boja teksta dugmeta \'Predaj sve odgovore i završi test\' {$a}';
$string['alternativethemequizsubmittextcolourdesc'] = 'Podesite alternativnu boju teksta {$a} za dugme \'Predaj sve odgovore i završi test\'.';
$string['alternativethemequizsubmittexthovercolour'] = 'Lebdeća boja teksta dugmeta \'Predaj sve odgovore i završi test\' {$a}';
$string['alternativethemequizsubmittexthovercolourdesc'] = 'Podesite alternativnu lebdeću boju teksta {$a} za dugme \'Predaj sve odgovore i završi test\'.';
$string['alternativethemesidepreblockbackgroundcolour'] = 'Alternativna {$a} boja pozadine bloka s leve strane';
$string['alternativethemesidepreblockbackgroundcolourdesc'] = 'Podesite alternativnu {$a} boju pozadine za blok s leve strane.';
$string['alternativethemesidepreblockhovercolour'] = 'Alternativna {$a} lebdeća boja linka bloka s leve strane';
$string['alternativethemesidepreblockhovercolourdesc'] = 'Podesite alternativnu {$a} lebdeću boju linka za blok s leve strane.';
$string['alternativethemesidepreblocktextcolour'] = 'Alternativna {$a} boja teksta bloka s leve strane';
$string['alternativethemesidepreblocktextcolourdesc'] = 'Podesite alternativnu {$a} boju teksta za blok s leve strane.';
$string['alternativethemesidepreblockurlcolour'] = 'Alternativna {$a} boja linka bloka s leve strane';
$string['alternativethemesidepreblockurlcolourdesc'] = 'Podesite alternativnu {$a} boju linka za blok s leve strane.';
$string['alternativethemeslidebuttoncolor'] = 'Alternativna boja dugmeta na slajdu {$a}';
$string['alternativethemeslidebuttoncolordesc'] = 'Koja boje treba da bude boja dugmeta na slajdu u vašoj temi za alternativne boje teme {$a}.';
$string['alternativethemeslidebuttonhovercolor'] = 'Alternativna lebdeća boja dugmeta na slajdu {$a}';
$string['alternativethemeslidebuttonhovercolordesc'] = 'Koja bi trebalo da bude vaša lebdeća boja dugmeta na slajdu za alternativne boje teme {$a}.';
$string['alternativethemeslidecaptionbackgroundcolor'] = 'Alternativna boja pozadine natpisa na slajdu {$a}';
$string['alternativethemeslidecaptionbackgroundcolordesc'] = 'Koja boje treba da bude boja pozadine natpisa na slajdu u vašoj temi za alternativne boje teme {$a}. Nije primenjivo ako je za natpis na slajdu izabrana opcija \'Pored\'.';
$string['alternativethemeslidecaptiontextcolor'] = 'Alternativna boja teksta natpisa na slajdu {$a}';
$string['alternativethemeslidecaptiontextcolordesc'] = 'Koja boje treba da bude boja teksta natpisa na slajdu u vašoj temi za alternativne boje teme {$a}. Nije primenjivo ako je za natpis na slajdu izabrana opcija \'Pored\'.';
$string['alternativethemeslidecolors'] = 'Alternativne boje slajdova teme';
$string['alternativethemeslidecolorsdesc'] = 'Definiše alternativne boje slajdova teme koje korisnik može da izabere.';
$string['alternativethemestripebackgroundcolour'] = 'Alternativna boja pozadine pruge {$a}';
$string['alternativethemestripebackgroundcolourdesc'] = 'Podesite alternativnu {$a} boju pozadine za pruge u tabelama';
$string['alternativethemestripetextcolour'] = 'Alternativna boja teksta pruge {$a}';
$string['alternativethemestripetextcolourdesc'] = 'Podesite alternativnu {$a} boju teksta za pruge u tabelama';
$string['alternativethemestripeurlcolour'] = 'Alternativna boja URL linka unutar pruge {$a}';
$string['alternativethemestripeurlcolourdesc'] = 'Podesite alternativnu boju {$a} URL linka unutar pruga u tabelama.';
$string['alternativethemetextcolor'] = 'Alternativna boja teksta {$a}';
$string['alternativethemetextcolordesc'] = 'Podesite svoju alternativnu boju za tekst {$a}.';
$string['alternativethemeurlcolor'] = 'Alternativna boja linka {$a}';
$string['alternativethemeurlcolordesc'] = 'Podesite svoju alternativnu boju za tekst linkova {$a}.';
$string['alwaysdisplay'] = 'Uvek prikaži';
$string['android'] = 'Android (Google Play)';
$string['androiddesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Google Play prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične Moodle Mobile aplikacije (https://play.google.com/store/apps/details?id=com.moodle.moodlemobile)';
$string['androidurl'] = 'Android (Google Play) URL adresa';
$string['asconfigintlower'] = '{$a->value} je manje od donje granice opsega {$a->lower}';
$string['asconfigintnan'] = '{$a->value} nije broj';
$string['asconfigintupper'] = '{$a->value} je veće od gornje granice opsega {$a->upper}';
$string['backtotop'] = 'Nazad na vrh';
$string['badgepreferences'] = 'Bedž';
$string['badgesmi'] = 'Bedževi';
$string['badgesmidesc'] = 'Prikažite stavku menija za bedževe ako korisnik ima sposobnost \'moodle/badges:manageownbadges\' i ako su bedževi omogućeni na nivou sajta.';
$string['beforecontent'] = 'Pre sadržaja';
$string['below'] = 'Ispod';
$string['breadcrumbsimple'] = 'Jednostavan';
$string['breadcrumbstyle'] = 'Stil navigacione putanje';
$string['breadcrumbstyled'] = 'Elegantan';
$string['breadcrumbstyledesc'] = 'Ovde možete da promenite stil navigacione putanje.';
$string['breadcrumbstylednocollapse'] = 'Elegantan bez skupljanja';
$string['breadcrumbthin'] = 'Proređen';
$string['cachesused'] = 'Korišćena keš memorija';
$string['calendarmi'] = 'Kalendar';
$string['calendarmidesc'] = 'Prikažite stavku menija za kalendar ako korisnik ima sposobnost \'moodle/calendar:manageownentries\'.';
$string['categoryctidesc'] = 'Ako je ova opcija uključena, to će vam omogućiti da postavite slike za svaku kategoriju.';
$string['categoryctiheading'] = 'Naslovne slike kategorije kurseva';
$string['categoryctiheadingcategory'] = 'Naslovna slika kategorije kurseva za: {$a->category}';
$string['categoryctiheadingcs'] = 'Konfiguracija naslovnih slika kategorije kurseva';
$string['categoryctiheadingsub'] = 'Koristite slike za predstavljanje vaših kategorija unutar kursa';
$string['categoryctiheight'] = 'Kategorija \'{$a->category}\' - visina naslovne slike kursa';
$string['categoryctiheightdesc'] = 'Visina slike za naslov kursa u kategoriji \'{$a->category}\' između {$a->lower} i {$a->upper} piksela. Nemojte dodavati \'px\' na kraju, već samo unesite broj.';
$string['categoryctiinfo'] = 'Podešavanje kategorije {$a->category}';
$string['categoryctiinfodesc'] = 'Podešavanja naslovne slike kategorije kurseva za: {$a->category}.';
$string['categoryctimage'] = 'Kategorija \'{$a->category}\' - datoteka naslovne slike kursa';
$string['categoryctimagedesc'] = 'Slika datoteke za naslov kursa u kategoriji \'{$a->category}\'.';
$string['categoryctimageurl'] = 'Kategorija \'{$a->category}\' - URL adresa naslovne slike kursa';
$string['categoryctimageurldesc'] = 'URL adresa slike za naslov kursa u kategoriji \'{$a->category}\'. Ako je datoteka postavljena onda će to zameniti ovo podešavanje.';
$string['categoryctitextbackgroundcolour'] = 'Kategorija \'{$a->category}\' - boja pozadine teksta naslova kursa';
$string['categoryctitextbackgroundcolourdesc'] = 'Boja pozadine teksta za naslov kursa u kategoriji \'{$a->category}\'.';
$string['categoryctitextbackgroundopacity'] = 'Kategorija \'{$a->category}\' - neprozirnost pozadine teksta naslova kursa';
$string['categoryctitextbackgroundopacitydesc'] = 'Neprozirnost pozadine teksta za naslova kursa u kategoriji \'{$a->category}\'.';
$string['categoryctitextcolour'] = 'Kategorija \'{$a->category}\' - boja teksta naslova kursa';
$string['categoryctitextcolourdesc'] = 'Boja teksta za naslov kursa u kategoriji \'{$a->category}\'.';
$string['categoryiconcategory'] = 'Ikonica za kategoriju: {$a->category}.';
$string['categoryicondesc'] = 'Ako omogućena ova opcija će vam dozvoliti da podesite ikonice za svaku kategoriju kursa.';
$string['categoryiconheading'] = 'Ikonice kategorija';
$string['categoryiconheadingsub'] = 'Koristite ikonice za prikazivanje vaših kategorija';
$string['categoryiconinfo'] = 'Podesite prilagođene ikonice kategorija';
$string['categoryiconinfodesc'] = 'Unesite naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza "fa-".';
$string['categoryimagecategory'] = 'Slika za kategoriju: {$a->category}.';
$string['categoryincoursebreadcrumbfeature'] = 'Kategorije u navigacionoj putanji kursa';
$string['categoryincoursebreadcrumbfeaturedesc'] = 'Prikažite link kategorije u navigacionoj putanji kursa.';
$string['ccd'] = 'Datum kreiranja kursa';
$string['ced'] = 'Datum završetka kursa';
$string['cfn'] = 'Pun naziv kursa';
$string['choosereadme'] = '<div class="clearfix">
<div class="well">
<h2>Essential</h2>
<p><img class="img-polaroid" src="essential/pix/screenshot.jpg" alt="Essential screen shot"/></p>
</div>
<div class="well">
<h3>O temi Essential</h3>
<p>Essential  se zasniva na temi Bootstrap, koja je kreirana za Moodle 2.5. Kreiranje teme su pomogli:<br>
Bas Brands, Stuart Lamour, Mark Aberdour, Paul Hibbitts, Mary Evans.</p>
<h3>Zasluge za temu</h3>
<p>Originalni autor: Julian Ridden<br>
Od jula 2014 razvoj teme preuzeli su:<br>
Gareth J. Barnard<br>
David Bezemer<br>
Od 9. oktobra 2014 razvoj teme preuzeo je:<br>
Gareth J. Barnard<br>
</p>
<h3>Sponzorstvo</h3>
<p>Ova tema je besplatna. Ukoliko želite da izrazite svoju zahvalnost što je koristite, molimo vas, razmislite o sponzorisanju putem:
<h4>PayPal</h4>
<p>Molim vas, kontaktirajte me putem mog <a href="http://moodle.org/user/profile.php?id=442195" target="_blank">\'Moodle profila\'</a> za više informacije pošto kao pojedinac ne mogu da imam dugme \'Kupi sada\' pod uslovima Pay Pal sistema.</p>
<br>Sponzorstvo će pomoći da se tema lakše održava, kao i da se razviju nove i bolje funkcije. Bez vaše podrške tema se ne može održavati.</p>
<p>
<h3>Sponzori</h3>
<p>Zahvaljujem se na sponzorstvu:</p>
<ul>
<li>Mihai Bojonca, TCM International Institute.</li>
<li>Guido Hornig, actXcellence <a href="//actxcellence.de" target="_blank">actxcellence.de</a></li>
<li>Delvon Forrester, Esparanza co uk</li>
<li>iZone</li>
<li>Anis Jradah</li>
<li>Ute Hlasek, <a href="//hlasek-it.de/moodle" target="_blank">hlasek-it.de/moodle</a></li>
</ul>
</p>
<p>
<h3>Razvoj teme Essential za Moodle 3.3 sponzorisali su:</h3>
<ul>
<li>ClassroomRevolution, LLC -- Moodle Partner</li>
<li>Daniel Méthot - e-learning-facile.com/formations/</li>
<li>Floyd Saner, Learning Contexts, LLC</li>
<li>Gemma Lesterhuis</li>
<li>Mihai Bojonca, TCM International Institute</li>
</ul>
</p>
<h3>Prilagođavanje</h3>
<p>Ako vam se ova tema sviđa i ukoliko želite da je prilagodim, prebacim njene funkcije u drugu temu, razvijem novu temu ispočetka ili kreiram podređenu temu, onda vam nudim razumne cene. Molim vas, kontaktirajte me putem \'http://moodle.org/user/profile.php?id=442195\' kako bismo razmotrili vaše zahteve.</p>
</div></div>';
$string['cid'] = 'ID oznaka kursa';
$string['colordesc'] = 'Ovde možete naći različita podešavanja za promenu mnogih boja u ovoj temi.';
$string['colorheading'] = 'Boje';
$string['colorheadingsub'] = 'Podesite boje koje se koriste u vašoj temi';
$string['configtitle'] = 'Essential';
$string['contactinfo'] = 'Kontakt informacije';
$string['contactinfodesc'] = 'Upišite svoje kontakt informacije';
$string['copyright'] = 'Autorsko pravo';
$string['copyrightdesc'] = 'Naziv vaše institucije/organizacije.';
$string['coursecategorysettingstitle'] = 'Podešavanja kategorije kurseva';
$string['coursecontentsearch'] = 'Pretraga sadržaja kursa';
$string['coursecontentsearchdesc'] = 'Omogućite pretragu sadržaja kursa na stranici \'Kontrolni panel\'. Ovo funkcioniše samo kada tema Essential nije navedena u \'$CFG->themedir\'.';
$string['coursecontentsearchsortattribute'] = 'Atribut sortiranja rezultata pretrage kursa';
$string['coursecontentsearchsortattributedesc'] = 'Sortirajte rezultate pretrage prema ovom atributu.';
$string['coursecontentsearchsortorder'] = 'Redosled sortiranja pretrage kompletnog sadržaja kursa';
$string['coursecontentsearchsortorderdesc'] = 'Sortirajte rezultate pretrage opadajućim ili rastućim redosledom.';
$string['coursegrades'] = 'Ocene na kursu';
$string['coursegradesmi'] = 'Ocene na kursu';
$string['coursegradesmidesc'] = 'Prikažite stavku menija za ocene na kursu ako korisnik ima sposobnost \'gradereport/user:view\'  i ako je opcija za prikaz ocena podešena na kursu.';
$string['courselistteachericon'] = 'Ikonica za predavača na spisku kurseva';
$string['courselistteachericondesc'] = 'Naziv ikonice koju želite da koristite ili ostavite prazno. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza  "fa-",", npr.  "star".';
$string['coursesettingstitle'] = 'Podešavanja kursa';
$string['coursetitleposition'] = 'Pozicija naslova kursa';
$string['coursetitlepositiondesc'] = 'Izaberite između opcija \'Iznad\' i \'Unutar\', gde opcija \'Iznad\' znači položaj iznad regiona \'Levo\', \'Vrh stranice\' i \'Sadržaj kursa\', dok opcija \'Unutar\' podrazumeva položaj unutar regiona \'Sadržaj kursa\', kako to je i bilo pre nego što je uvedeno ovo podešavanja.';
$string['csd'] = 'Datum početka kursa';
$string['ctioverride'] = 'Redefinisanje slika kategorija unutar kursa';
$string['ctioverridedesc'] = 'Ako želite da redefinišete naslovnu sliku kategorije kurseva, kada je ovo omogućeno sa podešavanjem \'enablecategorycti\', onda uredite rezime kursa u podešavanjima kursa i dodajte sliku. Onda uredite u HTML režimu - uklonite sve \'p\' i \'br\' oznake, potom uklonite atribute \'style\', \'width\' i \'height\' kao i klase \'classes\' koje je dodao editor teksta uz oznaku \'img\'. Zatim dodajte klasu  \'categorycti\'. Kako biste odredili visinu (u pikselima) kao i boju naslova teksta, boju pozadine i neprozirnost, koristite sledeće atribute: \'ctih\', \'ctit\', \'ctib\' i \'ctio\', na primer:<br/><br/><img src="https://mymoodleinstall.me/pluginfile.php/493/course/section/237/myimage.jpg" alt="Replacement image" class="categorycti" ctih="250" ctit="#afafaf" ctib="#222222" ctio="0.5"><br/><br/>. Ova slika neće biti prikazani u samom rezimeu kada gledate listu kurseva.';
$string['ctioverrideheight'] = 'Standardna redefinisana visina naslovne slike kursa';
$string['ctioverrideheightdesc'] = 'Standardna redefinisana visina slike za naslov kursa između  {$a->lower} i {$a->upper} piksela. Nemojte dodavati \'px\' na kraju, već samo unesite broj.';
$string['ctioverridetextbackgroundcolour'] = 'Standardna redefinisana boja pozadine teksta naslova kursa';
$string['ctioverridetextbackgroundcolourdesc'] = 'Standardna redefinisana boja pozadine teksta za naslov kursa.';
$string['ctioverridetextbackgroundopacity'] = 'Standardna redefinisana neprozirnost pozadine teksta naslova kursa';
$string['ctioverridetextbackgroundopacitydesc'] = 'Standardna redefinisana neprozirnost pozadine teksta za naslova kursa.';
$string['ctioverridetextcolour'] = 'Standardna redefinisana boja teksta naslova kursa';
$string['ctioverridetextcolourdesc'] = 'Standardna redefinisana boja teksta za naslov kursa.';
$string['customcss'] = 'Prilagođeni CSS';
$string['customcssdesc'] = 'CSS pravila koja dodate u ovo polje za tekst odraziće se na izgled svih stranica, što olakšava prilagođavanje ove teme.';
$string['customscrollbars'] = 'Prilagođene klizne trake';
$string['customscrollbarsdesc'] = 'Koristite prilagođene klizne trake za pomeranje sadržaja. Ovo će zameniti standardne klizne trake u veb čitaču.';
$string['dbqueries'] = 'Baza podataka - čitanje/upisivanje';
$string['dbtime'] = 'Vreme upita baze podataka';
$string['defaultcategoryicon'] = 'Podrazumevana ikonica kategorije';
$string['defaultcategoryicondesc'] = 'Podesite podrazumevanu ikonicu kategorije';
$string['defaultcategoryimage'] = 'Podrazumevana slika kategorije';
$string['defaultcategoryimagedesc'] = 'Podesite podrazumevanu sliku kategorije. Kada postavite sliku ona će zameniti ikonicu.';
$string['defaultcolors'] = 'Podrazumevane boje';
$string['displayafterlogin'] = 'Prikaži samo nakon prijave na sistem';
$string['displaybeforelogin'] = 'Prikaži samo pre prijave na sistem';
$string['displayeditingmenu'] = 'Prikaži dugme za uređivanje';
$string['displayeditingmenudesc'] = 'Prikazuje dugme sa istim funkcionalnostima kao standardno dugme za uređivanje stranice u zaglavlju.';
$string['displayhiddenmycourses'] = 'Prikaži sakrivene kurseve';
$string['displayhiddenmycoursesdesc'] = 'Prikazuje sakrivene kurseve korisnicima u \'Meniju kurseva\' ako imaju ovlašćenje da vide sakrivene kurseve.';
$string['displaymycourses'] = 'Prikaži kurseve';
$string['displaymycoursesdesc'] = 'Korisnicima se u navigacionoj traci prikazuju kursevi koje su upisali.';
$string['docking'] = 'Omogući prebacivanja blokova u dok.';
$string['dockingdesc'] = 'Ako je ova opcija omogućena biće dostupno prebacivanje blokova u dok.';
$string['dontdisplay'] = 'Nikad ne prikazuj';
$string['dropdownmenumaxheight'] = 'Maksimalna visina padajućeg menija';
$string['dropdownmenumaxheightdesc'] = 'Maksimalna visina padajućeg menija kada su omogućene klizne trake. Između  {$a->lower} i {$a->upper} piksela.';
$string['dropdownmenuscroll'] = 'Klizne trake na padajućim menijima';
$string['dropdownmenuscrolldesc'] = 'Dodajte kliznu traku padajućem meniju kada je njegova visina ograničena.';
$string['editingmenu'] = 'Prekidač za uređivanje stranice';
$string['editingmenudesc'] = 'Prikazuje dugme za uključivanje/isključivanje uređivanja tekuće stranice ako je korisniku dozvoljeno da uređuje stranicu. Ista funkcionalnost kao i kod običnog dugmeta za uređivanje stranice.';
$string['enablealert'] = 'Uključi važna obaveštenja';
$string['enablealertdesc'] = 'Uključite ili isključite važna obaveštenja';
$string['enablealternativethemecolors'] = 'Omogući alternativne boje teme {$a}';
$string['enablealternativethemecolorsdesc'] = 'Ako je ova opcija omogućena korisnik će moći da izabere alternativne boje teme {$a}.';
$string['enablecategorycti'] = 'Omogući naslovne slike kategorije kurseva';
$string['enablecategoryctics'] = 'Omogući zasebne stranice za sve kategorija za podešavanje naslovne slike kategorije kurseva';
$string['enablecategorycticsdesc'] = 'Ako je omogućeno ovo podešavanje, sve kategorije kurseva najvišeg nivoa imaće sopstvenu stranicu za podešavanje.';
$string['enablecategoryctidesc'] = 'Ako je omogućeno ovo podešavanje, moći ćete da izaberete naslovne slike kategorije kurseva nakon što kliknete na ”Sačuvaj promene”.';
$string['enablecategoryicon'] = 'Omogući ikonice kategorija';
$string['enablecategoryicondesc'] = 'Ako je omogućeno, moći ćete da izaberete ikonice kategorija nakon što kliknete na "Sačuvaj promene".';
$string['enablecustomcategoryicon'] = 'Omogući prilagođene ikonice kategorija';
$string['enablecustomcategoryicondesc'] = 'Ako je ova opcija omogućena. ispod ovog odeljka videćete kategorije sa podesivim opcijama pored svake kategorije. Molimo vas da sačuvate promene nakon što omogućite/onemogućite ovu opciju.';
$string['extperfinfoheading'] = 'Informacije o dodatnim performansama';
$string['facebook'] = 'Facebook URL adresa';
$string['facebookdesc'] = 'Unesite URL adresu vaše Facebook stranice (tj. http://www.facebook.com/mojaskola).';
$string['facebookurl'] = 'Facebook URL adresa';
$string['favicon'] = 'Prilagođena favikonica';
$string['favicondesc'] = 'Postavite sopstvenu favikonicu. To treba da bude .ico datoteka.';
$string['featuredesc'] = 'Ovde možete naći različita podešavanja za promenu mnogih funkcionalnosti koje se nalaze u ovoj temi.';
$string['featureheading'] = 'Funkcionalnosti';
$string['featureheadingsub'] = 'Podesite funkcionalnosti koje se koriste u vašoj temi';
$string['findcoursecontent'] = 'Pretraga kursa:';
$string['fitvids'] = 'Koristi FitVids';
$string['fitvidsdesc'] = 'Omogućite FitVids (fitvidsjs.com) kako bi vaši video snimci bili prilagodljivi. Ako je FitVids uključen, i pritom želite da video snimak bude izuzet, onda u HTML kôd dodajte \'class="fitvidsignore"\' unutar \'iframe\' oznake. Na primer:<iiframe class="fitvidsignore" width="420" height="315" src="//www.youtube.com/embed/enmEmym85xc" frameborder="0" allowfullscreen=""></iframe>.';
$string['fixedwidthnarrow'] = 'Fiksna širina - Usko';
$string['fixedwidthnormal'] = 'Fiksna širina - Normalno';
$string['fixedwidthwide'] = 'Fiksna širina - Široko';
$string['flatnavigation'] = 'Omogući ravnu navigaciju.';
$string['flatnavigationdesc'] = 'Ako je ova opcija omogućena, umesto blokova za navigaciju i administraciju (podešavanja) biće korišćena ravna navigacija.';
$string['flickr'] = 'Flickr URL adresa';
$string['flickrdesc'] = 'Unesite URL adresu vaše Flickr stranice (tj. http://www.flickr.com/mojaskola).';
$string['flickrurl'] = 'Flickr URL adresa';
$string['floatingsubmitbuttons'] = 'Plutajuća dugmad';
$string['floatingsubmitbuttonsdesc'] = 'Ova opcija omogućava korišćenje \'plutajućeg\' regiona koji sadrži dugmad za slanje obrazaca na stonim računarima. Ovo pomaže da se smanji premotavanja sadržaja na nekim stranicama. Ne koristi se za upis na kurs i postove na forumima.';
$string['fontcharacterset'] = 'Dodatan skup karaktera Google fonta';
$string['fontcharactersetcyrillic'] = 'Ćirilica';
$string['fontcharactersetcyrillicext'] = 'Proširena ćirilica';
$string['fontcharactersetdesc'] = 'Izaberite dodatni skupove karaktera za različite jezike.
Kako korišćenje više skupova karaktera može da uspori vaš Moodle izaberite samo one koji su vam stvarno potrebni.';
$string['fontcharactersetgreek'] = 'Grčki alfabet';
$string['fontcharactersetgreekext'] = 'Prošireni grčki alfabet';
$string['fontcharactersetlatinext'] = 'Proširena latinica';
$string['fontcharactersetvietnamese'] = 'Vijetnamski';
$string['fontfileeotbody'] = 'Datoteka osnovnog EOT fonta';
$string['fontfileeotheading'] = 'Datoteka EOT fonta naslova';
$string['fontfileotfbody'] = 'Datoteka osnovnog OTF fonta';
$string['fontfileotfheading'] = 'Datoteka OTF fonta naslova';
$string['fontfiles'] = 'Datoteke fontova';
$string['fontfilesdesc'] = 'Postavite ovde svoje datoteke fontova.';
$string['fontfilesvgbody'] = 'Datoteka osnovnog SVG fonta';
$string['fontfilesvgheading'] = 'Datoteka SVG fonta naslova';
$string['fontfilettfbody'] = 'Datoteka osnovnog TTF fonta';
$string['fontfilettfheading'] = 'Datoteka TTF fonta naslova';
$string['fontfilewoffbody'] = 'Datoteka osnovnog WOFF fonta';
$string['fontfilewoffheading'] = 'Datoteka WOFF fonta naslova';
$string['fontfilewofftwobody'] = 'Datoteka osnovnog WOFF2 fonta';
$string['fontfilewofftwoheading'] = 'Datoteka WOFF2 fonta naslova';
$string['fontheadingdesc'] = 'Izaberite i unesite fontove koje želite da koristite u svom Moodle okruženju.';
$string['fontheadingsub'] = 'Podešavanja fonta';
$string['fontnamebody'] = 'Font teksta';
$string['fontnamebodydesc'] = 'Unesite tačan naziv fonta koji želite da koristite za sav ostali tekst.';
$string['fontnameheading'] = 'Font naslova';
$string['fontnameheadingdesc'] = 'Unesite tačan naziv fonta koji želite da koristite za naslove.';
$string['fontselect'] = 'Birač tipa fonta';
$string['fontselectdesc'] = 'Izaberite sa spiska dostupnih tipova fontova. Molimo sačuvajte kako bi se prikazale opcije za tip fonta koji ste izabrali.';
$string['fontsettings'] = 'Font';
$string['fonttypecustom'] = 'Nestandardni font';
$string['fonttypegoogle'] = 'Google  veb fontovi';
$string['fonttypeuser'] = 'Korisnički fontovi';
$string['footerblockbackgroundcolour'] = 'Boja pozadine bloka podnožja';
$string['footerblockbackgroundcolourdesc'] = 'Podesite boju za pozadinu bloka u podnožju stranice.';
$string['footerblockhovercolour'] = 'Lebdeća boja linka bloka podnožja';
$string['footerblockhovercolourdesc'] = 'Podesite boju za tekst linkova bloka u podnožju stranice kada se mišem pređe preko njih.';
$string['footerblocktextcolour'] = 'Boja teksta bloka podnožja';
$string['footerblocktextcolourdesc'] = 'Podesite boju teksta bloka u podnožju stranice.';
$string['footerblockurlcolour'] = 'Boja linka bloka podnožja';
$string['footerblockurlcolourdesc'] = 'Podesite boju za tekst linkova bloka u podnožju stranice.';
$string['footercolor'] = 'Boja pozadine podnožja';
$string['footercolordesc'] = 'Podesite boju pozadine regiona koji se nalazi u podnožju stranice.';
$string['footercolors'] = 'Boje podnožja';
$string['footercolorsdesc'] = 'Promenite boje podnožja stranice';
$string['footerheading'] = 'Podnožje stranice';
$string['footerheadingcolor'] = 'Boja naslova u podnožju stranice';
$string['footerheadingcolordesc'] = 'Podesite boju za naslove blokova u podnožju stranice.';
$string['footerhovercolor'] = 'Lebdeća boja linka podnožja';
$string['footerhovercolordesc'] = 'Podesite boju za tekst linkova u podnožju stranice kada se mišem pređe preko njih.';
$string['footersepcolor'] = 'Boja separatora u podnožju stranice';
$string['footersepcolordesc'] = 'Separatori su linije koje se koriste da bi se razdvojio sadržaj. Ovde podesite boju za separatore.';
$string['footertextcolor'] = 'Boja teksta u podnožju stranice';
$string['footertextcolordesc'] = 'Podesite boju kojom želite da bude prikazan tekst u podnožju stranice.';
$string['footerurlcolor'] = 'Boja linka u podnožju stranice';
$string['footerurlcolordesc'] = 'Podesite boju za tekst linkova u podnožju stranice.';
$string['footnote'] = 'Podnožje';
$string['footnotedesc'] = 'Sadržaj koji dodate u ovo polje za tekst biće prikazan u podnožju svake stranice vašeg Moodle sajta.';
$string['forumdiscussionsmi'] = 'Diskusije';
$string['forumdiscussionsmidesc'] = 'Prikažite stavku menija za diskusije ako korisnik ima sposobnost \'mod/forum:viewdiscussion\'.';
$string['forumpostsmi'] = 'Poruke na forumima';
$string['forumpostsmidesc'] = 'Prikažite stavku menija za poruke na forumima ako korisnik ima sposobnost \'mod/forum:viewdiscussion\'.';
$string['fppagetopblocks'] = 'Omogući dodatne blokove na naslovnoj stranici u regionu \'Vrh stranice\'';
$string['fppagetopblocksdesc'] = 'Ako je omogućeno ovo podešavanje, na naslovnoj stranici, iznad dela sa sadržajem, biće prikazan dodatni region za blokove. Napomena: broj blokova po jednom redu zavisi od podešavanja \'fppagetopblocksperrow\' (Broj blokova po jednom redu na naslovnoj stranici u regionu \'Vrh stranice\').';
$string['fppagetopblocksperrow'] = 'Broj blokova po jednom redu na naslovnoj stranici u regionu \'Vrh stranice\'';
$string['fppagetopblocksperrowdesc'] = 'Navedite koliko će biti blokova po jednom redu (između {$a->lower} i {$a->upper}) u regionu \'Vrh stranice\' na naslovnoj stranici.';
$string['frontcontent'] = 'Omogući tekstualni blok na naslovnoj stranici';
$string['frontcontentarea'] = 'Sadržaj tekstualnog bloka na naslovnoj stranici';
$string['frontcontentareadesc'] = 'Sadržaj koji unesete u ovaj tekstualni blok biće prikazan čitavom širinom naslovne stranice u prostoru koji se nalazi između slajd prezentacije i promotivnih blokova.';
$string['frontcontentdesc'] = 'Ako je omogućeno, ovo dodaje tekstualni blok za vaš namenski prilagođeni sadržaj, smešten između slajd prezentacije i promotivnih blokova.';
$string['frontcontentheading'] = 'Tekstualni blok na naslovnoj stranici';
$string['frontpageblocks'] = 'Poravnanje blokova na naslovnoj stranici';
$string['frontpageblocksdesc'] = 'Ovde možete odrediti da li su standardni Moodle blokovi na naslovnoj stranici poravnati pre ili posle sadržaja.';
$string['frontpageblocksheading'] = 'Blokovi naslovne stranice';
$string['frontpageheading'] = 'Naslovna stranica';
$string['frontpageheadingdesc'] = 'Podesite ovde koje dodatne stavke želite da prikažete na naslovnoj stranici.';
$string['frontpagehomeblocksperrow'] = 'Broj blokova u regionu \'Početak stranice\' (ranije \'Sredina stranice\')';
$string['frontpagehomeblocksperrowdesc'] = 'Navedite koliko će biti blokova po jednom redu (između {$a->lower} i {$a->upper}) u regionu \'Početak stranice\'.';
$string['frontpagemiddleblocks'] = 'Omogući dodatne blokove na naslovnoj stranici u regionu \'Početak stranice\' (ranije \'Sredina stranice\')';
$string['frontpagemiddleblocksdesc'] = 'Ako je omogućeno, ovo podešavanje će prikazati dodatan region za blokove, odmah ispod promotivnih blokova.';
$string['frontpagesettingstitle'] = 'Podešavanja naslovne stranice';
$string['fullname'] = 'Pun naziv sajta';
$string['fullnamesummary'] = 'Pun naziv sajta i rezime';
$string['generalheadingdesc'] = 'Konfigurišite ovde opšta podešavanja teme.';
$string['generalheadingsub'] = 'Opšta podešavanja';
$string['genericsettings'] = 'Opšte';
$string['googleplus'] = 'Google+ URL adresa';
$string['googleplusdesc'] = 'Unesite URL adresu vašeg Google+ profila (tj. http://plus.google.com/+mojaskola).';
$string['googleplusurl'] = 'Google+ URL adresa';
$string['gotobottom'] = 'Idi na dno stranice';
$string['gotopeople'] = 'Učesnici';
$string['haveheaderblock'] = 'Region blokova \'Zaglavlje\'';
$string['haveheaderblockdesc'] = 'Omogućite region blokova \'Zaglavlje\' odmah ispod navigacione trake.';
$string['headerbackground'] = 'Pozadinska slika zaglavlja';
$string['headerbackgrounddesc'] = 'Postavite svoju sliku pozadine.';
$string['headerbackgroundstyle'] = 'Stil pozadine zaglavlja';
$string['headerbackgroundstyledesc'] = 'Izaberite stil za pozadinu zaglavlja.';
$string['headerblocksperrow'] = 'Broj blokova po jednom redu u regionu \'Zaglavlje\'';
$string['headerblocksperrowdesc'] = 'Navedite koliko će biti blokova po jednom redu (između {$a->lower} i {$a->upper}) na stranicama sa regionom \'Zaglavlje\'.';
$string['headerheading'] = 'Zaglavlje';
$string['headertextcolor'] = 'Boja teksta zaglavlja';
$string['headertextcolordesc'] = 'Podesite boju teksta u zaglavlju.';
$string['headertitle'] = 'Naslov zaglavlja';
$string['headertitledesc'] = 'Podesite ovde naslov koji će se pojaviti u zaglavlju';
$string['helplink'] = 'Link za pomoć';
$string['helplinkdesc'] = 'Ako ste prethodno izabrali opciju "URL adresa" unesite kompletnu URL adresu sajta sa pomoćnim informacijama (adresa mora da sadrži prefiks http:// ili https://). Ako ste izabrali opciju "E-adresa" unesite svoju elektronsku adresu.';
$string['helplinktype'] = 'Omogući link za pomoć u meniju';
$string['helplinktypedesc'] = 'Izaberite da li želite da omogućite opciju za pomoći u korisničkom meniju, Možete da birate između URL adrese sajta sa pomoćnim informacije, koji će se otvarati u novom prozoru, i elektronske adrese.';
$string['hidedefaulteditingbutton'] = 'Sakrij standardno dugme za uređivanje stranice';
$string['hidedefaulteditingbuttondesc'] = 'Sakriva, sa svih stranica, standardno dugme za uređivanje stranice. Ovo podešavanje ima efekta ako je omogućeno podešavanje ”Prikaži dugme za uređivanje”.';
$string['hideonphone'] = 'Sakrij slajd-šou na mobilnim uređajima';
$string['hideonphonedesc'] = 'Izaberite da li želite da onemogućite slajd-šou na mobilnim uređajima.';
$string['hideontablet'] = 'Sakrij slajd-šou na mobilnim tabletima';
$string['hideontabletdesc'] = 'Izaberite da li želite da onemogućite slajd-šou na tabletima.';
$string['hvpcustomcss'] = 'H5P prilagođeni CSS';
$string['hvpcustomcssdesc'] = 'Prilagođeni CSS za H5P modul je (moodle.org/plugins/mod_hvp) instaliran.';
$string['icon'] = 'ikonica';
$string['image'] = 'slika';
$string['included'] = 'Datoteke uključene';
$string['instagram'] = 'Instagram URL adresa';
$string['instagramdesc'] = 'Unesite URL adresu vaše Instagram stranice (tj. http://web.stagram.com/mojaskola/).';
$string['instagramurl'] = 'Instagram URL adresa';
$string['ios'] = 'iPhone/iPad (App Store)';
$string['iosdesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Apple App prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične mobilne aplikacije za Moodle (https://itunes.apple.com/en/app/moodle-mobile/id633359593)..';
$string['iosicon'] = 'Ikonice iOS početnog ekrana';
$string['iosicondesc'] = 'Tema obezbeđuje standardne ikonice za iOS i Android početne ekrane. Ako želite možete postaviti svoje prilagođene ikonice.';
$string['iosurl'] = 'iPhone/iPad (App Store) URL adresa';
$string['ipadicon'] = 'iPad ikonica (Non Retina)';
$string['ipadicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 72 x 72 piksela.';
$string['ipadretinaicon'] = 'iPad ikonica (Retina)';
$string['ipadretinaicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 144 x 144 piksela.';
$string['iphoneicon'] = 'iPhone/iPod Touch ikonica (Non Retina)';
$string['iphoneicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 57 x 57 piksela.';
$string['iphoneretinaicon'] = 'iPhone/iPod Touch ikonica (Retina)';
$string['iphoneretinaicondesc'] = 'Ikonica treba da bude PNG datoteka veličine 114 x 114 piksela.';
$string['layout'] = 'Koristi standardni izgled kursa';
$string['layoutdesc'] = 'Ova teme je dizajnirana tako da oba stupca sa blokovima postavlja sa desne strane. Ukoliko preferirate standardni izgled Moodle kurseva možete da označite ovo polje za potvrdu kako biste koristili stari izgled kursa sa tri stupca.';
$string['left'] = 'Levo';
$string['linkedin'] = 'LinkedIn URL adresa';
$string['linkedindesc'] = 'Unesite URL adresu vašeg LinkedIn profila (tj. http://www.linkedin.com/company/mojaskola).';
$string['linkedinurl'] = 'LinkedIn URL adresa';
$string['loadtime'] = 'Vreme učitavanja';
$string['loggedinas'] = 'prijavljen na sistem kao';
$string['loggedinfrom'] = 'Prijavljen na sistem sa';
$string['loggedinfrommi'] = 'Prijavljen na sistem sa';
$string['loggedinfrommidesc'] = 'Prikažite stavku menija \'Prijavljen na sistem sa\' ako je korisnik MNET udaljeni korisnik.';
$string['loginbackground'] = 'Pozadinska slike stranice za prijavu na sistem';
$string['loginbackgrounddesc'] = 'Postavite sopstvenu pozadinsku sliku na stranici za prijavu na sistem. Izaberite u nastavku stil slike.';
$string['loginbackgroundopacity'] = 'Neprozirnost polja za prijavu kada postoji pozadinska slika';
$string['loginbackgroundopacitydesc'] = 'Nivo neprozirnosti polja za prijavu kada postoji pozadinska slika.';
$string['loginbackgroundstyle'] = 'Stil pozadinske slike stranice za prijavu';
$string['loginbackgroundstyledesc'] = 'Izaberite stil postavljene slike.';
$string['logo'] = 'Logotip';
$string['logodesc'] = 'Postavite ovde prilagođeni logo ukoliko želite da ga dodate u zaglavlje. <br>Veličina slika će biti proporcionalno promenjena tako da se uklopi u raspoloživu procentualnu širinu koja je određena za dole navedeni uređaj. Ako imate puno ikonica društvenih mreža / aplikacija dobro proverite krajnji izgled. <br>Ako postavite logo, on će zameniti standardnu ikonicu i naziv koji se prikazuje kao podrazumevani.';
$string['logodesktopwidth'] = 'Širina logotipa za stone računare';
$string['logodesktopwidthdesc'] = 'Širina kontejnera slike logotipa na stonim računarima , >= 980px.<br>Navedite procenat raspoloživog prostora između {$a->lower} i {$a->upper}.<br>Raspoloživi prostor je širina koju dozvoljava podešavanje \'pagewidth\' Slika će popuniti navedeni procenat do širine njene rezolucije.<br>Napomena! Minimalna visina kontejnera je 64 piksela, pa će, ukoliko je visina slike izračunata kao manja,  ispod nje postojati praznina.';
$string['logodimerror'] = 'je neispravna vrednost. Molimo, navedite jedinicu \'px\' ili \'em\' odmah nakon  jedinične vrednosti, i ništa pre nje.';
$string['logomobilewidth'] = 'Širina logotipa za mobilne uređaje';
$string['logomobilewidthdesc'] = 'Širina kontejnera slike logotipa na stonim računarima , >= 980px.<br>Navedite procenat raspoloživog prostora između {$a->lower} i {$a->upper}.<br>Raspoloživi prostor je širina koju dozvoljava podešavanje \'pagewidth\' Slika će popuniti navedeni procenat do širine njene rezolucije.<br>Napomena! Minimalna visina kontejnera je 52 piksela, pa će, ukoliko je visina slike izračunata kao manja,  ispod nje postojati praznina.';
$string['marketing1'] = 'Promotivni blok jedan';
$string['marketing2'] = 'Promotivni blok dva';
$string['marketing3'] = 'Promotivni blok tri';
$string['marketingbuttontext'] = 'Tekst linka';
$string['marketingbuttontextdesc'] = 'Tekst koji se pojavljuje na dugmetu';
$string['marketingbuttonurl'] = 'URL adresa linka';
$string['marketingbuttonurldesc'] = 'URL adresa sa kojom je dugme povezano.';
$string['marketingcontent'] = 'Sadržaj';
$string['marketingcontentdesc'] = 'Tekst koji se prikazuje u promotivnom bloku. Treba da bude kratak i zanimljiv.';
$string['marketingdesc'] = 'Ova tema pruža opciju da na naslovnoj stranici postavite tri promotivna bloka ili oglasa, odmah ispod slajd-šou prezentacije. Ovo vam omogućava da svojim korisnicima lako naznačite najbitnije informacije i obezbedite odgovarajuće direktne linkove.';
$string['marketingheading'] = 'Promotivni blokovi';
$string['marketingheadingsub'] = 'Tri mesta na naslovnoj stranici sajta za dodavanje informacija i linkova.';
$string['marketingheight'] = 'Visina kontejnera promotivog bloka (pikseli)';
$string['marketingheightdesc'] = 'Odredite visinu kontejnera promotivnog bloka u pikselima. Podesite ovo tako da odgovara vašem sadržaju. Ako bilo koji blok ima sliku ili link, onda će i to biti dodato ovoj vrednosti visine u svim blokovima.';
$string['marketingicon'] = 'Ikonica';
$string['marketingicondesc'] = 'Naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza  "fa-",", npr.  "star".';
$string['marketingimage'] = 'Slika';
$string['marketingimagedesc'] = 'Ovo pruža mogućnost da iznad teksta u promotivnom bloku bude prikazana slika';
$string['marketingimageheight'] = 'Visina promotivnih slika (pikseli)';
$string['marketingimageheightdesc'] = 'Ako želite da prikažete slike u promotivnim blokovima ovde možete da odredite njihovu visinu u pikselima.';
$string['marketinginfodesc'] = 'Unesite podešavanja za vaš promotivni blok.';
$string['marketingtitle'] = 'Naslov';
$string['marketingtitledesc'] = 'Naslov koji će biti prikazan u ovom promotivnom bloku';
$string['marketingurltarget'] = 'Odredište linka';
$string['marketingurltargetdesc'] = 'Izaberite kako link treba da bude otvoren';
$string['marketingurltargetnew'] = 'Nova stranica';
$string['marketingurltargetparent'] = 'Matični okvir';
$string['marketingurltargetself'] = 'Tekuća stranica';
$string['memused'] = 'Korišćena memorija';
$string['messagesmi'] = 'Poruke';
$string['messagesmidesc'] = 'Prikažite stavku menija za poruke ako je slanje poruka omogućeno';
$string['mobileappsdesc'] = 'Da li imate veb aplikaciju u Apple App ili Google Play prodavnici? Unesite ovde link kako bi vaši korisnici mogli da preuzmu aplikacije onlajn.';
$string['mobileappsheading'] = 'Mobilne aplikacije';
$string['mobileappsheadingsub'] = 'Link ka vašoj aplikacija za polaznike koji koriste mobilne uređaje';
$string['modulesettingstitle'] = 'Podešavanja modula';
$string['myclasses'] = 'Moji časovi';
$string['mycourses'] = 'Moji kursevi';
$string['mycoursescatsubmenu'] = 'Podmeni kategorija i kurseva';
$string['mycoursescatsubmenudesc'] = 'Organizujte kurseve u podmenija na osnovu hijerarhije kategorija u kojima se nalaze. Kada je opcija \'enablecategoryicon\' (Omogući ikonice kategorija) podešena na \'Ne\' onda će biti korišćena ikonica kategorije podrazumevana za temu. Kada je ova opcija podešena na \'Da\' onda će biti korišćena ili vrednost opcije  \'defaultcategoryicon\' (Podrazumevane ikonice kategorija), ili ikonica same kategorije ako je opcija \'enablecustomcategoryicon\' (Omogući prilagođene ikonice kategorija) podešena na \'Da\'. Podešavanje \'mycoursesmax\' (Maksimalan broj kurseva) i dalje će se primenjivati ali na nivou kategorije.';
$string['mycoursesinfo'] = 'Meni kurseva';
$string['mycoursesinfodesc'] = 'Prikazuje korisnicima dinamički spisak upisanih kurseva.';
$string['mycoursesmax'] = 'Maksimalan broj kurseva';
$string['mycoursesmaxdesc'] = 'Navedite broj kurseva koji treba da bude prikazani na spisku, između {$a->lower} i {$a->upper},  gde \'{$a->lower}\' predstavlja sve kurseve.';
$string['mycoursesorder'] = 'Redosled kurseva';
$string['mycoursesorderdesc'] = 'Navedite kako kursevi treba da budu poređani. Redosled kurseva može da se podesi pomoću podešavanja za navigaciju \'Sortiraj moje kurseve\' (\'navsortmycoursessort\').';
$string['mycoursesorderenrolbackcolour'] = 'Boja pozadine za upisane kurseve kojima korisnik još nije pristupio.';
$string['mycoursesorderenrolbackcolourdesc'] = 'Boja pozadine za upisane kurseve kojima korisnik još nije pristupio, kada je \'Redosled sortiranja kurseva\' podešen na \'Vreme poslednjeg pristupa…\'';
$string['mycoursesorderid'] = 'ID oznaka kursa';
$string['mycoursesorderidasc'] = 'Rastući';
$string['mycoursesorderiddes'] = 'Opadajući';
$string['mycoursesorderidorder'] = 'Redosled ID oznaka kurseva';
$string['mycoursesorderidorderdesc'] = 'Redosled ID oznaka kurseva kada je \'Redosled sortiranja kurseva\' podešen na \'ID oznaka kursa\'.';
$string['mycoursesorderlast'] = 'Vreme poslednjeg pristupa ili početno vreme upisa ako korisnik nikad nije pristupio kursu';
$string['mycoursesordersort'] = 'Redosled sortiranja kurseva';
$string['mycoursetitle'] = 'Terminologija';
$string['mycoursetitledesc'] = 'Promenite termin naslova menija "Moji kursevi". Kada je \'Redosled sortiranja kurseva\' podešen na \'Vreme poslednjeg pristupa...\' onda će biti dodata reč \'najnoviji\'.';
$string['mygrades'] = 'Moje ocene';
$string['mygradesmi'] = 'Moje ocene';
$string['mygradesmidesc'] = 'Prikažite stavku menija \'Moje ocene\' ako korisnik ima sposobnost gradereport/overview:view\' na kursu. Nije potvrđeno na nivou sajta.';
$string['mylatestclasses'] = 'Moji najnoviji časovi';
$string['mylatestcourses'] = 'Moji najnoviji kursevi';
$string['mylatestmodules'] = 'Moji najnoviji moduli';
$string['mylatestunits'] = 'Moje najnovije jedinice';
$string['mymodules'] = 'Moji moduli';
$string['myunits'] = 'Moje jedinice';
$string['navbarabove'] = 'Navigaciona traka iznad zaglavlja';
$string['navbarbelow'] = 'Navigaciona traka ispod zaglavlja';
$string['navbartitle'] = 'Naslov trake za navigaciju';
$string['navbartitledesc'] = 'Podesite ovde naslov koji će se pojaviti u taci za navigaciju';
$string['nextsection'] = 'Sledeća sekcija';
$string['nobreadcrumb'] = 'Sakrij';
$string['noenrolments'] = 'Trenutno niste upisani ni na jedan kurs';
$string['noslidetitle'] = 'Nema naslova za slajd {$a->slide}';
$string['notitle'] = 'Bez naslova';
$string['numberofcoursesandsubcatcourses'] = 'Broj kurseva - potkategorija kurseva';
$string['numberofslides'] = 'Broj slajdova';
$string['numberofslides_desc'] = 'Broj slajdova u okviru slajd prezentacije.';
$string['oldnavbar'] = 'Koristi stari položaj navigacione trake';
$string['oldnavbardesc'] = 'Omogućite ovu opciju kako biste koristili stari položaj navigacione trake.';
$string['pagebackground'] = 'Pozadinska slika stranice';
$string['pagebackgrounddesc'] = 'Postavite svoju pozadinsku sliku. Izaberite stil slike u nastavku.';
$string['pagebackgroundstyle'] = 'Stil pozadine stranice';
$string['pagebackgroundstyledesc'] = 'Izaberite stil postavljene slike.';
$string['pagebottomblocksperrow'] = 'Broj blokova po jednom redu u regionu \'Dno stranice\'';
$string['pagebottomblocksperrowdesc'] = 'Navedite broj blokova (između {$a->lower} i {$a->upper}) koji će biti prikazani na stranicama sa regionom \'Blokovi na dnu stranice\'. Trenutne stranice su: Administracija, Upravljanje kursevima, Ocenjivanje i Uređivanje testa.';
$string['pagetopblocks'] = 'Omogući dodatan region blokova \'Vrh stranice\'';
$string['pagetopblocksdesc'] = 'Ako je omogućeno ovo podešavanje, na svim stranicam osim na naslovnoj (koja ima sopstvena podešavanja), iznad dela sa sadržajem biće prikazan dodatni region za blokove. Napomena: broj blokova po jednom redu zavisi od podešavanja \'pagetopblocksperrow\' (Broj blokova po jednom redu u regionu \'Vrh stranice\').';
$string['pagetopblocksperrow'] = 'Broj blokova po jednom redu u regionu \'Vrh stranice\'';
$string['pagetopblocksperrowdesc'] = 'Navedite koliko će blokova biti po jednom redu (između {$a->lower} i {$a->upper}) na stranicama sa regionom \'Vrh stranice\'. Trenutne stranice su: Administracija, Kurs, Kategorija kurseva, Kontrolni panel i Stranica za štampu.';
$string['pagewidth'] = 'Podesi širinu stranice';
$string['pagewidthdesc'] = 'Izaberite sa spiska dostupnih širina stranice za vaš sajt.';
$string['participantsmenu'] = 'Meni učesnika';
$string['participantsmenudesc'] = 'Prikažite meni učesnika na stranicama kursa i modula.';
$string['paypal_click'] = 'Moodle profila';
$string['paypal_desc'] = '{$a->url}\' za više informacija, pošto prema uslovima korišćenja Pay Pal servisa, kao pojedinac, ne mogu da koristim dugmad \'donacija\' / \'kupi sad\', ili';
$string['peakmem'] = 'Maksimum opterećenja memorije';
$string['perf_max'] = 'Detaljno';
$string['perf_min'] = 'Minimalno';
$string['perfinfo'] = 'Informacije o performansama';
$string['perfinfodesc'] = 'Mnogim sajtovima nisu potrebne detaljne informacije o performansama, posebno kada se posmatra iz ugla korisnika. Kada je omogućeno, ovo prikazuje osnovne informacije o učitavanju stranice.';
$string['perfinfoheading'] = 'Informacije o performansama';
$string['pinterest'] = 'Pinterest URL adresa';
$string['pinterestdesc'] = 'Unesite URL adresu vaše Pinterest stranice (tj. http://pinterest.com/mojaskola).';
$string['pinteresturl'] = 'Pinterest URL adresa';
$string['pluginname'] = 'Essential';
$string['preferencesmi'] = 'Parametri';
$string['preferencesmidesc'] = 'Prikažite stavku menija \'Parametri\\';
$string['previoussection'] = 'Prethodna sekcija';
$string['privacy:metadata:preference:courseitemsearchtype'] = 'Izbor korisnika za pretragu kurseva  (\'pun naziv kursa\' - \'0\' ili \'kompletan sadržaj kursa\' - \'1\'), u slučaju da je sačuvan kada je u podešavanjim teme potvrđena opcija  \'coursecontentsearch\'. Ako ništa nije navedeno onda je ili pretraga kursa isključena ili korisnik nikada nije video \'Kontrolni panel\' kada je bio na sajtu.';
$string['privacy:request:preference:courseitemsearchtype'] = 'Korisnik je izabrao "{$a->value}" kao parametar "{$a->name}" za pretragu kurseva, gde je \'0\' označava \'samo pun naziv kursa\' a \'1\' je \'kompletan sadržaj kursa\'.';
$string['privatefilesmi'] = 'Privatne datoteke';
$string['privatefilesmidesc'] = 'Prikažite stavku menija za privatne datoteke ako korisnik ima sposobnost \'moodle/user:manageownfiles\'.';
$string['profilebarcustomtitle'] = 'Traka profila - naslov prilagođenog blok';
$string['profilebarcustomtitledesc'] = 'Naslov za prilagođeni blok sa trakom profila.';
$string['profilelinkmi'] = 'Link profila';
$string['profilelinkmidesc'] = 'Prikažite stavku menija za link ka profilu korisnika';
$string['properties'] = 'Svojstva';
$string['propertiesdesc'] = 'Spisak svojstava.';
$string['propertiesexport'] = 'Izvezi svojstva kao JSON string';
$string['propertiesproperty'] = 'Svojstvo';
$string['propertiesreturn'] = 'Vrati se';
$string['propertiessub'] = 'Svojstva';
$string['propertiesvalue'] = 'Vrednost';
$string['putpropertiesadded'] = 'Dodato:';
$string['putpropertieschanged'] = 'Promenjeno:';
$string['putpropertiesdesc'] = 'Nalepite JSON string i kliknite na \'Sačuvaj promene\'. Upozorenje! Vrednosti podešavanja se ne proveravaju a komanda \'Obriši sve zapise iz keš memorije\' se automatski izvršava.';
$string['putpropertiesfrom'] = 'od';
$string['putpropertiesignorecti'] = 'Ignorisanje svih podešavanja naslovne slike kursa.';
$string['putpropertiesignored'] = 'Ignorisano:';
$string['putpropertiesname'] = 'Postavite svojstva - Eksperimentalno!';
$string['putpropertiesreportfiles'] = 'Ne zaboravite da postavite sledeće datoteke u njihova podešavanja:';
$string['putpropertiessettingsreport'] = 'Izveštaj o podešavanjima:';
$string['putpropertiesunchanged'] = 'Nepromenjeno:';
$string['putpropertiesvalue'] = '->';
$string['putpropertyour'] = 'Naša';
$string['putpropertyproperties'] = 'Svojstva';
$string['putpropertyreport'] = 'Izveštaj:';
$string['putpropertyversion'] = 'verzija:';
$string['readme_click'] = 'kliknite ovde za README.md';
$string['readme_desc'] = 'Molimo {$a->url} datoteku koja sadrži više informacija o temi Essential.';
$string['readme_title'] = 'Essential read-me datoteka sa uputstvom';
$string['readmore'] = 'Pročitaj više';
$string['region-footer-left'] = 'Podnožje (levo)';
$string['region-footer-middle'] = 'Podnožje (sredina)';
$string['region-footer-right'] = 'Podnožje (desno)';
$string['region-header'] = 'Zaglavlje';
$string['region-hidden-dock'] = 'Sakriveno od korisnika';
$string['region-home'] = 'Početak stranice';
$string['region-page-top'] = 'Vrh stranice';
$string['region-side-post'] = 'Desno';
$string['region-side-pre'] = 'Levo';
$string['returntosection'] = 'Povratak na: {$a->section}';
$string['returntosectionfeature'] = 'Povratak na sekciju';
$string['returntosectionfeaturedesc'] = 'Omogućite funkcionalnost povratka na sekciju unutar modula kursa.';
$string['returntosectiontextlimitfeature'] = 'Povratak na sekciju - ograničenje dužine naziva';
$string['returntosectiontextlimitfeaturedesc'] = 'Ograničenje dužine za \'naziv\' sekcije na dugmetu između {$a->lower} i {$a->upper} karaktera.';
$string['right'] = 'Desno';
$string['searchallcoursecontent'] = 'Pretraži kompletan sadržaj kursa';
$string['searchallcoursecontentdefault'] = 'Podrazumevana pretraga kompletnog sadržaj kursa';
$string['searchallcoursecontentdefaultdesc'] = 'Podešava vrednost polja za potvrdu \'Pretraži kompletan sadržaj kursa\' za pretragu sadržaja kursa. Ako ovo polje nije potvrđeno onda će se pretraživati samo pun naziv kursa.';
$string['searchallcoursecontentenable'] = 'Omogući pretragu kompletnog sadržaj kursa';
$string['searchallcoursecontentenabledesc'] = 'Dozvolite korisniku da odluči da li želi da pretražuje kompletan sadržaj kursa. Ako je onemogućeno, onda će se za pretragu kursa primeniti vrednost  \'searchallcoursecontentdefault\' (Podrazumevana pretraga kompletnog sadržaj kursa).';
$string['serverload'] = 'Opterećenje servera';
$string['sessionsize'] = 'Veličina sesije';
$string['shortname'] = 'Skraćeni naziv sajta';
$string['shortnamesummary'] = 'Skraćeni naziv  i rezime';
$string['siteicon'] = 'Ikonica sajta';
$string['siteicondesc'] = 'Nemate svoj logo? Unesite naziv ikonice koju želite da koristite. Spisak ikonica možete naći <a href="http://fortawesome.github.io/Font-Awesome/cheatsheet/" target="_new">ovde</a>. Unesite samo ono što sledi iza "fa-".';
$string['skype'] = 'Skype nalog';
$string['skypedesc'] = 'Unesite korisničko ime za Skype nalog vaše institucije/organizacije (tj. skype://moja.skola).';
$string['skypeuri'] = 'URL adresa Skype naloga';
$string['slidebuttoncolor'] = 'Boja dugmeta na slajdu';
$string['slidebuttoncolordesc'] = 'Koje boje treba da bude navigaciono dugme na slajdu.';
$string['slidebuttonhovercolor'] = 'Lebdeća boja dugmeta na slajdu';
$string['slidebuttonhovercolordesc'] = 'Koje boje treba da bude lebdeća boja navigacionog dugmeta na slajdu.';
$string['slidecaption'] = 'Opis slajda';
$string['slidecaptionbackgroundcolor'] = 'Boja pozadine natpisa na slajdu';
$string['slidecaptionbackgroundcolordesc'] = 'Koja boje treba da bude boja pozadine natpisa na slajdu. Nije primenjivo ako je za natpis na slajdu izabrana opcija \'Pored\'.';
$string['slidecaptionbelow'] = 'Opis slajda ispod slike';
$string['slidecaptionbelowdesc'] = 'Da li opis slajda treba da bude ispod slike.';
$string['slidecaptionbeside'] = 'Pored';
$string['slidecaptioncentred'] = 'Opis slajda centriran';
$string['slidecaptioncentreddesc'] = 'Da li opis slajda treba da bude na sredini.';
$string['slidecaptiondesc'] = 'Unesite tekst koji će se koristiti za opis slajda';
$string['slidecaptionontop'] = 'Na vrhu';
$string['slidecaptionoptions'] = 'Opcije za opis slajda';
$string['slidecaptionoptionsdesc'] = 'Gde treba da se nalazi opis slajda u odnosu na sliku.';
$string['slidecaptiontextcolor'] = 'Boja teksta natpisa na slajdu';
$string['slidecaptiontextcolordesc'] = 'Koja boje treba da bude boja teksta natpisa na slajdu. Nije primenjivo ako je za natpis na slajdu izabrana opcija \'Pored\'.';
$string['slidecaptionunderneath'] = 'Ispod';
$string['slidecolor'] = 'Boja teksta slajda';
$string['slidecolordesc'] = 'Koje boje treba da bude tekst opisa slajda.';
$string['slideimage'] = 'Slika slajda';
$string['slideimagedesc'] = 'Najbolje je koristiti transparentnu sliku.';
$string['slideinterval'] = 'Interval između slajdova';
$string['slideintervaldesc'] = 'Vreme prelaska sa jednog na drugi slajd u milisekundama.';
$string['slideno'] = 'Slajd {$a->slide}';
$string['slidenodesc'] = 'Unesite podešavanja za slajd {$a->slide}.';
$string['slideshowdesc'] = 'Ovo kreira dinamički slajd-šou od maksimalno 16 slajdova za promovisanje važnih stvari na vašem sajtu. Slajd-šou je prilagodljiv tako da se visina slike podešava prema veličini ekrana. Preporučena visina je 300 piksela. Širina je podešena na 100 % pa će zato stvarna visina slike biti manja ako je širina veća od veličine ekrana. Na ekranima manje veličine, visina se dinamički smanjuje, bez potrebe da se obezbede zasebne slike. Za ekrane čija je širina manja od 767 piksela visina će biti165 piksela, za ekrane čija je širina između 768 i 979 piksela, visina će biti 225piksela, dok će za ekrane širine veće od 980 piksela visina biti 300 piksela. Ako je nije izabrana nijedna slika za slajd, onda će se koristiti slika default_slide koja se nalazi u folderu pix.';
$string['slideshowheading'] = 'Slajd-šou';
$string['slideshowheadingsub'] = 'Dinamički slajd-šou na naslovnoj stranici';
$string['slidetitle'] = 'Naslov slajda';
$string['slidetitledesc'] = 'Unesite opisni naslov za vaš slajd';
$string['slideurl'] = 'Link slajda';
$string['slideurldesc'] = 'Unesite ciljno odredište linka prve slike slajda';
$string['slideurltarget'] = 'Odredište linka';
$string['slideurltargetdesc'] = 'Izaberite kako link treba da bude otvoren';
$string['slideurltargetnew'] = 'Nova stranica';
$string['slideurltargetparent'] = 'Matični okvir';
$string['slideurltargetself'] = 'Tekuća stranica';
$string['socialdesc'] = 'Unesite direktne linkove ka glavnim društvenim mrežama kako biste promovisali svoj sajt. Ovi linkovi će se pojavljivati u zaglavlju svake stranice.';
$string['socialheading'] = 'Društvene mreže';
$string['socialheadingsub'] = 'Animirajte svoje korisnike putem društvenih mreža';
$string['socialnetworks'] = 'Društvene mreže';
$string['sponsor_desc'] = 'Molimo vas da putem PayPal sistema budete sponzor tako što ćete me kontaktirati preko mog';
$string['sponsor_desc2'] = 'kako bi se nastavio razvoj teme Essential , ili jednostavno, da biste izrazili svoju zahvalnost.';
$string['sponsor_title'] = 'Sponzorišite temu Essential';
$string['stylecover'] = 'Prekriveno';
$string['stylefixed'] = 'Fiksirano';
$string['styleguide'] = 'Stilski vodič';
$string['styleguidedesc'] = 'Originalna dokumentacija kôda je pod \'{$a->origcodelicenseurl}\' licencom. Holder.js ima \'{$a->holderlicenseurl}\' licencu. Dodatni kôd je pod \'{$a->thiscodelicenseurl}\' licencom, koja je \'{$a->compatible}\' licenca. Sadržaj ima \'{$a->contentlicenseurl}\' licencu. Dokumentacija je formatirana za prikaz u Moodleu sa dodatkom FontAwesome ikonica gde je to potrebno. Dodatni CSS može se naći u datoteci \'essential_admin_setting_styleguide.php\' pod komentarom \'// Beyond docs.css.\'. Sekcija \'{$a->globalsettings}\' je uklonjena.';
$string['styleguidesub'] = 'Bootstrap V2.3.2 Stilski vodič';
$string['stylestretch'] = 'Razvučeno';
$string['styletiled'] = 'Popločano';
$string['switchrolemi'] = 'Promena uloge';
$string['switchrolemidesc'] = 'Prikažite stavku menija za promenu uloge ako korisnik može da menja uloge.';
$string['tallyinoftotal'] = '{$a->rtally} u {$a->ctally} od {$a->ctotal}';
$string['tallyoftotal'] = '{$a->tally} od {$a->total}';
$string['themecolor'] = 'Boja teme';
$string['themecolordesc'] = 'Koje boje treba da bude vaša tema. Ovo će promeniti brojne komponente kako biste koristili boju koju želite na čitavom sajtu.';
$string['themecolors'] = 'Boje teme';
$string['themedefaultbuttonbackgroundcolour'] = 'Boja pozadine standardnog dugmeta';
$string['themedefaultbuttonbackgroundcolourdesc'] = 'Podesite boju pozadine za svu standardnu dugmad.';
$string['themedefaultbuttonbackgroundhovercolour'] = 'Lebdeća boja pozadine standardnog dugmeta';
$string['themedefaultbuttonbackgroundhovercolourdesc'] = 'Podesite lebdeću boju pozadine za svu standardnu dugmad.';
$string['themedefaultbuttontextcolour'] = 'Boja teksta standardnog dugmeta';
$string['themedefaultbuttontextcolourdesc'] = 'Podesite boju teksta za svu standardnu dugmad.';
$string['themedefaultbuttontexthovercolour'] = 'Lebdeća boja teksta standardnog dugmeta';
$string['themedefaultbuttontexthovercolourdesc'] = 'Podesite lebdeću boju teksta za svu standardnu dugmad.';
$string['themehovercolor'] = 'Lebdeća boja teme';
$string['themehovercolordesc'] = 'Koja boje treba da bude lebdeća boja u vašoj temi. Ona se koristi za linkove, menije itd.';
$string['themeiconcolor'] = 'Boja ikonica';
$string['themeiconcolordesc'] = 'Podesite boju za sve ikonice.';
$string['themenavcolor'] = 'Boja navigacije';
$string['themenavcolordesc'] = 'Podesite boju teksta za navigaciju, imajući u vidu navigacionu traku i elegantni stil navigacione putanje.';
$string['themequizsubmitbackgroundcolour'] = 'Boja pozadine dugmeta \'Predaj sve odgovore i završi test\'';
$string['themequizsubmitbackgroundcolourdesc'] = 'Podesite boju pozadine za dugme \'Predaj sve odgovore i završi test\'.';
$string['themequizsubmitbackgroundhovercolour'] = 'Lebdeća boja pozadine dugmeta \'Predaj sve odgovore i završi test\'';
$string['themequizsubmitbackgroundhovercolourdesc'] = 'Podesite lebdeću boju pozadine za dugme \'Predaj sve odgovore i završi test\'.';
$string['themequizsubmittextcolour'] = 'Boja teksta dugmeta \'Predaj sve odgovore i završi test\'';
$string['themequizsubmittextcolourdesc'] = 'Podesite boju teksta za dugme \'Predaj sve odgovore i završi test\'.';
$string['themequizsubmittexthovercolour'] = 'Lebdeća boja teksta dugmeta \'Predaj sve odgovore i završi test\' {$a}';
$string['themequizsubmittexthovercolourdesc'] = 'Podesite alternativnu lebdeću boju teksta za dugme \'Predaj sve odgovore i završi test\'.';
$string['themesidepreblockbackgroundcolour'] = 'Boja pozadine bloka s leve strane';
$string['themesidepreblockbackgroundcolourdesc'] = 'Podesite boju pozadine u regionu s leve strane';
$string['themesidepreblockhovercolour'] = 'Boja pozadine lebdećeg linka s leve strane';
$string['themesidepreblockhovercolourdesc'] = 'Podesite lebdeće boju pozadine link za blok s leve strane';
$string['themesidepreblocktextcolour'] = 'Boja teksta bloka s leve strane';
$string['themesidepreblocktextcolourdesc'] = 'Podesite boju teksta za blok s leve strane';
$string['themesidepreblockurlcolour'] = 'Boja linka bloka s leve strane';
$string['themesidepreblockurlcolourdesc'] = 'Podesite boju linka za blok s leve strane';
$string['themestripebackgroundcolour'] = 'Boja pozadine pruge';
$string['themestripebackgroundcolourdesc'] = 'Podesite boju pozadine za pruge u tabelama';
$string['themestripetextcolour'] = 'Boja teksta pruge';
$string['themestripetextcolourdesc'] = 'Podesite boju teksta za pruge u tabelama';
$string['themestripeurlcolour'] = 'Boja URL linka unutar pruge';
$string['themestripeurlcolourdesc'] = 'Podesite boju URL linka unutar pruga u tabelama';
$string['themetextcolor'] = 'Boja teksta';
$string['themetextcolordesc'] = 'Podesite boju za vaš tekst.';
$string['themeurlcolor'] = 'Boja linka';
$string['themeurlcolordesc'] = 'Podesite boju za tekst linkova.';
$string['thiscourse'] = 'Ovaj kurs';
$string['togglemarketing'] = 'Prekidač za prikaz promotivnih blokova';
$string['togglemarketingdesc'] = 'Izaberite da li želite da sakrijete ili prikažete tri promotivna bloka.';
$string['toggleslideshow'] = 'Slajd-šou - prekidač prikaza';
$string['toggleslideshowdesc'] = 'Izaberite da li želite da sakrijete ili prikažete slajd-šou.';
$string['twitter'] = 'Twitter URL adresa';
$string['twitterdesc'] = 'Unesite URL adresu vaše Twitter stranice (tj. http://www.twitter.com/mojaskola).';
$string['twitterurl'] = 'Twitter URL adresa';
$string['userimageborderradius'] = 'Poluprečnik ivice korisničke slike';
$string['userimageborderradiusdesc'] = 'Navedite poluprečnik ivice korisničke slike, između  {$a->lower} i {$a->upper} piksela, na čitavom sajtu osim u zaglavlju koje koristi podešavanje \'usermenuuserimageborderradius\'.';
$string['usermenu'] = 'Korisnički meni';
$string['usermenudesc'] = 'Meni za korisnika.';
$string['usermenuuserimageborderradius'] = 'Poluprečnik ivice slike u korisničkom meniju';
$string['usermenuuserimageborderradiusdesc'] = 'Navedite poluprečnik ivice slike u korisničkom meniju, između  {$a->lower} i {$a->upper} piksela.';
$string['usersettingstitle'] = 'Korisnička podešavanja';
$string['usesiteicon'] = 'Koristi ikonicu sajta';
$string['usesiteicondesc'] = 'Koristite ikonicu sajta ako ne postoji logo.';
$string['variablewidth'] = 'Promenljiva širina';
$string['versionalerttext1'] = 'Tema nije dizajnirana za ovu verziju Moodlea.';
$string['versionalerttext2'] = 'Mogu se javiti neočekivani problem, molimo, preuzmite ispravnu verziju temu za vašu verziju Moodlea.';
$string['versionalerttitle'] = 'Upozorenje o verziji:';
$string['visibleadminonly'] = 'Blokovi premešteni u donji region biće vidljivi samo administratorima';
$string['vk'] = 'VKontakte URL adresa';
$string['vkdesc'] = 'Unesite URL adresu vaše Vkontakte stranice (tj. http://www.vk.com/mojaskola).';
$string['vkurl'] = 'VKontakte URL adresa';
$string['website'] = 'URL adresa veb sajta';
$string['websitedesc'] = 'Unesite URL adresu vašeg glavnog veb sajta (tj. http://www.mojfakultet.ac.rs ili http://www.mojaskola.edu.rs).';
$string['websiteurl'] = 'URL adresa veb sajta';
$string['windows'] = 'Windows stoni računar';
$string['windowsdesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Windows prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične Moodle Desktop aplikacije (https://www.microsoft.com/en-us/store/p/moodle-desktop/9p9bwvhdc8c8).';
$string['windowsurl'] = 'URL adresa aplikacije za Windows stoni računar';
$string['winphone'] = 'Windows mobilni uređaj';
$string['winphonedesc'] = 'Unesite URL adresu za vašu mobilnu aplikaciju u Windows  prodavnici. Ukoliko nemate svoju možete uneti adresu besplatne zvanične mobilne aplikacije za Moodle (https://www.microsoft.com/en-rs/store/p/moodlemobile/9wzdncrdk93x?rtc=1).';
$string['winphoneurl'] = 'URL adresa aplikacije za Windows mobilni uređaj';
$string['within'] = 'Unutar';
$string['youtube'] = 'YouTube URL adresa';
$string['youtubedesc'] = 'Unesite URL adresu vašeg YouTube kanala (tj. http://www.youtube.com/mojaskola).';
$string['youtubeurl'] = 'YouTube URL adresa';
