<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'badges', language 'es', version '4.4'.
 *
 * @package     badges
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actions'] = 'Acciones';
$string['activate'] = 'Habilitar acceso';
$string['activatesuccess'] = 'El acceso a las insignias fue activado con éxito.';
$string['addalignment'] = 'Añadir habilidad externa o estándar';
$string['addbadge'] = 'Añadir insignias';
$string['addbadge_help'] = 'Seleccione todas las insignias que deben ser añadidas para los requisitos de esta insignia. Mantenga pulsada la tecla CTRL para seleccionar multiples items.';
$string['addbadgecriteria'] = 'Añadir criterios para las insignias';
$string['addcohort'] = 'Añadir cohorte';
$string['addcohort_help'] = 'Seleccione todas las cohortes que deben ser añadidas para los requisitos de esta insignia. Mantenga pulsada la tecla CTRL para seleccionar multiples items.';
$string['addcompetency'] = 'Añadir competencia';
$string['addcompetency_help'] = 'Seleccionar todas las competencias que deberían de ser añadidas a este requisito para la insignia. Mantenga presionada la tecla CTRL para seleccionar varios ítems.';
$string['addcourse'] = 'Añadir cursos';
$string['addcourse_help'] = 'Seleccionar todos los cursos que deben agregarse a este requisito para la insignia. Mantener pulsada la tecla CTRL para seleccionar varios elementos.';
$string['addcriteria'] = 'Añadir criterios';
$string['addcriteriatext'] = 'Para empezar a añadir criterios, por favor seleccione una de las opciones del menú desplegable.';
$string['addedtobackpack'] = 'Insignia añadida a mochila';
$string['addrelated'] = 'Añadir insignia relacionada';
$string['addtobackpack'] = 'Añadir a la mochila';
$string['adminonly'] = 'Esta página está restringida a los administradores del sitio.';
$string['after'] = 'después de la fecha de su expedición.';
$string['aggregationmethod'] = 'Método de agregación';
$string['alignment'] = 'Alineación';
$string['all'] = 'Todas';
$string['allmethod'] = 'Todas las condiciones seleccionadas se cumplen';
$string['allmethodactivity'] = 'Todas las actividades seleccionadas están finalizadas';
$string['allmethodbadges'] = 'Se deben obtener todas las insignias seleccionadas';
$string['allmethodcohort'] = 'Pertenencia a todas las cohortes seleccionadas';
$string['allmethodcompetencies'] = 'Todas las competencias seleccionadas han sido completadas';
$string['allmethodcourseset'] = 'Todos los cursos seleccionados están finalizados';
$string['allmethodmanual'] = 'Todos los roles seleccionados otorgan la insignia';
$string['allmethodprofile'] = 'Todos los campos de perfil seleccionados han sido cumplimentados';
$string['allowcoursebadges'] = 'Habilitar insignias del curso';
$string['allowcoursebadges_desc'] = 'Permitir crear y otorgar insignias en el contexto del curso.';
$string['allowexternalbackpack'] = 'Conexión hacia mochila externa';
$string['allowexternalbackpack_desc'] = 'Si se habilita, los usuarios se pueden conectar con una mochila externa y compartir sus insignias de este sitio. Los usuarios también pueden elegir mostrar cualquier colección pública de insignias desde  su mochila externa en su página del perfil en este sitio. Se recomienda dejar esta opción deshabilitada si el sitio web no es accesible desde el Internet.';
$string['any'] = 'Cualquiera';
$string['anymethod'] = 'Cualquiera de las condiciones se cumple';
$string['anymethodactivity'] = 'Cualquiera de las actividades seleccionada está finalizada';
$string['anymethodbadges'] = 'Se debe obtener alguna de las insignias seleccionadas';
$string['anymethodcohort'] = 'Pertenencia a una de las cohortes seleccionadas';
$string['anymethodcompetencies'] = 'Cualquiera de las competencias seleccionadas ha sido completada';
$string['anymethodcourseset'] = 'Cualquiera de los cursos seleccionados está finalizado';
$string['anymethodmanual'] = 'Cualquiera de los roles seleccionados otorga la insignia';
$string['anymethodprofile'] = 'Cualquiera de los campos de perfil seleccionados ha sido cumplimentado';
$string['apiversion'] = 'Versión API soportada';
$string['archivebadge'] = '¿Quiere eliminar la insignia \'{$a}\', pero mantener las insignias otorgadas existentes?';
$string['archiveconfirm'] = 'Eliminar y mantener las insignias otorgadas existentes';
$string['archivehelp'] = '<p>Esta opción significa que la insignia se marcará como "retirada" y ya no aparecerá en la lista de insignias. Los usuarios no podrán ganar esta insignia, sin embargo los destinatarios de la insignia existentes seguirán pudiendo mostrarla en su página de perfil y subirla a sus mochilas externas. </p>
<p> Si desea que sus usuarios pueden mantener el acceso a las insignias obtenidas es importante seleccionar esta opción en lugar de eliminar totalmente las insignias.</p>';
$string['attachment'] = 'Adjuntar insignia al mensaje';
$string['attachment_help'] = 'Si está habilitado, se adjuntará una archivo de insignia emitida al correo electrónico del destinatario para descarga. (Los adjuntos deben ser habilitados en \'Administración del sitio  > Servidor > Correo electrónico > Configuración de correo saliente\' para usar esta opción.)';
$string['award'] = 'Otorgar insignia';
$string['awardedto'] = 'Otorgado a {$a}';
$string['awardedtoyou'] = 'Emitida para mi';
$string['awardoncron'] = 'El acceso a las insignias se activó con éxito. Muchos usuarios pueden ganar simultáneamente esta insignia. Para garantizar el funcionamiento del sitio, esta acción llevará un cierto tiempo de proceso.';
$string['awards'] = 'Destinatarios';
$string['backpackapiurl'] = 'URL de API de mochila';
$string['backpackavailability'] = 'Verificación externa de la insignia';
$string['backpackavailability_help'] = 'Para que los receptores de insignias puedan demostrar que han ganado insignias emitidas por usted, un servicio de mochila externo debe poder acceder a su sitio y verificar las insignias emitidas desde ahí.
En este momento, no aparece que su sitio sea accesible, lo que significa que las insignias que ya haya emitido o que se emitan en el futuro no se podrán verificar.

## ¿Por qué me sale este mensaje?

Puede ser que el firewall impida el acceso de usuarios externos a la red, que el sitio esté protegido con contraseña, o que esté ejecutando el sitio en un equipo que no está disponible a través de Internet (por ejemplo, una máquina de desarrollo local).

## ¿Es un problema?

Debe solucionar este problema en cada sitio de producción donde vaya a emitir insignias, de lo contrario los destinatarios no serán capaces de probar que han ganado las insignias emitidas por usted.
Si su sitio no está activo aún, puede crear y suministrar insignias de prueba, siempre y cuando el sitio sea accesible antes de activarse.

## ¿Qué pasa si no puedo dar acceso público a mi sitio completo?

El único URL necesario para la verificación es [su-sitio-url]/badges/assertion.php, por lo que si usted puede modificar el firewall para permitir el acceso externo a ese archivo, la verificación de las insignias seguirá funcionando.';
$string['backpackbadgessettings'] = 'Cambiar configuraciones de mochila';
$string['backpackbadgessummary'] = 'Usted tiene {$a->totalbadges} insignia(s) mostrada(s) de  {$a->totalcollections} colección(es).';
$string['backpackcannotsendverification'] = 'No puede enviarse email de verificación';
$string['backpackconnected'] = 'La mochila está conectada';
$string['backpackconnection'] = 'Conexión a la mochila';
$string['backpackconnection_connected'] = 'Su mochila';
$string['backpackconnection_help'] = 'Guardar y compartir sus insignias desde este sitio y mostrar insignias públicas desde otras páginas web en su perfil de usuario.';
$string['backpackconnectioncancelattempt'] = 'Conectar usando una dirección email diferente';
$string['backpackconnectionconnect'] = 'Conectar a mochila';
$string['backpackconnectionnottested'] = 'No se pudo probar la conexión para esta mochila porque solamente las mochilas Open Badges 2.0 la soportan.';
$string['backpackconnectionok'] = 'Conexión a mochila restablecida exitosamente';
$string['backpackconnectionresendemail'] = 'Reenviar email de verificación';
$string['backpackconnectionunexpectedmessage'] = 'La mochila devolvió el error: "{$a}".';
$string['backpackconnectionunexpectedresult'] = 'Hubo un problema conectando su mochila. Su proveedor de mochila envía este mensaje: "{$a}".';
$string['backpackdetails'] = 'Configuración de la mochila';
$string['backpackdisconnected'] = 'La mochila está desconectada';
$string['backpackemail'] = 'Dirección de correo electrónico';
$string['backpackemail_help'] = 'La dirección de correo electrónico asociada a su mochila. Mientras está conectado, las insignias obtenidas en este sitio se asociarán con esta dirección de correo electrónico.';
$string['backpackemail_required'] = 'La dirección de correo electrónico no puede estar en blanco';
$string['backpackemailverificationpending'] = 'Verificación pendiente';
$string['backpackemailverifyemailbody'] = 'Hola, {$a->userfirstname}.

Casi ha terminado de conectar su mochila de insignias en "{$a->sitename}".

Para confirmar y activar la conexión a su mochila, verifique su dirección de coreo mediante el siguiente botón:

{$a->buttonlink}

Si el botón no funciona, puede copiar y pegar la siguiente URL en su navegador:
{$a->link}

Si usted no intentaba conectar su mochila de insignias, ignore este correo electrónico.

Si necesita ayuda, comuníquese con el administrador del sitio,

{$a->admin}';
$string['backpackemailverifyemailsubject'] = '{$a}: Verificación de correo electrónico de Mochila de insignias';
$string['backpackemailverifypending'] = 'Se ha enviado un email de notificación a <strong>{$a}</strong>. Haga clic en el enlace de verificación en el email para activar la conexión a su Mochila.';
$string['backpackemailverifysuccess'] = 'Ahora está conectado a su Mochila.';
$string['backpackemailverifytokenmismatch'] = 'El token en el enlace que pinchó coincide con el token almacenado. Asegúrese de que hizo clic en el email más reciente que recibió.';
$string['backpackexporterror'] = 'No se puede exportar la insignia a la mochila';
$string['backpackexporterrorwithinfo'] = 'No se pudo exportar la insignia "{$a->badgename}" a la copia de respaldo. Error: {$a->error}';
$string['backpackimport'] = 'Ajustes de importación de insignias';
$string['backpackimport_help'] = 'Después de establecerse una conexión correcta a la mochila, las insignias de su mochila pueden verse en la página "Mis Badges"  y en su página de perfil.

En este área, puede seleccionar las colecciones de insignias de su mochila que quiera mostrar  en su perfil.';
$string['backpackprovider'] = 'Proveedor de Mochila';
$string['backpacksettings'] = 'Configuraciones de mochila';
$string['backpackweburl'] = 'URL de mochila';
$string['badgedetails'] = 'Detalles de la insignia';
$string['badgeimage'] = 'Imagen';
$string['badgeimage_help'] = 'La imagen debe tener un tamaño mínimo de 300 x 300 píxeles. Se mostrará como 300 x 300 píxeles en la página de la insignia y 100 x 100 píxeles en la página del perfil del usuario.';
$string['badgeissued'] = 'Insignia emitida';
$string['badgeprivacysetting'] = 'Configuración de privacidad de la insignia';
$string['badgeprivacysetting_help'] = 'Las insignias que usted gane se pueden mostrar en su página de perfil de cuenta. Este ajuste le permite mostrar automáticamente las insignias recientemente ganadas.

Puede controlar la configuración de privacidad de las insignias individuales en la página "Mis insignias".';
$string['badgeprivacysetting_str'] = 'Mostrar automáticamente en mi página de perfil las insignias que he ganado';
$string['badges'] = 'Insignias';
$string['badgesalt'] = 'Sal para encriptar la dirección de correo electrónico del destinatario';
$string['badgesalt_desc'] = 'Usar un \'hash\' permite que los servicios de mochila confirmen el origen de la insignia sin tener que mostrar su dirección de correo electrónico. Este ajuste debe utilizar solo números y letras.

Observación: Con fines de verificación de los receptores, evite cambiar este ajuste una vez que comience la emisión de insignias';
$string['badgesdisabled'] = 'Las insignias no están habilitados en este sitio.';
$string['badgesearned'] = 'Número de insignias conseguidas: {$a}';
$string['badgesettings'] = 'Configuración de las insignias';
$string['badgestatus_0'] = 'No disponible';
$string['badgestatus_1'] = 'Disponible';
$string['badgestatus_2'] = 'No disponible para los usuarios (criterios bloqueados)';
$string['badgestatus_3'] = 'Disponible para los usuarios (criterios bloqueados)';
$string['badgestatus_4'] = 'Archivado';
$string['badgestoearn'] = 'Número de insignias disponibles: {$a}';
$string['badgesview'] = 'Insignias de curso';
$string['badgetags'] = 'Etiquetas de insignia';
$string['badgeurl'] = 'Enlace a la insignia emitida';
$string['balignment'] = 'Alineaciones ({$a})';
$string['bawards'] = 'Destinatarios ({$a})';
$string['bcriteria'] = 'Criterios';
$string['bdetails'] = 'Editar detalles';
$string['bendorsement'] = 'Confirmación';
$string['bmessage'] = 'Mensajes';
$string['boverview'] = 'Visión global';
$string['brelated'] = 'Insignias relacionadas ({$a})';
$string['bydate'] = 'finalizado antes de';
$string['claim'] = 'Pretensión';
$string['claimcomment'] = 'Comentario a la Confirmación';
$string['claimid'] = 'URL de petición';
$string['clearsettings'] = 'Eliminar ajustes';
$string['completioninfo'] = 'Esta insignia fue emitida al finalizar:';
$string['completionnotenabled'] = 'La finalización del curso no está habilitada en este curso, por lo que no puede incluirse en los criterios de la insignia. La finalización del curso puede habilitarse en la configuración del curso.';
$string['configenablebadges'] = 'Si está habilitada, esta función le permite crear insignias y otorgarlas a los usuarios del sitio.';
$string['configuremessage'] = 'Mensaje de la insignia';
$string['connect'] = 'Conectar';
$string['connected'] = 'Conectado';
$string['connecting'] = 'Conectando....';
$string['contact'] = 'Contacto';
$string['contact_help'] = 'Una dirección de correo electrónico asociada al emisor de la insignia.';
$string['copy'] = 'Copiar';
$string['copyof'] = 'Copia de {$a}';
$string['course'] = 'Curso: {$a}';
$string['coursebadges'] = 'Insignias';
$string['coursebadgesdisabled'] = 'Las insignias de curso no están habilitadas en este sitio.';
$string['coursebadgetitle'] = 'Insignia del curso {$a}';
$string['coursecompletion'] = 'Los usuarios deben finalizar este curso.';
$string['create'] = 'Nueva insignia';
$string['createbutton'] = 'Crear insignia';
$string['creatorbody'] = '<p> {$a->user} ha completado todos los requisitos de la insignia y ha sido galardonado con esta insignia. Ver insignias emitidas en {$a->link} </p>';
$string['creatorsubject'] = '¡\'{$a}\' ha sido galardonado!';
$string['criteria_0'] = 'Esta insignia se concede cuando...';
$string['criteria_1'] = 'Finalización de la actividad';
$string['criteria_1_help'] = 'Permite que una insignia se conceda a los usuarios en base a la realización de un conjunto de actividades dentro de un curso.';
$string['criteria_2'] = 'Concesión manual por rol';
$string['criteria_2_help'] = 'Permite que una insignia se conceda a los usuarios de forma manual por los usuarios que tienen un rol particular en el sitio o en el curso.';
$string['criteria_3'] = 'Participación social';
$string['criteria_3_help'] = 'Social';
$string['criteria_4'] = 'Finalización del curso';
$string['criteria_4_help'] = 'Permite que una insignia se conceda a los usuarios que hayan completado el curso. Este criterio puede tener parámetros adicionales como una calificación mínima y la fecha de finalización del curso.';
$string['criteria_5'] = 'Finalización de una serie de cursos';
$string['criteria_5_help'] = 'Permite que una insignia se conceda a los usuarios que han completado una serie de cursos. Cada curso puede tener parámetros adicionales como una calificación mínima y la fecha de finalización del curso.';
$string['criteria_6'] = 'Cumplimentación del perfil';
$string['criteria_6_help'] = 'Permite que una insignia se conceda a los usuarios que han cumplimentado ciertos campos en su perfil personal.  Puede elegir entre los campos de perfil personalizados y los campos de perfil predeterminados.';
$string['criteria_7'] = 'Insignias otorgadas';
$string['criteria_7_help'] = 'Permite otorgar una insignia a los usuarios en función de otras insignias que hayan obtenido.';
$string['criteria_8'] = 'Pertenencia a una cohorte';
$string['criteria_8_help'] = 'Permite a los usuarios obtener una insignia basada en la pertenencia a una cohorte.';
$string['criteria_9'] = 'Competencias';
$string['criteria_9_help'] = 'Permitir que una insignia sea otorgada a usuarios, basada en las competencias que ellos han completado.';
$string['criteria_descr'] = 'Los estudiantes son galardonados con esta insignia cuando han cumplido el siguiente requisito:';
$string['criteria_descr_0'] = 'Completar <strong>{$a}</strong> de los requisitos enumerados.';
$string['criteria_descr_1'] = '<strong>{$a}</strong> de las siguientes actividades se han finalizado:';
$string['criteria_descr_2'] = 'Esta insignia debe ser otorgada por los usuarios con <strong>{$a}</strong> de los siguientes roles:';
$string['criteria_descr_4'] = 'Los usuarios deben finalizar el curso';
$string['criteria_descr_5'] = '<strong>{$a}</strong> de los siguientes cursos han sido finalizados:';
$string['criteria_descr_6'] = '<strong>{$a}</strong> de los siguientes campos de perfil de usuario han sido cumplimentados:';
$string['criteria_descr_7'] = '<strong>{$a}</strong> de las siguientes insignias tienen que haber sido ganadas:';
$string['criteria_descr_8'] = 'Se requiere pertenecer a las siguiente cohortes <strong>{$a}</strong>:';
$string['criteria_descr_9'] = '<strong>{$a}</strong> de las competencias siguientes tengan que ser completadas:';
$string['criteria_descr_bydate'] = 'antes de <em>{$a}</em>';
$string['criteria_descr_grade'] = 'con calificación mínima de <em>{$a}</em>';
$string['criteria_descr_short0'] = 'Finalizados <strong>{$a}</strong> de:';
$string['criteria_descr_short1'] = 'Finalizados <strong>{$a}</strong> de:';
$string['criteria_descr_short2'] = 'Otorgados <strong>{$a}</strong> de:';
$string['criteria_descr_short4'] = 'Finalice el curso';
$string['criteria_descr_short5'] = 'Finalizados <strong>{$a}</strong> de:';
$string['criteria_descr_short6'] = 'Finalizados <strong>{$a}</strong> de:';
$string['criteria_descr_short7'] = 'Completar <strong>{$a}</strong> de:';
$string['criteria_descr_short8'] = 'Membresía de cohorte en <strong>{$a}</strong> de:';
$string['criteria_descr_short9'] = 'Completar <strong>{$a}</strong> de:';
$string['criteria_descr_single_1'] = 'La siguiente actividad debe ser finalizada:';
$string['criteria_descr_single_2'] = 'Esta insignia debe ser otorgada por un usuario con el siguiente rol:';
$string['criteria_descr_single_4'] = 'Los usuarios deben finalizar el curso';
$string['criteria_descr_single_5'] = 'Finalizar los siguientes cursos:';
$string['criteria_descr_single_6'] = 'Los siguientes campos de perfil de usuario deben cumplimentarse:';
$string['criteria_descr_single_7'] = 'La siguiente insignia tiene que ser obtenida:';
$string['criteria_descr_single_8'] = 'Se requiere membresía a la siguiente cohorte:';
$string['criteria_descr_single_9'] = 'Las siguientes competencias deben ser completadas:';
$string['criteria_descr_single_short1'] = 'Finalizado:';
$string['criteria_descr_single_short2'] = 'Otorgado por:';
$string['criteria_descr_single_short4'] = 'Finalizar el curso';
$string['criteria_descr_single_short5'] = 'Finalizado:';
$string['criteria_descr_single_short6'] = 'Finalizado:';
$string['criteria_descr_single_short7'] = 'Completas:';
$string['criteria_descr_single_short8'] = 'Membresía en:';
$string['criteria_descr_single_short9'] = 'Completas:';
$string['criteriacreated'] = 'Criterios de insignia creados correctamente';
$string['criteriadeleted'] = 'Criterios de insignia eliminados correctamente';
$string['criteriasummary'] = 'Resumen de criterios';
$string['criteriaupdated'] = 'Criterios de insignia actualizados correctamente';
$string['criterror'] = 'Incidencias con parámetros actuales';
$string['criterror_help'] = 'Este conjunto de campos muestra todos los parámetros que inicialmente se añadieron a los requisitos de la insignia, pero que ya no están disponibles. Se recomienda que estos parámetros se desactiven para asegurar que los estudiantes puedan obtener esta insignia en el futuro.';
$string['currentimage'] = 'Imagen actual';
$string['currentstatus'] = 'Estado actual:';
$string['dateawarded'] = 'Fecha de la emisión';
$string['dateearned'] = 'Fecha: {$a}';
$string['day'] = 'Día(s)';
$string['deactivate'] = 'Deshabilitar acceso';
$string['deactivatesuccess'] = 'El acceso a las insignias se ha desactivado con éxito.';
$string['defaultissuercontact'] = 'Dirección de correo electrónico del emisor de la insignia';
$string['defaultissuercontact_desc'] = 'Una dirección Email asociada con el emisor de insignia. Para una mochila de Open Badges v2.0, esto es usado para autenticación cuando se publican insignias a una mochila.';
$string['defaultissuername'] = 'Nombre del emisor de insignia';
$string['defaultissuername_desc'] = 'Nombre del agente o autoridad emisora';
$string['defaultissuerpassword'] = 'Contraseña del emisor de la insignia';
$string['defaultissuerpassword_help'] = 'Se necesita una cuenta en el sitio de la mochila con una de dirección email tal como está especificado en la configuración para email del emisor de la insignia en la Administración del sitio / Insignias / Configuraciones de insignias. La contraseña para la cuenta debería ser introducida aquí.';
$string['delbadge'] = '¿Desea borrar la insignia \'{$a}\' y todas las que se han generado a partir de la misma?';
$string['delconfirm'] = 'Borrar y retirar las insignias emitidas';
$string['delcritconfirm'] = '¿Estás seguro de que quiere eliminar este criterio?';
$string['deletehelp'] = '<p>Borrar completamente una insignia significa que todos sus registros de información y criterios se eliminarán de forma permanente. Los usuarios que han ganado esta insignia ya no serán capaces de acceder a ella y mostrarla en sus páginas de perfil.</p> <p>Nota: Los usuarios que hayan ganado esta placa y la hayan subido a su mochila externa, aún la tendrán en su mochila. Sin embargo, no podrán acceder a los criterios ni las páginas de evidencia que enlazan con este sitio web.</p>';
$string['delexternalbackpack'] = 'Eliminar mochila del sitio';
$string['delexternalbackpackconfirm'] = '¿Eliminar mochila del sitio \'{$a}\'?';
$string['delparamconfirm'] = '¿Estás seguro de que quiere eliminar este parámetro?';
$string['description'] = 'Descripción';
$string['disconnect'] = 'Desconectar';
$string['donotaward'] = 'En este momento, esta insignia no está activa, por lo que no se puede conceder a los usuarios. Si usted desea otorgar esta insignia, ponga su estado en activo.';
$string['enablebadges'] = 'Habilitar insignias';
$string['endorsement'] = 'Aprobación (idoneidad)';
$string['error:backpackdatainvalid'] = 'Los datos devueltos por la mochila no son válidos.';
$string['error:backpackemailnotfound'] = 'La dirección de correo \'{$a}\' no está asociada a una mochila. Es necesario <a href="http://backpack.openbadges.org">crear una mochila</a> para esa cuenta o iniciar sesión con otra dirección de correo electrónico.';
$string['error:badgeawardnotfound'] = 'No es posible verificar esta insignia obtenida. Esta insignia puede haber sido revocada.';
$string['error:badgenotfound'] = 'Insignia no encontrada';
$string['error:cannotact'] = 'No se puede activar la insignia.';
$string['error:cannotawardbadge'] = 'No se puede conceder la insignia a un usuario.';
$string['error:cannotdeletecriterion'] = 'Este criterio no puede ser borrado.';
$string['error:cannotrevokebadge'] = 'No es posible revocar la insignia de un usuario.';
$string['error:clone'] = 'No se puede clonar la insignia';
$string['error:connectionunknownreason'] = 'La conexión no tuvo éxito, pero no se conoce el motivo.';
$string['error:duplicatename'] = 'Una insignia con ese nombre ya existe en el sistema.';
$string['error:externalbadgedoesntexist'] = 'Insignia no encontrada';
$string['error:guestuseraccess'] = 'Usted está empleando un acceso de invitado. Para poder ver las insignias necesita entrar con su cuenta de usuario.';
$string['error:invalidcriteriatype'] = 'Tipo de criterios no válido';
$string['error:invalidexpiredate'] = 'La fecha de expiración deberá ser una fecha futura';
$string['error:invalidexpireperiod'] = 'El periodo de expiración no puede ser negativo o igual a cero';
$string['error:invalidparambadge'] = 'La insignia no existe.';
$string['error:invalidparamcohort'] = 'La cohorte no existe.';
$string['error:noactivities'] = 'No hay actividades con criterios de finalización habilitados en este curso';
$string['error:nobadges'] = 'Actualmente no hay insignias con acceso habilitado para ser añadidas como criterio. Una insignia del sitio solamente puede tener como criterio a otras insignias del sitio. Una insignia del curso puede tener otras insignias del curso o insignias del sitio como criterios.';
$string['error:nocohorts'] = 'Sin cohortes';
$string['error:nocourses'] = 'La finalización del curso no está habilitada en ninguno de los cursos de este sitio, por lo que ninguno se mostrará. Puede habilitar la finalización del curso en la configuración del curso.';
$string['error:nogroupslink'] = '<p>Solamente son mostradas colecciones públicas, <a href="{$a}" target="_blank" rel="nofollow">Visite su mochila</a> para crear algunas colecciones públicas.</p>';
$string['error:nogroupssummary'] = '<p>No hay colecciones públicas de insignias disponibles en su mochila. </p>';
$string['error:nopermissiontoview'] = 'No tiene permisos para ver los destinatarios de la insignia';
$string['error:nosuchbadge'] = 'La insignia con id {$a} no existe.';
$string['error:nosuchcohort'] = 'Atención: Esta cohorte no está disponible.';
$string['error:nosuchcourse'] = 'Advertencia: Este curso ya no está disponible.';
$string['error:nosuchfield'] = 'Advertencia: este campo de perfil de usuario ya no está disponible.';
$string['error:nosuchmod'] = 'Advertencia: Esta actividad ya no está disponible.';
$string['error:nosuchrole'] = 'Advertencia: Este rol ya no está disponible.';
$string['error:nosuchuser'] = 'El usuario con esta dirección de correo electrónico no tiene una cuenta con el proveedor de mochila actual.';
$string['error:notifycoursedate'] = 'Advertencia: Las insignias asociadas con la finalización del curso y con la finalización de actividades no se emitirán hasta la fecha de inicio del curso.';
$string['error:parameter'] = 'Advertencia: Al menos un parámetro debe seleccionarse para asegurar el flujo de trabjo correcto para la entrega de la insignia.';
$string['error:relatedbadgedoesntexist'] = 'No hay insignia pública con este identificador';
$string['error:requesterror'] = 'La solicitud de conexión ha fallado (código de error {$a}).';
$string['error:requesttimeout'] = 'Terminó el tiempo de solicitud de conexión antes de que esta se pudiera llevar a cabo.';
$string['error:save'] = 'No se puede guardar la insignia';
$string['error:userdeleted'] = '{$a->user} (Este usuario ya no existe en {$a->site})';
$string['eventbadgearchived'] = 'Insignia archivada';
$string['eventbadgeawarded'] = 'Insignia concedida';
$string['eventbadgecreated'] = 'Insignia creada';
$string['eventbadgecriteriacreated'] = 'Criterios de insignia creados';
$string['eventbadgecriteriadeleted'] = 'Criterios de insignia eliminados';
$string['eventbadgecriteriaupdated'] = 'Criterios de insignia actualizados';
$string['eventbadgedeleted'] = 'Insignia borrada';
$string['eventbadgedisabled'] = 'Insignia deshabilitada';
$string['eventbadgeduplicated'] = 'Insignia duplicada';
$string['eventbadgeenabled'] = 'Insignia habilitada';
$string['eventbadgelistingviewed'] = 'Lista de insignias vista';
$string['eventbadgerevoked'] = 'Insignia revocada';
$string['eventbadgeupdated'] = 'Insignia actualizada';
$string['eventbadgeviewed'] = 'Insignia vista';
$string['existingrecipients'] = 'Destinatarios de insignias existentes';
$string['existsinbackpack'] = 'La insignia ya existe en la mochila';
$string['expired'] = 'Expirada';
$string['expiredate'] = 'Esta insignia expira en {$a}.';
$string['expireddate'] = 'Esta insignia expira en {$a}.';
$string['expiredin'] = 'Caducado {$a}';
$string['expireperiod'] = 'Esta insignia expira {$a} días después de haber sido expedida.';
$string['expireperiodh'] = 'Esta insignia expira {$a} horas después de haber sido expedida.';
$string['expireperiodm'] = 'Esta insignia expira {$a} minutos después de haber sido expedida.';
$string['expireperiods'] = 'Esta insignia expira {$a} segundos después de haber sido expedida.';
$string['expiresin'] = 'Caduca {$a}';
$string['expirydate'] = 'Fecha de expiración';
$string['expirydate_help'] = 'Opcionalmente, las insignias pueden caducar en una fecha determinada, o en una fecha calculada a partir de la fecha en que se entregó al usuario.';
$string['externalbackpack_required'] = 'El proveedor de la mochila no puede estar en blanco';
$string['externalbadges'] = 'Mis insignias de otros sitios web';
$string['externalbadges_help'] = 'En esta área se muestran las insignias de la mochila externa.';
$string['externalbadgesp'] = 'Insignias de otros sitios web';
$string['externalconnectto'] = 'Para mostrar las insignias externas necesita <a href="{$a}">conectarse a una mochila</a> .';
$string['fixed'] = 'Fecha fija';
$string['hidden'] = 'Oculta';
$string['hiddenbadge'] = 'Por desgracia, el propietario de la insignia no ha puesto disponible esta información.';
$string['hostedurl'] = 'URL externa';
$string['hostedurldescription'] = 'URL externa donde está alojada la insignia';
$string['imageauthoremail'] = 'Email del autor de la imagen';
$string['imageauthoremail_help'] = 'Si se especifica, la dirección de email del autor de la imagen de la insignia se muestra en la página de la insignia.';
$string['imageauthorname'] = 'Nombre del autor de la imagen';
$string['imageauthorname_help'] = 'Si se especifica, el nombre del autor de la imagen de la insignia se muestra en la página de la insignia.';
$string['imageauthorurl'] = 'URL del autor de la imagen';
$string['imageauthorurl_help'] = 'Si se especifica, un enlace al sitio web del autor de la imagen de la insignia se muestra en la página de la insignia. La URL debería tener un prefijo http:// o https://.';
$string['imagecaption'] = 'Leyenda de la imagen';
$string['imagecaption_help'] = 'Si se especifica, una leyenda de la imagen se muestra en la página de la insignia.';
$string['includeauthdetails'] = 'Incluir detalles de autenticación con la mochila';
$string['invalidurl'] = 'URL inválida';
$string['issuancedetails'] = 'Caducidad de la insignia';
$string['issuedbadge'] = 'Información de la insignia emitida';
$string['issuedby'] = 'Emitido por {$a}';
$string['issuedon'] = 'Emitido {$a}';
$string['issuerdetails'] = 'Detalles del emisor';
$string['issueremail'] = 'Email';
$string['issueremail_help'] = 'Una dirección email de contacto de la organización que emite la aprobación.';
$string['issuername'] = 'Nombre del emisor';
$string['issuername_endorsement'] = 'Nombre de quien aprueba';
$string['issuername_endorsement_help'] = 'El nombre de quien aprueba.';
$string['issuername_help'] = 'Nombre del agente o autoridad emisora';
$string['issuerurl'] = 'URL del emisor';
$string['issuerurl_help'] = 'El sitio web de la organización que emite la aprobación. La URL debería tener un prefijo http:// o https://.';
$string['language'] = 'Idioma';
$string['language_help'] = 'El idioma usado en la página de la insignia.';
$string['listbackpacks'] = 'Lista de mochilas';
$string['localbadges'] = 'Mis insignias del sitio web {$a}';
$string['localbadgesh'] = 'Mis insignias de este sitio web';
$string['localbadgesh_help'] = 'Todas los insignias conseguidas en este sitio web por finalizar cursos, actividades de los cursos y otros requisitos.

Aquí puede gestionar sus insignias haciéndolas públicas o privadas en su página de perfil.

Puede descargar todas sus insignias o cada una por separado y guardarlas en su ordenador. Las insignias descargadas pueden añadirse a su servicio de mochila externo.';
$string['localbadgesp'] = 'Insignias de {$a}:';
$string['localconnectto'] = 'Para compartir estas insignias fuera de este sitio web es necesario <a href="{$a}">conectarse a una mochila</a> .';
$string['loginbackpacktitle'] = '<strong>Autentíquese en su mochila</strong>';
$string['makeprivate'] = 'hacer privado';
$string['makepublic'] = 'Hacer público';
$string['managebackpacks'] = 'Gestionar mochilas';
$string['managebadges'] = 'Gestionar insignias';
$string['message'] = 'Cuerpo del mensaje';
$string['messagebody'] = '<p> ¡Se le ha otorgado una insignia "%badgename%"!</p>
<p> Puede encontrar más información sobre esta insignia en la %badgelink% página de información de insignias. </p>
<p> Puede gestionar y descargar la insignia desde {$a}. </p>';
$string['messagesubject'] = '¡Felicidades, acaba de ganar una insignia!';
$string['method'] = 'Este criterio se cumple cuando...';
$string['mingrade'] = 'Calificación mínima requerida';
$string['month'] = 'Mes(es)';
$string['moredetails'] = 'Más detalles';
$string['mybackpack'] = 'Configuración de Mi mochila';
$string['mybadges'] = 'Mis insignias';
$string['namewithlink'] = 'Nombre con enlace';
$string['never'] = 'Nunca';
$string['newbackpack'] = 'Añadir una nueva mochila';
$string['newbadge'] = 'Añadir una nueva insignia';
$string['newimage'] = 'Nueva imagen';
$string['noalignment'] = 'Esta insignia no tiene ninguna habilidad externa o estándar especificado.';
$string['noawards'] = 'Esta insignia aún no se ha ganado.';
$string['nobackpack'] = 'No hay servicio de mochila conectada a esta cuenta. <br/>';
$string['nobackpackbadgessummary'] = 'No hay insignias en las colecciones que Usted ha seleccionado.';
$string['nobackpackcollectionssummary'] = 'No ha sido seleccionada ninguna colección de insignias.';
$string['nobackpacks'] = 'No hay mochilas disponibles';
$string['nobadges'] = 'Actualmente no hay insignias disponibles que los usuarios puedan conseguir.';
$string['nocompetencies'] = 'Sin competencias seleccionadas.';
$string['nocriteria'] = 'Los criterios para esta insignia no se han establecido todavía.';
$string['noendorsement'] = 'Esta insignia no tiene aprobación.';
$string['noexpiry'] = 'Esta insignia no tiene fecha de expiración.';
$string['nomatchingawards'] = 'No hay receptores coincidentes que hayan ganado esta insignia aún.';
$string['nomatchingbadges'] = 'No hay insignias coincidentes disponibles para que las consigan los usuarios.';
$string['noparamstoadd'] = 'No hay parámetros adicionales disponibles para añadir a este requerimieto de la insignia.';
$string['norelated'] = 'Esta insignia no tiene ninguna insignia relacionada.';
$string['notacceptedrole'] = 'Su rol asignado actualmente no es uno de los roles que pueden emitir manualmente esta insignia. <br/>
Si quiere ver los usuarios que ya han ganado esta insignia, puede visitar la página {$a}.';
$string['notconnected'] = 'No conectado';
$string['notealignment'] = 'Estándares o habilidades externas, con los que la insignia está alineada, deben ser especificados. Cualquier estándar o habilidad externa son mostrados en la página de la insignia.';
$string['noteendorsement'] = 'La aprobación por un tercero puede ser usada para añadirle valor a la insignia. Por ejemplo, una insignia emitida por un profesor puede ser aprobada por la escuela, o una insignia emitida por una entidad local puede ser aprobada por una entidad nacional.';
$string['noterelated'] = 'Las insignias con una conexión serán marcadas como relacionadas. Por ejemplo, las insignias con el mismo criterio que son mostradas en diferentes idiomas pueden ser marcadas como relacionadas. Cualquier insignia relacionada es mostrada en la página de insignias.';
$string['nothingtoadd'] = 'No existen criterios disponibles para añadir.';
$string['notification'] = 'Notificar al creador de la insignia';
$string['notification_help'] = 'Este ajuste gestiona las notificaciones enviadas a un creador de insignias para hacerles saber que la insignia ha sido emitida.

Las siguientes opciones están disponibles:

* **NUNCA** - No enviar notificaciones.

* **SIEMPRE** - Enviar una notificación cada vez que se concede esta insignia.

* **DIARIAMENTE** - Enviar notificaciones una vez al día.

* **SEMANALMENTE** - Enviar notificaciones una vez a la semana.

*** MENSUALMENTE** - Enviar notificaciones una vez al mes.';
$string['notifydaily'] = 'Dirariamente';
$string['notifyevery'] = 'Siempre';
$string['notifymonthly'] = 'Mensualmente';
$string['notifyweekly'] = 'Semanalmente';
$string['numawards'] = 'Esta insignia ha sido emitida para <a href="{$a->link}">{$a->count}</a> usuario(s).';
$string['numawardstat'] = 'Esta insignia ha sido emitida para {$a} usuario (s).';
$string['oauth2issuer'] = 'Servicios OAuth 2';
$string['openbadgesv1'] = 'Open Badges v1.0';
$string['openbadgesv2'] = 'Open Badges v2.0';
$string['openbadgesv2p1'] = 'Open Badges v2.1';
$string['othernavigation'] = 'Otra navegación ...';
$string['overallcrit'] = 'de los criterios seleccionados se cumple.';
$string['password_required'] = 'La contraseña no puede estar en blanco';
$string['potentialrecipients'] = 'Potenciales destinatarios de la insignia';
$string['preferences'] = 'Preferencias de insignias';
$string['privacy:metadata:backpack'] = 'Un registro de las mochilas del usuario';
$string['privacy:metadata:backpack:backpackuid'] = 'El identificador único de la mochila';
$string['privacy:metadata:backpack:email'] = 'El email asociado con la mochila';
$string['privacy:metadata:backpack:externalbackpackid'] = 'La ID de la mochila';
$string['privacy:metadata:backpack:userid'] = 'El ID del usuario de la mochila';
$string['privacy:metadata:backpackoauth2'] = 'Información OAuth 2 cuando el usuario se conecta a una mochila externa';
$string['privacy:metadata:backpackoauth2:issuerid'] = 'ID del servicio Oauth 2';
$string['privacy:metadata:backpackoauth2:scope'] = 'Enlistar el alcance de conexión de mochila';
$string['privacy:metadata:backpackoauth2:token'] = 'El token (ficha) de conexión de mochila';
$string['privacy:metadata:backpackoauth2:userid'] = 'La ID del usuario con conexión de mochila';
$string['privacy:metadata:backpackoauth2:usermodified'] = 'La ID del usuario que modificó el contenido';
$string['privacy:metadata:badge'] = 'Una colección de insignias';
$string['privacy:metadata:badge:timecreated'] = 'La hora en la cual fue creada la insignia';
$string['privacy:metadata:badge:timemodified'] = 'La hora en la cual fue modificada por última vez la insignia';
$string['privacy:metadata:badge:usercreated'] = 'El ID del usuario que creó la insignia';
$string['privacy:metadata:badge:usermodified'] = 'El ID del usuario que modificó la insignia';
$string['privacy:metadata:criteriamet'] = 'Una colección de criterios que han sido cumplidos';
$string['privacy:metadata:criteriamet:datemet'] = 'La fecha en la cual se cumplieron los criterios';
$string['privacy:metadata:criteriamet:userid'] = 'El ID del usuario que ha cumplido con los criterios';
$string['privacy:metadata:external:backpacks'] = 'Información compartida cuando los usuarios envían sus insignias a una mochila externa';
$string['privacy:metadata:external:backpacks:badge'] = 'El nombre de la insignia';
$string['privacy:metadata:external:backpacks:description'] = 'La descripción de la insignia';
$string['privacy:metadata:external:backpacks:image'] = 'La imagen de la insignia';
$string['privacy:metadata:external:backpacks:issuer'] = 'Alguna información sobre el emisor';
$string['privacy:metadata:external:backpacks:url'] = 'La URL de Moodle en donde puede verse la información de la insignia emitida';
$string['privacy:metadata:issued'] = 'Un registro de insignias otorgadas';
$string['privacy:metadata:issued:dateexpire'] = 'La fecha en la cual caduca la insignia';
$string['privacy:metadata:issued:dateissued'] = 'La fecha de la distinción';
$string['privacy:metadata:issued:userid'] = 'El ID del usuario a quien se le otorgó una insignia';
$string['privacy:metadata:manualaward'] = 'Un registro de otorgamientos manuales';
$string['privacy:metadata:manualaward:datemet'] = 'La fecha en la cual al usuario le fue otorgada la insignia';
$string['privacy:metadata:manualaward:issuerid'] = 'El ID del usuario que otorga la insignia';
$string['privacy:metadata:manualaward:issuerrole'] = 'El rol del usuario que otorga la insignia';
$string['privacy:metadata:manualaward:recipientid'] = 'El ID del usuario al que se le otorga manualmente una insignia';
$string['recipient'] = 'Destinatario de la insignia';
$string['recipients'] = 'Destinatarios de la insignia';
$string['recipientvalidationproblem'] = 'Este usuario no puede verificarse como receptor de esta insignia.';
$string['relatedbages'] = 'Insignias relacionadas';
$string['relative'] = 'Fecha relativa';
$string['requiredbadge'] = 'Al menos una insigina debe ser añadida como criterio.';
$string['requiredcohort'] = 'Al menos una cohorte debe ser añadida como criterio.';
$string['requiredcompetency'] = 'Al menos una competencia debería ser añadida al criterio de la competencia.';
$string['requiredcourse'] = 'Al menos un curso debe ser añadido al grupo de criterios de curso';
$string['reviewbadge'] = 'Cambios en el acceso insignia';
$string['reviewconfirm'] = '<p> Con esto, hará que su insignia sea visible para los usuarios y les permita empezar a ganarla</p>

<p> Es posible que algunos usuarios ya cumplan los criterios de esta insignia y que se les entregue inmediatamente después de que la haya activado. </p>

<p> Una vez que la insignia haya sido emitida será <strong>bloqueada</strong> - ciertos ajustes incluyendo los criterios y los ajustes de caducidad ya no se podrán modificar. </p>

<p> ¿Está seguro de que desea permitir el acceso a la insignia \'{$a}\'? </p>';
$string['revoke'] = 'Quitar insignia';
$string['save'] = 'Guardar';
$string['searchname'] = 'Buscar por nombre';
$string['selectaward'] = 'Por favor, seleccione el rol que le gustaría usar para otorgar esta insignia:';
$string['selectgroup_end'] = 'Solamente son mostradas colecciones públicas,  <a href="{$a}">visite su mochila</a> para crear más colecciones públicas.';
$string['selectgroup_start'] = 'Seleccione las colecciones de la mochila que se mostrarán en este sitio:';
$string['selecting'] = 'Con insignias seleccionadas ...';
$string['setup'] = 'Configurar conexión';
$string['sitebackpackdeleted'] = 'La mochila del sitio ha sido eliminada.';
$string['sitebackpacknotdeleted'] = 'Esta mochila no pudo ser eliminada porque actualmente es la predeterminada del sitio.';
$string['sitebackpackwarning'] = 'No fue posible conectarse a mochila. <br/><br/>Revise que la configuración administrativa "Dirección Email del emisor de insignia" sea el Email válido para una cuenta en el sitio web de la mochila. <br/><br/>Revise que la "Contraseña del emisor de insignia" en la <a href="{$a->url}">página de configuraciones de mochila del sitio </a>, sea la contraseña correcta para la cuenta en el sitio web de la mochila. <br/><br/>La mochila regresó: "{$a->warning}"';
$string['sitebadges'] = 'Insignias del sitio';
$string['sitebadges_help'] = 'Las insignias del sitio sólo pueden ser otorgadas a los usuarios de las actividades relacionadas con el sitio. Estos incluyen completar una serie de cursos o partes de los perfiles de usuario. Las insignias del sitio también pueden ser emitidas manualmente por un usuario para otro.

La insignias para las actividades relacionadas con los cursos deben ser creados a nivel de curso. Las insignias de curso se pueden encontrar en Administración >  Insignias';
$string['sitebadgetitle'] = 'Insignia del sitio {$a}';
$string['status'] = 'Estado de la insignia';
$string['status_help'] = 'El estado de una insignia determina su comportamiento en el sistema:

* ** DISPONIBLE ** - Significa que esta insignia puede ser ganada por los usuarios. Mientras que una insignia está disponible para los usuarios, los criterios no pueden ser modificados.

* ** NO DISPONIBLE ** - Significa que esta insignia no está disponible para los usuarios y no se puede ganar o emitir manualmente. Si dicha insignia no ha sido emitida antes, los criterios pueden cambiarse.

Una vez que una insignia ha sido emitida por lo menos para un usuario, pasa automáticamente a **BLOQUEADA**.  Los usuarios pueden ontener insignias bloqueadas,  pero sus criterios ya no se pueden cambiar. Si necesita modificar detalles o criterios de una insignia bloqueada, puede duplicar esta insignia y hacer todos los cambios necesarios.

* ¿Por qué bloqueamos insignias? *

Para asegurarnos de que todos los usuarios tengan los mismos requisitos para ganar una insignia. En este momento, no es posible revocar insignias. Si permitimos que los requisitos de las insignias se puedan modificar en cualquier momento, lo más probable es que al final usuarios que tienen la misma insignia hayan tenido que satisfacer requisitos completamente diferentes.';
$string['statusmessage_0'] = 'Esta insignia no está en este momento disponible para los usuarios. Habilite el acceso si desea que los usuarios puedan ganar esta insignia.';
$string['statusmessage_1'] = 'Esta insignia está en este momento disponible para los usuarios. Deshabilite el acceso para hacer cualquier cambio.';
$string['statusmessage_2'] = 'Esta insignia no está en este momento disponible para los usuarios, y los criterios están bloqueados. Habilite el acceso si desea que los usuarios puedan ganar esta insignia.';
$string['statusmessage_3'] = 'Esta insignia está en este momento disponible para los usuarios y sus criterios están bloqueados';
$string['statusmessage_4'] = 'Esta insignia está en este momento archivada.';
$string['subject'] = 'Asunto del mensaje';
$string['tagarea_badge'] = 'Insignias';
$string['tags'] = 'Etiquetas';
$string['targetcode'] = 'Código';
$string['targetcode_help'] = 'Un identificador de cadena de caracteres único para referenciar el estándar o habilidad externa dentro de su estructura.';
$string['targetdescription'] = 'Descripción';
$string['targetdescription_help'] = 'Descripción breve del estándar o habilidad externa.';
$string['targetframework'] = 'Contexto';
$string['targetframework_help'] = 'El nombre de la estructura estándar o habilidad externa.';
$string['targetname'] = 'Nombre';
$string['targetname_help'] = 'La habilidad externa o estándar con la cual está alineada la insignia.';
$string['targeturl'] = 'URL';
$string['targeturl_help'] = 'Un enlace a una página que describe la habilidad externa o el estándar. La URL debe tener un prefijo http: // o https: //.';
$string['testbackpack'] = 'Probar mochila \'{$a}\'';
$string['testsettings'] = 'Configuraciones de prueba';
$string['type'] = 'Tipo';
$string['userbadges'] = 'Insignias del usuario';
$string['variablesubstitution'] = 'Sustitución de variables en los mensajes.';
$string['variablesubstitution_help'] = 'En un mensaje de insignia, ciertas variables se pueden insertar en el asunto y/o en el cuerpo del mensaje para que puedan ser sustituidas por valores reales cuando se envía el mensaje. Las variables deben insertarse en el el texto tal y como se muestra a continuación. Se pueden utilizar las siguientes variables:

%badgename%
: Será reemplazado por el nombre completo de la insignia.

%username%
: Será reemplazado por el nombre completo del destinatario.

%badgelink%
: Será reemplazado por el URL público con información sobre la insignia emitida.';
$string['verifyemail'] = 'Verificar correo electrónico';
$string['version'] = 'Versión';
$string['version_help'] = 'El campo de versión puede ser usado para llevar un registro del desarrollo de la insignia. Si se especifica, se muestra la versión en la página de la insignia.';
$string['viewbadge'] = 'Ver insignia emitida';
$string['visible'] = 'Visible';
$string['warnexpired'] = '(¡Esta insignia ha expirado!)';
$string['year'] = 'Año(s)';
