<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'grouptool', language 'fr', version '4.4'.
 *
 * @package     grouptool
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activated_group'] = 'Groupe activé';
$string['activated_groups'] = 'Groupes activés !';
$string['active'] = 'Actif';
$string['activegroups'] = 'Groupes actifs';
$string['add_member'] = 'Ajouter <strong>{$a->username}</strong> au groupe <strong>{$a->groupname}</strong>';
$string['added_member'] = '<strong>{$a->username}</strong> ajouté au groupe <strong>{$a->groupname}</strong>';
$string['administration'] = 'Administration';
$string['administration_alt'] = 'Création de groupe(ment), et réglage des groupes actifs pour cette instance';
$string['agroups'] = 'Groupes activés';
$string['ajax_edit_size_help'] = 'Enregistrer la nouvelle taille avec &lt;Enter&gt;, utiliser &lt;ESC&gt; pour annuler, laisser vide pour effacer la taille individuelle.';
$string['all_groups_full'] = '<strong>{$a}</strong> n’a pu être inscrit dans aucun groupe car tous les groupes sont complets !';
$string['allow_multiple'] = 'Inscription multiple';
$string['allow_multiple_help'] = 'Permettre aux étudiants de s’inscrire dans plus d\'un groupe à la fois. Vous devez spécifier combien de groupes ils doivent choisir au moins (= nombre minimum de groupes à choisir) et combien de groupes ils peuvent choisir au maximum (=nombre maximum de groupes à choisir).';
$string['allow_reg'] = 'Autoriser l’auto-inscription';
$string['allow_reg_help'] = 'Permettre l’auto-inscription des étudiants pour qu\'ils puissent s\'inscrire eux-mêmes dans les groupes actifs, qui sont choisis plus bas.';
$string['allow_unreg'] = 'Autoriser la désinscription';
$string['allow_unreg_help'] = 'Autoriser les étudiants de se désinscrire ou de changer de groupe avant une date limite (optionnelle).';
$string['allowed'] = 'Autorisé';
$string['already_marked'] = 'Ce groupe a déjà été marqué pour l’inscription !';
$string['already_member'] = '<strong>{$a->username}</strong> est déjà membre du groupe <strong>{$a->groupname}</strong>';
$string['already_occupied'] = 'La place dans le groupe <strong>{$a->grpname}</strong> est déjà occupée parce qu’un autre membre a complété l’enregistrement plus rapidement. Veuillez chercher un autre groupe !';
$string['already_queued'] = '<strong>{$a->username}</strong> est déjà en file d’attente dans le groupe <strong>{$a->groupname}</strong> !';
$string['already_registered'] = '<strong>{$a->username}</strong> est déjà inscrit dans le groupe <strong>{$a->groupname}</strong> !';
$string['alwaysshowdescription'] = 'Toujours afficher la description';
$string['alwaysshowdescription_help'] = 'Si désactivé, la description du devoir ci-dessus ne sera visible pour les étudiants qu\'à partir de la date de « Début de l\'inscription ».';
$string['asterisk_marks_moodle_registrations'] = 'Les utilisateurs marqués d’un astérisque (*) sont déjà inscrits dans le groupe Moodle concerné.';
$string['availabledate'] = 'Début de l’inscription ';
$string['availabledate_help'] = 'Début de la période d’inscription. Après cette date les étudiants pourront s\'inscrire eux-mêmes dans les groupes sélectionnés (si activé).';
$string['availabledateno'] = 'Toujours disponible';
$string['calendaravailable'] = 'L’inscription {$a} commence';
$string['calendardue'] = 'L’inscription {$a} est passée';
$string['cant_enrol'] = 'Impossible d’inscrire automatiquement un utilisateur à un cours.';
$string['cfg_addinstanceset_head'] = 'Paramètres supplémentaires de l’instance';
$string['cfg_addinstanceset_head_info'] = 'Paramètres supplémentaires pour Grouptool.';
$string['cfg_admin_head'] = 'Paramètres par défaut de la vue d’administration';
$string['cfg_admin_head_info'] = 'Paramètres standard pour l’onglet d’administration dans la vue de Grouptool.';
$string['cfg_allow_multiple'] = 'Inscriptions multiples';
$string['cfg_allow_multiple_desc'] = 'Permettre aux étudiants d’être inscrits dans plus d’un groupe à la fois par défaut.';
$string['cfg_allow_reg'] = 'Autoriser l’auto-inscription';
$string['cfg_allow_reg_desc'] = 'Permettre aux étudiants de s’inscrire eux-mêmes par défaut';
$string['cfg_allow_unreg'] = 'Autoriser la désinscription';
$string['cfg_allow_unreg_desc'] = 'Les utilisateurs doivent-ils pouvoir se désinscrire et changer de groupe ?';
$string['cfg_choose_max'] = 'Choisir le maximum';
$string['cfg_choose_max_desc'] = 'À combien de groupes les utilisateurs doivent-ils pouvoir s’inscrire simultanément par défaut ?';
$string['cfg_choose_min'] = 'Choisir le minimum';
$string['cfg_choose_min_desc'] = 'Combien de groupes les utilisateurs peuvent-ils choisir par défaut ?';
$string['cfg_force_dereg'] = 'Forcer la désinscription dans Grouptool';
$string['cfg_force_dereg_desc'] = 'Forcer la désinscription non seulement de Grouptool mais aussi des groupes Moodle.';
$string['cfg_force_importreg'] = 'Forcer l’inscription dans Grouptool';
$string['cfg_force_importreg_desc'] = 'Forcer via Grouptool dans les groupes Moodle les utilisateurs importés à s’inscrire de force dans cette instance de Grouptool également.';
$string['cfg_groups_queues_limit'] = 'Places dans la file d’attente par groupe';
$string['cfg_groups_queues_limit_desc'] = 'Détermine le nombre d’étudiants différents qui peuvent être mis en file d’attente dans un groupe en même temps par défaut.';
$string['cfg_grpsize'] = 'Taille globale du groupe standard';
$string['cfg_grpsize_desc'] = 'Taille de groupe standard utilisée partout dans Grouptool';
$string['cfg_ifgroupdeleted'] = 'Si des groupes sont supprimés';
$string['cfg_ifgroupdeleted_desc'] = 'Les groupes supprimés doivent-ils être recréés pour l’instance grouptool ou les références dans grouptool (y compris les données de groupe, les inscriptions et la file d’attente) doivent-elles être supprimées ? Remarque : si vous sélectionnez "recréer le groupe", les groupes seront recréés automatiquement après leur suppression sous "Administration du cours / Utilisateurs / Groupes".';
$string['cfg_ifmemberadded'] = 'Si des membres du groupe sont ajoutés';
$string['cfg_ifmemberadded_desc'] = 'Les nouveaux membres d’un groupe ajoutés via moodle doivent-ils également être enregistrés dans grouptool ou doivent-ils être ignorés ?';
$string['cfg_ifmemberremoved'] = 'Si des membres du groupe sont retirés';
$string['cfg_ifmemberremoved_desc'] = 'Les enregistrements de grouptool doivent-ils être supprimés si les utilisateurs sont supprimés du groupe moodle correspondant ?';
$string['cfg_immediate_reg'] = 'Inscription immédiate';
$string['cfg_immediate_reg_desc'] = 'Chaque inscription doit-elle être faite au travers des groupes moodle ?';
$string['cfg_importfields'] = 'Comparer les champs pour l’importation / la désinscription';
$string['cfg_importfields_desc'] = 'Définit quels champs de la table des utilisateurs doivent être comparés aux données lors de l\'importation / la désinscription des utilisateurs. Une recherche sur les champs un par un est effectuée jusqu’à ce qu\'une correspondance soit trouvée. Les valeurs possibles/utiles sont par exemple: nom d’utilisateur, identifiant d’utilisateur, email. ATTENTION : il n\'est pas vérifié que les noms des champs sont corrects. Caractères autorisés: a-z, A-Z et « , »';
$string['cfg_instance_head'] = 'Paramètres par défaut de l’instance';
$string['cfg_instance_head_info'] = 'Paramètres par défaut pour les nouvelles instances de grouptool.';
$string['cfg_max_queues'] = 'Nombre maximal de places simultanées dans la file d’attente par participant';
$string['cfg_max_queues_desc'] = 'Définit dans combien de groupes différents un utilisateur peut être mis en file d’attente par défaut.';
$string['cfg_moodlesync_head'] = 'Comportement de synchronisation';
$string['cfg_moodlesync_head_info'] = 'Comment les grouptools doivent se comporter si des membres de groupes sont ajoutés/supprimés ou si des groupes sont supprimés';
$string['cfg_name_scheme'] = 'Schéma de dénomination standard';
$string['cfg_name_scheme_desc'] = 'Schéma de dénomination standard utilisé pour la création de groupe';
$string['cfg_show_add_info'] = 'Montre de l’information supplémentaire sur le groupe lors de l\'auto-inscription';
$string['cfg_show_add_info_desc'] = 'Montre de l’information supplémentaire provenant des groupes Moodle dans l’onglet d’inscription, telles que des descriptions ou des images';
$string['cfg_show_members'] = 'Afficher les membres du groupe';
$string['cfg_show_members_desc'] = 'Détermine si les membres des groupes sont visibles par défaut';
$string['cfg_use_individual'] = 'Utiliser une taille individuelle';
$string['cfg_use_individual_desc'] = 'Si une taille de groupe individuelle doit être utilisée pour chaque groupe par défaut';
$string['cfg_use_queue'] = 'Utiliser la file d’attente';
$string['cfg_use_queue_desc'] = 'Si la mise en fille d\'attente pour les groupes complets doit être utilisée par défaut.';
$string['cfg_use_size'] = 'Utiliser la taille du groupe';
$string['cfg_use_size_desc'] = 'Si la taille des groupes doit être limitée par défaut';
$string['cfg_users_queues_limit'] = 'Places en file d’attente par utilisateur';
$string['cfg_users_queues_limit_desc'] = 'Détermine le nombre de groupes différents dans lesquels un utilisateur peut être mis en file d’attente en même temps par défaut.';
$string['change_group'] = 'Changer de groupe';
$string['change_group_to'] = 'Poursuivre le changement de groupe pour <strong>{$a->groupname}</strong> ?';
$string['change_group_to_success'] = 'Changement de groupe réussi ! <strong>{$a->username}</strong> est maintenant enregistré dans le groupe <strong>{$a->groupname}</strong> !';
$string['changes_saved'] = 'Modifications enregistrées';
$string['checkbox_control_header'] = 'Dé-/sélectionner les groupes et groupements';
$string['choose'] = 'Choisir…';
$string['choose_group'] = 'Vous devez choisir un groupe cible';
$string['choose_max'] = 'Nombre maximum de groupes à choisir';
$string['choose_max_text'] = 'Vous pouvez choisir au maximum <strong>{$a}</strong> groupe(s) !';
$string['choose_min'] = 'Nombre minimum de groupes à choisir';
$string['choose_min_max_text'] = 'Vous devez choisir entre <strong>{$a->min}</strong> et <strong>{$a->max}</strong> groupes !';
$string['choose_min_text'] = 'Vous devez choisir au moins <strong>{$a}</strong> groupe(s) !';
$string['choose_minmax_title'] = 'Groupes à choisir';
$string['choose_targetgroup_import'] = 'Importer dans le(s) groupe(s)';
$string['choose_targetgroup_unregister'] = 'Désinscrire d’un ou plusieurs groupes';
$string['chooseactivity'] = 'Vous devez choisir une activité avant de pouvoir afficher les données !';
$string['completiondetail:register'] = 'Inscrire dans les groupes : {$a}';
$string['completionregister'] = 'L\'étudiant doit être inscrit dans les groupes :';
$string['condition_prevent_access'] = 'Les conditions actuelles vous empêchent d\'accéder à l\'instance grouptool !';
$string['confirm_delete'] = 'Vous êtes sur le point de supprimer complètement le groupe. Cela retirera tous les membres de ce groupe de manière irrévocable. Êtes-vous SÛR de vouloir continuer ?';
$string['confirm_delete_title'] = 'Voulez-vous vraiment supprimer cet élément ?';
$string['copy'] = 'Copier';
$string['copy_chosen'] = 'Copie sélectionnée';
$string['copy_grade_confirm'] = 'Poursuivre la copie de cette note ?';
$string['copy_grade_overwrite_confirm'] = 'Poursuivre la copie de cette note ? Les notes préexistantes seront écrasées !';
$string['copy_grades_confirm'] = 'Poursuivre la copie de ces notes ?';
$string['copy_grades_errors'] = 'Au moins une erreur au cours de la copie des notes :';
$string['copy_grades_overwrite_confirm'] = 'Poursuivre la copie de ces notes ? Les notes préexistantes seront écrasées !';
$string['copy_grades_success'] = 'Les notes suivantes ont été mises à jours avec succès :';
$string['copy_refgrades_feedback'] = 'Copier les notes de référence et les feedbacks pour les autres membres des groupes sélectionnés';
$string['copygrade'] = 'Copier la note';
$string['could_not_add'] = 'Impossible d\'ajouter <strong>{$a->username}</strong> au groupe <strong>{$a->groupname}</strong>';
$string['couldnt_move_down'] = 'Impossible de déplacer le groupe vers le bas !';
$string['couldnt_move_up'] = 'Impossible de déplacer le groupe vers le haut !';
$string['createGroups'] = 'Créer les groupes';
$string['create_1_person_groups'] = 'Créer des groupes individuels';
$string['create_assign_groupings'] = 'Créer/Affecter des groupements';
$string['create_fromto_groups'] = 'Créer des groupes avec des nombres issus d’un intervalle (par exemple de 34 à 89), <strong>sans attribution automatique</strong> des membres du groupe';
$string['create_fromto_groups_help'] = 'Créer des groupes avec des nombres d\'un intervalle (e.g. de 34 à 89) - utiliser ce mode pour créer des groupes (i.e. Groupe 4, Groupe 5, Groupe 6). Insérer simplement les limites et le nombre de chiffres à utiliser pour les noms (i.e. 1, 01, 001, 0001 ...). Il est possible de définir une taille de groupe avec "Nombre de membres de groupe M". Il n\'y aura <strong>pas d\'allocation automatique</strong> des membres de groupes.';
$string['create_groupings_confirm'] = 'Continuer à créer des groupements comme prévisualisé ci-dessous ?';
$string['create_groupings_confirm_problem'] = 'Au moins une erreur (se référer à la prévisualisation ci-dessus) !';
$string['create_groups_confirm'] = 'Continuer à créer des groupes comme prévisualisé ci-dessous ?';
$string['create_n_m_groups'] = 'Créer N groupes pour M membres, <strong>sans attribution automatique</strong> des membres du groupe';
$string['createinsertgrouping'] = 'Ajouter au groupement';
$string['deactivated_group'] = 'Groupe désactivé';
$string['deactivated_groups'] = 'Groupes désactivés !';
$string['define_amount_groups'] = 'Définir un nombre N de groupes';
$string['define_amount_members'] = 'Définir un nombre M de membres dans le groupe';
$string['delete_reference'] = 'Supprimer de Grouptool';
$string['description'] = 'Description';
$string['deselect'] = 'Désélectionner';
$string['determinismerror'] = 'La fin de l\'inscription ne peut pas être avant le début de l\'inscription, ni dans le passé.';
$string['digits'] = 'Nombre de chiffres minimal';
$string['disabled'] = 'Désactivé';
$string['drag'] = 'Déplacer';
$string['due'] = 'Grouptool à rendre';
$string['duedate'] = 'Fin de l’inscription ';
$string['duedate_help'] = 'Fin de la période d’inscription. Après cette date, les membres ne peuvent plus s’inscrire eux-mêmes et les référents ont accès à la fonctionnalité de résolution des files d’attente, etc.';
$string['duedateno'] = 'Pas de dates limites';
$string['early'] = '{$a} en avance';
$string['error_activating_group'] = 'Erreur lors de l’activation du groupe <strong>{$a->groupid}</strong> dans le grouptool <strong>{$a->grouptoolid}</strong> !';
$string['error_at'] = 'Erreur à';
$string['error_deactivating_group'] = 'Erreur lors de la désactivation du groupe <strong>{$a->groupid}</strong> dans le grouptool <strong>{$a->grouptoolid}</strong> !';
$string['error_getting_data'] = 'Erreur lors de la récupération des données de groupe! Aucun ou plus d\'un groupe ont été renvoyés !';
$string['error_saving_new_order'] = 'Erreur lors de la sauvegarde du nouvel ordre pour les groupes : <strong>{$a}</strong>';
$string['eventagrpcreated'] = 'Groupe actif créé';
$string['eventagrpdeleted'] = 'Groupe actif supprimé';
$string['eventagrpsupdated'] = 'Groupes actifs mis à jour';
$string['eventdequeuingstarted'] = 'Résolution de file d’attente commencée';
$string['eventgroupcreationstarted'] = 'Création des groupes commencée';
$string['eventgroupgraded'] = 'Groupe évalué';
$string['eventgroupingscreated'] = 'Groupements créés';
$string['eventgrouprecreated'] = 'Groupe recréé';
$string['eventoverviewexported'] = 'Aperçu exporté';
$string['eventqueueentrycreated'] = 'Entrée de liste d’attente créée';
$string['eventqueueentrydeleted'] = 'Entrée de liste d\'attente supprimée';
$string['eventregistrationcreated'] = 'Inscription créée';
$string['eventregistrationdeleted'] = 'Inscription supprimée';
$string['eventregistrationpushstarted'] = 'Envoi des inscriptions commencé';
$string['eventuserimported'] = 'Utilisateur importé';
$string['eventuserlistexported'] = 'Liste d’utilisateurs importée';
$string['eventusermoved'] = 'Utilisateur déplacé';
$string['exceedgroupqueuelimit'] = 'Dépassement de la limite de liste d\'attente du groupe !';
$string['exceedgroupsize'] = 'Dépassement de la limite de la taille du groupe !';
$string['exceeduserqueuelimit'] = 'Dépassement de la limite du nombre d’utilisateurs dans la liste d’attente !';
$string['exceeduserreglimit'] = 'Dépassement de la limite du nombre d’utilisateurs inscrits !';
$string['feedbackplural'] = 'Feedbacks';
$string['filters_legend'] = 'Filtres';
$string['filterunoccupied'] = 'Afficher uniquement les groupes ayant des places libres';
$string['followchanges'] = 'Suivre les modifications';
$string['forceregistration'] = 'Forcer l’enregistrement dans Grouptool';
$string['forceregistration_help'] = 'Noter que les groupes du grouptool diffèrent fondamentalement des groupes standard du cours. Sélectionner la case pour importer les utilisateurs dans les groupes du grouptool ainsi que dans les groupes standard du cours.';
$string['found_multiple'] = 'Impossible d\'identifier de façon unique, plusieurs utilisateurs trouvés :';
$string['free'] = 'Libre';
$string['fromgttoerror'] = 'La valeur d\'arrivée doit être supérieure ou égale à la valeur de départ';
$string['fullgroup'] = 'Le groupe est complet';
$string['general_information'] = 'Information générale';
$string['general_registration_exception'] = 'Une exception d’inscription générale s’est produite et nous ne pouvons pas en déterminer la raison automatiquement !';
$string['global_userstats'] = '<strong>{$a->reg_users}</strong> sur <strong>{$a->users}</strong> utilisateurs sont inscrits. <strong>{$a->notreg_users}</strong> ne sont toujours pas inscrits.';
$string['grading'] = 'Evaluation';
$string['grading_activity_title'] = 'Activité';
$string['grading_alt'] = 'Outils pour copier des notes d\'un membre de groupe aux autres membres du groupe, soit pour un groupe ou pour un ensemble de  groupes.';
$string['grading_filter_select_title'] = 'Groupe ou groupes';
$string['grading_filter_select_title_help'] = 'Choisir quel groupe ou quels groupes utiliser :<ul><li>Sans conflit - tous les groupes pour lesquels un seul membre a été évalué pour l\'activité choisie</li><li>Tous - tous les groupes</li><li>"Nom de groupe" - seulement le groupe sélectionné</li></ul>';
$string['grading_grouping_select_title'] = 'Filtre des groupements';
$string['group_administration'] = 'Administration des groupes';
$string['group_administration_alt'] = 'Gérer les groupes et groupements (actifs)';
$string['group_assign_error'] = 'Impossible d\'affecter au groupe !';
$string['group_assign_error_prev'] = 'Impossible d\'affecter au groupe !';
$string['group_creation'] = 'Création des groupes';
$string['group_creation_alt'] = 'Créer des groupes';
$string['group_creation_failed'] = 'La création des groupes a échoué !';
$string['group_creation_success'] = 'Création de groupes avec succès !';
$string['group_not_found'] = 'Le groupe <strong>{$a->groupid}</strong> n’a pu être trouvé dans le grouptool <strong>{$a->grouptoolid}</strong> !';
$string['group_not_in_grouping'] = 'Le groupe choisi n’est pas membre du groupement choisi !';
$string['group_or_member_count'] = 'Nombre de Groupe/Membre';
$string['group_places'] = 'Nombre de places disponibles';
$string['groupchange_from_non_unique_reg'] = 'Ne peut pas changer de groupe car ancien groupe non-unique !';
$string['groupcreation'] = 'Création des groupes';
$string['groupcreationmode'] = 'Mode';
$string['groupfromtodigits'] = 'De, à &amp; chiffres dans les noms de groupe :';
$string['groupinfo'] = 'Information du groupe';
$string['grouping_assign_error'] = 'N’a pas pu être attribué au groupement :';
$string['grouping_assign_error_prev'] = 'Ne peut pas être attribué au groupement :';
$string['grouping_assign_success'] = 'Attribués avec succès :';
$string['grouping_assign_success_prev'] = 'Peut être attribué :';
$string['grouping_creation_error'] = 'Le groupement n’a pas pu être créé !';
$string['grouping_creation_error_prev'] = 'Le groupement ne peut pas être créé !';
$string['grouping_creation_only_success'] = 'Groupement créé avec succès !';
$string['grouping_creation_only_success_prev'] = 'Le groupement peut être créé !';
$string['grouping_exists_error'] = 'Le groupement n’a pas pu être créé car un groupement portant ce nom existe déjà !';
$string['grouping_exists_error_prev'] = 'Le groupement ne peut pas être créé car un groupement portant ce nom existe déjà !';
$string['groupings_created_and_groups_added'] = 'Groupement(s) créé(s) et/ou groupe(s) ajouté(s) !';
$string['groupingscreation'] = 'Création et attribution de groupements';
$string['groupingselect'] = 'Groupements pour les groupes sélectionnés';
$string['groupoverview'] = 'Aperçu du groupe';
$string['groups_created'] = 'Création des groupes avec succès !';
$string['groups_queues_limit'] = 'Places dans la file d’attente par groupe';
$string['groups_queues_limit_help'] = 'Limite le nombre de places dans la file d’attente par groupe si activé';
$string['groupselection'] = 'Sélection du groupe';
$string['groupsize'] = 'Taille du groupe';
$string['groupstatus'] = 'Statut';
$string['grouptool'] = 'Grouptool';
$string['grouptool:addinstance'] = 'Ajouter une instance de grouptool dans le cours.';
$string['grouptool:administrate_groups'] = 'Gérer les groupes et groupements (actifs)';
$string['grouptool:create_groupings'] = 'Créer des groupements avec grouptool.';
$string['grouptool:create_groups'] = 'Créer des groupes avec grouptool.';
$string['grouptool:export'] = 'Exporter les données de groupe et d’inscription dans différents formats';
$string['grouptool:grade'] = 'Copier les notes d’un membre de groupe vers d\'autres';
$string['grouptool:grade_own_group'] = 'Copier les notes d\'un membre de groupe vers d’autres si la notre d’origine a été attribuée par moi';
$string['grouptool:move_students'] = 'Déplacer des étudiants dans d\'autres groupes.';
$string['grouptool:register'] = 'S’inscrire dans un groupe actif en utilisant grouptool.';
$string['grouptool:register_students'] = 'Inscrire des étudiants dans un groupe actif en utilisant grouptool. (Également utilisé pour la résolution des files d\'attentes)';
$string['grouptool:unregister_students'] = 'Désinscrire des étudiants des groupes en utilisant grouptool.';
$string['grouptool:view_description'] = 'Visualiser la description des grouptools';
$string['grouptool:view_groups'] = 'Voir les groupes actifs';
$string['grouptool:view_own_registration'] = 'Voir sa propre inscription';
$string['grouptoolfieldset'] = 'Paramètres de l’instance';
$string['grouptoolname'] = 'Nom du grouptool';
$string['grouptoolname_help'] = 'Le nom de l’instance grouptool';
$string['groupuser_import'] = 'Importer des groupes d’utilisateurs';
$string['groupuser_unregister'] = 'Désinscription des utilisateurs du groupe';
$string['grp_marked'] = 'Sélectionné pour l’inscription';
$string['grpsizezeroerror'] = 'La taille de groupe doit être supérieure ou égale à 1. Les lettres ou d\'autres symboles ne sont pas autorisés.';
$string['ifgroupdeleted'] = 'Si le groupe est supprimé';
$string['ifmemberadded'] = 'Si des membres du groupe sont ajoutés';
$string['ifmemberremoved'] = 'Si des membres du groupe sont retirés';
$string['ignorechanges'] = 'Ignorer les modifications';
$string['immediate_reg'] = 'Inscription immédiate';
$string['import_progress_completed'] = 'Importation terminée';
$string['import_progress_import'] = 'Importer l\'utilisateur';
$string['import_progress_preview_completed'] = 'Aperçu d’importation terminé';
$string['import_progress_search'] = 'Rechercher un utilisateur';
$string['import_progress_start'] = 'Démarrer l’importation';
$string['import_skipped'] = 'Utilisateur <strong>{$a->fullname}</strong> ignoré pour le groupe <strong>{$a->groupname}</strong> !';
$string['import_user'] = 'L’importation de <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) dans le groupe <strong>{$a->groupname}</strong> a réussi.';
$string['import_user_prev'] = 'Importer <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong>) dans le groupe <strong>{$a->groupname}</strong>.';
$string['import_user_problem'] = 'Problème lors de l’importation de <strong>{$a->fullname}</strong> (<strong>{$a->idnumber}</strong> - <strong>{$a->id}</strong>) dans le groupe <strong>{$a->groupname}</strong>.';
$string['importbutton'] = 'Importer les utilisateurs';
$string['inactive'] = 'Non actif';
$string['inactivegroups'] = 'Groupes non actifs';
$string['inactivegroups_hide'] = 'Masquer les groupes non actifs';
$string['inactivegroups_show'] = 'Afficher les groupes non actifs';
$string['includeonlyactiveenrol'] = 'Inclure uniquement les inscriptions actives';
$string['incomplete_only_label'] = 'Afficher uniquement les groupes dont les notes sont manquantes';
$string['individual_size_info'] = '* Taille du groupe selon les paramètres établis';
$string['invert'] = 'Inverser';
$string['landscape'] = 'Paysage';
$string['limit'] = 'limite';
$string['loading'] = 'chargement…';
$string['max_queues_reached'] = 'Files d’attente maximales atteintes !';
$string['max_regs_reached'] = 'Nombre maximum d’inscriptions atteint !';
$string['moodlesync'] = 'Le comportement en cas de changement dans moodle';
$string['multiple'] = 'Gestion des groupes d’utilisateurs';
$string['mygroups_only_label'] = 'Ne montrer que les éléments que j’ai notés';
$string['name_scheme_tags'] = '<span class="tag firstname">[firstname]</span>
<span class="tag lastname">[lastname]</span>
<span class="tag idnumber">[idnumber]</span>
<span class="tag username">[username]</span>
<span class="tag alpha">@</span>
<span class="tag number">#</span>';
$string['namingscheme'] = 'Schéma des noms';
$string['no_registrations'] = 'Pas d’inscriptions';
$string['no_users_to_display'] = 'Pas d’utilisateurs à afficher !';
$string['nobody_queued'] = 'Personne en file d’attente';
$string['nogroupschoose'] = 'Choisir les groupes';
$string['nogroupscreate'] = 'Créer les groupes';
$string['nonconflicting'] = 'Sans conflit';
$string['noregistrationdue'] = 'illimité';
$string['not_registered'] = 'Vous n’est pas inscrit !';
$string['nowhere_queued'] = 'Pas de file d’attente';
$string['number_of_groups'] = 'Nombre N de groupes';
$string['number_of_students'] = 'Nombre de participants';
$string['occupied'] = 'Occupé';
$string['onenewgrouping'] = 'Dans UN nouveau groupement';
$string['onenewgroupingpergroup'] = 'Un groupement PAR groupe';
$string['open_group_message'] = 'Ouvrir les messages de groupe';
$string['orientation'] = 'Orientation du PDF';
$string['outdated'] = 'déviant';
$string['overview'] = 'Aperçu';
$string['overview_tab'] = 'Vue du groupe';
$string['overview_tab_alt'] = 'Ouvrir la vue du groupe';
$string['overwrite_label'] = 'Remplacer les notes existantes';
$string['pluginadministration'] = 'Gestion du grouptool';
$string['pluginname'] = 'Grouptool';
$string['portrait'] = 'Portrait';
$string['preview'] = 'Prévisualisation';
$string['queue'] = 'File d’attente';
$string['queue_and_multiple_reg_title'] = 'Files d’attente et inscriptions multiples';
$string['queued'] = 'Sur liste d’attente';
$string['queued_on_rank'] = 'En attente au rang #{$a}';
$string['queueing_is'] = 'Mise en file d’attente';
$string['queues'] = 'Files d’attente';
$string['queuesgrp'] = 'File d’attente et nombre maximal de places dans la file d’attente';
$string['rank'] = 'Rang';
$string['recreate_group'] = 'Recréer le groupe';
$string['refresh_table_button'] = 'Actualiser l’aperçu';
$string['register'] = 'S’inscrire';
$string['register_you_in_group'] = 'Voulez-vous vraiment vous inscrire dans le groupe ?';
$string['register_you_in_group_success'] = 'Vous vous êtes inscrit avec succès dans le groupe <strong>{$a->groupname}</strong> !';
$string['register_you_in_group_successmail'] = 'Vous vous êtes inscrit avec succès dans le groupe <strong>{$a->groupname}</strong> !';
$string['register_you_in_group_successmailhtml'] = 'Vous vous êtes inscrit avec succès dans le groupe <strong>{$a->groupname}</strong> !';
$string['registered'] = 'Inscrit';
$string['registered_on_rank'] = 'Inscrit au rang #{$a}';
$string['registration_missing'] = '1 inscription manquante';
$string['registrationdue'] = 'Fin de l’inscription ';
$string['registrations'] = 'Inscriptions au groupe';
$string['select'] = 'Sélectionner';
$string['selected'] = 'Sélectionné';
$string['selectfromcohort'] = 'Sélectionnez des utilisateurs de la cohorte';
$string['selectfromgroup'] = 'Sélectionner les membres du groupe';
$string['selectmultiple'] = 'Choix multiple';
$string['selectsingle'] = 'Choix unique';
$string['selfregistration'] = 'Inscription';
$string['setactive'] = 'Activer';
$string['setinactive'] = 'Désactiver';
$string['show_members'] = 'Afficher les membres du groupe';
$string['size'] = 'Taille du groupe';
$string['start'] = 'Démarrer';
$string['status'] = 'Statut';
$string['unreg'] = 'Se désinscrire';
$string['unreg_is'] = 'Désinscription';
$string['unreg_you_from_group'] = 'Poursuivre la désinscription du groupe <strong>{$a->groupname}</strong> ?';
$string['unreg_you_from_group_success'] = 'La désinscription du groupe <strong>{$a->groupname}</strong> a été effectuée avec succès !';
$string['unregfrommgroups'] = 'Forcer la désinscription de Grouptool';
$string['unregisterbutton'] = 'Désinscrire les utilisateurs';
$string['use_queue'] = 'Utiliser les files d’attente';
$string['userlist'] = 'Liste d’utilisateurs';
$string['userlist_tab'] = 'Vue du cours';
$string['users_queues_limit'] = 'Places en file d’attente par utilisateur';
$string['viewmoodlegroups'] = 'Vers les groupes Moodle';
$string['with_selection'] = 'Avec la sélection…';
$string['you_are_already_registered'] = 'Vous êtes déjà inscrit au groupe <strong>{$a->groupname}</strong> !';
