<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'groupformation', language 'es_mx', version '4.4'.
 *
 * @package     groupformation
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity'] = 'Actividad';
$string['activity_end'] = 'Detener actividad';
$string['activity_start'] = 'Iniciar actividad';
$string['activity_visible'] = 'Esta actividad no es visible para Usted debido a su rol. Usted puede acceder a esta actividad como un profesor o un usuario. Los profesores sin derecho de edición o tutores no pueden tener acceso.';
$string['add_line'] = 'Añadir línea';
$string['adopt_groups_task'] = 'Quehacer de adopción de grupo';
$string['allanswersrequired'] = 'Es necesario contestar todas las preguntas para completar la actividad.';
$string['allanswersrequired_description'] = 'Es necesario contestar todas las preguntas para completar la actividad.';
$string['alreadySubmitted'] = 'Ya enviado/a';
$string['analyse'] = 'Análisis';
$string['answers_for_eval_text'] = 'Si todas las preguntas son contestadas, Usted puede recibir retroalimentación en la pestaña de evaluación. Si sus respuestas son incompletas, la evaluación no es posible debido a las respuestas faltantes.';
$string['archive_activity_task'] = 'Quehacer de archivado';
$string['archived_activity_admin'] = 'La actividad ha sido archivada. Aquí no hay nada que hacer.';
$string['archived_activity_answers'] = 'La actividad ha sido archivada.  Sus respuestas ya no están almacenadas y aquí no hay nada que hacer.';
$string['are'] = 'Hay';
$string['are_now'] = 'Ahora, hay';
$string['availability_nochangespossible'] = 'El questionnaire ya ha sido contestado. Usted ya no puede cambiarle la hora de inicio..';
$string['bad'] = 'malo';
$string['beta_version'] = '';
$string['build_groups_task'] = 'Quehacer de formación del grupo';
$string['cannotloadxml'] = 'No puede cargarse archivo XML';
$string['category_catfreetext'] = 'Texto Libre';
$string['category_catmultiselect'] = 'Opción Múltiple';
$string['category_catnumber'] = 'Número';
$string['category_character'] = 'Caracter';
$string['category_demographic'] = 'Demográfica';
$string['category_general'] = 'General';
$string['category_grade'] = 'Metas';
$string['category_honesty'] = 'Honestidad';
$string['category_knowledge'] = 'Conocimiento';
$string['category_learning'] = 'Aprendiendo';
$string['category_motivation'] = 'Motivación';
$string['category_points'] = 'Metas';
$string['category_self'] = 'Auto-evaluación';
$string['category_sellmo'] = 'Motivación de Logro y Aprendizaje';
$string['category_skills'] = 'Experiencia';
$string['category_srl'] = 'Aprendizaje Auto-controlado';
$string['category_team'] = 'Equipo';
$string['category_times'] = 'Disponibilidad';
$string['category_topic'] = 'Tópicos';
$string['choose_evaluationmethod'] = 'Elegir método';
$string['choose_number'] = 'Elegir número';
$string['choose_scenario'] = 'Elegir escenario';
$string['cohort_index'] = 'Índice-de-Desempeño-Cohortes:';
$string['cohort_index_info'] = 'El índice de Desempeño de Cohortes (KPI) representa la calidad de los grupos construídos y tiene un rango entre 0 y 1. Mientras más grandel el valor, tanto mejores los grupos construídos.';
$string['committed_not_completed'] = 'de los questionnaires cometidos no están completos.';
$string['completeTheForm'] = 'Questionnaire completo';
$string['completed_questionnaire'] = 'questionnaires completamente contestados';
$string['consent_agree'] = 'Estoy de acuerdo con las condiciones';
$string['consent_alert_message'] = 'Usted necesita dar consentimiento antes de acceder all questionnaire. Deslice el curso hacia abajo y acepte las condiciones antes de hacer clic en "Siguiente".';
$string['consent_header'] = 'Yo deseo participar en el plugin groupformation y estoy de acuerdo en enviar respuestas al questionnaire. La participación o no-participación no tiene impacto en el proceso de calificación (o en los puntos de crédito).';
$string['consent_header_import'] = 'Al importar sus respuestas, Usted está de acuerdo en participar en el plugin groupformation y Usted está dee acuerdo en enviar respuestas al questionnaire. La participación o no-participación no tiene impacto en el proceso de calificación (o en los puntos de crédito).';
$string['consent_message'] = '<ul><li>
El instructor no tiene acceso directo a mis respuestas para la formación del grupo (solamente yo puedo acceder a la evaluación acerca de mi personalidad y el promedio del grupo).
</li><li>
Mis datos personales serán eliminados cuando termine el curso - a más tardar  después de {$a->archivedays}  días.</li></ul>';
$string['consent_opt_in'] = 'Consentimiento (si)';
$string['contact_members'] = 'Para contactar a los miembros de su equipo Usted puede hacer clic en sus nombre_de_usuario.';
$string['continueTheForm'] = 'Continuar';
$string['cron_job_not_running'] = 'Par poder manejar los trabajos en cola, un cron está trabajando en segundo plano. Desafortunadamente, o no está respondiendo o no está corriendo en absoluto. Si este mensaje sigue apareciendo después de 24 horas, por favor contacte al administrador del sistema.';
$string['drop_selection'] = 'Desseleccionar todo';
$string['edit_param'] = 'Editar';
$string['editparam'] = 'Editar parametros';
$string['emailnotifications'] = '<i style="color:red;">Actualmente no está disponible la notificación automática cuando groupformation está terminado.</i>';
$string['emailnotifications_description'] = '<i style="color:red;">Actualmente no está disponible la notificación automática cuando groupformation está terminado.</i>';
$string['emailnotifications_info'] = 'Usted será notificado vía mensaje cuando esté terminado.';
$string['endtime'] = 'Hora de fin';
$string['eval_caption_course'] = 'Curso';
$string['eval_caption_group'] = 'Grupo';
$string['eval_caption_user'] = 'Usuario';
$string['eval_cutoff_caption_agreeableness'] = 'Amabilidad Social';
$string['eval_cutoff_caption_challenge'] = 'Reto';
$string['eval_cutoff_caption_conscientiousness'] = 'Escrupulosidad';
$string['eval_cutoff_caption_extraversion'] = 'Extraversión';
$string['eval_cutoff_caption_interest'] = 'Interés';
$string['eval_cutoff_caption_lackofconfidence'] = 'Expectativa de falla';
$string['eval_cutoff_caption_neuroticism'] = 'Neuroticismo';
$string['eval_cutoff_caption_openness'] = 'Apertura a experiencia';
$string['eval_cutoff_caption_successprobability'] = 'Probabilidad de Éxito';
$string['eval_final_text'] = 'La comparación está basada en {$a->percent}% de las respuestas de los usuarios ({$a->completed} de {$a->coursesize} usuarios que ya han contestado).';
$string['eval_first_page_text'] = 'Aquí Usted recibe su retroalimentación personalizada con respecto a sus respuestas dadas en el cuestionario. Para este propósito, las preguntas relacionadas con el mismo asunto fueron agrupadas y se calcularon valores promedio y se compararon con una muestra de estudiantes. Los llamados rangos percentiles fueron calculados, no con la intenciónde juzgar si es que un valor obtenido era bueno o malo, sino para ver qué tan frecuentes son esos valores dentro de una muestra de estudiantes. Un rango percentil de 10% significa que 10% de la muestra comparativa tuvo un valor igual o menor. Por otra parte, un rango percentil de 90% significa que 90% de la muestra comparativa obtuvo un valor igual o menor.
\\n\\n
Primeramente, Usted recibe retroalimentación en cinco características de la personalidad, que puede ser comprendida como relativamente estable; que es independiente de situaciones específicas: extraversión, neuroticismo, conciencia, amabilidad social y apertura hacia experiencia. Usted recibirá entonces retroalimentación en cuatro dimensiones de motivación, que se relacionan con el curso o ejercicio académico actual y así pueden variar de situación a situación: interés, reto, probabilidad de éxito y expectativa de fracaso.';
$string['eval_first_page_title'] = 'Información General';
$string['eval_max_caption_agreeableness'] = 'amable';
$string['eval_max_caption_challenge'] = 'Reto';
$string['eval_max_caption_conscientiousness'] = 'concienzudo';
$string['eval_max_caption_extraversion'] = 'extrovertido';
$string['eval_max_caption_interest'] = 'Interés';
$string['eval_max_caption_lackofconfidence'] = 'Expectativa de Fracaso';
$string['eval_max_caption_neuroticism'] = 'emocionalmente estable';
$string['eval_max_caption_openness'] = 'abierto';
$string['eval_max_caption_successprobability'] = 'Probabilidad de Éxito';
$string['eval_max_text_agreeableness'] = 'Amabilidad social se refiere al comportamiento hacia otras personas.';
$string['eval_max_text_challenge'] = 'Reto es una dimensión de motivación, que expresa en qué medida el curso o ejercicio actual es interpretado como relacionado con el desempeño; esto es, en qué medida Usted se siente como si estuviera ejercitando sus propias destrezas y sus habilidades.';
$string['eval_max_text_conscientiousness'] = 'El factor "Conciencia" primariamente describe el grado de auto-control, exactitud y determinación.';
$string['eval_max_text_extraversion'] = 'Introversión y extroversión son dos polos de un razgo de la personalidad que está caracterizado por la interacción con el ambiente. La introversión denota una actitud hacia internalización, mientras que la extroversión denota externalización';
$string['eval_max_text_interest'] = 'Interés es una dimensión de motivación, la cual es derivada de la apreciación del contenido de un trabajo. El interés es expresado, entre otros, en el hecho de que los trabajos son realizados gustosamente y voluntariamente. Especialmente cuando los trabajos están siendo hechos auto-dirigidos y se busca un profundo entendimiento; el interés contribuye al aprendizaje exitoso.';
$string['eval_max_text_lackofconfidence'] = 'Expectativa de fracaso es una forma de motivación, que surge del miedo de no tener éxito en la tarea, combinado con la idea que debido a la presión de la situación, uno no podrá estudiar óptimamente.';
$string['eval_max_text_neuroticism'] = 'El factor de personalidad "Neuroticismo" refleja diferencias individuales en la experimentación de emociones negativas y también es conocida como Labilidad Emocional. El polo opuesto también es referido como Estabilidad Emocional.';
$string['eval_max_text_openness'] = 'El factor "Apertura a experiencia" describe el interés y cantidad de dedicación en nuevas experiencias e impresiones.';
$string['eval_max_text_successprobability'] = 'Probabilidad de éxito incluye presunciones acerca de qué tan confiado es uno de que obtendrá una buena evaluación en el curso o ejercicio actual. Una alta probabilidad esperada de éxito puede derivar de la estimación de ser lo suficientemente capaz, o de encontrar la tarea como fácil.';
$string['eval_min_caption_agreeableness'] = 'competitivo';
$string['eval_min_caption_challenge'] = 'Reto';
$string['eval_min_caption_conscientiousness'] = 'descuidado';
$string['eval_min_caption_extraversion'] = 'introvertido';
$string['eval_min_caption_interest'] = 'Interés';
$string['eval_min_caption_lackofconfidence'] = 'Expectativa de Fracaso';
$string['eval_min_caption_neuroticism'] = 'emocionalmente inestable';
$string['eval_min_caption_openness'] = 'conservador';
$string['eval_min_caption_successprobability'] = 'Probabilidad de Éxito';
$string['eval_min_text_agreeableness'] = 'Amabilidad social se refiere al comportamiento hacia otras personas.';
$string['eval_min_text_challenge'] = 'Reto es una dimensión de motivación, que expresa en qué medida el curso o ejercicio actual es interpretado como relacionado con el desempeño; esto es, en qué medida Usted se siente como si estuviera ejercitando sus propias destrezas y sus habilidades.';
$string['eval_min_text_conscientiousness'] = 'El factor "Conciencia" primariamente describe el grado de auto-control, exactitud y determinación.';
$string['eval_min_text_extraversion'] = 'Introversión y extroversión son dos polos de un razgo de la personalidad que está caracterizado por la interacción con el ambiente. La introversión denota una actitud hacia internalización, mientras que la extroversión denota externalización';
$string['eval_min_text_interest'] = 'Interés es una dimensión de motivación, la cual es derivada de la apreciación del contenido de un trabajo. El interés es expresado, entre otros, en el hecho de que los trabajos son realizados gustosamente y voluntariamente. Especialmente cuando los trabajos están siendo hechos auto-dirigidos y se busca un profundo entendimiento; el interés contribuye al aprendizaje exitoso.';
$string['eval_min_text_lackofconfidence'] = 'Expectativa de fracaso es una forma de motivación, que surge del miedo de no tener éxito en la tarea, combinado con la idea que debido a la presión de la situación, uno no podrá estudiar óptimamente.';
$string['eval_min_text_neuroticism'] = 'El factor de personalidad "Neuroticismo" refleja diferencias individuales en la experimentación de emociones negativas y también es conocida como Labilidad Emocional. El polo opuesto también es referido como Estabilidad Emocional.';
$string['eval_min_text_openness'] = 'El factor "Apertura a experiencia" describe el interés y cantidad de dedicación en nuevas experiencias e impresiones.';
$string['eval_min_text_successprobability'] = 'Probabilidad de éxito incluye presunciones acerca de qué tan confiado es uno de que obtendrá una buena evaluación en el curso o ejercicio actual. Una alta probabilidad esperada de éxito puede derivar de la estimación de ser lo suficientemente capaz, o de encontrar la tarea como fácil.';
$string['eval_name_big5'] = 'Personalidad';
$string['eval_name_fam'] = 'Motivación';
$string['eval_text_big5_agreeableness_1'] = 'Sus bajos puntajes en amabilidad social indican que Usted es básicamente bastante argumentativo, egocéntrico y sospechoso de las intenciones de otras personas. Usted se comporta más competitivamente que cooperativamente, tiene la habilidad para pelear por sus propios intereses y es menos complaciente.';
$string['eval_text_big5_agreeableness_2'] = 'Sus medianos puntajes en amabilidad social indican que Usted no está predispuesto ni hacia fuertemente egocéntrico ni altruista. Uno lo describiría como que ni es particularmente suspicaz ni particularmentee confiado; no es ni complaciente ni extremadamente obsecado.';
$string['eval_text_big5_agreeableness_3'] = 'Sus altos puntajes en amabilidad social indican que Usted es en general más altruista. Usted trata a otros con comprensión, amabilidad y empatía; y Usted trata de ayudar a otros y asume que los otros actuarán ayudando también. Usted tiende a confianza interpersonal, cooperación y obediencia.';
$string['eval_text_big5_conscientiousness_1'] = 'Usted parec tener un puntaje bastante bajo en conciencia. Por eso, uno puede concluir que Usted tiende a ser espontáneo y que actual bastante descuidado e inexacto.';
$string['eval_text_big5_conscientiousness_2'] = 'Usted parece tener un puntaje promedio en conciencia. Por eso, puede asumirse que Usted tiene una relación balanceada entre conciencia y soltura y que Usted no es, ni muy estrictamente organizado, ni desorganizado.';
$string['eval_text_big5_conscientiousness_3'] = 'Usted parecee tener un puntaje alto en conciencia. Por eso, puede asumirse que Usted es organizado, planea cuidadosameente, es afectivo, responsable y confiable, y que Usted actua sensatamente.';
$string['eval_text_big5_extraversion_1'] = 'Sus respuestas indican un bajo puntaje en extraversión. Por eso, Usted probablemente tiende hacia un comportamiento discreto, introvertido, en sus interacciones sociales y Usted es felíz solo y solitario. Las personas introvertidas a menudo son descritas como calmadas, calladas y reservadas.';
$string['eval_text_big5_extraversion_2'] = 'Sus respuestas sugieren una puntuación  promedio en extraversión. Así, Usted probablemente sea entusiasta hasta un punto moderado, y Usted no es particularmente dominante o parlanchín.';
$string['eval_text_big5_extraversion_3'] = 'Sus respuestas indican un alto puntaje en extraversión. Así, Usted probablemente tiende hacia socialización, expresando un comportamiento activo y parlanchín, siendo optimista y cálido, y Usted probablemente reacciona con mayor susceptibilidad a estímulos y emociones.';
$string['eval_text_big5_neuroticism_1'] = 'Usted aparenta tener un bajo puntaje en neuroticismo. Así, Usted es bastante tranquilo, satizfecho, estable, relajado y se siente seguro y a menudo puede lidiar mejor con situaciones estresantes.';
$string['eval_text_big5_neuroticism_2'] = 'Usted aparenta tener un puntaje promedio en neuroticismo. Así, Usted no experimenta a menudo ni raramente ansiedad, nerviosismo, tensión, tristeza, incertidumbre y bochorno. En situaciones estresantes, Usted no es particularmente susceptible a problemas ni tampoco especialmente robusto hacia ellos.';
$string['eval_text_big5_neuroticism_3'] = 'Usted aparenta tener un puntaje bastante alto en neuroticismo. Así, Usted experimenta frecuente ansiedad, nerviosismo, tensión, tristeza, incetidumbre y bochorno. Más aun, estos sentimientos se quedan con Usted más tiempo y son disparados con más facilidad. Usted tiende a estar más preocupado acerca de su salud, a desarrollar ideas irreales y encontrar difícil responder a situaciones estresantes.';
$string['eval_text_big5_openness_1'] = 'Usted ha obtenido un puntaje bastante bajo en apertura. Esto sugiere que Usted está más dispuesto al comportamiento convencional y actitudes conservadoras. Usted prefiere cosas establecidas y aprobadas sobre cosas nuevas y percibe sus reacciones emocionales bastante atenuadas. Usted actua pragmáticamente en el aquí y ahora.';
$string['eval_text_big5_openness_2'] = 'Usted ha obtenido valores de apertura promedio. Esto indica que Usted no tiende hacia actitudes y comportamiento muy convencional ni hacia lo no-convencional. Para Usted, visionario; la disposición imaginativa está balanceada con vida pragmática en el aquí y ahora.';
$string['eval_text_big5_openness_3'] = 'Usted ha obtenido puntajes bastante altos en apertura. Esto sugiere que Usted tiene una vida de fantasía activa y que Usted está interesado en muchos procesos privados y públicos. Tales personas a menudo son descritas como intelectuales, experimentales y con interes artístico; ellos a menudo se comportan de forma no convencional y prefiren la variedad.';
$string['eval_text_fam_challenge_1'] = 'El curso o ejercicio actual fue considerado por Usted como no muy desafiante. Esto puede ser positivo en trabajos dirigidos-externamente, pero puede tener efectos negativos cuando el ejercicio es auto-dirigido.';
$string['eval_text_fam_challenge_2'] = 'El curso o ejercicio actual fue considerado por Usted como que no fuera especialmente desafiante ni tampoco muy simple.';
$string['eval_text_fam_challenge_3'] = 'El curso o ejercicio actual fue considerado por Usted como particularmente desafiante. Esto puede ser negativo en caso de que el ejercicio esté regulado externamente. Por el contrario, podría tener efectos muy positivos si el ejercicio es auto-dirigido.';
$string['eval_text_fam_interest_1'] = 'Usted parece tener un bajo interés en el contenido del curso o ejercicio actual, lo que puede ser malo para su propio aprendizaje; en caso de que el proceso mismo tenga lugar auto-dirigido en una mayor medida.';
$string['eval_text_fam_interest_2'] = 'Usted parece tener un interés moderado en el contenido del curso o ejercicio actual.';
$string['eval_text_fam_interest_3'] = 'Usted parece tener un alto interés en el contenido del curso o ejercicio actual, lo que debería de ser bueno para su propio aprendizaje; en caso de que el proceso mismo tenga lugar auto-dirigido en una mayor medida.';
$string['eval_text_fam_lackofconfidence_1'] = 'Su puntaje sugiere que la presunción de su expectativa de fracaso es poco pronunciada en Usted. Esto podría estar derivado de un temor generalmente inexistente de fracaso, o ansiedad por el examen, pero también podría relacionarse a factores situacionales más específicos del curso o ejercicio actual. Generalmente  se cree que la falta de expectativa de fracaso tiene un efecto positivo sobre el aprendizaje.';
$string['eval_text_fam_lackofconfidence_2'] = 'Su puntaje sugiere que la presunción de su expectativa de fracaso es moderadad. Esto podría estar derivado de un temor general al fracaso, o ansiedad por el examen, pero también podría relacionarse a factores situacionales más específicos del curso o ejercicio actual. Generalmente  se cree que las expectativas de fracaso tienen un impacto negativo sobre el estudio.';
$string['eval_text_fam_lackofconfidence_3'] = 'Su puntaje sugiere que la presunción de su expectativa de fracaso es muy pronunciada en Usted. Esto podría estar derivado de un temor general al fracaso, o ansiedad por el examen, pero también podría relacionarse a factores situacionales más específicos del curso o ejercicio actual. Generalmente  se cree que la expectativa de fracaso tiene un impacto negativo sobre el estudio.';
$string['eval_text_fam_successprobability_1'] = 'Usted ha considerado que tendrá bajas probabilidades de éxito en el ejercicio o curso actual. Usualmente esto tiene un efecto adverso en el  proceso de aprendizaje.';
$string['eval_text_fam_successprobability_2'] = 'Usted ha considerado que obtendrá resultados moderadamente buenos en el ejercicio o curso actual. Esto no debería de tener una influencia ni particularmente buena ni mala en su proceso de aprendizaje.';
$string['eval_text_fam_successprobability_3'] = 'Usted ha considerado que muy probablemente será exitoso en el curso o ejercicio actual. Hablando generalmente, esto debería facilitar el proceso de aprendizaje.';
$string['evaluation'] = 'Evaluación';
$string['evaluation_point_info'] = 'Indique el puntaje máximo disponible';
$string['evaluationmethod_description'] = '¿Cómo evalúa Usted el trabajo?';
$string['evaluationmethod_error'] = 'Por favor elija un método de evaluación.';
$string['excellent'] = 'excelente';
$string['export'] = 'Exportar';
$string['export_all'] = 'Exportar todos los datos personales';
$string['export_all_data_check'] = 'Incluir datos personales de groupformations en todo el sistema Moodle (de acuerdo con Regulación de Protección de Datos General de la Unión Europea)';
$string['export_all_description'] = 'Usted puede exportar aquí todos sus datos personales almacenados por esta actividad:';
$string['export_answers'] = 'Usted puede descargar aquí todas las respuestas con IDs de usuario anonimizadas:';
$string['export_description_no'] = 'Usted no puede exportar sus respuestas porque Usted no ha contestado ninguna pregunta en las categorías exportables.';
$string['export_description_yes'] = 'Usted puede exportar sus respuestas al hacer clic en el botón inferior.';
$string['export_group_users'] = 'Usted puede descargar aquí todas las relaciones grupo-usuarios con IDs de usuario anonimizadas:';
$string['export_groups'] = 'Usted puede descargar aquí todos los grupos con IDs de usuario anonimizadas:';
$string['export_logging'] = 'Usted puede descargar aquí todos los datos de bitácora con IDs de usuario anonimizadas:';
$string['export_users'] = 'Usted puede descargar aquí os los datos relacionados con usuarios con IDs de usuario anonimizadas:';
$string['failed_import'] = 'La importación ha fallado por causa de un formato inválido. Por favor, suba un archivo con formato de respuesta exportable.';
$string['file_error'] = 'Usted tiene que subir un archivo *.xml.';
$string['freetext_noanswer'] = 'Sin respuesta';
$string['generategroups'] = 'Generar grupos';
$string['go_to_group_view'] = 'a vista de grupo Moodle';
$string['grades'] = 'Calificaciones';
$string['groupSettingsInfo'] = 'Usted ha elegido definir tópicos. Así, el número de grupos y sus tamaños serán calculados, como Usted puede ver debajo.';
$string['group_building'] = 'Construcción del grupo';
$string['group_overview'] = 'Vista general de grupos generados';
$string['groupformation'] = 'Formación del grupo';
$string['groupformation:addinstance'] = 'Añadir groupformation';
$string['groupformation:editsettings'] = 'Editar groupformation';
$string['groupformation:onlymanager'] = 'groupformation: solo mánager';
$string['groupformation:onlyread'] = 'groupformation: solo lectura';
$string['groupformation:onlystudent'] = 'groupformation: solo estudiante';
$string['groupformation:readsettings'] = 'groupformation: leer configuraciones';
$string['groupformation:submit'] = 'groupformation: enviar';
$string['groupformation:view'] = 'groupformation: ver';
$string['groupformation_message'] = 'La formación de grupo ha terminado. Ahora puede Usted ver los resultados.';
$string['groupformation_message_contexturlname'] = 'resultados';
$string['groupformation_message_subject'] = 'Formación de grupo completada';
$string['groupformation_subject'] = 'formación de grupo terminada';
$string['groupformationfieldset'] = 'Conjunto_de_campo de ejemplo personalizado';
$string['groupformationname'] = 'Formación del grupo';
$string['groupformationname_help'] = 'Herramientita para Formación de Grupo';
$string['groupformationsettings'] = 'Configuraciones de formación de grupo';
$string['groupingNotReady'] = 'La formación de grupo aun no h aterminado.';
$string['grouping_abort'] = 'Cancelar generación de grupos';
$string['grouping_adopt'] = 'Adoptar grupos';
$string['grouping_delete'] = 'Eliminar grupos';
$string['grouping_delete_moodle_groups'] = 'Eliminar grupos Moodle';
$string['grouping_edit'] = 'Editar grupos';
$string['grouping_start'] = 'Iniciar formación de grupo';
$string['grouping_status_0'] = 'Usted tiene que cerrar la actividad para iniciar la formación de grupo.';
$string['grouping_status_1'] = 'Usted puede iniciar la formación de grupo ahora';
$string['grouping_status_2'] = 'La formación de grupo está en progreso. Este proceso puede tomar 2-5 minutos. Por favor vuelva a cargar la página ocasionalmente para ver el resultado.';
$string['grouping_status_3'] = 'La formación de grupo fue abortada. El reinicio del sistema puede demorar 2-5 minutos. Por favor vuelva a cargar la página ocasionalmente para ver el resultado.';
$string['grouping_status_4'] = 'La formación de grupo está terminada. Usted puede adoptar los grupos a Moodle o si lo necesita puede editar manualmente los resultados.';
$string['grouping_status_5'] = 'Los grupos generados son adoptados a Moodle. Usted puede ajustarlos manualmente.';
$string['grouping_status_6'] = 'Los grupos generados van a ser adoptados a Moodle. Este proceso puede tomar 2-5 minutos. Por favor vuelva a cargar la página ocasionalmente para ver el resultado.';
$string['groupname'] = 'Nombre del agrupamiento';
$string['groupname_error'] = 'Por favor elija un nombre conmenos de 100 caracteres.';
$string['groupname_help'] = 'El nombre de agrupamiento elegido será un prefijo para los grupos generados. Este esquema es [nombre del agrupamiento]_XXX en donde XXX es el número del grupo.';
$string['groupnameexists'] = 'El grupo ya existe.';
$string['groupoption_allanswersrequired'] = 'Antes de continuar a la siguiente página del cuestionario, uno tiene que contestar todas las preguntas.';
$string['groupoption_description'] = 'Descripción de configuraciones del grupo';
$string['groupoption_help'] = 'Este parámetrop puede ser optimizado después del envío de los questionnarires.';
$string['groupoption_onlyactivestudents'] = 'Los estudiantes sin respuestas no serán asignados a ningun grupo.';
$string['groupoptions'] = 'Configuraciones del grupo';
$string['groupsize'] = 'Tamaño del grupo:';
$string['import'] = 'Importar';
$string['import_description_no'] = 'Usted no uede importar sus respuestas por que Usted ya envió sus respuestas o el cueationario ya no está disponible.';
$string['import_description_yes'] = 'Usted puede importar sus respuestas al hacer clic en el botón inferior y subir un archivo con formato de respuesta exportable.';
$string['import_form_description'] = 'Usted puede importar sus respuestas de cuestionarios anteriores al enviar un archivo  "answers.xml" debajo.';
$string['inactive_members_are'] = 'Usuarios que dejaron el grupo o el curso:';
$string['info_header_student'] = '¿ Para qué es "groupformation" (formación_de_grupo) ?';
$string['info_header_teacher_analysis'] = '¿Cómo funciona la actividad formación_de_grupo (groupformation)?';
$string['info_header_teacher_settings'] = '¿Cómo funciona la actividad formación_de_grupo (groupformation)?';
$string['info_text_student'] = 'En este curso Moodle el "groupformation" es usado para construir cooperativamente exitoso {$a->scenario_name}.
   Después de que Usted complete y envíe el cuestionario, sus socios de aprendizaje apropiados serán determinados.
   Todos los detalles se mantienen confidenciales.
   <br>Una vez que el cuestionario haya expirado, los grupos serán generados considerando sus datos y preferencias.
<br><br>
¿Preguntas, problemas o sugerencias?
Usted puede encontrar al desarrollador del plugin y a los científicos en <br>
https://github.com/moodlepeers <br>
(creado y desarrolado con medios para mejora de la calidad  de la enseñanza en Technische Universität Darmstadt)';
$string['info_text_teacher_analysis'] = 'Con este plugin usted tiene la habilidad para optimizar la formación de grupos de sus estudiantes. Los tres pasos requeridos son:<br>
   1.) Añadir la actividad "groupformation" a su curso.
   En las configuraciones, Usted puede elegir cual escenario se ajusta mejor a sus necesidades (en caso de duda, elija equipos de proyecto).
   Las configuraciones avanzadas le permiten especificar el tamaño del grupo o el conocimiento previo de los estudiantes. Si los conocimientros previos de los estudiantes deberían de complementarse mutuamente, Usted puede especificarlo en las configuraciones.
   2.) Los estudiantes obtienen el cuestionario que está basado en sus configuraciones. Usted puede ajustar el período en el cual está disponible el cuestionario (vea el paso 1).
   Una vista previa del cuestionario se puede encontrar al abrir la actividad como un docente.<br>
   3.) Las estadísticas de las respuestas se pueden ancontrar al abrir la actividad. Si Usted está satisfecho con la respuesta, Usted puede iniciar manualmente a groupformation (nunca sucede automáticamente).<br>
   Tomará un tiempo hasta que los grupos estén formados. Usted puede ver los grupos generados antes de adoptarlos a Moodle.<br>
<br>
   Terminado, Ahora también los estudiantes pueden ver a sus compañeros de grupo. Como un docente, Usted puede ajustar manualmente los grupos en cualquier momento en Moodle (por ejemplo, con los rezagados).<br>';
$string['info_text_teacher_settings'] = 'Con este plugin usted tiene la habilidad para optimizar la formación de grupos de sus estudiantes. Los tres pasos requeridos son:<br>
   1.) Añadir la actividad "groupformation" a su curso.
   En las configuraciones, Usted puede elegir cual escenario se ajusta mejor a sus necesidades (en caso de duda, elija equipos de proyecto).
   Las configuraciones avanzadas le permiten especificar el tamaño del grupo o el conocimiento previo de los estudiantes. Si los conocimientros previos de los estudiantes deberían de complementarse mutuamente, Usted puede especificarlo en las configuraciones.
   2.) Los estudiantes obtienen el cuestionario que está basado en sus configuraciones. Usted puede ajustar el período en el cual está disponible el cuestionario (vea el paso 1).
   Una vista previa del cuestionario se puede encontrar al abrir la actividad como un docente.<br>
   3.) Las estadísticas de las respuestas se pueden ancontrar al abrir la actividad. Si Usted está satisfecho con la respuesta, Usted puede iniciar manualmente a groupformation (nunca sucede automáticamente).<br>
   Tomará un tiempo hasta que los grupos estén formados. Usted puede ver los grupos generados antes de adoptarlos a Moodle.<br>
<br>
   Terminado, Ahora también los estudiantes pueden ver a sus compañeros de grupo. Como un docente, Usted puede ajustar manualmente los grupos en cualquier momento en Moodle (por ejemplo, con los rezagados).<br>';
$string['input'] = 'Ingreso:';
$string['invalid'] = 'estatus inválido';
$string['jobget_name'] = 'Formación y limpieza de grupo';
$string['justpass'] = 'Simplemente pasar';
$string['knowledge'] = 'Conocimiento';
$string['knowledgeChoice'] = 'Conocimiento';
$string['knowledge_description'] = 'Yo quiero incluir preguntas de conocimiento';
$string['knowledge_description_extended'] = 'Por favor enliste las áreas del conocimiento en las que los estudiantes deberían de evaluarse ellos mismos.
    Vea la vista previa en el lado derecho.';
$string['knowledge_dummy'] = 'Ejemplo';
$string['knowledge_help'] = 'Si los tópicos (opción inferior) están activados, esta opción es desactivada y deshabilitada automáticamente.';
$string['knowledge_info_homework'] = 'Por favor enliste las áreas del conocimiento en las que los estudiantes deberían de evaluarse ellos mismos.
    Vea la vista previa en el lado derecho.
    De acuerdo a su selección, el conocimiento previo de "grupos de tarea en casa" será variada dentro de cada grupo.';
$string['knowledge_info_presentation'] = 'Por favor enliste las áreas del conocimiento en las que los estudiantes deberían de evaluarse ellos mismos.
    Vea la vista previa en el lado derecho.
    De acuerdo a su selección, el conocimiento previo de "grupos de presentación" será variada dentro de cada grupo (ignorada cuando los tópicos sean configurados)';
$string['knowledge_info_project'] = 'Por favor enliste las áreas del conocimiento en las que los estudiantes deberían de evaluarse ellos mismos.
    Vea la vista previa en el lado derecho.
    De acuerdo a su selección, (las áreas de) el conocimiento previo de "equipos de proyecto" será variada dentro de cada grupo, pero el nivel de conocimieno es deseable que sea similar.';
$string['knowledge_question'] = '¿Qué tanto sabe acerca de los siguientes tópicos?';
$string['knowledge_scale'] = '0 = sin conocimiento, 100 = mucho conocimiento';
$string['language'] = 'es_mx';
$string['max_group_size'] = 'Tamaño máximo del grupo:';
$string['max_group_size_not_reached'] = 'El tamaño máximo del grupo no se ha alcanzado para los grupos siguientes:';
$string['maxgroups'] = 'Máximo número de grupos';
$string['maxgroups_error'] = 'Por favor elija un número mayor a 0';
$string['maxmembers'] = 'Número máximo de miembros del grupo';
$string['maxmembers_error'] = 'Por favor elija un número mayor a 0';
$string['maxpoints'] = 'Puntos máximos';
$string['maxpoints_error'] = 'Por favor elija un número entre 1 y 100';
$string['members_are'] = 'Los miembros de su grupo son:';
$string['messageprovider:submission'] = 'Notificarme si terminó el algoritmo para formación de grupo.';
$string['modulename'] = 'Formación del grupo';
$string['modulename_help'] = 'El plugin groupformation (formación_de_grupo) genera grupos de participantes basados en respuestas a un questionnaire.';
$string['modulenameplural'] = 'Formaciones de grupo';
$string['name_by_group'] = 'Nombre:';
$string['namingschema'] = 'Esquema de nombrado';
$string['noGroup'] = 'Usted no ha sido asignado a ningún grupo porque Usted no contestó el questionnaire a tiempo. Sin embargo, el instructor puede asignarlo manualmente a un grupo si Usted lo solicita.';
$string['noUser'] = 'El usuario no existe';
$string['no_data_to_display'] = 'Sin datos para mostrar';
$string['no_evaluation_ready'] = 'No hay evaluación para Usted. La evaluación de sus respuestas es posible si Usted contesta todo y envía sus respuestas.';
$string['no_evaluation_text'] = 'No hay evaluación para la actividad de formación de grupo.';
$string['no_time'] = 'Sin tiempo configurado';
$string['nochangespossible'] = 'El cuestionario ya ha sido contestado. Usted solamente puede cambiar el número máximo de miembros o el número máximo de grupos. Cambios mayores no serán guardados.';
$string['noevaluation'] = 'Sin evaluación';
$string['nogroupformation'] = 'Sin formación del grupo';
$string['none'] = 'ninguno';
$string['notOpen'] = 'El envío está cerrado.';
$string['notamember'] = '(Dejó grupo o curso)';
$string['number_member'] = 'Número de miembros:';
$string['number_of_groups'] = 'Número de grupos generados:';
$string['oneManGroup'] = 'Usted está en un grupo de una persona';
$string['onlyactivestudents'] = 'Solamente estudiantes con al menos una respuesta enviada deberían ser considerados para construir grupos.';
$string['onlyactivestudents_description'] = 'Solamente estudiantes con al menos una respuesta enviada deberían ser considerados para construir grupos.';
$string['onlyactivestudents_info'] = 'Solamente estudiantes con al menos una respuesta enviada deberían ser considerados para construir grupos. Esto puede ser configurado en {$a->url}.';
$string['options'] = 'Opciones';
$string['overview'] = 'Vista general';
$string['page_title_analysis'] = 'Actividad';
$string['page_title_evaluation'] = 'Evaluación';
$string['page_title_export'] = 'Exportar';
$string['page_title_group'] = 'Tarea de grupo';
$string['page_title_grouping'] = 'Formación de grupo';
$string['page_title_grouping_edit'] = 'Formación de grupo - Modo de edición';
$string['page_title_import_export'] = 'Importar y Exportar';
$string['page_title_overview'] = 'Vista general';
$string['participant_code_alert_message'] = 'Usted necesita ingresar un código válido de participante antes de acceder al questionnaire. Deslice el cursor hacia abajo e ingrese su código de participante.';
$string['participant_code_footer'] = 'Su código personal de participante es';
$string['participant_code_title'] = 'Código del Participante';
$string['password_wrong'] = 'contraseña equivocada';
$string['pluginadministration'] = 'Administración: Formación de grupo';
$string['pluginname'] = 'Groupformation (Formación_de_grupo)';
$string['points'] = 'Puntos';
$string['preview'] = 'Vista previa:';
$string['quality'] = 'Calidad del grupo';
$string['quality_info'] = 'El Índice de Desempeño del Grupo (GPI) representa la calidad del grupo construido y tiene un rango entre 0 y 1. Mientras más grande el valor, mucho mejor es el grupo. Si no se menciona valor, el grupo no está construido algorítmicamente, sino aleatoriamente.';
$string['questionnaire_answer_stats'] = 'Estado actual del questionnaire:';
$string['questionnaire_availability_info_from'] = 'El questionnaire está disponible en {$a->start}.';
$string['questionnaire_availability_info_future'] = 'El questionnaire estará disponible en el período desde {$a->start} hasta {$a->end}.';
$string['questionnaire_availability_info_now'] = 'El questionnaire está disponible hasta {$a->end}.';
$string['questionnaire_availability_info_until'] = 'El cuestionario sigue actualmente disponible hasta {$a->end}';
$string['questionnaire_available'] = 'El cuestionario está listo para procesamiento.';
$string['questionnaire_available_end'] = 'El questionnaire está disponible hasta {$a->end}.';
$string['questionnaire_committed'] = 'Usted ya ha enviado sis respuestas, por lo que Usted no puede cambiarlas más.';
$string['questionnaire_delete'] = 'Quitar consentimiento';
$string['questionnaire_go_to_start'] = 'Ir al Inicio';
$string['questionnaire_no_more_questions'] = 'Ya no hay más preguntas para contestar.';
$string['questionnaire_not_available'] = 'El questionnaire esta actualmente no disponible.';
$string['questionnaire_not_available_begin'] = 'El questionnaire esta disponible a partir de {$a->start}.';
$string['questionnaire_not_available_begin_end'] = 'El questionnaire esta disponible desde {$a->start} hasta {$a->end}.';
$string['questionnaire_not_available_end'] = 'El questionnaire ya no está disponible.';
$string['questionnaire_not_started'] = 'El questionnaire está listo.';
$string['questionnaire_not_submitted'] = 'El questionnaire está disponible para procesamiento. Cuando termine de contestar las preguntas, por favor envíe sus respuestas.';
$string['questionnaire_outdated'] = 'Esta actividad es demasiado vieja. No puede asegurarse la funcionalidad correcta. Por favor, cree una nueva actividad para disfrutar de la funcionalidad completa.';
$string['questionnaire_press_beginning_submit'] = 'Hacer clic en "Ir al principio" para regresar a la página de inicio. Allí puede Usted enviar sus respuestas actuales.';
$string['questionnaire_press_continue_submit'] = 'Hacer clic en "Editar" para continuar el cuestionario o "Enviar" para enviar sus respuestas actuales.
Usted también puede quitar su consentimiento, lo que también quita todas las respuestas dadas, al hacer clic en "Quitar consentimiento".';
$string['questionnaire_press_preview'] = 'Presione "Vista previa" para echarle un vistazo al questionnaire.';
$string['questionnaire_press_revert'] = 'Hacer clic en "Revertir" para revertir su decisión de enviar el cuestionario. Usted también puede quitar su consentimiento, lo que también elimina todas las respuestas dadas, al hacer clic en "Quitar consentimiento".';
$string['questionnaire_press_to_begin'] = 'De su consentimiento y haga clic en "Siguiente" para comenzar.';
$string['questionnaire_press_to_begin_participant_code'] = 'Ingrese su código de participación y otorgue su consentimiento. Haga clic en "Siguiente" para comenzar.';
$string['questionnaire_preview'] = 'Esta es una vista previa del questionnaire';
$string['questionnaire_submit'] = 'Enviar respuestas';
$string['questionnaire_submit_disabled_teacher'] = 'El envío está deshabilitado porque esto es solamente una vista previa.';
$string['questionnaire_submitted'] = 'Usted ha enviado sus respuestas. Revierta su envío o quite el consentimiento para comenzar de nuevo.';
$string['remove_line'] = 'Quitar línea';
$string['sampleGroupName'] = 'El nombre de su grupo es';
$string['scenario'] = 'Escenario';
$string['scenarioInfo'] = 'Los tres escenarios difieren en la forma en la cual los ítems del cuestionario influencían la formación del grupo.
   Para equipos de proyectos se considera que el conocimiento anterior y las características de los miembros del grupo se complementan mutuamente, mientras que (el nivel de) la motivación y las metas personales deberían de ser tan similares como sea posible.
   Para grupos de tareas a casa se optimiza cada grupo para que tengan los mejores pre-requisitos posibles para aprendizaje colaborativo.
   Para grupos de presentaciones el principal aspecto es un interés mutuo en el mismo tópico seleccionado (y asignado) para trabajar en él.';
$string['scenarioLabel'] = '';
$string['scenario_description'] = 'Por favor elija el escenario más apropiado para la formación del grupo.';
$string['scenario_error'] = 'Por favor elija un escenario';
$string['scenario_homeworkgroups'] = 'Grupos de trabajo en casa';
$string['scenario_homeworkgroups_description'] = 'Los grupos de tarea para casa completan tareas (más pequeñas) en intervalos regulares (a menudo semanalmente) como una preparación para un examen. Aunque los trabajos de las tareas (a menudo llamados ejercicios, práctica, preguntas de control o tarea para casa) son principalmente subdivisibles entre los miembros del grupo, esto no está dirigido hacia el examen final, donde cada miembro será calificado  individualmente y necesita poder resolver solo todos los trabajos. Consecuentemente, groupformation intenta  buscar diverso conocimiento anterior y diversos estilos de aprendizaje, que se beneficien los unos a los otros.';
$string['scenario_homeworkgroups_short'] = 'Las áreas del conocimiento y las metas deseables son heterogéneas; orientación del equipo homogénea.';
$string['scenario_presentationgroups'] = 'Grupos de presentación';
$string['scenario_presentationgroups_description'] = 'Los grupos de presentación trabajan juntos por un período de tiempo relativamente corto para terminar una presentación (usualmente para darse en clase). Al principio, a menudo es asignada una sub-tarea específica a (o es seleccionada por) cada estudiante, es trabajada individualmente , y al final es re-ensamblada en una presentación completa. La calificación generalmente es hecha por el desempeño de todo el grupo junto. Por lo tanto, groupformation está enfocado primariamente para el interés mutuo en el mismo tópico.';
$string['scenario_presentationgroups_short'] = 'Habilita exclusivamente el ordenar una ista de tópicos mediante Arrastrar y Soltar. El procedimiento de que el primero en llegar sea el primero en ser atendido es evitado, para una distribución más justa de tópicos.';
$string['scenario_projectteams'] = 'Equipos del proyecto';
$string['scenario_projectteams_description'] = 'Equipos de trabajo trabajan juntos intensivamente para terminar un proyecto (por ejemplo, conducir un estudio, entregar un reporte, etc). A menudo, las obligaciones y tareas pueden ser divididas entre los miembros del equipo. Consecuentemente, es benéfico el tener una mezcla de competencias en el equipo. Usualmente, el resultado de un trabajo colectivo así es calificado con un puntaje grupal igual para todos los miembros. Así, groupformation busca una motivación similar y objetivos similares (además de los pre-requisitos).';
$string['scenario_projectteams_short'] = 'Las áreas del conocimiento y las motivaciones son heterogéneas; el nivel de conocimiento, las metas establecidas, y la orientación al equipo son homogéneas; los rasgos de carácter son parcialmente homogéneos, parcialmente heterogéneos.';
$string['scenario_usage_header'] = 'Questionnaire-Uso';
$string['scenario_usage_header_presentation'] = 'Los estudiantes configuran preferencias';
$string['select_info'] = 'Seleccionar cuales miembros del grupo moveer hacia otro grupo';
$string['settings_archiving_time'] = 'Tiempo para archivado';
$string['settings_archiving_time_description'] = 'Después de cuantos días se archivará la actividad.';
$string['settings_description'] = 'Configuraciones para archivado y funcionalidad adicional.';
$string['settings_header'] = 'General';
$string['settings_import_export'] = 'Importación/Exportación de respuestas';
$string['settings_import_export_description'] = 'Si se configura, los estudiantes pueden exportar sus respuestas e importar respuestas en otra instancia.';
$string['settings_participant_code'] = 'Código del participante';
$string['settings_participant_code_description'] = 'Los estudiantes necesitan ingresar un código de participante (como se usa en exámenes sicológicos).';
$string['starttime'] = 'Hora de Inicio';
$string['statistic'] = 'Estadísticas del questionnaire';
$string['stats_all'] = 'Usted contestó todas las preguntas en la categoría "{$a->category}".';
$string['stats_none'] = 'Usted no contestó ninguna de las preguntas en la categoría  "{$a->category}".';
$string['stats_partly'] = 'Usted contestó  {$a->answered} de un total de {$a->questions} preguntas en la categoría "{$a->category}".';
$string['students_enrolled_info'] = 'Estudiantes que están inscritos en este curso. Si la actividad está configurada para solamente un cierto agrupamiento, el número real podría ser más pequeño.';
$string['students_selected'] = 'estudiantes seleccionados';
$string['submit-modal-text'] = 'Para fines científicos y para el proceso de formación del grupo, es importante que Usted conteste todas las preguntas con la verdad y correctamente. Nosotros apreciamos su apoyo.

Haga clic en \'Cancelar\' si Usted quiere editar sus respuestas antes de enviarlas.';
$string['submit-modal-title'] = 'Enviar sus respuestas';
$string['successful_import'] = 'La importación fue exitosa. Usted puede revisar sus respuestas en el questionnaire.';
$string['tab_analysis'] = 'Análisis';
$string['tab_evaluation'] = 'Evaluación';
$string['tab_group'] = 'Asignación de Grupo';
$string['tab_grouping'] = 'Formación de grupo';
$string['tab_overview'] = 'Vista general';
$string['tab_preview'] = 'Questionnaire (Vista previa)';
$string['tab_questionnaire'] = 'Questionnaire';
$string['tabletitle_catfreetext'] = 'Texto libre';
$string['tabletitle_catmultiselect'] = 'Opción múltiple';
$string['tabletitle_catnumber'] = 'Número';
$string['tabletitle_character'] = 'Caracter';
$string['tabletitle_demographic'] = 'Demográfica';
$string['tabletitle_general'] = 'General';
$string['tabletitle_grade'] = 'Objetivos';
$string['tabletitle_honesty'] = 'Honestidad';
$string['tabletitle_knowledge'] = '¿Cuanto sabe Usted acerca dee los temas siguientes?';
$string['tabletitle_learning'] = 'Aprendizaje';
$string['tabletitle_motivation'] = 'Motivación';
$string['tabletitle_points'] = 'Objetivos';
$string['tabletitle_self'] = 'Auto-evaluación';
$string['tabletitle_sellmo'] = 'Motivación para Aprendizaje y Logro';
$string['tabletitle_skills'] = 'Eexperiencia';
$string['tabletitle_srl'] = 'Aprendizaje Auto-controlado';
$string['tabletitle_team'] = 'Equipo';
$string['tabletitle_times'] = 'Disponibilidad';
$string['tabletitle_topic'] = 'Tópicos';
$string['time'] = 'Hora';
$string['topic'] = 'Tópico';
$string['topic_group_info'] = 'Su tópico es';
$string['topicchoice'] = 'Selección del tópico';
$string['topics'] = 'Tópicos';
$string['topics_description'] = 'Yo quiero definir tópicos';
$string['topics_description_extended'] = 'Por favor enliste los tópicos para que los estudiantes elijan entre ellos. <strong>Después, la formación de grupo optimiza usando las preferencias de selección de tópico exclusivamente.</strong> Todas las demás partes del questionnaire serán ignoradas.';
$string['topics_dummy'] = 'Tópico';
$string['topics_help'] = 'Cuando se usan tópicos, las preguntas sobre conocimiento están desactivadas y el número de grupos es fijado por el número de tópicos.';
$string['topics_question'] = 'Por favor ordene los tópicos siguientes de acuerdo a sus intereses personales y empiece con su tópico favorito. Ordene mediante arrastrar y soltar.';
$string['topics_statistics'] = 'Estadísticas de tópicos ofrecidos';
$string['topics_statistics_description'] = 'Los puntajes siguientes indican cuales tópicos han sido favorecidos por los estudiantes; por ejemplo, un puntaje cercano a 1 indica que el tópico es más gustado que los tópicos con un puntaje menor.';
$string['topics_statistics_score'] = 'Puntaje [0-1]';
$string['unselect_all'] = 'Des-seleccionar todos';
$string['useOneLineForEachKnowledge'] = 'Usar una línea para cada tópico';
$string['useOneLineForEachTopic'] = 'Usar una línea para cada tópico';
$string['userpergroup'] = '¿Cuantos usuarios en un grupo?';
$string['your_group'] = 'El nombre de su grupo es:';
