<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_obf', language 'es_mx', version '4.4'.
 *
 * @package     local_obf
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activitycompletedby'] = 'Completado por';
$string['addcourses'] = 'Añadir cursos seleccionados';
$string['addcriteria'] = 'Crear nueva regla para otorgar';
$string['addemaildescription'] = 'Escriba su dirección Email. Si la dirección no ha sido verificada, se enviará un código para verificación a esa dirección.';
$string['addemailheader'] = 'Añada y verifique su dirección Email';
$string['addnew'] = 'Añadir nuevo';
$string['addnewclient'] = 'Añadir nuevo cliente';
$string['addnewcriterion'] = 'Añadir curso';
$string['addnewoauth2'] = 'Nueva conexión OAuth2 API';
$string['addrulelabel'] = 'Aquí usted puede definir donde estarán disponibles las insignias, al aparear categorías de OBF con categorías de Moodle. de forma predeterminada, sin una regla específica, sus insignias de OBF estarán disponibles en todas sus categorías de Moodle.';
$string['addrules'] = 'Añadir una regla';
$string['alluseralreadyrevoke'] = 'Todos los usuarios tienen, o que fueron revocados, o que ya no están registrados en la plataforma';
$string['apidataretrieve'] = 'Eventos de emisión de insignias';
$string['apidataretrieveall'] = 'Mostrar todas las insignias emitidas con OBF';
$string['apidataretrievedesc'] = 'Si Usted selecciona a "Todas" las insignias emitidas directamente desde la Fábrica de Insignias Abiertas, serán incluidas en todos los resultados (de insignias).';
$string['apidataretrievelocal'] = 'Mostrar solamente insignias emitidas desde este sistema';
$string['apierror'] = 'No se pudo encontrar servicio OBF. Por favor revise la URL de la API de las configuraciones.';
$string['apierror0'] = 'Falló solicitud de servicio de Open Badge Factory (Fábrica de Insignia Abierta). El administrador del sitio necesita configurar las configuraciones del plugin.';
$string['apierror400'] = 'Falló solicitud de servicio de Open Badge Factory (Fábrica de Insignia Abierta) por causa de un parámetro erróneo/faltante.';
$string['apierror403'] = 'La Fábrica de Insignias Abiertas negó la solicitud. El administrador del sitio necesita re-autenticar el cliente de la Fábrica de Insignias Abiertas.';
$string['apierror404'] = 'No se pudo encontrar servicio OBF. Por favor revise la URL de la API de las configuraciones.';
$string['apierror405'] = '405 Método no permitido';
$string['apierror411'] = '411 Longitud requerida';
$string['apierror413'] = '413 Entidad solicitada demasiado grande';
$string['apierror429'] = '429 Demasiadas solicitudes';
$string['apierror495'] = '495 Error de certificado';
$string['apierror496'] = 'El certificado necesita ser generado antes de que pueda ser usada Open Badge Factory con Moodle. Ingrese a Open Badge Factory para obtener el token de solicitud y péguelo en el campo inferior.';
$string['apierror500'] = '500 Error interno del servidor';
$string['apierror502'] = '502 Bad gateway';
$string['apierror503'] = 'El servicio OBF está temporalmente no-disponible. Por favor inténtelo nuevamente más tarde.';
$string['authenticate'] = 'Autenticar';
$string['authenticationsuccess'] = 'Autenticación exitosa';
$string['availablecategories'] = 'Categorías disponibles';
$string['availablecategorieshelp'] = 'Seleccionar las categorías de insignia de cuales insignias puedan ser usadas en eventos de emisión de esta institución. Si ninguna de las categorías es seleccionada, las insignias de todas las categorías pueden ser emitidas.';
$string['availablecategoriesselect'] = 'Categorías';
$string['back'] = 'Regresar';
$string['backpackconfig'] = 'Configuraciones de Mochila de Mozilla';
$string['backpackconnected'] = 'Conectado';
$string['backpackdisconnected'] = 'Desconectado';
$string['backpackemail'] = 'Dirección Email';
$string['backpackemail_help'] = 'Dirección Email asociada con su cuenta de Pasaporte de InsigniasAbiertas (OpenBadges).';
$string['backpackemailaddexternalbackpackprovider'] = '<p>No se pudo encontrar un usuario que coincidiera con el Email \'<strong>{$a->useremail}</strong>\' de {$a->backpackproviderfullname}.</p><p>Asegúrese de que Usted tenga una cuenta en <a href="{$a->backpackprovidersiteurl}">{$a->backpackprovidersiteurl}</a> y \'<strong>{$a->useremail}</strong>\' sea añadido a su perfil.</p>';
$string['backpackemailaddexternalobp'] = '<p>No se pudo encontrar un usuario que coincida con email \'<strong>{$a}</strong>\' de Open Badge Passport.</p><p>Para añadir sur email, abrir <a href="https://openbadgepassport.com">https://openbadgepassport.com</a> en su navegador e ingresar. </p><p>Después de ingresar, seguir la ruta de navegación hacia <strong><i>My account &gt; Account settings &gt; E-mail addresses</i></strong> .</p><p>Con la página <i>E-mail addresses</i> -abierta, añadir \'<strong>{$a}</strong>\' en el campo de \'Add new e-mail\' -y guardar.</p>';
$string['backpackemailnotfound'] = 'No se pudo encontrar a un usuario por el Email \'{$a->email}\' de {$a->provider}.';
$string['backpackgroups'] = 'Grupos de insignia';
$string['backpackgroups_help'] = 'Seleccione los grupos de insignia que son mostrados en su visor de insignia';
$string['backpackprovideractions'] = 'Acciones';
$string['backpackprovideremailconfigureable'] = 'El usuario puede definir la dirección Email';
$string['backpackproviderfullname'] = 'Nombre completo';
$string['backpackprovidersettings'] = '{$a} -configuraciones';
$string['backpackprovidershortname'] = 'Nombre corto';
$string['backpackproviderurl'] = 'URL';
$string['backpackproviderurlinvalid'] = 'La URL no está definida apropiadamente; por favor, use la URL completa, como por ejemplo https://openbadgepassport.com/displayer/';
$string['backpackprovideruserwarning'] = 'Advertencia: {$a} usuarios ya tiene guardadas las asociaciones del Email para el proveedor. Cree  nuevos proveedores cuando añada nuevos servicios; no edite los proveedores existentes para apuntar a otros servicios.';
$string['backpacksettings'] = 'Configuraciones de Mochila de Mozilla';
$string['badgeactions'] = 'Acciones';
$string['badgeblacklist'] = 'Ocultar insignia';
$string['badgecategories'] = 'Categorías';
$string['badgecreated'] = 'Creada en';
$string['badgecriteria'] = 'Reglas para otorgar';
$string['badgecriteriahtml'] = 'Criterio';
$string['badgecriteriaurl'] = 'URL del criterio';
$string['badgedescription'] = 'Descripción';
$string['badgedetails'] = 'Detalles de insignia';
$string['badgeemail'] = 'Plantilla de Email';
$string['badgeexpiresby'] = 'Caduca en';
$string['badgeexport'] = 'Exportar insignias creadas previamente en Moodle';
$string['badgeexportdescription'] = 'Una copia de todas las insignias seleccionadas será hecha en la Fábrica de Insignia Abierta.';
$string['badgeexportzeroexportable'] = 'No se encontraron insignias exportables, o todas las insignias ya han sido exportadas.';
$string['badgehistory'] = 'Histoira de otorgamiento';
$string['badgeimage'] = 'Insignia';
$string['badgeissued'] = 'La insignia fue emitida exitosamente.';
$string['badgeissuedbody'] = 'La insignia <b>{$a->badgename}</b> fue otorgada a <b>{$a->firstname} {$a->lastname}</b>.<br>La insignia fue emitida en el curso <b>{$a->courselink}.</b>';
$string['badgeissuedsubject'] = 'La insignia {$a->badgename} fue otorgada a usuarios ...';
$string['badgeissuedwhen'] = 'Esta insignia es emitida automáticamente cuando se cumple cualquiera de las reglas siguientes:';
$string['badgelist'] = 'Lista de insignias';
$string['badgelisttitle'] = 'Todas las insignias';
$string['badgename'] = 'Nombre';
$string['badgenameorid'] = 'ID o Nombre de Insignia';
$string['badgependinginformation'] = 'Información';
$string['badgependinginformationmessage'] = 'Esta sección contiene una lista de insignias pendientes de emisión. En algunos casos, las insignias pueden retrasarse debido a problemas como la indisponibilidad del servidor o la inactividad de la suscripción del cliente.';
$string['badgerevokedbody'] = 'La insignia <b>{$a->badgename}</b> le ha sido revocada a <b>{$a->firstname} {$a->lastname}</b>.';
$string['badgerevokedsubject'] = 'La insignia {$a->badgename}  ha sido revocada para usuarios ...';
$string['badgesonprofiledescri0'] = 'No mostrar insignia en perfil';
$string['badgesonprofiledescri1'] = 'Si mostrar insignia en perfil';
$string['badgesplatform'] = 'Insignias ganadas en {$a->nameinstance}';
$string['badgetags'] = 'Marcas';
$string['badgewasautomaticallyissued'] = 'Después de revisar, la insignia fue otorgada a {$a} recipiente(s).';
$string['blacklistbadge'] = 'No mostrar insignia';
$string['blacklistdescription'] = 'Seleccione la insignia que NO quiere mostrar en su perfil. Usted puede ocultar cualquier insignia emitida por  este entorno Moodle.';
$string['blacklistsaved'] = 'Mochila guardada.';
$string['cachedef_obf_assertions'] = 'Caché de afirmación de insignia OBF';
$string['cachedef_obf_assertions_backpacks'] = 'Caché de servicio externo Open Badge';
$string['cachedef_obf_pub_badge'] = 'Caché de datos específicos de eventos accesibles públicamente de OBF Badge';
$string['cancel'] = 'Cancelar';
$string['cannoteditcriterion'] = 'Esta regla no puede ser editada, porque la insignia ya ha sido otorgada automáticamente basándose en esta regla.';
$string['categorysettings'] = 'Configuraciones de categoría';
$string['certificateexpirationremindertask'] = 'recordatorio de caducidad del certificado';
$string['certrequestfailed'] = 'Hubo un error al solicitar el certificado de la API';
$string['choosecategories'] = 'Elegir sus categorías de Moodle';
$string['chooseurbadgecategories'] = 'Elegir sus categorías de OBF';
$string['client'] = 'Cliente';
$string['clientdeleted'] = 'Conexión API eliminada';
$string['clientid'] = 'ID del cliente';
$string['clientid_help'] = 'ID del cliente de su cuenta';
$string['clientname'] = 'Nombre del cliente';
$string['clientsaved'] = 'Cliente guardado';
$string['clientsecret'] = 'Secreto del cliente';
$string['clientsecret_help'] = 'Ingrese a su cuenta de la Fábrica y vaya a  "Herramientas administrativas > API". Haga clic en "Generar nuevo secreto del cliente"';
$string['closemodal'] = 'Cerrar';
$string['closepopup'] = 'Cerrar';
$string['completedbycriterion'] = 'por <strong>{$a}</strong>';
$string['configurecriteria'] = 'Configurar';
$string['confirmcriteriondeletion'] = '¿Está Used seguro de querer eliminar esta regla de otorgamiento?';
$string['confirmdelete'] = '¿Está Usted seguro de querer eliminar el registro {$a} ?';
$string['confirmrevokation'] = '¿Está Used seguro de querer revocar la insignia del usuario?';
$string['congratsbadgeearned'] = '¡Felicitaciones! Usted ha ganado una nueva insignia: {$a}';
$string['connect'] = 'Conectar {$a}';
$string['connectionerror'] = 'Se produjo un error de conexión. Esto podría deberse a una suscripción revocada o a servidores inaccesibles. Si el problema persiste, contacte con el servicio de asistencia.';
$string['connectionisworking'] = 'La conexión OBF está levantada y funcionando. el certificado del cliente expira en <strong>{$a}</strong>.';
$string['connectionstatus'] = 'Estatus de conexión';
$string['contact_openbadgefactory'] = 'Los beneficiarios de insignia pueden acceder a datos personales usados  por los emisores de insignias para proporcionarles sus insignias en: <a href"https://openbadgefactory.com/en/personal-data-request/" target="_blank">https://openbadgefactory.com/en/personal-data-request/</a> y pueden solicitar que los emisores de insignia eliminen sus datos personales.';
$string['coursealreadyincriterion'] = 'La regla de otorgamiento automático de esta insignia en este curso no puede ser editada, porque la combinación curso/insignia ya existe en otra regla que contiene varios cursos.';
$string['coursebadgelisttitle'] = 'Insignias relacionadas con este curso';
$string['coursecompletedby'] = 'Completada por';
$string['coursecompletionnotenabled'] = 'El seguimiento de la finalización no está habilitado en este curso. Habilítelo en <a href="{$a}">confguraciones del curso</a>.';
$string['courseeventhistory'] = 'Historia de Otorgamiento del Curso';
$string['courseobfbadges'] = 'Insignias';
$string['courserequired'] = 'Tiene que estar seleccionado al menos un curso';
$string['coursereset'] = 'Eliminar reglas de otorgamiento cuando el curso es reiniciado.';
$string['courseuserbadges'] = 'Insignias del usuario';
$string['createcsv'] = 'Descargar Historia de Insignias en CSV';
$string['criteria_3'] = 'Campos del perfil';
$string['criteria_3_help'] = 'Cuales campos del perfil necesitan llenarse, para disparar otorgamiento de insignia.';
$string['criteriaaddcourse'] = 'Añadir curso';
$string['criteriaaddendum'] = 'Adendo de criterios';
$string['criteriaaddendum_help'] = 'Una adición al criterio será añadida a la insignia emitida. La adición será mostrada debajo del criterio de la insignia. Nota: La sintaxis Markdown está soportada.';
$string['criteriaaddendumadd'] = 'Añadir un adendo de criterios';
$string['criteriaaddendumheader'] = 'Adendo de criterios';
$string['criteriacompletedwhen'] = 'Esta regla se cumple cuando...';
$string['criteriacompletedwhenall'] = 'Todos los cursos siguientes tienen que estar completados:';
$string['criteriacompletedwhenany'] = 'Cualquiera de los cursos siguientes tiene que estar completado:';
$string['criteriacompletionmethodall'] = 'Todos estos cursos están completados';
$string['criteriacompletionmethodany'] = 'Cualquiera de estos cursos es completado';
$string['criteriacompletionmethodprofileall'] = 'Todos los campos de perfil seleccionados han sido completados';
$string['criteriacompletionmethodprofileany'] = 'Cualquiera de los campos del perfil ha sido completado';
$string['criteriacourses'] = 'Criterios en esta regla';
$string['criteriapartofcourseset'] = 'Parte de criterio con varios cursos';
$string['criteriapreview'] = 'Vista previa de criterio de insignia';
$string['criteriatypeactivity'] = 'Finalización  de actividad';
$string['criteriatypecourse'] = 'Finalización de curso';
$string['criteriatypecourseset'] = 'Finalización de curso';
$string['criteriatypeprofile'] = 'Completado del perfil';
$string['criteriatypetotaracertif'] = 'Completando un certificado';
$string['criteriatypetotaraprogram'] = 'Completando un programa';
$string['criteriatypeunknown'] = 'Criterio incompleto';
$string['criteriondeleted'] = 'Se eliminó regla para otorgamiento.';
$string['criterionsaved'] = 'Se guardó regla para otorgamiento.';
$string['csrexportfailed'] = 'Hubo un error al tratar de exportar la solicitud para firma del certificado';
$string['dateformatdate'] = '%Y-%m-%d';
$string['deauthenticate'] = 'Desconectar';
$string['deauthenticationsuccess'] = 'Desconectado exitosamente de Fábrica de Perfil Abierto';
$string['delete_rule'] = 'Eliminar regla';
$string['delete_rule_button'] = 'Eliminar esta regla';
$string['deleteclientconfirm'] = '¿Está seguro de querer eliminar esta conexión API?';
$string['deletecriterion'] = 'Eliminar regla de otorgamiento';
$string['deletelink'] = 'Eiminar';
$string['disableassertioncache'] = 'Deshabilitar caché de afirmación de insignia';
$string['disableassertioncache_help'] = 'Las insignias en páginas de perfil no serán cacheadas. Las insignias emitidas desde afuera del entorno Moodle aparecerán en páginas de perfil sin retraso, pero puede afectar los tiempos de carga de páginas de perfil.';
$string['disablemoodlebadges'] = 'Deshabilitar el módulo de Insignias propio de Moodle. ADVERTENCIA: EL PERMITIR EL MÓDULO PROPIO DE MOODLE CAUSARÁ CONFLICTO';
$string['disablemoodlebadges_help'] = 'Las insignias antiguas de Moodle serán ocultadas de la interfaz del usuario, pero las insignias del usuario que sean guardadas a una Mochila todavía pueden mostrarse, y las insignias exportadas a la Fábrica de Insignias Abiertas todavía pueden ser otorgadas.';
$string['disconnect'] = 'Desconectar {$a}';
$string['displaymoodlebadges'] = 'Mostrar insignias de Moodle en perfiles';
$string['displaymoodlebadges_help'] = 'Las insignias antiguas de Moodle serán mostradas en páginas de perfil del usuario.';
$string['edit'] = 'Editar';
$string['editemailmessage'] = 'Editar mensaje Email';
$string['emailbadgeid'] = 'ID de Insignia';
$string['emailbadgerevokedbody'] = 'Una de sus insignias ganadas ({$a->revokedbadgename}) ha sido revocada por {$a->revokername}.';
$string['emailbadgerevokedsubject'] = 'Su insignia ha sido revocada';
$string['emailbody'] = 'Cuerpo del Email';
$string['emailbutton'] = 'Mostrar mensaje';
$string['emailfooter'] = 'Pie de página del email';
$string['emaillinktext'] = 'Prueba del enlace del Email';
$string['emailmessage'] = 'Mensaje Email';
$string['emailsubject'] = 'Asunto del Email';
$string['emailtemplatedescription'] = 'Aquí puede Usted configurar la plantilla por dfecto para el Email que será enviado al usuario que reciba eesta insignia. el Email puede ser personalizado antes de que la insignia sea otorgada.';
$string['emailtemplatesaved'] = 'La plantilla de Email fue guardada exitosamente.';
$string['emailverifytokenemailbody2'] = 'Por favor, verifique su dirección de correo electrónico. Código de verificación:';
$string['emailverifytokenemailsubject'] = 'Verificación del Email';
$string['error:nosuchfield'] = 'No hay tal campo.';
$string['eventrevoked'] = 'La insignia ha sido revocada exitosamente para {$a}.';
$string['evidence'] = 'Evidencia';
$string['expired'] = 'Caducó';
$string['expiresby'] = 'Caduca';
$string['expiringcertificate'] = 'La clave API de Open Badge Factory expirará en <b>{$a->days}</b> días. Para renovar la clave API <a href="{$a->obfurl}">ingrese a Open Badge Factory</a> con la cuenta administrativa de su organización, vaya a Admin tools -> Edit Organisation Details -> More settings, genere el token de solicitud de firma de certificado (certificate signing request token) y renueve la clave API en  <a href="{$a->configurl}">Open Badges -> Settings -> OBF request token</a>.';
$string['expiringcertificatesubject'] = 'El certificado de cliente de Open Badge factoryestá expirando.';
$string['exportbadgename'] = 'Nombre de insignia';
$string['exportexpiresby'] = 'Expira en';
$string['exportextrasettings'] = 'Configuraciones para exportar';
$string['exportissuedfrom'] = 'Emitida desde';
$string['exportissuedon'] = 'Emitida en';
$string['exportrecipients'] = 'Destinatarios';
$string['exportsettings'] = 'Configuraciones para exportar';
$string['failedtogetaccesstoken'] = 'No se pudo acceder al token';
$string['failrecordlist'] = 'Cola de Insignias Pendientes';
$string['gradecriterion'] = 'con <strong>c calificación mínima de  {$a}</strong>';
$string['history'] = 'Historia de otorgamiento';
$string['historyrecipients'] = '{$a} recipientes';
$string['image_not_found'] = 'Error: El enlace a la imagen de la insignia con pudo ser recuperado.';
$string['infoconnectapi'] = 'Seleccionar método de autenticación API. OAuth2 es preferido en el nivel de suscripción Pro.';
$string['invalidclientsecret'] = 'La ID o el secreto del cliente NO es válido';
$string['invalidcriterion'] = 'LA regla de otorgamiento es inválida. Uno o más requisitos no se cumplen y la insignia';
$string['invalidtab'] = 'Página no encontrada';
$string['issuancedetails'] = 'Detalles de la emisión';
$string['issue'] = 'Emitir insignia';
$string['issueandexpiration'] = 'Fechas de emisión y caducidad';
$string['issuebadge'] = 'Emitir una insignia';
$string['issuedfrom'] = 'Emitidas desde';
$string['issuedon'] = 'Emitida en';
$string['issuer'] = 'Emisor';
$string['issuerdescription'] = 'Descripción';
$string['issuerdetails'] = 'Detalles del emisor';
$string['issueremail'] = 'Email';
$string['issuername'] = 'Nombre';
$string['issuerroles'] = 'Roles del emisor';
$string['issuerroles_help'] = 'Autorizar roles para emitir insignias para este cliente:';
$string['issuerurl'] = 'URL';
$string['issuethisbadge'] = 'Emitir esta insignia';
$string['localevents'] = 'La historia de otorgamientos solamente muestra insignias emitidas desde este sistema.';
$string['makeexporteddrafts'] = 'Las insignias exportadas son borradores por defecto';
$string['messageprovider:issued'] = 'Insignia nueva es otorgada';
$string['messageprovider:issuedbadgetostudent'] = 'Insignia nueva es otorgada a un estudiante';
$string['messageprovider:revoked'] = 'La insignia emitida está revocada';
$string['messageprovider:revokedbadgetostudent'] = 'La insignia de un estudiante ha sido revocada';
$string['minimumgrade'] = 'Calificación mínima';
$string['newbadgeearned'] = '<b>{$a->courselink}</b><br><hr><br>Usted ha obtenido una nueva insignia:<b>{$a->badgelink}</b><br><br>Usted ha recibido un correo electrónico que explica cómo obtener su insignia. <br>Si usted no puede encontrar este correo electrónico, te invitamos a que revise sus carpetas de correo no deseado o spam.';
$string['nobackpackgroups'] = 'Usted no tiene insignias públicas en su Pasaporte de Open Badge. Por favor comparta sus insignias como públicas si desea mostrarlas aquí.';
$string['nobadgehistory'] = 'Esta insignia todavía no ha sido emitida aun.';
$string['nobadges'] = 'Sin insignia';
$string['nobadgesearned'] = 'No se ha ganado ninguna insignia aún';
$string['nobadgesincourse'] = 'Todavía sin insignias relacionadas.';
$string['nobadgestoexport'] = 'Sin insignias para exportar.';
$string['nocourseswithcompletionenabled'] = 'No hay cursos con finalización habilitada.';
$string['nocriteriayet'] = 'Todavía no se han creado reglas de otorgamiento automático.';
$string['nohistory'] = 'Todavía sin insignias emitidas.';
$string['noparticipants'] = 'Sin participantes.';
$string['norecordsfound'] = 'No se encontraron registros';
$string['nouserbadges'] = 'Todavía sin insignias ganadas.';
$string['novalidcourses'] = 'No hay cursos a los que les falten reglas para otorgar con respecto a esta insignia.';
$string['numberofbadgesmany'] = 'insignias';
$string['numberofbadgessingle'] = 'insignia';
$string['obf'] = 'Insignias Abiertas';
$string['obf:configure'] = 'Configurar configuraciones del cliente de OBF';
$string['obf:configureuser'] = 'Configurar las configuraciones propias de Insignia Abierta';
$string['obf:earnbadge'] = 'Ganarse una Insignia Abierta';
$string['obf:editcriterion'] = 'Editar criterio de insignia';
$string['obf:issuebadge'] = 'Emitirle insignia a un usuario';
$string['obf:revokeallevents'] = 'Revocar evento';
$string['obf:revokecourseevents'] = 'Revocar un evento, que fue emitido automáticamente basándose en criterios del curso.';
$string['obf:seeparticipantbadges'] = 'Ver las insignias de participantes del curso';
$string['obf:viewallbadges'] = 'Ver insignias disponibles';
$string['obf:viewallevents'] = 'Ver eventos de emisión de insignia';
$string['obf:viewbackpack'] = 'Ver mochilas';
$string['obf:viewcourseevents'] = 'Ver eventos de emisión de insignia de curso';
$string['obf:viewdetails'] = 'Ver detalles de insignia';
$string['obf:viewhistory'] = 'Ver historia de emisión de insignia';
$string['obf:viewownbackpack'] = 'Ver mochila propia';
$string['obf:viewspecialnotif'] = 'Este permiso le permite al rol el habilitar el envío de notificaciones cuando un usuario recibe un insignia o cuando es revocada';
$string['obfconnectionconfig'] = 'Configuraciones de conexión API antiguas heredadas';
$string['obfurl'] = 'URL de API';
$string['obfurl_help'] = 'URL para la Fábrica de donde es esta cuenta.';
$string['obfuserpreferences'] = 'Configuraciones de Insignia Abierta';
$string['obpbackpacksettings'] = 'Pasaporte de Insignia Abierta - configuraciones';
$string['personalbadgecloudservices'] = 'Origen del visualizador de insignia';
$string['pkidirnotwritable'] = 'El directorio del certificado <i>{$a}</i> debería ser escribible para el usuario del servidor web.';
$string['pluginname'] = 'Fábrica de Insignia Abierta';
$string['previewbadge'] = 'Previsualizar insignia';
$string['previewcriteria'] = 'Previsualizar';
$string['previewemail'] = 'Previsualizar';
$string['privacy:metadata:activity_name'] = 'Nombre de actividad';
$string['privacy:metadata:addendum'] = 'Adendo';
$string['privacy:metadata:backpack_data'] = 'Datos de Mochila';
$string['privacy:metadata:backpack_emails'] = 'Emails de Mochila';
$string['privacy:metadata:backpack_id'] = 'ID de Mochila';
$string['privacy:metadata:backpack_provider'] = 'Proveedor de Mochila';
$string['privacy:metadata:badge_blacklists'] = 'Lista negra de Insignia';
$string['privacy:metadata:badge_groups'] = 'Grupos de Insignia';
$string['privacy:metadata:badge_id'] = 'ID de insignia';
$string['privacy:metadata:body'] = 'Cuerpo';
$string['privacy:metadata:client_id'] = 'ID del cliente';
$string['privacy:metadata:completed_by'] = 'Completado Por';
$string['privacy:metadata:completion_method'] = 'Método de Finalización';
$string['privacy:metadata:course_id'] = 'ID del curso';
$string['privacy:metadata:course_name'] = 'Nombre del Curso';
$string['privacy:metadata:courseid'] = 'ID del curso';
$string['privacy:metadata:criteria_addendum'] = 'Adendo de criterios';
$string['privacy:metadata:criteria_type'] = 'Tipo de criterio';
$string['privacy:metadata:criterion'] = 'Criterio';
$string['privacy:metadata:criterion_courses'] = 'Cursos de Criterio';
$string['privacy:metadata:criterion_met'] = 'Criterio alcanzado';
$string['privacy:metadata:email'] = 'E-mail';
$string['privacy:metadata:email_templates'] = 'Plantillas de E-mail';
$string['privacy:metadata:event_id'] = 'ID del evento';
$string['privacy:metadata:expiration_date'] = 'Fecha de expiración';
$string['privacy:metadata:footer'] = 'Pie de página';
$string['privacy:metadata:full_name'] = 'Nombre Completo';
$string['privacy:metadata:grade'] = 'Calificación';
$string['privacy:metadata:history_emails'] = 'E-mail de historia';
$string['privacy:metadata:id'] = 'ID';
$string['privacy:metadata:issue_date'] = 'Fecha de emisión';
$string['privacy:metadata:issue_events'] = 'evento de emisión';
$string['privacy:metadata:link_text'] = 'Texto del enlace';
$string['privacy:metadata:met_at'] = 'Conseguido en';
$string['privacy:metadata:name'] = 'Nombre';
$string['privacy:metadata:obf_criterion_id'] = 'ID de criterio OBF';
$string['privacy:metadata:remote_data'] = 'Datos Remotos enviado a https://openbadgefactory.com/';
$string['privacy:metadata:subject'] = 'Asunto';
$string['privacy:metadata:timestamp'] = 'Sello de tiempo';
$string['privacy:metadata:token'] = 'Token';
$string['privacy:metadata:use_addendum'] = 'Usar adendo';
$string['privacy:metadata:user_emails'] = 'Enlace de usuario por E-mails de mochila';
$string['privacy:metadata:user_id'] = 'ID del usurio';
$string['privacy:metadata:user_preferences'] = 'Preferencias del usuario';
$string['privacy:metadata:userid'] = 'ID del usuario';
$string['privacy:metadata:value'] = 'Valor';
$string['privacy:metadata:verified'] = 'Verificada';
$string['processobfissuefailedrecord'] = 'Reintentar eventos de emisión de insignias OBF que fallaron anteriormente';
$string['processobfissuefailedrecordlog'] = 'Error al intentar reemitir el ID de la insignia: {$a}. Esto podría deberse a un error de conexión con el servidor o a una suscripción de cliente inactiva.';
$string['profilebadgelist'] = 'Insignias';
$string['profilebadgelistbackpackprovider'] = '{$a} insignias';
$string['profilebadgelistmoz'] = 'Insignias de Mochila Mozilla';
$string['profilebadgelistobp'] = 'Insignias Pasaporte de Insignia Abierta';
$string['pubkeyextractionfailed'] = 'Hubo un error al extraer la clave pública del certificado.';
$string['pubkeyrequestfailed'] = 'Hubo un error al solicitar la clave pública de la API';
$string['readmeenablecompletion'] = 'Criterio para ganar insignia';
$string['readmeenablecompletion_help'] = '<p>Para que funcione apropiadamente el criterio para ganar insignia automáticamente, tiene que estar habilitado el seguimiento de la finalización. </p><p>La forma más fácil de habilitar el seguimiento de finalización es:</p><ol><li>Localice el bloque de "Configuraciones".</li><li>Escriba "enablecompletion" dentro de la caja de búsqueda, y elija \'Buscar\'.</li><li>Habilitar seguimiento de finalización: Si.</li><li>Opcional pero recomendable: Habilitar por defecto el seguimiento de finalización en configuraciones del curso.</li></ol><strong>Configuraciones del curso</strong><p>Si el seguimiento de la finalización no está habilitado en las configuraciones por defecto del curso, el seguimiento de la finalización puede ser habilitado vía la página de <i>Administración del curso->Editar configuraciones</i> .</p>';
$string['recipientcandidates'] = 'Usuarios que coincidan con la búsqueda';
$string['recipients'] = 'Beneficiario(s)';
$string['requesttoken'] = 'Token de solicitud OBF';
$string['requesttoken_help'] = '<p>PPegue aquí el token que es usado para conectar a API de Open Badge Factory.</p><p>Para generar la clave API requerida, ingrese a <a href="https://openbadgefactory.com">Open Badge Factory</a>,  en la página de herramientas administrativas \'<i>Admin tools</i>\' , abra el enlace a la clave API \'<i>API key</i>\' -, y haga clic en Generar token para firmar certificado generado \'<i>Generate certificate signing request token</i>\'. Copie el token generado a  Moodle.</p>';
$string['resetfilter'] = 'Reiniciar filtro';
$string['reviewcriterionaftersave'] = 'Examinar la regla retroactivamente';
$string['reviewcriterionaftersave_help'] = 'Si esta casilla está activada, la regla será revisada después de guardarla y si alguien ya ha cumplido con esta regla anteriormente, entonces esta insignia será otorgada automáticamente.';
$string['revoke'] = 'Revocar';
$string['revokeuserbadges'] = 'Revocar insignia';
$string['rules'] = 'Regla';
$string['saveconfiguration'] = 'Continuar';
$string['savecriteria'] = 'Guardar';
$string['savesettings'] = 'Guardar';
$string['selectactivity'] = 'Seleccionar actividad';
$string['selectatleastonerecipient'] = 'Selecionar al menos un recipiente';
$string['selectbadge'] = 'Seleccionar insignia';
$string['selectbadgestoexport'] = 'Seleccionar las insignias que desea exportar a la Fábrica de Insignia Abierta';
$string['selectcompletionmethod'] = 'Seleccionar método de finalización';
$string['selectcompletionmethod_help'] = 'Seleccionar el método por el que se gana la insignia.';
$string['selectcourses'] = 'Seleccionar cursos';
$string['selectcourses_help'] = 'Seleccione los cursos que deben de completarse para recibir autmáticamente esta insignia.';
$string['selectcriteriatype'] = 'Seleccionar...';
$string['selectcriteriatype_help'] = 'Seleccionar el método por el que se gana la insignia.';
$string['selectprogram'] = 'Seleccionar programa';
$string['selectrecipients'] = 'Seleccionar recipientes';
$string['settings'] = 'Configuraciones';
$string['settingssaved'] = 'Configuraciones guardadas';
$string['showassertion'] = 'Detalles';
$string['showbadgecriteria'] = 'Criterio de insignia abierta';
$string['showbadges'] = 'Mostrar insignias';
$string['showbadgesonmyprofile'] = 'Mostrar insignias en página de perfil';
$string['showcategories'] = 'Mostrar insignias de estas categorías:';
$string['showconnectionconfig'] = 'Yo sé que está funcionando, pero déjame cambiar el token de cualquier forma.';
$string['showmore'] = 'Mostrar más';
$string['showmorerecipients'] = 'más';
$string['siteadmin'] = 'Administración del Sitio';
$string['tableheaderaction'] = 'Acción';
$string['tableheadercourse'] = 'Curso';
$string['tableheaderdate'] = 'Fecha';
$string['tableheaderid'] = 'ID';
$string['tableheaderinfo'] = 'Información';
$string['tableheaderrecipients'] = 'Destinatarios';
$string['tableheaderstatus'] = 'Estado';
$string['testbackpackapiurlexception'] = '¡Error al probar API via <a href="{$a->url}">{$a->url}</a> ! Código del error: {$a->errorcode}.';
$string['toearnthisbadge'] = 'Para ganar esta insignia el curso debe estar finalizado';
$string['tokendecryptionfailed'] = 'Falló el des-encriptado del token solicitado. Asegúrese de pegar completo el token de solicitud que firma el certificado.';
$string['totaraprogram'] = 'Programa';
$string['totaraprogramexpiresbybadge'] = 'Caducidad de propiedades de insignia';
$string['totaraprogramexpiresbycertificate'] = 'Caducidad de propiedades de certificado';
$string['totaraprogramselectexpires'] = 'Seleccionar cual configuración se usa para otorgar insignias';
$string['unavailableinfo'] = 'Parece que la información de esta insignia no está disponible actualmente. Esto podría deberse a que el servidor OBF no está disponible o a que la suscripción del cliente está inactiva.';
$string['unavailableserver'] = 'El servidor de insignias no está disponible actualmente o podría no estar disponible para al menos un cliente. Verifique la configuración del plugin y, si el problema persiste, contacte con el proveedor de servicios correspondiente. Es posible que algunas funciones o información no estén disponibles.';
$string['unavailableserverbadgelist'] = 'La lista de insignias no puede ser mostrada porque el servidor OB actualmente está inalcanzable.';
$string['unknowncriterion'] = 'Criterio incompleto';
$string['upgradelegacyapi'] = 'Sugerencia: Usted puede cambiar a autenticación OAuth basada en API en el nivel de suscripción Pro. Comience por quitar esta conexión.';
$string['urlgroup'] = 'URL';
$string['urlgroup_help'] = '<p>Si Usted no está usando el servidor por defecto openbadgefactory.com. Configure aquí a dirección del servicio.</p>';
$string['useremailupdater'] = 'Actualizador de Email del usuario';
$string['userpreferences'] = 'Configuraciones del usuario';
$string['userpreferencessaved'] = 'Configuraciones del usuario guardadas';
$string['userremoved'] = 'Usuario quitado';
$string['userscanmanagedisplayofbadges'] = 'Los usuarios pueden elegir si quieren mostrar insignias';
$string['usersdisplaybadges'] = 'Mostrar insignias del usuario';
$string['usersforcedtodisplaybadges'] = 'Las insignias son mostradas en página del perfil';
$string['usersnotallowedtodisplaybadges'] = 'Las insignias no son mostradas en página del perfil';
$string['verification_failed'] = 'Falló la verificación de mochila. Razón: {$a}';
$string['verifytoken'] = 'Token';
$string['verifytokenbutton'] = 'Verificar';
$string['verifytokendescription'] = 'Se ha enviado un Email a la dirección proporcionada. Revise su correo para localizar un código de verificación.';
$string['warningcannoteditafterreview'] = 'Tenga en cuanta que si la insignia es otorgada cuando estas reglas están siendo revisadas, las reglas ya no podrán ser editadas. Una vez que la insignia haya sido otorgada automáticamente a cuando menos una persona, la edición de las reglas será prohibida. Así es que asegúrese de que las reglas estén correctamente configuradas antes de revisarlas.';
