<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'customcert', language 'ja', version '4.4'.
 *
 * @package     customcert
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activity'] = '活動';
$string['addcertpage'] = 'ページを追加する';
$string['addelement'] = 'エレメントを追加する';
$string['aligncenter'] = '中央揃え';
$string['alignleft'] = '左寄せ';
$string['alignment'] = '配置';
$string['alignment_help'] = '本プロパティは要素の水平方向の配置を設定します。これをサポートしていない要素があります。また他の要素と動作が異なる場合もあります。';
$string['alignright'] = '右寄せ';
$string['awardedto'] = '授与対象';
$string['cannotverifyallcertificates'] = 'あなたにはサイトのすべての証明書を確認するパーミッションがありません。';
$string['certificate'] = '証明書';
$string['certificateexecutionperiod'] = '証明書実行期間';
$string['certificateexecutionperiod_desc'] = '0でない場合、コースが非アクティブであるか、最終発行が設定された時間より古い証明書はタスクで処理されません。これにより、スケジュールされたタスクのパフォーマンスが向上する場合があります';
$string['certificatesperrun'] = '実行ごとの証明書数';
$string['certificatesperrun_desc'] = 'スケジュールされたタスク実行ごとに処理する証明書の数を入力してください。0の場合はすべての証明書が処理されます';
$string['code'] = 'コード';
$string['copy'] = 'コピー';
$string['coursetimereq'] = 'コース要求時間 (分)';
$string['coursetimereq_help'] = '学生が証明書を受理できるまでにコース内にログインしている必要のある合計時間 (分) を入力してください。';
$string['createtemplate'] = 'テンプレートを作成する';
$string['customcert:addinstance'] = '新しいカスタム証明書インスタンスを追加する';
$string['customcert:manage'] = 'カスタム証明書を管理する';
$string['customcert:manageemailothers'] = '他の人にメールする設定を管理する';
$string['customcert:manageemailstudents'] = '学生にメールする設定を管理する';
$string['customcert:manageemailteachers'] = '教師にメールする設定を管理する';
$string['customcert:managelanguages'] = '編集フォームでの言語管理';
$string['customcert:manageprotection'] = '保護設定を管理する';
$string['customcert:managerequiredtime'] = '要求時間設定を管理する';
$string['customcert:manageverifyany'] = '確認設定を管理する';
$string['customcert:receiveissue'] = '証明書を受理する';
$string['customcert:verifyallcertificates'] = 'サイトのすべての証明書を確認する';
$string['customcert:verifycertificate'] = '証明書を確認する';
$string['customcert:view'] = 'カスタム証明書を表示する';
$string['customcert:viewallcertificates'] = 'すべての証明書を表示する';
$string['customcert:viewreport'] = 'コースレポートを表示する';
$string['customcertsettings'] = 'カスタム証明書設定';
$string['deletecertpage'] = 'ページを削除する';
$string['deleteconfirm'] = '確認を削除する';
$string['deleteelement'] = 'エレメントを削除する';
$string['deleteelementconfirm'] = '本当にこのエレメントを削除してもよろしいですか?';
$string['deleteissueconfirm'] = '本当にこの証明書発行を削除してもよろしいですか?';
$string['deleteissuedcertificates'] = '発行済み証明書を削除する';
$string['deletepageconfirm'] = '本当にこの証明書ページを削除してもよろしいですか?';
$string['deletetemplateconfirm'] = '本当にこの証明書テンプレートを削除してもよろしいですか?';
$string['deliveryoptiondownload'] = 'ブラウザに送信してファイルを強制的にダウンロードする';
$string['deliveryoptioninline'] = 'ブラウザにインラインでファイルを送信する';
$string['deliveryoptions'] = '配送オプション';
$string['description'] = '説明';
$string['downloadallissuedcertificates'] = '発行されたすべての証明書をダウンロード';
$string['downloadallsitecertificates'] = 'サイトのすべての証明書をダウンロード';
$string['downloadallsitecertificatesdesc'] = 'これにより、サイト上のすべての証明書がzipファイルとしてダウンロードされます';
$string['duplicate'] = '複製';
$string['duplicateconfirm'] = '複製確認';
$string['duplicatetemplateconfirm'] = '本当にこの証明書テンプレートを複製してもよろしいですか?';
$string['editcustomcert'] = '証明書を編集する';
$string['editelement'] = 'エレメントを編集する';
$string['edittemplate'] = 'テンプレートを編集する';
$string['elementheight'] = '高さ';
$string['elementheight_help'] = 'エレメントの高さを指定してください。「0」が許可されている場合、自動的に計算されます';
$string['elementname'] = 'エレメント名';
$string['elementname_help'] = 'これは証明書の編集時にこのエレメントを識別するため使用される名称です。メモ: これはPDFに表示されません。';
$string['elementplugins'] = 'エレメントプラグイン';
$string['elements'] = 'エレメント';
$string['elements_help'] = 'これは証明書に表示されるエレメントの一覧です。

注意: エレメントはこの順序で表示されます。順番はそれぞれのエレメントの隣にある矢印を使って変更できます。';
$string['elementwidth'] = '幅';
$string['elementwidth_help'] = 'エレメントの幅を指定してください。「0」が許可されている場合、自動的に計算されます';
$string['emailnonstudentbody'] = '添付はコース「 {$a->coursefullname} 」における「 {$a->userfullname} 」の証明書「 {$a->certificatename} 」です。';
$string['emailnonstudentbodyplaintext'] = '添付はコース「 {$a->coursefullname} 」における「 {$a->userfullname} 」の証明書「 {$a->certificatename} 」です。';
$string['emailnonstudentcertificatelinktext'] = '証明書レポートを表示する';
$string['emailnonstudentgreeting'] = 'こんにちは';
$string['emailnonstudentsubject'] = '{$a->coursefullname}: {$a->certificatename}';
$string['emailothers'] = '他の人にメールする';
$string['emailothers_help'] = 'この設定を有効にした場合、ここで入力されたメールアドレス (カンマ区切り) 宛に証明書の利用可能時に証明書のコピーをメール送信します。<strong>警告:</strong> あなたが証明書作成完了前にこのフィールドを設定した場合、宛先に不完全な証明書がメール送信されてしまいます。';
$string['emailstudentbody'] = '添付はコース「 {$a->coursefullname} 」におけるあなたの証明書「 {$a->certificatename} 」です。';
$string['emailstudentbodyplaintext'] = '添付はコース「 {$a->coursefullname} 」におけるあなたの証明書「 {$a->certificatename} 」です。';
$string['emailstudentcertificatelinktext'] = '証明書を表示する';
$string['emailstudentgreeting'] = '{$a} さん';
$string['emailstudents'] = '学生にメールする';
$string['emailstudents_help'] = 'この設定を有効にした場合、証明書の利用可能時に証明書のコピーを学生にメール送信します。<strong>警告:</strong> あなたが証明書作成完了前にこの設定を有効にした場合、学生に不完全な証明書がメール送信されてしまいます。';
$string['emailstudentsubject'] = '{$a->coursefullname}: {$a->certificatename}';
$string['emailteachers'] = '教師にメールする';
$string['emailteachers_help'] = 'この設定を有効にした場合、証明書の利用可能時に証明書のコピーを教師にメール送信します。<strong>警告:</strong> あなたが証明書作成完了前にこの設定を有効にした場合、教師に不完全な証明書がメール送信されてしまいます。';
$string['eventelementcreated'] = 'カスタム証明書エレメントが作成されました';
$string['eventelementdeleted'] = 'カスタム証明書エレメントが削除されました';
$string['eventelementupdated'] = 'カスタム証明書エレメントが更新されました';
$string['eventpagecreated'] = 'カスタム証明書ページが作成されました';
$string['eventpagedeleted'] = 'カスタム証明書ページが削除されました';
$string['eventpageupdated'] = 'カスタム証明書ページが更新されました';
$string['eventtemplatecreated'] = 'カスタム証明書テンプレートが作成されました';
$string['eventtemplatedeleted'] = 'カスタム証明書テンプレートが削除されました';
$string['eventtemplateupdated'] = 'カスタム証明書テンプレートが更新されました';
$string['exampledatawarning'] = 'これらの値のいくつかはエレメントのポジションが可能かどうか確認するための例にできます。';
$string['font'] = 'フォント';
$string['font_help'] = 'このエレメントの作成時に使用されるフォントです。';
$string['fontcolour'] = '色';
$string['fontcolour_help'] = 'フォントの色です。';
$string['fontsize'] = 'サイズ';
$string['fontsize_help'] = 'フォントのサイズ (ポイント) です。';
$string['getcustomcert'] = '証明書を表示する';
$string['gradeoutcome'] = 'アウトカム';
$string['height'] = '高さ';
$string['height_help'] = 'これは証明書PDFの高さ (mm) です。ご参考までにA4サイズは高さ297mm、レターサイズは高さ279mmです。';
$string['includeinnotvisiblecourses'] = '非公開コースの証明書を含める';
$string['includeinnotvisiblecourses_desc'] = '非公開コースの証明書はデフォルトでは処理されません。それらを含めたい場合は、この設定を有効にしてください';
$string['invalidcode'] = '無効なコードが提供されました。';
$string['invalidcolour'] = '無効な色が選択されました。有効なHTMLカラー名、6桁または3桁の16進数カラーコードを入力してください。';
$string['invalidelementwidthorheightnotnumber'] = '有効な数値を入力してください';
$string['invalidelementwidthorheightzeroallowed'] = '0以上の数値を入力してください';
$string['invalidelementwidthorheightzeronotallowed'] = '0より大きい数値を入力してください';
$string['invalidheight'] = '高さはゼロを除く有効数字にしてください。';
$string['invalidmargin'] = '余白はゼロを除く有効数字にしてください。';
$string['invalidposition'] = 'ポジション {$a} には正数を選択してください。';
$string['invalidwidth'] = '幅はゼロを除く有効数字にしてください。';
$string['landscape'] = 'ランドスケープ';
$string['languageoptions'] = '証明書の言語を強制する';
$string['leftmargin'] = '左余白';
$string['leftmargin_help'] = 'これは証明書PDFの左余白 (mm) です。';
$string['listofissues'] = '受理者: {$a}';
$string['load'] = '読み込む';
$string['loadtemplate'] = 'テンプレートを読み込む';
$string['loadtemplatemsg'] = '本当にこのテンプレートを読み込んでもよろしいですか? これによりこの証明書の既存のページおよびエレメントすべてが削除されます。';
$string['managetemplates'] = 'テンプレートを管理する';
$string['managetemplatesdesc'] = 'このリンクによりあなたがコースのカスタム証明書活動で使用されるテンプレートを管理できる新しい画面に移動します。';
$string['modify'] = '修正';
$string['modulename'] = 'カスタム証明書';
$string['modulename_help'] = 'このモジュールではPDF証明書を動的に生成できます。';
$string['modulename_link'] = 'Custom_certificate_module';
$string['modulenameplural'] = 'カスタム証明書';
$string['mycertificates'] = '私の証明書';
$string['mycertificatesdescription'] = 'これらはメールまたは手動ダウンロードにより、あなたに発行された証明書です。';
$string['name'] = '名称';
$string['nametoolong'] = 'あなたは名称に許可される最大長を超過しました。';
$string['nocustomcerts'] = 'このコースに証明書はありません。';
$string['noimage'] = 'イメージなし';
$string['norecipients'] = '受理者なし';
$string['notemplates'] = 'テンプレートなし';
$string['notissued'] = '授与なし';
$string['notverified'] = '未検証';
$string['numbersuffix_nd_as_in_second'] = 'nd';
$string['numbersuffix_rd_as_in_third'] = 'rd';
$string['numbersuffix_st_as_in_first'] = 'st';
$string['options'] = 'オプション';
$string['page'] = 'ページ {$a}';
$string['pluginadministration'] = 'カスタム証明書管理';
$string['pluginname'] = 'カスタム証明書';
$string['portrait'] = 'ポートレイト';
$string['posx'] = 'ポジション X';
$string['posx_help'] = 'これはあなたがエレメントの基準点を置きたい最上部左端からのX方向のポジション (mm) です。';
$string['posy'] = 'ポジション Y';
$string['posy_help'] = 'これはあなたがエレメントの基準点を置きたい最上部左端からのY方向のポジション (mm) です。';
$string['preventcopy'] = 'コピーを防ぐ';
$string['preventcopy_desc'] = 'コピー操作の保護を有効にします。';
$string['preventmodify'] = '修正を防ぐ';
$string['preventmodify_desc'] = '修正操作の保護を有効にします。';
$string['preventprint'] = '印刷を防ぐ';
$string['preventprint_desc'] = '印刷操作の保護を有効にします。';
$string['print'] = '印刷';
$string['privacy:metadata:customcert_issues'] = '発行済み証明書の一覧です。';
$string['privacy:metadata:customcert_issues:code'] = '証明書に属するコードです。';
$string['privacy:metadata:customcert_issues:customcertid'] = '証明書のIDです。';
$string['privacy:metadata:customcert_issues:emailed'] = '証明書がメール送信されたかどうか示します。';
$string['privacy:metadata:customcert_issues:timecreated'] = '証明書の発行日時です。';
$string['privacy:metadata:customcert_issues:userid'] = '証明書を発行したユーザのIDです。';
$string['rearrangeelements'] = 'エレメントを再配置する';
$string['rearrangeelementsheading'] = 'エレメントの証明書でのポジションを変更したい場合、ドラッグ＆ドロップしてください。';
$string['receiveddate'] = '授与日';
$string['refpoint'] = '設置場所の基準点';
$string['refpoint_help'] = 'エレメントの設置場所の基準点はXおよびYの座標により決定されます。これはエレメントの中央または端に表示される「+」により示されます。';
$string['replacetemplate'] = '置換';
$string['requiredtimenotmet'] = 'あなたがこの証明書にアクセスできるようになるにはこのコースに少なくとも {$a->requiredtime} 分滞在する必要があります。';
$string['rightmargin'] = '右余白';
$string['rightmargin_help'] = 'これは証明書PDFの右余白 (mm) です。';
$string['save'] = '保存';
$string['saveandclose'] = '保存して閉じる';
$string['saveandcontinue'] = '保存して続ける';
$string['savechanges'] = '変更を保存する';
$string['savechangespreview'] = '保存してプレビューする';
$string['savetemplate'] = 'テンプレートを保存する';
$string['scheduledtaskconfigdesc'] = '証明書を処理するスケジュールタスクの設定をする';
$string['scheduledtaskconfigheading'] = 'スケジュールタスクの設定';
$string['search:activity'] = 'カスタム証明書 - 活動情報';
$string['setprotection'] = '保護設定';
$string['setprotection_help'] = 'あなたがこの証明書でユーザによる実行を防ぎたい操作を選択してください。';
$string['showposxy'] = 'ポジション X および Y を表示する';
$string['showposxy_desc'] = 'これはエレメントの編集時にユーザが設置場所を正確に指定できるようXおよびYポジションを表示します。

あなたが設置場所を指定する目的で主にドラッグ＆ドロップを使用する場合、これは必要ではありません。';
$string['subplugintype_customcertelement'] = 'エレメント';
$string['subplugintype_customcertelement_plural'] = 'エレメント';
$string['taskemailcertificate'] = '証明書のメール送信を処理します。';
$string['taskissuecertificate'] = '証明書発行タスク';
$string['templatename'] = 'テンプレート名';
$string['templatenameexists'] = 'このテンプレート名は現在使用されています。別のテンプレート名を選択してください。';
$string['topcenter'] = '中央';
$string['topleft'] = '最上部左';
$string['topright'] = '最上部右';
$string['type'] = 'タイプ';
$string['uploadimage'] = 'イメージをアップロードする';
$string['uploadimagedesc'] = 'このリンクによりあなたがイメージをアップロードできる新しい画面に移動します。この方法でアップロードされたイメージは証明書を作成できるすべてのユーザがあなたのサイト全体で利用できます。';
$string['useadhoc'] = 'メール証明書アドホックタスクを使用';
$string['useadhoc_desc'] = '有効にすると、証明書に関連するメールは、各発行のために作成されたアドホックタスクを通じて即座に処理されます。無効にすると、メールは通常のスケジュールタスクによって管理されます。

このオプションを有効にすると、メール処理をアドホックタスクに分担させることで、スケジュールタスクのパフォーマンスが向上する可能性があります。';
$string['userlanguage'] = 'ユーザの設定を使用';
$string['userlanguage_help'] = '証明書の言語をユーザの言語設定に上書きして強制することができます';
$string['verified'] = '確認済み';
$string['verify'] = '確認する';
$string['verifyallcertificates'] = 'すべての証明書の確認を許可する';
$string['verifyallcertificates_desc'] = 'この設定により誰でも (未ログインのユーザを含む) それぞれの証明書の確認リンクにアクセスせずにリンク「 {$a} 」をクリックしてサイトの証明書すべてを確認できます。

注意 - これはカスタム証明書設定で「誰でも証明書を確認できる」が有効にされた場合のみ適用されます。';
$string['verifycertificate'] = '証明書を確認する';
$string['verifycertificateanyone'] = '誰でも証明書を確認できる';
$string['verifycertificateanyone_help'] = 'この設定により誰でも (未ログインのユーザを含む) 証明書確認リンクで証明書を確認できます。';
$string['verifycertificatedesc'] = 'このリンクによりあなたがサイトの証明書を確認できる新しい画面に移動します。';
$string['width'] = '幅';
$string['width_help'] = 'これは証明書PDFの幅  (mm) です。ご参考までにA4サイズは幅210mm、レターサイズは幅216mmです。';
