<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'local_moodlemobileapp', language 'ja', version '4.4'.
 *
 * @package     local_moodlemobileapp
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['addon.block_myoverview.browseallcourses'] = 'すべてのコースを閲覧する';
$string['addon.block_myoverview.nocoursesenrolled'] = 'あなたはまだどのコースにも登録していません。';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = '以下の利用可能なコースを閲覧して学習を始めてください。';
$string['addon.block_myoverview.noresult'] = 'あなたの検索条件に一致するコースはありません。';
$string['addon.block_myoverview.noresultdescription'] = 'あなたのフィルタを調整するか、以下のすべてのコースを閲覧してください。';
$string['addon.blog.errorloadentries'] = 'ブログエントリの読み込み中にエラーが発生しました。';
$string['addon.blog.showonlyyourentries'] = 'あなたのエントリのみ表示する';
$string['addon.calendar.calendarevent'] = 'カレンダーイベント';
$string['addon.calendar.calendarevents'] = 'カレンダーイベント';
$string['addon.calendar.calendarreminders'] = 'カレンダーリマインダ';
$string['addon.calendar.currentmonth'] = '今月';
$string['addon.calendar.defaultnotificationtime'] = 'デフォルト通知時間';
$string['addon.calendar.errorloadevent'] = 'イベントの読み込み時にエラーが発生しました。';
$string['addon.calendar.errorloadevents'] = 'イベントの読み込み時にエラーが発生しました。';
$string['addon.calendar.monthlyview'] = '月別表示';
$string['addon.calendar.noevents'] = 'イベントはありません。';
$string['addon.calendar.reminders'] = 'リマインダ';
$string['addon.calendar.setnewreminder'] = '新しいリマインダを設定する';
$string['addon.competency.errornocompetenciesfound'] = 'コンピテンシーが見つかりませんでした。';
$string['addon.competency.nocompetencies'] = 'コンピテンシーなし';
$string['addon.coursecompletion.complete'] = '完了';
$string['addon.coursecompletion.couldnotloadreport'] = 'コース完了の読み込みができませんでした。後でもう一度お試しください。';
$string['addon.enrol_self.confirmselfenrol'] = '本当にこのコースにあなたを登録しますか?';
$string['addon.enrol_self.errorselfenrol'] = '自己登録中にエラーが発生しました。';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'デバイス設定';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'あなたのユーザはこのサイトの通知をモバイルデバイスで受信していません。通知設定ページでモバイル通知を有効にしてください。';
$string['addon.messages.contactlistempty'] = '連絡先リストは空です。';
$string['addon.messages.contactname'] = '連絡先名';
$string['addon.messages.deletemessage'] = 'メッセージを削除する';
$string['addon.messages.deletemessageconfirmation'] = '本当にこのメッセージを削除してもよろしいですか? このメッセージはあなたのメッセージ履歴からのみ削除されます。メッセージを送信または受信したユーザは引き続き閲覧できます。';
$string['addon.messages.errordeletemessage'] = 'メッセージ削除中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingcontacts'] = 'サーバからの連絡先取得中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'サーバからのディスカッション取得中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingmessages'] = 'サーバからのメッセージ取得中にエラーが発生しました。';
$string['addon.messages.errorwhileretrievingusers'] = 'サーバからのユーザ検索中にエラーが発生しました。';
$string['addon.messages.messagenotsent'] = 'メッセージは送信されませんでした。後でもう一度お試しください。';
$string['addon.messages.newmessages'] = '新しいメッセージ';
$string['addon.messages.nousersfound'] = 'ユーザが見つかりませんでした。';
$string['addon.messages.showdeletemessages'] = 'メッセージ削除を表示する';
$string['addon.messages.type_blocked'] = 'ブロック済み';
$string['addon.messages.type_offline'] = 'オフライン';
$string['addon.messages.type_online'] = 'オンライン';
$string['addon.messages.type_search'] = '結果を検索する';
$string['addon.messages.type_strangers'] = 'その他';
$string['addon.messages.useentertosenddescdesktop'] = '無効にした場合、あなたは「Ctrl+Enter」でメッセージを送信できます。';
$string['addon.messages.useentertosenddescmac'] = '無効にした場合、あなたは「Cmd+Enter」でメッセージを送信できます。';
$string['addon.messages.warningconversationmessagenotsent'] = '会話 {{conversation}} にメッセージを送信できませんでした。{{error}}';
$string['addon.messages.warningmessagenotsent'] = 'ユーザ {{user}} にメッセージを送信ができませんでした。 {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = '提出時宣誓文を承認してください。';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = '課題詳細および提出フォームは<strong>{{$a}}</strong>から利用できます。';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'この課題は<strong>{{$a}}</strong>から提出を受け付けます。';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'サイトから提出時宣誓文を取得できなかったため、あなたはアプリで提出を追加または編集できません。';
$string['addon.mod_assign.cannotgradefromapp'] = '一部の評定方法はまだアプリでサポートされていないため変更できません。';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'サイトから提出時宣誓文が取得できなかったため、あなたはアプリから提出できません。';
$string['addon.mod_assign.duedateno'] = '期限なし';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = '提出の編集がサポートされていないプラグインがあるため、あなたはアプリから提出を追加または編集できません。';
$string['addon.mod_assign.errorshowinginformation'] = '提出情報を表示できません。';
$string['addon.mod_assign.feedbacknotsupported'] = 'このフィードバックはアプリでは未サポートのため、すべての情報が含まれていない可能性があります';
$string['addon.mod_assign.gradenotsynced'] = '評定が同期できませんでした。';
$string['addon.mod_assign.notallparticipantsareshown'] = '提出していない参加者は表示されていません。';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = '{{count}} 件の下書きがあります。';
$string['addon.mod_assign.numberofparticipantscountdescription'] = '{{count}} 名の参加者がいます。';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = '評定が必要な {{count}} 件の提出があります。';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = '{{count}} 件の提出済み課題があります。';
$string['addon.mod_assign.numberofteamscountdescription'] = '{{count}} 組のチームがあります。';
$string['addon.mod_assign.submissionnotsupported'] = 'この提出はアプリでは未サポートのため、すべての情報が含まれていない可能性があります';
$string['addon.mod_assign.syncblockedusercomponent'] = 'ユーザ評定';
$string['addon.mod_assign.warningsubmissiongrademodified'] = '提出の評定がサイト上で変更されました。';
$string['addon.mod_assign.warningsubmissionmodified'] = 'ユーザの提出がサイト上で変更されました。';
$string['addon.mod_chat.confirmloss'] = '本当によろしいですか? チャット履歴を失うことになります。';
$string['addon.mod_chat.errorwhileconnecting'] = 'チャットへの接続中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'チャットのデータ取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'チャットのユーザ取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'サーバからのメッセージ取得中にエラーが発生しました。';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'メッセージ送信中にエラーが発生しました。';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'あなたがメッセージを送信するにはオンラインにする必要があります。';
$string['addon.mod_chat.nosessionsfound'] = 'セッションは見つかりませんでした。';
$string['addon.mod_chat.showincompletesessions'] = '未完了のセッションを表示する';
$string['addon.mod_choice.errorgetchoice'] = '選択データの取得中にエラーが発生しました。';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% のユーザが選択肢: {{text}} を選択しました。';
$string['addon.mod_choice.resultsnotsynced'] = 'あなたの最後の回答は結果に含まれる前に同期される必要があります。';
$string['addon.mod_data.edittagsnotsupported'] = '申し訳ございません、アプリではタグの編集はサポートされていません。';
$string['addon.mod_data.errorapproving'] = 'エントリの承認または不承認中にエラーが発生しました。';
$string['addon.mod_data.errordeleting'] = 'エントリの削除中にエラーが発生しました。';
$string['addon.mod_data.gettinglocation'] = 'ロケーションを取得する';
$string['addon.mod_data.locationnotenabled'] = 'ロケーションは有効にされていません。';
$string['addon.mod_data.locationpermissiondenied'] = 'あなたのロケーションへのアクセスが拒否されました。';
$string['addon.mod_data.mylocation'] = 'マイロケーション';
$string['addon.mod_data.searchbytagsnotsupported'] = '申し訳ございません、アプリではタグの検索はサポートされていません。';
$string['addon.mod_feedback.captchaofflinewarning'] = 'CAPTCHAを使用したフィードバックはオフラインの場合、または設定されていない場合、またはサーバがダウンしている場合には完了できません。';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = '{{count}} 件の送信済み回答があります。';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'このフィードバックは後で提出するために保存されました。';
$string['addon.mod_feedback.questionscountdescription'] = '{{count}} 件の質問があります。';
$string['addon.mod_folder.emptyfilelist'] = '表示するファイルがありません。';
$string['addon.mod_forum.errorgetforum'] = 'フォーラムデータの取得中にエラーが発生しました。';
$string['addon.mod_forum.errorgetgroups'] = 'グループ設定の取得中にエラーが発生しました。';
$string['addon.mod_forum.errorloadingsortingorder'] = 'この並び順ではフォーラムは使用できません。';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'フォーラムを見るには、並び順を変更するか、インターネットに接続してください。';
$string['addon.mod_forum.errorposttoallgroups'] = 'すべてのグループで新しいディスカッションを作成できませんでした。';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'このフォーラムにはまだディスカッションがありません。';
$string['addon.mod_forum.group'] = 'グループ';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} ディスカッション';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} 返信';
$string['addon.mod_forum.postingroup'] = '{{groupname}}に投稿しています。';
$string['addon.mod_forum.refreshposts'] = '投稿を更新する';
$string['addon.mod_glossary.browsemode'] = 'エントリを閲覧する';
$string['addon.mod_glossary.byalphabet'] = 'アルファベット順';
$string['addon.mod_glossary.byauthor'] = '作成者別グループ';
$string['addon.mod_glossary.bycategory'] = 'カテゴリ別グループ';
$string['addon.mod_glossary.bynewestfirst'] = '新しいものを最初に';
$string['addon.mod_glossary.byrecentlyupdated'] = '最近の更新';
$string['addon.mod_glossary.bysearch'] = '検索';
$string['addon.mod_glossary.cannoteditentry'] = 'エントリを編集できませんでした。';
$string['addon.mod_glossary.entriestobesynced'] = '同期するエントリ';
$string['addon.mod_glossary.entrypendingapproval'] = 'このエントリは承認待ちです。';
$string['addon.mod_glossary.errordeleting'] = 'エントリの削除中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingentries'] = 'エントリの読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingentry'] = 'エントリの読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.errorloadingglossary'] = '用語集の読み込み中にエラーが発生しました。';
$string['addon.mod_glossary.noentriesfound'] = 'エントリが見つかりませんでした。';
$string['addon.mod_glossary.searchquery'] = '検索クエリ';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'H5Pファイルをダウンロードする';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'H5P活動データの取得中にエラーが発生しました。';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'H5Pパッケージはダウンロードされていません。あなたがH5Pパッケージを使用するにはダウンロードする必要があります。';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'H5Pパッケージは前回ダウンロード後に修正されています。使用するにはあなたは再度ダウンロードする必要があります。';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} 受験';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'あなたがH5Pパッケージを表示するにはオンラインにする必要があります。';
$string['addon.mod_h5pactivity.viewattempt'] = '受験を表示する {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = '説明を表示する';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'このレッスンにはランダムなコンテンツページへのジャンプが含まれています。ウェブブラウザで起動するまでアプリでは受験できません。';
$string['addon.mod_lesson.errorreviewretakenotlast'] = '別の解凍が完了しているため、この解答は評価できません。';
$string['addon.mod_lesson.finishretakeoffline'] = 'この解答はオフライン状態で完了しました。';
$string['addon.mod_lesson.retakefinishedinsync'] = 'オフライン解答が同期されました。レビューしますか?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = '受験はサイト内で完了しました。';
$string['addon.mod_lti.errorgetlti'] = 'モジュールデータ取得中にエラーが発生しました。';
$string['addon.mod_lti.errorinvalidlaunchurl'] = '起動URLが有効ではありません。';
$string['addon.mod_lti.launchactivity'] = '活動を起動する';
$string['addon.mod_page.errorwhileloadingthepage'] = 'ページコンテンツの読み込み中にエラーが発生しました。';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'この小テストはアプリでも受験できますが、あなたは次の理由でブラウザでの受験の送信が必要です:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'この小テストの受験は以下の理由で送信できません:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'この解答は「 {{$a}} 」の理由で同期できません。あなたが別のデバイスでこの受験を続けた場合、データが失われる可能性があります。';
$string['addon.mod_quiz.confirmleavequizonerror'] = '解凍保存中にエラーが発生しました。本当に小テストを終了してもよろしいですか?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = '問題動作がアプリでサポートされていないため、この小テストはアプリでは受験できません:';
$string['addon.mod_quiz.errordownloading'] = '必須データのダウンロード中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetattempt'] = '解答データの取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetquestions'] = '問題の取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorgetquiz'] = '小テストデータの取得中にエラーが発生しました。';
$string['addon.mod_quiz.errorparsequestions'] = '問題の読み込み中にエラーが発生しました。ウェブブラウザでこの小テストに解答してください。';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'この小テストにはアプリでサポートされない問題を含むため解答ができません。';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'この小テストはアプリでサポートされていないアクセスルールがあるため解答できません。';
$string['addon.mod_quiz.errorsaveattempt'] = '解答データの保存中にエラーが発生しました。';
$string['addon.mod_quiz.finishedofflinenotice'] = 'あなたの受験は送信および保存されました。あなたが再度オンラインになった時点でサイトに送信されます。';
$string['addon.mod_quiz.finishnotsynced'] = '完了しましたが同期されていません。';
$string['addon.mod_quiz.opentoc'] = 'ナビゲーションポップオーバを開く';
$string['addon.mod_quiz.warningattemptfinished'] = 'サイト上で終了したか見つからなかったため、オフライン受験は破棄されました。';
$string['addon.mod_quiz.warningdatadiscarded'] = 'オンライン上で問題が修正されたため、一部のオフラインでの解答は破棄されました。';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'オフラインの解答が破棄されたため、未完了となりました。あなたの解答を見直して再度受験を送信してください。';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'この小テストはアプリでサポートされていない問題を含みます:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'コンテンツの読み込み中にエラーが発生しました。';
$string['addon.mod_resource.openthefile'] = '開く';
$string['addon.mod_resource.resourcestatusoutdated'] = 'このファイルはあなたが前回開いた時点から変更されています。';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'このファイルには新しいバージョンがあります。確認するにはあなたのデバイスをインターネットに接続してください。';
$string['addon.mod_scorm.cannotcalculategrade'] = '評定を計算できませんでした。';
$string['addon.mod_scorm.dataattemptshown'] = 'このデータは受験番号 {{number}} に属します。';
$string['addon.mod_scorm.errorcreateofflineattempt'] = '新たなオフライン回答の作成中にエラーが発生しました。再度お試しください。';
$string['addon.mod_scorm.errordownloadscorm'] = '次のSCORMダウンロード中にエラーが発生しました: {{name}}';
$string['addon.mod_scorm.errorgetscorm'] = 'SCORMデータの取得中にエラーが発生しました。';
$string['addon.mod_scorm.errorinvalidversion'] = '申し訳ございません。アプリケーションはSCORM 1.2のみサポートします。';
$string['addon.mod_scorm.errornotdownloadable'] = 'あなたのスクールまたは学習プロバイダはSCORMパッケージのダウンロードを無効にしています。';
$string['addon.mod_scorm.errornovalidsco'] = 'このSCORMパッケージは読み込み可能なSCOがありません。';
$string['addon.mod_scorm.errorpackagefile'] = '申し訳ございません。アプリケーションはZIPパッケージのみサポートします。';
$string['addon.mod_scorm.errorsyncscorm'] = '同期中にエラーが発生しました。再度お試しください。';
$string['addon.mod_scorm.offlineattemptnote'] = 'この受験には同期されていないデータがあります。';
$string['addon.mod_scorm.offlineattemptovermax'] = 'あなたは受験可能回数を超えたため、この解答を送信できません。';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'このSCORMパッケージはダウンロードされません。あなたが開いた場合、自動的にダウンロードされます。';
$string['addon.mod_scorm.scormstatusoutdated'] = 'このSCORMパッケージは前回のダウンロードから変更されています。あなたが開いた場合、自動的にダウンロードされます。';
$string['addon.mod_scorm.warningofflinedatadeleted'] = '解答番号 {{number}} を新しい解答として作成できなかったため、オフラインデータの一部が消去されました。';
$string['addon.mod_scorm.warningsynconlineincomplete'] = '最終のオンライン解答が完了していないため、一部の解答を同期できませんでした。先にオンライン解答を完了してください。';
$string['addon.mod_survey.cannotsubmitsurvey'] = '申し訳ございません。あなたの調査提出に問題が発生しました。再度お試しください。';
$string['addon.mod_survey.errorgetsurvey'] = '調査データの取得中にエラーが発生しました。';
$string['addon.mod_survey.results'] = '結果';
$string['addon.mod_url.accessurl'] = 'URLへのアクセス';
$string['addon.mod_url.pointingtourl'] = 'このリソースのURL';
$string['addon.mod_wiki.errorloadingpage'] = 'ページ読み込み中にエラーが発生しました。';
$string['addon.mod_wiki.errornowikiavailable'] = 'このWikiにはまだコンテンツがありません。';
$string['addon.mod_wiki.gowikihome'] = 'Wikiの最初のページに移動する';
$string['addon.mod_wiki.subwiki'] = 'サブWiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'タイトルは空白にできません。';
$string['addon.mod_wiki.viewpage'] = 'ページを表示する';
$string['addon.mod_wiki.wikipage'] = 'Wikiページ';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = '評価戦略 {{$a}} はサポートされていません。';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'あなたはタイトルを入力する必要があります。';
$string['addon.mod_workshop.warningassessmentmodified'] = 'このサイトの提出が修正されました。';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'このサイトの評価が修正されました。';
$string['addon.notes.warningnotenotsent'] = 'コース {{course}} にノートを追加できません。 {{error}}';
$string['addon.notifications.allownotifications'] = '通知を許可する';
$string['addon.notifications.errorgetnotifications'] = '通知の取得中にエラーが発生しました。';
$string['addon.notifications.notifications'] = '通知';
$string['addon.notifications.playsound'] = 'サウンドを再生する';
$string['addon.notifications.therearentnotificationsyet'] = '通知はありません。';
$string['addon.notifications.typeofnotification'] = '通知の種類';
$string['addon.privatefiles.couldnotloadfiles'] = 'ファイル一覧を読み込みませんでした。';
$string['addon.privatefiles.emptyfilelist'] = '表示するファイルはありません。';
$string['addon.privatefiles.erroruploadnotworking'] = '残念ですが、現在あなたのサイトにはファイルをアップロードできません。';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'すべてのサイトダウンロードデータを削除してもよろしいですか?';
$string['addon.storagemanager.confirmdeletecourses'] = 'すべてのコースからダウンロードデータを削除してもよろしいですか?';
$string['addon.storagemanager.confirmdeletedatafrom'] = '「 {{name}} 」からすべてのダウンロードデータを削除してもよろしいですか?';
$string['addon.storagemanager.coursedownloads'] = 'コースダウンロード';
$string['addon.storagemanager.courseinfo'] = 'オフラインで作業するにはコースコンテンツをダウンロードしてください。デバイスがオンラインに復帰した場合、あなたの活動は自動的に同期されます。';
$string['addon.storagemanager.deleteallsitedata'] = 'すべてのサイトダウンロードデータを削除する';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'あなたがオフラインで作業するため「 {{name}} 」からダウンロードしたダウンロード済みコースおよびデータを含むすべてのダウンロードデータが削除されます。';
$string['addon.storagemanager.deletecourses'] = 'すべてのコースからダウンロードデータを削除する';
$string['addon.storagemanager.deletedata'] = 'ダウンロード済みデータを削除する';
$string['addon.storagemanager.deletedatafrom'] = '「 {{name}} 」からすべてのダウンロードデータを削除する';
$string['addon.storagemanager.downloaddatafrom'] = 'ダウンロード {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'ダウンロード済みコース';
$string['addon.storagemanager.downloads'] = 'ダウンロード';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'ダウンロード済みデータの削除中にエラーが発生しました。';
$string['addon.storagemanager.managedownloads'] = 'ダウンロードを管理する';
$string['addon.storagemanager.totaldownloads'] = '合計ダウンロード';
$string['addon.storagemanager.totalspaceusage'] = '合計利用スペース';
$string['addon.tinymce.enabletinymceeditor'] = 'TinyMCEテキストエディタを使用';
$string['addon.tinymce.enabletinymceeditordescription'] = '追加の書式設定機能を備えた高機能テキストエディタ';
$string['addon.tinymce.license'] = 'Moodle Pty Ltd は、Apacheライセンス2.0と互換性のある TinyMCE の商用ライセンスを付与されています。';
$string['appstoredescription'] = '注意：本オフィシャルMoodleモバイルアプリは、その利用許可を設定されたMoodleサイトで「のみ」利用可能です。接続に問題がある場合には、あなたのMoodle管理者に問い合わせてください。

あなたのMoodleサイトがすでに正しくその設定がなされていれば、本アプリから、以下のことができます：

 - あなたのコースコンテンツのブラウズ（オフラインからも）
 - メッセージその他のイベントの即座の通知を受ける
 - あなたのコースに参加している他の人を即座に検索して連絡をとる
 - 画像、オーディオ、動画その他のファイルをあなたのモバイルデバイスからアップロード
 - あなたのコース成績の閲覧
 - その他、もっと多くのこと

最新情報は、 http://docs.moodle.org/en/Mobile_app を参照してください。

私たちは、本アプリの機能その他についての建設的なレビューを心から歓迎します。また、本アプリでできたらよいと思うことがあれば、ぜひ提案してください。

本アプリは、あなたのデバイスに以下の権限を要求します：
オーディオの録音 - オーディオを録音してMoodleへアップロードするため
SDカードの内容の読み取りと変更 - コンテンツをオフラインで閲覧する際に、コンテンツはSDカードにダウンロードされます
ネットワークアクセス - Moodleサイトへ接続できるようにするため、またあなたがサイトへ接続している、あるいはオフラインモードに切り替えていないことを確かめるため
起動時の実行 - アプリがバックグランド動作している間のローカル通知を受信するため
デバイスのスリープ禁止 - いつでもプッシュ通知を受信できるようにするため';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynoteプレゼンテーション';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbersスプレッドシート';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pagesドキュメント';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Googleドライブオーディオ';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Googleドキュメント';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google図形描画';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Googleドライブファイル';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Googleドライブフォルダ';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Googleフォーム';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Googleスライド';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Script';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Googleサイト';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Googleスプレッドシート';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Googleドライブビデオ';
$string['core.ajaxendpointnotfound'] = 'AJAXエンドポイントが見つかりませんでした。これはMoodleサイトが古すぎるか、このエンドポイントへのアクセスをブロックしている場合に発生する可能性があります。MoodleアプリはMoodleシステム {{$a}} 以降のみをサポートします。';
$string['core.browser'] = 'ブラウザ';
$string['core.calculating'] = '計算する';
$string['core.cannotconnect'] = 'サイトに接続できません。';
$string['core.cannotdownloadfiles'] = 'あなたのスクールまたは学習プロバイダがファイルのダウンロードを無効にしています。';
$string['core.cannotinstallapk'] = 'APKファイルをインストールできません。';
$string['core.cannotinstallapkinfo'] = 'セキュリティ上の理由から、あなたのデバイスのこのアプリから不明なアプリをインストールできません。それでもインストールを進めたい場合、あなたはブラウザで開く必要があります。';
$string['core.cannotlogoutpageblocks'] = '続ける前にあなたの変更を保存または破棄してください。';
$string['core.cannotopeninapp'] = 'このファイルはこのデバイスでは期待通りに動作しない可能性があります。とにかく開いてみますか?';
$string['core.cannotopeninappdownload'] = 'このファイルはこのデバイスでは期待通りに動作しない可能性があります。とにかくダウンロードしてみますか?';
$string['core.captureaudio'] = 'オーディオを録音する';
$string['core.capturedimage'] = '撮影写真';
$string['core.captureimage'] = '写真を撮る';
$string['core.capturevideo'] = 'ビデオを録画する';
$string['core.certificaterror'] = 'このサイトの証明書はあなたのデバイスでは信頼できません: {{details}}';
$string['core.clearsearch'] = '検索をクリアする';
$string['core.clearstoreddata'] = 'ストレージをクリアする {{$a}}';
$string['core.clicktoseefull'] = 'すべてのコンテンツを表示するにはクリックしてください。';
$string['core.comments.commentsnotworking'] = 'コメントは検索できません。';
$string['core.comments.warningcommentsnotsent'] = 'コメントを同期できませんでした。{{error}}';
$string['core.confirmcanceledit'] = '本当にこのページを離れてもうよろしいですか? すべての変更を失うことになります。';
$string['core.confirmleavepagedescription'] = '保存されていない変更は失われます。';
$string['core.confirmleavepagetitle'] = 'ページを離れますか?';
$string['core.confirmleaveunknownchanges'] = '本当にこのページを離れてもよろしいですか? 変更を保存していない場合、変更を失うことになります。';
$string['core.confirmloss'] = '本当によろしいですか? すべての変更が失われます。';
$string['core.confirmopeninbrowser'] = 'ブラウザで開きますか?';
$string['core.confirmremoveselectedfile'] = 'これは「 {{filename}} 」を完全に削除します。あなたは元に戻せません。';
$string['core.confirmremoveselectedfiles'] = 'これは選択したファイルを完全に削除します。あなたは元に戻せません。';
$string['core.connectandtryagain'] = 'インターネットに接続して再度お試しください。';
$string['core.connectionlost'] = 'サイトへの接続が切れました。';
$string['core.contactsupport'] = 'サポート問い合わせ先';
$string['core.contactverb'] = '連絡先';
$string['core.contenteditingsynced'] = 'あなたの編集中のコンテンツが同期されました。';
$string['core.contentlinks.chooseaccount'] = 'アカウントを選択する';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'リンクを開くアカウントを選択してください。';
$string['core.contentlinks.confirmurlothersite'] = 'このリンクは別のサイトに属しています。開きますか?';
$string['core.contentlinks.errornoactions'] = 'このリンクで実行するアクションが見つかりませんでした。';
$string['core.contentlinks.errornosites'] = 'このリンクを処理するサイトは見つかりませんでした。';
$string['core.contentlinks.errorredirectothersite'] = 'リダイレクトURLに異なるサイトを指定できません。';
$string['core.copiedtoclipboard'] = 'クリップボードにコピーされたテキスト';
$string['core.copytoclipboard'] = 'クリップボードにコピーする';
$string['core.course.activitydisabled'] = 'あなたの組織はモバイルアプリでのこの活動の使用を無効にしています。';
$string['core.course.activitynotavailableoffline'] = 'この活動はオフラインでは利用できません。';
$string['core.course.activitynotyetviewableremoteaddon'] = 'あなたの組織はまだサポートされていないプラグインをインストールしました。';
$string['core.course.activityrequiresconnection'] = 'この活動はインターネット接続がある場合のみ利用できます。あなたのデバイスがオフラインの場合はアクセスできません。';
$string['core.course.allsections'] = 'すべてのセクション';
$string['core.course.aria:sectionprogress'] = 'セクション進捗:';
$string['core.course.availablespace'] = '現在、あなたには約 {{available}} の空き容量があります。';
$string['core.course.cannotdeletewhiledownloading'] = '活動のダウンロード中はファイルを削除できません。ダウンロードが終了するまでお待ちください。';
$string['core.course.changesofflinemaybelost'] = 'オフライン中にこの活動に加えた変更は保存されない場合があります。<br><br>あなたの進捗を失わないようにデバイスをインターネットに接続してください。';
$string['core.course.confirmdownload'] = 'あなたは {{size}}.{{availableSpace}} をダウンロードしようとしています。本当に続けてもよろしいですか?';
$string['core.course.confirmdownloadunknownsize'] = 'ダウンロードサイズを計算できませんでした。{{availableSpace}} 本当に続けてもよろしいですか?';
$string['core.course.confirmdownloadzerosize'] = 'あなたはダウンロードを開始しようとしています。{{availableSpace}} 本当に続けてもよろしいですか?';
$string['core.course.confirmlimiteddownload'] = '現在あなたはWi-Fiに接続していません。';
$string['core.course.confirmpartialdownloadsize'] = 'あなたは<strong>少なくとも</strong> {{size}} のダウンロードを開始しようとしています。{{availableSpace}} 本当に続けてもよろしいですか?';
$string['core.course.couldnotloadsectioncontent'] = 'セクションコンテンツを読み込めませんでした。後でもう一度お試しください。';
$string['core.course.couldnotloadsections'] = 'セクションを読み込めませんでした。後でもう一度お試しください。';
$string['core.course.downloadcoursesprogressdescription'] = 'コースダウンロード中: ダウンロード済み {{count}} / {{total}}';
$string['core.course.downloadsectionprogressdescription'] = 'セクションダウンロード中: ダウンロード済み {{count}} / {{total}}';
$string['core.course.errordownloadingcourse'] = 'コースのダウンロード中にエラーが発生しました。';
$string['core.course.errordownloadingsection'] = 'セクションのダウンロード中にエラーが発生しました。';
$string['core.course.errorgetmodule'] = '活動データの取得中にエラーが発生しました。';
$string['core.course.insufficientavailablequota'] = 'あなたのデバイスではこのダウンロードを保存するためのスペースを確保できませんでした。アプリおよびシステムアップデートのために容量が確保されている可能性があります。最初にストレージの空き容量を確保してください。';
$string['core.course.insufficientavailablespace'] = 'あなたは {{size}} をダウンロードしようとしています。あなたのデバイスを正常に動作させるために十分なスペースがありません。最初にストレージの空き容量を確保してください。';
$string['core.course.lastaccessedactivity'] = '最後にアクセスした活動';
$string['core.course.manualcompletionnotsynced'] = '手動完了は同期されません。';
$string['core.course.modulenotfound'] = 'リソースまたは活動が見つかりませんでした。あなたがオンラインであること、そしてまだリソースまたは活動が利用可能であることを確認してください。';
$string['core.course.nextactivity'] = '次の活動';
$string['core.course.nextactivitynotfound'] = '次の活動が見つかりませんでした。活動が非表示にされているか、削除されている可能性があります。';
$string['core.course.nocontentavailable'] = '現在、利用できるコンテンツはありません。';
$string['core.course.previousactivity'] = '前の活動';
$string['core.course.previousactivitynotfound'] = '前の活動が見つかりませんでした。活動が非表示にされているか、削除されている可能性があります。';
$string['core.course.refreshcourse'] = 'コースをリフレッシュする';
$string['core.course.useactivityonbrowser'] = 'あなたのデバイスのウェブブラウザで利用可能です。';
$string['core.course.warningmanualcompletionmodified'] = 'サイトの活動の手動完了が修正されました。';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'コース「 {{name}} 」の一部のオフライン手動完了が削除されました。{{error}}';
$string['core.coursenogroups'] = 'あなたはこのコースのどのグループにも属していません。';
$string['core.courses.browserenrolinstructions'] = 'あなたのデバイスのブラウザに移動します。あなたの登録完了後、このアプリに戻ってきてください。';
$string['core.courses.cannotretrievemorecategories'] = 'レベル {{$a}} より深いカテゴリは検索できません。';
$string['core.courses.completeenrolmentbrowser'] = 'ブラウザで登録を完了する';
$string['core.courses.downloadcourses'] = 'すべてのコースをダウンロードする';
$string['core.courses.enrolme'] = '私を登録する';
$string['core.courses.errorloadcategories'] = 'カテゴリの読み込み中にエラーが発生しました。';
$string['core.courses.errorloadcourses'] = 'コースの読み込み中にエラーが発生しました。';
$string['core.courses.errorloadplugins'] = 'このコースで必要なプラグインを正しく読み込めませんでした。アプリを再読み込みして再度お試しください。';
$string['core.courses.errorsearching'] = '検索中にエラーが発生しました。';
$string['core.courses.filtermycourses'] = 'マイコースをフィルタする';
$string['core.courses.notenrollable'] = 'あなたはこのコースに自分では登録できません。';
$string['core.courses.otherenrolments'] = '他の登録';
$string['core.courses.password'] = '登録キー';
$string['core.courses.refreshcourses'] = 'コースをリフレッシュする';
$string['core.courses.searchcoursesadvice'] = 'あなたはコース検索ボタンでゲストアクセス可能なコースを探したり、ゲストアクセス可能なコースに登録できます。';
$string['core.courses.showonlyenrolled'] = 'マイコースのみ表示する';
$string['core.courses.totalcoursesearchresults'] = '合計コース数: {{$a}}';
$string['core.currentdevice'] = '現在のデバイス';
$string['core.datastoredoffline'] = '送信できなかったため、データはデバイスに保存されました。後ほど自動的に送信されます。';
$string['core.deletedoffline'] = '削除済みオフライン';
$string['core.deleting'] = '削除中';
$string['core.desktop'] = 'デスクトップ';
$string['core.dfdaymonthyear'] = 'YYYY/MM/DD';
$string['core.dfdayweekmonth'] = 'MMM月D日（ddd）';
$string['core.dffulldate'] = 'YYYY年MMMM月D日（dddd） h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = '無視';
$string['core.dismiss'] = '取消';
$string['core.dontshowagain'] = '再度表示しません。';
$string['core.downloaded'] = 'ダウンロード済み';
$string['core.downloading'] = 'ダウンロード中';
$string['core.editor.hidetoolbar'] = 'ツールバーを隠す';
$string['core.editor.toggle'] = 'エディタを切り替える';
$string['core.emptysplit'] = '左側パネルが空であるか読み込み中の場合、このページは空白で表示されます。';
$string['core.endingtime'] = '終了時刻:{{$a}}';
$string['core.errorchangecompletion'] = '完了ステータスの変更中にエラーが発生しました。再度お試しください。';
$string['core.errorcode'] = 'エラーコード:{{errorCode}}';
$string['core.errordeletefile'] = 'ファイル削除中にエラーが発生しました。再度お試しください。';
$string['core.errordetailshide'] = 'エラーの詳細を隠す';
$string['core.errordetailsshow'] = 'エラーの詳細を見る';
$string['core.errordownloading'] = 'ファイルのダウンロード中にエラーが発生しました。';
$string['core.errordownloadingsomefiles'] = 'ファイルのダウンロード中にエラーが発生しました。一部のファイルが欠落している可能性があります。';
$string['core.errorfileexistssamename'] = '同じ名称のファイルが存在します。';
$string['core.errorinvalidform'] = '必須フィールドがすべて入力されていること、あなたが入力したデータが正しいフォーマットであることを確認してください。';
$string['core.errorinvalidresponse'] = '{{method}} ウェブサービスに対する予期しない応答があります。';
$string['core.errorloadingcontent'] = 'コンテンツの読み込み中にエラーが発生しました。';
$string['core.errorofflinedisabled'] = 'あなたのサイトではオフライン閲覧が無効にされています。あなたがアプリを使用するにはインターネットへの接続が必要です。';
$string['core.erroropenfiledownloading'] = 'ファイルオープンエラー: あなたはダウンロード完了を待つ必要があります。';
$string['core.erroropenfilenoapp'] = 'ファイルを開く際にエラーが発生しました。このタイポウのファイルを開くためのアプリが見つかりませんでした。';
$string['core.erroropenfilenoextension'] = 'ファイルを開く際にエラーが発生しました。ファイルに拡張子がありません。';
$string['core.erroropenpopup'] = 'この活動はポップアップを開こうとしています。これはアプリではサポートされていません。';
$string['core.errorrenamefile'] = 'ファイル名変更中にエラーが発生しました。再度お試しください。';
$string['core.errorsitesupport'] = '問題が続く場合、サイトサポートにご連絡ください。';
$string['core.errorsomedatanotdownloaded'] = 'あなたがこの活動をダウンロードした場合、パフォーマンスおよびデータ使用の理由からダウンロード処理中に一部のデータがダウンロードされないことに留意してください。';
$string['core.errorsomethingwrong'] = '問題が発生しました。再度お試しください。';
$string['core.errorsync'] = '同期中にエラーが発生しました。再度お試しください。';
$string['core.errorsyncblocked'] = '実行中のプロセスがあったため、この {{$a}} はすぐに同期できませんでした。後でもう一度お試しください。問題が継続する場合、アプリを再起動してください。';
$string['core.errorurlschemeinvalidscheme'] = 'このURLは別のアプリでの使用を想定しています: {{$a}}';
$string['core.errorurlschemeinvalidsite'] = 'このサイトURLはこのアプリで開けません。';
$string['core.exactalarmsturnedoff'] = 'リアルタイム通知は無効にされています。';
$string['core.exactalarmsturnedoffmessage'] = '重要なアラートを見逃したくない場合、あなたのデバイスの設定で「アラームおよびリマインダ」を有効にしてください。';
$string['core.filedeletedsuccessfully'] = 'あなたは正常に「 {{filename}} 」を削除しました。';
$string['core.filenameexist'] = 'ファイル名がすでに存在します: {{$a}}';
$string['core.fileuploader.audio'] = 'オーディオ';
$string['core.fileuploader.camera'] = 'カメラ';
$string['core.fileuploader.confirmuploadfile'] = 'あなたは {$a} をアップロードしようとしています。本当に続けてもよろしいですか?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'アップロードのサイズを計算できませんでした。本当に続けてもよろしいですか?';
$string['core.fileuploader.discardrecording'] = 'レコーディングを削除する';
$string['core.fileuploader.errorcapturingaudio'] = 'オーディオのキャプチャ中にエラーが発生しました。';
$string['core.fileuploader.errorcapturingimage'] = 'イメージのキャプチャ中にエラーが発生しました。';
$string['core.fileuploader.errorcapturingvideo'] = 'ビデオのキャプチャ中にエラーが発生しました。';
$string['core.fileuploader.errorgettingimagealbum'] = 'アルバムからのイメージの取得中にエラーが発生しました。';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'ファイルをアップロードする場合、あなたはオンラインである必要があります。';
$string['core.fileuploader.errornoapp'] = 'あなたはこの操作を実行するためのアプリをインストールしていません。';
$string['core.fileuploader.errorreadingfile'] = 'ファイルの読み込み中にエラーが発生しました。';
$string['core.fileuploader.errorwhileuploading'] = 'ファイルのアップロード中にエラーが発生しました。';
$string['core.fileuploader.file'] = 'ファイル';
$string['core.fileuploader.fileuploaded'] = 'ファイルが正常にアップロードされました。';
$string['core.fileuploader.maxbytesfile'] = 'ファイル {{$a.file}} が大きすぎます。あなたがアップロードできる最大サイズは {{$a.size}} です。';
$string['core.fileuploader.microphonepermissiondenied'] = 'マイクへのアクセス許可が拒否されました。';
$string['core.fileuploader.microphonepermissionrestricted'] = 'マイクへのアクセスは制限されています。';
$string['core.fileuploader.pauserecording'] = 'レコーディングを中断する';
$string['core.fileuploader.photoalbums'] = 'フォトアルバム';
$string['core.fileuploader.readingfile'] = 'ファイル読み込み';
$string['core.fileuploader.readingfileperc'] = 'ファイル読み込み中: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'レコーディングを再開';
$string['core.fileuploader.selectafile'] = 'ファイルを選択する';
$string['core.fileuploader.startrecordinginstructions'] = 'タップしてレコーディングを開始';
$string['core.fileuploader.uploadafile'] = 'ファイルをアップロードする';
$string['core.fileuploader.uploading'] = 'アップロード中';
$string['core.fileuploader.uploadingperc'] = 'アップロード中: {{$a}}%';
$string['core.fileuploader.video'] = 'ビデオ';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = '{{$a}} に移動する';
$string['core.h5p.errorgetemail'] = 'ユーザメールの取得中にエラーが発生しました。あなたの接続を確認して再度お試しください。';
$string['core.h5p.offlinedisabled'] = 'サイトではH5Pパッケージをダウンロードできません。';
$string['core.h5p.play'] = 'H5Pを再生する';
$string['core.hasdatatosync'] = 'この {{$a}} には同期すべきオフラインデータがあります。';
$string['core.howtoobtaincoordinates'] = 'あなたはGPSアプリまたは<a href="{{url}}">地図アプリ</a>で座標を取得できます。';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'このコンテンツを利用できませんか?';
$string['core.image'] = 'イメージ';
$string['core.imageviewer'] = 'イメージビューア';
$string['core.ioscookieshelp'] = '埋め込みコンテンツの動作にはクッキーが必要な場合があります。アプリのiOS設定で「クロスウェブサイトトラッキングを許可する」を有効にして再度お試しください。';
$string['core.lastdownloaded'] = '最終ダウンロード';
$string['core.lastsync'] = '最終同期';
$string['core.leave'] = '離れる';
$string['core.loadmore'] = 'さらに読み込む';
$string['core.locationnolongeravailable'] = 'あなたの現在地検索は終了しました。{{howToObtain}}';
$string['core.login.authenticating'] = '認証中';
$string['core.login.changepasswordbutton'] = 'パスワード変更';
$string['core.login.changepasswordhelp'] = 'あなたのパスワード変更に問題がある場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.login.changepasswordreconnectinstructions'] = 'あなたがパスワードを正しく変更しなかった場合、再度変更するよう求められます。';
$string['core.login.changepasswordsupportsubject'] = '私のパスワード変更のサポートを必要とする';
$string['core.login.confirmdeletesite'] = '本当に {{sitename}} のアカウントを削除してもよろしいですか?';
$string['core.login.connect'] = '接続する!';
$string['core.login.connecttomoodle'] = 'Moodleに接続する';
$string['core.login.connecttomoodleapp'] = 'あなたは通常のMoodleサイトに接続しようとしています。このサイトにアクセスするには公式Moodleアプリをダウンロードしてください。';
$string['core.login.connecttoworkplaceapp'] = 'あなたはMoodle Workplaceサイトに接続しようとしています。このサイトにアクセスするにはMoodle Workplaceアプリをダウンロードしてください。';
$string['core.login.credentialsdescription'] = 'ログインするにはユーザ名およびパスワードを入力してください。';
$string['core.login.credentialshelp'] = 'あなたがログインできない場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.login.credentialssupportsubject'] = 'ログインのサポートを必要とする';
$string['core.login.emailconfirmsentnoemail'] = '<p>あなたのアドレスにメールが送信されました。</p><p>メールには登録を完了するための簡単なインストラクションを含みます。</p>';
$string['core.login.emailnotmatch'] = 'メールが合致しません。';
$string['core.login.erroraccesscontrolalloworigin'] = 'あなたが実行を試みているクロスオリジンコールが拒否されました。次をご確認ください: https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'このアカウントの削除中にエラーが発生しました。再度お試しください。';
$string['core.login.errorexampleurl'] = 'URL https://campus.example.eduはあくまでもURL例であり、実際のサイトではありません。<strong>あなたのスクールまたは組織のサイトURLを使用してください。</strong>';
$string['core.login.errorqrnoscheme'] = 'これは正しいログインURLではありません。';
$string['core.login.errorupdatesite'] = 'サイトトークンの更新中にエラーが発生しました。';
$string['core.login.exceededloginattempts'] = 'ログインのサポートが必要ですか? {{recoverPassword}} を試してみるか、あなたのサイトサポートにご連絡ください。';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'パスワードを復旧しています';
$string['core.login.exceededloginattemptssupportsubject'] = 'ログインできません';
$string['core.login.exceededloginattemptswithoutpassword'] = 'ログインのサポートが必要ですか? あなたのサイトサポートにご連絡ください。';
$string['core.login.exceededloginattemptswithoutsupport'] = 'ログインのサポートが必要ですか? {{recoverPassword}} をお試しください。';
$string['core.login.exceededpasswordresetattempts'] = 'あなたのアカウントへのアクセスに問題があるようです。あなたの教育機関または学習プロバイダに連絡するか、後でもう一度お試しください。';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'パスワードをリセットできない';
$string['core.login.faqcannotfindmysiteanswer'] = 'URLアドレスで検索してもあなたのMoodleサイトが見つからない場合、あなたのスクールまたは学習組織のMoodle担当者にご連絡ください。';
$string['core.login.faqcannotfindmysitequestion'] = 'URLアドレスで私のサイトが見つかりません。';
$string['core.login.faqcantloginanswer'] = '<p>あなたのMoodleサイトに接続できた場合、いつものユーザ名およびパスワードでログインできるはずです。</p>
<br>
<p>あなたのユーザ名またはパスワードを忘れた場合、<strong>あなたのユーザ名またはパスワードを忘れましたか?</strong>オプションを選択してください。それでもログインできない場合、またはあなたのユーザ名またはパスワードを取得するためのオプションが表示されない場合、あなたの教育機関または学習組織でMoodleを管理している担当者にご連絡ください。</p>';
$string['core.login.faqcantloginquestion'] = 'ログインできません。';
$string['core.login.faqmore'] = '詳細は<a href="https://docs.moodle.org/ja/モバイルMoodle_FAQ#toc" target="_blank">私たちのFAQ</a>をご確認ください。';
$string['core.login.faqsetupsiteanswer'] = 'あなたのMoodleサイトを作成するための異なるオプションを {{$link}} にアクセスして確認してください。';
$string['core.login.faqsetupsitelinktitle'] = '始めます。';
$string['core.login.faqsetupsitequestion'] = '自分のMoodleサイトを設定したい。';
$string['core.login.faqtestappanswer'] = 'Moodleデモサイトでアプリをテストするには「Your site」フィールドに「teacher」または「student」と入力した後、「Connect to your site」ボタンをクリックしてください。';
$string['core.login.faqtestappquestion'] = 'デモサイトでアプリをテストできますか?';
$string['core.login.faqwhatisurlanswer'] = '<p>すべての組織にはそれぞれのMoodleサイトに固有のアドレスまたはURLを持っています。</p><ol><li>ウェブブラウザを開いてあなたのMoodleサイトのログインページに移動してください。</li><li>ページ上部のアドレスバーにあなたのMoodleサイトのURLが表示されます。 例) campus.example.edu<br>{{$image}}</li><li>アドレスをコピーして (/loginおよびその後の部分はコピーしないでください) Moodleアプリに貼り付けた後、「あなたのサイトに接続する」をクリックしてください。</li><li>あなたのユーザ名およびパスワードを使ってあなたのサイトにログインできます</li></ol>。';
$string['core.login.faqwhatisurlquestion'] = '私のサイトを探すには?';
$string['core.login.faqwhereisqrcode'] = 'QRコードはどこにありますか?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>あなたのスクールまたは学習組織がこの機能を有効にしている場合、あなたのウェブサイトのユーザプロファイルページ下部にQRコードが表示されます。</p>{{$image}}';
$string['core.login.findyoursite'] = 'あなたのサイトを探す';
$string['core.login.invalidaccount'] = 'あなたのログイン情報を確認して再度お試しください。';
$string['core.login.invalidmoodleversion'] = 'このMoodleサイトのバージョンは古すぎます。Moodleアプリは {{$a}} またはそれ以降を使用するサイトで動作します。';
$string['core.login.invalidsite'] = 'サイトURLが正しくありません。';
$string['core.login.invalidtime'] = '時間が有効ではありません。';
$string['core.login.invalidvaluemax'] = '最大値は {{$a}} です。';
$string['core.login.invalidvaluemin'] = '最小値は {{$a}} です。';
$string['core.login.loginbutton'] = 'ログイン';
$string['core.login.mobileservicesnotenabled'] = 'サイトでモバイルサービスが有効にされていません。';
$string['core.login.morewaystologin'] = 'ログイン方法を増やす';
$string['core.login.notloggedin'] = 'あなたはログインする必要があります。';
$string['core.login.onboardingcreatemanagecourses'] = 'あなたのコースを作成および管理する';
$string['core.login.onboardingenrolmanagestudents'] = 'あなたの学生を登録および管理する';
$string['core.login.onboardinggetstarted'] = 'Moodleを始めましょう';
$string['core.login.onboardingialreadyhaveasite'] = '私にはすでにMoodleサイトがあります。';
$string['core.login.onboardingimalearner'] = '私は学習者です。';
$string['core.login.onboardingimaneducator'] = '私は教育者です。';
$string['core.login.onboardingineedasite'] = 'Moodleサイトが必要です。';
$string['core.login.onboardingprovidefeedback'] = 'フィードバックを適時提供する';
$string['core.login.onboardingtoconnect'] = 'あなたがMoodleアプリに接続するにはMoodleサイトが必要です。';
$string['core.login.onboardingwelcome'] = 'Moodleアプリにようこそ!';
$string['core.login.or'] = 'OR';
$string['core.login.passwordrequired'] = 'パスワードが必要です。';
$string['core.login.policyacceptmandatory'] = '私は必須のサイトポリシーを理解および同意します';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHAチャレンジイメージ';
$string['core.login.recaptchaexpired'] = '検証の有効期限が切れました。再度セキュリティ質問にお答えください。';
$string['core.login.recaptchaincorrect'] = 'セキュリティ質問の回答が正しくありません。';
$string['core.login.reconnect'] = '再接続';
$string['core.login.reconnecthelp'] = '再接続に問題がある場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.login.reconnectsupportsubject'] = '再接続のサポートを必要とする';
$string['core.login.reconnecttosite'] = 'サイトに再接続する';
$string['core.login.removeaccount'] = 'アカウントを削除する';
$string['core.login.searchby'] = '検索:';
$string['core.login.selectsite'] = 'あなたのアカウントを選択してください:';
$string['core.login.signupplugindisabled'] = '{{$a}} が有効にされていません。';
$string['core.login.signuprequiredfieldnotsupported'] = 'サインアップフォームにアプリでサポートされていない必須のカスタムフィールドが含まれています。ウェブブラウザを使用してあなたのアカウントを作成してください。';
$string['core.login.siteaddress'] = 'あなたのサイト';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = '{{count}} 件の未読通知があります。';
$string['core.login.sitehasredirect'] = 'あなたのサイトには少なくとも1つのHTTPリダイレクトが含まれています。アプリがリダイレクトに従えないため、これがあなたのサイトへのアプリの接続を妨げている問題である可能性があります。';
$string['core.login.siteinmaintenance'] = 'あなたのサイトはメンテナンスモードです。';
$string['core.login.sitenotallowed'] = 'このサイトは利用できません。';
$string['core.login.sitepolicynotagreederror'] = 'サイトポリシーに同意されていません。';
$string['core.login.siteurl'] = 'サイトURL';
$string['core.login.siteurlrequired'] = 'サイトURLは必須です。例) https://campus.example.edu';
$string['core.login.stillcantconnect'] = 'まだ接続できませんか?';
$string['core.login.toggleremove'] = 'アカウントリストを編集する';
$string['core.login.unsupportedsite'] = 'アプリからサイトにアクセスできません。';
$string['core.login.unsupportedsitemessage'] = '{{site}} はこのアプリからアクセスできません。<br><br>あなたはウェブブラウザでアクセスできます。';
$string['core.login.usernamerequired'] = 'ユーザ名が必要です。';
$string['core.login.visitchangepassword'] = 'パスワードの変更のためにサイトにアクセスしますか?';
$string['core.login.webservicesnotenabled'] = 'サイトではWebサービスが有効にされていません。';
$string['core.login.youcanstillconnectwithcredentials'] = 'あなたはまだユーザ名およびパスワードを入力してサイトに接続できます。';
$string['core.login.yourenteredsite'] = 'あなたのサイトに接続する';
$string['core.lostconnection'] = 'あなたのセッションの有効期限が切れました。続けるには再度ログインしてください。';
$string['core.mainmenu.switchaccount'] = 'アカウントをスイッチする';
$string['core.mainmenu.usermenutourdescription'] = 'あなたの成績を確認、プリファレンスを変更またはアカウントを切り替える場所です。';
$string['core.mainmenu.usermenutourtitle'] = 'あなたのパーソナルエリアを探索する';
$string['core.needhelp'] = 'お困りですか?';
$string['core.needinternettoaccessit'] = 'アクセスするにはあなたはインターネットに接続する必要があります。';
$string['core.networkerroriframemsg'] = 'このコンテンツはオフラインでは利用できません。インターネットに接続して再度お試しください。';
$string['core.networkerrormsg'] = 'サイトへの接続中にに問題が発生しました。あなたの接続を確認して再度お試しください。';
$string['core.nooptionavailable'] = '利用可能なオプションはありません。';
$string['core.nopasswordchangeforced'] = 'あなたのパスワードを変更しない限り、先に進めません。';
$string['core.nopermissionerror'] = '申し訳ございません、現在あなたにはその操作のパーミッションがありません。';
$string['core.notapplicable'] = '該当なし';
$string['core.notavailablecontentinapp'] = 'このコンテンツはアプリでは利用できませんが、あなたは以下のボタンからウェブブラウザで開けます。';
$string['core.notavailableoffline'] = 'このコンテンツはオフラインでは利用できません。インターネットに接続して再度お試しください。';
$string['core.notdownloadable'] = 'ダウンロード不可';
$string['core.notnow'] = '今ではない';
$string['core.notsent'] = '未送信';
$string['core.nummore'] = 'さらに {{$a}}';
$string['core.openfile'] = 'ファイルを開く';
$string['core.openfilewithextension'] = '{{extension}} ファイルを開く';
$string['core.openfullimage'] = 'クリックしてフルサイズの画像を表示する';
$string['core.openinbrowser'] = 'ブラウザで開く';
$string['core.openinbrowserdescription'] = 'あなたはウェブブラウザに移動します。';
$string['core.openmodinbrowser'] = '{{$a}} をブラウザで開く';
$string['core.opensecurityquestion'] = 'セキュリティ質問を開く';
$string['core.opensettings'] = '設定を開く';
$string['core.openwith'] = '開く ...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = '再生';
$string['core.policy.havereadandagreepolicy'] = '私は {{policyname}} を読んで同意します。';
$string['core.policy.nopoliciesyet'] = 'まだポリシおよび同意はありません。';
$string['core.policy.policyacceptmandatory'] = '私は必須サイトポリシを理解および同意します。';
$string['core.policy.sitepolicynotagreederror'] = 'まだサイトポリシに同意されていません。';
$string['core.policy.viewpolicy'] = 'ポリシ {{policyname}} を表示します。';
$string['core.pulltorefresh'] = 'スワイプで更新';
$string['core.qrscanner'] = 'QRスキャナ';
$string['core.question.cannotdeterminestatus'] = 'ステータスを判定できません。';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'あなたのサイトはまだ回答へのファイル添付をサポートしていません。';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'あなたのサイトはまだ埋め込みファイルの編集をサポートしていません。';
$string['core.question.errorquestionnotsupported'] = 'この問題タイプはアプリでサポートされていません: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'タップして選択してタップしてドロップしてください。';
$string['core.question.questionmessage'] = '問題 {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'あなたはサイトにリダイレクトされます。';
$string['core.reminders.atthetime'] = 'イベント時';
$string['core.reminders.custom'] = 'カスタム ...';
$string['core.reminders.customreminder'] = 'カスタムリマインダー';
$string['core.reminders.delete'] = 'リマインダを削除する';
$string['core.reminders.reminderset'] = '{{$a}} にリマインダを設定する';
$string['core.reminders.reminderunset'] = 'リマインダーを削除しました';
$string['core.reminders.setareminder'] = 'リマインダーを設定する';
$string['core.reminders.setareminderfor'] = '「 {{title}} 」 ({{label}}) にリマインダを設定する';
$string['core.reminders.setreminder'] = 'リマインダーを設定する';
$string['core.reminders.timebefore'] = '{{value}} {{units}} 前';
$string['core.reminders.value'] = '値';
$string['core.removedownloadeddata'] = 'ダウンロードデータを削除する';
$string['core.removefiles'] = 'ファイルを削除する {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'この表示にはフィルタが適用されている場合があります。フィルタを編集または並べ替え順を変更する場合、<a href="{{$a}}">あなたのブラウザでこのレポートを開いてください。</a>';
$string['core.reportbuilder.hidecolumns'] = '列を非表示';
$string['core.reportbuilder.showcolumns'] = '列を表示';
$string['core.requireduserdatamissing'] = 'このユーザには必要なプロファイルデータがありません。あなたのサイトにデータを入力して再度お試しください。<br>{{$a}}';
$string['core.resume'] = '再開';
$string['core.retry'] = 'リトライ';
$string['core.scanqr'] = 'QRコードをスキャンする';
$string['core.scrollbackward'] = '後ろにスクロールする';
$string['core.scrollforward'] = '前にスクロールする';
$string['core.search.allcategories'] = 'すべてのカテゴリ';
$string['core.search.empty'] = '何を探しますか?';
$string['core.search.filtercategories'] = 'フィルタ結果:';
$string['core.search.filtercourses'] = '検索';
$string['core.search.noresults'] = '「 {{$a}} 」の結果はありません。';
$string['core.search.noresultshelp'] = 'タイポをチェックするか、別のキーワードを使ってみる';
$string['core.search.resultby'] = 'By {{$a}}';
$string['core.searching'] = '検索中';
$string['core.serverconnection'] = 'サーバ接続エラー: {{details}}';
$string['core.settings.about'] = 'このアプリについて';
$string['core.settings.appsettings'] = 'アプリ設定';
$string['core.settings.appversion'] = 'アプリバージョン';
$string['core.settings.cannotsyncloggedout'] = 'あなたがログアウトしたためこのサイトは同期できません。あなたがサイトにログインした際に再度お試しください。';
$string['core.settings.cannotsyncoffline'] = 'あなたのデバイスがインターネットに接続されていないため、サイトの同期に失敗しました。';
$string['core.settings.cannotsyncwithoutwifi'] = 'あなたのデバイスがWi-Fiに接続されていません。Wi-Fiネットワークに接続するか、アプリの設定でデータセーバをオフにしてください。';
$string['core.settings.changelanguage'] = '{{$a}} に変更する';
$string['core.settings.changelanguagealert'] = '言語を変更した場合、アプリが再起動します。';
$string['core.settings.colorscheme'] = 'カラースキーマ';
$string['core.settings.colorscheme-dark'] = 'ダーク';
$string['core.settings.colorscheme-light'] = 'ライト';
$string['core.settings.colorscheme-system'] = 'システムデフォルト';
$string['core.settings.colorscheme-system-notice'] = 'あなたのデバイスのサポートによりシステムのデフォルトモードは異なります。';
$string['core.settings.compilationinfo'] = 'コンパイル情報';
$string['core.settings.connecttosync'] = 'オフラインです。サイトを同期するため、インターネットに接続してください。';
$string['core.settings.connectwifitosync'] = 'サイトを同期するには、Wi-Fi をオンにするかデータセーバーをオフにしてください。';
$string['core.settings.copyinfo'] = 'デバイス情報をクリップボードにコピーする';
$string['core.settings.cordovadevicemodel'] = 'Cordovaデバイスモデル';
$string['core.settings.cordovadeviceosversion'] = 'CordovaデバイスOSバージョン';
$string['core.settings.cordovadeviceplatform'] = 'Cordovaデバイスプラットフォーム';
$string['core.settings.cordovadeviceuuid'] = 'CordovaデバイスUUID';
$string['core.settings.cordovaversion'] = 'Cordovaバージョン';
$string['core.settings.debugdisplaydescription'] = 'この設定を有効にした場合、可能であればエラーモーダルはエラーに関する詳細データを表示します。';
$string['core.settings.developeroptions'] = '開発者オプション';
$string['core.settings.deviceinfo'] = 'デバイス情報';
$string['core.settings.deviceos'] = 'デバイスOS';
$string['core.settings.displayformat'] = '表示フォーマット';
$string['core.settings.enableanalytics'] = 'アナリティクスを有効にする';
$string['core.settings.enableanalyticsdescription'] = 'この設定を有効にした場合、アプリは匿名の使用データを収集します。';
$string['core.settings.enabledownloadsection'] = 'セクションダウンロードを有効にする';
$string['core.settings.enablepinchtozoom'] = 'ピンチズームを有効にする';
$string['core.settings.enablerichtexteditor'] = 'テキストエディタを有効にする';
$string['core.settings.enablerichtexteditordescription'] = 'この設定を有効にした場合、コンテンツ入力時にテキストエディタを利用できます。';
$string['core.settings.encryptedpushsupported'] = '暗号化プッシュ通知サポート';
$string['core.settings.entriesincache'] = 'キャッシュ内に {{$a}} 件のエントリがあります。';
$string['core.settings.estimatedfreespace'] = '推定空き容量';
$string['core.settings.filesystemroot'] = 'ファイルシステムルート';
$string['core.settings.fontsize'] = 'テキストサイズ';
$string['core.settings.forcedsetting'] = 'この設定はあなたのサイト設定により強制されています。';
$string['core.settings.helpusimprove'] = 'このアプリの改善にご協力ください。';
$string['core.settings.ioscookies'] = 'クロスウェブサイトトラッキング';
$string['core.settings.ioscookiesdescription'] = 'サイトからの埋め込みコンテンツには動作にクロスサイトクッキーを必要とする場合があります。この設定を有効にするにはアプリのiOS設定で「クロスウェブサイトトラッキングを許可する」を有効にしてください。';
$string['core.settings.legaldisclaimer'] = '免責事項';
$string['core.settings.localnotifavailable'] = 'ローカル通知利用可';
$string['core.settings.locationhref'] = 'ウェブ表示URL';
$string['core.settings.logintosync'] = 'ログインして同期する';
$string['core.settings.navigatorlanguage'] = 'ナビゲータ言語';
$string['core.settings.navigatoruseragent'] = 'ナビゲータユーザエージェント';
$string['core.settings.networkstatus'] = 'インターネット接続ステータス';
$string['core.settings.opensourcelicenses'] = 'オープンソースライセンス';
$string['core.settings.privacypolicy'] = 'プライバシーポリシー';
$string['core.settings.publisher'] = '発行者';
$string['core.settings.pushid'] = 'プッシュ通知ID';
$string['core.settings.reportinbackground'] = 'エラーを自動的に報告する';
$string['core.settings.screen'] = 'スクリーン情報';
$string['core.settings.showdownloadoptions'] = 'ダウンロードオプションを表示する';
$string['core.settings.siteinfo'] = 'サイト情報';
$string['core.settings.sitesynccompleted'] = 'サイト同期が完了しました。';
$string['core.settings.sitesyncfailed'] = 'サイト同期に失敗';
$string['core.settings.spaceusage'] = 'ストレージ使用量';
$string['core.settings.syncdatasaver'] = 'データセーバ: Wi-Fi接続時のみ同期する';
$string['core.settings.synchronization'] = '同期';
$string['core.settings.synchronizenow'] = '今すぐ同期する';
$string['core.settings.synchronizenowhelp'] = 'サイトを同期させた場合、保留中の変更およびデバイスに保存されているすべてのオフライン活動が送信されます。また、メッセージおよび通知等の一部のデータが同期されます。';
$string['core.settings.syncsettings'] = '同期設定';
$string['core.settings.wificonnection'] = 'Wi-Fi接続';
$string['core.settings.youradev'] = 'あなたは開発者です。';
$string['core.sharedfiles.chooseaccountstorefile'] = 'ファイルを保存するアカウントを選択してください。';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'この名称のファイルはすでに存在します。既存のファイルを置換または「 {{$a}} 」にリネームしますか?';
$string['core.sharedfiles.errorreceivefilenosites'] = '保存されているサイトはありません。このアプリでファイルを共有するにはサイトを追加してください。';
$string['core.sharedfiles.nosharedfiles'] = 'このサイトに保存されている共有ファイルはありません。';
$string['core.sharedfiles.nosharedfilestoupload'] = 'ここにアップロードするファイルはありません。他のアプリからファイルをアップロードしたい場合、ファイルを探して「開く」ボタンをクリックしてください。';
$string['core.sharedfiles.rename'] = 'リネーム';
$string['core.sharedfiles.replace'] = '置換';
$string['core.sharedfiles.sharedfiles'] = '共有ファイル';
$string['core.sharedfiles.successstorefile'] = 'ファイルが正常に保存されました。あなたのプライベートファイルにアップロードまたは活動で使用するファイルを選択してください。';
$string['core.sitenotfoundhelp'] = '私たちはあなたが入力したサイトを探せませんでした。タイポを確認するか、後でもう一度お試しください。このメッセージが表示され続ける場合、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.siteunavailablehelp'] = 'サイト「 {{site}} 」は現在利用できません。後でもう一度試すか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = '申し訳ございません ...';
$string['core.start'] = 'スタート';
$string['core.startingtime'] = '開始時刻: {{$a}}';
$string['core.storingfiles'] = 'ファイルを保存する';
$string['core.submittedoffline'] = '送信済み (オフライン)';
$string['core.swipenavigationtourdescription'] = '移動するには左右にスワイプしてください。';
$string['core.tablet'] = 'タブレット';
$string['core.tag.errorareanotsupported'] = 'アプリではこのタグエリアはサポートされません。';
$string['core.tag.tagareabadgedescription'] = '{{count}} 件のアイテムがあります。';
$string['core.tag.warningareasnotsupported'] = 'アプリでサポートされていないため、一部のタグエリアは表示されません。';
$string['core.thereisdatatosync'] = '同期が必要なオフライン {{$a}} があります。';
$string['core.toggledelete'] = '削除ボタンの切り替え';
$string['core.tryagain'] = 'リトライ';
$string['core.turnon'] = '有効にする';
$string['core.turnonexactalarms'] = 'リアルタイム通知を有効にする';
$string['core.turnonnotifications'] = '通知を有効にする';
$string['core.turnonnotificationsmessage'] = '活動および 課題に関する通知を受信しますか?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.uhoh'] = 'おおっと!';
$string['core.unexpectederror'] = '不明なエラー。アプリを閉じて再起動してください。';
$string['core.unicodenotsupported'] = 'このサイトでは一部の絵文字がサポートされていません。このような文字はメッセージ送信時に削除されます。';
$string['core.unicodenotsupportedcleanerror'] = 'Unicode文字のクリーニング時に空のテキストが見つかりました。';
$string['core.unknown'] = '不明';
$string['core.unzipping'] = '展開する';
$string['core.updaterequired'] = '要アプリアップデート';
$string['core.updaterequireddesc'] = 'あなたのアプリをバージョン {{$a}} にアップデートしてください。';
$string['core.user.completeprofile'] = 'プロファイルを完了する';
$string['core.user.completeprofilehelp'] = 'あなたのプロファイル完了に問題がある場合、後でもう一度試してみるか、あなたの教育機関または学習プロバイダにご連絡ください。';
$string['core.user.completeprofilenotice'] = '続ける前に、プロフィールの必須項目に記入してください。';
$string['core.user.completeprofilereconnectinstructions'] = 'あなたのプロファイルが正しく完了されていない場合、後でもう一度お願いすることになります。';
$string['core.user.completeprofilesupportsubject'] = '私のプロファイル完了のサポートを必要とする';
$string['core.user.completeyourprofile'] = 'あなたのプロファイルを完了する';
$string['core.user.contact'] = 'コンタクト';
$string['core.user.detailsnotavailable'] = 'あなたはこのユーザ詳細を利用できません。';
$string['core.user.errorloaduser'] = 'ユーザ読み込み中にエラーが発生しました。';
$string['core.user.sendemail'] = 'メール';
$string['core.user.support'] = 'サイトサポートに連絡する';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'ID {{id}} のユーザ';
$string['core.usernologin'] = 'このアカウントの認証は無効にされました。';
$string['core.viewcode'] = 'コードを表示する';
$string['core.vieweditor'] = 'エディタを表示する';
$string['core.viewembeddedcontent'] = '埋め込みコンテンツを表示する';
$string['core.viewer.decreasetextsize'] = 'テキストサイズを小さくする';
$string['core.viewer.enterreadingmode'] = 'リーディングモードに入る';
$string['core.viewer.exitreadingmode'] = 'リーディングモードから抜ける';
$string['core.viewer.increasetextsize'] = 'テキストサイズを大きくする';
$string['core.viewer.openreadingmodesettings'] = 'リーディングモード設定を開く';
$string['core.viewer.readingthemeauto'] = 'マッチアプリ';
$string['core.viewer.readingthemedark'] = 'ダーク';
$string['core.viewer.readingthemehcm'] = 'ハイコントラスト';
$string['core.viewer.readingthemelight'] = 'ライト';
$string['core.viewer.readingthemesepia'] = 'セピア';
$string['core.wanttochangesite'] = 'サイトを変更またはログアウトしますか?';
$string['core.warningofflinedatadeleted'] = '{{component}} 「 {{name}} 」のオフラインデータが削除されました。{{error}}';
$string['core.warningofflinedatadeletedreason'] = 'この活動の新しい変更は別のデバイスから実施されました。';
$string['core.warnopeninbrowser'] = '<p>あなたはアプリから離れてブラウザで次のURLを開こうとしています。続けてもよろしいですか?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'なぜこのようなことが発生したのですか?';
$string['core.wsfunctionnotavailable'] = 'ウェブサービス関数は利用できません。';
$string['core.youreoffline'] = 'あなたのデバイスはオフラインです。';
$string['core.youreonline'] = 'あなたのデバイスはオンラインに戻りました。';
$string['core.zoomin'] = 'ズームイン';
$string['core.zoomout'] = 'ズームアウト';
$string['freemium.biometriclogin'] = '生体認証ログイン';
$string['freemium.biometriclogindescription'] = 'あなたの指を指紋認証リーダに乗せてください。';
$string['freemium.biometricloginenablefaceid'] = 'FaceIDを有効にする';
$string['freemium.biometricloginenablefingerprint'] = '指紋認証を有効にする';
$string['freemium.biometricloginenabletouchid'] = 'TouchIDを有効にする';
$string['freemium.biometricloginloginwithfaceid'] = 'FaceIDでログインする';
$string['freemium.biometricloginloginwithfingerprint'] = '指紋でログインする';
$string['freemium.biometricloginloginwithtouchid'] = 'TouchIDでログインする';
$string['freemium.biometricloginskip'] = '今はスキップする';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} が有効にされました。';
$string['freemium.biometricloginturnoff'] = 'あなたはこの機能を設定でいつでも有効または無効にできます。';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = '指紋';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'あなたの指紋または顔による生体認証ログインを利用します。';
$string['freemium.change'] = '変更';
$string['freemium.coursesbatchdownloaddisabled'] = 'このサイトではコースの一括ダウンロードは有効にされていません。';
$string['freemium.coursesdownloadlimitreached'] = 'コースのダウンロード制限に達しました! あなたがダウンロードできるコースは {{limit}} のみです。この制限を増やすかダウンロードしたコースの一部をデバイスから削除したい場合、あなたの管理者にご連絡ください。';
$string['freemium.downloadmainapplicationrequired'] = 'あなたはこのサイトに専用アプリでのみ接続可能です。';
$string['freemium.downloadmainapplicationsuggestion'] = 'あなたが接続を試みているサイトには専用アプリがあります。そちらをお試しください。';
$string['freemium.feature_biometriclogin'] = '生体認証ログイン';
$string['freemium.feature_coursesdownload'] = 'ダウンロードしたコース';
$string['freemium.feature_multimediapushnotifications'] = 'マルチメディアプッシュ通知';
$string['freemium.feature_pushnotificationsdevices'] = 'プッシュ通知デバイス';
$string['freemium.feature_qrlogin'] = 'QRコードで認証する';
$string['freemium.feature_remotethemes'] = 'リモートテーマ';
$string['freemium.feature_sitelogo'] = 'サイトロゴ';
$string['freemium.notallowed'] = '許可されていません';
$string['freemium.nottoday'] = '今日ではありません';
$string['freemium.qrlogindisabled'] = 'QRコードを使用したアプリでの認証はサイトで有効にされていません:
<br><br>
{{url}}';
$string['freemium.qrloginexpiredkey'] = 'QRコードの有効期限が切れています。QRコードのあるページを更新して再度スキャンしてください。';
$string['freemium.qrloginipmismatch'] = 'あなたが接続に使用しているデバイスがQRコードを表示するデバイスと同じネットワークにないようです。両方のデバイスが同じネットワーク (例: 同じWiFiネットワーク) に接続されていることを確認してください。エラーが続く場合、あなたのサイト管理者にご連絡ください。';
$string['freemium.ratetheapp'] = '私たちのアプリを楽しんでいますか?';
$string['freemium.ratetheapp_feedbackko'] = '私たちに問題点をお教えください。';
$string['freemium.ratetheapp_feedbackmessage'] = 'あなたのフィードバックは匿名にされます。';
$string['freemium.ratetheapp_feedbackok'] = 'フィードバックを送る';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'ここに記入';
$string['freemium.ratetheapp_feedbacksent'] = 'ご協力ありがとうございます。フィードバックは正常に送信されました。';
$string['freemium.ratetheapp_sendtostore'] = '私たちのアプリを評価していただけませんでしょうか? この評価は私たちのアプリの改善に役立てることができます。';
$string['freemium.remindmelater'] = '私に後で知らせて';
$string['freemium.settingsoptionsfacial'] = '顔認証ログインを有効にする';
$string['freemium.settingsoptionsfingerprint'] = '指紋認証ログインを有効にする';
$string['freemium.subscription'] = 'サイトサブスクリプション';
$string['freemium.subscriptiondetails'] = 'サブスクリプション詳細';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} 件のカスタム言語ストリングは無視されます。';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} 件のカスタムメニューアイテムは無視されます。';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} 件の無効に設定された機能が有効なままです。';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'あなたのカスタムテーマは適用されません。';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'あなたのサイトロゴは適用されません。';
$string['freemium.subscriptionfeature_limited'] = '{{ limit }} に制限する';
$string['freemium.subscriptionfeature_unlimited'] = '無制限';
$string['freemium.subscriptionplan'] = 'サブスクリプションプラン';
$string['freemium.subscriptionplan_expired'] = '期限切れ';
$string['freemium.subscriptionplan_free'] = '無料';
$string['freemium.subscriptionplan_upgrade'] = 'あなたのプランをアップグレードする';
$string['freemium.subscriptionplan_validuntil'] = '{{ date }} まで有効';
$string['freemium.subscriptionplandescription'] = 'サブスクリプションプランはこのサイトに適用される制限を示します。';
$string['freemium.subscriptionplanlearnmore'] = 'もっと見る';
$string['freemium.upsell_renewexpired'] = 'あなたのサブスクリプションの有効期限が切れました。';
$string['freemium.upsell_renewexpiring'] = 'あなたのサブスクリプションは {{ days }} 日で有効期限が切れます。';
$string['freemium.upsell_renewtitle'] = 'あなたのサブスクリプションを更新する';
$string['freemium.upsell_upgradefreeaccept'] = 'アップグレード';
$string['freemium.upsell_upgradefreemessage'] = '現在、無料プランを使用中です。アップグレードして、より多くの機能をお試しください。';
$string['freemium.upsell_upgradefreepostpone'] = '後で';
$string['freemium.upsell_upgradefreetitle'] = 'アップグレードする';
$string['pluginname'] = 'Moodle App言語文字列';
$string['privacy_metadata'] = 'このプラグインはユーザーデータを一切保存しません。';
$string['workplace.teams.isoverdue'] = '期限切れのアイテムがある';
