<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'auth_oauth2', language 'sl', version '4.4'.
 *
 * @package     auth_oauth2
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accountexists'] = 'Na tej strani že obstaja uporabnik s tem uporabniškim imenom. Če je to vaš račun, se prijavite z vnosom vašega uporabniškega imena in gesla ter ga dodajte kot povezano prijavo v nastavitvah.';
$string['alreadylinked'] = 'Zunanji račun je že povezan z računom na tem spletnem mestu';
$string['auth_oauth2description'] = 'OAuth 2 standardno preverjanje pristnosti';
$string['auth_oauth2settings'] = 'OAuth 2 nastavitve za preverjanje pristnosti.';
$string['confirmaccountemail'] = 'Pozdravljeni {$a->firstname},

A z vašim e-poštnim naslovom zahtevan nov uporabniški račun\'{$a->sitename}\'.

Za potrditev vašega novega računa obiščite ta spletni naslov:

{$a->link}

V večini e-poštnih odjemalcev bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete. Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta,
{$a->admin}

če tega niste storili vi, je nekdo drug želel uporabiti vaš račun.
Prosimo, da se obrnete na skrbnika spletnega mesta.';
$string['confirmaccountemailsubject'] = '{$a}: potrditev računa';
$string['confirmationinvalid'] = 'Potrditvena povezava je neveljavna ali pa je potekla. Prosimo, da ponovno začnete s procesom prijave za ustvarjanje nove potrditvene e-pošte.';
$string['confirmationpending'] = 'Ta račun čaka na potrditev e-pošte.';
$string['confirmlinkedloginemail'] = 'Pozdravljeni {$a->fullname},

A z vašim e-poštnim naslovom je bil zahtevan {$a->issuername} nov uporabniški račun\'{$a->sitename}\'.

Za potrditev zahteve obiščite ta spletni naslov:

{$a->link}

V večini e-poštnih odjemalcev bi se moral naslov pojaviti kot modra povezava
na katero lahko preprosto kliknete. Če to ne deluje,
potem kopirajte in prilepite naslov v naslovno
vrstico na vrhu okna vašega spletnega brskalnika.

Če potrebujete pomoč, se obrnite na skrbnika spletnega mesta,
{$a->admin}

če tega niste storili vi, je nekdo drug želel uporabiti vaš račun.
Prosimo, da se obrnete na skrbnika spletnega mesta.';
$string['confirmlinkedloginemailsubject'] = '{$a}: potrditev povezanih prijav';
$string['createaccountswarning'] = 'Vtičnik za preverjanje pristnosti uporabniku dovoljuje, da na svojem spletnem mestu ustvari račune. Omogočite nastavitev »authpreventaccountcreation«, če ste uporabili ta vtičnik.';
$string['createnewlinkedlogin'] = 'Povežite nov račun ({$a})';
$string['emailconfirmlink'] = 'Povežite vaše račune';
$string['emailconfirmlinksent'] = '<p>Najden je bil obstoječ e-poštni naslov, ki pa ni še povezan.</p>
<p>Računi morajo biti povezani, preden se prijavite.</p>
   <p>Na vaš naslov ste dobili sporočilo <b>{$a}</b>. </p>
   <p>Vsebuje navodila za povezavo vaših računov. </p>
   <p>Če imate težave, se obrnite na skrbnika spletnega mesta.</p>';
$string['emailpasswordchangeinfo'] = 'Pozdravljeni {$a->firstname},

Nekdo (verjetni vi) je dal zahtevo za novo geslo za vaš račun na ‚{$a->sitename}‘.

Vendar pa vaše geslo ne more biti ponastavljeno, ker vaš račun uporabljate na drugi strani za prijavo.

Prosimo, da se prijavite kot običajno z uporabo povezave na strani za prijavo.
{$a->admin}';
$string['emailpasswordchangeinfosubject'] = '{$a}: Spremeni informacije o geslu';
$string['info'] = 'Zunanji račun';
$string['issuer'] = 'Storitev OAuth 2';
$string['issuernologin'] = 'Izdajatelj ne more biti uporabljen za prijavo';
$string['linkedlogins'] = 'Poveze prijave';
$string['linkedloginshelp'] = 'Pomoč pri povezanih prijavah';
$string['loginerror_authenticationfailed'] = 'Proces preverjanja pristnosti ni uspel.';
$string['loginerror_cannotcreateaccounts'] = 'Račun z vašim e-poštnim naslovom ni bil najden.';
$string['loginerror_invaliddomain'] = 'E-poštni naslov ni dovoljen na tem spletnem mestu.';
$string['loginerror_nouserinfo'] = 'Povratne infromacije o uporabniku so bile zavrnjene. OAuth 2 storitev je lahko nepravilno nastavljena.';
$string['loginerror_userincomplete'] = 'Povratne infromacije o uporabniku ne vsebujejo uporabniškega imena and e-poštnega naslova. OAuth 2 storitev je lahko nepravilno nastavljena.';
$string['noissuersavailable'] = 'Nobena od nastavljene OAuth 2 storitve ne dovoli, da povežete račune za prijavo.';
$string['notenabled'] = 'Vtičnik za preverjanje pristnosti OAuth 2 ni omgočen.';
$string['notloggedindebug'] = 'Poskus prijave ni uspel. Razlog: {$a}';
$string['notwhileloggedinas'] = 'Povezane prijave ne morete urejati, če ste prijavljeni kot drug uporabnik.';
$string['oauth2:managelinkedlogins'] = 'Upravljajte lastne račune povezanih prijav.';
$string['plugindescription'] = 'Ta vtičnik za preverjanje pristnosti prikazuje seznam nastavljenih ponudnikov identitet na strani za prijavo. Izbira ponudnika identitet uporabniku dovoljuje, da se prijavi s svojimi overitvenimi podatki ponudnika OAuth 2.';
$string['pluginname'] = 'OAuth 2';
$string['privacy:metadata:auth_oauth2'] = 'OAuth 2 preverjanje pristnosti.';
$string['privacy:metadata:auth_oauth2:authsubsystem'] = 'Ta vtičnik je povezan s podsistemom prevejanja prisotnosti.';
$string['privacy:metadata:auth_oauth2:confirmtoken'] = 'Potrditvena koda.';
$string['privacy:metadata:auth_oauth2:confirmtokenexpires'] = 'Časovni žig izteka veljavnosti potrditvene kode.';
$string['privacy:metadata:auth_oauth2:email'] = 'Zunanja e-pošta je povezana s tem računom.';
$string['privacy:metadata:auth_oauth2:issuerid'] = 'ID izdajatelja OAuth 2 za to prjavo v OAuth 2.';
$string['privacy:metadata:auth_oauth2:tableexplanation'] = 'OAuth 2 račun pvoezan z uporabnikovim Moodle računom.';
$string['privacy:metadata:auth_oauth2:timecreated'] = 'Časovni žig povezave uporabniškega računa s prijavo v OAuth 2.';
$string['privacy:metadata:auth_oauth2:timemodified'] = 'Časovni žig spremembe zapisa.';
$string['privacy:metadata:auth_oauth2:userid'] = 'ID uporabniškega računa OAuth 2, s katerim so povezane prijave v OAuth 2.';
$string['privacy:metadata:auth_oauth2:usermodified'] = 'ID uporabnika, ki je spreminjal ta račun.';
$string['privacy:metadata:auth_oauth2:username'] = 'Zunanje uporabniško ime je povezano s tem računom.';
